/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.combat.moves;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.body.tags.BodyPartTag;
import com.lilithsthrone.game.character.body.types.ArmType;
import com.lilithsthrone.game.character.body.types.FaceType;
import com.lilithsthrone.game.character.body.types.FootType;
import com.lilithsthrone.game.character.body.types.HornType;
import com.lilithsthrone.game.character.body.valueEnums.LegConfiguration;
import com.lilithsthrone.game.character.body.valueEnums.PenetrationGirth;
import com.lilithsthrone.game.character.effects.AbstractStatusEffect;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.combat.Attack;
import com.lilithsthrone.game.combat.DamageType;
import com.lilithsthrone.game.combat.DamageVariance;
import com.lilithsthrone.game.combat.moves.AbstractCombatMove;
import com.lilithsthrone.game.combat.moves.CombatMoveCategory;
import com.lilithsthrone.game.combat.moves.CombatMoveType;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.PresetColour;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CMSpecialAttack {
    public static AbstractCombatMove HORSE_KICK = new AbstractCombatMove(CombatMoveCategory.SPECIAL, "\u8e44\u8e22", 1, 2, 1, CombatMoveType.ATTACK, DamageType.UNARMED, DamageVariance.NONE, "moves/hoof_kick", Util.newArrayListOfValues(PresetColour.DAMAGE_TYPE_PHYSICAL, PresetColour.BASE_RED), false, true, false, (Map)Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.DAZED, 1)), (Map)Util.newHashMapOfValues(new Util.Value[0])){

        @Override
        public DamageType getDamageType(int turnIndex, GameCharacter source) {
            return DamageType.UNARMED.getParentDamageType(source, null);
        }

        @Override
        public int getBaseDamage(GameCharacter source) {
            return (int)Math.max(1.0f, (float)(source.getUnarmedDamage() * 2) * (source.isLegMovementHindered() ? 0.1f : 1.0f));
        }

        @Override
        protected int getDamage(int turnIndex, GameCharacter source, GameCharacter target, boolean isCrit) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return Attack.calculateSpecialAttackDamage(source, target, this.getType(), damageType, this.getBaseDamage(source), this.getDamageVariance(), false);
        }

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, String>(source.getLegType().getFootType().equals(FootType.HOOFS), "\u4ec5\u9002\u7528\u4e8e\u62e5\u6709\u8e44\u5b50\u7684\u89d2\u8272\u3002");
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, target, "\u5bf9" + (target == null ? "[npc.her]\u7684\u76ee\u6807" : "[npc2.name]") + "\u53d1\u51fa\u4e00\u51fb\u6709\u529b\u7684\u8e44\u8e22\uff0c\u9020\u6210" + 1.getFormattedDamage(damageType, this.getDamage(turnIndex, source, target, false), target, false, this.isTargetAtMaximumLust(target)) + "\u4f24\u5bb3\u3002" + (source.isLegMovementHindered() ? "[style.italicsMinorBad(\u7531\u4e8e\u8863\u7269\u963b\u788d\u4e86\u817f\u90e8\u8fd0\u52a8\uff0c\u9020\u6210\u7684\u4f24\u5bb3\u964d\u4f4e\u4e3a\u539f\u6765\u768410%\uff01)]" : ""), new ParserTag[0]);
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, "[npc.Name]\u4f7f\u7528\u5176\u5f3a\u5065\u7684\u817f\u90e8\u5411\u76ee\u6807\u53d1\u51fa\u4e00\u8bb0\u6709\u529b\u7684\u8e22\u51fb\uff0c\u9020\u6210" + 1.getFormattedDamage(damageType, this.getBaseDamage(source), null, false, false) + "\u57fa\u7840\u4f24\u5bb3\u3002[style.italicsMinorBad(\u5982\u679c\u8863\u7269\u963b\u788d\u4e86\u817f\u90e8\u8fd0\u52a8\uff0c\u9020\u6210\u7684\u4f24\u5bb3\u5c06\u4f1a\u964d\u4f4e\u4e3a\u539f\u6765\u768410%\u3002)]", new ParserTag[0]);
        }

        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            boolean maxLust = this.isTargetAtMaximumLust(target);
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            Util.Value<String, Integer> damageValue = damageType.damageTarget(source, target, this.getDamage(turnIndex, source, target, isCrit));
            Util.Value<String, Integer> critDamageValue = new Util.Value<String, Integer>("", 0);
            if (isCrit) {
                critDamageValue = damageType.damageTarget(source, target, this.getDamage(turnIndex, source, target, isCrit) / 2);
            }
            return 1.formatAttackOutcome(source, target, (source.isLegMovementHindered() ? "\u7531\u4e8e\u8863\u7269\u963b\u788d\u4e86\u817f\u90e8\u8fd0\u52a8\uff0c[npc.name]\u96be\u4ee5\u7528\u529b\uff0c\u53ea\u80fd\u5bf9[npc2.name]\u9020\u6210\u6781\u5c0f\u7684\u4f24\u5bb3\u2026\u2026" : "[npc.Name]\u4fa7\u8fc7\u8eab\u53bb\uff0c\u63a5\u7740\u5c31\u7528\u8e44\u5b50\u671d[npc2.name]\u53d1\u51fa\u4e86\u4e00\u8bb0\u6709\u529b\u7684\u8e22\u51fb\uff01") + damageValue.getKey(), "[npc2.Name]\u53d7\u5230\u4e86" + 1.getFormattedDamage(damageType, damageValue.getValue(), target, true, maxLust) + "\u4f24\u5bb3\uff01", isCrit ? "[npc.Name]\u53c8\u8fc5\u901f\u63a5\u4e0a\u4e00\u4e0b\uff0c\u8bd5\u56fe\u7a81\u7834[npc2.namePos]\u7684\u683c\u6321\uff01" + critDamageValue.getKey() : null, "[npc2.Name]\u53d7\u5230\u4e86\u989d\u5916" + 1.getFormattedDamage(damageType, critDamageValue.getValue(), target, true, maxLust) + "\u4f24\u5bb3\uff01");
        }

        @Override
        public List<String> getCritRequirements(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return Util.newArrayListOfValues("\u8e44\u8e22\u672a\u80fd\u7a81\u7834" + (target != null ? UtilText.parse(target, "[npc.namePos]", new ParserTag[0]) : "\u76ee\u6807") + "\u7684\u62a4\u76fe\u3002");
        }

        @Override
        public boolean canCrit(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            int damage = this.getDamage(turnIndex, source, target, false);
            int potentialDamage = this.getDamageType(turnIndex, source).shieldCheckNoDamage(source, target, damage);
            return potentialDamage <= 0;
        }
    };
    public static AbstractCombatMove CAT_SCRATCH = new AbstractCombatMove(CombatMoveCategory.SPECIAL, "\u6293\u6320", 1, 1, CombatMoveType.ATTACK, DamageType.UNARMED, "moves/scratch", false, true, false, (Map)Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.VULNERABLE, 2))){

        @Override
        public DamageType getDamageType(int turnIndex, GameCharacter source) {
            return DamageType.UNARMED.getParentDamageType(source, null);
        }

        @Override
        public int getBaseDamage(GameCharacter source) {
            return (int)Math.max(1.0f, (float)source.getUnarmedDamage() * 1.5f * (source.isArmMovementHindered() ? 0.5f : 1.0f));
        }

        @Override
        protected int getDamage(int turnIndex, GameCharacter source, GameCharacter target, boolean isCrit) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return Attack.calculateSpecialAttackDamage(source, target, this.getType(), damageType, this.getBaseDamage(source), this.getDamageVariance(), isCrit);
        }

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, String>(source.getArmType().equals(ArmType.CAT_MORPH), "\u4ec5\u9002\u7528\u4e8e\u62e5\u6709\u732b\u7c7b\u722a\u5b50\u7684\u89d2\u8272\u3002");
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, target, "\u5bf9" + (target == null ? "[npc.her]\u7684\u76ee\u6807" : "[npc2.name]") + "\u53d1\u51fa\u4e00\u8bb0\u51f6\u6b8b\u7684\u6293\u6320\uff0c\u9020\u6210" + 2.getFormattedDamage(damageType, this.getDamage(turnIndex, source, target, isCrit), target, false, this.isTargetAtMaximumLust(target)) + "\u4f24\u5bb3\u3002" + (source.isArmMovementHindered() ? "[style.italicsMinorBad(\u7531\u4e8e\u8863\u7269\u963b\u788d\u4e86\u624b\u81c2\u8fd0\u52a8\uff0c\u9020\u6210\u7684\u4f24\u5bb3\u964d\u4f4e\u4e3a\u539f\u6765\u768450%\uff01)]" : ""), new ParserTag[0]);
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, "[npc.Name]\u7528\u732b\u79d1\u7684\u722a\u5b50\u5411\u76ee\u6807\u53d1\u51fa\u4e00\u8bb0\u51f6\u6b8b\u7684\u722a\u51fb\uff0c\u9020\u6210" + 2.getFormattedDamage(damageType, this.getBaseDamage(source), null, false, false) + "\u57fa\u7840\u4f24\u5bb3\u3002[style.italicsMinorBad(\u5982\u679c\u8863\u7269\u963b\u788d\u4e86\u624b\u81c2\u8fd0\u52a8\uff0c\u9020\u6210\u7684\u4f24\u5bb3\u5c06\u4f1a\u964d\u4f4e\u4e3a\u539f\u6765\u768450%\u3002)]", new ParserTag[0]);
        }

        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            boolean maxLust = this.isTargetAtMaximumLust(target);
            Util.Value<String, Integer> damageValue = damageType.damageTarget(source, target, this.getDamage(turnIndex, source, target, isCrit));
            return 2.formatAttackOutcome(source, target, (source.isArmMovementHindered() ? "\u7531\u4e8e\u8863\u7269\u963b\u788d\u4e86\u624b\u81c2\u8fd0\u52a8\uff0c[npc.name]\u96be\u4ee5\u7528\u529b\uff0c\u53ea\u80fd\u5bf9[npc2.name]\u9020\u6210\u4e00\u534a\u7684\u4f24\u5bb3\u2026\u2026" : "[npc.Name]\u5c06\u722a\u5b50\u4ece[npc.her]\u732b\u822c\u7684\u4eba\u5f62\u624b\u4e0a\u4f38\u7f29\u51fa\u6765\uff0c\u8fc5\u901f\u51b2\u5411\u524d\u53bb\uff0c\u8bd5\u56fe\u5411[npc2.name]\u6293\u53bb\uff01") + damageValue.getKey(), "[npc2.Name]\u53d7\u5230\u4e86" + 2.getFormattedDamage(damageType, damageValue.getValue(), target, true, maxLust) + "\u4f24\u5bb3\uff01", isCrit ? "[npc.NamePos]\u7684\u722a\u51fb\u683c\u5916\u6709\u6548\uff01" : null, "\u201c" + StatusEffect.VULNERABLE.getName(target) + "\u201d\u7684\u6301\u7eed\u65f6\u95f4\u7ffb\u500d\u4e86\uff01");
        }

        @Override
        public float getCritStatusEffectDurationMultiplier() {
            return 2.0f;
        }

        @Override
        public List<String> getCritRequirements(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return Util.newArrayListOfValues((target != null ? UtilText.parse(target, "[npc.NameHasFull]", new ParserTag[0]) : "\u9632\u5b88\u8005\u5269\u4f59") + "\u6ca1\u6709" + this.getDamageType(0, source).getNameColoured() + "\u62a4\u76fe\u3002");
        }

        @Override
        public boolean canCrit(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return target.getShields(this.getDamageType(turnIndex, source)) <= 0;
        }
    };
    public static AbstractCombatMove TAIL_SWIPE = new AbstractCombatMove(CombatMoveCategory.SPECIAL, "\u626b\u5c3e", 2, 3, CombatMoveType.ATTACK, DamageType.UNARMED, "moves/tail_swipe", false, true, false, (Map)Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.DAZED, 2))){

        @Override
        public DamageType getDamageType(int turnIndex, GameCharacter source) {
            return DamageType.UNARMED.getParentDamageType(source, null);
        }

        @Override
        public int getBaseDamage(GameCharacter source) {
            return source.getUnarmedDamage() * 3;
        }

        @Override
        protected int getDamage(int turnIndex, GameCharacter source, GameCharacter target, boolean isCrit) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return Attack.calculateSpecialAttackDamage(source, target, this.getType(), damageType, this.getBaseDamage(source), this.getDamageVariance(), isCrit);
        }

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, CallSite>(source.getTailType().isSuitableForAttack() && source.getTailLength(false) >= 100 || source.getLegConfiguration() == LegConfiguration.TAIL_LONG, (CallSite)((Object)("\u4ec5\u9002\u7528\u4e8e\u62e5\u6709\u8db3\u591f\u5927\u5c0f\u5c3e\u5df4(\u957f\u5ea6\u81f3\u5c11[units.sizeShort(100)])\u6216\u62e5\u6709\u201c" + LegConfiguration.TAIL_LONG.getName() + "\u201d\u4e0b\u534a\u8eab\u7684\u89d2\u8272\u3002")));
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, target, "\u5bf9" + (target == null ? "[npc.her] target" : "[npc2.name]") + "\u6325\u51fa\u4e00\u8bb0\u96f7\u9706\u4e07\u94a7\u7684\u626b\u5c3e\uff0c\u9020\u6210" + 3.getFormattedDamage(damageType, this.getDamage(turnIndex, source, target, isCrit), target, false, this.isTargetAtMaximumLust(target)) + "\u4f24\u5bb3\u3002", new ParserTag[0]);
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, "[npc.Name]\u4f7f\u7528[npc.tailRace]\u5c3e\u5df4\u5411\u76ee\u6807\u4f7f\u51fa\u4e00\u8bb0\u96f7\u9706\u4e07\u94a7\u7684\u626b\u5c3e\uff0c\u9020\u6210" + 3.getFormattedDamage(damageType, this.getBaseDamage(source), null, false, false) + "\u57fa\u7840\u4f24\u5bb3\u3002", new ParserTag[0]);
        }

        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            boolean maxLust = this.isTargetAtMaximumLust(target);
            Util.Value<String, Integer> damageValue = damageType.damageTarget(source, target, this.getDamage(turnIndex, source, target, isCrit));
            return 3.formatAttackOutcome(source, target, "[npc.Name]\u4fa7\u8fc7\u8eab\u53bb\uff0c\u63a5\u529b\u626b\u51fa\u4e86[npc.her]\u5de8\u5927\u7684[npc.tailRace]\u5c3e\u5df4\uff0c\u76f4\u76f4\u5411\u7740[npc2.name]\u800c\u53bb\uff01" + damageValue.getKey(), "[npc2.Name]\u53d7\u5230\u4e86" + 3.getFormattedDamage(damageType, damageValue.getValue(), target, true, maxLust) + "\u4f24\u5bb3\uff01", isCrit ? "[npc.NamePos]\u7684\u626b\u5c3e\u683c\u5916\u6709\u6548\uff01" : null, "\u201c" + StatusEffect.DAZED.getName(target) + "\u201d\u7684\u6301\u7eed\u65f6\u95f4\u7ffb\u500d\u4e86\uff01");
        }

        @Override
        public float getCritStatusEffectDurationMultiplier() {
            return 2.0f;
        }

        @Override
        public List<String> getCritRequirements(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return Util.newArrayListOfValues((source != null ? UtilText.parse(source, "[npc.NamePos]", new ParserTag[0]) : "\u653b\u51fb\u8005") + "\u7684\u5c3e\u5df4\u81f3\u5c11\u9700\u8981\u8fbe\u5230\u201c<span style='color:" + PenetrationGirth.FIVE_THICK.getColour().toWebHexString() + ";'>" + PenetrationGirth.FIVE_THICK.getName() + "</span>\u201d\u3002");
        }

        @Override
        public boolean canCrit(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return source.getTailGirth().getValue() >= PenetrationGirth.FIVE_THICK.getValue();
        }
    };
    public static AbstractCombatMove SQUIRREL_SCRATCH = new AbstractCombatMove(CombatMoveCategory.SPECIAL, "\u677e\u9f20\u6293\u6320", 1, 1, CombatMoveType.ATTACK, DamageType.UNARMED, "moves/scratch_double", false, true, false, (Map)Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.VULNERABLE, 1))){

        @Override
        public DamageType getDamageType(int turnIndex, GameCharacter source) {
            return DamageType.UNARMED.getParentDamageType(source, null);
        }

        @Override
        public int getBaseDamage(GameCharacter source) {
            return (int)Math.max(1.0f, (float)source.getUnarmedDamage() * (source.isArmMovementHindered() ? 0.5f : 1.0f));
        }

        @Override
        protected int getDamage(int turnIndex, GameCharacter source, GameCharacter target, boolean isCrit) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return Attack.calculateSpecialAttackDamage(source, target, this.getType(), damageType, this.getBaseDamage(source), this.getDamageVariance(), isCrit);
        }

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, String>(source.getArmType().equals(ArmType.SQUIRREL_MORPH), "\u4ec5\u9002\u7528\u4e8e\u62e5\u6709\u677e\u9f20\u722a\u5b50\u7684\u89d2\u8272\u3002");
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, target, "\u5bf9" + (target == null ? "[npc.her]\u7684\u76ee\u6807" : "[npc2.name]") + "\u53d1\u51fa\u4e00\u8bb0\u51f6\u6b8b\u7684\u6293\u6320\uff0c\u9020\u6210" + 4.getFormattedDamage(damageType, this.getDamage(turnIndex, source, target, false), target, false, this.isTargetAtMaximumLust(target)) + "\u4f24\u5bb3\u3002" + (source.isArmMovementHindered() ? "[style.italicsMinorBad(\u7531\u4e8e\u8863\u7269\u963b\u788d\u4e86\u624b\u81c2\u8fd0\u52a8\uff0c\u9020\u6210\u7684\u4f24\u5bb3\u964d\u4f4e\u4e3a\u539f\u6765\u768450%\uff01)]" : ""), new ParserTag[0]);
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, "[npc.Name]\u7528\u950b\u5229\u7684\u722a\u5b50\u5411\u76ee\u6807\u53d1\u51fa\u4e00\u8bb0\u51f6\u6b8b\u7684\u722a\u51fb\uff0c\u9020\u6210" + 4.getFormattedDamage(damageType, this.getBaseDamage(source), null, false, false) + "\u57fa\u7840\u4f24\u5bb3\u3002[style.italicsMinorBad(\u5982\u679c\u8863\u7269\u963b\u788d\u4e86\u624b\u81c2\u8fd0\u52a8\uff0c\u9020\u6210\u7684\u4f24\u5bb3\u5c06\u4f1a\u964d\u4f4e\u4e3a\u539f\u6765\u768450%\u3002)]", new ParserTag[0]);
        }

        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            boolean maxLust = this.isTargetAtMaximumLust(target);
            Util.Value<String, Integer> damageValue = damageType.damageTarget(source, target, this.getDamage(turnIndex, source, target, isCrit));
            int dealtCritDamage2 = 0;
            int dealtCritDamage3 = 0;
            if (isCrit) {
                dealtCritDamage2 = damageType.damageTarget(source, target, this.getDamage(turnIndex, source, target, false)).getValue() / 2;
                dealtCritDamage3 = damageType.damageTarget(source, target, this.getDamage(turnIndex, source, target, false)).getValue() / 2;
            }
            return 4.formatAttackOutcome(source, target, (source.isArmMovementHindered() ? "\u7531\u4e8e\u8863\u7269\u963b\u788d\u4e86\u624b\u81c2\u8fd0\u52a8\uff0c[npc.name]\u96be\u4ee5\u7528\u529b\uff0c\u53ea\u80fd\u5bf9[npc2.name]\u9020\u6210\u4e00\u534a\u7684\u4f24\u5bb3\u2026\u2026" : "[npc.Name]\u5c06\u722a\u5b50\u4ece[npc.her]\u677e\u9f20\u822c\u7684\u4eba\u5f62\u624b\u4e0a\u4f38\u7f29\u51fa\u6765\uff0c\u8fc5\u901f\u51b2\u5411\u524d\u53bb\uff0c\u8bd5\u56fe\u5411[npc2.name]\u6293\u53bb\uff01") + damageValue.getKey(), "[npc2.Name]\u53d7\u5230\u4e86" + 4.getFormattedDamage(damageType, damageValue.getValue(), target, true, maxLust) + "\u4f24\u5bb3\uff01", isCrit ? "[npc.Name]\u53c8\u8fc5\u901f\u671d[npc2.name]\u6293\u4e86\u4e24\u4e0b\uff01" : null, "[npc2.Name]\u53d7\u5230\u4e86\u989d\u5916" + 4.getFormattedDamage(damageType, dealtCritDamage2, target, true, maxLust) + "\u4ee5\u53ca" + 4.getFormattedDamage(damageType, dealtCritDamage3, target, true, maxLust) + "\u4f24\u5bb3\uff01");
        }

        @Override
        public List<String> getCritRequirements(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return Util.newArrayListOfValues((target != null ? UtilText.parse(target, "[npc.NameHasFull]", new ParserTag[0]) : "\u9632\u5b88\u8005\u5269\u4f59") + "\u6ca1\u6709" + this.getDamageType(0, source).getNameColoured() + "\u62a4\u76fe\u3002");
        }

        @Override
        public boolean canCrit(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return target.getShields(this.getDamageType(turnIndex, source)) <= 0;
        }
    };
    public static AbstractCombatMove WOLF_SAVAGE = new AbstractCombatMove(CombatMoveCategory.SPECIAL, "\u72c2\u91ce\u4e00\u51fb", 6, 3, CombatMoveType.ATTACK, DamageType.UNARMED, "moves/savage_attack", false, true, false, (Map)Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.CRIPPLE, 3))){

        @Override
        public DamageType getDamageType(int turnIndex, GameCharacter source) {
            return DamageType.UNARMED.getParentDamageType(source, null);
        }

        @Override
        public int getBaseDamage(GameCharacter source) {
            return (int)Math.max(1.0f, (float)(source.getUnarmedDamage() * 4) * (source.isArmMovementHindered() ? 0.5f : 1.0f));
        }

        @Override
        protected int getDamage(int turnIndex, GameCharacter source, GameCharacter target, boolean isCrit) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return Attack.calculateSpecialAttackDamage(source, target, this.getType(), damageType, this.getBaseDamage(source), this.getDamageVariance(), isCrit);
        }

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, String>(source.getArmType().getRace().equals(Race.WOLF_MORPH), "\u4ec5\u9002\u7528\u4e8e\u62e5\u6709\u72fc\u5316\u5f62\u624b\u81c2\u7684\u89d2\u8272\u3002");
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, target, "\u5bf9" + (target == null ? "[npc.her]\u7684\u76ee\u6807" : "[npc2.name]") + "\u53d1\u51fa\u4e00\u8fde\u4e32\u72c2\u91ce\u7684\u722a\u51fb\uff0c\u9020\u6210" + 5.getFormattedDamage(damageType, this.getDamage(turnIndex, source, target, isCrit), target, false, this.isTargetAtMaximumLust(target)) + "\u4f24\u5bb3\u3002" + (source.isArmMovementHindered() ? "[style.italicsMinorBad(\u7531\u4e8e\u8863\u7269\u963b\u788d\u4e86\u624b\u81c2\u8fd0\u52a8\uff0c\u9020\u6210\u7684\u4f24\u5bb3\u964d\u4f4e\u4e3a\u539f\u6765\u768450%\uff01)]" : ""), new ParserTag[0]);
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, "[npc.Name]\u7528\u950b\u5229\u7684\u722a\u5b50\u5411\u76ee\u6807\u53d1\u51fa\u4e00\u8fde\u4e32\u72c2\u91ce\u7684\u722a\u51fb\uff0c\u9020\u6210" + 5.getFormattedDamage(damageType, this.getBaseDamage(source), null, false, false) + "\u57fa\u7840\u4f24\u5bb3\u3002[style.italicsMinorBad(\u5982\u679c\u8863\u7269\u963b\u788d\u4e86\u624b\u81c2\u8fd0\u52a8\uff0c\u9020\u6210\u7684\u4f24\u5bb3\u5c06\u4f1a\u964d\u4f4e\u4e3a\u539f\u6765\u768450%\u3002)]", new ParserTag[0]);
        }

        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            boolean maxLust = this.isTargetAtMaximumLust(target);
            Util.Value<String, Integer> damageValue = damageType.damageTarget(source, target, this.getDamage(turnIndex, source, target, isCrit));
            return 5.formatAttackOutcome(source, target, (source.isArmMovementHindered() ? "\u7531\u4e8e\u8863\u7269\u963b\u788d\u4e86\u624b\u81c2\u8fd0\u52a8\uff0c[npc.name]\u96be\u4ee5\u7528\u529b\uff0c\u53ea\u80fd\u5bf9[npc2.name]\u9020\u6210\u4e00\u534a\u7684\u4f24\u5bb3\u2026\u2026" : "[npc.Name]\u957f\u568e\u4e00\u58f0\u540e\u4fbf\u5411[npc2.name]\u51b2\u53bb\uff0c\u950b\u5229\u7684\u722a\u5b50\u63a0\u8fc7[npc2.her]\u7684\u8eab\u4f53\uff0c\u9020\u6210\u4e86\u4e25\u91cd\u7684\u4f24\u5bb3\u3002") + damageValue.getKey(), "[npc2.Name]\u53d7\u5230\u4e86" + 5.getFormattedDamage(damageType, damageValue.getValue(), target, true, maxLust) + "\u4f24\u5bb3\uff01", isCrit ? "[npc.namePos]\u51f6\u72e0\u7684\u653b\u51fb\u8ba9[npc2.name]\u731d\u4e0d\u53ca\u9632\uff01" : null, "\u201c" + StatusEffect.CRIPPLE.getName(target) + "\u201d\u7684\u6301\u7eed\u65f6\u95f4\u7ffb\u500d\u4e86\uff01");
        }

        @Override
        public float getCritStatusEffectDurationMultiplier() {
            return 2.0f;
        }

        @Override
        public List<String> getCritRequirements(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return Util.newArrayListOfValues("\u5728\u6218\u6597\u7684\u7b2c\u4e00\u56de\u5408\u4f7f\u7528\u3002");
        }

        @Override
        public boolean canCrit(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return Main.combat.getTurn() == 0;
        }
    };
    public static AbstractCombatMove ANTLER_HEADBUTT = new AbstractCombatMove(CombatMoveCategory.SPECIAL, "\u9e7f\u89d2\u5934\u69cc", 1, 2, CombatMoveType.ATTACK, DamageType.UNARMED, "moves/antlers", false, true, false, (Map)Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.DAZED, 2))){

        @Override
        public DamageType getDamageType(int turnIndex, GameCharacter source) {
            return DamageType.UNARMED.getParentDamageType(source, null);
        }

        @Override
        public int getBaseDamage(GameCharacter source) {
            return source.getUnarmedDamage() * 2;
        }

        @Override
        protected int getDamage(int turnIndex, GameCharacter source, GameCharacter target, boolean isCrit) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return Attack.calculateSpecialAttackDamage(source, target, this.getType(), damageType, this.getBaseDamage(source), this.getDamageVariance(), isCrit);
        }

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, String>(source.getHornType().equals(HornType.REINDEER_RACK), "\u4ec5\u9002\u7528\u4e8e\u62e5\u6709\u591a\u53c9\u9e7f\u89d2\u7684\u89d2\u8272\u3002");
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, target, "\u5bf9" + (target == null ? "[npc.her]\u7684\u76ee\u6807" : "[npc2.name]") + "\u4f7f\u51fa\u4e00\u8bb0\u5927\u529b\u5934\u69cc\uff0c\u9020\u6210" + 6.getFormattedDamage(damageType, this.getDamage(turnIndex, source, target, isCrit), target, false, this.isTargetAtMaximumLust(target)) + "\u4f24\u5bb3\u3002", new ParserTag[0]);
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, "[npc.Name]\u7528\u9e7f\u89d2\u5411\u76ee\u6807\u53d1\u51fa\u4e00\u8bb0\u5927\u529b\u5934\u69cc\uff0c\u9020\u6210" + 6.getFormattedDamage(damageType, this.getBaseDamage(source), null, false, false) + "\u57fa\u7840\u4f24\u5bb3\u3002", new ParserTag[0]);
        }

        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            boolean maxLust = this.isTargetAtMaximumLust(target);
            Util.Value<String, Integer> damageValue = damageType.damageTarget(source, target, this.getDamage(turnIndex, source, target, isCrit));
            return 6.formatAttackOutcome(source, target, "[npc.Name]\u5e26\u7740\u5de8\u5927\u7684\u529b\u91cf\u7eb5\u8eab\u4e00\u8dc3\uff0c\u7528\u524d\u989d\u5411\u7740[npc2.namePos]\u7684\u8eab\u4f53\u7838\u53bb\uff0c\u9e7f\u89d2\u72e0\u72e0\u5730\u91cd\u51fb\u4e86[npc2.herHim]\u3002" + damageValue.getKey(), "[npc2.Name]\u53d7\u5230\u4e86" + 6.getFormattedDamage(damageType, damageValue.getValue(), target, true, maxLust) + "\u4f24\u5bb3\uff01", isCrit ? "[npc.NamePos]\u7684\u5934\u69cc\u683c\u5916\u6709\u6548\uff01" : null, "\u201c" + StatusEffect.DAZED.getName(target) + "\u201d\u7684\u6301\u7eed\u65f6\u95f4\u7ffb\u500d\u4e86\uff01");
        }

        @Override
        public float getCritStatusEffectDurationMultiplier() {
            return 2.0f;
        }

        @Override
        public List<String> getCritRequirements(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return Util.newArrayListOfValues((source != null ? UtilText.parse(source, "[npc.NameIsFull]", new ParserTag[0]) : "\u653b\u51fb\u8005") + "\u9700\u8981\u6bd4" + (target != null ? UtilText.parse(target, "[npc.name]", new ParserTag[0]) : "\u76ee\u6807") + "\u9ad8\u81f3\u5c1150%\u3002");
        }

        @Override
        public boolean canCrit(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return (float)source.getHeightValue() > (float)target.getHeightValue() * 1.5f;
        }
    };
    public static AbstractCombatMove COW_HEADBUTT = new AbstractCombatMove(CombatMoveCategory.SPECIAL, "\u89d2\u649e\u5934\u69cc", 1, 2, CombatMoveType.ATTACK, DamageType.UNARMED, "moves/horns", false, true, false, (Map)Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.DAZED, 2))){

        @Override
        public DamageType getDamageType(int turnIndex, GameCharacter source) {
            return DamageType.UNARMED.getParentDamageType(source, null);
        }

        @Override
        public int getBaseDamage(GameCharacter source) {
            return source.getUnarmedDamage() * 2;
        }

        @Override
        protected int getDamage(int turnIndex, GameCharacter source, GameCharacter target, boolean isCrit) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return Attack.calculateSpecialAttackDamage(source, target, this.getType(), damageType, this.getBaseDamage(source), this.getDamageVariance(), isCrit);
        }

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, String>(source.hasHorns() && !source.getHornType().equals(HornType.REINDEER_RACK), "\u4ec5\u9002\u7528\u4e8e\u62e5\u6709\u89d2\u7684\u89d2\u8272\u3002");
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, target, "\u5bf9" + (target == null ? "[npc.her]\u7684\u76ee\u6807" : "[npc2.name]") + "\u4f7f\u51fa\u4e00\u8bb0\u5927\u529b\u5934\u69cc\uff0c\u9020\u6210" + 7.getFormattedDamage(damageType, this.getDamage(turnIndex, source, target, isCrit), target, false, this.isTargetAtMaximumLust(target)) + "\u4f24\u5bb3\u3002", new ParserTag[0]);
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, "[npc.Name]\u7528\u89d2\u5411\u76ee\u6807\u53d1\u51fa\u4e00\u8bb0\u5927\u529b\u5934\u69cc\uff0c\u9020\u6210" + 7.getFormattedDamage(damageType, this.getBaseDamage(source), null, false, false) + "\u57fa\u7840\u4f24\u5bb3\u3002", new ParserTag[0]);
        }

        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            boolean maxLust = this.isTargetAtMaximumLust(target);
            Util.Value<String, Integer> damageValue = damageType.damageTarget(source, target, this.getDamage(turnIndex, source, target, isCrit));
            return 7.formatAttackOutcome(source, target, "[npc.Name]\u5e26\u7740\u5de8\u5927\u7684\u529b\u91cf\u7eb5\u8eab\u4e00\u8dc3\uff0c\u7528\u524d\u989d\u5411\u7740[npc2.namePos]\u7684\u8eab\u4f53\u7838\u53bb\uff0c\u89d2\u72e0\u72e0\u5730\u91cd\u51fb\u4e86[npc2.herHim]\u3002" + damageValue.getKey(), "[npc2.Name]\u53d7\u5230\u4e86" + 7.getFormattedDamage(damageType, damageValue.getValue(), target, true, maxLust) + "\u4f24\u5bb3\uff01", isCrit ? "[npc.NamePos]\u7684\u5934\u69cc\u683c\u5916\u6709\u6548\uff01" : null, "\u201c" + StatusEffect.DAZED.getName(target) + "\u201d\u7684\u6301\u7eed\u65f6\u95f4\u7ffb\u500d\u4e86\uff01");
        }

        @Override
        public float getCritStatusEffectDurationMultiplier() {
            return 2.0f;
        }

        @Override
        public List<String> getCritRequirements(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return Util.newArrayListOfValues((source != null ? UtilText.parse(source, "[npc.NameIsFull]", new ParserTag[0]) : "\u653b\u51fb\u8005") + "\u9700\u8981\u6bd4" + (target != null ? UtilText.parse(target, "[npc.name]", new ParserTag[0]) : "\u76ee\u6807") + "\u9ad8\u81f3\u5c1150%\u3002");
        }

        @Override
        public boolean canCrit(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return (float)source.getHeightValue() > (float)target.getHeightValue() * 1.5f;
        }
    };
    public static AbstractCombatMove BITE = new AbstractCombatMove(CombatMoveCategory.SPECIAL, "\u517d\u6027\u6495\u54ac", 1, 2, CombatMoveType.ATTACK, DamageType.UNARMED, "moves/bite", false, true, false, (Map)Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.CRIPPLE, 2))){

        @Override
        public DamageType getDamageType(int turnIndex, GameCharacter source) {
            return DamageType.UNARMED.getParentDamageType(source, null);
        }

        @Override
        public Map<AbstractStatusEffect, Integer> getStatusEffects(GameCharacter caster, GameCharacter target, boolean isCritical) {
            LinkedHashMap<AbstractStatusEffect, Integer> effects = Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.CRIPPLE, 2));
            if (caster.getFaceType().getTags().contains((Object)BodyPartTag.FACE_VENOMOUS_TEETH)) {
                effects.put(StatusEffect.POISONED, 6);
            }
            if (caster.getFaceType().getTags().contains((Object)BodyPartTag.FACE_VENOMOUS_TEETH_LUST)) {
                effects.put(StatusEffect.POISONED_LUST, 6);
            }
            if (isCritical) {
                return effects;
            }
            return effects;
        }

        @Override
        public float getWeight(GameCharacter source, List<GameCharacter> enemies, List<GameCharacter> allies) {
            if (!source.isCoverableAreaExposed(CoverableArea.MOUTH)) {
                return 0.0f;
            }
            return super.getWeight(source, enemies, allies);
        }

        @Override
        public int getBaseDamage(GameCharacter source) {
            return source.getUnarmedDamage() * 2 * (!source.isCoverableAreaExposed(CoverableArea.MOUTH) ? 0 : 1);
        }

        @Override
        protected int getDamage(int turnIndex, GameCharacter source, GameCharacter target, boolean isCrit) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return Attack.calculateSpecialAttackDamage(source, target, this.getType(), damageType, this.getBaseDamage(source), this.getDamageVariance(), isCrit);
        }

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, String>(!Collections.disjoint(source.getFaceTypeTags(), Util.newArrayListOfValues(BodyPartTag.FACE_MUZZLE, BodyPartTag.FACE_FANGS, BodyPartTag.FACE_BEAK)), "\u4ec5\u9002\u7528\u4e8e\u62e5\u6709\u52a8\u7269\u62df\u4eba\u9762\u90e8\u7684\u89d2\u8272\u3002");
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, target, "\u5bf9" + (target == null ? "[npc.her]\u7684\u76ee\u6807" : "[npc2.name]") + "\u53d1\u51fa\u4e00\u8bb0\u517d\u6027\u7684\u6495\u54ac\uff0c\u9020\u6210" + 8.getFormattedDamage(damageType, this.getDamage(turnIndex, source, target, isCrit), target, false, this.isTargetAtMaximumLust(target)) + "\u4f24\u5bb3" + (source.getFaceType().getTags().contains((Object)BodyPartTag.FACE_VENOMOUS_TEETH) ? "\u5e76\u65bd\u52a06\u56de\u5408\u201c\u4e2d\u6bd2\u201d\u3002" : (source.getFaceType().getTags().contains((Object)BodyPartTag.FACE_VENOMOUS_TEETH_LUST) ? "\u5e76\u65bd\u52a06\u56de\u5408\u201c\u6b32\u6bd2\u201d\u3002" : "\u3002")) + (!source.isCoverableAreaExposed(CoverableArea.MOUTH) ? "[style.italicsBad(\u7531\u4e8e\u5634\u90e8\u88ab\u8863\u7269\u963b\u6321\uff0c\u4f24\u5bb3\u964d\u4f4e\u81f30%\uff01)]" : ""), new ParserTag[0]);
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, "[npc.Name]\u7528\u52a8\u7269\u62df\u4eba\u7684\u9762\u90e8\u5411\u76ee\u6807\u4f7f\u51fa\u4e00\u8bb0\u517d\u6027\u7684\u6495\u54ac\uff0c\u9020\u6210" + 8.getFormattedDamage(damageType, this.getBaseDamage(source), null, false, false) + "\u57fa\u7840\u4f24\u5bb3" + (source.getFaceType().getTags().contains((Object)BodyPartTag.FACE_VENOMOUS_TEETH) ? "\u5e76\u65bd\u52a06\u56de\u5408\u201c\u4e2d\u6bd2\u201d\u3002" : (source.getFaceType().getTags().contains((Object)BodyPartTag.FACE_VENOMOUS_TEETH_LUST) ? "\u5e76\u65bd\u52a06\u56de\u5408\u201c\u6b32\u6bd2\u201d\u3002" : "\u3002")) + "[style.italicsBad(\u7531\u4e8e\u5634\u90e8\u88ab\u8863\u7269\u963b\u6321\uff0c\u4f24\u5bb3\u964d\u4f4e\u81f30%\uff01)]", new ParserTag[0]);
        }

        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            boolean maxLust = this.isTargetAtMaximumLust(target);
            Util.Value<String, Integer> damageValue = damageType.damageTarget(source, target, this.getDamage(turnIndex, source, target, isCrit));
            return 8.formatAttackOutcome(source, target, (String)(!source.isCoverableAreaExposed(CoverableArea.MOUTH) ? "\u7531\u4e8e\u5634\u90e8\u88ab\u8863\u7269\u963b\u6321\uff0c[npc.nameIsFull]\u65e0\u6cd5\u4f7f\u7528\u517d\u6027\u6495\u54ac\u9020\u6210\u4f24\u5bb3\u2026\u2026" : "[npc.Name]\u5e26\u7740\u5de8\u5927\u7684\u529b\u91cf\u7eb5\u8eab\u4e00\u8dc3\uff0c\u8bd5\u56fe\u54ac\u4f4f[npc2.name]\uff01\u6700\u7ec8\u843d\u5728\u4e86[npc2.her]\u7684[npc2.arm]\u4e0a\uff0c\u5728\u5bf9\u65b9\u6323\u8131\u524d\uff0c\u7528" + (source.getFaceType() == FaceType.HARPY ? "\u9510\u5229\u7684\u5599" : "\u91ce\u517d\u822c\u7684\u5229\u9f7f") + "\u9020\u6210\u4e86\u4e25\u91cd\u7684\u4f24\u5bb3\u3002" + (source.getFaceType().getTags().contains((Object)BodyPartTag.FACE_VENOMOUS_TEETH) ? "\u88ab[npc.namePos]\u6bd2\u6027\u7684\u5c16\u7259\u54ac\u4f4f\u540e\uff0c[npc2.namehasFull]\u7684\u4f53\u5185\u88ab\u6ce8\u5165\u4e86\u6bd2\u6db2\uff01" : (source.getFaceType().getTags().contains((Object)BodyPartTag.FACE_VENOMOUS_TEETH_LUST) ? "\u88ab[npc.namePos]\u6bd2\u6027\u7684\u5c16\u7259\u54ac\u4f4f\u540e\uff0c[npc2.namehasFull]\u7684\u4f53\u5185\u88ab\u6ce8\u5165\u4e86\u6b32\u6bd2\u6bd2\u6db2\uff01" : ""))) + damageValue.getKey(), "[npc2.Name]\u53d7\u5230\u4e86" + 8.getFormattedDamage(damageType, damageValue.getValue(), target, true, maxLust) + "\u4f24\u5bb3\uff01", isCrit ? "[npc.NamePos]\u7684\u517d\u6027\u6495\u54ac\u683c\u5916\u6709\u6548\uff01" : null, "\u201c" + StatusEffect.CRIPPLE.getName(target) + "\u201d\u7684\u6301\u7eed\u65f6\u95f4\u7ffb\u500d\u4e86\uff01");
        }

        @Override
        public float getCritStatusEffectDurationMultiplier() {
            return 2.0f;
        }

        @Override
        public List<String> getCritRequirements(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return Util.newArrayListOfValues((target != null ? UtilText.parse(target, "[npc.NameHasFull]", new ParserTag[0]) : "\u9632\u5b88\u8005\u8fd8\u5269") + "\u4e0d\u523025%" + Attribute.HEALTH_MAXIMUM.getColouredName("span") + "\u3002");
        }

        @Override
        public boolean canCrit(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return target.getHealthPercentage() < 0.25f;
        }
    };
    public static AbstractCombatMove TALON_SLASH = new AbstractCombatMove(CombatMoveCategory.SPECIAL, "\u9e1f\u722a\u6325\u51fb", 1, 1, 10, CombatMoveType.ATTACK, DamageType.PHYSICAL, DamageVariance.HIGH, "moves/talon_slash", Util.newArrayListOfValues(PresetColour.RACE_HARPY), false, true, false, (Map)Util.newHashMapOfValues(new Util.Value[0]), (Map)Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(StatusEffect.VULNERABLE, 2))){

        @Override
        public DamageType getDamageType(int turnIndex, GameCharacter source) {
            return DamageType.UNARMED.getParentDamageType(source, null);
        }

        @Override
        public int getBaseDamage(GameCharacter source) {
            return (int)Math.max(1.0f, (float)source.getUnarmedDamage() * 1.2f * (source.isLegMovementHindered() ? 0.1f : 1.0f));
        }

        @Override
        protected int getDamage(int turnIndex, GameCharacter source, GameCharacter target, boolean isCrit) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return Attack.calculateSpecialAttackDamage(source, target, this.getType(), damageType, this.getBaseDamage(source), this.getDamageVariance(), false);
        }

        @Override
        public Util.Value<Boolean, String> isAvailableFromSpecialCase(GameCharacter source) {
            return new Util.Value<Boolean, String>(source.getLegType().getFootType().equals(FootType.TALONS), "\u4ec5\u9002\u7528\u4e8e\u62e5\u6709\u9e1f\u7c7b\u5229\u722a\u7684\u89d2\u8272\u3002");
        }

        @Override
        public String getPrediction(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, target, "\u7528\u9e1f\u7c7b\u7684\u5229\u722a\u5411" + (target == null ? "[npc.her]\u7684\u76ee\u6807i" : "[npc2.name]") + "\u53d1\u51fa\u4e00\u8bb0\u6709\u529b\u7684\u722a\u51fb\uff0c\u9020\u6210" + 9.getFormattedDamage(damageType, this.getDamage(turnIndex, source, target, false), target, false, this.isTargetAtMaximumLust(target)) + "\u4f24\u5bb3\u3002" + (source.isLegMovementHindered() ? "[style.italicsMinorBad(\u7531\u4e8e\u8863\u7269\u963b\u788d\u4e86\u817f\u90e8\u8fd0\u52a8\uff0c\u9020\u6210\u7684\u4f24\u5bb3\u964d\u4f4e\u4e3a\u539f\u6765\u768410%\uff01)]" : ""), new ParserTag[0]);
        }

        @Override
        public String getDescription(int turnIndex, GameCharacter source) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            return UtilText.parse(source, "[npc.Name]\u7528\u9510\u5229\u7684\u9e1f\u722a\u5411\u76ee\u6807\u53d1\u51fa\u4e00\u51fb\u6709\u529b\u7684\u722a\u51fb\uff0c\u9020\u6210" + 9.getFormattedDamage(damageType, this.getBaseDamage(source), null, false, false) + "\u57fa\u7840\u4f24\u5bb3\u3002[style.italicsMinorBad(\u5982\u679c\u8863\u7269\u963b\u788d\u4e86\u817f\u90e8\u8fd0\u52a8\uff0c\u9020\u6210\u7684\u4f24\u5bb3\u5c06\u4f1a\u964d\u4f4e\u4e3a\u539f\u6765\u768410%\u3002)]", new ParserTag[0]);
        }

        @Override
        public String perform(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            DamageType damageType = this.getDamageType(turnIndex, source);
            boolean maxLust = this.isTargetAtMaximumLust(target);
            boolean isCrit = this.canCrit(turnIndex, source, target, enemies, allies);
            Util.Value<String, Integer> damageValue = damageType.damageTarget(source, target, this.getDamage(turnIndex, source, target, isCrit));
            Util.Value<String, Integer> critDamageValue = new Util.Value<String, Integer>("", 0);
            if (isCrit) {
                critDamageValue = damageType.damageTarget(source, target, this.getDamage(turnIndex, source, target, isCrit) / 2);
            }
            return 9.formatAttackOutcome(source, target, (source.isLegMovementHindered() ? "\u7531\u4e8e\u8863\u7269\u963b\u788d\u4e86\u817f\u90e8\u8fd0\u52a8\uff0c[npc.name]\u96be\u4ee5\u5229\u7528\u5229\u722a\uff0c\u53ea\u80fd\u5bf9[npc2.name]\u9020\u6210\u6781\u5c0f\u7684\u4f24\u5bb3\u2026\u2026" : "[npc.Name]\u817e\u7a7a\u800c\u8d77\uff0c\u63a5\u7740\u4f38\u76f4\u5229\u722a\u8fc5\u901f\u964d\u843d\uff0c\u5411\u7740[npc2.name]\u53d1\u51fa\u4e86\u6709\u529b\u7684\u722a\u51fb\uff01") + damageValue.getKey(), "[npc2.Name]\u53d7\u5230\u4e86" + 9.getFormattedDamage(damageType, damageValue.getValue(), target, true, maxLust) + "\u4f24\u5bb3\uff01", isCrit ? "[npc.Name]\u53c8\u8fc5\u901f\u63a5\u4e0a\u4e00\u4e0b\uff0c\u8bd5\u56fe\u7a81\u7834[npc2.namePos]\u7684\u683c\u6321\uff01" + critDamageValue.getKey() : null, "[npc2.Name]\u53d7\u5230\u4e86\u989d\u5916" + 9.getFormattedDamage(damageType, critDamageValue.getValue(), target, true, maxLust) + "\u4f24\u5bb3\uff01");
        }

        @Override
        public List<String> getCritRequirements(GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            return Util.newArrayListOfValues("\u5229\u722a\u7684\u653b\u51fb\u7a81\u7834\u4e86" + (target != null ? UtilText.parse(target, "[npc.namePos]", new ParserTag[0]) : "\u76ee\u6807") + "\u7684\u62a4\u76fe\u3002");
        }

        @Override
        public boolean canCrit(int turnIndex, GameCharacter source, GameCharacter target, List<GameCharacter> enemies, List<GameCharacter> allies) {
            int damage = this.getDamage(turnIndex, source, target, false);
            int potentialDamage = this.getDamageType(turnIndex, source).shieldCheckNoDamage(source, target, damage);
            return potentialDamage > 0;
        }
    };
}

