/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.Game;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.dialogue.AbstractDialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.places.dominion.helenaHotel.HelenaConversationTopic;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJob;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.XMLSaving;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DialogueFlags
implements XMLSaving {
    private int muggerDemand1 = 250;
    private int muggerDemand2 = 500;
    private int muggerDemand3 = 750;
    private int prostituteFine = 10000;
    public Set<AbstractDialogueFlagValue> values;
    public int ralphDiscount = 0;
    public int scarlettPrice = 15000;
    public int eponaStamps = 0;
    public Map<String, Long> savedLongs = new HashMap<String, Long>();
    public int helenaSlaveOrderDay = -1;
    public int impCitadelImpWave = 0;
    public int offspringDialogueTokens = 2;
    private int murkPlayerTfStage = 0;
    private int murkCompanionTfStage = 0;
    private String slaveTrader = null;
    private String managementCompanion = null;
    private SlaveJob slaveryManagerJobSelected;
    private Colour natalyaCollarColour;
    private int natalyaPoints = 0;
    private String sadistNatalyaSlave = "";
    private Set<String> helenaConversationTopics = new HashSet<String>();
    private Set<String> reindeerEncounteredIDs = new HashSet<String>();
    private Set<String> reindeerWorkedForIDs = new HashSet<String>();
    private Set<String> reindeerFuckedIDs = new HashSet<String>();
    public Set<String> warehouseDefeatedIDs = new HashSet<String>();
    private Map<String, Boolean> tempBooleans;
    private Map<String, String> tempStrings;
    private Map<String, Integer> tempIntegers;

    public DialogueFlags() {
        this.values = new HashSet<AbstractDialogueFlagValue>();
        this.slaveryManagerJobSelected = SlaveJob.IDLE;
        this.natalyaCollarColour = PresetColour.CLOTHING_BRONZE;
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element element = doc.createElement("dialogueFlags");
        parentElement.appendChild(element);
        XMLUtil.createXMLElementWithValue(doc, element, "ralphDiscount", String.valueOf(this.ralphDiscount));
        XMLUtil.createXMLElementWithValue(doc, element, "scarlettPrice", String.valueOf(this.scarlettPrice));
        XMLUtil.createXMLElementWithValue(doc, element, "eponaStamps", String.valueOf(this.eponaStamps));
        XMLUtil.createXMLElementWithValue(doc, element, "helenaSlaveOrderDay", String.valueOf(this.helenaSlaveOrderDay));
        XMLUtil.createXMLElementWithValue(doc, element, "impCitadelImpWave", String.valueOf(this.impCitadelImpWave));
        XMLUtil.createXMLElementWithValue(doc, element, "murkPlayerTfStage", String.valueOf(this.murkPlayerTfStage));
        XMLUtil.createXMLElementWithValue(doc, element, "murkCompanionTfStage", String.valueOf(this.murkCompanionTfStage));
        XMLUtil.createXMLElementWithValue(doc, element, "offspringDialogueTokens", String.valueOf(this.offspringDialogueTokens));
        XMLUtil.createXMLElementWithValue(doc, element, "slaveTrader", this.slaveTrader);
        XMLUtil.createXMLElementWithValue(doc, element, "slaveryManagerSlaveSelected", this.managementCompanion);
        XMLUtil.createXMLElementWithValue(doc, element, "natalyaCollarColour", PresetColour.getIdFromColour(this.natalyaCollarColour));
        XMLUtil.createXMLElementWithValue(doc, element, "natalyaPoints", String.valueOf(this.natalyaPoints));
        XMLUtil.createXMLElementWithValue(doc, element, "sadistNatalyaSlave", this.sadistNatalyaSlave);
        Element savedLongsElement = doc.createElement("savedLongs");
        element.appendChild(savedLongsElement);
        for (Map.Entry<String, Long> savedLong : this.savedLongs.entrySet()) {
            Element save = doc.createElement("save");
            savedLongsElement.appendChild(save);
            save.setAttribute("id", savedLong.getKey());
            save.setTextContent(String.valueOf(savedLong.getValue()));
        }
        Element valuesElement = doc.createElement("dialogueValues");
        element.appendChild(valuesElement);
        for (AbstractDialogueFlagValue value : this.values) {
            XMLUtil.createXMLElementWithValue(doc, valuesElement, "dialogueValue", DialogueFlagValue.getIdFromDialogueFlagValue(value));
        }
        DialogueFlags.saveSet(element, doc, this.helenaConversationTopics, "helenaConversationTopics");
        DialogueFlags.saveSet(element, doc, this.reindeerEncounteredIDs, "reindeerEncounteredIDs");
        DialogueFlags.saveSet(element, doc, this.reindeerWorkedForIDs, "reindeerWorkedForIDs");
        DialogueFlags.saveSet(element, doc, this.reindeerFuckedIDs, "reindeerFuckedIDs");
        DialogueFlags.saveSet(element, doc, this.warehouseDefeatedIDs, "warehouseDefeatedIDs");
        return element;
    }

    /*
     * Unable to fully structure code
     */
    public static DialogueFlags loadFromXML(Element parentElement, Document doc) {
        newFlags = new DialogueFlags();
        newFlags.ralphDiscount = Integer.valueOf(((Element)parentElement.getElementsByTagName("ralphDiscount").item(0)).getAttribute("value"));
        newFlags.scarlettPrice = Integer.valueOf(((Element)parentElement.getElementsByTagName("scarlettPrice").item(0)).getAttribute("value"));
        newFlags.offspringDialogueTokens = Integer.valueOf(((Element)parentElement.getElementsByTagName("offspringDialogueTokens").item(0)).getAttribute("value"));
        newFlags.slaveTrader = ((Element)parentElement.getElementsByTagName("slaveTrader").item(0)).getAttribute("value");
        newFlags.managementCompanion = ((Element)parentElement.getElementsByTagName("slaveryManagerSlaveSelected").item(0)).getAttribute("value");
        try {
            newFlags.eponaStamps = Integer.valueOf(((Element)parentElement.getElementsByTagName("eponaStamps").item(0)).getAttribute("value"));
        }
        catch (Exception var3_3) {
            // empty catch block
        }
        try {
            newFlags.helenaSlaveOrderDay = Integer.valueOf(((Element)parentElement.getElementsByTagName("helenaSlaveOrderDay").item(0)).getAttribute("value"));
        }
        catch (Exception var3_4) {
            // empty catch block
        }
        try {
            newFlags.impCitadelImpWave = Integer.valueOf(((Element)parentElement.getElementsByTagName("impCitadelImpWave").item(0)).getAttribute("value"));
        }
        catch (Exception var3_6) {
            // empty catch block
        }
        try {
            newFlags.murkPlayerTfStage = Integer.valueOf(((Element)parentElement.getElementsByTagName("murkPlayerTfStage").item(0)).getAttribute("value"));
            newFlags.murkCompanionTfStage = Integer.valueOf(((Element)parentElement.getElementsByTagName("murkCompanionTfStage").item(0)).getAttribute("value"));
        }
        catch (Exception var3_7) {
            // empty catch block
        }
        try {
            newFlags.natalyaCollarColour = PresetColour.getColourFromId(((Element)parentElement.getElementsByTagName("natalyaCollarColour").item(0)).getAttribute("value"));
            if (newFlags.natalyaCollarColour == PresetColour.CLOTHING_STEEL) {
                newFlags.natalyaCollarColour = PresetColour.CLOTHING_BRONZE;
            }
            newFlags.natalyaPoints = Integer.valueOf(((Element)parentElement.getElementsByTagName("natalyaPoints").item(0)).getAttribute("value"));
            newFlags.sadistNatalyaSlave = ((Element)parentElement.getElementsByTagName("sadistNatalyaSlave").item(0)).getAttribute("value");
        }
        catch (Exception var3_8) {
            // empty catch block
        }
        if (parentElement.getElementsByTagName("savedLongs").item(0) != null) {
            for (i = 0; i < ((Element)parentElement.getElementsByTagName("savedLongs").item(0)).getElementsByTagName("save").getLength(); ++i) {
                e = (Element)((Element)parentElement.getElementsByTagName("savedLongs").item(0)).getElementsByTagName("save").item(i);
                id = e.getAttribute("id");
                if (Main.isVersionOlderThan(Game.loadingVersion, "0.3.15") && (id.equals("MACHINES") || id.equals("INTERCOM") || id.equals("BUSINESS") || id.equals("BOUNTY_HUNTERS"))) {
                    id = "KAY_" + (String)id;
                }
                newFlags.setSavedLong((String)id, Long.valueOf(e.getTextContent()));
            }
        } else {
            newFlags.setSavedLong("ralph_discount_timer", Long.valueOf(((Element)parentElement.getElementsByTagName("ralphDiscountStartTime").item(0)).getAttribute("value")));
            try {
                newFlags.setSavedLong("kalahari_break_timer", Long.valueOf(((Element)parentElement.getElementsByTagName("kalahariBreakStartTime").item(0)).getAttribute("value")));
            }
            catch (Exception i) {
                // empty catch block
            }
            try {
                newFlags.setSavedLong("daddy_reset_timer", Long.valueOf(((Element)parentElement.getElementsByTagName("daddyResetTimer").item(0)).getAttribute("value")));
            }
            catch (Exception i) {
                // empty catch block
            }
            try {
                if (Main.isVersionOlderThan(Game.loadingVersion, "0.2.11.5")) ** GOTO lbl65
                newFlags.setSavedLong("fortress_alpha_clear", Long.valueOf(((Element)parentElement.getElementsByTagName("impFortressAlphaDefeatedTime").item(0)).getAttribute("value")));
                newFlags.setSavedLong("fortress_females_clear", Long.valueOf(((Element)parentElement.getElementsByTagName("impFortressFemalesDefeatedTime").item(0)).getAttribute("value")));
                newFlags.setSavedLong("fortress_males_clear", Long.valueOf(((Element)parentElement.getElementsByTagName("impFortressMalesDefeatedTime").item(0)).getAttribute("value")));
            }
            catch (Exception i) {
                // empty catch block
            }
        }
lbl65:
        // 8 sources

        for (i = 0; i < ((Element)parentElement.getElementsByTagName("dialogueValues").item(0)).getElementsByTagName("dialogueValue").getLength(); ++i) {
            e = (Element)((Element)parentElement.getElementsByTagName("dialogueValues").item(0)).getElementsByTagName("dialogueValue").item(i);
            try {
                flag = e.getAttribute("value");
                if (flag.equalsIgnoreCase("punishedByAlexa")) {
                    newFlags.values.add(DialogueFlagValue.punishedByHelena);
                    continue;
                }
                flagValue = DialogueFlagValue.getDialogueFlagValueFromId(flag);
                if (flagValue == null) continue;
                newFlags.values.add(flagValue);
                continue;
            }
            catch (Exception var5_16) {
                // empty catch block
            }
        }
        if (Main.isVersionOlderThan(Game.loadingVersion, "0.2.6.1")) {
            newFlags.values.remove(DialogueFlagValue.axelIntroduced);
            newFlags.values.remove(DialogueFlagValue.roxyIntroduced);
            newFlags.values.remove(DialogueFlagValue.eponaIntroduced);
        }
        if (Main.isVersionOlderThan(Game.loadingVersion, "0.2.11.5")) {
            newFlags.values.add(DialogueFlagValue.impFortressAlphaDefeated);
            newFlags.values.add(DialogueFlagValue.impFortressDemonDefeated);
            newFlags.values.add(DialogueFlagValue.impFortressFemalesDefeated);
            newFlags.values.add(DialogueFlagValue.impFortressMalesDefeated);
        }
        DialogueFlags.loadSet(parentElement, doc, newFlags.helenaConversationTopics, "helenaConversationTopics");
        DialogueFlags.loadSet(parentElement, doc, newFlags.reindeerEncounteredIDs, "reindeerEncounteredIDs");
        DialogueFlags.loadSet(parentElement, doc, newFlags.reindeerWorkedForIDs, "reindeerWorkedForIDs");
        DialogueFlags.loadSet(parentElement, doc, newFlags.reindeerFuckedIDs, "reindeerFuckedIDs");
        DialogueFlags.loadSet(parentElement, doc, newFlags.warehouseDefeatedIDs, "warehouseDefeatedIDs");
        return newFlags;
    }

    private static void saveSet(Element parentElement, Document doc, Set<String> set, String title) {
        Element valuesElement = doc.createElement(title);
        parentElement.appendChild(valuesElement);
        for (String value : set) {
            XMLUtil.createXMLElementWithValue(doc, valuesElement, "value", value.toString());
        }
    }

    private static void loadSet(Element parentElement, Document doc, Set<String> set, String title) {
        try {
            if (parentElement.getElementsByTagName(title).item(0) != null) {
                for (int i = 0; i < ((Element)parentElement.getElementsByTagName(title).item(0)).getElementsByTagName("value").getLength(); ++i) {
                    Element e = (Element)((Element)parentElement.getElementsByTagName(title).item(0)).getElementsByTagName("value").item(i);
                    set.add(e.getAttribute("value"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<AbstractDialogueFlagValue> applyTimePassingResets(int startHour, int hoursPassed) {
        ArrayList<AbstractDialogueFlagValue> flagsReset = new ArrayList<AbstractDialogueFlagValue>();
        for (AbstractDialogueFlagValue flag : new HashSet<AbstractDialogueFlagValue>(this.values)) {
            if (flag.getResetHour() <= -1 || (startHour >= flag.getResetHour() || startHour + hoursPassed < flag.getResetHour()) && startHour - 24 + hoursPassed < flag.getResetHour()) continue;
            flagsReset.add(flag);
            this.values.remove(flag);
        }
        return flagsReset;
    }

    public boolean hasFlag(AbstractDialogueFlagValue flag) {
        return this.values.contains(flag);
    }

    public boolean hasFlag(String flagId) {
        return this.values.contains(DialogueFlagValue.getDialogueFlagValueFromId(flagId));
    }

    public void setFlag(String flagId, boolean flagMarker) {
        if (flagMarker) {
            this.values.add(DialogueFlagValue.getDialogueFlagValueFromId(flagId));
        } else {
            this.values.remove(DialogueFlagValue.getDialogueFlagValueFromId(flagId));
        }
    }

    public void setFlag(AbstractDialogueFlagValue flag, boolean flagMarker) {
        if (flagMarker) {
            this.values.add(flag);
        } else {
            this.values.remove(flag);
        }
    }

    public void setSavedLong(String id, long value) {
        this.savedLongs.put(id, value);
    }

    public void setSavedLong(String id, String value) {
        try {
            long valueLong = Long.valueOf(value);
            this.setSavedLong(id, valueLong);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void incrementSavedLong(String id, long increment) {
        this.savedLongs.put(id, this.getSavedLong(id) + increment);
    }

    public boolean hasSavedLong(String id) {
        return this.savedLongs.containsKey(id);
    }

    public void removeSavedLong(String id) {
        this.savedLongs.remove(id);
    }

    public long getSavedLong(String id) {
        this.savedLongs.putIfAbsent(id, -1L);
        return this.savedLongs.get(id);
    }

    public void resetTemporaryVariables() {
        this.tempBooleans = new HashMap<String, Boolean>();
        this.tempStrings = new HashMap<String, String>();
        this.tempIntegers = new HashMap<String, Integer>();
    }

    public void setBool(String id, boolean value) {
        this.tempBooleans.put(id, value);
    }

    public boolean getBool(String id) {
        if (!this.tempBooleans.containsKey(id)) {
            return false;
        }
        return this.tempBooleans.get(id);
    }

    public void setString(String id, String value) {
        this.tempStrings.put(id, value);
    }

    public String getString(String id) {
        if (!this.tempStrings.containsKey(id)) {
            return "";
        }
        return this.tempStrings.get(id);
    }

    public void setInt(String id, int value) {
        this.tempIntegers.put(id, value);
    }

    public int getInt(String id) {
        if (!this.tempIntegers.containsKey(id)) {
            return Integer.MIN_VALUE;
        }
        return this.tempIntegers.get(id);
    }

    public int getMuggerDemand1() {
        return this.muggerDemand1;
    }

    public int getMuggerDemand2() {
        return this.muggerDemand2;
    }

    public int getMuggerDemand3() {
        return this.muggerDemand3;
    }

    public int getProstituteFine() {
        return this.prostituteFine;
    }

    public NPC getSlaveTrader() {
        if (this.slaveTrader == null || this.slaveTrader.isEmpty()) {
            return null;
        }
        try {
            return (NPC)Main.game.getNPCById(this.slaveTrader);
        }
        catch (Exception e) {
            Util.logGetNpcByIdError("getSlaveTrader()", this.slaveTrader);
            return null;
        }
    }

    public void setSlaveTrader(GameCharacter slaveTrader) {
        this.slaveTrader = slaveTrader == null ? null : slaveTrader.getId();
    }

    public String getSlaveTraderId() {
        return this.slaveTrader;
    }

    public void setSlaveTraderId(String slaveTrader) {
        this.slaveTrader = slaveTrader;
    }

    public NPC getManagementCompanion() {
        if (this.managementCompanion == null || this.managementCompanion.isEmpty()) {
            return null;
        }
        try {
            return (NPC)Main.game.getNPCById(this.managementCompanion);
        }
        catch (Exception e) {
            Util.logGetNpcByIdError("getManagementCompanion()", this.managementCompanion);
            return null;
        }
    }

    public void setManagementCompanion(GameCharacter managementCompanion) {
        this.managementCompanion = managementCompanion == null ? null : managementCompanion.getId();
    }

    public String getManagementCompanionId() {
        return this.managementCompanion;
    }

    public void setManagementCompanionId(String managementCompanion) {
        this.managementCompanion = managementCompanion;
    }

    public SlaveJob getSlaveryManagerJobSelected() {
        return this.slaveryManagerJobSelected;
    }

    public void setSlaveryManagerJobSelected(SlaveJob slaveryManagerJobSelected) {
        this.slaveryManagerJobSelected = slaveryManagerJobSelected;
    }

    public void addHelenaConversationTopic(HelenaConversationTopic topic) {
        this.helenaConversationTopics.add(topic.toString());
    }

    public boolean hasHelenaConversationTopic(HelenaConversationTopic topic) {
        return this.helenaConversationTopics.contains(topic.toString());
    }

    public void addReindeerEncountered(String reindeerID) {
        this.reindeerEncounteredIDs.add(reindeerID);
    }

    public boolean hasEncounteredReindeer(String reindeerID) {
        return this.reindeerEncounteredIDs.contains(reindeerID);
    }

    public boolean hasEncounteredAnyReindeers() {
        return !this.reindeerEncounteredIDs.isEmpty();
    }

    public void addReindeerDailyWorkedFor(String reindeerID) {
        this.reindeerWorkedForIDs.add(reindeerID);
    }

    public boolean hasWorkedForReindeer(String reindeerID) {
        return this.reindeerWorkedForIDs.contains(reindeerID);
    }

    public void addReindeerDailyFucked(String reindeerID) {
        this.reindeerFuckedIDs.add(reindeerID);
    }

    public boolean hasFuckedReindeer(String reindeerID) {
        return this.reindeerFuckedIDs.contains(reindeerID);
    }

    public void dailyReindeerReset(String reindeerID) {
        this.reindeerWorkedForIDs.remove(reindeerID);
    }

    public int getMurkTfStage(GameCharacter target) {
        if (target.isPlayer()) {
            return this.murkPlayerTfStage;
        }
        return this.murkCompanionTfStage;
    }

    public void setMurkTfStage(GameCharacter target, int stage) {
        if (target.isPlayer()) {
            this.murkPlayerTfStage = stage;
        } else {
            this.murkCompanionTfStage = stage;
        }
    }

    public Colour getNatalyaCollarColour() {
        return this.natalyaCollarColour;
    }

    public void setNatalyaCollarColour(Colour natalyaCollarColour) {
        this.natalyaCollarColour = natalyaCollarColour;
    }

    public int getNatalyaPoints() {
        return this.natalyaPoints;
    }

    public void setNatalyaPoints(int natalyaPoints) {
        this.natalyaPoints = natalyaPoints;
        if (this.natalyaPoints < 0) {
            this.natalyaPoints = 0;
        }
    }

    public String incrementNatalyaPoints(int increment) {
        this.setNatalyaPoints(this.getNatalyaPoints() + increment);
        boolean plural = increment != 1;
        StringBuilder sb = new StringBuilder();
        sb.append("<p style='text-align:center;'>");
        if (increment > 0) {
            sb.append("\u4f60[style.colourGood(\u83b7\u5f97\u4e86)][style.boldPink(" + increment + ")][style.colourPinkLight([style.mule]\u70b9\u6570" + (plural ? "s" : "") + ")]\uff01");
        } else {
            sb.append("\u4f60[style.colourBad(\u5931\u53bb\u4e86)][style.boldPink(" + -increment + ")][style.colourPinkLight([style.mule]\u70b9\u6570)]\uff01");
        }
        sb.append("<br/>\u4f60\u73b0\u5728\u6709[style.boldPink(" + this.getNatalyaPoints() + ")][style.colourPinkLight([style.mule]\u70b9\u6570)]\uff01");
        sb.append("</p>");
        return sb.toString();
    }

    public String getSadistNatalyaSlave() {
        return this.sadistNatalyaSlave;
    }

    public void setSadistNatalyaSlave(String sadistNatalyaSlave) {
        this.sadistNatalyaSlave = sadistNatalyaSlave;
    }
}

