/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.companions;

import com.lilithsthrone.game.PropertyValue;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.PlayerCharacter;
import com.lilithsthrone.game.character.attributes.AffectionLevelBasic;
import com.lilithsthrone.game.character.attributes.ObedienceLevelBasic;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.NPCFlagValue;
import com.lilithsthrone.game.character.npc.dominion.Helena;
import com.lilithsthrone.game.character.npc.dominion.Scarlett;
import com.lilithsthrone.game.character.npc.misc.NPCOffspring;
import com.lilithsthrone.game.character.persona.Relationship;
import com.lilithsthrone.game.character.quests.Quest;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.DialogueNodeType;
import com.lilithsthrone.game.dialogue.companions.CompanionManagement;
import com.lilithsthrone.game.dialogue.places.dominion.slaverAlley.ScarlettsShop;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseEffectsOnly;
import com.lilithsthrone.game.dialogue.responses.ResponseSex;
import com.lilithsthrone.game.dialogue.responses.ResponseTag;
import com.lilithsthrone.game.dialogue.utils.CharactersPresentDialogue;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.ClothingType;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJob;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJobSetting;
import com.lilithsthrone.game.occupantManagement.slave.SlavePermissionSetting;
import com.lilithsthrone.game.sex.ImmobilisationType;
import com.lilithsthrone.game.sex.SexControl;
import com.lilithsthrone.game.sex.SexPace;
import com.lilithsthrone.game.sex.managers.dominion.SMMilkingStall;
import com.lilithsthrone.game.sex.managers.universal.SMGeneric;
import com.lilithsthrone.game.sex.positions.slots.SexSlot;
import com.lilithsthrone.game.sex.positions.slots.SexSlotMilkingStall;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceUpgrade;
import com.lilithsthrone.world.places.PlaceType;
import com.lilithsthrone.world.places.PlaceUpgrade;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SlaveDialogue {
    private static NPC slave;
    private static NPC characterForSex;
    private static NPC characterForSexSecondary;
    private static List<NPC> charactersPresent;
    private static boolean initFromCharactersPresent;
    private static boolean dollStatueInterrupted;
    private static GameCharacter enslavementTarget;
    private static DialogueNode followupEnslavementDialogue;
    private static boolean enslavementWorked;
    public static final DialogueNode DEFAULT_ENSLAVEMENT_DIALOGUE;
    public static final DialogueNode FREEDOM_DIALOG;
    public static final DialogueNode SLAVE_START_NO_CONTENT;
    public static final DialogueNode SLAVE_START;
    public static final DialogueNode SLAVE_PROGRESSION;
    public static final DialogueNode SLAVE_MINOR;
    public static final DialogueNode SLAVE_ENCOURAGE;
    public static final DialogueNode SLAVE_HUG;
    public static final DialogueNode SLAVE_PETTINGS;
    public static final DialogueNode SLAVE_PRESENT;
    public static final DialogueNode SLAVE_INSPECT;
    public static final DialogueNode SLAVE_SPANKING;
    public static final DialogueNode SLAVE_MOLEST;
    public static final DialogueNode AFTER_SEX;

    public static void initDialogue(NPC targetedSlave, boolean initFromCharactersPresent) {
        CompanionManagement.initManagement(SLAVE_START, 2, targetedSlave);
        slave = targetedSlave;
        characterForSex = targetedSlave;
        characterForSexSecondary = null;
        charactersPresent = new ArrayList<NPC>(Main.game.getCharactersPresent());
        charactersPresent.removeIf(npc -> !Main.game.getPlayer().getCompanions().contains(npc) && (!npc.isSlave() || !npc.getOwner().isPlayer()) && !Main.game.getPlayer().getFriendlyOccupants().contains(npc.getId()));
        if (charactersPresent.size() > 1) {
            characterForSexSecondary = charactersPresent.contains(Main.game.getPlayer().getMainCompanion()) && !SlaveDialogue.getSlave().equals(Main.game.getPlayer().getMainCompanion()) ? (NPC)Main.game.getPlayer().getMainCompanion() : charactersPresent.stream().filter(npc -> !npc.equals(SlaveDialogue.getSlave())).findFirst().get();
        }
        SlaveDialogue.initFromCharactersPresent = initFromCharactersPresent;
        dollStatueInterrupted = false;
    }

    private static DialogueNode getAfterSexDialogue() {
        if (initFromCharactersPresent) {
            return CharactersPresentDialogue.AFTER_SEX;
        }
        return AFTER_SEX;
    }

    private static NPC getSlave() {
        return slave;
    }

    private static boolean isDoll() {
        return SlaveDialogue.getSlave().isDoll();
    }

    private static boolean isDollStatue() {
        return SlaveDialogue.getSlave().isDollStatue();
    }

    private static ResponseTag getDollSexTag() {
        if (SlaveDialogue.isDollStatue()) {
            if (SlaveDialogue.getSlave().hasSlaveJobSetting(SlaveJob.DOLL_STATUE, SlaveJobSetting.DOLL_STATUE_ALL_FOURS)) {
                return ResponseTag.PREFER_DOGGY;
            }
            if (SlaveDialogue.getSlave().hasSlaveJobSetting(SlaveJob.DOLL_STATUE, SlaveJobSetting.DOLL_STATUE_MISSIONARY) || SlaveDialogue.getSlave().hasSlaveJobSetting(SlaveJob.DOLL_STATUE, SlaveJobSetting.DOLL_STATUE_BRIDGE)) {
                return ResponseTag.PREFER_MISSIONARY;
            }
            if (SlaveDialogue.getSlave().hasSlaveJobSetting(SlaveJob.DOLL_STATUE, SlaveJobSetting.DOLL_STATUE_SQUATTING)) {
                return ResponseTag.PREFER_ORAL;
            }
        }
        return null;
    }

    public static boolean isDollStatueInterrupted() {
        return dollStatueInterrupted;
    }

    private static SlaveJob getCurrentJob() {
        return SlaveDialogue.getSlave().getSlaveJob(Main.game.getHourOfDay());
    }

    public static String getTextFilePath() {
        if (SlaveDialogue.getSlave().isRelatedTo(Main.game.getPlayer(), new Relationship[0])) {
            return "characters/offspring/slave";
        }
        return "misc/slaveDialogue";
    }

    private static String getThreesomeTextFilePath() {
        if (characterForSex.isRelatedTo(Main.game.getPlayer(), new Relationship[0]) || characterForSexSecondary != null && characterForSexSecondary.isRelatedTo(Main.game.getPlayer(), new Relationship[0])) {
            return "characters/offspring/slave";
        }
        return "misc/slaveDialogue";
    }

    private static void applyReactionReset() {
        if (SlaveDialogue.getSlave().isVisiblyPregnant()) {
            SlaveDialogue.getSlave().setCharacterReactedToPregnancy(Main.game.getPlayer(), true);
        }
        if (Main.game.getPlayer().isVisiblyPregnant()) {
            Main.game.getPlayer().setCharacterReactedToPregnancy(SlaveDialogue.getSlave(), true);
        }
    }

    private static boolean isCompanionSexPublic() {
        return Main.game.getPlayer().getLocationPlace().isPopulated() && !Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.WATERING_HOLE_SEATING_AREA) && !Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.WATERING_HOLE_TOILETS);
    }

    public static GameCharacter getEnslavementTarget() {
        return enslavementTarget;
    }

    public static void setEnslavementTarget(GameCharacter enslavementTarget) {
        SlaveDialogue.enslavementTarget = enslavementTarget;
    }

    public static DialogueNode getFollowupEnslavementDialogue() {
        return followupEnslavementDialogue;
    }

    public static void setFollowupEnslavementDialogue(DialogueNode followupEnslavementDialogue) {
        SlaveDialogue.followupEnslavementDialogue = followupEnslavementDialogue;
    }

    private static SMGeneric getGenericSlaveSexManager(List<GameCharacter> dominantParticipants, List<GameCharacter> submissiveParticipants, List<ResponseTag> tags, boolean forcePlayerFullControl) {
        return SlaveDialogue.getGenericSlaveSexManager(dominantParticipants, submissiveParticipants, SlaveDialogue.getDominantSpectators(), SlaveDialogue.getSubmissiveSpectators(), tags, forcePlayerFullControl, new HashMap<GameCharacter, SexPace>());
    }

    private static SMGeneric getGenericSlaveSexManager(final List<GameCharacter> dominantParticipants, final List<GameCharacter> submissiveParticipants, List<GameCharacter> dominantSpectators, List<GameCharacter> submissiveSpectators, List<ResponseTag> tags, final boolean forcePlayerFullControl, final Map<GameCharacter, SexPace> startingSexPaces) {
        return new SMGeneric(dominantParticipants, submissiveParticipants, dominantSpectators, submissiveSpectators, tags){

            @Override
            public SexPace getStartingSexPaceModifier(GameCharacter character) {
                if (startingSexPaces != null && startingSexPaces.containsKey(character)) {
                    return (SexPace)((Object)startingSexPaces.get(character));
                }
                return super.getStartingSexPaceModifier(character);
            }

            @Override
            public boolean isPublicSex() {
                return SlaveDialogue.isCompanionSexPublic();
            }

            @Override
            public SexControl getSexControl(GameCharacter participant) {
                if (participant.isPlayer() && forcePlayerFullControl) {
                    return SexControl.FULL;
                }
                return super.getSexControl(participant);
            }

            @Override
            public Map<ImmobilisationType, Map<GameCharacter, Set<GameCharacter>>> getStartingCharactersImmobilised() {
                AbstractPlaceUpgrade upgrade;
                ImmobilisationType immobilisationType = null;
                Iterator<AbstractPlaceUpgrade> iterator = Main.game.getPlayer().getLocationPlace().getPlaceUpgrades().iterator();
                while (iterator.hasNext() && (immobilisationType = (upgrade = iterator.next()).getImmobilisationType()) == null) {
                }
                HashMap<ImmobilisationType, Map<GameCharacter, Set<GameCharacter>>> map = new HashMap<ImmobilisationType, Map<GameCharacter, Set<GameCharacter>>>();
                map.put(immobilisationType, new HashMap());
                ((Map)map.get((Object)immobilisationType)).put((GameCharacter)dominantParticipants.get(0), new HashSet());
                if (immobilisationType != null) {
                    for (GameCharacter character : submissiveParticipants) {
                        if (!character.isSlave() || character.isDollStatue()) continue;
                        ((Set)((Map)map.get((Object)immobilisationType)).get(dominantParticipants.get(0))).add(character);
                    }
                }
                map.put(ImmobilisationType.COMMAND, new HashMap());
                ((Map)map.get((Object)ImmobilisationType.COMMAND)).put((GameCharacter)dominantParticipants.get(0), new HashSet());
                for (GameCharacter character : submissiveParticipants) {
                    if (!character.isDollStatue()) continue;
                    ((Set)((Map)map.get((Object)ImmobilisationType.COMMAND)).get(dominantParticipants.get(0))).add(character);
                }
                map.put(ImmobilisationType.SLEEP, new HashMap());
                ((Map)map.get((Object)ImmobilisationType.SLEEP)).put((GameCharacter)dominantParticipants.get(0), new HashSet());
                for (GameCharacter character : submissiveParticipants) {
                    if (!character.isAsleep()) continue;
                    ((Set)((Map)map.get((Object)ImmobilisationType.SLEEP)).get(dominantParticipants.get(0))).add(character);
                }
                return map;
            }
        };
    }

    public static List<GameCharacter> getDominantSpectators() {
        return Main.game.getPlayer().getCompanions();
    }

    public static List<GameCharacter> getSubmissiveSpectators() {
        ArrayList<NPC> characters = new ArrayList<NPC>();
        for (NPC character : Main.game.getCharactersPresent()) {
            if ((!character.isSlave() || !character.getOwner().isPlayer()) && (!Main.game.getPlayer().getFriendlyOccupants().contains(character.getId()) || !character.isAttractedTo(Main.game.getPlayer())) || character.isAsleep()) continue;
            characters.add(character);
        }
        return new ArrayList<GameCharacter>(characters);
    }

    private static String getSlaveStartCoreContent() {
        StringBuilder sb = new StringBuilder();
        if (!SlaveDialogue.isDollStatue()) {
            if (SlaveDialogue.getSlave().isVisiblyPregnant()) {
                if (!SlaveDialogue.getSlave().isCharacterReactedToPregnancy(Main.game.getPlayer())) {
                    sb.append("<p>");
                    sb.append("\u5f53\u4f60\u770b\u5230[npc.race]\u65f6\uff0c\u5f88\u96be\u4e0d\u6ce8\u610f\u5230[npc.sheIs]\u6b63\u633a\u7740\u5b55\u809a\u3002");
                    sb.append("[npc.She]\u548c\u4f60\u5bf9\u89c6\u65f6\u5fc3\u795e\u604d\u60da\u5730\u629a\u6478\u7740\u5979\u80bf\u80c0\u7684\u8179\u90e8\uff0c");
                    GameCharacter father = SlaveDialogue.getSlave().getPregnantLitter().getFather();
                    if (father != null && father.isPlayer()) {
                        block0 : switch (AffectionLevelBasic.getAffectionLevelFromValue(SlaveDialogue.getSlave().getAffection(Main.game.getPlayer()))) {
                            case DISLIKE: {
                                switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                    case DISOBEDIENT: {
                                        sb.append("[npc.she]\u5411\u4f60\u5410\u53e3\u6c34\u65f6\u751a\u81f3\u6ca1\u6709\u63a9\u9970[npc.eyes]\u4e2d\u7684\u6068\u610f\uff0c[npc.speech(\u5478\uff0c\u90fd\u662f<i>\u4f60</i>\u3002\u4f60\u8ba9\u6211\u6000\u5b55\u4e86\uff0c\u6240\u4ee5\u6211\u8fd9\u6bb5\u65f6\u95f4\u4e0d\u80fd\u5de5\u4f5c\uff0c\u8be5\u6b7b\u7684\u6df7\u86cb\u2026\u2026)]");
                                        break;
                                    }
                                    case NEUTRAL: {
                                        sb.append("[npc.she]\u52aa\u529b\u6291\u5236[npc.eyes]\u4e2d\u6d41\u9732\u51fa\u7684\u6068\u610f\uff0c\u8bf4\u9053\uff0c[npc.speech(\u54e6\uff0c\u55e8\uff0c[npc.pcName]\u3002\u4f60\u8ba9\u6211\u6000\u5b55\u4e86\uff0c\u6240\u4ee5\u6211\u9700\u8981\u4e00\u4e9b\u65f6\u95f4\u6765\u4f11\u606f\u3002)]");
                                        break;
                                    }
                                    case OBEDIENT: {
                                        sb.append("[npc.she]\u547c\u5524\u7740\u4f60\u5e76\u987a\u4ece\u5730\u63a9\u9970\u7740[npc.her]\u773c\u4e2d\u7684\u6068\u610f\uff0c[npc.speech(\u55e8\uff0c[npc.pcName]\u3002\u6211\u76f8\u4fe1\u4f60\u770b\u5f97\u51fa\u6765\uff0c\u4f60\u8ba9\u6211\u6000\u5b55\u4e86\u2026\u2026)]");
                                    }
                                }
                                break;
                            }
                            case NEUTRAL: {
                                switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                    case DISOBEDIENT: {
                                        sb.append("\u53f9\u4e86\u53e3\u6c14\uff0c[npc.speech(\u55e8\uff0c[npc.pcName]\u3002\u4f60\u8ba9\u6211\u6000\u5b55\u4e86\uff0c\u6240\u4ee5\u6211\u8fd9\u6bb5\u65f6\u95f4\u9700\u8981\u653e\u677e\u4e00\u4e0b\uff0c\u597d\u5417\uff1f)]");
                                        break;
                                    }
                                    case NEUTRAL: {
                                        sb.append("\u53f9\u4e86\u53e3\u6c14\uff0c[npc.speech(\u55e8\uff0c[npc.pcName]\u3002\u4f60\u8ba9\u6211\u6000\u5b55\u4e86\u2026\u2026)]");
                                        break;
                                    }
                                    case OBEDIENT: {
                                        sb.append("\u53f9\u4e86\u53e3\u6c14\uff0c[npc.speech(\u55e8\uff0c[npc.pcName]\u3002\u4f60\u8ba9\u6211\u6000\u5b55\u4e86\u2026\u2026\u6240\u4ee5\u6211\u5f97\u505a\u597d\u7167\u987e\u597d\u5b69\u5b50\u7684\u51c6\u5907\uff01)]");
                                    }
                                }
                                break;
                            }
                            case LIKE: {
                                switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                    case DISOBEDIENT: {
                                        sb.append("[npc.she]\u7efd\u653e\u51fa\u707f\u70c2\u7684\u7b11\u5bb9\uff0c\u9ad8\u5174\u5730\u558a\u9053\uff0c[npc.speech([npc.PcName]\uff01\u770b\uff01\u4f60\u8ba9\u6211\u6000\u5b55\u4e86\uff0c\u662f\u4e0d\u662f\u5f88\u68d2\uff1f\uff01\u6211\u9700\u8981\u4f11\u606f\u4e00\u6bb5\u65f6\u95f4\uff0c\u8fd9\u6837\u624d\u80fd\u7167\u987e\u597d\u81ea\u5df1\uff0c\u600e\u4e48\u6837\uff1f)]");
                                        break block0;
                                    }
                                    case NEUTRAL: {
                                        sb.append("[npc.she]\u7efd\u653e\u51fa\u707f\u70c2\u7684\u7b11\u5bb9\uff0c\u9ad8\u5174\u5730\u558a\u9053\uff0c[npc.speech([npc.PcName]\uff01\u4f60\u8ba9\u6211\u6000\u5b55\u4e86\uff0c\u662f\u4e0d\u662f\u5f88\u68d2\uff1f\uff01\u6211\u4e00\u5b9a\u4f1a\u7167\u987e\u597d\u6211\u4eec\u7684\u5b69\u5b50\uff01)]");
                                        break block0;
                                    }
                                    case OBEDIENT: {
                                        sb.append("[npc.she]\u7efd\u653e\u51fa\u707f\u70c2\u7684\u7b11\u5bb9\uff0c\u9ad8\u5174\u5730\u558a\u9053\uff0c[npc.speech(\u55e8\uff0c[npc.pcName]\uff01\u4f60\u8ba9\u6211\u6000\u5b55\u4e86\uff01\u6240\u4ee5\u6211\u5f97\u505a\u597d\u7167\u987e\u597d\u5b69\u5b50\u7684\u51c6\u5907\uff01)]");
                                    }
                                }
                            }
                        }
                        sb.append("</p>");
                        sb.append("<p>\u4f60[pc.step]\u5230\u4f60\u7684\u5974\u96b6\u9762\u524d\u5e76\u7528[pc.hands]\u629a\u6478\u7740[npc.her]\u7684\u5b55\u809a\u3002\u4f60\u653e\u5fc3\u5730\u5bf9\u4f60\u5b69\u5b50\u7684\u6bcd\u4eb2\u5fae\u7b11\uff0c\u544a\u8bc9[npc.herHim]\u4e00\u65e6\u65f6\u95f4\u5230\u4e86\uff0c\u8389\u83b1\u96c5\u5c31\u80fd\u5e2e\u52a9[npc.herHim]\u5206\u5a29\u3002</p><p>[npc.Name]\u70b9\u4e86\u70b9\u5934\uff0c\u4e8e\u662f\u5728\u4f60\u629a\u6478\u4e86\u4e00\u4f1a[npc.her]\u7684\u8179\u90e8\u540e\uff0c\u4f60\u9000\u4e86\u51fa\u53bb\uff0c\u60f3\u7740\u63a5\u4e0b\u6765\u8be5\u5e72\u4ec0\u4e48\u2026\u2026</p>");
                    } else {
                        switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                            case DISOBEDIENT: {
                                sb.append("\u53f9\u4e86\u53e3\u6c14\uff0c[npc.speech(\u55e8\uff0c[npc.pcName]\u3002" + (String)(father == null || father.equals(SlaveDialogue.getSlave()) ? "\u7ed3\u679c\u6211\u6000\u5b55\u4e86" : father.getName("") + "\u8ba9\u6211\u6000\u5b55\u4e86") + "\uff0c\u6240\u4ee5\u8bf4\u6211\u8981\u4f11\u606f\u4e00\u9635\u5b50\u3002\u627e\u4e2a\u522b\u7684\u5974\u96b6\u6765\u9876\u66ff\u6211\uff0c\u597d\u5417\uff1f)]");
                                break;
                            }
                            case NEUTRAL: {
                                sb.append("\u53f9\u4e86\u53e3\u6c14\uff0c[npc.speech(\u55e8\uff0c[npc.pcName]\u3002" + (String)(father == null || father.equals(SlaveDialogue.getSlave()) ? "\u7ed3\u679c\u6211\u6000\u5b55\u4e86" : father.getName("") + "\u8ba9\u6211\u6000\u5b55\u4e86") + ", \u6240\u4ee5\u6211\u8fd9\u6bb5\u65f6\u95f4\u9700\u8981\u653e\u677e\u4e00\u4e0b\uff0c\u53ef\u4ee5\u5427\uff1f)]");
                                break;
                            }
                            case OBEDIENT: {
                                sb.append("\u987a\u4ece\u5730\u544a\u8bc9\u4f60\u53d1\u751f\u4e86\u4ec0\u4e48\uff0c[npc.speech(\u4f60\u597d\uff0c[npc.pcName]\u3002" + (String)(father == null || father.equals(SlaveDialogue.getSlave()) ? "\u7ed3\u679c\u6211\u6000\u5b55\u4e86" : father.getName("") + "\u8ba9\u6211\u6000\u5b55\u4e86") + "\uff0c\u4f46\u6211\u4e0d\u4f1a\u8ba9\u8fd9\u59a8\u788d\u6211\u5c65\u884c\u804c\u8d23\u7684\uff01)]");
                            }
                        }
                        sb.append("</p>");
                        sb.append("<p>\u4f60[pc.step]\u5230\u4f60\u7684\u5974\u96b6\u9762\u524d\u5e76\u7528[pc.hands]\u629a\u6478\u7740[npc.her]\u7684\u5b55\u809a\u3002\u4f60\u653e\u5fc3\u5730\u5bf9[npc.race]\u5fae\u7b11\uff0c\u544a\u8bc9[npc.herHim]\u4e00\u65e6\u65f6\u95f4\u5230\u4e86\uff0c\u8389\u83b1\u96c5\u5c31\u80fd\u5e2e\u52a9[npc.herHim]\u5206\u5a29\u3002</p><p>[npc.Name]\u70b9\u4e86\u70b9\u5934\uff0c\u4e8e\u662f\u5728\u4f60\u629a\u6478\u4e86\u4e00\u4f1a[npc.her]\u7684\u8179\u90e8\u540e\uff0c\u4f60\u9000\u4e86\u51fa\u53bb\uff0c\u60f3\u7740\u63a5\u4e0b\u6765\u8be5\u5e72\u4ec0\u4e48\u2026\u2026</p>");
                    }
                } else {
                    sb.append("<p>\u5728\u4f60\u770b\u5411[npc.race]\u65f6\uff0c\u4f60\u770b\u89c1[npc.sheIs]\u4f9d\u7136\u633a\u7740\u5b55\u809a\uff0c\u800c[npc.She]\u4e00\u8fb9\u4f60\u5bf9\u89c6\u4e00\u8fb9\u5fc3\u795e\u604d\u60da\u5730\u629a\u6478\u7740\u5979\u80bf\u80c0\u7684\u8179\u90e8\uff0c");
                    block25 : switch (AffectionLevelBasic.getAffectionLevelFromValue(SlaveDialogue.getSlave().getAffection(Main.game.getPlayer()))) {
                        case DISLIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    sb.append("[npc.she]\u5411\u4f60\u5410\u53e3\u6c34\u65f6\u751a\u81f3\u6ca1\u6709\u63a9\u9970[npc.eyes]\u4e2d\u7684\u6068\u610f\uff0c[npc.speech(\u5478\uff0c\u662f<i>\u4f60</i>\u3002\u4f60\u4ed6\u5988\u73b0\u5728\u53c8\u60f3\u5e72\u4ec0\u4e48\uff1f\uff01)]");
                                    break;
                                }
                                case NEUTRAL: {
                                    sb.append("[npc.she]\u52aa\u529b\u6291\u5236[npc.eyes]\u4e2d\u6d41\u9732\u51fa\u7684\u6068\u610f\uff0c\u8bf4\u9053\uff0c[npc.speech(\u54e6\uff0c\u4f60\u597d\uff0c[npc.pcName]\u3002\u4f60\u60f3\u8981\u5e72\u4ec0\u4e48\uff1f)]");
                                    break;
                                }
                                case OBEDIENT: {
                                    sb.append("[npc.she]\u547c\u5524\u7740\u4f60\u5e76\u987a\u4ece\u5730\u63a9\u9970\u7740[npc.her]\u773c\u4e2d\u7684\u6068\u610f\uff0c[npc.speech(\u60a8\u597d\uff0c[npc.pcName]\u3002\u6211\u80fd\u4e3a\u60a8\u505a\u4e9b\u4ec0\u4e48\uff1f)]");
                                }
                            }
                            break;
                        }
                        case NEUTRAL: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    sb.append("\u53f9\u4e86\u53e3\u6c14\uff0c[npc.speech(\u55e8\uff0c[npc.pcName]\u3002\u6211\u73b0\u5728\u5f88\u8f7b\u677e\uff0c\u56e0\u4e3a\u6211\u6000\u5b55\u4e86\uff0c\u597d\u5417\uff1f)]");
                                    break;
                                }
                                case NEUTRAL: {
                                    sb.append("\u53f9\u4e86\u53e3\u6c14\uff0c[npc.speech(\u60a8\u597d\uff0c[npc.pcName]\u3002\u6211\u80fd\u4e3a\u60a8\u505a\u4e9b\u4ec0\u4e48\uff1f)]");
                                    break;
                                }
                                case OBEDIENT: {
                                    sb.append("\u53f9\u4e86\u53e3\u6c14\uff0c[npc.speech(\u55e8\uff0c[npc.pcName]\u3002\u6709\u4f55\u8d35\u5e72\uff1f)]");
                                }
                            }
                            break;
                        }
                        case LIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    sb.append("[npc.she]\u7efd\u653e\u51fa\u707f\u70c2\u7684\u7b11\u5bb9\uff0c\u9ad8\u5174\u5730\u558a\u9053\uff0c[npc.speech(\u55e8\uff0c[npc.pcName]\uff01\u60a8\u597d\u5417\uff1f\uff01\u6211\u73b0\u5728\u5f88\u8f7b\u677e\uff0c\u53ef\u4ee5\u7167\u987e\u597d\u81ea\u5df1\uff0c\u597d\u5417\uff1f)]");
                                    break block25;
                                }
                                case NEUTRAL: {
                                    sb.append("[npc.she]\u7efd\u653e\u51fa\u707f\u70c2\u7684\u7b11\u5bb9\uff0c\u9ad8\u5174\u5730\u558a\u9053\uff0c[npc.speech(\u55e8\uff0c[npc.pcName]\uff01\u6211\u80fd\u7167\u987e\u597d\u81ea\u5df1\uff0c\u60a8\u600e\u4e48\u6837\uff1f)]");
                                    break block25;
                                }
                                case OBEDIENT: {
                                    sb.append("[npc.she]\u7efd\u653e\u51fa\u707f\u70c2\u7684\u7b11\u5bb9\uff0c\u9ad8\u5174\u5730\u558a\u9053\uff0c[npc.speech(\u55e8\uff0c[npc.pcName]\uff01\u6709\u4f55\u8d35\u5e72\uff1f)]");
                                }
                            }
                        }
                    }
                    sb.append("</p>");
                    sb.append("<p>\u4f60[pc.step]\u5230\u4f60\u7684\u5974\u96b6\u9762\u524d\u5e76\u7528[pc.hands]\u629a\u6478\u7740[npc.her]\u7684\u5b55\u809a\u3002\u4f60\u653e\u5fc3\u5730\u5bf9[npc.race]\u5fae\u7b11\uff0c\u544a\u8bc9[npc.herHim]\u4e00\u65e6\u65f6\u95f4\u5230\u4e86\uff0c\u8389\u83b1\u96c5\u5c31\u80fd\u5e2e\u52a9[npc.herHim]\u5206\u5a29\u3002</p><p>[npc.Name]\u70b9\u4e86\u70b9\u5934\uff0c\u4e8e\u662f\u5728\u4f60\u629a\u6478\u4e86\u4e00\u4f1a[npc.her]\u7684\u8179\u90e8\u540e\uff0c\u4f60\u9000\u4e86\u51fa\u53bb\uff0c\u60f3\u7740\u63a5\u4e0b\u6765\u8be5\u5e72\u4ec0\u4e48\u2026\u2026</p>");
                }
            } else {
                sb.append("<p>");
                if (SlaveDialogue.isDoll()) {
                    sb.append("[npc.speech([style.morning]\u597d\uff0c[pc.name]\uff0c)][npc.she]\u53d1\u51fa\u7565\u663e\u673a\u68b0\u7684\u58f0\u97f3\uff0c[npc.speech(\u6211\u80fd\u5e2e\u4f60\u505a\u70b9\u4ec0\u4e48\uff1f)]");
                } else {
                    sb.append("\u4f60\u770b\u7740[npc.race]\uff0c[npc.she]\u540c\u6837\u51dd\u89c6\u7740\u4f60\uff0c");
                    block45 : switch (AffectionLevelBasic.getAffectionLevelFromValue(SlaveDialogue.getSlave().getAffection(Main.game.getPlayer()))) {
                        case DISLIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    sb.append("[npc.she]\u5411\u4f60\u5410\u53e3\u6c34\u65f6\u751a\u81f3\u6ca1\u6709\u63a9\u9970[npc.eyes]\u4e2d\u7684\u6068\u610f\uff0c[npc.speech(\u5478\uff0c\u662f<i>\u4f60</i>\u3002\u4f60\u4ed6\u5988\u73b0\u5728\u53c8\u60f3\u5e72\u4ec0\u4e48\uff1f\uff01)]");
                                    break;
                                }
                                case NEUTRAL: {
                                    sb.append("[npc.she]\u52aa\u529b\u6291\u5236[npc.eyes]\u4e2d\u6d41\u9732\u51fa\u7684\u6068\u610f\uff0c\u8bf4\u9053\uff0c[npc.speech(\u54e6\uff0c\u55e8\uff0c[npc.pcName]\u3002\u4f60\u60f3\u8981\u5e72\u4ec0\u4e48\uff1f)]");
                                    break;
                                }
                                case OBEDIENT: {
                                    sb.append("[npc.she]\u547c\u5524\u7740\u4f60\u5e76\u987a\u4ece\u5730\u63a9\u9970\u7740[npc.her]\u773c\u4e2d\u7684\u6068\u610f\uff0c[npc.speech(\u55e8\uff0c[npc.pcName]\u3002\u6211\u80fd\u4e3a\u60a8\u505a\u4e9b\u4ec0\u4e48\uff1f)]");
                                }
                            }
                            break;
                        }
                        case NEUTRAL: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    sb.append("\u53f9\u4e86\u53e3\u6c14\uff0c[npc.speech(\u55e8\uff0c[npc.pcName]\u3002\u4f60\u9700\u8981\u4e9b\u4ec0\u4e48\u5462\uff1f)]");
                                    break;
                                }
                                case NEUTRAL: {
                                    sb.append("\u53f9\u4e86\u53e3\u6c14\uff0c[npc.speech(\u55e8\uff0c[npc.pcName]\u3002\u6211\u80fd\u4e3a\u60a8\u505a\u4e9b\u4ec0\u4e48\uff1f)]");
                                    break;
                                }
                                case OBEDIENT: {
                                    sb.append("\u53f9\u4e86\u53e3\u6c14\uff0c[npc.speech(\u55e8\uff0c[npc.pcName]\u3002\u6709\u4f55\u8d35\u5e72\uff1f)]");
                                }
                            }
                            break;
                        }
                        case LIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    sb.append("[npc.she]\u7efd\u653e\u51fa\u707f\u70c2\u7684\u7b11\u5bb9\uff0c\u9ad8\u5174\u5730\u558a\u9053\uff0c[npc.speech(\u55e8\uff0c[npc.pcName]\uff01\u6211\u770b\u89c1\u60a8\u771f\u662f\u592a\u9ad8\u5174\u4e86\uff0c\u6211\u4e00\u76f4\u90fd\u8868\u73b0\u7684\u5f88\u597d\uff01)]");
                                    break block45;
                                }
                                case NEUTRAL: {
                                    sb.append("[npc.she]\u7efd\u653e\u51fa\u707f\u70c2\u7684\u7b11\u5bb9\uff0c\u9ad8\u5174\u5730\u558a\u9053\uff0c[npc.speech(\u55e8\uff0c[npc.pcName]\uff01\u60a8\u597d\u5417\uff1f\u6709\u4f55\u8d35\u5e72\uff1f)]");
                                    break block45;
                                }
                                case OBEDIENT: {
                                    sb.append("[npc.she]\u7efd\u653e\u51fa\u707f\u70c2\u7684\u7b11\u5bb9\uff0c\u9ad8\u5174\u5730\u558a\u9053\uff0c[npc.speech(\u55e8\uff0c[npc.pcName]\uff01\u6709\u4f55\u8d35\u5e72\uff1f)]");
                                }
                            }
                        }
                    }
                }
                sb.append("</p>");
                sb.append("<p>\u5974\u96b6\u6b63\u5728\u7b49\u5f85\u4f60\u7684\u547d\u4ee4\uff0c\u4f46\u4f60\u4e0d\u77e5\u9053\u73b0\u5728\u8be5\u5982\u4f55\u5b89\u6392[npc.herHim]\u2026\u2026</p>");
            }
        }
        sb.append(SlaveDialogue.getFooterText());
        return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), sb.toString(), new ParserTag[0]);
    }

    private static Response getWakeUpResponse() {
        return new Response(UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u53eb\u9192[npc.herHim]", new ParserTag[0]), UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u628a[npc.name]\u53eb\u9192\uff0c\u8fd9\u6837\u4f60\u5c31\u53ef\u4ee5\u548c[npc.herHim]\u8fdb\u884c\u4e92\u52a8\u3002<br/>[style.italicsMinorBad(\u8981\u662f\u628a[npc.She]\u5435\u9192\u4e86\uff0c[npc.herHim]\u80af\u5b9a\u4f1a\u5f88\u751f\u6c14\u7684\u2026\u2026)]", new ParserTag[0]), SLAVE_START_NO_CONTENT){

            @Override
            public void effects() {
                SlaveDialogue.getSlave().wakeUp();
                StringBuilder sb = new StringBuilder();
                sb.append("<p>");
                sb.append("\u4f60\u60f3\u4e0e[npc.name]\u4e92\u52a8\uff0c\u4fbf[pc.step]\u5230[npc.sheIs]\u7761\u89c9\u7684\u5730\u65b9\uff0c\u7136\u540e");
                if (Main.game.getPlayer().isMute()) {
                    sb.append("\u6447\u4e86\u6447[npc.herHim]\u3002");
                } else {
                    sb.append("\u53eb\u7740[npc.her]\u7684\u540d\u5b57\u3002");
                }
                if (SlaveDialogue.getSlave().hasTrait(Perk.HEAVY_SLEEPER, true)) {
                    sb.append("\u56e0\u4e3a[npc.name]\u662f\u91cd\u5ea6\u6c89\u7761\u8005\uff0c\u8fd9\u5e76\u4e0d\u8db3\u4ee5\u5524\u9192[npc.herHim]\uff0c\u4f60\u4e0d\u5f97\u4e0d\u7528\u529b\u63a8\u4e86[npc.herHim]\u597d\u51e0\u6b21\uff0c[npc.she]\u624d\u7ec8\u4e8e\u7741\u5f00\u75b2\u5026\u7684[npc.eyes]\u3002");
                }
                sb.append("[npc.name]\u9192\u8fc7\u6765\u770b\u4f60\u7ad9\u5728\u65c1\u8fb9\uff0c\u4fbf\u8fc5\u901f\u7ad9\u8d77\u8eab\u9762\u5411\u4f60\u3002");
                sb.append("</p>");
                sb.append("<p style='text-align:center;'>[style.italicsMinorBad([npc.Name]\u4e0d\u60f3\u88ab\u53eb\u9192\u2026\u2026)]</p>");
                Main.game.appendToTextEndStringBuilder(UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), sb.toString(), new ParserTag[0]));
                Main.game.appendToTextEndStringBuilder(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), -1.0f));
                Main.game.appendToTextEndStringBuilder(SlaveDialogue.getSlaveStartCoreContent());
            }
        };
    }

    private static String getFooterText() {
        if (SlaveDialogue.isDoll()) {
            return "";
        }
        return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "<p><i>" + (SlaveDialogue.getSlave().isAttractedTo(Main.game.getPlayer()) ? "[npc.she]\u5982\u9965\u4f3c\u6e34\u5730\u76ef\u7740\u4f60\u7684\u8eab\u4f53\uff0c\u4f60\u770b\u51fa[npc.sheIs]\u88ab\u4f60\u5438\u5f15\u4e86\u2026\u2026" : "[npc.she]\u4f3c\u4e4e\u5e76\u6ca1\u6709\u88ab\u4f60\u5438\u5f15\u2026\u2026") + "</i></p>", new ParserTag[0]);
    }

    private static boolean isSlaveNaked() {
        return SlaveDialogue.getSlave().isCoverableAreaVisible(CoverableArea.ANUS) && SlaveDialogue.getSlave().isCoverableAreaVisible(CoverableArea.NIPPLES) && SlaveDialogue.getSlave().isCoverableAreaVisible(CoverableArea.PENIS) && SlaveDialogue.getSlave().isCoverableAreaVisible(CoverableArea.VAGINA);
    }

    private static String partInspection() {
        if (SlaveDialogue.getSlave().hasPenis()) {
            if (SlaveDialogue.getSlave().hasVagina()) {
                return "[npc.penis+]\u548c[npc.vagina+]\u4f9b\u4f60\u68c0\u67e5\u3002";
            }
            return "[npc.penis+]\u4f9b\u4f60\u68c0\u67e5\u3002";
        }
        if (SlaveDialogue.getSlave().hasVagina()) {
            return "[npc.vagina+]\u4f9b\u4f60\u68c0\u67e5\u3002";
        }
        return "\u65e0\u6027\u522b\u7684\u4e0b\u4f53\u4f9b\u4f60\u68c0\u67e5\u3002";
    }

    static {
        enslavementWorked = false;
        DEFAULT_ENSLAVEMENT_DIALOGUE = new DialogueNode("\u65b0\u5974\u96b6", "", true){

            @Override
            public void applyPreParsingEffects() {
                if (!SlaveDialogue.getEnslavementTarget().isSlave() && SlaveDialogue.getEnslavementTarget().isAbleToBeEnslaved() && Main.game.getPlayer().isHasSlaverLicense()) {
                    Main.game.getTextEndStringBuilder().append(enslavementTarget.applyEnslavementEffects(Main.game.getPlayer()));
                } else {
                    Main.game.getTextEndStringBuilder().append(enslavementTarget.incrementAffection(Main.game.getPlayer(), -25.0f));
                }
                GameCharacter target = enslavementTarget;
                AbstractClothing enslavementClothing = target.getEnslavementClothing();
                UtilText.addSpecialParsingString(enslavementClothing.getName(), true);
                UtilText.addSpecialParsingString(enslavementClothing.getClothingType().isPlural() != false ? "\u5b83\u4eec" : "\u5b83", false);
                String path = "characters/enslavement";
                if (target instanceof NPCOffspring) {
                    path = "characters/offspring/enslavement";
                }
                if (!target.isSlave() && target.isAbleToBeEnslaved() && Main.game.getPlayer().isHasSlaverLicense()) {
                    if (enslavementClothing.getClothingType().equals(ClothingType.getClothingTypeFromId("innoxia_bdsm_metal_collar"))) {
                        Main.game.appendToTextStartStringBuilder(UtilText.parseFromXMLFile(path, "ENSLAVEMENT_SUCCESS_COLLAR", target));
                    } else {
                        Main.game.appendToTextStartStringBuilder(UtilText.parseFromXMLFile(path, "ENSLAVEMENT_SUCCESS", target));
                    }
                    enslavementWorked = true;
                    Main.game.getPlayer().addSlave((NPC)enslavementTarget);
                    enslavementTarget.setLocation(WorldType.SLAVER_ALLEY, PlaceType.SLAVER_ALLEY_SLAVERY_ADMINISTRATION, true);
                } else {
                    if (target.isSlave()) {
                        Main.game.appendToTextStartStringBuilder(UtilText.parseFromXMLFile(path, "ENSLAVEMENT_FAIL_ALREADY_SLAVE", target));
                    } else if (!target.isAbleToBeEnslaved()) {
                        if (target.getSubspecies() == Subspecies.DEMON) {
                            Main.game.appendToTextStartStringBuilder(UtilText.parseFromXMLFile(path, "ENSLAVEMENT_FAIL_NOT_WANTED_DEMON", target));
                        } else {
                            Main.game.appendToTextStartStringBuilder(UtilText.parseFromXMLFile(path, "ENSLAVEMENT_FAIL_NOT_WANTED", target));
                        }
                    } else {
                        Main.game.appendToTextStartStringBuilder(UtilText.parseFromXMLFile(path, "ENSLAVEMENT_FAIL_NO_LICENSE", target));
                    }
                    enslavementWorked = false;
                }
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    if (enslavementWorked) {
                        return new Response("\u7ee7\u7eed", "\u7ee7\u7eed\u4f60\u7684\u65c5\u7a0b\u3002", SlaveDialogue.getFollowupEnslavementDialogue()){

                            @Override
                            public void effects() {
                            }

                            @Override
                            public DialogueNode getNextDialogue() {
                                return SlaveDialogue.getFollowupEnslavementDialogue();
                            }
                        };
                    }
                    return new Response("\u7ee7\u7eed", UtilText.parse(SlaveDialogue.getEnslavementTarget(), "\u867d\u7136\u4e0d\u8d77\u6548\u679c\uff0c\u4f46\u4f60\u53ef\u6ca1\u60f3\u653e\u8fc7[npc.name]\uff01", new ParserTag[0]), SlaveDialogue.getFollowupEnslavementDialogue());
                }
                return null;
            }
        };
        FREEDOM_DIALOG = new DialogueNode("\u5df2\u91ca\u653e\u5974\u96b6", "", true){

            @Override
            public void applyPreParsingEffects() {
                Main.game.getTextEndStringBuilder().append(enslavementTarget.incrementAffection(Main.game.getPlayer(), -25.0f));
            }

            @Override
            public String getContent() {
                GameCharacter target = enslavementTarget;
                AbstractClothing enslavementClothing = target.getEnslavementClothing();
                UtilText.addSpecialParsingString(enslavementClothing.getName(), true);
                UtilText.addSpecialParsingString(enslavementClothing.getClothingType().isPlural() != false ? "\u5b83\u4eec" : "\u5b83", false);
                return UtilText.parseFromXMLFile("characters/enslavement", "ENSLAVEMENT_FAIL_FREEDOM_CERTIFICATION", target);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u7ee7\u7eed", UtilText.parse(SlaveDialogue.getEnslavementTarget(), "\u867d\u7136\u4e0d\u8d77\u6548\u679c\uff0c\u4f46\u4f60\u53ef\u6ca1\u60f3\u653e\u8fc7[npc.name]\uff01", new ParserTag[0]), SlaveDialogue.getFollowupEnslavementDialogue());
                }
                return null;
            }
        };
        SLAVE_START_NO_CONTENT = new DialogueNode("", "", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return Main.game.getPlayer().getLocationPlace().getName();
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public String getResponseTabTitle(int index) {
                return SLAVE_START.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return SLAVE_START.getResponse(responseTab, index);
            }
        };
        SLAVE_START = new DialogueNode("", "\u3002", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return Main.game.getPlayer().getLocationPlace().getName();
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append("<p>");
                if (SlaveDialogue.getSlave().isAsleep()) {
                    UtilText.nodeContentSB.append("[npc.name]\u73b0\u5728\u6b63\u5728\u7761\u89c9\uff0c\u4f60\u5f97\u5148\u53eb\u9192[npc.herHim]\uff0c\u624d\u80fd\u548c[npc.herHim]\u4e92\u52a8\u3002");
                    UtilText.nodeContentSB.append("\u8fd9\u6837\u505a\u80af\u5b9a\u4f1a\u8ba9[npc.herHim]\u6709\u4e9b\u607c\u706b\u2026\u2026");
                } else if (SlaveDialogue.isDoll()) {
                    UtilText.nodeContentSB.append("\u4f60\u60f3\u8981\u548c[npc.name]\u4e92\u52a8\uff0c\u4fbf[pc.walk]\u5230\u73a9\u5076\u9762\u524d\uff0c\u5f15\u8d77\u4e86[npc.her]\u7684\u6ce8\u610f\u3002");
                    if (SlaveDialogue.isDollStatue()) {
                        UtilText.nodeContentSB.append("\u56e0\u4e3a\u4f60\u547d\u4ee4[npc.herHim]\u626e\u6f14\u96d5\u50cf\uff0c\u6240\u4ee5[npc.she]\u5c3d\u804c\u5c3d\u8d23\u5730\u65e0\u89c6\u4f60\u7684\u9760\u8fd1\uff0c\u5728\u539f\u5730\u4fdd\u6301\u9759\u6b62\u3002");
                    }
                } else {
                    UtilText.nodeContentSB.append("\u4f60\u60f3\u8981\u548c[npc.name]\u4e92\u52a8\uff0c\u4fbf[pc.walk]\u5230[npc.herHim]\u9762\u524d\u5f15\u8d77\u4e86[npc.her]\u7684\u6ce8\u610f\u3002");
                }
                UtilText.nodeContentSB.append("</p>");
                if (!SlaveDialogue.getSlave().isAsleep() && !SlaveDialogue.isDollStatue()) {
                    UtilText.nodeContentSB.append(SlaveDialogue.getSlaveStartCoreContent());
                }
                return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                if (index == 0) {
                    return "\u4e92\u52a8";
                }
                if (index == 1) {
                    return UtilText.parse("[style.colourSex(\u505a\u7231)]", new ParserTag[0]);
                }
                if (index == 2) {
                    return UtilText.parse("[style.colourCompanion(\u7ba1\u7406)]", new ParserTag[0]);
                }
                return null;
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (responseTab == 0) {
                    if (index == 0) {
                        return new Response("\u79bb\u5f00", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), SlaveDialogue.isDollStatue() ? "\u8ba9[npc.name]\u9759\u6b62\u5728\u539f\u5730\uff0c\u7ee7\u7eed\u4f60\u7684\u65c5\u7a0b\u3002" : (SlaveDialogue.getSlave().isAsleep() ? "\u79bb\u5f00\uff0c\u8ba9[npc.name]\u7ee7\u7eed\u7761\u89c9\u2026\u2026" : "\u544a\u8bc9[npc.name]\u4f60\u4f1a\u5728\u5176\u4ed6\u65f6\u95f4\u518d\u53bb\u627e[npc.herHim]\u3002"), new ParserTag[0]), Main.game.getDefaultDialogue(false)){

                            @Override
                            public DialogueNode getNextDialogue() {
                                return Main.game.getDefaultDialogue(false);
                            }

                            @Override
                            public void effects() {
                                Main.game.setResponseTab(0);
                                SlaveDialogue.applyReactionReset();
                                Main.game.getDialogueFlags().setManagementCompanion(null);
                            }
                        };
                    }
                    if (SlaveDialogue.isDollStatue()) {
                        if (index == 1) {
                            return new Response("\u6682\u505c\u626e\u6f14\u96d5\u50cf", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u8ba9[npc.name]\u6682\u65f6\u505c\u6b62\u626e\u6f14\u96d5\u50cf\uff0c\u8fd9\u6837\u4f60\u5c31\u53ef\u4ee5\u4e0e[npc.herHim]\u4e92\u52a8\u4e86\u3002", new ParserTag[0]), SLAVE_START_NO_CONTENT){

                                @Override
                                public void effects() {
                                    dollStatueInterrupted = true;
                                    Main.game.appendToTextEndStringBuilder("<p>");
                                    Main.game.appendToTextEndStringBuilder("\u60f3\u8981\u4e0e[npc.name]\u4e92\u52a8\uff0c\u800c\u4e0d\u60f3\u8ba9[npc.herHim]\u7ee7\u7eed\u50cf\u4e00\u5c0a\u6beb\u65e0\u53cd\u5e94\u7684\u96d5\u50cf\u4e00\u6837\uff0c\u4f60\u5e94\u8be5\u5141\u8bb8[npc.herHim]\u518d\u6b21\u6682\u65f6\u81ea\u7531\u79fb\u52a8\u3002");
                                    Main.game.appendToTextEndStringBuilder("</p>");
                                    Main.game.appendToTextEndStringBuilder(SlaveDialogue.getSlaveStartCoreContent());
                                }
                            };
                        }
                    } else if (SlaveDialogue.getSlave().isAsleep()) {
                        if (index == 1) {
                            return SlaveDialogue.getWakeUpResponse();
                        }
                    } else {
                        if (index == 1) {
                            if (!SlaveDialogue.getSlave().NPCFlagValues.contains((Object)NPCFlagValue.flagSlaveBackground)) {
                                return new Response("\u8fc7\u5f80\u5386\u53f2", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), SlaveDialogue.isDoll() ? "\u95ee[npc.name]\u88ab\u521b\u9020\u65f6\u7684\u8bb0\u5fc6\u3002" : "\u95ee[npc.name]\u8fc7\u53bb\u7684\u751f\u6d3b\u3002", new ParserTag[0]), SLAVE_PROGRESSION){

                                    @Override
                                    public void effects() {
                                        SlaveDialogue.applyReactionReset();
                                        SlaveDialogue.getSlave().NPCFlagValues.add(NPCFlagValue.flagSlaveBackground);
                                        if (!SlaveDialogue.isDoll()) {
                                            Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), 3.0f));
                                        }
                                    }
                                };
                            }
                            return new Response("\u8fc7\u5f80\u5386\u53f2", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u4f60\u4eca\u5929\u5df2\u7ecf\u548c[npc.name]\u804a\u8fc7\u8fd9\u4e2a\u95ee\u9898\u4e86\u2026\u2026", new ParserTag[0]), null);
                        }
                        if (index == 2) {
                            if (!SlaveDialogue.getSlave().NPCFlagValues.contains((Object)NPCFlagValue.flagSlaveSmallTalk)) {
                                return new Response("\u95f2\u804a", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u4e0e[npc.name]\u804a\u8fd9\u804a\u90a3\u3002", new ParserTag[0]), SLAVE_MINOR){

                                    @Override
                                    public void effects() {
                                        SlaveDialogue.applyReactionReset();
                                        SlaveDialogue.getSlave().NPCFlagValues.add(NPCFlagValue.flagSlaveSmallTalk);
                                        if (!SlaveDialogue.isDoll()) {
                                            switch (AffectionLevelBasic.getAffectionLevelFromValue(SlaveDialogue.getSlave().getAffection(Main.game.getPlayer()))) {
                                                case DISLIKE: {
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), -1.0f));
                                                    break;
                                                }
                                                case NEUTRAL: {
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), 2.0f));
                                                    break;
                                                }
                                                case LIKE: {
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), 4.0f));
                                                }
                                            }
                                        }
                                    }
                                };
                            }
                            return new Response("\u95f2\u804a", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u4f60\u4eca\u5929\u5df2\u7ecf\u82b1\u65f6\u95f4\u548c[npc.name]\u804a\u8fc7\u4e86\u3002", new ParserTag[0]), null);
                        }
                        if (index == 3 && SlaveDialogue.getSlave().equals(Main.game.getNpc(Scarlett.class)) && !Main.getProperties().hasValue(PropertyValue.companionContent) && Main.game.getPlayer().getQuest(QuestLine.ROMANCE_HELENA) == Quest.ROMANCE_HELENA_4_SCARLETTS_RETURN) {
                            if (Main.game.getNpc(Helena.class).getLocationPlace().getPlaceType() != PlaceType.SLAVER_ALLEY_SCARLETTS_SHOP) {
                                return new Response("\u6d77\u4f26\u5a1c", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u6d77\u4f26\u5a1c\u7684\u5546\u5e97\u76ee\u524d\u5173\u95ed\uff0c\u56e0\u6b64\u4f60\u6682\u65f6\u65e0\u6cd5\u5e26[npc.Name]\u53bb\u627e\u5979\u2026\u2026", new ParserTag[0]), null);
                            }
                            return new Response("\u6d77\u4f26\u5a1c", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u966a\u540c[npc.Name]\u524d\u5f80\u5974\u96b6\u5df7\u4e2d\u6d77\u4f26\u5a1c\u7684\u5546\u5e97\u3002", new ParserTag[0]), ScarlettsShop.ROMANCE_SHOP_CORE){

                                @Override
                                public Colour getHighlightColour() {
                                    return PresetColour.QUEST_RELATIONSHIP;
                                }

                                @Override
                                public void effects() {
                                    SlaveDialogue.applyReactionReset();
                                    Main.game.getDialogueFlags().setManagementCompanion(null);
                                    Main.game.getPlayer().setLocation(WorldType.SLAVER_ALLEY, PlaceType.SLAVER_ALLEY_SCARLETTS_SHOP);
                                    Main.game.getNpc(Scarlett.class).setLocation(WorldType.SLAVER_ALLEY, PlaceType.SLAVER_ALLEY_SCARLETTS_SHOP);
                                    Main.game.getNpc(Helena.class).setLocation(WorldType.SLAVER_ALLEY, PlaceType.SLAVER_ALLEY_SCARLETTS_SHOP);
                                }
                            };
                        }
                        if (index == 5 && Main.getProperties().hasValue(PropertyValue.companionContent)) {
                            if (!Main.game.getPlayer().hasCompanion(SlaveDialogue.getSlave())) {
                                if (!SlaveDialogue.getSlave().isCompanionAvailable(Main.game.getPlayer())) {
                                    return new Response("\u52a0\u5165\u961f\u4f0d", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "[npc.Name]\u4e0d\u80fd\u52a0\u5165\u4f60\u7684\u961f\u4f0d\uff01", new ParserTag[0]), null);
                                }
                                if (Main.game.getPlayer().canHaveMoreCompanions()) {
                                    return new Response("\u52a0\u5165\u961f\u4f0d", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u547d\u4ee4[npc.name]\u8ddf\u968f\u4f60\u3002", new ParserTag[0]), SLAVE_START){

                                        @Override
                                        public void effects() {
                                            SlaveDialogue.applyReactionReset();
                                            Main.game.getPlayer().addCompanion(SlaveDialogue.getSlave());
                                        }
                                    };
                                }
                                return new Response("\u52a0\u5165\u961f\u4f0d", "\u4f60\u7684\u961f\u4f0d\u6ee1\u5458\u4e86\uff01", null);
                            }
                            return new Response("\u4ece\u961f\u4f0d\u79fb\u9664", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u547d\u4ee4[npc.name]\u4ece\u4f60\u7684\u961f\u4f0d\u91cc\u79bb\u5f00\u3002", new ParserTag[0]), SLAVE_START){

                                @Override
                                public void effects() {
                                    SlaveDialogue.applyReactionReset();
                                    Main.game.getPlayer().removeCompanion(SlaveDialogue.getSlave());
                                }
                            };
                        }
                        if (index == 6) {
                            if (!SlaveDialogue.getSlave().NPCFlagValues.contains((Object)NPCFlagValue.flagSlaveEncourage)) {
                                if (SlaveDialogue.getCurrentJob() == SlaveJob.IDLE) {
                                    return new Response("\u5de5\u4f5c", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "[npc.Name]\u73b0\u5728\u6ca1\u6709\u4efb\u4f55\u5de5\u4f5c\u2026\u2026<br/>[style.italicsMinorBad(\u5728[npc.name]\u65e0\u6240\u4e8b\u4e8b\u7684\u65f6\u5019\uff0c\u4f60\u4e0d\u80fd\u95ee[npc.her]\u5de5\u4f5c\u76f8\u5173\u7684\u4e8b\u60c5\uff01)]", new ParserTag[0]), null);
                                }
                                return new Response("\u5de5\u4f5c", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u8be2\u95ee[npc.name][npc.her]\u7684\u5de5\u4f5c\u5982\u4f55\u3002", new ParserTag[0]), SLAVE_ENCOURAGE){

                                    @Override
                                    public void effects() {
                                        SlaveDialogue.applyReactionReset();
                                        SlaveDialogue.getSlave().NPCFlagValues.add(NPCFlagValue.flagSlaveEncourage);
                                        if (!SlaveDialogue.isDoll()) {
                                            switch (AffectionLevelBasic.getAffectionLevelFromValue(SlaveDialogue.getSlave().getAffection(Main.game.getPlayer()))) {
                                                case DISLIKE: {
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), 0.5f));
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementObedience(0.1f));
                                                    break;
                                                }
                                                case NEUTRAL: {
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), 2.0f));
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementObedience(1.0f));
                                                    break;
                                                }
                                                case LIKE: {
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), 4.0f));
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementObedience(2.0f));
                                                }
                                            }
                                        }
                                    }
                                };
                            }
                            return new Response("\u5de5\u4f5c", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u4f60\u5df2\u7ecf\u95ee\u8fc7[npc.name][npc.her]\u7684\u5de5\u4f5c\u4e86\u3002", new ParserTag[0]), null);
                        }
                        if (index == 7) {
                            if (!SlaveDialogue.getSlave().NPCFlagValues.contains((Object)NPCFlagValue.flagSlaveHug)) {
                                return new Response("\u62e5\u62b1", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u62e5\u62b1[npc.name]\u3002", new ParserTag[0]), SLAVE_HUG){

                                    @Override
                                    public void effects() {
                                        SlaveDialogue.applyReactionReset();
                                        SlaveDialogue.getSlave().NPCFlagValues.add(NPCFlagValue.flagSlaveHug);
                                        if (!SlaveDialogue.isDoll()) {
                                            switch (AffectionLevelBasic.getAffectionLevelFromValue(SlaveDialogue.getSlave().getAffection(Main.game.getPlayer()))) {
                                                case DISLIKE: {
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), -2.0f));
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementObedience(-1.0f));
                                                    break;
                                                }
                                                case NEUTRAL: {
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), 2.0f));
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementObedience(-1.0f));
                                                    break;
                                                }
                                                case LIKE: {
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), 5.0f));
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementObedience(-2.0f));
                                                }
                                            }
                                        }
                                    }
                                };
                            }
                            return new Response("\u62e5\u62b1", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u4f60\u4eca\u5929\u5df2\u7ecf\u82b1\u65f6\u95f4\u62e5\u62b1[npc.name]\u4e86\u3002", new ParserTag[0]), null);
                        }
                        if (index == 8) {
                            if (!SlaveDialogue.getSlave().NPCFlagValues.contains((Object)NPCFlagValue.flagSlavePettings)) {
                                return new Response("\u7231\u629a", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u7ed9[npc.name]\u5145\u6ee1\u7231\u7684\u629a\u6478\u3002", new ParserTag[0]), SLAVE_PETTINGS){

                                    @Override
                                    public void effects() {
                                        SlaveDialogue.applyReactionReset();
                                        SlaveDialogue.getSlave().NPCFlagValues.add(NPCFlagValue.flagSlavePettings);
                                        if (!SlaveDialogue.isDoll()) {
                                            switch (AffectionLevelBasic.getAffectionLevelFromValue(SlaveDialogue.getSlave().getAffection(Main.game.getPlayer()))) {
                                                case DISLIKE: {
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), -2.0f));
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementObedience(-1.0f));
                                                    break;
                                                }
                                                case NEUTRAL: {
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), 2.0f));
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementObedience(-1.0f));
                                                    break;
                                                }
                                                case LIKE: {
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), 5.0f));
                                                    Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementObedience(-2.0f));
                                                }
                                            }
                                        }
                                    }
                                };
                            }
                            return new Response("\u7231\u629a", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u4f60\u4eca\u5929\u5df2\u7ecf\u82b1\u65f6\u95f4\u7231\u629a[npc.name]\u4e86\u3002", new ParserTag[0]), null);
                        }
                        if (index == 9) {
                            if (Main.game.getPlayer().hasItemType(ItemType.PRESENT)) {
                                if (SlaveDialogue.isDoll()) {
                                    return new Response("\u8d60\u9001\u793c\u7269", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u4f5c\u4e3a\u4e00\u4e2a\u73a9\u5076\uff0c[npc.name]\u4e0d\u9700\u8981\u4e5f\u4e0d\u559c\u6b22\u793c\u7269\u2026\u2026", new ParserTag[0]), null);
                                }
                                return new Response("\u8d60\u9001\u793c\u7269", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u628a\u4f60\u643a\u5e26\u7684\u793c\u7269\u4ea4\u7ed9[npc.name]\u3002", new ParserTag[0]), SLAVE_PRESENT){

                                    @Override
                                    public void effects() {
                                        SlaveDialogue.applyReactionReset();
                                        Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.PRESENT));
                                        if (!SlaveDialogue.isDoll()) {
                                            Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), 10.0f));
                                            Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementObedience(-2.0f));
                                        }
                                    }
                                };
                            }
                            return null;
                        }
                        if (index == 11) {
                            if (!SlaveDialogue.getSlave().NPCFlagValues.contains((Object)NPCFlagValue.flagSlaveInspect)) {
                                return new Response("\u68c0\u67e5", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u8ba9[npc.name]\u8131\u5149\u8863\u670d\uff0c\u5728\u623f\u95f4\u91cc\u7ed5\u5708\u5e76\u63a5\u53d7\u4f60\u7684\u68c0\u67e5\u3002", new ParserTag[0]), SLAVE_INSPECT){

                                    @Override
                                    public void effects() {
                                        SlaveDialogue.applyReactionReset();
                                        SlaveDialogue.getSlave().NPCFlagValues.add(NPCFlagValue.flagSlaveInspect);
                                        SlaveDialogue.getSlave().setAreaKnownByCharacter(CoverableArea.ANUS, Main.game.getPlayer(), true);
                                        SlaveDialogue.getSlave().setAreaKnownByCharacter(CoverableArea.ASS, Main.game.getPlayer(), true);
                                        SlaveDialogue.getSlave().setAreaKnownByCharacter(CoverableArea.BREASTS, Main.game.getPlayer(), true);
                                        SlaveDialogue.getSlave().setAreaKnownByCharacter(CoverableArea.MOUND, Main.game.getPlayer(), true);
                                        SlaveDialogue.getSlave().setAreaKnownByCharacter(CoverableArea.MOUTH, Main.game.getPlayer(), true);
                                        SlaveDialogue.getSlave().setAreaKnownByCharacter(CoverableArea.NIPPLES, Main.game.getPlayer(), true);
                                        SlaveDialogue.getSlave().setAreaKnownByCharacter(CoverableArea.PENIS, Main.game.getPlayer(), true);
                                        SlaveDialogue.getSlave().setAreaKnownByCharacter(CoverableArea.TESTICLES, Main.game.getPlayer(), true);
                                        SlaveDialogue.getSlave().setAreaKnownByCharacter(CoverableArea.VAGINA, Main.game.getPlayer(), true);
                                        if (!SlaveDialogue.isDoll()) {
                                            if (SlaveDialogue.getSlave().getFetishDesire(Fetish.FETISH_MASOCHIST).isPositive() || SlaveDialogue.getSlave().getFetishDesire(Fetish.FETISH_EXHIBITIONIST).isPositive()) {
                                                Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), 10.0f));
                                            } else {
                                                Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), -5.0f));
                                            }
                                            Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementObedience(5.0f));
                                        }
                                    }
                                };
                            }
                            return new Response("\u68c0\u67e5", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u4f60\u4eca\u5929\u5df2\u7ecf\u82b1\u65f6\u95f4\u68c0\u67e5[npc.name]\u4e86\u3002", new ParserTag[0]), null);
                        }
                        if (index == 12) {
                            if (!SlaveDialogue.getSlave().NPCFlagValues.contains((Object)NPCFlagValue.flagSlaveSpanking)) {
                                return new Response("\u6253\u5c41\u80a1", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u628a[npc.name]\u6309\u5728\u4f60\u819d\u76d6\u4e0a\uff0c\u7c97\u66b4\u5730\u6253[npc.herHim]\u7684\u5c41\u80a1\u3002", new ParserTag[0]), SLAVE_SPANKING){

                                    @Override
                                    public void effects() {
                                        SlaveDialogue.applyReactionReset();
                                        SlaveDialogue.getSlave().NPCFlagValues.add(NPCFlagValue.flagSlaveSpanking);
                                        if (!SlaveDialogue.isDoll()) {
                                            if (SlaveDialogue.getSlave().getFetishDesire(Fetish.FETISH_MASOCHIST).isPositive()) {
                                                Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), 10.0f));
                                            } else {
                                                Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), -5.0f));
                                            }
                                            Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementObedience(10.0f));
                                        }
                                    }
                                };
                            }
                            return new Response("\u6253\u5c41\u80a1", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u4f60\u4eca\u5929\u5df2\u7ecf\u6253\u8fc7[npc.name]\u7684\u5c41\u80a1\u4e86\u3002", new ParserTag[0]), null);
                        }
                        if (index == 13) {
                            if (!SlaveDialogue.getSlave().NPCFlagValues.contains((Object)NPCFlagValue.flagSlaveMolest)) {
                                return new Response("\u7325\u4eb5", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u7325\u4eb5[npc.name]\u7684\u8eab\u4f53\uff0c\u5e76\u8ba9[npc.her]\u4fdd\u6301\u4e0d\u52a8\u3002", new ParserTag[0]), SLAVE_MOLEST){

                                    @Override
                                    public void effects() {
                                        SlaveDialogue.applyReactionReset();
                                        SlaveDialogue.getSlave().NPCFlagValues.add(NPCFlagValue.flagSlaveMolest);
                                        if (!SlaveDialogue.isDoll()) {
                                            if (SlaveDialogue.getSlave().isAttractedTo(Main.game.getPlayer()) && (SlaveDialogue.getSlave().hasFetish(Fetish.FETISH_SUBMISSIVE) || SlaveDialogue.getSlave().hasFetish(Fetish.FETISH_NON_CON_SUB))) {
                                                Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), 10.0f));
                                            } else if (!(SlaveDialogue.getSlave().isAttractedTo(Main.game.getPlayer()) || SlaveDialogue.getSlave().hasFetish(Fetish.FETISH_SUBMISSIVE) || SlaveDialogue.getSlave().hasFetish(Fetish.FETISH_NON_CON_SUB))) {
                                                Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementAffection(Main.game.getPlayer(), -10.0f));
                                            }
                                            Main.game.getTextEndStringBuilder().append(SlaveDialogue.getSlave().incrementObedience(10.0f));
                                        }
                                    }
                                };
                            }
                            return new Response("\u7325\u4eb5", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u4f60\u4eca\u5929\u5df2\u7ecf\u7325\u4eb5\u8fc7[npc.name]\u4e86\u3002", new ParserTag[0]), null);
                        }
                    }
                    return null;
                }
                if (responseTab == 1) {
                    if (index == 0) {
                        return new Response("\u79bb\u5f00", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), SlaveDialogue.isDollStatue() ? "\u8ba9[npc.name]\u9759\u6b62\u5728\u539f\u5730\uff0c\u7ee7\u7eed\u4f60\u7684\u65c5\u7a0b\u3002" : (SlaveDialogue.getSlave().isAsleep() ? "\u8ba9[npc.name]\u7ee7\u7eed\u7761\u89c9\u2026\u2026" : "\u544a\u8bc9[npc.name]\u4f60\u4f1a\u5728\u5176\u4ed6\u65f6\u95f4\u518d\u53bb\u627e[npc.herHim]\u3002"), new ParserTag[0]), Main.game.getDefaultDialogue(false)){

                            @Override
                            public DialogueNode getNextDialogue() {
                                return Main.game.getDefaultDialogue(false);
                            }

                            @Override
                            public void effects() {
                                Main.game.setResponseTab(0);
                                SlaveDialogue.applyReactionReset();
                                Main.game.getDialogueFlags().setManagementCompanion(null);
                            }
                        };
                    }
                    if (Main.game.getPlayer().getLocationPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM)) {
                        if (index == 1) {
                            if (!(characterForSex.isSlave() && characterForSex.getOwner().isPlayer() || characterForSex.isAttractedTo(Main.game.getPlayer()))) {
                                return new Response("\u505a\u7231", UtilText.parse((GameCharacter)characterForSex, "[npc.Name]\u6ca1\u88ab\u4f60\u5438\u5f15\uff0c\u4f60\u4e0d\u80fd\u5f3a\u8feb[npc.herHim]\u548c\u4f60\u505a\u7231\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (Main.game.isNonConEnabled() && !characterForSex.isAttractedTo(Main.game.getPlayer())) {
                                return new ResponseSex("\u5f3a\u5978", UtilText.parse((GameCharacter)characterForSex, "[npc.Name]\u663e\u7136\u4e0d\u60f3\u8ddf\u4f60\u505a\u7231\uff0c[npc.sheHasFull]\u4f3c\u4e4e\u522b\u65e0\u9009\u62e9\u2026\u2026", new ParserTag[0]), false, false, new SMMilkingStall(Util.newHashMapOfValues(new Util.Value<PlayerCharacter, SexSlot>(Main.game.getPlayer(), SexSlotMilkingStall.BEHIND_MILKING_STALL)), Util.newHashMapOfValues(new Util.Value<NPC, SexSlot>(characterForSex, SexSlotMilkingStall.LOCKED_IN_MILKING_STALL))), SlaveDialogue.getDominantSpectators(), SlaveDialogue.getSubmissiveSpectators(), SlaveDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(SlaveDialogue.getTextFilePath(), "RAPE_START_MILKING_ROOM", characterForSex)){

                                    @Override
                                    public void effects() {
                                        SlaveDialogue.applyReactionReset();
                                        if (!characterForSex.isDoll()) {
                                            if (characterForSex.getFetishDesire(Fetish.FETISH_NON_CON_SUB).isPositive()) {
                                                Main.game.getTextEndStringBuilder().append(characterForSex.incrementAffection(Main.game.getPlayer(), 5.0f));
                                            } else {
                                                Main.game.getTextEndStringBuilder().append(characterForSex.incrementAffection(Main.game.getPlayer(), -25.0f));
                                            }
                                        }
                                    }
                                };
                            }
                            return new ResponseSex("\u505a\u7231", UtilText.parse((GameCharacter)characterForSex, "\u548c[npc.name]\u505a\u7231\u3002", new ParserTag[0]), true, false, new SMMilkingStall(Util.newHashMapOfValues(new Util.Value<PlayerCharacter, SexSlot>(Main.game.getPlayer(), SexSlotMilkingStall.BEHIND_MILKING_STALL)), Util.newHashMapOfValues(new Util.Value<NPC, SexSlot>(characterForSex, SexSlotMilkingStall.LOCKED_IN_MILKING_STALL))), SlaveDialogue.getDominantSpectators(), SlaveDialogue.getSubmissiveSpectators(), SlaveDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(SlaveDialogue.getTextFilePath(), "SEX_START_MILKING_ROOM", characterForSex)){

                                @Override
                                public void effects() {
                                    SlaveDialogue.applyReactionReset();
                                    if (!characterForSex.isDoll()) {
                                        Main.game.getTextEndStringBuilder().append(characterForSex.incrementAffection(Main.game.getPlayer(), 5.0f));
                                    }
                                }
                            };
                        }
                    } else if (SlaveDialogue.getSlave().isAsleep()) {
                        if (index == 1) {
                            if (!(characterForSex.isSlave() && characterForSex.getOwner().isPlayer() || characterForSex.isAttractedTo(Main.game.getPlayer()))) {
                                return new Response("\u7761\u5978", UtilText.parse((GameCharacter)characterForSex, "[npc.Name]\u6ca1\u88ab\u4f60\u5438\u5f15\uff0c\u4f60\u4e0d\u80fd\u5f3a\u8feb[npc.herHim]\u548c\u4f60\u505a\u7231\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (Main.game.isNonConEnabled() && !characterForSex.isAttractedTo(Main.game.getPlayer())) {
                                if (!SlaveDialogue.getSlave().hasTrait(Perk.HEAVY_SLEEPER, true)) {
                                    return new Response("\u7761\u5978", UtilText.parse((GameCharacter)characterForSex, "[npc.Name]\u5e76\u4e0d\u662f\u91cd\u5ea6\u6c89\u7761\u8005\uff0c\u56e0\u6b64\u4f60\u4e0d\u80fd\u5bf9[npc.herHim]\u8fdb\u884c\u7761\u5978\u2026\u2026", new ParserTag[0]), null);
                                }
                                return new ResponseSex("\u7761\u5978", UtilText.parse((GameCharacter)characterForSex, "[npc.Name]\u663e\u7136\u4e0d\u60f3\u8ddf\u4f60\u505a\u7231\uff0c\u4f46[npc.sheHasFull]\u4f3c\u4e4e\u522b\u65e0\u9009\u62e9\u2026\u2026\u56e0\u4e3a[npc.sheIs]\u662f\u4e2a\u91cd\u5ea6\u6c89\u7761\u8005\uff0c\u4f60\u53ef\u4ee5\u5728\u4e0d\u5435\u9192[npc.herHim]\u7684\u524d\u63d0\u4e0b\u6e29\u67d4\u5730\u64cd[npc.herHim]\u2026\u2026", new ParserTag[0]), false, false, SlaveDialogue.getGenericSlaveSexManager(Util.newArrayListOfValues(Main.game.getPlayer()), Util.newArrayListOfValues(characterForSex), new ArrayList<GameCharacter>(), new ArrayList<GameCharacter>(), Util.newArrayListOfValues(ResponseTag.PREFER_MISSIONARY), false, Util.newHashMapOfValues(new Util.Value<PlayerCharacter, SexPace>(Main.game.getPlayer(), SexPace.DOM_GENTLE))), SlaveDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(SlaveDialogue.getTextFilePath(), "RAPE_START", characterForSex)){

                                    @Override
                                    public void effects() {
                                        SlaveDialogue.applyReactionReset();
                                    }
                                };
                            }
                            if (!SlaveDialogue.getSlave().hasTrait(Perk.HEAVY_SLEEPER, true)) {
                                return new Response("\u7761\u5978", UtilText.parse((GameCharacter)characterForSex, "[npc.Name]\u5e76\u4e0d\u662f\u91cd\u5ea6\u6c89\u7761\u8005\uff0c\u56e0\u6b64\u4f60\u4e0d\u80fd\u5bf9[npc.herHim]\u8fdb\u884c\u7761\u5978\u2026\u2026", new ParserTag[0]), null);
                            }
                            return new ResponseSex("\u7761\u5978", UtilText.parse((GameCharacter)characterForSex, "\u56e0\u4e3a[npc.sheIs]\u662f\u4e2a\u91cd\u5ea6\u6c89\u7761\u8005\uff0c\u4f60\u53ef\u4ee5\u5728\u4e0d\u5435\u9192[npc.herHim]\u7684\u524d\u63d0\u4e0b\u6e29\u67d4\u5730\u64cd[npc.herHim]\u2026\u2026", new ParserTag[0]), true, false, SlaveDialogue.getGenericSlaveSexManager(Util.newArrayListOfValues(Main.game.getPlayer()), Util.newArrayListOfValues(characterForSex), new ArrayList<GameCharacter>(), new ArrayList<GameCharacter>(), Util.newArrayListOfValues(ResponseTag.PREFER_MISSIONARY), false, Util.newHashMapOfValues(new Util.Value<PlayerCharacter, SexPace>(Main.game.getPlayer(), SexPace.DOM_GENTLE))), SlaveDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(SlaveDialogue.getTextFilePath(), "SEX_START", characterForSex)){

                                @Override
                                public void effects() {
                                    SlaveDialogue.applyReactionReset();
                                }
                            };
                        }
                    } else {
                        if (index == 1) {
                            if (!(characterForSex.isSlave() && characterForSex.getOwner().isPlayer() || characterForSex.isAttractedTo(Main.game.getPlayer()))) {
                                return new Response("\u505a\u7231", UtilText.parse((GameCharacter)characterForSex, "[npc.Name]\u6ca1\u88ab\u4f60\u5438\u5f15\uff0c\u4f60\u4e0d\u80fd\u5f3a\u8feb[npc.herHim]\u548c\u4f60\u505a\u7231\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (Main.game.isNonConEnabled() && !characterForSex.isAttractedTo(Main.game.getPlayer())) {
                                return new ResponseSex("\u5f3a\u5978", UtilText.parse((GameCharacter)characterForSex, "[npc.Name]\u663e\u7136\u4e0d\u60f3\u8ddf\u4f60\u505a\u7231\uff0c[npc.sheHasFull]\u4f3c\u4e4e\u522b\u65e0\u9009\u62e9\u2026\u2026", new ParserTag[0]), false, false, SlaveDialogue.getGenericSlaveSexManager(Util.newArrayListOfValues(Main.game.getPlayer()), Util.newArrayListOfValues(characterForSex), characterForSex.hasSlavePermissionSetting(SlavePermissionSetting.GENERAL_CRAWLING) ? Util.newArrayListOfValues(ResponseTag.PREFER_DOGGY) : new ArrayList<ResponseTag>(), false), SlaveDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(SlaveDialogue.getTextFilePath(), "RAPE_START", characterForSex)){

                                    @Override
                                    public void effects() {
                                        SlaveDialogue.applyReactionReset();
                                        if (!characterForSex.isDoll()) {
                                            if (characterForSex.getFetishDesire(Fetish.FETISH_NON_CON_SUB).isPositive()) {
                                                Main.game.getTextEndStringBuilder().append(characterForSex.incrementAffection(Main.game.getPlayer(), 5.0f));
                                            } else {
                                                Main.game.getTextEndStringBuilder().append(characterForSex.incrementAffection(Main.game.getPlayer(), -25.0f));
                                            }
                                        }
                                    }
                                };
                            }
                            return new ResponseSex("\u505a\u7231", UtilText.parse((GameCharacter)characterForSex, "\u548c[npc.name]\u505a\u7231\u3002", new ParserTag[0]), true, false, SlaveDialogue.getGenericSlaveSexManager(Util.newArrayListOfValues(Main.game.getPlayer()), Util.newArrayListOfValues(characterForSex), SlaveDialogue.isDollStatue() ? Util.newArrayListOfValues(SlaveDialogue.getDollSexTag()) : (characterForSex.hasSlavePermissionSetting(SlavePermissionSetting.GENERAL_CRAWLING) ? Util.newArrayListOfValues(ResponseTag.PREFER_DOGGY) : new ArrayList<ResponseTag>()), false), SlaveDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(SlaveDialogue.getTextFilePath(), "SEX_START", characterForSex)){

                                @Override
                                public void effects() {
                                    SlaveDialogue.applyReactionReset();
                                    if (!characterForSex.isDoll()) {
                                        Main.game.getTextEndStringBuilder().append(characterForSex.incrementAffection(Main.game.getPlayer(), 5.0f));
                                    }
                                }
                            };
                        }
                        if (index == 2) {
                            if (characterForSexSecondary == null || charactersPresent.size() < 2) {
                                return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", "\u5f97\u6709\u7b2c\u4e09\u4e2a\u4eba\u5728\u573a\uff0c\u4f60\u624d\u80fd\u5f00\u59cb\u201c\u4e32\u8089\u4e32\u201d\u2026\u2026", null);
                            }
                            if (characterForSex.isPlayer()) {
                                return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", "\u4f60\u4e0d\u80fd\u4ee5\u81ea\u5df1\u4e3a\u76ee\u6807\u5e94\u7528\u8fd9\u4e2a\u52a8\u4f5c\uff01", null);
                            }
                            if (characterForSexSecondary.isDollStatue()) {
                                return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSexSecondary, "[npc.name]\u662f\u4e00\u4e2a\u65e0\u6cd5\u79fb\u52a8\u7684\u73a9\u5076\uff0c\u4e0d\u80fd\u5728\u505a\u7231\u4e2d\u5360\u636e\u652f\u914d\u5730\u4f4d\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (characterForSexSecondary.isAsleep()) {
                                return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSexSecondary, "[npc.name]\u73b0\u5728\u5b8c\u5168\u7761\u7740\u4e86\uff0c\u4e0d\u80fd\u53c2\u4e0e\u505a\u7231\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (!characterForSexSecondary.isAttractedTo(characterForSex)) {
                                return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.Name]\u5bf9[npc2.name]\u4e0d\u611f\u5174\u8da3\uff0c\u56e0\u6b64\u4e0d\u53ef\u80fd\u8ba9[npc.herHim]\u5360\u636e\u4e3b\u5bfc\u5730\u4f4d\u4e0e[npc2.herHim]\u505a\u7231\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (!(Main.game.isNonConEnabled() && characterForSex.isSlave() || characterForSex.isAttractedTo(Main.game.getPlayer()))) {
                                return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSex, "[npc.Name]\u5bf9\u4f60\u6ca1\u6709\u5174\u8da3\uff0c\u56e0\u6b64\u4e0d\u613f\u610f\u5728[npc.she]\u4e0e\u4f60\u4e09\u4eba\u884c\u7684\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (!(Main.game.isNonConEnabled() && characterForSex.isSlave() || characterForSex.isAttractedTo(characterForSexSecondary))) {
                                return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc2.Name]\u5bf9[npc.name]\u6ca1\u6709\u5174\u8da3\uff0c\u56e0\u6b64\u4e0d\u613f\u610f\u53c2\u4e0e[npc2.she]\u4e0e[npc.herHim]\u7684\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                            }
                            boolean isRape = !characterForSex.isAttractedTo(Main.game.getPlayer()) && !characterForSex.isAttractedTo(characterForSexSecondary);
                            return new ResponseSex(isRape ? "\u201c\u4e32\u8089\u4e32\u201d\u5f3a\u5978(\u5728\u524d)" : "\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSex, characterForSexSecondary, "\u79fb\u52a8\u5230[npc.name]\u524d\u9762\uff0c[npc2.name]\u73a9\u5f04[npc.her]\u7684\u65f6\u5019\uff0c\u4f60\u53ef\u4ee5\u4f7f\u7528[npc.her]\u7684\u5634\u3002", new ParserTag[0]), null, null, null, null, null, null, !isRape, false, SlaveDialogue.getGenericSlaveSexManager(Util.newArrayListOfValues(characterForSexSecondary, Main.game.getPlayer()), Util.newArrayListOfValues(characterForSex), Util.newArrayListOfValues(ResponseTag.PREFER_DOGGY), false), SlaveDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(SlaveDialogue.getThreesomeTextFilePath(), "SEX_SPITROAST_FRONT_START", characterForSex, characterForSexSecondary)){

                                @Override
                                public void effects() {
                                    SlaveDialogue.applyReactionReset();
                                }
                            };
                        }
                        if (index == 3) {
                            if (characterForSexSecondary == null || charactersPresent.size() < 2) {
                                return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", "\u5f97\u6709\u7b2c\u4e09\u4e2a\u4eba\u5728\u573a\uff0c\u4f60\u624d\u80fd\u5f00\u59cb\u201c\u4e32\u8089\u4e32\u201d\u2026\u2026", null);
                            }
                            if (characterForSex.isPlayer()) {
                                return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", "\u4f60\u4e0d\u80fd\u4ee5\u81ea\u5df1\u4e3a\u76ee\u6807\u5e94\u7528\u8fd9\u4e2a\u52a8\u4f5c\uff01", null);
                            }
                            if (characterForSexSecondary.isDollStatue()) {
                                return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse((GameCharacter)characterForSexSecondary, "[npc.name]\u662f\u4e00\u4e2a\u65e0\u6cd5\u79fb\u52a8\u7684\u73a9\u5076\uff0c\u4e0d\u80fd\u5728\u505a\u7231\u4e2d\u5360\u636e\u652f\u914d\u5730\u4f4d\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (characterForSexSecondary.isAsleep()) {
                                return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse((GameCharacter)characterForSexSecondary, "[npc.name]\u73b0\u5728\u5b8c\u5168\u7761\u7740\u4e86\uff0c\u4e0d\u80fd\u53c2\u4e0e\u505a\u7231\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (!characterForSexSecondary.isAttractedTo(characterForSex)) {
                                return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.Name]\u5bf9[npc2.name]\u4e0d\u611f\u5174\u8da3\uff0c\u56e0\u6b64\u4e0d\u53ef\u80fd\u8ba9[npc.herHim]\u5360\u636e\u4e3b\u5bfc\u5730\u4f4d\u4e0e[npc2.herHim]\u505a\u7231\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (!(Main.game.isNonConEnabled() && characterForSex.isSlave() || characterForSex.isAttractedTo(Main.game.getPlayer()))) {
                                return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse((GameCharacter)characterForSex, "[npc.Name]\u5bf9\u4f60\u6ca1\u6709\u5174\u8da3\uff0c\u56e0\u6b64\u4e0d\u613f\u610f\u5728[npc.she]\u4e0e\u4f60\u4e09\u4eba\u884c\u7684\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (!(Main.game.isNonConEnabled() && characterForSex.isSlave() || characterForSex.isAttractedTo(characterForSexSecondary))) {
                                return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc2.Name]\u5bf9[npc.name]\u6ca1\u6709\u5174\u8da3\uff0c\u56e0\u6b64\u4e0d\u613f\u610f\u53c2\u4e0e[npc2.she]\u4e0e[npc.herHim]\u7684\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                            }
                            boolean isRape = !characterForSex.isAttractedTo(Main.game.getPlayer()) && !characterForSex.isAttractedTo(characterForSexSecondary);
                            return new ResponseSex(isRape ? "\u201c\u4e32\u8089\u4e32\u201d\u5f3a\u5978(\u5728\u540e)" : "\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse((GameCharacter)characterForSex, characterForSexSecondary, "\u79fb\u52a8\u5230[npc.name]\u80cc\u540e\uff0c[npc2.name]\u4f7f\u7528[npc.her]\u7684\u5634\u7684\u65f6\u5019\uff0c\u4f60\u53ef\u4ee5\u73a9\u5f04[npc.her]\u7684\u540e\u9762\u3002", new ParserTag[0]), null, null, null, null, null, null, !isRape, false, SlaveDialogue.getGenericSlaveSexManager(Util.newArrayListOfValues(Main.game.getPlayer(), characterForSexSecondary), Util.newArrayListOfValues(characterForSex), Util.newArrayListOfValues(ResponseTag.PREFER_DOGGY), false), SlaveDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(SlaveDialogue.getThreesomeTextFilePath(), "SEX_SPITROAST_BEHIND_START", characterForSex, characterForSexSecondary)){

                                @Override
                                public void effects() {
                                    SlaveDialogue.applyReactionReset();
                                }
                            };
                        }
                        if (index == 4) {
                            if (characterForSexSecondary == null || charactersPresent.size() < 2) {
                                return new Response("\u5e76\u6392\u540e\u5165(\u4f5c\u4e3a\u652f\u914d\u65b9)", "\u5f97\u6709\u7b2c\u4e09\u4e2a\u4eba\u5728\u573a\uff0c\u4f60\u624d\u80fd\u5f00\u59cb\u5e76\u6392\u540e\u5165\u2026\u2026", null);
                            }
                            if (characterForSex.isPlayer()) {
                                return new Response("\u5e76\u6392\u540e\u5165(\u4f5c\u4e3a\u652f\u914d\u65b9)", "\u4f60\u4e0d\u80fd\u4ee5\u81ea\u5df1\u4e3a\u76ee\u6807\u5e94\u7528\u8fd9\u4e2a\u52a8\u4f5c\uff01", null);
                            }
                            if (characterForSexSecondary.isAsleep()) {
                                return new Response("\u5e76\u6392\u540e\u5165(\u4f5c\u4e3a\u652f\u914d\u65b9)", UtilText.parse((GameCharacter)characterForSexSecondary, "[npc.name]\u73b0\u5728\u5b8c\u5168\u7761\u7740\u4e86\uff0c\u4e0d\u80fd\u53c2\u4e0e\u505a\u7231\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (!(Main.game.isNonConEnabled() && characterForSexSecondary.isSlave() || characterForSexSecondary.isAttractedTo(Main.game.getPlayer()))) {
                                return new Response("\u5e76\u6392\u540e\u5165(\u4f5c\u4e3a\u652f\u914d\u65b9)", UtilText.parse((GameCharacter)characterForSexSecondary, "[npc.Name]\u5bf9\u4f60\u6ca1\u6709\u5174\u8da3\uff0c\u56e0\u6b64\u4e0d\u613f\u610f\u5728[npc.she]\u4e0e\u4f60\u4e09\u4eba\u884c\u7684\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (!(Main.game.isNonConEnabled() && characterForSex.isSlave() || characterForSex.isAttractedTo(Main.game.getPlayer()))) {
                                return new Response("\u5e76\u6392\u540e\u5165(\u4f5c\u4e3a\u652f\u914d\u65b9)", UtilText.parse((GameCharacter)characterForSex, "[npc.Name]\u5bf9\u4f60\u6ca1\u6709\u5174\u8da3\uff0c\u56e0\u6b64\u4e0d\u613f\u610f\u5728[npc.she]\u4e0e\u4f60\u4e09\u4eba\u884c\u7684\u2026\u2026", new ParserTag[0]), null);
                            }
                            boolean isRape = !characterForSex.isAttractedTo(Main.game.getPlayer()) || !characterForSexSecondary.isAttractedTo(Main.game.getPlayer());
                            return new ResponseSex(isRape ? "\u5e76\u6392\u540e\u5165(\u5f3a\u5978)(\u5728\u4e0a)" : "\u5e76\u6392\u540e\u5165(\u5728\u4e0a)", UtilText.parse((GameCharacter)characterForSex, characterForSexSecondary, "\u8ba9[npc.name]\u548c[npc2.name]\u56db\u4f53\u6295\u5730\uff0c\u8dea\u5728[npc.Name]\u8eab\u540e\uff0c\u51c6\u5907\u5e76\u6392\u540e\u5165\u4ed6\u4eec\u3002", new ParserTag[0]), null, null, null, null, null, null, !isRape, false, SlaveDialogue.getGenericSlaveSexManager(Util.newArrayListOfValues(Main.game.getPlayer()), Util.newArrayListOfValues(characterForSex, characterForSexSecondary), Util.newArrayListOfValues(ResponseTag.PREFER_DOGGY), false), SlaveDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(SlaveDialogue.getThreesomeTextFilePath(), "SEX_SIDE_BY_SIDE_START", characterForSex, characterForSexSecondary)){

                                @Override
                                public void effects() {
                                    SlaveDialogue.applyReactionReset();
                                }
                            };
                        }
                        if (index == 5) {
                            if (charactersPresent.size() < 3) {
                                return new Response("\u4e00\u53d7\u591a\u653b(\u4f5c\u4e3a\u652f\u914d\u65b9)", "\u81f3\u5c11\u8981\u6709\u4e09\u4e2a\u89d2\u8272\u5728\u573a\u624d\u80fd\u5f00\u59cb\u7fa4\u4ea4\u3002", null);
                            }
                            if (charactersPresent.stream().anyMatch(c -> c.isAsleep())) {
                                boolean soloSleeper = charactersPresent.stream().filter(c -> c.isAsleep()).count() == 1L;
                                String names = Util.charactersToStringListOfNames(charactersPresent.stream().filter(c -> c.isAsleep()).collect(Collectors.toList()));
                                return new Response("\u4e00\u53d7\u591a\u653b(\u4f5c\u4e3a\u652f\u914d\u65b9)", names + "\u9700\u8981\u9192\u6765\u624d\u80fd\u7fa4\u4ea4\uff01", null);
                            }
                            boolean isRape = charactersPresent.stream().anyMatch(c -> !c.isAttractedTo(Main.game.getPlayer()));
                            if (isRape) {
                                if (charactersPresent.stream().anyMatch(c -> !c.isSlave())) {
                                    ArrayList<GameCharacter> nonSlaves = new ArrayList<GameCharacter>();
                                    for (GameCharacter gameCharacter : charactersPresent) {
                                        if (gameCharacter.isSlave() || gameCharacter.isAttractedTo(Main.game.getPlayer())) continue;
                                        nonSlaves.add(gameCharacter);
                                    }
                                    String isAre = nonSlaves.size() == 1 ? "is" : "are";
                                    String string = nonSlaves.size() == 1 ? "slave" : "slaves";
                                    String them = nonSlaves.size() == 1 ? UtilText.parse((GameCharacter)nonSlaves.get(0), "[npc.herHim]", new ParserTag[0]) : "\u4ed6\u4eec";
                                    return new Response("\u4e00\u53d7\u591a\u653b(\u4f5c\u4e3a\u652f\u914d\u65b9)", "\u7531\u4e8e" + Util.charactersToStringListOfNames(nonSlaves) + " " + isAre + " \u5bf9\u4f60\u4e0d\u611f\u5174\u8da3\uff0c\u5e76\u4e14" + isAre + "\u4e0d\u662f\u4f60\u7684" + string + "\uff0c\u4f60\u4e0d\u80fd\u4e0e" + them + "\u8fdb\u884c\u7fa4\u4ea4\u3002", null);
                                }
                                if (!Main.game.isNonConEnabled()) {
                                    ArrayList<GameCharacter> nonAttracted = new ArrayList<GameCharacter>();
                                    for (GameCharacter gameCharacter : charactersPresent) {
                                        if (gameCharacter.isAttractedTo(Main.game.getPlayer())) continue;
                                        nonAttracted.add(gameCharacter);
                                    }
                                    String isAre = nonAttracted.size() == 1 ? "is" : "are";
                                    String string = nonAttracted.size() == 1 ? UtilText.parse((GameCharacter)nonAttracted.get(0), "[npc.herHim]", new ParserTag[0]) : "\u4ed6\u4eec";
                                    return new Response("\u4e00\u53d7\u591a\u653b(\u4f5c\u4e3a\u652f\u914d\u65b9)", "\u7531\u4e8e" + Util.charactersToStringListOfNames(nonAttracted) + " " + (String)isAre + " \u5bf9\u4f60\u4e0d\u611f\u5174\u8da3\uff0c\u4f60\u4e0d\u80fd\u4e0e" + string + "\u8fdb\u884c\u7fa4\u4ea4\u3002", null);
                                }
                            }
                            ArrayList<GameCharacter> nonAttracted = new ArrayList<GameCharacter>();
                            for (GameCharacter gameCharacter : charactersPresent) {
                                if (gameCharacter.isAttractedTo(Main.game.getPlayer())) continue;
                                nonAttracted.add(gameCharacter);
                            }
                            String isAre = nonAttracted.size() == 1 ? "is" : "are";
                            String string = nonAttracted.size() == 1 ? UtilText.parse((GameCharacter)nonAttracted.get(0), "[npc.herHim]", new ParserTag[0]) : "\u4ed6\u4eec";
                            ArrayList<GameCharacter> sexParticipants = new ArrayList<GameCharacter>(charactersPresent);
                            return new ResponseSex(isRape ? "\u8f6e\u5978(\u4f5c\u4e3a\u652f\u914d\u65b9)" : "\u4e00\u53d7\u591a\u653b(\u4f5c\u4e3a\u652f\u914d\u65b9)", "\u540c" + Util.charactersToStringListOfNames(sexParticipants) + "\u505a\u7231\u3002" + (String)(isRape ? "\u7531\u4e8e" + Util.charactersToStringListOfNames(nonAttracted) + "\u6ca1\u88ab\u4f60\u5438\u5f15\uff0c\u4f60\u5fc5\u987b\u5f3a\u8feb" + string + "\u52a0\u5165\u2026\u2026" : ""), null, null, null, null, null, null, !isRape, false, SlaveDialogue.getGenericSlaveSexManager(Util.newArrayListOfValues(Main.game.getPlayer()), sexParticipants, Util.newArrayListOfValues(new ResponseTag[0]), false), SlaveDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(SlaveDialogue.getThreesomeTextFilePath(), sexParticipants.size() == 3 ? "SEX_GANGBANG_3" : "SEX_GANGBANG_4", sexParticipants)){

                                @Override
                                public void effects() {
                                    SlaveDialogue.applyReactionReset();
                                }
                            };
                        }
                        if (index == 6) {
                            if (characterForSex.isDollStatue()) {
                                return new Response("\u670d\u4ece\u578b\u6027\u7231", UtilText.parse((GameCharacter)characterForSex, "[npc.name]\u662f\u4e00\u4e2a\u65e0\u6cd5\u79fb\u52a8\u7684\u73a9\u5076\uff0c\u4e0d\u80fd\u5728\u505a\u7231\u4e2d\u5360\u636e\u652f\u914d\u5730\u4f4d\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (!characterForSex.isAttractedTo(Main.game.getPlayer())) {
                                return new Response("\u670d\u4ece\u578b\u6027\u7231", UtilText.parse((GameCharacter)characterForSex, "[npc.Name]\u5bf9\u4f60\u4e0d\u611f\u5174\u8da3\uff0c" + (Main.game.isNonConEnabled() && characterForSex.isSlave() ? " \u6240\u4ee5\u5982\u679c\u4f60\u60f3\u548c[npc.herHim]\u53d1\u751f\u6027\u5173\u7cfb\uff0c\u5c31\u9700\u8981\u4f5c\u4e3a\u4e3b\u5bfc\u8005\u5f3a\u5978[npc.herHim]\u3002" : "\u6240\u4ee5\u4f60\u4e0d\u80fd\u4e0e[npc.herHim]\u8fdb\u884c\u670d\u4ece\u578b\u6027\u7231\u3002"), new ParserTag[0]), null);
                            }
                            return new ResponseSex("\u670d\u4ece\u6027\u7231", UtilText.parse((GameCharacter)characterForSex, "\u548c[npc.name]\u6765\u4e00\u573a\u670d\u4ece\u578b\u6027\u7231\u3002", new ParserTag[0]), Util.newArrayListOfValues(Fetish.FETISH_SUBMISSIVE), null, Fetish.FETISH_SUBMISSIVE.getAssociatedCorruptionLevel(), null, null, null, true, true, SlaveDialogue.getGenericSlaveSexManager(Util.newArrayListOfValues(characterForSex), Util.newArrayListOfValues(Main.game.getPlayer()), characterForSex.hasSlavePermissionSetting(SlavePermissionSetting.GENERAL_CRAWLING) ? Util.newArrayListOfValues(ResponseTag.PREFER_DOGGY) : new ArrayList<ResponseTag>(), false), SlaveDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(SlaveDialogue.getTextFilePath(), "SEX_AS_SUB_START", characterForSex)){

                                @Override
                                public void effects() {
                                    SlaveDialogue.applyReactionReset();
                                    if (!characterForSex.isDoll()) {
                                        Main.game.getTextEndStringBuilder().append(characterForSex.incrementAffection(Main.game.getPlayer(), 5.0f));
                                    }
                                }
                            };
                        }
                        if (index == 7) {
                            if (characterForSexSecondary == null || charactersPresent.size() < 2) {
                                return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", "\u5f97\u6709\u7b2c\u4e09\u4e2a\u4eba\u5728\u573a\uff0c\u4f60\u624d\u80fd\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d\u2026\u2026", null);
                            }
                            if (characterForSex.isPlayer()) {
                                return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", "\u4f60\u4e0d\u80fd\u4ee5\u81ea\u5df1\u4e3a\u76ee\u6807\u5e94\u7528\u8fd9\u4e2a\u52a8\u4f5c\uff01", null);
                            }
                            if (characterForSex.isDollStatue()) {
                                return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSex, "[npc.name]\u662f\u4e00\u4e2a\u65e0\u6cd5\u79fb\u52a8\u7684\u73a9\u5076\uff0c\u4e0d\u80fd\u5728\u505a\u7231\u4e2d\u5360\u636e\u652f\u914d\u5730\u4f4d\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (characterForSexSecondary.isAsleep()) {
                                return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSexSecondary, "[npc.name]\u73b0\u5728\u5b8c\u5168\u7761\u7740\u4e86\uff0c\u4e0d\u80fd\u53c2\u4e0e\u505a\u7231\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (characterForSexSecondary.isDollStatue()) {
                                return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSexSecondary, "[npc.name]\u662f\u4e00\u4e2a\u65e0\u6cd5\u79fb\u52a8\u7684\u73a9\u5076\uff0c\u4e0d\u80fd\u5728\u505a\u7231\u4e2d\u5360\u636e\u652f\u914d\u5730\u4f4d\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (!characterForSex.isAttractedTo(Main.game.getPlayer())) {
                                if (!characterForSexSecondary.isAttractedTo(Main.game.getPlayer())) {
                                    return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.name]\u548c[npc2.name]\u90fd\u5bf9\u4f60\u4e0d\u611f\u5174\u8da3\uff0c" + (Main.game.isNonConEnabled() && characterForSexSecondary.isSlave() ? "\u6240\u4ee5\uff0c\u5982\u679c\u4f60\u60f3\u548c\u4ed6\u4eec\u8fdb\u884c\u6027\u5173\u7cfb\uff0c\u4f60\u5c31\u5fc5\u987b\u4ee5\u652f\u914d\u8005\u7684\u8eab\u4efd\u5f3a\u5978\u4ed6\u4eec\u3002" : "\u6240\u4ee5\u4f60\u4e0d\u80fd\u548c\u4ed6\u4eec\u8fdb\u884c\u670d\u4ece\u578b\u6027\u7231\u3002"), new ParserTag[0]), null);
                                }
                                return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSex, "[npc.Name]\u5bf9\u4f60\u4e0d\u611f\u5174\u8da3\uff0c" + (Main.game.isNonConEnabled() ? " \u6240\u4ee5\u5982\u679c\u4f60\u60f3\u548c[npc.herHim]\u53d1\u751f\u6027\u5173\u7cfb\uff0c\u5c31\u9700\u8981\u4f5c\u4e3a\u4e3b\u5bfc\u8005\u5f3a\u5978[npc.herHim]\u3002" : "\u6240\u4ee5\u4f60\u4e0d\u80fd\u4e0e[npc.herHim]\u8fdb\u884c\u670d\u4ece\u578b\u6027\u7231\u3002"), new ParserTag[0]), null);
                            }
                            if (!characterForSexSecondary.isAttractedTo(Main.game.getPlayer())) {
                                return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSexSecondary, "[npc.Name]\u5bf9\u4f60\u4e0d\u611f\u5174\u8da3\uff0c" + (Main.game.isNonConEnabled() && characterForSexSecondary.isSlave() ? " \u6240\u4ee5\u5982\u679c\u4f60\u60f3\u548c[npc.herHim]\u53d1\u751f\u6027\u5173\u7cfb\uff0c\u5c31\u9700\u8981\u4f5c\u4e3a\u4e3b\u5bfc\u8005\u5f3a\u5978[npc.herHim]\u3002" : "\u6240\u4ee5\u4f60\u4e0d\u80fd\u4e0e[npc.herHim]\u8fdb\u884c\u670d\u4ece\u578b\u6027\u7231\u3002"), new ParserTag[0]), null);
                            }
                            return new ResponseSex("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u524d)", UtilText.parse((GameCharacter)characterForSex, characterForSexSecondary, "\u4f60\u56db\u80a2\u7740\u5730\uff0c\u9762\u671d[npc.name]\uff0c[npc2.name]\u73a9\u5f04\u4f60\u7684\u540e\u9762\u7684\u65f6\u5019\uff0c[npc.she]\u5c31\u53ef\u4ee5\u4f7f\u7528\u4f60\u7684\u5634\u4e86\u3002", new ParserTag[0]), null, null, null, null, null, null, true, true, SlaveDialogue.getGenericSlaveSexManager(Util.newArrayListOfValues(characterForSexSecondary, characterForSex), Util.newArrayListOfValues(Main.game.getPlayer()), Util.newArrayListOfValues(ResponseTag.PREFER_DOGGY), false), SlaveDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(SlaveDialogue.getThreesomeTextFilePath(), "SEX_SPITROASTED_START", characterForSex, characterForSexSecondary)){

                                @Override
                                public void effects() {
                                    SlaveDialogue.applyReactionReset();
                                }
                            };
                        }
                        if (index == 8) {
                            if (characterForSexSecondary == null || charactersPresent.size() < 2) {
                                return new Response("\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", "\u5f97\u6709\u7b2c\u4e09\u4e2a\u4eba\u5728\u573a\uff0c\u4f60\u624d\u80fd\u5f00\u59cb\u201c\u4e32\u8089\u4e32\u201d\u2026\u2026", null);
                            }
                            if (characterForSex.isPlayer()) {
                                return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", "\u4f60\u4e0d\u80fd\u4ee5\u81ea\u5df1\u4e3a\u76ee\u6807\u5e94\u7528\u8fd9\u4e2a\u52a8\u4f5c\uff01", null);
                            }
                            if (characterForSex.isDollStatue()) {
                                return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse((GameCharacter)characterForSex, "[npc.name]\u662f\u4e00\u4e2a\u65e0\u6cd5\u79fb\u52a8\u7684\u73a9\u5076\uff0c\u4e0d\u80fd\u5728\u505a\u7231\u4e2d\u5360\u636e\u652f\u914d\u5730\u4f4d\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (characterForSexSecondary.isDollStatue()) {
                                return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse((GameCharacter)characterForSexSecondary, "[npc.name]\u662f\u4e00\u4e2a\u65e0\u6cd5\u79fb\u52a8\u7684\u73a9\u5076\uff0c\u4e0d\u80fd\u5728\u505a\u7231\u4e2d\u5360\u636e\u652f\u914d\u5730\u4f4d\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (characterForSexSecondary.isAsleep()) {
                                return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse((GameCharacter)characterForSexSecondary, "[npc.name]\u73b0\u5728\u5b8c\u5168\u7761\u7740\u4e86\uff0c\u4e0d\u80fd\u53c2\u4e0e\u505a\u7231\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (!characterForSex.isAttractedTo(Main.game.getPlayer())) {
                                if (!characterForSexSecondary.isAttractedTo(Main.game.getPlayer())) {
                                    return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.name]\u548c[npc2.name]\u90fd\u5bf9\u4f60\u4e0d\u611f\u5174\u8da3\uff0c" + (Main.game.isNonConEnabled() && characterForSexSecondary.isSlave() ? "\u6240\u4ee5\uff0c\u5982\u679c\u4f60\u60f3\u548c\u4ed6\u4eec\u8fdb\u884c\u6027\u5173\u7cfb\uff0c\u4f60\u5c31\u5fc5\u987b\u4ee5\u652f\u914d\u8005\u7684\u8eab\u4efd\u5f3a\u5978\u4ed6\u4eec\u3002" : "\u6240\u4ee5\u4f60\u4e0d\u80fd\u548c\u4ed6\u4eec\u8fdb\u884c\u670d\u4ece\u578b\u6027\u7231\u3002"), new ParserTag[0]), null);
                                }
                                return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse((GameCharacter)characterForSex, "[npc.Name]\u5bf9\u4f60\u4e0d\u611f\u5174\u8da3\uff0c" + (Main.game.isNonConEnabled() ? " \u6240\u4ee5\u5982\u679c\u4f60\u60f3\u548c[npc.herHim]\u53d1\u751f\u6027\u5173\u7cfb\uff0c\u5c31\u9700\u8981\u4f5c\u4e3a\u4e3b\u5bfc\u8005\u5f3a\u5978[npc.herHim]\u3002" : "\u6240\u4ee5\u4f60\u4e0d\u80fd\u4e0e[npc.herHim]\u8fdb\u884c\u670d\u4ece\u578b\u6027\u7231\u3002"), new ParserTag[0]), null);
                            }
                            if (!characterForSexSecondary.isAttractedTo(Main.game.getPlayer())) {
                                return new Response("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse((GameCharacter)characterForSexSecondary, "[npc.Name]\u5bf9\u4f60\u4e0d\u611f\u5174\u8da3\uff0c" + (Main.game.isNonConEnabled() && characterForSexSecondary.isSlave() ? " \u6240\u4ee5\u5982\u679c\u4f60\u60f3\u548c[npc.herHim]\u53d1\u751f\u6027\u5173\u7cfb\uff0c\u5c31\u9700\u8981\u4f5c\u4e3a\u4e3b\u5bfc\u8005\u5f3a\u5978[npc.herHim]\u3002" : "\u6240\u4ee5\u4f60\u4e0d\u80fd\u4e0e[npc.herHim]\u8fdb\u884c\u670d\u4ece\u578b\u6027\u7231\u3002"), new ParserTag[0]), null);
                            }
                            return new ResponseSex("\u63a5\u53d7\u201c\u4e32\u8089\u4e32\u201d(\u5728\u540e)", UtilText.parse((GameCharacter)characterForSex, characterForSexSecondary, "\u4f60\u56db\u80a2\u8dea\u5730\uff0c\u5c06\u8eab\u540e\u5c55\u73b0\u7ed9[npc.name]\uff0c\u8fd9\u6837\u5728[npc.she]\u5e72\u4f60\u7684\u65f6\u5019[npc2.name]\u53ef\u4ee5\u540c\u65f6\u4f7f\u7528\u4f60\u7684\u5634\u5df4\u3002", new ParserTag[0]), null, null, null, null, null, null, true, true, SlaveDialogue.getGenericSlaveSexManager(Util.newArrayListOfValues(characterForSex, characterForSexSecondary), Util.newArrayListOfValues(Main.game.getPlayer()), Util.newArrayListOfValues(ResponseTag.PREFER_DOGGY), false), SlaveDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(SlaveDialogue.getThreesomeTextFilePath(), "SEX_SPITROASTED_START", characterForSexSecondary, characterForSex)){

                                @Override
                                public void effects() {
                                    SlaveDialogue.applyReactionReset();
                                }
                            };
                        }
                        if (index == 9) {
                            if (characterForSexSecondary == null || charactersPresent.size() < 2) {
                                return new Response("\u5e76\u6392\u540e\u5165(\u5728\u4e0b)", UtilText.parse((GameCharacter)characterForSex, "\u4f60\u9700\u8981\u7b2c\u4e09\u4e2a\u4eba\u5728\u573a\uff0c\u624d\u80fd\u88ab\u4ed6\u4eec\u6216\u8005[npc.name]\u64cd\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (characterForSex.isPlayer()) {
                                return new Response("\u5e76\u6392\u540e\u5165(\u4f5c\u4e3a\u670d\u4ece\u65b9)", "\u4f60\u4e0d\u80fd\u4ee5\u81ea\u5df1\u4e3a\u76ee\u6807\u5e94\u7528\u8fd9\u4e2a\u52a8\u4f5c\uff01", null);
                            }
                            if (characterForSex.isDollStatue()) {
                                return new Response("\u5e76\u6392\u540e\u5165(\u4f5c\u4e3a\u670d\u4ece\u65b9)", UtilText.parse((GameCharacter)characterForSex, "[npc.name]\u662f\u4e00\u4e2a\u65e0\u6cd5\u79fb\u52a8\u7684\u73a9\u5076\uff0c\u4e0d\u80fd\u5728\u505a\u7231\u4e2d\u5360\u636e\u652f\u914d\u5730\u4f4d\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (characterForSexSecondary.isDollStatue()) {
                                return new Response("\u5e76\u6392\u540e\u5165(\u4f5c\u4e3a\u670d\u4ece\u65b9)", UtilText.parse((GameCharacter)characterForSexSecondary, "[npc.name]\u662f\u4e00\u4e2a\u65e0\u6cd5\u79fb\u52a8\u7684\u73a9\u5076\uff0c\u4e0d\u80fd\u5728\u505a\u7231\u4e2d\u5360\u636e\u652f\u914d\u5730\u4f4d\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (characterForSexSecondary.isAsleep()) {
                                return new Response("\u5e76\u6392\u540e\u5165(\u4f5c\u4e3a\u670d\u4ece\u65b9)", UtilText.parse((GameCharacter)characterForSexSecondary, "[npc.name]\u73b0\u5728\u5b8c\u5168\u7761\u7740\u4e86\uff0c\u4e0d\u80fd\u53c2\u4e0e\u505a\u7231\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (!characterForSex.isAttractedTo(Main.game.getPlayer())) {
                                if (!characterForSexSecondary.isAttractedTo(Main.game.getPlayer())) {
                                    return new Response("\u5e76\u6392\u540e\u5165(\u5728\u4e0b)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.name]\u548c[npc2.name]\u90fd\u6ca1\u88ab\u4f60\u5438\u5f15\u2026\u2026", new ParserTag[0]), null);
                                }
                                return new Response("\u5e76\u6392\u540e\u5165(\u5728\u4e0b)", UtilText.parse((GameCharacter)characterForSex, "[npc.Name]\u6ca1\u88ab\u4f60\u5438\u5f15\uff0c\u4e0d\u60f3\u53c2\u52a0\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (!characterForSexSecondary.isAttractedTo(Main.game.getPlayer())) {
                                return new Response("\u5e76\u6392\u540e\u5165(\u5728\u4e0b)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.Name]\u6ca1\u88ab\u4f60\u5438\u5f15\uff0c[npc.she]\u548c[npc2.name]\u90fd\u4e0d\u613f\u610f\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (!characterForSexSecondary.isAttractedTo(characterForSex)) {
                                return new Response("\u5e76\u6392\u540e\u5165(\u4f5c\u4e3a\u670d\u4ece\u65b9)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc.Name]\u6ca1\u88ab[npc2.name]\u5438\u5f15\uff0c\u4ed6\u4eec\u4e0d\u60f3\u5f7c\u6b64\u63a5\u89e6\uff0c\u6240\u4ee5\u90fd\u4e0d\u4f1a\u53c2\u52a0\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (!characterForSex.isAttractedTo(characterForSexSecondary)) {
                                return new Response("\u5e76\u6392\u540e\u5165(\u4f5c\u4e3a\u670d\u4ece\u65b9)", UtilText.parse((GameCharacter)characterForSexSecondary, characterForSex, "[npc2.name]\u6ca1\u88ab[npc2.name]\u5438\u5f15\uff0c\u4ed6\u4eec\u4e0d\u60f3\u5f7c\u6b64\u63a5\u89e6\uff0c\u6240\u4ee5\u90fd\u4e0d\u4f1a\u53c2\u52a0\u4e09\u4eba\u884c\u2026\u2026", new ParserTag[0]), null);
                            }
                            return new ResponseSex("\u5e76\u6392\u540e\u5165(\u5728\u4e0b)", UtilText.parse((GameCharacter)characterForSex, characterForSexSecondary, "\u5728[npc2.name]\u8eab\u8fb9\u56db\u80a2\u8dea\u5730\uff0c\u8fd9\u6837[npc.name]\u5c31\u53ef\u4ee5\u8dea\u5728\u4f60\u4eec\u8eab\u540e\uff0c\u8ddf\u6328\u5728\u4e00\u8d77\u7684\u4f60\u4eec\u4e24\u4e2a\u505a\u7231\u4e86\u3002", new ParserTag[0]), null, null, null, null, null, null, true, false, SlaveDialogue.getGenericSlaveSexManager(Util.newArrayListOfValues(characterForSex), Util.newArrayListOfValues(Main.game.getPlayer(), characterForSexSecondary), Util.newArrayListOfValues(ResponseTag.PREFER_DOGGY), false), SlaveDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(SlaveDialogue.getThreesomeTextFilePath(), "SEX_SIDE_BY_SIDE_AS_SUB_START", characterForSex, characterForSexSecondary)){

                                @Override
                                public void effects() {
                                    SlaveDialogue.applyReactionReset();
                                }
                            };
                        }
                        if (index == 10) {
                            if (charactersPresent.size() < 3) {
                                return new Response("\u4e00\u53d7\u591a\u653b(\u4f5c\u4e3a\u670d\u4ece\u65b9)", "\u81f3\u5c11\u8981\u6709\u4e09\u4e2a\u89d2\u8272\u5728\u573a\u624d\u80fd\u5f00\u59cb\u7fa4\u4ea4\u3002", null);
                            }
                            if (charactersPresent.stream().anyMatch(c -> c.isDollStatue())) {
                                return new Response("\u4e00\u53d7\u591a\u653b(\u4f5c\u4e3a\u670d\u4ece\u65b9)", UtilText.parse((GameCharacter)charactersPresent.stream().filter(c -> c.isDollStatue()).findFirst().get(), "[npc.name]\u662f\u4e00\u4e2a\u65e0\u6cd5\u79fb\u52a8\u7684\u73a9\u5076\uff0c\u4e0d\u80fd\u5728\u505a\u7231\u4e2d\u5360\u636e\u652f\u914d\u5730\u4f4d\u2026\u2026", new ParserTag[0]), null);
                            }
                            if (charactersPresent.stream().anyMatch(c -> c.isAsleep())) {
                                boolean soloSleeper = charactersPresent.stream().filter(c -> c.isAsleep()).count() == 1L;
                                String names = Util.charactersToStringListOfNames(charactersPresent.stream().filter(c -> c.isAsleep()).collect(Collectors.toList()));
                                return new Response("\u4e00\u53d7\u591a\u653b(\u4f5c\u4e3a\u670d\u4ece\u65b9)", names + "\u9700\u8981\u9192\u6765\u624d\u80fd\u7fa4\u4ea4\uff01", null);
                            }
                            boolean isRape = charactersPresent.stream().anyMatch(c -> !c.isAttractedTo(Main.game.getPlayer()));
                            if (isRape) {
                                ArrayList<GameCharacter> nonAttracted = new ArrayList<GameCharacter>();
                                for (GameCharacter gameCharacter : charactersPresent) {
                                    if (gameCharacter.isAttractedTo(Main.game.getPlayer())) continue;
                                    nonAttracted.add(gameCharacter);
                                }
                                String isAre = nonAttracted.size() == 1 ? "is" : "are";
                                String string = nonAttracted.size() == 1 ? UtilText.parse((GameCharacter)nonAttracted.get(0), "[npc.herHim]", new ParserTag[0]) : "\u4ed6\u4eec";
                                return new Response("\u4e00\u53d7\u591a\u653b(\u4f5c\u4e3a\u670d\u4ece\u65b9)", "\u7531\u4e8e" + Util.charactersToStringListOfNames(nonAttracted) + " " + (String)isAre + " \u4e0d\u88ab\u4f60\u5438\u5f15\uff0c\u4f60\u4e0d\u80fd\u8ba9" + string + "\u5728\u7fa4\u4ea4\u4e2d\u5360\u636e\u4e3b\u5bfc\u3002", null);
                            }
                            ArrayList<GameCharacter> sexParticipants = new ArrayList<GameCharacter>(charactersPresent);
                            return new ResponseSex("\u4e00\u53d7\u591a\u653b(\u4f5c\u4e3a\u670d\u4ece\u65b9)", "\u8ba9" + Util.charactersToStringListOfNames(sexParticipants) + "\u5360\u636e\u4e3b\u5bfc\u5730\u4f4d\uff0c\u5e76\u8ba9\u5979\u4eec\u4e0e\u4f60\u5f00\u5c55\u7fa4\u4ea4\u3002", null, null, null, null, null, null, true, false, SlaveDialogue.getGenericSlaveSexManager(sexParticipants, Util.newArrayListOfValues(Main.game.getPlayer()), Util.newArrayListOfValues(new ResponseTag[0]), true), SlaveDialogue.getAfterSexDialogue(), UtilText.parseFromXMLFile(SlaveDialogue.getThreesomeTextFilePath(), sexParticipants.size() == 3 ? "SEX_GANGBANG_AS_SUB_3" : "SEX_GANGBANG_AS_SUB_4", sexParticipants)){

                                @Override
                                public void effects() {
                                    SlaveDialogue.applyReactionReset();
                                }
                            };
                        }
                        if (index == 11) {
                            if (characterForSexSecondary != null) {
                                return new ResponseEffectsOnly(UtilText.parse((GameCharacter)characterForSex, "\u76ee\u6807\uff1a<b style='color:" + characterForSex.getFemininity().getColour().toWebHexString() + ";'>[npc.Name]</b>", new ParserTag[0]), "\u5faa\u73af\u5207\u6362\u9009\u62e9\u7fa4\u4ea4\u89d2\u8272\u3002"){

                                    @Override
                                    public void effects() {
                                        if (charactersPresent.size() > 1) {
                                            for (int i = 0; i < charactersPresent.size(); ++i) {
                                                if (!charactersPresent.get(i).equals(characterForSex)) continue;
                                                if (i == charactersPresent.size() - 1) {
                                                    characterForSex = charactersPresent.get(0);
                                                    if (!characterForSexSecondary.equals(characterForSex)) continue;
                                                    characterForSexSecondary = charactersPresent.get(1);
                                                    continue;
                                                }
                                                characterForSex = charactersPresent.get(i + 1);
                                                if (!characterForSexSecondary.equals(characterForSex)) break;
                                                characterForSexSecondary = charactersPresent.get(i + 2 < charactersPresent.size() ? i + 2 : 0);
                                                break;
                                            }
                                        }
                                        Main.game.updateResponses();
                                    }
                                };
                            }
                            return new Response(UtilText.parse((GameCharacter)characterForSex, "\u76ee\u6807\uff1a<b>[npc.Name]</b>", new ParserTag[0]), "\u5faa\u73af\u5207\u6362\u9009\u62e9\u7fa4\u4ea4\u76ee\u6807\u89d2\u8272\u3002<br/>[style.italicsBad(\u82e5\u8981\u89e3\u9501\u8be5\u52a8\u4f5c\uff0c\u9700\u8981\u5e26\u7740\u4e00\u540d\u540c\u4f34\uff01)]", null);
                        }
                        if (index == 12) {
                            if (characterForSexSecondary != null) {
                                return new ResponseEffectsOnly(UtilText.parse((GameCharacter)characterForSexSecondary, "\u6b21\u76ee\u6807\uff1a<b style='color:" + characterForSexSecondary.getFemininity().getColour().toWebHexString() + ";'>[npc.Name]</b>", new ParserTag[0]), "\u5faa\u73af\u5207\u6362\u9009\u62e9\u7fa4\u4ea4\u6b21\u76ee\u6807\u89d2\u8272\u3002"){

                                    @Override
                                    public void effects() {
                                        if (charactersPresent.size() > 1) {
                                            for (int i = 0; i < charactersPresent.size(); ++i) {
                                                if (!charactersPresent.get(i).equals(characterForSexSecondary)) continue;
                                                if (i == charactersPresent.size() - 1) {
                                                    characterForSexSecondary = charactersPresent.get(0);
                                                    if (!characterForSexSecondary.equals(characterForSex)) break;
                                                    characterForSex = charactersPresent.get(1);
                                                    break;
                                                }
                                                characterForSexSecondary = charactersPresent.get(i + 1);
                                                if (!characterForSexSecondary.equals(characterForSex)) break;
                                                characterForSex = charactersPresent.get(i + 2 < charactersPresent.size() ? i + 2 : 0);
                                                break;
                                            }
                                        }
                                        Main.game.updateResponses();
                                    }
                                };
                            }
                            return new Response(UtilText.parse((GameCharacter)characterForSex, "\u6b21\u76ee\u6807\uff1a<b>[npc.Name]</b>", new ParserTag[0]), "\u5faa\u73af\u5207\u6362\u9009\u62e9\u7fa4\u4ea4\u6b21\u76ee\u6807\u89d2\u8272\u3002<br/>[style.italicsBad(\u82e5\u8981\u89e3\u9501\u8be5\u52a8\u4f5c\uff0c\u9700\u8981\u5e26\u7740\u4e00\u540d\u540c\u4f34\uff01)]", null);
                        }
                    }
                    return null;
                }
                if (responseTab == 2) {
                    if (SlaveDialogue.isDollStatue()) {
                        if (index == 1) {
                            return new Response("\u6682\u505c\u626e\u6f14\u96d5\u50cf", UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u8ba9[npc.name]\u6682\u65f6\u505c\u6b62\u626e\u6f14\u96d5\u50cf\uff0c\u8fd9\u6837\u4f60\u5c31\u53ef\u4ee5\u7ba1\u7406[npc.herHim]\u4e86\u3002", new ParserTag[0]), SLAVE_START_NO_CONTENT){

                                @Override
                                public void effects() {
                                    dollStatueInterrupted = true;
                                    Main.game.appendToTextEndStringBuilder("<p>");
                                    Main.game.appendToTextEndStringBuilder("\u60f3\u8981\u4e0e[npc.name]\u4e92\u52a8\uff0c\u800c\u4e0d\u60f3\u8ba9[npc.herHim]\u7ee7\u7eed\u50cf\u4e00\u5c0a\u6beb\u65e0\u53cd\u5e94\u7684\u96d5\u50cf\u4e00\u6837\uff0c\u4f60\u5e94\u8be5\u5141\u8bb8[npc.herHim]\u518d\u6b21\u6682\u65f6\u81ea\u7531\u79fb\u52a8\u3002");
                                    Main.game.appendToTextEndStringBuilder("</p>");
                                    Main.game.appendToTextEndStringBuilder(SlaveDialogue.getSlaveStartCoreContent());
                                }
                            };
                        }
                        if (index == 0) {
                            return CompanionManagement.getManagementResponses(index);
                        }
                        return null;
                    }
                    if (SlaveDialogue.getSlave().isAsleep()) {
                        if (index == 1) {
                            return SlaveDialogue.getWakeUpResponse();
                        }
                        if (index == 0) {
                            return CompanionManagement.getManagementResponses(index);
                        }
                        return null;
                    }
                    return CompanionManagement.getManagementResponses(index);
                }
                return null;
            }
        };
        SLAVE_PROGRESSION = new DialogueNode("", "", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u4e0e[npc.Name]\u4ea4\u8c08", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                if (SlaveDialogue.isDoll()) {
                    UtilText.nodeContentSB.append("<p>\u4f60\u60f3\u8981\u4e86\u89e3[npc.Name]\u7684\u770b\u6cd5\uff0c\u95ee\u4e86\u95ee[npc.she]\u88ab\u521b\u9020\u65f6\u7684\u8bb0\u5fc6</p><p>[npc.speech(\u62b1\u6b49[pc.name]\uff0c\u4f46\u6211\u5df2\u7ecf\u8bb0\u4e0d\u6e05\u4e86)]\uff0c[npc.she]\u56de\u7b54\u9053\uff0c[npc.speech(\u6211\u6700\u521d\u7684\u8bb0\u5fc6\u662f\uff0c\u6211\u88ab\u547d\u4ee4\u548c\u5176\u4ed6\u5341\u51e0\u4e2a\u73a9\u5076\u7ad9\u5728\u4e00\u8d77\uff0c\u7b49\u7740\u88ab\u5356\u6389\u3002)]</p><p>\u770b\u6837\u5b50\uff0c[npc.Name]\u4f3c\u4e4e\u65e0\u6cd5\u63d0\u4f9b\u4efb\u4f55\u8d5b\u62c9\u7279\u91cc\u514b\u65af\u672a\u66fe\u544a\u8bc9\u8fc7\u4f60\u7684\u4fe1\u606f\uff0c\u6240\u4ee5\u4f60\u51b3\u5b9a\u4e0d\u518d\u5c31\u8fd9\u4e2a\u95ee\u9898\u6d6a\u8d39\u65f6\u95f4\u63d0\u95ee\u2026\u2026</p>");
                } else {
                    UtilText.nodeContentSB.append("<p><i>\u8fd8\u6ca1\u505a\u5b8c\uff01</i></p><p>\u4f60\u51b3\u5b9a\u8981\u548c[npc.Name]\u8c08\u4e00\u4e9b\u66f4\u4e25\u8083\u7684\u8bdd\u9898\uff0c\u4e8e\u662f\u4f60\u5411[npc.herHim]\u8be2\u95ee\u4e86[npc.her]\u5728\u6210\u4e3a\u4f60\u7684\u5974\u96b6\u4e4b\u524d\u7684\u751f\u6d3b\uff0c[pc.speech(\u6211\u60f3\u4e86\u89e3\u4e00\u4e0b\u4f60\u7684\u8fc7\u53bb\uff0c[npc.name]\u3002\u6765\u8fd9\u91cc\u4e4b\u524d\uff0c\u4f60\u7684\u751f\u6d3b\u662f\u600e\u6837\u7684\uff1f)]</p><p>");
                    block0 : switch (AffectionLevelBasic.getAffectionLevelFromValue(SlaveDialogue.getSlave().getAffection(Main.game.getPlayer()))) {
                        case DISLIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.her]\u7684[npc.eyes]\u4e2d\u6d41\u9732\u51fa\u5f3a\u70c8\u7684\u4ec7\u6068\u795e\u60c5\uff0c[npc.she]\u8fc5\u901f\u505a\u51fa\u4e86\u65e0\u793c\u7684\u56de\u5e94\uff0c[npc.speech(\u6eda\u4f60\u5988\u7684\uff01\u8bf4\u5f97\u597d\u50cf\u6211\u4f1a\u8ddf\u4f60\u8c08\u8fd9\u4e9b\u4f3c\u7684\uff01\u50bb\u903c\uff01)]");
                                    break;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("\u867d\u7136[npc.she]\u6781\u529b\u63a9\u9970\uff0c\u4f46\u5728[npc.she]\u8bf4\u8bdd\u65f6\uff0c\u4f60\u8fd8\u662f\u770b\u5230\u4e86[npc.her][npc.eyes]\u91cc\u660e\u663e\u7684\u4ec7\u6068\u773c\u795e\uff0c[npc.speech(\u6211\u6ca1\u505a\u4ec0\u4e48\u3002\u771f\u7684\u6ca1\u4ec0\u4e48\u597d\u8bf4\u7684\u4e86\uff0c[npc.pcName]\u3002)]");
                                    break;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append("\u5728[npc.she]\u56de\u7b54\u65f6\uff0c[npc.she]\u987a\u4ece\u5730\u7aed\u529b\u63a9\u9970[npc.her][npc.eyes]\u4e2d\u7684\u4ec7\u6068\u795e\u60c5\uff0c[npc.speech(\u5176\u5b9e\u8fd9\u6ca1\u4ec0\u4e48\u597d\u8bf4\u7684\uff0c[npc.pcName]\u3002\u5728\u6210\u4e3a\u4f60\u7684\u8d22\u4ea7\u4e4b\u524d\uff0c\u6211\u8fc7\u7740\u5e73\u6de1\u65e0\u5947\u7684\u751f\u6d3b\u3002\u4f60\u8fd8\u9700\u8981\u95ee\u4ec0\u4e48\u5417\uff1f)]");
                                }
                            }
                            break;
                        }
                        case NEUTRAL: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("\u867d\u7136[npc.she]\u4f3c\u4e4e\u5e76\u4e0d\u8ba8\u538c\u4f60\uff0c\u4f46[npc.Name]\u663e\u7136\u4e0d\u592a\u613f\u610f\u548c\u4f60\u8c08\u8bba[npc.her]\u7684\u8fc7\u53bb\uff0c\u4e8e\u662f\u53f9\u4e86\u53e3\u6c14\uff0c[npc.speech(\u6211\u4e0d\u77e5\u9053\uff0c[npc.pcName]\uff0c\u597d\u50cf\u6ca1\u4ec0\u4e48\u597d\u8bf4\u7684\uff0c\u771f\u7684\u3002\u6211\u4eec\u8fd8\u662f\u8c08\u70b9\u522b\u7684\u5427\uff0c\u597d\u5417\uff1f)]");
                                    break;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("\u867d\u7136[npc.she]\u4f3c\u4e4e\u5e76\u4e0d\u8ba8\u538c\u4f60\uff0c\u4f46[npc.Name]\u663e\u7136\u4e0d\u592a\u613f\u610f\u548c\u4f60\u8c08\u8bba[npc.her]\u7684\u8fc7\u53bb\uff0c\u4e8e\u662f\u53f9\u4e86\u53e3\u6c14\uff0c[npc.speech(\u62b1\u6b49[npc.pcName]\uff0c\u5173\u4e8e\u6211\u7684\u8fc7\u53bb\uff0c\u771f\u7684\u6ca1\u4ec0\u4e48\u597d\u8bf4\u7684\u3002\u4e5f\u8bb8\u6211\u80fd\u4e3a\u4f60\u505a\u70b9\u522b\u7684\u4ec0\u4e48\uff1f)]");
                                    break;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append("\u867d\u7136[npc.she]\u4f3c\u4e4e\u5e76\u4e0d\u8ba8\u538c\u4f60\uff0c\u4f46[npc.Name]\u663e\u7136\u4e0d\u592a\u613f\u610f\u548c\u4f60\u8c08\u8bba[npc.her]\u7684\u8fc7\u53bb\uff0c\u53ea\u662f\u7b80\u5355\u5730\u56de\u5e94\u4e86\u4e00\u4e0b\uff0c[npc.speech(\u8fd9\u6ca1\u4ec0\u4e48\u597d\u8bf4\u7684\uff0c[npc.pcName]\u3002\u5728\u6210\u4e3a\u4f60\u7684\u5974\u96b6\u4e4b\u524d\uff0c\u6211\u7684\u751f\u6d3b\u4e00\u5e06\u98ce\u987a\u3002\u6211\u8fd8\u80fd\u4e3a\u4f60\u505a\u4ec0\u4e48\u5417\uff1f)]");
                                }
                            }
                            break;
                        }
                        case LIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("\u5728\u88ab\u95ee\u53ca[npc.her]\u7684\u8fc7\u5f80\u65f6\uff0c[npc.her]\u51e0\u4e4e\u65e0\u6cd5\u6291\u5236\u6fc0\u52a8\u7684\u5fc3\u60c5\uff0c[npc.Name]\u5f88\u5feb\u5c31\u505a\u51fa\u4e86\u56de\u7b54\uff0c[npc.speech(\u8c22\u8c22\u4f60\u7684\u5173\u5fc3\uff0c[npc.pcName]\uff01\u54e6\uff0c\u4f46\u4e5f\u8bb8\u6211\u4eec\u5e94\u8be5\u6539\u5929\u518d\u8ba8\u8bba\u8fd9\u4e2a\u95ee\u9898\u2026\u2026)]");
                                    break block0;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("\u4f60\u5411[npc.Name]\u95ee\u53ca[npc.her]\u8fc7\u53bb\u7684\u751f\u6d3b\uff0c[npc.herHim]\u5fae\u7b11\u7740\u56de\u7b54\uff0c[npc.speech(\u554a\uff0c[npc.pcName]\uff0c\u4e5f\u8bb8\u6211\u4eec\u5e94\u8be5\u6539\u5929\u518d\u8ba8\u8bba\u8fd9\u4e2a\u95ee\u9898\u2026\u2026)]");
                                    break block0;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append("\u88ab\u95ee\u53ca[npc.Name]\u7684\u8fc7\u5f80\u8ba9[npc.her]\u663e\u7136\u5f88\u9ad8\u5174\uff0c\u5f88\u5feb\u5c31\u505a\u51fa\u4e86\u56de\u7b54\uff0c[npc.speech(\u5bf9\u4e0d\u8d77\uff0c[npc.pcName]\uff0c\u6211\u4eec\u5f97\u6539\u5929\u518d\u8c08\u8fd9\u4e2a\u2026\u2026)]");
                                }
                            }
                        }
                    }
                    UtilText.nodeContentSB.append("</p>");
                }
                UtilText.nodeContentSB.append(SlaveDialogue.getFooterText());
                return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return SLAVE_START.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return SLAVE_START.getResponse(responseTab, index);
            }
        };
        SLAVE_MINOR = new DialogueNode("", "", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u4e0e[npc.Name]\u4ea4\u8c08", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                if (SlaveDialogue.isDoll()) {
                    UtilText.nodeContentSB.append("<p>\u9274\u4e8e[npc.name]\u4e0d\u4ec5\u4ec5\u662f\u4e00\u4e2a\u6027\u73a9\u5076\uff0c\u6240\u4ee5\u4f60\u51b3\u5b9a\u4e0e[npc.herHim]\u95f2\u804a\u4e00\u4f1a\u3002</p><p>[npc.name]\u4ee5\u4e00\u79cd\u79ef\u6781\u53c2\u4e0e\u7684\u65b9\u5f0f\u56de\u5e94\u4f60\u7684\u95ee\u9898\u548c\u9648\u8ff0\uff0c\u8ba9\u4f60\u611f\u89c9\u5c31\u50cf\u662f\u5728\u4e0e\u4e00\u4e2a\u6b63\u5e38\u4eba\u4ea4\u8c08\u3002\u4f60\u5f88\u5feb\u53d1\u73b0\uff0c[npc.she]\u5b9e\u9645\u4e0a\u6ca1\u8bb2\u4ec0\u4e48\uff0c\u4ec5\u4ec5\u662f\u5bf9\u4f60\u8a00\u542c\u8ba1\u4ece\u3002</p><p>\u5728\u6ce8\u610f\u5230[npc.namePos]\u7684\u5c40\u9650\u6027\u540e\uff0c\u4f60\u7ed3\u675f\u4e86\u8fd9\u6b21\u5bf9\u8bdd\uff0c\u968f\u540e\u5f00\u59cb\u601d\u8003\u63a5\u4e0b\u6765\u8be5\u505a\u4ec0\u4e48\u2026\u2026</p>");
                } else {
                    UtilText.nodeContentSB.append("<p>\u4f60\u51b3\u5b9a\u5c1d\u8bd5\u4e0e[npc.name]\u95f2\u804a\u51e0\u53e5\uff0c\u4e8e\u662f\u5411[npc.herHim]\u63d0\u51fa\u4e86\u4e00\u7cfb\u5217\u95ee\u9898\uff0c\u4ece[npc.sheIs]\u4f5c\u4e3a\u4f60\u7684\u5974\u96b6\u751f\u6d3b\u611f\u89c9\u5982\u4f55\u5f00\u59cb\uff0c\u5230[npc.she]\u5982\u4f55\u770b\u5f85\u5fa1\u57ce\u533a\u8fd9\u5947\u7279\u7684\u5965\u672f\u5929\u6c14\u3002");
                    switch (AffectionLevelBasic.getAffectionLevelFromValue(SlaveDialogue.getSlave().getAffection(Main.game.getPlayer()))) {
                        case DISLIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("\u7136\u800c\uff0c\u65e0\u8bba\u4f60\u5982\u4f55\u52aa\u529b\uff0c\u4f60\u7684\u8c08\u8bdd\u5c1d\u8bd5\u90fd\u4f1a\u906d\u5230\u4ee4\u4eba\u96be\u4ee5\u7f6e\u4fe1\u7684\u7c97\u9c81\u8bc4\u4ef7\u3002</p><p>\u610f\u8bc6\u5230\u8fd9\u6837\u4e0b\u53bb\u4e0d\u4f1a\u6709\u7ed3\u679c\uff0c\u4f60\u653e\u5f03\u4e86\u4e0e[npc.name]\u5bf9\u8bdd\u7684\u5c1d\u8bd5\u3002\u5f53\u4f60\u8f6c\u8eab\u79bb\u5f00\u65f6\uff0c[npc.she]\u76b1\u8d77\u4e86\u7709\u5934\u3002[npc.speech(\u8bf7\u60a8\u80fd\u6eda\u86cb\u4e86\u5417\uff1f\uff01)]");
                                    break;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("\u7136\u800c\uff0c\u65e0\u8bba\u4f60\u5982\u4f55\u52aa\u529b\u5c1d\u8bd5\uff0c\u4f60\u7684\u8c08\u8bdd\u90fd\u4f1a\u906d\u5230\u7b80\u77ed\u3001\u8f7b\u8511\u7684\u56de\u5e94\u3002</p><p>\u610f\u8bc6\u5230\u8fd9\u6837\u4e0b\u53bb\u4e0d\u4f1a\u6709\u7ed3\u679c\uff0c\u4f60\u653e\u5f03\u4e86\u4e0e[npc.name]\u5bf9\u8bdd\u7684\u5c1d\u8bd5\u3002\u5f53\u4f60\u8f6c\u8eab\u79bb\u5f00\u65f6\uff0c[npc.she]\u76b1\u8d77\u4e86\u7709\u5934\u3002[npc.speech(\u4f60\u8bf4\u5b8c\u4e86\u5417\uff0c[npc.pcName]\uff1f)]");
                                    break;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append("\u7136\u800c\uff0c\u65e0\u8bba\u4f60\u5982\u4f55\u52aa\u529b\u5c1d\u8bd5\uff0c\u4f60\u7684\u8c08\u8bdd\u90fd\u4f1a\u906d\u5230\u7b80\u77ed\u3001\u8f7b\u8511\u7684\u56de\u5e94\u3002</p><p>\u610f\u8bc6\u5230\u8fd9\u6837\u4e0b\u53bb\u4e0d\u4f1a\u6709\u7ed3\u679c\uff0c\u4f60\u653e\u5f03\u4e86\u4e0e[npc.name]\u5bf9\u8bdd\u7684\u5c1d\u8bd5\u3002\u5f53\u4f60\u8f6c\u8eab\u79bb\u5f00\u65f6\uff0c[npc.she]\u95ee\u9053\uff0c[npc.speech(\u8fd8\u6709\u4ec0\u4e48\u9700\u8981\u6211\u5e2e\u5fd9\u7684\u5417\uff0c[npc.pcName]\uff1f)]");
                                }
                            }
                            UtilText.nodeContentSB.append("</p><p><i>\u7531\u4e8e[npc.Name]<span style='" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getColour().toWebHexString() + "'>" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getDescriptor() + "</span>\u4f60\uff0c\u4f60\u60f3\u548c\u5bf9\u65b9\u5957\u8fd1\u4e4e\u7684\u505a\u6cd5\u5f0a\u5927\u4e8e\u5229\uff01</i></p>");
                            break;
                        }
                        case NEUTRAL: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append(" \u867d\u7136[npc.she]\u4e00\u5f00\u59cb\u4f3c\u4e4e\u5bf9\u4e0e\u4f60\u4ea4\u8c08\u4e0d\u611f\u5174\u8da3\uff0c\u4f46[npc.name]\u8fd8\u662f\u53cb\u597d\u5730\u56de\u7b54\u4e86\u4f60\u7684\u6bcf\u4e00\u4e2a\u95ee\u9898\u3002\u4ece[npc.her]\u8138\u4e0a\u6162\u6162\u7efd\u653e\u7684\u7b11\u5bb9\u4e2d\uff0c\u4f60\u53ef\u4ee5\u770b\u51fa[npc.she]\u5f88\u611f\u6fc0\u4f60\u8bd5\u56fe\u8ba9[npc.herHim]\u5b89\u5fc3\u3002</p><p>\u4f60\u4e0e[npc.name]\u804a\u4e86\u4e00\u4f1a\uff0c\u51b3\u5b9a\u7ed3\u675f\u5bf9\u8bdd\u3002\u8fd9\u65f6\u4f60\u7684\u5974\u96b6\u561f\u56d4\u4e86\u4e00\u53e5\uff0c[npc.speech(\u8c22\u8c22\u4f60\u8ddf\u6211\u8bf4\u8bdd\uff0c[npc.pcName]\u2026\u2026)]");
                                    break;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("\u867d\u7136[npc.she]\u5728\u4e0e\u4f60\u4ea4\u8c08\u65f6\u663e\u5f97\u6709\u4e9b\u72b9\u8c6b\uff0c\u4f46[npc.name]\u8fd8\u662f\u53cb\u597d\u5730\u56de\u7b54\u4e86\u4f60\u7684\u6bcf\u4e00\u4e2a\u95ee\u9898\u3002\u4ece[npc.her]\u8138\u4e0a\u6162\u6162\u7efd\u653e\u7684\u7b11\u5bb9\u4e2d\uff0c\u4f60\u53ef\u4ee5\u770b\u51fa[npc.she]\u5f88\u611f\u6fc0\u4f60\u8bd5\u56fe\u8ba9[npc.herHim]\u5b89\u5fc3\u3002</p><p>\u4f60\u4e0e[npc.name]\u804a\u4e86\u4e00\u4f1a\uff0c\u51b3\u5b9a\u7ed3\u675f\u5bf9\u8bdd\u3002\u8fd9\u65f6\u4f60\u7684\u5974\u96b6\u561f\u56d4\u4e86\u4e00\u53e5\uff0c[npc.speech(\u8c22\u8c22\u4f60\uff0c[npc.pcName]\u3002\u6211\u5f88\u9ad8\u5174\u4e0e\u4f60\u4ea4\u8c08\u2026\u2026)]");
                                    break;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.she]\u987a\u4ece\u4e14\u53cb\u597d\u5730\u56de\u7b54\u4f60\u7684\u6bcf\u4e00\u4e2a\u95ee\u9898\u3002\u4ece[npc.her]\u8138\u4e0a\u6162\u6162\u7efd\u653e\u7684\u7b11\u5bb9\u4e2d\uff0c\u4f60\u53ef\u4ee5\u770b\u51fa[npc.she]\u5f88\u611f\u6fc0\u4f60\u8bd5\u56fe\u8ba9[npc.herHim]\u5b89\u5fc3\u3002</p><p>\u4f60\u4e0e[npc.Name]\u804a\u4e86\u4e00\u4f1a\uff0c\u51b3\u5b9a\u7ed3\u675f\u5bf9\u8bdd\u3002\u5728\u8fd9\u65f6\uff0c\u4f60\u7684\u5974\u96b6\u9732\u51fa\u4e86\u7b11\u5bb9\u3002[npc.speech(\u5e0c\u671b\u6211\u7684\u56de\u7b54\u80fd\u8ba9\u4f60\u6ee1\u610f\uff0c[npc.pcName]\u3002)]");
                                }
                            }
                            UtilText.nodeContentSB.append("</p><p><i>\u7531\u4e8e[npc.Name]<span style='" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getColour().toWebHexString() + "'>" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getDescriptor() + "</span>\u4f60\uff0c\u4f60\u8bd5\u56fe\u95f2\u804a\u7684\u4e3e\u52a8\u6b63\u5728\u8ba9[npc.herHim]\u66f4\u559c\u6b22\u4f60\uff01</i></p>");
                            break;
                        }
                        case LIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.Name]\u6ee1\u9762\u7b11\u5bb9\uff0c\u70ed\u60c5\u5730\u56de\u7b54\u4f60\u7684\u6bcf\u4e00\u4e2a\u95ee\u9898\uff0c[npc.her]\u7684\u6001\u5ea6\u66f4\u50cf\u662f\u4e00\u4f4d\u4eb2\u5bc6\u7684\u670b\u53cb\uff0c\u800c\u4e0d\u662f\u4f60\u7684\u5974\u96b6\u3002\u4ece[npc.her]\u7684\u5fae\u7b11\u548c[npc.she]\u51dd\u89c6\u4f60[pc.eyes]\u7684\u773c\u795e\u4e2d\uff0c\u4f60\u53ef\u4ee5\u770b\u51fa[npc.name]\u975e\u5e38\u611f\u6fc0\u4f60\u82b1\u65f6\u95f4\u548c[npc.herHim]\u4ea4\u8c08\u3002</p><p>\u8fc7\u4e86\u4e00\u4f1a\u513f\uff0c\u4f60\u51b3\u5b9a\u7ed3\u675f\u8c08\u8bdd\uff0c\u5c31\u5728\u4f60\u7ed3\u675f\u8c08\u8bdd\u65f6\uff0c\u4f60\u7684\u5974\u96b6\u5bf9\u4f60\u54a7\u5634\u4e00\u7b11\u3002[npc.speech(\u8c22\u8c22\uff0c[npc.pcName]\uff01\u5076\u5c14\u80fd\u548c\u4f60\u804a\u804a\u5929\u771f\u7684\u5f88\u5f00\u5fc3\uff01)]");
                                    break;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("[npc.Name]\u6ee1\u9762\u7b11\u5bb9\uff0c\u70ed\u60c5\u5730\u56de\u7b54\u4f60\u7684\u6bcf\u4e00\u4e2a\u95ee\u9898\uff0c\u4f46[npc.she]\u786e\u4fdd\u4e0d\u4f1a\u505a\u5f97\u592a\u8fc7\u706b\uff0c\u4fdd\u6301\u4e00\u70b9\u8ddd\u79bb\uff0c\u56e0\u4e3a[npc.she]\u52aa\u529b\u8868\u73b0\u5f97\u50cf\u4e2a\u597d\u5974\u96b6\u3002\u4ece[npc.her]\u7684\u5fae\u7b11\u548c[npc.she]\u51dd\u89c6\u4f60[pc.eyes]\u7684\u773c\u795e\u4e2d\uff0c\u4f60\u53ef\u4ee5\u770b\u51fa[npc.name]\u975e\u5e38\u611f\u6fc0\u4f60\u82b1\u65f6\u95f4\u548c[npc.herHim]\u4ea4\u8c08\u3002</p><p>\u8fc7\u4e86\u4e00\u4f1a\u513f\uff0c\u4f60\u51b3\u5b9a\u7ed3\u675f\u8c08\u8bdd\uff0c\u8fd9\u65f6\u4f60\u7684\u5974\u96b6\u9732\u51fa\u4e86\u7b11\u5bb9\u3002[npc.speech(\u8c22\u8c22\u4f60\uff0c[npc.pcName]\u3002\u611f\u8c22\u4f60\u62bd\u51fa\u65f6\u95f4\u548c\u6211\u8bf4\u8bdd\u3002)]");
                                    break;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.Name]\u52aa\u529b\u63a7\u5236\u4f4f[npc.her]\u6fc0\u52a8\u7684\u58f0\u97f3\uff0c\u70ed\u60c5\u5730\u56de\u7b54\u4f60\u7684\u6bcf\u4e00\u4e2a\u95ee\u9898\uff0c\u5c3d\u7ba1[npc.sheIs]\u5c0f\u5fc3\u7ffc\u7ffc\u5730\u4fdd\u6301[npc.her]\u7684\u9547\u5b9a\uff0c\u7aed\u5c3d\u5168\u529b\u8868\u73b0\u5f97\u50cf\u4e2a\u542c\u8bdd\u7684\u5974\u96b6\u3002\u4e0d\u8fc7\uff0c[npc.she]\u65e0\u6cd5\u5b8c\u5168\u6291\u5236[npc.her]\u7684\u5fae\u7b11\u548c[npc.she]\u6e34\u671b\u5730\u4ef0\u671b\u4f60[pc.eyes]\u7684\u773c\u795e\uff0c\u8ba9\u4f60\u77e5\u9053\uff0c[npc.she]\u975e\u5e38\u611f\u6fc0\u4f60\u82b1\u65f6\u95f4\u4e0e[npc.herHim]\u4ea4\u8c08\u3002</p><p>\u8fc7\u4e86\u4e00\u4f1a\u513f\uff0c\u4f60\u51b3\u5b9a\u7ed3\u675f\u8c08\u8bdd\uff0c\u8fd9\u65f6\u4f60\u7684\u5974\u96b6\u9732\u51fa\u4e86\u7b11\u5bb9\u3002[npc.speech(\u5e0c\u671b\u6211\u7684\u56de\u7b54\u80fd\u8ba9\u4f60\u6ee1\u610f\uff0c[npc.pcName]\u3002)]");
                                }
                            }
                            UtilText.nodeContentSB.append("</p><p><i>\u7531\u4e8e[npc.Name]<span style='" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getColour().toWebHexString() + "'>" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getDescriptor() + "</span>\u4f60\uff0c\u4f60\u8bd5\u56fe\u95f2\u804a\u7684\u4e3e\u52a8\u5927\u5927\u6709\u52a9\u4e8e\u8ba9[npc.herHim]\u66f4\u559c\u6b22\u4f60\uff01</i></p>");
                        }
                    }
                }
                UtilText.nodeContentSB.append(SlaveDialogue.getFooterText());
                return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return SLAVE_START.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return SLAVE_START.getResponse(responseTab, index);
            }
        };
        SLAVE_ENCOURAGE = new DialogueNode("", "", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u9f13\u52b1[npc.Name]", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                if (SlaveDialogue.isDoll()) {
                    String jobName = SlaveDialogue.getCurrentJob().getName(SlaveDialogue.getSlave());
                    UtilText.nodeContentSB.append("<p>\u4f60\u60f3\u542c\u542c[npc.Name]\u5bf9[npc.her]\u5de5\u4f5c\u7684\u60f3\u6cd5\uff0c\u4fbf\u95ee[npc.herHim]\u89c9\u5f97\u5de5\u4f5c\u600e\u4e48\u6837" + UtilText.generateSingularDeterminer(jobName) + jobName + "\u3002</p><p>[npc.speech(\u6211\u6ca1\u60f3\u8fc7\uff0c[pc.name]\uff0c)]\u73a9\u5076\u56de\u5e94\u9053\uff0c[npc.speech(\u6211\u53ea\u662f\u6765\u670d\u52a1\u4f60\u7684\uff0c\u4efb\u51ed\u5dee\u9063\u3002)]</p><p>\u770b\u8d77\u6765\u5728\u8fd9\u4e2a\u8bdd\u9898\u4e0a\uff0c\u4f60\u4ece[npc.name]\u90a3\u91cc\u5f97\u4e0d\u5230\u592a\u591a\u4fe1\u606f\u2026\u2026</p>");
                } else {
                    UtilText.nodeContentSB.append("<p>");
                    switch (SlaveDialogue.getCurrentJob()) {
                        case CLEANING: {
                            UtilText.nodeContentSB.append("\u5e0c\u671b\u9f13\u52b1[npc.Name]\u5728\u5de5\u4f5c\u65f6\u505a\u5230\u6700\u597d\uff0c\u4f5c\u4e3a\u4f60\u7684 ");
                            UtilText.nodeContentSB.append(Util.capitaliseSentence(SlaveJob.CLEANING.getName(SlaveDialogue.getSlave())));
                            UtilText.nodeContentSB.append("\uff0c\u4f60\u8be2\u95ee[npc.sheIs]\u53d1\u73b0\u4e86\u4ec0\u4e48\u3002");
                            break;
                        }
                        case IDLE: {
                            UtilText.nodeContentSB.append("\u867d\u7136[npc.name]\u8fd8\u6ca1\u6709\u88ab\u5206\u914d\u5de5\u4f5c\uff0c\u4f46\u4f60\u8fd8\u662f\u8981\u95ee\u95ee[npc.her]\u4f5c\u4e3a\u4f60\u7684\u5974\u96b6\u751f\u6d3b\u5f97\u600e\u4e48\u6837\u3002");
                            break;
                        }
                        case GARDEN: {
                            UtilText.nodeContentSB.append("\u4e3a\u4e86\u9f13\u52b1[npc.name]\u5728\u505a\u56ed\u4e01\u65f6\u5c3d\u5fc3\u5c3d\u529b\uff0c\u4f60\u95ee[npc.her]\u505a\u5f97\u600e\u4e48\u6837\u3002");
                            break;
                        }
                        case SECURITY: {
                            UtilText.nodeContentSB.append("\u4e3a\u4e86\u9f13\u52b1[npc.name]\u5728\u505a\u4fdd\u5b89\u65f6\u5c3d\u5fc3\u5c3d\u529b\uff0c\u4f60\u95ee[npc.sheIs]\u89c9\u5f97\u600e\u4e48\u6837\u3002");
                            break;
                        }
                        case KITCHEN: {
                            UtilText.nodeContentSB.append("\u4e3a\u4e86\u9f13\u52b1[npc.Name]\u5728\u53a8\u623f\u505a\u53a8\u5e08\u65f6\u5c3d\u5fc3\u5c3d\u529b\uff0c\u4f60\u95ee[npc.her]\u89c9\u5f97\u600e\u4e48\u6837\u3002");
                            break;
                        }
                        case LAB_ASSISTANT: {
                            UtilText.nodeContentSB.append("\u4e3a\u4e86\u9f13\u52b1[npc.Name]\u4f5c\u4e3a\u4f60\u7684[lilaya.relation(pc)]\u7684\u52a9\u624b\u5728\u8389\u83b1\u96c5\u7684\u5b9e\u9a8c\u5ba4\u5de5\u4f5c\u65f6\u5c3d\u5fc3\u5c3d\u529b\uff0c\u4f60\u95ee[npc.her]\u89c9\u5f97\u600e\u4e48\u6837\u3002");
                            break;
                        }
                        case LIBRARY: {
                            UtilText.nodeContentSB.append("\u4e3a\u4e86\u9f13\u52b1[npc.name]\u5728\u8389\u83b1\u96c5\u7433\u7405\u6ee1\u76ee\u7684\u56fe\u4e66\u9986\u62c5\u4efb\u56fe\u4e66\u7ba1\u7406\u5458\u671f\u95f4\u5c3d\u5fc3\u5c3d\u529b\uff0c\u4f60\u8be2\u95ee[npc.her]\u89c9\u5f97\u600e\u4e48\u6837\u3002");
                            break;
                        }
                        case OFFICE: {
                            UtilText.nodeContentSB.append("\u4e3a\u4e86\u9f13\u52b1[npc.Name]\u5728\u529e\u516c\u5ba4\u5de5\u4f5c\u65f6\u5c3d\u5fc3\u5c3d\u529b\uff0c\u4f60\u95ee[npc.her]\u5904\u7406\u8fd9\u4e9b\u6587\u4e66\u5de5\u4f5c\u662f\u5426\u5f00\u5fc3\u3002");
                            break;
                        }
                        case TEST_SUBJECT: {
                            UtilText.nodeContentSB.append("\u4f60\u60f3\u9f13\u52b1[npc.name]\u5728\u4f5c\u4e3a\u8389\u83b1\u96c5\u6539\u9020\u5de5\u4f5c\u7684\u8bd5\u9a8c\u54c1\u65f6\u5c3d\u5168\u529b\u505a\u597d[npc.her]\u7684\u5de5\u4f5c\uff0c\u4e8e\u662f\u95ee[npc.her]\u89c9\u5f97\u600e\u4e48\u6837\u3002");
                            break;
                        }
                        case PUBLIC_STOCKS: {
                            UtilText.nodeContentSB.append("\u4e3a\u4e86\u9f13\u52b1[npc.Name]\u5728\u5974\u96b6\u5df7\u88ab\u516c\u5f00\u5229\u7528\u7684\u540c\u65f6\uff0c\u5c3d\u6700\u5927\u52aa\u529b\u505a\u597d[npc.her]\u7684\u5de5\u4f5c\uff0c\u4f60\u95ee[npc.her]\u611f\u89c9\u5982\u4f55\u3002");
                            break;
                        }
                        case PROSTITUTE: {
                            UtilText.nodeContentSB.append("\u4e3a\u4e86\u9f13\u52b1[npc.name]\u5728\u201c\u5929\u4f7f\u4e4b\u543b\u201d\u505a\u5993\u5973\u65f6\u5c3d\u5fc3\u5c3d\u529b\uff0c\u4f60\u8be2\u95ee[npc.her]\u611f\u89c9\u5982\u4f55\u3002");
                            break;
                        }
                        case MILKING: {
                            UtilText.nodeContentSB.append("\u4e3a\u4e86\u9f13\u52b1[npc.name]\u5728\u6324\u5976\u95f4\u5de5\u4f5c\u65f6\u5c3d\u5fc3\u5c3d\u529b\uff0c\u4f60\u95ee[npc.her]\u611f\u89c9\u5982\u4f55\u3002");
                            break;
                        }
                        case BEDROOM: {
                            UtilText.nodeContentSB.append("\u4e3a\u4e86\u8ba9[npc.nameIsFull]\u6ee1\u610f\uff0c\u4f60\u8be2\u95ee[npc.herHim]\u5bf9\u4e8e[npc.she]\u88ab\u6307\u6d3e\u5728\u5367\u5ba4\u91cc\u4f3a\u5019\u4f60\u611f\u89c9\u5982\u4f55\u3002");
                            break;
                        }
                        case SPA: {
                            UtilText.nodeContentSB.append("\u4e3a\u4e86\u8ba9[npc.nameIsFull]\u5f00\u5fc3\uff0c\u4f60\u8be2\u95ee[npc.herHim]\u5bf9[npc.she]\u88ab\u5206\u914d\u5230\u6c34\u7597\u4e2d\u5fc3\u5de5\u4f5c\u7684\u611f\u53d7\u3002");
                            break;
                        }
                        case SPA_RECEPTIONIST: {
                            UtilText.nodeContentSB.append("\u4e3a\u4e86\u8ba9[npc.nameIsFull]\u5f00\u5fc3\uff0c\u4f60\u8be2\u95ee[npc.herHim]\u5bf9[npc.she]\u88ab\u5206\u914d\u5230\u6c34\u7597\u4e2d\u5fc3\u5de5\u4f5c\u7684\u611f\u53d7\u3002");
                            break;
                        }
                        case DINING_HALL: {
                            UtilText.nodeContentSB.append("\u5e0c\u671b\u9f13\u52b1[npc.Name]\u5728\u5de5\u4f5c\u65f6\u505a\u5230\u6700\u597d\uff0c\u4f5c\u4e3a\u4f60\u7684 ");
                            UtilText.nodeContentSB.append(Util.capitaliseSentence(SlaveJob.DINING_HALL.getName(SlaveDialogue.getSlave())));
                            UtilText.nodeContentSB.append("\uff0c\u4f60\u8be2\u95ee[npc.sheIs]\u53d1\u73b0\u4e86\u4ec0\u4e48\u3002");
                            break;
                        }
                    }
                    switch (AffectionLevelBasic.getAffectionLevelFromValue(SlaveDialogue.getSlave().getAffection(Main.game.getPlayer()))) {
                        case DISLIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("\u4f60\u8bdd\u97f3\u521a\u843d\uff0c\u4e0d\u542c\u8bdd\u7684\u5974\u96b6\u5c31\u5550\u4e86\u51fa\u6765\uff0c[npc.speech(\u6eda\u4f60\u5988\u7684\uff01\u6211\u8ba8\u538c\u8fd9\u6837\uff0c\u800c\u4e14\u6211\u5728\u503c\u73ed\u7684\u65f6\u5019\u6839\u672c\u6ca1\u5de5\u4f5c\uff0c\u6240\u4ee5\u53bb\u4f60\u5988\u4e86\u4e2a\u903c\u7684\uff01)]</p><p>\u4ece[npc.her]\u7c97\u9c81\u7684\u53cd\u5e94\u6765\u770b\uff0c\u5f88\u660e\u663e[npc.Name]\u4e0d\u4ec5\u8ba8\u538c\u4f60\uff0c\u800c\u4e14\u4e5f\u4e0d\u60c5\u613f\u8fc7\u4f5c\u4e3a\u4f60\u7684\u5974\u96b6\u7684\u751f\u6d3b\u3002\u8fd8\u6ca1\u7b49\u4f60\u8bd5\u7740\u8981\u6c42[npc.herHim]\u7ed9\u4f60\u4e00\u4e2a\u5408\u9002\u7684\u7b54\u6848\uff0c[npc.she]\u5c31\u671d\u4f60\u8f6c\u8fc7\u8eab\u5486\u54ee\u8d77\u6765\uff0c[npc.speech(\u4f60\u4e3a\u4ec0\u4e48\u4e0d\u6eda\u5f00\u53bb\u7ed9\u8389\u83b1\u96c5\u8214\u9e21\u5df4\uff1f)]");
                                    break;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("\u4f60\u8bdd\u97f3\u521a\u843d\uff0c\u4f60\u7684\u5974\u96b6\u5c31\u505a\u51fa\u4e86\u5c16\u9510\u7684\u56de\u5e94\uff0c[npc.speech(\u6211\u505a\u6211\u5fc5\u987b\u505a\u7684\u3002\u6211\u4e0d\u559c\u6b22\u8fd9\u6837\uff0c\u4e5f\u4e0d\u559c\u6b22\u505a\u4f60\u7684\u5974\u96b6\uff0c\u4f46\u6211\u4f1a\u505a\u6211\u5fc5\u987b\u505a\u7684\u3002)]</p><p>\u4ece[npc.her]\u6025\u4fc3\u7684\u53cd\u5e94\u6765\u770b\uff0c[npc.Name]\u663e\u7136\u4e0d\u592a\u9002\u5e94[npc.her]\u7684\u5974\u96b6\u751f\u6d3b\u3002\u8fd8\u6ca1\u7b49\u4f60\u5f00\u53e3\uff0c[npc.she]\u5c31\u4e0d\u8010\u70e6\u5730\u95ee\uff0c[npc.speech(\u8fd8\u6709\u4ec0\u4e48\u4e8b\u5417\uff0c[npc.pcName]\uff1f\u6216\u8005\u8bf4\u4f60\u73b0\u5728\u5df2\u7ecf\u8bf4\u5b8c\u4e86\uff1f)]");
                                    break;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append("\u4f60\u8bdd\u97f3\u521a\u843d\uff0c\u542c\u8bdd\u7684\u5974\u96b6\u5c31\u8fc5\u901f\u505a\u51fa\u53cd\u5e94\uff0c[npc.speech([npc.pcName]\u8ba9\u6211\u505a\u4ec0\u4e48\u6211\u5c31\u505a\u4ec0\u4e48\u3002\u6211\u4f1a\u5c3d\u6211\u6240\u80fd\u5c65\u884c\u6211\u7684\u804c\u8d23\uff0c\u56e0\u4e3a\u8fd9\u662f\u5bf9\u6211\u7684\u671f\u671b\u3002)]</p><p>\u4ece[npc.her]\u7c97\u9c81\u7684\u53cd\u5e94\u4e2d\u53ef\u4ee5\u770b\u51fa\uff0c\u867d\u7136[npc.Name]\u4f1a\u987a\u4ece\u5730\u5c65\u884c[npc.her]\u4f5c\u4e3a\u5974\u96b6\u7684\u804c\u8d23\uff0c\u4f46[npc.she]\u5e76\u4e0d\u559c\u6b22\u4f60\u3002\u8fd8\u6ca1\u7b49\u4f60\u5f00\u53e3\uff0c[npc.she]\u95ee\u9053\uff0c[npc.speech(\u4f60\u8fd8\u9700\u8981\u6211\u505a\u4ec0\u4e48\uff0c[npc.pcName]\uff1f)]");
                                }
                            }
                            UtilText.nodeContentSB.append("</p><p><i>\u7531\u4e8e[npc.Name]<span style='" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getColour().toWebHexString() + "'>" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getDescriptor() + "</span>\u4f60\uff0c\u5bf9[npc.her]\u7684\u5de5\u4f5c\u8868\u73b0\u6765\u8bf4\uff0c\u5174\u8da3\u53ea\u662f\u8d77\u5230\u4e86\u5fae\u4e0d\u8db3\u9053\u7684\u4f5c\u7528\uff01</i></p>");
                            break;
                        }
                        case NEUTRAL: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("\u4f60\u8bdd\u97f3\u521a\u843d\uff0c\u4f60\u4e0d\u542c\u8bdd\u7684\u5974\u96b6\u5c31\u53d1\u51fa\u545c\u545c\u58f0\uff0c[npc.speech(\u6211\u4e5f\u6ca1\u5f97\u9009\u62e9\u554a\u3002\u6211\u662f\u8bf4\uff0c\u8c22\u8c22\u4f60\u7684\u5173\u5fc3\uff0c\u4f46\u6211\u662f\u4e2a\u5974\u96b6\uff0c\u6240\u4ee5\u4e0d\u7ba1\u6211\u559c\u4e0d\u559c\u6b22\uff0c\u4f60\u547d\u4ee4\u6211\u505a\u4ec0\u4e48\uff0c\u6211\u5c31\u5f97\u505a\u4ec0\u4e48\u2026\u2026)]</p><p>\u4ece[npc.her]\u7c97\u66b4\u8bda\u5b9e\u7684\u53cd\u5e94\u6765\u770b\uff0c[npc.Name]\u663e\u7136\u8fd8\u6ca1\u6709\u5b8c\u5168\u9002\u5e94\u4f5c\u4e3a\u4f60\u7684\u5974\u96b6\u7684\u751f\u6d3b\u3002\u4f60\u601d\u5fd6\u7740\u5982\u4f55\u56de\u7b54\uff0c[npc.she]\u95ee\uff0c[npc.speech(\u6240\u4ee5\uff0c\u4f60\u60f3\u8981\u4ec0\u4e48\uff1f[npc.pcName]\uff1f)]");
                                    break;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("\u4f60\u8bdd\u97f3\u521a\u843d\uff0c\u4f60\u7684\u5974\u96b6\u5c31\u56de\u7b54\uff0c[npc.speech(\u8fd8\u4e0d\u9519\uff0c[npc.pcName]\u3002\u8c22\u8c22\u4f60\u7684\u5173\u5fc3\uff0c\u4f60\u8ba9\u6211\u505a\u4ec0\u4e48\u6211\u5c31\u505a\u4ec0\u4e48\u2026\u2026)]</p><p>\u4ece[npc.her]\u8bda\u5b9e\u7684\u53cd\u5e94\u6765\u770b\uff0c\u5f88\u660e\u663e[npc.Name]\u5bf9\u6210\u4e3a\u4f60\u7684\u5974\u96b6\u8fd8\u6709\u4e9b\u4fdd\u7559\u610f\u89c1\u3002\u4f60\u601d\u5fd6\u7740\u5982\u4f55\u56de\u7b54\uff0c[npc.she]\u95ee\uff0c[npc.speech(\u8fd8\u6709\u4ec0\u4e48\u9700\u8981\u6211\u5e2e\u5fd9\u7684\u5417\uff0c[npc.pcName]\uff1f)]");
                                    break;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append(" \u4f60\u8bdd\u97f3\u521a\u843d\uff0c\u4f60\u7684\u5974\u96b6\u5c31\u56de\u7b54\uff0c[npc.speech(\u6211\u603b\u662f\u5c3d\u6211\u6240\u80fd\uff0c[npc.pcName]\u3002\u8c22\u8c22\u60a8\u7684\u5173\u5fc3\uff0c\u4f46\u8bf7\u653e\u5fc3\uff0c\u6211\u4e00\u5b9a\u4f1a\u5c3d\u6211\u6240\u80fd\u3002)]</p><p>\u4ece[npc.her]\u7684\u53cd\u5e94\u6765\u770b\uff0c\u5f88\u660e\u663e[npc.Name]\u5df2\u7ecf\u5b8c\u5168\u63a5\u53d7\u4e86[npc.her]\u4f5c\u4e3a\u4f60\u7684\u5974\u96b6\u7684\u5730\u4f4d\u3002[npc.her]\u7684\u56de\u7b54\u4f3c\u4e4e\u6709\u70b9\u51b7\u6de1\uff0c\u4f60\u610f\u8bc6\u5230\u867d\u7136[npc.she]\u5e76\u4e0d\u6068\u4f60\uff0c\u4f46[npc.she]\u4e5f\u5e76\u4e0d\u5b8c\u5168\u7231\u4f60\u3002\u4f60\u8fd8\u6ca1\u6765\u5f97\u53ca\u53d1\u8868\u8bc4\u8bba\uff0c[npc.she]\u5c31\u7ee7\u7eed\u8bf4\u9053\uff0c[npc.speech(\u6211\u8fd8\u80fd\u4e3a\u4f60\u505a\u4ec0\u4e48\uff0c[npc.pcName]\uff1f)]");
                                }
                            }
                            UtilText.nodeContentSB.append("</p><p><i>\u7531\u4e8e[npc.Name]<span style='" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getColour().toWebHexString() + "'>" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getDescriptor() + "</span>\u4f60, \u4f60\u5bf9[npc.her]\u5bf9\u5de5\u4f5c\u8868\u73b0\u51fa\u5174\u8da3\u4ea7\u751f\u4e86\u660e\u663e\u7684\u6548\u679c\uff01</i></p>");
                            break;
                        }
                        case LIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("\u4f60\u8bdd\u97f3\u521a\u843d\uff0c\u4f60\u4e0d\u542c\u8bdd\u7684\u5974\u96b6\u5c31\u7b11\u4e86\uff0c[npc.speech(\u597d\u5427\uff0c\u5728\u8fd9\u4ef6\u4e8b\u4e0a\u6211\u4e5f\u522b\u65e0\u9009\u62e9\uff0c\u4e0d\u662f\u5417\uff1f\u54c8\u54c8\uff01\u4e0d\u8fc7\u522b\u62c5\u5fc3\uff0c\u6211\u7231\u4f60\uff01\u6211\uff0c\u6211\u662f\u8bf4\uff01\u6211\u559c\u6b22\u4e3a\u4f60<i>\u5de5\u4f5c</i>\uff01)]</p><p>[npc.she]\u8bd5\u56fe\u5306\u5fd9\u63a9\u9970\u81ea\u5df1\u7684\u5931\u8a00\uff0c\u8138\u988a\u6da8\u5f97\u901a\u7ea2\uff0c\u4f46\u5373\u4f7f\u6ca1\u6709\u610f\u5916\u8868\u767d\uff0c\u4f60\u4e5f\u5df2\u7ecf\u77e5\u9053[npc.Name]\u6df1\u6df1\u5730\u5173\u5fc3\u7740\u4f60\u3002\u4ece[npc.she]\u770b\u4f60\u7684\u773c\u795e\uff0c\u5230\u6bcf\u6b21\u4f60\u5bf9[npc.herHim]\u8868\u793a\u5173\u6ce8\u65f6[npc.her]\u8138\u4e0a\u7efd\u653e\u7684\u7b11\u5bb9\uff0c\u5927\u5bb6\u90fd\u6e05\u695a[npc.she]\u662f\u591a\u4e48\u8ff7\u604b\u4f60\u3002\u8fd8\u6ca1\u7b49\u4f60\u5f00\u53e3\uff0c\u4f60\u7684\u5974\u96b6\u5c31\u8d76\u7d27\u8bd5\u56fe\u628a\u8bdd\u9898\u8f6c\u79fb\u5230\u8ba9[npc.herHim]\u4e0d\u90a3\u4e48\u5c34\u5c2c\u7684\u5730\u65b9\uff0c[npc.speech(\u6211\u8fd8\u80fd\u4e3a\u4f60\u505a\u4ec0\u4e48\u5417\uff0c[npc.pcName]\uff1f\u4ec0\u4e48\u90fd\u884c\uff0c\u5c3d\u7ba1\u5f00\u53e3\uff01)]");
                                    break;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("\u4f60\u4e00\u8bf4\u5b8c\uff0c\u4f60\u7684\u5974\u96b6\u5c31\u4f1a\u5fae\u7b11\u7740\u56de\u5e94\uff0c[npc.speech(\u4e00\u5207\u90fd\u5f88\u987a\u5229\uff0c\u8c22\u8c22\u4f60\u7684\u5173\u5fc3\uff0c[npc.pcName]\u3002\u6211\u559c\u6b22\u4e3a\u4f60\u5de5\u4f5c\u2026\u2026)]</p><p>\u5f53[npc.she]\u627f\u8ba4[npc.she]\u559c\u6b22\u505a\u4f60\u7684\u5974\u96b6\u65f6\uff0c[npc.her]\u7684\u8138\u988a\u53d8\u5f97\u901a\u7ea2\uff0c\u4f46\u5373\u4f7f\u6ca1\u6709[npc.she]\u5bb3\u7f9e\u7684\u8868\u73b0\uff0c\u4f60\u4e5f\u5df2\u7ecf\u77e5\u9053[npc.Name]\u975e\u5e38\u5728\u4e4e\u4f60\u3002\u4ece[npc.she]\u770b\u4f60\u7684\u773c\u795e\uff0c\u5230\u6bcf\u6b21\u4f60\u5bf9[npc.herHim]\u8868\u793a\u5173\u6ce8\u65f6[npc.her]\u8138\u4e0a\u7efd\u653e\u7684\u7b11\u5bb9\uff0c\u5927\u5bb6\u90fd\u6e05\u695a[npc.she]\u662f\u591a\u4e48\u8ff7\u604b\u4f60\u3002\u8fd8\u6ca1\u7b49\u4f60\u5f00\u53e3\uff0c\u4f60\u7684\u5974\u96b6\u5c31\u8d76\u7d27\u8bd5\u56fe\u628a\u8bdd\u9898\u8f6c\u79fb\u5230\u8ba9[npc.herHim]\u4e0d\u90a3\u4e48\u5c34\u5c2c\u7684\u5730\u65b9\uff0c[npc.speech(\u60a8\u8fd8\u9700\u8981\u4ec0\u4e48\u5417\uff0c[npc.pcName]\uff1f)]");
                                    break;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append("\u4f60\u4e00\u8bf4\u5b8c\uff0c\u4f60\u7684\u5974\u96b6\u5c31\u4f1a\u5fae\u7b11\u7740\u56de\u5e94\uff0c[npc.speech(\u4e00\u5207\u90fd\u5f88\u987a\u5229\uff0c[npc.pcName]\u3002\u6211\u559c\u6b22\u4e3a\u4f60\u5de5\u4f5c\u2026\u2026)]</p><p>\u5f53[npc.she]\u627f\u8ba4[npc.she]\u559c\u6b22\u505a\u4f60\u7684\u5974\u96b6\u65f6\uff0c[npc.her]\u7684\u8138\u988a\u53d8\u5f97\u901a\u7ea2\uff0c\u4f46\u5373\u4f7f\u6ca1\u6709[npc.she]\u5bb3\u7f9e\u7684\u8868\u73b0\uff0c\u4f60\u4e5f\u5df2\u7ecf\u77e5\u9053[npc.Name]\u975e\u5e38\u5728\u4e4e\u4f60\u3002\u4ece[npc.she]\u770b\u4f60\u7684\u773c\u795e\uff0c\u5230\u6bcf\u6b21\u4f60\u5bf9[npc.herHim]\u8868\u793a\u5173\u6ce8\u65f6[npc.her]\u8138\u4e0a\u7efd\u653e\u7684\u7b11\u5bb9\uff0c\u5927\u5bb6\u90fd\u6e05\u695a[npc.she]\u662f\u591a\u4e48\u8ff7\u604b\u4f60\u3002\u8fd8\u6ca1\u7b49\u4f60\u5f00\u53e3\uff0c\u4f60\u7684\u5974\u96b6\u5c31\u8d76\u7d27\u8bd5\u56fe\u628a\u8bdd\u9898\u8f6c\u79fb\u5230\u8ba9[npc.herHim]\u4e0d\u90a3\u4e48\u5c34\u5c2c\u7684\u5730\u65b9\uff0c[npc.speech(\u60a8\u8fd8\u9700\u8981\u4ec0\u4e48\u5417\uff0c[npc.pcName]\uff1f)]");
                                }
                            }
                            UtilText.nodeContentSB.append("</p><p><i>\u7531\u4e8e[npc.Name]<span style='" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getColour().toWebHexString() + "'>" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getDescriptor() + "</span>\u4f60, \u663e\u793a\u4f60\u5bf9[npc.her]\u5de5\u4f5c\u7684\u5174\u8da3\u4ea7\u751f\u4e86\u91cd\u5927\u5f71\u54cd\uff01</i></p>");
                        }
                    }
                }
                UtilText.nodeContentSB.append(SlaveDialogue.getFooterText());
                return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return SLAVE_START.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return SLAVE_START.getResponse(responseTab, index);
            }
        };
        SLAVE_HUG = new DialogueNode("", "", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u62e5\u62b1[npc.Name]", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                if (SlaveDialogue.isDoll()) {
                    UtilText.nodeContentSB.append("<p>\u51fa\u4e8e\u7ed9\u4e88[npc.name]\u4e00\u4e9b\u80a2\u4f53\u5173\u6000\u7684\u613f\u671b\uff0c\u4f60[pc.step]\u4e0a\u524d\uff0c\u5c06[npc.herHim]\u7d27\u7d27\u62e5\u62b1\u5728\u6000\u4e2d\u3002</p><p>\u4f60\u7684\u73a9\u5076\u7acb\u523b\u4f5c\u51fa\u4e86\u540c\u6837\u7684\u56de\u5e94\uff0c[npc.she]\u7528[npc.her]\u7684[npc.arms]\u73af\u7ed5\u4f4f\u4f60\uff0c\u5c06\u4f60\u62c9\u8fd1[npc.herHim]\u6000\u91cc\u3002\u5c3d\u7ba1\u8fd9\u662f\u4f60\u671f\u5f85\u7684\u56de\u5e94\uff0c\u4f46[npc.namePos]\u7684\u62e5\u62b1\u5374\u7f3a\u4e4f\u6e29\u5ea6\u548c\u4eb2\u5bc6\u611f\uff0c\u56e0\u6b64\u4f60\u5f88\u5feb\u7ed3\u675f\u4e86\u62e5\u62b1\u5e76\u79bb\u5f00\u4e86[npc.herHim]\u3002</p><p>[npc.speech(\u6211\u5e0c\u671b\u8fd9\u80fd\u6ee1\u8db3\u60a8\u7684\u9700\u6c42\uff0c[pc.name]\u3002)][npc.she]\u56de\u7b54\u9053\uff0c\u63a5\u4e0b\u6765\u4f60\u8981\u5bf9[npc.herHim]\u6709\u4f55\u9700\u6c42\u2026\u2026</p>");
                } else {
                    AffectionLevelBasic slaveAffection = AffectionLevelBasic.getAffectionLevelFromValue(SlaveDialogue.getSlave().getAffection(Main.game.getPlayer()));
                    boolean silly = Main.game.isSillyMode() && Math.random() < 0.25 && slaveAffection == AffectionLevelBasic.NEUTRAL;
                    UtilText.nodeContentSB.append("<p>");
                    if (silly) {
                        UtilText.nodeContentSB.append("\u60f3\u8ba9[npc.Name]\u5411\u4f60\u8868\u8fbe\u4e00\u4e9b\u8eab\u4f53\u4e0a\u7684\u597d\u611f\uff0c\u4f60\u8981\u6c42[npc.herHim]\u7ed9\u4f60\u4e00\u4e2a\u62e5\u62b1\u3002");
                    } else {
                        UtilText.nodeContentSB.append("\u4f60\u8ba4\u4e3a[npc.Name]\u9700\u8981\u4e00\u4e9b\u8eab\u4f53\u4e0a\u7684\u5b89\u6170\uff0c\u4e8e\u662f\u8d70\u4e0a\u524d\u53bb\uff0c\u4f38\u624b\u62c9\u4f4f[npc.herHim]\uff0c\u7136\u540e\u7ed9[npc.herHim]\u4e00\u4e2a\u7d27\u7d27\u7684\u62e5\u62b1\u3002");
                    }
                    switch (slaveAffection) {
                        case DISLIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.she]\u7acb\u523b\u8bd5\u56fe\u6323\u8131\u4f60\u7684\u63a7\u5236\uff0c\u5e76\u5927\u558a\u5927\u53eb\uff0c[npc.speech(\u653e\u5f00\u6211\uff01\u6eda\u5f00\uff01)]</p><p>\u4f60\u65e0\u89c6\u4e0d\u542c\u8bdd\u7684\u5974\u96b6\u7684\u6297\u8bae\uff0c\u5c06[npc.herHim]\u7d27\u7d27\u62b1\u5728\u6000\u91cc\uff0c\u547c\u5438\u7740[npc.her][npc.scent]\u7684\u6c14\u606f\u3002[npc.she]\u53cd\u6297\uff0c\u4e1d\u6beb\u4e0d\u4e3a\u4f60\u5b89\u629a[npc.herHim]\u7684\u884c\u4e3a\u6240\u52a8\u3002\u8fc7\u4e86\u4e00\u5c0f\u4f1a\u513f\uff0c\u4f60\u7ec8\u4e8e\u677e\u5f00\u4e86[npc.Name]\uff0c\u800c[npc.she]\u5219\u8e09\u8e09\u8dc4\u8dc4\u5730\u540e\u9000\u5e76\u5927\u558a\u5927\u53eb\uff0c[npc.speech(\u6211\u4e0d\u9700\u8981\u4f60\u7684\u540c\u60c5\uff0c\u4f60\u4e2a" + (Main.game.getPlayer().isFeminine() ? "\u5a4a\u5b50" : "\u6df7\u86cb") + "\uff01)]");
                                    break;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("[npc.she]\u672c\u80fd\u5730\u8bd5\u56fe\u6323\u8131\u4f60\u7684\u63a7\u5236\uff0c\u5e76\u53d1\u51fa\u545c\u545c\u58f0\uff0c[npc.speech([npc.PcName]\u6c42\u4f60\u4e86\uff01\u6211\u4e0d\u559c\u6b22\u8fd9\u6837\uff01)]</p><p>\u4f60\u65e0\u89c6\u5974\u96b6\u7684\u6297\u8bae\uff0c\u5c06[npc.herHim]\u7d27\u7d27\u62b1\u5728\u6000\u91cc\uff0c\u547c\u5438\u7740[npc.her][npc.scent]\u7684\u6c14\u5473\u3002[npc.she]\u8bd5\u56fe\u6323\u8131\u4f60\u7684\u63a7\u5236\uff0c\u663e\u7136\u5bf9\u4f60\u5b89\u629a[npc.herHim]\u7684\u65b9\u6cd5\u4e0d\u4ee5\u4e3a\u7136\uff0c\u4f46\u4f60\u8fd8\u662f\u7d27\u7d27\u6293\u4f4f\uff0c\u9632\u6b62[npc.her]\u9003\u8131\u3002\u8fc7\u4e86\u4e00\u4f1a\u513f\uff0c\u4f60\u7ec8\u4e8e\u677e\u5f00\u4e86[npc.Name]\uff0c\u800c[npc.she]\u5219\u8e09\u8e09\u8dc4\u8dc4\u5730\u540e\u9000\uff0c\u5634\u91cc\u8fd8\u5728\u561f\u56d4\u7740\u4ec0\u4e48\uff0c[npc.speech(\u6211\u751a\u81f3\u90fd\u4e0d\u559c\u6b22\u62e5\u62b1\u2026\u2026)]");
                                    break;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append("\u5f53\u4f60\u62b1\u4f4f[npc.herHim]\u65f6\uff0c[npc.she]\u6123\u4f4f\u4e86\uff0c\u5583\u5583\u81ea\u8bed\uff0c\u58f0\u97f3\u4e2d\u6ca1\u6709\u4e00\u4e1d\u771f\u8bda\uff0c[npc.speech(\u8c22\u8c22\uff0c[npc.pcName]\u2026\u2026)]</p><p>\u4f60\u65e0\u89c6\u5974\u96b6\u7684\u51b7\u6de1\u53cd\u5e94\uff0c\u5c06[npc.herHim]\u7d27\u7d27\u62b1\u5728\u6000\u91cc\uff0c\u547c\u5438\u7740[npc.her][npc.scent]\u7684\u6c14\u5473\u3002[npc.she]\u4e00\u52a8\u4e0d\u52a8\uff0c\u663e\u7136\u5bf9\u4f60\u5b89\u629a\u7684\u65b9\u6cd5\u4e0d\u4ee5\u4e3a\u7136\uff0c\u4f46\u4f60\u65e0\u89c6[npc.her]\u7684\u6297\u62d2\u7684\u53cd\u5e94\uff0c\u7ee7\u7eed\u628a\u81ea\u5df1\u538b\u5728[npc.herHim]\u8eab\u4e0a\u3002\u8fc7\u4e86\u4e00\u4f1a\u513f\uff0c\u4f60\u7ec8\u4e8e\u677e\u5f00\u4e86[npc.Name]\uff0c\u800c[npc.she]\u5219\u9000\u540e\u4e00\u6b65\uff0c\u4f4e\u5934\u770b\u7740\u5730\u9762\u3002[npc.speech(\u8c22\u8c22\uff0c[npc.pcName]\u3002\u4f60\u8fd8\u9700\u8981\u4ec0\u4e48\uff1f)]");
                                }
                            }
                            UtilText.nodeContentSB.append("</p><p><i>\u7531\u4e8e[npc.Name]<span style='" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getColour().toWebHexString() + "'>" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getDescriptor() + "</span>\u4f60\uff0c\u4f60\u8bd5\u56fe\u5f3a\u884c\u8fdb\u884c\u8eab\u4f53\u63a5\u89e6\u7684\u505a\u6cd5\u5f0a\u5927\u4e8e\u5229\uff01</i></p>");
                            break;
                        }
                        case NEUTRAL: {
                            if (silly) {
                                UtilText.nodeContentSB.append("</p><p>[npc.speech(~\u5443\uff01\u597d\u5427\u2026\u2026)][npc.Name]\u677e\u4e86\u53e3\u6c14\uff0c\u7136\u540e\u7ea2\u7740\u8138\u5411\u4f60\u4f38\u51fa[npc.her][npc.arms]\u3002\u5c06\u4f60\u62e5\u5165[npc.her]\u7684\u6000\u62b1\uff0c\u5979\u53f9\u606f\u9053\uff0c[npc.speech(\u6211\u731c\u4f60\u662f\u6211\u7684\u5c0f\u79c0\u513f\u2026\u2026\u8fc7\u6765\u2026\u2026)]</p><p>[pc.Stepping]\u5411\u524d\uff0c\u4f60\u65e0\u89c6[npc.namePos]\u7684\u5c34\u5c2c\uff0c\u8ba9[npc.herHim]\u7ed9\u4e86\u4f60\u4e00\u4e2a\u5927\u5927\u7684\u62e5\u62b1\u3002[npc.she]\u8f7b\u8f7b\u62cd\u4e86\u62cd\u4f60\u7684\u80cc\uff0c\u4f60\u660e\u663e\u611f\u89c9\u5230[npc.she]\u53ea\u662f\u5728\u56de\u5e94\u4f60\u7684\u52a8\u4f5c\uff0c\u56e0\u4e3a\u8fd9\u662f[npc.herHim]\u6240\u671f\u671b\u7684\u3002\u8fc7\u4e86\u4e00\u5c0f\u4f1a\u513f\uff0c\u4f60\u7ec8\u4e8e\u677e\u5f00\u4e86[npc.Name]\uff0c[npc.herHim]\u5411\u540e[npc.step]\u5e76\u5583\u5583\u81ea\u8bed\uff0c[npc.speech(\u8fd9\u6709\u70b9\u79c0\u4e86\u2026\u2026)]");
                            } else {
                                switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                    case DISOBEDIENT: {
                                        UtilText.nodeContentSB.append("[npc.she]\u534a\u4fe1\u534a\u7591\u5730\u56de\u5230\u4f60\u7684\u6000\u62b1\uff0c\u53f9\u4e86\u53e3\u6c14\uff0c[npc.speech(\u8c22\u8c22\uff0c[npc.pcName]\uff0c\u6211\u60f3\u5076\u5c14\u6765\u4e2a\u62e5\u62b1\u4e5f\u4e0d\u9519\u2026\u2026)]</p><p>\u4f60\u5c06[npc.name]\u62c9\u8fd1\u4e00\u70b9\uff0c\u5c06[npc.herHim]\u7d27\u7d27\u62b1\u5728\u6000\u91cc\uff0c\u547c\u5438[npc.her][npc.scent]\u7684\u6c14\u5473\u3002[npc.she]\u8f7b\u8f7b\u62cd\u4e86\u62cd\u4f60\u7684\u80cc\uff0c\u4f60\u660e\u663e\u611f\u89c9\u5230[npc.she]\u53ea\u662f\u5728\u56de\u5e94\u4f60\u7684\u52a8\u4f5c\uff0c\u56e0\u4e3a\u8fd9\u662f[npc.herHim]\u6240\u671f\u671b\u7684\u3002\u8fc7\u4e86\u4e00\u5c0f\u4f1a\u513f\uff0c\u4f60\u7ec8\u4e8e\u677e\u5f00\u4e86[npc.Name]\uff0c\u800c[npc.she]\u5219\u5fae\u7b11\u7740\u540e\u9000\u4e86\u4e00\u6b65\u3002[npc.speech(\u5f88\u4e0d\u9519\u5427\uff1f\u4f60\u8fd8\u60f3\u8981\u4ec0\u4e48\u5417\uff1f)]");
                                        break;
                                    }
                                    case NEUTRAL: {
                                        UtilText.nodeContentSB.append("[npc.she]\u534a\u4fe1\u534a\u7591\u5730\u56de\u5230\u4f60\u7684\u6000\u62b1\uff0c\u53f9\u4e86\u53e3\u6c14\uff0c[npc.speech(\u8c22\u8c22\uff0c[npc.pcName]\u2026\u2026)]</p><p>\u4f60\u5c06[npc.name]\u62c9\u8fd1\u4e00\u70b9\uff0c\u5c06[npc.herHim]\u7d27\u7d27\u62b1\u5728\u6000\u91cc\uff0c\u547c\u5438[npc.her][npc.scent]\u7684\u6c14\u5473\u3002[npc.she]\u8f7b\u8f7b\u62cd\u4e86\u62cd\u4f60\u7684\u80cc\uff0c\u4f60\u660e\u663e\u611f\u89c9\u5230[npc.she]\u53ea\u662f\u5728\u56de\u5e94\u4f60\u7684\u52a8\u4f5c\uff0c\u56e0\u4e3a\u8fd9\u662f[npc.herHim]\u6240\u671f\u671b\u7684\u3002\u8fc7\u4e86\u4e00\u5c0f\u4f1a\u513f\uff0c\u4f60\u7ec8\u4e8e\u677e\u5f00\u4e86[npc.Name]\uff0c\u800c[npc.she]\u5219\u5fae\u7b11\u7740\u540e\u9000\u4e86\u4e00\u6b65\u3002[npc.speech(\u4f60\u8fd8\u9700\u8981\u4ec0\u4e48\u5417\uff0c[npc.pcName]\uff1f)]");
                                        break;
                                    }
                                    case OBEDIENT: {
                                        UtilText.nodeContentSB.append("[npc.she]\u534a\u4fe1\u534a\u7591\u5730\u56de\u5230\u4f60\u7684\u6000\u62b1\uff0c\u53f9\u4e86\u53e3\u6c14\uff0c[npc.speech(\u8c22\u8c22\u4f60\uff0c[npc.pcName]\u3002)]</p><p>\u4f60\u5c06[npc.name]\u62c9\u8fd1\u4e00\u70b9\uff0c\u5c06[npc.herHim]\u7d27\u7d27\u62b1\u5728\u6000\u91cc\uff0c\u547c\u5438[npc.her][npc.scent]\u7684\u6c14\u5473\u3002[npc.she]\u8f7b\u8f7b\u62cd\u4e86\u62cd\u4f60\u7684\u80cc\uff0c\u4f60\u660e\u663e\u611f\u89c9\u5230[npc.sheIs]\u53ea\u662f\u5728\u56de\u5e94\u4f60\u7684\u52a8\u4f5c\uff0c\u56e0\u4e3a\u8fd9\u662f[npc.herHim]\u6240\u671f\u671b\u7684\u3002\u8fc7\u4e86\u4e00\u5c0f\u4f1a\u513f\uff0c\u4f60\u7ec8\u4e8e\u677e\u5f00\u4e86[npc.Name]\uff0c\u800c[npc.she]\u5219\u5fae\u7b11\u7740\u540e\u9000\u4e86\u4e00\u6b65\u3002[npc.speech(\u4f60\u8fd8\u9700\u8981\u4ec0\u4e48\u5417\uff0c[npc.pcName]\uff1f)]");
                                    }
                                }
                            }
                            UtilText.nodeContentSB.append("</p><p><i>\u7531\u4e8e[npc.Name]<span style='" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getColour().toWebHexString() + "'>" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getDescriptor() + "</span>\u4f60\uff0c\u7ed9[npc.herHim]\u4e00\u4e2a\u5b89\u5fc3\u7684\u62e5\u62b1\uff0c\u5bf9[npc.she]\u5982\u4f55\u770b\u5f85\u4f60\u4ea7\u751f\u4e86\u79ef\u6781\u7684\u5f71\u54cd\uff01\u4e0d\u8fc7\uff0c\u4ee5\u5982\u6b64\u719f\u6089\u7684\u65b9\u5f0f\u5bf9\u5f85[npc.she]\uff0c\u5bf9[npc.her]\u7684\u670d\u4ece\u6027\u6709\u4e00\u70b9\u8d1f\u9762\u5f71\u54cd\u2026\u2026</i></p>");
                            break;
                        }
                        case LIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.she]\u70ed\u5207\u5730\u56de\u5e94\u4f60\u7684\u62e5\u62b1\uff0c\u53d1\u51fa\u4e00\u58f0\u6df1\u6df1\u7684\u53f9\u606f\uff0c[npc.speech(\u8c22\u8c22\u4f60\uff0c[npc.pcName]\uff01)]</p><p>\u4f60\u5c06[npc.name]\u62c9\u8fd1\u4e00\u70b9\uff0c\u5c06[npc.herHim]\u7d27\u7d27\u62b1\u5728\u6000\u91cc\uff0c\u547c\u5438[npc.her][npc.scent]\u7684\u6c14\u5473\u3002[npc.she]\u4f9d\u504e\u7740\u4f60\uff0c[npc.her]\u7684[npc.arms]\u73af\u7ed5\u7740\u4f60\u7684\u540e\u80cc\uff0c\u53d1\u51fa\u6ee1\u8db3\u7684\u53f9\u606f\u3002\u4ece[npc.her]\u7684\u53cd\u5e94\u6765\u770b\uff0c[npc.she]\u663e\u7136\u975e\u5e38\u6b23\u8d4f\u4f60\u7684\u884c\u4e3a\uff0c\u5728[npc.her]\u70ed\u60c5\u7684\u9f13\u52b1\u4e0b\uff0c\u4f60\u82b1\u4e86\u4e0d\u5c11\u65f6\u95f4\u62e5\u62b1\u4f60\u7684\u5974\u96b6\u3002</p><p>\u8fc7\u4e86\u4e00\u4f1a\u513f\uff0c\u4f60\u7ec8\u4e8e\u677e\u5f00\u4e86[npc.Name]\uff0c\u800c[npc.she]\u5219\u5fae\u7b11\u7740\u9000\u540e\u3002[npc.speech(\u8c22\u8c22\u4f60\uff0c[npc.pcName]\uff01\u6211\u771f\u7684\u9700\u8981\u5b83\u2026\u2026)]");
                                    break;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("[npc.she]\u70ed\u5207\u5730\u56de\u5e94\u4f60\u7684\u62e5\u62b1\uff0c\u53d1\u51fa\u4e00\u58f0\u6df1\u6df1\u7684\u53f9\u606f\uff0c[npc.speech(\u8c22\u8c22\uff0c[npc.pcName]\u2026\u2026)]</p><p>\u4f60\u5c06[npc.name]\u62c9\u8fd1\u4e00\u70b9\uff0c\u7d27\u7d27\u62b1\u5728\u6000\u91cc\uff0c\u547c\u5438[npc.her][npc.scent]\u7684\u6c14\u5473\u3002[npc.she]\u4f9d\u504e\u7740\u4f60\uff0c[npc.her]\u7684[npc.arms]\u73af\u7ed5\u7740\u4f60\u7684\u540e\u80cc\uff0c\u53d1\u51fa\u6ee1\u8db3\u7684\u53f9\u606f\u3002\u4ece[npc.her]\u7684\u53cd\u5e94\u6765\u770b\uff0c[npc.she]\u663e\u7136\u975e\u5e38\u6b23\u8d4f\u4f60\u7684\u884c\u4e3a\uff0c\u5728[npc.her]\u70ed\u60c5\u7684\u9f13\u52b1\u4e0b\uff0c\u4f60\u82b1\u4e86\u4e0d\u5c11\u65f6\u95f4\u62e5\u62b1\u4f60\u7684\u5974\u96b6\u3002</p><p>\u8fc7\u4e86\u4e00\u4f1a\u513f\uff0c\u4f60\u7ec8\u4e8e\u677e\u5f00\u4e86[npc.Name]\uff0c\u800c[npc.she]\u5219\u5fae\u7b11\u7740\u9000\u540e\u3002[npc.speech(\u8c22\u8c22\u4f60\uff0c[npc.pcName]\u3002\u6211\u771f\u7684\u9700\u8981\u8fd9\u4e2a\u2026\u2026\u6709\u4ec0\u4e48\u6211\u80fd\u4e3a\u4f60\u505a\u7684\u5417\uff1f)]");
                                    break;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.she]\u70ed\u5207\u5730\u56de\u5e94\u4f60\u7684\u62e5\u62b1\uff0c\u53d1\u51fa\u4e00\u58f0\u6df1\u6df1\u7684\u53f9\u606f\uff0c[npc.speech(\u8c22\u8c22\uff0c[npc.pcName]\u2026\u2026)]</p><p>\u4f60\u5c06[npc.name]\u62c9\u8fd1\u4e00\u70b9\uff0c\u5c06[npc.herHim]\u7d27\u7d27\u62b1\u5728\u6000\u91cc\uff0c\u547c\u5438[npc.her][npc.scent]\u7684\u6c14\u5473\u3002[npc.she]\u4f9d\u504e\u7740\u4f60\uff0c[npc.her]\u7684[npc.arms]\u73af\u7ed5\u7740\u4f60\u7684\u540e\u80cc\uff0c\u53d1\u51fa\u6ee1\u8db3\u7684\u53f9\u606f\u3002\u4ece[npc.her]\u7684\u53cd\u5e94\u6765\u770b\uff0c[npc.she]\u663e\u7136\u975e\u5e38\u6b23\u8d4f\u4f60\u7684\u884c\u4e3a\uff0c\u5728[npc.her]\u70ed\u60c5\u7684\u9f13\u52b1\u4e0b\uff0c\u4f60\u82b1\u4e86\u4e0d\u5c11\u65f6\u95f4\u62e5\u62b1\u4f60\u7684\u5974\u96b6\u3002</p><p>\u8fc7\u4e86\u4e00\u4f1a\u513f\uff0c\u4f60\u7ec8\u4e8e\u677e\u5f00\u4e86[npc.Name]\uff0c\u800c[npc.she]\u5219\u5fae\u7b11\u7740\u9000\u540e\u3002[npc.speech(\u8c22\u8c22\u4f60\uff0c[npc.pcName]\u3002\u6709\u4ec0\u4e48\u9700\u8981\u6211\u5e2e\u5fd9\u7684\u5417\uff1f)]");
                                }
                            }
                            UtilText.nodeContentSB.append("</p><p><i>\u7531\u4e8e[npc.Name]<span style='" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getColour().toWebHexString() + "'>" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getDescriptor() + "</span>\u4f60\uff0c\u7ed9[npc.herHim]\u4e00\u4e2a\u5b89\u5fc3\u7684\u62e5\u62b1\uff0c\u5bf9[npc.she]\u5982\u4f55\u770b\u5f85\u4f60\u4ea7\u751f\u4e86\u5de8\u5927\u7684\u79ef\u6781\u5f71\u54cd\uff01\u4e0d\u8fc7\uff0c\u5982\u6b64\u4eb2\u6635\u5730\u5bf9\u5f85[npc.she]\uff0c\u4f1a\u964d\u4f4e[npc.her]\u7684\u670d\u4ece\u6027\u2026\u2026</i></p>");
                        }
                    }
                }
                UtilText.nodeContentSB.append(SlaveDialogue.getFooterText());
                return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return SLAVE_START.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return SLAVE_START.getResponse(responseTab, index);
            }
        };
        SLAVE_PETTINGS = new DialogueNode("", "", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u7231\u629a[npc.Name]", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                if (SlaveDialogue.isDoll()) {
                    UtilText.nodeContentSB.append("<p>\u4f60\u60f3\u8ba9[npc.Name]\u611f\u5230\u5b89\u5fc3\uff0c\u4e8e\u662f\u4f38[pc.hand]\u5728[npc.her]\u7684\u5934\u4e0a\u6478\u4e86\u4e00\u628a\u3002\u5728[npc.she]\u8fd8\u6ca1\u53cd\u5e94\u8fc7\u6765\u4e4b\u524d\uff0c\u4f60\u5f00\u59cb\u629a\u6478[npc.her]\u7684[npc.hair+]\uff0c\u7136\u540e\u5411\u4e0b\u8f7b\u8f7b\u6320\u5728[npc.her]\u7684[npc.ears]\u540e\u9762\u3002</p><p>\u4f60\u7684\u73a9\u5076\u5728\u4f60\u7684\u7231\u629a\u4e4b\u4e0b\u8f7b\u8f7b\u4f9d\u504e\u8fc7\u6765\uff0c\u540c\u65f6\u56de\u5e94\u9053\uff1a[npc.speech(\u8c22\u8c22\u4f60\uff0c[pc.name]\u3002\u6211\u5e0c\u671b\u6211\u80fd\u5f88\u597d\u5730\u670d\u52a1\u4e8e\u4f60\u3002)]</p><p>\u867d\u7136\u4f60\u7ee7\u7eed\u629a\u6478[npc.name]\u51e0\u79d2\u949f\uff0c\u4f46[npc.her]\u90a3\u51b7\u6de1\u4e14\u673a\u68b0\u822c\u7684\u53cd\u5e94\u5e76\u4e0d\u7b26\u5408\u4f60\u671f\u671b\u7684\u6e29\u60c5\u4e92\u52a8\u3002\u6765\u81ea\u4f60\u7684\u73a9\u5076\u90a3\u4e00\u7247\u7a7a\u767d\u4e14\u6beb\u65e0\u8868\u60c5\u7684\u51dd\u89c6\u6210\u4e86\u6700\u540e\u4e00\u6839\u7a3b\u8349\uff0c\u4f60\u6536\u56de\u4e86\u4f60\u7684[pc.hand]\uff0c\u5e76\u7136\u540e\u5f00\u59cb\u601d\u7d22\u4e0b\u4e00\u6b65\u8be5\u600e\u4e48\u505a\u2026\u2026</p>");
                } else {
                    UtilText.nodeContentSB.append("<p>\u4f60\u60f3\u8ba9[npc.Name]\u611f\u5230\u5b89\u5fc3\uff0c\u4e8e\u662f\u4f38[pc.hand]\u5728[npc.her]\u7684\u5934\u4e0a\u6478\u4e86\u4e00\u628a\u3002\u5728[npc.she]\u8fd8\u6ca1\u53cd\u5e94\u8fc7\u6765\u4e4b\u524d\uff0c\u4f60\u5f00\u59cb\u629a\u6478[npc.her]\u7684[npc.hair+]\uff0c\u7136\u540e\u5411\u4e0b\u8f7b\u8f7b\u6320\u5728[npc.her]\u7684[npc.ears]\u540e\u9762\u3002</p><p>");
                    switch (AffectionLevelBasic.getAffectionLevelFromValue(SlaveDialogue.getSlave().getAffection(Main.game.getPlayer()))) {
                        case DISLIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.Name]\u88ab\u4f60\u7684\u4e3e\u52a8\u5413\u4e86\u4e00\u8df3\uff0c\u8fc7\u4e86\u4e00\u4f1a\u513f\u624d\u53cd\u5e94\u8fc7\u6765\u3002[npc.she]\u4e00\u58f0\u6012\u559d\uff0c\u62cd\u5f00\u4f60\u7684[pc.hand]\uff0c\u540e\u9000\u51e0\u6b65\uff0c\u5927\u58f0\u558a\u9053\uff0c[npc.speech(\u5e72\u4f60\u5a18\u7684\uff1f\uff01\u653e\u5f00\u6211\uff01\u4f60\u4ed6\u5988\u7684\u8ba9\u6211\u81ea\u5df1\u5f85\u4f1a\uff01)]</p>");
                                    break;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("[npc.Name]\u88ab\u4f60\u7684\u884c\u4e3a\u5413\u4e86\u4e00\u8df3\uff0c\u8fc7\u4e86\u4e00\u4f1a\u513f\u624d\u53cd\u5e94\u8fc7\u6765\uff0c\u4e0d\u81ea\u5728\u5730\u54fc\u4e86\u4e00\u58f0\uff0c[npc.she]\u5411\u540e\u9000\u4e86\u4e00\u6b65\uff0c\u8868\u793a\u6b49\u610f\uff0c[npc.speech(\u5bf9\u4e0d\u8d77\uff0c[npc.pcName]\uff0c\u4f46\u662f\uff0c\u4f60\u80fd\u4e0d\u80fd\u4e0d\u8981\u8fd9\u6837\u505a\uff1f)]</p>");
                                    break;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.Name]\u88ab\u4f60\u7684\u4e3e\u52a8\u5413\u4e86\u4e00\u8df3\uff0c\u8fc7\u4e86\u4e00\u4f1a\u513f\u624d\u53cd\u5e94\u8fc7\u6765\uff0c\u53d1\u51fa\u4e0d\u8212\u670d\u7684\u545c\u545c\u58f0\uff0c[npc.she]\u4e00\u52a8\u4e0d\u52a8\uff0c\u772f\u8d77[npc.eyes]\uff0c\u5f3a\u8feb\u81ea\u5df1\u5fcd\u53d7\u4f60\u591a\u4f59\u7684\u5173\u6ce8\u3002\u8fc7\u4e86\u4e00\u4f1a\u513f\uff0c\u4f60\u505c\u4e0b\u624b\u4e2d\u7684\u6d3b\u513f\uff0c\u628a[pc.hand]\u62ff\u5f00\uff0c[npc.Name]\u677e\u4e86\u4e00\u53e3\u6c14\uff0c\u95ee\u9053\uff0c[npc.speech(\u8fd8\u6709\u4ec0\u4e48\u9700\u8981\u6211\u5e2e\u5fd9\u7684\u5417\uff0c[npc.pcName]\uff1f)]</p>");
                                }
                            }
                            UtilText.nodeContentSB.append("<p><i>\u7531\u4e8e[npc.Name]<span style='" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getColour().toWebHexString() + "'>" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getDescriptor() + "</span>\u4f60\uff0c\u4f60\u8bd5\u56fe\u5f3a\u884c\u8fdb\u884c\u8eab\u4f53\u63a5\u89e6\u7684\u505a\u6cd5\u5f0a\u5927\u4e8e\u5229\uff01</i></p>");
                            break;
                        }
                        case NEUTRAL: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.Name]\u88ab\u4f60\u7684\u4e3e\u52a8\u5413\u4e86\u4e00\u8df3\uff0c\u8fc7\u4e86\u4e00\u4f1a\u513f\u624d\u53cd\u5e94\u8fc7\u6765\uff0c\u53f9\u4e86\u53e3\u6c14\uff0c[npc.she]\u628a[npc.her]\u7684\u5934\u504f\u5411\u4e00\u8fb9\u3002[npc.speech(\u611f\u89c9\u6709\u70b9\u4e0d\u9519\u2026\u2026\u7ee7\u7eed\u4e0d\u8981\u505c\uff01)]</p><p>\u4f60\u6309\u7167[npc.she]\u7684\u8981\u6c42\uff0c\u7ee7\u7eed\u629a\u6478\u548c\u62cd\u6253[npc.her]\u7684\u5934\u597d\u4e00\u4f1a\u513f\u3002\u6700\u540e\uff0c\u4f60\u89c9\u5f97[npc.name]\u5df2\u7ecf\u4eab\u53d7\u591f\u4e86\uff0c\u4e8e\u662f\u628a[pc.hand]\u62ff\u5f00\uff0c\u770b\u7740\u4f60\u7684\u5974\u96b6\u53d1\u51fa\u6ee1\u8db3\u7684\u5598\u606f\uff0c\u4f60\u7b11\u4e86\u3002</p>");
                                    break;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("[npc.Name]\u88ab\u4f60\u7684\u4e3e\u52a8\u5413\u4e86\u4e00\u8df3\uff0c\u8fc7\u4e86\u4e00\u4f1a\u513f\u624d\u53cd\u5e94\u8fc7\u6765\uff0c\u53f9\u4e86\u53e3\u6c14\uff0c[npc.she]\u628a[npc.her]\u7684\u5934\u504f\u5411\u4e00\u8fb9\u3002[npc.speech(\u611f\u89c9\u8fd8\u4e0d\u9519\u2026\u2026\u8c22\u8c22\u4f60\uff0c[npc.pcName]\u2026\u2026)]</p><p>\u5728[npc.her]\u53cd\u5e94\u7684\u9f13\u52b1\u4e0b\uff0c\u4f60\u7ee7\u7eed\u629a\u6478\u548c\u62cd\u6253[npc.her]\u7684\u5934\uff0c\u6301\u7eed\u4e86\u597d\u4e00\u4f1a\u513f\u3002\u6700\u540e\uff0c\u4f60\u89c9\u5f97[npc.name]\u5df2\u7ecf\u4eab\u53d7\u591f\u4e86\uff0c\u4e8e\u662f\u628a[pc.hand]\u62ff\u5f00\uff0c\u770b\u7740\u4f60\u7684\u5974\u96b6\u53d1\u51fa\u6ee1\u8db3\u7684\u5598\u606f\uff0c\u4f60\u7b11\u4e86\u3002</p>");
                                    break;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.Name]\u88ab\u4f60\u7684\u4e3e\u52a8\u5413\u4e86\u4e00\u8df3\uff0c\u8fc7\u4e86\u4e00\u4f1a\u513f\u624d\u53cd\u5e94\u8fc7\u6765\uff0c\u53f9\u4e86\u53e3\u6c14\uff0c[npc.she]\u628a[npc.her]\u7684\u5934\u504f\u5411\u4e00\u8fb9\u3002[npc.speech(\u8c22\u8c22\uff0c[npc.pcName]\u2026\u2026)]</p><p>\u5728[npc.her]\u53cd\u5e94\u7684\u9f13\u52b1\u4e0b\uff0c\u4f60\u7ee7\u7eed\u629a\u6478\u548c\u62cd\u6253[npc.her]\u7684\u5934\uff0c\u6301\u7eed\u4e86\u597d\u4e00\u4f1a\u513f\u3002\u6700\u540e\uff0c\u4f60\u89c9\u5f97[npc.name]\u5df2\u7ecf\u4eab\u53d7\u591f\u4e86\uff0c\u4e8e\u662f\u628a[pc.hand]\u62ff\u5f00\uff0c\u770b\u7740\u4f60\u7684\u5974\u96b6\u53d1\u51fa\u6ee1\u8db3\u7684\u5598\u606f\uff0c\u4f60\u7b11\u4e86\u3002</p>");
                                }
                            }
                            UtilText.nodeContentSB.append("<p><i>\u7531\u4e8e[npc.Name]<span style='" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getColour().toWebHexString() + "'>" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getDescriptor() + "</span>\u4f60\uff0c\u7ed9\u4e88[npc.herHim]\u5982\u6b64\u4eb2\u5bc6\u7684\u8eab\u4f53\u63a5\u89e6\uff0c\u8ba9[npc.her]\u66f4\u559c\u6b22\u4f60\u4e86\uff01\u4e0d\u8fc7\uff0c\u53d7\u5230\u5982\u6b64\u719f\u6089\u7684\u5bf9\u5f85\u5bf9[npc.her]\u7684\u670d\u4ece\u6027\u4ea7\u751f\u4e86\u4e00\u70b9\u8d1f\u9762\u5f71\u54cd\u2026\u2026</i></p>");
                            break;
                        }
                        case LIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.Name]\u53d1\u51fa\u4e00\u58f0\u5145\u6ee1\u7231\u610f\u7684\u5598\u606f\uff0c\u6b6a\u4e86\u6b6a\u5934\uff0c\u5411\u4f60\u8d70\u6765\u3002[npc.speech(\u611f\u89c9\u771f\u597d\u2026\u2026\u7ee7\u7eed\u4e0d\u8981\u505c\uff01)]</p><p>\u4f60\u6309\u7167[npc.she]\u7684\u8981\u6c42\uff0c\u7ee7\u7eed\u629a\u6478\u548c\u62cd\u6253[npc.her]\u7684\u5934\u597d\u4e00\u4f1a\u513f\u3002\u6700\u540e\uff0c\u4f60\u89c9\u5f97[npc.name]\u5df2\u7ecf\u4eab\u53d7\u591f\u4e86\uff0c\u4e8e\u662f\u628a[pc.hand]\u62ff\u5f00\uff0c\u770b\u7740\u4f60\u7684\u5974\u96b6\u53d1\u51fa\u6ee1\u8db3\u7684\u5598\u606f\uff0c\u4f60\u7b11\u4e86\u3002</p>");
                                    break;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("[npc.Name]\u53d1\u51fa\u4e00\u58f0\u5145\u6ee1\u7231\u610f\u7684\u5598\u606f\uff0c\u6b6a\u4e86\u6b6a\u5934\uff0c\u5411\u4f60\u8d70\u6765\u3002[npc.speech(\u8c22\u8c22\u4f60\uff0c[npc.pcName]\uff01\u611f\u89c9\u771f\u7684\u5f88\u597d\uff01\u8bf7\u4e0d\u8981\u505c\u4e0b\u6765\uff01)]</p><p>\u4f60\u6309\u7167[npc.she]\u7684\u8981\u6c42\uff0c\u7ee7\u7eed\u629a\u6478\u548c\u62cd\u6253[npc.her]\u7684\u5934\u597d\u4e00\u4f1a\u513f\u3002\u6700\u540e\uff0c\u4f60\u89c9\u5f97[npc.name]\u5df2\u7ecf\u4eab\u53d7\u591f\u4e86\uff0c\u4e8e\u662f\u628a[pc.hand]\u62ff\u5f00\uff0c\u770b\u7740\u4f60\u7684\u5974\u96b6\u53d1\u51fa\u6ee1\u8db3\u7684\u5598\u606f\uff0c\u4f60\u7b11\u4e86\u3002</p>");
                                    break;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.Name]\u53d1\u51fa\u4e00\u58f0\u5145\u6ee1\u7231\u610f\u7684\u5598\u606f\uff0c\u6b6a\u4e86\u6b6a\u5934\uff0c\u5411\u4f60\u8d70\u6765\u3002[npc.speech(\u8c22\u8c22\u4f60\uff0c[npc.pcName]\uff01)]</p><p>\u5728[npc.her]\u53cd\u5e94\u7684\u9f13\u52b1\u4e0b\uff0c\u4f60\u7ee7\u7eed\u629a\u6478\u548c\u62cd\u6253[npc.her]\u7684\u5934\uff0c\u6301\u7eed\u4e86\u597d\u4e00\u4f1a\u513f\u3002\u6700\u540e\uff0c\u4f60\u89c9\u5f97[npc.name]\u5df2\u7ecf\u4eab\u53d7\u591f\u4e86\uff0c\u4e8e\u662f\u628a[pc.hand]\u62ff\u5f00\uff0c\u770b\u7740\u4f60\u7684\u5974\u96b6\u53d1\u51fa\u6ee1\u8db3\u7684\u5598\u606f\uff0c\u4f60\u7b11\u4e86\u3002</p>");
                                }
                            }
                            UtilText.nodeContentSB.append("<p><i>\u7531\u4e8e[npc.Name]<span style='" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getColour().toWebHexString() + "'>" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getDescriptor() + "</span>\u4f60\uff0c\u7ed9\u4e88[npc.herHim]\u5982\u6b64\u4eb2\u5bc6\u7684\u8eab\u4f53\u63a5\u89e6\uff0c\u8ba9[npc.her]\u66f4\u559c\u6b22\u4f60\u4e86\uff01\u4e0d\u8fc7\uff0c\u53d7\u5230\u5982\u6b64\u719f\u6089\u7684\u5bf9\u5f85\u5bf9[npc.her]\u7684\u670d\u4ece\u6027\u4ea7\u751f\u4e86\u4e00\u70b9\u8d1f\u9762\u5f71\u54cd\u2026\u2026</i></p>");
                        }
                    }
                }
                UtilText.nodeContentSB.append(SlaveDialogue.getFooterText());
                return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return SLAVE_START.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return SLAVE_START.getResponse(responseTab, index);
            }
        };
        SLAVE_PRESENT = new DialogueNode("", "", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u7ed9[npc.Name]\u793c\u7269", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append("<p>\u4f60\u8ba4\u4e3a[npc.Name]\u503c\u5f97\u5728\u8fd9\u4e2a\u5723\u8bde\u8282\u6536\u5230\u4e00\u4efd\u793c\u7269\uff0c\u4e8e\u662f\u5c06\u793c\u7269\u9012\u7ed9\u4e86[npc.herHim]\u3002[pc.speech(\u8fd9\u662f\u7ed9\u4f60\u7684\uff0c[npc.name]\u3002\u5723\u8bde\u5feb\u4e50)]</p><p>");
                switch (AffectionLevelBasic.getAffectionLevelFromValue(SlaveDialogue.getSlave().getAffection(Main.game.getPlayer()))) {
                    case DISLIKE: {
                        switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                            case DISOBEDIENT: {
                                UtilText.nodeContentSB.append("\u4f60\u628a\u793c\u7269\u585e\u8fdb[npc.Name][npc.hands]\u91cc\uff0c[npc.she]\u5583\u5583\u81ea\u8bed\uff0c[npc.speech(\u7ed9\uff0c\u7ed9\u6211\u7684\uff1f\u4f60\u77e5\u9053\u6211\u8fd8\u662f\u6068\u4f60\u7684\u2026\u2026)]</p>");
                                break;
                            }
                            case NEUTRAL: {
                                UtilText.nodeContentSB.append("\u5f53\u4f60\u628a\u793c\u7269\u585e\u8fdb[npc.her][npc.hands]\u91cc\u7684\u65f6\u5019\uff0c[npc.she]\u5583\u5583\u81ea\u8bed\u9053\uff0c[npc.speech(\u7ed9\uff0c\u7ed9\u6211\u7684\uff1f\u90a3\u6211\u5c31\u6536\u4e0b\u4e86\u2026\u2026)]</p>");
                                break;
                            }
                            case OBEDIENT: {
                                UtilText.nodeContentSB.append("[npc.Name]\u5b8c\u5168\u63aa\u624b\u4e0d\u53ca\uff0c\u4e0d\u77e5\u9053\u8be5\u5982\u4f55\u56de\u5e94\u3002\u4f60\u628a\u793c\u7269\u585e\u8fdb[npc.her][npc.hands]\u91cc\u3002[npc.she]\u9547\u5b9a\u4e0b\u6765\uff0c\u51b7\u51b7\u5730\u8bf4\uff0c[npc.speech(\u5982\u679c\u8fd9\u662f\u4f60\u7684\u6240\u60f3\u7684\u8bdd\uff0c\u6211\u4f1a\u63a5\u53d7\u7684\uff0c[npc.pcName]\u3002)]</p>");
                            }
                        }
                        UtilText.nodeContentSB.append("<p><i>\u5c3d\u7ba1[npc.she]<span style='" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getColour().toWebHexString() + "'>" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getDescriptor() + "</span>\u4f60\uff0c[npc.name]\u5f88\u9ad8\u5174\u80fd\u5f97\u5230\u4e00\u4efd\u793c\u7269\uff01</i></p>");
                        break;
                    }
                    case NEUTRAL: {
                        switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                            case DISOBEDIENT: {
                                UtilText.nodeContentSB.append("\u5f53\u4f60\u628a\u793c\u7269\u585e\u8fdb[npc.her][npc.hands]\u91cc\u7684\u65f6\u5019\uff0c[npc.she]\u5bf9\u4f60\u5fae\u7b11\u3002[npc.speech(\u7ed9-\u7ed9\u6211\u7684\uff1f\u8c22\u8c22\u4f60\uff0c[npc.pcName]\uff01)]</p>");
                                break;
                            }
                            case NEUTRAL: {
                                UtilText.nodeContentSB.append("\u5f53\u4f60\u628a\u793c\u7269\u585e\u8fdb[npc.her][npc.hands]\u91cc\u7684\u65f6\u5019\uff0c[npc.she]\u5bf9\u4f60\u5fae\u7b11\u3002[npc.speech(\u7ed9-\u7ed9\u6211\u7684\uff1f\u8c22\u8c22\u4f60\uff0c[npc.pcName]\uff01)]</p>");
                                break;
                            }
                            case OBEDIENT: {
                                UtilText.nodeContentSB.append("\u4f60\u628a\u793c\u7269\u585e\u8fdb[npc.Name][npc.hands]\u91cc\uff0c[npc.she]\u5bf9\u4f60\u5fae\u7b11\u3002[npc.speech(\u8c22\u8c22\u4f60\uff0c[npc.pcName]\uff0c\u6211\u4e5f\u795d\u4f60\u5723\u8bde\u5feb\u4e50\uff01)]</p>");
                            }
                        }
                        UtilText.nodeContentSB.append("<p><i>\u867d\u7136[npc.Name]\u5f88\u9ad8\u5174\u80fd\u5f97\u5230\u793c\u7269\uff0c\u4f46\u53d7\u5230\u5982\u6b64\u53cb\u597d\u7684\u5bf9\u5f85\u964d\u4f4e\u4e86[npc.her]\u7684\u670d\u4ece\u6027\u2026\u2026</i></p>");
                        break;
                    }
                    case LIKE: {
                        switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                            case DISOBEDIENT: {
                                UtilText.nodeContentSB.append("\u5f53\u4f60\u628a\u793c\u7269\u585e\u8fdb[npc.her][npc.hands]\u91cc\u7684\u65f6\u5019\uff0c[npc.she]\u8ff8\u53d1\u51fa\u4e00\u9635\u72c2\u559c\uff0c[npc.speech([npc.PcName]\uff01\u975e\u5e38\u611f\u8c22\uff01\u4e5f\u795d\u4f60\u5723\u8bde\u5feb\u4e50)]</p>");
                                break;
                            }
                            case NEUTRAL: {
                                UtilText.nodeContentSB.append("\u5f53\u4f60\u628a\u793c\u7269\u585e\u8fdb[npc.her][npc.hands]\u91cc\u7684\u65f6\u5019\uff0c[npc.she]\u8ff8\u53d1\u51fa\u4e00\u9635\u72c2\u559c\uff0c[npc.speech([npc.PcName]\uff01\u975e\u5e38\u611f\u8c22\uff01\u4e5f\u795d\u4f60\u5723\u8bde\u5feb\u4e50)]</p>");
                                break;
                            }
                            case OBEDIENT: {
                                UtilText.nodeContentSB.append("\u5f53\u4f60\u628a\u793c\u7269\u585e\u8fdb[npc.her][npc.hands]\u91cc\u7684\u65f6\u5019\uff0c[npc.she]\u5411\u4f60\u6295\u6765\u8d5e\u8bb8\u7684\u76ee\u5149\u3002[npc.speech(\u8c22\u8c22\u4f60\uff0c[npc.pcName]\uff01\u4e5f\u795d\u4f60\u5723\u8bde\u5feb\u4e50\uff01)]</p>");
                            }
                        }
                        UtilText.nodeContentSB.append("<p><i>\u867d\u7136[npc.Name]\u5f88\u9ad8\u5174\u80fd\u5f97\u5230\u793c\u7269\uff0c\u4f46\u53d7\u5230\u5982\u6b64\u53cb\u597d\u7684\u5bf9\u5f85\u964d\u4f4e\u4e86[npc.her]\u7684\u670d\u4ece\u6027\u2026\u2026</i></p>");
                    }
                }
                UtilText.nodeContentSB.append(SlaveDialogue.getFooterText());
                return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return SLAVE_START.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return SLAVE_START.getResponse(responseTab, index);
            }
        };
        SLAVE_INSPECT = new DialogueNode("", "", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u5ba1\u89c6[npc.Name]", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                String legsSpreading;
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append("<p>" + (SlaveDialogue.isSlaveNaked() ? "\u4f60\u51b3\u5b9a\u8981\u68c0\u67e5\u4e00\u4e0b[npc.namePos]\u7684\u88f8\u4f53\uff0c\u4e8e\u662f\u547d\u4ee4[npc.herHim]\u9000\u540e\u4e00\u6b65\uff0c\u8fd9\u6837\u4f60\u5c31\u80fd\u66f4\u597d\u5730\u89c2\u5bdf[npc.herHim]\u3002" : "\u4f60\u51b3\u5b9a\u68c0\u67e5\u4e00\u4e0b[npc.namePos]\u7684\u8eab\u4f53\uff0c\u4e8e\u662f\u547d\u4ee4[npc.herHim]\u8131\u5149\u8863\u670d\uff0c\u7136\u540e\u9000\u540e\u4e00\u6b65\uff0c\u4ee5\u4fbf\u66f4\u597d\u5730\u89c2\u5bdf[npc.herHim]\u3002") + "</p><p>");
                String string = legsSpreading = SlaveDialogue.getSlave().hasLegs() ? "\u5f20\u5f00[npc.her]\u7684[npc.legs]\u5e76\u5c55\u793a[npc.her]" : "\u5c55\u793a\u7ed9\u4f60[npc.her]";
                if (SlaveDialogue.isDoll()) {
                    UtilText.nodeContentSB.append((SlaveDialogue.isSlaveNaked() ? "[npc.She]\u7acb\u5373\u56de\u5e94\u4e86\u4f60\u7684\u547d\u4ee4\uff0c\u987a\u4ece\u5730\u540e\u9000\u4e00\u6b65\u5e76\u8be2\u95ee," : "[npc.She]\u7acb\u5373\u54cd\u5e94\u4f60\u7684\u547d\u4ee4\uff0c\u987a\u4ece\u5730\u5c06[npc.her]\u7684\u8863\u670d\u4e22\u5f03\u5728\u4e86\u5730\u677f\u4e0a\u3002\u5f53[npc.she]\u8131\u4e0b[npc.her]\u7684\u6700\u540e\u4e00\u4ef6\u8863\u670d\u65f6\uff0c[npc.she]\u95ee\u9053\uff0c") + "[npc.speech(\u4f60\u6ee1\u610f\u4e86\u5417\uff0c[npc.pcName]\uff1f)]</p><p>\u4f60\u7ed9\u4e88\u4e86\u80af\u5b9a\u7684\u56de\u7b54\uff0c\u7136\u540e\u547d\u4ee4[npc.Name]\u5728\u4f60\u9762\u524d\u5c55\u793a\u81ea\u5df1\uff1b[npc.she]\u518d\u6b21\u5c3d\u804c\u5c3d\u8d23\u5730\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002\u5728\u8fd9\u4e4b\u540e\uff0c\u4f60\u8ba9[npc.herHim]" + legsSpreading + SlaveDialogue.partInspection() + "\u6700\u540e\uff0c\u4f60\u547d\u4ee4\u4f60\u7684\u73a9\u5076\u5c55\u793a\u9888\u90e8\u540e\u9762\u7684\u63a5\u53e3\uff0c\u5e76\u68c0\u67e5\u786e\u4fdd\u5176\u5904\u4e8e\u5b8c\u7f8e\u72b6\u6001\u3002</p><p>\u4f60\u5bf9[npc.Name]\u7684\u5916\u8868\u611f\u5230\u6ee1\u610f\uff0c\u8ba9[npc.her]" + (SlaveDialogue.isSlaveNaked() ? "\u5728\u4f60\u9762\u524d\u91cd\u65b0\u7ad9\u8d77\u6765" : "\u91cd\u65b0\u7a7f\u4e0a\u8863\u670d") + "\uff0c\u7136\u540e[npc.she]\u6beb\u65e0\u6028\u8a00\u5730\u518d\u6b21\u7167\u4f60\u8bf4\u7684\u505a\u4e86\u3002</p>");
                } else if (SlaveDialogue.getSlave().getFetishDesire(Fetish.FETISH_MASOCHIST).isPositive() || SlaveDialogue.getSlave().getFetishDesire(Fetish.FETISH_EXHIBITIONIST).isPositive()) {
                    block0 : switch (AffectionLevelBasic.getAffectionLevelFromValue(SlaveDialogue.getSlave().getAffection(Main.game.getPlayer()))) {
                        case DISLIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.she]\u542c\u5230\u4f60\u7684\u547d\u4ee4\uff0c\u751f\u6c14\u5730\u76b1\u8d77\u4e86\u7709\u5934\u3002\u4f46[npc.she]\u610f\u8bc6\u5230\u81ea\u5df1\u522b\u65e0\u9009\u62e9\uff0c\u53ea\u597d\u52c9\u5f3a\u670d\u4ece\u3002" + (SlaveDialogue.isSlaveNaked() ? "[npc.she]\u53cc\u76ee\u5706\u7741\uff0c\u6012\u89c6\u7740\u4f60\uff0c\u5486\u54ee\u9053\uff0c" : "[npc.she]\u5486\u54ee\u7740\u8131\u4e0b\u8863\u670d\uff0c") + "[npc.speech(\u8be5\u6b7b\u7684" + (Main.game.getPlayer().isFeminine() ? "\u5a4a\u5b50" : "\u6df7\u7403") + "\uff01\u7ee7\u7eed\uff01\u4ed4\u7ec6\u770b\u770b\u4f60\u7684<i>\u8d22\u4ea7</i>\u5427\uff0c\u4f60\u8fd9\u4e2a\u75c5\u6001\u7684\u6df7\u86cb\uff01)]</p><p>\u5c3d\u7ba1[npc.namePos]\u8a00\u8f9e\u6fc0\u70c8\uff0c\u4f46\u4f60\u8fd8\u662f\u4ece[npc.her]\u7684\u58f0\u97f3\u4e2d\u542c\u51fa\u4e86\u4e00\u4e1d\u5174\u594b\uff0c\u4f60\u547d\u4ee4[npc.herHim]\u5728\u4f60\u9762\u524d\u9732\u51fa\uff0c[npc.she]\u51e0\u4e4e\u6ca1\u6709\u62b5\u6297\u3002\u5728\u8fd9\u4e4b\u540e\uff0c\u4f60\u8ba9[npc.herHim]" + legsSpreading + SlaveDialogue.partInspection() + "\u4f60\u5bf9[npc.Name]\u7684\u5916\u8868\u611f\u5230\u6ee1\u610f\uff0c\u8ba9[npc.her]" + (SlaveDialogue.isSlaveNaked() ? "\u5728\u4f60\u9762\u524d\u91cd\u65b0\u7ad9\u8d77\u6765" : "\u91cd\u65b0\u7a7f\u4e0a\u8863\u670d") + "\uff0c\u800c\u5c3d\u7ba1\u8fd9\u8ba9\u4f60\u90a3\u4e0d\u987a\u4ece\u7684\u5974\u96b6\u53c8\u53d1\u8868\u4e86\u4e00\u53e5\u607c\u6012\u7684\u8a00\u8bba\uff0c\u4f60\u786e\u4fe1[npc.she]\u5728\u5077\u5077\u4eab\u53d7\u5411\u4f60\u5c55\u793a\u81ea\u5df1\u3002</p>");
                                    break;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("\u542c\u5230\u4f60\u7684\u547d\u4ee4\uff0c[npc.she]\u65e0\u5948\u5730\u53f9\u4e86\u53e3\u6c14\uff0c\u4f46\u8fd8\u662f\u52aa\u529b\u63a7\u5236\u4f4f[npc.her]\u7684\u60c5\u7eea\uff0c\u52c9\u5f3a\u670d\u4ece\u547d\u4ee4\u3002" + (SlaveDialogue.isSlaveNaked() ? "\u77aa\u7740\u4f60\uff0c[npc.she]\u51b7\u7b11\u9053\uff1a" : "[npc.she]\u6076\u58f0\u6076\u6c14\u5730\u8131\u4e0b\u8863\u670d\uff0c") + "[npc.speech(\u5f88\u597d\uff0c<i>[npc.pcName]</i>\u3002)]</p><p>\u5c3d\u7ba1[npc.her]\u7684\u8bed\u6c14\u7565\u663e\u53db\u9006\uff0c\u4f46\u4f60\u8fd8\u662f\u4ece[npc.namePos]\u7684\u58f0\u97f3\u4e2d\u542c\u51fa\u4e86\u4e00\u4e1d\u5feb\u611f\uff0c\u4f60\u547d\u4ee4[npc.herHim]\u5728\u4f60\u9762\u524d\u5c55\u793a\u81ea\u5df1\uff0c[npc.she]\u610f\u5916\u5730\u51e0\u4e4e\u6ca1\u62b5\u6297\u3002\u5728\u8fd9\u4e4b\u540e\uff0c\u4f60\u8ba9[npc.herHim]" + legsSpreading + SlaveDialogue.partInspection() + "\u4f60\u5bf9[npc.Name]\u7684\u5916\u8868\u611f\u5230\u6ee1\u610f\uff0c\u8ba9[npc.her]" + (SlaveDialogue.isSlaveNaked() ? "\u5728\u4f60\u9762\u524d\u91cd\u65b0\u7ad9\u8d77\u6765" : "\u91cd\u65b0\u7a7f\u4e0a\u8863\u670d") + "\uff0c\u800c\u4ece[npc.her]\u5931\u671b\u7684\u53f9\u606f\u58f0\u4e2d\uff0c\u4f60\u53ef\u4ee5\u770b\u51fa[npc.she]\u5f88\u559c\u6b22\u5411\u4f60\u5c55\u793a[npc.herself]\u3002</p>");
                                    break;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append((SlaveDialogue.isSlaveNaked() ? "[npc.she]\u7acb\u5373\u670d\u4ece\u4f60\u7684\u547d\u4ee4\uff0c\u4f46\u4f60\u770b\u5230[npc.her][npc.eyes]\u91cc\u660e\u663e\u6d41\u9732\u51fa\u618e\u6068\u7684\u795e\u60c5\uff0c[npc.her]\u987a\u4ece\u5730\u540e\u9000\u5e76\u95ee\u9053\uff0c" : "[npc.she]\u987a\u4ece\u5730\u628a[npc.her]\u7684\u8863\u670d\u6254\u5230\u5730\u4e0a\uff0c[npc.her]\u7acb\u5373\u79fb\u52a8\u811a\u6b65\u53bb\u670d\u4ece\u4f60\u7684\u547d\u4ee4\uff0c\u4f46\u4f60\u770b\u5230\u4e86[npc.her][npc.eyes]\u4e2d\u660e\u663e\u7684\u4ec7\u6068\u795e\u60c5\u3002\u5f53[npc.she]\u8131\u4e0b[npc.her]\u7684\u6700\u540e\u4e00\u4ef6\u8863\u670d\u65f6\uff0c[npc.she]\u95ee\u9053\uff0c") + "[npc.speech(\u4f60\u6ee1\u610f\u4e86\u5417\uff0c[npc.pcName]\uff1f)]</p><p>\u4f60\u7ed9\u4e88\u4e86\u80af\u5b9a\u7684\u56de\u7b54\uff0c\u7136\u540e\u547d\u4ee4[npc.Name]\u5728\u4f60\u9762\u524d\u5c55\u793a\u81ea\u5df1\uff1b[npc.she]\u518d\u6b21\u5c3d\u804c\u5c3d\u8d23\u5730\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002\u5728\u8fd9\u4e4b\u540e\uff0c\u4f60\u8ba9[npc.herHim]" + legsSpreading + SlaveDialogue.partInspection() + "\u4f60\u5bf9[npc.Name]\u7684\u5916\u8868\u611f\u5230\u6ee1\u610f\uff0c\u4fbf\u8ba9[npc.her]" + (SlaveDialogue.isSlaveNaked() ? "\u5728\u4f60\u9762\u524d\u91cd\u65b0\u7ad9\u8d77\u6765" : "\u91cd\u65b0\u7a7f\u4e0a\u8863\u670d") + "\uff0c\u7136\u540e\uff0c[npc.she]\u6beb\u65e0\u6028\u8a00\u5730\u518d\u6b21\u7167\u4f60\u8bf4\u7684\u505a\u4e86\u3002\u4ece[npc.her]\u8138\u988a\u6cdb\u7ea2\u7684\u6837\u5b50\u53ef\u4ee5\u770b\u51fa\uff0c[npc.she]\u5f88\u559c\u6b22\u5411\u4f60\u5c55\u793a[npc.herself]\u3002</p>");
                                }
                            }
                            break;
                        }
                        case NEUTRAL: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.she]\u542c\u5230\u4f60\u7684\u547d\u4ee4\u540e\uff0c\u53d1\u51fa\u4e86\u6b22\u5feb\u7684\u53eb\u58f0\uff0c\u5e76\u8fc5\u901f\u884c\u52a8\u8d77\u6765\u670d\u4ece\u547d\u4ee4\u3002" + (SlaveDialogue.isSlaveNaked() ? "\u5bf9\u7740\u4f60\u9732\u51fa\u8bf1\u4eba\u7684\u5fae\u7b11\uff0c[npc.she][npc.moansVerb]\u9053\uff0c" : "[npc.she][npc.moansVerb]\uff0c\u8131\u4e0b\u8863\u670d\uff0c") + "[npc.speech(~\u59c6\u59c6\u59c6~ \u5e0c\u671b\u4f60\u548c\u6211\u4e00\u6837\u559c\u6b22\u8fd9\u4e2a\uff0c[npc.pcName]\u2026\u2026)]</p><p>\u4f60\u65e0\u89c6[npc.her]\u7684\u8bdd\u8bed\uff0c\u547d\u4ee4[npc.Name]\u5728\u4f60\u9762\u524d\u5c55\u793a\u81ea\u5df1\uff1b[npc.she]\u518d\u6b21\u8feb\u4e0d\u53ca\u5f85\u5730\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002\u5728\u8fd9\u4e4b\u540e\uff0c\u4f60\u8ba9[npc.herHim]" + legsSpreading + SlaveDialogue.partInspection() + "\u4f60\u5bf9[npc.Name]\u7684\u5916\u8868\u611f\u5230\u6ee1\u610f\uff0c\u8ba9[npc.her]" + (SlaveDialogue.isSlaveNaked() ? "\u5728\u4f60\u9762\u524d\u91cd\u65b0\u7ad9\u8d77\u6765" : "\u91cd\u65b0\u7a7f\u4e0a\u8863\u670d") + "\u8fd9\u5f15\u6765\u4e86\u4f60\u4e0d\u542c\u8bdd\u7684\u5974\u96b6\u7684\u4e00\u58f0\u5931\u671b\u7684\u53f9\u606f\u3002</p>");
                                    break;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("[npc.she]\u542c\u5230\u4f60\u7684\u547d\u4ee4\uff0c\u9ad8\u5174\u5730\u53eb\u4e86\u4e00\u58f0\uff0c\u4f46\u8fd8\u662f\u52aa\u529b\u63a7\u5236\u4f4f[npc.her]\u7684\u60c5\u7eea\uff0c\u8fc5\u901f\u884c\u52a8\u8d77\u6765\u670d\u4ece\u547d\u4ee4\u3002" + (SlaveDialogue.isSlaveNaked() ? "\u5bf9\u7740\u4f60\u9732\u51fa\u8bf1\u4eba\u7684\u5fae\u7b11\uff0c[npc.she][npc.moansVerb]\u9053\uff0c" : "[npc.she][npc.moansVerb]\uff0c\u8131\u4e0b\u8863\u670d\uff0c") + "[npc.speech(\u6211\u5e0c\u671b\u8fd9\u80fd\u8ba9\u4f60\u6ee1\u610f\uff0c[npc.pcName]\u3002)]</p><p>\u5728[npc.she]\u8131\u5149\u8863\u670d\u540e\uff0c\u4f60\u547d\u4ee4[npc.Name]\u5728\u4f60\u9762\u524d\u5c55\u793a\u81ea\u5df1\uff1b[npc.she]\u518d\u6b21\u8feb\u4e0d\u53ca\u5f85\u5730\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002\u5728\u8fd9\u4e4b\u540e\uff0c\u4f60\u8ba9[npc.herHim]" + legsSpreading + SlaveDialogue.partInspection() + "\u4f60\u5bf9[npc.Name]\u7684\u5916\u8868\u611f\u5230\u6ee1\u610f\uff0c\u8ba9[npc.her]" + (SlaveDialogue.isSlaveNaked() ? "\u5728\u4f60\u9762\u524d\u91cd\u65b0\u7ad9\u8d77\u6765" : "\u91cd\u65b0\u7a7f\u4e0a\u8863\u670d") + "\uff0c\u7136\u540e[npc.she]\u5931\u671b\u5730\u53f9\u4e86\u53e3\u6c14\uff0c\u7167\u4f60\u7684\u5429\u5490\u505a\u4e86\u3002</p>");
                                    break;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append((SlaveDialogue.isSlaveNaked() ? "[npc.she]\u987a\u4ece\u5730\u540e\u9000\uff0c\u4f60\u770b\u5230[npc.her]\u7684[npc.eyes]\u91cc\u6d41\u9732\u51fa\u660e\u663e\u7684\u5174\u594b\u795e\u60c5\uff0c\u95ee\u9053\uff0c" : "[npc.she]\u987a\u4ece\u5730\u628a[npc.her]\u7684\u8863\u670d\u8131\u5230\u5730\u4e0a\uff0c\u4f60\u770b\u5230[npc.her]\u7684[npc.eyes]\u91cc\u6d41\u9732\u51fa\u660e\u663e\u7684\u5174\u594b\u795e\u60c5\u3002\u5f53[npc.she]\u8131\u4e0b[npc.her]\u7684\u6700\u540e\u4e00\u4ef6\u8863\u670d\u65f6\uff0c[npc.she]\u95ee\u9053\uff0c") + "[npc.speech(\u4f60\u6ee1\u610f\u4e86\u5417\uff0c[npc.pcName]\uff1f)]</p><p>\u4f60\u7ed9\u4e88\u4e86\u80af\u5b9a\u7684\u56de\u7b54\uff0c\u7136\u540e\u547d\u4ee4[npc.Name]\u5728\u4f60\u9762\u524d\u5c55\u793a\u81ea\u5df1\uff1b[npc.she]\u518d\u6b21\u5c3d\u804c\u5c3d\u8d23\u5730\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002\u5728\u8fd9\u4e4b\u540e\uff0c\u4f60\u8ba9[npc.herHim]" + legsSpreading + SlaveDialogue.partInspection() + "\u4f60\u5bf9[npc.Name]\u7684\u5916\u8868\u611f\u5230\u6ee1\u610f\uff0c\u8ba9[npc.her]" + (SlaveDialogue.isSlaveNaked() ? "\u5728\u4f60\u9762\u524d\u91cd\u65b0\u7ad9\u8d77\u6765" : "\u91cd\u65b0\u7a7f\u4e0a\u8863\u670d") + "\uff0c\u7136\u540e[npc.she]\u6beb\u65e0\u6028\u8a00\u5730\u518d\u6b21\u7167\u4f60\u8bf4\u7684\u505a\u4e86\u3002\u4ece[npc.her]\u8138\u988a\u6cdb\u7ea2\u7684\u6837\u5b50\u53ef\u4ee5\u770b\u51fa\uff0c[npc.she]\u5f88\u559c\u6b22\u5411\u4f60\u5c55\u793a[npc.herself]\u3002</p>");
                                }
                            }
                            break;
                        }
                        case LIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.she]\u542c\u5230\u4f60\u7684\u547d\u4ee4\u540e\u9ad8\u5174\u5730\u53eb\u4e86\u4e00\u58f0\uff0c\u5e76\u8fc5\u901f\u884c\u52a8\u8d77\u6765\u670d\u4ece\u547d\u4ee4\u3002" + (SlaveDialogue.isSlaveNaked() ? "\u5bf9\u7740\u4f60\u9732\u51fa\u8bf1\u4eba\u7684\u5fae\u7b11\uff0c[npc.she][npc.moansVerb]\u9053\uff0c" : "[npc.she][npc.moansVerb]\uff0c\u8131\u4e0b\u8863\u670d\uff0c") + "[npc.speech(~\u59c6\u59c6\u59c6~\u88ab\u8feb\u8fd9\u4e48\u505a\u771f\u662f\u6709\u5931\u8eab\u4efd\u2026\u2026\u6211\u559c\u6b22\u2026\u2026)]</p><p>\u4f60\u65e0\u89c6[npc.her]\u7684\u8bdd\u8bed\uff0c\u547d\u4ee4[npc.Name]\u5728\u4f60\u9762\u524d\u5c55\u793a\u81ea\u5df1\uff1b[npc.she]\u518d\u6b21\u9ad8\u5174\u5730\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002\u5728\u8fd9\u4e4b\u540e\uff0c\u4f60\u8ba9[npc.herHim]" + legsSpreading + SlaveDialogue.partInspection() + "\u4f60\u5bf9[npc.Name]\u7684\u5916\u8868\u611f\u5230\u6ee1\u610f\uff0c\u8ba9[npc.her]" + (SlaveDialogue.isSlaveNaked() ? "\u5728\u4f60\u9762\u524d\u91cd\u65b0\u7ad9\u8d77\u6765" : "\u91cd\u65b0\u7a7f\u4e0a\u8863\u670d") + "\u8fd9\u5f15\u6765\u4e86\u4f60\u4e0d\u542c\u8bdd\u7684\u5974\u96b6\u7684\u4e00\u58f0\u5931\u671b\u7684\u53f9\u606f\u3002</p>");
                                    break block0;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("[npc.she]\u542c\u5230\u4f60\u7684\u547d\u4ee4\uff0c\u9ad8\u5174\u5730\u53eb\u4e86\u4e00\u58f0\uff0c\u4f46\u8fd8\u662f\u52aa\u529b\u63a7\u5236\u4f4f\u60c5\u7eea\uff0c\u670d\u4ece\u547d\u4ee4\uff0c\u8fc5\u901f\u884c\u52a8\u8d77\u6765\u3002" + (SlaveDialogue.isSlaveNaked() ? "\u5bf9\u7740\u4f60\u9732\u51fa\u8bf1\u4eba\u7684\u5fae\u7b11\uff0c[npc.she][npc.moansVerb]\u9053\uff0c" : "[npc.she][npc.moansVerb]\uff0c\u8131\u4e0b\u8863\u670d\uff0c") + "[npc.speech(\u6211\u5e0c\u671b\u4f60\u559c\u6b22\uff0c[npc.pcName]\u2026\u2026)]</p><p>\u4f60\u65e0\u89c6[npc.her]\u5145\u6ee1\u60c5\u6b32\u7684\u8bed\u6c14\uff0c\u547d\u4ee4[npc.Name]\u5728\u4f60\u9762\u524d\u8d70\u6765\u8d70\u53bb\uff1b[npc.she]\u518d\u6b21\u6109\u5feb\u5730\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002\u5728\u8fd9\u4e4b\u540e\uff0c\u4f60\u8ba9[npc.herHim]" + legsSpreading + SlaveDialogue.partInspection() + "\u4f60\u5bf9[npc.Name]\u7684\u5916\u8868\u611f\u5230\u6ee1\u610f\uff0c\u8ba9[npc.her]" + (SlaveDialogue.isSlaveNaked() ? "\u5728\u4f60\u9762\u524d\u91cd\u65b0\u7ad9\u8d77\u6765" : "\u91cd\u65b0\u7a7f\u4e0a\u8863\u670d") + "\uff0c\u7136\u540e[npc.she]\u5931\u671b\u5730\u53f9\u4e86\u53e3\u6c14\uff0c\u7167\u4f60\u7684\u5429\u5490\u505a\u4e86\u3002</p>");
                                    break block0;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append((SlaveDialogue.isSlaveNaked() ? "[npc.she]\u987a\u4ece\u5730\u540e\u9000\uff0c\u4f60\u770b\u5230[npc.her]\u7684[npc.eyes]\u91cc\u6d41\u9732\u51fa\u660e\u663e\u7684\u5174\u594b\u795e\u60c5\uff0c\u95ee\u9053\uff0c" : "[npc.she]\u987a\u4ece\u5730\u628a[npc.her]\u7684\u8863\u670d\u8131\u5230\u5730\u4e0a\uff0c\u4f60\u770b\u5230[npc.her]\u7684[npc.eyes]\u91cc\u6d41\u9732\u51fa\u660e\u663e\u7684\u5174\u594b\u795e\u60c5\u3002\u5f53[npc.she]\u8131\u4e0b[npc.her]\u7684\u6700\u540e\u4e00\u4ef6\u8863\u670d\u65f6\uff0c[npc.she]\u95ee\u9053\uff0c") + "[npc.speech(\u4f60\u6ee1\u610f\u4e86\u5417\uff0c[npc.pcName]\uff1f)]</p><p>\u4f60\u7ed9\u4e88\u4e86\u80af\u5b9a\u7684\u56de\u7b54\uff0c\u7136\u540e\u547d\u4ee4[npc.Name]\u5728\u4f60\u9762\u524d\u5c55\u793a\u81ea\u5df1\uff1b[npc.she]\u518d\u6b21\u5c3d\u804c\u5c3d\u8d23\u5730\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002\u5728\u8fd9\u4e4b\u540e\uff0c\u4f60\u8ba9[npc.herHim]" + legsSpreading + SlaveDialogue.partInspection() + "\u4f60\u5bf9[npc.Name]\u7684\u5916\u8868\u611f\u5230\u6ee1\u610f\uff0c\u8ba9[npc.her]" + (SlaveDialogue.isSlaveNaked() ? "\u5728\u4f60\u9762\u524d\u91cd\u65b0\u7ad9\u8d77\u6765" : "\u91cd\u65b0\u7a7f\u4e0a\u8863\u670d") + "\uff0c\u7136\u540e[npc.she]\u6beb\u65e0\u6028\u8a00\u5730\u518d\u6b21\u7167\u4f60\u8bf4\u7684\u505a\u4e86\u3002\u4ece[npc.her]\u8138\u988a\u6cdb\u7ea2\u7684\u6837\u5b50\u53ef\u4ee5\u770b\u51fa\uff0c[npc.she]\u5f88\u559c\u6b22\u5411\u4f60\u5c55\u793a[npc.herself]\u3002</p>");
                                }
                            }
                        }
                    }
                    UtilText.nodeContentSB.append("<p><i>[npc.Name]\u559c\u6b22\u8fd9\u6837\u5c55\u793a[npc.herself]\uff0c[npc.her]\u5bf9\u4f60\u7684\u597d\u611f\u548c[npc.her]\u7684\u670d\u4ece\u6027\u90fd\u4f1a\u589e\u52a0\uff01</i></p>");
                } else {
                    block20 : switch (AffectionLevelBasic.getAffectionLevelFromValue(SlaveDialogue.getSlave().getAffection(Main.game.getPlayer()))) {
                        case DISLIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.she]\u542c\u5230\u4f60\u7684\u547d\u4ee4\uff0c\u751f\u6c14\u5730\u76b1\u8d77\u4e86\u7709\u5934\u3002\u4f46[npc.she]\u610f\u8bc6\u5230\u81ea\u5df1\u522b\u65e0\u9009\u62e9\uff0c\u53ea\u597d\u52c9\u5f3a\u670d\u4ece\u3002" + (SlaveDialogue.isSlaveNaked() ? "[npc.she]\u53cc\u76ee\u5706\u7741\uff0c\u6012\u89c6\u7740\u4f60\uff0c\u5486\u54ee\u9053\uff0c" : "[npc.she]\u5486\u54ee\u7740\u8131\u4e0b\u8863\u670d\uff0c") + "[npc.speech(\u8be5\u6b7b\u7684" + (Main.game.getPlayer().isFeminine() ? "\u5a4a\u5b50" : "\u6df7\u7403") + "\uff01\u7ee7\u7eed\uff01\u4ed4\u7ec6\u770b\u770b\u4f60\u7684<i>\u8d22\u4ea7</i>\u5427\uff0c\u4f60\u8fd9\u4e2a\u75c5\u6001\u7684\u6df7\u86cb\uff01)]</p><p>\u4f60\u65e0\u89c6[npc.her]\u7684\u53cd\u53db\u8a00\u8bba\uff0c\u547d\u4ee4[npc.Name]\u5728\u4f60\u9762\u524d\u5c55\u793a\u81ea\u5df1\uff1b[npc.she]\u518d\u6b21\u52c9\u5f3a\u5730\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002\u5728\u8fd9\u4e4b\u540e\uff0c\u4f60\u8ba9[npc.herHim]" + legsSpreading + SlaveDialogue.partInspection() + "\u4f60\u5bf9[npc.Name]\u7684\u5916\u8868\u611f\u5230\u6ee1\u610f\uff0c\u8ba9[npc.her]" + (SlaveDialogue.isSlaveNaked() ? "\u5728\u4f60\u9762\u524d\u7ad9\u8d77\u6765" : "\u91cd\u65b0\u7a7f\u4e0a\u8863\u670d") + "\u4f60\u4e0d\u542c\u8bdd\u7684\u5974\u96b6[npc.lips]\u4e4b\u95f4\u53c8\u53d1\u51fa\u4e86\u4e00\u53e5\u6124\u6012\u7684\u8bdd\u8bed\u3002</p>");
                                    break;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("\u542c\u5230\u4f60\u7684\u547d\u4ee4\uff0c[npc.she]\u65e0\u5948\u5730\u53f9\u4e86\u53e3\u6c14\uff0c\u4f46\u8fd8\u662f\u52aa\u529b\u63a7\u5236\u4f4f[npc.her]\u7684\u60c5\u7eea\uff0c\u52c9\u5f3a\u670d\u4ece\u547d\u4ee4\u3002" + (SlaveDialogue.isSlaveNaked() ? "\u77aa\u7740\u4f60\uff0c[npc.she]\u51b7\u7b11\u9053\uff1a" : "[npc.she]\u6076\u58f0\u6076\u6c14\u5730\u8131\u4e0b\u8863\u670d\uff0c") + "[npc.speech(\u5f88\u597d\uff0c<i>[npc.pcName]</i>\u3002)]</p><p>\u4f60\u65e0\u89c6[npc.her]\u7565\u5e26\u53cd\u6297\u7684\u8bed\u6c14\uff0c\u547d\u4ee4[npc.Name]\u5728\u4f60\u9762\u524d\u5c55\u793a\u81ea\u5df1\uff1b[npc.she]\u518d\u6b21\u52c9\u5f3a\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002\u5728\u8fd9\u4e4b\u540e\uff0c\u4f60\u8ba9[npc.herHim]" + legsSpreading + SlaveDialogue.partInspection() + "\u4f60\u5bf9[npc.Name]\u7684\u5916\u8868\u611f\u5230\u6ee1\u610f\uff0c\u4fbf\u8ba9[npc.her]" + (SlaveDialogue.isSlaveNaked() ? "\u5728\u4f60\u9762\u524d\u91cd\u65b0\u8d77\u8eab" : "\u91cd\u65b0\u7a7f\u4e0a\u8863\u670d") + "[npc.she]\u89e3\u8131\u822c\u8212\u4e86\u53e3\u6c14\uff0c\u9075\u4ece\u4e86\u4f60\u7684\u547d\u4ee4\u3002</p>");
                                    break;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append((SlaveDialogue.isSlaveNaked() ? "[npc.she]\u7acb\u5373\u670d\u4ece\u4f60\u7684\u547d\u4ee4\uff0c\u4f46\u4f60\u770b\u5230[npc.her][npc.eyes]\u91cc\u660e\u663e\u6d41\u9732\u51fa\u618e\u6068\u7684\u795e\u60c5\uff0c[npc.her]\u987a\u4ece\u5730\u540e\u9000\u5e76\u95ee\u9053\uff0c" : "[npc.she]\u987a\u4ece\u5730\u628a[npc.her]\u7684\u8863\u670d\u6254\u5230\u5730\u4e0a\uff0c[npc.her]\u7acb\u5373\u79fb\u52a8\u811a\u6b65\u53bb\u670d\u4ece\u4f60\u7684\u547d\u4ee4\uff0c\u4f46\u4f60\u770b\u5230\u4e86[npc.her][npc.eyes]\u4e2d\u660e\u663e\u7684\u4ec7\u6068\u795e\u60c5\u3002\u5f53[npc.she]\u8131\u4e0b[npc.her]\u7684\u6700\u540e\u4e00\u4ef6\u8863\u670d\u65f6\uff0c[npc.she]\u95ee\u9053\uff0c") + "[npc.speech(\u4f60\u6ee1\u610f\u4e86\u5417\uff0c[npc.pcName]\uff1f)]</p><p>\u4f60\u7ed9\u4e88\u4e86\u80af\u5b9a\u7684\u56de\u7b54\uff0c\u7136\u540e\u547d\u4ee4[npc.Name]\u5728\u4f60\u9762\u524d\u5c55\u793a\u81ea\u5df1\uff1b[npc.she]\u518d\u6b21\u5c3d\u804c\u5c3d\u8d23\u5730\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002\u5728\u8fd9\u4e4b\u540e\uff0c\u4f60\u8ba9[npc.herHim]" + legsSpreading + SlaveDialogue.partInspection() + "\u4f60\u5bf9[npc.Name]\u7684\u5916\u8868\u611f\u5230\u6ee1\u610f\uff0c\u8ba9[npc.her]" + (SlaveDialogue.isSlaveNaked() ? "\u5728\u4f60\u9762\u524d\u91cd\u65b0\u7ad9\u8d77\u6765" : "\u91cd\u65b0\u7a7f\u4e0a\u8863\u670d") + "\uff0c\u7136\u540e[npc.she]\u6beb\u65e0\u6028\u8a00\u5730\u518d\u6b21\u7167\u4f60\u8bf4\u7684\u505a\u4e86\u3002</p>");
                                }
                            }
                            break;
                        }
                        case NEUTRAL: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.she]\u542c\u5230\u4f60\u7684\u547d\u4ee4\uff0c\u614c\u5f20\u5730\u53eb\u4e86\u4e00\u58f0\uff0c\u4f46\u610f\u8bc6\u5230[npc.she]\u5728\u8fd9\u4ef6\u4e8b\u4e0a\u771f\u7684\u522b\u65e0\u9009\u62e9\uff0c\u53ea\u597d\u52c9\u5f3a\u670d\u4ece\u547d\u4ee4\u3002" + (SlaveDialogue.isSlaveNaked() ? "[npc.her]\u6446\u51fa\u6700\u54c0\u6c42\u7684\u8868\u60c5\uff0c\u62b1\u6028\u9053\uff0c" : "[npc.she]\u62b1\u6028\u7740\u8131\u4e0b\u8863\u670d\uff0c") + "[npc.speech(\u6211\u771f\u7684\u5fc5\u987b\u8fd9\u4e48\u505a\u5417\uff1f\u88ab\u8feb\u8fd9\u6837\u505a\u6709\u70b9\u6709\u8fb1\u4eba\u683c\u2026\u2026)]</p><p>\u4f60\u65e0\u89c6[npc.her]\u7684\u8bdd\u8bed\uff0c\u547d\u4ee4[npc.Name]\u5728\u4f60\u9762\u524d\u5c55\u793a\u81ea\u5df1\uff1b[npc.she]\u518d\u6b21\u52c9\u5f3a\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002\u5728\u8fd9\u4e4b\u540e\uff0c\u4f60\u8ba9[npc.herHim]" + legsSpreading + SlaveDialogue.partInspection() + "\u4f60\u5bf9[npc.Name]\u7684\u5916\u8868\u611f\u5230\u6ee1\u610f\uff0c\u8ba9[npc.her]" + (SlaveDialogue.isSlaveNaked() ? "\u5728\u4f60\u9762\u524d\u91cd\u65b0\u7ad9\u8d77\u6765" : "\u91cd\u65b0\u7a7f\u4e0a\u8863\u670d") + "\u4f60\u4e0d\u542c\u8bdd\u7684\u5974\u96b6\u7684[npc.lips]\u95f4\u53d1\u51fa\u4e00\u58f0\u5982\u91ca\u91cd\u8d1f\u7684\u53f9\u606f\u3002</p>");
                                    break;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("[npc.she]\u542c\u5230\u4f60\u7684\u547d\u4ee4\u540e\uff0c\u53d1\u51fa\u4e86\u4e00\u58f0\u614c\u4e71\u7684\u53eb\u558a\uff0c\u4f46\u8fd8\u662f\u52aa\u529b\u63a7\u5236\u4f4f[npc.her]\u7684\u60c5\u7eea\uff0c\u52c9\u5f3a\u670d\u4ece\u547d\u4ee4\u3002" + (SlaveDialogue.isSlaveNaked() ? "[npc.her]\u6446\u51fa\u6700\u54c0\u6c42\u7684\u8868\u60c5\uff0c\u62b1\u6028\u9053\uff0c" : "[npc.she]\u62b1\u6028\u7740\u8131\u4e0b\u8863\u670d\uff0c") + "[npc.speech(\u7ed9\u6211\u4e00\u70b9\u65f6\u95f4\uff0c[npc.pcName]\u3002)]</p><p>\u5728[npc.sheIs]\u88ab\u5265\u5149\u8863\u670d\u540e\uff0c\u4f60\u547d\u4ee4[npc.Name]\u5728\u4f60\u9762\u524d\u5c55\u793a\u81ea\u5df1\uff1b[npc.she]\u518d\u6b21\u4e0d\u60c5\u613f\u5730\u6267\u884c\u4e86\u8fd9\u4e2a\u547d\u4ee4\u3002\u5728\u8fd9\u4e4b\u540e\uff0c\u4f60\u8ba9[npc.herHim]" + legsSpreading + SlaveDialogue.partInspection() + "\u4f60\u5bf9[npc.Name]\u7684\u5916\u8868\u611f\u5230\u6ee1\u610f\uff0c\u4fbf\u8ba9[npc.her]" + (SlaveDialogue.isSlaveNaked() ? "\u5728\u4f60\u9762\u524d\u91cd\u65b0\u8d77\u8eab" : "\u91cd\u65b0\u7a7f\u4e0a\u8863\u670d") + "[npc.she]\u89e3\u8131\u822c\u8212\u4e86\u53e3\u6c14\uff0c\u9075\u4ece\u4e86\u4f60\u7684\u547d\u4ee4\u3002</p>");
                                    break;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append((SlaveDialogue.isSlaveNaked() ? "[npc.she]\u987a\u4ece\u5730\u540e\u9000\uff0c\u4f60\u770b\u5230[npc.her]\u7684[npc.eyes]\u91cc\u6d41\u9732\u51fa\u660e\u663e\u7684\u75db\u82e6\u795e\u60c5\uff0c\u95ee\u9053\uff0c" : "[npc.she]\u987a\u4ece\u5730\u628a[npc.her]\u7684\u8863\u670d\u8131\u5230\u5730\u4e0a\uff0c\u4f60\u770b\u5230[npc.her]\u7684[npc.eyes]\u91cc\u6d41\u9732\u51fa\u660e\u663e\u7684\u75db\u82e6\u795e\u60c5\u3002\u5f53[npc.she]\u8131\u4e0b[npc.her]\u7684\u6700\u540e\u4e00\u4ef6\u8863\u670d\u65f6\uff0c[npc.she]\u95ee\u9053\uff0c") + "[npc.speech(\u4f60\u6ee1\u610f\u4e86\u5417\uff0c[npc.pcName]\uff1f)]</p><p>\u4f60\u7ed9\u4e88\u4e86\u80af\u5b9a\u7684\u56de\u7b54\uff0c\u7136\u540e\u547d\u4ee4[npc.Name]\u5728\u4f60\u9762\u524d\u5c55\u793a\u81ea\u5df1\uff1b[npc.she]\u518d\u6b21\u5c3d\u804c\u5c3d\u8d23\u5730\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002\u5728\u8fd9\u4e4b\u540e\uff0c\u4f60\u8ba9[npc.herHim]" + legsSpreading + SlaveDialogue.partInspection() + "\u4f60\u5bf9[npc.Name]\u7684\u5916\u8868\u611f\u5230\u6ee1\u610f\uff0c\u8ba9[npc.her]" + (SlaveDialogue.isSlaveNaked() ? "\u5728\u4f60\u9762\u524d\u91cd\u65b0\u7ad9\u8d77\u6765" : "\u91cd\u65b0\u7a7f\u4e0a\u8863\u670d") + "\uff0c\u7136\u540e[npc.she]\u6beb\u65e0\u6028\u8a00\u5730\u518d\u6b21\u7167\u4f60\u8bf4\u7684\u505a\u4e86\u3002</p>");
                                }
                            }
                            break;
                        }
                        case LIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.she]\u542c\u5230\u4f60\u7684\u547d\u4ee4\uff0c\u4f24\u5fc3\u5730\u54ed\u51fa\u6765\uff0c\u4f46\u610f\u8bc6\u5230[npc.she]\u5728\u8fd9\u4ef6\u4e8b\u4e0a\u771f\u7684\u522b\u65e0\u9009\u62e9\uff0c\u53ea\u597d\u52c9\u5f3a\u670d\u4ece\u547d\u4ee4\u3002" + (SlaveDialogue.isSlaveNaked() ? "[npc.her]\u6446\u51fa\u6700\u54c0\u6c42\u7684\u8868\u60c5\uff0c\u62b1\u6028\u9053\uff0c" : "[npc.she]\u62b1\u6028\u7740\u8131\u4e0b\u8863\u670d\uff0c") + "[npc.speech(\u4f60\u77e5\u9053\u5417\uff0c\u88ab\u8feb\u8fd9\u6837\u505a\u6709\u70b9\u6709\u8fb1\u4eba\u683c\u2026\u2026\u6211\u4ee5\u4e3a\u4f60\u559c\u6b22\u6211\u7684\u2026\u2026)]</p><p>\u4f60\u65e0\u89c6[npc.her]\u7684\u8bdd\u8bed\uff0c\u547d\u4ee4[npc.Name]\u5728\u4f60\u9762\u524d\u5c55\u793a\u81ea\u5df1\uff1b[npc.she]\u518d\u6b21\u52c9\u5f3a\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002\u5728\u8fd9\u4e4b\u540e\uff0c\u4f60\u8ba9[npc.herHim]" + legsSpreading + SlaveDialogue.partInspection() + "\u4f60\u5bf9[npc.Name]\u7684\u5916\u8868\u611f\u5230\u6ee1\u610f\uff0c\u8ba9[npc.her]" + (SlaveDialogue.isSlaveNaked() ? "\u5728\u4f60\u9762\u524d\u91cd\u65b0\u7ad9\u8d77\u6765" : "\u91cd\u65b0\u7a7f\u4e0a\u8863\u670d") + "\u4f60\u4e0d\u542c\u8bdd\u7684\u5974\u96b6\u7684[npc.lips]\u95f4\u53d1\u51fa\u4e00\u58f0\u5982\u91ca\u91cd\u8d1f\u7684\u53f9\u606f\u3002</p>");
                                    break block20;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("\u5f53[npc.she]\u542c\u5230\u4f60\u7684\u547d\u4ee4\u65f6\uff0c[npc.she]\u53d1\u51fa\u4e86\u60b2\u4f24\u7684\u54ed\u58f0\uff0c\u4f46\u5979\u52aa\u529b\u63a7\u5236\u4f4f[npc.her]\u7684\u60c5\u7eea\uff0c\u6162\u6162\u5730\u8d70\u53bb\u670d\u4ece\u547d\u4ee4\u3002" + (SlaveDialogue.isSlaveNaked() ? "[npc.her]\u6446\u51fa\u6700\u54c0\u6c42\u7684\u8868\u60c5\uff0c\u62b1\u6028\u9053\uff0c" : "[npc.she]\u62b1\u6028\u7740\u8131\u4e0b\u8863\u670d\uff0c") + "[npc.speech(\u6211\u4ee5\u4e3a\u4f60\u559c\u6b22\u6211\uff0c[npc.pcName]\u2026\u2026\u4f46\u5982\u679c\u8fd9\u662f\u4f60\u60f3\u8981\u7684\u2026\u2026)]</p><p>\u4f60\u65e0\u89c6[npc.her]\u7565\u5e26\u53cd\u6297\u7684\u6297\u8bae\uff0c\u547d\u4ee4[npc.Name]\u5728\u4f60\u9762\u524d\u5c55\u793a\u81ea\u5df1\uff1b[npc.she]\u518d\u6b21\u4e0d\u60c5\u613f\u5730\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002\u5728\u8fd9\u4e4b\u540e\uff0c\u4f60\u8ba9[npc.herHim]" + legsSpreading + SlaveDialogue.partInspection() + "\u4f60\u5bf9[npc.Name]\u7684\u5916\u8868\u611f\u5230\u6ee1\u610f\uff0c\u4fbf\u8ba9[npc.her]" + (SlaveDialogue.isSlaveNaked() ? "\u5728\u4f60\u9762\u524d\u91cd\u65b0\u8d77\u8eab" : "\u91cd\u65b0\u7a7f\u4e0a\u8863\u670d") + "[npc.she]\u89e3\u8131\u822c\u8212\u4e86\u53e3\u6c14\uff0c\u9075\u4ece\u4e86\u4f60\u7684\u547d\u4ee4\u3002</p>");
                                    break block20;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append((SlaveDialogue.isSlaveNaked() ? "[npc.she]\u987a\u4ece\u5730\u540e\u9000\uff0c\u4f60\u770b\u5230[npc.her]\u7684[npc.eyes]\u91cc\u6d41\u9732\u51fa\u660e\u663e\u7684\u75db\u82e6\u795e\u60c5\uff0c\u95ee\u9053\uff0c" : "[npc.she]\u987a\u4ece\u5730\u628a[npc.her]\u7684\u8863\u670d\u8131\u5230\u5730\u4e0a\uff0c\u4f60\u770b\u5230[npc.her]\u7684[npc.eyes]\u91cc\u6d41\u9732\u51fa\u660e\u663e\u7684\u60b2\u4f24\u795e\u60c5\u3002\u5f53[npc.she]\u8131\u4e0b[npc.her]\u7684\u6700\u540e\u4e00\u4ef6\u8863\u670d\u65f6\uff0c[npc.she]\u95ee\u9053\uff0c") + "[npc.speech(\u4f60\u6ee1\u610f\u4e86\u5417\uff0c[npc.pcName]\uff1f)]</p><p>\u4f60\u7ed9\u4e88\u4e86\u80af\u5b9a\u7684\u56de\u7b54\uff0c\u7136\u540e\u547d\u4ee4[npc.Name]\u5728\u4f60\u9762\u524d\u5c55\u793a\u81ea\u5df1\uff1b[npc.she]\u518d\u6b21\u5c3d\u804c\u5c3d\u8d23\u5730\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002\u5728\u8fd9\u4e4b\u540e\uff0c\u4f60\u8ba9[npc.herHim]" + legsSpreading + SlaveDialogue.partInspection() + "\u4f60\u5bf9[npc.Name]\u7684\u5916\u8868\u611f\u5230\u6ee1\u610f\uff0c\u8ba9[npc.her]" + (SlaveDialogue.isSlaveNaked() ? "\u5728\u4f60\u9762\u524d\u91cd\u65b0\u7ad9\u8d77\u6765" : "\u91cd\u65b0\u7a7f\u4e0a\u8863\u670d") + "\uff0c\u7136\u540e[npc.she]\u6beb\u65e0\u6028\u8a00\u5730\u518d\u6b21\u7167\u4f60\u8bf4\u7684\u505a\u4e86\u3002</p>");
                                }
                            }
                        }
                    }
                    UtilText.nodeContentSB.append("<p><i>\u8fd9\u5e76\u6ca1\u6709\u6539\u53d8[npc.name]<span style='" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getColour().toWebHexString() + "'>" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getDescriptor() + "</span>\u4f60\u7684\u4e8b\u5b9e\uff0c[npc.she]\u88ab\u5f3a\u884c\u8131\u5149\u8863\u670d\uff0c\u50cf\u4e00\u5757\u8089\u4e00\u6837\u5728\u4f60\u9762\u524d\u5c55\u793a\u81ea\u5df1\uff0c\u8fd9\u5bf9[npc.her]\u5bf9\u4f60\u7684\u597d\u611f\u4ea7\u751f\u4e86\u5de8\u5927\u7684\u8d1f\u9762\u5f71\u54cd\uff0c\u4f46\u540c\u65f6\u4e5f\u4f1a\u589e\u52a0[npc.her]\u7684\u670d\u4ece\u6027\uff01</i></p>");
                }
                UtilText.nodeContentSB.append(SlaveDialogue.getFooterText());
                return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return SLAVE_START.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return SLAVE_START.getResponse(responseTab, index);
            }
        };
        SLAVE_SPANKING = new DialogueNode("", "", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u6253[npc.Name]\u7684\u5c41\u80a1", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                if (SlaveDialogue.isDoll()) {
                    UtilText.nodeContentSB.append("<p>\u4f60\u8ba4\u4e3a\u6709\u5fc5\u8981\u8ba9[npc.name]\u8bb0\u4f4f[npc.her]\u7684\u8eab\u4efd\u5730\u4f4d\uff0c\u56e0\u6b64\u5728\u5750\u4e0b\u4e4b\u540e\uff0c\u4f60\u547d\u4ee4[npc.herHim]\u8131\u6389\u8863\u7269\u5e76\u5728\u4f60\u7684\u819d\u4e0a\u5f2f\u8170\u5c48\u8eab\u3002</p><p>[npc.She]\u7acb\u5373\u9075\u4ece\u4f60\u7684\u547d\u4ee4\uff0c\u4e56\u4e56\u5730\u5c06[npc.her]\u7684\u8863\u670d\u653e\u5230\u5730\u4e0a\u3002[npc.she]\u8131\u4e0b[npc.her]\u7684\u6700\u540e\u4e00\u4ef6\u8863\u670d\uff0c[npc.she]\u95ee\u9053\uff0c[npc.speech(\u4f60\u6ee1\u610f\u4e86\u5417\uff0c[npc.pcName]\uff1f)]</p><p>\u4f60\u7ed9\u51fa\u4e86\u80af\u5b9a\u7684\u56de\u7b54\uff0c\u7136\u540e\u518d\u6b21\u547d\u4ee4[npc.name]\u8db4\u5728\u4f60\u7684\u819d\u76d6\u4e0a\uff1b[npc.she]\u7acb\u523b\u9075\u4ece\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002[npc.she]\u8eba\u5728\u4f60\u7684\u817f\u4e0a\u5e76\u5c55\u73b0\u51fa[npc.her][npc.ass+]\uff0c\u4f60\u8fc5\u901f\u62ac\u8d77[pc.hand]\uff0c\u91cd\u91cd\u5730\u62cd\u6253[npc.her]\u90a3\u88f8\u9732\u7684\u81c0\u90e8\u3002\u4e00\u9635\u7c7b\u4f3c\u673a\u5668\u7684\u5431\u5566\u58f0\u4f34\u968f\u7740\u7845\u80f6\u88ab\u6253\u65f6\u7684\u6e05\u8106\u58f0\u54cd\uff0c\u8fd9\u4f7f\u5f97\u4f60\u518d\u6b21\u51fa\u624b\u6253\u51fb\u4e86[npc.her]\u7684[npc.ass]\u3002</p><p>\u4f60\u7ee7\u7eed\u8fd9\u6837\u505a\u4e86\u7247\u523b\uff1b\u4f46\u4f60\u7684\u73a9\u5076\u53ea\u662f\u987a\u4ece\u5730\u8db4\u5728\u4f60\u7684\u819d\u4e0a\uff0c\u4efb\u7531\u4f60\u4e00\u638c\u53c8\u4e00\u638c\u5730\u62cd\u6253\u5728[npc.her]\u90a3\u67d4\u5f31\u7684\u81c0\u90e8\u4e0a\u3002\u5c3d\u7ba1[npc.she]\u5728\u4f60\u7684\u60e9\u7f5a\u4e0b\u4ee5\u5c16\u53eb\u548c\u5598\u606f\u7740\u56de\u5e94\uff0c\u4f46\u4f60\u603b\u89c9\u5f97[npc.she]\u662f\u4e3a\u4e86\u8fce\u5408\u4f60\u800c\u505a\u51fa\u8fd9\u6837\u7684\u53cd\u5e94\uff0c\u5b9e\u9645\u4e0a\u8fd9\u79cd\u60e9\u7f5a\u5e76\u672a\u5bf9[npc.herHim]\u9020\u6210\u4efb\u4f55\u4f24\u5bb3\u3002\u89c1\u6b64\u4f60\u53ea\u6709\u7ed3\u675f\u8fd9\u573a\u60e9\u6212\u2026\u2026</p>");
                } else {
                    UtilText.nodeContentSB.append("<p>\u4f60\u89c9\u5f97[npc.Name]\u53ef\u4ee5\u56de\u60f3\u4e00\u4e0b\u8c01\u662f\u8001\u5927\uff0c\u4e8e\u662f\uff0c\u4f60\u5750\u4e0b\u6765\uff0c\u547d\u4ee4[npc.herHim]\u8131\u5149\u8863\u670d\uff0c\u5f2f\u8170\u8db4\u5728\u4f60\u817f\u4e0a\u3002</p><p>");
                    block0 : switch (AffectionLevelBasic.getAffectionLevelFromValue(SlaveDialogue.getSlave().getAffection(Main.game.getPlayer()))) {
                        case DISLIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("\u5f53[npc.her]\u542c\u5230\u4f60\u547d\u4ee4[npc.herHim]\u505a\u4ec0\u4e48\u65f6\uff0c[npc.she]\u5634\u91cc\u53d1\u51fa\u6124\u6012\u7684\u5486\u54ee\u58f0\uff0c\u4f46\u662f[npc.she]\u660e\u767d[npc.she]\u522b\u65e0\u9009\u62e9\uff0c\u53ea\u597d\u52c9\u5f3a\u670d\u4ece\u3002[npc.she]\u6076\u58f0\u6076\u6c14\u6162\u6162\u8131\u6389[npc.her]\u7684\u8863\u670d\uff0c[npc.speech(\u4f60\u8fd9\u8be5\u6b7b\u7684" + (Main.game.getPlayer().isFeminine() ? "\u5a4a\u5b50" : "\u6df7\u7403") + "\uff01\u6211\u771f\u4ed6\u5988\u7684\u6068\u6b7b\u4f60\u4e86\uff01)]</p><p>\u4f60\u65e0\u89c6[npc.her]\u7684\u65e0\u793c\u8a00\u8bba\uff0c\u518d\u6b21\u547d\u4ee4[npc.Name]\u8dea\u4e0b\uff1b[npc.she]\u518d\u6b21\u5c3d\u53ef\u80fd\u78e8\u8e6d\u5730\u6267\u884c\u547d\u4ee4\u3002[npc.she]\u8db4\u5728\u4f60\u5927\u817f\u4e0a\uff0c\u5c55\u793a[npc.her][npc.ass+]\uff0c\u4f60\u53d1\u51fa\u80dc\u5229\u7684\u7b11\u58f0\uff0c\u7136\u540e\u8fc5\u901f\u7528[pc.hand]\u6247[npc.her]\u88f8\u9732\u7684\u5c41\u80a1\u3002\u4e00\u58f0\u5c16\u53eb\u54cd\u8d77\uff0c\u548c\u7740\u8089\u4f53\u88ab\u62cd\u6253\u7684\u58f0\u97f3\uff0c\u4fc3\u4f7f\u4f60\u518d\u6b21\u6253\u5411[npc.her]\u7684[npc.ass]\u3002</p><p>\u4f60\u7ee7\u7eed\u8fd9\u6837\u505a\u4e86\u4e00\u4f1a\u513f\uff1b\u4f60\u7684\u5974\u96b6\u4f0f\u5728\u5927\u817f\u4e0a\u626d\u52a8\u7740\uff0c\u5c16\u53eb\u7740\uff0c\u4f60\u4e00\u4e0b\u53c8\u4e00\u4e0b\u5730\u6253\u7740[npc.her]\u8106\u5f31\u7684\u810a\u80cc\u3002\u6700\u7ec8\uff0c\u4f60\u89c9\u5f97[npc.sheIs]\u5df2\u7ecf\u5f97\u5230\u4e86\u6559\u8bad\uff0c\u4e8e\u662f\u4f60\u547d\u4ee4[npc.herHim]\u7ad9\u8d77\u6765\uff0c\u91cd\u65b0\u7a7f\u4e0a[npc.her]\u7684\u8863\u670d\u3002</p>");
                                    break;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("\u5f53[npc.she]\u542c\u5230\u4f60\u547d\u4ee4[npc.herHim]\u505a\u4ec0\u4e48\u65f6\uff0c[npc.she]\u53d1\u51fa\u4e86\u4e00\u58f0\u60ca\u614c\u5931\u63aa\u7684\u53eb\u58f0\uff0c\u4f46\u662f[npc.her]\u52aa\u529b\u63a7\u5236\u7684\u60c5\u7eea\uff0c\u52c9\u5f3a\u505a\u51fa\u670d\u4ece\u7684\u4e3e\u52a8\u3002[npc.she]\u6162\u6162\u8131\u4e0b[npc.her]\u7684\u8863\u670d\uff0c\u53f9\u4e86\u53e3\u6c14\uff0c[npc.speech(\u8fd9\u9700\u8981\u4e00\u70b9\u70b9\u65f6\u95f4\uff0c<i>[npc.pcName]</i>\u3002)]</p><p>\u4f60\u6ca1\u6709\u7406\u4f1a[npc.her]\u7565\u5e26\u53cd\u6297\u7684\u8bed\u6c14\uff0c\u518d\u6b21\u547d\u4ee4[npc.Name]\u628a\u81ea\u5df1\u8db4\u5230\u4f60\u7684\u819d\u76d6\u4e0a\uff1b[npc.she]\u5c3d\u53ef\u80fd\u78e8\u8e6d\u5730\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002[npc.she]\u8db4\u5728\u4f60\u5927\u817f\u4e0a\uff0c\u5c55\u793a[npc.her][npc.ass+]\uff0c\u4f60\u53d1\u51fa\u80dc\u5229\u7684\u7b11\u58f0\uff0c\u7136\u540e\u8fc5\u901f\u7528[pc.hand]\u6247[npc.her]\u88f8\u9732\u7684\u5c41\u80a1\u3002\u4e00\u58f0\u5c16\u53eb\u54cd\u8d77\uff0c\u548c\u7740\u8089\u4f53\u88ab\u62cd\u6253\u7684\u58f0\u97f3\uff0c\u4fc3\u4f7f\u4f60\u518d\u6b21\u6253\u5411[npc.her]\u7684[npc.ass]\u3002</p><p>\u4f60\u7ee7\u7eed\u8fd9\u6837\u505a\u4e86\u4e00\u4f1a\u513f\uff1b\u4f60\u7684\u5974\u96b6\u4f0f\u5728\u5927\u817f\u4e0a\u626d\u52a8\u7740\uff0c\u5c16\u53eb\u7740\uff0c\u4f60\u4e00\u4e0b\u53c8\u4e00\u4e0b\u5730\u6253\u7740[npc.her]\u8106\u5f31\u7684\u810a\u80cc\u3002\u6700\u7ec8\uff0c\u4f60\u89c9\u5f97[npc.sheIs]\u5df2\u7ecf\u5f97\u5230\u4e86\u6559\u8bad\uff0c\u4e8e\u662f\u4f60\u547d\u4ee4[npc.herHim]\u7ad9\u8d77\u6765\uff0c\u91cd\u65b0\u7a7f\u4e0a[npc.her]\u7684\u8863\u670d\u3002</p>");
                                    break;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.she]\u987a\u4ece\u5730\u628a[npc.her]\u7684\u8863\u670d\u6254\u5230\u5730\u4e0a\uff0c\u7acb\u5373\u79fb\u52a8\u811a\u6b65\u53bb\u670d\u4ece\u4f60\u7684\u547d\u4ee4\uff0c\u4f46\u4f60\u770b\u5230\u4e86[npc.her]\u7684[npc.eyes]\u4e2d\u660e\u663e\u7684\u4ec7\u6068\u795e\u60c5\u3002[npc.she]\u8131\u4e0b[npc.her]\u7684\u6700\u540e\u4e00\u4ef6\u8863\u670d\uff0c[npc.she]\u95ee\u9053\uff0c[npc.speech(\u4f60\u6ee1\u610f\u4e86\u5417\uff0c[npc.pcName]\uff1f)]</p><p>\u4f60\u7ed9\u4e88\u4e86\u80af\u5b9a\u7684\u56de\u7b54\uff0c\u7136\u540e\u518d\u6b21\u547d\u4ee4[npc.Name]\u8ba9[npc.herself]\u8dea\u4e0b\uff1b[npc.she]\u5c3d\u53ef\u80fd\u78e8\u8e6d\u5730\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002[npc.she]\u8db4\u5728\u4f60\u5927\u817f\u4e0a\uff0c\u5c55\u793a[npc.her][npc.ass+]\uff0c\u4f60\u53d1\u51fa\u80dc\u5229\u7684\u7b11\u58f0\uff0c\u7136\u540e\u8fc5\u901f\u7528[pc.hand]\u6247[npc.her]\u88f8\u9732\u7684\u5c41\u80a1\u3002\u4e00\u58f0\u5c16\u53eb\u54cd\u8d77\uff0c\u548c\u7740\u8089\u4f53\u88ab\u62cd\u6253\u7684\u58f0\u97f3\uff0c\u4fc3\u4f7f\u4f60\u518d\u6b21\u6253\u5411[npc.her]\u7684[npc.ass]\u3002</p><p>\u4f60\u7ee7\u7eed\u8fd9\u6837\u505a\u4e86\u4e00\u4f1a\u513f\uff1b\u4f60\u7684\u5974\u96b6\u4f0f\u5728\u5927\u817f\u4e0a\u626d\u52a8\u7740\uff0c\u5c16\u53eb\u7740\uff0c\u4f60\u4e00\u4e0b\u53c8\u4e00\u4e0b\u5730\u6253\u7740[npc.her]\u8106\u5f31\u7684\u810a\u80cc\u3002\u6700\u7ec8\uff0c\u4f60\u89c9\u5f97[npc.sheIs]\u5df2\u7ecf\u5f97\u5230\u4e86\u6559\u8bad\uff0c\u4e8e\u662f\u4f60\u547d\u4ee4[npc.herHim]\u7ad9\u8d77\u6765\uff0c\u91cd\u65b0\u7a7f\u4e0a[npc.her]\u7684\u8863\u670d\u3002</p>");
                                }
                            }
                            break;
                        }
                        case NEUTRAL: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.she]\u542c\u5230\u4f60\u7684\u547d\u4ee4\uff0c\u614c\u5f20\u5730\u53eb\u4e86\u4e00\u58f0\uff0c\u4f46\u610f\u8bc6\u5230[npc.she]\u5728\u8fd9\u4ef6\u4e8b\u4e0a\u771f\u7684\u522b\u65e0\u9009\u62e9\uff0c\u53ea\u597d\u52c9\u5f3a\u670d\u4ece\u547d\u4ee4\u3002[npc.she]\u62b1\u6028\u7740\u8131\u4e0b\u8863\u670d\uff0c[npc.speech(\u6211\u771f\u7684\u5fc5\u987b\u8fd9\u4e48\u505a\u5417\uff1f\u88ab\u8feb\u8fd9\u6837\u505a\u6709\u70b9\u6709\u8fb1\u4eba\u683c\u2026\u2026)]</p><p>\u4f60\u6ca1\u6709\u7406\u4f1a[npc.her]\u7684\u8bdd\uff0c\u518d\u6b21\u547d\u4ee4[npc.Name]\u8db4\u5230\u4f60\u819d\u76d6\u4e0a\uff1b[npc.she]\u518d\u6b21\u5c3d\u53ef\u80fd\u78e8\u8e6d\u5730\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002[npc.she]\u8db4\u5728\u4f60\u5927\u817f\u4e0a\uff0c\u5c55\u793a[npc.her][npc.ass+]\uff0c\u4f60\u53d1\u51fa\u80dc\u5229\u7684\u7b11\u58f0\uff0c\u7136\u540e\u8fc5\u901f\u7528[pc.hand]\u6247[npc.her]\u88f8\u9732\u7684\u5c41\u80a1\u3002\u4e00\u58f0\u5c16\u53eb\u54cd\u8d77\uff0c\u548c\u7740\u8089\u4f53\u88ab\u62cd\u6253\u7684\u58f0\u97f3\uff0c\u4fc3\u4f7f\u4f60\u518d\u6b21\u6253\u5411[npc.her]\u7684[npc.ass]\u3002</p><p>\u4f60\u7ee7\u7eed\u8fd9\u6837\u505a\u4e86\u4e00\u4f1a\u513f\uff1b\u4f60\u7684\u5974\u96b6\u4f0f\u5728\u5927\u817f\u4e0a\u626d\u52a8\u7740\uff0c\u5c16\u53eb\u7740\uff0c\u4f60\u4e00\u4e0b\u53c8\u4e00\u4e0b\u5730\u6253\u7740[npc.her]\u8106\u5f31\u7684\u810a\u80cc\u3002\u6700\u7ec8\uff0c\u4f60\u89c9\u5f97[npc.sheIs]\u5df2\u7ecf\u5f97\u5230\u4e86\u6559\u8bad\uff0c\u4e8e\u662f\u4f60\u547d\u4ee4[npc.herHim]\u7ad9\u8d77\u6765\uff0c\u91cd\u65b0\u7a7f\u4e0a[npc.her]\u7684\u8863\u670d\u3002</p>");
                                    break;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("[npc.she]\u542c\u5230\u4f60\u7684\u547d\u4ee4\u540e\uff0c\u53d1\u51fa\u4e86\u4e00\u58f0\u614c\u4e71\u7684\u53eb\u558a\uff0c\u4f46\u8fd8\u662f\u52aa\u529b\u63a7\u5236\u4f4f[npc.her]\u7684\u60c5\u7eea\uff0c\u52c9\u5f3a\u670d\u4ece\u547d\u4ee4\u3002[npc.she]\u62b1\u6028\u7740\u8131\u4e0b\u8863\u670d\uff0c[npc.speech(\u7ed9\u6211\u4e00\u70b9\u65f6\u95f4\uff0c[npc.pcName]\u3002)]</p><p>\u5728[npc.sheIs]\u88ab\u8131\u5149\u540e\uff0c\u4f60\u518d\u6b21\u547d\u4ee4[npc.Name]\u8db4\u5230\u4f60\u819d\u76d6\u4e0a\uff1b[npc.she]\u518d\u6b21\u4ee5\u5c3d\u53ef\u80fd\u6162\u7684\u901f\u5ea6\u6267\u884c\u547d\u4ee4\u3002[npc.she]\u8db4\u5728\u4f60\u5927\u817f\u4e0a\uff0c\u5c55\u793a[npc.her][npc.ass+]\uff0c\u4f60\u53d1\u51fa\u80dc\u5229\u7684\u7b11\u58f0\uff0c\u7136\u540e\u8fc5\u901f\u7528[pc.hand]\u6247[npc.her]\u88f8\u9732\u7684\u5c41\u80a1\u3002\u4e00\u58f0\u5c16\u53eb\u54cd\u8d77\uff0c\u548c\u7740\u8089\u4f53\u88ab\u62cd\u6253\u7684\u58f0\u97f3\uff0c\u4fc3\u4f7f\u4f60\u518d\u6b21\u6253\u5411[npc.her]\u7684[npc.ass]\u3002</p><p>\u4f60\u7ee7\u7eed\u8fd9\u6837\u505a\u4e86\u4e00\u4f1a\u513f\uff1b\u4f60\u7684\u5974\u96b6\u4f0f\u5728\u5927\u817f\u4e0a\u626d\u52a8\u7740\uff0c\u5c16\u53eb\u7740\uff0c\u4f60\u4e00\u4e0b\u53c8\u4e00\u4e0b\u5730\u6253\u7740[npc.her]\u8106\u5f31\u7684\u810a\u80cc\u3002\u6700\u7ec8\uff0c\u4f60\u89c9\u5f97[npc.sheIs]\u5df2\u7ecf\u5f97\u5230\u4e86\u6559\u8bad\uff0c\u4e8e\u662f\u4f60\u547d\u4ee4[npc.herHim]\u7ad9\u8d77\u6765\uff0c\u91cd\u65b0\u7a7f\u4e0a[npc.her]\u7684\u8863\u670d\u3002</p>");
                                    break;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.she]\u7acb\u5373\u670d\u4ece\u4f60\u7684\u547d\u4ee4\uff0c\u4f46\u5f53[npc.she]\u987a\u4ece\u5730\u628a[npc.her]\u7684\u8863\u670d\u6254\u5230\u5730\u4e0a\u65f6\uff0c\u4f60\u770b\u5230[npc.her]\u7684[npc.eyes]\u91cc\u660e\u663e\u6d41\u9732\u51fa\u75db\u82e6\u7684\u795e\u60c5\u3002[npc.she]\u8131\u4e0b[npc.her]\u7684\u6700\u540e\u4e00\u4ef6\u8863\u670d\uff0c[npc.she]\u95ee\u9053\uff0c[npc.speech(\u4f60\u6ee1\u610f\u4e86\u5417\uff0c[npc.pcName]\uff1f)]</p><p>\u4f60\u7ed9\u51fa\u4e86\u80af\u5b9a\u7684\u56de\u7b54\uff0c\u63a5\u7740\u518d\u6b21\u547d\u4ee4[npc.name]\u4f0f\u5728\u4f60\u7684\u819d\u4e0a\uff1b[npc.she]\u7acb\u9a6c\u9075\u4ece\u4e86\u547d\u4ee4\u3002[npc.she]\u8db4\u5728\u4f60\u5927\u817f\u4e0a\uff0c\u5c55\u793a[npc.her][npc.ass+]\uff0c\u4f60\u53d1\u51fa\u80dc\u5229\u7684\u7b11\u58f0\uff0c\u7136\u540e\u8fc5\u901f\u7528[pc.hand]\u6247[npc.her]\u88f8\u9732\u7684\u5c41\u80a1\u3002\u4e00\u58f0\u5c16\u53eb\u54cd\u8d77\uff0c\u548c\u7740\u8089\u4f53\u88ab\u62cd\u6253\u7684\u58f0\u97f3\uff0c\u4fc3\u4f7f\u4f60\u518d\u6b21\u6253\u5411[npc.her]\u7684[npc.ass]\u3002</p><p>\u4f60\u7ee7\u7eed\u8fd9\u6837\u505a\u4e86\u4e00\u4f1a\u513f\uff1b\u4f60\u7684\u5974\u96b6\u4f0f\u5728\u5927\u817f\u4e0a\u626d\u52a8\u7740\uff0c\u5c16\u53eb\u7740\uff0c\u4f60\u4e00\u4e0b\u53c8\u4e00\u4e0b\u5730\u6253\u7740[npc.her]\u8106\u5f31\u7684\u810a\u80cc\u3002\u6700\u7ec8\uff0c\u4f60\u89c9\u5f97[npc.sheIs]\u5df2\u7ecf\u5f97\u5230\u4e86\u6559\u8bad\uff0c\u4e8e\u662f\u4f60\u547d\u4ee4[npc.herHim]\u7ad9\u8d77\u6765\uff0c\u91cd\u65b0\u7a7f\u4e0a[npc.her]\u7684\u8863\u670d\u3002</p>");
                                }
                            }
                            break;
                        }
                        case LIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.she]\u542c\u5230\u4f60\u7684\u547d\u4ee4\uff0c\u4f24\u5fc3\u5730\u54ed\u51fa\u6765\uff0c\u4f46\u610f\u8bc6\u5230[npc.she]\u5728\u8fd9\u4ef6\u4e8b\u4e0a\u771f\u7684\u522b\u65e0\u9009\u62e9\uff0c\u53ea\u597d\u52c9\u5f3a\u670d\u4ece\u547d\u4ee4\u3002[npc.she]\u62b1\u6028\u7740\u8131\u4e0b\u8863\u670d\uff0c[npc.speech(\u4f60\u77e5\u9053\u5417\uff0c\u88ab\u8feb\u8fd9\u6837\u505a\u6709\u70b9\u6709\u8fb1\u4eba\u683c\u2026\u2026\u6211\u4ee5\u4e3a\u4f60\u559c\u6b22\u6211\u7684\u2026\u2026)]</p><p>\u4f60\u6ca1\u6709\u7406\u4f1a[npc.her]\u7684\u8bdd\uff0c\u518d\u6b21\u547d\u4ee4[npc.Name]\u8db4\u5230\u4f60\u819d\u76d6\u4e0a\uff1b[npc.she]\u518d\u6b21\u5c3d\u53ef\u80fd\u78e8\u8e6d\u5730\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002[npc.she]\u8db4\u5728\u4f60\u5927\u817f\u4e0a\uff0c\u5c55\u793a[npc.her][npc.ass+]\uff0c\u4f60\u53d1\u51fa\u80dc\u5229\u7684\u7b11\u58f0\uff0c\u7136\u540e\u8fc5\u901f\u7528[pc.hand]\u6247[npc.her]\u88f8\u9732\u7684\u5c41\u80a1\u3002\u4e00\u58f0\u5c16\u53eb\u54cd\u8d77\uff0c\u548c\u7740\u8089\u4f53\u88ab\u62cd\u6253\u7684\u58f0\u97f3\uff0c\u4fc3\u4f7f\u4f60\u518d\u6b21\u6253\u5411[npc.her]\u7684[npc.ass]\u3002</p><p>\u4f60\u7ee7\u7eed\u8fd9\u6837\u505a\u4e86\u4e00\u4f1a\u513f\uff1b\u4f60\u7684\u5974\u96b6\u4f0f\u5728\u5927\u817f\u4e0a\u626d\u52a8\u7740\uff0c\u5c16\u53eb\u7740\uff0c\u4f60\u4e00\u4e0b\u53c8\u4e00\u4e0b\u5730\u6253\u7740[npc.her]\u8106\u5f31\u7684\u810a\u80cc\u3002\u6700\u7ec8\uff0c\u4f60\u89c9\u5f97[npc.sheIs]\u5df2\u7ecf\u5f97\u5230\u4e86\u6559\u8bad\uff0c\u4e8e\u662f\u4f60\u547d\u4ee4[npc.herHim]\u7ad9\u8d77\u6765\uff0c\u91cd\u65b0\u7a7f\u4e0a[npc.her]\u7684\u8863\u670d\u3002</p>");
                                    break block0;
                                }
                                case NEUTRAL: {
                                    UtilText.nodeContentSB.append("\u5f53[npc.she]\u542c\u5230\u4f60\u7684\u547d\u4ee4\u65f6\uff0c[npc.she]\u53d1\u51fa\u4e86\u60b2\u4f24\u7684\u54ed\u58f0\uff0c\u4f46\u5979\u52aa\u529b\u63a7\u5236\u4f4f[npc.her]\u7684\u60c5\u7eea\uff0c\u6162\u6162\u5730\u8d70\u53bb\u670d\u4ece\u547d\u4ee4\u3002[npc.she]\u62b1\u6028\u7740\u8131\u4e0b\u8863\u670d\uff0c[npc.speech(\u6211\u4ee5\u4e3a\u4f60\u559c\u6b22\u6211\uff0c[npc.pcName]\u2026\u2026\u4f46\u5982\u679c\u8fd9\u662f\u4f60\u60f3\u8981\u7684\u2026\u2026)]</p><p>\u4f60\u6ca1\u6709\u7406\u4f1a[npc.her]\u7684\u8bdd\uff0c\u518d\u6b21\u547d\u4ee4[npc.Name]\u8db4\u5230\u4f60\u819d\u76d6\u4e0a\uff1b[npc.she]\u518d\u6b21\u5c3d\u53ef\u80fd\u78e8\u8e6d\u5730\u6267\u884c\u4e86\u8fd9\u4e00\u547d\u4ee4\u3002[npc.she]\u8db4\u5728\u4f60\u5927\u817f\u4e0a\uff0c\u5c55\u793a[npc.her][npc.ass+]\uff0c\u4f60\u53d1\u51fa\u80dc\u5229\u7684\u7b11\u58f0\uff0c\u7136\u540e\u8fc5\u901f\u7528[pc.hand]\u6247[npc.her]\u88f8\u9732\u7684\u5c41\u80a1\u3002\u4e00\u58f0\u5c16\u53eb\u54cd\u8d77\uff0c\u548c\u7740\u8089\u4f53\u88ab\u62cd\u6253\u7684\u58f0\u97f3\uff0c\u4fc3\u4f7f\u4f60\u518d\u6b21\u6253\u5411[npc.her]\u7684[npc.ass]\u3002</p><p>\u4f60\u7ee7\u7eed\u8fd9\u6837\u505a\u4e86\u4e00\u4f1a\u513f\uff1b\u4f60\u7684\u5974\u96b6\u4f0f\u5728\u5927\u817f\u4e0a\u626d\u52a8\u7740\uff0c\u5c16\u53eb\u7740\uff0c\u4f60\u4e00\u4e0b\u53c8\u4e00\u4e0b\u5730\u6253\u7740[npc.her]\u8106\u5f31\u7684\u810a\u80cc\u3002\u6700\u7ec8\uff0c\u4f60\u89c9\u5f97[npc.sheIs]\u5df2\u7ecf\u5f97\u5230\u4e86\u6559\u8bad\uff0c\u4e8e\u662f\u4f60\u547d\u4ee4[npc.herHim]\u7ad9\u8d77\u6765\uff0c\u91cd\u65b0\u7a7f\u4e0a[npc.her]\u7684\u8863\u670d\u3002</p>");
                                    break block0;
                                }
                                case OBEDIENT: {
                                    UtilText.nodeContentSB.append("[npc.she]\u987a\u4ece\u5730\u628a[npc.her]\u7684\u8863\u670d\u6254\u5230\u5730\u4e0a\uff0c\u7acb\u5373\u79fb\u52a8\u811a\u6b65\u53bb\u670d\u4ece\u4f60\u7684\u547d\u4ee4\uff0c\u4f46\u4f60\u770b\u5230[npc.her]\u7684[npc.eyes]\u4e2d\u6d41\u9732\u51fa\u660e\u663e\u7684\u60b2\u4f24\u795e\u60c5\u3002[npc.she]\u8131\u4e0b[npc.her]\u7684\u6700\u540e\u4e00\u4ef6\u8863\u670d\uff0c[npc.she]\u95ee\u9053\uff0c[npc.speech(\u4f60\u6ee1\u610f\u4e86\u5417\uff0c[npc.pcName]\uff1f)]</p><p>\u4f60\u7684\u56de\u7b54\u662f\u80af\u5b9a\u7684\uff0c\u7136\u540e\u518d\u6b21\u547d\u4ee4[npc.Name]\u8ba9[npc.herself]\u5c48\u819d\uff1b[npc.she]\u518d\u6b21\u5c3d\u53ef\u80fd\u78e8\u8e6d\u5730\u6267\u884c\u547d\u4ee4\u3002[npc.she]\u8db4\u5728\u4f60\u5927\u817f\u4e0a\uff0c\u5c55\u793a[npc.her][npc.ass+]\u65f6\uff0c\u4f60\u53d1\u51fa\u80dc\u5229\u7684\u7b11\u58f0\uff0c\u7136\u540e\u8fc5\u901f\u7528[pc.hand]\u6247[npc.her]\u88f8\u9732\u7684\u5c41\u80a1\u3002\u4e00\u58f0\u5c16\u53eb\u54cd\u8d77\uff0c\u548c\u7740\u8089\u4f53\u88ab\u62cd\u6253\u7684\u58f0\u97f3\uff0c\u4fc3\u4f7f\u4f60\u518d\u6b21\u6253\u5411[npc.her]\u7684[npc.ass]\u3002</p><p>\u4f60\u7ee7\u7eed\u8fd9\u6837\u505a\u4e86\u4e00\u4f1a\u513f\uff1b\u4f60\u7684\u5974\u96b6\u4f0f\u5728\u5927\u817f\u4e0a\u626d\u52a8\u7740\uff0c\u5c16\u53eb\u7740\uff0c\u4f60\u4e00\u4e0b\u53c8\u4e00\u4e0b\u5730\u6253\u7740[npc.her]\u8106\u5f31\u7684\u810a\u80cc\u3002\u6700\u7ec8\uff0c\u4f60\u89c9\u5f97[npc.sheIs]\u5df2\u7ecf\u5f97\u5230\u4e86\u6559\u8bad\uff0c\u4e8e\u662f\u4f60\u547d\u4ee4[npc.herHim]\u7ad9\u8d77\u6765\uff0c\u91cd\u65b0\u7a7f\u4e0a[npc.her]\u7684\u8863\u670d\u3002</p>");
                                }
                            }
                        }
                    }
                    if (SlaveDialogue.getSlave().getFetishDesire(Fetish.FETISH_MASOCHIST).isPositive()) {
                        UtilText.nodeContentSB.append("<p><i>\u7531\u4e8e[npc.Name]\u662f\u4e2a\u53d7\u8650\u72c2\uff0c\u6253[npc.herHim]\u7684\u5c41\u80a1\u5b9e\u9645\u4e0a\u8ba9[npc.herHim]\u66f4\u559c\u6b22\u4f60\u4e86\uff0c\u4e5f\u589e\u52a0\u4e86[npc.her]\u7684\u670d\u4ece\u6027\uff01</i></p>");
                    } else {
                        UtilText.nodeContentSB.append("<p><i>\u8fd9\u5e76\u6ca1\u6709\u6539\u53d8[npc.name]<span style='" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getColour().toWebHexString() + "'>" + SlaveDialogue.getSlave().getAffectionLevel(Main.game.getPlayer()).getDescriptor() + "</span>\u4f60\u7684\u4e8b\u5b9e\uff0c[npc.she]\u88ab\u8feb\u63a5\u53d7\u60e9\u7f5a\u6027\u6253\u5c41\u80a1\uff0c\u8fd9\u5bf9[npc.her]\u5bf9\u4f60\u7684\u597d\u611f\u4ea7\u751f\u4e86\u5de8\u5927\u7684\u8d1f\u9762\u5f71\u54cd\uff0c\u4f46\u540c\u65f6\u4e5f\u4f1a\u589e\u52a0[npc.her]\u7684\u670d\u4ece\u6027\uff01</i></p>");
                    }
                }
                UtilText.nodeContentSB.append(SlaveDialogue.getFooterText());
                return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return SLAVE_START.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return SLAVE_START.getResponse(responseTab, index);
            }
        };
        SLAVE_MOLEST = new DialogueNode("", "", true){

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.OCCUPANT_MANAGEMENT;
            }

            @Override
            public String getLabel() {
                return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), "\u6027\u4fb5[npc.Name]", new ParserTag[0]);
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                if (SlaveDialogue.isDoll()) {
                    UtilText.nodeContentSB.append("<p>\u4f60\u65e0\u6cd5\u62b5\u6321[npc.namePos][npc.feminine]\u8eab\u4f53\u7684\u8bf1\u60d1\uff0c\u7ed5\u5230[npc.her]\u80cc\u540e\uff0c\u7136\u540e\u5411\u524d\u8fc8\u51fa\u4e00\u6b65\uff0c\u7528[pc.arms]\u73af\u62b1\u4f4f[npc.herHim]\u3002\u4f60\u6293\u4f4f\u73a9\u5076[npc.breasts+]\uff0c[npc.her]\u987a\u670d\u5730\u4e00\u52a8\u4e0d\u52a8\u3002\u4f60\u5411\u4e0b\u6478\u5230[npc.her][npc.legs]\u95f4\uff0c\u624d\u53d1\u51fa[npc.a_moan+]\u3002</p><p>[npc.speech(\u662f\u7684\uff0c[pc.name]\uff0c\u8bf7\u968f\u610f\u6309\u7167\u60a8\u7684\u610f\u613f\u4f7f\u7528\u6211\uff0c)][npc.she]\u56de\u7b54\u9053\u3002</p><p>\u5c31\u8fd9\u6837\uff0c\u4f60\u7ee7\u7eed\u5bf9[npc.name]\u8fdb\u884c\u7325\u4eb5\u548c\u6478\u7d22\uff0c\u76f4\u5230\u5c3d\u5174\u5e76\u4e14\u63a2\u7d22\u4e86[npc.her]\u7845\u80f6\u8eab\u4f53\u7684\u6bcf\u4e00\u5bf8\u808c\u80a4\u624d\u505c\u6b62\u3002\u4f60\u9000\u4e86\u5f00\u6765\uff0c\u601d\u7d22\u7740\u4e0b\u4e00\u6b65\u8be5\u600e\u4e48\u505a\u2026\u2026</p>");
                } else {
                    UtilText.nodeContentSB.append("<p>\u4f60\u65e0\u6cd5\u62b5\u6321[npc.namePos][npc.feminine]\u8eab\u4f53\u7684\u8bf1\u60d1\uff0c\u7ed5\u5230[npc.her]\u80cc\u540e\uff0c\u7136\u540e\u5411\u524d\u8fc8\u51fa\u4e00\u6b65\uff0c\u7528[pc.arms]\u73af\u62b1\u4f4f[npc.herHim]\u3002");
                    String firstCry = "\u4e00\u58f0\u60ca\u6050\u7684\u54ed\u558a";
                    String firstReaction = "\u7a81\u7136\u5f00\u59cb\u626d\u52a8\uff0c\u8bd5\u56fe\u6323\u8131\u4f60\u7684\u629a\u6478";
                    String firstSpeech = "\u6eda\u5f00\uff01\u522b\u70e6\u6211\uff01";
                    String firstPCReaction = "[npc.her]\u7684\u8a00\u8bed\u65e0\u6cd5\u963b\u6b62\u4f60\u5411[npc.her]\u4e0d\u60c5\u613f\u7684\u8eab\u4f53\u524d\u8fdb";
                    String secondReaction = "[npc.she]\u7ee7\u7eed\u547c\u558a\u548c\u6323\u624e";
                    String thirdReaction = "\uff0c\u5c3d\u7ba1[npc.her]\u63d0\u51fa\u4e86\u6297\u8bae\uff0c";
                    String secondSpeech = "[npc.speech(\u505c\u4e0b\uff01\u6eda\u2026\u2026\u6eda\u5f00\uff01)][npc.she]\u558a\u9053\uff0c\u4f60\u5bf9[npc.her]\u7684\u8bdd\u5145\u8033\u4e0d\u95fb\uff0c\u7ee7\u7eed\u4eab\u53d7\u4f60\u7684\u4e50\u8da3\u3002";
                    String finalDescription = "\u6700\u7ec8\uff0c\u4f60\u89c9\u5f97\u81ea\u5df1\u6ee1\u8db3\u4e86\uff0c\u4e8e\u662f\u677e\u5f00[npc.Name]\u8ba9[npc.herHim]\u5230\u623f\u95f4\u7684\u53e6\u4e00\u8fb9\u53bb\uff0c\u4f60\u4e0a\u4e0b\u6253\u91cf\u7740[npc.herHim]\uff0c\u54a7\u5634\u7b11\u4e86\u8d77\u6765\u3002[npc.she]\u7ee7\u7eed\u5410\u53e3\u6c34\u8bc5\u5492\u4f60\uff0c\u8ba9\u4f60\u4e0d\u8981\u518d\u6253\u6270[npc.herHim]\uff0c\u4f60\u4e0d\u77e5\u9053\u662f\u5e94\u8be5\u6309\u7167\u4f60\u7684\u5974\u96b6\u7684\u8981\u6c42\u53bb\u505a\uff0c\u8fd8\u662f\u5bf9[npc.herHim]\u505a\u4e9b\u522b\u7684\u4e8b\u60c5\u2026\u2026";
                    block0 : switch (AffectionLevelBasic.getAffectionLevelFromValue(SlaveDialogue.getSlave().getAffection(Main.game.getPlayer()))) {
                        case DISLIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    break;
                                }
                                case NEUTRAL: {
                                    firstCry = "\u4ee4\u4eba\u4e0d\u9002\u7684\u54ed\u58f0";
                                    firstReaction = "\u5f00\u59cb\u626d\u52a8\u5e76\u8bd5\u56fe\u5c06[npc.her]\u7684\u8eab\u4f53\u4ece\u4f60\u7684\u629a\u6478\u4e2d\u79fb\u5f00";
                                    firstSpeech = "\u4f60\u2026\u2026\u4f60\u80fd\u505c\u4e0b\u4e86\u5417\uff1f\uff01";
                                    firstPCReaction = "[npc.her]\u7684\u8a00\u8bed\u65e0\u6cd5\u963b\u6b62\u4f60\u5411[npc.her]\u4e0d\u60c5\u613f\u7684\u8eab\u4f53\u524d\u8fdb";
                                    secondReaction = "[npc.She]\u7ee7\u7eed\u5728\u4e0d\u9002\u4e2d\u6323\u624e";
                                    thirdReaction = "\uff0c\u5c3d\u7ba1[npc.her]\u5e76\u4e0d\u60c5\u613f\uff0c";
                                    secondSpeech = "[npc.speech(\u6c42\u2026\u2026\u6c42\u4f60\u4e86\uff01\u5feb\u2026\u2026\u5feb\u4f4f\u624b\uff01)][npc.she]\u54ed\u6ce3\u7740\uff0c\u4f60\u5bf9[npc.her]\u7684\u8bdd\u88ab\u5145\u8033\u4e0d\u95fb\uff0c\u7ee7\u7eed\u4eab\u53d7\u4f60\u7684\u4e50\u8da3\u3002";
                                    finalDescription = "\u6700\u7ec8\uff0c\u4f60\u89c9\u5f97\u81ea\u5df1\u6ee1\u8db3\u4e86\uff0c\u4e8e\u662f\u677e\u5f00[npc.Name]\u8ba9[npc.herHim]\u51b2\u5230\u623f\u95f4\u7684\u53e6\u4e00\u8fb9\uff0c\u4f60\u4e0a\u4e0b\u6253\u91cf\u7740[npc.herHim]\uff0c\u54a7\u5634\u7b11\u4e86\u8d77\u6765\u3002\u5f53[npc.she]\u8bf7\u6c42\u4f60\u653e\u8fc7[npc.herHim]\u65f6\uff0c[npc.she]\u907f\u5f00\u4e86\u4f60\u7684\u89c6\u7ebf\uff0c\u4f60\u4e0d\u77e5\u9053\u662f\u5e94\u8be5\u6309\u7167\u4f60\u7684\u5974\u96b6\u7684\u8981\u6c42\u53bb\u505a\uff0c\u8fd8\u662f\u5bf9[npc.herHim]\u505a\u4e9b\u522b\u7684\u4e8b\u60c5\u2026\u2026";
                                    break;
                                }
                                case OBEDIENT: {
                                    firstCry = "\u54ed\u558a";
                                    firstReaction = "\u987a\u4ece\u5730\u4e3a\u4f60\u4fdd\u6301[npc.her]\u7684\u8eab\u4f53\u4e00\u52a8\u4e0d\u52a8";
                                    firstSpeech = "\u6211\u968f\u4f60\u4f7f\u7528\uff0c[npc.pcName]\u3002";
                                    firstPCReaction = "[npc.her]\u7684\u51b7\u8a00\u51b7\u8bed\u65e0\u52a9\u4e8e\u963b\u6b62\u4f60\u5411[npc.her]\u7684\u8eab\u4f53\u524d\u8fdb";
                                    secondReaction = "[npc.she]\u7ee7\u7eed\u987a\u4ece\u5730\u5141\u8bb8[npc.herself]\u88ab\u4f7f\u7528";
                                    thirdReaction = "\uff0c\u5c3d\u7ba1[npc.her]\u6001\u5ea6\u51b7\u6de1\uff0c";
                                    secondSpeech = "[npc.speech(\u8fd9\u662f\u5426\u4ee4\u4f60\u6ee1\u610f\uff1f[npc.pcName]\uff1f)][npc.she]\u5c3d\u804c\u5c3d\u8d23\u5730\u95ee\u9053\uff0c\u5728\u4f60\u4eec\u7ee7\u7eed\u4eab\u53d7\u4e50\u8da3\u65f6\u6ca1\u6709\u8868\u73b0\u51fa\u4efb\u4f55\u60c5\u7eea\u3002";
                                    finalDescription = "\u6700\u7ec8\uff0c\u4f60\u89c9\u5f97\u81ea\u5df1\u6ee1\u8db3\u4e86\uff0c\u677e\u5f00[npc.Name]\u8ba9[npc.herHim]\u5f80\u540e\u9000\u4e86\u4e00\u6b65\uff0c\u7136\u540e\u4e0a\u4e0b\u6253\u91cf\u7740[npc.herHim]\uff0c\u54a7\u5634\u7b11\u4e86\u8d77\u6765\u3002[npc.she]\u987a\u4ece\u5730\u8be2\u95ee\u4f60\u662f\u5426\u8fd8\u9700\u8981[npc.herHim]\u505a\u4ec0\u4e48\uff0c\u8fd9\u8ba9\u4f60\u6000\u7591\u662f\u5426\u5e94\u8be5\u5bf9[npc.herHim]\u505a\u5176\u4ed6\u4e8b\u60c5\u2026\u2026";
                                }
                            }
                            break;
                        }
                        case NEUTRAL: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    firstCry = "\u60ca\u547c";
                                    firstReaction = "\u5f00\u59cb\u626d\u52a8\u5e76\u8bd5\u56fe\u5c06[npc.her]\u7684\u8eab\u4f53\u4ece\u4f60\u7684\u629a\u6478\u4e2d\u79fb\u5f00";
                                    firstSpeech = "\u4f60\u2026\u2026\u4f60\u4e00\u5b9a\u8981\u8fd9\u4e48\u505a\u5417\uff1f";
                                    firstPCReaction = "[npc.her]\u5fe7\u5fc3\u5fe1\u5fe1\u7684\u8bed\u6c14\u4e1d\u6beb\u4e0d\u80fd\u963b\u6b62\u4f60\u5411[npc.her]\u7684\u8eab\u4f53\u524d\u8fdb";
                                    secondReaction = "[npc.She]\u7ee7\u7eed\u8f7b\u8f7b\u5730\u6323\u624e";
                                    thirdReaction = "\uff0c\u5c3d\u7ba1[npc.her]\u7684\u6001\u5ea6\u5e76\u4e0d\u70ed\u60c5\uff0c";
                                    secondSpeech = "[npc.speech(\u8fd9\u8fd8\u8981\u6301\u7eed\u591a\u4e45\uff0c[npc.pcName]\uff1f)][npc.her]\u4e0d\u670d\u6c14\u5730\u8d28\u95ee\uff0c\u4f46\u6ca1\u6709\u5f97\u5230\u4efb\u4f55\u56de\u7b54\uff0c\u4f60\u4eec\u7ee7\u7eed\u4eab\u53d7\u4e50\u8da3\u3002";
                                    finalDescription = "\u6700\u7ec8\uff0c\u4f60\u89c9\u5f97\u81ea\u5df1\u6ee1\u8db3\u4e86\uff0c\u4e8e\u662f\u677e\u5f00[npc.Name]\u8ba9[npc.herHim]\u5f80\u540e\u9000\u4e86\u51e0\u6b65\uff0c\u7136\u540e\u4e0a\u4e0b\u6253\u91cf\u7740[npc.herHim]\uff0c\u54a7\u5634\u7b11\u4e86\u8d77\u6765\u3002\u5f53[npc.she]\u8bf7\u4f60\u653e\u8fc7[npc.herHim]\u65f6\uff0c[npc.she]\u53f9\u4e86\u4e00\u53e3\u6c14\uff0c\u4f60\u4e0d\u77e5\u9053\u662f\u5e94\u8be5\u6309\u7167\u4f60\u7684\u5974\u96b6\u7684\u8981\u6c42\u53bb\u505a\uff0c\u8fd8\u662f\u5bf9[npc.herHim]\u505a\u4e9b\u522b\u7684\u4e8b\u60c5\u2026\u2026";
                                    break;
                                }
                                case NEUTRAL: {
                                    firstCry = "\u534a\u538b\u6291\u7684\u54ed\u6ce3";
                                    firstReaction = "\u5f00\u59cb\u626d\u52a8\u5e76\u8bd5\u56fe\u5c06[npc.her]\u7684\u8eab\u4f53\u4ece\u4f60\u7684\u629a\u6478\u4e2d\u79fb\u5f00";
                                    firstSpeech = "[npc.pcName]\uff0c\u771f\u7684\u8981\u8fd9\u6837\u505a\u5417\uff1f";
                                    firstPCReaction = "[npc.her]\u5fe7\u5fc3\u5fe1\u5fe1\u7684\u8bed\u6c14\u4e1d\u6beb\u4e0d\u80fd\u963b\u6b62\u4f60\u5411[npc.her]\u7684\u8eab\u4f53\u524d\u8fdb";
                                    secondReaction = "[npc.She]\u7ee7\u7eed\u8f7b\u8f7b\u5730\u6323\u624e";
                                    thirdReaction = "\uff0c\u5c3d\u7ba1[npc.her]\u7684\u6001\u5ea6\u5e76\u4e0d\u70ed\u60c5\uff0c";
                                    secondSpeech = "[npc.speech(\u4f60\u5feb\u5b8c\u4e8b\u4e86\u5417\uff1f[npc.pcName]\uff1f)][npc.her]\u4e0d\u670d\u6c14\u5730\u8d28\u95ee\uff0c\u4f46\u6ca1\u6709\u5f97\u5230\u4efb\u4f55\u56de\u7b54\uff0c\u4f60\u4eec\u7ee7\u7eed\u4eab\u53d7\u4e50\u8da3\u3002";
                                    finalDescription = "\u6700\u7ec8\uff0c\u4f60\u89c9\u5f97\u81ea\u5df1\u6ee1\u8db3\u4e86\uff0c\u4e8e\u662f\u677e\u5f00[npc.Name]\u8ba9[npc.herHim]\u5f80\u540e\u9000\u4e86\u51e0\u6b65\uff0c\u7136\u540e\u4e0a\u4e0b\u6253\u91cf\u7740[npc.herHim]\uff0c\u54a7\u5634\u7b11\u4e86\u8d77\u6765\u3002\u5f53[npc.she]\u907f\u5f00\u4f60\u7684\u89c6\u7ebf\u65f6\uff0c[npc.she]\u7a0d\u7a0d\u677e\u4e86\u4e00\u53e3\u6c14\uff0c\u4f60\u5728\u60f3\u662f\u5426\u5e94\u8be5\u5bf9[npc.herHim]\u505a\u70b9\u522b\u7684\u4ec0\u4e48\u2026\u2026";
                                    break;
                                }
                                case OBEDIENT: {
                                    firstCry = "\u54ed\u558a";
                                    firstReaction = "\u987a\u4ece\u5730\u4e3a\u4f60\u4fdd\u6301[npc.her]\u7684\u8eab\u4f53\u4e00\u52a8\u4e0d\u52a8";
                                    firstSpeech = "\u6211\u968f\u4f60\u4f7f\u7528\uff0c[npc.pcName]\u3002";
                                    firstPCReaction = "[npc.her]\u7684\u51b7\u8a00\u51b7\u8bed\u65e0\u52a9\u4e8e\u963b\u6b62\u4f60\u5411[npc.her]\u7684\u8eab\u4f53\u524d\u8fdb";
                                    secondReaction = "[npc.she]\u7ee7\u7eed\u987a\u4ece\u5730\u5141\u8bb8[npc.herself]\u88ab\u4f7f\u7528";
                                    thirdReaction = "\uff0c\u5c3d\u7ba1[npc.her]\u6001\u5ea6\u51b7\u6de1\uff0c";
                                    secondSpeech = "[npc.speech(\u8fd9\u662f\u5426\u4ee4\u4f60\u6ee1\u610f\uff1f[npc.pcName]\uff1f)][npc.she]\u5c3d\u804c\u5c3d\u8d23\u5730\u95ee\u9053\uff0c\u5728\u4f60\u4eec\u7ee7\u7eed\u4eab\u53d7\u4e50\u8da3\u65f6\u6ca1\u6709\u8868\u73b0\u51fa\u4efb\u4f55\u60c5\u7eea\u3002";
                                    finalDescription = "\u6700\u7ec8\uff0c\u4f60\u89c9\u5f97\u81ea\u5df1\u6ee1\u8db3\u4e86\uff0c\u677e\u5f00[npc.Name]\u8ba9[npc.herHim]\u5f80\u540e\u9000\u4e86\u4e00\u6b65\uff0c\u7136\u540e\u4e0a\u4e0b\u6253\u91cf\u7740[npc.herHim]\uff0c\u54a7\u5634\u7b11\u4e86\u8d77\u6765\u3002[npc.she]\u987a\u4ece\u5730\u8be2\u95ee\u4f60\u662f\u5426\u8fd8\u9700\u8981[npc.herHim]\u505a\u4ec0\u4e48\uff0c\u8fd9\u8ba9\u4f60\u6000\u7591\u662f\u5426\u5e94\u8be5\u5bf9[npc.herHim]\u505a\u5176\u4ed6\u4e8b\u60c5\u2026\u2026";
                                }
                            }
                            break;
                        }
                        case LIKE: {
                            switch (ObedienceLevelBasic.getObedienceLevelFromValue(SlaveDialogue.getSlave().getObedienceValue())) {
                                case DISOBEDIENT: {
                                    firstCry = "\u60ca\u547c";
                                    firstReaction = "\u5f00\u59cb\u626d\u52a8\u5e76\u8bd5\u56fe\u5c06[npc.her]\u7684\u8eab\u4f53\u4ece\u4f60\u7684\u629a\u6478\u4e2d\u79fb\u5f00";
                                    firstSpeech = "[npc.pcName]\uff01\u6211\u4ee5\u4e3a\u4f60\u559c\u6b22\u6211\u7684\uff01\u4f60\u4e3a\u4ec0\u4e48\u8981\u8fd9\u4e48\u505a\uff1f\uff01";
                                    firstPCReaction = "[npc.her]\u75db\u82e6\u7684\u8bed\u6c14\u4e1d\u6beb\u4e0d\u80fd\u963b\u6b62\u4f60\u5411[npc.her]\u7684\u8eab\u4f53\u524d\u8fdb";
                                    secondReaction = "[npc.She]\u7ee7\u7eed\u8f7b\u8f7b\u5730\u6323\u624e";
                                    thirdReaction = "\uff0c\u5c3d\u7ba1[npc.her]\u7684\u6001\u5ea6\u5e76\u4e0d\u70ed\u60c5\uff0c";
                                    secondSpeech = "[npc.speech([npc.PcName]\uff0c\u6c42\u4f60\u4e86\uff01\u6211\u2026\u2026\u6211\u53ea\u662f\u60f3\u62b1\u62b1\u2026\u2026)][npc.she]\u53f9\u4e86\u53e3\u6c14\uff0c[npc.she]\u4e0d\u542c\u8bdd\u7684\u8bdd\u8bed\u6ca1\u6709\u5f97\u5230\u4efb\u4f55\u56de\u7b54\uff0c\u4f60\u7ee7\u7eed\u4eab\u53d7\u4f60\u7684\u4e50\u8da3\u3002";
                                    finalDescription = "\u6700\u7ec8\uff0c\u4f60\u89c9\u5f97\u81ea\u5df1\u6ee1\u8db3\u4e86\uff0c\u4e8e\u662f\u677e\u5f00[npc.Name]\u8ba9[npc.herHim]\u5f80\u540e\u9000\u4e86\u51e0\u6b65\uff0c\u7136\u540e\u4e0a\u4e0b\u6253\u91cf\u7740[npc.herHim]\uff0c\u54a7\u5634\u7b11\u4e86\u8d77\u6765\u3002\u5f53[npc.she]\u5bf9\u4f60\u5fae\u7b11\u65f6\uff0c[npc.She]\u677e\u4e86\u4e00\u53e3\u6c14\uff0c\u4f60\u4e0d\u77e5\u9053\u73b0\u5728\u662f\u5426\u5e94\u8be5\u5bf9[npc.herHim]\u505a\u70b9\u522b\u7684\u4ec0\u4e48\u2026\u2026";
                                    break block0;
                                }
                                case NEUTRAL: {
                                    firstCry = "\u4e00\u58f0\u8f7b\u547c";
                                    firstReaction = "\u4e3a\u4f60\u4fdd\u6301[npc.her]\u7684\u8eab\u4f53\u4e00\u52a8\u4e0d\u52a8";
                                    firstSpeech = "[npc.PcName]\uff0c\u771f\u7684\u8981\u8fd9\u6837\u505a\u5417\uff1f";
                                    firstPCReaction = "[npc.her]\u5fe7\u5fc3\u5fe1\u5fe1\u7684\u8bed\u6c14\u4e1d\u6beb\u4e0d\u80fd\u963b\u6b62\u4f60\u5411[npc.her]\u7684\u8eab\u4f53\u524d\u8fdb";
                                    secondReaction = "[npc.She]\u7ee7\u7eed\u4fdd\u6301\u4e00\u52a8\u4e0d\u52a8";
                                    thirdReaction = "\uff0c\u5c3d\u7ba1[npc.her]\u6709\u4e00\u70b9\u4e0d\u542c\u8bdd\uff0c";
                                    secondSpeech = "[npc.speech(\u8fd9\u5c31\u662f\u4f60\u559c\u6b22\u7684\u5417\uff1f[npc.pcName]\uff1f)][npc.she]\u95ee\u9053\uff0c[npc.her]\u7684\u8d28\u95ee\u6ca1\u6709\u5f97\u5230\u56de\u7b54\uff0c\u4f60\u4eec\u7ee7\u7eed\u4eab\u53d7\u4e50\u8da3\u3002";
                                    finalDescription = "\u6700\u7ec8\uff0c\u4f60\u89c9\u5f97\u81ea\u5df1\u6ee1\u8db3\u4e86\uff0c\u4e8e\u662f\u677e\u5f00[npc.Name]\u8ba9[npc.herHim]\u5f80\u540e\u9000\u4e86\u51e0\u6b65\uff0c\u7136\u540e\u4e0a\u4e0b\u6253\u91cf\u7740[npc.herHim]\uff0c\u54a7\u5634\u7b11\u4e86\u8d77\u6765\u3002\u5f53[npc.she]\u907f\u5f00\u4f60\u7684\u89c6\u7ebf\u65f6\uff0c[npc.she]\u7a0d\u7a0d\u677e\u4e86\u4e00\u53e3\u6c14\uff0c\u4f60\u5728\u60f3\u662f\u5426\u5e94\u8be5\u5bf9[npc.herHim]\u505a\u70b9\u522b\u7684\u4ec0\u4e48\u2026\u2026";
                                    break block0;
                                }
                                case OBEDIENT: {
                                    firstCry = "\u5a07\u5598";
                                    firstReaction = "\u987a\u4ece\u5730\u4e3a\u4f60\u4fdd\u6301[npc.her]\u7684\u8eab\u4f53\u4e00\u52a8\u4e0d\u52a8";
                                    firstSpeech = "\u6211\u968f\u4f60\u4f7f\u7528\uff0c[npc.pcName]\u3002";
                                    firstPCReaction = "[npc.her]\u7684\u51b7\u8a00\u51b7\u8bed\u65e0\u52a9\u4e8e\u963b\u6b62\u4f60\u5411[npc.her]\u7684\u8eab\u4f53\u524d\u8fdb";
                                    secondReaction = "[npc.she]\u7ee7\u7eed\u987a\u4ece\u5730\u5141\u8bb8[npc.herself]\u88ab\u4f7f\u7528";
                                    thirdReaction = "\uff0c\u5c3d\u7ba1[npc.her]\u6001\u5ea6\u51b7\u6de1\uff0c";
                                    secondSpeech = "[npc.speech(\u8fd9\u662f\u5426\u4ee4\u4f60\u6ee1\u610f\uff1f[npc.pcName]\uff1f)][npc.she]\u5c3d\u804c\u5c3d\u8d23\u5730\u95ee\u9053\uff0c\u5728\u4f60\u4eec\u7ee7\u7eed\u4eab\u53d7\u4e50\u8da3\u65f6\u6ca1\u6709\u8868\u73b0\u51fa\u4efb\u4f55\u60c5\u7eea\u3002";
                                    finalDescription = "\u6700\u7ec8\uff0c\u4f60\u89c9\u5f97\u81ea\u5df1\u6ee1\u8db3\u4e86\uff0c\u677e\u5f00[npc.Name]\u8ba9[npc.herHim]\u5f80\u540e\u9000\u4e86\u4e00\u6b65\uff0c\u7136\u540e\u4e0a\u4e0b\u6253\u91cf\u7740[npc.herHim]\uff0c\u54a7\u5634\u7b11\u4e86\u8d77\u6765\u3002[npc.she]\u987a\u4ece\u5730\u8be2\u95ee\u4f60\u662f\u5426\u8fd8\u9700\u8981[npc.herHim]\u505a\u4ec0\u4e48\uff0c\u8fd9\u8ba9\u4f60\u6000\u7591\u662f\u5426\u5e94\u8be5\u5bf9[npc.herHim]\u505a\u5176\u4ed6\u4e8b\u60c5\u2026\u2026";
                                }
                            }
                        }
                    }
                    if (SlaveDialogue.getSlave().hasBreasts()) {
                        UtilText.nodeContentSB.append("\u4f60\u7684[pc.hands]\u4f38\u5230\u7f69\u676f\u7136\u540e\u63c9\u634f[npc.namePos][npc.breasts+]\uff0c[npc.she]" + firstReaction + "\uff0c\u53e3\u4e2d\u53d1\u51fa" + firstCry + "\uff0c[npc.speech(" + firstSpeech + ")]</p><p>" + firstPCReaction + "\uff0c\u4f60\u7528\u4e00\u53ea[pc.hand]\u7ee7\u7eed\u63c9\u634f\u7740[npc.her][npc.breasts+]\uff0c\u5c06\u53e6\u4e00\u53ea\u624b\u6ed1#IF(npc.hasLegs())\u5230[npc.her]\u4e24\u817f\u4e4b\u95f4#ELSE\u5411[npc.her]\u7684\u80ef\u90e8#ENDIF\u3002");
                    } else {
                        UtilText.nodeContentSB.append("\u4f60\u4f38\u51fa[pc.hands]\u6478\u5411[npc.her]\u7684\u80f8\u90e8\uff0c\u8ba9[npc.namePos]\u5728" + firstReaction + "\u7684\u540c\u65f6\u4ece\u53e3\u4e2d\u53d1\u51fa" + firstCry + "\uff0c[npc.speech(" + firstSpeech + ")]</p><p>" + firstPCReaction + "\uff0c\u4f60\u7528\u4e00\u53ea[pc.hand]\u7ee7\u7eed\u63c9\u634f\u7740[npc.her]\u7684\u80f8\u90e8\uff0c\u5c06\u53e6\u4e00\u53ea\u624b\u6ed1#IF(npc.hasLegs())\u5230[npc.her]\u4e24\u817f\u4e4b\u95f4#ELSE\u5411[npc.her]\u7684\u80ef\u90e8#ENDIF\u3002");
                    }
                    if (SlaveDialogue.getSlave().hasVagina() && SlaveDialogue.getSlave().hasPenis()) {
                        UtilText.nodeContentSB.append("\u4f60\u5bf9\u7740[npc.her][npc.penis+]\u629a\u6478\u3001\u64b8\u52a8\u3001\u6311\u5f04\uff0c" + secondReaction + "\uff0c\u4f60\u5fcd\u4e0d\u4f4f\u5728\u5974\u96b6\u7684[npc.ear]\u8fb9[pc.moan]\u7740" + thirdReaction + "\u4f60\u8fd8\u662f\u80fd\u611f\u89c9\u5230[npc.her][npc.cock+]\u6b63\u5728\u4f60\u7684\u620f\u5f04\u4e0b\u9010\u6e10\u80c0\u5927\u3002\u4f60\u5c06[pc.hand]\u7ee7\u7eed\u5411\u4e0b\u63a2\u7d22\uff0c\u9010\u6e10\u5c06\u91cd\u5fc3\u8f6c\u79fb\u5230[npc.her][npc.pussy+]\u4e0a\uff0c\u4f60\u611f\u89c9\u5230\u5728\u4f60\u7684\u523a\u6fc0\u4e0b\uff0c[npc.her][npc.clit+]\u548c[npc.labia+]\u5df2\u7ecf\u6162\u6162\u6e7f\u6da6\u8d77\u6765\uff0c\u4e0d\u7981\u53c8\u9732\u51fa\u4e86\u7b11\u5bb9\u3002</p>");
                    } else if (SlaveDialogue.getSlave().hasVagina()) {
                        UtilText.nodeContentSB.append("\u4f60\u5bf9\u7740[npc.her][npc.clit+]\u629a\u6478\u3001\u64b8\u52a8\u3001\u6311\u5f04\uff0c" + secondReaction + "\uff0c\u4f60\u5fcd\u4e0d\u4f4f\u5728\u5974\u96b6\u7684[npc.ear]\u8fb9[pc.moan]\u7740" + thirdReaction + "\u4f60\u8fd8\u662f\u80fd\u611f\u89c9\u5230[npc.her][npc.pussy+]\u5728\u4f60\u7684\u620f\u5f04\u4e0b\u6e7f\u6da6\u4e86\u3002</p>");
                    } else if (SlaveDialogue.getSlave().hasPenis()) {
                        UtilText.nodeContentSB.append("\u4f60\u5bf9\u7740[npc.her][npc.penis+]\u629a\u6478\u3001\u64b8\u52a8\u3001\u6311\u5f04\uff0c" + secondReaction + "\uff0c\u4f60\u5fcd\u4e0d\u4f4f\u5728\u5974\u96b6\u7684[npc.ear]\u8fb9[pc.moan]\u7740" + thirdReaction + "\u4f60\u8fd8\u662f\u80fd\u611f\u89c9\u5230[npc.her][npc.cock+]\u6b63\u5728\u4f60\u7684\u620f\u5f04\u4e0b\u9010\u6e10\u80c0\u5927\u3002</p>");
                    } else {
                        UtilText.nodeContentSB.append("\u4f60\u5bf9\u7740[npc.her]\u65e0\u6027\u522b\u7684\u4e0b\u4f53\u629a\u6478\u3001\u6311\u5f04\uff0c" + secondReaction + "\uff0c\u4f60\u5fcd\u4e0d\u4f4f\u5728\u5974\u96b6\u7684[npc.ear]\u8fb9[pc.moan]\u7740" + thirdReaction + "\u4f60\u8fd8\u662f\u80fd\u611f\u89c9\u5230[npc.her]\u5728\u4f60\u7684\u620f\u5f04\u4e0b\u6643\u52a8\u8d77\u4e86\u8170\u8eab\u3002</p>");
                    }
                    UtilText.nodeContentSB.append("<p>" + secondSpeech + "</p><p>" + finalDescription + "</p>");
                    UtilText.nodeContentSB.append("<p><i>\u8c03\u620f[npc.name]\u6709\u52a9\u4e8e\u5f3a\u5316[npc.her]\u7684\u610f\u8bc6\u2014\u2014[npc.she]\u662f\u5c5e\u4e8e\u4f60\u7684\u2014\u2014\u8fd9\u4f1a\u63d0\u9ad8[npc.her]\u7684\u670d\u4ece\uff01");
                    if (SlaveDialogue.getSlave().isAttractedTo(Main.game.getPlayer())) {
                        if (SlaveDialogue.getSlave().hasFetish(Fetish.FETISH_SUBMISSIVE) || SlaveDialogue.getSlave().hasFetish(Fetish.FETISH_NON_CON_SUB)) {
                            UtilText.nodeContentSB.append("\u7531\u4e8e[npc.sheIs]\u4e0d\u4ec5\u88ab\u4f60\u5438\u5f15\uff0c\u800c\u4e14" + (SlaveDialogue.getSlave().hasFetish(Fetish.FETISH_SUBMISSIVE) ? (SlaveDialogue.getSlave().hasFetish(Fetish.FETISH_NON_CON_SUB) ? "\u65e2\u613f\u610f\u505a\u987a\u4ece\u8005\uff0c\u53c8\u56e0\u672a\u7ecf\u540c\u610f\u7684\u6027\u884c\u4e3a\u800c\u5174\u594b\uff0c" : "\u613f\u610f\u505a\u987a\u4ece\u8005\uff0c") : "\u56e0\u672a\u7ecf\u540c\u610f\u7684\u6027\u884c\u4e3a\u800c\u5174\u594b\uff0c") + "\u4f60\u5bf9\u4e8e[npc.namePos]\u8eab\u4f53\u7684\u4f7f\u7528\u4e0d\u5bb9\u62d2\u7edd\uff0c\u4e5f\u6ca1\u6709\u5f97\u5230\u540c\u610f\uff0c\u53cd\u800c\u8ba9[npc.herHim]\u66f4\u559c\u6b22\u4f60\u4e86\uff01</i></p>");
                        } else {
                            UtilText.nodeContentSB.append("\u7531\u4e8e[npc.sheIs]\u53d7\u5230\u4e86\u4f60\u7684\u5438\u5f15\uff0c\u800c\u4f60\u5bf9\u4e8e[npc.namePos]\u8eab\u4f53\u7684\u4f7f\u7528\u4e0d\u5bb9\u62d2\u7edd\uff0c\u4e5f\u6ca1\u6709\u5f97\u5230\u540c\u610f\uff0c\u5e76\u6ca1\u6709\u8ba9[npc.herHim]\u5bf9\u4f60\u7684\u597d\u611f\u4e0a\u5347\u6216\u4e0b\u964d\uff01</i></p>");
                        }
                    } else if (SlaveDialogue.getSlave().hasFetish(Fetish.FETISH_SUBMISSIVE) || SlaveDialogue.getSlave().hasFetish(Fetish.FETISH_NON_CON_SUB)) {
                        UtilText.nodeContentSB.append("\u5c3d\u7ba1[npc.sheIs]\u5e76\u6ca1\u6709\u88ab\u4f60\u5438\u5f15\uff0c\u4f46[npc.she]" + (SlaveDialogue.getSlave().hasFetish(Fetish.FETISH_SUBMISSIVE) ? (SlaveDialogue.getSlave().hasFetish(Fetish.FETISH_NON_CON_SUB) ? "\u65e2\u613f\u610f\u505a\u987a\u4ece\u8005\uff0c\u53c8\u56e0\u672a\u7ecf\u540c\u610f\u7684\u6027\u884c\u4e3a\u800c\u5174\u594b\uff0c" : "\u613f\u610f\u505a\u987a\u4ece\u8005\uff0c") : "\u56e0\u672a\u7ecf\u540c\u610f\u7684\u6027\u884c\u4e3a\u800c\u5174\u594b\uff0c") + "\u4f60\u5bf9\u4e8e[npc.namePos]\u8eab\u4f53\u7684\u4f7f\u7528\u4e0d\u5bb9\u62d2\u7edd\uff0c\u4e5f\u6ca1\u6709\u5f97\u5230\u540c\u610f\uff0c\u5374\u5e76\u6ca1\u6709\u8ba9[npc.herHim]\u5bf9\u4f60\u7684\u597d\u611f\u4e0a\u5347\u6216\u4e0b\u964d\uff01</i></p>");
                    } else {
                        UtilText.nodeContentSB.append("\u7531\u4e8e[npc.sheIs]\u5e76\u6ca1\u6709\u88ab\u4f60\u5438\u5f15\uff0c\u800c\u4f60\u5bf9\u4e8e[npc.namePos]\u8eab\u4f53\u7684\u4f7f\u7528\u4e0d\u5bb9\u62d2\u7edd\uff0c\u4e5f\u6ca1\u6709\u5f97\u5230\u540c\u610f\uff0c\u6240\u4ee5[npc.herHim]\u5931\u53bb\u4e86\u4e00\u4e9b\u5bf9\u4f60\u7684\u597d\u611f\uff01</i></p>");
                    }
                }
                UtilText.nodeContentSB.append(SlaveDialogue.getFooterText());
                return UtilText.parse((GameCharacter)SlaveDialogue.getSlave(), UtilText.nodeContentSB.toString(), new ParserTag[0]);
            }

            @Override
            public String getResponseTabTitle(int index) {
                return SLAVE_START.getResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return SLAVE_START.getResponse(responseTab, index);
            }
        };
        AFTER_SEX = new DialogueNode("\u8fd4\u56de", "", true){

            @Override
            public String getDescription() {
                return "\u4f60\u5df2\u7ecf\u723d\u8fc7\u4e86\uff0c\u79bb\u5f00\u8fd9\u91cc\u8ba9[npc.name]\u6062\u590d\u4e00\u4e0b\u5427\u3002";
            }

            @Override
            public String getContent() {
                if (Main.sex.getAllParticipants(false).size() == 4) {
                    ArrayList<GameCharacter> sexParticipants = new ArrayList<GameCharacter>(charactersPresent);
                    return UtilText.parseFromXMLFile(SlaveDialogue.getTextFilePath(), "AFTER_SEX_GANGBANG_3", sexParticipants);
                }
                if (Main.sex.getAllParticipants(false).size() == 5) {
                    ArrayList<GameCharacter> sexParticipants = new ArrayList<GameCharacter>(charactersPresent);
                    return UtilText.parseFromXMLFile(SlaveDialogue.getTextFilePath(), "AFTER_SEX_GANGBANG_4", sexParticipants);
                }
                if (Main.sex.getNumberOfOrgasms(SlaveDialogue.getSlave()) >= SlaveDialogue.getSlave().getOrgasmsBeforeSatisfied()) {
                    return UtilText.parseFromXMLFile(SlaveDialogue.getTextFilePath(), "AFTER_SEX", SlaveDialogue.getSlave());
                }
                return UtilText.parseFromXMLFile(SlaveDialogue.getTextFilePath(), "AFTER_SEX_NO_ORGASM", SlaveDialogue.getSlave());
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u7ee7\u7eed", "\u51b3\u5b9a\u63a5\u4e0b\u6765\u8be5\u505a\u4ec0\u4e48\u3002", SLAVE_START_NO_CONTENT){

                        @Override
                        public void effects() {
                            SlaveDialogue.initDialogue(SlaveDialogue.getSlave(), false);
                            Main.game.appendToTextEndStringBuilder(UtilText.parseFromXMLFile(SlaveDialogue.getTextFilePath(), "AFTER_SEX_CONTINUE", SlaveDialogue.getSlave()));
                            if (!SlaveDialogue.getSlave().isAsleep() && !SlaveDialogue.isDollStatue()) {
                                Main.game.appendToTextEndStringBuilder(SlaveDialogue.getFooterText());
                            }
                        }
                    };
                }
                return null;
            }
        };
    }
}

