/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.encounters;

import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.encounters.AbstractEncounter;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;

public class DominionEncounterDialogue {
    public static final DialogueNode ALLEY_FIND_ITEM = new DialogueNode("\u4e22\u5f03\u7684\u5305\u88f9", "", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            UtilText.addSpecialParsingString(AbstractEncounter.getRandomItem().getDisplayName(true), true);
            if (DominionEncounterDialogue.isCanal()) {
                return UtilText.parseFromXMLFile("encounters/dominion/generic", "CANAL_FIND_PACKAGE");
            }
            return UtilText.parseFromXMLFile("encounters/dominion/generic", "ALLEY_FIND_PACKAGE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u62ff\u8d70", "\u628a" + AbstractEncounter.getRandomItem().getName() + "\u52a0\u5165\u4f60\u7684\u7269\u54c1\u680f\u3002", Main.game.getDefaultDialogue(false)){

                    @Override
                    public void effects() {
                        if (AbstractEncounter.getRandomItem() instanceof AbstractWeapon) {
                            Main.game.getTextStartStringBuilder().append(Main.game.getPlayer().addWeapon((AbstractWeapon)AbstractEncounter.getRandomItem(), true));
                        } else if (AbstractEncounter.getRandomItem() instanceof AbstractClothing) {
                            Main.game.getTextStartStringBuilder().append(Main.game.getPlayer().addClothing((AbstractClothing)AbstractEncounter.getRandomItem(), true));
                        } else if (AbstractEncounter.getRandomItem() instanceof AbstractItem) {
                            Main.game.getTextStartStringBuilder().append(Main.game.getPlayer().addItem((AbstractItem)AbstractEncounter.getRandomItem(), true, true));
                        }
                    }
                };
            }
            if (index == 2) {
                return new Response("\u79bb\u5f00", "\u628a" + AbstractEncounter.getRandomItem().getName() + "\u7559\u5728\u5730\u4e0a\u3002", Main.game.getDefaultDialogue(false));
            }
            return null;
        }
    };
    public static final DialogueNode HARPY_NESTS_FIND_ITEM = new DialogueNode("\u9057\u843d\u7684\u7269\u54c1", "", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            UtilText.addSpecialParsingString(AbstractEncounter.getRandomItem().getDisplayName(true), true);
            UtilText.addSpecialParsingString(AbstractEncounter.getRandomItem().getName(), false);
            return UtilText.parseFromXMLFile("encounters/dominion/generic", "HARPY_NESTS_FIND_ITEM");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u62ff\u8d70", "\u628a" + AbstractEncounter.getRandomItem().getName() + "\u52a0\u5165\u4f60\u7684\u7269\u54c1\u680f\u3002", Main.game.getDefaultDialogue(false)){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(Main.game.getPlayer().addItem((AbstractItem)AbstractEncounter.getRandomItem(), true, true));
                    }
                };
            }
            if (index == 2) {
                return new Response("\u79bb\u5f00", "\u628a" + AbstractEncounter.getRandomItem().getName() + "\u7559\u5728\u5730\u4e0a\u3002", Main.game.getDefaultDialogue(false));
            }
            return null;
        }
    };
    public static final DialogueNode DOMINION_STREET_FIND_HAPPINESS = new DialogueNode("\u627e\u5230\u201c\u6b22\u6b23\u201d", "", true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("encounters/dominion/generic", "DOMINION_STREET_FIND_HAPPINESS");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u7ee7\u7eed\u4f60\u7684\u65c5\u7a0b\u3002", Main.game.getDefaultDialogue(false));
            }
            return null;
        }
    };
    public static final DialogueNode DOMINION_STREET_PILL_HANDOUT = new DialogueNode("", "", true){

        @Override
        public String getLabel() {
            if (Main.game.getDateNow().getMonth() == Month.MAY) {
                return "\u6bcd\u4eb2\u5468\u7684\u793c\u7269";
            }
            return "\u7236\u4eb2\u5468\u7684\u793c\u7269";
        }

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            if (Main.game.getDateNow().getMonth() == Month.MAY) {
                String name = Util.randomItemFrom(Subspecies.getWorldSpecies(WorldType.DOMINION, PlaceType.DOMINION_STREET, false, new AbstractSubspecies[0]).keySet()).getSingularFemaleName(null);
                String litter = Util.randomItemFrom(new String[]{"\u53cc\u80de\u80ce", "\u4e09\u80de\u80ce", "\u56db\u80de\u80ce", "\u4e94\u80de\u80ce", "\u516d\u80de\u80ce"});
                UtilText.addSpecialParsingString(name, true);
                UtilText.addSpecialParsingString(litter, false);
                return UtilText.parseFromXMLFile("encounters/dominion/generic", "DOMINION_STREET_PILL_HANDOUT_MOTHER");
            }
            String name = Util.randomItemFrom(Subspecies.getWorldSpecies(WorldType.DOMINION, PlaceType.DOMINION_STREET, false, new AbstractSubspecies[0]).keySet()).getSingularMaleName(null);
            UtilText.addSpecialParsingString(name, true);
            return UtilText.parseFromXMLFile("encounters/dominion/generic", "DOMINION_STREET_PILL_HANDOUT_FATHER");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u7ee7\u7eed\u4f60\u7684\u65c5\u7a0b\u3002", Main.game.getDefaultDialogue(false));
            }
            return null;
        }
    };

    private static boolean isCanal() {
        return Main.game.getPlayer().getLocationPlace().getPlaceType() == PlaceType.DOMINION_CANAL || Main.game.getPlayer().getLocationPlace().getPlaceType() == PlaceType.DOMINION_CANAL_END;
    }
}

