/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.eventLog;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.utils.XMLSaving;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EventLogEntry
implements XMLSaving {
    protected String name;
    protected String description;

    public EventLogEntry(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element element = doc.createElement("eventLogEntry");
        parentElement.appendChild(element);
        XMLUtil.addAttribute(doc, element, "name", this.name);
        XMLUtil.addAttribute(doc, element, "description", this.description);
        return element;
    }

    public static EventLogEntry loadFromXML(Element parentElement, Document doc) {
        return new EventLogEntry(parentElement.getAttribute("name"), parentElement.getAttribute("description"));
    }

    public String getFormattedEntry() {
        if (this.name == null || this.name.isEmpty()) {
            return this.description;
        }
        return this.name + ": " + this.description;
    }

    public String getMainDialogueDescription() {
        return "<p style='text-align:center;'><b>" + this.name + "</b><br/>" + this.description + "</p>";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

