/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.eventLog;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.occupantManagement.slaveEvent.SlaveEvent;
import com.lilithsthrone.game.occupantManagement.slaveEvent.SlaveEventTag;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.XMLSaving;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SlaveryEventLogEntry
implements XMLSaving {
    protected long time;
    private boolean slaveDeleted;
    private String slaveID;
    private List<String> involvedSlaveIDs;
    private SlaveEvent event;
    private List<SlaveEventTag> tags;
    private List<String> extraEffects;
    private String parsedName;
    private String parsedDescription;

    public SlaveryEventLogEntry(long time, NPC slave, List<String> involvedSlaveIDs, SlaveEvent event, boolean applyEffectsToSlave) {
        this(time, slave, involvedSlaveIDs, event, null, null, applyEffectsToSlave);
    }

    public SlaveryEventLogEntry(long time, NPC slave, List<String> involvedSlaveIDs, SlaveEvent event, List<SlaveEventTag> tags, boolean applyEffectsToSlave) {
        this(time, slave, involvedSlaveIDs, event, tags, null, applyEffectsToSlave);
    }

    public SlaveryEventLogEntry(long time, String slaveID, List<String> involvedSlaveIDs, SlaveEvent event, List<SlaveEventTag> tags, List<String> extraEffects) {
        this.time = time;
        this.slaveDeleted = false;
        this.slaveID = slaveID;
        this.involvedSlaveIDs = involvedSlaveIDs == null ? new ArrayList<String>() : new ArrayList<String>(involvedSlaveIDs);
        this.event = event;
        this.tags = tags;
        this.extraEffects = extraEffects;
    }

    public SlaveryEventLogEntry(long time, NPC slave, List<String> involvedSlaveIDs, SlaveEvent event, List<SlaveEventTag> tags, List<String> extraEffects, boolean applyEffectsToSlave) {
        this.time = time;
        this.slaveDeleted = false;
        this.slaveID = slave.getId();
        this.involvedSlaveIDs = involvedSlaveIDs == null ? new ArrayList<String>() : new ArrayList<String>(involvedSlaveIDs);
        this.event = event;
        if (applyEffectsToSlave) {
            event.applyEffects(slave);
        }
        this.tags = tags;
        if (tags != null && applyEffectsToSlave) {
            for (SlaveEventTag tag : tags) {
                tag.applyEffects(slave);
            }
        }
        this.extraEffects = extraEffects;
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element element = doc.createElement("eventLogEntry");
        parentElement.appendChild(element);
        XMLUtil.addAttribute(doc, element, "time", String.valueOf(this.time));
        XMLUtil.addAttribute(doc, element, "slaveID", this.slaveID);
        XMLUtil.addAttribute(doc, element, "event", this.event.toString());
        if (this.slaveDeleted) {
            XMLUtil.addAttribute(doc, element, "slaveDeleted", String.valueOf(this.slaveDeleted));
            Element deletedInfoNode = doc.createElement("deletedInfo");
            element.appendChild(deletedInfoNode);
            Element node = doc.createElement("parsedName");
            deletedInfoNode.appendChild(node);
            node.setTextContent(this.parsedName);
            node = doc.createElement("parsedDescription");
            deletedInfoNode.appendChild(node);
            node.setTextContent(this.parsedDescription);
        }
        if (this.involvedSlaveIDs != null && !this.involvedSlaveIDs.isEmpty()) {
            Element slavesNode = doc.createElement("involvedSlaves");
            element.appendChild(slavesNode);
            for (String id : this.involvedSlaveIDs) {
                Element idNode = doc.createElement("id");
                slavesNode.appendChild(idNode);
                idNode.setTextContent(id);
            }
        }
        if (this.tags != null) {
            Element tagsNode = doc.createElement("tags");
            element.appendChild(tagsNode);
            for (SlaveEventTag tag : this.tags) {
                Element tagDataNode = doc.createElement("tag");
                tagsNode.appendChild(tagDataNode);
                XMLUtil.addAttribute(doc, tagDataNode, "value", String.valueOf((Object)tag));
            }
        }
        if (this.extraEffects != null) {
            Element extraEffectsNode = doc.createElement("extraEffects");
            element.appendChild(extraEffectsNode);
            for (String s : this.extraEffects) {
                Element extraEffectsDataNode = doc.createElement("entry");
                extraEffectsNode.appendChild(extraEffectsDataNode);
                XMLUtil.addAttribute(doc, extraEffectsDataNode, "value", s);
            }
        }
        return element;
    }

    public static SlaveryEventLogEntry loadFromXML(Element parentElement, Document doc) {
        ArrayList<SlaveEventTag> loadedTags = null;
        NodeList nodes = parentElement.getElementsByTagName("tags");
        Element tagNode = (Element)nodes.item(0);
        if (tagNode != null) {
            loadedTags = new ArrayList<SlaveEventTag>();
            NodeList tagElements = tagNode.getElementsByTagName("tag");
            for (int i = 0; i < tagElements.getLength(); ++i) {
                Element e = (Element)tagElements.item(i);
                try {
                    String value = e.getAttribute("value");
                    if (value.equals("JOB_LILAYA_MILK_SOLD")) {
                        value = "JOB_MILK_SOLD";
                    } else if (value.equals("JOB_LILAYA_CUM_SOLD")) {
                        value = "JOB_CUM_SOLD";
                    }
                    loadedTags.add(SlaveEventTag.valueOf(value));
                    continue;
                }
                catch (IllegalArgumentException value) {
                    // empty catch block
                }
            }
        }
        ArrayList<String> loadedSlaveIDs = null;
        nodes = parentElement.getElementsByTagName("involvedSlaves");
        Element slaveIdsNode = (Element)nodes.item(0);
        if (slaveIdsNode != null) {
            loadedSlaveIDs = new ArrayList<String>();
            NodeList idElements = slaveIdsNode.getElementsByTagName("id");
            for (int i = 0; i < idElements.getLength(); ++i) {
                Element e = (Element)idElements.item(i);
                try {
                    loadedSlaveIDs.add(e.getTextContent());
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        ArrayList<String> loadedExtraEffects = null;
        nodes = parentElement.getElementsByTagName("extraEffects");
        Element extraEffectNode = (Element)nodes.item(0);
        if (extraEffectNode != null) {
            NodeList extraEffectElements = extraEffectNode.getElementsByTagName("entry");
            loadedExtraEffects = new ArrayList<String>(extraEffectElements.getLength());
            for (int i = 0; i < extraEffectElements.getLength(); ++i) {
                Element e = (Element)extraEffectElements.item(i);
                try {
                    loadedExtraEffects.add(e.getAttribute("value"));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        SlaveryEventLogEntry entry = new SlaveryEventLogEntry((long)Long.valueOf(parentElement.getAttribute("time")), parentElement.getAttribute("slaveID"), loadedSlaveIDs, SlaveEvent.valueOf(parentElement.getAttribute("event")), loadedTags, loadedExtraEffects);
        boolean loadedSlaveDeleted = false;
        if (parentElement.hasAttribute("slaveDeleted")) {
            loadedSlaveDeleted = Boolean.valueOf(parentElement.getAttribute("slaveDeleted"));
            nodes = parentElement.getElementsByTagName("deletedInfo");
            Element deletedInfoNode = (Element)nodes.item(0);
            if (deletedInfoNode != null) {
                entry.parsedName = deletedInfoNode.getElementsByTagName("parsedName").item(0).getTextContent();
                entry.parsedDescription = deletedInfoNode.getElementsByTagName("parsedDescription").item(0).getTextContent();
            }
        }
        entry.slaveDeleted = loadedSlaveDeleted;
        return entry;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String getName() {
        return this.event.getName();
    }

    public String getDescription() {
        if (this.slaveDeleted) {
            return this.parsedDescription;
        }
        StringBuilder descriptionSB = new StringBuilder();
        descriptionSB.append(this.event.getDescription());
        if (this.tags != null) {
            for (SlaveEventTag tag : this.tags) {
                if (descriptionSB.length() > 0) {
                    descriptionSB.append("<br/>");
                }
                descriptionSB.append(tag.getDescription());
            }
        }
        if (this.extraEffects != null) {
            for (String s : this.extraEffects) {
                if (descriptionSB.length() > 0) {
                    descriptionSB.append("<br/>");
                }
                descriptionSB.append(s);
            }
        }
        try {
            GameCharacter slave = Main.game.getNPCById(this.slaveID);
            return UtilText.parse(slave, descriptionSB.toString(), new ParserTag[0]);
        }
        catch (Exception e) {
            Util.logGetNpcByIdError("SlaveryEventLogEntry.getDescription()", this.slaveID);
            return descriptionSB.toString();
        }
    }

    public String getSlaveName() {
        if (this.slaveDeleted) {
            return this.parsedName;
        }
        try {
            GameCharacter slave = Main.game.getNPCById(this.slaveID);
            return "<b style='color:" + slave.getFemininity().getColour().toWebHexString() + ";'>" + slave.getName(true) + "</b>";
        }
        catch (Exception e) {
            Util.logGetNpcByIdError("SlaveryEventLogEntry.getSlaveName()", this.slaveID);
            return "<b>\u5974\u96b6</b>";
        }
    }

    public String getSlaveID() {
        return this.slaveID;
    }

    public List<String> getInvolvedSlaveIDs() {
        return this.involvedSlaveIDs;
    }

    public SlaveEvent getEvent() {
        return this.event;
    }

    public List<SlaveEventTag> getTags() {
        return this.tags;
    }

    public boolean addTag(SlaveEventTag tag, GameCharacter slave, boolean withEffects) {
        if (this.tags == null) {
            this.tags = new ArrayList<SlaveEventTag>();
        }
        if (this.tags.add(tag)) {
            if (withEffects) {
                tag.applyEffects(slave);
            }
            return true;
        }
        return false;
    }

    public List<String> getExtraEffects() {
        return this.extraEffects;
    }

    public void addExtraEffect(String extraEffect) {
        if (this.extraEffects == null) {
            this.extraEffects = new ArrayList<String>();
        }
        this.extraEffects.add(extraEffect);
    }

    public void applySlaveDeleted() {
        this.parsedName = this.getSlaveName();
        this.parsedDescription = this.getDescription();
        this.slaveDeleted = true;
    }
}

