/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.dominion;

import com.lilithsthrone.game.character.npc.dominion.Daddy;
import com.lilithsthrone.game.character.npc.dominion.Felicia;
import com.lilithsthrone.game.character.npc.dominion.Fiammetta;
import com.lilithsthrone.game.character.quests.Quest;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueManager;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.npcDialogue.dominion.DaddyDialogue;
import com.lilithsthrone.game.dialogue.places.dominion.feliciaApartment.FeliciaApartment;
import com.lilithsthrone.game.dialogue.places.dominion.zaranixHome.ZaranixHomeGroundFloor;
import com.lilithsthrone.game.dialogue.places.dominion.zaranixHome.ZaranixHomeGroundFloorRepeat;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.Season;
import com.lilithsthrone.world.Weather;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.Month;

public class DemonHome {
    public static final DialogueNode DEMON_HOME_GATE = new DialogueNode("\u6076\u9b54\u4e4b\u5bb6(\u5927\u95e8)", "\u6076\u9b54\u4e4b\u5bb6", false){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append("<p>\u8fd9\u91cc\u7684\u8857\u9053\u5bf9\u9762\u5efa\u6709\u4e00\u6247\u5de8\u5927\u7684\u94c1\u95e8\uff0c\u5c06\u5fa1\u57ce\u533a\u7684\u5e38\u89c4\u533a\u57df\u4e0e\u5916\u9762\u7684\u201c\u6076\u9b54\u4e4b\u5bb6\u201d\u5206\u9694\u5f00\u6765\u3002\u534a\u6253\u7cbe\u82f1\u6076\u9b54\u6267\u6cd5\u8005\u9a7b\u624e\u5728\u8fd9\u91cc\uff0c\u5bc6\u5207\u5730\u76d1\u89c6\u7740\u8def\u8fc7\u7684\u4eba\u3002</p><p>\u5f53\u4f60\u8d70\u8fc7\u5927\u95e8\u65f6\uff0c\u4f60\u6ce8\u610f\u5230\u5176\u4e2d\u4e00\u4f4d\u6076\u9b54\u5b88\u536b\u6b63\u5728\u76ef\u7740\u4f60\u4f60\u65e0\u89c6\u5b88\u536b\u9510\u5229\u7684\u76ee\u5149\uff0c\u5927\u6b65\u5411\u524d\u8d70\u53bb\u3002\u5f53\u4f60\u987a\u5229\u5230\u8fbe\u53e6\u4e00\u4fa7\u65f6\uff0c\u4f60\u957f\u957f\u5730\u8212\u4e86\u4e00\u53e3\u6c14\u3002</p>");
            UtilText.nodeContentSB.append(DemonHome.getAdditionalDescriptions());
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return null;
        }
    };
    public static final DialogueNode DEMON_HOME_STREET = new DialogueNode("\u6076\u9b54\u4e4b\u5bb6", "\u6076\u9b54\u4e4b\u5bb6", false){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append("<p>\u4ece\u5927\u7406\u77f3\u94fa\u5c31\u7684\u5bbd\u9614\u8857\u9053\uff0c\u5230\u6444\u653f\u98ce\u683c\u5efa\u7b51\u5b8c\u7f8e\u65e0\u7455\u7684\u6b63\u9762\uff0c\u201c\u6076\u9b54\u4e4b\u5bb6\u201d\u6240\u5728\u533a\u57df\u663e\u7136\u662f\u5fa1\u57ce\u533a\u8f83\u4e3a\u9ad8\u6863\u7684\u533a\u57df\u4e4b\u4e00\u3002\u8be5\u5730\u533a\u5206\u5e03\u7740\u8bb8\u591a\u96d5\u523b\u7cbe\u7f8e\u7684\u96d5\u50cf\uff0c\u5176\u4e2d\u7edd\u5927\u591a\u6570\u90fd\u63cf\u7ed8\u4e86\u67d0\u79cd\u5f62\u5f0f\u7684\u6076\u9b54\uff0c\u4f60\u8ba4\u4e3a\u8fd9\u4e9b\u96d5\u5851\u5c31\u662f\u8fd9\u4e2a\u5730\u533a\u7684\u540d\u79f0\u7531\u6765\u3002</p><p>\u8d70\u5728\u8857\u4e0a\uff0c\u4f60\u7ecf\u8fc7\u51e0\u4e2a\u7528\u6805\u680f\u56f4\u8d77\u6765\u7684\u79c1\u4eba\u82b1\u56ed\uff1b\u5b83\u4eec\u90c1\u90c1\u8471\u8471\uff0c\u6253\u7834\u4e86\u5468\u56f4\u5efa\u7b51\u4e73\u767d\u8272\u77f3\u5934\u5916\u5899\u7684\u5355\u8c03\u611f\u3002\u5c3d\u7ba1\u201c\u6076\u9b54\u4e4b\u5bb6\u201d\u6bd4\u5fa1\u57ce\u533a\u7684\u5176\u4ed6\u5927\u90e8\u5206\u5730\u533a\u90fd\u8981\u5b89\u9759\u4e00\u4e9b\uff0c\u4f46\u4f60\u6ce8\u610f\u5230\u8857\u4e0a\u5de1\u903b\u7684\u6267\u6cd5\u8005\u8fd8\u662f\u7a0d\u5fae\u591a\u4e00\u4e9b\uff1b\u8fd9\u4e9b\u8bc1\u636e\u8868\u660e\uff0c\u57ce\u5e02\u91cc\u5bcc\u6709\u7684\u548c\u6709\u5f71\u54cd\u529b\u7684\u5c45\u6c11\u53d7\u5230\u4e86\u989d\u5916\u7684\u4fdd\u62a4\u3002</p>");
            if (Main.game.getPlayerCell().getPlace().getPlaceType().equals(PlaceType.DOMINION_DEMON_HOME_DADDY)) {
                UtilText.nodeContentSB.append("<p><b style='color:" + PresetColour.RACE_DEMON.toWebHexString() + ";'>[daddy.NamePos]\u4f4f\u5904\uff1a</b><br/>[Daddy.NamePos]\u516c\u5bd3\u4f4d\u4e8e\u6076\u9b54\u4e4b\u5bb6\u7684\u8fd9\u4e00\u7279\u5b9a\u533a\u57df\u3002" + Daddy.getAvailabilityText() + "</p>");
            }
            if (Main.game.getPlayerCell().getPlace().getPlaceType().equals(PlaceType.DOMINION_DEMON_HOME_ARTHUR)) {
                UtilText.nodeContentSB.append("<p><b style='color:" + PresetColour.RACE_HUMAN.toWebHexString() + ";'>\u5723\u5c14\u8482\u65c5\u9986:</b><br/>\u4e9a\u745f\u7684\u516c\u5bd3\u697c\u201c\u5723\u5c14\u8482\u65c5\u9986\u201d\u5c31\u4f4d\u4e8e\u6076\u9b54\u4e4b\u5bb6\u7684\u8fd9\u4e00\u7279\u6b8a\u533a\u57df\u3002</p>");
            }
            UtilText.nodeContentSB.append(DemonHome.getAdditionalDescriptions());
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return null;
        }
    };
    public static final DialogueNode DEMON_HOME_STREET_ARTHUR = new DialogueNode("\u6076\u9b54\u4e4b\u5bb6", "\u6076\u9b54\u4e4b\u5bb6", false){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return DEMON_HOME_STREET.getContent();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getPlayer().getQuest(QuestLine.MAIN) == Quest.MAIN_1_B_DEMON_HOME) {
                    return new Response("\u5723\u5c14\u8482\u65c5\u9986", "\u6309\u7167\u8389\u83b1\u96c5\u7ed9\u4f60\u7684\u6307\u793a\u627e\u5230\u4e9a\u745f\u5728\u5927\u697c\u91cc\u7684\u516c\u5bd3\u3002", DEMON_HOME_ARTHURS_APARTMENT);
                }
                if (Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_1_B_DEMON_HOME)) {
                    return new Response("\u5723\u5c14\u8482\u65c5\u9986", "\u524d\u5f80\u5723\u5c14\u8482\u65c5\u9986\u516c\u5bd3\u697c\u3002", DEMON_HOME_ARTHURS_APARTMENT);
                }
                return null;
            }
            return null;
        }
    };
    public static final DialogueNode DEMON_HOME_STREET_ZARANIX = new DialogueNode("\u6076\u9b54\u4e4b\u5bb6", "\u6076\u9b54\u4e4b\u5bb6", false){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return DEMON_HOME_STREET.getContent();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getPlayer().getQuest(QuestLine.MAIN) == Quest.MAIN_1_H_THE_GREAT_ESCAPE) {
                    return new Response("\u624e\u62c9\u5c3c\u514b\u65af\u7684\u5bb6", "\u4ece\u4e9a\u745f\u7684\u516c\u5bd3\u697c\u5f80\u4e0b\u8d70\u4e00\u6bb5\u8def\uff0c\u5c31\u5230\u4e86\u624e\u62c9\u5c3c\u514b\u65af\u7684\u5bb6\uff0c\u4e5f\u5c31\u662f\u65af\u5609\u4e3d\u8ddf\u4f60\u8bf4\u8fc7\u7684\u90a3\u4e2a\u6076\u9b54\u3002", ZaranixHomeGroundFloor.OUTSIDE);
                }
                if (Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_1_H_THE_GREAT_ESCAPE)) {
                    return new Response("\u624e\u62c9\u5c3c\u514b\u65af\u7684\u5bb6", "\u518d\u6b21\u8bbf\u95ee\u624e\u62c9\u5c3c\u514b\u65af\u3002", ZaranixHomeGroundFloorRepeat.OUTSIDE);
                }
                return null;
            }
            return null;
        }
    };
    public static final DialogueNode DEMON_HOME_STREET_DADDY = new DialogueNode("\u6076\u9b54\u4e4b\u5bb6", "\u6076\u9b54\u4e4b\u5bb6", false){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return DEMON_HOME_STREET.getContent();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (!Daddy.isAvailable()) {
                    return new Response("[daddy.Name]", Daddy.getAvailabilityText(), null);
                }
                if (Main.game.getPlayer().hasCompanions()) {
                    return new Response("[daddy.Name]", "[style.italicsBad(\u5728\u6709\u540c\u4f34\u7684\u60c5\u51b5\u4e0b\uff0c\u4f60\u65e0\u6cd5\u4e0e[daddy.name]\u4f1a\u9762\uff01)]", null);
                }
                return new Response("[daddy.Name]", "\u524d\u5f80[daddy.namePos]\u516c\u5bd3\uff0c\u6572\u5f00[daddy.her]\u7684\u95e8\u3002", DaddyDialogue.MEETING){

                    @Override
                    public void effects() {
                        if (Main.game.getPlayer().isQuestProgressLessThan(QuestLine.SIDE_DADDY, Quest.DADDY_MEETING)) {
                            Main.game.getTextStartStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_DADDY, Quest.DADDY_MEETING));
                        }
                        Main.game.getPlayer().setLocation(WorldType.DADDYS_APARTMENT, PlaceType.DADDY_APARTMENT_ENTRANCE);
                        Main.game.getNpc(Daddy.class).setLocation(Main.game.getPlayer(), false);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode DEMON_HOME_ARTHURS_APARTMENT = new DialogueNode("", "-", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/arthursApartment/apartment", "DEMON_HOME_ARTHURS_APARTMENT");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getPlayer().getQuest(QuestLine.MAIN) == Quest.MAIN_1_B_DEMON_HOME) {
                    return new Response("\u4e9a\u745f\u7684\u623f\u95f4", "\u8fdb\u5165\u4e9a\u745f\u7684\u623f\u95f4", DEMON_HOME_ARTHURS_APARTMENT_ARTHURS_ROOM){

                        @Override
                        public void effects() {
                            if (Main.game.getPlayer().getQuest(QuestLine.MAIN) == Quest.MAIN_1_B_DEMON_HOME) {
                                Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.MAIN, Quest.MAIN_1_C_WOLFS_DEN));
                            }
                        }
                    };
                }
                if (Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_1_B_DEMON_HOME)) {
                    return new Response("\u4e9a\u745f\u7684\u623f\u95f4", "\u4e9a\u745f\u5df2\u7ecf\u4e0d\u4f4f\u5728\u8fd9\u91cc\u4e86\u2026\u2026", null);
                }
            } else if (index == 2) {
                if (Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.MAIN, Quest.MAIN_1_B_DEMON_HOME)) {
                    return new Response("[felicia.Name]\u7684\u623f\u95f4", "\u524d\u5f80[felicia.namePos]\u7684\u623f\u95f4\u3002", DEMON_HOME_ARTHURS_APARTMENT_FELICIAS_ROOM);
                }
            } else if (index == 0) {
                return new Response("\u79bb\u5f00", "\u79bb\u5f00\u5efa\u7b51\uff0c\u56de\u5230\u6076\u9b54\u4e4b\u5bb6\u7684\u5927\u8857\u4e0a", DEMON_HOME_STREET_ARTHUR);
            }
            return null;
        }
    };
    public static final DialogueNode DEMON_HOME_ARTHURS_APARTMENT_ARTHURS_ROOM = new DialogueNode("\u4e9a\u745f\u7684\u623f\u95f4", "-", true){

        @Override
        public void applyPreParsingEffects() {
            DemonHome.getFelicia().equipOutsideClothing();
            DemonHome.getFelicia().setLocation(Main.game.getPlayer(), false);
        }

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getLabel() {
            return "\u4e9a\u745f\u7684\u623f\u95f4";
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/arthursApartment/apartment", "DEMON_HOME_ARTHURS_APARTMENT_ARTHURS_ROOM");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u8be2\u95ee\u72ac\u5973", "\u8be2\u95ee\u72ac\u5973\u662f\u5426\u77e5\u9053\u6709\u5173\u4e9a\u745f\u88ab\u6355\u7684\u4e8b\u60c5", DEMON_HOME_ARTHURS_APARTMENT_ARTHURS_ROOM_END);
            }
            return null;
        }
    };
    public static final DialogueNode DEMON_HOME_ARTHURS_APARTMENT_ARTHURS_ROOM_END = new DialogueNode("\u4e9a\u745f\u7684\u623f\u95f4", "-", true, true){

        @Override
        public void applyPreParsingEffects() {
            DemonHome.getFelicia().setPlayerKnowsName(true);
        }

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/arthursApartment/apartment", "DEMON_HOME_ARTHURS_APARTMENT_ARTHURS_ROOM_END");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u79bb\u5f00", "\u4f60\u5728\u8fd9\u5df2\u7ecf\u505a\u4e86\u6240\u6709\u80fd\u505a\u7684\u3002\u8f6c\u8eab\u79bb\u5f00\u6076\u9b54\u4e4b\u5bb6\u3002", DEMON_HOME_STREET_ARTHUR){

                    @Override
                    public void effects() {
                        DemonHome.getFelicia().equipInsideClothing();
                        DemonHome.getFelicia().setLocation(WorldType.FELICIA_APARTMENT, PlaceType.FELICIA_APARTMENT_LIVING_AREA, true);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode DEMON_HOME_ARTHURS_APARTMENT_FELICIAS_ROOM = new DialogueNode("", "", true){
        public int h;

        @Override
        public void applyPreParsingEffects() {
            this.h = Main.game.getHourOfDay();
            if (this.h >= 6 && this.h <= 14) {
                DemonHome.getFelicia().setLocation(Main.game.getPlayer(), false);
                DemonHome.getFelicia().setIntroducedToPlayer(true);
            }
        }

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getLabel() {
            return "[felicia.NamePos]\u623f\u95f4";
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/arthursApartment/apartment", "DEMON_HOME_ARTHURS_APARTMENT_FELICIAS_ROOM");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.feliciaRejectedPlayer)) {
                    return new Response("\u79bb\u5f00", "\u770b\u6765\u83f2\u5229\u5e0c\u4e9a\u4e0d\u60f3\u548c\u4f60\u8bf4\u8bdd\u3002\u56de\u5230\u5916\u9762\u7684\u6076\u9b54\u4e4b\u5bb6", DEMON_HOME_STREET_ARTHUR);
                }
                if (this.h < 6 || this.h > 14) {
                    return new Response("\u79bb\u5f00", "\u770b\u8d77\u6765[felicia.name]\u4e0d\u5728\u8fd9\u91cc\u3002\u56de\u5230\u6076\u9b54\u4e4b\u5bb6\u95e8\u5916\u3002", DEMON_HOME_STREET_ARTHUR);
                }
                if (this.h >= 6 && this.h <= 14) {
                    if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.feliciaToldAboutArthur)) {
                        return new Response("\u8fdb\u5165", "\u8fdb\u5165[felicia.namePos]\u5bb6\u3002", FeliciaApartment.ARTHUR_WHEREABOUTS){

                            @Override
                            public void effects() {
                                DemonHome.getFelicia().setLocation(WorldType.FELICIA_APARTMENT, PlaceType.FELICIA_APARTMENT_LIVING_AREA, false);
                                Main.game.getPlayer().setLocation(WorldType.FELICIA_APARTMENT, PlaceType.FELICIA_APARTMENT_LIVING_AREA);
                            }
                        };
                    }
                    return new Response("\u8fdb\u5165", "\u8fdb\u5165[felicia.namePos]\u5bb6\u3002", FeliciaApartment.FELICIA_GREETINGS){

                        @Override
                        public void effects() {
                            DemonHome.getFelicia().setLocation(WorldType.FELICIA_APARTMENT, PlaceType.FELICIA_APARTMENT_LIVING_AREA, false);
                            Main.game.getPlayer().setLocation(WorldType.FELICIA_APARTMENT, PlaceType.FELICIA_APARTMENT_LIVING_AREA);
                        }
                    };
                }
            }
            return null;
        }
    };
    public static final DialogueNode DEMON_HOME_SEX_SHOP = new DialogueNode("", "", false){

        @Override
        public void applyPreParsingEffects() {
            if (Main.game.getPlayer().getQuest(QuestLine.SIDE_DOLL_FACTORY) == Quest.DOLL_FACTORY_7A && !Main.game.getDialogueFlags().hasFlag("innoxia_doll_factory_ending_riot_witnessed")) {
                Main.game.getNpc(Fiammetta.class).setLocation(Main.game.getPlayer());
                Main.game.appendToTextEndStringBuilder(Main.game.getPlayer().incrementMoney(50000L));
            }
            if (Main.game.getPlayer().getQuest(QuestLine.SIDE_DOLL_FACTORY) == Quest.DOLL_FACTORY_7A && Main.game.getSecondsPassed() - Main.game.getDialogueFlags().getSavedLong("doll_quest_choice_time") < 604800L) {
                int daysToGo = 7 - (int)((Main.game.getSecondsPassed() - Main.game.getDialogueFlags().getSavedLong("doll_quest_choice_time")) / 86400L);
                if (daysToGo <= 1) {
                    UtilText.addSpecialParsingString("[style.italicsGood(\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u5c06\u4f1a\u5728\u4e00\u4e24\u5929\u540e\u91cd\u65b0\u5f00\u5f20\u3002)]", true);
                } else {
                    UtilText.addSpecialParsingString("[style.italicsMinorGood(\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u5c06\u4f1a\u5728" + daysToGo + "\u5929\u540e\u91cd\u65b0\u5f00\u5f20\u2026\u2026)]", true);
                }
            }
            if (Main.game.getPlayer().getQuest(QuestLine.SIDE_DOLL_FACTORY) == Quest.DOLL_FACTORY_7B && Main.game.getSecondsPassed() - Main.game.getDialogueFlags().getSavedLong("doll_quest_choice_time") < 86400L) {
                UtilText.addSpecialParsingString("[style.italicsGood(\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u5c06\u4f1a\u5728\u4e00\u4e24\u5929\u540e\u91cd\u65b0\u5f00\u5f20\u3002)]", true);
            }
        }

        @Override
        public boolean isTravelDisabled() {
            if (Main.game.getPlayer().getQuest(QuestLine.SIDE_DOLL_FACTORY) == Quest.DOLL_FACTORY_7A) {
                if (Main.game.getSecondsPassed() - Main.game.getDialogueFlags().getSavedLong("doll_quest_choice_time") < 604800L) {
                    return !Main.game.getDialogueFlags().hasFlag("innoxia_doll_factory_ending_riot_witnessed");
                }
                return !Main.game.getDialogueFlags().hasFlag("innoxia_doll_factory_ending_reopen_scene_seen");
            }
            return false;
        }

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            if (Main.game.getPlayer().getQuest(QuestLine.SIDE_DOLL_FACTORY) == Quest.DOLL_FACTORY_7A) {
                if (Main.game.getSecondsPassed() - Main.game.getDialogueFlags().getSavedLong("doll_quest_choice_time") < 604800L) {
                    return UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "DEMON_HOME_SEX_SHOP_RIOT");
                }
                if (!Main.game.getDialogueFlags().hasFlag("innoxia_doll_factory_ending_reopen_scene_seen")) {
                    return UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "DEMON_HOME_SEX_SHOP_RIOT_ENDED");
                }
            }
            if (Main.game.getPlayer().getQuest(QuestLine.SIDE_DOLL_FACTORY) == Quest.DOLL_FACTORY_7B && Main.game.getSecondsPassed() - Main.game.getDialogueFlags().getSavedLong("doll_quest_choice_time") < 86400L) {
                return UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "DEMON_HOME_SEX_SHOP_FIA_CLOSED");
            }
            return UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "DEMON_HOME_SEX_SHOP");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (!(Main.game.getPlayer().getQuest(QuestLine.SIDE_DOLL_FACTORY) != Quest.DOLL_FACTORY_7A || Main.game.getSecondsPassed() - Main.game.getDialogueFlags().getSavedLong("doll_quest_choice_time") >= 604800L && Main.game.getDialogueFlags().hasFlag("innoxia_doll_factory_ending_riot_witnessed") && Main.game.getDialogueFlags().hasFlag("innoxia_doll_factory_ending_reopen_scene_seen"))) {
                    if (!Main.game.getDialogueFlags().hasFlag("innoxia_doll_factory_ending_riot_witnessed")) {
                        return new Response("\u544a\u522b", "\u5411\u83f2\u4e9a\u6885\u5854\u9053\u522b\u3002", DEMON_HOME_SEX_SHOP_RIOT_CONTINUE){

                            @Override
                            public void effects() {
                                Main.game.getNpc(Fiammetta.class).returnToHome();
                                Main.game.getDialogueFlags().setFlag("innoxia_doll_factory_ending_riot_witnessed", true);
                                if (Main.game.getSecondsPassed() - Main.game.getDialogueFlags().getSavedLong("doll_quest_choice_time") >= 604800L) {
                                    Main.game.getDialogueFlags().setSavedLong("doll_quest_choice_time", Main.game.getSecondsPassed() - 518400L);
                                }
                            }
                        };
                    }
                    if (Main.game.getSecondsPassed() - Main.game.getDialogueFlags().getSavedLong("doll_quest_choice_time") >= 604800L && !Main.game.getDialogueFlags().hasFlag("innoxia_doll_factory_ending_reopen_scene_seen")) {
                        return new Response("\u7ee7\u7eed", "\u7ee7\u7eed\u4f60\u7684\u65c5\u7a0b\u3002", DEMON_HOME_SEX_SHOP){

                            @Override
                            public void effects() {
                                Main.game.getDialogueFlags().setFlag("innoxia_doll_factory_ending_reopen_scene_seen", true);
                            }
                        };
                    }
                    int daysRemaining = 7 - (int)((Main.game.getSecondsPassed() - Main.game.getDialogueFlags().getSavedLong("doll_quest_choice_time")) / 86400L);
                    return new Response("\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97", "\u7531\u4e8e\u516c\u4f17\u7684\u9a9a\u4e71\uff0c\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u73b0\u5728[style.colourBad(\u5173\u95ed)]\u4e86\u3002<br/>[style.italicsMinorGood(\u5927\u7ea6\u4f1a\u5728" + Util.intToString(daysRemaining) + "\u5929\u540e\u91cd\u65b0\u5f00\u5f20\u2026\u2026)]", null);
                }
                if (Main.game.getPlayer().getQuest(QuestLine.SIDE_DOLL_FACTORY) == Quest.DOLL_FACTORY_7B && Main.game.getDialogueFlags().hasSavedLong("doll_quest_choice_time") && Main.game.getSecondsPassed() - Main.game.getDialogueFlags().getSavedLong("doll_quest_choice_time") < 86400L) {
                    return new Response("\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97", "\u7531\u4e8e\u9700\u8981\u5904\u7406\u83f2\u4e9a\u6885\u5854\u7684\u6587\u7ae0\u6240\u5f15\u53d1\u7684\u60c5\u51b5\uff0c\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u76ee\u524d[style.colourBad(\u5173\u95ed)]\u4e86\u3002<br/>[style.italicsMinorGood(\u5927\u7ea6\u4f1a\u5728\u4e00\u4e24\u5929\u540e\u91cd\u65b0\u5f00\u5f20\u2026\u2026)]", null);
                }
                if (!Main.game.isHourBetween(11.0f, 23.0f)) {
                    return new Response("\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97", "\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97[units.time(11)]-[units.time(23)]\u5f00\u653e\uff0c\u56e0\u6b64\u76ee\u524d\u662f[style.colourBad(\u5173\u95ed)]\u7684\u3002", null);
                }
                return new Response("\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97", "\u63a8\u5f00\u524d\u95e8\uff0c\u8fdb\u5165\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97", DialogueManager.getDialogueFromId("innoxia_places_dominion_sex_shop_generic_enter")){

                    @Override
                    public void effects() {
                        Main.game.getPlayer().setLocation(WorldType.getWorldTypeFromId("innoxia_dominion_sex_shop"), PlaceType.getPlaceTypeFromId("innoxia_dominion_sex_shop_exit"));
                    }
                };
            }
            if (index == 2) {
                if (!(Main.game.getPlayer().getQuest(QuestLine.SIDE_DOLL_FACTORY) != Quest.DOLL_FACTORY_7A || Main.game.getSecondsPassed() - Main.game.getDialogueFlags().getSavedLong("doll_quest_choice_time") >= 604800L && Main.game.getDialogueFlags().hasFlag("innoxia_doll_factory_ending_riot_witnessed") && Main.game.getDialogueFlags().hasFlag("innoxia_doll_factory_ending_reopen_scene_seen") || Main.game.getDialogueFlags().hasFlag("innoxia_doll_factory_ending_riot_witnessed"))) {
                    return null;
                }
                if (Main.game.getPlayer().getQuest(QuestLine.SIDE_DOLL_FACTORY) == Quest.DOLL_FACTORY_7A && Main.game.getSecondsPassed() - Main.game.getDialogueFlags().getSavedLong("doll_quest_choice_time") >= 604800L && !Main.game.getDialogueFlags().hasFlag("innoxia_doll_factory_ending_reopen_scene_seen")) {
                    return null;
                }
                if (Main.game.getPlayer().getQuest(QuestLine.SIDE_DOLL_FACTORY) == Quest.DOLL_FACTORY_2) {
                    if (!Main.game.isHourBetween(1.0f, 4.0f)) {
                        return new Response("\u5bfb\u627e\u83f2\u4e9a", "\u4f60\u9700\u8981\u7b49\u5230[units.time(1)]\u5230[units.time(4)]\u4e4b\u95f4\uff0c\u518d\u8ddf\u83f2\u4e9a\u4e00\u8d77\u95ef\u5165\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u2026\u2026", null);
                    }
                    if (Main.game.getCurrentWeather() == Weather.MAGIC_STORM) {
                        return new Response("\u5bfb\u627e\u83f2\u4e9a", "\u867d\u7136\u4f60\u5728[units.time(1)]\u5230[units.time(4)]\u4e4b\u95f4\u6309\u65f6\u5230\u8fbe\u3002\u53ef\u83f2\u4e9a\u5374\u7531\u4e8e\u5965\u672f\u98ce\u66b4\u65e0\u6cd5\u73b0\u8eab\u2026\u2026", null);
                    }
                    return new Response("\u5bfb\u627e\u83f2\u4e9a", "\u5bfb\u627e\u83f2\u4e9a\u7684\u8e2a\u8ff9\uff0c\u51c6\u5907\u4e24\u4eba\u4e00\u8d77\u95ef\u5165\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\uff0c\u641c\u5bfb\u662f\u5426\u6709\u4e9b\u8bc1\u636e\uff0c\u8bb0\u5f55\u4e86\u88ab\u7ed1\u67b6\u8005\u7684\u6240\u5728\u3002<br/>[style.italicsCombat(\u8bf7\u505a\u597d\u51c6\u5907\uff0c\u56e0\u4e3a\u8fd9\u5c06\u5f00\u542f\u4e00\u6bb5\u6f2b\u957f\u7684\u652f\u7ebf\u4efb\u52a1\uff0c\u671f\u95f4\u53ef\u80fd\u4f1a\u6709\u8270\u96be\u7684\u6218\u6597\uff01)]", DialogueManager.getDialogueFromId("innoxia_places_dominion_sex_shop_factory_meet_fia_start"));
                }
                if (Main.game.getPlayer().hasQuestInLine(QuestLine.SIDE_DOLL_FACTORY, Quest.DOLL_FACTORY_7A)) {
                    if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_DOLL_FACTORY)) {
                        return new Response("\u83f2\u4e9a", "\u83f2\u4e9a\u8fd8\u5728\u7ee7\u7eed\u8eb2\u7740\u4e0d\u518d\u9732\u9762\uff0c\u73b0\u5728\u552f\u4e00\u80fd\u505a\u7684\u53ea\u6709\u7b49\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u91cd\u65b0\u5f00\u5f20\u2026\u2026" + (!Main.game.getDialogueFlags().hasFlag("innoxia_doll_factory_ending_reopen_scene_seen") ? "<br/>[style.italics(\u7b49\u4f60\u53bb\u8fc7\u91cd\u65b0\u5f00\u5f20\u7684\u6d1b\u7ef4\u8036\u7eb3\u5962\u4f88\u54c1\u5e97\u4e4b\u540e\u83f2\u4e9a\u624d\u4f1a\u518d\u6b21\u73b0\u8eab\u3002)]" : ""), null);
                    }
                    if (!Main.game.isHourBetween(19.0f, 0.0f)) {
                        return new Response("\u83f2\u4e9a", "\u83f2\u4e9a\u8fd9\u4e2a\u65f6\u95f4\u4e0d\u5728\u8fd9\u91cc\u2026\u2026<br/><i>\u7b49\u5230[units.time(19)]-[units.time(00)]\u4e4b\u95f4\u518d\u56de\u6765\u627e\u83f2\u4e9a\u3002</i>", null);
                    }
                    if (Main.game.getDialogueFlags().hasFlag("innoxia_fia_bar_seen")) {
                        return new Response("\u5bfb\u627e\u83f2\u4e9a", "\u4f60\u4eca\u665a\u5df2\u7ecf\u89c1\u8fc7\u83f2\u4e9a\u4e86\uff0c\u4e0b\u6b21\u89c1\u9762\u53ea\u80fd\u7b49\u660e\u5929\u4e86\u3002", null);
                    }
                    return new Response("\u83f2\u4e9a", "\u5728\u9644\u8fd1\u7684\u9152\u5427\u5bfb\u627e\u83f2\u4e9a\u3002", DialogueManager.getDialogueFromId("innoxia_places_dominion_demon_home_fia_start"));
                }
                if (Main.game.getPlayer().hasQuestInLine(QuestLine.SIDE_DOLL_FACTORY, Quest.DOLL_FACTORY_7B) && Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_DOLL_FACTORY)) {
                    if (!Main.game.isHourBetween(16.0f, 22.0f)) {
                        return new Response("\u5b89\u5409\u8389\u514b\u4e1d", "\u8fd9\u4e2a\u65f6\u95f4\uff0c\u5b89\u5409\u8389\u514b\u4e1d\u548c\u5979\u7684\u513f\u5b50\u5e94\u8be5\u5728\u5916\u9762\u201c\u5de5\u4f5c\u201d\uff0c\u5982\u679c\u60f3\u89c1\u5230\u4ed6\u4eec\uff0c\u4f60\u5f97\u665a\u70b9\u518d\u6765\u3002<br/><i>\u7b49\u5230[units.time(16)]-[units.time(22)]\u4e4b\u95f4\u518d\u56de\u6765\u4e0e\u5b89\u5409\u8389\u514b\u4e1d\u548c\u5979\u7684\u513f\u5b50\u4eec\u89c1\u9762\u3002</i>", null);
                    }
                    if (Main.game.getDialogueFlags().hasFlag("innoxia_angelixx_apartment_visited")) {
                        return new Response("\u5b89\u5409\u8389\u514b\u4e1d", "\u4f60\u4eca\u665a\u5df2\u7ecf\u8bbf\u95ee\u8fc7\u5b89\u5409\u8389\u514b\u4e1d\u7684\u4f4f\u5904\u4e86\uff0c\u4e0b\u6b21\u89c1\u9762\u53ea\u80fd\u7b49\u660e\u5929\u4e86\u3002", null);
                    }
                    return new Response("\u5b89\u5409\u8389\u514b\u4e1d", "\u53bb\u5b89\u5409\u8389\u514b\u4e1d\u7684\u4f4f\u5904\u62dc\u8bbf\u5979\u548c\u5979\u7684\u513f\u5b50\u4eec\u3002", DialogueManager.getDialogueFromId("innoxia_places_dominion_angelixx_apartment_generic_visit"));
                }
            }
            return null;
        }
    };
    public static final DialogueNode DEMON_HOME_SEX_SHOP_RIOT_CONTINUE = new DialogueNode("", "", false, true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "DEMON_HOME_SEX_SHOP_RIOT_CONTINUE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return DEMON_HOME_SEX_SHOP.getResponse(responseTab, index);
        }
    };

    private static Felicia getFelicia() {
        return (Felicia)Main.game.getNpc(Felicia.class);
    }

    private static String getAdditionalDescriptions() {
        StringBuilder sb = new StringBuilder();
        if (Main.game.getCurrentWeather() == Weather.MAGIC_STORM) {
            sb.append("<p>\u5934\u9876\u4e0a\u8086\u8650\u7684\u5965\u672f\u98ce\u66b4\u8ba9\u8fd9\u7247\u533a\u57df\u51fa\u73b0\u4e86\u5927\u91cf\u7684\u6076\u9b54\u6267\u6cd5\u8005\u3002\u8fd9\u4e9b\u7cbe\u82f1\u6267\u6cd5\u8005\u4e0d\u4f1a\u53d7\u5230\u5965\u672f\u98ce\u66b4\u50ac\u60c5\u4e4b\u529b\u7684\u5f71\u54cd\uff0c\u4ed6\u4eec\u4f1a\u5728\u4f60\u7ecf\u8fc7\u88ab\u79f0\u4e3a\u6076\u9b54\u4e4b\u5bb6\u7684\u8352\u829c\u5730\u533a\u65f6\u5bc6\u5207\u5173\u6ce8\u4f60\u7684\u52a8\u5411\u3002\u5728\u4ed6\u4eec\u7684\u6ce8\u89c6\u4e0b\uff0c\u4efb\u4f55\u4eba\u90fd\u4e0d\u53ef\u80fd\u653b\u51fb\u4f60\uff0c\u8ba9\u4f60\u5b89\u5b89\u9759\u9759\u5730\u7ee7\u7eed\u524d\u884c\u2026\u2026</p>");
        }
        if (Main.game.getDateNow().getMonth() == Month.OCTOBER) {
            sb.append("<p><b style='color:" + PresetColour.BASE_ORANGE.toWebHexString() + ";'>\u5341\u6708;</b><b style='color:" + PresetColour.GENERIC_ARCANE.toWebHexString() + ";'>\u8389\u8389\u4e1d\u6708:</b><br/>\u51e0\u4e4e\u6bcf\u6247\u7a97\u6237\u4e0a\u90fd\u98d8\u626c\u7740\u6a59\u8272\u3001\u9ed1\u8272\u548c\u7d2b\u8272\u7684\u65d7\u5e1c\uff0c\u62ac\u5934\u4e00\u770b\uff0c\u8857\u9053\u4e24\u65c1\u6302\u6ee1\u4e86\u5de8\u5927\u7684\u6a2a\u5e45\uff0c\u6bcf\u6761\u6a2a\u5e45\u4e0a\u90fd\u6709\u4e0d\u540c\u7684\u6807\u8bed\uff0c\u6b4c\u9882\u7740\u8389\u8389\u4e1d\u7684\u7edf\u6cbb\u3002\u5076\u5c14\u770b\u5230\u7684\u6076\u9b54\u901a\u5e38\u90fd\u7a7f\u7740\u4e07\u5723\u8282\u5f0f\u7684\u670d\u88c5\uff0c\u8fd9\u65e0\u52a9\u4e8e\u7f13\u89e3\u9634\u68ee\u6050\u6016\u7684\u6c14\u6c1b\u3002</p>");
        }
        if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.hasSnowedThisWinter) && Main.game.getSeason() == Season.WINTER) {
            sb.append("<p>\u9a6f\u9e7f\u5316\u5f62\u7684\u5de5\u4eba\u4eec\u5f88\u597d\u5730\u4fdd\u6301\u4e86\u5fa1\u57ce\u533a\u8857\u9053\u4e0a\u7684\u6e05\u6d01\uff0c\u4f46\u5c4b\u9876\u3001\u6811\u6728\u548c\u706f\u67f1\u9876\u4e0a\u90fd\u8986\u76d6\u4e86\u4e00\u5c42\u539a\u539a\u7684\u767d\u96ea\u3002\u4f60\u770b\u5230\u81ea\u5df1\u547c\u51fa\u7684\u6c14\u5728\u53e3\u4e2d\u51dd\u7ed3\u6210\u4e00\u5c0f\u56e2\u96fe\u6c14\uff0c\u5c3d\u7ba1\u7a7a\u6c14\u4e2d\u7684\u51b0\u51b7\u6e29\u5ea6\u4e00\u76ee\u4e86\u7136\uff0c\u4f46\u4f60\u7684\u5965\u672f\u7075\u6c14\u5374\u4fdd\u62a4\u7740\u4f60\u7684\u8eab\u4f53\uff0c\u8ba9\u4f60\u611f\u89c9\u4e0d\u5230\u5bd2\u51b7\u3002</p>");
        }
        return sb.toString();
    }
}

