/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.dominion;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.dominion.Callie;
import com.lilithsthrone.game.character.npc.dominion.Cultist;
import com.lilithsthrone.game.character.npc.dominion.Nyan;
import com.lilithsthrone.game.character.npc.dominion.ReindeerOverseer;
import com.lilithsthrone.game.character.npc.dominion.RentalMommy;
import com.lilithsthrone.game.character.npc.submission.Claire;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueManager;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.companions.OccupantDialogue;
import com.lilithsthrone.game.dialogue.encounters.AbstractEncounter;
import com.lilithsthrone.game.dialogue.npcDialogue.dominion.CultistDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.dominion.ReindeerOverseerDialogue;
import com.lilithsthrone.game.dialogue.npcDialogue.dominion.RentalMommyDialogue;
import com.lilithsthrone.game.dialogue.places.dominion.helenaHotel.HelenaHotel;
import com.lilithsthrone.game.dialogue.places.dominion.nyansApartment.NyanDateFinalRepeat;
import com.lilithsthrone.game.dialogue.places.dominion.nyansApartment.NyanFirstDate;
import com.lilithsthrone.game.dialogue.places.dominion.nyansApartment.NyanFirstDoubleDate;
import com.lilithsthrone.game.dialogue.places.dominion.nyansApartment.NyanRepeatDate;
import com.lilithsthrone.game.dialogue.places.submission.BatCaverns;
import com.lilithsthrone.game.dialogue.places.submission.SubmissionGenericPlaces;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseEffectsOnly;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.sex.SexAreaOrifice;
import com.lilithsthrone.game.sex.SexAreaPenetration;
import com.lilithsthrone.game.sex.SexParticipantType;
import com.lilithsthrone.game.sex.SexType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.Vector2i;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.Season;
import com.lilithsthrone.world.Weather;
import com.lilithsthrone.world.WorldRegion;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.DayOfWeek;
import java.time.Month;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DominionPlaces {
    public static final int TRAVEL_TIME_STREET = 120;
    public static final DialogueNode STREET = new DialogueNode("\u5fa1\u57ce\u533a\u8857\u9053", "", false){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "STREET"));
            if (Main.game.getCurrentWeather() != Weather.MAGIC_STORM) {
                sb.append(DominionPlaces.getRandomStreetEvent());
            }
            sb.append(DominionPlaces.getExtraStreetFeatures());
            if (Main.game.getDateNow().getMonth() == Month.OCTOBER) {
                sb.append(UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "STREET_EVENT_OCTOBER"));
            }
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.hasSnowedThisWinter) && Main.game.getSeason() == Season.WINTER) {
                sb.append(UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "STREET_EVENT_SNOW"));
            }
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            List<Response> responses = DominionPlaces.getExtraStreetResponses();
            if (index == 0) {
                return null;
            }
            if (index - 1 < responses.size()) {
                return responses.get(index - 1);
            }
            return null;
        }
    };
    public static final DialogueNode BACK_ALLEYS_SAFE = new DialogueNode("", "", false){

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "BACK_ALLEYS_SAFE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return null;
        }
    };
    public static final DialogueNode BACK_ALLEYS = new DialogueNode("", "", false){

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "BACK_ALLEYS", new ArrayList<GameCharacter>(Main.game.getNonCompanionCharactersPresent())));
            for (GameCharacter gameCharacter : Main.game.getNonCompanionCharactersPresent()) {
                UtilText.nodeContentSB.append(((NPC)gameCharacter).getPresentInTileDescription());
            }
            UtilText.nodeContentSB.append(DominionPlaces.getEnforcersPresent());
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return AbstractEncounter.exploreArea("\u5c0f\u5df7");
            }
            if (index == 2) {
                return AbstractEncounter.useOffspringMap();
            }
            return null;
        }
    };
    public static final DialogueNode DARK_ALLEYS = new DialogueNode("Dark \u5c0f\u5df7", "", false){

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "DARK_ALLEYS", new ArrayList<GameCharacter>(Main.game.getNonCompanionCharactersPresent())));
            for (GameCharacter gameCharacter : Main.game.getNonCompanionCharactersPresent()) {
                UtilText.nodeContentSB.append(((NPC)gameCharacter).getPresentInTileDescription(false));
            }
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return AbstractEncounter.exploreArea("\u5c0f\u5df7");
            }
            if (index == 2) {
                return AbstractEncounter.useOffspringMap();
            }
            return null;
        }
    };
    public static final DialogueNode BACK_ALLEYS_CANAL = new DialogueNode("\u8fd0\u6cb3\u4ea4\u6c47\u5904", "\u3002", false){

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "BACK_ALLEYS_CANAL", new ArrayList<GameCharacter>(Main.game.getNonCompanionCharactersPresent())));
            for (GameCharacter gameCharacter : Main.game.getNonCompanionCharactersPresent()) {
                UtilText.nodeContentSB.append(((NPC)gameCharacter).getPresentInTileDescription());
            }
            UtilText.nodeContentSB.append(DominionPlaces.getEnforcersPresent());
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return AbstractEncounter.exploreArea("\u5c0f\u5df7");
            }
            if (index == 2) {
                return AbstractEncounter.useOffspringMap();
            }
            return null;
        }
    };
    public static final DialogueNode BOULEVARD = new DialogueNode("\u5fa1\u57ce\u533a\u4e3b\u5e72\u9053", "\u3002", false){

        @Override
        public int getSecondsPassed() {
            return 90;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "BOULEVARD"));
            sb.append(DominionPlaces.getExtraStreetFeatures());
            if (Main.game.getDateNow().getMonth() == Month.OCTOBER) {
                sb.append(UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "STREET_EVENT_OCTOBER"));
            }
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.hasSnowedThisWinter) && Main.game.getSeason() == Season.WINTER) {
                sb.append(UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "STREET_EVENT_SNOW"));
            }
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            List<Response> responses = DominionPlaces.getExtraStreetResponses();
            if (index == 0) {
                return null;
            }
            if (index - 1 < responses.size()) {
                return responses.get(index - 1);
            }
            return null;
        }
    };
    private static Set<Integer> viewedNewsIndexes = new HashSet<Integer>();
    private static boolean viewedAllNews = false;
    public static final DialogueNode DOMINION_PLAZA = new DialogueNode("\u8389\u8389\u4e1d\u7684\u5e7f\u573a", "", false){

        @Override
        public void applyPreParsingEffects() {
            viewedNewsIndexes.clear();
            viewedAllNews = false;
        }

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "DOMINION_PLAZA");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getCurrentWeather() == Weather.MAGIC_STORM) {
                    return new Response("\u65b0\u95fb", "\u56e0\u4e3a\u5965\u672f\u98ce\u66b4\u6b63\u5728\u8086\u8650\uff0c\u73b0\u5728\u6ca1\u4eba\u5728\u8fd9\u513f\u2026\u2026", null);
                }
                if (viewedAllNews) {
                    return new Response("\u65b0\u95fb", "\u4f60\u5df2\u7ecf\u5168\u90fd\u542c\u8fc7\u4e86\u2026\u2026", null);
                }
                return new Response("\u65b0\u95fb", "\u51b3\u5b9a\u5728\u6b64\u9017\u7559\u7247\u523b\uff0c\u8046\u542c\u4e00\u4f4d\u6f14\u8bf4\u8005\u2026\u2026", DOMINION_PLAZA_NEWS){

                    @Override
                    public void effects() {
                        Main.game.getTextEndStringBuilder().append("<p>" + DominionPlaces.getRandomNewsText() + "</p>");
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode DOMINION_PLAZA_NEWS = new DialogueNode("\u8389\u8389\u4e1d\u7684\u5e7f\u573a", "\u3002", false, true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append("<p>\u4f60\u51b3\u5b9a\u7559\u4e0b\u6765\u8046\u542c\u4f17\u591a\u6b63\u5411\u4eba\u7fa4\u53d1\u8868\u6f14\u8bf4\u7684\u6f14\u8bf4\u8005\u4e2d\u7684\u4e00\u4f4d\u2026\u2026</p>");
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return DOMINION_PLAZA.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode HELENAS_HOTEL = new DialogueNode("", "", false){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(STREET.getContent());
            sb.append(UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "STREET_SHADED"));
            sb.append(UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "HELENAS_HOTEL"));
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            List<Response> responses = DominionPlaces.getExtraStreetResponses();
            if (index == 0) {
                return null;
            }
            if (index == 1) {
                return new Response("\u6d77\u4f26\u5a1c\u7684\u5de2", "\u4f7f\u7528\u65c5\u9986\u7535\u68af\uff0c\u76f4\u8fbe\u6d77\u4f26\u5a1c\u7684\u5de2\u3002", HelenaHotel.HOTEL_TRAVEL_TO_NEST){

                    @Override
                    public void effects() {
                        Main.game.getPlayer().setLocation(WorldType.HARPY_NEST, PlaceType.HARPY_NESTS_HELENAS_NEST);
                    }
                };
            }
            if (index - 2 < responses.size()) {
                return responses.get(index - 2);
            }
            return null;
        }
    };
    public static final DialogueNode STREET_SHADED = new DialogueNode("\u5fa1\u57ce\u533a\u8857\u9053(\u9634\u6697)", "\u3002", false){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(STREET.getContent());
            sb.append(UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "STREET_SHADED"));
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            List<Response> responses = DominionPlaces.getExtraStreetResponses();
            if (index != 0 && index - 1 < responses.size()) {
                return responses.get(index - 1);
            }
            return null;
        }
    };
    public static final DialogueNode CANAL = new DialogueNode("\u5fa1\u57ce\u533a\u8fd0\u6cb3", "\u3002", false){

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "CANAL", new ArrayList<GameCharacter>(Main.game.getNonCompanionCharactersPresent())));
            for (GameCharacter gameCharacter : Main.game.getNonCompanionCharactersPresent()) {
                UtilText.nodeContentSB.append(((NPC)gameCharacter).getPresentInTileDescription());
            }
            UtilText.nodeContentSB.append(DominionPlaces.getEnforcersPresent());
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return AbstractEncounter.exploreArea("\u8fd0\u6cb3");
            }
            if (index == 2) {
                return AbstractEncounter.useOffspringMap();
            }
            return null;
        }
    };
    public static final DialogueNode CANAL_END = new DialogueNode("\u5fa1\u57ce\u533a\u8fd0\u6cb3", "\u3002", false){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "CANAL", new ArrayList<GameCharacter>(Main.game.getNonCompanionCharactersPresent())));
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "CANAL_END", new ArrayList<GameCharacter>(Main.game.getNonCompanionCharactersPresent())));
            for (GameCharacter gameCharacter : Main.game.getNonCompanionCharactersPresent()) {
                UtilText.nodeContentSB.append(((NPC)gameCharacter).getPresentInTileDescription());
            }
            UtilText.nodeContentSB.append(DominionPlaces.getEnforcersPresent());
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return AbstractEncounter.exploreArea("\u8fd0\u6cb3");
            }
            if (index == 2) {
                return AbstractEncounter.useOffspringMap();
            }
            return null;
        }
    };
    public static final DialogueNode CITY_EXIT_SEWERS = new DialogueNode("\u5c48\u57ce\u533a\u5165\u53e3", "\u8fdb\u5165\u5c48\u57ce\u533a\u5730\u4e0b\u57ce\u3002", false){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "CITY_EXIT_SEWERS");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u5c48\u57ce\u533a", "\u8fdb\u5165\u5c48\u57ce\u533a\u4e0b\u57ce\u3002", CITY_EXIT_SEWERS_ENTERING_SUBMISSION){

                    @Override
                    public void effects() {
                        if (!Main.game.getPlayer().hasQuest(QuestLine.SIDE_SLIME_QUEEN)) {
                            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.visitedSubmission, false);
                        }
                        Main.game.getPlayer().setLocation(WorldType.SUBMISSION, PlaceType.SUBMISSION_ENTRANCE, false);
                        Main.game.getNpc(Claire.class).setLocation(Main.game.getPlayer().getWorldLocation(), Main.game.getPlayer().getLocation(), true);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode CITY_EXIT_SEWERS_ENTERING_SUBMISSION = new DialogueNode("\u6267\u6cd5\u8005\u68c0\u67e5\u70b9", "\u8fdb\u5165\u5c48\u57ce\u533a\u5730\u4e0b\u57ce\u3002", false){

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public boolean isTravelDisabled() {
            return !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.visitedSubmission);
        }

        @Override
        public String getContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "ENTER_SUBMISSION"));
            if (!Main.game.getPlayer().hasQuest(QuestLine.SIDE_SLIME_QUEEN)) {
                Main.game.getTextEndStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "ENTER_SUBMISSION_FIRST_TIME"));
            } else {
                Main.game.getTextEndStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "ENTER_SUBMISSION_REPEAT"));
            }
            return sb.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.visitedSubmission)) {
                if (index == 1) {
                    return new Response("\u80af\u5b9a", "\u5411\u732b\u5973\u80af\u5b9a\u8fd9\u786e\u5b9e\u662f\u4f60\u7b2c\u4e00\u6b21\u6765\u5c48\u57ce\u533a\u3002", CITY_EXIT_SEWERS_ENTERING_SUBMISSION_FIRST_TIME){

                        @Override
                        public void effects() {
                            Main.game.getNpc(Claire.class).setPlayerKnowsName(true);
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().startQuest(QuestLine.SIDE_SLIME_QUEEN));
                        }
                    };
                }
                return null;
            }
            return SubmissionGenericPlaces.SEWER_ENTRANCE.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode CITY_EXIT_SEWERS_ENTERING_SUBMISSION_FIRST_TIME = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 180;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "ENTER_SUBMISSION_FIRST_TIME_CONFIRMATION");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u7ee7\u7eed\u7a7f\u8fc7\u6267\u6cd5\u8005\u5c97\u54e8\u3002", Main.game.getDefaultDialogue(false)){

                    @Override
                    public void effects() {
                        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.visitedSubmission, true);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode CITY_EXIT_BAT_CAVERNS = new DialogueNode("", "", false){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "CITY_EXIT_BAT_CAVERNS");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getPlayer().isAbleToFly()) {
                    if (!Main.game.getPlayer().isPartyAbleToFly()) {
                        return new Response("\u8759\u8760\u6d1e\u7a9f", "\u7531\u4e8e\u4f60\u7684\u961f\u4f0d\u6210\u5458\u65e0\u6cd5\u98de\u884c\uff0c\u6240\u4ee5\u4e0d\u80fd\u4f7f\u7528\u8fd9\u53e3\u7ad6\u4e95\u8fdb\u5165\u8759\u8760\u6d1e\u7a9f\u2026\u2026", null);
                    }
                    return new Response("\u8759\u8760\u6d1e\u7a9f", "\u4ece\u7ad6\u4e95\u98de\u8fdb\u8759\u8760\u6d1e\u7a9f\u3002", CITY_EXIT_BAT_CAVERNS_FLY_DOWN){

                        @Override
                        public void effects() {
                            Main.game.getPlayer().setLocation(WorldType.BAT_CAVERNS, PlaceType.BAT_CAVERN_SHAFT, false);
                        }
                    };
                }
                return new Response("Bat Caverns", "\u7531\u4e8e\u4f60\u65e0\u6cd5\u98de\u884c\uff0c\u6240\u4ee5\u4e0d\u80fd\u4f7f\u7528\u8fd9\u53e3\u7ad6\u4e95\u8fdb\u5165\u8759\u8760\u6d1e\u7a9f\u2026\u2026", null);
            }
            return null;
        }
    };
    public static final DialogueNode CITY_EXIT_BAT_CAVERNS_FLY_DOWN = new DialogueNode("", "", false){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/dominionPlaces", "CITY_EXIT_BAT_CAVERNS_FLY_DOWN");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return BatCaverns.SHAFT.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode CITY_EXIT = new DialogueNode("\u5fa1\u57ce\u533a\u51fa\u53e3", "", false){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            if (Main.game.getPlayer().isDiscoveredWorldMap()) {
                return "<p>\u4e00\u5bf9\u7cbe\u82f1\u6076\u9b54\u6267\u6cd5\u8005\u6b63\u5728\u8fd9\u91cc\u5bc6\u5207\u5730\u76d1\u89c6\u7740\u8fdb\u51fa\u57ce\u5e02\u7684\u6240\u6709\u4eba\u3002\u73b0\u5728\u4f60\u6709\u4e86\u5730\u56fe\uff0c\u5fa1\u57ce\u533a\u7684\u4efb\u52a1\u4e5f\u7ed3\u675f\u4e86\uff0c\u6ca1\u4ec0\u4e48\u80fd\u963b\u6b62\u4f60\u51fa\u53bb\u65c5\u884c\u4e86\u3002</p>";
            }
            return "<p>\u4e00\u5bf9\u7cbe\u82f1\u6076\u9b54\u6267\u6cd5\u8005\u6b63\u5728\u8fd9\u91cc\u5bc6\u5207\u5730\u76d1\u89c6\u7740\u8fdb\u51fa\u57ce\u5e02\u7684\u6240\u6709\u4eba\u3002\u867d\u7136\u6ca1\u6709\u4ec0\u4e48\u53ef\u4ee5\u963b\u6b62\u4f60\u53bb\u5916\u9762\u7684\u4e16\u754c\uff0c\u4f46\u4f60\u73b0\u5728\u6ca1\u7406\u7531\u79bb\u5f00\u5fa1\u57ce\u533a\uff0c\u800c\u4e14\u4f60\u6ca1\u6709\u5730\u56fe\uff0c\u5f88\u5bb9\u6613\u8ff7\u8def\u3002</p><p>\u4f60\u5728\u5bfb\u627e\u8fd4\u56de\u65e7\u4e16\u754c\u7684\u65b9\u6cd5\uff0c\u6beb\u65e0\u7591\u95ee\uff0c\u8fd9\u6700\u7ec8\u4f1a\u628a\u4f60\u5f15\u5411\u5fa1\u57ce\u533a\u4e4b\u5916\u3002\u4f46\u6682\u65f6\uff0c\u4f60\u5728\u8fd9\u5ea7\u57ce\u5e02\u91cc\u8fd8\u6709\u4efb\u52a1\u8981\u5b8c\u6210\u3002</p>";
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getPlayer().isDiscoveredWorldMap()) {
                    return new ResponseEffectsOnly("\u4e16\u754c\u65c5\u884c", "\u9000\u51fa\u5fa1\u57ce\u533a\uff0c\u5411\u7740\u66f4\u5e7f\u9614\u7684\u5929\u5730\u884c\u8fdb\u2026\u2026"){

                        @Override
                        public void effects() {
                            Main.game.getPlayer().setLocation(WorldType.WORLD_MAP, Main.game.getPlayer().getGlobalLocation(), false);
                            Main.game.setContent(new Response("", "", Main.game.getDefaultDialogue(false)));
                        }
                    };
                }
                return new Response("\u4e16\u754c\u65c5\u884c", "\u4f60\u5c1a\u672a\u77e5\u6653\u4e16\u754c\u7684\u5168\u8c8c\uff0c\u5e76\u4e14\u6682\u65f6\uff0c\u5728\u8fd9\u4e2a\u57ce\u5e02\u91cc\u8fd8\u6709\u4e8b\u8981\u505a\u3002", null);
            }
            return null;
        }
    };

    public static boolean isCloseToEnforcerHQ() {
        return Vector2i.getDistance(Main.game.getPlayerCell().getLocation(), Main.game.getWorlds().get(WorldType.DOMINION).getCell(PlaceType.DOMINION_ENFORCER_HQ).getLocation()) < 4.0f;
    }

    private static String getExtraStreetFeatures() {
        StringBuilder mommySB = new StringBuilder();
        StringBuilder occupantSB = new StringBuilder();
        StringBuilder cultistSB = new StringBuilder();
        StringBuilder reindeerSB = new StringBuilder();
        HashSet<NPC> characters = new HashSet<NPC>(Main.game.getNonCompanionCharactersPresent());
        characters.addAll(Main.game.getCharactersTreatingCellAsHome(Main.game.getPlayerCell()));
        if (Main.game.getPlayerCell().getPlace().getPlaceType() == PlaceType.DOMINION_NYAN_APARTMENT) {
            mommySB.append("<p>[style.boldPinkLight(\u59ae\u5b89\u7684\u516c\u5bd3\uff1a)]<br/>" + (Main.game.getNpc(Nyan.class).getWorldLocation() == WorldType.NYANS_APARTMENT ? "\u59ae\u5b89\u5c31\u4f4f\u5728\u8fd9\u7247\u533a\u57df\uff0c\u5982\u679c\u4f60\u60f3\u7684\u8bdd\uff0c\u53ef\u4ee5\u53bb\u5979\u7684\u516c\u5bd3\u62dc\u8bbf\u5979\u2026\u2026" : "\u59ae\u5b89\u5c31\u4f4f\u5728\u8fd9\u7247\u533a\u57df\uff0c\u4e0d\u8fc7\u4f60\u77e5\u9053\u5979\u8fd9\u4e2a\u65f6\u5019\u5728\u5de5\u4f5c\uff0c\u6240\u4ee5\u6ca1\u5fc5\u8981\u53bb\u5979\u7684\u516c\u5bd3\u697c\u2026\u2026") + "</p>");
        }
        if (Main.game.getPlayerCell().getPlace().getPlaceType() == PlaceType.DOMINION_CALLIE_BAKERY) {
            mommySB.append("<p>[style.boldBrown(\u5976\u6cb9\u70d8\u7119\u5e97\uff1a)]</p>");
            mommySB.append(UtilText.parseFromXMLFile("nnxx/callie_bakery", "EXTERIOR"));
        }
        for (NPC npc : characters) {
            if (npc instanceof RentalMommy) {
                mommySB.append(UtilText.parse((GameCharacter)npc, "<p><b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u201c\u5988\u54aa\u201d\u7684\u5bb6\uff1a</b><br/>" + (Main.game.getCurrentWeather() == Weather.MAGIC_STORM ? "\u201c\u5988\u54aa\u201d\u7684\u623f\u5b50\u5c31\u5728\u8fd9\u6761\u8857\u4e0a\uff0c\u4f46\u7531\u4e8e\u6b63\u5728\u8086\u8650\u7684\u5965\u672f\u98ce\u66b4\uff0c\u5979\u7ecf\u5e38\u5750\u7684\u90a3\u6761\u957f\u51f3\u73b0\u5728\u7a7a\u65e0\u4e00\u4eba\u3002\u5982\u679c\u4f60\u60f3\u548c\u5979\u4e92\u52a8\uff0c\u6700\u597d\u7b49\u98ce\u66b4\u8fc7\u53bb\u540e\u518d\u56de\u6765\u2026\u2026" : "\u5988\u54aa\u7684\u623f\u5b50\u5c31\u5728\u8fd9\u6761\u8857\u7684\u5c3d\u5934\uff0c\u5f53\u4f60\u671b\u5411\u623f\u5b50\u65f6\uff0c\u4f60\u80fd\u770b\u5230\u5979\u5750\u5728\u5916\u9762\u5979\u5e38\u5750\u7684\u90a3\u6761\u957f\u51f3\u4e0a\u3002\u5979\u4ecd\u7136\u7a7f\u7740\u201c\u79df\u8d41\u5988\u54aa\u201dT\u6064\u886b\uff0c\u663e\u7136\u662f\u5982\u5e38\u5f00\u5f20\u4e86\u2026\u2026") + "</p>", new ParserTag[0]));
                break;
            }
            if (Main.game.getPlayer().getFriendlyOccupants().contains(npc.getId())) {
                occupantSB.append("<p>");
                occupantSB.append(UtilText.parse((GameCharacter)npc, "<b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>[npc.NamePos]\u7684\u516c\u5bd3\uff1a</b><br/>[npc.name]\u4ece\u8389\u83b1\u96c5\u5bb6\u642c\u51fa\u53bb\u540e\uff0c\u6700\u7ec8\u4f4f\u8fdb\u4e86\u8fd9\u9644\u8fd1\u7684\u4e00\u680b\u516c\u5bd3\u3002", new ParserTag[0]));
                if (npc.isAsleep()) {
                    occupantSB.append(UtilText.parse((GameCharacter)npc, "\u4f60\u5982\u679c\u60f3\u7684\u8bdd\uff0c\u5c31\u53ef\u4ee5\u53bb\u770b\u671b[npc.race]\u3002\u4f46\u56e0\u4e3a[npc.sheIs]\u76ee\u524d[style.colourSleep(\u5728\u7761\u89c9)]\uff0c\u4f60\u5f97\u53eb\u9192[npc.herHim]\u2026\u2026", new ParserTag[0]));
                } else {
                    occupantSB.append(UtilText.parse((GameCharacter)npc, "\u4f60\u5982\u679c\u60f3\u7684\u8bdd\uff0c\u5c31\u53ef\u4ee5\u53bb\u770b\u671b[npc.race]\u2026\u2026", new ParserTag[0]));
                }
                occupantSB.append("<br/>");
                occupantSB.append(UtilText.parse((GameCharacter)npc, "<i>[npc.Name]\u5728[style.time(" + npc.getSleepStartHour() + ")]-[style.time(" + npc.getSleepEndHour() + ")]\u4e4b\u95f4\u7761\u89c9</i>", new ParserTag[0]));
                occupantSB.append("</p>");
                break;
            }
            if (npc instanceof Cultist) {
                cultistSB.append("<p><b style='color:" + PresetColour.GENERIC_ARCANE.toWebHexString() + ";'>\u72c2\u4fe1\u8005\u7684\u5c0f\u793c\u62dc\u5802\uff1a</b><br/>" + UtilText.parse((GameCharacter)npc, "\u4f60\u8bb0\u5f97[npc.namePos]\u5730\u5c0f\u6559\u5802\u5c31\u5728\u9644\u8fd1\uff0c\u5982\u679c\u4f60\u613f\u610f\uff0c\u53ef\u4ee5\u5f88\u5bb9\u6613\u5730\u518d\u6b21\u627e\u5230\u5b83\u2026\u2026", new ParserTag[0]) + "</p>");
                break;
            }
            if (!(npc instanceof ReindeerOverseer)) continue;
            reindeerSB.append("<p><b style='color:" + PresetColour.RACE_REINDEER_MORPH.toWebHexString() + ";'>\u9a6f\u9e7f\u76d1\u5de5:</b><br/>" + (Main.game.getCurrentWeather() == Weather.MAGIC_STORM ? UtilText.parse((GameCharacter)npc, "\u8fd9\u4e9b\u9a6f\u9e7f\u5316\u5f62\u6b63\u5728\u8eb2\u907f\u903c\u8fd1\u7684\u5965\u672f\u98ce\u66b4\u3002\u5982\u679c\u60f3\u8ddf\u76d1\u5de5\u5bf9\u8bdd\uff0c\u6700\u597d\u7b49\u5230\u98ce\u66b4\u8fc7\u53bb\u3002", new ParserTag[0]) : UtilText.parse((GameCharacter)npc, "\u4e00\u5927\u7fa4\u9a6f\u9e7f\u5316\u5f62\uff0c\u6b63\u5728\u52aa\u529b\u9664\u96ea\u3002\u9886\u5934\u7684[npc.a_race]\uff0c\u6b63\u5728\u5927\u558a\u7740\u547d\u4ee4\uff0c\u5728\u5de5\u4eba\u4e2d\u95f4\u6765\u56de\u7a7f\u68ad\uff0c\u786e\u4fdd\u5de5\u4f5c\u6210\u679c\u80fd\u8ba9[npc.her]\u6ee1\u610f\u3002\u5c3d\u7ba1\u8fd9\u4e9b\u5de5\u4eba\u5fd9\u5230\u6ca1\u529f\u592b\u505c\u4e0b\u6765\u8bf4\u8bdd\uff0c\u4f46\u5982\u679c\u60f3\u7684\u8bdd\uff0c\u4f60\u8fd8\u662f\u53ef\u4ee5\u8ddf\u76d1\u5de5\u804a\u4e0a\u51e0\u53e5\u3002", new ParserTag[0])) + "</p>");
            break;
        }
        mommySB.append(cultistSB.toString()).append(occupantSB.toString()).append(reindeerSB.toString());
        AbstractClothing collar = Main.game.getPlayer().getClothingInSlot(InventorySlot.NECK);
        if (collar != null && collar.getClothingType().getId().equals("innoxia_neck_filly_choker")) {
            mommySB.append("<p>");
            mommySB.append("[style.boldPinkLight([style.Mule]\u9879\u5708\uff1a)]<br/>");
            mommySB.append("\u4f60\u6234\u7740[style.mule]\u9879\u5708\uff0c\u76f8\u5f53\u4e8e\u5bf9\u5fa1\u57ce\u901f\u9012\u7684\u534a\u4eba\u9a6c\u5974\u96b6\u4f20\u8fbe\u7740\u4e00\u4e2a\u4fe1\u606f\uff0c\u4f60\u53ef\u4ee5\u4e3a\u4ed6\u4eec\u63d0\u4f9b\u6027\u670d\u52a1\u3002");
            if (Main.game.getCurrentWeather() == Weather.MAGIC_STORM) {
                mommySB.append("\u7136\u800c\u7531\u4e8e\u5965\u672f\u98ce\u66b4\u5c06\u81f3\uff0c\u4f60[style.colourMinorBad(\u6ca1\u6709\u53ef\u80fd)]\u9047\u89c1\u534a\u4eba\u9a6c\u2026\u2026");
            } else if (!Main.game.isExtendedWorkTime()) {
                mommySB.append("\u7136\u800c\u7531\u4e8e\u73b0\u5728\u4e0d\u662f\u5de5\u4f5c\u65f6\u95f4\uff0c\u4f60[style.colourMinorBad(\u6ca1\u6709\u53ef\u80fd)]\u9047\u89c1\u534a\u4eba\u9a6c\u2026\u2026");
            } else if (!Main.game.getPlayer().isAbleToAccessCoverableArea(CoverableArea.MOUTH, true)) {
                mommySB.append("\u7136\u800c\u7531\u4e8e\u4f60\u65e0\u6cd5\u4f7f\u7528\u81ea\u5df1\u7684\u5634\u5df4\uff0c\u4ed6\u4eec[style.colourMinorBad(\u6ca1\u6709\u53ef\u80fd)]\u5411\u4f60\u8d70\u6765\u2026\u2026");
            } else {
                mommySB.append("\u5c3d\u7ba1\u5fa1\u57ce\u533a\u5341\u5206\u5e7f\u88a4\uff0c\u4f46\u5fa1\u57ce\u901f\u9012\u7684\u534a\u4eba\u9a6c\u5974\u96b6\u4e5f\u4eba\u6570\u4f17\u591a\uff0c\u8fd9\u5c31\u610f\u5473\u7740\u4f60[style.colourMinorGood(\u6709\u4e00\u70b9\u53ef\u80fd)]\u9047\u89c1\u5176\u4e2d\u4e00\u4e2a\u2026\u2026");
            }
            mommySB.append("</p>");
        }
        return mommySB.toString();
    }

    private static List<Response> getExtraStreetResponses() {
        ArrayList<Response> mommyResponses = new ArrayList<Response>();
        ArrayList<3> occupantResponses = new ArrayList<3>();
        ArrayList<4> cultistResponses = new ArrayList<4>();
        ArrayList<Response> reindeerResponses = new ArrayList<Response>();
        HashSet<NPC> characters = new HashSet<NPC>(Main.game.getNonCompanionCharactersPresent());
        characters.addAll(Main.game.getCharactersTreatingCellAsHome(Main.game.getPlayerCell()));
        if (Main.game.getPlayerCell().getPlace().getPlaceType() == PlaceType.DOMINION_NYAN_APARTMENT) {
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanmumDateCompleted)) {
                // empty if block
            }
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanmumInterviewPassed) && (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanmumDateCompleted) || Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanmumGirlfriend))) {
                dateCost = 4000;
                if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanWeekendDated)) {
                    if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanmumDateCompleted)) {
                        mommyResponses.add(new Response("\u53cc\u4eba\u7ea6\u4f1a (" + UtilText.formatAsMoneyUncoloured(dateCost, "span") + ")", "\u4f60\u8fd9\u4e2a\u5468\u672b\u5df2\u7ecf\u5e26\u59ae\u5b89\u51fa\u53bb\u7ea6\u4f1a\u8fc7\u4e86\u3002\u4f60\u9700\u8981\u7b49\u5230\u4e0b\u5468\u672b\u624d\u80fd\u5e26\u5979\u548c[nyanmum.name]\u51fa\u53bb\u53cc\u91cd\u7ea6\u4f1a\u2026\u2026", null));
                    } else {
                        mommyResponses.add(new Response("\u53cc\u4eba\u7ea6\u4f1a (" + UtilText.formatAsMoneyUncoloured(dateCost, "span") + ")", "\u4f60\u8fd9\u4e2a\u5468\u672b\u5df2\u7ecf\u5e26\u59ae\u5b89\u548c[nyanmum.name]\u51fa\u53bb\u7ea6\u4f1a\u8fc7\u4e86\u3002\u4f60\u9700\u8981\u7b49\u5230\u4e0b\u5468\u672b\u2026\u2026", null));
                    }
                } else if ((Main.game.getDayOfWeek() == DayOfWeek.FRIDAY || Main.game.getDayOfWeek() == DayOfWeek.SATURDAY) && Main.game.isHourBetween(20.0f, 23.0f)) {
                    if (Main.game.getNpc(Nyan.class).getWorldLocation() != WorldType.NYANS_APARTMENT) {
                        mommyResponses.add(new Response("\u53cc\u4eba\u7ea6\u4f1a (" + UtilText.formatAsMoneyUncoloured(dateCost, "span") + ")", "\u59ae\u5b89\u548c[nyanmum.name]\u73b0\u5728\u4e0d\u5728\u5bb6\u3002\u4f60\u9700\u8981\u7b49\u5de5\u4f5c\u65e5\u7ed3\u675f\u518d\u6765\u2026\u2026", null));
                    } else if (Main.game.getPlayer().getMoney() < (long)dateCost) {
                        mommyResponses.add(new Response("\u53cc\u4eba\u7ea6\u4f1a (" + UtilText.formatAsMoneyUncoloured(dateCost, "span") + ")", "\u201c\u6a61\u6728\u6797\u836b\u201d\u770b\u8d77\u6765\u662f\u4e2a\u9ad8\u6d88\u8d39\u7684\u7ea6\u4f1a\u5730\u70b9\u3002\u4f60\u60f3\u548c\u59ae\u5b89\u8fd8\u6709[nyanmum.name]\u5728\u8fd9\u7ea6\u4f1a\uff0c\u81f3\u5c11\u8981\u6709" + Util.intToString(dateCost) + "\u706b\u5e01\u3002", null));
                    } else if (!Main.game.getPlayer().isAbleToAccessCoverableArea(CoverableArea.MOUTH, true)) {
                        mommyResponses.add(new Response("\u53cc\u4eba\u7ea6\u4f1a (" + UtilText.formatAsMoneyUncoloured(dateCost, "span") + ")", "\u4f60\u5403\u4e0d\u4e86\u4e1c\u897f\uff0c\u6240\u4ee5\u4e0d\u80fd\u53bb\u9910\u5385\u7ea6\u4f1a\uff01<br/>[style.italicsMinorBad(\u4f60\u9700\u8981\u80fd\u591f\u4f7f\u7528\u81ea\u5df1\u7684\u5634\u5df4\uff0c\u624d\u80fd\u5e26\u59ae\u5b89\u548c[nyanmum.name]\u51fa\u53bb\u7ea6\u4f1a\u2026\u2026)]", null));
                    } else {
                        mommyResponses.add(new Response("\u53cc\u4eba\u7ea6\u4f1a (" + UtilText.formatAsMoney(dateCost, "span") + ")", "\u53bb\u516c\u5bd3\u63a5\u59ae\u5b89\u548c[nyanmum.name]\uff0c\u7136\u540e\u4e00\u8d77\u53bb\u201c\u6a61\u6728\u6797\u836b\u201d\u9910\u5385\u7ea6\u4f1a\u3002", Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanmumGirlfriend) ? NyanDateFinalRepeat.DOUBLE_DATE_START : NyanFirstDoubleDate.DATE_START));
                    }
                } else {
                    mommyResponses.add(new Response("\u53cc\u4eba\u7ea6\u4f1a (" + UtilText.formatAsMoneyUncoloured(dateCost, "span") + ")", "\u4f60\u73b0\u5728\u4e0d\u80fd\u5e26\u59ae\u5b89\u548c[nyanmum.name]\u51fa\u53bb\u7ea6\u4f1a\u2026\u2026<br/><i>\u4f60\u9700\u8981\u5728" + (Main.game.getDayOfWeek() == DayOfWeek.FRIDAY ? "[style.italicsMinorGood(\u661f\u671f\u4e94)]" : "[style.italicsMinorBad(\u661f\u671f\u4e94)]") + "\u6216" + (Main.game.getDayOfWeek() == DayOfWeek.SATURDAY ? "[style.italicsMinorGood(\u661f\u671f\u516d)]" : "[style.italicsMinorBad(\u661f\u671f\u516d)]") + "\uff0c\u800c\u4e14\u5728" + (Main.game.isHourBetween(20.0f, 23.0f) ? "[style.italicsMinorGood([unit.time(20)]-[unit.time(23)])]" : "[style.italicsMinorBad([unit.time(20)]-[unit.time(23)])]") + "\u624d\u80fd\u5e26\u59ae\u5b89\u548c[nyanmum.name]\u51fa\u53bb\u7ea6\u4f1a\uff01", null));
                }
            } else {
                dateCost = 2500;
                if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanWeekendDated)) {
                    mommyResponses.add(new Response("\u8ddf\u59ae\u5b89\u7ea6\u4f1a (" + UtilText.formatAsMoneyUncoloured(dateCost, "span") + ")", "\u4f60\u8fd9\u4e2a\u5468\u672b\u5df2\u7ecf\u5e26\u59ae\u5b89\u51fa\u53bb\u7ea6\u4f1a\u8fc7\u4e86\u3002\u4f60\u9700\u8981\u7b49\u5230\u4e0b\u5468\u672b\u2026\u2026", null));
                } else if ((Main.game.getDayOfWeek() == DayOfWeek.FRIDAY || Main.game.getDayOfWeek() == DayOfWeek.SATURDAY) && Main.game.getHourOfDay() >= 18 && Main.game.getHourOfDay() < 23) {
                    if (Main.game.getNpc(Nyan.class).getWorldLocation() != WorldType.NYANS_APARTMENT) {
                        mommyResponses.add(new Response("\u8ddf\u59ae\u5b89\u7ea6\u4f1a (" + UtilText.formatAsMoneyUncoloured(dateCost, "span") + ")", "\u59ae\u5b89\u73b0\u5728\u5728\u5de5\u4f5c\u3002\u4f60\u9700\u8981\u7b49\u5de5\u4f5c\u65e5\u7ed3\u675f\u518d\u6765\u2026\u2026", null));
                    } else if (Main.game.getPlayer().getMoney() < (long)dateCost) {
                        mommyResponses.add(new Response("\u8ddf\u59ae\u5b89\u7ea6\u4f1a (" + UtilText.formatAsMoneyUncoloured(dateCost, "span") + ")", "\u201c\u6a61\u6728\u6797\u836b\u201d\u770b\u8d77\u6765\u662f\u4e2a\u9ad8\u6d88\u8d39\u7684\u7ea6\u4f1a\u5730\u70b9\u3002\u4f60\u60f3\u548c\u59ae\u5b89\u5728\u8fd9\u7ea6\u4f1a\uff0c\u81f3\u5c11\u8981\u6709" + Util.intToString(dateCost) + "\u706b\u5e01\u3002", null));
                    } else if (!Main.game.getPlayer().isAbleToAccessCoverableArea(CoverableArea.MOUTH, true)) {
                        mommyResponses.add(new Response("\u8ddf\u59ae\u5b89\u7ea6\u4f1a (" + UtilText.formatAsMoneyUncoloured(dateCost, "span") + ")", "\u4f60\u5403\u4e0d\u4e86\u4e1c\u897f\uff0c\u6240\u4ee5\u4e0d\u80fd\u53bb\u9910\u5385\u7ea6\u4f1a\uff01<br/>[style.italicsMinorBad(\u4f60\u9700\u8981\u80fd\u591f\u4f7f\u7528\u81ea\u5df1\u7684\u5634\u5df4\uff0c\u624d\u80fd\u5e26\u59ae\u5b89\u51fa\u53bb\u7ea6\u4f1a\u2026\u2026)]", null));
                    } else {
                        mommyResponses.add(new Response("\u8ddf\u59ae\u5b89\u7ea6\u4f1a (" + UtilText.formatAsMoney(dateCost, "span") + ")", "\u53bb\u59ae\u5b89\u7684\u516c\u5bd3\u63a5\u5979\uff0c\u7136\u540e\u4e00\u8d77\u53bb\u201c\u6a61\u6728\u6797\u836b\u201d\u9910\u5385\u7ea6\u4f1a\u3002", Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanmumDateCompleted) ? NyanDateFinalRepeat.SOLO_DATE_START : (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanRestaurantDateCompleted) && !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanmumInterviewPassed) ? NyanRepeatDate.DATE_START : NyanFirstDate.DATE_START)));
                    }
                } else {
                    mommyResponses.add(new Response("\u8ddf\u59ae\u5b89\u7ea6\u4f1a (" + UtilText.formatAsMoneyUncoloured(dateCost, "span") + ")", "\u4f60\u73b0\u5728\u8fd8\u4e0d\u80fd\u5e26\u59ae\u5b89\u53bb\u7ea6\u4f1a\u2026\u2026<br/><i>\u4f60\u9700\u8981\u5728" + (Main.game.getDayOfWeek() == DayOfWeek.FRIDAY ? "[style.italicsMinorGood(\u661f\u671f\u4e94)]" : "[style.italicsMinorBad(\u661f\u671f\u4e94)]") + "\u6216" + (Main.game.getDayOfWeek() == DayOfWeek.SATURDAY ? "[style.italicsMinorGood(\u661f\u671f\u516d)]" : "[style.italicsMinorBad(\u661f\u671f\u516d)]") + "\uff0c\u800c\u4e14\u5728" + (Main.game.getHourOfDay() >= 18 && Main.game.getHourOfDay() < 23 ? "[style.italicsMinorGood([unit.time(18)]-[unit.time(23)])]" : "[style.italicsMinorBad([unit.time(18)]-[unit.time(23)])]") + "\u624d\u80fd\u5e26\u59ae\u5b89\u51fa\u53bb\u7ea6\u4f1a\uff01", null));
                }
            }
        }
        if (Main.game.getPlayerCell().getPlace().getPlaceType() == PlaceType.DOMINION_CALLIE_BAKERY) {
            int hourClose;
            int hourOpen = Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.getDialogueFlagValueFromId("nnxx_callie_upgrade_2")) ? 7 : 9;
            int n = hourClose = Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.getDialogueFlagValueFromId("nnxx_callie_upgrade_2")) ? 17 : 15;
            if (Main.game.isHourBetween(hourOpen, hourClose) && Main.game.getDayOfWeek() != DayOfWeek.SUNDAY) {
                DialogueNode initNode = DialogueManager.getDialogueFromId("nnxx_callie_bakery_entry_first_time");
                if (Main.game.getDialogueFlags().hasFlag("nnxx_callie_introduced")) {
                    AbstractClothing playerNeckClothing = Main.game.getPlayer().getClothingInSlot(InventorySlot.NECK);
                    initNode = Main.game.getDialogueFlags().hasFlag("nnxx_callie_upgrade_3") && !Main.game.getDialogueFlags().hasFlag("nnxx_callie_upgrade_reaction_pending") && Main.game.getPlayer().getSexCount(Main.game.getNpc(Callie.class), new SexType(SexParticipantType.NORMAL, SexAreaPenetration.TONGUE, SexAreaOrifice.ANUS)) > 0 && Main.game.getNpc(Callie.class).isAttractedTo(Main.game.getPlayer()) && Main.game.getPlayer().isQuestCompleted(QuestLine.ROMANCE_NATALYA) && playerNeckClothing != null && playerNeckClothing.getClothingType().getId().equals("innoxia_neck_filly_choker") && Main.game.getPlayer().isAbleToAccessCoverableArea(CoverableArea.MOUTH, true) && (!Main.game.getDialogueFlags().hasFlag("innoxia_callie_natalya_encountered") || Main.game.getSecondsPassed() - Main.game.getDialogueFlags().getSavedLong("callie_natalya_encounter_time") >= 259200L) ? DialogueManager.getDialogueFromId("nnxx_callie_bakery_entry_natalya") : DialogueManager.getDialogueFromId("nnxx_callie_bakery_entry");
                }
                mommyResponses.add(new Response("\u5976\u6cb9\u70d8\u7119\u5e97", "\u53bb\u9644\u8fd1\u7684\u9762\u5305\u5e97\u201c\u5976\u6cb9\u70d8\u7119\u201d\u770b\u770b\u5427\u3002<br/><i>\u8fd9\u5bb6\u9762\u5305\u5e97[style.italicsMinorGood([unit.time(" + hourOpen + ")]-[unit.time(" + hourClose + ")])]\u5f00\u95e8\u8425\u4e1a\u3002</i>", initNode){

                    @Override
                    public void effects() {
                        Main.game.getPlayer().setLocation(WorldType.getWorldTypeFromId("nnxx_callie_bakery"), PlaceType.getPlaceTypeFromId("nnxx_callie_bakery_counter"));
                    }
                });
            } else {
                mommyResponses.add(new Response("\u5976\u6cb9\u70d8\u7119\u5e97", "\u9644\u8fd1\u7684\u9762\u5305\u623f\uff0c\u201c\u5976\u6cb9\u70d8\u7119\u5e97\u201d\uff0c\u5728\u8fd9\u4e2a\u65f6\u95f4\u70b9\u4e0d\u8425\u4e1a\u3002<br/><i>\u4f60\u5f97\u5728" + (Main.game.isHourBetween(hourOpen, hourClose) ? "[style.italicsMinorGood([unit.time(" + hourOpen + ")]-[unit.time(" + hourClose + ")])]\uff0c" : "[style.italicsMinorBad([unit.time(" + hourOpen + ")]-[unit.time(" + hourClose + ")])]\uff0c") + (Main.game.getDayOfWeek() != DayOfWeek.SUNDAY ? "[style.italicsMinorGood(\u5468\u4e00\u5230\u5468\u516d)]" : "[style.italicsMinorBad(\u5468\u4e00\u5230\u5468\u516d)]") + "\u518d\u6765\u3002</i>", null));
            }
        }
        for (final NPC npc : characters) {
            if (npc instanceof RentalMommy) {
                if (Main.game.getCurrentWeather() == Weather.MAGIC_STORM) {
                    mommyResponses.add(new Response("\u5988\u54aa", "\u201c\u5988\u54aa\u201d\u6ca1\u50cf\u4ee5\u5f80\u4e00\u6837\u5750\u5728\u957f\u51f3\u4e0a\uff0c\u4f60\u731c\u5979\u53ef\u80fd\u662f\u5728\u5bb6\u91cc\u8eb2\u907f\u5f53\u524d\u7684\u98ce\u66b4\u3002", null));
                } else {
                    mommyResponses.add(new Response("\u5988\u54aa", "\u4f60\u770b\u89c1\u201c\u5988\u54aa\u201d\u5750\u5728\u5c4b\u5916\u7684\u6728\u5236\u957f\u51f3\u4e0a\uff0c\u8d70\u8fc7\u53bb\u548c\u5979\u6253\u62db\u547c\u3002", RentalMommyDialogue.ENCOUNTER){

                        @Override
                        public void effects() {
                            Main.game.setActiveNPC(npc);
                        }
                    });
                }
            }
            if (Main.game.getPlayer().getFriendlyOccupants().contains(npc.getId())) {
                occupantResponses.add(new Response(UtilText.parse((GameCharacter)npc, "[npc.Name]", new ParserTag[0]), UtilText.parse((GameCharacter)npc, Main.game.getPlayer().getCompanions().contains(npc) ? "\u8f6c\u5934\u56de[npc.namePos]\u7684\u516c\u5bd3\u3002" : "\u8f6c\u5934\u56de[npc.namePos]\u7684\u516c\u5bd3\u62dc\u8bbf[npc.herHim]\u3002", new ParserTag[0]), OccupantDialogue.OCCUPANT_APARTMENT){

                    @Override
                    public void effects() {
                        OccupantDialogue.initDialogue(npc, true, false);
                    }
                });
            }
            if (npc instanceof Cultist) {
                cultistResponses.add(new Response("\u5c0f\u6559\u5802", UtilText.parse((GameCharacter)npc, "\u518d\u6b21\u62dc\u8bbf[npc.namePos]\u7684\u5c0f\u6559\u5802\u3002", new ParserTag[0]), CultistDialogue.ENCOUNTER_CHAPEL_REPEAT){

                    @Override
                    public void effects() {
                        Main.game.setActiveNPC(npc);
                    }
                });
            }
            if (!(npc instanceof ReindeerOverseer)) continue;
            if (Main.game.getCurrentWeather() == Weather.MAGIC_STORM) {
                reindeerResponses.add(new Response("\u76d1\u5de5", "\u9a6f\u9e7f\u5316\u5f62\u5de5\u4eba\u4eec\u6b63\u5728\u8eb2\u907f\u8086\u8650\u7684\u5965\u672f\u98ce\u66b4\u3002\u4f60\u5982\u679c\u60f3\u548c\u76d1\u5de5\u8bf4\u8bdd\uff0c\u53ea\u80fd\u7a0d\u540e\u518d\u6765\u3002", null));
                continue;
            }
            reindeerResponses.add(new Response("\u76d1\u5de5", UtilText.parse((GameCharacter)npc, "\u8d70\u8fc7\u53bb\u548c[npc.name]\u6253\u62db\u547c\u3002", new ParserTag[0]), ReindeerOverseerDialogue.ENCOUNTER_START){

                @Override
                public void effects() {
                    Main.game.setActiveNPC(npc);
                    npc.setPlayerKnowsName(true);
                }
            });
        }
        mommyResponses.addAll(cultistResponses);
        mommyResponses.addAll(occupantResponses);
        mommyResponses.addAll(reindeerResponses);
        return mommyResponses;
    }

    private static String getRandomStreetEvent() {
        int extraText = Util.random.nextInt(100) + 1;
        if (extraText <= 3) {
            return "<p><i>\u4e00\u4e2a\u8eab\u6750\u9ad8\u5927\u3001\u5a01\u98ce\u51db\u51db\u7684\u6deb\u68a6\u9b54\u7a7f\u8fc7\u4eba\u7fa4\uff0c\u7275\u7740\u4e09\u4e2a\u7eaf\u732b\u5973\u5974\u96b6\u3002\u5979\u4eec\u6bcf\u4e2a\u90fd\u4e00\u4e1d\u4e0d\u6302\uff0c\u4f60\u7ecf\u8fc7\u65f6\u53ef\u4ee5\u6e05\u695a\u5730\u770b\u5230\u5979\u4eec\u7684\u6deb\u7a74\u5728\u5174\u594b\u5730\u6d41\u7740\u6c34</i></p>";
        }
        if (extraText <= 6) {
            return "<p><i>\u5728\u4e00\u4fa7\uff0c\u4f60\u770b\u5230\u4e00\u5bf9\u72d7\u7537\u6267\u6cd5\u8005\u6b63\u5728\u5ba1\u95ee\u4e00\u4e2a\u9762\u76ee\u53ef\u618e\u7684\u732b\u7537\u3002\u5f53\u4f60\u7ecf\u8fc7\u65f6\uff0c\u732b\u7537\u8bd5\u56fe\u9003\u8dd1\uff0c\u4f46\u5f88\u5feb\u5c31\u88ab\u6251\u5012\u5728\u5730\u4e0a\u3002\u6267\u6cd5\u8005\u5728\u4ed6\u7684\u624b\u8155\u4e0a\u5957\u4e0a\u4e86\u4e00\u526f\u624b\u94d0\uff0c\u7136\u540e\u628a\u4ed6\u62d6\u5230\u9644\u8fd1\u7684\u4e00\u6761\u5c0f\u5df7\u91cc\u3002</i></p>";
        }
        if (extraText <= 9) {
            return "<p><i>\u4e00\u4e2a\u5de8\u5927\u7684\u5e7f\u544a\u724c\u8986\u76d6\u4e86\u8857\u5bf9\u9762\u4e00\u680b\u5efa\u7b51\u7684\u6574\u4e2a\u6b63\u9762\u3002\u4e0a\u9762\u6709\u4e00\u5219\u201c\u5b64\u6ce8\u4e00\u63b7\u201d\u7684\u6bd4\u8d5b\u5e7f\u544a\uff0c\u627f\u8bfa\u4efb\u4f55\u6709\u5b9e\u529b\u6218\u80dc\u6311\u6218\u7684\u4eba\u90fd\u80fd\u83b7\u5f97\u4e30\u539a\u7684\u5956\u52b1\u3002\u4e0b\u9762\u7528\u9192\u76ee\u7684\u7ea2\u8272\u5b57\u4f53\u5199\u7740\u201c\u7533\u8bf7\u5373\u5c06\u5f00\u59cb\uff01\u201d\u3002</i></p>";
        }
        if (extraText == 10) {
            return "<p><i>\u4e00\u4e2a\u7eaf\u732b\u5973\u5728\u4f60\u7684\u524d\u9762\u53d1\u4f20\u5355\uff0c\u5f53\u4f60\u7ecf\u8fc7\u65f6\uff0c\u5979\u628a\u4e00\u5f20\u4f20\u5355\u585e\u5230\u4f60\u7684\u624b\u91cc\u3002\u4f60\u4f4e\u5934\u4e00\u770b\uff0c\u8fd9\u53ea\u662f\u996e\u6599\u7684\u5e7f\u544a\uff1a\u201c" + ItemType.getItemTypeFromId("innoxia_race_cat_felines_fancy").getName(false) + "\u201d\u3002</i></p>";
        }
        if (extraText == 11) {
            return "<p><i>\u4e00\u4e2a\u7eaf\u72fc\u7537\u5728\u4f60\u7684\u524d\u9762\u53d1\u4f20\u5355\uff0c\u5f53\u4f60\u7ecf\u8fc7\u65f6\uff0c\u4ed6\u628a\u4e00\u5f20\u4f20\u5355\u585e\u5230\u4f60\u7684\u624b\u91cc\u3002\u4f60\u4f4e\u5934\u4e00\u770b\uff0c\u8fd9\u53ea\u662f\u996e\u6599\u7684\u5e7f\u544a\uff1a\u201c" + ItemType.getItemTypeFromId("innoxia_race_wolf_wolf_whiskey").getName(false) + "\u201d\u3002</i></p>";
        }
        if (extraText == 12) {
            return "<p><i>\u4e00\u4e2a\u7eaf\u72d7\u5973\u5728\u4f60\u7684\u524d\u9762\u53d1\u4f20\u5355\uff0c\u5f53\u4f60\u7ecf\u8fc7\u65f6\uff0c\u5979\u628a\u4e00\u5f20\u4f20\u5355\u585e\u5230\u4f60\u7684\u624b\u91cc\u3002\u4f60\u4f4e\u5934\u4e00\u770b\uff0c\u8fd9\u53ea\u662f\u996e\u6599\u7684\u5e7f\u544a\uff1a\u201c" + ItemType.getItemTypeFromId("innoxia_race_dog_canine_crush").getName(false) + "\u201d\u3002</i></p>";
        }
        if (extraText == 13) {
            return "<p><i>\u4e00\u4e2a\u7eaf\u9a6c\u7537\u5728\u4f60\u7684\u524d\u9762\u53d1\u4f20\u5355\uff0c\u5f53\u4f60\u7ecf\u8fc7\u65f6\uff0c\u4ed6\u628a\u4e00\u5f20\u4f20\u5355\u585e\u5230\u4f60\u7684\u624b\u91cc\u3002\u4f60\u4f4e\u5934\u4e00\u770b\uff0c\u8fd9\u53ea\u662f\u996e\u6599\u7684\u5e7f\u544a\uff1a\u201c" + ItemType.getItemTypeFromId("innoxia_race_horse_equine_cider").getName(false) + "\u201d\u3002</i></p>";
        }
        if (extraText == 14) {
            return "<p><i>\u6b22\u547c\u7684\u4eba\u7fa4\u805a\u96c6\u5728\u8857\u9053\u7684\u4e00\u4fa7\uff0c\u5f53\u4f60\u77a5\u5411\u5bf9\u9762\u65f6\uff0c\u4eba\u7fa4\u4e2d\u77ac\u95f4\u51fa\u73b0\u7684\u7a7a\u9699\u8ba9\u4f60\u77a5\u89c1\u4e86\u6b63\u5728\u53d1\u751f\u7684\u4e8b\u60c5\u3002\u4e00\u4e2a\u7eaf\u72d7\u5973\u56db\u811a\u7740\u5730\uff0c\u88ab\u4e00\u4e2a\u7eaf\u9a6c\u7537\u7684\u4e00\u5bf9\u5de8\u5927\u7684\u9a6c\u9e21\u5df4\u53cc\u91cd\u63d2\u5165\u3002\u5973\u5b69\u7684\u201c\u6c41\u6c34\u201d\u987a\u7740\u53cc\u817f\u6d41\u4e0b\uff0c\u5de8\u5927\u7684\u8089\u68d2\u5728\u5979\u88ab\u6491\u5927\u7684\u5c0f\u7a74\u4e2d\u8fdb\u8fdb\u51fa\u51fa\uff0c\u5979\u7684\u820c\u5934\u4e5f\u4ece\u53e3\u4e2d\u8214\u51fa\u3002</i></p>";
        }
        return "";
    }

    private static String getEnforcersPresent() {
        StringBuilder sb = new StringBuilder();
        if (Main.game.getSavedEnforcers(WorldType.DOMINION).isEmpty()) {
            if (DominionPlaces.isCloseToEnforcerHQ()) {
                sb.append("<p style='text-align:center;'><i>");
                sb.append("\u8fd9\u4e00\u533a\u57df\u7531\u4e8e\u9760\u8fd1\u5fa1\u57ce\u533a\u7684[style.colourBlueDark(\u6267\u6cd5\u8005\u603b\u90e8)]\uff0c\u6709[style.italicsBad(\u5f88\u9ad8\u6982\u7387)]\u9047\u5230[style.colourBlueDark(\u6267\u6cd5\u8005\u5de1\u903b\u961f)]\uff01");
                if (Main.game.getCurrentWeather() == Weather.MAGIC_STORM) {
                    sb.append("<br/>\u7136\u800c\uff0c\u7531\u4e8e\u6301\u7eed\u7684\u5965\u672f\u98ce\u66b4\uff0c\u76ee\u524d\u4e0d\u53ef\u80fd\u9047\u5230\u5de1\u903b\u961f\u2026\u2026");
                }
                sb.append("</i></p>");
            }
        } else {
            sb.append("<p style='text-align:center;'><i>");
            if (Main.game.getCurrentWeather() == Weather.MAGIC_STORM) {
                sb.append("\u7531\u4e8e[style.italicsArcane(\u5965\u672f\u98ce\u66b4)]\u6b63\u5728\u8086\u8650\uff0c\u4f60[style.italicsGood(\u6839\u672c\u6ca1\u673a\u4f1a)]\u9047\u89c1[style.colourBlueDark(\u6267\u6cd5\u8005\u5de1\u903b\u961f)]:");
            } else if (DominionPlaces.isCloseToEnforcerHQ()) {
                sb.append("\u8fd9\u4e00\u533a\u57df\u7531\u4e8e\u9760\u8fd1\u5fa1\u57ce\u533a\u7684[style.colourBlueDark(\u6267\u6cd5\u8005\u603b\u90e8)]\uff0c\u6709[style.italicsBad(\u5f88\u9ad8\u6982\u7387)]\u9047\u5230[style.colourBlueDark(\u6267\u6cd5\u8005\u5de1\u903b\u961f)]\u5176\u4e2d\u4e4b\u4e00\u7684\uff1a");
            } else {
                sb.append("\u6709[style.italicsMinorBad(\u8f83\u4f4e\u6982\u7387)]\u906d\u9047\u5176\u4e2d\u4e00\u652f[style.colourBlueDark(\u6267\u6cd5\u8005\u5de1\u903b\u961f)]\uff1a");
            }
            for (List<String> enforcerIds : Main.game.getSavedEnforcers(WorldType.DOMINION)) {
                sb.append("<br/>");
                ArrayList<String> names = new ArrayList<String>();
                for (String id : enforcerIds) {
                    try {
                        GameCharacter enforcer = Main.game.getNPCById(id);
                        names.add(UtilText.parse(enforcer, "<span style='color:" + enforcer.getFemininity().getColour().toWebHexString() + ";'>[npc.Name]</span>", new ParserTag[0]));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                sb.append(Util.stringsToStringList(names, false));
            }
            sb.append("</i></p>");
        }
        return sb.toString();
    }

    private static String getRandomNewsText() {
        ArrayList<AbstractSubspecies> possibleSubspecies = new ArrayList<AbstractSubspecies>();
        for (AbstractSubspecies s : Subspecies.allSubspecies) {
            if (!s.getMostCommonWorldRegions().contains((Object)WorldRegion.DOMINION)) continue;
            possibleSubspecies.add(s);
        }
        String randomFemalePerson = ((AbstractSubspecies)Util.randomItemFrom(possibleSubspecies)).getSingularFemaleName(null);
        String randomMalePerson = ((AbstractSubspecies)Util.randomItemFrom(possibleSubspecies)).getSingularMaleName(null);
        ArrayList<String> strings = Util.newArrayListOfValues("\u4e00\u4e2a\u9762\u76f8\u4e0d\u5584\u7684" + randomMalePerson + "\u5c55\u5f00\u4e00\u4e2a\u5927\u5377\u8f74\uff0c\u6e05\u4e86\u6e05\u55d3\u5b50\u558a\u9053\uff0c[maleNPC.speech(\u5949\u8389\u8389\u4e1d\u6555\u8c15\uff0c\u4e3a\u4e86\u5fa1\u57ce\u533a\u7684\u5b89\u5168\uff0c\u5728\u767d\u5929\u4ee5\u5916\u7684\u65f6\u95f4\uff0c\u4efb\u4f55\u5728\u8857\u4e0a\u884c\u8d70\u7684\u4eba\u90fd\u53ef\u80fd\u88ab\u6267\u6cd5\u8005\u4f9d\u6cd5\u8fdb\u884c\u5168\u8eab\u641c\u67e5\u3002)]", Util.capitaliseSentence(UtilText.addDeterminer(randomFemalePerson)) + "\u4e3e\u8d77\u4e00\u5f20\u76d6\u6709\u7ea2\u8272\u8721\u5370\u7684\u5b98\u65b9\u6587\u4ef6\u516c\u5e03\u7740\u4ec0\u4e48\uff0c[femaleNPC.speech(\u60ac\u8d4f\u4e8c\u5341\u4e07\u706b\u5e01\uff0c\u4ee5\u5956\u52b1\u4efb\u4f55\u63d0\u4f9b\u7ebf\u7d22\u8005\uff0c\u7f09\u62ff\u5728\u54c8\u6bd4\u4e4b\u5de2\u4e0b\u7684\u5730\u533a\u6563\u53d1\u975e\u6cd5\u62a5\u7eb8\u7684\u5acc\u7591\u4eba\uff01)]", "\u4e00\u4e2a\u7a7f\u7740\u4e07\u5723\u8282\u5973\u5deb\u670d\u3001\u5916\u8868\u72c2\u91ce\u7684\u9b45\u9b54\uff0c\u4e00\u8fb9\u5c16\u53eb\u4e00\u8fb9\u6307\u7740\u4eba\u7fa4\u4e2d\u7684\u5404\u8272\u4eba\u7b49\uff0c[femaleNPC.speech(\u6211\u6570\u4e86\u4e00\u4e0b\uff0c\u4eba\u7fa4\u4e2d\u81f3\u5c11\u6709\u4e09\u4e2a\u6076\u9b54\u6ca1\u6709\u7a7f\u72c2\u4fe1\u8005\u5236\u670d\uff01\u8389\u8389\u4e1d\u5982\u679c\u770b\u5230\u8fd9\u4e9b\u4f1a\u600e\u4e48\u8bf4\uff1f\uff01)]", Util.capitaliseSentence(UtilText.addDeterminer(randomMalePerson)) + "\u6b63\u5411\u7fa4\u4f17\u4f20\u64ad\u51e0\u6761\u65e0\u804a\u7684\u7410\u788e\u65b0\u95fb\u3002\u6ca1\u6709\u4efb\u4f55\u4f60\u611f\u5174\u8da3\u7684\u4e1c\u897f\uff0c\u4f60\u6700\u7ec8\u8f6c\u8eab\u79bb\u53bb\uff0c\u89c9\u5f97\u81ea\u5df1\u53ea\u662f\u5728\u6d6a\u8d39\u65f6\u95f4\u3002", Util.capitaliseSentence(UtilText.addDeterminer(randomFemalePerson)) + " \u6b63\u5411\u7fa4\u4f17\u4f20\u64ad\u51e0\u6761\u65e0\u804a\u7684\u7410\u788e\u65b0\u95fb\u3002\u6ca1\u6709\u4efb\u4f55\u4f60\u611f\u5174\u8da3\u7684\u4e1c\u897f\uff0c\u4f60\u6700\u7ec8\u8f6c\u8eab\u79bb\u53bb\uff0c\u89c9\u5f97\u81ea\u5df1\u53ea\u662f\u5728\u6d6a\u8d39\u65f6\u95f4\u3002", Util.capitaliseSentence(UtilText.addDeterminer(randomMalePerson)) + "\u6b63\u5728\u5ba3\u8bfb\u5f53\u5730\u5546\u5e97\u7684\u5e7f\u544a\u6e05\u5355\u3002\u6ca1\u6709\u4efb\u4f55\u4f60\u611f\u5174\u8da3\u7684\u4e1c\u897f\uff0c\u4f60\u5f88\u5feb\u53d1\u73b0\u81ea\u5df1\u53ea\u662f\u5728\u6d6a\u8d39\u65f6\u95f4\uff0c\u8f6c\u8eab\u79bb\u5f00\u3002", Util.capitaliseSentence(UtilText.addDeterminer(randomFemalePerson)) + "\u6b63\u5728\u5ba3\u8bfb\u5f53\u5730\u5546\u5e97\u7684\u5e7f\u544a\u6e05\u5355\u3002\u6ca1\u6709\u4efb\u4f55\u4f60\u611f\u5174\u8da3\u7684\u4e1c\u897f\uff0c\u4f60\u5f88\u5feb\u53d1\u73b0\u81ea\u5df1\u53ea\u662f\u5728\u6d6a\u8d39\u65f6\u95f4\uff0c\u8f6c\u8eab\u79bb\u5f00\u3002");
        ArrayList<Integer> availableIndexes = new ArrayList<Integer>();
        for (int i = 0; i < strings.size(); ++i) {
            availableIndexes.add(i);
        }
        for (Integer i : viewedNewsIndexes) {
            availableIndexes.remove(i);
        }
        if (availableIndexes.isEmpty()) {
            viewedAllNews = true;
            return "<p style='text-align:center;'>[style.italicsDisabled(\u4f60\u5df2\u7ecf\u5168\u90fd\u542c\u8fc7\u4e86\u2026\u2026)]</p>";
        }
        int index = (Integer)Util.randomItemFrom(availableIndexes);
        viewedNewsIndexes.add(index);
        return "<p>" + (String)strings.get(index) + "</p>";
    }
}

