/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.dominion.lilayashome;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.PlayerCharacter;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.body.valueEnums.BodyMaterial;
import com.lilithsthrone.game.character.body.valueEnums.NippleShape;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.dominion.Lilaya;
import com.lilithsthrone.game.character.npc.misc.OffspringSeed;
import com.lilithsthrone.game.character.quests.Quest;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.Lab;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.RoomPlayer;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.XMLSaving;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;
import java.util.ArrayList;

public class LilayaBirthing {
    public static final DialogueNode LILAYA_ASSISTS_PREGNANCY = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            PlayerCharacter player = Main.game.getPlayer();
            NPC lilaya = Main.game.getNpc(Lilaya.class);
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "LILAYA_ASSISTS_PREGNANCY_START"));
            if (player.getTotalTimesHadSex(lilaya) > 0) {
                if (player.getPotentialPartnersAsMother().stream().anyMatch(x -> x.getFather() == lilaya)) {
                    if (player.getPotentialPartnersAsMother().stream().anyMatch(x -> x.getFather() != lilaya)) {
                        UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "LILAYA_ASSISTS_PREGNANCY_LILAYA_POSSIBLY_FATHER"));
                    } else {
                        UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "LILAYA_ASSISTS_PREGNANCY_LILAYA_DEFINITELY_FATHER"));
                    }
                } else {
                    UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "LILAYA_ASSISTS_PREGNANCY_LILAYA_DEFINITELY_NOT_FATHER"));
                }
            }
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "LILAYA_ASSISTS_PREGNANCY_END"));
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getPlayer().hasStatusEffect(StatusEffect.PREGNANT_3)) {
                    return new Response("\u5206\u5a29", "\u544a\u8bc9\u8389\u83b1\u96c5\uff0c\u4f60\u51c6\u5907\u597d\u5206\u5a29\u4e86\u3002", LILAYA_DETECTS_BIRTHING_TYPE){

                        @Override
                        public void effects() {
                            if (Main.game.getPlayer().isVisiblyPregnant() && !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.reactedToPregnancyLilaya)) {
                                Main.game.getDialogueFlags().setFlag(DialogueFlagValue.reactedToPregnancyLilaya, true);
                            }
                        }
                    };
                }
                return new Response("\u5206\u5a29", "\u4f60\u9700\u8981\u7b49\u5230\u809a\u5b50\u505c\u6b62\u751f\u957f\u540e\u624d\u80fd\u5206\u5a29\u3002", null){

                    @Override
                    public void effects() {
                        if (Main.game.getPlayer().isVisiblyPregnant() && !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.reactedToPregnancyLilaya)) {
                            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.reactedToPregnancyLilaya, true);
                        }
                    }
                };
            }
            if (index == 0) {
                return new Response("\u8fd4\u56de", "\u544a\u8bc9\u8389\u83b1\u96c5\uff0c\u4f60\u9700\u8981\u8003\u8651\u4e00\u4e0b\u3002", Lab.LAB_EXIT){

                    @Override
                    public void effects() {
                        if (Main.game.getPlayer().isVisiblyPregnant() && !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.reactedToPregnancyLilaya)) {
                            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.reactedToPregnancyLilaya, true);
                        }
                        Main.game.getTextStartStringBuilder().append("<p>[pc.speech(\u8c22\u8c22\u4f60\u7684\u5e2e\u52a9\uff0c\u8389\u83b1\u96c5\uff0c\u4f46\u6211\u80fd\u60f3\u4e00\u60f3\u5417\uff1f)]\u4f60\u95ee\uff0c\u5fae\u7b11\u5730\u770b\u7740\u4f60\u7684\u6076\u9b54[lilaya.relation(pc)].</p><p>[lilaya.speech(\u5f53\u7136\uff0c\u5982\u679c\u4f60\u8fd8\u9700\u8981\u4ec0\u4e48\uff0c\u8bf7\u544a\u8bc9\u6211\uff01)]\u5979\u8bf4\uff0c\u7136\u540e\u7a0d\u7a0d\u540e\u9000\uff0c\u7ed9\u4f60\u4e00\u4e9b\u7a7a\u95f4\u3002</p>");
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode LILAYA_ASSISTS_PREGNANCY_REPEAT = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 30;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "LILAYA_ASSISTS_PREGNANCY_REPEAT");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return LILAYA_ASSISTS_PREGNANCY.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode LILAYA_DETECTS_BIRTHING_TYPE = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getLabel() {
            return "\u5206\u5a29";
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "LILAYA_DETECTS_BIRTHING_TYPE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getPlayer().isVaginaEggLayer()) {
                    return new Response("\u8ddf\u968f\u8389\u83b1\u96c5", "\u8ba9\u8389\u83b1\u96c5\u5e26\u4f60\u53bb\u4f60\u7684\u623f\u95f4\u3002", LILAYA_ASSISTS_EGG_LAYING){

                        @Override
                        public void effects() {
                            Main.game.getNpc(Lilaya.class).setLocation(WorldType.LILAYAS_HOUSE_FIRST_FLOOR, PlaceType.LILAYA_HOME_ROOM_PLAYER, false);
                            Main.game.getPlayer().setLocation(WorldType.LILAYAS_HOUSE_FIRST_FLOOR, PlaceType.LILAYA_HOME_ROOM_PLAYER, false);
                        }
                    };
                }
                return new Response("\u8ddf\u968f\u8389\u83b1\u96c5", "\u8ba9\u8389\u83b1\u96c5\u5e26\u4f60\u53bb\u5206\u5a29\u5ba4\u3002", LILAYA_ASSISTS_BIRTHING){

                    @Override
                    public void effects() {
                        Main.game.getNpc(Lilaya.class).setLocation(WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_BIRTHING_ROOM, false);
                        Main.game.getPlayer().setLocation(WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_BIRTHING_ROOM, false);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode LILAYA_ASSISTS_BIRTHING = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 600;
        }

        @Override
        public String getLabel() {
            return "\u5206\u5a29\u5ba4";
        }

        @Override
        public String getContent() {
            if (Main.game.getPlayer().getBodyMaterial() == BodyMaterial.SLIME) {
                return UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "ASSIST_BIRTHING_SLIME");
            }
            if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_FIRST_TIME_PREGNANCY)) {
                return UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "ASSIST_BIRTHING_FIRST_TIME");
            }
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "ASSIST_BIRTHING");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u5f00\u59cb", "\u544a\u8bc9\u8389\u83b1\u96c5\u4f60\u5df2\u7ecf\u51c6\u5907\u597d\u5206\u5a29\u4e86\u3002", LILAYA_ASSISTS_BIRTHING_DELIVERS){

                    @Override
                    public void effects() {
                        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.reactedToPregnancyLilaya, false);
                        Main.game.getPlayer().endPregnancy(true);
                        Main.game.getPlayer().setMana(0.0f);
                        if (Main.game.getPlayer().getBodyMaterial() != BodyMaterial.SLIME) {
                            Main.game.getPlayer().incrementVaginaStretchedCapacity(15.0f);
                            Main.game.getPlayer().incrementVaginaCapacity((Main.game.getPlayer().getVaginaStretchedCapacity() - Main.game.getPlayer().getVaginaRawCapacityValue()) * Main.game.getPlayer().getVaginaPlasticity().getCapacityIncreaseModifier(), false);
                        }
                    }
                };
            }
            if (index == 2) {
                return new Response("\u9ebb\u9189", "\u95ee\u95ee\u8389\u83b1\u96c5\u80fd\u4e0d\u80fd\u7ed9\u4f60\u70b9\u836f\u8ba9\u4f60\u9ebb\u8fc7\u53bb\u3002\u6bd5\u7adf\uff0c\u5979\u8bf4\u8fc7\u4f60\u4e0d\u9700\u8981\u6709\u610f\u8bc6\u5730\u53bb\u505a\u8fd9\u4ef6\u4e8b\u3002", LILAYA_ASSISTS_BIRTHING_KNOCK_OUT){

                    @Override
                    public void effects() {
                        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.reactedToPregnancyLilaya, false);
                        Main.game.getPlayer().endPregnancy(true);
                        Main.game.getPlayer().setMana(0.0f);
                        if (Main.game.getPlayer().getBodyMaterial() != BodyMaterial.SLIME) {
                            Main.game.getPlayer().incrementVaginaStretchedCapacity(15.0f);
                            Main.game.getPlayer().incrementVaginaCapacity((Main.game.getPlayer().getVaginaStretchedCapacity() - Main.game.getPlayer().getVaginaRawCapacityValue()) * Main.game.getPlayer().getVaginaPlasticity().getCapacityIncreaseModifier(), false);
                        }
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode LILAYA_ASSISTS_BIRTHING_DELIVERS = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 14400;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "LILAYA_ASSISTS_BIRTHING_DELIVERS"));
            UtilText.nodeContentSB.append("<p><i>\u4f60\u542c\u5230\u8389\u83b1\u96c5\u5728\u4f60\u4e0b\u9762\u7684\u67d0\u4e2a\u5730\u65b9\u8bf4\u8bdd\uff0c\u4f46\u4f60\u542c\u4e0d\u6e05\u5979\u5728\u8bf4\u4ec0\u4e48\u2026\u2026<br/><br/>");
            if (Main.game.getPlayer().getBreastRawMilkStorageValue() > 0 && Main.game.getPlayer().isAbleToAccessCoverableArea(CoverableArea.NIPPLES, true) && Main.game.getPlayer().getNippleShape() == NippleShape.NORMAL && Main.game.isLactationContentEnabled()) {
                UtilText.nodeContentSB.append("\u4f60\u611f\u5230\u4e73\u5934\u88ab\u62fc\u547d\u542e\u5438\uff0c\u4f60\u9690\u7ea6\u610f\u8bc6\u5230\u6709\u4ec0\u4e48\u4e1c\u897f\u5728\u8d2a\u5a6a\u5730\u559d\u4e0b\u4f60\u7684[pc.milk]\u2026\u2026");
            } else {
                UtilText.nodeContentSB.append("\u4f60\u611f\u5230\u80f8\u53e3\u6709\u4e00\u79cd\u91cd\u91cf\uff0c\u4f60\u9690\u7ea6\u610f\u8bc6\u5230\u6709\u4ec0\u4e48\u4e1c\u897f\u5728\u8d2a\u5a6a\u5730\u559d\u7740\u4e00\u74f6\u725b\u5976\uff0c\u4f60\u628a\u5b83\u62b1\u5728\u6000\u91cc\u2026\u2026");
            }
            String offspringId = Util.randomItemFrom(Main.game.getPlayer().getLastLitterBirthed().getOffspring());
            try {
                if (offspringId.contains("NPCOffspring")) {
                    GameCharacter offspring = Main.game.getNPCById(offspringId);
                    if (offspring.isFeminine()) {
                        UtilText.nodeContentSB.append("<br/><br/>\u4e00\u6bb5\u65f6\u95f4\u540e\uff0c\u4f60\u4f3c\u4e4e\u770b\u5230\u4e86\u4e00\u4e2a\u964c\u751f\u800c\u719f\u6089\u7684" + offspring.getSubspecies().getSingularFemaleName(offspring.getBody()) + "\u5728\u4f60\u9762\u524d\u4fef\u4e0b\u8eab\u5b50\uff0c\u7ed9\u4f60\u4e00\u4e2a\u6df1\u60c5\u7684\u62e5\u62b1\uff0c\u5728\u4f60\u7684\u8138\u988a\u4e0a\u4eb2\u543b\u4e00\u4e0b\uff0c\u7136\u540e\u79bb\u53bb\u2026\u2026");
                    } else {
                        UtilText.nodeContentSB.append("<br/><br/>\u4e00\u6bb5\u65f6\u95f4\u540e\uff0c\u4f60\u4f3c\u4e4e\u770b\u5230\u4e86\u4e00\u4e2a\u964c\u751f\u800c\u719f\u6089\u7684" + offspring.getSubspecies().getSingularMaleName(offspring.getBody()) + "\u5f2f\u4e0b\u8170\uff0c\u5728\u4f60\u8138\u4e0a\u4eb2\u4e86\u4e00\u4e0b\uff0c\u5e76\u5728\u4f60\u8033\u8fb9\u5600\u5495\u4e86\u51e0\u53e5\uff0c\u7136\u540e\u8d70\u51fa\u95e8\u53bb\u2026\u2026");
                    }
                } else {
                    OffspringSeed offspring = Main.game.getOffspringSeedById(offspringId);
                    if (offspring.isFeminine()) {
                        UtilText.nodeContentSB.append("<br/><br/>\u4e00\u6bb5\u65f6\u95f4\u540e\uff0c\u4f60\u4f3c\u4e4e\u770b\u5230\u4e86\u4e00\u4e2a\u964c\u751f\u800c\u719f\u6089\u7684" + offspring.getSubspecies().getSingularFemaleName(offspring.getBody()) + "\u5728\u4f60\u9762\u524d\u4fef\u4e0b\u8eab\u5b50\uff0c\u7ed9\u4f60\u4e00\u4e2a\u6df1\u60c5\u7684\u62e5\u62b1\uff0c\u5728\u4f60\u7684\u8138\u988a\u4e0a\u4eb2\u543b\u4e00\u4e0b\uff0c\u7136\u540e\u79bb\u53bb\u2026\u2026");
                    } else {
                        UtilText.nodeContentSB.append("<br/><br/>\u4e00\u6bb5\u65f6\u95f4\u540e\uff0c\u4f60\u4f3c\u4e4e\u770b\u5230\u4e86\u4e00\u4e2a\u964c\u751f\u800c\u719f\u6089\u7684" + offspring.getSubspecies().getSingularMaleName(offspring.getBody()) + "\u5f2f\u4e0b\u8170\uff0c\u5728\u4f60\u8138\u4e0a\u4eb2\u4e86\u4e00\u4e0b\uff0c\u5e76\u5728\u4f60\u8033\u8fb9\u5600\u5495\u4e86\u51e0\u53e5\uff0c\u7136\u540e\u8d70\u51fa\u95e8\u53bb\u2026\u2026");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            UtilText.nodeContentSB.append("</i></p>");
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u660f\u8ff7", "\u4f60\u5df2\u7ecf\u6ca1\u6709\u529b\u6c14\u4e86\uff0c\u65e0\u6cd5\u518d\u4fdd\u6301\u6e05\u9192\u2026\u2026", LILAYA_ASSISTS_BIRTHING_FINISHED){

                    @Override
                    public void effects() {
                        if (Main.game.getPlayer().getQuest(QuestLine.SIDE_FIRST_TIME_PREGNANCY) == Quest.SIDE_PREGNANCY_LILAYA_THE_MIDWIFE) {
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_FIRST_TIME_PREGNANCY, Quest.SIDE_UTIL_COMPLETE));
                        }
                        Main.game.getPlayer().setMana(Main.game.getPlayer().getAttributeValue(Attribute.MANA_MAXIMUM));
                        Main.game.getNpc(Lilaya.class).setLocation(WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_LAB, false);
                        Main.game.getPlayer().setLocation(WorldType.LILAYAS_HOUSE_FIRST_FLOOR, PlaceType.LILAYA_HOME_ROOM_PLAYER, false);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode LILAYA_ASSISTS_BIRTHING_KNOCK_OUT = new DialogueNode("\u4f60\u7684\u623f\u95f4", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 14400;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "LILAYA_ASSISTS_BIRTHING_KNOCK_OUT");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u660f\u8ff7", "\u8389\u83b1\u96c5\u7ed9\u4f60\u7684\u996e\u6599\u76f4\u51b2\u8111\u95e8\uff0c\u4f60\u5931\u53bb\u77e5\u89c9\u540e\u5012\u5728\u4e86\u5e8a\u4e0a\u3002", LILAYA_ASSISTS_BIRTHING_FINISHED){

                    @Override
                    public void effects() {
                        if (Main.game.getPlayer().getQuest(QuestLine.SIDE_FIRST_TIME_PREGNANCY) == Quest.SIDE_PREGNANCY_LILAYA_THE_MIDWIFE) {
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_FIRST_TIME_PREGNANCY, Quest.SIDE_UTIL_COMPLETE));
                        }
                        Main.game.getPlayer().setMana(Main.game.getPlayer().getAttributeValue(Attribute.MANA_MAXIMUM));
                        Main.game.getNpc(Lilaya.class).setLocation(WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_LAB, false);
                        Main.game.getPlayer().setLocation(WorldType.LILAYAS_HOUSE_FIRST_FLOOR, PlaceType.LILAYA_HOME_ROOM_PLAYER, false);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode LILAYA_ASSISTS_EGG_LAYING = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 600;
        }

        @Override
        public String getLabel() {
            return "\u4f60\u7684\u623f\u95f4";
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "LILAYA_ASSISTS_EGG_LAYING");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u4e0b\u86cb", "\u544a\u8bc9\u8389\u83b1\u96c5\uff0c\u4f60\u73b0\u5728\u53ef\u4ee5\u4e0b\u86cb\u4e86\u3002", LILAYA_ASSISTS_EGG_LAYING_DELIVERS){

                    @Override
                    public void effects() {
                        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.reactedToPregnancyLilaya, false);
                        Main.game.getPlayer().endPregnancy(true);
                        Main.game.getPlayer().setMana(0.0f);
                        if (Main.game.getPlayer().getBodyMaterial() != BodyMaterial.SLIME) {
                            Main.game.getPlayer().incrementVaginaStretchedCapacity(15.0f);
                            Main.game.getPlayer().incrementVaginaCapacity((Main.game.getPlayer().getVaginaStretchedCapacity() - Main.game.getPlayer().getVaginaRawCapacityValue()) * Main.game.getPlayer().getVaginaPlasticity().getCapacityIncreaseModifier(), false);
                        }
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode LILAYA_ASSISTS_EGG_LAYING_DELIVERS = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 1800;
        }

        @Override
        public String getContent() {
            UtilText.addSpecialParsingString(Util.intToString(Main.game.getPlayer().getLastLitterBirthed().getTotalLitterCount()), true);
            return UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "LILAYA_ASSISTS_EGG_LAYING_DELIVERS");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response(Main.game.getPlayer().getLastLitterBirthed().getTotalLitterCount() == 1 ? "\u4fdd\u62a4\u86cb" : "\u4fdd\u62a4\u86cb\uff01", Main.game.getPlayer().getLastLitterBirthed().getTotalLitterCount() == 1 ? "\u4e3a\u4ec0\u4e48\u8389\u83b1\u96c5\u9760\u5f97\u8fd9\u4e48\u8fd1\uff1f\u4e5f\u8bb8\u5979\u60f3\u628a\u4f60\u7684\u86cb\u5360\u4e3a\u5df1\u6709\uff01" : "\u4e3a\u4ec0\u4e48\u8389\u83b1\u96c5\u9760\u5f97\u8fd9\u4e48\u8fd1\uff1f\u4e5f\u8bb8\u5979\u60f3\u628a\u4f60\u7684\u86cb\u5360\u4e3a\u5df1\u6709\uff01", LILAYA_ASSISTS_EGG_LAYING_PROTECT_THE_EGGS){

                    @Override
                    public void effects() {
                        Main.game.getNpc(Lilaya.class).setLocation(WorldType.LILAYAS_HOUSE_GROUND_FLOOR, PlaceType.LILAYA_HOME_LAB, false);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode LILAYA_ASSISTS_EGG_LAYING_PROTECT_THE_EGGS = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 86400;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "LILAYA_ASSISTS_EGG_LAYING_PROTECT_THE_EGGS"));
            String offspringId = Util.randomItemFrom(Main.game.getPlayer().getLastLitterBirthed().getOffspring());
            try {
                if (offspringId.contains("NPCOffspring")) {
                    GameCharacter offspring = Main.game.getNPCById(offspringId);
                    if (offspring.isFeminine()) {
                        UtilText.addSpecialParsingString(offspring.getSubspecies().getSingularFemaleName(offspring.getBody()), true);
                        UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "LILAYA_ASSISTS_EGG_LAYING_PROTECT_THE_EGGS_FEMININE_HATCHING"));
                    } else {
                        UtilText.addSpecialParsingString(offspring.getSubspecies().getSingularMaleName(offspring.getBody()), true);
                        UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "LILAYA_ASSISTS_EGG_LAYING_PROTECT_THE_EGGS_MASCULINE_HATCHING"));
                    }
                } else {
                    OffspringSeed offspring = Main.game.getOffspringSeedById(offspringId);
                    if (offspring.isFeminine()) {
                        UtilText.addSpecialParsingString(offspring.getSubspecies().getSingularFemaleName(offspring.getBody()), true);
                        UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "LILAYA_ASSISTS_EGG_LAYING_PROTECT_THE_EGGS_FEMININE_HATCHING"));
                    } else {
                        UtilText.addSpecialParsingString(offspring.getSubspecies().getSingularMaleName(offspring.getBody()), true);
                        UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "LILAYA_ASSISTS_EGG_LAYING_PROTECT_THE_EGGS_MASCULINE_HATCHING"));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "LILAYA_ASSISTS_EGG_LAYING_PROTECT_THE_EGGS_END"));
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u4e00\u6bb5\u65f6\u95f4\u540e", "\u4f60\u6700\u7ec8\u4ece\u75b2\u60eb\u7684\u6c89\u7761\u4e2d\u9192\u6765\u2026\u2026", LILAYA_ASSISTS_BIRTHING_FINISHED){

                    @Override
                    public void effects() {
                        if (Main.game.getPlayer().getQuest(QuestLine.SIDE_FIRST_TIME_PREGNANCY) == Quest.SIDE_PREGNANCY_LILAYA_THE_MIDWIFE) {
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_FIRST_TIME_PREGNANCY, Quest.SIDE_UTIL_COMPLETE));
                        }
                        Main.game.getPlayer().setMana(Main.game.getPlayer().getAttributeValue(Attribute.MANA_MAXIMUM));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode LILAYA_ASSISTS_BIRTHING_FINISHED = new DialogueNode("\u4f60\u7684\u623f\u95f4", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("places/dominion/lilayasHome/lilayaBirthing", "LILAYA_ASSISTS_BIRTHING_FINISHED"));
            UtilText.nodeContentSB.append("<p style='text-align:center;'>\u5728\u56fe\u7247\u4e2d\u4f60\u53ef\u4ee5\u770b\u5230\uff1a");
            for (String id : Main.game.getPlayer().getLastLitterBirthed().getOffspring()) {
                try {
                    String descriptor;
                    XMLSaving offspring;
                    if (id.contains("NPCOffspring")) {
                        offspring = Main.game.getNPCById(id);
                        descriptor = LilayaBirthing.getOffspringDescriptor((GameCharacter)offspring);
                        UtilText.nodeContentSB.append("<br/>" + Util.capitaliseSentence(UtilText.generateSingularDeterminer(descriptor)) + descriptor + "\u7684<i style='color:" + ((GameCharacter)offspring).getGender().getColour().toWebHexString() + ";'>" + ((GameCharacter)offspring).getGender().getName() + "</i>" + (String)(((GameCharacter)offspring).isFeral() ? "<i style='color:" + RaceStage.FERAL.getColour().toWebHexString() + ";'>" + RaceStage.FERAL.getName() + "</i>" : "") + "<i style='color:" + ((GameCharacter)offspring).getSubspecies().getColour((GameCharacter)offspring).toWebHexString() + ";'>" + UtilText.parse((GameCharacter)offspring, "[npc.race]", new ParserTag[0]) + "</i>");
                        continue;
                    }
                    offspring = Main.game.getOffspringSeedById(id);
                    descriptor = LilayaBirthing.getOffspringDescriptor((OffspringSeed)offspring);
                    UtilText.nodeContentSB.append("<br/>" + Util.capitaliseSentence(UtilText.generateSingularDeterminer(descriptor)) + descriptor + (String)(((OffspringSeed)offspring).isFeral() ? "<i style='color:" + RaceStage.FERAL.getColour().toWebHexString() + ";'>" + RaceStage.FERAL.getName() + "</i>" : "") + "<i style='color:" + ((OffspringSeed)offspring).getSubspecies().getColour(null).toWebHexString() + ";'>" + ((OffspringSeed)offspring).getSubspecies().getName(((OffspringSeed)offspring).getBody()) + "</i><i style='color:" + ((OffspringSeed)offspring).getGender().getColour().toWebHexString() + ";'>" + ((OffspringSeed)offspring).getGenderName() + "</i>");
                }
                catch (Exception exception) {}
            }
            UtilText.nodeContentSB.append("</p><p>\u82b1\u4e86\u4e00\u5206\u949f\u63a7\u5236\u60c5\u7eea\u540e\uff0c\u4f60\u628a\u7167\u7247\u6536\u8d77\u6765\u4fdd\u7ba1\uff0c\u5e76\u601d\u8003\u4e0b\u4e00\u6b65\u8be5\u600e\u4e48\u505a\u3002</p>");
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u8d77\u5e8a", "\u4ece\u5e8a\u4e0a\u722c\u8d77\u6765\uff0c\u51c6\u5907\u8fce\u63a5\u65b0\u7684\u4e00\u5929\u3002", RoomPlayer.ROOM);
            }
            return null;
        }
    };

    public static String getOffspringDescriptor(GameCharacter offspring) {
        ArrayList<String> descriptors = new ArrayList<String>();
        descriptors.add(offspring.getBodyShape().getName(false));
        descriptors.add(offspring.getHeight().getDescriptor());
        descriptors.add(offspring.getFemininity().getName(false));
        return (String)Util.randomItemFrom(descriptors);
    }

    public static String getOffspringDescriptor(OffspringSeed offspring) {
        ArrayList<String> descriptors = new ArrayList<String>();
        descriptors.add(offspring.getBodyShape().getName(false));
        descriptors.add(offspring.getHeight().getDescriptor());
        descriptors.add(offspring.getFemininity().getName(false));
        return (String)Util.randomItemFrom(descriptors);
    }
}

