/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.dominion.lilayashome;

import com.lilithsthrone.game.PropertyValue;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.body.types.HornType;
import com.lilithsthrone.game.character.body.types.TailType;
import com.lilithsthrone.game.character.body.types.WingType;
import com.lilithsthrone.game.character.body.valueEnums.BodyMaterial;
import com.lilithsthrone.game.character.body.valueEnums.HairLength;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.markings.Tattoo;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.npc.misc.BasicDoll;
import com.lilithsthrone.game.character.race.RaceStage;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.combat.DamageType;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.companions.CompanionManagement;
import com.lilithsthrone.game.dialogue.companions.OccupantManagementDialogue;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.LilayaHomeGeneric;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseEffectsOnly;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.PhoneDialogue;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.ColourReplacement;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.Rarity;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.AbstractClothingType;
import com.lilithsthrone.game.inventory.clothing.Sticker;
import com.lilithsthrone.game.inventory.clothing.StickerCategory;
import com.lilithsthrone.game.inventory.enchanting.EnchantingUtils;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.game.inventory.enchanting.TFPotency;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.outfit.Outfit;
import com.lilithsthrone.game.inventory.outfit.OutfitSource;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.game.inventory.weapon.AbstractWeaponType;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJob;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJobFlag;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.Pattern;
import com.lilithsthrone.rendering.RenderingEngine;
import com.lilithsthrone.rendering.SVGImages;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.places.AbstractPlaceUpgrade;
import com.lilithsthrone.world.places.PlaceUpgrade;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LilayaDressingRoomDialogue {
    public static String deleteConfirmationName = "";
    private static Map<String, Outfit> loadedOutfitsMap;
    private static Map<Outfit, Integer> loadedOutfitsAvailabilityFromTile;
    private static Outfit activeOutfit;
    private static String loadedFileName;
    private static boolean outfitFilesFullVisibility;
    private static boolean outfitObtainedViaPurchase;
    public static boolean newlyCreatedWeapon;
    private static String dollID;
    public static final DialogueNode ROOM_DRESSING_ROOM;
    public static final DialogueNode OUTFITS;
    public static final DialogueNode OUTFIT_EDITOR;
    public static final DialogueNode OUTFIT_PURCHASE;
    private static float inventoryUIWidth;
    private static float mainClothingPanelWidth;
    private static InventorySlot selectedSlot;
    private static AbstractWeapon weaponSelected;
    private static AbstractClothing clothingSelected;
    public static final DialogueNode OUTFIT_EDITOR_ITEM_CHOICE;
    public static final DialogueNode OUTFIT_EDITOR_ITEM_DYE;
    public static final DialogueNode OUTFIT_EDITOR_ITEM_ENCHANT;
    private static List<ItemEffect> effects;
    private static TFModifier primaryMod;
    private static TFModifier secondaryMod;
    public static TFModifier previousPrimaryMod;
    public static TFModifier previousSecondaryMod;
    private static TFPotency potency;
    private static int limit;
    private static String outputName;
    public static final DialogueNode INSTALLATION;
    public static final DialogueNode WARDROBE_ACTIVATION;

    private static void initDressupDoll() {
        BasicDoll doll = new BasicDoll();
        try {
            dollID = Main.game.addNPC(doll, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        doll.setBody(Gender.F_P_V_B_FUTANARI, Subspecies.HUMAN, RaceStage.GREATER, true);
        doll.setBodyMaterial(BodyMaterial.SILICONE);
        doll.setTailType(TailType.DEMON_COMMON);
        doll.setWingType(WingType.DEMON_COMMON);
        doll.setHornType(HornType.STRAIGHT);
        doll.setHairLength(HairLength.FOUR_MID_BACK.getMedianValue());
        doll.setArmRows(3);
        doll.setPiercedEar(true);
        doll.setPiercedLip(true);
        doll.setPiercedNavel(true);
        doll.setPiercedNipples(true);
        doll.setPiercedNipplesCrotch(true);
        doll.setPiercedNose(true);
        doll.setPiercedPenis(true);
        doll.setPiercedTongue(true);
        doll.setPiercedVagina(true);
        doll.setName("\u88c5\u626e\u73a9\u5076");
        Main.game.setActiveNPC(doll);
    }

    public static GameCharacter getDoll() {
        if (dollID == null || !Main.game.isCharacterExisting(dollID)) {
            LilayaDressingRoomDialogue.initDressupDoll();
        }
        try {
            return Main.game.getNPCById(dollID);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void initOutfitsMenu() {
        if (Main.game.getCurrentDialogueNode() != OUTFITS) {
            deleteConfirmationName = "";
        }
        loadedOutfitsMap = new TreeMap<String, Outfit>();
        for (File f : LilayaDressingRoomDialogue.getSavedOutfits()) {
            try {
                String name = Util.getFileIdentifier(f);
                Outfit loadedOutfit = LilayaDressingRoomDialogue.loadOutfit(name);
                if (loadedOutfit.getGameCreationID() != Main.game.getId() && !outfitFilesFullVisibility) continue;
                loadedOutfitsMap.put(name, loadedOutfit);
            }
            catch (Exception exception) {}
        }
        LilayaDressingRoomDialogue.calculateOutfitAvailability();
    }

    public static List<File> getSavedOutfits() {
        File[] directoryListing;
        ArrayList<File> filesList = new ArrayList<File>();
        File dir = new File("data/outfits");
        if (dir.isDirectory() && (directoryListing = dir.listFiles((path, name) -> name.endsWith(".xml"))) != null) {
            filesList.addAll(Arrays.asList(directoryListing));
        }
        filesList.sort(Comparator.comparing(File::getName).reversed());
        return filesList;
    }

    private static String getOutfitListRow(String baseName, Outfit loadedOutfit, boolean altColour) {
        String fileName = baseName + ".xml";
        int availabilityCount = LilayaDressingRoomDialogue.getOutfitAvailabilityFromTile(loadedOutfit);
        int essenceCost = loadedOutfit.getEssenceCost();
        return "<div class='container-full-width" + (altColour ? " light" : "") + "' style='padding:0; margin:0 0 4px 0; position:relative;'><div class='container-full-width" + (altColour ? " light" : "") + " hover-enabled' id='LOADED_OUTFIT_" + baseName + "' style='width:90%; margin:0;'><div class='container-full-width' style='width:calc(10% - 8px); margin:0 0 0 8px; padding:0; background:transparent; position:relative; float:left;'><div class='inventoryImage' style='width:100%;'><div class='inventoryImage-content'>" + loadedOutfit.getIconSVG() + "</div><div class='overlay no-highlight' style='cursor:pointer;'></div></div></div><div style='width:calc(67.7% - 8px); padding:0; margin:0 0 0 8px; position:relative; float:left;'><h6 style='margin:0; padding:2px;'>" + (loadedOutfit.getGameCreationID() == Main.game.getId() ? "" : "[style.boldExcellent(*)]") + loadedOutfit.getName() + "</h6><p style='margin:0; padding:2px;'>[style.colourDisabled(data/outfits/)]" + baseName + "[style.colourDisabled(.xml)]</p></div><div style='width:calc(11.1% - 8px); padding:0; margin:0 0 0 8px; position:relative; text-align:center; float:left;'><p style='margin:0; padding:2px;'>" + availabilityCount + "</p></div><div style='width:calc(11.1% - 8px); padding:0; margin:0 0 0 8px; position:relative; text-align:center; float:left;'><p style='margin:0; padding:2px;'>[style.moneyFormat(" + loadedOutfit.getCost() + ", span)]</p>" + (essenceCost == 0 ? UtilText.formatAsEssencesUncoloured(essenceCost, "b", false) : UtilText.formatAsEssences(essenceCost, "b", false)) + "</div></div><div class='container-full-width' style='width:10%; margin:0; text-align:center; background:transparent;'>" + (fileName.equals(deleteConfirmationName) ? "<div class='square-button saveIcon' style='width:75%; margin:12.5%;' id='DELETE_OUTFIT_" + baseName + "'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskDeleteConfirm() + "</div></div>" : "<div class='square-button saveIcon' style='width:75%; margin:12.5%;' id='DELETE_OUTFIT_" + baseName + "'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskDelete() + "</div></div>") + "</div></div>";
    }

    public static void saveOutfit(String name, Outfit outfit, boolean allowOverwrite, DialogueNode dialogueNode) {
        File[] directoryListing;
        if ((name = Main.checkFileName(name)).isEmpty()) {
            return;
        }
        File dir = new File("data/");
        dir.mkdir();
        dir = new File("data/outfits");
        dir.mkdir();
        if (dir.isDirectory() && (directoryListing = dir.listFiles((path, filename) -> filename.endsWith(".xml"))) != null) {
            for (File child : directoryListing) {
                if (!child.getName().equals(name + ".xml") || allowOverwrite) continue;
                Main.game.flashMessage(PresetColour.GENERIC_BAD, "\u540d\u79f0\u5df2\u5b58\u5728\uff01");
                return;
            }
        }
        try {
            Document doc = Main.getDocBuilder().newDocument();
            Element element = doc.createElement("exportedOutfit");
            doc.appendChild(element);
            outfit.saveAsXML(element, doc);
            Transformer transformer1 = Main.transformerFactory.newTransformer();
            transformer1.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer1.transform(new DOMSource(doc), new StreamResult(writer));
            Transformer transformer = Main.transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(doc);
            String saveLocation = "data/outfits/" + name + ".xml";
            StreamResult result = new StreamResult(saveLocation);
            transformer.transform(source, result);
        }
        catch (TransformerException tfe) {
            tfe.printStackTrace();
        }
        if (dialogueNode != null) {
            Main.game.setContent(new Response("", "", dialogueNode));
        }
        Main.game.flashMessage(PresetColour.GENERIC_GOOD, "\u670d\u88c5\u5df2\u4fdd\u5b58\uff01");
    }

    public static Outfit loadOutfit(String name) {
        File file;
        if (LilayaDressingRoomDialogue.isLoadOutfitAvailable(name) && (file = new File("data/outfits/" + name + ".xml")).exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(file);
                doc.getDocumentElement().normalize();
                Element outerOutfitElement = (Element)doc.getElementsByTagName("exportedOutfit").item(0);
                Element outfitElement = (Element)outerOutfitElement.getElementsByTagName("outfit").item(0);
                loadedFileName = name;
                return Outfit.loadFromXML(outfitElement, doc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isLoadOutfitAvailable(String name) {
        File file = new File("data/outfits/" + name + ".xml");
        return file.exists();
    }

    public static String getOutfitSaveName() {
        return Main.checkFileName(activeOutfit.getName()).toLowerCase();
    }

    public static boolean isSaveOutfitAvailable(boolean allowOverwrite) {
        return LilayaDressingRoomDialogue.isSaveOutfitAvailable(LilayaDressingRoomDialogue.getOutfitSaveName(), allowOverwrite);
    }

    public static boolean isSaveOutfitAvailable(String saveName, boolean allowOverwrite) {
        File[] directoryListing;
        if (saveName.isEmpty()) {
            return false;
        }
        File dir = new File("data/");
        dir.mkdir();
        dir = new File("data/outfits");
        dir.mkdir();
        if (dir.isDirectory() && (directoryListing = dir.listFiles((path, filename) -> filename.endsWith(".xml"))) != null) {
            for (File child : directoryListing) {
                if (!child.getName().equals(saveName + ".xml") || allowOverwrite) continue;
                return false;
            }
        }
        return true;
    }

    public static void deleteOutfit(String name) {
        File file = new File("data/outfits/" + name + ".xml");
        if (file.exists()) {
            try {
                file.delete();
                Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            Main.game.flashMessage(PresetColour.GENERIC_BAD, "\u672a\u627e\u5230\u6587\u4ef6\u2026\u2026");
        }
    }

    public static Outfit getActiveOutfit() {
        return activeOutfit;
    }

    public static void setActiveOutfit(Outfit outfit) {
        activeOutfit = outfit;
    }

    public static void setOutfitName(String name) {
        activeOutfit.setName(name);
    }

    private static String getOutfitEquipTextRow(equipType type, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div style='margin:0; padding:0; width:20%; text-align:right; color:" + type.colour.toWebHexString() + "; float:left;'>");
        sb.append(type.name);
        sb.append("</div>");
        sb.append("<div style='margin:0; padding:0; width:60%; text-align:center; float:left;'>");
        sb.append(name);
        sb.append("</div>");
        sb.append("<div style='margin:0; padding:0; width:20%; text-align:left; float:left;'>");
        if (type.droppedOnFloor) {
            sb.append("([style.italics(\u4e22\u5728\u5730\u4e0a)])");
        }
        sb.append("</div>");
        return sb.toString();
    }

    private static String applyRowWrapper(String content, boolean alternateRow) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div class='container-full-width' style='background:" + RenderingEngine.getEntryBackgroundColour(alternateRow) + "; width:100%; margin:0;'>");
        sb.append(content);
        sb.append("</div>");
        return sb.toString();
    }

    private static String getInventoryEquippedPanel() {
        StringBuilder sb = new StringBuilder();
        String weaponStyle = "width:31%; margin:1%;";
        String piercingStyle = "width:40%; margin:5% 5%;";
        float piercingTopOffset = 7.5f;
        sb.append("<div class='container-full-width' style='width:" + (inventoryUIWidth - 5.0f) + "%; padding:0; margin:0 0 0 5%; float:left;'>");
        sb.append("<div class='container-full-width' style='width:" + mainClothingPanelWidth + "%; padding:0; margin:0;'>");
        for (InventorySlot invSlot : RenderingEngine.mainInventorySlots) {
            sb.append(LilayaDressingRoomDialogue.getClothingSlotDiv(invSlot, activeOutfit.getClothing().get((Object)invSlot), false));
        }
        sb.append("</div>");
        sb.append("<div class='container-full-width' style='width:" + (100.0f - mainClothingPanelWidth) + "%; padding:0; margin:0.5% 0 0 0;'>");
        AbstractWeapon mainWeapon1 = activeOutfit.getWeapons().get((Object)InventorySlot.WEAPON_MAIN_1);
        AbstractWeapon mainWeapon2 = activeOutfit.getWeapons().get((Object)InventorySlot.WEAPON_MAIN_2);
        AbstractWeapon mainWeapon3 = activeOutfit.getWeapons().get((Object)InventorySlot.WEAPON_MAIN_3);
        AbstractWeapon offhandWeapon1 = activeOutfit.getWeapons().get((Object)InventorySlot.WEAPON_OFFHAND_1);
        AbstractWeapon offhandWeapon2 = activeOutfit.getWeapons().get((Object)InventorySlot.WEAPON_OFFHAND_2);
        AbstractWeapon offhandWeapon3 = activeOutfit.getWeapons().get((Object)InventorySlot.WEAPON_OFFHAND_3);
        if (mainWeapon1 != null) {
            sb.append(LilayaDressingRoomDialogue.getWeaponDiv(mainWeapon1, InventorySlot.WEAPON_MAIN_1, weaponStyle));
        } else {
            sb.append(LilayaDressingRoomDialogue.getEmptyWeaponDiv(false, InventorySlot.WEAPON_MAIN_1, weaponStyle));
        }
        if (mainWeapon2 != null) {
            sb.append(LilayaDressingRoomDialogue.getWeaponDiv(mainWeapon2, InventorySlot.WEAPON_MAIN_2, weaponStyle));
        } else {
            sb.append(LilayaDressingRoomDialogue.getEmptyWeaponDiv(false, InventorySlot.WEAPON_MAIN_2, weaponStyle));
        }
        if (mainWeapon3 != null) {
            sb.append(LilayaDressingRoomDialogue.getWeaponDiv(mainWeapon3, InventorySlot.WEAPON_MAIN_3, weaponStyle));
        } else {
            sb.append(LilayaDressingRoomDialogue.getEmptyWeaponDiv(false, InventorySlot.WEAPON_MAIN_3, weaponStyle));
        }
        if (offhandWeapon1 != null) {
            sb.append(LilayaDressingRoomDialogue.getWeaponDiv(offhandWeapon1, InventorySlot.WEAPON_OFFHAND_1, weaponStyle));
        } else if (mainWeapon1 != null && mainWeapon1.getWeaponType().isTwoHanded()) {
            sb.append(LilayaDressingRoomDialogue.getEmptyWeaponDiv(true, InventorySlot.WEAPON_OFFHAND_1, weaponStyle));
        } else {
            sb.append(LilayaDressingRoomDialogue.getEmptyWeaponDiv(false, InventorySlot.WEAPON_OFFHAND_1, weaponStyle));
        }
        offhandWeapon2 = activeOutfit.getWeapons().get((Object)InventorySlot.WEAPON_OFFHAND_2);
        if (offhandWeapon2 != null) {
            sb.append(LilayaDressingRoomDialogue.getWeaponDiv(offhandWeapon2, InventorySlot.WEAPON_OFFHAND_2, weaponStyle));
        } else if (mainWeapon2 != null && mainWeapon2.getWeaponType().isTwoHanded()) {
            sb.append(LilayaDressingRoomDialogue.getEmptyWeaponDiv(true, InventorySlot.WEAPON_OFFHAND_2, weaponStyle));
        } else {
            sb.append(LilayaDressingRoomDialogue.getEmptyWeaponDiv(false, InventorySlot.WEAPON_OFFHAND_2, weaponStyle));
        }
        offhandWeapon3 = activeOutfit.getWeapons().get((Object)InventorySlot.WEAPON_OFFHAND_3);
        if (offhandWeapon3 != null) {
            sb.append(LilayaDressingRoomDialogue.getWeaponDiv(offhandWeapon3, InventorySlot.WEAPON_OFFHAND_3, weaponStyle));
        } else if (mainWeapon3 != null && mainWeapon3.getWeaponType().isTwoHanded()) {
            sb.append(LilayaDressingRoomDialogue.getEmptyWeaponDiv(true, InventorySlot.WEAPON_OFFHAND_3, weaponStyle));
        } else {
            sb.append(LilayaDressingRoomDialogue.getEmptyWeaponDiv(false, InventorySlot.WEAPON_OFFHAND_3, weaponStyle));
        }
        sb.append("<div class='container-full-width' style='width:100%; padding:0; margin:" + piercingTopOffset + "% 0 0 0;'>");
        for (InventorySlot invSlot : RenderingEngine.piercingSlots) {
            AbstractClothing clothing = activeOutfit.getClothing().get((Object)invSlot);
            if (clothing != null) {
                sb.append("<div class='inventory-item-slot " + LilayaDressingRoomDialogue.getClassRarityIdentifier(clothing.getRarity()) + "'" + (clothing.isSealed() ? "style='" + piercingStyle + " border-width:2px; border-color:" + PresetColour.SEALED.toWebHexString() + "; border-style:solid;'" : "style='" + piercingStyle + "'") + ">");
                sb.append("<div class='inventory-icon-content'>" + clothing.getSVGEquippedString(Main.game.getPlayer()) + "</div>");
                sb.append("<div class='item-price'>" + UtilText.formatAsItemPrice(clothing.getValue()) + "</div>");
                sb.append("<div class='overlay' id='outfit_select_slot_" + invSlot.toString() + "'></div>");
                sb.append(LilayaDressingRoomDialogue.getItemDeleteButton(invSlot, 14));
                sb.append("</div>");
                continue;
            }
            sb.append("<div class='inventory-item-slot' style='" + piercingStyle + "'>");
            if (activeOutfit.getIgnoredSlots().contains((Object)invSlot)) {
                sb.append("<div class='inventory-icon-content' style='opacity:0.25;'>" + SVGImages.SVG_IMAGE_PROVIDER.getDeniedIconDisabled() + "</div>");
            }
            sb.append("<div class='overlay' id='outfit_select_slot_" + invSlot.toString() + "'></div>");
            sb.append("</div>");
        }
        sb.append("</div>");
        sb.append("</div>");
        sb.append("<div class='container-full-width' style='width:100%; padding:0; margin:0;'>");
        for (InventorySlot invSlot : RenderingEngine.secondaryInventorySlots) {
            sb.append(LilayaDressingRoomDialogue.getClothingSlotDiv(invSlot, activeOutfit.getClothing().get((Object)invSlot), true));
        }
        sb.append("</div>");
        sb.append("</div>");
        return sb.toString();
    }

    public static boolean isSlotDisabled(InventorySlot invSlot) {
        String blockText = LilayaDressingRoomDialogue.getSlotDisabledText(invSlot);
        return blockText != null && !blockText.isEmpty();
    }

    public static String getSlotDisabledText(InventorySlot invSlot) {
        ArrayList<String> clothingBlockingThisSlot = new ArrayList<String>();
        for (AbstractClothing c : LilayaDressingRoomDialogue.getDoll().getClothingCurrentlyEquipped()) {
            if (!c.getIncompatibleSlots(LilayaDressingRoomDialogue.getDoll(), c.getSlotEquippedTo()).contains((Object)invSlot)) continue;
            clothingBlockingThisSlot.add(c.getName());
        }
        if (!clothingBlockingThisSlot.isEmpty()) {
            return "\u8be5\u680f\u4f4d\u76ee\u524d\u88ab" + Util.stringsToStringList(clothingBlockingThisSlot, false) + "<b style='color:" + PresetColour.SEALED.toWebHexString() + ";'>\u9501\u4f4f\u4e86</b>\u3002";
        }
        return "";
    }

    private static String getClothingSlotDiv(InventorySlot invSlot, AbstractClothing clothing, boolean isSecondary) {
        StringBuilder sb = new StringBuilder();
        String className = "inventory-item-slot";
        Object styleModifier = "width:23%; margin:1%; padding:0;";
        if (isSecondary) {
            className = "inventory-item-slot secondary";
            styleModifier = "width:" + (mainClothingPanelWidth / 4.0f - 1.5f) + "%; margin:0.75%; padding:0;";
        }
        if (clothing != null) {
            int essenceCost = LilayaDressingRoomDialogue.getClothingEssenceCost(clothing);
            sb.append("<div class='" + className + LilayaDressingRoomDialogue.getClassRarityIdentifier(clothing.getRarity()) + "'" + (clothing.isSealed() ? " style='border-width:2px; border-color:" + PresetColour.SEALED.toWebHexString() + "; border-style:solid;" + (String)styleModifier + "'" : " style='" + (String)styleModifier + "'") + ">");
            sb.append("<div class='inventory-icon-content'>" + clothing.getSVGEquippedString(Main.game.getPlayer()) + "</div>");
            if (essenceCost > 0) {
                sb.append("<div class='item-price' style='bottom:14px;'>" + (essenceCost == 0 ? UtilText.formatAsEssencesUncoloured(LilayaDressingRoomDialogue.getClothingEssenceCost(clothing), "b", false) : UtilText.formatAsEssences(LilayaDressingRoomDialogue.getClothingEssenceCost(clothing), "b", false)) + "</div>");
            }
            sb.append("<div class='item-price'>" + UtilText.formatAsItemPrice(clothing.getValue()) + "</div>");
            sb.append("<div class='overlay' id='outfit_select_slot_" + invSlot.toString() + "'></div>");
            sb.append(LilayaDressingRoomDialogue.getItemDeleteButton(invSlot));
            sb.append("</div>");
        } else {
            boolean disabled = LilayaDressingRoomDialogue.isSlotDisabled(invSlot);
            sb.append("<div class='" + className + (disabled ? " disabled" : "") + "' style='" + (String)styleModifier + "'>");
            if (activeOutfit.getIgnoredSlots().contains((Object)invSlot) && !disabled) {
                sb.append("<div class='inventory-icon-content' style='opacity:0.25;'>" + SVGImages.SVG_IMAGE_PROVIDER.getDeniedIconDisabled() + "</div>");
            }
            sb.append("<div class='overlay' id='outfit_select_slot_" + invSlot.toString() + "' style='" + (disabled ? "cursor:default;" : "") + "'></div>");
            sb.append("</div>");
        }
        return sb.toString();
    }

    public static int getClothingEssenceCost(AbstractClothing clothing) {
        int essenceCost = 0;
        for (ItemEffect ie : clothing.getEffects()) {
            if (LilayaDressingRoomDialogue.getDefaultEffects(clothing).contains(ie)) continue;
            essenceCost += EnchantingUtils.getModifierEffectCost(true, clothing, ie);
        }
        return essenceCost;
    }

    private static String getEmptyWeaponDiv(boolean disabled, InventorySlot slot, String weaponStyle) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div class='inventory-item-slot" + (disabled ? " disabled" : "") + "' " + (String)(disabled ? "id='outfit_select_slot_" + slot.toString() + "'" : "") + " style='" + weaponStyle + "'>");
        if (!disabled) {
            if (activeOutfit.getIgnoredSlots().contains((Object)slot)) {
                sb.append("<div class='inventory-icon-content' style='opacity:0.25;'>" + SVGImages.SVG_IMAGE_PROVIDER.getDeniedIconDisabled() + "</div>");
            } else {
                sb.append("<div class='inventory-icon-content' style='width:75%; margin:12.5%;'>" + SVGImages.SVG_IMAGE_PROVIDER.getFist() + "</div>");
            }
            sb.append("<div class='overlay' id='outfit_select_slot_" + slot.toString() + "'></div>");
        }
        sb.append("</div>");
        return sb.toString();
    }

    private static String getWeaponDiv(AbstractWeapon weapon, InventorySlot slot, String weaponStyle) {
        StringBuilder sb = new StringBuilder();
        String weaponCount = LilayaDressingRoomDialogue.getThrownWeaponCountDiv(weapon.getWeaponType());
        int essenceCost = LilayaDressingRoomDialogue.getWeaponEssenceCost(weapon);
        sb.append("<div class='inventory-item-slot" + LilayaDressingRoomDialogue.getClassRarityIdentifier(weapon.getRarity()) + "' style='" + weaponStyle + "'><div class='inventory-icon-content'>" + weapon.getSVGEquippedString(Main.game.getPlayer()) + "</div>");
        if (essenceCost > 0) {
            sb.append("<div class='item-price' style='bottom:14px;'>" + (essenceCost == 0 ? UtilText.formatAsEssencesUncoloured(LilayaDressingRoomDialogue.getWeaponEssenceCost(weapon), "b", false) : UtilText.formatAsEssences(LilayaDressingRoomDialogue.getWeaponEssenceCost(weapon), "b", false)) + "</div>");
        }
        sb.append("<div class='item-price'>" + UtilText.formatAsItemPrice(weapon.getValue()) + "</div><div class='overlay' id='outfit_select_slot_" + slot.toString() + "'>" + weaponCount + "</div>");
        sb.append(LilayaDressingRoomDialogue.getItemDeleteButton(slot, 14));
        sb.append("</div>");
        return sb.toString();
    }

    public static int getWeaponEssenceCost(AbstractWeapon weapon) {
        int essenceCost = 0;
        for (ItemEffect ie : weapon.getEffects()) {
            if (LilayaDressingRoomDialogue.getDefaultEffects(weapon).contains(ie)) continue;
            essenceCost += EnchantingUtils.getModifierEffectCost(true, weapon, ie);
        }
        return essenceCost;
    }

    private static String getItemDeleteButton(InventorySlot slot) {
        return LilayaDressingRoomDialogue.getItemDeleteButton(slot, 16);
    }

    private static String getItemDeleteButton(InventorySlot slot, int size) {
        StringBuilder sb = new StringBuilder();
        int sizeReduced = size / 3;
        sb.append("<div class='normal-button' id='clear_slot_" + slot.toString() + "'style='position:absolute; right:-" + sizeReduced + "px; top:-" + sizeReduced + "px; text-align:center; font-size:" + size + "px; line-height:" + size + "px; width:" + (size + 2) + "px;  padding:0; margin:0; color:" + PresetColour.GENERIC_BAD.toWebHexString() + "; border:1px solid " + PresetColour.BACKGROUND_DARK.toWebHexString() + ";'>");
        sb.append("X");
        sb.append("</div>");
        return sb.toString();
    }

    private static String getThrownWeaponCountDiv(AbstractWeaponType weaponType) {
        int amount = 10;
        if (!weaponType.isOneShot()) {
            return "";
        }
        return "<div class='item-count' " + (amount == 0 ? "style='opacity:0.5;'" : "") + ">+" + amount + "</div>";
    }

    private static String getClassRarityIdentifier(Rarity rarity) {
        return RenderingEngine.getClassRarityIdentifier(rarity);
    }

    public static InventorySlot getSelectedSlot() {
        return selectedSlot;
    }

    public static void setSelectedSlot(InventorySlot selectedSlot) {
        LilayaDressingRoomDialogue.selectedSlot = selectedSlot;
    }

    public static boolean initItemFromSlot() {
        if (selectedSlot.isWeapon()) {
            AbstractWeapon weapon = activeOutfit.getWeapons().get((Object)selectedSlot);
            if (weapon != null) {
                weaponSelected = weapon;
                return true;
            }
        } else {
            AbstractClothing clothing = activeOutfit.getClothing().get((Object)selectedSlot);
            if (clothing != null) {
                clothingSelected = clothing;
                return true;
            }
        }
        return false;
    }

    public static AbstractWeapon getWeaponSelected() {
        return weaponSelected;
    }

    public static void setWeaponSelected(AbstractWeaponType weaponType) {
        weaponSelected = Main.game.getItemGen().generateWeapon(weaponType);
    }

    public static AbstractClothing getClothingSelected() {
        return clothingSelected;
    }

    public static void setClothingSelected(AbstractClothingType clothingType) {
        clothingSelected = Main.game.getItemGen().generateClothing(clothingType, false);
    }

    public static AbstractCoreItem getSelectedItem() {
        if (weaponSelected != null) {
            return weaponSelected;
        }
        if (clothingSelected != null) {
            return clothingSelected;
        }
        return null;
    }

    public static void clearSlot() {
        activeOutfit.clearSlot(selectedSlot);
    }

    public static void ignoreSlot() {
        activeOutfit.addIgnoredSlot(selectedSlot);
    }

    private static String getClothingDyeUI() {
        ColourReplacement cr;
        InventorySlot slotEquippedTo = LilayaDressingRoomDialogue.getSelectedSlot();
        StringBuilder sb = new StringBuilder();
        sb.append("<div class='container-full-width'><div class='inventoryImage'><div class='inventoryImage-content'>" + clothingSelected.getClothingType().getSVGImage(slotEquippedTo, clothingSelected.getColours(), clothingSelected.getPattern(), clothingSelected.getPatternColours(), clothingSelected.getStickers()) + "</div></div>");
        sb.append("<h3 style='text-align:center;'><b>\u67d3\u8272\u5e76\u9884\u89c8</b></h3>");
        if (!clothingSelected.getClothingType().getStickers().isEmpty()) {
            StringBuilder stickerSB = new StringBuilder();
            boolean stickerFound = false;
            ArrayList<StickerCategory> orderedCategories = new ArrayList<StickerCategory>(clothingSelected.getClothingType().getStickers().keySet());
            Collections.sort(orderedCategories, (s1, s2) -> s1.getPriority() - s2.getPriority());
            for (StickerCategory cat : orderedCategories) {
                stickerSB.append("<div class='container-quarter-width' style='width:calc(75% - 16px); margin:0 8px; padding:0;'>");
                stickerSB.append("<div class='container-quarter-width' style='margin:0; padding-top:6px; width:20%;'>");
                stickerSB.append(Util.capitaliseSentence(cat.getName()) + ":");
                stickerSB.append("</div>");
                stickerSB.append("<div class='container-quarter-width' style='margin:0; padding:0; width:80%;'>");
                ArrayList orderedStickers = new ArrayList(clothingSelected.getClothingType().getStickers().get(cat));
                Collections.sort(orderedStickers, (s1, s2) -> s1.getPriority() - s2.getPriority());
                for (Sticker sticker : orderedStickers) {
                    String requirements = UtilText.parse(sticker.getUnavailabilityText(), new ParserTag[0]).trim();
                    if (!requirements.isEmpty() && !sticker.isShowDisabledButton()) continue;
                    boolean specialSticker = !sticker.getAvailabilityText().isEmpty() || !sticker.getTagsApplied().isEmpty() || !sticker.getTagsRemoved().isEmpty();
                    stickerFound = true;
                    String id = "ITEM_STICKER_" + cat.getId() + sticker.getId();
                    if (!requirements.isEmpty()) {
                        stickerSB.append("<div id='" + id + "' class='cosmetics-button disabled'><b style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>" + Util.capitaliseSentence(sticker.getName()) + (specialSticker ? "*" : "") + "</b></div>");
                        continue;
                    }
                    if (clothingSelected.getStickers().get(cat.getId()).equalsIgnoreCase(sticker.getId())) {
                        stickerSB.append("<div id='" + id + "' class='cosmetics-button active'><b style='color:" + sticker.getColourSelected().toWebHexString() + ";'>" + Util.capitaliseSentence(sticker.getName()) + (specialSticker ? "*" : "") + "</b></div>");
                        continue;
                    }
                    stickerSB.append("<div id='" + id + "' class='cosmetics-button'><span style='color:" + sticker.getColourDisabled().toWebHexString() + ";'>" + Util.capitaliseSentence(sticker.getName()) + (specialSticker ? "*" : "") + "</span></div>");
                }
                stickerSB.append("</div>");
                stickerSB.append("</div>");
                if (!stickerFound) continue;
                stickerFound = false;
                sb.append(stickerSB.toString());
                stickerSB = new StringBuilder();
            }
        }
        List<Colour> clothingColours = clothingSelected.getColours();
        for (int i = 0; i < clothingSelected.getClothingType().getColourReplacements().size(); ++i) {
            cr = clothingSelected.getClothingType().getColourReplacement(i);
            if (cr.getAllColours().isEmpty()) continue;
            sb.append("<div class='container-quarter-width' style='width:calc(75% - 16px);'>" + Util.capitaliseSentence(Util.intToPrimarySequence(i + 1)) + "\u989c\u8272" + (cr.isRecolouringAllowed() ? "" : " ([style.italicsBad(\u65e0\u6cd5\u66f4\u6539)])") + ":<br/>");
            for (Colour c : cr.getAllColours()) {
                sb.append("<div class='normal-button" + (clothingColours.size() > i && clothingColours.get(i) == c ? " selected" : "") + "' id='DYE_CLOTHING_" + i + "_" + c.getId() + "' style='width:auto; margin-right:4px; border-width:1px;" + (String)(cr.getDefaultColours().contains(c) ? "border-color:" + PresetColour.TEXT_GREY.toWebHexString() + ";" : "") + (String)(clothingColours.size() > i && clothingColours.get(i) == c ? " background-color:" + PresetColour.BASE_GREEN.getShades()[4] + ";" : "") + "'><div class='phone-item-colour' style='" + (c.isMetallic() ? "background: repeating-linear-gradient(135deg, " + c.toWebHexString() + ", " + c.getShades()[4] + " 10px);" : "background-color:" + c.toWebHexString() + ";") + "'></div></div>");
            }
            sb.append("</div>");
        }
        if (clothingSelected.getClothingType().isPatternAvailable()) {
            sb.append("<br/><div class='container-full-width'>\u82b1\u7eb9:<br/>");
            for (Pattern pattern : Pattern.getAllPatterns()) {
                if (clothingSelected.getPattern().equals(pattern.getId())) {
                    sb.append("<div class='cosmetics-button active'><b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>" + Util.capitaliseSentence(pattern.getNiceName()) + "</b></div>");
                    continue;
                }
                sb.append("<div id='ITEM_PATTERN_" + pattern.getId() + "' class='cosmetics-button'><span style='color:" + PresetColour.TRANSFORMATION_GENERIC.getShades()[0] + ";'>" + Util.capitaliseSentence(pattern.getNiceName()) + "</span></div>");
            }
            sb.append("</div>");
            for (int i = 0; i < clothingSelected.getClothingType().getPatternColourReplacements().size(); ++i) {
                cr = clothingSelected.getClothingType().getPatternColourReplacement(i);
                if (cr.getAllColours().isEmpty() || !Pattern.getPattern(clothingSelected.getPattern()).isRecolourAvailable(cr)) continue;
                sb.append("<div class='container-quarter-width' style='width:calc(75% - 16px);'>Pattern " + Util.capitaliseSentence(Util.intToPrimarySequence(i + 1)) + " \u989c\u8272:<br/>");
                for (Colour c : cr.getAllColours()) {
                    sb.append("<div class='normal-button" + (clothingSelected.getPatternColours().size() > i && clothingSelected.getPatternColours().get(i) == c ? " selected" : "") + "' id='DYE_CLOTHING_PATTERN_" + i + "_" + c.getId() + "' style='width:auto; margin-right:4px;" + (String)(clothingSelected.getPatternColours().size() > i && clothingSelected.getPatternColours().get(i) == c ? " background-color:" + PresetColour.BASE_GREEN.getShades()[4] + ";" : "") + "'><div class='phone-item-colour' style='" + (c.isMetallic() ? "background: repeating-linear-gradient(135deg, " + c.toWebHexString() + ", " + c.getShades()[4] + " 10px);" : "background-color:" + c.toWebHexString() + ";") + "'></div></div>");
                }
                sb.append("</div>");
            }
        }
        sb.append("</div>");
        return sb.toString();
    }

    private static String getWeaponDyeUI() {
        StringBuilder sb = new StringBuilder();
        sb.append("<div class='container-full-width'><div class='container-full-width' style='text-align:center; width:calc(25% - 16px); float:right;'><div class='inventoryImage' style='width:100%;'>" + (weaponSelected.getWeaponType().isEquippedSVGImageDifferent() ? "\u5df2\u5378\u4e0b" : "") + "<div class='inventoryImage-content'>" + weaponSelected.getSVGString() + "</div></div>" + (String)(weaponSelected.getWeaponType().isEquippedSVGImageDifferent() ? "<div class='inventoryImage' style='width:100%;'>\u5df2\u88c5\u5907<div class='inventoryImage-content'>" + weaponSelected.getSVGEquippedString(Main.game.getPlayer()) + "</div></div>" : "") + "</div><h3 style='text-align:center;'><b>\u67d3\u8272\u5e76\u9884\u89c8</b></h3>");
        sb.append("<div class='container-quarter-width' style='text-align:center;width:calc(75% - 16px);'><b>\u4f24\u5bb3\u7c7b\u578b:</b><br/>");
        for (DamageType dt : weaponSelected.getWeaponType().getAvailableDamageTypes()) {
            sb.append("<div class='normal-button" + (weaponSelected.getDamageType() == dt ? " selected" : "") + "' id='DAMAGE_TYPE_" + dt.toString() + "'style='width:20%; margin:0 2.5%; color:" + (weaponSelected.getDamageType() == dt ? dt.getColour().toWebHexString() : dt.getColour().getShades(8)[0]) + ";'>" + Util.capitaliseSentence(dt.getName()) + "</div>");
        }
        sb.append("</div>");
        boolean colourOptions = false;
        for (int i = 0; i < weaponSelected.getWeaponType().getColourReplacements(false).size(); ++i) {
            colourOptions = true;
            ColourReplacement cr = weaponSelected.getWeaponType().getColourReplacement(false, i);
            if (cr.getAllColours().isEmpty()) continue;
            sb.append("<div class='container-quarter-width' style='width:calc(75% - 16px);'>" + Util.capitaliseSentence(Util.intToPrimarySequence(i + 1)) + "\u989c\u8272" + (cr.isRecolouringAllowed() ? "" : " ([style.italicsBad(\u65e0\u6cd5\u66f4\u6539)])") + ":<br/>");
            for (Colour c : cr.getAllColours()) {
                sb.append("<div class='normal-button" + (weaponSelected.getColours().size() > i && weaponSelected.getColours().get(i) == c ? " selected" : "") + "' id='DYE_WEAPON_" + i + "_" + c.getId() + "' style='width:auto; margin-right:4px; border-width:1px;" + (String)(cr.getDefaultColours().contains(c) ? "border-color:" + PresetColour.TEXT_GREY.toWebHexString() + ";" : "") + (String)(weaponSelected.getColours().size() > i && weaponSelected.getColours().get(i) == c ? " background-color:" + PresetColour.BASE_GREEN.getShades()[4] + ";" : "") + "'><div class='phone-item-colour' style='" + (c.isMetallic() ? "background: repeating-linear-gradient(135deg, " + c.toWebHexString() + ", " + c.getShades()[4] + " 10px);" : "background-color:" + c.toWebHexString() + ";") + "'></div></div>");
            }
            sb.append("</div>");
        }
        if (!colourOptions) {
            sb.append("<div class='container-half-width' style='text-align:center;'>[style.colourDisabled(\u67d3\u8272\u9009\u9879\u5747\u4e0d\u53ef\u7528\u2026\u2026)]</div>");
        }
        sb.append("</div>");
        return sb.toString();
    }

    public static void initEnchantDialogue() {
        if (newlyCreatedWeapon) {
            LilayaDressingRoomDialogue.getSelectedItem().getEffects().clear();
            LilayaDressingRoomDialogue.getSelectedItem().getEffects().addAll(LilayaDressingRoomDialogue.getDefaultEffects(LilayaDressingRoomDialogue.getSelectedItem()));
        }
        effects.clear();
        LilayaDressingRoomDialogue.resetEnchantmentVariables();
        LilayaDressingRoomDialogue.initModifiers();
        LilayaDressingRoomDialogue.setOutputName(EnchantingUtils.getPotionName(LilayaDressingRoomDialogue.getSelectedItem(), effects));
    }

    public static List<ItemEffect> getEffects() {
        return effects;
    }

    public static List<ItemEffect> getDefaultEffects(AbstractCoreItem item) {
        ArrayList<ItemEffect> defaultEffects = new ArrayList<ItemEffect>();
        if (item instanceof AbstractClothing) {
            AbstractClothing selectedClothing = (AbstractClothing)item;
            defaultEffects = new ArrayList<ItemEffect>(selectedClothing.getClothingType().getEffects());
        } else if (item instanceof AbstractWeapon) {
            AbstractWeapon selectedWeapon = (AbstractWeapon)item;
            AbstractWeapon defaultWeapon = Main.game.getItemGen().generateWeapon(selectedWeapon.getWeaponType(), selectedWeapon.getDamageType());
            defaultEffects = new ArrayList<ItemEffect>(defaultWeapon.getEffects());
        }
        return defaultEffects;
    }

    public static List<ItemEffect> getEffectsPlusDefaults() {
        ArrayList<ItemEffect> effectsPlusDefaults = new ArrayList<ItemEffect>(LilayaDressingRoomDialogue.getDefaultEffects(LilayaDressingRoomDialogue.getSelectedItem()));
        for (ItemEffect ie : effects) {
            if (effectsPlusDefaults.contains(ie)) continue;
            effectsPlusDefaults.add(ie);
        }
        return effectsPlusDefaults;
    }

    public static TFModifier getPrimaryMod() {
        return primaryMod;
    }

    public static void setPrimaryMod(TFModifier primaryMod) {
        LilayaDressingRoomDialogue.primaryMod = primaryMod;
        if (Main.game.getCurrentDialogueNode().equals(OUTFIT_EDITOR_ITEM_ENCHANT)) {
            Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('output_name').value;");
            LilayaDressingRoomDialogue.setOutputName(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
        }
    }

    public static TFModifier getSecondaryMod() {
        return secondaryMod;
    }

    public static void setSecondaryMod(TFModifier secondaryMod) {
        LilayaDressingRoomDialogue.secondaryMod = secondaryMod;
        if (Main.game.getCurrentDialogueNode().equals(OUTFIT_EDITOR_ITEM_ENCHANT)) {
            Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('output_name').value;");
            LilayaDressingRoomDialogue.setOutputName(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
        }
    }

    public static TFPotency getPotency() {
        return potency;
    }

    public static void setPotency(TFPotency potency) {
        LilayaDressingRoomDialogue.potency = potency;
        if (Main.game.getCurrentDialogueNode().equals(OUTFIT_EDITOR_ITEM_ENCHANT)) {
            Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('output_name').value;");
            LilayaDressingRoomDialogue.setOutputName(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
        }
    }

    public static int getLimit() {
        return limit;
    }

    public static void setLimit(int limit) {
        LilayaDressingRoomDialogue.limit = limit;
        if (Main.game.getCurrentDialogueNode().equals(OUTFIT_EDITOR_ITEM_ENCHANT)) {
            Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('output_name').value;");
            LilayaDressingRoomDialogue.setOutputName(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
        }
    }

    public static String getOutputName() {
        return outputName;
    }

    public static void setOutputName(String outputName) {
        LilayaDressingRoomDialogue.outputName = outputName = outputName.replaceAll("\\[\\#(.*?)]", "");
    }

    public static void resetEnchantmentVariables() {
        primaryMod = TFModifier.NONE;
        secondaryMod = TFModifier.NONE;
        potency = TFPotency.MINOR_BOOST;
        limit = 0;
    }

    public static boolean addEffect(ItemEffect effect) {
        boolean defaultName = EnchantingUtils.getPotionName(LilayaDressingRoomDialogue.getSelectedItem(), LilayaDressingRoomDialogue.getEffects()).equalsIgnoreCase(LilayaDressingRoomDialogue.getOutputName());
        boolean added = false;
        if (effects.size() < LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentLimit() && (added = LilayaDressingRoomDialogue.getEffects().add(effect))) {
            if (defaultName) {
                LilayaDressingRoomDialogue.setOutputName(EnchantingUtils.getPotionName(LilayaDressingRoomDialogue.getSelectedItem(), LilayaDressingRoomDialogue.getEffects()));
            } else if (Main.game.getCurrentDialogueNode().equals(OUTFIT_EDITOR_ITEM_ENCHANT)) {
                Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('output_name').value;");
                LilayaDressingRoomDialogue.setOutputName(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
            }
        }
        return added;
    }

    public static boolean removeEffect(int index) {
        boolean defaultName = EnchantingUtils.getPotionName(LilayaDressingRoomDialogue.getSelectedItem(), LilayaDressingRoomDialogue.getEffects()).equalsIgnoreCase(LilayaDressingRoomDialogue.getOutputName());
        LilayaDressingRoomDialogue.getEffects().remove(index);
        if (defaultName) {
            LilayaDressingRoomDialogue.setOutputName(EnchantingUtils.getPotionName(LilayaDressingRoomDialogue.getSelectedItem(), LilayaDressingRoomDialogue.getEffects()));
        } else if (Main.game.getCurrentDialogueNode().equals(OUTFIT_EDITOR_ITEM_ENCHANT)) {
            Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('output_name').value;");
            LilayaDressingRoomDialogue.setOutputName(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
        }
        return true;
    }

    public static boolean removeEffect(ItemEffect effect) {
        boolean defaultName = EnchantingUtils.getPotionName(LilayaDressingRoomDialogue.getSelectedItem(), LilayaDressingRoomDialogue.getEffects()).equalsIgnoreCase(LilayaDressingRoomDialogue.getOutputName());
        boolean removed = LilayaDressingRoomDialogue.getEffects().remove(effect);
        if (removed) {
            if (defaultName) {
                LilayaDressingRoomDialogue.setOutputName(EnchantingUtils.getPotionName(LilayaDressingRoomDialogue.getSelectedItem(), LilayaDressingRoomDialogue.getEffects()));
            } else if (Main.game.getCurrentDialogueNode().equals(OUTFIT_EDITOR_ITEM_ENCHANT)) {
                Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('output_name').value;");
                LilayaDressingRoomDialogue.setOutputName(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
            }
        }
        return removed;
    }

    public static void initModifiers() {
        effects = new ArrayList<ItemEffect>(LilayaDressingRoomDialogue.getSelectedItem().getEffects());
        if (!LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentEffect().getPrimaryModifiers(LilayaDressingRoomDialogue.getSelectedItem()).contains((Object)primaryMod)) {
            primaryMod = LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentEffect().getPrimaryModifiers(LilayaDressingRoomDialogue.getSelectedItem()).get(0);
        }
        if (!LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentEffect().getSecondaryModifiers(LilayaDressingRoomDialogue.getSelectedItem(), primaryMod).contains((Object)secondaryMod)) {
            secondaryMod = LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentEffect().getSecondaryModifiers(LilayaDressingRoomDialogue.getSelectedItem(), primaryMod).get(0);
        }
        if (!LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentEffect().getPotencyModifiers(primaryMod, secondaryMod).contains((Object)potency)) {
            potency = TFPotency.MINOR_BOOST;
        }
        if (limit <= LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentEffect().getLimits(primaryMod, secondaryMod)) {
            limit = LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentEffect().getLimits(primaryMod, secondaryMod);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String getEnchantmentUI() {
        void var6_24;
        StringBuilder inventorySB = new StringBuilder();
        ItemEffect effect = LilayaDressingRoomDialogue.getCurrentEffect();
        int displaySlots = Math.max(32, 8 * (int)Math.ceil((float)Math.max(LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentEffect().getPrimaryModifiers(LilayaDressingRoomDialogue.getSelectedItem()).size(), LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentEffect().getSecondaryModifiers(LilayaDressingRoomDialogue.getSelectedItem(), primaryMod).size()) / 8.0f));
        inventorySB.append("<div class='container-half-width' style='padding-bottom:0;'>");
        for (TFModifier tfMod : LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentEffect().getPrimaryModifiers(LilayaDressingRoomDialogue.getSelectedItem())) {
            inventorySB.append("<div class='modifier-icon' style='width:11.5%; background-color:" + tfMod.getRarity().getBackgroundColour().toWebHexString() + ";'><div class='modifier-icon-content'>" + tfMod.getSVGString() + "</div><div class='overlay' id='MOD_PRIMARY_" + tfMod.hashCode() + "'></div></div>");
        }
        for (int i = displaySlots; i > LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentEffect().getPrimaryModifiers(LilayaDressingRoomDialogue.getSelectedItem()).size(); --i) {
            inventorySB.append("<div class='modifier-icon empty' style='width:11.5%;'></div>");
        }
        inventorySB.append("<div class='container-full-width'><div class='container-half-width' style='width:78%; margin:0 1%; text-align:center; line-height:100vh;'><h5 style='margin:0; padding:0;'>\u9996\u8981\u4fee\u9970\u8bcd</h5></div><div class='container-half-width' style='width:18%; margin:0 1%;'>");
        if (primaryMod != null) {
            inventorySB.append("<div class='modifier-icon' style='width:100%; margin:0;background-color:" + primaryMod.getRarity().getBackgroundColour().toWebHexString() + ";'><div class='modifier-icon-content'>" + primaryMod.getSVGString() + "</div><div class='overlay' id='MOD_PRIMARY_ENCHANTING'></div></div>");
        } else {
            inventorySB.append("<div class='modifier-icon empty' style='width:30%; margin:0 1%;'><div class='overlay' style='cursor:default;' id='MOD_PRIMARY_ENCHANTING'></div></div>");
        }
        inventorySB.append("</div></div>");
        inventorySB.append("</div>");
        inventorySB.append("<div class='container-half-width' style='padding-bottom:0;'>");
        for (TFModifier tfMod : LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentEffect().getSecondaryModifiers(LilayaDressingRoomDialogue.getSelectedItem(), primaryMod)) {
            inventorySB.append("<div class='modifier-icon' style='width:11.5%; background-color:" + tfMod.getRarity().getBackgroundColour().toWebHexString() + ";'><div class='modifier-icon-content'>" + tfMod.getSVGString() + "</div><div class='overlay' id='MOD_SECONDARY_" + tfMod.hashCode() + "'></div></div>");
        }
        for (int i = displaySlots; i > LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentEffect().getSecondaryModifiers(LilayaDressingRoomDialogue.getSelectedItem(), primaryMod).size(); --i) {
            inventorySB.append("<div class='modifier-icon empty' style='width:11.5%;'></div>");
        }
        inventorySB.append("<div class='container-full-width'><div class='container-half-width' style='width:18%; margin:0 1%;'>");
        if (secondaryMod != null) {
            inventorySB.append("<div class='modifier-icon' style='width:100%; margin:0; background-color:" + secondaryMod.getRarity().getBackgroundColour().toWebHexString() + ";'><div class='modifier-icon-content'>" + secondaryMod.getSVGString() + "</div><div class='overlay' id='MOD_SECONDARY_ENCHANTING'></div></div>");
        } else {
            inventorySB.append("<div class='modifier-icon empty' style='width:30%; margin:0 1%;'><div class='overlay' style='cursor:default;' id='MOD_SECONDARY_ENCHANTING'></div></div>");
        }
        inventorySB.append("</div><div class='container-half-width' style='width:78%; margin:0 1%; text-align:center; line-height:100vh;'><h5 style='margin:0; padding:0;'>\u6b21\u8981\u4fee\u9970\u8bcd</h5></div></div>");
        inventorySB.append("</div>");
        inventorySB.append("<div class='container-full-width' style='text-align:center; padding:8px 0; margin-top:0;'>");
        for (TFPotency potency : TFPotency.getAllPotencies()) {
            inventorySB.append("<div class='normal-button" + (LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentEffect().getPotencyModifiers(primaryMod, secondaryMod).contains((Object)potency) ? "" : " disabled") + (LilayaDressingRoomDialogue.potency == potency ? " selected" : "") + "' id='POTENCY_" + String.valueOf((Object)potency) + "' style='" + (String)(LilayaDressingRoomDialogue.potency == potency ? "color:" + potency.getColour().toWebHexString() + ";" : "") + " margin:0 1%; width:14%;'>" + potency.getName() + "</div>");
        }
        inventorySB.append("</div>");
        int ingredientLimit = LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentEffect().getLimits(primaryMod, secondaryMod);
        if (ingredientLimit != 0) {
            inventorySB.append("<div class='container-full-width' style='text-align:center; padding:8px 0; margin-top:0;'><div style='float:left; width:14.6%; margin:0 1%; padding:0;'><div class='normal-button" + (limit == 0 ? " disabled" : "") + "' id='LIMIT_MINIMUM' style='width:100%;'>\u6700\u4f4e\u6781\u9650</div></div><div style='float:left; width:14.6%; margin:0 1%; padding:0;'><div class='normal-button" + (limit == 0 ? " disabled" : "") + "' id='LIMIT_DECREASE_LARGE' style='width:100%;'>\u6781\u9650--</div></div><div style='float:left; width:14.6%; margin:0 1%; padding:0;'><div class='normal-button" + (limit == 0 ? " disabled" : "") + "' id='LIMIT_DECREASE' style='width:100%;'>\u6781\u9650-</div></div><div style='float:left; width:14.6%; margin:0 1%; padding:0;'><div class='normal-button" + (limit == ingredientLimit ? " disabled" : "") + "' id='LIMIT_INCREASE' style='width:100%;'>\u6781\u9650+</div></div><div style='float:left; width:14.6%; margin:0 1%; padding:0;'><div class='normal-button" + (limit == ingredientLimit ? " disabled" : "") + "' id='LIMIT_INCREASE_LARGE' style='width:100%;'>\u6781\u9650++</div></div><div style='float:left; width:14.6%; margin:0 1%; padding:0;'><div class='normal-button" + (limit == ingredientLimit ? " disabled" : "") + "' id='LIMIT_MAXIMUM' style='width:100%;'>\u6700\u9ad8\u6781\u9650</div></div></div>");
        }
        inventorySB.append("<div class='container-full-width' style='text-align:center; padding:8px 0; margin-top:0;'>");
        inventorySB.append("<div class='container-half-width' style='width:28%; margin:0 1%;'><b style='color:" + PresetColour.GENERIC_ARCANE.toWebHexString() + ";'>\u8981\u6dfb\u52a0\u7684\u6548\u679c\uff1a</b></div>");
        inventorySB.append("<div class='container-half-width' style='width:48%; margin:0 1%;'>");
        if (effect.getEffectsDescription(Main.game.getPlayer(), Main.game.getPlayer()) != null) {
            int i = 0;
            for (String string : effect.getEffectsDescription(Main.game.getPlayer(), Main.game.getPlayer())) {
                if (i > 0) {
                    inventorySB.append("<br/>");
                }
                inventorySB.append("<b>" + Util.capitaliseSentence(string) + "</b>");
                ++i;
            }
        } else {
            inventorySB.append("<b>-</b>");
        }
        if (Main.game.isEnchantmentCapacityEnabled() && (LilayaDressingRoomDialogue.getSelectedItem() instanceof AbstractClothing || LilayaDressingRoomDialogue.getSelectedItem() instanceof AbstractWeapon || LilayaDressingRoomDialogue.getSelectedItem() instanceof Tattoo) && (effect.getItemEffectType() == ItemEffectType.CLOTHING || effect.getItemEffectType() == ItemEffectType.WEAPON || effect.getItemEffectType() == ItemEffectType.TATTOO) && (effect.getPrimaryModifier() == TFModifier.CLOTHING_ATTRIBUTE || effect.getPrimaryModifier() == TFModifier.CLOTHING_MAJOR_ATTRIBUTE)) {
            int cost = Math.max(0, effect.getPotency().getClothingBonusValue());
            if (effect.getSecondaryModifier() == TFModifier.FERTILITY || effect.getSecondaryModifier() == TFModifier.VIRILITY) {
                cost = 0;
            } else if (effect.getSecondaryModifier() == TFModifier.CORRUPTION) {
                cost = effect.getPotency().isNegative() ? Math.abs(effect.getPotency().getClothingBonusValue()) : 0;
            }
            inventorySB.append("<br/>" + (cost > 0 ? "[style.colourEnchantment(" + Util.capitaliseSentence(Attribute.ENCHANTMENT_LIMIT.getName()) + ")]\uff1a" + UtilText.formatAsEnchantmentCapacity(cost, "b") : Util.capitaliseSentence(Attribute.ENCHANTMENT_LIMIT.getName()) + "\uff1a[style.colourDisabled(" + UtilText.formatAsEnchantmentCapacityUncoloured(cost, "b") + ")]"));
        }
        inventorySB.append("</div>");
        inventorySB.append("<div class='container-half-width' style='width:18%; margin:0 1%;'>");
        if (effects.size() >= LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentLimit() || LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentEffect().getEffectsDescription(primaryMod, secondaryMod, potency, limit, Main.game.getPlayer(), Main.game.getPlayer()) == null || LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentEffect().getEffectsDescription(primaryMod, secondaryMod, potency, limit, Main.game.getPlayer(), Main.game.getPlayer()).isEmpty() || LilayaDressingRoomDialogue.getEnchantmentEffectBlockedReason(effect) != null) {
            inventorySB.append("<div class='normal-button disabled' style='width:100%; margin:auto 0;'><b>\u6dfb\u52a0</b>| " + (LilayaDressingRoomDialogue.getSelectedItem() instanceof Tattoo ? UtilText.formatAsMoneyUncoloured(EnchantingUtils.getModifierEffectCost(true, LilayaDressingRoomDialogue.getSelectedItem(), effect) * 500, "b") : UtilText.formatAsEssencesUncoloured(EnchantingUtils.getModifierEffectCost(true, LilayaDressingRoomDialogue.getSelectedItem(), effect), "b", false)) + "<div class='overlay no-pointer' id='ENCHANT_ADD_BUTTON_DISABLED'></div></div>");
        } else {
            inventorySB.append("<div class='normal-button' style='width:100%; margin:auto 0;'><b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u6dfb\u52a0</b>| " + (LilayaDressingRoomDialogue.getSelectedItem() instanceof Tattoo ? UtilText.formatAsMoney(EnchantingUtils.getModifierEffectCost(true, LilayaDressingRoomDialogue.getSelectedItem(), effect) * 500, "b") : UtilText.formatAsEssences(EnchantingUtils.getModifierEffectCost(true, LilayaDressingRoomDialogue.getSelectedItem(), effect), "b", false)) + "<div class='overlay' id='ENCHANT_ADD_BUTTON'></div></div>");
        }
        inventorySB.append("</div>");
        inventorySB.append("</div>");
        inventorySB.append("<div class='container-full-width' style='text-align:center; padding:8px 0; margin-top:0;'>");
        inventorySB.append("<div class='container-half-width' style='width:18%; margin:0 1%; text-align:center;'>");
        inventorySB.append("<b>\u8f93\u5165</b><div class='enchanting-ingredient' style='background-color:" + LilayaDressingRoomDialogue.getSelectedItem().getRarity().getBackgroundColour().toWebHexString() + ";'><div class='enchanting-ingredient-content'>" + LilayaDressingRoomDialogue.getSelectedItem().getSVGString() + "</div><div class='overlay' id='INGREDIENT_ENCHANTING'  style='cursor:default;'></div></div>");
        inventorySB.append("</div>");
        inventorySB.append("<div class='container-half-width' style='width:58%; margin:0 1%;'>");
        inventorySB.append("<form style='padding:0; margin:0 0 4px 0; float:left; width:90%; text-align:center;'>");
        inventorySB.append("<input type='text' id='output_name' value='" + UtilText.parseForHTMLDisplay(outputName) + "' style='padding:0;margin:0;width:100%;text-align:center;'>");
        inventorySB.append("</form>");
        inventorySB.append("<div class='normal-button' id='apply_enchanted_item_name' style='float:left; width:9.5%; height:22px; line-height:22px; margin:0 0 0 0.5%; padding:0; text-align:center;'>");
        inventorySB.append("&#10003;");
        inventorySB.append("</div>");
        List<ItemEffect> defaultEffects = LilayaDressingRoomDialogue.getDefaultEffects(LilayaDressingRoomDialogue.getSelectedItem());
        int totalCost = 0;
        for (ItemEffect ie : effects) {
            if (defaultEffects.contains(ie)) continue;
            totalCost += EnchantingUtils.getModifierEffectCost(true, LilayaDressingRoomDialogue.getSelectedItem(), ie);
        }
        inventorySB.append("<b>\u6548\u679c(</b>" + (String)(effects.size() >= LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentLimit() ? "<b style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>" : "<b>") + effects.size() + "/" + LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentLimit() + "</b><b>)</b>| \u603b\u6210\u672c\uff1a" + (LilayaDressingRoomDialogue.getSelectedItem() instanceof Tattoo ? UtilText.formatAsMoney(EnchantingUtils.getCost(LilayaDressingRoomDialogue.getSelectedItem(), effects) * 500, "b") : UtilText.formatAsEssences(totalCost, "b", false)));
        if (effects.isEmpty()) {
            inventorySB.append("<br/><span style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>\u65e0\u6548\u679c\u6dfb\u52a0</span>");
        } else {
            if (!Collections.disjoint(effects, defaultEffects)) {
                inventorySB.append("<br/>[style.italicsMinorGood(\u9ed8\u8ba4\u6548\u679c\u7531" + UtilText.getEssenceSymbol(PresetColour.TEXT_GREY) + "[style.boldDisabled('D')]\u6807\u8bb0\uff0c\u4e14\u514d\u8d39\u63d0\u4f9b\u3002)]");
            }
            boolean bl = false;
            int it = 0;
            for (ItemEffect ie : effects) {
                boolean isDefaultEffect = defaultEffects.contains(ie);
                if (!(ie.getItemEffectType() != ItemEffectType.CLOTHING && ie.getItemEffectType() != ItemEffectType.WEAPON && ie.getItemEffectType() != ItemEffectType.TATTOO || ie.getPrimaryModifier() != TFModifier.CLOTHING_ATTRIBUTE && ie.getPrimaryModifier() != TFModifier.CLOTHING_MAJOR_ATTRIBUTE)) {
                    if (ie.getSecondaryModifier() == TFModifier.FERTILITY || ie.getSecondaryModifier() == TFModifier.VIRILITY) {
                        var6_18 += 0;
                    } else if (ie.getSecondaryModifier() == TFModifier.CORRUPTION) {
                        if (ie.getPotency().isNegative()) {
                            var6_18 += Math.abs(ie.getPotency().getClothingBonusValue());
                        }
                    } else {
                        var6_18 += Math.max(0, ie.getPotency().getClothingBonusValue());
                    }
                }
                int i = 0;
                for (String s : ie.getEffectsDescription(Main.game.getPlayer(), Main.game.getPlayer())) {
                    inventorySB.append("<div class='container-full-width' style='background:" + RenderingEngine.getEntryBackgroundColour(it % 2 == 0) + "; width:98%; margin:0 1%; padding:0;'>");
                    inventorySB.append("<div style='width:calc(100% - 94px); line-height:17px; margin:0; padding:0; float:left;'>");
                    inventorySB.append(Util.capitaliseSentence(s));
                    inventorySB.append("</div>");
                    if (i == 0) {
                        inventorySB.append("<div style='width:64px; line-height:17px; margin:0; padding:0 0 0 4px; float:left;'>");
                        int essenceCost = EnchantingUtils.getModifierEffectCost(true, LilayaDressingRoomDialogue.getSelectedItem(), ie);
                        if (isDefaultEffect) {
                            essenceCost = effects.contains(ie) ? 0 : EnchantingUtils.getModifierEffectCost(false, LilayaDressingRoomDialogue.getSelectedItem(), ie);
                        }
                        if (essenceCost == 0) {
                            if (isDefaultEffect) {
                                inventorySB.append(UtilText.getEssenceSymbol(PresetColour.TEXT_GREY));
                                inventorySB.append("[style.boldDisabled(D)]");
                            } else {
                                inventorySB.append(UtilText.formatAsEssencesUncoloured(essenceCost, "b", false));
                            }
                        } else {
                            inventorySB.append(UtilText.formatAsEssences(essenceCost, "b", false));
                        }
                        inventorySB.append("</div>");
                        inventorySB.append("<div class='normal-button' style='width:17px; height:17px; line-height:17px; font-size:14px; margin:0; padding:0 0 0 4px; float:left; text-align:left;'><b style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>X</b><div class='overlay' id='DELETE_EFFECT_" + it + "'></div></div>");
                    }
                    inventorySB.append("</div>");
                    ++i;
                }
                ++it;
            }
            if (Main.game.isEnchantmentCapacityEnabled() && (LilayaDressingRoomDialogue.getSelectedItem() instanceof AbstractClothing || LilayaDressingRoomDialogue.getSelectedItem() instanceof AbstractWeapon || LilayaDressingRoomDialogue.getSelectedItem() instanceof Tattoo)) {
                void var6_18;
                inventorySB.append("<br/>" + (var6_18 > 0 ? "[style.colourEnchantment(" + Util.capitaliseSentence(Attribute.ENCHANTMENT_LIMIT.getName()) + ")]\uff1a" + UtilText.formatAsEnchantmentCapacity((int)var6_18, "b") : Util.capitaliseSentence(Attribute.ENCHANTMENT_LIMIT.getName()) + "\uff1a[style.colourDisabled(" + UtilText.formatAsEnchantmentCapacityUncoloured((int)var6_18, "b") + ")]"));
            }
        }
        inventorySB.append("</div>");
        Object var6_19 = null;
        if (LilayaDressingRoomDialogue.getSelectedItem() instanceof AbstractItem) {
            AbstractItem abstractItem = EnchantingUtils.craftItem(LilayaDressingRoomDialogue.getSelectedItem(), LilayaDressingRoomDialogue.getEffects());
        } else if (LilayaDressingRoomDialogue.getSelectedItem() instanceof AbstractClothing) {
            AbstractClothing abstractClothing = EnchantingUtils.craftClothing(LilayaDressingRoomDialogue.getSelectedItem(), LilayaDressingRoomDialogue.getEffects());
        } else if (LilayaDressingRoomDialogue.getSelectedItem() instanceof AbstractWeapon) {
            AbstractWeapon abstractWeapon = EnchantingUtils.craftWeapon(LilayaDressingRoomDialogue.getSelectedItem(), LilayaDressingRoomDialogue.getEffects());
        } else if (LilayaDressingRoomDialogue.getSelectedItem() instanceof Tattoo) {
            Tattoo tattoo = EnchantingUtils.craftTattoo(LilayaDressingRoomDialogue.getSelectedItem(), LilayaDressingRoomDialogue.getEffects());
        }
        if (var6_24 != null) {
            inventorySB.append("<div class='container-half-width' style='width:18%; margin:0 1%; text-align:center;'>");
            inventorySB.append("<b>\u7ed3\u679c</b>");
            inventorySB.append("<div class='enchanting-ingredient' style='background-color:" + var6_24.getRarity().getBackgroundColour().toWebHexString() + ";'>");
            inventorySB.append("<div class='enchanting-ingredient-content'>" + var6_24.getSVGString() + "</div>");
            inventorySB.append("<div class='overlay' id='OUTPUT_ENCHANTING' style='cursor:default;'></div>");
            inventorySB.append("</div>");
            inventorySB.append("</div>");
        }
        inventorySB.append("</div>");
        inventorySB.append("<p id='hiddenPField' style='display:none;'></p>");
        return inventorySB.toString();
    }

    public static ItemEffect getCurrentEffect() {
        return new ItemEffect(LilayaDressingRoomDialogue.getSelectedItem().getEnchantmentEffect(), primaryMod, secondaryMod, potency, limit);
    }

    public static String getEnchantmentEffectBlockedReason(ItemEffect effect) {
        if (LilayaDressingRoomDialogue.getSelectedItem() instanceof AbstractClothing && effect.getSecondaryModifier() == TFModifier.CLOTHING_VIBRATION) {
            for (ItemEffect ie : effects) {
                if (ie.getSecondaryModifier() != TFModifier.CLOTHING_VIBRATION) continue;
                return "\u4e00\u4ef6\u8863\u670d\u53ea\u80fd\u6dfb\u52a0\u4e00\u4e2a\u201c\u9707\u52a8\u201d\u6548\u679c\uff01";
            }
        }
        return null;
    }

    public static void calculateOutfitAvailability() {
        loadedOutfitsAvailabilityFromTile = new HashMap<Outfit, Integer>();
        for (Map.Entry<String, Outfit> entry : loadedOutfitsMap.entrySet()) {
            loadedOutfitsAvailabilityFromTile.put(entry.getValue(), LilayaDressingRoomDialogue.getOutfitAvailabilityCount(entry.getValue()));
        }
    }

    private static int getOutfitAvailabilityCount(Outfit outfit) {
        HashMap outfitToWeaponToRequirementMap = new HashMap();
        HashMap outfitToClothingToRequirementMap = new HashMap();
        outfitToWeaponToRequirementMap.put(outfit, new HashMap());
        outfitToClothingToRequirementMap.put(outfit, new HashMap());
        for (Map.Entry<InventorySlot, AbstractWeapon> entry : outfit.getWeapons().entrySet()) {
            ((Map)outfitToWeaponToRequirementMap.get(outfit)).putIfAbsent(entry.getValue(), 0);
            ((Map)outfitToWeaponToRequirementMap.get(outfit)).put(entry.getValue(), (Integer)((Map)outfitToWeaponToRequirementMap.get(outfit)).get(entry.getValue()) + 1);
        }
        for (Map.Entry<InventorySlot, AbstractCoreItem> entry : outfit.getClothing().entrySet()) {
            ((Map)outfitToClothingToRequirementMap.get(outfit)).putIfAbsent((AbstractClothing)entry.getValue(), 0);
            ((Map)outfitToClothingToRequirementMap.get(outfit)).put((AbstractClothing)entry.getValue(), (Integer)((Map)outfitToClothingToRequirementMap.get(outfit)).get(entry.getValue()) + 1);
        }
        int minimumOutfitsCompleted = 9999;
        for (Map.Entry weaponRequirementEntry : ((Map)outfitToWeaponToRequirementMap.get(outfit)).entrySet()) {
            int maximumOutfitsFromThisWeapon = 0;
            for (Map.Entry<AbstractWeapon, Integer> entry : Main.game.getPlayerCell().getInventory().getAllWeaponsInInventory().entrySet()) {
                if (!entry.getKey().equals(weaponRequirementEntry.getKey())) continue;
                maximumOutfitsFromThisWeapon = entry.getValue() / (Integer)weaponRequirementEntry.getValue();
            }
            if (maximumOutfitsFromThisWeapon < minimumOutfitsCompleted) {
                minimumOutfitsCompleted = maximumOutfitsFromThisWeapon;
            }
            if (maximumOutfitsFromThisWeapon != 0) continue;
            break;
        }
        for (Map.Entry clothingRequirementEntry : ((Map)outfitToClothingToRequirementMap.get(outfit)).entrySet()) {
            int maximumOutfitsFromThisClothing = 0;
            for (Map.Entry<AbstractCoreItem, Integer> entry : Main.game.getPlayerCell().getInventory().getAllClothingInInventory().entrySet()) {
                if (!((AbstractClothing)entry.getKey()).equals(clothingRequirementEntry.getKey())) continue;
                maximumOutfitsFromThisClothing = entry.getValue() / (Integer)clothingRequirementEntry.getValue();
            }
            if (maximumOutfitsFromThisClothing < minimumOutfitsCompleted) {
                minimumOutfitsCompleted = maximumOutfitsFromThisClothing;
            }
            if (maximumOutfitsFromThisClothing != 0) continue;
            break;
        }
        return minimumOutfitsCompleted;
    }

    public static int getOutfitAvailabilityFromTile(Outfit outfit) {
        if (!loadedOutfitsAvailabilityFromTile.containsKey(outfit)) {
            return LilayaDressingRoomDialogue.getOutfitAvailabilityCount(outfit);
        }
        try {
            return loadedOutfitsAvailabilityFromTile.get(outfit);
        }
        catch (Exception ex) {
            System.out.println(outfit.getName());
            ex.printStackTrace();
            return -1;
        }
    }

    static {
        outfitFilesFullVisibility = false;
        outfitObtainedViaPurchase = false;
        newlyCreatedWeapon = false;
        ROOM_DRESSING_ROOM = new DialogueNode("\u66f4\u8863\u5ba4", "", false){

            @Override
            public int getSecondsPassed() {
                return 10;
            }

            @Override
            public String getLabel() {
                return Main.game.getPlayer().getLocationPlace().getName();
            }

            @Override
            public String getContent() {
                StringBuilder sb = new StringBuilder();
                sb.append(LilayaHomeGeneric.getBaseRoomDescription());
                sb.append("<p><b style='color:" + PlaceUpgrade.LILAYA_DRESSING_ROOM.getColour().toWebHexString() + ";'>" + PlaceUpgrade.LILAYA_DRESSING_ROOM.getName() + "</b><br/>" + PlaceUpgrade.LILAYA_DRESSING_ROOM.getRoomDescription(Main.game.getPlayerCell()) + "</p>");
                for (AbstractPlaceUpgrade up : Main.game.getPlayerCell().getPlace().getPlaceUpgrades()) {
                    if (up.isCoreRoomUpgrade()) continue;
                    sb.append("<p><b style='color:" + up.getColour().toWebHexString() + ";'>" + up.getName() + "</b><br/>" + up.getRoomDescription(Main.game.getPlayerCell()) + "</p>");
                }
                return sb.toString();
            }

            @Override
            public String getResponseTabTitle(int index) {
                return LilayaHomeGeneric.getLilayasHouseStandardResponseTabs(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (responseTab == 1) {
                    return LilayaHomeGeneric.getLilayasHouseFastTravelResponses(index);
                }
                List<NPC> charactersPresent = LilayaHomeGeneric.getSlavesAndOccupantsPresent();
                ArrayList<NPC> slavesAssignedToRoom = new ArrayList<NPC>();
                slavesAssignedToRoom.addAll(charactersPresent);
                if (index == 0) {
                    return null;
                }
                if (index == 1) {
                    if (Main.game.getPlayer().isAbleToAccessRoomManagement()) {
                        return new Response("\u7ba1\u7406\u623f\u95f4", "\u8fdb\u5165\u8be5\u623f\u95f4\u7684\u7ba1\u7406\u754c\u9762\u3002", OccupantManagementDialogue.ROOM_UPGRADES){

                            @Override
                            public void effects() {
                                OccupantManagementDialogue.cellToInspect = Main.game.getPlayerCell();
                            }
                        };
                    }
                    return new Response("\u7ba1\u7406\u623f\u95f4", "\u5728\u8fdb\u5165\u8be5\u754c\u9762\u524d\uff0c\u4f60\u9700\u8981\u83b7\u5f97\u8d29\u5974\u8bb8\u53ef\uff1b\u8389\u83b1\u96c5\u8981\u662f\u5141\u8bb8\u4f60\u5e26\u4eba\u6216\u73a9\u5076\u4f4f\u4e0b\u7684\u8bdd\u90a3\u4e5f\u884c\u3002", null);
                }
                if (index == 2) {
                    if (Main.game.getPlayer().isAbleToAccessRoomManagement()) {
                        return new Response("\u4eba\u5458\u7ba1\u7406", "\u8fdb\u5165\u5974\u96b6\u548c\u53cb\u4eba\u4f4f\u5ba2\u7684\u7ba1\u7406\u754c\u9762\u3002", OccupantManagementDialogue.getSlaveryRoomListDialogue(null, null)){

                            @Override
                            public void effects() {
                                CompanionManagement.initManagement(Main.game.getDefaultDialogue(), 0, null);
                            }
                        };
                    }
                    return new Response("\u7ba1\u7406\u4eba\u5458", "\u5728\u8fdb\u5165\u8be5\u754c\u9762\u524d\uff0c\u4f60\u9700\u8981\u83b7\u5f97\u8d29\u5974\u8bb8\u53ef\uff1b\u8389\u83b1\u96c5\u8981\u662f\u5141\u8bb8\u4f60\u5e26\u4eba\u6216\u73a9\u5076\u4f4f\u4e0b\u7684\u8bdd\u90a3\u4e5f\u884c\u3002", null);
                }
                if (index == 3) {
                    if (Main.game.getPlayer().getLocationPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_DRESSING_ROOM_LYSSIETH_WARDROBE)) {
                        return new Response("\u670d\u88c5", "\u5f97\u76ca\u4e8e\u8389\u897f\u4e1d\u7684\u8863\u67dc\u7684\u80fd\u529b\uff0c\u4f60\u73b0\u5728\u53ef\u4ee5\u4e3a\u81ea\u5df1\u548c\u5974\u96b6\u521b\u5efa\u6216\u7f16\u8f91\u5957\u88c5\u3002", OUTFITS);
                    }
                    return new Response("\u670d\u88c5", "\u4f60\u9700\u8981\u7ed9\u8389\u83b1\u96c5\u4ed8\u94b1\u6765\u91cd\u65b0\u6fc0\u6d3b\u8389\u897f\u4e1d\u7684\u8863\u67dc\uff0c\u4e4b\u540e\u624d\u80fd\u4f7f\u7528\u66f4\u8863\u5ba4\u7684\u5957\u88c5\u7ba1\u7406\u529f\u80fd\u2026\u2026", null);
                }
                if (index == 5) {
                    final boolean autoCleaning = Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.dressingRoomAutoClean);
                    return new Response("\u81ea\u52a8\u6e05\u6d17" + (autoCleaning ? "[style.colourGood(\u5f00\u542f)]" : "[style.colourBad(\u5173\u95ed)]"), "\u786e\u8ba4\u4f60\u5728\u66f4\u8863\u5ba4\u4e2d\u5b58\u653e\u7684\u8863\u7269\u662f\u5426\u4f1a\u88ab\u81ea\u52a8\u6e05\u6d17\u3002<br/><b>\u6ce8\u610f\uff1a</b>\u5728\u68c0\u67e5\u8be5\u533a\u57df\u7684\u8863\u7269\u4ee5\u7ec4\u6210\u5b8c\u6574\u7684\u5957\u88c5\u65f6\uff0c\u810f\u8863\u7269[style.italicsBad(\u5c06\u4e0d\u4f1a)]\u88ab\u8ba1\u7b97\u5728\u5185\u3002\u6240\u4ee5\u5982\u679c\u4f60\u60f3\u4f7f\u7528\u201c\u4ece\u5730\u5757\u88c5\u5907\u201d\u7684\u529f\u80fd\uff0c\u90a3\u4e48\u5efa\u8bae\u4fdd\u6301\u8fd9\u4e2a\u8bbe\u7f6e\u5f00\u542f\u3002", ROOM_DRESSING_ROOM){

                        @Override
                        public int getSecondsPassed() {
                            return 0;
                        }

                        @Override
                        public void effects() {
                            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.dressingRoomAutoClean, !autoCleaning);
                        }
                    };
                }
                return null;
            }
        };
        OUTFITS = new DialogueNode("\u5957\u88c5\u7ba1\u7406", "", true){

            @Override
            public void applyPreParsingEffects() {
                LilayaDressingRoomDialogue.initOutfitsMenu();
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public String getHeaderContent() {
                StringBuilder saveLoadSB = new StringBuilder();
                saveLoadSB.append("<div class='container-full-width' style='padding:0; margin:0;'><div class='container-full-width' style='width:70%; margin:0; text-align:center; background:transparent;'>\u5957\u88c5\u540d\u79f0\u4e0e\u6587\u4ef6\u5730\u5740</div><div class='container-full-width' style='width:10%; margin:0; text-align:center; background:transparent;'>\u53ef\u7528\u7269\u54c1\u6570</div><div class='container-full-width' style='width:10%; margin:0; text-align:center; background:transparent;'>\u6210\u672c</div><div class='container-full-width' style='width:10%; margin:0; text-align:center; background:transparent;'>\u5220\u9664</div></div>");
                if (loadedOutfitsMap.isEmpty()) {
                    saveLoadSB.append("<div class='container-full-width' style='padding:0; margin:0;'><div class='container-full-width' style='width:calc(100% - 16px); text-align:center; background:" + PresetColour.BACKGROUND_ALT.toWebHexString() + ";'><i>\u4f60\u8fd8\u6ca1\u6709\u4fdd\u5b58\u4efb\u4f55\u5957\u88c5\uff01</i></div></div>");
                } else {
                    int i = 0;
                    for (Map.Entry<String, Outfit> entry : loadedOutfitsMap.entrySet()) {
                        saveLoadSB.append(LilayaDressingRoomDialogue.getOutfitListRow(entry.getKey(), entry.getValue(), i % 2 == 0));
                        ++i;
                    }
                }
                saveLoadSB.append("<p id='hiddenPField' style='display:none;'></p>");
                return saveLoadSB.toString();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u65b0\u5efa\u5957\u88c5", "\u521b\u5efa\u4e00\u5957\u65b0\u5957\u88c5", OUTFIT_EDITOR){

                        @Override
                        public void effects() {
                            activeOutfit = new Outfit();
                            loadedFileName = "";
                        }
                    };
                }
                if (index == 2) {
                    return new Response("\u65b0\u5efa(\u6765\u81ea\u5f53\u524d\u88c5\u5907)", "\u521b\u5efa\u4e00\u5957\u65b0\u5957\u88c5\uff0c\u4ee5\u4f60\u5f53\u524d\u88c5\u5907\u7684\u8863\u7269\u548c\u6b66\u5668\u751f\u6210\u521d\u59cb\u6a21\u677f\u3002<br/>[style.italicsMinorBad(\u8bf7\u6ce8\u610f\uff0c\u4f60\u88c5\u5907\u7684\u6240\u6709\u72ec\u7279\u6216\u4f20\u5947\u7269\u54c1\u90fd\u5c06\u88ab\u5ffd\u7565\uff0c\u56e0\u4e3a\u5957\u88c5\u65e0\u6cd5\u590d\u5236\u5982\u6b64\u5f3a\u5927\u7684\u7269\u54c1\u3002)]", OUTFIT_EDITOR){

                        @Override
                        public void effects() {
                            activeOutfit = new Outfit();
                            loadedFileName = "";
                            for (InventorySlot slot : InventorySlot.allWeaponSlots) {
                                AbstractWeapon weapon = Main.game.getPlayer().getWeaponInSlot(slot);
                                if (weapon == null || weapon.getRarity() == Rarity.QUEST || weapon.getRarity() == Rarity.LEGENDARY) continue;
                                activeOutfit.addWeapon(slot, Main.game.getItemGen().generateWeapon(weapon));
                            }
                            for (InventorySlot slot : InventorySlot.getClothingSlots()) {
                                AbstractClothing clothing = Main.game.getPlayer().getClothingInSlot(slot);
                                if (clothing == null || clothing.getRarity() == Rarity.QUEST || clothing.getRarity() == Rarity.LEGENDARY) continue;
                                AbstractClothing clothingClone = Main.game.getItemGen().generateClothing(clothing);
                                clothingClone.setDirty(null, false);
                                activeOutfit.addClothing(slot, clothingClone);
                            }
                        }
                    };
                }
                if (index == 11) {
                    return new Response("\u786e\u8ba4\u72b6\u6001\uff1a", "\u5728\u70b9\u51fb\u5220\u9664\u5957\u88c5\u5b58\u6863\u65f6\u4f1a\u8fdb\u5165\u786e\u8ba4\u72b6\u6001\u3002\u542f\u7528\u65f6\uff0c\u9700\u8981\u8fdb\u884c\u4e24\u6b21\u70b9\u51fb\u624d\u80fd\u4f7f\u5220\u9664\u751f\u6548\u3002\u5173\u95ed\u65f6\u53ea\u9700\u8981\u4e00\u6b21\u70b9\u51fb\u3002", OUTFITS){

                        @Override
                        public String getTitle() {
                            return "\u518d\u6b21\u786e\u8ba4\uff1a" + (Main.getProperties().hasValue(PropertyValue.overwriteWarning) ? "<span style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u5f00\u542f</span>" : "<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u5173\u95ed</span>");
                        }

                        @Override
                        public void effects() {
                            deleteConfirmationName = "";
                            Main.getProperties().setValue(PropertyValue.overwriteWarning, !Main.getProperties().hasValue(PropertyValue.overwriteWarning));
                            Main.getProperties().savePropertiesAsXML();
                        }
                    };
                }
                if (index == 12) {
                    if (outfitFilesFullVisibility) {
                        return new Response("\u663e\u793a\uff1a[style.colourExcellent(\u5168\u90e8)]", "\u4f60\u6b63\u5728\u67e5\u770b\u201cres/outfits\u201d\u6587\u4ef6\u5939\u4e2d\u7684[style.colourExcellent(\u6240\u6709)]\u670d\u88c5\u3002\u5728\u4e0d\u540c\u5b58\u6863\u6587\u4ef6\u4e2d\u521b\u5efa\u7684\u670d\u88c5\u4f1a\u6807\u6709\u300c[style.boldExcellent(*)]\u300d\u3002<br/><i>\u6fc0\u6d3b\u6b64\u9009\u9879\u53ef\u5207\u6362\u5230\u201c\u672c\u5730\u201d\u6a21\u5f0f\uff0c\u8be5\u6a21\u5f0f\u4ec5\u663e\u793a\u5f53\u524d\u6e38\u5b58\u6863\u521b\u5efa\u7684\u670d\u88c5\u3002</i>", OUTFITS){

                            @Override
                            public void effects() {
                                outfitFilesFullVisibility = !outfitFilesFullVisibility;
                            }
                        };
                    }
                    return new Response("\u663e\u793a\uff1a[style.colourMinorGood(\u672c\u5730)]", "\u4f60\u5f53\u524d\u4ec5\u67e5\u770b\u5728\u5f53\u524d\u6e38\u620f\u4e2d\u521b\u5efa\u7684\u670d\u88c5\u3002<br/><i>\u6fc0\u6d3b\u6b64\u9009\u9879\u53ef\u5207\u6362\u5230\u201c\u5168\u90e8\u201d\u6a21\u5f0f\uff0c\u8be5\u6a21\u5f0f\u5c06\u663e\u793a\u201cres/outfits\u201d\u6587\u4ef6\u5939\u4e2d\u7684\u6240\u6709\u670d\u88c5\u3002</i>", OUTFITS){

                        @Override
                        public void effects() {
                            outfitFilesFullVisibility = !outfitFilesFullVisibility;
                        }
                    };
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u9000\u51fa\u670d\u88c5\u7ba1\u7406\u83dc\u5355\u3002", ROOM_DRESSING_ROOM);
                }
                return null;
            }
        };
        OUTFIT_EDITOR = new DialogueNode("\u670d\u88c5\u7f16\u8f91\u5668", "", true){

            @Override
            public void applyPreParsingEffects() {
                LilayaDressingRoomDialogue.getDoll().resetInventory(true);
                LilayaDressingRoomDialogue.getDoll().loadOutfit(activeOutfit, OutfitSource.NOWHERE, OutfitSource.NOWHERE);
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public String getHeaderContent() {
                StringBuilder sb = new StringBuilder();
                sb.append("<div style='float:left; border-radius:5px; background:" + PresetColour.BACKGROUND_DARK.toWebHexString() + "; text-align:center; width:90%; margin:1% 5%; padding:8px;'>");
                sb.append("<i>");
                sb.append("\u70b9\u51fb\u4efb\u610f\u680f\u4f4d\u6253\u5f00\u8863\u7269/\u6b66\u5668\u9009\u62e9\u754c\u9762\u3002");
                sb.append("</i>");
                sb.append("</div>");
                sb.append(LilayaDressingRoomDialogue.getInventoryEquippedPanel());
                sb.append("<div style='width:calc(" + (100.0f - inventoryUIWidth) + "% - 8px); padding:0; margin:0 0 0 8px; float:left;'>");
                sb.append("<h5 style='text-align:center;'>\u670d\u88c5\u8be6\u60c5</h5>");
                sb.append("<form style='text-align:center;float:left; width:80%; padding:0; margin:0 0 5% 5%;'>");
                sb.append("<input type='text' id='outfit_name' placeholder='Outfit name' value='" + activeOutfit.getName() + "' style='padding:0;margin:0;width:100%;'>");
                sb.append("</form>");
                sb.append("<div class='normal-button' id='apply_outfit_name' style='float:left; width:9.5%; height:22px; line-height:22px; margin:0 0 0 0.5%; padding:0; text-align:center;'>&#10003;</div>");
                sb.append("<p style='margin-bottom:0; padding-bottom:0;'>");
                sb.append("\u540d\u79f0\uff1a");
                sb.append("<br/><span style='font-size:1.1em;'>" + activeOutfit.getName() + "</span>");
                sb.append("<br/>");
                sb.append("<br/>");
                sb.append("\u670d\u88c5\u8d39\u7528\uff1a");
                sb.append("<br/><span style='font-size:1.1em;'>" + UtilText.formatAsMoney(activeOutfit.getCost()) + "</span>");
                int essenceCost = activeOutfit.getEssenceCost();
                if (essenceCost == 0) {
                    sb.append("<br/><span style='font-size:1.1em;'>" + UtilText.formatAsEssencesUncoloured(essenceCost, "b", false) + "</span>");
                } else {
                    sb.append("<br/><span style='font-size:1.1em;'>" + UtilText.formatAsEssences(essenceCost, "b", false) + "</span>");
                }
                sb.append("<br/>");
                sb.append("<br/>");
                sb.append("\u8be5\u533a\u57df\u53ef\u83b7\u53d6\u7684\u5957\u88c5\uff1a");
                sb.append("<br/><span style='font-size:1.1em;'>" + LilayaDressingRoomDialogue.getOutfitAvailabilityFromTile(activeOutfit) + "</span>");
                sb.append("</p>");
                sb.append("</div>");
                sb.append("<p id='hiddenPField' style='display:none;'></p>");
                return sb.toString();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                boolean outfitChanged;
                Outfit loadedOutfit = LilayaDressingRoomDialogue.loadOutfit(loadedFileName);
                boolean bl = outfitChanged = loadedFileName != null && !loadedFileName.isEmpty() && activeOutfit != null && loadedOutfit != null && activeOutfit.hashCode() != loadedOutfit.hashCode();
                if (index == 1) {
                    if (LilayaDressingRoomDialogue.isSaveOutfitAvailable(false)) {
                        return new ResponseEffectsOnly("[style.colourMinorGood(\u4fdd\u5b58)]", "\u5c06\u8be5\u670d\u88c5\u4ee5\u6587\u4ef6\u540d\u201c" + LilayaDressingRoomDialogue.getOutfitSaveName() + "\u201d\u4fdd\u5b58\uff0c\u4ece\u800c\u53ef\u4ee5\u7a7f\u7740\u6216\u5206\u914d\u7ed9\u5974\u96b6\u3002"){

                            @Override
                            public void effects() {
                                LilayaDressingRoomDialogue.saveOutfit(LilayaDressingRoomDialogue.getOutfitSaveName(), activeOutfit, true, OUTFIT_EDITOR);
                                loadedFileName = LilayaDressingRoomDialogue.getOutfitSaveName();
                            }
                        };
                    }
                    if (LilayaDressingRoomDialogue.isSaveOutfitAvailable(true)) {
                        return new Response("\u4fdd\u5b58", "\u5df2\u5b58\u5728\u540d\u4e3a\u201c" + LilayaDressingRoomDialogue.getOutfitSaveName() + "\u201d\u7684\u6587\u4ef6\uff0c\u65e0\u6cd5\u53e6\u5b58\u4e3a\u65b0\u6587\u4ef6\u2026\u2026", null);
                    }
                    return new Response("\u4fdd\u5b58", "\u65e0\u6cd5\u4fdd\u5b58\u672a\u547d\u540d\u7684\u670d\u88c5\uff01", null);
                }
                if (index == 2) {
                    if (loadedFileName == null || loadedFileName.isEmpty()) {
                        return new Response("\u8986\u76d6", "\u8fd9\u662f\u65b0\u521b\u5efa\u7684\u670d\u88c5\uff0c\u6ca1\u6709\u6587\u4ef6\u53ef\u4ee5\u8986\u76d6\u2026\u2026", null);
                    }
                    if (!outfitChanged) {
                        return new Response("\u8986\u76d6", "\u4f60\u8fd8\u6ca1\u4fee\u6539\u8fc7\u670d\u88c5\uff0c\u73b0\u5728\u65e0\u9700\u8986\u76d6\u2026\u2026", null);
                    }
                    final String fileNameForOverwrite = !LilayaDressingRoomDialogue.isSaveOutfitAvailable(false) ? LilayaDressingRoomDialogue.getOutfitSaveName() : loadedFileName;
                    return new ResponseEffectsOnly("[style.colourMinorBad(\u8986\u76d6)]", "\u5c06\u6587\u4ef6\u540d\u79f0\u4e3a\u201c" + fileNameForOverwrite + "\u201d\u7684\u5df2\u4fdd\u5b58\u670d\u88c5\u66ff\u6362\u4e3a\u8fd9\u5957\u670d\u88c5\u3002<br/>[style.italicsBad(\u5982\u679c\u7ee7\u7eed\u64cd\u4f5c\uff0c\u73b0\u6709\u7684\u540d\u4e3a\u201c" + fileNameForOverwrite + "\u201d\u7684\u670d\u88c5\u5c06\u88ab\u8986\u76d6\u4e22\u5931\uff01)]"){

                        @Override
                        public void effects() {
                            LilayaDressingRoomDialogue.deleteOutfit(fileNameForOverwrite);
                            LilayaDressingRoomDialogue.saveOutfit(LilayaDressingRoomDialogue.getOutfitSaveName(), activeOutfit, true, OUTFIT_EDITOR);
                            loadedFileName = LilayaDressingRoomDialogue.getOutfitSaveName();
                        }
                    };
                }
                if (index == 4) {
                    return new Response("\u5ffd\u7565\u6240\u6709", "\u5c06\u6240\u6709\u5f53\u524d\u4e3a\u7a7a\u7684\u680f\u4f4d\u8bbe\u4e3a\u201c\u5ffd\u7565\u201d\u3002\u8fd9\u610f\u5473\u7740\u6bcf\u5f53\u5957\u88c5\u88ab\u5e94\u7528\u5230\u89d2\u8272\u8eab\u4e0a\u65f6\uff0c\u89d2\u8272\u76ee\u524d\u5728\u8be5\u680f\u4f4d\u4e0a\u88c5\u5907\u7684\u4efb\u4f55\u7269\u54c1\u90fd\u4e0d\u4f1a\u88ab\u79fb\u9664\uff0c\u800c\u662f\u4f1a\u88ab\u5ffd\u7565\u5e76\u4fdd\u6301\u539f\u6837\u3002", OUTFIT_EDITOR){

                        @Override
                        public void effects() {
                            for (InventorySlot slot : InventorySlot.values()) {
                                if (activeOutfit.getClothing().get((Object)slot) != null || activeOutfit.getWeapons().get((Object)slot) != null) continue;
                                activeOutfit.addIgnoredSlot(slot);
                            }
                        }
                    };
                }
                if (index == 5) {
                    return new Response("\u6e05\u9664\u5ffd\u7565", "\u5c06\u6240\u6709\u5f53\u524d\u8bbe\u4e3a\u201c\u5ffd\u7565\u201d\u7684\u680f\u4f4d\u6539\u4e3a\u7a7a\u3002\u8fd9\u610f\u5473\u7740\u6bcf\u5f53\u5957\u88c5\u88ab\u5e94\u7528\u5230\u89d2\u8272\u8eab\u4e0a\u65f6\uff0c\u6240\u6709\u88ab\u5b9a\u4e49\u4e3a\u7a7a\u7684\u680f\u4f4d\u5c06\u88ab\u6e05\u7a7a\uff0c\u800c\u4e0d\u662f\u4fdd\u6301\u539f\u6837\u3002", OUTFIT_EDITOR){

                        @Override
                        public void effects() {
                            for (InventorySlot slot : InventorySlot.values()) {
                                if (!activeOutfit.getIgnoredSlots().contains((Object)slot)) continue;
                                if (slot.isWeapon()) {
                                    activeOutfit.addWeapon(slot, null);
                                    continue;
                                }
                                activeOutfit.addClothing(slot, null);
                            }
                        }
                    };
                }
                if (index == 6) {
                    if (Main.game.getPlayer().getMoney() < (long)activeOutfit.getCost() || Main.game.getPlayer().getEssenceCount() < activeOutfit.getEssenceCost()) {
                        return new Response("\u8d2d\u4e70 (" + UtilText.formatAsMoneyUncoloured(activeOutfit.getCost(), "span") + ")", "\u4f60\u4e70\u4e0d\u8d77\u8fd9\u5957\u670d\u88c5\u3002<br/>" + (Main.game.getPlayer().getMoney() < (long)activeOutfit.getCost() ? "\u4f60[style.colourBad(\u6ca1\u6709)][style.moneyFormat(" + activeOutfit.getCost() + ", span)](\u53ea\u6709[style.moneyFormat(" + Main.game.getPlayer().getMoney() + ", span)])\u3002" : "\u4f60[style.colourGood(\u62e5\u6709)]\u6240\u9700\u7684[style.moneyFormat(" + activeOutfit.getCost() + ", span)]\u3002") + (String)(activeOutfit.getEssenceCost() <= 0 ? "" : "<br/>" + (Main.game.getPlayer().getEssenceCount() < activeOutfit.getEssenceCost() ? "\u4f60[style.colourBad(\u6ca1\u6709)][style.essenceFormat(" + activeOutfit.getEssenceCost() + ", span)](\u53ea\u6709[style.essenceFormat(" + Main.game.getPlayer().getEssenceCount() + ", span)])\u3002" : "\u4f60[style.colourGood(\u62e5\u6709)]\u6240\u9700\u7684[style.essenceFormat(" + activeOutfit.getEssenceCost() + ", span)]\u3002")), null);
                    }
                    return new Response("\u8d2d\u4e70 (" + UtilText.formatAsMoney(activeOutfit.getCost(), "span") + ")", "\u8d2d\u4e70\u8fd9\u5957\u670d\u88c5\u540e\uff0c\u4f60\u53ef\u4ee5\u9009\u62e9\u81ea\u5df1\u7a7f\u7740\u6216\u7ed9\u4e00\u4e2a\u5974\u96b6\u7a7f\u4e0a\u3002<br/>\u8fd9\u4f1a[style.colorBad(\u82b1\u8d39)]\u4f60[style.moneyFormat(" + activeOutfit.getCost() + ", span)]" + (String)(activeOutfit.getEssenceCost() <= 0 ? "\u3002" : "\u548c[style.essenceFormat(" + activeOutfit.getEssenceCost() + ", span)]\u3002") + "<br/>[style.colorGood(\u4f60\u62e5\u6709)][style.moneyFormat(" + Main.game.getPlayer().getMoney() + ", span)]" + (String)(activeOutfit.getEssenceCost() <= 0 ? "\u3002" : "\u548c[style.essenceFormat(" + Main.game.getPlayer().getEssenceCount() + ", span)]\u3002"), OUTFIT_PURCHASE){

                        @Override
                        public void effects() {
                            if (activeOutfit.getCost() == 0) {
                                Main.game.appendToTextEndStringBuilder(UtilText.parseFromXMLFile("places/dominion/lilayasHome/dressingRoom", "OUTFIT_NOTHING"));
                            } else {
                                Main.game.appendToTextEndStringBuilder(UtilText.parseFromXMLFile("places/dominion/lilayasHome/dressingRoom", "OUTFIT_PURCHASE"));
                            }
                            outfitObtainedViaPurchase = true;
                            if (activeOutfit.getCost() > 0) {
                                Main.game.appendToTextEndStringBuilder(Main.game.getPlayer().incrementMoney(-activeOutfit.getCost()));
                            }
                            if (activeOutfit.getEssenceCost() > 0) {
                                Main.game.appendToTextEndStringBuilder(Main.game.getPlayer().incrementEssenceCount(-activeOutfit.getEssenceCost(), false));
                            }
                        }
                    };
                }
                if (index == 7) {
                    if (LilayaDressingRoomDialogue.getOutfitAvailabilityFromTile(activeOutfit) <= 0) {
                        return new Response("\u4ece\u8be5\u533a\u57df\u88c5\u5907", "\u4f60\u6ca1\u6709\u5728\u8fd9\u4e2a\u533a\u57df\u83b7\u5f97\u8fd9\u5957\u670d\u88c5\u6240\u9700\u7684\u5168\u90e8\u90e8\u4ef6\uff0c\u6240\u4ee5\u5982\u679c\u4f60\u60f3\u88c5\u5907\uff0c\u5c31\u5f97\u5148\u8d2d\u4e70\u2026\u2026", null);
                    }
                    return new Response("\u4ece\u8be5\u533a\u57df\u88c5\u5907", "\u7531\u4e8e\u4f60\u5728\u8fd9\u4e2a\u533a\u57df\u5df2\u7ecf\u62e5\u6709\u8fd9\u5957\u670d\u88c5\u7684\u5168\u90e8\u6240\u9700\u90e8\u4ef6\uff0c\u53ef\u4ee5\u76f4\u63a5\u7ed9\u81ea\u5df1\u6216\u5176\u4e2d\u4e00\u4e2a\u5974\u96b6\u88c5\u5907\uff0c\u65e0\u9700\u518d\u989d\u5916\u8d2d\u4e70\u3002", OUTFIT_PURCHASE){

                        @Override
                        public void effects() {
                            if (activeOutfit.getCost() == 0) {
                                Main.game.appendToTextEndStringBuilder(UtilText.parseFromXMLFile("places/dominion/lilayasHome/dressingRoom", "OUTFIT_NOTHING"));
                            } else {
                                Main.game.appendToTextEndStringBuilder(UtilText.parseFromXMLFile("places/dominion/lilayasHome/dressingRoom", "OUTFIT_OWNED"));
                            }
                            outfitObtainedViaPurchase = false;
                        }
                    };
                }
                if (index == 0) {
                    final boolean unsavedNewOutfit = LilayaDressingRoomDialogue.isSaveOutfitAvailable(false) && activeOutfit.hashCode() != new Outfit().hashCode();
                    return new Response(outfitChanged || unsavedNewOutfit ? "\u53d6\u6d88" : "\u8fd4\u56de", (String)(outfitChanged || unsavedNewOutfit ? "\u53d6\u6d88\u4fee\u6539\u5e76\u9000\u51fa\u670d\u88c5\u7f16\u8f91\u5668\uff0c\u8fd4\u56de\u670d\u88c5\u9009\u62e9\u754c\u9762\u3002" + (unsavedNewOutfit ? "<br/>[style.italicsTerrible(\u7531\u4e8e\u4f60\u5c1a\u672a\u4fdd\u5b58\u8fd9\u5957\u670d\u88c5\uff0c\u5982\u679c\u7ee7\u7eed\u64cd\u4f5c\uff0c\u4f60\u6240\u505a\u7684\u6240\u6709\u4fee\u6539\u90fd\u5c06\u4e22\u5931\uff01)]" : "<br/>[style.italicsTerrible(\u5982\u679c\u4f60\u8fd9\u6837\u505a\uff0c\u4f60\u5bf9\u8fd9\u5957\u670d\u88c5\u6240\u505a\u7684\u4fee\u6539\u5c06\u4f1a\u4e22\u5931\uff01)]") : "\u9000\u51fa\u670d\u88c5\u7f16\u8f91\u5668\u5e76\u8fd4\u56de\u670d\u88c5\u9009\u62e9\u754c\u9762\u3002"), OUTFITS){

                        @Override
                        public Colour getHighlightColour() {
                            if (outfitChanged || unsavedNewOutfit) {
                                return PresetColour.GENERIC_TERRIBLE;
                            }
                            return super.getHighlightColour();
                        }
                    };
                }
                return null;
            }
        };
        OUTFIT_PURCHASE = new DialogueNode("\u8d2d\u4e70\u670d\u88c5", "", true){

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u51b3\u5b9a\u8fd8\u662f\u4e0d\u8d2d\u4e70\u8fd9\u5957\u670d\u88c5\u4e86\u2026\u2026", OUTFIT_EDITOR){

                        @Override
                        public void effects() {
                            if (outfitObtainedViaPurchase) {
                                Main.game.appendToTextEndStringBuilder("<p>");
                                if (activeOutfit.getCost() > 0) {
                                    Main.game.appendToTextEndStringBuilder(Main.game.getPlayer().incrementMoney(activeOutfit.getCost()));
                                }
                                if (activeOutfit.getEssenceCost() > 0) {
                                    Main.game.appendToTextEndStringBuilder(Main.game.getPlayer().incrementEssenceCount(activeOutfit.getEssenceCost(), false));
                                }
                                Main.game.appendToTextEndStringBuilder("</p>");
                            }
                        }
                    };
                }
                String helperText = "<br/>\u88c5\u5907\u8fd9\u5957\u670d\u88c5\u65f6\u5378\u4e0b\u7684\u4efb\u4f55\u8863\u7269\u6216\u6b66\u5668\u5c06\u88ab\u653e\u5165\u66f4\u8863\u5ba4\u3002";
                if (index == 1) {
                    boolean sealedClothingEquipped = Main.game.getPlayer().isAnyEquippedClothingSealed();
                    String additionalHelperText = "";
                    if (sealedClothingEquipped) {
                        additionalHelperText = "<br/>[style.italicsMinorBad(*\u4f60\u5f53\u524d\u88c5\u5907\u4e86\u88ab\u5c01\u5370\u7684\u8863\u7269\uff0c\u53ef\u80fd\u5bfc\u81f4\u65e0\u6cd5\u7a7f\u6234\u8fd9\u5957\u670d\u88c5\u7684\u6240\u6709\u7269\u54c1\u3002)]";
                    }
                    return new Response("\u4f60" + (sealedClothingEquipped ? "[style.colourMinorBad(*)]" : ""), "\u7ed9\u81ea\u5df1\u88c5\u5907\u8fd9\u5957\u670d\u88c5\u3002" + helperText + additionalHelperText, OUTFIT_EDITOR){

                        @Override
                        public void effects() {
                            ArrayList<String> unequipsList = new ArrayList<String>();
                            ArrayList<String> equipsList = new ArrayList<String>();
                            ArrayList<String> failuresList = new ArrayList<String>();
                            HashMap<InventorySlot, AbstractWeapon> weaponsEquippedBeforeOutfitApplication = new HashMap<InventorySlot, AbstractWeapon>();
                            for (InventorySlot inventorySlot : InventorySlot.allWeaponSlots) {
                                AbstractWeapon abstractWeapon = Main.game.getPlayer().getWeaponInSlot(inventorySlot);
                                if (abstractWeapon == null) continue;
                                weaponsEquippedBeforeOutfitApplication.put(inventorySlot, abstractWeapon);
                            }
                            HashMap<InventorySlot, AbstractClothing> clothingEquippedBeforeOutfitApplication = new HashMap<InventorySlot, AbstractClothing>();
                            for (AbstractClothing c : Main.game.getPlayer().getClothingCurrentlyEquipped()) {
                                clothingEquippedBeforeOutfitApplication.put(c.getSlotEquippedTo(), c);
                            }
                            Map<InventorySlot, AbstractCoreItem> failureToEquipMap = Main.game.getPlayer().loadOutfit(activeOutfit, OutfitSource.CELL, outfitObtainedViaPurchase ? OutfitSource.NOWHERE : OutfitSource.CELL);
                            Main.game.appendToTextEndStringBuilder("<h3 style='text-align:center; margin-bottom:0;'>\u4f60\u88c5\u5907\u4e86\u201c" + activeOutfit.getName() + "\u201d\u5957\u88c5</h3>");
                            for (Map.Entry<InventorySlot, AbstractWeapon> entry : activeOutfit.getWeapons().entrySet()) {
                                if (!failureToEquipMap.containsKey((Object)entry.getKey())) {
                                    equipsList.add(LilayaDressingRoomDialogue.getOutfitEquipTextRow(equipType.EQUIP, Util.capitaliseSentence(entry.getValue().getName(false, true))));
                                    continue;
                                }
                                failuresList.add(LilayaDressingRoomDialogue.getOutfitEquipTextRow(equipType.FAILED, Util.capitaliseSentence(entry.getValue().getName(false, true))));
                            }
                            for (Map.Entry<InventorySlot, AbstractCoreItem> entry : activeOutfit.getClothing().entrySet()) {
                                if (!failureToEquipMap.containsKey((Object)entry.getKey())) {
                                    equipsList.add(LilayaDressingRoomDialogue.getOutfitEquipTextRow(equipType.EQUIP, Util.capitaliseSentence(((AbstractClothing)entry.getValue()).getName(false, true))));
                                    continue;
                                }
                                failuresList.add(LilayaDressingRoomDialogue.getOutfitEquipTextRow(equipType.FAILED, Util.capitaliseSentence(((AbstractClothing)entry.getValue()).getName(false, true))));
                            }
                            for (Map.Entry<InventorySlot, AbstractCoreItem> entry : weaponsEquippedBeforeOutfitApplication.entrySet()) {
                                if (Main.game.getPlayer().getWeaponInSlot(entry.getKey()) == entry.getValue()) continue;
                                unequipsList.add(LilayaDressingRoomDialogue.getOutfitEquipTextRow(equipType.UNEQUIP, Util.capitaliseSentence(((AbstractWeapon)entry.getValue()).getName(false, true))));
                            }
                            for (Map.Entry<InventorySlot, AbstractCoreItem> entry : clothingEquippedBeforeOutfitApplication.entrySet()) {
                                if (Main.game.getPlayer().getClothingInSlot(entry.getKey()) == entry.getValue()) continue;
                                unequipsList.add(LilayaDressingRoomDialogue.getOutfitEquipTextRow(equipType.UNEQUIP, Util.capitaliseSentence(((AbstractClothing)entry.getValue()).getName(false, true))));
                            }
                            Main.game.appendToTextEndStringBuilder("<div class='container-full-width'>");
                            int i = 0;
                            for (String string : unequipsList) {
                                Main.game.appendToTextEndStringBuilder(LilayaDressingRoomDialogue.applyRowWrapper(string, i % 2 == 0));
                                ++i;
                            }
                            for (String string : equipsList) {
                                Main.game.appendToTextEndStringBuilder(LilayaDressingRoomDialogue.applyRowWrapper(string, i % 2 == 0));
                                ++i;
                            }
                            for (String string : failuresList) {
                                Main.game.appendToTextEndStringBuilder(LilayaDressingRoomDialogue.applyRowWrapper(string, i % 2 == 0));
                                ++i;
                            }
                            Main.game.appendToTextEndStringBuilder("</div>");
                            if (outfitObtainedViaPurchase) {
                                for (Map.Entry<InventorySlot, AbstractCoreItem> entry : failureToEquipMap.entrySet()) {
                                    if (entry.getValue() instanceof AbstractClothing && !((AbstractClothing)entry.getValue()).isDiscardedOnUnequip(entry.getKey())) {
                                        Main.game.getPlayerCell().getInventory().addClothing((AbstractClothing)entry.getValue());
                                        continue;
                                    }
                                    if (!(entry.getValue() instanceof AbstractWeapon)) continue;
                                    Main.game.getPlayerCell().getInventory().addWeapon((AbstractWeapon)entry.getValue());
                                }
                            }
                            LilayaDressingRoomDialogue.calculateOutfitAvailability();
                        }
                    };
                }
                ArrayList<Response> slaveResponses = new ArrayList<Response>();
                for (final GameCharacter slave : Main.game.getPlayer().getSlavesOwnedAsCharacters()) {
                    SlaveJob currentJob = slave.getSlaveJob(Main.game.getHourOfDay());
                    if (currentJob.getFlags().contains((Object)SlaveJobFlag.SPECIAL_UNIFORM)) {
                        String jobName = currentJob.getName(slave);
                        slaveResponses.add(new Response(UtilText.parse(slave, "[npc.Name]", new ParserTag[0]), UtilText.parse(slave, "\u4f60\u7684[npc.raceFull(true)]\u5974\u96b6\uff0c[npc.name]\u76ee\u524d\u6b63\u5728\u62c5\u4efb" + jobName + "\u3002\u7531\u4e8e\u8fd9\u4efd\u5de5\u4f5c\u7684\u7279\u6b8a\u5236\u670d\u8981\u6c42\uff0c[npc.sheIs]\u6682\u65f6\u65e0\u6cd5\u88c5\u5907\u8fd9\u5957\u670d\u88c5\u3002", new ParserTag[0]), null));
                        continue;
                    }
                    boolean sealedClothingEquipped = slave.isAnyEquippedClothingSealed();
                    String additionalHelperText = "";
                    if (sealedClothingEquipped) {
                        additionalHelperText = "<br/>[style.italicsMinorBad(*[npc.Name]\u5f53\u524d\u88c5\u5907\u4e86\u88ab\u5c01\u5370\u7684\u8863\u7269\uff0c\u53ef\u80fd\u5bfc\u81f4[npc.herHim]\u65e0\u6cd5\u7a7f\u6234\u8fd9\u5957\u670d\u88c5\u7684\u6240\u6709\u7269\u54c1\u3002)]";
                    }
                    slaveResponses.add(new Response(UtilText.parse(slave, "<span style='color:" + slave.getFemininity().getColour().toWebHexString() + ";'>[npc.Name]</span>" + (sealedClothingEquipped ? "[style.colourMinorBad(*)]" : ""), new ParserTag[0]), UtilText.parse(slave, "\u7ed9\u4f60\u7684[npc.raceFull(true)]\u5974\u96b6[npc.name]\u88c5\u5907\u8fd9\u5957\u670d\u88c5\u3002" + helperText + additionalHelperText, new ParserTag[0]), OUTFIT_EDITOR){

                        @Override
                        public void effects() {
                            ArrayList<String> unequipsList = new ArrayList<String>();
                            ArrayList<String> equipsList = new ArrayList<String>();
                            ArrayList<String> failuresList = new ArrayList<String>();
                            HashMap<InventorySlot, AbstractWeapon> weaponsEquippedBeforeOutfitApplication = new HashMap<InventorySlot, AbstractWeapon>();
                            for (Object weaponSlot : InventorySlot.allWeaponSlots) {
                                AbstractWeapon abstractWeapon = slave.getWeaponInSlot((InventorySlot)((Object)weaponSlot));
                                if (abstractWeapon == null) continue;
                                weaponsEquippedBeforeOutfitApplication.put((InventorySlot)((Object)weaponSlot), abstractWeapon);
                            }
                            HashMap<InventorySlot, AbstractClothing> clothingEquippedBeforeOutfitApplication = new HashMap<InventorySlot, AbstractClothing>();
                            for (AbstractClothing c : slave.getClothingCurrentlyEquipped()) {
                                clothingEquippedBeforeOutfitApplication.put(c.getSlotEquippedTo(), c);
                            }
                            Cell c = slave.getCell();
                            slave.setLocation(Main.game.getPlayer());
                            Map<InventorySlot, AbstractCoreItem> failureToEquipMap = slave.loadOutfit(activeOutfit, OutfitSource.CELL, outfitObtainedViaPurchase ? OutfitSource.NOWHERE : OutfitSource.CELL);
                            slave.setLocation(c);
                            Main.game.appendToTextEndStringBuilder(UtilText.parse(slave, "<h3 style='text-align:center; margin-bottom:0;'>\u4f60\u7684\u5974\u96b6[npc.name]\uff0c\u88c5\u5907\u4e86\u201c" + activeOutfit.getName() + "\u201d\u5957\u88c5\uff1a</h3>", new ParserTag[0]));
                            for (Map.Entry entry : activeOutfit.getWeapons().entrySet()) {
                                if (!failureToEquipMap.containsKey(entry.getKey())) {
                                    equipsList.add(LilayaDressingRoomDialogue.getOutfitEquipTextRow(equipType.EQUIP, Util.capitaliseSentence(((AbstractWeapon)entry.getValue()).getName(false, true))));
                                    continue;
                                }
                                failuresList.add(LilayaDressingRoomDialogue.getOutfitEquipTextRow(equipType.FAILED, Util.capitaliseSentence(((AbstractWeapon)entry.getValue()).getName(false, true))));
                            }
                            for (Map.Entry entry : activeOutfit.getClothing().entrySet()) {
                                if (!failureToEquipMap.containsKey(entry.getKey())) {
                                    equipsList.add(LilayaDressingRoomDialogue.getOutfitEquipTextRow(equipType.EQUIP, Util.capitaliseSentence(((AbstractClothing)entry.getValue()).getName(false, true))));
                                    continue;
                                }
                                failuresList.add(LilayaDressingRoomDialogue.getOutfitEquipTextRow(equipType.FAILED, Util.capitaliseSentence(((AbstractClothing)entry.getValue()).getName(false, true))));
                            }
                            for (Map.Entry entry : weaponsEquippedBeforeOutfitApplication.entrySet()) {
                                if (slave.getWeaponInSlot((InventorySlot)((Object)entry.getKey())) == entry.getValue()) continue;
                                unequipsList.add(LilayaDressingRoomDialogue.getOutfitEquipTextRow(equipType.UNEQUIP, Util.capitaliseSentence(((AbstractWeapon)entry.getValue()).getName(false, true))));
                            }
                            for (Map.Entry entry : clothingEquippedBeforeOutfitApplication.entrySet()) {
                                if (slave.getClothingInSlot((InventorySlot)((Object)entry.getKey())) == entry.getValue()) continue;
                                unequipsList.add(LilayaDressingRoomDialogue.getOutfitEquipTextRow(equipType.UNEQUIP, Util.capitaliseSentence(((AbstractClothing)entry.getValue()).getName(false, true))));
                            }
                            Main.game.appendToTextEndStringBuilder("<div class='container-full-width'>");
                            int i = 0;
                            for (String string : unequipsList) {
                                Main.game.appendToTextEndStringBuilder(LilayaDressingRoomDialogue.applyRowWrapper(string, i % 2 == 0));
                                ++i;
                            }
                            for (String string : equipsList) {
                                Main.game.appendToTextEndStringBuilder(LilayaDressingRoomDialogue.applyRowWrapper(string, i % 2 == 0));
                                ++i;
                            }
                            for (String string : failuresList) {
                                Main.game.appendToTextEndStringBuilder(LilayaDressingRoomDialogue.applyRowWrapper(string, i % 2 == 0));
                                ++i;
                            }
                            Main.game.appendToTextEndStringBuilder("</div>");
                            if (outfitObtainedViaPurchase) {
                                for (Map.Entry<InventorySlot, AbstractCoreItem> entry : failureToEquipMap.entrySet()) {
                                    if (entry.getValue() instanceof AbstractClothing && !((AbstractClothing)entry.getValue()).isDiscardedOnUnequip(entry.getKey())) {
                                        Main.game.getPlayerCell().getInventory().addClothing((AbstractClothing)entry.getValue());
                                        continue;
                                    }
                                    if (!(entry.getValue() instanceof AbstractWeapon)) continue;
                                    Main.game.getPlayerCell().getInventory().addWeapon((AbstractWeapon)entry.getValue());
                                }
                            }
                            LilayaDressingRoomDialogue.calculateOutfitAvailability();
                        }
                    });
                }
                for (int i = 0; i < slaveResponses.size(); ++i) {
                    if (index - 2 != i) continue;
                    return (Response)slaveResponses.get(i);
                }
                return null;
            }
        };
        inventoryUIWidth = 60.0f;
        mainClothingPanelWidth = 69.0f;
        OUTFIT_EDITOR_ITEM_CHOICE = new DialogueNode("\u9009\u62e9", "", true){

            @Override
            public void applyPreParsingEffects() {
                weaponSelected = null;
                clothingSelected = null;
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public String getHeaderContent() {
                StringBuilder sb = new StringBuilder();
                sb.append("<div class='container-full-width' style='width:100%; padding:0; margin:0 0 8px 0; text-align:center'>");
                sb.append("<h3 style='margin:0'>\u9009\u62e9[style.colourDisabled(-> \u67d3\u8272 -> \u9644\u9b54)]</h3>");
                sb.append("</div>");
                sb.append("<div class='container-full-width' style='width:100%; padding:0; margin:0 0 8px 0; text-align:center'>");
                sb.append("<p style='margin:0;'>");
                sb.append("<i>\u6240\u6709\u5df2\u7ecf\u53d1\u73b0\u7684" + (selectedSlot.isWeapon() ? "\u6b66\u5668" : "\u8863\u7269") + "\u90fd\u53ef\u4ee5\u9009\u62e9\u3002\u8fd9\u4f1a\u8003\u8651\u4f60\u201c\u5171\u4eab\u767e\u79d1\u5168\u4e66\u201d\u7684\u5185\u5bb9\u8bbe\u7f6e\u3002</i>");
                sb.append("</p>");
                sb.append("</div>");
                sb.append("<div class='container-full-width' style='width:100%; padding:0; margin:0;'>");
                sb.append("<div class='inventory-item-slot unequipped' style='background-color:" + Rarity.COMMON.getBackgroundColour().toWebHexString() + "; width:12%; margin:0.25%; padding:0;'><div class='inventory-icon-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskDelete() + "</div><div class='overlay' id='clear_slot' style='cursor:default;'></div></div>");
                sb.append("<div class='inventory-item-slot unequipped' style='background-color:" + Rarity.COMMON.getBackgroundColour().toWebHexString() + "; width:12%; margin:0.25%; padding:0;'><div class='inventory-icon-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDeniedIconDisabled() + "</div><div class='overlay' id='ignore_slot' style='cursor:default;'></div></div>");
                if (selectedSlot.isWeapon()) {
                    for (AbstractWeaponType weaponType : PhoneDialogue.getWeaponsDiscoveredList()) {
                        if (weaponType.getRarity() == Rarity.QUEST || weaponType.getRarity() == Rarity.LEGENDARY || weaponType.getItemTags().contains((Object)ItemTag.REMOVE_FROM_DRESSING_ROOM_OUTFITS)) continue;
                        boolean discovered = Main.getProperties().isWeaponDiscovered(weaponType) || Main.game.isDebugMode();
                        sb.append("<div class='inventory-item-slot unequipped' style='background-color:" + weaponType.getRarity().getBackgroundColour().toWebHexString() + "; width:12%; margin:0.25%; padding:0;'><div class='inventory-icon-content'>" + (discovered ? weaponType.getSVGImage() : "") + "</div>" + (String)(discovered ? "<div class='item-price'>" + UtilText.formatAsItemPrice(weaponType.getBaseValue()) + "</div>" : "") + "<div class='overlay" + (String)(discovered ? "' id='" + weaponType.getId() + "'" : " disabled-dark'") + " style='cursor:default;'></div></div>");
                    }
                } else {
                    for (AbstractClothingType clothingType : PhoneDialogue.getClothingDiscoveredList()) {
                        if (clothingType.getRarity() == Rarity.QUEST || clothingType.getRarity() == Rarity.LEGENDARY || clothingType.getDefaultItemTags().contains((Object)ItemTag.REMOVE_FROM_DRESSING_ROOM_OUTFITS) || clothingType.getDefaultItemTags().contains((Object)ItemTag.MILKING_EQUIPMENT) || !clothingType.getEquipSlots().contains((Object)selectedSlot)) continue;
                        boolean discovered = Main.getProperties().isClothingDiscovered(clothingType) || Main.game.isDebugMode();
                        ArrayList<AbstractClothing> incompatibleClothing = new ArrayList<AbstractClothing>();
                        for (InventorySlot slot : Main.game.getItemGen().generateClothing(clothingType, false).getIncompatibleSlots(LilayaDressingRoomDialogue.getDoll(), selectedSlot)) {
                            if (LilayaDressingRoomDialogue.getDoll().getClothingInSlot(slot) == null) continue;
                            incompatibleClothing.add(LilayaDressingRoomDialogue.getDoll().getClothingInSlot(slot));
                        }
                        ArrayList<Colour> clothingColours = new ArrayList<Colour>();
                        for (ColourReplacement cr : clothingType.getColourReplacements()) {
                            Util.random.setSeed(clothingType.getName().hashCode());
                            Colour colour = cr.getRandomOfDefaultColours();
                            clothingColours.add(colour);
                        }
                        sb.append("<div class='inventory-item-slot unequipped' style='background-color:" + clothingType.getRarity().getBackgroundColour().toWebHexString() + "; width:12%; margin:0.25%; padding:0;'>");
                        sb.append("<div class='inventory-icon-content'>" + (discovered ? clothingType.getSVGEquippedImage(Main.game.getPlayer(), selectedSlot, clothingColours, null, new ArrayList<Colour>(), null) : "") + "</div>");
                        if (discovered) {
                            if (!incompatibleClothing.isEmpty()) {
                                sb.append("<div class='item-price' style='top:8px; font-size:1.4em;'>[style.boldBad(!)]</div>");
                            }
                            sb.append("<div class='item-price'>" + UtilText.formatAsItemPrice(clothingType.getBaseValue()) + "</div>");
                        }
                        sb.append("<div class='overlay" + (String)(discovered ? "' id='" + clothingType.getId() + "'" : " disabled-dark'") + " style='cursor:default;'></div>");
                        sb.append("</div>");
                    }
                }
                Util.random.setSeed(System.nanoTime());
                sb.append("</div>");
                return sb.toString();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u8fd4\u56de\u670d\u88c5\u7f16\u8f91\u5668\u3002", OUTFIT_EDITOR);
                }
                return null;
            }
        };
        OUTFIT_EDITOR_ITEM_DYE = new DialogueNode("\u67d3\u8272", "", true){

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public String getHeaderContent() {
                StringBuilder sb = new StringBuilder();
                sb.append("<div class='container-full-width' style='width:100%; padding:0; margin:0;'>");
                sb.append("<h3 style='text-align:center'>[style.colourDisabled(\u9009\u62e9 ->)]\u67d3\u8272[style.colourDisabled(-> \u9644\u9b54)]</h3>");
                sb.append("</div>");
                if (clothingSelected != null) {
                    sb.append(LilayaDressingRoomDialogue.getClothingDyeUI());
                } else {
                    sb.append(LilayaDressingRoomDialogue.getWeaponDyeUI());
                }
                return sb.toString();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u7ee7\u7eed", "\u524d\u5f80\u9644\u9b54\u754c\u9762\u3002", OUTFIT_EDITOR_ITEM_ENCHANT){

                        @Override
                        public void effects() {
                            LilayaDressingRoomDialogue.initEnchantDialogue();
                        }
                    };
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u8fd4\u56de\u7269\u54c1\u9009\u62e9\u754c\u9762\u3002<br/>[style.italicsBad(\u5982\u679c\u4f60\u8fd9\u6837\u505a\uff0c\u5c06\u5931\u53bb\u6240\u6709\u7684\u4fee\u6539\u3002)]", OUTFIT_EDITOR_ITEM_CHOICE);
                }
                return null;
            }
        };
        OUTFIT_EDITOR_ITEM_ENCHANT = new DialogueNode("\u9644\u9b54", "", true){

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public String getHeaderContent() {
                StringBuilder sb = new StringBuilder();
                sb.append("<div class='container-full-width' style='width:100%; padding:0; margin:0;'>");
                sb.append("<h3 style='text-align:center'>[style.colourDisabled(\u9009\u62e9 -> \u67d3\u8272 ->)]\u9644\u9b54</h3>");
                sb.append("</div>");
                sb.append(LilayaDressingRoomDialogue.getEnchantmentUI());
                return sb.toString();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u786e\u8ba4", "\u4f7f\u7528\u8fd9\u4ef6\u7269\u54c1\u5e76\u8fd4\u56de\u670d\u88c5\u7f16\u8f91\u5668\u3002", OUTFIT_EDITOR){

                        @Override
                        public void effects() {
                            if (clothingSelected != null) {
                                AbstractClothing craftedClothing = EnchantingUtils.craftClothing(clothingSelected, effects);
                                activeOutfit.addClothing(selectedSlot, craftedClothing);
                                for (InventorySlot slot : craftedClothing.getIncompatibleSlots(LilayaDressingRoomDialogue.getDoll(), LilayaDressingRoomDialogue.getSelectedSlot())) {
                                    activeOutfit.addClothing(slot, null);
                                }
                                clothingSelected = null;
                            } else {
                                AbstractWeapon craftedWeapon = EnchantingUtils.craftWeapon(weaponSelected, effects);
                                activeOutfit.addWeapon(selectedSlot, craftedWeapon);
                                weaponSelected = null;
                            }
                            LilayaDressingRoomDialogue.calculateOutfitAvailability();
                        }
                    };
                }
                if (index == 4) {
                    boolean defaultsMissing = false;
                    for (ItemEffect ie : LilayaDressingRoomDialogue.getDefaultEffects(LilayaDressingRoomDialogue.getSelectedItem())) {
                        if (effects.contains(ie)) continue;
                        defaultsMissing = true;
                        break;
                    }
                    String helperText = "<br/><i>\u9ed8\u8ba4\u9644\u9b54\u5728\u8d2d\u4e70\u670d\u88c5\u65f6\u4e0d\u6d88\u8017\u7cbe\u534e\u3002</i>";
                    if (LilayaDressingRoomDialogue.getDefaultEffects(LilayaDressingRoomDialogue.getSelectedItem()).isEmpty()) {
                        return new Response("\u6062\u590d\u9ed8\u8ba4", "\u8be5\u7269\u54c1\u6ca1\u6709\u53ef\u6062\u590d\u7684\u9ed8\u8ba4\u9644\u9b54\u6548\u679c\u3002" + helperText, null);
                    }
                    if (!defaultsMissing) {
                        return new Response("\u6062\u590d\u9ed8\u8ba4", "\u8be5\u7269\u54c1\u5df2\u62e5\u6709\u5168\u90e8\u9ed8\u8ba4\u9644\u9b54\u6548\u679c\u3002" + helperText, null);
                    }
                    return new ResponseEffectsOnly("\u6062\u590d\u9ed8\u8ba4", "\u6062\u590d\u8be5\u7269\u54c1\u7684\u9ed8\u8ba4\u9644\u9b54\u6548\u679c\u3002" + helperText){

                        @Override
                        public void effects() {
                            int i = 0;
                            for (ItemEffect ie : LilayaDressingRoomDialogue.getDefaultEffects(LilayaDressingRoomDialogue.getSelectedItem())) {
                                effects.remove(ie);
                                effects.add(i, ie);
                                ++i;
                            }
                            Main.game.setContent(new Response("", "", OUTFIT_EDITOR_ITEM_ENCHANT));
                        }
                    };
                }
                if (index == 5) {
                    if (activeOutfit.getIconSlotPriority() != selectedSlot) {
                        return new ResponseEffectsOnly("\u56fe\u6807\uff1a[style.colourBad(\u5173\u95ed)]", (String)(activeOutfit.getIconSlotPriority() == null ? "\u8fd9\u5957\u670d\u88c5\u5f53\u524d\u4f7f\u7528\u7684\u662f\u6700\u9ad8\u4ef7\u503c\u7269\u54c1\u4f5c\u4e3a\u56fe\u6807\u3002" : "\u8fd9\u5957\u670d\u88c5\u5f53\u524d\u4f7f\u7528\u201c<i>" + activeOutfit.getIconSlotPriority().getName() + "</i>\u201d\u680f\u4f4d\u4f5c\u4e3a\u56fe\u6807\u3002") + "<br/>[style.italics(\u6fc0\u6d3b\u540e\uff0c\u8be5\u5957\u88c5\u5c06\u4f7f\u7528\u8be5\u680f\u4f4d(<i>" + selectedSlot.getName() + "</i>)\u4f5c\u4e3a\u5176\u9ed8\u8ba4\u56fe\u6807\u3002)]"){

                            @Override
                            public void effects() {
                                activeOutfit.setIconSlotPriority(selectedSlot);
                                Main.game.setContent(new Response("", "", OUTFIT_EDITOR_ITEM_ENCHANT));
                            }
                        };
                    }
                    return new ResponseEffectsOnly("\u56fe\u6807\uff1a[style.colourGood(\u5f00\u542f)]", "\u8fd9\u5957\u670d\u88c5\u5f53\u524d\u4f7f\u7528\u8be5\u680f\u4f4d(<i>" + selectedSlot.getName() + "</i>)\u4f5c\u4e3a\u5176\u9ed8\u8ba4\u56fe\u6807\u3002<br/>[style.italics(\u6fc0\u6d3b\u540e\uff0c\u8be5\u5957\u88c5\u5c06\u4f7f\u7528\u6700\u9ad8\u4ef7\u503c\u7684\u7269\u54c1\u4f5c\u4e3a\u5176\u56fe\u6807\u3002)]"){

                        @Override
                        public void effects() {
                            activeOutfit.setIconSlotPriority(null);
                            Main.game.setContent(new Response("", "", OUTFIT_EDITOR_ITEM_ENCHANT));
                        }
                    };
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u8fd4\u56de\u5230\u7269\u54c1\u9009\u62e9\u754c\u9762\u3002", OUTFIT_EDITOR_ITEM_DYE);
                }
                return null;
            }
        };
        effects = new ArrayList<ItemEffect>();
        primaryMod = TFModifier.NONE;
        secondaryMod = TFModifier.NONE;
        previousPrimaryMod = TFModifier.NONE;
        previousSecondaryMod = TFModifier.NONE;
        potency = TFPotency.MINOR_BOOST;
        limit = 0;
        outputName = "";
        INSTALLATION = new DialogueNode("\u66f4\u8863\u5ba4", "", true){

            @Override
            public int getSecondsPassed() {
                return 1800;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/lilayasHome/dressingRoom", "INSTALLATION");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u7ee7\u7eed", "\u4f60\u5df2\u7ecf\u628a\u8fd9\u4e2a\u623f\u95f4\u6539\u9020\u6210\u4e86\u66f4\u8863\u5ba4\uff0c\u73b0\u5728\u4f60\u5728\u8003\u8651\u662f\u5426\u8981\u4fee\u7406\u8389\u897f\u4e1d\u7684\u8863\u67dc\u2026\u2026", ROOM_DRESSING_ROOM);
                }
                return null;
            }
        };
        WARDROBE_ACTIVATION = new DialogueNode("\u66f4\u8863\u5ba4", "", true){

            @Override
            public int getSecondsPassed() {
                return 600;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/lilayasHome/dressingRoom", "WARDROBE_ACTIVATION");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u7ee7\u7eed", "\u8389\u897f\u4e1d\u7684\u8863\u67dc\u53c8\u53ef\u4ee5\u4f7f\u7528\u4e86\uff0c\u8ba9\u4f60\u80fd\u51ed\u7a7a\u521b\u9020\u51fa\u5404\u79cd\u5957\u88c5\u3002", ROOM_DRESSING_ROOM){

                        @Override
                        public void effects() {
                            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.dressingRoomLyssiethsWardrobeActivated, true);
                        }
                    };
                }
                return null;
            }
        };
    }

    private static enum equipType {
        UNEQUIP("\u5df2\u5378\u4e0b", PresetColour.BASE_BLUE_LIGHT, true),
        EQUIP("\u5df2\u88c5\u5907", PresetColour.GENERIC_GOOD, false),
        FAILED("\u88c5\u5907\u5931\u8d25", PresetColour.GENERIC_BAD, true);

        private String name;
        private Colour colour;
        private boolean droppedOnFloor;

        private equipType(String name, Colour colour, boolean droppedOnFloor) {
            this.name = name;
            this.colour = colour;
            this.droppedOnFloor = droppedOnFloor;
        }
    }
}

