/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.dominion.nyansApartment;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.npc.dominion.Nyan;
import com.lilithsthrone.game.character.npc.dominion.NyanMum;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.places.dominion.nyansApartment.NyanFirstDate;
import com.lilithsthrone.game.dialogue.places.dominion.shoppingArcade.ClothingEmporium;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.PlaceType;

public class NyanRepeatDate {
    private static int dateBill;
    private static float playerAlcoholIncrement;
    public static final DialogueNode DATE_START;
    public static final DialogueNode DATE_RESTAURANT_1_ARRIVED;
    public static final DialogueNode DATE_RESTAURANT_2_WINE_ORDER;
    public static final DialogueNode DATE_RESTAURANT_3_MAIN_DATE;
    public static final DialogueNode DATE_END_RETURN;
    public static final DialogueNode POST_DATE_APARTMENT_INTERVIEW_2_FOOD;
    public static final DialogueNode POST_DATE_APARTMENT_INTERVIEW_3_HISTORY;
    public static final DialogueNode POST_DATE_APARTMENT_INTERVIEW_4_STORE;
    public static final DialogueNode POST_DATE_APARTMENT_INTERVIEW_5_FLOWER;
    public static final DialogueNode POST_DATE_APARTMENT_INTERVIEW_6_BOOK;
    public static final DialogueNode POST_DATE_APARTMENT_INTERVIEW_PASS;

    private static Nyan getNyan() {
        return (Nyan)Main.game.getNpc(Nyan.class);
    }

    private static NyanMum getNyanMum() {
        return (NyanMum)Main.game.getNpc(NyanMum.class);
    }

    private static void travelTo(AbstractWorldType worldType, AbstractPlaceType placeType) {
        Main.game.getPlayer().setLocation(worldType, placeType);
        NyanRepeatDate.getNyan().setLocation(Main.game.getPlayer(), false);
    }

    static {
        playerAlcoholIncrement = 0.0f;
        DATE_START = new DialogueNode("", "", true){

            @Override
            public void applyPreParsingEffects() {
                dateBill = 0;
                NyanRepeatDate.getNyan().wearDress();
                NyanRepeatDate.getNyan().wearCoat(true, true);
                NyanRepeatDate.getNyanMum().setLocation(WorldType.EMPTY, PlaceType.GENERIC_EMPTY_TILE, true);
                NyanRepeatDate.travelTo(WorldType.NYANS_APARTMENT, PlaceType.NYAN_APARTMENT_ENTRANCE);
                Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanWeekendDated, true);
            }

            @Override
            public int getSecondsPassed() {
                return 600;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "DATE_START");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u9910\u5385", "\u966a\u59ae\u5b89\u53bb\u9910\u5385\u3002", DATE_RESTAURANT_1_ARRIVED);
                }
                return null;
            }
        };
        DATE_RESTAURANT_1_ARRIVED = new DialogueNode("", "", true){

            @Override
            public void applyPreParsingEffects() {
                NyanRepeatDate.getNyan().wearCoat(false, false);
                NyanRepeatDate.travelTo(WorldType.SHOPPING_ARCADE, PlaceType.SHOPPING_ARCADE_RESTAURANT);
                NyanRepeatDate.getNyanMum().setLocation(WorldType.NYANS_APARTMENT, PlaceType.NYAN_APARTMENT_SPARE_BEDROOM, true);
            }

            @Override
            public int getSecondsPassed() {
                return 900;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "DATE_RESTAURANT_1_ARRIVED");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    final int cost = 350;
                    return new Response("\u72d0\u72f8\u8461\u8404\u56ed(" + UtilText.formatAsMoney(cost, "span") + ")", "\u70b9\u9910\u5355\u4e0a\u6700\u4fbf\u5b9c\u7684\u8461\u8404\u9152\uff0c\u5c3d\u7ba1\u5982\u6b64\uff0c\u5b83\u4ecd\u7136\u662f\u4e00\u6b3e\u975e\u5e38\u597d\u7684\u4f73\u917f\u3002", DATE_RESTAURANT_2_WINE_ORDER){

                        @Override
                        public void effects() {
                            UtilText.addSpecialParsingString("\u72d0\u72f8\u8461\u8404\u56ed", true);
                            UtilText.addSpecialParsingString(Util.intToString(cost), false);
                            dateBill += cost;
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "DATE_RESTAURANT_2_VULPINE"));
                        }
                    };
                }
                if (index == 2) {
                    final int cost = 600;
                    return new Response("\u5929\u89d2\u517d\u7cbe\u9009 (" + UtilText.formatAsMoney(cost, "span") + ")", "\u70b9\u9910\u5355\u4e0a\u66f4\u6602\u8d35\u7684\u8461\u8404\u9152\u4e4b\u4e00\u3002", DATE_RESTAURANT_2_WINE_ORDER){

                        @Override
                        public void effects() {
                            UtilText.addSpecialParsingString("\u5929\u89d2\u517d\u7cbe\u9009", true);
                            UtilText.addSpecialParsingString(Util.intToString(cost), false);
                            dateBill += cost;
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "DATE_RESTAURANT_2_ALICORN"));
                            Main.game.getTextStartStringBuilder().append(ClothingEmporium.incrementAffection(NyanRepeatDate.getNyan(), 1.0f, 60.0f, 100.0f));
                        }
                    };
                }
                if (index == 3) {
                    final int cost = 950;
                    return new Response("\u5996\u72d0\u7684\u73cd\u85cf(" + UtilText.formatAsMoney(cost, "span") + ")", "\u70b9\u9910\u5355\u4e0a\u6700\u6602\u8d35\u7684\u8461\u8404\u9152\u3002", DATE_RESTAURANT_2_WINE_ORDER){

                        @Override
                        public void effects() {
                            UtilText.addSpecialParsingString("\u5996\u72d0\u7684\u73cd\u85cf", true);
                            UtilText.addSpecialParsingString(Util.intToString(cost), false);
                            dateBill += cost;
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "DATE_RESTAURANT_2_YOUKO"));
                            Main.game.getTextStartStringBuilder().append(ClothingEmporium.incrementAffection(NyanRepeatDate.getNyan(), 2.0f, 60.0f, 100.0f));
                        }
                    };
                }
                return null;
            }
        };
        DATE_RESTAURANT_2_WINE_ORDER = new DialogueNode("", "", true, true){

            @Override
            public int getSecondsPassed() {
                return 300;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "DATE_RESTAURANT_2_WINE_ORDER");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u5171\u4eab\u7f8e\u9152", "\u8bf4\u4f60\u4f1a\u548c\u59ae\u5b89\u5171\u4eab\u8fd9\u74f6\u9152\u3002", DATE_RESTAURANT_3_MAIN_DATE){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "DATE_RESTAURANT_3_SHARE"));
                            playerAlcoholIncrement = 0.1f;
                        }
                    };
                }
                if (index == 2) {
                    return new Response("\u6c34", "\u7ed9\u81ea\u5df1\u70b9\u4e00\u74f6\u6c34\u3002", DATE_RESTAURANT_3_MAIN_DATE){

                        @Override
                        public void effects() {
                            dateBill += 25;
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "DATE_RESTAURANT_3_WATER"));
                            playerAlcoholIncrement = 0.0f;
                        }
                    };
                }
                if (index == 3) {
                    return new Response("\u5564\u9152", "\u7ed9\u81ea\u5df1\u70b9\u4e00\u624e\u5564\u9152\u3002", DATE_RESTAURANT_3_MAIN_DATE){

                        @Override
                        public void effects() {
                            dateBill += 50;
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "DATE_RESTAURANT_3_BEER"));
                            playerAlcoholIncrement = 0.05f;
                        }
                    };
                }
                return null;
            }
        };
        DATE_RESTAURANT_3_MAIN_DATE = new DialogueNode("", "", true, true){

            @Override
            public void applyPreParsingEffects() {
                dateBill += 1200;
                NyanRepeatDate.getNyan().incrementAlcoholLevel(0.2f);
                Main.game.getPlayer().incrementAlcoholLevel(playerAlcoholIncrement * 2.0f);
            }

            @Override
            public int getSecondsPassed() {
                return 6000;
            }

            @Override
            public String getContent() {
                UtilText.addSpecialParsingString(Util.intToString(dateBill), true);
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "DATE_RESTAURANT_3_MAIN_DATE");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u79bb\u5f00(" + UtilText.formatAsMoney(dateBill, "span") + ")", "\u652f\u4ed8\u8d26\u5355\uff0c\u7136\u540e\u966a\u59ae\u5b89\u56de\u5979\u7684\u516c\u5bd3\u697c\u3002", DATE_END_RETURN){

                        @Override
                        public void effects() {
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().incrementMoney(-dateBill));
                        }
                    };
                }
                return null;
            }
        };
        DATE_END_RETURN = new DialogueNode("", "", true, true){

            @Override
            public void applyPreParsingEffects() {
                NyanRepeatDate.getNyanMum().setLocation(WorldType.NYANS_APARTMENT, PlaceType.NYAN_APARTMENT_LOUNGE);
                NyanRepeatDate.travelTo(WorldType.NYANS_APARTMENT, PlaceType.NYAN_APARTMENT_ENTRANCE);
                NyanRepeatDate.getNyan().wearCoat(false, true);
                AbstractClothing shoes = NyanRepeatDate.getNyan().getClothingInSlot(InventorySlot.FOOT);
                if (shoes != null) {
                    NyanRepeatDate.getNyan().unequipClothingIntoVoid(shoes, true, (GameCharacter)NyanRepeatDate.getNyan());
                }
                Main.game.getPlayer().applyFoodConsumed(10);
                Main.game.getPlayer().applyDrinkConsumed(10);
                NyanRepeatDate.getNyan().applyFoodConsumed(10);
                NyanRepeatDate.getNyan().applyDrinkConsumed(10);
            }

            @Override
            public int getSecondsPassed() {
                return 600;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "DATE_END_RETURN");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("[nyanmum.Name]", "\u662f\u65f6\u5019\u548c[nyanmum.name]\u518d\u6b21\u89c1\u9762\u4e86\u2026\u2026", POST_DATE_APARTMENT_INTERVIEW_2_FOOD);
                }
                return null;
            }
        };
        POST_DATE_APARTMENT_INTERVIEW_2_FOOD = new DialogueNode("", "", true, true){

            @Override
            public void applyPreParsingEffects() {
                NyanRepeatDate.travelTo(WorldType.NYANS_APARTMENT, PlaceType.NYAN_APARTMENT_LOUNGE);
            }

            @Override
            public int getSecondsPassed() {
                return 60;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "POST_DATE_APARTMENT_INTERVIEW_2_FOOD");
            }

            private void failEffects(String foodName) {
                UtilText.addSpecialParsingString(foodName, true);
                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "POST_DATE_APARTMENT_INTERVIEW_2_FOOD_FAIL"));
                Main.game.getTextStartStringBuilder().append(ClothingEmporium.incrementAffection(NyanRepeatDate.getNyan(), -1.0f, 60.0f, 100.0f));
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u6c99\u62c9", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u6700\u559c\u6b22\u7684\u98df\u7269\u662f\u6c99\u62c9\u3002", POST_DATE_APARTMENT_INTERVIEW_3_HISTORY){

                        @Override
                        public void effects() {
                            this.failEffects("\u6c99\u62c9");
                        }
                    };
                }
                if (index == 2) {
                    return new Response("\u63d0\u65af\u666e\u62c9\u91d1\u9cb7\u9c7c", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u6700\u559c\u6b22\u7684\u98df\u7269\u662f\u4e00\u9053\u9c7c\u505a\u7684\u83dc\uff0c\u540d\u4e3a\u201c\u63d0\u65af\u666e\u62c9\u91d1\u9cb7\u9c7c\u201d\u3002", POST_DATE_APARTMENT_INTERVIEW_3_HISTORY){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "POST_DATE_APARTMENT_INTERVIEW_2_FOOD_SUCCESS"));
                            Main.game.getTextStartStringBuilder().append(ClothingEmporium.incrementAffection(NyanRepeatDate.getNyanMum(), 1.0f, -20.0f, 20.0f));
                        }
                    };
                }
                if (index == 3) {
                    return new Response("\u62ab\u8428", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u6700\u559c\u6b22\u7684\u98df\u7269\u662f\u62ab\u8428\u3002", POST_DATE_APARTMENT_INTERVIEW_3_HISTORY){

                        @Override
                        public void effects() {
                            this.failEffects("\u62ab\u8428");
                        }
                    };
                }
                if (index == 4) {
                    return new Response("\u732b\u8584\u8377", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u6700\u559c\u6b22\u7684\u98df\u7269\u662f\u2018\u8346\u82a5\u2019\uff0c\u53c8\u540d\u732b\u8584\u8377\u3002", POST_DATE_APARTMENT_INTERVIEW_3_HISTORY){

                        @Override
                        public void effects() {
                            this.failEffects("\u732b\u8584\u8377");
                        }
                    };
                }
                if (index == 5) {
                    return new Response("\u51b0\u6dc7\u6dcb", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u6700\u559c\u6b22\u7684\u98df\u7269\u662f\u51b0\u6dc7\u6dcb\u3002", POST_DATE_APARTMENT_INTERVIEW_3_HISTORY){

                        @Override
                        public void effects() {
                            this.failEffects("\u51b0\u6fc0\u51cc");
                        }
                    };
                }
                return null;
            }
        };
        POST_DATE_APARTMENT_INTERVIEW_3_HISTORY = new DialogueNode("", "", true, true){

            @Override
            public int getSecondsPassed() {
                return 60;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "POST_DATE_APARTMENT_INTERVIEW_3_HISTORY");
            }

            private void failEffects(String foodName) {
                UtilText.addSpecialParsingString(foodName, true);
                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "POST_DATE_APARTMENT_INTERVIEW_3_HISTORY_FAIL"));
                Main.game.getTextStartStringBuilder().append(ClothingEmporium.incrementAffection(NyanRepeatDate.getNyan(), -1.0f, 60.0f, 100.0f));
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u5b89\u6392\u65e5\u7a0b", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u4ee5\u524d\u6bcf\u5929\u65e9\u4e0a\u90fd\u4e3a\u5979\u5b89\u6392\u5f53\u5929\u7684\u65e5\u7a0b\u3002", POST_DATE_APARTMENT_INTERVIEW_4_STORE){

                        @Override
                        public void effects() {
                            this.failEffects("\u4e3a\u5979\u5b89\u6392\u65e5\u7a0b");
                        }
                    };
                }
                if (index == 2) {
                    return new Response("\u4eb2\u543b\u5979", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u4ee5\u524d\u6bcf\u5929\u65e9\u4e0a\u90fd\u4f1a\u4eb2\u543b\u5979\u3002", POST_DATE_APARTMENT_INTERVIEW_4_STORE){

                        @Override
                        public void effects() {
                            this.failEffects("\u543b\u5979");
                        }
                    };
                }
                if (index == 3) {
                    return new Response("\u5e8a\u4e0a\u65e9\u9910", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u4ee5\u524d\u6bcf\u5929\u65e9\u4e0a\u90fd\u4f1a\u505a\u597d\u65e9\u9910\u9001\u5230\u5979\u5e8a\u4e0a\u3002", POST_DATE_APARTMENT_INTERVIEW_4_STORE){

                        @Override
                        public void effects() {
                            this.failEffects("\u505a\u597d\u65e9\u9910\u9001\u5230\u5979\u5e8a\u4e0a");
                        }
                    };
                }
                if (index == 4) {
                    return new Response("\u70e4\u70b9\u5fc3", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u4ee5\u524d\u6bcf\u5929\u65e9\u4e0a\u90fd\u4f1a\u4e3a\u5979\u70e4\u70b9\u5fc3\u3002", POST_DATE_APARTMENT_INTERVIEW_4_STORE){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "POST_DATE_APARTMENT_INTERVIEW_3_HISTORY_SUCCESS"));
                            Main.game.getTextStartStringBuilder().append(ClothingEmporium.incrementAffection(NyanRepeatDate.getNyanMum(), 2.0f, -20.0f, 20.0f));
                        }
                    };
                }
                if (index == 5) {
                    return new Response("\u5f39\u94a2\u7434", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u4ee5\u524d\u6bcf\u5929\u65e9\u4e0a\u90fd\u4f1a\u4e3a\u5979\u5f39\u94a2\u7434\u3002", POST_DATE_APARTMENT_INTERVIEW_4_STORE){

                        @Override
                        public void effects() {
                            this.failEffects("\u7ed9\u5979\u5f39\u94a2\u7434");
                        }
                    };
                }
                return null;
            }
        };
        POST_DATE_APARTMENT_INTERVIEW_4_STORE = new DialogueNode("", "", true, true){

            @Override
            public int getSecondsPassed() {
                return 60;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "POST_DATE_APARTMENT_INTERVIEW_4_STORE");
            }

            private void failEffects(String foodName) {
                UtilText.addSpecialParsingString(foodName, true);
                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "POST_DATE_APARTMENT_INTERVIEW_4_STORE_FAIL"));
                Main.game.getTextStartStringBuilder().append(ClothingEmporium.incrementAffection(NyanRepeatDate.getNyan(), -1.0f, 60.0f, 100.0f));
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u592a\u7a7a", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u7684\u5546\u5e97\u4ee5\u524d\u53eb\u505a\u201c\u592a\u7a7a\u201d\u3002", POST_DATE_APARTMENT_INTERVIEW_5_FLOWER){

                        @Override
                        public void effects() {
                            this.failEffects("\u592a\u7a7a");
                        }
                    };
                }
                if (index == 2) {
                    return new Response("\u65f6\u5c1a\u5c0f\u5783\u573e", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u7684\u5546\u5e97\u4ee5\u524d\u53eb\u505a\u201c\u65f6\u5c1a\u5c0f\u5783\u573e\u201d\u3002", POST_DATE_APARTMENT_INTERVIEW_5_FLOWER){

                        @Override
                        public void effects() {
                            this.failEffects("\u65f6\u5c1a\u5c0f\u5783\u573e");
                        }
                    };
                }
                if (index == 3) {
                    return new Response("\u8fde\u8863\u88d9\u4e13\u5356\u5e97", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u7684\u5546\u5e97\u4ee5\u524d\u53eb\u505a\u201c\u8fde\u8863\u88d9\u4e13\u5356\u5e97\u201d\u3002", POST_DATE_APARTMENT_INTERVIEW_5_FLOWER){

                        @Override
                        public void effects() {
                            this.failEffects("\u8fde\u8863\u88d9\u4e13\u5356\u5e97");
                        }
                    };
                }
                if (index == 4) {
                    return new Response("[nyanmum.NamePos]\u7684\u6700\u4f73\u9009\u62e9", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u7684\u5546\u5e97\u4ee5\u524d\u53eb\u505a'[nyanmum.NamePos]\u7684\u6700\u4f73\u9009\u62e9'\u3002", POST_DATE_APARTMENT_INTERVIEW_5_FLOWER){

                        @Override
                        public void effects() {
                            this.failEffects("[nyanmum.NamePos]\u7684\u6700\u4f73\u9009\u62e9");
                        }
                    };
                }
                if (index == 5) {
                    return new Response("\u91d1\u4e1d\u94f6\u7ebf", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u7684\u5546\u5e97\u4ee5\u524d\u53eb\u505a\u201c\u91d1\u4e1d\u94f6\u7ebf\u201d\u3002", POST_DATE_APARTMENT_INTERVIEW_5_FLOWER){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "POST_DATE_APARTMENT_INTERVIEW_4_STORE_SUCCESS"));
                            Main.game.getTextStartStringBuilder().append(ClothingEmporium.incrementAffection(NyanRepeatDate.getNyanMum(), 3.0f, -20.0f, 20.0f));
                        }
                    };
                }
                return null;
            }
        };
        POST_DATE_APARTMENT_INTERVIEW_5_FLOWER = new DialogueNode("", "", true, true){

            @Override
            public int getSecondsPassed() {
                return 60;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "POST_DATE_APARTMENT_INTERVIEW_5_FLOWER");
            }

            private void failEffects(String foodName) {
                UtilText.addSpecialParsingString(foodName, true);
                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "POST_DATE_APARTMENT_INTERVIEW_5_FLOWER_FAIL"));
                Main.game.getTextStartStringBuilder().append(ClothingEmporium.incrementAffection(NyanRepeatDate.getNyan(), -1.0f, 60.0f, 100.0f));
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u96cf\u83ca", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u6700\u559c\u6b22\u7684\u82b1\u662f\u96cf\u83ca\u3002", POST_DATE_APARTMENT_INTERVIEW_6_BOOK){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "POST_DATE_APARTMENT_INTERVIEW_5_FLOWER_SUCCESS"));
                            Main.game.getTextStartStringBuilder().append(ClothingEmporium.incrementAffection(NyanRepeatDate.getNyanMum(), 4.0f, -20.0f, 20.0f));
                        }
                    };
                }
                if (index == 2) {
                    return new Response("\u90c1\u91d1\u9999", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u6700\u559c\u6b22\u7684\u82b1\u662f\u90c1\u91d1\u9999\u3002", POST_DATE_APARTMENT_INTERVIEW_6_BOOK){

                        @Override
                        public void effects() {
                            this.failEffects("\u90c1\u91d1\u9999");
                        }
                    };
                }
                if (index == 3) {
                    return new Response("\u73ab\u7470", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u6700\u559c\u6b22\u7684\u82b1\u662f\u73ab\u7470\u3002", POST_DATE_APARTMENT_INTERVIEW_6_BOOK){

                        @Override
                        public void effects() {
                            this.failEffects("\u73ab\u7470");
                        }
                    };
                }
                if (index == 4) {
                    return new Response("\u62a5\u6625\u82b1", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u6700\u559c\u6b22\u7684\u82b1\u662f\u62a5\u6625\u82b1\u3002", POST_DATE_APARTMENT_INTERVIEW_6_BOOK){

                        @Override
                        public void effects() {
                            this.failEffects("\u62a5\u6625\u82b1");
                        }
                    };
                }
                if (index == 5) {
                    return new Response("\u7ee3\u7403\u82b1", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u6700\u559c\u6b22\u7684\u82b1\u662f\u7ee3\u7403\u82b1\u3002", POST_DATE_APARTMENT_INTERVIEW_6_BOOK){

                        @Override
                        public void effects() {
                            this.failEffects("\u7ee3\u7403\u82b1");
                        }
                    };
                }
                return null;
            }
        };
        POST_DATE_APARTMENT_INTERVIEW_6_BOOK = new DialogueNode("", "", true, true){

            @Override
            public void applyPreParsingEffects() {
                Main.game.getPlayer().setKnowsCharacterArea(CoverableArea.VAGINA, NyanRepeatDate.getNyanMum(), true);
            }

            @Override
            public int getSecondsPassed() {
                return 120;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "POST_DATE_APARTMENT_INTERVIEW_6_BOOK");
            }

            private void failEffects(String foodName) {
                UtilText.addSpecialParsingString(foodName, true);
                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "POST_DATE_APARTMENT_INTERVIEW_6_BOOK_FAIL"));
                Main.game.getTextStartStringBuilder().append(ClothingEmporium.incrementAffection(NyanRepeatDate.getNyan(), -1.0f, 60.0f, 100.0f));
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u68a6\u9b47\u793c\u62dc\u5802", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u6700\u559c\u6b22\u7684\u4e66\u53eb\u505a\u201c\u68a6\u9b47\u793c\u62dc\u5802\u201d\u3002", POST_DATE_APARTMENT_INTERVIEW_PASS){

                        @Override
                        public void effects() {
                            this.failEffects("\u68a6\u9b47\u793c\u62dc\u5802");
                        }
                    };
                }
                if (index == 2) {
                    return new Response("\u5b54\u96c0\u7684\u8fdb\u5316", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u6700\u559c\u6b22\u7684\u4e66\u53eb\u505a\u201c\u5b54\u96c0\u7684\u8fdb\u5316\u201d\u3002", POST_DATE_APARTMENT_INTERVIEW_PASS){

                        @Override
                        public void effects() {
                            this.failEffects("\u5b54\u96c0\u7684\u8fdb\u5316");
                        }
                    };
                }
                if (index == 3) {
                    return new Response("\u516d\u6708\u7684\u4e00\u5929", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u6700\u559c\u6b22\u7684\u4e66\u53eb\u505a\u201c\u516d\u6708\u7684\u4e00\u5929\u201d\u3002", POST_DATE_APARTMENT_INTERVIEW_PASS){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "POST_DATE_APARTMENT_INTERVIEW_6_BOOK_SUCCESS"));
                            Main.game.getTextStartStringBuilder().append(ClothingEmporium.incrementAffection(NyanRepeatDate.getNyanMum(), 5.0f, -20.0f, 20.0f));
                        }
                    };
                }
                if (index == 4) {
                    return new Response("\u516b\u4e4b\u7b26\u53f7", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u6700\u559c\u6b22\u7684\u4e66\u53eb\u505a\u201c\u516b\u4e4b\u7b26\u53f7\u201d\u3002", POST_DATE_APARTMENT_INTERVIEW_PASS){

                        @Override
                        public void effects() {
                            this.failEffects("\u516b\u4e4b\u7b26\u53f7");
                        }
                    };
                }
                if (index == 5) {
                    return new Response("\u5e3d\u5b50\u4e4b\u4e3b", "\u544a\u8bc9[nyanmum.name]\uff0c\u59ae\u5b89\u6700\u559c\u6b22\u7684\u4e66\u53eb\u505a\u201c\u5e3d\u5b50\u4e4b\u4e3b\u201d\u3002", POST_DATE_APARTMENT_INTERVIEW_PASS){

                        @Override
                        public void effects() {
                            this.failEffects("\u5e3d\u5b50\u4e4b\u4e3b");
                        }
                    };
                }
                return null;
            }
        };
        POST_DATE_APARTMENT_INTERVIEW_PASS = new DialogueNode("", "", true, true){

            @Override
            public void applyPreParsingEffects() {
                Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanmumInterviewPassed, true);
                NyanRepeatDate.getNyanMum().setLocation(WorldType.NYANS_APARTMENT, PlaceType.NYAN_APARTMENT_SPARE_BEDROOM);
            }

            @Override
            public int getSecondsPassed() {
                return 300;
            }

            @Override
            public String getContent() {
                return UtilText.parseFromXMLFile("places/dominion/nyansApartment/repeatDate", "POST_DATE_APARTMENT_INTERVIEW_PASS");
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u62e5\u62b1", "\u770b\u8d77\u6765\u59ae\u5b89\u73b0\u5728\u771f\u7684\u9700\u8981\u4e00\u4e2a\u5b89\u6170\u7684\u62e5\u62b1\u3002", NyanFirstDate.POST_DATE_APARTMENT_BEDROOM);
                }
                return null;
            }
        };
    }
}

