/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.dominion.shoppingArcade;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.PlayerCharacter;
import com.lilithsthrone.game.character.attributes.AffectionLevel;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.npc.dominion.Nyan;
import com.lilithsthrone.game.character.quests.Quest;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.places.dominion.shoppingArcade.ShoppingArcadeDialogue;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseSex;
import com.lilithsthrone.game.dialogue.responses.ResponseTrade;
import com.lilithsthrone.game.dialogue.utils.GiftDialogue;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.sex.InitialSexActionInformation;
import com.lilithsthrone.game.sex.SexAreaOrifice;
import com.lilithsthrone.game.sex.SexAreaPenetration;
import com.lilithsthrone.game.sex.SexParticipantType;
import com.lilithsthrone.game.sex.SexType;
import com.lilithsthrone.game.sex.managers.dominion.nyan.SMNyanSex;
import com.lilithsthrone.game.sex.positions.SexPosition;
import com.lilithsthrone.game.sex.positions.slots.SexSlot;
import com.lilithsthrone.game.sex.positions.slots.SexSlotAgainstWall;
import com.lilithsthrone.game.sex.positions.slots.SexSlotStanding;
import com.lilithsthrone.game.sex.sexActions.baseActions.FingerVagina;
import com.lilithsthrone.game.sex.sexActions.baseActions.PenisMouth;
import com.lilithsthrone.game.sex.sexActions.baseActions.TongueAnus;
import com.lilithsthrone.game.sex.sexActions.baseActions.TongueMouth;
import com.lilithsthrone.game.sex.sexActions.baseActions.TongueVagina;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.Vector2i;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.PlaceType;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ClothingEmporium {
    public static final String NYAN_HIDING_DAY_ID = "nyanHidingDay";
    public static final DialogueNode EXTERIOR = new DialogueNode("\u59ae\u5b89\u670d\u88c5\u5e97(\u5916\u90e8)", "", false){

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/shoppingArcade/clothingEmporium", "NYAN_EXTERIOR");
        }

        @Override
        public String getResponseTabTitle(int index) {
            return ShoppingArcadeDialogue.getCoreResponseTab(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (responseTab == 0 && index == 1) {
                if (!Main.game.isHourBetween(9.0f, 20.0f)) {
                    return new Response("\u8fdb\u5165", "\u59ae\u5b89\u670d\u88c5\u5e97\u76ee\u524d\u5173\u95e8\u3002\u4f60\u5f97\u8fc7\u4e00\u4f1a\u518d\u6765\u2026\u2026", null);
                }
                if (Main.game.getDialogueFlags().values.contains(DialogueFlagValue.nyanIntroduced)) {
                    return new Response("\u8fdb\u5165", "\u8fdb\u5165\u59ae\u5b89\u670d\u88c5\u5546\u573a\u3002", SHOP_CLOTHING_REPEAT);
                }
                return new Response("\u8fdb\u5165", "\u8fdb\u5165\u59ae\u5b89\u670d\u88c5\u5546\u573a\u3002", SHOP_CLOTHING);
            }
            return ShoppingArcadeDialogue.getFastTravelResponses(responseTab, index);
        }
    };
    public static final DialogueNode SHOP_CLOTHING = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/shoppingArcade/clothingEmporium", "SHOP_CLOTHING");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u4ed3\u5e93", "\u59ae\u5b89\u8ba9\u4f60\u8fdb\u4e86\u4ed3\u5e93\u3002", SHOP_CLOTHING_STOCK_ROOM){

                    @Override
                    public void effects() {
                        Main.game.getDialogueFlags().values.add(DialogueFlagValue.nyanIntroduced);
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode SHOP_CLOTHING_STOCK_ROOM = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/shoppingArcade/clothingEmporium", "SHOP_CLOTHING_STOCK_ROOM");
        }

        @Override
        public String getResponseTabTitle(int index) {
            return SHOP_CLOTHING_REPEAT.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SHOP_CLOTHING_REPEAT.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode SHOP_CLOTHING_REPEAT = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getAuthor() {
            if (ClothingEmporium.getNyan().isPregnant() && !ClothingEmporium.getNyan().isCharacterReactedToPregnancy(Main.game.getPlayer())) {
                return "Duner";
            }
            return "Innoxia";
        }

        @Override
        public String getContent() {
            if (!Main.game.getCharactersPresent().contains(ClothingEmporium.getNyan())) {
                return UtilText.parseFromXMLFile("places/dominion/shoppingArcade/clothingEmporium", "SHOP_CLOTHING_REPEAT_NO_NYAN");
            }
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanHiding)) {
                if (Main.game.getDialogueFlags().getSavedLong(ClothingEmporium.NYAN_HIDING_DAY_ID) < (long)Main.game.getDayNumber()) {
                    return UtilText.parseFromXMLFile("places/dominion/shoppingArcade/clothingEmporium", "NYAN_HIDING_NEXT_DAY");
                }
                return UtilText.parseFromXMLFile("places/dominion/shoppingArcade/clothingEmporium", "NYAN_HIDING");
            }
            if (ClothingEmporium.getNyan().isVisiblyPregnant() && !ClothingEmporium.getNyan().isCharacterReactedToPregnancy(Main.game.getPlayer())) {
                return UtilText.parseFromXMLFile("places/dominion/shoppingArcade/clothingEmporium", "NYAN_GREETING_REPEAT_PREGNANT");
            }
            return UtilText.parseFromXMLFile("places/dominion/shoppingArcade/clothingEmporium", "NYAN_GREETING_REPEAT");
        }

        @Override
        public String getResponseTabTitle(int index) {
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanHiding) || !Main.game.getPlayer().isQuestCompleted(QuestLine.RELATIONSHIP_NYAN_HELP) || !Main.game.getCharactersPresent().contains(ClothingEmporium.getNyan())) {
                return null;
            }
            if (index == 0) {
                return "\u4ea4\u6613";
            }
            if (index == 1) {
                return "\u5bf9\u8bdd";
            }
            return null;
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanHiding)) {
                if (index == 1) {
                    if (Main.game.getDialogueFlags().getSavedLong(ClothingEmporium.NYAN_HIDING_DAY_ID) < (long)Main.game.getDayNumber()) {
                        return new Response("\u8ddf\u968f", "\u8ddf\u968f\u59ae\u5b89\u518d\u6b21\u8fdb\u5165\u4ed3\u5e93\uff0c\u542c\u542c\u5979\u60f3\u8bf4\u4ec0\u4e48\u3002", NYAN_HIDING_END){

                            @Override
                            public void effects() {
                                Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanHiding, false);
                            }
                        };
                    }
                    return new Response("\u79bb\u5f00", "\u73b0\u5728\u59ae\u5b89\u8eb2\u4e86\u8d77\u6765\uff0c\u5e97\u91cc\u53c8\u6ca1\u522b\u4eba\u5e2e\u624b\uff0c\u4f60\u6ca1\u4ec0\u4e48\u4e8b\u80fd\u505a\uff0c\u53ea\u80fd\u79bb\u5f00\u3002", EXTERIOR){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/shoppingArcade/clothingEmporium", "NYAN_HIDING_LEAVE"));
                        }
                    };
                }
                return null;
            }
            if (responseTab == 1) {
                float currentAffection = ClothingEmporium.getNyan().getAffection(Main.game.getPlayer());
                if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanDating)) {
                    if (index == 1) {
                        return new Response("\u5973\u670b\u53cb", "\u544a\u59ae\u5b89\u4f60\u6539\u53d8\u60f3\u6cd5\u4e86\uff0c\u73b0\u5728\u60f3\u8ba9\u5979\u5f53\u4f60\u7684\u5973\u670b\u53cb\u3002", NYAN_HIDING_END_SHOP){

                            @Override
                            public void effects() {
                                Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanDating, true);
                                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/shoppingArcade/clothingEmporium", "SHOP_CLOTHING_REPEAT_GIRLFRIEND"));
                                Main.game.setResponseTab(1);
                            }
                        };
                    }
                } else {
                    int requiredAffection;
                    if (index == 1) {
                        if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanTalkedTo)) {
                            return new Response("\u5bf9\u8bdd", "\u4f60\u4eca\u5929\u5df2\u7ecf\u8ddf\u59ae\u5b89\u4ea4\u8c08\u8fc7\u4e86\u3002\u660e\u5929\u624d\u80fd\u518d\u6b21\u5bf9\u8bdd\u3002", null);
                        }
                        return new Response("\u5bf9\u8bdd", "\u8ddf\u59ae\u5b89\u8c08\u4e00\u4f1a\u513f\uff0c\u66f4\u591a\u5730\u4e86\u89e3\u5979\u3002", ROMANCE_TALK){

                            @Override
                            public void effects() {
                                UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("characters/dominion/nyan", "NYAN_TALK_BASE"));
                                ArrayList<String> topics = Util.newArrayListOfValues("NYAN_NOVELS", "NYAN_WORK", "NYAN_HOBBIES", "NYAN_HOME");
                                long lowestValue = 1000000L;
                                for (String topic : topics) {
                                    if (Main.game.getDialogueFlags().getSavedLong(topic) >= lowestValue) continue;
                                    lowestValue = Main.game.getDialogueFlags().getSavedLong(topic);
                                }
                                long thanksJava = lowestValue;
                                topics.removeIf(s -> Main.game.getDialogueFlags().getSavedLong((String)s) > thanksJava);
                                String topicSelected = Util.randomItemFrom(topics);
                                if (Main.game.getDialogueFlags().getSavedLong("NYAN_NOVELS") == -1L) {
                                    topicSelected = "NYAN_NOVELS";
                                }
                                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/dominion/nyan", "NYAN_TALK_" + topicSelected));
                                Main.game.getDialogueFlags().incrementSavedLong(topicSelected, 1L);
                                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/dominion/nyan", "NYAN_TALK_FINAL"));
                                Main.game.getTextEndStringBuilder().append(ClothingEmporium.incrementAffection(ClothingEmporium.getNyan(), 2.0f, 30.0f, 50.0f));
                                Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanTalkedTo, true);
                                ClothingEmporium.applyRepeatMeetingReactionUpdates();
                            }
                        };
                    }
                    if (index == 2) {
                        if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanComplimented)) {
                            return new Response("\u79f0\u8d5e", "\u4f60\u4eca\u5929\u5df2\u7ecf\u79f0\u8d5e\u8fc7\u59ae\u5b89\u4e86\u3002\u660e\u5929\u624d\u80fd\u518d\u8fdb\u884c\u6b64\u52a8\u4f5c\u3002", null);
                        }
                        if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanTalkedTo) && currentAffection < 50.0f) {
                            return new Response("\u79f0\u8d5e", "\u4f60\u770b\u5f97\u51fa\u6765\uff0c\u5982\u679c\u4e0d\u5148\u8ddf\u59ae\u5b89\u8c08\u4e00\u8c08\u5c31\u53d1\u51fa\u6ea2\u7f8e\u4e4b\u8bcd\uff0c\u5fc5\u7136\u4f1a\u641e\u7838\u7684\u3002<br/>[style.italicsMinorBad(\u4f60\u9700\u8981\u5148\u8ddf\u59ae\u5b89\u4ea4\u8c08\u624d\u80fd\u79f0\u8d5e\u5979\uff01)]", null);
                        }
                        return new Response("\u79f0\u8d5e", "\u79f0\u8d5e\u59ae\u5b89\u7684\u5916\u8c8c\u548c\u54c1\u683c\u3002", ROMANCE_COMPLIMENT){

                            @Override
                            public void effects() {
                                Main.game.getTextEndStringBuilder().append(ClothingEmporium.incrementAffection(ClothingEmporium.getNyan(), 2.0f, 30.0f, 50.0f));
                                Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanComplimented, true);
                                ClothingEmporium.applyRepeatMeetingReactionUpdates();
                            }
                        };
                    }
                    if (index == 3) {
                        int requiredAffection2 = 40;
                        if (currentAffection < (float)requiredAffection2) {
                            return new Response("\u8c03\u60c5", "\u4f60\u770b\u5f97\u51fa\u6765\u73b0\u5728\u8ddf\u59ae\u5b89\u8c03\u60c5\u80af\u5b9a\u4e0d\u4f1a\u6709\u597d\u7ed3\u679c\u3002\u4f60\u5e94\u8be5\u5148\u591a\u4e86\u89e3\u5979\u4e00\u4e0b\u3002<br/>[style.italicsMinorBad(\u9700\u8981\u59ae\u5b89\u7684\u597d\u611f\u81f3\u5c11\u8fbe\u5230" + requiredAffection2 + "\u76ee\u524d\u662f" + currentAffection + "\u3002)]", null);
                        }
                        if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanFlirtedWith)) {
                            return new Response("\u8c03\u60c5", "\u4f60\u4eca\u5929\u5df2\u7ecf\u548c\u59ae\u5b89\u8c03\u60c5\u4e86\u3002\u4f60\u53ea\u80fd\u660e\u5929\u518d\u8c03\u60c5\u3002", null);
                        }
                        if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanTalkedTo) && currentAffection < 50.0f) {
                            return new Response("\u8c03\u60c5", "\u4f60\u770b\u5f97\u51fa\u6765\uff0c\u5982\u679c\u4e0d\u5148\u8ddf\u59ae\u5b89\u8c08\u4e00\u8c08\u5c31\u8ddf\u5979\u8c03\u60c5\uff0c\u5fc5\u7136\u4f1a\u641e\u7838\u7684\u3002<br/>[style.italicsMinorBad(\u4f60\u9700\u8981\u5148\u8ddf\u59ae\u5b89\u4ea4\u8c08\u624d\u80fd\u8ddf\u5979\u8c03\u60c5\uff01)]", null);
                        }
                        return new Response("\u8c03\u60c5", "\u548c\u59ae\u5b89\u8c03\u60c5\u4e00\u4e0b\u3002", ROMANCE_FLIRT){

                            @Override
                            public void effects() {
                                Main.game.getTextEndStringBuilder().append(ClothingEmporium.incrementAffection(ClothingEmporium.getNyan(), 3.0f, 30.0f, 50.0f));
                                Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanFlirtedWith, true);
                                ClothingEmporium.applyRepeatMeetingReactionUpdates();
                            }
                        };
                    }
                    if (index == 6) {
                        int requiredAffection3 = 50;
                        if (currentAffection < (float)requiredAffection3) {
                            return new Response("\u6563\u6b65", "\u4f60\u89c9\u5f97\u59ae\u5b89\u8fd8\u4e0d\u4f1a\u8ddf\u4f60\u6563\u6b65\u2026\u2026<br/>[style.italicsMinorBad(\u9700\u8981\u59ae\u5b89\u7684\u597d\u611f\u81f3\u5c11\u8fbe\u5230" + requiredAffection3 + "\u76ee\u524d\u662f" + currentAffection + "\u3002)]", null);
                        }
                        if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanWalked)) {
                            return new Response("\u6563\u6b65", "\u4f60\u4eca\u5929\u5df2\u7ecf\u8ddf\u59ae\u5b89\u6563\u8fc7\u6b65\u4e86\u3002\u660e\u5929\u624d\u80fd\u518d\u8fdb\u884c\u6b64\u52a8\u4f5c\u3002", null);
                        }
                        return new Response("\u6563\u6b65", "\u8be2\u95ee\u59ae\u5b89\u613f\u4e0d\u613f\u610f\u8ddf\u4f60\u4e00\u8d77\u53bb\u6563\u6b65\u3002", ROMANCE_WALK){

                            @Override
                            public void effects() {
                                Main.game.getTextEndStringBuilder().append(ClothingEmporium.incrementAffection(ClothingEmporium.getNyan(), 2.0f, 50.0f, 60.0f));
                                ClothingEmporium.applyRepeatMeetingReactionUpdates();
                            }
                        };
                    }
                    if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanFirstKissed)) {
                        if (index == 4) {
                            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanHeadPatted)) {
                                return new Response("\u6478\u5934", "\u4f60\u4eca\u5929\u5df2\u7ecf\u6478\u8fc7\u59ae\u5b89\u7684\u8111\u888b\u4e86\u3002\u660e\u5929\u624d\u80fd\u518d\u8fdb\u884c\u6b64\u52a8\u4f5c\u3002", null);
                            }
                            return new Response("\u6478\u5934", "\u6478\u6478\u59ae\u5b89\u7684\u8111\u888b\uff0c\u5938\u5979\u662f\u4e2a\u597d\u59d1\u5a18\u3002", ROMANCE_HEAD_PAT){

                                @Override
                                public void effects() {
                                    Main.game.getTextEndStringBuilder().append(ClothingEmporium.incrementAffection(ClothingEmporium.getNyan(), 2.0f, 50.0f, 60.0f));
                                    Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanHeadPatted, true);
                                    ClothingEmporium.applyRepeatMeetingReactionUpdates();
                                }
                            };
                        }
                        if (index == 5) {
                            if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanKissed)) {
                                return new Response("\u4eb2\u543b", "\u4f60\u4eca\u5929\u5df2\u7ecf\u4eb2\u8fc7\u59ae\u5b89\u4e86\u3002\u660e\u5929\u624d\u80fd\u518d\u8fdb\u884c\u6b64\u52a8\u4f5c\u3002", null);
                            }
                            return new Response("\u4eb2\u543b", "\u4f60\u4ece\u59ae\u5b89\u770b\u5411\u4f60\u7684\u76ee\u5149\u5c31\u80fd\u770b\u51fa\u5979\u8fd8\u60f3\u518d\u4eb2\u4e00\u6b21\u3002\u4e8e\u662f\u4f60\u9760\u4e86\u4e0a\u53bb\uff0c\u7ed9\u4e86\u5979\u60f3\u8981\u7684\u3002", ROMANCE_KISS){

                                @Override
                                public void effects() {
                                    Main.game.getTextEndStringBuilder().append(ClothingEmporium.incrementAffection(ClothingEmporium.getNyan(), 5.0f, 50.0f, 60.0f));
                                    Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanKissed, true);
                                    ClothingEmporium.applyRepeatMeetingReactionUpdates();
                                }
                            };
                        }
                        if (index == 7) {
                            requiredAffection = 60;
                            if (currentAffection < (float)requiredAffection) {
                                return new Response("\u9910\u5385\u7ea6\u4f1a", "\u8003\u8651\u5230\u59ae\u5b89\u80c6\u602f\u548c\u654f\u611f\u7684\u6027\u683c\uff0c\u4f60\u9700\u8981\u786e\u5b9a\u5979\u80fd\u5426\u63a5\u53d7\u516c\u5f00\u7684\u7ea6\u4f1a\u2026\u2026<br/>[style.italicsMinorBad(\u9700\u8981\u59ae\u5b89\u7684\u597d\u611f\u81f3\u5c11\u8fbe\u5230" + requiredAffection + "\u76ee\u524d\u662f" + currentAffection + "\u3002)]", null);
                            }
                            if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanRestaurantDateRequested)) {
                                if (Main.game.getDayOfWeek() == DayOfWeek.FRIDAY || Main.game.getDayOfWeek() == DayOfWeek.SATURDAY) {
                                    return new Response("\u9910\u5385\u7ea6\u4f1a", "\u95ee\u95ee\u59ae\u5b89\u613f\u4e0d\u613f\u610f\u8ddf\u4f60\u53bb\u201c\u6a61\u6728\u6797\u836b\u201d\u9910\u5385\u7ea6\u4f1a\u3002<br/>[style.italicsMinorBad(\u8be5\u52a8\u4f5c\u4e0d\u80fd\u5728\u5468\u4e94\u548c\u5468\u516d\u4f7f\u7528\uff01)]", null);
                                }
                                return new Response("\u9910\u5385\u7ea6\u4f1a", "\u95ee\u95ee\u59ae\u5b89\u613f\u4e0d\u613f\u610f\u8ddf\u4f60\u53bb\u201c\u6a61\u6728\u6797\u836b\u201d\u9910\u5385\u7ea6\u4f1a\u3002", ROMANCE_DATE_REQUESTED){

                                    @Override
                                    public void effects() {
                                        ClothingEmporium.applyRepeatMeetingReactionUpdates();
                                    }
                                };
                            }
                        }
                    }
                    if ((currentAffection > 60.0f || Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanRestaurantDateCompleted)) && index == 7) {
                        if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanMakeOut)) {
                            return new Response("\u4eb2\u70ed", "\u4f60\u4eca\u5929\u5df2\u7ecf\u8ddf\u59ae\u5b89\u4eb2\u70ed\u8fc7\u4e86\u3002\u660e\u5929\u624d\u80fd\u518d\u8fdb\u884c\u6b64\u52a8\u4f5c\u3002", null);
                        }
                        return new Response("\u4eb2\u70ed", "\u4f60\u770b\u5f97\u51fa\u6765\u59ae\u5b89\u8feb\u4e0d\u53ca\u5f85\u5730\u60f3\u8ddf\u4f60\u6765\u4e00\u4e9b\u4eb2\u5bc6\u7684\u8eab\u4f53\u63a5\u89e6\uff0c\u4e8e\u662f\u4e5f\u70ed\u60c5\u5730\u4fef\u8eab\u8fc7\u53bb\uff0c\u4eb2\u70ed\u8d77\u6765\u3002", ROMANCE_MAKE_OUT){

                            @Override
                            public void effects() {
                                Main.game.getTextEndStringBuilder().append(ClothingEmporium.incrementAffection(ClothingEmporium.getNyan(), 5.0f, 60.0f, 100.0f));
                                Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanMakeOut, true);
                                ClothingEmporium.applyRepeatMeetingReactionUpdates();
                            }
                        };
                    }
                    if (index == 8 && ClothingEmporium.getNyan().isVisiblyPregnant()) {
                        if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanTummyRubbed)) {
                            return new Response("\u63c9\u809a\u5b50", "\u4f60\u4eca\u5929\u5df2\u7ecf\u63c9\u59ae\u5b89\u7684\u809a\u5b50\u4e86\u3002\u660e\u5929\u624d\u80fd\u518d\u8fdb\u884c\u6b64\u52a8\u4f5c\u3002", null);
                        }
                        return new Response("\u63c9\u809a\u5b50", "\u63c9\u63c9\u59ae\u5b89\u6000\u5b55\u7684\u5c0f\u809a\u5b50\uff0c\u95ee\u5979\u662f\u600e\u4e48\u5e94\u5bf9\u8fd9\u573a\u6000\u5b55\u7684\u3002", ROMANCE_RUB_TUMMY){

                            @Override
                            public void effects() {
                                Main.game.getTextEndStringBuilder().append(ClothingEmporium.incrementAffection(ClothingEmporium.getNyan(), 5.0f, 50.0f, 60.0f));
                                Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanTummyRubbed, true);
                                ClothingEmporium.applyRepeatMeetingReactionUpdates();
                            }
                        };
                    }
                    if (index == 10) {
                        requiredAffection = 40;
                        if (currentAffection < (float)requiredAffection) {
                            return new Response("\u9001\u793c", "\u5bf9\u4e8e\u73b0\u5728\u8fd8\u5341\u5206\u8106\u5f31\u7684\u732b\u5973\u6765\u8bf4\uff0c\u5979\u53ef\u80fd\u63a5\u53d7\u4e0d\u4e86\u6536\u5230\u793c\u7269\u7684\u611f\u53d7\u2026\u2026<br/>[style.italicsMinorBad(\u9700\u8981\u59ae\u5b89\u7684\u597d\u611f\u81f3\u5c11\u8fbe\u5230" + requiredAffection + "\u76ee\u524d\u662f" + currentAffection + "\u3002)]", null);
                        }
                        if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanGift)) {
                            return new Response("\u9001\u793c", "\u4f60\u4eca\u5929\u5df2\u7ecf\u9001\u7ed9\u8fc7\u59ae\u5b89\u793c\u7269\u4e86\u3002\u660e\u5929\u624d\u80fd\u518d\u8fdb\u884c\u6b64\u52a8\u4f5c\u3002", null);
                        }
                        return new Response("\u9001\u793c", "\u9001\u59ae\u5b89\u4e00\u4efd\u793c\u7269(\u6253\u5f00\u793c\u7269\u9009\u62e9\u754c\u9762)\u3002", ROMANCE_GIFT){

                            @Override
                            public DialogueNode getNextDialogue() {
                                return GiftDialogue.getGiftDialogue(ClothingEmporium.getNyan(), ROMANCE_GIFT, 1);
                            }

                            @Override
                            public void effects() {
                                ClothingEmporium.applyRepeatMeetingReactionUpdates();
                            }
                        };
                    }
                }
                if (index == 0) {
                    return new Response("\u79bb\u5f00", "\u8ddf\u59ae\u5b89\u8bf4\u4f60\u6709\u522b\u7684\u4e8b\u60c5\u8981\u505a\u3002", EXTERIOR){

                        @Override
                        public void effects() {
                            Main.game.setResponseTab(0);
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/shoppingArcade/clothingEmporium", "NYAN_EXIT"));
                            ClothingEmporium.applyRepeatMeetingReactionUpdates();
                        }
                    };
                }
                return null;
            }
            if (responseTab == 0) {
                String descriptionStart = "\u95ee\u5979";
                if (!Main.game.getCharactersPresent().contains(ClothingEmporium.getNyan())) {
                    descriptionStart = "\u770b\u4e00\u773c";
                }
                if (index == 1) {
                    return new ResponseTrade("\u5973\u6027\u8863\u7269", descriptionStart + "\u6709\u4ec0\u4e48\u5973\u6027\u8863\u7269\u3002", ClothingEmporium.getNyan()){

                        @Override
                        public void effects() {
                            ClothingEmporium.getNyan().clearNonEquippedInventory(false);
                            for (AbstractClothing c : ClothingEmporium.getNyan().getCommonFemaleClothing()) {
                                if (ClothingEmporium.getNyan().isInventoryFull()) break;
                                ClothingEmporium.getNyan().addClothing(c, false);
                            }
                        }
                    };
                }
                if (index == 2) {
                    return new ResponseTrade("\u5973\u6027\u5185\u8863", descriptionStart + "\u6709\u4ec0\u4e48\u5973\u6027\u5185\u8863\u3002", ClothingEmporium.getNyan()){

                        @Override
                        public void effects() {
                            ClothingEmporium.getNyan().clearNonEquippedInventory(false);
                            for (AbstractClothing c : ClothingEmporium.getNyan().getCommonFemaleUnderwear()) {
                                if (ClothingEmporium.getNyan().isInventoryFull()) break;
                                ClothingEmporium.getNyan().addClothing(c, false);
                            }
                        }
                    };
                }
                if (index == 3) {
                    return new ResponseTrade("\u5973\u6027\u914d\u4ef6", descriptionStart + "\u6709\u4ec0\u4e48\u5973\u6027\u914d\u4ef6\u3002", ClothingEmporium.getNyan()){

                        @Override
                        public void effects() {
                            ClothingEmporium.getNyan().clearNonEquippedInventory(false);
                            for (AbstractClothing c : ClothingEmporium.getNyan().getCommonFemaleAccessories()) {
                                if (ClothingEmporium.getNyan().isInventoryFull()) break;
                                ClothingEmporium.getNyan().addClothing(c, false);
                            }
                        }
                    };
                }
                if (index == 6) {
                    return new ResponseTrade("\u7537\u6027\u8863\u7269", descriptionStart + "\u6709\u4ec0\u4e48\u7537\u6027\u8863\u7269\u3002", ClothingEmporium.getNyan()){

                        @Override
                        public void effects() {
                            ClothingEmporium.getNyan().clearNonEquippedInventory(false);
                            for (AbstractClothing c : ClothingEmporium.getNyan().getCommonMaleClothing()) {
                                if (ClothingEmporium.getNyan().isInventoryFull()) break;
                                ClothingEmporium.getNyan().addClothing(c, false);
                            }
                        }
                    };
                }
                if (index == 7) {
                    return new ResponseTrade("\u7537\u6027\u5185\u8863", descriptionStart + "\u6709\u4ec0\u4e48\u7537\u6027\u5185\u8863\u3002", ClothingEmporium.getNyan()){

                        @Override
                        public void effects() {
                            ClothingEmporium.getNyan().clearNonEquippedInventory(false);
                            for (AbstractClothing c : ClothingEmporium.getNyan().getCommonMaleLingerie()) {
                                if (ClothingEmporium.getNyan().isInventoryFull()) break;
                                ClothingEmporium.getNyan().addClothing(c, false);
                            }
                        }
                    };
                }
                if (index == 8) {
                    return new ResponseTrade("\u7537\u6027\u914d\u4ef6", descriptionStart + "\u6709\u4ec0\u4e48\u7537\u6027\u914d\u4ef6\u3002", ClothingEmporium.getNyan()){

                        @Override
                        public void effects() {
                            ClothingEmporium.getNyan().clearNonEquippedInventory(false);
                            for (AbstractClothing c : ClothingEmporium.getNyan().getCommonMaleAccessories()) {
                                if (ClothingEmporium.getNyan().isInventoryFull()) break;
                                ClothingEmporium.getNyan().addClothing(c, false);
                            }
                        }
                    };
                }
                if (index == 11) {
                    return new ResponseTrade("\u901a\u7528\u670d\u88c5", descriptionStart + "\u901a\u7528\u670d\u88c5\u76ee\u524d\u53ef\u7528\u3002", ClothingEmporium.getNyan()){

                        @Override
                        public void effects() {
                            ClothingEmporium.getNyan().clearNonEquippedInventory(false);
                            for (AbstractClothing c : ClothingEmporium.getNyan().getCommonAndrogynousClothing()) {
                                if (ClothingEmporium.getNyan().isInventoryFull()) break;
                                ClothingEmporium.getNyan().addClothing(c, false);
                            }
                        }
                    };
                }
                if (index == 12) {
                    return new ResponseTrade("\u901a\u7528\u5185\u8863", descriptionStart + "\u6709\u4ec0\u4e48\u901a\u7528\u5185\u8863\u3002", ClothingEmporium.getNyan()){

                        @Override
                        public void effects() {
                            ClothingEmporium.getNyan().clearNonEquippedInventory(false);
                            for (AbstractClothing c : ClothingEmporium.getNyan().getCommonAndrogynousLingerie()) {
                                if (ClothingEmporium.getNyan().isInventoryFull()) break;
                                ClothingEmporium.getNyan().addClothing(c, false);
                            }
                        }
                    };
                }
                if (index == 13) {
                    return new ResponseTrade("\u901a\u7528\u914d\u4ef6", descriptionStart + "\u6709\u4ec0\u4e48\u901a\u7528\u914d\u4ef6\u3002", ClothingEmporium.getNyan()){

                        @Override
                        public void effects() {
                            ClothingEmporium.getNyan().clearNonEquippedInventory(false);
                            for (AbstractClothing c : ClothingEmporium.getNyan().getCommonAndrogynousAccessories()) {
                                if (ClothingEmporium.getNyan().isInventoryFull()) break;
                                ClothingEmporium.getNyan().addClothing(c, false);
                            }
                        }
                    };
                }
                if (index == 5) {
                    if (Main.game.getPlayer().isQuestCompleted(QuestLine.RELATIONSHIP_NYAN_HELP)) {
                        return new ResponseTrade("\u9644\u9b54\u8863\u7269", descriptionStart + "\u5e93\u5b58\u4e2d\u6709\u4ec0\u4e48\u7279\u6b8a\u8863\u7269\u3002", ClothingEmporium.getNyan()){

                            @Override
                            public void effects() {
                                ClothingEmporium.getNyan().clearNonEquippedInventory(false);
                                for (AbstractClothing c : ClothingEmporium.getNyan().getSpecials()) {
                                    if (ClothingEmporium.getNyan().isInventoryFull()) break;
                                    ClothingEmporium.getNyan().addClothing(c, false);
                                }
                            }
                        };
                    }
                    if (!Main.game.getPlayer().hasQuest(QuestLine.RELATIONSHIP_NYAN_HELP)) {
                        return new Response("\u9644\u9b54\u8863\u7269", "\u8be2\u95ee\u59ae\u5b89\u662f\u5426\u6709\u9644\u9b54\u8863\u7269\u5356\u3002<br/>[style.italicsQuestRomance(\u5c06\u4f1a\u5f00\u542f\u59ae\u5b89\u7684\u6d6a\u6f2b\u4efb\u52a1\uff01)]", SHOP_ENCHANTED_CLOTHING){

                            @Override
                            public void effects() {
                                Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().startQuest(QuestLine.RELATIONSHIP_NYAN_HELP));
                            }

                            @Override
                            public Colour getHighlightColour() {
                                return PresetColour.QUEST_RELATIONSHIP;
                            }
                        };
                    }
                    if (Main.game.getPlayer().getQuest(QuestLine.RELATIONSHIP_NYAN_HELP) == Quest.RELATIONSHIP_NYAN_4_STOCK_ISSUES_SUPPLIERS_BEATEN) {
                        return new Response("\u62a5\u544a", "\u544a\u8bc9\u59ae\u5b89\u4f9b\u8d27\u7684\u95ee\u9898\u5df2\u7ecf\u89e3\u51b3\u4e86\u3002", SHOP_REPORT_BACK){

                            @Override
                            public void effects() {
                                ClothingEmporium.getNyan().setSellModifier(1.25f);
                                Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().incrementMoney(5000L));
                                Main.game.getTextEndStringBuilder().append(ClothingEmporium.getNyan().setAffection(Main.game.getPlayer(), 30.0f));
                                Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.RELATIONSHIP_NYAN_HELP, Quest.SIDE_UTIL_COMPLETE));
                            }
                        };
                    }
                    if (Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.RELATIONSHIP_NYAN_HELP, Quest.RELATIONSHIP_NYAN_1_STOCK_ISSUES)) {
                        return new Response("\u62a5\u544a", "\u89e3\u51b3\u4f9b\u8d27\u95ee\u9898\u540e\u518d\u5411\u59ae\u5b89\u62a5\u544a\u3002", null);
                    }
                    return new Response("\u63d0\u4f9b\u5e2e\u52a9", "\u544a\u8bc9\u59ae\u5b89\u4f60\u53ef\u4ee5\u5e2e\u5979\u89e3\u51b3\u4f9b\u8d27\u95ee\u9898\u3002", SHOP_OFFER_HELP){

                        @Override
                        public void effects() {
                            Main.game.getTextEndStringBuilder().append(ClothingEmporium.getNyan().setAffection(Main.game.getPlayer(), 10.0f));
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.RELATIONSHIP_NYAN_HELP, Quest.RELATIONSHIP_NYAN_2_STOCK_ISSUES_AGREED_TO_HELP));
                        }
                    };
                }
                if (index == 0) {
                    return new Response("\u79bb\u5f00", "\u8ddf\u59ae\u5b89\u8bf4\u4f60\u6709\u522b\u7684\u4e8b\u60c5\u8981\u505a\u3002", EXTERIOR){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/shoppingArcade/clothingEmporium", "NYAN_EXIT"));
                        }
                    };
                }
                return null;
            }
            return null;
        }
    };
    public static final DialogueNode SHOP_ENCHANTED_CLOTHING = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/shoppingArcade/clothingEmporium", "SHOP_ENCHANTED_CLOTHING");
        }

        @Override
        public String getResponseTabTitle(int index) {
            return SHOP_CLOTHING_REPEAT.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SHOP_CLOTHING_REPEAT.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode SHOP_OFFER_HELP = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/shoppingArcade/clothingEmporium", "SHOP_OFFER_HELP");
        }

        @Override
        public String getResponseTabTitle(int index) {
            return SHOP_CLOTHING_REPEAT.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SHOP_CLOTHING_REPEAT.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode SHOP_REPORT_BACK = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/shoppingArcade/clothingEmporium", "SHOP_REPORT_BACK");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 0) {
                return new Response("\u79bb\u5f00", "\u9000\u51fa\u5546\u5e97\u3002", EXTERIOR){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/shoppingArcade/clothingEmporium", "NYAN_EXIT_EMBARRASSED"));
                        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanHiding, true);
                        Main.game.getDialogueFlags().setSavedLong(ClothingEmporium.NYAN_HIDING_DAY_ID, Main.game.getDayNumber());
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode NYAN_HIDING_END = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/dominion/shoppingArcade/clothingEmporium", "NYAN_HIDING_END");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u5973\u670b\u53cb", "\u544a\u8bc9\u59ae\u5b89\u4f60\u613f\u610f\u8ba9\u5979\u6210\u4e3a\u4f60\u7684\u5973\u670b\u53cb\u3002", NYAN_HIDING_END_SHOP){

                    @Override
                    public void effects() {
                        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanDating, true);
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/shoppingArcade/clothingEmporium", "NYAN_HIDING_END_GIRLFRIEND"));
                        Main.game.setResponseTab(1);
                    }
                };
            }
            if (index == 2) {
                return new Response("\u62d2\u7edd", "\u544a\u8bc9\u59ae\u5b89\u4f60\u73b0\u5728\u8fd8\u6ca1\u51c6\u5907\u597d\u4ea4\u5973\u670b\u53cb\u3002<br/>[style.italicsMinorGood(\u4e4b\u540e\u5982\u679c\u6539\u53d8\u4e86\u4e3b\u610f\uff0c\u8fd8\u53ef\u4ee5\u8be2\u95ee\u59ae\u5b89\u80fd\u5426\u5f53\u4f60\u7684\u5973\u670b\u53cb\u3002)]", NYAN_HIDING_END_SHOP){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("places/dominion/shoppingArcade/clothingEmporium", "NYAN_HIDING_END_DECLINE"));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode NYAN_HIDING_END_SHOP = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return "";
        }

        @Override
        public String getResponseTabTitle(int index) {
            return SHOP_CLOTHING_REPEAT.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SHOP_CLOTHING_REPEAT.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode ROMANCE_TALK = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 3300;
        }

        @Override
        public String getContent() {
            return "";
        }

        @Override
        public String getResponseTabTitle(int index) {
            return SHOP_CLOTHING_REPEAT.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SHOP_CLOTHING_REPEAT.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode ROMANCE_COMPLIMENT = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("characters/dominion/nyan", "NYAN_COMPLIMENT_BASE"));
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("characters/dominion/nyan", "NYAN_COMPLIMENT"));
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("characters/dominion/nyan", "NYAN_COMPLIMENT_FINAL"));
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public String getResponseTabTitle(int index) {
            return SHOP_CLOTHING_REPEAT.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SHOP_CLOTHING_REPEAT.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode ROMANCE_FLIRT = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 600;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("characters/dominion/nyan", "NYAN_FLIRT_BASE"));
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("characters/dominion/nyan", "NYAN_FLIRT"));
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("characters/dominion/nyan", "NYAN_FLIRT_FINAL"));
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public String getResponseTabTitle(int index) {
            return SHOP_CLOTHING_REPEAT.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SHOP_CLOTHING_REPEAT.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode ROMANCE_HEAD_PAT = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 900;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("characters/dominion/nyan", "NYAN_HEAD_PAT_BASE"));
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("characters/dominion/nyan", "NYAN_HEAD_PAT"));
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("characters/dominion/nyan", "NYAN_HEAD_PAT_FINAL"));
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public String getResponseTabTitle(int index) {
            return SHOP_CLOTHING_REPEAT.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SHOP_CLOTHING_REPEAT.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode ROMANCE_KISS = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("characters/dominion/nyan", "NYAN_KISS_BASE"));
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("characters/dominion/nyan", "NYAN_KISS"));
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("characters/dominion/nyan", "NYAN_KISS_FINAL"));
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public String getResponseTabTitle(int index) {
            return SHOP_CLOTHING_REPEAT.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SHOP_CLOTHING_REPEAT.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode ROMANCE_RUB_TUMMY = new DialogueNode("", "", true, true){

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("characters/dominion/nyan", "NYAN_RUB_TUMMY"));
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public String getResponseTabTitle(int index) {
            return SHOP_CLOTHING_REPEAT.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SHOP_CLOTHING_REPEAT.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode ROMANCE_WALK = new DialogueNode("", "", true){

        @Override
        public void applyPreParsingEffects() {
            Cell destination = null;
            if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanWalked)) {
                destination = Main.game.getWorlds().get(WorldType.SHOPPING_ARCADE).getCell(PlaceType.SHOPPING_ARCADE_ASHLEYS_SHOP);
                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/dominion/nyan", "ROMANCE_WALK_INITIAL"));
            } else {
                LinkedHashMap places = Util.newHashMapOfValues(new Util.Value<AbstractPlaceType, String>(PlaceType.SHOPPING_ARCADE_ASHLEYS_SHOP, "ASHLEY"), new Util.Value<AbstractPlaceType, String>(PlaceType.SHOPPING_ARCADE_ANTIQUES, "ANTIQUES"), new Util.Value<AbstractPlaceType, String>(PlaceType.SHOPPING_ARCADE_KATES_SHOP, "KATE"), new Util.Value<AbstractPlaceType, String>(PlaceType.SHOPPING_ARCADE_PIXS_GYM, "PIX"), new Util.Value<AbstractPlaceType, String>(PlaceType.SHOPPING_ARCADE_RALPHS_SHOP, "RALPH"), new Util.Value<AbstractPlaceType, String>(PlaceType.SHOPPING_ARCADE_RESTAURANT, "RESTAURANT"), new Util.Value<AbstractPlaceType, String>(PlaceType.SHOPPING_ARCADE_VICKYS_SHOP, "VICKY"));
                AbstractPlaceType place = (AbstractPlaceType)Util.randomItemFrom(places.keySet());
                destination = Main.game.getWorlds().get(WorldType.SHOPPING_ARCADE).getCell(place);
                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/dominion/nyan", "ROMANCE_WALK_REPEAT_START"));
                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/dominion/nyan", "ROMANCE_WALK_REPEAT_" + (String)places.get(place)));
                Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/dominion/nyan", "ROMANCE_WALK_REPEAT_END"));
            }
            Cell finalDestination = Main.game.getWorlds().get(WorldType.SHOPPING_ARCADE).getClosestCell(destination.getLocation(), PlaceType.SHOPPING_ARCADE_PATH);
            Main.game.getPlayer().setLocation(WorldType.SHOPPING_ARCADE, finalDestination.getLocation(), false);
            ClothingEmporium.getNyan().setLocation(Main.game.getPlayer(), false);
        }

        @Override
        public int getSecondsPassed() {
            return 900;
        }

        @Override
        public String getContent() {
            return "";
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanFirstKissed)) {
                if (index == 1) {
                    return new Response("\u7ee7\u7eed", "\u7ee7\u7eed\u8ddf\u59ae\u5b89\u5728\u8d2d\u7269\u4e2d\u5fc3\u6563\u6b65\u3002", ROMANCE_WALK_INITIAL_CONTINUE);
                }
            } else {
                if (index == 1) {
                    return new Response("\u8fd4\u56de", "\u8ddf\u59ae\u5b89\u8d70\u56de\u5979\u7684\u5546\u5e97\u3002", ROMANCE_WALK_END){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/dominion/nyan", "ROMANCE_WALK_END_NO_EVENT"));
                        }
                    };
                }
                if (index == 2) {
                    if (!Main.game.getPlayer().hasArms()) {
                        return new Response("\u7275\u624b", "\u7531\u4e8e\u4f60\u6ca1\u6709\u624b\u81c2\uff0c\u65e0\u6cd5\u63e1\u4f4f\u59ae\u5b89\u7684\u624b\uff01", null);
                    }
                    if (Main.game.getPlayer().isArmMovementHindered()) {
                        return new Response("\u7275\u624b", "\u7531\u4e8e\u4f60\u7684[pc.arm]\u884c\u52a8\u53d7\u5230\u4e86\u8863\u7269\u7684\u963b\u788d\uff0c\u65e0\u6cd5\u5f88\u8212\u670d\u5730\u8ddf\u59ae\u5b89\u7275\u624b\uff01", null);
                    }
                    return new Response("\u7275\u624b", "\u8d70\u56de\u5546\u5e97\u7684\u8def\u4e0a\u8ddf\u59ae\u5b89\u7275\u624b\u3002", ROMANCE_WALK_END){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/dominion/nyan", "ROMANCE_WALK_END_HOLD_HANDS"));
                            Main.game.getTextEndStringBuilder().append(ClothingEmporium.incrementAffection(ClothingEmporium.getNyan(), 2.0f, 50.0f, 60.0f));
                        }
                    };
                }
                if (index == 3) {
                    if (!Main.game.getPlayer().isAbleToAccessCoverableArea(CoverableArea.MOUTH, true)) {
                        return new Response("\u63a5\u543b", "\u4f60\u4e0d\u80fd\u4f7f\u7528\u5634\u5df4\uff0c\u6240\u4ee5\u4f60\u65e0\u6cd5\u548c\u59ae\u5b89\u63a5\u543b\uff01", null);
                    }
                    return new Response("\u63a5\u543b", "\u8d81\u673a\u5728\u5927\u5ead\u5e7f\u4f17\u4e0b\u4eb2\u4e00\u4eb2\u59ae\u5b89\u3002", ROMANCE_WALK_END){

                        @Override
                        public void effects() {
                            Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/dominion/nyan", "ROMANCE_WALK_END_KISS"));
                            Main.game.getTextEndStringBuilder().append(ClothingEmporium.incrementAffection(ClothingEmporium.getNyan(), 5.0f, 50.0f, 60.0f));
                        }
                    };
                }
            }
            return null;
        }
    };
    public static final DialogueNode ROMANCE_WALK_INITIAL_CONTINUE = new DialogueNode("", "", true, true){

        @Override
        public void applyPreParsingEffects() {
            Cell destination = Main.game.getWorlds().get(WorldType.SHOPPING_ARCADE).getCell(PlaceType.SHOPPING_ARCADE_RESTAURANT);
            Cell finalDestination = Main.game.getWorlds().get(WorldType.SHOPPING_ARCADE).getClosestCell(destination.getLocation(), PlaceType.SHOPPING_ARCADE_PATH);
            Main.game.getPlayer().setLocation(WorldType.SHOPPING_ARCADE, finalDestination.getLocation(), false);
            ClothingEmporium.getNyan().setLocation(Main.game.getPlayer(), false);
        }

        @Override
        public int getSecondsPassed() {
            return 600;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/nyan", "ROMANCE_WALK_INITIAL_CONTINUE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u8fd4\u56de", "\u966a\u59ae\u5b89\u56de\u5979\u7684\u5546\u5e97\u3002", ROMANCE_WALK_INITIAL_END);
            }
            return null;
        }
    };
    public static final DialogueNode ROMANCE_WALK_INITIAL_END = new DialogueNode("", "", true, true){

        @Override
        public void applyPreParsingEffects() {
            Main.game.getPlayer().setLocation(WorldType.SHOPPING_ARCADE, PlaceType.SHOPPING_ARCADE_NYANS_SHOP, false);
            ClothingEmporium.getNyan().setLocation(Main.game.getPlayer(), false);
        }

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/nyan", "ROMANCE_WALK_INITIAL_END");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (!Main.game.getPlayer().isAbleToAccessCoverableArea(CoverableArea.MOUTH, true)) {
                    return new Response("\u63a5\u543b", "\u4f60\u4e0d\u80fd\u4f7f\u7528\u5634\u5df4\uff0c\u6240\u4ee5\u4f60\u65e0\u6cd5\u548c\u59ae\u5b89\u63a5\u543b\uff01", null);
                }
                return new Response("\u4eb2\u543b", "\u6293\u4f4f\u673a\u4f1a\u4eb2\u4eb2\u59ae\u5b89\u3002", ROMANCE_WALK_END){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/dominion/nyan", "ROMANCE_WALK_INITIAL_END_KISS"));
                        Main.game.getTextEndStringBuilder().append(ClothingEmporium.incrementAffection(ClothingEmporium.getNyan(), 5.0f, 50.0f, 60.0f));
                        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanFirstKissed, true);
                    }
                };
            }
            if (index == 2) {
                return new Response("\u8fd8\u662f\u7b97\u4e86", "\u4e4b\u540e\u4ecd\u7136\u53ef\u4ee5\u518d\u7ecf\u5386\u8fd9\u6bb5\u5267\u60c5\u2026\u2026", ROMANCE_WALK_END){

                    @Override
                    public void effects() {
                        Main.game.getTextStartStringBuilder().append(UtilText.parseFromXMLFile("characters/dominion/nyan", "ROMANCE_WALK_INITIAL_END_NO_KISS"));
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ROMANCE_WALK_END = new DialogueNode("", "", true, true){

        @Override
        public void applyPreParsingEffects() {
            Main.game.getPlayer().setLocation(WorldType.SHOPPING_ARCADE, PlaceType.SHOPPING_ARCADE_NYANS_SHOP, false);
            ClothingEmporium.getNyan().setLocation(Main.game.getPlayer(), false);
            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanWalked, true);
            Main.game.setResponseTab(1);
        }

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return "";
        }

        @Override
        public String getResponseTabTitle(int index) {
            return SHOP_CLOTHING_REPEAT.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SHOP_CLOTHING_REPEAT.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode ROMANCE_DATE_REQUESTED = new DialogueNode("", "", true, true){

        @Override
        public void applyPreParsingEffects() {
            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanRestaurantDateRequested, true);
            Cell shoppingArcadeCell = Main.game.getWorlds().get(WorldType.DOMINION).getCell(PlaceType.DOMINION_SHOPPING_ARCADE);
            Cell nyanApartmentCell = Main.game.getWorlds().get(WorldType.DOMINION).getCell(new Vector2i(shoppingArcadeCell.getLocation().getX() - 1, shoppingArcadeCell.getLocation().getY()));
            nyanApartmentCell.getPlace().setPlaceType(PlaceType.DOMINION_NYAN_APARTMENT);
        }

        @Override
        public int getSecondsPassed() {
            return 300;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/nyan", "ROMANCE_DATE_REQUESTED");
        }

        @Override
        public String getResponseTabTitle(int index) {
            return SHOP_CLOTHING_REPEAT.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SHOP_CLOTHING_REPEAT.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode ROMANCE_MAKE_OUT = new DialogueNode("", "", true){

        @Override
        public int getSecondsPassed() {
            return 900;
        }

        @Override
        public String getContent() {
            UtilText.nodeContentSB.setLength(0);
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("characters/dominion/nyan", "NYAN_MAKE_OUT_BASE"));
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("characters/dominion/nyan", "NYAN_MAKE_OUT"));
            UtilText.nodeContentSB.append(UtilText.parseFromXMLFile("characters/dominion/nyan", "NYAN_MAKE_OUT_FINAL"));
            return UtilText.nodeContentSB.toString();
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u7ee7\u7eed", "\u7ed3\u675f\u4eb2\u70ed\u73af\u8282\u3002", POST_MAKEOUT);
            }
            if (index == 2) {
                return new ResponseSex("\u8214\u9634", "\u5411\u6b32\u706b\u4e2d\u70e7\u7684\u732b\u5973\u5efa\u8bae\uff0c\u4f60\u53ef\u4ee5\u5728\u4ed3\u5e93\u91cc\u5e2e\u5979\u8214\u9634\u3002", true, true, new SMNyanSex(SexPosition.AGAINST_WALL, Util.newHashMapOfValues(new Util.Value<PlayerCharacter, SexSlot>(Main.game.getPlayer(), SexSlotAgainstWall.PERFORMING_ORAL_WALL)), Util.newHashMapOfValues(new Util.Value<Nyan, SexSlot>(ClothingEmporium.getNyan(), SexSlotAgainstWall.BACK_TO_WALL))){

                    @Override
                    public SexType getMainSexPreference(GameCharacter character, GameCharacter targetedCharacter) {
                        if (character.isPlayer()) {
                            return new SexType(SexParticipantType.NORMAL, SexAreaPenetration.TONGUE, SexAreaOrifice.VAGINA);
                        }
                        return new SexType(SexParticipantType.NORMAL, SexAreaOrifice.VAGINA, SexAreaPenetration.TONGUE);
                    }

                    @Override
                    public boolean isExposeAtStartOfSexMapRemoval(GameCharacter character) {
                        return false;
                    }
                }, null, null, POST_ORAL, UtilText.parseFromXMLFile("characters/dominion/nyan", "ROMANCE_MAKE_OUT_CUNNILINGUS")){

                    @Override
                    public List<InitialSexActionInformation> getInitialSexActions() {
                        return Util.newArrayListOfValues(new InitialSexActionInformation(Main.game.getPlayer(), ClothingEmporium.getNyan(), TongueVagina.CUNNILINGUS_START, false, true));
                    }
                };
            }
            if (index == 3) {
                return new ResponseSex("\u6307\u4ea4", "\u6380\u5f00\u59ae\u5b89\u7684\u8ff7\u4f60\u88d9\uff0c\u4e00\u9762\u4e0e\u5979\u4eb2\u543b\u4e00\u9762\u6307\u4ea4\u3002", true, true, new SMNyanSex(SexPosition.AGAINST_WALL, Util.newHashMapOfValues(new Util.Value<PlayerCharacter, SexSlot>(Main.game.getPlayer(), SexSlotAgainstWall.STANDING_WALL)), Util.newHashMapOfValues(new Util.Value<Nyan, SexSlot>(ClothingEmporium.getNyan(), SexSlotAgainstWall.BACK_TO_WALL))){

                    @Override
                    public SexType getMainSexPreference(GameCharacter character, GameCharacter targetedCharacter) {
                        if (character.isPlayer()) {
                            return new SexType(SexParticipantType.NORMAL, SexAreaPenetration.FINGER, SexAreaOrifice.VAGINA);
                        }
                        return new SexType(SexParticipantType.NORMAL, SexAreaOrifice.VAGINA, SexAreaPenetration.FINGER);
                    }

                    @Override
                    public boolean isExposeAtStartOfSexMapRemoval(GameCharacter character) {
                        return false;
                    }
                }, null, null, POST_ORAL, UtilText.parseFromXMLFile("characters/dominion/nyan", "ROMANCE_MAKE_OUT_FINGERING")){

                    @Override
                    public List<InitialSexActionInformation> getInitialSexActions() {
                        return Util.newArrayListOfValues(new InitialSexActionInformation(Main.game.getPlayer(), ClothingEmporium.getNyan(), TongueMouth.KISS_START, false, true), new InitialSexActionInformation(Main.game.getPlayer(), ClothingEmporium.getNyan(), FingerVagina.FINGERING_START, false, true));
                    }
                };
            }
            ArrayList<Response> receiveOralResponses = new ArrayList<Response>();
            boolean penisAccess = Main.game.getPlayer().isAbleToAccessCoverableArea(CoverableArea.PENIS, true);
            boolean vaginaAccess = Main.game.getPlayer().isAbleToAccessCoverableArea(CoverableArea.VAGINA, true);
            if (Main.game.getPlayer().hasPenisIgnoreDildo()) {
                if (!penisAccess) {
                    receiveOralResponses.add(new Response("\u63a5\u53d7\u53e3\u4ea4", "\u56e0\u4e3a\u4f60\u4e0d\u80fd\u4f7f\u7528\u81ea\u5df1\u7684\u9634\u830e\uff0c\u6240\u4ee5\u4f60\u6ca1\u6cd5\u8ba9\u59ae\u5b89\u5438\u4f60\u7684\u9e21\u5df4\uff01", null));
                } else {
                    receiveOralResponses.add(new ResponseSex("\u63a5\u53d7\u53e3\u4ea4", "\u8ba9\u59ae\u5b89\u8dea\u4e0b\u6765\uff0c\u5728\u4ed3\u5e93\u91cc\u8214\u4f60\u7684\u8089\u68d2\u3002", true, true, new SMNyanSex(Main.game.getPlayer().isTaur() ? SexPosition.STANDING : SexPosition.AGAINST_WALL, Util.newHashMapOfValues(new Util.Value<PlayerCharacter, SexSlot>(Main.game.getPlayer(), Main.game.getPlayer().isTaur() ? SexSlotStanding.STANDING_DOMINANT : SexSlotAgainstWall.BACK_TO_WALL)), Util.newHashMapOfValues(new Util.Value<Nyan, SexSlot>(ClothingEmporium.getNyan(), Main.game.getPlayer().isTaur() ? SexSlotStanding.PERFORMING_ORAL : SexSlotAgainstWall.PERFORMING_ORAL_WALL))){

                        @Override
                        public SexType getMainSexPreference(GameCharacter character, GameCharacter targetedCharacter) {
                            if (character.isPlayer()) {
                                return new SexType(SexParticipantType.NORMAL, SexAreaPenetration.PENIS, SexAreaOrifice.MOUTH);
                            }
                            return new SexType(SexParticipantType.NORMAL, SexAreaOrifice.MOUTH, SexAreaPenetration.PENIS);
                        }

                        @Override
                        public Map<GameCharacter, List<CoverableArea>> exposeAtStartOfSexMap() {
                            return Util.newHashMapOfValues(new Util.Value<PlayerCharacter, ArrayList<CoverableArea>>(Main.game.getPlayer(), Util.newArrayListOfValues(CoverableArea.PENIS)));
                        }

                        @Override
                        public boolean isExposeAtStartOfSexMapRemoval(GameCharacter character) {
                            return false;
                        }
                    }, null, null, POST_ORAL, UtilText.parseFromXMLFile("characters/dominion/nyan", "ROMANCE_MAKE_OUT_RECEIVE_BLOWJOB")){

                        @Override
                        public List<InitialSexActionInformation> getInitialSexActions() {
                            return Util.newArrayListOfValues(new InitialSexActionInformation(Main.game.getPlayer(), ClothingEmporium.getNyan(), PenisMouth.BLOWJOB_START, false, true));
                        }
                    });
                }
            }
            if (Main.game.getPlayer().hasVagina()) {
                if (!vaginaAccess) {
                    receiveOralResponses.add(new Response("\u63a5\u53d7\u8214\u9634", "\u56e0\u4e3a\u4f60\u7684\u9634\u90e8\u65e0\u6cd5\u88ab\u89e6\u53ca\uff0c\u6240\u4ee5\u4f60\u4e0d\u80fd\u8ba9\u59ae\u5b89\u7ed9\u4f60\u8214\u9634\uff01", null));
                } else {
                    receiveOralResponses.add(new ResponseSex("\u63a5\u53d7\u8214\u9634", "\u8ba9\u59ae\u5b89\u8dea\u4e0b\u6765\uff0c\u5728\u4ed3\u5e93\u4e2d\u7ed9\u4f60\u8214\u9634\u3002", true, true, new SMNyanSex(Main.game.getPlayer().isTaur() ? SexPosition.STANDING : SexPosition.AGAINST_WALL, Util.newHashMapOfValues(new Util.Value<PlayerCharacter, SexSlot>(Main.game.getPlayer(), Main.game.getPlayer().isTaur() ? SexSlotStanding.STANDING_DOMINANT : SexSlotAgainstWall.BACK_TO_WALL)), Util.newHashMapOfValues(new Util.Value<Nyan, SexSlot>(ClothingEmporium.getNyan(), Main.game.getPlayer().isTaur() ? SexSlotStanding.PERFORMING_ORAL_BEHIND : SexSlotAgainstWall.PERFORMING_ORAL_WALL))){

                        @Override
                        public SexType getMainSexPreference(GameCharacter character, GameCharacter targetedCharacter) {
                            if (character.isPlayer()) {
                                return new SexType(SexParticipantType.NORMAL, SexAreaOrifice.VAGINA, SexAreaPenetration.TONGUE);
                            }
                            return new SexType(SexParticipantType.NORMAL, SexAreaPenetration.TONGUE, SexAreaOrifice.VAGINA);
                        }

                        @Override
                        public Map<GameCharacter, List<CoverableArea>> exposeAtStartOfSexMap() {
                            return Util.newHashMapOfValues(new Util.Value<PlayerCharacter, ArrayList<CoverableArea>>(Main.game.getPlayer(), Util.newArrayListOfValues(CoverableArea.VAGINA)));
                        }

                        @Override
                        public boolean isExposeAtStartOfSexMapRemoval(GameCharacter character) {
                            return false;
                        }
                    }, null, null, POST_ORAL, UtilText.parseFromXMLFile("characters/dominion/nyan", "ROMANCE_MAKE_OUT_RECEIVE_CUNNILINGUS")){

                        @Override
                        public List<InitialSexActionInformation> getInitialSexActions() {
                            return Util.newArrayListOfValues(new InitialSexActionInformation(Main.game.getPlayer(), ClothingEmporium.getNyan(), TongueVagina.RECEIVING_CUNNILINGUS_START, false, true));
                        }
                    });
                }
            }
            if (Main.game.isAnalContentEnabled() && Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanmumDateCompleted)) {
                if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanAnalTalk)) {
                    receiveOralResponses.add(new Response("\u540e\u5ead\u5c1d\u8bd5", "\u95ee\u95ee\u59ae\u5b89\u613f\u4e0d\u613f\u610f\u8ddf\u4f60\u5c1d\u8bd5\u809b\u95e8\u7684\u65b0\u73a9\u6cd5\u3002", ANAL_TALK));
                } else {
                    receiveOralResponses.add(new ResponseSex("\u8fdb\u884c\u8214\u809b", "\u8ba9\u8fd9\u4e2a\u6b32\u706b\u4e2d\u70e7\u7684\u732b\u5973\u9732\u51fa\u5c41\u80a1\u6765\uff0c\u4e3a\u5979\u8214\u5f04\u5916\u7f18\u3002", true, true, new SMNyanSex(SexPosition.AGAINST_WALL, Util.newHashMapOfValues(new Util.Value<PlayerCharacter, SexSlot>(Main.game.getPlayer(), SexSlotAgainstWall.STANDING_WALL)), Util.newHashMapOfValues(new Util.Value<Nyan, SexSlot>(ClothingEmporium.getNyan(), SexSlotAgainstWall.FACE_TO_WALL))){

                        @Override
                        public SexType getMainSexPreference(GameCharacter character, GameCharacter targetedCharacter) {
                            if (character.isPlayer()) {
                                return new SexType(SexParticipantType.NORMAL, SexAreaPenetration.TONGUE, SexAreaOrifice.ANUS);
                            }
                            return new SexType(SexParticipantType.NORMAL, SexAreaOrifice.ANUS, SexAreaPenetration.TONGUE);
                        }

                        @Override
                        public Map<GameCharacter, List<CoverableArea>> exposeAtStartOfSexMap() {
                            return Util.newHashMapOfValues(new Util.Value<Nyan, ArrayList<CoverableArea>>(ClothingEmporium.getNyan(), Util.newArrayListOfValues(CoverableArea.ANUS)));
                        }

                        @Override
                        public boolean isExposeAtStartOfSexMapRemoval(GameCharacter character) {
                            return false;
                        }
                    }, null, null, POST_ORAL, UtilText.parseFromXMLFile("characters/dominion/nyan", "ROMANCE_MAKE_OUT_PERFORM_ANILINGUS")){

                        @Override
                        public List<InitialSexActionInformation> getInitialSexActions() {
                            return Util.newArrayListOfValues(new InitialSexActionInformation(Main.game.getPlayer(), ClothingEmporium.getNyan(), TongueAnus.ANILINGUS_START, false, true));
                        }
                    });
                }
            }
            if (index > 0 && index - 4 < receiveOralResponses.size()) {
                return (Response)receiveOralResponses.get(index - 4);
            }
            return null;
        }
    };
    public static final DialogueNode ANAL_TALK = new DialogueNode("", "", true, true){

        @Override
        public void applyPreParsingEffects() {
            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanAnalTalk, true);
        }

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/nyan", "ANAL_TALK");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return ROMANCE_MAKE_OUT.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode POST_MAKEOUT = new DialogueNode("", "", true){

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/nyan", "POST_MAKEOUT");
        }

        @Override
        public String getResponseTabTitle(int index) {
            return SHOP_CLOTHING_REPEAT.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SHOP_CLOTHING_REPEAT.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode POST_ORAL = new DialogueNode("\u7ed3\u675f", "\u59ae\u5b89\u5df2\u7ecf\u6ee1\u8db3\u4e86\u2026\u2026", true){

        @Override
        public void applyPreParsingEffects() {
            ClothingEmporium.getNyan().cleanAllDirtySlots(true);
            ClothingEmporium.getNyan().cleanAllClothing(false, false);
            Main.game.setResponseTab(1);
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("characters/dominion/nyan", "POST_ORAL");
        }

        @Override
        public String getResponseTabTitle(int index) {
            return SHOP_CLOTHING_REPEAT.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SHOP_CLOTHING_REPEAT.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode ROMANCE_GIFT = new DialogueNode("\u8d60\u9001\u793c\u7269", "", true, true){

        @Override
        public String getContent() {
            return "";
        }

        @Override
        public String getResponseTabTitle(int index) {
            return SHOP_CLOTHING_REPEAT.getResponseTabTitle(index);
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return SHOP_CLOTHING_REPEAT.getResponse(responseTab, index);
        }
    };

    public static String incrementAffection(GameCharacter character, float increment, float minimumLimit, float maximumLimit) {
        float currentAffection = character.getAffection(Main.game.getPlayer());
        if ((increment = increment >= 0.0f ? Math.min(increment, Math.max(0.0f, maximumLimit - currentAffection)) : Math.max(increment, Math.min(0.0f, minimumLimit - currentAffection))) == 0.0f || increment > 0.0f && currentAffection >= maximumLimit) {
            return "<p style='text-align:center'>" + UtilText.parse(character, "[style.italicsDisabled(\u6b64\u4e3e\u5e76\u6ca1\u6709\u8ba9[npc.Name]\u5bf9\u4f60\u66f4\u6709\u597d\u611f\u2026\u2026)]", new ParserTag[0]) + "<br/>" + AffectionLevel.getDescription(character, Main.game.getPlayer(), true) + "</p>";
        }
        if (increment < 0.0f && currentAffection <= minimumLimit) {
            return "<p style='text-align:center'>" + UtilText.parse(character, "[style.italicsDisabled(\u6b64\u4e3e\u5e76\u6ca1\u6709\u8ba9[npc.Name]\u5bf9\u4f60\u66f4\u6709\u597d\u611f\u2026\u2026)]", new ParserTag[0]) + "<br/>" + AffectionLevel.getDescription(character, Main.game.getPlayer(), true) + "</p>";
        }
        return character.incrementAffection(Main.game.getPlayer(), increment);
    }

    private static void applyRepeatMeetingReactionUpdates() {
        if (ClothingEmporium.getNyan().isVisiblyPregnant()) {
            ClothingEmporium.getNyan().setCharacterReactedToPregnancy(Main.game.getPlayer(), true);
        }
        if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanRestaurantDateCompleted) && !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.nyanmumInterviewPassed)) {
            Main.game.getDialogueFlags().setFlag(DialogueFlagValue.nyanApologised, true);
        }
    }

    private static Nyan getNyan() {
        return (Nyan)Main.game.getNpc(Nyan.class);
    }
}

