/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.dominion.slaverAlley;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.gender.Gender;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.utils.Util;
import java.util.ArrayList;
import java.util.List;

public class SlaveAuctionBidder {
    private String name;
    private AbstractSubspecies subspecies;
    private Gender gender;
    private List<String> biddingComments;
    private List<String> failedBidComments;
    private List<String> successfulBidComments;

    public SlaveAuctionBidder(AbstractSubspecies subspecies, Gender gender, List<String> biddingComments, List<String> failedBidComments, List<String> successfulBidComments) {
        this.subspecies = subspecies;
        this.gender = gender;
        this.biddingComments = biddingComments;
        this.failedBidComments = failedBidComments;
        this.successfulBidComments = successfulBidComments;
        this.name = gender.isFeminine() ? subspecies.getSingularFemaleName(null) : subspecies.getSingularMaleName(null);
    }

    public String getName(boolean withDeterminer) {
        if (withDeterminer) {
            return UtilText.generateSingularDeterminer(this.name) + this.name;
        }
        return this.name;
    }

    public AbstractSubspecies getRace() {
        return this.subspecies;
    }

    public Gender getGender() {
        return this.gender;
    }

    public List<String> getBiddingComments() {
        return this.biddingComments;
    }

    public String getRandomBiddingComment() {
        return this.biddingComments.get(Util.random.nextInt(this.biddingComments.size()));
    }

    public List<String> getFailedBidComments() {
        return this.failedBidComments;
    }

    public String getRandomFailedBiddingComment() {
        return this.failedBidComments.get(Util.random.nextInt(this.failedBidComments.size()));
    }

    public List<String> getSuccessfulBidComments() {
        return this.successfulBidComments;
    }

    public String getRandomSuccessfulBiddingComment() {
        return this.successfulBidComments.get(Util.random.nextInt(this.successfulBidComments.size()));
    }

    public static SlaveAuctionBidder generateNewSlaveAuctionBidder(NPC slave) {
        ArrayList<AbstractSubspecies> races = Util.newArrayListOfValues(Subspecies.CAT_MORPH, Subspecies.COW_MORPH, Subspecies.DEMON, Subspecies.DOG_MORPH, Subspecies.HARPY, Subspecies.HORSE_MORPH, Subspecies.HUMAN, Subspecies.SQUIRREL_MORPH, Subspecies.WOLF_MORPH);
        ArrayList<Gender> genders = Util.newArrayListOfValues(Gender.F_V_B_FEMALE, Gender.F_P_V_B_FUTANARI, Gender.M_P_MALE);
        AbstractSubspecies race = Util.randomItemFrom(races);
        Gender gender = Util.randomItemFrom(genders);
        ArrayList<String> biddingComments = Util.newArrayListOfValues("\u8fd9\u8089\u4fbf\u5668\u662f\u6211\u7684\u2026\u2026", "\u6211\u7684\u5974\u96b6\u60f3\u8981\u65b0\u73a9\u5177\u4e86\u2026\u2026", UtilText.parse((GameCharacter)slave, "\u6211\u53ef\u4ee5\u8ba9[npc.herHim]\u5728\u5993\u9662\u91cc\u5de5\u4f5c\u2026\u2026", new ParserTag[0]), UtilText.parse((GameCharacter)slave, "\u6211\u6253\u7b97\u8ba9[npc.herHim]\u53bb\u6324\u5976\u68da\u5de5\u4f5c\u2026\u2026", new ParserTag[0]), UtilText.parse((GameCharacter)slave, "[npc.She]\u770b\u8d77\u6765\u50cf\u662f\u4e2a\u4e0d\u9519\u7684\u5973\u4ec6\u2026\u2026", new ParserTag[0]));
        ArrayList<String> failedBidComments = Util.newArrayListOfValues("\u6211\u4ed8\u4e0d\u8d77\u4e86\u2026\u2026", "\u592a\u9ad8\u4e86\u2026\u2026", "\u8981\u4e0d\u8fd8\u662f\u62a2\u4e0b\u4e00\u4e2a\u5427\u2026\u2026");
        ArrayList<String> successfulBidComments = Util.newArrayListOfValues(UtilText.parse((GameCharacter)slave, "\u6211\u4e00\u56de\u5bb6\u5c31\u5f00\u59cb\u9a6f\u670d[npc.herHim]\u2026\u2026", new ParserTag[0]), UtilText.parse((GameCharacter)slave, "\u6211\u4f1a\u8ba9\u6211\u5176\u4ed6\u7684\u5974\u96b6\u9a6f\u670d[npc.herHim]\u2026\u2026", new ParserTag[0]), UtilText.parse((GameCharacter)slave, "\u6211\u76f8\u4fe1[npc.she]\u4f1a\u559c\u6b22\u5728\u6211\u7684\u5993\u9662\u91cc\u7684\u65b0\u751f\u6d3b\u2026\u2026", new ParserTag[0]), UtilText.parse((GameCharacter)slave, "\u6211\u76f8\u4fe1[npc.she]\u4f1a\u559c\u6b22\u5728\u6324\u5976\u68da\u91cc\u7684\u65b0\u751f\u6d3b\u2026\u2026", new ParserTag[0]));
        return new SlaveAuctionBidder(race, gender, biddingComments, failedBidComments, successfulBidComments);
    }
}

