/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.places.submission.rebelBase;

import com.lilithsthrone.game.character.quests.Quest;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceType;

public class RebelBase {
    public static final DialogueNode REBEL_BASE_ENTRANCE = new DialogueNode("\u6d1e\u7a9f\u5165\u53e3", "", false){

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 30;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/rebelBase", "ENTRANCE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                if (Main.game.getPlayer().isQuestProgressLessThan(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_ESCAPE)) {
                    return new Response("[style.colourBad(\u79bb\u5f00)]", "\u8fd9\u4e2a\u5730\u65b9\u770b\u8d77\u6765\u5f88\u4e0d\u7a33\u5b9a\uff0c\u968f\u65f6\u90fd\u53ef\u80fd\u574d\u584c\u3002\u4e0d\u7ba1\u8fd9\u91cc\u6709\u4ec0\u4e48\u79d8\u5bc6\uff0c\u6700\u597d\u8fd8\u662f\u8d81\u65e9\u79bb\u5f00\u3002<br/>[style.italicsBad(\u79bb\u5f00\u540e\uff0c\u4f60\u5c06\u65e0\u6cd5\u8fd4\u56de\u8be5\u533a\u57df\uff01)]", REBEL_BASE_COLLAPSE);
                }
                return new Response("[style.colourGood(\u79bb\u5f00)]", "\u4f60\u5df2\u7ecf\u770b\u5b8c\u4e86\u6240\u6709\u80fd\u627e\u5230\u7684\u4e1c\u897f\u3002\u6700\u597d\u8fd8\u662f\u8d81\u65e9\u79bb\u5f00\u3002<br/><i>\u79bb\u5f00\u540e\uff0c\u4f60\u5c06\u65e0\u6cd5\u8fd4\u56de\u8be5\u533a\u57df\uff01</i>", REBEL_BASE_COLLAPSE);
            }
            return null;
        }
    };
    public static final DialogueNode REBEL_BASE_COLLAPSE = new DialogueNode("\u554a\u54e6\u2026\u2026", "", true){

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 30;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/rebelBase", "REBEL_BASE_COLLAPSE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u8dd1\uff01", "\u8dd1\u8def\u6c42\u751f\uff01", REBEL_BASE_ESCAPE){

                    @Override
                    public void effects() {
                        if (Main.game.getPlayer().isQuestProgressGreaterThan(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_EXPLORATION)) {
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_REBEL_BASE, Quest.SIDE_UTIL_COMPLETE));
                        } else {
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestFailed(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_FAILED));
                        }
                        Main.game.getPlayer().setLocation(WorldType.BAT_CAVERNS, PlaceType.BAT_CAVERNS_REBEL_BASE_ENTRANCE_EXTERIOR);
                        Main.game.getPlayerCell().getPlace().setPlaceType(PlaceType.BAT_CAVERN_DARK);
                        Main.game.getPlayerCell().getPlace().setName(PlaceType.BAT_CAVERN_DARK.getName());
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode REBEL_BASE_ESCAPE = new DialogueNode("", "", false, true){

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 60;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/rebelBase", "REBEL_BASE_ESCAPE");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return PlaceType.BAT_CAVERN_DARK.getDialogue(false).getResponse(responseTab, index);
        }
    };
    public static final DialogueNode REBEL_BASE_CORRIDOR = new DialogueNode("\u4eba\u5de5\u6d1e\u7a74", "", false){

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 30;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/rebelBase", "CORRIDOR");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return null;
        }
    };
    public static final DialogueNode REBEL_BASE_SLEEPING_AREA = new DialogueNode("\u5e9f\u5f03\u4f11\u606f\u533a", "", false){

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 30;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/rebelBase", "SLEEPING_AREA");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u6253\u5f00\u50a8\u7269\u7bb1", "\u6253\u5f00\u50a8\u7269\u7bb1\u3002", REBEL_BASE_SLEEPING_AREA_SEARCHED){

                    @Override
                    public void effects() {
                        Main.game.getTextEndStringBuilder().append(UtilText.parseFromXMLFile("places/submission/rebelBase", "SLEEPING_AREA_CACHE_OPEN"));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addClothing(Main.game.getItemGen().generateClothing("dsg_hlf_equip_rbooniehat", false), 2, false, true));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addClothing(Main.game.getItemGen().generateClothing("dsg_hlf_equip_rtunic", false), 2, false, true));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addClothing(Main.game.getItemGen().generateClothing("dsg_hlf_equip_rtrousers", false), 2, false, true));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addClothing(Main.game.getItemGen().generateClothing("dsg_hlf_equip_vcboots", false), 2, false, true));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addClothing(Main.game.getItemGen().generateClothing("dsg_hlf_equip_rbrassard", false), 5, false, true));
                        Main.game.getPlayerCell().getPlace().setPlaceType(PlaceType.REBEL_BASE_SLEEPING_AREA_SEARCHED);
                        Main.game.getPlayerCell().getPlace().setName(PlaceType.REBEL_BASE_SLEEPING_AREA_SEARCHED.getName());
                    }
                };
            }
            if (index == 2) {
                return new Response("\u9605\u8bfb\u65e5\u8bb0", "\u770b\u770b\u65e5\u8bb0\u91cc\u6709\u4ec0\u4e48\u3002", REBEL_BASE_SLEEPING_AREA_JOURNAL_OPEN);
            }
            return null;
        }
    };
    public static final DialogueNode REBEL_BASE_SLEEPING_AREA_JOURNAL_OPEN = new DialogueNode("\u7834\u65e7\u7684\u65e5\u8bb0", "", true){

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 30;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/rebelBase", "SLEEPING_AREA_JOURNAL_OPEN");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1 && Main.game.getPlayerCell().getPlace().getPlaceType().equals(PlaceType.REBEL_BASE_SLEEPING_AREA)) {
                return new Response("\u5173\u95ed", "\u4f60\u770b\u591f\u4e86\u3002", REBEL_BASE_SLEEPING_AREA){

                    @Override
                    public void effects() {
                        if (Main.game.getPlayer().isQuestProgressLessThan(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_ESCAPE)) {
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_ESCAPE));
                        }
                    }
                };
            }
            if (index == 1 && Main.game.getPlayerCell().getPlace().getPlaceType().equals(PlaceType.REBEL_BASE_SLEEPING_AREA_SEARCHED)) {
                return new Response("\u5173\u95ed", "\u4f60\u770b\u591f\u4e86\u3002", REBEL_BASE_SLEEPING_AREA_SEARCHED){

                    @Override
                    public void effects() {
                        if (Main.game.getPlayer().isQuestProgressLessThan(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_ESCAPE)) {
                            Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().setQuestProgress(QuestLine.SIDE_REBEL_BASE, Quest.REBEL_BASE_ESCAPE));
                        }
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode REBEL_BASE_SLEEPING_AREA_SEARCHED = new DialogueNode("\u5e9f\u5f03\u4f11\u606f\u533a", "", false){

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 30;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/rebelBase", "SLEEPING_AREA_SEARCHED");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u6253\u5f00\u50a8\u7269\u7bb1", "\u4f60\u5df2\u7ecf\u6253\u5f00\u4e86\u50a8\u7269\u7bb1\u3002", null);
            }
            if (index == 2) {
                return new Response("\u9605\u8bfb\u65e5\u8bb0", "\u770b\u770b\u65e5\u8bb0\u91cc\u6709\u4ec0\u4e48\u3002", REBEL_BASE_SLEEPING_AREA_JOURNAL_OPEN);
            }
            return null;
        }
    };
    public static final DialogueNode REBEL_BASE_COMMON_AREA = new DialogueNode("\u5e9f\u5f03\u516c\u5171\u533a", "", false){

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 30;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/rebelBase", "COMMON_AREA");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u6253\u5f00\u67dc\u5b50", "\u6253\u5f00\u91d1\u5c5e\u67dc\u3002", COMMON_AREA_CACHE_OPEN){

                    @Override
                    public void effects() {
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addClothing(Main.game.getItemGen().generateClothing("dsg_hlf_equip_rwebbing", false), 3, false, true));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addClothing(Main.game.getItemGen().generateClothing("dsg_hlf_equip_sbandana", false), 1, false, true));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addClothing(Main.game.getItemGen().generateClothing("dsg_hlf_equip_rbandolier", false), 3, false, true));
                        Main.game.getPlayerCell().getPlace().setPlaceType(PlaceType.REBEL_BASE_COMMON_AREA_SEARCHED);
                        Main.game.getPlayerCell().getPlace().setName(PlaceType.REBEL_BASE_COMMON_AREA_SEARCHED.getName());
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode COMMON_AREA_CACHE_OPEN = new DialogueNode("\u5e9f\u5f03\u516c\u5171\u533a", "", false){

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/rebelBase", "COMMON_AREA_CACHE_OPEN");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return REBEL_BASE_COMMON_AREA_SEARCHED.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode REBEL_BASE_COMMON_AREA_SEARCHED = new DialogueNode("\u5e9f\u5f03\u516c\u5171\u533a", "", false){

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 30;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/rebelBase", "COMMON_AREA_SEARCHED");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u6253\u5f00\u67dc\u5b50", "\u4f60\u5df2\u7ecf\u6253\u5f00\u4e86\u67dc\u5b50\u3002", null);
            }
            return null;
        }
    };
    public static final DialogueNode REBEL_BASE_ARMORY = new DialogueNode("\u90e8\u5206\u584c\u65b9\u7684\u623f\u95f4", "", false){

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 30;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/rebelBase", "ARMORY");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u6253\u5f00\u888b\u5b50", "\u6253\u5f00\u5851\u6599\u888b\u3002", ARMORY_CACHE_OPEN){

                    @Override
                    public void effects() {
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addWeapon(Main.game.getItemGen().generateWeapon("dsg_hlf_weap_pbsmg"), 3, false, true));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addWeapon(Main.game.getItemGen().generateWeapon("dsg_hlf_weap_pboltrifle"), 2, false, true));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addWeapon(Main.game.getItemGen().generateWeapon("dsg_hlf_weap_pbrevolver"), 5, false, true));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addWeapon(Main.game.getItemGen().generateWeapon("dsg_hlf_weap_gbshotgun"), 1, false, true));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().addWeapon(Main.game.getItemGen().generateWeapon("dsg_hlf_weap_pbomb"), 10, false, true));
                        Main.game.getTextEndStringBuilder().append(UtilText.parseFromXMLFile("places/submission/rebelBase", "ARMORY_CACHE_OPEN_FIREBOMBS"));
                        Main.game.getTextEndStringBuilder().append(Main.game.getPlayer().startQuest(QuestLine.SIDE_REBEL_BASE_FIREBOMBS));
                        Main.game.getPlayerCell().getPlace().setPlaceType(PlaceType.REBEL_BASE_ARMORY_SEARCHED);
                        Main.game.getPlayerCell().getPlace().setName(PlaceType.REBEL_BASE_ARMORY_SEARCHED.getName());
                    }
                };
            }
            return null;
        }
    };
    public static final DialogueNode ARMORY_CACHE_OPEN = new DialogueNode("\u5e9f\u5f03\u516c\u5171\u533a", "", false){

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 120;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/rebelBase", "ARMORY_CACHE_OPEN");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return REBEL_BASE_ARMORY_SEARCHED.getResponse(responseTab, index);
        }
    };
    public static final DialogueNode REBEL_BASE_ARMORY_SEARCHED = new DialogueNode("\u90e8\u5206\u584c\u65b9\u7684\u623f\u95f4", "", false){

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 30;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/rebelBase", "ARMORY_SEARCHED");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            if (index == 1) {
                return new Response("\u6253\u5f00\u888b\u5b50", "\u8fd9\u7247\u5e9f\u589f\u4e2d\u6ca1\u6709\u503c\u5f97\u5e26\u8d70\u7684\u4e1c\u897f\u3002", null);
            }
            return null;
        }
    };
    public static final DialogueNode REBEL_BASE_CAVED_IN_ROOM = new DialogueNode("\u584c\u65b9\u7684\u623f\u95f4", "", false){

        @Override
        public String getAuthor() {
            return "DSG";
        }

        @Override
        public int getSecondsPassed() {
            return 30;
        }

        @Override
        public String getContent() {
            return UtilText.parseFromXMLFile("places/submission/rebelBase", "REBEL_BASE_CAVED_IN_ROOM");
        }

        @Override
        public Response getResponse(int responseTab, int index) {
            return null;
        }
    };
}

