/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.responses;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.dialogue.DialogueManager;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.main.Main;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResponseCombat
extends Response {
    private List<NPC> allies;
    private NPC enemyLeader;
    private List<NPC> enemies;
    private Map<GameCharacter, String> openingDescriptions;
    private List<String> alliesIds;
    private boolean addCompanionsToAllies;
    private boolean addElementalsToAllies;
    private String enemyLeaderId;
    private List<String> enemiesIds;
    private String nextDialoguePlayerVictoryId;
    private String nextDialoguePlayerDefeatId;
    private Map<String, String> openingDescriptionsUsingIds;
    private boolean escapeBlocked = false;
    private boolean submitBlocked = false;

    public ResponseCombat(String title, String tooltipText, NPC opponent) {
        super(title, tooltipText, null);
        this.allies = new ArrayList<NPC>();
        for (GameCharacter companion : Main.game.getPlayer().getCompanions()) {
            this.allies.add((NPC)companion);
        }
        this.addElementalsToAllies = true;
        this.enemyLeader = opponent;
        this.enemies = new ArrayList<NPC>();
        this.enemies.add(opponent);
        for (GameCharacter companion : opponent.getCompanions()) {
            this.enemies.add((NPC)companion);
        }
        this.openingDescriptions = new HashMap<GameCharacter, String>();
    }

    public ResponseCombat(String title, String tooltipText, NPC opponent, Map<GameCharacter, String> openingDescriptions) {
        super(title, tooltipText, null);
        this.allies = new ArrayList<NPC>();
        for (GameCharacter companion : Main.game.getPlayer().getCompanions()) {
            this.allies.add((NPC)companion);
        }
        this.addElementalsToAllies = true;
        this.enemyLeader = opponent;
        this.enemies = new ArrayList<NPC>();
        this.enemies.add(opponent);
        for (GameCharacter companion : opponent.getCompanions()) {
            this.enemies.add((NPC)companion);
        }
        if (openingDescriptions != null) {
            this.openingDescriptions = openingDescriptions;
        }
    }

    public ResponseCombat(String title, String tooltipText, NPC enemyLeader, List<GameCharacter> enemies, Map<GameCharacter, String> openingDescriptions) {
        super(title, tooltipText, null);
        this.allies = new ArrayList<NPC>();
        for (GameCharacter companion : Main.game.getPlayer().getCompanions()) {
            this.allies.add((NPC)companion);
        }
        this.addElementalsToAllies = true;
        this.enemyLeader = enemyLeader;
        this.enemies = new ArrayList<NPC>();
        if (!enemies.contains(enemyLeader)) {
            this.enemies.add(enemyLeader);
        }
        for (GameCharacter enemy : enemies) {
            this.enemies.add((NPC)enemy);
        }
        if (openingDescriptions != null) {
            this.openingDescriptions = openingDescriptions;
        }
    }

    public ResponseCombat(String title, String tooltipText, List<GameCharacter> allies, NPC enemyLeader, List<GameCharacter> enemies, Map<GameCharacter, String> openingDescriptions) {
        super(title, tooltipText, null);
        this.allies = new ArrayList<NPC>();
        if (allies != null) {
            for (GameCharacter companion : allies) {
                this.allies.add((NPC)companion);
            }
        }
        this.addElementalsToAllies = true;
        this.enemyLeader = enemyLeader;
        this.enemies = new ArrayList<NPC>();
        if (!enemies.contains(enemyLeader)) {
            this.enemies.add(enemyLeader);
        }
        for (GameCharacter enemy : enemies) {
            this.enemies.add((NPC)enemy);
        }
        if (openingDescriptions != null) {
            this.openingDescriptions = openingDescriptions;
        }
    }

    public ResponseCombat(String title, String tooltipText, List<String> alliesIds, boolean addCompanionsToAllies, boolean addElementalsToAllies, String enemyLeaderId, List<String> enemiesIds, Map<String, String> openingDescriptionsUsingIds, String effectsResponse, boolean escapeBlocked, boolean submitBlocked) {
        super(title, tooltipText, null);
        this.fromExternalFile = true;
        this.alliesIds = alliesIds;
        this.addCompanionsToAllies = addCompanionsToAllies;
        this.addElementalsToAllies = addElementalsToAllies;
        this.enemyLeaderId = enemyLeaderId;
        this.enemiesIds = enemiesIds;
        if (openingDescriptionsUsingIds != null) {
            this.openingDescriptionsUsingIds = openingDescriptionsUsingIds;
        }
        this.effectsString = effectsResponse;
        this.escapeBlocked = escapeBlocked;
        this.submitBlocked = submitBlocked;
    }

    @Override
    public boolean isCombatHighlight() {
        return true;
    }

    public DialogueNode initCombat() {
        if (this.enemyLeaderId != null && !this.enemyLeaderId.isEmpty()) {
            String id;
            this.allies = new ArrayList<NPC>();
            for (String string : this.alliesIds) {
                id = UtilText.parse(string, new ParserTag[0]).trim();
                if (id.isEmpty()) continue;
                this.allies.add((NPC)UtilText.findFirstCharacterFromParserTarget(id));
            }
            if (this.addCompanionsToAllies) {
                for (GameCharacter gameCharacter : Main.game.getPlayer().getCompanions()) {
                    this.allies.add((NPC)gameCharacter);
                }
            }
            this.enemyLeader = (NPC)UtilText.findFirstCharacterFromParserTarget(UtilText.parse(this.enemyLeaderId, new ParserTag[0]).trim());
            this.enemies = new ArrayList<NPC>();
            for (String string : this.enemiesIds) {
                id = UtilText.parse(string, new ParserTag[0]).trim();
                if (id.isEmpty()) continue;
                this.enemies.add((NPC)UtilText.findFirstCharacterFromParserTarget(id));
            }
            if (!this.enemies.contains(this.enemyLeader)) {
                this.enemies.add(this.enemyLeader);
            }
            this.openingDescriptions = new HashMap<GameCharacter, String>();
            for (Map.Entry entry : this.openingDescriptionsUsingIds.entrySet()) {
                this.openingDescriptions.put(UtilText.findFirstCharacterFromParserTarget((String)entry.getKey()), (String)entry.getValue());
            }
            Main.combat.initialiseCombat(this.allies, this.addElementalsToAllies, this.enemyLeader, this.enemies, this.openingDescriptions, this.escapeBlocked, this.submitBlocked);
            Main.combat.setPlayerPostVictoryDialogue(DialogueManager.getDialogueFromId(UtilText.parse(this.nextDialoguePlayerVictoryId, new ParserTag[0]).trim()));
            Main.combat.setPlayerPostDefeatDialogue(DialogueManager.getDialogueFromId(UtilText.parse(this.nextDialoguePlayerDefeatId, new ParserTag[0]).trim()));
        } else {
            Main.combat.initialiseCombat(this.allies, this.addElementalsToAllies, this.enemyLeader, this.enemies, this.openingDescriptions);
        }
        return Main.combat.startCombat();
    }

    @Override
    public boolean disabledOnNullDialogue() {
        return false;
    }

    public List<String> getAlliesIds() {
        return this.alliesIds;
    }

    public void setAlliesIds(List<String> alliesIds) {
        this.alliesIds = alliesIds;
    }

    public String getEnemyLeaderId() {
        return this.enemyLeaderId;
    }

    public void setEnemyLeaderId(String enemyLeaderId) {
        this.enemyLeaderId = enemyLeaderId;
    }

    public List<String> getEnemiesIds() {
        return this.enemiesIds;
    }

    public void setEnemiesIds(List<String> enemiesIds) {
        this.enemiesIds = enemiesIds;
    }

    public String getNextDialoguePlayerVictoryId() {
        return this.nextDialoguePlayerVictoryId;
    }

    public void setNextDialoguePlayerVictoryId(String nextDialoguePlayerVictoryId) {
        this.nextDialoguePlayerVictoryId = nextDialoguePlayerVictoryId;
    }

    public String getNextDialoguePlayerDefeatId() {
        return this.nextDialoguePlayerDefeatId;
    }

    public void setNextDialoguePlayerDefeatId(String nextDialoguePlayerDefeatId) {
        this.nextDialoguePlayerDefeatId = nextDialoguePlayerDefeatId;
    }
}

