/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.utils;

import com.lilithsthrone.game.PropertyValue;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.markings.Tattoo;
import com.lilithsthrone.game.character.markings.TattooType;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.DialogueNodeType;
import com.lilithsthrone.game.dialogue.companions.CompanionManagement;
import com.lilithsthrone.game.dialogue.eventLog.EventLogEntry;
import com.lilithsthrone.game.dialogue.places.dominion.shoppingArcade.SuccubisSecrets;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseEffectsOnly;
import com.lilithsthrone.game.dialogue.utils.BodyChanging;
import com.lilithsthrone.game.dialogue.utils.CosmeticsDialogue;
import com.lilithsthrone.game.dialogue.utils.InventoryDialogue;
import com.lilithsthrone.game.dialogue.utils.InventoryInteraction;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.ClothingType;
import com.lilithsthrone.game.inventory.enchanting.EnchantingUtils;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.LoadedEnchantment;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.game.inventory.enchanting.TFPotency;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.game.inventory.weapon.WeaponType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.RenderingEngine;
import com.lilithsthrone.rendering.SVGImages;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.places.PlaceType;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EnchantmentDialogue {
    private static StringBuilder inventorySB = new StringBuilder("");
    private static InventoryInteraction interactionInit;
    private static AbstractCoreItem ingredient;
    private static AbstractCoreItem previousIngredient;
    private static List<ItemEffect> effects;
    private static List<ItemEffect> previousEffects;
    private static InventorySlot tattooSlot;
    private static GameCharacter tattooBearer;
    private static TFModifier primaryMod;
    private static TFModifier secondaryMod;
    public static TFModifier previousPrimaryMod;
    public static TFModifier previousSecondaryMod;
    private static TFPotency potency;
    private static int limit;
    private static Map<String, LoadedEnchantment> loadedEnchantmentsMap;
    private static String outputName;
    private static boolean isEquipped;
    private static GameCharacter isEquippedTo;
    private static InventorySlot isEquippedIn;
    public static String loadConfirmationName;
    public static String overwriteConfirmationName;
    public static String deleteConfirmationName;
    public static final DialogueNode ENCHANTMENT_MENU;
    public static final DialogueNode ENCHANTMENT_SAVE_LOAD;

    private static String inventoryView() {
        inventorySB.setLength(0);
        ItemEffect effect = EnchantmentDialogue.getCurrentEffect();
        int displaySlots = Math.max(32, 8 * (int)Math.ceil((float)Math.max(ingredient.getEnchantmentEffect().getPrimaryModifiers(ingredient).size(), ingredient.getEnchantmentEffect().getSecondaryModifiers(ingredient, primaryMod).size()) / 8.0f));
        inventorySB.append("<div class='container-half-width' style='padding-bottom:0;'>");
        for (TFModifier tfMod : ingredient.getEnchantmentEffect().getPrimaryModifiers(ingredient)) {
            inventorySB.append("<div class='modifier-icon' style='width:11.5%; background-color:" + tfMod.getRarity().getBackgroundColour().toWebHexString() + ";'><div class='modifier-icon-content'>" + tfMod.getSVGString() + "</div><div class='overlay' id='MOD_PRIMARY_" + tfMod.hashCode() + "'></div></div>");
        }
        for (int i = displaySlots; i > ingredient.getEnchantmentEffect().getPrimaryModifiers(ingredient).size(); --i) {
            inventorySB.append("<div class='modifier-icon empty' style='width:11.5%;'></div>");
        }
        inventorySB.append("<div class='container-full-width'><div class='container-half-width' style='width:78%; margin:0 1%; text-align:center; line-height:100vh;'><h5 style='margin:0; padding:0;'>\u9996\u8981\u4fee\u9970\u8bcd</h5></div><div class='container-half-width' style='width:18%; margin:0 1%;'>");
        if (primaryMod != null) {
            inventorySB.append("<div class='modifier-icon' style='width:100%; margin:0;background-color:" + primaryMod.getRarity().getBackgroundColour().toWebHexString() + ";'><div class='modifier-icon-content'>" + primaryMod.getSVGString() + "</div><div class='overlay' id='MOD_PRIMARY_ENCHANTING'></div></div>");
        } else {
            inventorySB.append("<div class='modifier-icon empty' style='width:30%; margin:0 1%;'><div class='overlay' style='cursor:default;' id='MOD_PRIMARY_ENCHANTING'></div></div>");
        }
        inventorySB.append("</div></div>");
        inventorySB.append("</div>");
        inventorySB.append("<div class='container-half-width' style='padding-bottom:0;'>");
        for (TFModifier tfMod : ingredient.getEnchantmentEffect().getSecondaryModifiers(ingredient, primaryMod)) {
            inventorySB.append("<div class='modifier-icon' style='width:11.5%; background-color:" + tfMod.getRarity().getBackgroundColour().toWebHexString() + ";'><div class='modifier-icon-content'>" + tfMod.getSVGString() + "</div><div class='overlay' id='MOD_SECONDARY_" + tfMod.hashCode() + "'></div></div>");
        }
        for (int i = displaySlots; i > ingredient.getEnchantmentEffect().getSecondaryModifiers(ingredient, primaryMod).size(); --i) {
            inventorySB.append("<div class='modifier-icon empty' style='width:11.5%;'></div>");
        }
        inventorySB.append("<div class='container-full-width'><div class='container-half-width' style='width:18%; margin:0 1%;'>");
        if (secondaryMod != null) {
            inventorySB.append("<div class='modifier-icon' style='width:100%; margin:0; background-color:" + secondaryMod.getRarity().getBackgroundColour().toWebHexString() + ";'><div class='modifier-icon-content'>" + secondaryMod.getSVGString() + "</div><div class='overlay' id='MOD_SECONDARY_ENCHANTING'></div></div>");
        } else {
            inventorySB.append("<div class='modifier-icon empty' style='width:30%; margin:0 1%;'><div class='overlay' style='cursor:default;' id='MOD_SECONDARY_ENCHANTING'></div></div>");
        }
        inventorySB.append("</div><div class='container-half-width' style='width:78%; margin:0 1%; text-align:center; line-height:100vh;'><h5 style='margin:0; padding:0;'>\u6b21\u8981\u4fee\u9970\u8bcd</h5></div></div>");
        inventorySB.append("</div>");
        inventorySB.append("<div class='container-full-width' style='text-align:center; padding:8px 0; margin-top:0;'>");
        for (TFPotency potency : TFPotency.getAllPotencies()) {
            inventorySB.append("<div class='normal-button" + (ingredient.getEnchantmentEffect().getPotencyModifiers(primaryMod, secondaryMod).contains((Object)potency) ? "" : " disabled") + (EnchantmentDialogue.potency == potency ? " selected" : "") + "' id='POTENCY_" + String.valueOf((Object)potency) + "' style='" + (String)(EnchantmentDialogue.potency == potency ? "color:" + potency.getColour().toWebHexString() + ";" : "") + " margin:0 1%; width:14%;'>" + potency.getName() + "</div>");
        }
        inventorySB.append("</div>");
        int ingredientLimit = ingredient.getEnchantmentEffect().getLimits(primaryMod, secondaryMod);
        if (ingredientLimit != 0) {
            inventorySB.append("<div class='container-full-width' style='text-align:center; padding:8px 0; margin-top:0;'><div style='float:left; width:14.6%; margin:0 1%; padding:0;'><div class='normal-button" + (limit == 0 ? " disabled" : "") + "' id='LIMIT_MINIMUM' style='width:100%;'>\u6700\u4f4e\u6781\u9650</div></div><div style='float:left; width:14.6%; margin:0 1%; padding:0;'><div class='normal-button" + (limit == 0 ? " disabled" : "") + "' id='LIMIT_DECREASE_LARGE' style='width:100%;'>\u6781\u9650--</div></div><div style='float:left; width:14.6%; margin:0 1%; padding:0;'><div class='normal-button" + (limit == 0 ? " disabled" : "") + "' id='LIMIT_DECREASE' style='width:100%;'>\u6781\u9650-</div></div><div style='float:left; width:14.6%; margin:0 1%; padding:0;'><div class='normal-button" + (limit == ingredientLimit ? " disabled" : "") + "' id='LIMIT_INCREASE' style='width:100%;'>\u6781\u9650+</div></div><div style='float:left; width:14.6%; margin:0 1%; padding:0;'><div class='normal-button" + (limit == ingredientLimit ? " disabled" : "") + "' id='LIMIT_INCREASE_LARGE' style='width:100%;'>\u6781\u9650++</div></div><div style='float:left; width:14.6%; margin:0 1%; padding:0;'><div class='normal-button" + (limit == ingredientLimit ? " disabled" : "") + "' id='LIMIT_MAXIMUM' style='width:100%;'>\u6700\u9ad8\u6781\u9650</div></div></div>");
        }
        inventorySB.append("<div class='container-full-width' style='text-align:center; padding:8px 0; margin-top:0;'>");
        inventorySB.append("<div class='container-half-width' style='width:28%; margin:0 1%;'><b style='color:" + PresetColour.GENERIC_ARCANE.toWebHexString() + ";'>\u8981\u6dfb\u52a0\u7684\u6548\u679c\uff1a</b></div>");
        inventorySB.append("<div class='container-half-width' style='width:48%; margin:0 1%;'>");
        if (effect.getEffectsDescription(Main.game.getPlayer(), Main.game.getPlayer()) != null) {
            int i = 0;
            for (String s : effect.getEffectsDescription(Main.game.getPlayer(), Main.game.getPlayer())) {
                if (i > 0) {
                    inventorySB.append("<br/>");
                }
                inventorySB.append("<b>" + Util.capitaliseSentence(s) + "</b>");
                ++i;
            }
        } else {
            inventorySB.append("<b>-</b>");
        }
        if (Main.game.isEnchantmentCapacityEnabled() && (ingredient instanceof AbstractClothing || ingredient instanceof AbstractWeapon || ingredient instanceof Tattoo) && (effect.getItemEffectType() == ItemEffectType.CLOTHING || effect.getItemEffectType() == ItemEffectType.WEAPON || effect.getItemEffectType() == ItemEffectType.TATTOO) && (effect.getPrimaryModifier() == TFModifier.CLOTHING_ATTRIBUTE || effect.getPrimaryModifier() == TFModifier.CLOTHING_MAJOR_ATTRIBUTE)) {
            int cost = Math.max(0, effect.getPotency().getClothingBonusValue());
            if (effect.getSecondaryModifier() == TFModifier.FERTILITY || effect.getSecondaryModifier() == TFModifier.VIRILITY) {
                cost = 0;
            } else if (effect.getSecondaryModifier() == TFModifier.CORRUPTION) {
                cost = effect.getPotency().isNegative() ? Math.abs(effect.getPotency().getClothingBonusValue()) : 0;
            }
            inventorySB.append("<br/>" + (cost > 0 ? "[style.colourEnchantment(" + Util.capitaliseSentence(Attribute.ENCHANTMENT_LIMIT.getName()) + ")]: " + UtilText.formatAsEnchantmentCapacity(cost, "b") : Util.capitaliseSentence(Attribute.ENCHANTMENT_LIMIT.getName()) + ": [style.colourDisabled(" + UtilText.formatAsEnchantmentCapacityUncoloured(cost, "b") + ")]"));
        }
        inventorySB.append("</div>");
        inventorySB.append("<div class='container-half-width' style='width:18%; margin:0 1%;'>");
        if (effects.size() >= ingredient.getEnchantmentLimit() || ingredient.getEnchantmentEffect().getEffectsDescription(primaryMod, secondaryMod, potency, limit, Main.game.getPlayer(), Main.game.getPlayer()) == null || ingredient.getEnchantmentEffect().getEffectsDescription(primaryMod, secondaryMod, potency, limit, Main.game.getPlayer(), Main.game.getPlayer()).isEmpty() || EnchantmentDialogue.getEnchantmentEffectBlockedReason(effect) != null) {
            inventorySB.append("<div class='normal-button disabled' style='width:100%; margin:auto 0;'><b>\u6dfb\u52a0</b>| " + (ingredient instanceof Tattoo ? UtilText.formatAsMoneyUncoloured(EnchantingUtils.getModifierEffectCost(true, ingredient, effect) * 500, "b") : UtilText.formatAsEssencesUncoloured(EnchantingUtils.getModifierEffectCost(true, ingredient, effect), "b", false)) + "<div class='overlay no-pointer' id='ENCHANT_ADD_BUTTON_DISABLED'></div></div>");
        } else {
            inventorySB.append("<div class='normal-button' style='width:100%; margin:auto 0;'><b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u6dfb\u52a0</b>| " + (ingredient instanceof Tattoo ? UtilText.formatAsMoney(EnchantingUtils.getModifierEffectCost(true, ingredient, effect) * 500, "b") : UtilText.formatAsEssences(EnchantingUtils.getModifierEffectCost(true, ingredient, effect), "b", false)) + "<div class='overlay' id='ENCHANT_ADD_BUTTON'></div></div>");
        }
        inventorySB.append("</div>");
        inventorySB.append("</div>");
        inventorySB.append("<div class='container-full-width' style='text-align:center; padding:8px 0; margin-top:0;'>");
        int count = 1;
        if (ingredient instanceof AbstractItem) {
            count = Main.game.getPlayer().getItemCount((AbstractItem)ingredient);
        } else if (ingredient instanceof AbstractClothing) {
            count = Main.game.getPlayer().getClothingCount((AbstractClothing)ingredient);
        } else if (ingredient instanceof AbstractWeapon) {
            count = Main.game.getPlayer().getWeaponCount((AbstractWeapon)ingredient);
        }
        inventorySB.append("<div class='container-half-width' style='width:18%; margin:0 1%; text-align:center;'>");
        inventorySB.append("<b>\u8f93\u5165</b><div class='enchanting-ingredient' style='background-color:" + ingredient.getRarity().getBackgroundColour().toWebHexString() + ";'><div class='enchanting-ingredient-content'>" + ingredient.getSVGString() + "</div><div class='overlay' id='INGREDIENT_ENCHANTING'  style='cursor:default;'></div>" + (String)(ingredient instanceof Tattoo ? "" : "<div class='enchanting-ingredient-count'><b>x" + count + "</b></div>") + "</div>");
        inventorySB.append("</div>");
        inventorySB.append("<div class='container-half-width' style='width:58%; margin:0 1%;'>");
        inventorySB.append("<form style='padding:0; margin:0 0 4px 0; float:left; width:90%; text-align:center;'>");
        inventorySB.append("<input type='text' id='output_name' value='" + UtilText.parseForHTMLDisplay(outputName) + "' style='padding:0;margin:0;width:100%;text-align:center;'>");
        inventorySB.append("</form>");
        inventorySB.append("<div class='normal-button' id='apply_enchanted_item_name' style='float:left; width:9.5%; height:22px; line-height:22px; margin:0 0 0 0.5%; padding:0; text-align:center;'>");
        inventorySB.append("&#10003;");
        inventorySB.append("</div>");
        inventorySB.append("<b>\u6548\u679c(</b>" + (String)(effects.size() >= ingredient.getEnchantmentLimit() ? "<b style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>" : "<b>") + effects.size() + "/" + ingredient.getEnchantmentLimit() + "</b><b>)</b>| \u82b1\u8d39\uff1a" + (ingredient instanceof Tattoo ? UtilText.formatAsMoney(EnchantingUtils.getCost(ingredient, effects) * 500, "b") : UtilText.formatAsEssences(EnchantingUtils.getCost(ingredient, effects), "b", false)));
        if (effects.isEmpty()) {
            inventorySB.append("<br/><span style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>\u65e0\u6548\u679c\u6dfb\u52a0</span>");
        } else {
            int cost = 0;
            for (int it = 0; it < effects.size(); ++it) {
                ItemEffect ie = effects.get(it);
                if (!(ie.getItemEffectType() != ItemEffectType.CLOTHING && ie.getItemEffectType() != ItemEffectType.WEAPON && ie.getItemEffectType() != ItemEffectType.TATTOO || ie.getPrimaryModifier() != TFModifier.CLOTHING_ATTRIBUTE && ie.getPrimaryModifier() != TFModifier.CLOTHING_MAJOR_ATTRIBUTE)) {
                    if (ie.getSecondaryModifier() == TFModifier.FERTILITY || ie.getSecondaryModifier() == TFModifier.VIRILITY) {
                        cost += 0;
                    } else if (ie.getSecondaryModifier() == TFModifier.CORRUPTION) {
                        if (ie.getPotency().isNegative()) {
                            cost += Math.abs(ie.getPotency().getClothingBonusValue());
                        }
                    } else {
                        cost += Math.max(0, ie.getPotency().getClothingBonusValue());
                    }
                }
                int i = 0;
                for (String s : ie.getEffectsDescription(Main.game.getPlayer(), Main.game.getPlayer())) {
                    inventorySB.append("<div class='container-full-width' style='background:" + RenderingEngine.getEntryBackgroundColour(it % 2 == 0) + "; width:98%; margin:0 1%; padding:" + (String)(i == 0 ? "2px" : "2px " + (ingredient.getEffects().contains(ie) ? "64px" : "22px") + " 2px 2px") + ";'>" + Util.capitaliseSentence(s));
                    if (i == 0) {
                        inventorySB.append(ingredient.getEffects().contains(ie) ? "<div class='normal-button' style='width:auto; min-width:64px; height:17px; line-height:17px; font-size:14px; margin:0; padding:0 0 0 4px; float:right; text-align:left;'><b style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>X</b>" + (ingredient instanceof Tattoo ? UtilText.formatAsMoney(EnchantingUtils.getModifierEffectCost(false, ingredient, ie) * 500, "b") : UtilText.formatAsEssences(EnchantingUtils.getModifierEffectCost(false, ingredient, ie), "b", false)) + "<div class='overlay' id='DELETE_EFFECT_" + it + "'></div></div>" : "<div class='normal-button' id='DELETE_EFFECT_" + it + "' style='width:17px; height:17px; line-height:17px; font-size:14px; margin:0; padding:0; float:right; color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'><b>X</b></div>");
                    }
                    inventorySB.append("</div>");
                    ++i;
                }
            }
            if (Main.game.isEnchantmentCapacityEnabled() && (ingredient instanceof AbstractClothing || ingredient instanceof AbstractWeapon || ingredient instanceof Tattoo)) {
                inventorySB.append("<br/>" + (cost > 0 ? "[style.colourEnchantment(" + Util.capitaliseSentence(Attribute.ENCHANTMENT_LIMIT.getName()) + ")]: " + UtilText.formatAsEnchantmentCapacity(cost, "b") : Util.capitaliseSentence(Attribute.ENCHANTMENT_LIMIT.getName()) + ": [style.colourDisabled(" + UtilText.formatAsEnchantmentCapacityUncoloured(cost, "b") + ")]"));
            }
        }
        inventorySB.append("</div>");
        AbstractCoreItem preview = null;
        if (EnchantmentDialogue.getIngredient() instanceof AbstractItem) {
            preview = EnchantingUtils.craftItem(EnchantmentDialogue.getIngredient(), EnchantmentDialogue.getEffects());
        } else if (EnchantmentDialogue.getIngredient() instanceof AbstractClothing) {
            preview = EnchantingUtils.craftClothing(EnchantmentDialogue.getIngredient(), EnchantmentDialogue.getEffects());
        } else if (EnchantmentDialogue.getIngredient() instanceof AbstractWeapon) {
            preview = EnchantingUtils.craftWeapon(EnchantmentDialogue.getIngredient(), EnchantmentDialogue.getEffects());
        } else if (EnchantmentDialogue.getIngredient() instanceof Tattoo) {
            preview = EnchantingUtils.craftTattoo(EnchantmentDialogue.getIngredient(), EnchantmentDialogue.getEffects());
        }
        if (preview != null) {
            inventorySB.append("<div class='container-half-width' style='width:18%; margin:0 1%; text-align:center;'>");
            inventorySB.append("<b>\u7ed3\u679c</b>");
            inventorySB.append("<div class='enchanting-ingredient' style='background-color:" + preview.getRarity().getBackgroundColour().toWebHexString() + ";'>");
            inventorySB.append("<div class='enchanting-ingredient-content'>" + preview.getSVGString() + "</div>");
            inventorySB.append("<div class='overlay' id='OUTPUT_ENCHANTING' style='cursor:default;'></div>");
            inventorySB.append("</div>");
            inventorySB.append("</div>");
        }
        inventorySB.append("</div>");
        inventorySB.append("<p id='hiddenPField' style='display:none;'></p>");
        return inventorySB.toString();
    }

    public static DialogueNode getEnchantmentMenu(AbstractCoreItem item) {
        return EnchantmentDialogue.getEnchantmentMenu(item, null, null);
    }

    public static DialogueNode getEnchantmentMenu(AbstractCoreItem item, GameCharacter tattooBearer, InventorySlot tattooSlot) {
        interactionInit = InventoryDialogue.getNPCInventoryInteraction();
        effects.clear();
        EnchantmentDialogue.resetEnchantmentVariables();
        EnchantmentDialogue.initModifiers(item, tattooBearer, tattooSlot);
        EnchantmentDialogue.setOutputName(EnchantingUtils.getPotionName(item, effects));
        return ENCHANTMENT_MENU;
    }

    private static void applyEnchantingEffect(int count) {
        Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('output_name').value;");
        EnchantmentDialogue.setOutputName(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
        for (int i = 0; i < count; ++i) {
            EnchantmentDialogue.craftAndApplyFullInventoryEffectsStack(ingredient, effects, i == count - 1);
        }
        if (previousIngredient instanceof AbstractItem && Main.game.getPlayer().hasItem((AbstractItem)previousIngredient) || previousIngredient instanceof AbstractClothing && Main.game.getPlayer().hasClothing((AbstractClothing)previousIngredient) || previousIngredient instanceof AbstractWeapon && Main.game.getPlayer().hasWeapon((AbstractWeapon)previousIngredient)) {
            ingredient = previousIngredient;
            effects = new ArrayList<ItemEffect>(previousEffects);
            Main.game.setContent(new Response("", "", ENCHANTMENT_MENU));
        } else if (previousIngredient instanceof Tattoo) {
            if (BodyChanging.getTarget().isPlayer()) {
                if (Main.game.getPlayer().getLocationPlaceType() == PlaceType.SHOPPING_ARCADE_KATES_SHOP) {
                    Main.game.setContent(new Response("", "", SuccubisSecrets.SHOP_BEAUTY_SALON_TATTOOS));
                } else {
                    Main.game.setContent(new Response("", "", CosmeticsDialogue.BEAUTICIAN_TATTOOS));
                }
            } else {
                Main.game.setContent(new Response("", "", CompanionManagement.SLAVE_MANAGEMENT_TATTOOS));
            }
        } else {
            Main.game.setContent(new Response("", "", InventoryDialogue.INVENTORY_MENU){

                @Override
                public void effects() {
                    Main.game.setResponseTab(0);
                    EnchantmentDialogue.resetEnchantmentVariables();
                    InventoryDialogue.resetItems();
                    InventoryDialogue.setNPCInventoryInteraction(interactionInit);
                }
            });
        }
    }

    public static boolean canAffordCost(AbstractCoreItem ingredient, List<ItemEffect> itemEffects, int count) {
        if (ingredient instanceof Tattoo) {
            return Main.game.getPlayer().getMoney() >= (long)(EnchantingUtils.getCost(ingredient, itemEffects) * count * 500);
        }
        return Main.game.getPlayer().getEssenceCount() >= EnchantingUtils.getCost(ingredient, itemEffects) * count;
    }

    public static AbstractCoreItem craftAndApplyFullInventoryEffects(AbstractCoreItem ingredient, List<ItemEffect> effects) {
        return EnchantmentDialogue.craftAndApplyFullInventoryEffects(ingredient, effects, true);
    }

    public static AbstractCoreItem craftAndApplyFullInventoryEffects(AbstractCoreItem ingredient, List<ItemEffect> effects, boolean applyCost) {
        return EnchantmentDialogue.craftAndApplyFullInventoryEffectsStack(ingredient, effects, applyCost, true);
    }

    public static AbstractCoreItem craftAndApplyFullInventoryEffectsStack(AbstractCoreItem ingredient, List<ItemEffect> effects, boolean finalCraftInStack) {
        return EnchantmentDialogue.craftAndApplyFullInventoryEffectsStack(ingredient, effects, true, finalCraftInStack);
    }

    public static AbstractCoreItem craftAndApplyFullInventoryEffectsStack(AbstractCoreItem ingredient, List<ItemEffect> effects, boolean applyCost, boolean finalCraftInStack) {
        if (ingredient instanceof AbstractItem) {
            Main.game.getPlayer().removeItem((AbstractItem)ingredient);
            AbstractItem craftedItem = EnchantingUtils.craftItem(ingredient, effects);
            Main.game.getPlayer().addItem(craftedItem, false);
            Main.game.addEvent(new EventLogEntry("[style.colourExcellent(\u9053\u5177\u9644\u9b54)]", Util.capitaliseSentence(craftedItem.getName(false, true))), false);
            if (applyCost) {
                Main.game.getPlayer().incrementEssenceCount(-EnchantingUtils.getCost(ingredient, effects), false);
            }
            if (finalCraftInStack) {
                EnchantmentDialogue.finaliseCrafting(ingredient, effects);
            }
            return craftedItem;
        }
        if (ingredient instanceof AbstractClothing) {
            Main.game.getPlayer().removeClothing((AbstractClothing)ingredient);
            AbstractClothing craftedClothing = EnchantingUtils.craftClothing(ingredient, effects);
            Main.game.getPlayer().addClothing(craftedClothing, false);
            Main.game.addEvent(new EventLogEntry("[style.colourExcellent(\u8863\u7269\u9644\u9b54)]", Util.capitaliseSentence(craftedClothing.getName(false, true))), false);
            if (applyCost) {
                Main.game.getPlayer().incrementEssenceCount(-EnchantingUtils.getCost(ingredient, effects), false);
            }
            if (finalCraftInStack) {
                EnchantmentDialogue.finaliseCrafting(ingredient, effects);
            }
            return craftedClothing;
        }
        if (ingredient instanceof AbstractWeapon) {
            Main.game.getPlayer().removeWeapon((AbstractWeapon)ingredient);
            AbstractWeapon craftedWeapon = EnchantingUtils.craftWeapon(ingredient, effects);
            Main.game.getPlayer().addWeapon(craftedWeapon, false);
            Main.game.addEvent(new EventLogEntry("[style.colourExcellent(\u6b66\u5668\u9644\u9b54)]", Util.capitaliseSentence(craftedWeapon.getName(false, true))), false);
            if (applyCost) {
                Main.game.getPlayer().incrementEssenceCount(-EnchantingUtils.getCost(ingredient, effects), false);
            }
            if (finalCraftInStack) {
                EnchantmentDialogue.finaliseCrafting(ingredient, effects);
            }
            return craftedWeapon;
        }
        if (ingredient instanceof Tattoo) {
            Tattoo tattoo;
            if (applyCost) {
                Main.game.getPlayer().incrementMoney(-EnchantingUtils.getCost(ingredient, effects) * 500);
            }
            if (isEquipped) {
                isEquippedTo.removeTattoo(isEquippedIn);
                tattoo = EnchantingUtils.craftTattoo(ingredient, effects);
                isEquippedTo.addTattoo(isEquippedIn, tattoo);
            } else {
                System.err.println("craftAndApplyFullInventoryEffects() error: Tattoo is not equipped?");
                tattoo = EnchantingUtils.craftTattoo(ingredient, effects);
            }
            Main.game.addEvent(new EventLogEntry("[style.colourExcellent(\u7eb9\u8eab\u9644\u9b54)]", Util.capitaliseSentence(((Tattoo)ingredient).getName())), false);
            if (finalCraftInStack) {
                EnchantmentDialogue.finaliseCrafting(ingredient, effects);
            }
            return tattoo;
        }
        return null;
    }

    private static void finaliseCrafting(AbstractCoreItem ingredient, List<ItemEffect> effects) {
        previousIngredient = ingredient;
        previousPrimaryMod = primaryMod;
        previousSecondaryMod = secondaryMod;
        previousEffects.clear();
        previousEffects.addAll(EnchantmentDialogue.effects);
        EnchantmentDialogue.resetEnchantmentVariables();
        EnchantmentDialogue.effects.clear();
    }

    public static void resetEnchantmentVariables() {
        ingredient = null;
        primaryMod = TFModifier.NONE;
        secondaryMod = TFModifier.NONE;
        potency = TFPotency.MINOR_BOOST;
        limit = 0;
        tattooBearer = null;
        tattooSlot = null;
        isEquipped = false;
        isEquippedIn = null;
        isEquippedTo = null;
    }

    public static void resetNonTattooEnchantmentVariables() {
        if (!(ingredient instanceof Tattoo)) {
            ingredient = null;
            tattooBearer = null;
            tattooSlot = null;
        }
        primaryMod = TFModifier.NONE;
        secondaryMod = TFModifier.NONE;
        potency = TFPotency.MINOR_BOOST;
        limit = 0;
    }

    public static void initModifiers(AbstractCoreItem ingredient) {
        EnchantmentDialogue.initModifiers(ingredient, tattooBearer, tattooSlot);
    }

    public static void initModifiers(AbstractCoreItem ingredient, GameCharacter tattooBearer, InventorySlot tattooSlot) {
        EnchantmentDialogue.ingredient = ingredient;
        EnchantmentDialogue.tattooBearer = tattooBearer;
        EnchantmentDialogue.tattooSlot = tattooSlot;
        if (ingredient instanceof AbstractClothing || ingredient instanceof Tattoo || ingredient instanceof AbstractWeapon) {
            effects = new ArrayList<ItemEffect>(ingredient.getEffects());
            if (ingredient instanceof Tattoo && tattooBearer.getTattooInSlot(tattooSlot) == ingredient) {
                isEquipped = true;
                isEquippedIn = tattooSlot;
                isEquippedTo = tattooBearer;
            }
        } else {
            effects = new ArrayList<ItemEffect>();
        }
        if (!EnchantmentDialogue.ingredient.getEnchantmentEffect().getPrimaryModifiers(ingredient).contains((Object)primaryMod)) {
            primaryMod = EnchantmentDialogue.ingredient.getEnchantmentEffect().getPrimaryModifiers(ingredient).get(0);
        }
        if (!EnchantmentDialogue.ingredient.getEnchantmentEffect().getSecondaryModifiers(EnchantmentDialogue.ingredient, primaryMod).contains((Object)secondaryMod)) {
            secondaryMod = EnchantmentDialogue.ingredient.getEnchantmentEffect().getSecondaryModifiers(EnchantmentDialogue.ingredient, primaryMod).get(0);
        }
        if (!EnchantmentDialogue.ingredient.getEnchantmentEffect().getPotencyModifiers(primaryMod, secondaryMod).contains((Object)potency)) {
            potency = TFPotency.MINOR_BOOST;
        }
        if (limit <= EnchantmentDialogue.ingredient.getEnchantmentEffect().getLimits(primaryMod, secondaryMod)) {
            limit = EnchantmentDialogue.ingredient.getEnchantmentEffect().getLimits(primaryMod, secondaryMod);
        }
    }

    public static void initSaveLoadMenu() {
        loadedEnchantmentsMap = new TreeMap<String, LoadedEnchantment>();
        for (File f : EnchantmentDialogue.getSavedEnchants()) {
            try {
                String name = Util.getFileIdentifier(f);
                LoadedEnchantment loadedEnchant = EnchantmentDialogue.loadEnchant(name);
                if (!(ingredient instanceof Tattoo ? loadedEnchant.getTattooType() != null : loadedEnchant.getTattooType() == null)) continue;
                loadedEnchantmentsMap.put(name, loadedEnchant);
            }
            catch (Exception exception) {}
        }
    }

    public static List<File> getSavedEnchants() {
        File[] directoryListing;
        ArrayList<File> filesList = new ArrayList<File>();
        File dir = new File("data/enchantments");
        if (dir.isDirectory() && (directoryListing = dir.listFiles((path, name) -> name.endsWith(".xml"))) != null) {
            filesList.addAll(Arrays.asList(directoryListing));
        }
        filesList.sort(Comparator.comparing(File::getName).reversed());
        return filesList;
    }

    private static String getSaveLoadRow(String baseName, LoadedEnchantment loadedEnchantment, boolean altColour) {
        if (loadedEnchantment != null) {
            String fileName = baseName + ".xml";
            boolean suitableItemAvailable = loadedEnchantment.isSuitableItemAvailable();
            return "<div class='container-full-width' style='padding:0; margin:0 0 4px 0;" + (altColour ? "background:#222;" : "") + " position:relative;'><div class='container-full-width' style='width:calc(75% - 16px); background:transparent;'><div class='container-full-width' style='width:10%; margin:0; padding:0; background:transparent; position:relative; float:left;'><div class='inventoryImage' style='width:100%;'><div class='inventoryImage-content'>" + loadedEnchantment.getSVGString() + "</div><div class='overlay no-pointer' id='LOADED_ENCHANTMENT_" + baseName + "'></div></div></div><div style='width:calc(90% - 8px); padding:0; margin:0 0 0 8px; position:relative; float:left;'><h6 style='margin:0; padding:2px;'>" + (String)(!suitableItemAvailable ? "[style.boldBad(" + loadedEnchantment.getName() + ")]" : loadedEnchantment.getName()) + "</h6><p style='margin:0; padding:2px;'>[style.colourDisabled(data/enchantments/)]" + baseName + "[style.colourDisabled(.xml)]</p></div></div><div class='container-full-width' style='width:calc(25% - 16px);text-align:center; background:transparent;'>" + (Main.game.isStarted() && !Main.game.isInCombat() && !Main.game.isInSex() && !EnchantmentDialogue.getEffects().isEmpty() ? (fileName.equals(overwriteConfirmationName) ? "<div class='square-button saveIcon' id='OVERWRITE_" + baseName + "'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskSaveConfirm() + "</div></div>" : "<div class='square-button saveIcon' id='OVERWRITE_" + baseName + "'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskOverwrite() + "</div></div>") : "<div class='square-button saveIcon disabled'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskSaveDisabled() + "</div></div>") + (suitableItemAvailable ? (fileName.equals(loadConfirmationName) ? "<div class='square-button saveIcon' id='LOAD_" + baseName + "'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskLoadConfirm() + "</div></div>" : "<div class='square-button saveIcon' id='LOAD_" + baseName + "'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskLoad() + "</div></div>") : "<div class='square-button saveIcon disabled'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskLoadDisabled() + "</div></div>") + (fileName.equals(deleteConfirmationName) ? "<div class='square-button saveIcon' id='DELETE_" + baseName + "'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskDeleteConfirm() + "</div></div>" : "<div class='square-button saveIcon' id='DELETE_" + baseName + "'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskDelete() + "</div></div>") + "</div></div>";
        }
        if (EnchantmentDialogue.getEffects().isEmpty()) {
            return "<div class='container-full-width' style='padding:0; margin:0 0 4px 0;" + (altColour ? "background:#222;" : "") + "'><div class='container-full-width' style='width:calc(75% - 16px); background:transparent; text-align:center;'>[style.colourDisabled(\u65e0\u6cd5\u4fdd\u5b58\u65e0\u6548\u679c\u6dfb\u52a0\u7684\u9644\u9b54\uff01)]</div><div class='container-full-width' style='width:calc(25% - 16px); text-align:center; background:transparent;'><div class='square-button saveIcon disabled' style='float:left;'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskSaveDisabled() + "</div></div></div></div>";
        }
        String svgString = "";
        if (EnchantmentDialogue.getIngredient() instanceof AbstractItem) {
            svgString = ((AbstractItem)EnchantmentDialogue.getIngredient()).getSVGString();
        } else if (EnchantmentDialogue.getIngredient() instanceof AbstractClothing) {
            svgString = ((AbstractClothing)EnchantmentDialogue.getIngredient()).getSVGString();
        } else if (EnchantmentDialogue.getIngredient() instanceof AbstractWeapon) {
            svgString = ((AbstractWeapon)EnchantmentDialogue.getIngredient()).getSVGString();
        } else if (EnchantmentDialogue.getIngredient() instanceof Tattoo) {
            svgString = ((Tattoo)EnchantmentDialogue.getIngredient()).getSVGString();
        }
        return "<div class='container-full-width' style='padding:0; margin:0 0 4px 0;" + (altColour ? "background:#222;" : "") + "'><div class='container-full-width' style='width:calc(75% - 16px); background:transparent;'><div class='container-full-width' style='width:10%; margin:0; padding:0; background:transparent; position:relative; float:left;'><div class='inventoryImage' style='width:100%;'><div class='inventoryImage-content'>" + svgString + "</div><div class='overlay no-pointer' id='LOADED_ENCHANTMENT_CURRENT'></div></div></div><div style='width:calc(90% - 8px); padding:0; margin:0 0 0 8px; position:relative; float:left;'><form style='padding:0;margin:0;text-align:center;'><input type='text' id='new_save_name' placeholder='Enter File Name' style='padding:0;margin:0;width:100%;'></form></div></div><div class='container-full-width' style='width:calc(25% - 16px); text-align:center; background:transparent;'><div class='square-button saveIcon' id='NEW_SAVE' style='float:left;'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getDiskSave() + "</div></div></div></div>";
    }

    public static void saveEnchant(String name, boolean allowOverwrite, DialogueNode dialogueNode) {
        File[] directoryListing;
        if ((name = Main.checkFileName(name)).isEmpty()) {
            return;
        }
        File dir = new File("data/");
        dir.mkdir();
        dir = new File("data/enchantments");
        dir.mkdir();
        if (dir.isDirectory() && (directoryListing = dir.listFiles((path, filename) -> filename.endsWith(".xml"))) != null) {
            for (File child : directoryListing) {
                if (!child.getName().equals(name + ".xml") || allowOverwrite) continue;
                Main.game.flashMessage(PresetColour.GENERIC_BAD, "\u540d\u79f0\u5df2\u5b58\u5728\uff01");
                return;
            }
        }
        try {
            Document doc = Main.getDocBuilder().newDocument();
            Element enchantment = doc.createElement("enchantment");
            doc.appendChild(enchantment);
            if (EnchantmentDialogue.getIngredient() instanceof AbstractItem) {
                Element itemTypeElement = doc.createElement("itemType");
                enchantment.appendChild(itemTypeElement);
                itemTypeElement.setTextContent(((AbstractItem)EnchantmentDialogue.getIngredient()).getItemType().getId());
            } else if (EnchantmentDialogue.getIngredient() instanceof AbstractClothing) {
                Element itemTypeElement = doc.createElement("clothingType");
                enchantment.appendChild(itemTypeElement);
                itemTypeElement.setTextContent(((AbstractClothing)EnchantmentDialogue.getIngredient()).getClothingType().getId());
            } else if (EnchantmentDialogue.getIngredient() instanceof AbstractWeapon) {
                Element itemTypeElement = doc.createElement("weaponType");
                enchantment.appendChild(itemTypeElement);
                itemTypeElement.setTextContent(((AbstractWeapon)EnchantmentDialogue.getIngredient()).getWeaponType().getId());
            } else if (EnchantmentDialogue.getIngredient() instanceof Tattoo) {
                Element itemTypeElement = doc.createElement("tattooType");
                enchantment.appendChild(itemTypeElement);
                itemTypeElement.setTextContent(((Tattoo)EnchantmentDialogue.getIngredient()).getType().getId());
            }
            Element nameElement = doc.createElement("name");
            enchantment.appendChild(nameElement);
            nameElement.appendChild(doc.createCDATASection(EnchantmentDialogue.getOutputName()));
            Element itemEffects = doc.createElement("itemEffects");
            enchantment.appendChild(itemEffects);
            for (ItemEffect effect : effects) {
                effect.saveAsXML(itemEffects, doc);
            }
            Transformer transformer1 = Main.transformerFactory.newTransformer();
            transformer1.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer1.transform(new DOMSource(doc), new StreamResult(writer));
            Transformer transformer = Main.transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(doc);
            String saveLocation = "data/enchantments/" + name + ".xml";
            StreamResult result = new StreamResult(saveLocation);
            transformer.transform(source, result);
        }
        catch (TransformerException tfe) {
            tfe.printStackTrace();
        }
        if (dialogueNode != null) {
            Main.game.setContent(new Response("", "", dialogueNode));
        }
        Main.game.flashMessage(PresetColour.GENERIC_GOOD, "\u9644\u9b54\u5df2\u4fdd\u5b58\uff01");
    }

    public static LoadedEnchantment loadEnchant(String name) {
        File file;
        if (EnchantmentDialogue.isLoadEnchantAvailable(name) && (file = new File("data/enchantments/" + name + ".xml")).exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(file);
                doc.getDocumentElement().normalize();
                String importedName = ((Element)doc.getElementsByTagName("name").item(0)).getTextContent();
                Element enchantment = (Element)doc.getElementsByTagName("enchantment").item(0);
                Element itemEffects = (Element)enchantment.getElementsByTagName("itemEffects").item(0);
                ArrayList<ItemEffect> effectsToBeAdded = new ArrayList<ItemEffect>();
                for (int i = 0; i < itemEffects.getElementsByTagName("effect").getLength(); ++i) {
                    Element e = (Element)itemEffects.getElementsByTagName("effect").item(i);
                    ItemEffect itemEffect = ItemEffect.loadFromXML(e, doc);
                    if (itemEffect == null) continue;
                    effectsToBeAdded.add(itemEffect);
                }
                if (doc.getElementsByTagName("itemType").item(0) != null) {
                    return new LoadedEnchantment(importedName, ItemType.getItemTypeFromId(doc.getElementsByTagName("itemType").item(0).getTextContent()), effectsToBeAdded);
                }
                if (doc.getElementsByTagName("clothingType").item(0) != null) {
                    return new LoadedEnchantment(importedName, ClothingType.getClothingTypeFromId(doc.getElementsByTagName("clothingType").item(0).getTextContent()), effectsToBeAdded);
                }
                if (doc.getElementsByTagName("weaponType").item(0) != null) {
                    return new LoadedEnchantment(importedName, WeaponType.getWeaponTypeFromId(doc.getElementsByTagName("weaponType").item(0).getTextContent()), effectsToBeAdded);
                }
                if (doc.getElementsByTagName("tattooType").item(0) != null) {
                    return new LoadedEnchantment(importedName, TattooType.getTattooTypeFromId(doc.getElementsByTagName("tattooType").item(0).getTextContent()), effectsToBeAdded);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isLoadEnchantAvailable(String name) {
        File file = new File("data/enchantments/" + name + ".xml");
        return file.exists();
    }

    public static void deleteEnchant(String name) {
        File file = new File("data/enchantments/" + name + ".xml");
        if (file.exists()) {
            try {
                file.delete();
                Main.game.setContent(new Response("", "", Main.game.getCurrentDialogueNode()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            Main.game.flashMessage(PresetColour.GENERIC_BAD, "\u672a\u627e\u5230\u6587\u4ef6\u2026\u2026");
        }
    }

    public static LoadedEnchantment getCurrentEnchantmentAsLoadedEnchantment() {
        if (EnchantmentDialogue.getIngredient() instanceof AbstractItem) {
            return new LoadedEnchantment(outputName, ((AbstractItem)EnchantmentDialogue.getIngredient()).getItemType(), effects);
        }
        if (EnchantmentDialogue.getIngredient() instanceof AbstractClothing) {
            return new LoadedEnchantment(outputName, ((AbstractClothing)EnchantmentDialogue.getIngredient()).getClothingType(), effects);
        }
        if (EnchantmentDialogue.getIngredient() instanceof AbstractWeapon) {
            return new LoadedEnchantment(outputName, ((AbstractWeapon)EnchantmentDialogue.getIngredient()).getWeaponType(), effects);
        }
        if (EnchantmentDialogue.getIngredient() instanceof Tattoo) {
            return new LoadedEnchantment(outputName, ((Tattoo)EnchantmentDialogue.getIngredient()).getType(), effects);
        }
        return null;
    }

    public static AbstractCoreItem getIngredient() {
        return ingredient;
    }

    public static void setIngredient(AbstractCoreItem ingredient) {
        EnchantmentDialogue.ingredient = ingredient;
    }

    public static AbstractCoreItem getPreviousIngredient() {
        return previousIngredient;
    }

    public static void setPreviousIngredient(AbstractCoreItem previousIngredient) {
        EnchantmentDialogue.previousIngredient = previousIngredient;
    }

    public static ItemEffect getCurrentEffect() {
        return new ItemEffect(ingredient.getEnchantmentEffect(), primaryMod, secondaryMod, potency, limit);
    }

    public static List<ItemEffect> getEffects() {
        return effects;
    }

    public static String getEnchantmentEffectBlockedReason(ItemEffect effect) {
        if (ingredient instanceof AbstractClothing && effect.getSecondaryModifier() == TFModifier.CLOTHING_VIBRATION) {
            for (ItemEffect ie : effects) {
                if (ie.getSecondaryModifier() != TFModifier.CLOTHING_VIBRATION) continue;
                return "\u4e00\u4ef6\u8863\u670d\u53ea\u80fd\u6dfb\u52a0\u4e00\u4e2a\u201c\u9707\u52a8\u201d\u6548\u679c\uff01";
            }
        }
        return null;
    }

    public static boolean addEffect(ItemEffect effect) {
        boolean defaultName = EnchantingUtils.getPotionName(EnchantmentDialogue.getIngredient(), EnchantmentDialogue.getEffects()).equalsIgnoreCase(EnchantmentDialogue.getOutputName());
        boolean added = false;
        if (effects.size() < ingredient.getEnchantmentLimit() && (added = EnchantmentDialogue.getEffects().add(effect))) {
            if (defaultName) {
                EnchantmentDialogue.setOutputName(EnchantingUtils.getPotionName(EnchantmentDialogue.getIngredient(), EnchantmentDialogue.getEffects()));
            } else if (Main.game.getCurrentDialogueNode().equals(ENCHANTMENT_MENU)) {
                Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('output_name').value;");
                EnchantmentDialogue.setOutputName(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
            }
        }
        return added;
    }

    public static boolean removeEffect(int index) {
        boolean defaultName = EnchantingUtils.getPotionName(EnchantmentDialogue.getIngredient(), EnchantmentDialogue.getEffects()).equalsIgnoreCase(EnchantmentDialogue.getOutputName());
        EnchantmentDialogue.getEffects().remove(index);
        if (defaultName) {
            EnchantmentDialogue.setOutputName(EnchantingUtils.getPotionName(EnchantmentDialogue.getIngredient(), EnchantmentDialogue.getEffects()));
        } else if (Main.game.getCurrentDialogueNode().equals(ENCHANTMENT_MENU)) {
            Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('output_name').value;");
            EnchantmentDialogue.setOutputName(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
        }
        return true;
    }

    public static boolean removeEffect(ItemEffect effect) {
        boolean defaultName = EnchantingUtils.getPotionName(EnchantmentDialogue.getIngredient(), EnchantmentDialogue.getEffects()).equalsIgnoreCase(EnchantmentDialogue.getOutputName());
        boolean removed = EnchantmentDialogue.getEffects().remove(effect);
        if (removed) {
            if (defaultName) {
                EnchantmentDialogue.setOutputName(EnchantingUtils.getPotionName(EnchantmentDialogue.getIngredient(), EnchantmentDialogue.getEffects()));
            } else if (Main.game.getCurrentDialogueNode().equals(ENCHANTMENT_MENU)) {
                Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('output_name').value;");
                EnchantmentDialogue.setOutputName(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
            }
        }
        return removed;
    }

    public static TFModifier getPrimaryMod() {
        return primaryMod;
    }

    public static void setPrimaryMod(TFModifier primaryMod) {
        EnchantmentDialogue.primaryMod = primaryMod;
        if (Main.game.getCurrentDialogueNode().equals(ENCHANTMENT_MENU)) {
            Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('output_name').value;");
            EnchantmentDialogue.setOutputName(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
        }
    }

    public static TFModifier getSecondaryMod() {
        return secondaryMod;
    }

    public static void setSecondaryMod(TFModifier secondaryMod) {
        EnchantmentDialogue.secondaryMod = secondaryMod;
        if (Main.game.getCurrentDialogueNode().equals(ENCHANTMENT_MENU)) {
            Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('output_name').value;");
            EnchantmentDialogue.setOutputName(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
        }
    }

    public static TFPotency getPotency() {
        return potency;
    }

    public static void setPotency(TFPotency potency) {
        EnchantmentDialogue.potency = potency;
        if (Main.game.getCurrentDialogueNode().equals(ENCHANTMENT_MENU)) {
            Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('output_name').value;");
            EnchantmentDialogue.setOutputName(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
        }
    }

    public static int getLimit() {
        return limit;
    }

    public static void setLimit(int limit) {
        EnchantmentDialogue.limit = limit;
        if (Main.game.getCurrentDialogueNode().equals(ENCHANTMENT_MENU)) {
            Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('output_name').value;");
            EnchantmentDialogue.setOutputName(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
        }
    }

    public static String getOutputName() {
        return outputName;
    }

    public static void setOutputName(String outputName) {
        EnchantmentDialogue.outputName = outputName = outputName.replaceAll("\\[\\#(.*?)]", "");
    }

    public static Map<String, LoadedEnchantment> getLoadedEnchantmentsMap() {
        return loadedEnchantmentsMap;
    }

    public static InventorySlot getTattooSlot() {
        return tattooSlot;
    }

    public static GameCharacter getTattooBearer() {
        return tattooBearer;
    }

    static {
        ingredient = null;
        previousIngredient = null;
        effects = new ArrayList<ItemEffect>();
        previousEffects = new ArrayList<ItemEffect>();
        primaryMod = TFModifier.NONE;
        secondaryMod = TFModifier.NONE;
        previousPrimaryMod = TFModifier.NONE;
        previousSecondaryMod = TFModifier.NONE;
        potency = TFPotency.MINOR_BOOST;
        limit = 0;
        outputName = "";
        isEquipped = false;
        isEquippedTo = null;
        isEquippedIn = null;
        loadConfirmationName = "";
        overwriteConfirmationName = "";
        deleteConfirmationName = "";
        ENCHANTMENT_MENU = new DialogueNode("\u9644\u9b54", "", true){

            @Override
            public void applyPreParsingEffects() {
                InventoryDialogue.setNPCInventoryInteraction(InventoryInteraction.FULL_MANAGEMENT);
                if (tattooBearer instanceof NPC) {
                    InventoryDialogue.setInventoryNPC((NPC)tattooBearer);
                }
            }

            @Override
            public String getLabel() {
                return "\u9644\u9b54";
            }

            @Override
            public String getHeaderContent() {
                return EnchantmentDialogue.inventoryView();
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u505c\u6b62\u9644\u9b54\u3002", InventoryDialogue.ITEM_INVENTORY){

                        @Override
                        public DialogueNode getNextDialogue() {
                            if (ingredient instanceof AbstractItem) {
                                if (InventoryDialogue.getItem() == null) {
                                    InventoryDialogue.setItem((AbstractItem)ingredient);
                                }
                                return InventoryDialogue.ITEM_INVENTORY;
                            }
                            if (ingredient instanceof AbstractClothing) {
                                if (InventoryDialogue.getClothing() == null) {
                                    InventoryDialogue.setClothing((AbstractClothing)ingredient);
                                }
                                if (Main.game.getPlayer().getClothingCurrentlyEquipped().contains(ingredient)) {
                                    return InventoryDialogue.CLOTHING_EQUIPPED;
                                }
                                return InventoryDialogue.CLOTHING_INVENTORY;
                            }
                            if (ingredient instanceof AbstractWeapon) {
                                if (InventoryDialogue.getWeapon() == null) {
                                    InventoryDialogue.setWeapon(isEquippedIn, (AbstractWeapon)ingredient);
                                }
                                if (Main.game.getPlayer().hasWeaponEquipped((AbstractWeapon)ingredient)) {
                                    return InventoryDialogue.WEAPON_EQUIPPED;
                                }
                                return InventoryDialogue.WEAPON_INVENTORY;
                            }
                            if (ingredient instanceof Tattoo) {
                                if (BodyChanging.getTarget().isPlayer()) {
                                    if (Main.game.getPlayer().getLocationPlaceType() == PlaceType.SHOPPING_ARCADE_KATES_SHOP) {
                                        return SuccubisSecrets.SHOP_BEAUTY_SALON_TATTOOS;
                                    }
                                    return CosmeticsDialogue.BEAUTICIAN_TATTOOS;
                                }
                                return CompanionManagement.SLAVE_MANAGEMENT_TATTOOS;
                            }
                            throw new IllegalStateException("If it's not an item, not clothing, and not a weapon, then what?");
                        }

                        @Override
                        public void effects() {
                            Main.game.setResponseTab(1);
                            EnchantmentDialogue.resetEnchantmentVariables();
                            InventoryDialogue.setNPCInventoryInteraction(interactionInit);
                        }
                    };
                }
                try {
                    int ingredientCount;
                    int essenceCost = EnchantingUtils.getCost(ingredient, effects);
                    int price = essenceCost * 500;
                    int n = ingredient instanceof AbstractItem ? Main.game.getPlayer().getItemCount((AbstractItem)ingredient) : (ingredient instanceof AbstractClothing ? Main.game.getPlayer().getClothingCount((AbstractClothing)ingredient) : (ingredientCount = ingredient instanceof AbstractWeapon ? Main.game.getPlayer().getWeaponCount((AbstractWeapon)ingredient) : 1));
                    if (index == 1) {
                        if (effects.equals(ingredient.getEffects()) || effects.isEmpty() && ingredient instanceof AbstractItem) {
                            return new Response("\u5236\u4f5c", "\u5236\u4f5c\u81f3\u5c11\u9700\u8981\u6dfb\u52a0\u4e00\u79cd\u6548\u679c\uff01", null);
                        }
                        if (!EnchantmentDialogue.canAffordCost(ingredient, effects, 1)) {
                            return new Response(ingredient instanceof Tattoo ? "\u9644\u9b54(" + UtilText.formatAsMoneyUncoloured(price, "span") + ")" : "\u5236\u4f5c (" + UtilText.formatAsEssencesUncoloured(essenceCost, "span", false) + ")", "\u5236\u4f5c\u6240\u9700\u5f00\u9500\u4e0d\u8db3\uff01", null);
                        }
                        return new ResponseEffectsOnly(ingredient instanceof Tattoo ? "\u9644\u9b54 (" + UtilText.formatAsMoney(price, "span") + ")" : "\u5236\u4f5c (" + UtilText.formatAsEssences(essenceCost, "span", false) + ")", ingredient instanceof Tattoo ? "\u5c06\u6b64\u7eb9\u8eab\u9644\u9b54\u4e0a\u7279\u6b8a\u6548\u679c\uff0c\u5c06\u82b1\u8d39" + UtilText.formatAsMoney(price, "span") + "\u3002" : "\u5236\u4f5c\u201c" + EnchantingUtils.getPotionName(ingredient, effects) + "\u201d\u3002\u5c06\u4f1a\u82b1\u8d39[style.boldArcane(" + essenceCost + ")]\u5965\u672f\u7cbe\u534e\u3002"){

                            @Override
                            public void effects() {
                                EnchantmentDialogue.applyEnchantingEffect(1);
                            }
                        };
                    }
                    if (index == 2 && !(ingredient instanceof Tattoo)) {
                        if (effects.equals(ingredient.getEffects()) || effects.isEmpty() && ingredient instanceof AbstractItem) {
                            return new Response("\u5236\u4f5cx5", "\u5236\u4f5c\u81f3\u5c11\u9700\u8981\u6dfb\u52a0\u4e00\u79cd\u6548\u679c\uff01", null);
                        }
                        if (ingredientCount < 5) {
                            return new Response("\u5236\u4f5cx5 (" + UtilText.formatAsEssencesUncoloured(essenceCost * 5, "span", false) + ")", "\u4f60\u5e76\u672a\u62e5\u6709\u4e94\u4e2a" + ingredient.getNamePlural() + "\uff0c\u6240\u4ee5\u65e0\u6cd5\u5236\u4f5c\u4e94\u4e2a\u6b64\u7c7b\u7269\u54c1\u2026\u2026", null);
                        }
                        if (!EnchantmentDialogue.canAffordCost(ingredient, effects, 5)) {
                            return new Response("\u5236\u4f5cx5 (" + UtilText.formatAsEssencesUncoloured(essenceCost * 5, "span", false) + ")", "\u5236\u4f5c\u4e94\u4e2a\u6240\u9700\u5f00\u9500\u4e0d\u8db3\uff01", null);
                        }
                        return new ResponseEffectsOnly("\u5236\u4f5cx5 (" + UtilText.formatAsEssences(essenceCost * 5, "span", false) + ")", "\u5236\u4f5c\u4e94\u4e2a'" + EnchantingUtils.getPotionName(ingredient, effects) + "'. \u5c06\u4f1a\u82b1\u8d39[style.boldArcane(" + EnchantingUtils.getCost(ingredient, effects) + ")]\u5965\u672f\u7cbe\u534e\u3002"){

                            @Override
                            public void effects() {
                                EnchantmentDialogue.applyEnchantingEffect(5);
                            }
                        };
                    }
                    if (index == 3 && !(ingredient instanceof Tattoo)) {
                        if (effects.equals(ingredient.getEffects()) || effects.isEmpty() && ingredient instanceof AbstractItem) {
                            return new Response("\u5168\u90e8\u5236\u4f5c (x" + ingredientCount + ")", "\u4f60\u9700\u8981\u81f3\u5c11\u6dfb\u52a0\u4e00\u4e2a\u6548\u679c\u624d\u80fd\u8fdb\u884c\u5236\u4f5c\uff01", null);
                        }
                        if (!EnchantmentDialogue.canAffordCost(ingredient, effects, ingredientCount)) {
                            return new Response("\u5236\u4f5c\u6240\u6709 (x" + ingredientCount + ") (" + UtilText.formatAsEssencesUncoloured(essenceCost * ingredientCount, "span", false) + ")", "\u5236\u4f5c\u4e94\u4e2a\u6240\u9700\u5f00\u9500\u4e0d\u8db3\uff01", null);
                        }
                        return new ResponseEffectsOnly("\u5168\u90e8\u5236\u4f5c (x" + ingredientCount + ") (" + UtilText.formatAsEssences(essenceCost * ingredientCount, "span", false) + ")", "\u5236\u4f5c" + Util.intToString(ingredientCount) + "\u4e2a\u201c" + EnchantingUtils.getPotionName(ingredient, effects) + "\u201d\u3002\u5c06\u4f1a\u82b1\u8d39[style.boldArcane(" + essenceCost * ingredientCount + ")]\u5965\u672f\u7cbe\u534e\u3002"){

                            @Override
                            public void effects() {
                                EnchantmentDialogue.applyEnchantingEffect(ingredientCount);
                            }
                        };
                    }
                    if (index == 6) {
                        return new Response("\u4fdd\u5b58/\u8bfb\u53d6", "\u4fdd\u5b58/\u8bfb\u53d6\u9644\u9b54\u65b9\u6cd5\u3002", ENCHANTMENT_SAVE_LOAD){

                            @Override
                            public void effects() {
                                Main.mainController.getWebEngine().executeScript("document.getElementById('hiddenPField').innerHTML=document.getElementById('output_name').value;");
                                EnchantmentDialogue.setOutputName(Main.mainController.getWebEngine().getDocument().getElementById("hiddenPField").getTextContent());
                            }
                        };
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.INVENTORY;
            }
        };
        ENCHANTMENT_SAVE_LOAD = new DialogueNode("\u4fdd\u5b58\u9644\u9b54\u6587\u4ef6", "", true){

            @Override
            public void applyPreParsingEffects() {
                EnchantmentDialogue.initSaveLoadMenu();
            }

            @Override
            public String getContent() {
                return "";
            }

            @Override
            public String getHeaderContent() {
                StringBuilder saveLoadSB = new StringBuilder();
                saveLoadSB.append("<div class='container-full-width' style='padding:0; margin:0 0 8px 0;'>\u53ea\u6709\u6807\u51c6\u7684\u7b26\u53f7(\u5b57\u6bcd\u4e0e\u6570\u5b57)\u80fd\u4f5c\u4e3a\u4fdd\u5b58\u6587\u4ef6\u7684\u540d\u5b57\u3002<br/>\u60ac\u505c\u5728\u9053\u5177\u56fe\u6807\u4e0a\u65b9\u4ee5\u67e5\u770b\u8981\u4fdd\u5b58/\u8bfb\u53d6\u7684\u6548\u679c\u3002<br/>\u5982\u679c\u540d\u5b57\u662f[style.colourBad(\u7ea2\u8272)]\u7684\uff0c\u8fd9\u4ee3\u8868\u4f60\u6ca1\u6709\u76f8\u5e94\u7684\u9053\u5177\uff0c\u4ee5\u81f3\u4e8e\u65e0\u6cd5\u8bfb\u53d6\u5bf9\u5e94\u6548\u679c\u3002<br/>\u5982\u679c\u4f60\u7684\u9644\u9b54\u5df2\u6dfb\u52a0\u81f3\u5c11\u4e00\u79cd\u6548\u679c\uff0c\u90a3\u4e48\u53ea\u80fd\u4fdd\u5b58/\u8986\u76d6\u3002</div><div class='container-full-width' style='padding:0; margin:0;'><div class='container-full-width' style='width:calc(75% - 16px); text-align:center; background:transparent;'>\u540d\u5b57</div><div class='container-full-width' style='width:calc(25% - 16px); text-align:center; background:transparent;'>\u4fdd\u5b58 | \u8bfb\u53d6 | \u5220\u9664</div></div>");
                int i = 0;
                saveLoadSB.append(EnchantmentDialogue.getSaveLoadRow(null, null, i % 2 == 0));
                ++i;
                for (Map.Entry<String, LoadedEnchantment> entry : loadedEnchantmentsMap.entrySet()) {
                    saveLoadSB.append(EnchantmentDialogue.getSaveLoadRow(entry.getKey(), entry.getValue(), i % 2 == 0));
                    ++i;
                }
                saveLoadSB.append("<p id='hiddenPField' style='display:none;'></p>");
                return saveLoadSB.toString();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 1) {
                    return new Response("\u786e\u8ba4\u72b6\u6001\uff1a", "\u5728\u70b9\u51fb\u8bfb\u53d6\u3001\u8986\u5199\u6216\u5220\u9664\u9644\u9b54\u65f6\u4f1a\u8fdb\u5165\u786e\u8ba4\u72b6\u6001\u3002\u542f\u7528\u65f6\uff0c\u9700\u8981\u8fdb\u884c\u4e24\u6b21\u70b9\u51fb\u624d\u80fd\u4f7f\u884c\u4e3a\u751f\u6548\u3002\u5173\u95ed\u65f6\u53ea\u9700\u8981\u4e00\u6b21\u70b9\u51fb\u3002", ENCHANTMENT_SAVE_LOAD){

                        @Override
                        public String getTitle() {
                            return "\u786e\u8ba4\uff1a" + (Main.getProperties().hasValue(PropertyValue.overwriteWarning) ? "<span style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u5f00\u542f</span>" : "<span style='color:" + PresetColour.GENERIC_BAD.toWebHexString() + ";'>\u5173\u95ed</span>");
                        }

                        @Override
                        public void effects() {
                            loadConfirmationName = "";
                            overwriteConfirmationName = "";
                            deleteConfirmationName = "";
                            Main.getProperties().setValue(PropertyValue.overwriteWarning, !Main.getProperties().hasValue(PropertyValue.overwriteWarning));
                            Main.getProperties().savePropertiesAsXML();
                        }
                    };
                }
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u56de\u5230\u9644\u9b54\u83dc\u5355\u3002", ENCHANTMENT_MENU);
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.INVENTORY;
            }
        };
    }
}

