/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.utils;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.body.types.LegType;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.npc.NPC;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.combat.DamageType;
import com.lilithsthrone.game.combat.moves.CombatMove;
import com.lilithsthrone.game.combat.spells.SpellSchool;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.DialogueNodeType;
import com.lilithsthrone.game.dialogue.companions.SlaveDialogue;
import com.lilithsthrone.game.dialogue.eventLog.EventLogEntry;
import com.lilithsthrone.game.dialogue.eventLog.EventLogEntryEncyclopediaUnlock;
import com.lilithsthrone.game.dialogue.responses.Response;
import com.lilithsthrone.game.dialogue.responses.ResponseEffectsOnly;
import com.lilithsthrone.game.dialogue.story.CharacterCreation;
import com.lilithsthrone.game.dialogue.utils.EnchantmentDialogue;
import com.lilithsthrone.game.dialogue.utils.InventoryInteraction;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.ColourReplacement;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.Rarity;
import com.lilithsthrone.game.inventory.ShopTransaction;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.BlockedParts;
import com.lilithsthrone.game.inventory.clothing.DisplacementType;
import com.lilithsthrone.game.inventory.clothing.Sticker;
import com.lilithsthrone.game.inventory.clothing.StickerCategory;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.game.inventory.enchanting.TFPotency;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.game.sex.sexActions.SexActionUtility;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.Pattern;
import com.lilithsthrone.rendering.RenderingEngine;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.utils.comparators.ClothingZLayerComparator;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class InventoryDialogue {
    private static final int IDENTIFICATION_PRICE = 1000;
    private static final int IDENTIFICATION_ESSENCE_PRICE = 15;
    private static AbstractItem item;
    private static AbstractClothing clothing;
    private static AbstractWeapon weapon;
    private static InventorySlot weaponSlot;
    private static GameCharacter owner;
    private static NPC inventoryNPC;
    private static InventoryInteraction interactionType;
    private static StringBuilder inventorySB;
    private static boolean buyback;
    private static int buyBackPrice;
    private static int buyBackIndex;
    public static DamageType damageTypePreview;
    public static List<Colour> dyePreviews;
    public static String dyePreviewPattern;
    public static List<Colour> dyePreviewPatternColours;
    public static Map<StickerCategory, Sticker> dyePreviewStickers;
    public static final DialogueNode INVENTORY_MENU;
    public static final DialogueNode INVENTORY_MENU_KEYS;
    public static final DialogueNode ITEM_INVENTORY;
    public static final DialogueNode WEAPON_INVENTORY;
    public static final DialogueNode CLOTHING_INVENTORY;
    public static final DialogueNode WEAPON_EQUIPPED;
    public static final DialogueNode CLOTHING_EQUIPPED;
    public static final DialogueNode DYE_CLOTHING;
    public static final DialogueNode DYE_EQUIPPED_CLOTHING;
    public static final DialogueNode DYE_CLOTHING_CHARACTER_CREATION;
    public static final DialogueNode DYE_EQUIPPED_CLOTHING_CHARACTER_CREATION;
    public static final DialogueNode DYE_WEAPON;
    public static final DialogueNode DYE_EQUIPPED_WEAPON;

    public static Map<String, String> getDyePreviewStickersAsStrings() {
        HashMap<String, String> stickerIds = new HashMap<String, String>();
        for (Map.Entry<StickerCategory, Sticker> entry : dyePreviewStickers.entrySet()) {
            stickerIds.put(entry.getKey().getId(), entry.getValue().getId());
        }
        return stickerIds;
    }

    private static void resetClothingDyeColours() {
        dyePreviews = new ArrayList<Colour>();
        dyePreviews.addAll(clothing.getColours());
        dyePreviewPattern = clothing.getPattern();
        dyePreviewPatternColours = new ArrayList<Colour>();
        dyePreviewPatternColours.addAll(clothing.getPatternColours());
        dyePreviewStickers = new HashMap<StickerCategory, Sticker>(clothing.getStickersAsObjects());
    }

    private static void resetWeaponDyeColours() {
        dyePreviews = new ArrayList<Colour>();
        dyePreviews.addAll(weapon.getColours());
        damageTypePreview = weapon.getDamageType();
    }

    private static String inventoryView() {
        inventorySB = new StringBuilder();
        inventorySB.append(RenderingEngine.ENGINE.getInventoryPanel(inventoryNPC, buyback));
        return inventorySB.toString();
    }

    private static void equipAll(GameCharacter character) {
        ArrayList<AbstractClothing> zlayerClothing = new ArrayList<AbstractClothing>(character.getAllClothingInInventory().keySet());
        zlayerClothing.removeIf(c -> c.isEnchantmentKnown() && c.isSealed());
        zlayerClothing.sort(new ClothingZLayerComparator().reversed());
        HashSet<InventorySlot> slotsTaken = new HashSet<InventorySlot>();
        for (AbstractClothing c2 : character.getClothingCurrentlyEquipped()) {
            slotsTaken.add(c2.getSlotEquippedTo());
        }
        for (AbstractClothing c2 : zlayerClothing) {
            if (slotsTaken.contains((Object)c2.getClothingType().getEquipSlots().get(0))) continue;
            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + character.equipClothingFromInventory(c2, true, character, character) + "</p>");
            slotsTaken.add(c2.getClothingType().getEquipSlots().get(0));
        }
    }

    private static String unequipAll(GameCharacter character) {
        StringBuilder sb = new StringBuilder();
        ArrayList<AbstractClothing> zlayerClothing = new ArrayList<AbstractClothing>(character.getClothingCurrentlyEquipped());
        zlayerClothing.sort(new ClothingZLayerComparator());
        for (AbstractClothing c : zlayerClothing) {
            if (Main.game.isInSex() && (c.getSlotEquippedTo().isJewellery() || c.isCondom() || character.hasPerkAnywhereInTree(Perk.SPECIAL_SHORT_SIGHTED) && c.getItemTags().contains((Object)ItemTag.PRESCRIPTION_GLASSES)) || c.isMilkingEquipment()) continue;
            if (c.isDiscardedOnUnequip(null)) {
                character.unequipClothingIntoVoid(c, true, (GameCharacter)Main.game.getPlayer());
            } else if (Main.game.isInNewWorld()) {
                character.unequipClothingIntoInventory(c, true, Main.game.getPlayer());
            } else {
                character.unequipClothingOntoFloor(c, true, Main.game.getPlayer());
            }
            sb.append("<p style='text-align:center;'>" + character.getUnequipDescription() + "</p>");
        }
        return sb.toString();
    }

    private static String getEnchantmentNotDiscoveredText(String item) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u4f60\u8fd8\u4e0d\u77e5\u9053\u5982\u4f55\u9644\u9b54");
        sb.append(item);
        sb.append("\u2026\u2026");
        sb.append("<br/>");
        if (Main.game.getPlayer().hasQuest(QuestLine.SIDE_ENCHANTMENT_DISCOVERY)) {
            sb.append("[style.italicsArcane(\u4f60\u5e94\u8be5\u95ee\u4e00\u95ee\u8389\u83b1\u96c5\u7cbe\u534e\u7684\u4e8b\u60c5\u2026\u2026)]");
        } else {
            sb.append("[style.italicsArcane(\u4f60\u9700\u8981\u5728\u6218\u6597\u6216\u6027\u7231\u540e\u5438\u6536\u7cbe\u534e\uff0c\u6216\u8005\u901a\u8fc7\u8d2d\u4e70\u7cbe\u534e\u6765\u53d1\u73b0\u66f4\u591a\u5173\u4e8e\u9644\u9b54\u7684\u77e5\u8bc6\u2026\u2026)]");
        }
        return sb.toString();
    }

    private static String getClothingBlockingRemovalText(GameCharacter equipTarget, String equipVerb) {
        StringBuilder sb = new StringBuilder();
        AbstractClothing blockingClothing = equipTarget.getBlockingClothing();
        sb.append("\u4f60\u4e0d\u80fd");
        sb.append(equipVerb);
        sb.append("\u90a3\u4ef6");
        sb.append(clothing.getName());
        sb.append("\uff0c\u8fd9\u662f\u56e0\u4e3a");
        if (blockingClothing.equals(clothing) && clothing.isSealed()) {
            sb.append(blockingClothing.getClothingType().isPlural() != false ? "\u5b83\u4eec\u88ab" : "\u5b83\u88ab");
            sb.append(" \u5c01\u5370\u4e86\uff01");
        } else {
            sb.append(UtilText.parse(equipTarget, "[npc.namePos]\u7684", new ParserTag[0]));
            sb.append(blockingClothing.getName());
            sb.append(blockingClothing.getClothingType().isPlural() != false ? "\u5728" : " \u5728");
            sb.append("\u963b\u6b62\u4f60\u5982\u6b64\u505a\uff01");
        }
        return sb.toString();
    }

    private static boolean isWeaponDyeReforgeActionAvailable() {
        return Main.game.getPlayer().hasItemType(ItemType.DYE_BRUSH) || Main.game.getPlayer().hasItemType(ItemType.REFORGE_HAMMER) || Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) || Main.game.isDebugMode();
    }

    private static boolean isClothingDyeActionAvailable() {
        return Main.game.getPlayer().hasItemType(ItemType.DYE_BRUSH) || Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) || Main.game.isDebugMode();
    }

    private static String getClothingDyeUI() {
        InventorySlot slotEquippedTo = clothing.getSlotEquippedTo();
        if (slotEquippedTo == null) {
            slotEquippedTo = clothing.getClothingType().getEquipSlots().get(0);
        }
        inventorySB = new StringBuilder("<div class='container-full-width'><div class='inventoryImage'><div class='inventoryImage-content'>" + clothing.getSVGString() + "</div></div><h3 style='text-align:center;'><b>" + clothing.getDisplayName(true) + "</b></h3><p>\u4ece\u4e0b\u65b9\u67d3\u8272\u7684\u6309\u94ae\u4e2d\u9009\u62e9\u4f60\u60f3\u8981\u7684\u989c\u8272\uff0c\u5e76\u4f7f\u7528\u9884\u89c8\u67e5\u770b\u67d3\u8272\u540e\u7684\u6548\u679c\uff0c\u70b9\u51fb\u5c4f\u5e55\u5e95\u7aef\u7684\u201c\u67d3\u8272\u201d\u5373\u53ef\u5e94\u7528\u4fee\u6539\u3002</p></div><br/><div class='container-full-width'><div class='inventoryImage'><div class='inventoryImage-content'>" + clothing.getClothingType().getSVGImage(slotEquippedTo, dyePreviews, dyePreviewPattern, dyePreviewPatternColours, InventoryDialogue.getDyePreviewStickersAsStrings()) + "</div></div>");
        inventorySB.append("<h3 style='text-align:center;'><b>\u67d3\u8272\u5e76\u9884\u89c8</b></h3>");
        if (!clothing.getClothingType().getStickers().isEmpty()) {
            StringBuilder stickerSB = new StringBuilder();
            boolean stickerFound = false;
            ArrayList<StickerCategory> orderedCategories = new ArrayList<StickerCategory>(clothing.getClothingType().getStickers().keySet());
            Collections.sort(orderedCategories, (s1, s2) -> s1.getPriority() - s2.getPriority());
            for (StickerCategory cat : orderedCategories) {
                stickerSB.append("<div class='container-quarter-width' style='width:calc(75% - 16px); margin:0 8px; padding:0;'>");
                stickerSB.append("<div class='container-quarter-width' style='margin:0; padding-top:6px; width:20%;'>");
                stickerSB.append(Util.capitaliseSentence(cat.getName()) + ":");
                stickerSB.append("</div>");
                stickerSB.append("<div class='container-quarter-width' style='margin:0; padding:0; width:80%;'>");
                ArrayList orderedStickers = new ArrayList(clothing.getClothingType().getStickers().get(cat));
                Collections.sort(orderedStickers, (s1, s2) -> s1.getPriority() - s2.getPriority());
                for (Sticker sticker : orderedStickers) {
                    String requirements = UtilText.parse(sticker.getUnavailabilityText(), new ParserTag[0]).trim();
                    if (!requirements.isEmpty() && !sticker.isShowDisabledButton()) continue;
                    boolean specialSticker = !sticker.getAvailabilityText().isEmpty() || !sticker.getTagsApplied().isEmpty() || !sticker.getTagsRemoved().isEmpty();
                    stickerFound = true;
                    String id = "ITEM_STICKER_" + cat.getId() + sticker.getId();
                    if (!requirements.isEmpty()) {
                        stickerSB.append("<div id='" + id + "' class='cosmetics-button disabled'><b style='color:" + PresetColour.TEXT_GREY.toWebHexString() + ";'>" + Util.capitaliseSentence(sticker.getName()) + (specialSticker ? "*" : "") + "</b></div>");
                        continue;
                    }
                    if (dyePreviewStickers.get(cat) == sticker) {
                        stickerSB.append("<div id='" + id + "' class='cosmetics-button active'><b style='color:" + sticker.getColourSelected().toWebHexString() + ";'>" + Util.capitaliseSentence(sticker.getName()) + (specialSticker ? "*" : "") + "</b></div>");
                        continue;
                    }
                    stickerSB.append("<div id='" + id + "' class='cosmetics-button'><span style='color:" + sticker.getColourDisabled().toWebHexString() + ";'>" + Util.capitaliseSentence(sticker.getName()) + (specialSticker ? "*" : "") + "</span></div>");
                }
                stickerSB.append("</div>");
                stickerSB.append("</div>");
                if (!stickerFound) continue;
                stickerFound = false;
                inventorySB.append(stickerSB.toString());
                stickerSB = new StringBuilder();
            }
        }
        for (int i = 0; i < clothing.getClothingType().getColourReplacements().size(); ++i) {
            ColourReplacement cr = clothing.getClothingType().getColourReplacement(i);
            if (cr.getAllColours().isEmpty()) continue;
            inventorySB.append("<div class='container-quarter-width' style='width:calc(75% - 16px);'>" + Util.capitaliseSentence(Util.intToPrimarySequence(i + 1)) + "\u989c\u8272" + (cr.isRecolouringAllowed() ? "" : " ([style.italicsBad(\u65e0\u6cd5\u66f4\u6539)])") + ":<br/>");
            for (Colour c : cr.getAllColours()) {
                inventorySB.append("<div class='normal-button" + (dyePreviews.size() > i && dyePreviews.get(i) == c ? " selected" : "") + "' id='DYE_CLOTHING_" + i + "_" + c.getId() + "' style='width:auto; margin-right:4px; border-width:1px;" + (String)(cr.getDefaultColours().contains(c) ? "border-color:" + PresetColour.TEXT_GREY.toWebHexString() + ";" : "") + (String)(dyePreviews.size() > i && dyePreviews.get(i) == c ? " background-color:" + PresetColour.BASE_GREEN.getShades()[4] + ";" : "") + "'><div class='phone-item-colour' style='" + (c.isMetallic() ? "background: repeating-linear-gradient(135deg, " + c.toWebHexString() + ", " + c.getShades()[4] + " 10px);" : "background-color:" + c.toWebHexString() + ";") + "'></div></div>");
            }
            inventorySB.append("</div>");
        }
        if (clothing.getClothingType().isPatternAvailable()) {
            inventorySB.append("<br/><div class='container-full-width'>\u82b1\u7eb9:<br/>");
            for (Pattern pattern : Pattern.getAllPatterns()) {
                if (dyePreviewPattern.equals(pattern.getId())) {
                    inventorySB.append("<div class='cosmetics-button active'><b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>" + Util.capitaliseSentence(pattern.getNiceName()) + "</b></div>");
                    continue;
                }
                inventorySB.append("<div id='ITEM_PATTERN_" + pattern.getId() + "' class='cosmetics-button'><span style='color:" + PresetColour.TRANSFORMATION_GENERIC.getShades()[0] + ";'>" + Util.capitaliseSentence(pattern.getNiceName()) + "</span></div>");
            }
            inventorySB.append("</div>");
            for (int i = 0; i < clothing.getClothingType().getPatternColourReplacements().size(); ++i) {
                ColourReplacement cr = clothing.getClothingType().getPatternColourReplacement(i);
                if (cr.getAllColours().isEmpty() || !Pattern.getPattern(dyePreviewPattern).isRecolourAvailable(cr)) continue;
                inventorySB.append("<div class='container-quarter-width' style='width:calc(75% - 16px);'>Pattern " + Util.capitaliseSentence(Util.intToPrimarySequence(i + 1)) + " \u989c\u8272:<br/>");
                for (Colour c : cr.getAllColours()) {
                    inventorySB.append("<div class='normal-button" + (dyePreviewPatternColours.size() > i && dyePreviewPatternColours.get(i) == c ? " selected" : "") + "' id='DYE_CLOTHING_PATTERN_" + i + "_" + c.getId() + "' style='width:auto; margin-right:4px;" + (String)(dyePreviewPatternColours.size() > i && dyePreviewPatternColours.get(i) == c ? " background-color:" + PresetColour.BASE_GREEN.getShades()[4] + ";" : "") + "'><div class='phone-item-colour' style='" + (c.isMetallic() ? "background: repeating-linear-gradient(135deg, " + c.toWebHexString() + ", " + c.getShades()[4] + " 10px);" : "background-color:" + c.toWebHexString() + ";") + "'></div></div>");
                }
                inventorySB.append("</div>");
            }
        }
        inventorySB.append("</div>");
        return inventorySB.toString();
    }

    private static String getWeaponDyeUI() {
        inventorySB = new StringBuilder("<div class='container-full-width'><div class='inventoryImage'><div class='inventoryImage-content'>" + weapon.getSVGString() + "</div></div><h3 style='text-align:center;'><b>" + weapon.getDisplayName(true) + "</b></h3><p>\u4ece\u4e0b\u65b9\u67d3\u8272\u7684\u6309\u94ae\u4e2d\u9009\u62e9\u4f60\u60f3\u8981\u7684\u989c\u8272\uff0c\u5e76\u4f7f\u7528\u9884\u89c8\u67e5\u770b\u67d3\u8272\u540e\u7684\u6548\u679c\uff0c\u70b9\u51fb\u5c4f\u5e55\u5e95\u7aef\u7684\u201c\u67d3\u8272\u201d\u5373\u53ef\u5e94\u7528\u4fee\u6539\u3002</p></div><br/><div class='container-full-width'><div class='container-full-width' style='text-align:center; width:calc(25% - 16px); float:right;'><div class='inventoryImage' style='width:100%;'>" + (weapon.getWeaponType().isEquippedSVGImageDifferent() ? "\u5df2\u5378\u4e0b" : "") + "<div class='inventoryImage-content'>" + weapon.getWeaponType().getSVGImage(damageTypePreview, dyePreviews) + "</div></div>" + (String)(weapon.getWeaponType().isEquippedSVGImageDifferent() ? "<div class='inventoryImage' style='width:100%;'>\u5df2\u88c5\u5907<div class='inventoryImage-content'>" + weapon.getWeaponType().getSVGEquippedImage(Main.game.getPlayer(), damageTypePreview, dyePreviews) + "</div></div>" : "") + "</div><h3 style='text-align:center;'><b>\u67d3\u8272\u5e76\u9884\u89c8</b></h3>");
        inventorySB.append("<div class='container-quarter-width' style='text-align:center;width:calc(75% - 16px);'><b>\u4f24\u5bb3\u7c7b\u578b:</b><br/>");
        for (DamageType dt : weapon.getWeaponType().getAvailableDamageTypes()) {
            inventorySB.append("<div class='normal-button" + (damageTypePreview == dt ? " selected" : "") + "' id='DAMAGE_TYPE_" + dt.toString() + "'style='width:20%; margin:0 2.5%; color:" + (damageTypePreview == dt ? dt.getColour().toWebHexString() : dt.getColour().getShades(8)[0]) + ";'>" + Util.capitaliseSentence(dt.getName()) + "</div>");
        }
        inventorySB.append("</div>");
        boolean colourOptions = false;
        for (int i = 0; i < weapon.getWeaponType().getColourReplacements(false).size(); ++i) {
            colourOptions = true;
            ColourReplacement cr = weapon.getWeaponType().getColourReplacement(false, i);
            if (cr.getAllColours().isEmpty()) continue;
            inventorySB.append("<div class='container-quarter-width' style='width:calc(75% - 16px);'>" + Util.capitaliseSentence(Util.intToPrimarySequence(i + 1)) + "\u989c\u8272" + (cr.isRecolouringAllowed() ? "" : " ([style.italicsBad(\u65e0\u6cd5\u66f4\u6539)])") + ":<br/>");
            for (Colour c : cr.getAllColours()) {
                inventorySB.append("<div class='normal-button" + (dyePreviews.size() > i && dyePreviews.get(i) == c ? " selected" : "") + "' id='DYE_WEAPON_" + i + "_" + c.getId() + "' style='width:auto; margin-right:4px; border-width:1px;" + (String)(cr.getDefaultColours().contains(c) ? "border-color:" + PresetColour.TEXT_GREY.toWebHexString() + ";" : "") + (String)(dyePreviews.size() > i && dyePreviews.get(i) == c ? " background-color:" + PresetColour.BASE_GREEN.getShades()[4] + ";" : "") + "'><div class='phone-item-colour' style='" + (c.isMetallic() ? "background: repeating-linear-gradient(135deg, " + c.toWebHexString() + ", " + c.getShades()[4] + " 10px);" : "background-color:" + c.toWebHexString() + ";") + "'></div></div>");
            }
            inventorySB.append("</div>");
        }
        if (!colourOptions) {
            inventorySB.append("<div class='container-half-width' style='text-align:center;'>[style.colourDisabled(\u67d3\u8272\u9009\u9879\u5747\u4e0d\u53ef\u7528\u2026\u2026)]</div>");
        }
        inventorySB.append("</div>");
        return inventorySB.toString();
    }

    private static String getDyeBrushEffects(AbstractClothing clothing, Colour colour) {
        return "<p>\u5f53\u4f60\u63e1\u4f4f\u67d3\u8272\u5237\u65f6\uff0c\u4f60\u770b\u5230\u5237\u5934\u53d1\u51fa\u4e00\u9635\u7d2b\u8272\u7684\u5f3a\u5149\u3002\u5f53\u5176\u8d8a\u9760\u8fd1" + clothing.getName() + "\uff0c\u5149\u8292\u5c31\u8d8a\u660e\u4eae\uff0c\u6700\u540e\u4e00\u77ac\u95f4\uff0c\u4e94\u989c\u516d\u8272\u7684\u753b\u9762\u5f00\u59cb\u5728\u4f60\u7684\u8111\u4e2d\u95ea\u70c1\u3002\u7528\u6bdb\u5237\u89e6\u78b0\u5230" + clothing.getName() + "\u7684\u8868\u9762\u65f6\uff0c\u67d3\u8272\u5237\u77ac\u95f4\u6c7d\u5316\u4e86\uff01\u4f60\u770b\u5f97\u51fa\u5965\u672f\u9644\u9b54\u5df2\u7ecf\u5c06" + clothing.getName() + "\u67d3\u6210" + colour.getName() + "\u3002</p>";
    }

    private static String getDyeBrushEffects(AbstractWeapon weapon, Colour colour) {
        return "<p>\u5f53\u4f60\u63e1\u4f4f\u67d3\u8272\u5237\u65f6\uff0c\u4f60\u770b\u5230\u5237\u5934\u53d1\u51fa\u4e00\u9635\u7d2b\u8272\u7684\u5f3a\u5149\u3002\u5f53\u5176\u8d8a\u9760\u8fd1" + weapon.getName() + "\uff0c\u5149\u8292\u5c31\u8d8a\u660e\u4eae\uff0c\u6700\u540e\u4e00\u77ac\u95f4\uff0c\u4e94\u989c\u516d\u8272\u7684\u753b\u9762\u5f00\u59cb\u5728\u4f60\u7684\u8111\u4e2d\u95ea\u70c1\u3002\u7528\u6bdb\u5237\u89e6\u78b0\u5230" + weapon.getName() + "\u7684\u8868\u9762\u65f6\uff0c\u67d3\u8272\u5237\u77ac\u95f4\u6c7d\u5316\u4e86\uff01\u4f60\u770b\u5f97\u51fa\u5965\u672f\u9644\u9b54\u5df2\u7ecf\u5c06" + weapon.getName() + "\u67d3\u6210" + colour.getName() + "\u3002</p>";
    }

    private static String getReforgeHammerEffects(AbstractWeapon weapon, DamageType damageType) {
        return "<p>\u5f53\u4f60\u63e1\u4f4f\u91cd\u94f8\u9524\u65f6\uff0c\u4f60\u770b\u5230\u91d1\u5c5e\u5934\u53d1\u51fa\u4e00\u9635\u6697\u7d2b\u8272\u7684\u5149\u8292\u3002\u5f53\u5176\u8d8a\u9760\u8fd1" + weapon.getName() + "\uff0c\u5149\u8292\u5c31\u8d8a\u660e\u4eae\uff0c\u6700\u540e\u4e00\u77ac\u95f4\uff0c\u5404\u7c7b\u4f24\u5bb3\u7c7b\u578b\u7684\u753b\u9762\u5f00\u59cb\u5728\u4f60\u7684\u8111\u4e2d\u95ea\u70c1\u3002\u7528\u91d1\u5c5e\u5934\u89e6\u78b0\u5230" + weapon.getName() + "\u7684\u8868\u9762\u65f6\uff0c\u91cd\u94f8\u9524\u77ac\u95f4\u6c7d\u5316\u4e86\uff01\u4f60\u6ce8\u610f\u5230\u5965\u672f\u9644\u9b54\u5df2\u7ecf\u91cd\u94f8\u4e86" + weapon.getName() + "\uff0c\u73b0\u5728\u8fd9\u628a\u6b66\u5668\u80fd\u9020\u6210" + damageType.getName() + "\u4f24\u5bb3\u3002</p>";
    }

    private static String getItemDisplayPanel(AbstractCoreItem item, String SVGString, String title, String description) {
        return "<div class='inventoryImage'><div class='inventoryImage-content'>" + SVGString + "</div></div><h5 style='margin-bottom:0; padding-bottom:0;'><b>" + title + "</b></h5><p style='margin-top:0; padding-top:0;'>" + UtilText.parse(item, description, new ParserTag[0]) + "</p>";
    }

    private static String getGeneralResponseTabTitle(int index) {
        if (index == 0) {
            return "\u603b\u89c8";
        }
        if (index == 1) {
            return "\u9009\u62e9\u7684\u7269\u54c1";
        }
        return null;
    }

    private static Response getCloseInventoryResponse() {
        if (interactionType == InventoryInteraction.CHARACTER_CREATION) {
            return new Response("\u8fd4\u56de", "\u5bf9\u7740\u955c\u5b50\u68c0\u67e5\u4f60\u7684\u5916\u89c2\u3002", CharacterCreation.CHOOSE_ADVANCED_APPEARANCE){

                @Override
                public int getSecondsPassed() {
                    return -30;
                }

                @Override
                public void effects() {
                    item = null;
                    clothing = null;
                    weapon = null;
                }
            };
        }
        return new ResponseEffectsOnly("\u5173\u95ed\u7269\u54c1\u680f", "\u5173\u95ed\u7269\u54c1\u680f\u83dc\u5355\u3002"){

            @Override
            public void effects() {
                item = null;
                clothing = null;
                weapon = null;
                Main.mainController.openInventory();
            }
        };
    }

    private static Response getBuybackResponse() {
        if (buyback) {
            return new Response("\u6b63\u5e38\u4ea4\u6613", "\u8f6c\u6362\u81f3\u6b63\u5e38\u4ea4\u6613\u83dc\u5355\u3002", INVENTORY_MENU){

                @Override
                public void effects() {
                    buyback = !buyback;
                }
            };
        }
        if (Main.game.getPlayer().getBuybackStack() == null || Main.game.getPlayer().getBuybackStack().isEmpty()) {
            return new Response("\u56de\u8d2d", "\u4f60\u8fd8\u6ca1\u6709\u51fa\u624b\u4efb\u4f55\u7269\u54c1\uff0c\u6240\u4ee5\u65e0\u6cd5\u56de\u8d2d\u2026\u2026", null);
        }
        return new Response("\u56de\u8d2d", "\u8f6c\u6362\u81f3\u56de\u8d2d\u83dc\u5355\u3002", INVENTORY_MENU){

            @Override
            public void effects() {
                buyback = !buyback;
            }
        };
    }

    private static Response getQuickTradeResponse() {
        return null;
    }

    private static Response getJinxRemovalResponse(boolean selfUnseal) {
        final boolean ownsKey = Main.game.getPlayer().getUnlockKeyMap().containsKey(owner.getId()) && Main.game.getPlayer().getUnlockKeyMap().get(owner.getId()).contains((Object)clothing.getSlotEquippedTo());
        final int removalCost = clothing.getJinxRemovalCost(Main.game.getPlayer(), selfUnseal);
        if (clothing.getEffects().stream().filter(ie -> ie.getSecondaryModifier() == TFModifier.CLOTHING_SEALING).findFirst().get().getPotency() == TFPotency.SPECIAL) {
            return new Response("\u89e3\u5c01([style.colourTerrible(\u4e0d\u53ef\u80fd)])", "\u8fd9\u4e2a" + clothing.getName() + "\u62e5\u6709\u7279\u6b8a\u7684\u5c01\u5370\u9644\u9b54\uff0c\u65e0\u6cd5\u901a\u8fc7\u5e38\u89c4\u65b9\u5f0f\u89e3\u9664\uff01", null);
        }
        if (interactionType == InventoryInteraction.COMBAT) {
            return new Response("\u89e3\u5c01" + (String)(ownsKey ? "(\u4f7f\u7528\u94a5\u5319)" : "(<i>" + removalCost + "\u7cbe\u534e</i>)"), "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u89e3\u5c01\u8863\u7269\uff01", null);
        }
        if (interactionType == InventoryInteraction.SEX) {
            if (Main.sex.isCharacterImmobilised(Main.game.getPlayer())) {
                return new Response("\u89e3\u5c01" + (String)(ownsKey ? "(\u4f7f\u7528\u94a5\u5319)" : "(<i>" + removalCost + "\u7cbe\u534e</i>)"), UtilText.parse(owner, "\u4f60\u65e0\u6cd5\u89e3\u5c01[npc.namePos]\u7684\u8863\u7269\uff0c\u56e0\u4e3a\u4f60\u5f53\u524d[style.colourTerrible(\u65e0\u6cd5\u884c\u52a8)]\uff01", new ParserTag[0]), null);
            }
            if (!selfUnseal && Main.sex.getInitialSexManager().isHidden(Main.game.getPlayer())) {
                return new Response("\u89e3\u5c01" + (String)(ownsKey ? "(\u4f7f\u7528\u94a5\u5319)" : "(<i>" + removalCost + "\u7cbe\u534e</i>)"), UtilText.parse(owner, "\u4f60\u65e0\u6cd5\u5728\u8eb2\u85cf\u65f6\u89e3\u5c01[npc.namePos]\u7684\u8863\u7269\uff01", new ParserTag[0]), null);
            }
            if (!Main.sex.getInitialSexManager().isAbleToRemoveClothingSeals(Main.game.getPlayer())) {
                return new Response("\u89e3\u5c01" + (String)(ownsKey ? "(\u4f7f\u7528\u94a5\u5319)" : "(<i>" + removalCost + "\u7cbe\u534e</i>)"), "\u65e0\u6cd5\u5728\u8be5\u6027\u4ea4\u573a\u666f\u89e3\u5c01\u8863\u7269\uff01", null);
            }
        }
        if (!ownsKey) {
            if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ENCHANTMENT_DISCOVERY)) {
                return new Response("\u89e3\u5c01", "\u4f60\u4e0d\u77e5\u9053\u5982\u4f55\u89e3\u5c01\u8863\u7269\uff01\u6216\u8bb8\u4f60\u53ef\u4ee5\u62dc\u8bbf\u8389\u83b1\u96c5\u7136\u540e\u95ee\u95ee\u5979\u2026\u2026", null);
            }
            if (Main.game.getPlayer().getClothingCurrentlyEquipped().stream().anyMatch(c -> c.isSelfTransformationInhibiting())) {
                return new Response("\u89e3\u5c01", "\u5c3d\u7ba1\u4f60\u5e73\u65f6\u53ef\u4ee5\u89e3\u5c01\u8863\u7269\uff0c\u4f46\u7531\u4e8e\u4f60\u88c5\u5907\u7684\u8863\u7269\u4e2d\u6709\u4e00\u5230\u591a\u4e2a\u5b58\u5728\u9644\u9b54\uff0c\u6240\u4ee5\u65e0\u6cd5\u8fd9\u4e48\u505a\uff01<br/>[style.italicsArcane(\u53bb\u627e\u8389\u83b1\u96c5\u5e2e\u4f60\u53bb\u9664\u5c01\u5370\u7684\u8863\u7269\uff01)]", null);
            }
            if (Main.game.getPlayer().getTattoos().values().stream().anyMatch(c -> c.isSelfTransformationInhibiting())) {
                return new Response("\u89e3\u5c01", "\u5c3d\u7ba1\u4f60\u5e73\u65f6\u53ef\u4ee5\u89e3\u5c01\u8863\u7269\uff0c\u4f46\u7531\u4e8e\u4f60\u7684\u7eb9\u8eab\u4e2d\u6709\u4e00\u5230\u591a\u4e2a\u5b58\u5728\u9644\u9b54\uff0c\u6240\u4ee5\u65e0\u6cd5\u8fd9\u4e48\u505a\uff01<br/>[style.italicsArcane(\u53bb\u627e\u51ef\u7279\u5e2e\u4f60\u53bb\u9664\u7eb9\u8eab\uff01)]", null);
            }
        }
        if (ownsKey || Main.game.getPlayer().getEssenceCount() >= removalCost) {
            return new Response("\u89e3\u5c01" + (String)(ownsKey ? "([style.italicsGood(\u4f7f\u7528\u94a5\u5319)])" : "([style.italicsArcane(" + removalCost + "\u7cbe\u534e)])"), (String)(ownsKey ? "\u7531\u4e8e\u4f60\u62e5\u6709\u80fd\u591f\u89e3\u9501\u8863\u670d\u7684\u94a5\u5319\uff0c\u4f60\u80fd\u591f\u4e0d\u6d88\u8017\u4efb\u4f55\u5965\u672f\u7cbe\u534e\u53bb\u9664\u5b83\uff01" : "\u82b1\u8d39" + removalCost + "\u5965\u672f\u7cbe\u534e\u89e3\u5c01\u8fd9\u4ef6\u8863\u7269\u3002" + (String)(Main.game.getPlayer().hasFetish(Fetish.FETISH_BONDAGE_VICTIM) && selfUnseal ? "<br/>[style.italicsMinorBad(\u7531\u4e8e\u4f60\u7684\u201c" + Fetish.FETISH_BONDAGE_VICTIM.getName(Main.game.getPlayer()) + "\u201d\u6027\u7656\uff0c\u4f60\u7684\u89e3\u5c01\u82b1\u8d39\u53d8\u4e3a\u6807\u51c6\u60c5\u51b5\u7684\u4e94\u500d\uff01)]" : "")), interactionType == InventoryInteraction.SEX ? Main.sex.SEX_DIALOGUE : INVENTORY_MENU){

                @Override
                public void effects() {
                    Object s = "";
                    if (ownsKey) {
                        if (!Main.game.isInSex()) {
                            Main.game.getPlayer().removeFromUnlockKeyMap(owner.getId(), clothing.getSlotEquippedTo());
                        }
                        s = "<p>Using the key which is in your possession, you unlock the " + clothing.getName() + "!</p>";
                    } else {
                        Main.game.getPlayer().incrementEssenceCount(-removalCost, false);
                        s = UtilText.parse(owner, "<p>\u4f60\u5f15\u5bfc\u5965\u672f\u7cbe\u534e\u7684\u80fd\u91cf\u8fdb\u5165\u4e86[npc.namePos]\u7684" + clothing.getName() + "\uff0c\u4e00\u9635\u4eae\u7d2b\u8272\u7684\u95ea\u5149\u540e\uff0c\u4f60\u89e3\u9664\u4e86\u5c01\u5370\uff01</p><p style='text-align:center;'>\u79fb\u9664\u5c01\u5370\u6d88\u8017\u4e86\u4f60[style.boldBad(" + removalCost + ")][style.boldArcane(\u5965\u672f\u7cbe\u534e)]\uff01</p>", new ParserTag[0]);
                    }
                    ArrayList clothingDisplacementTypes = new ArrayList();
                    if (Main.game.isInSex() && Main.sex.getAllParticipants().contains(owner)) {
                        if (Main.sex.getClothingPreSexMap().get(owner).get((Object)clothing.getSlotEquippedTo()).get(clothing) != null) {
                            clothingDisplacementTypes.addAll(Main.sex.getClothingPreSexMap().get(owner).get((Object)clothing.getSlotEquippedTo()).get(clothing));
                        }
                        Main.sex.getClothingPreSexMap().get(owner).get((Object)clothing.getSlotEquippedTo()).remove(clothing);
                    }
                    clothing.setSealed(false);
                    if (Main.game.isInSex() && Main.sex.getAllParticipants().contains(owner)) {
                        Main.sex.getClothingPreSexMap().get(owner).get((Object)clothing.getSlotEquippedTo()).put(clothing, clothingDisplacementTypes);
                    }
                    if (interactionType == InventoryInteraction.SEX) {
                        Main.sex.setUnequipClothingText(clothing, (String)s);
                        Main.mainController.openInventory();
                        Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                        Main.sex.setSexStarted(true);
                    } else {
                        Main.game.getTextEndStringBuilder().append((String)s);
                    }
                }
            };
        }
        return new Response("\u89e3\u5c01(<i>" + removalCost + "\u7cbe\u534e</i>)", "\u4f60\u81f3\u5c11\u9700\u8981" + removalCost + "\u5965\u672f\u7cbe\u534e\u624d\u80fd\u89e3\u5c01\u8fd9\u4ef6\u8863\u7269\uff01" + (String)(Main.game.getPlayer().hasFetish(Fetish.FETISH_BONDAGE_VICTIM) ? "<br/>[style.italicsMinorBad(\u7531\u4e8e\u4f60\u7684\u201c" + Fetish.FETISH_BONDAGE_VICTIM.getName(Main.game.getPlayer()) + "\u201d\u6027\u7656\uff0c\u89e3\u5c01\u82b1\u8d39\u53d8\u4e3a\u4e86\u6807\u51c6\u60c5\u51b5\u7684)][style.italicsBad(5\u500d)][style.italicsMinorBad(\uff01)]" : ""), null);
    }

    private static void transferItems(GameCharacter from, GameCharacter to, AbstractItem item, int count) {
        if (!to.isInventoryFull() || to.hasItem(item) || item.getRarity() == Rarity.QUEST) {
            from.removeItem(item, count);
            to.addItem(item, count, false, to.isPlayer());
        }
        InventoryDialogue.resetPostAction();
    }

    private static void dropItems(GameCharacter from, AbstractItem item, int count) {
        if (!Main.game.getPlayerCell().getInventory().isInventoryFull() || Main.game.getPlayerCell().getInventory().hasItem(item)) {
            from.dropItem(item, count, from.isPlayer());
        }
        InventoryDialogue.resetPostAction();
    }

    private static void pickUpItems(GameCharacter to, AbstractItem item, int count) {
        if (!to.isInventoryFull() || to.hasItem(item) || item.getRarity() == Rarity.QUEST) {
            to.addItem(item, count, true, to.isPlayer());
        }
        InventoryDialogue.resetPostAction();
    }

    private static void sellItems(GameCharacter from, GameCharacter to, AbstractItem item, int count, int itemPrice) {
        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.removeTraderDescription, false);
        if (!to.isPlayer() || !to.isInventoryFull() || to.hasItem(item) || item.getRarity() == Rarity.QUEST) {
            from.incrementMoney(itemPrice * count);
            to.incrementMoney(-itemPrice * count);
            if (buyback && to.isPlayer()) {
                Main.game.getPlayer().addItem(item, count, false, true);
                ((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).incrementCount(-count);
                if (((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).getCount() <= 0) {
                    Main.game.getPlayer().getBuybackStack().remove(buyBackIndex);
                }
            } else {
                if (from.isPlayer()) {
                    Main.game.getPlayer().getBuybackStack().push(new ShopTransaction(item, itemPrice, count));
                } else {
                    to.addItem(item, count, false, true);
                }
                from.removeItem(item, count);
            }
            if (from.isPlayer()) {
                Main.game.addEvent(new EventLogEntry("\u5df2\u51fa\u552e", count + "x <span style='color:" + item.getRarity().getColour().toWebHexString() + ";'>" + (count == 1 ? item.getName() : item.getNamePlural()) + "</span>\u4ef7\u683c\uff1a" + UtilText.formatAsMoney(itemPrice * count)), false);
            }
            if (to.isPlayer()) {
                Main.game.addEvent(new EventLogEntry("\u5df2\u4e70\u5165", count + "x <span style='color:" + item.getRarity().getColour().toWebHexString() + ";'>" + (count == 1 ? item.getName() : item.getNamePlural()) + "</span>\u4ef7\u683c\uff1a" + UtilText.formatAsMoney(itemPrice * count)), false);
            }
            if (!from.isPlayer()) {
                ((NPC)from).applyItemTransactionEffects(item, count, itemPrice, true);
            } else {
                ((NPC)to).applyItemTransactionEffects(item, count, itemPrice, false);
            }
        }
        InventoryDialogue.resetPostAction();
    }

    private static void transferWeapons(GameCharacter from, GameCharacter to, AbstractWeapon weapon, int count) {
        if (!to.isInventoryFull() || to.hasWeapon(weapon) || weapon.getRarity() == Rarity.QUEST) {
            from.removeWeapon(weapon, count);
            to.addWeapon(weapon, count, false, to.isPlayer());
        }
        InventoryDialogue.resetPostAction();
    }

    private static void dropWeapons(GameCharacter from, AbstractWeapon weapon, int count) {
        if (!Main.game.getPlayerCell().getInventory().isInventoryFull() || Main.game.getPlayerCell().getInventory().hasWeapon(weapon)) {
            from.dropWeapon(weapon, count, from.isPlayer());
        }
        InventoryDialogue.resetPostAction();
    }

    private static void pickUpWeapons(GameCharacter to, AbstractWeapon weapon, int count) {
        if (!to.isInventoryFull() || to.hasWeapon(weapon) || weapon.getRarity() == Rarity.QUEST) {
            to.addWeapon(weapon, count, true, to.isPlayer());
        }
        InventoryDialogue.resetPostAction();
    }

    private static void sellWeapons(GameCharacter from, GameCharacter to, AbstractWeapon weapon, int count, int itemPrice) {
        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.removeTraderDescription, false);
        if (!to.isPlayer() || !to.isInventoryFull() || to.hasWeapon(weapon) || weapon.getRarity() == Rarity.QUEST) {
            from.incrementMoney(itemPrice * count);
            to.incrementMoney(-itemPrice * count);
            if (buyback && to.isPlayer()) {
                Main.game.getPlayer().addWeapon(Main.game.getItemGen().generateWeapon(weapon), count, false, true);
                ((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).incrementCount(-count);
                if (((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).getCount() <= 0) {
                    Main.game.getPlayer().getBuybackStack().remove(buyBackIndex);
                }
            } else {
                if (from.isPlayer()) {
                    Main.game.getPlayer().getBuybackStack().push(new ShopTransaction(weapon, itemPrice, count));
                } else {
                    to.addWeapon(Main.game.getItemGen().generateWeapon(weapon), count, false, true);
                }
                from.removeWeapon(weapon, count);
            }
            if (from.isPlayer()) {
                Main.game.addEvent(new EventLogEntry("\u5df2\u51fa\u552e", count + "x <span style='color:" + weapon.getRarity().getColour().toWebHexString() + ";'>" + (count == 1 ? weapon.getName() : weapon.getNamePlural()) + "</span>\u4ef7\u683c\uff1a" + UtilText.formatAsMoney(itemPrice * count)), false);
            }
            if (to.isPlayer()) {
                Main.game.addEvent(new EventLogEntry("\u5df2\u4e70\u5165", count + "x <span style='color:" + weapon.getRarity().getColour().toWebHexString() + ";'>" + (count == 1 ? weapon.getName() : weapon.getNamePlural()) + "</span>\u4ef7\u683c\uff1a" + UtilText.formatAsMoney(itemPrice * count)), false);
            }
            if (!from.isPlayer()) {
                ((NPC)from).applyItemTransactionEffects(weapon, count, itemPrice, true);
            } else {
                ((NPC)to).applyItemTransactionEffects(weapon, count, itemPrice, false);
            }
        }
        InventoryDialogue.resetPostAction();
    }

    private static void transferClothing(GameCharacter from, GameCharacter to, AbstractClothing clothing, int count) {
        if (!to.isInventoryFull() || to.hasClothing(clothing) || clothing.getRarity() == Rarity.QUEST) {
            from.removeClothing(clothing, count);
            to.addClothing(clothing, count, false, to.isPlayer());
            owner = to;
        }
        InventoryDialogue.resetPostAction();
    }

    private static void dropClothing(GameCharacter from, AbstractClothing clothing, int count) {
        if (!Main.game.getPlayerCell().getInventory().isInventoryFull() || Main.game.getPlayerCell().getInventory().hasClothing(clothing)) {
            from.dropClothing(clothing, count, from.isPlayer());
            if (from.getClothingCount(clothing) == 0) {
                owner = null;
            }
        }
        InventoryDialogue.resetPostAction();
    }

    private static void pickUpClothing(GameCharacter to, AbstractClothing clothing, int count) {
        if (!to.isInventoryFull() || to.hasClothing(clothing) || clothing.getRarity() == Rarity.QUEST) {
            to.addClothing(clothing, count, true, to.isPlayer());
            owner = to;
        }
        InventoryDialogue.resetPostAction();
    }

    private static void sellClothing(GameCharacter from, GameCharacter to, AbstractClothing clothing, int count, int itemPrice) {
        Main.game.getDialogueFlags().setFlag(DialogueFlagValue.removeTraderDescription, false);
        if (!to.isPlayer() || !to.isInventoryFull() || to.hasClothing(clothing) || clothing.getRarity() == Rarity.QUEST) {
            from.incrementMoney(itemPrice * count);
            to.incrementMoney(-itemPrice * count);
            if (buyback && to.isPlayer()) {
                Main.game.getPlayer().addClothing(new AbstractClothing(clothing){}, count, false, true);
                ((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).incrementCount(-count);
                if (((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).getCount() <= 0) {
                    Main.game.getPlayer().getBuybackStack().remove(buyBackIndex);
                }
            } else {
                if (from.isPlayer()) {
                    Main.game.getPlayer().getBuybackStack().push(new ShopTransaction(clothing, itemPrice, count));
                } else {
                    to.addClothing(new AbstractClothing(clothing){}, count, false, true);
                }
                from.removeClothing(clothing, count);
            }
            if (from.isPlayer()) {
                Main.game.addEvent(new EventLogEntry("\u5df2\u51fa\u552e", count + "x <span style='color:" + clothing.getRarity().getColour().toWebHexString() + ";'>" + (count == 1 ? clothing.getName() : clothing.getNamePlural()) + "</span>\u4ef7\u683c\uff1a" + UtilText.formatAsMoney(itemPrice * count)), false);
            }
            if (to.isPlayer()) {
                Main.game.addEvent(new EventLogEntry("\u5df2\u4e70\u5165", count + "x <span style='color:" + clothing.getRarity().getColour().toWebHexString() + ";'>" + (count == 1 ? clothing.getName() : clothing.getNamePlural()) + "</span>\u4ef7\u683c\uff1a" + UtilText.formatAsMoney(itemPrice * count)), false);
            }
            if (!from.isPlayer()) {
                ((NPC)from).applyItemTransactionEffects(clothing, count, itemPrice, true);
            } else {
                ((NPC)to).applyItemTransactionEffects(clothing, count, itemPrice, false);
            }
        }
        InventoryDialogue.resetPostAction();
    }

    private static String unequipClothingToFloor(GameCharacter unequipper, AbstractClothing clothing) {
        String unequipDescription = "";
        unequipDescription = clothing.isDiscardedOnUnequip(clothing.getSlotEquippedTo()) ? owner.unequipClothingIntoVoid(clothing, true, unequipper) : owner.unequipClothingOntoFloor(clothing, true, unequipper);
        owner = null;
        InventoryDialogue.resetPostAction();
        return unequipDescription;
    }

    private static String unequipClothingToUnequippersInventory(GameCharacter unequipper, AbstractClothing clothing) {
        String unequipDescription = "";
        unequipDescription = clothing.isDiscardedOnUnequip(clothing.getSlotEquippedTo()) ? owner.unequipClothingIntoVoid(clothing, true, unequipper) : owner.unequipClothingIntoUnequippersInventory(clothing, true, unequipper);
        InventoryDialogue.resetPostAction();
        return unequipDescription;
    }

    private static String unequipClothingToInventory(GameCharacter unequipper, AbstractClothing clothing) {
        String unequipDescription = "";
        unequipDescription = clothing.isDiscardedOnUnequip(clothing.getSlotEquippedTo()) ? owner.unequipClothingIntoVoid(clothing, true, unequipper) : owner.unequipClothingIntoInventory(clothing, true, unequipper);
        InventoryDialogue.resetPostAction();
        return unequipDescription;
    }

    private static String equipClothingFromInventory(GameCharacter to, InventorySlot slot, GameCharacter equipper, AbstractClothing clothing) {
        String equipDescription = to.equipClothingFromInventory(clothing, slot, true, equipper, owner);
        owner = to;
        InventoryDialogue.resetPostAction();
        return equipDescription;
    }

    private static String equipClothingFromGround(GameCharacter to, InventorySlot slot, GameCharacter equipper, AbstractClothing clothing) {
        owner = to;
        InventoryDialogue.resetPostAction();
        return to.equipClothingFromGround(clothing, slot, true, equipper);
    }

    private static Response getCondomSabotageResponse(final AbstractClothing clothing) {
        if (clothing.getCondomEffect().getPotency().isNegative()) {
            if (Main.game.getPlayer().getEssenceCount() >= 1) {
                return new Response("\u4fee\u590d([style.italicsArcane(1\u7cbe\u534e)])", "\u82b1\u8d391\u5965\u672f\u7cbe\u534e\u6765\u4fee\u590d\u907f\u5b55\u5957\u3002", CLOTHING_INVENTORY){

                    @Override
                    public void effects() {
                        Main.game.getPlayer().incrementEssenceCount(-1, false);
                        Main.game.getTextEndStringBuilder().append("<p>\u4f60\u5f15\u5bfc\u5965\u672f\u7cbe\u534e\u7684\u80fd\u91cf\u8fdb\u5165\u4e86\u907f\u5b55\u5957\uff0c\u4e00\u9635\u6de1\u7d2b\u8272\u7684\u5149\u8292\u540e\uff0c\u5b83\u88ab\u4fee\u590d\u4e86\uff01</p><p style='text-align:center;'>\u4fee\u590d\u907f\u5b55\u5957\u6d88\u8017\u4e86\u4f60[style.boldBad(1)][style.boldArcane(\u5965\u672f\u7cbe\u534e)]\uff01</p>");
                        AbstractClothing c = (AbstractClothing)EnchantmentDialogue.craftAndApplyFullInventoryEffects(clothing, clothing.getClothingType().getEffects());
                        Main.game.getPlayer().removeClothing(c);
                        c.setName(c.getClothingType().getName());
                        InventoryDialogue.setClothing(c);
                        Main.game.getPlayer().addClothing(c, false);
                        RenderingEngine.setPage(Main.game.getPlayer(), c);
                    }
                };
            }
            return new Response("\u4fee\u590d(<i>1\u7cbe\u534e</i>)", "\u4f60\u9700\u8981\u81f3\u5c111\u5965\u672f\u7cbe\u534e\u6765\u4fee\u590d\u907f\u5b55\u5957\uff01", null);
        }
        return new Response("\u7834\u574f", "\u901a\u8fc7\u5728\u907f\u5b55\u5957\u9876\u7aef\u5236\u9020\u4e00\u70b9\u7834\u635f\uff0c\u4f60\u80fd\u591f\u4fdd\u8bc1\u9ad8\u6f6e\u65f6\u907f\u5b55\u5957\u88c2\u5f00\uff01", CLOTHING_INVENTORY){

            @Override
            public void effects() {
                EnchantmentDialogue.setOutputName(clothing.getClothingType().getName());
                AbstractClothing c = (AbstractClothing)EnchantmentDialogue.craftAndApplyFullInventoryEffects(clothing, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_CONDOM, TFModifier.ARCANE_BOOST, TFPotency.MAJOR_DRAIN, 0)), false);
                Main.game.getPlayer().removeClothing(c);
                InventoryDialogue.setClothing(c);
                Main.game.getPlayer().addClothing(c, false);
                RenderingEngine.setPage(Main.game.getPlayer(), c);
                Main.game.getTextEndStringBuilder().append("<p>\u901a\u8fc7\u5728\u907f\u5b55\u5957\u9876\u7aef\u5236\u9020\u4e00\u4e2a\u51e0\u4e4e\u4e0d\u53ef\u89c1\u7684\u5fae\u7b11\u7834\u635f\uff0c\u4f60\u786e\u4fe1\u5145\u6ee1\u7cbe\u6db2\u65f6\u907f\u5b55\u5957\u4f1a\u88c2\u5f00\u2026\u2026</p><p style='text-align:center;'>[style.italicsBad(\u8fd9\u4e2a\u907f\u5b55\u5957\u4e00\u5b9a\u4f1a\u5728\u9ad8\u6f6e\u65f6\u7834\u88c2)]\uff01</p>");
            }
        };
    }

    private static void resetPostAction() {
        Main.game.setResponseTab(0);
        InventoryDialogue.resetItems();
    }

    public static void resetItems() {
        item = null;
        clothing = null;
        weapon = null;
    }

    public static AbstractItem getItem() {
        return item;
    }

    public static void setItem(AbstractItem item) {
        InventoryDialogue.resetItems();
        InventoryDialogue.item = item;
        if (Main.getProperties().addItemDiscovered(item.getItemType())) {
            Main.game.addEvent(new EventLogEntryEncyclopediaUnlock(item.getItemType().getName(false), item.getRarity().getColour()), true);
        }
    }

    public static AbstractWeapon getWeapon() {
        return weapon;
    }

    public static void setWeapon(InventorySlot slot, AbstractWeapon weapon) {
        InventoryDialogue.resetItems();
        weaponSlot = slot;
        InventoryDialogue.weapon = weapon;
        if (Main.getProperties().addWeaponDiscovered(weapon.getWeaponType())) {
            Main.game.addEvent(new EventLogEntryEncyclopediaUnlock(weapon.getWeaponType().getName(), weapon.getWeaponType().getRarity().getColour()), true);
        }
    }

    public static AbstractClothing getClothing() {
        return clothing;
    }

    public static void setClothing(AbstractClothing clothing) {
        InventoryDialogue.resetItems();
        InventoryDialogue.clothing = clothing;
        if (Main.getProperties().addClothingDiscovered(clothing.getClothingType())) {
            Main.game.addEvent(new EventLogEntryEncyclopediaUnlock(clothing.getClothingType().getName(), clothing.getClothingType().getRarity().getColour()), true);
        }
    }

    public static boolean isBuyback() {
        return buyback;
    }

    public static void setBuyback(boolean buyback) {
        InventoryDialogue.buyback = buyback;
    }

    public static int getBuyBackPrice() {
        return buyBackPrice;
    }

    public static void setBuyBackPrice(int buyBackPrice) {
        InventoryDialogue.buyBackPrice = buyBackPrice;
    }

    public static int getBuyBackIndex() {
        return buyBackIndex;
    }

    public static void setBuyBackIndex(int buyBackIndex) {
        InventoryDialogue.buyBackIndex = buyBackIndex;
    }

    public static GameCharacter getOwner() {
        return owner;
    }

    public static void setOwner(GameCharacter owner) {
        InventoryDialogue.owner = owner;
    }

    public static NPC getInventoryNPC() {
        return inventoryNPC;
    }

    public static void setInventoryNPC(NPC inventoryNPC) {
        InventoryDialogue.inventoryNPC = inventoryNPC;
    }

    public static InventoryInteraction getNPCInventoryInteraction() {
        return interactionType;
    }

    public static void setNPCInventoryInteraction(InventoryInteraction npcInventoryInteraction) {
        interactionType = npcInventoryInteraction;
    }

    static {
        inventorySB = new StringBuilder();
        INVENTORY_MENU = new DialogueNode("\u7269\u54c1\u680f", "\u8fd4\u56de\u7269\u54c1\u680f\u83dc\u5355\u3002", true){

            @Override
            public String getLabel() {
                if (!Main.game.isInNewWorld()) {
                    return "\u665a\u4f1a\u7740\u88c5";
                }
                if (Main.game.getDialogueFlags().values.contains(DialogueFlagValue.quickTrade) && !Main.game.isInSex() && !Main.game.isInCombat()) {
                    return "\u7269\u54c1\u680f(\u5feb\u901f\u7ba1\u7406\u5f53\u524d<b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u5f00\u542f</b>)";
                }
                return "\u7269\u54c1\u680f";
            }

            @Override
            public String getHeaderContent() {
                return InventoryDialogue.inventoryView();
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                if (inventoryNPC != null && interactionType == InventoryInteraction.TRADING) {
                    if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.removeTraderDescription)) {
                        UtilText.nodeContentSB.append(inventoryNPC.getTraderDescription());
                    }
                } else if (interactionType == InventoryInteraction.CHARACTER_CREATION) {
                    return CharacterCreation.getCheckingClothingDescription();
                }
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public String getResponseTabTitle(int index) {
                return InventoryDialogue.getGeneralResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 0) {
                    return InventoryDialogue.getCloseInventoryResponse();
                }
                if (Main.game.isBadEnd()) {
                    if (index == 1) {
                        return new Response("\u4e0d\u53ef\u7528", "\u5728\u574f\u7ed3\u5c40\u65f6\u65e0\u6cd5\u64cd\u4f5c\u7269\u54c1\u680f\u2026\u2026", null);
                    }
                    return null;
                }
                if (responseTab == 1) {
                    if (item != null) {
                        return ITEM_INVENTORY.getResponse(responseTab, index);
                    }
                    if (clothing != null) {
                        if (Main.game.getPlayer().getClothingCurrentlyEquipped().contains(clothing) || inventoryNPC != null && inventoryNPC.getClothingCurrentlyEquipped().contains(clothing)) {
                            return CLOTHING_EQUIPPED.getResponse(responseTab, index);
                        }
                        return CLOTHING_INVENTORY.getResponse(responseTab, index);
                    }
                    if (weapon != null) {
                        if (Main.game.getPlayer().hasWeaponEquipped(weapon) || inventoryNPC != null && inventoryNPC.hasWeaponEquipped(weapon)) {
                            return WEAPON_EQUIPPED.getResponse(responseTab, index);
                        }
                        return WEAPON_INVENTORY.getResponse(responseTab, index);
                    }
                    return null;
                }
                final StringBuilder responseSB = new StringBuilder();
                switch (interactionType) {
                    case COMBAT: {
                        if (index == 1) {
                            return new Response("\u62ff\u53d6\u6240\u6709", "\u6218\u6597\u4e2d\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01", null);
                        }
                        if (index == 2) {
                            return new Response("\u79fb\u5f00\u6240\u6709", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01", null);
                        }
                        if (index == 3) {
                            return new Response("\u6574\u7406\u6240\u6709\u8863\u7269", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01", null);
                        }
                        if (index == 4) {
                            return new Response("\u8131\u4e0b\u6240\u6709\u8863\u7269", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01", null);
                        }
                        if (index == 5) {
                            return new Response("\u88c5\u5907\u6240\u6709\u8863\u7269", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01", null);
                        }
                        if (index == 6) {
                            if (Main.game.getPlayer().getLocationPlace().isItemsDisappear()) {
                                return new Response("\u5b58\u50a8\u6240\u6709", "\u6218\u6597\u4e2d\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01", null);
                            }
                            return new Response("\u4e22\u5f03\u6240\u6709", "\u6218\u6597\u4e2d\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01", null);
                        }
                        if (index == 11) {
                            if (Main.game.getPlayer().getUnlockKeyMap().isEmpty()) {
                                return new Response("\u89e3\u9501\u7528\u5177", "\u4f60\u5f53\u524d\u5e76\u6ca1\u6709\u80fd\u89e3\u9501\u7279\u5b9a\u8863\u7269\u7684\u89e3\u9501\u7528\u5177\u3002", null);
                            }
                            if (Main.game.getCurrentDialogueNode() == INVENTORY_MENU_KEYS) {
                                return new Response("\u89e3\u9501\u7528\u5177", "\u4f60\u6b63\u5728\u67e5\u770b\u80fd\u591f\u7528\u6765\u89e3\u9501\u7279\u5b9a\u8863\u7269\u7684\u89e3\u9501\u7528\u5177\u3002", null);
                            }
                            return new Response("\u89e3\u9501\u7528\u5177", "\u67e5\u770b\u6240\u6709\u80fd\u591f\u7528\u6765\u89e3\u9501\u7279\u5b9a\u8863\u7269\u7684\u89e3\u9501\u7528\u5177\u3002", INVENTORY_MENU_KEYS);
                        }
                        return null;
                    }
                    case FULL_MANAGEMENT: {
                        if (index == 1) {
                            if (inventoryNPC == null) {
                                if (Main.game.getPlayerCell().getInventory().getInventorySlotsTaken() == 0 && !Main.game.getPlayerCell().getInventory().isAnyQuestItemPresent() || Main.game.isInCombat() || Main.game.isInSex()) {
                                    return new Response("\u62ff\u53d6\u6240\u6709", "\u62ff\u8d77\u6240\u6709\u5728\u5730\u4e0a\u7684\u7269\u54c1\u3002", null);
                                }
                                return new Response("\u62ff\u53d6\u6240\u6709", "\u62ff\u8d77\u6240\u6709\u5728\u5730\u4e0a\u7684\u7269\u54c1\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        for (Map.Entry<AbstractItem, Integer> entry : new HashMap<AbstractItem, Integer>(Main.game.getPlayerCell().getInventory().getAllItemsInInventory()).entrySet()) {
                                            Main.game.getPlayer().addItem(entry.getKey(), entry.getValue(), true, true);
                                        }
                                        for (Map.Entry<AbstractCoreItem, Integer> entry : new HashMap<AbstractWeapon, Integer>(Main.game.getPlayerCell().getInventory().getAllWeaponsInInventory()).entrySet()) {
                                            Main.game.getPlayer().addWeapon((AbstractWeapon)entry.getKey(), entry.getValue(), true, true);
                                        }
                                        for (Map.Entry<AbstractCoreItem, Integer> entry : new HashMap<AbstractClothing, Integer>(Main.game.getPlayerCell().getInventory().getAllClothingInInventory()).entrySet()) {
                                            Main.game.getPlayer().addClothing((AbstractClothing)entry.getKey(), entry.getValue(), true, true);
                                        }
                                    }
                                };
                            }
                            if (inventoryNPC.getInventorySlotsTaken() == 0 || Main.game.isInCombat() || Main.game.isInSex()) {
                                return new Response("\u62ff\u53d6\u6240\u6709", UtilText.parse((GameCharacter)inventoryNPC, "\u4ece[npc.namePos]\u7684\u7269\u54c1\u680f\u62ff\u53d6\u6240\u6709\u7269\u54c1\u3002", new ParserTag[0]), null);
                            }
                            return new Response("\u62ff\u53d6\u6240\u6709", UtilText.parse((GameCharacter)inventoryNPC, "\u4ece[npc.namePos]\u7684\u7269\u54c1\u680f\u62ff\u53d6\u6240\u6709\u7269\u54c1\u3002", new ParserTag[0]), INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    for (Map.Entry<AbstractItem, Integer> entry : new HashMap<AbstractItem, Integer>(inventoryNPC.getAllItemsInInventory()).entrySet()) {
                                        if (Main.game.getPlayer().isInventoryFull() && !Main.game.getPlayer().hasItem(entry.getKey()) && entry.getKey().getRarity() != Rarity.QUEST) continue;
                                        inventoryNPC.removeItem(entry.getKey(), entry.getValue());
                                        Main.game.getPlayer().addItem(entry.getKey(), entry.getValue(), true, true);
                                    }
                                    for (Map.Entry<AbstractCoreItem, Integer> entry : new HashMap<AbstractClothing, Integer>(inventoryNPC.getAllClothingInInventory()).entrySet()) {
                                        if (Main.game.getPlayer().isInventoryFull() && !Main.game.getPlayer().hasClothing((AbstractClothing)entry.getKey()) && ((AbstractClothing)entry.getKey()).getRarity() != Rarity.QUEST) continue;
                                        inventoryNPC.removeClothing((AbstractClothing)entry.getKey(), entry.getValue());
                                        Main.game.getPlayer().addClothing((AbstractClothing)entry.getKey(), entry.getValue(), true, true);
                                    }
                                    for (Map.Entry<AbstractCoreItem, Integer> entry : new HashMap<AbstractWeapon, Integer>(inventoryNPC.getAllWeaponsInInventory()).entrySet()) {
                                        if (Main.game.getPlayer().isInventoryFull() && !Main.game.getPlayer().hasWeapon((AbstractWeapon)entry.getKey()) && ((AbstractWeapon)entry.getKey()).getRarity() != Rarity.QUEST) continue;
                                        inventoryNPC.removeWeapon((AbstractWeapon)entry.getKey(), entry.getValue());
                                        Main.game.getPlayer().addWeapon((AbstractWeapon)entry.getKey(), entry.getValue(), true, true);
                                    }
                                }
                            };
                        }
                        if (index == 2) {
                            if (Main.game.getPlayer().getClothingCurrentlyEquipped().isEmpty()) {
                                return new Response("\u79fb\u5f00\u6240\u6709", "\u4f60\u6ca1\u7a7f\u8863\u7269\uff0c\u6240\u4ee5\u65e0\u6cd5\u79fb\u5f00\u8863\u7269\uff01", null);
                            }
                            return new Response("\u79fb\u5f00\u6240\u6709", "\u5c3d\u53ef\u80fd\u5730\u79fb\u5f00\u6240\u6709\u8863\u7269\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    for (AbstractClothing c : Main.game.getPlayer().getClothingCurrentlyEquipped()) {
                                        for (BlockedParts bp : c.getBlockedPartsMap(Main.game.getPlayer(), c.getSlotEquippedTo())) {
                                            if (bp.displacementType == DisplacementType.REMOVE_OR_EQUIP) continue;
                                            Main.game.getPlayer().isAbleToBeDisplaced(c, bp.displacementType, true, true, Main.game.getPlayer());
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().getDisplaceDescription() + "</p>");
                                        }
                                    }
                                }
                            };
                        }
                        if (index == 3) {
                            if (Main.game.getPlayer().getClothingCurrentlyEquipped().isEmpty()) {
                                return new Response("\u6574\u7406\u6240\u6709\u8863\u7269", "\u4f60\u6ca1\u7a7f\u8863\u7269\uff0c\u6240\u4ee5\u6ca1\u6709\u8863\u7269\u53ef\u4ee5\u6574\u7406\uff01", null);
                            }
                            return new Response("\u6574\u7406\u6240\u6709\u8863\u7269", "\u5c3d\u91cf\u6574\u7406\u597d\u4f60\u7684\u8863\u7269\uff01", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    ArrayList<AbstractClothing> zlayerClothing = new ArrayList<AbstractClothing>(Main.game.getPlayer().getClothingCurrentlyEquipped());
                                    zlayerClothing.sort(new ClothingZLayerComparator().reversed());
                                    for (AbstractClothing c : zlayerClothing) {
                                        for (BlockedParts bp : c.getBlockedPartsMap(Main.game.getPlayer(), c.getSlotEquippedTo())) {
                                            if (bp.displacementType == DisplacementType.REMOVE_OR_EQUIP) continue;
                                            Main.game.getPlayer().isAbleToBeReplaced(c, bp.displacementType, true, true, Main.game.getPlayer());
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().getReplaceDescription() + "</p>");
                                        }
                                    }
                                }
                            };
                        }
                        if (index == 4) {
                            if (Main.game.getPlayer().getClothingCurrentlyEquipped().isEmpty()) {
                                return new Response("\u8131\u4e0b\u6240\u6709\u8863\u7269", "\u4f60\u6ca1\u6709\u7a7f\u8863\u7269\uff0c\u6240\u4ee5\u65e0\u6cd5\u8131\u4e0b\u8863\u7269\uff01", null);
                            }
                            return new Response("\u8131\u4e0b\u6240\u6709\u8863\u7269", "\u5c3d\u53ef\u80fd\u5730\u8131\u4e0b\u8863\u7269\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    Main.game.getTextEndStringBuilder().append(InventoryDialogue.unequipAll(Main.game.getPlayer()));
                                }
                            };
                        }
                        if (index == 5) {
                            if (Main.game.getPlayer().getAllClothingInInventory().isEmpty()) {
                                return new Response("\u88c5\u5907\u6240\u6709\u8863\u7269", "\u4f60\u6ca1\u6709\u8863\u7269\uff0c\u6240\u4ee5\u65e0\u6cd5\u88c5\u5907\uff01", null);
                            }
                            return new Response("\u88c5\u5907\u6240\u6709\u8863\u7269", "\u5c3d\u53ef\u80fd\u5730\u88c5\u5907\u7269\u54c1\u680f\u4e2d\u7684\u8863\u7269\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    InventoryDialogue.equipAll(Main.game.getPlayer());
                                }
                            };
                        }
                        if (index == 6) {
                            if (Main.game.getPlayer().getInventorySlotsTaken() == 0) {
                                return new Response(!Main.game.getPlayer().getLocationPlace().isItemsDisappear() ? "\u5b58\u50a8\u6240\u6709" : "\u4e22\u5f03\u6240\u6709", !Main.game.getPlayer().getLocationPlace().isItemsDisappear() ? "\u4f60\u7684\u7269\u54c1\u680f\u91cc\u6ca1\u6709\u4efb\u4f55\u80fd\u5b58\u5165\u7684\u4e1c\u897f\u2026\u2026" : "\u4f60\u7684\u7269\u54c1\u680f\u91cc\u6ca1\u6709\u4efb\u4f55\u80fd\u4e22\u5f03\u7684\u4e1c\u897f\u2026\u2026", null);
                            }
                            return new Response(!Main.game.getPlayer().getLocationPlace().isItemsDisappear() ? "\u5b58\u50a8\u6240\u6709" : "\u4e22\u5f03\u6240\u6709", !Main.game.getPlayer().getLocationPlace().isItemsDisappear() ? "\u5c06\u7269\u54c1\u680f\u4e2d\u7684\u6240\u6709\u7269\u54c1\u5b58\u50a8\u4e8e\u8be5\u5730\u70b9\u3002" : "\u5c06\u7269\u54c1\u680f\u4e2d\u7684\u6240\u6709\u7269\u54c1\u4e22\u5728\u5730\u4e0a\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    for (Map.Entry<AbstractItem, Integer> entry : new HashSet<Map.Entry<AbstractItem, Integer>>(Main.game.getPlayer().getAllItemsInInventory().entrySet())) {
                                        if (!entry.getKey().getItemType().isAbleToBeDropped()) continue;
                                        InventoryDialogue.dropItems(Main.game.getPlayer(), entry.getKey(), entry.getValue());
                                    }
                                    for (Map.Entry<AbstractCoreItem, Integer> entry : new HashSet<Map.Entry<AbstractWeapon, Integer>>(Main.game.getPlayer().getAllWeaponsInInventory().entrySet())) {
                                        if (!((AbstractWeapon)entry.getKey()).getWeaponType().isAbleToBeDropped()) continue;
                                        InventoryDialogue.dropWeapons(Main.game.getPlayer(), (AbstractWeapon)entry.getKey(), entry.getValue());
                                    }
                                    for (Map.Entry<AbstractCoreItem, Integer> entry : new HashSet<Map.Entry<AbstractClothing, Integer>>(Main.game.getPlayer().getAllClothingInInventory().entrySet())) {
                                        if (!((AbstractClothing)entry.getKey()).getClothingType().isAbleToBeDropped()) continue;
                                        InventoryDialogue.dropClothing(Main.game.getPlayer(), (AbstractClothing)entry.getKey(), entry.getValue());
                                    }
                                }
                            };
                        }
                        if (index == 7 && inventoryNPC != null) {
                            if (inventoryNPC.getClothingCurrentlyEquipped().isEmpty()) {
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u79fb\u5f00\u6240\u6709([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u6ca1\u6709\u7a7f\u8863\u7269\uff0c\u6240\u4ee5\u65e0\u6cd5\u79fb\u5f00\u8863\u7269\uff01", new ParserTag[0]), null);
                            }
                            return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u79fb\u5f00\u6240\u6709([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u5c3d\u53ef\u80fd\u5730\u89e3\u9664[npc.namePos]\u7684\u8863\u7269\u3002", new ParserTag[0]), INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    for (AbstractClothing c : inventoryNPC.getClothingCurrentlyEquipped()) {
                                        for (BlockedParts bp : c.getBlockedPartsMap(inventoryNPC, c.getSlotEquippedTo())) {
                                            if (bp.displacementType == DisplacementType.REMOVE_OR_EQUIP) continue;
                                            inventoryNPC.isAbleToBeDisplaced(c, bp.displacementType, true, true, Main.game.getPlayer());
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + inventoryNPC.getDisplaceDescription() + "</p>");
                                        }
                                    }
                                }
                            };
                        }
                        if (index == 8 && inventoryNPC != null) {
                            if (inventoryNPC.getClothingCurrentlyEquipped().isEmpty()) {
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u6574\u7406\u6240\u6709\u8863\u7269([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u6ca1\u7a7f\u8863\u7269\uff0c\u6240\u4ee5\u65e0\u6cd5\u6574\u7406\u8863\u7269\uff01", new ParserTag[0]), null);
                            }
                            return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u6574\u7406\u6240\u6709\u8863\u7269([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u5c3d\u53ef\u80fd\u5730\u6574\u7406[npc.namePos]\u7684\u8863\u7269\u3002", new ParserTag[0]), INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    ArrayList<AbstractClothing> zlayerClothing = new ArrayList<AbstractClothing>(inventoryNPC.getClothingCurrentlyEquipped());
                                    zlayerClothing.sort(new ClothingZLayerComparator().reversed());
                                    for (AbstractClothing c : zlayerClothing) {
                                        for (BlockedParts bp : c.getBlockedPartsMap(inventoryNPC, c.getSlotEquippedTo())) {
                                            if (bp.displacementType == DisplacementType.REMOVE_OR_EQUIP) continue;
                                            inventoryNPC.isAbleToBeReplaced(c, bp.displacementType, true, true, Main.game.getPlayer());
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + inventoryNPC.getReplaceDescription() + "</p>");
                                        }
                                    }
                                }
                            };
                        }
                        if (index == 9 && inventoryNPC != null) {
                            if (inventoryNPC.getClothingCurrentlyEquipped().isEmpty()) {
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u8131\u4e0b\u6240\u6709\u8863\u7269([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u6ca1\u7a7f\u8863\u7269\uff0c\u6240\u4ee5\u65e0\u6cd5\u89e3\u9664\u8863\u7269\uff01", new ParserTag[0]), null);
                            }
                            return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u8131\u4e0b\u6240\u6709\u8863\u7269([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u5c3d\u53ef\u80fd\u5730\u89e3\u9664[npc.namePos]\u7684\u8863\u7269\u3002", new ParserTag[0]), INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    Main.game.getTextEndStringBuilder().append(InventoryDialogue.unequipAll(inventoryNPC));
                                }
                            };
                        }
                        if (index == 10 && !Main.game.isInSex() && !Main.game.isInCombat()) {
                            return InventoryDialogue.getQuickTradeResponse();
                        }
                        if (index == 11) {
                            if (Main.game.getPlayer().getUnlockKeyMap().isEmpty()) {
                                return new Response("\u89e3\u9501\u7528\u5177", "\u4f60\u5f53\u524d\u5e76\u6ca1\u6709\u80fd\u89e3\u9501\u7279\u5b9a\u8863\u7269\u7684\u89e3\u9501\u7528\u5177\u3002", null);
                            }
                            if (Main.game.getCurrentDialogueNode() == INVENTORY_MENU_KEYS) {
                                return new Response("\u89e3\u9501\u7528\u5177", "\u4f60\u6b63\u5728\u67e5\u770b\u80fd\u591f\u7528\u6765\u89e3\u9501\u7279\u5b9a\u8863\u7269\u7684\u89e3\u9501\u7528\u5177\u3002", null);
                            }
                            return new Response("\u89e3\u9501\u7528\u5177", "\u67e5\u770b\u6240\u6709\u80fd\u591f\u7528\u6765\u89e3\u9501\u7279\u5b9a\u8863\u7269\u7684\u89e3\u9501\u7528\u5177\u3002", INVENTORY_MENU_KEYS);
                        }
                        return null;
                    }
                    case CHARACTER_CREATION: {
                        if (index == 1) {
                            if (Main.game.getPlayer().isCoverableAreaVisible(CoverableArea.NIPPLES) || Main.game.getPlayer().isCoverableAreaVisible(CoverableArea.ANUS) || Main.game.getPlayer().isCoverableAreaVisible(CoverableArea.PENIS) || Main.game.getPlayer().isCoverableAreaVisible(CoverableArea.VAGINA) || Main.game.getPlayer().getClothingInSlot(InventorySlot.FOOT) == null && Main.game.getPlayer().getLegType().equals(LegType.HUMAN)) {
                                return new Response("\u524d\u5f80\u821e\u53f0", "\u4f60\u9700\u8981\u5148\u7a7f\u597d\u80fd\u591f\u906e\u76d6\u8eab\u4f53\u7684\u8863\u7269\uff0c\u8fd8\u9700\u8981\u4e00\u53cc\u978b\u3002", null);
                            }
                            return new Response("\u524d\u5f80\u821e\u53f0", "\u4f60\u5df2\u7ecf\u51c6\u5907\u597d\u524d\u5f80\u821e\u53f0\u4e86\u3002", CharacterCreation.CHOOSE_BACKGROUND){

                                @Override
                                public int getSecondsPassed() {
                                    return 150;
                                }

                                @Override
                                public void effects() {
                                    CharacterCreation.moveNPCIntoPlayerTile();
                                }
                            };
                        }
                        if (index == 2) {
                            if (Main.game.getPlayer().getClothingCurrentlyEquipped().isEmpty()) {
                                return new Response("\u8131\u4e0b\u6240\u6709\u8863\u7269", "\u4f60\u73b0\u5728\u5df2\u7ecf\u5149\u7740\u4e86\uff0c\u6ca1\u6709\u8863\u7269\u53ef\u4ee5\u8131\u3002", null);
                            }
                            return new Response("\u8131\u4e0b\u6240\u6709\u8863\u7269", "\u5c3d\u53ef\u80fd\u5730\u8131\u4e0b\u8863\u7269\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    Main.game.getTextEndStringBuilder().append(InventoryDialogue.unequipAll(Main.game.getPlayer()));
                                }
                            };
                        }
                        return null;
                    }
                    case TRADING: {
                        if (index == 1) {
                            if (inventoryNPC != null || Main.game.getPlayerCell().getInventory().getInventorySlotsTaken() == 0 || Main.game.isInCombat() || Main.game.isInSex()) {
                                return new Response("\u62ff\u53d6\u6240\u6709", "\u62ff\u8d77\u6240\u6709\u5728\u5730\u4e0a\u7684\u7269\u54c1\u3002", null);
                            }
                            return new Response("\u62ff\u53d6\u6240\u6709", "\u62ff\u8d77\u6240\u6709\u5728\u5730\u4e0a\u7684\u7269\u54c1\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    for (Map.Entry<AbstractItem, Integer> entry : new HashMap<AbstractItem, Integer>(Main.game.getPlayerCell().getInventory().getAllItemsInInventory()).entrySet()) {
                                        Main.game.getPlayer().addItem(entry.getKey(), entry.getValue(), true, true);
                                    }
                                    for (Map.Entry<AbstractCoreItem, Integer> entry : new HashMap<AbstractWeapon, Integer>(Main.game.getPlayerCell().getInventory().getAllWeaponsInInventory()).entrySet()) {
                                        Main.game.getPlayer().addWeapon((AbstractWeapon)entry.getKey(), entry.getValue(), true, true);
                                    }
                                    for (Map.Entry<AbstractCoreItem, Integer> entry : new HashMap<AbstractClothing, Integer>(Main.game.getPlayerCell().getInventory().getAllClothingInInventory()).entrySet()) {
                                        Main.game.getPlayer().addClothing((AbstractClothing)entry.getKey(), entry.getValue(), true, true);
                                    }
                                }
                            };
                        }
                        if (index == 2) {
                            if (Main.game.getPlayer().getClothingCurrentlyEquipped().isEmpty()) {
                                return new Response("\u79fb\u5f00\u6240\u6709", "\u4f60\u6ca1\u7a7f\u8863\u7269\uff0c\u6240\u4ee5\u65e0\u6cd5\u79fb\u5f00\u8863\u7269\uff01", null);
                            }
                            return new Response("\u79fb\u5f00\u6240\u6709", "\u5c3d\u53ef\u80fd\u5730\u79fb\u5f00\u6240\u6709\u8863\u7269\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    for (AbstractClothing c : Main.game.getPlayer().getClothingCurrentlyEquipped()) {
                                        for (BlockedParts bp : c.getBlockedPartsMap(Main.game.getPlayer(), c.getSlotEquippedTo())) {
                                            if (bp.displacementType == DisplacementType.REMOVE_OR_EQUIP) continue;
                                            Main.game.getPlayer().isAbleToBeDisplaced(c, bp.displacementType, true, true, Main.game.getPlayer());
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().getDisplaceDescription() + "</p>");
                                        }
                                    }
                                }
                            };
                        }
                        if (index == 3) {
                            if (Main.game.getPlayer().getClothingCurrentlyEquipped().isEmpty()) {
                                return new Response("\u6574\u7406\u6240\u6709\u8863\u7269", "\u4f60\u6ca1\u6709\u7a7f\u8863\u7269\uff0c\u6240\u4ee5\u6ca1\u6709\u8863\u7269\u53ef\u4ee5\u6574\u7406\uff01", null);
                            }
                            return new Response("\u6574\u7406\u6240\u6709\u8863\u7269", "\u5c3d\u91cf\u6574\u7406\u597d\u4f60\u7684\u8863\u7269\uff01", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    ArrayList<AbstractClothing> zlayerClothing = new ArrayList<AbstractClothing>(Main.game.getPlayer().getClothingCurrentlyEquipped());
                                    zlayerClothing.sort(new ClothingZLayerComparator().reversed());
                                    for (AbstractClothing c : zlayerClothing) {
                                        for (BlockedParts bp : c.getBlockedPartsMap(Main.game.getPlayer(), c.getSlotEquippedTo())) {
                                            if (bp.displacementType == DisplacementType.REMOVE_OR_EQUIP) continue;
                                            Main.game.getPlayer().isAbleToBeReplaced(c, bp.displacementType, true, true, Main.game.getPlayer());
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().getReplaceDescription() + "</p>");
                                        }
                                    }
                                }
                            };
                        }
                        if (index == 4) {
                            if (Main.game.getPlayer().getClothingCurrentlyEquipped().isEmpty()) {
                                return new Response("\u8131\u4e0b\u6240\u6709\u8863\u7269", "\u4f60\u6ca1\u6709\u7a7f\u8863\u7269\uff0c\u6240\u4ee5\u65e0\u6cd5\u8131\u4e0b\u8863\u7269\uff01", null);
                            }
                            return new Response("\u8131\u4e0b\u6240\u6709\u8863\u7269", "\u5c3d\u53ef\u80fd\u5730\u8131\u4e0b\u8863\u7269\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    Main.game.getTextEndStringBuilder().append(InventoryDialogue.unequipAll(Main.game.getPlayer()));
                                }
                            };
                        }
                        if (index == 5) {
                            if (Main.game.getPlayer().getAllClothingInInventory().isEmpty()) {
                                return new Response("\u88c5\u5907\u6240\u6709\u8863\u7269", "\u4f60\u6ca1\u6709\u8863\u7269\uff0c\u6240\u4ee5\u65e0\u6cd5\u88c5\u5907\uff01", null);
                            }
                            return new Response("\u88c5\u5907\u6240\u6709\u8863\u7269", "\u5c3d\u53ef\u80fd\u5730\u88c5\u5907\u7269\u54c1\u680f\u4e2d\u7684\u8863\u7269\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    InventoryDialogue.equipAll(Main.game.getPlayer());
                                }
                            };
                        }
                        if (index == 6) {
                            if (Main.game.getPlayer().getLocationPlace().isItemsDisappear()) {
                                return new Response("\u5b58\u50a8\u6240\u6709", "\u4f60\u65e0\u6cd5\u5728\u4ea4\u6613\u65f6\u505a\u8fd9\u4e2a\u2026\u2026", null);
                            }
                            return new Response("\u4e22\u5f03\u6240\u6709", "\u4f60\u65e0\u6cd5\u5728\u4ea4\u6613\u65f6\u505a\u8fd9\u4e2a\u2026\u2026", null);
                        }
                        if (index == 9 && inventoryNPC != null) {
                            return InventoryDialogue.getBuybackResponse();
                        }
                        if (index == 10 && !Main.game.isInSex() && !Main.game.isInCombat()) {
                            return InventoryDialogue.getQuickTradeResponse();
                        }
                        if (index == 11) {
                            if (Main.game.getPlayer().getUnlockKeyMap().isEmpty()) {
                                return new Response("\u89e3\u9501\u7528\u5177", "\u4f60\u5f53\u524d\u5e76\u6ca1\u6709\u80fd\u89e3\u9501\u7279\u5b9a\u8863\u7269\u7684\u89e3\u9501\u7528\u5177\u3002", null);
                            }
                            if (Main.game.getCurrentDialogueNode() == INVENTORY_MENU_KEYS) {
                                return new Response("\u89e3\u9501\u7528\u5177", "\u4f60\u6b63\u5728\u67e5\u770b\u80fd\u591f\u7528\u6765\u89e3\u9501\u7279\u5b9a\u8863\u7269\u7684\u89e3\u9501\u7528\u5177\u3002", null);
                            }
                            return new Response("\u89e3\u9501\u7528\u5177", "\u67e5\u770b\u6240\u6709\u80fd\u591f\u7528\u6765\u89e3\u9501\u7279\u5b9a\u8863\u7269\u7684\u89e3\u9501\u7528\u5177\u3002", INVENTORY_MENU_KEYS);
                        }
                        return null;
                    }
                    case SEX: {
                        if (index == 1) {
                            return new Response("\u62ff\u53d6\u6240\u6709", "\u62ff\u8d77\u6240\u6709\u5728\u5730\u4e0a\u7684\u7269\u54c1\u3002", null);
                        }
                        if (index == 2) {
                            if (Main.game.getPlayer().getClothingCurrentlyEquipped().isEmpty()) {
                                return new Response("\u79fb\u5f00\u6240\u6709", "\u4f60\u6ca1\u7a7f\u8863\u7269\uff0c\u6240\u4ee5\u65e0\u6cd5\u79fb\u5f00\u8863\u7269\uff01", null);
                            }
                            return new Response("\u79fb\u5f00\u6240\u6709", "\u5c3d\u53ef\u80fd\u5730\u79fb\u5f00\u6240\u6709\u8863\u7269\u3002", Main.sex.SEX_DIALOGUE){

                                @Override
                                public void effects() {
                                    responseSB.setLength(0);
                                    for (AbstractClothing c : Main.game.getPlayer().getClothingCurrentlyEquipped()) {
                                        for (BlockedParts bp : c.getBlockedPartsMap(Main.game.getPlayer(), c.getSlotEquippedTo())) {
                                            if (bp.displacementType == DisplacementType.REMOVE_OR_EQUIP) continue;
                                            Main.game.getPlayer().isAbleToBeDisplaced(c, bp.displacementType, true, true, Main.game.getPlayer());
                                            responseSB.append("<p style='text-align:center;'>" + Main.game.getPlayer().getDisplaceDescription() + "</p>");
                                        }
                                    }
                                    Main.sex.setUnequipClothingText(null, responseSB.toString());
                                    Main.mainController.openInventory();
                                    Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                    Main.sex.setSexStarted(true);
                                }
                            };
                        }
                        if (index == 3) {
                            return new Response("\u6574\u7406\u6240\u6709\u8863\u7269", "\u4f60\u65e0\u6cd5\u5728\u6027\u4ea4\u573a\u666f\u4e2d\u6574\u7406\u8863\u7269\uff01", null);
                        }
                        if (index == 4) {
                            if (Main.game.getPlayer().getClothingCurrentlyEquipped().isEmpty()) {
                                return new Response("\u8131\u4e0b\u6240\u6709\u8863\u7269", "\u4f60\u6ca1\u7a7f\u8863\u7269\uff0c\u6240\u4ee5\u65e0\u6cd5\u8131\u4e0b\u8863\u7269\uff01", null);
                            }
                            return new Response("\u8131\u4e0b\u6240\u6709\u8863\u7269", "\u5c3d\u53ef\u80fd\u5730\u8131\u4e0b\u8863\u7269\u3002", Main.sex.SEX_DIALOGUE){

                                @Override
                                public void effects() {
                                    responseSB.setLength(0);
                                    responseSB.append(InventoryDialogue.unequipAll(Main.game.getPlayer()));
                                    Main.sex.setUnequipClothingText(null, responseSB.toString());
                                    Main.mainController.openInventory();
                                    Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                    Main.sex.setSexStarted(true);
                                }
                            };
                        }
                        if (index == 5) {
                            return new Response("\u88c5\u5907\u6240\u6709\u8863\u7269", "\u4f60\u65e0\u6cd5\u5728\u6027\u4ea4\u573a\u666f\u4e2d\u88c5\u5907\u8863\u7269\uff01", null);
                        }
                        if (index == 6) {
                            if (Main.game.getPlayer().getLocationPlace().isItemsDisappear()) {
                                return new Response("\u5b58\u50a8\u6240\u6709", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u8fd9\u4e48\u505a\u2026\u2026", null);
                            }
                            return new Response("\u4e22\u5f03\u6240\u6709", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u8fd9\u4e48\u505a\u2026\u2026", null);
                        }
                        if (index == 7 && inventoryNPC != null) {
                            if (Main.sex.getInitialSexManager().isHidden(Main.game.getPlayer())) {
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u79fb\u5f00\u6240\u6709([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u4f60\u65e0\u6cd5\u5728\u8eb2\u85cf\u65f6\u79fb\u5f00[npc.namePos]\u7684\u8863\u670d\uff01", new ParserTag[0]), null);
                            }
                            if (!Main.sex.isCanRemoveOthersClothing(Main.game.getPlayer(), null)) {
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u79fb\u5f00\u6240\u6709([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u8be5\u6027\u4ea4\u573a\u666f\u4e2d\u4f60\u65e0\u6cd5\u79fb\u5f00[npc.namePos]\u7684\u8863\u7269\uff01", new ParserTag[0]), null);
                            }
                            if (inventoryNPC.getClothingCurrentlyEquipped().isEmpty()) {
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u79fb\u5f00\u6240\u6709([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "[npc.namePos]\u6ca1\u7a7f\u8863\u7269\uff0c\u6240\u4ee5\u65e0\u6cd5\u79fb\u5f00\u8863\u7269\uff01", new ParserTag[0]), null);
                            }
                            return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u79fb\u5f00\u6240\u6709([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u5c3d\u53ef\u80fd\u5730\u79fb\u5f00[npc.namePos]\u7684\u8863\u7269\u3002", new ParserTag[0]), Main.sex.SEX_DIALOGUE){

                                @Override
                                public void effects() {
                                    responseSB.setLength(0);
                                    for (AbstractClothing c : inventoryNPC.getClothingCurrentlyEquipped()) {
                                        for (BlockedParts bp : c.getBlockedPartsMap(inventoryNPC, c.getSlotEquippedTo())) {
                                            if (bp.displacementType == DisplacementType.REMOVE_OR_EQUIP) continue;
                                            inventoryNPC.isAbleToBeDisplaced(c, bp.displacementType, true, true, Main.game.getPlayer());
                                            responseSB.append("<p style='text-align:center;'>" + inventoryNPC.getDisplaceDescription() + "</p>");
                                        }
                                    }
                                    Main.sex.setUnequipClothingText(null, responseSB.toString());
                                    Main.mainController.openInventory();
                                    Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                    Main.sex.setSexStarted(true);
                                }
                            };
                        }
                        if (index == 8 && inventoryNPC != null) {
                            return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u6574\u7406\u6240\u6709\u8863\u7269([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u4f60\u65e0\u6cd5\u5728\u6027\u4ea4\u573a\u666f\u4e2d\u6574\u7406[npc.namePos]\u7684\u8863\u7269\uff01", new ParserTag[0]), null);
                        }
                        if (index == 9 && inventoryNPC != null) {
                            if (Main.sex.getInitialSexManager().isHidden(Main.game.getPlayer())) {
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u8131\u4e0b\u6240\u6709\u8863\u7269([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u4f60\u65e0\u6cd5\u5728\u8eb2\u85cf\u65f6\u8131\u4e0b[npc.namePos]\u7684\u8863\u670d\uff01", new ParserTag[0]), null);
                            }
                            if (!Main.sex.isCanRemoveOthersClothing(Main.game.getPlayer(), null)) {
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u8131\u4e0b\u6240\u6709\u8863\u7269([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u8be5\u6027\u4ea4\u573a\u666f\u4e2d\u4f60\u65e0\u6cd5\u8131\u4e0b[npc.namePos]\u7684\u8863\u7269\uff01", new ParserTag[0]), null);
                            }
                            if (inventoryNPC.getClothingCurrentlyEquipped().isEmpty()) {
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u8131\u4e0b\u6240\u6709\u8863\u7269([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u6ca1\u7a7f\u8863\u7269\uff0c\u6240\u4ee5\u65e0\u6cd5\u8131\u4e0b\u8863\u7269\uff01", new ParserTag[0]), null);
                            }
                            return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u8131\u4e0b\u6240\u6709\u8863\u7269([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u5c3d\u53ef\u80fd\u5730\u8131\u4e0b[npc.namePos]\u7684\u8863\u7269\u3002", new ParserTag[0]), Main.sex.SEX_DIALOGUE){

                                @Override
                                public void effects() {
                                    responseSB.setLength(0);
                                    responseSB.append(InventoryDialogue.unequipAll(inventoryNPC));
                                    Main.sex.setUnequipClothingText(null, responseSB.toString());
                                    Main.mainController.openInventory();
                                    Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                    Main.sex.setSexStarted(true);
                                }
                            };
                        }
                        if (index == 11) {
                            if (Main.game.getPlayer().getUnlockKeyMap().isEmpty()) {
                                return new Response("\u89e3\u9501\u7528\u5177", "\u4f60\u5f53\u524d\u5e76\u6ca1\u6709\u80fd\u89e3\u9501\u7279\u5b9a\u8863\u7269\u7684\u89e3\u9501\u7528\u5177\u3002", null);
                            }
                            if (Main.game.getCurrentDialogueNode() == INVENTORY_MENU_KEYS) {
                                return new Response("\u89e3\u9501\u7528\u5177", "\u4f60\u6b63\u5728\u67e5\u770b\u80fd\u591f\u7528\u6765\u89e3\u9501\u7279\u5b9a\u8863\u7269\u7684\u89e3\u9501\u7528\u5177\u3002", null);
                            }
                            return new Response("\u89e3\u9501\u7528\u5177", "\u67e5\u770b\u6240\u6709\u80fd\u591f\u7528\u6765\u89e3\u9501\u7279\u5b9a\u8863\u7269\u7684\u89e3\u9501\u7528\u5177\u3002", INVENTORY_MENU_KEYS);
                        }
                        return null;
                    }
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.INVENTORY;
            }
        };
        INVENTORY_MENU_KEYS = new DialogueNode("\u7269\u54c1\u680f", "\u8fd4\u56de\u7269\u54c1\u680f\u83dc\u5355\u3002", true){

            @Override
            public String getLabel() {
                if (!Main.game.isInNewWorld()) {
                    return "\u665a\u4f1a\u7740\u88c5";
                }
                if (Main.game.getDialogueFlags().values.contains(DialogueFlagValue.quickTrade) && !Main.game.isInSex() && !Main.game.isInCombat()) {
                    return "\u7269\u54c1\u680f(\u5feb\u901f\u7ba1\u7406\u5f53\u524d<b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u5f00\u542f</b>)";
                }
                return "\u7269\u54c1\u680f";
            }

            @Override
            public String getHeaderContent() {
                return InventoryDialogue.inventoryView();
            }

            @Override
            public String getContent() {
                UtilText.nodeContentSB.setLength(0);
                UtilText.nodeContentSB.append("<p>");
                UtilText.nodeContentSB.append("[style.boldMinorGood(\u62e5\u6709\u7684\u89e3\u9501\u7528\u5177\uff1a)]");
                if (Main.game.getPlayer().getUnlockKeyMap().isEmpty()) {
                    UtilText.nodeContentSB.append("<br/>[style.italicsDisabled(\u4ec0\u4e48\u4e5f\u6ca1\u6709\u2026\u2026)]");
                } else {
                    for (Map.Entry<String, List<InventorySlot>> entry : Main.game.getPlayer().getUnlockKeyMap().entrySet()) {
                        try {
                            GameCharacter npc = Main.game.getNPCById(entry.getKey());
                            ArrayList<CallSite> slots = new ArrayList<CallSite>();
                            for (InventorySlot slot : entry.getValue()) {
                                AbstractClothing abstractClothing = npc.getClothingInSlot(slot);
                                if (abstractClothing == null) continue;
                                slots.add((CallSite)((Object)(Util.capitaliseSentence(abstractClothing.getName()) + " ('" + slot.getName() + "'\u680f\u4f4d)")));
                            }
                            if (slots.isEmpty()) continue;
                            UtilText.nodeContentSB.append(UtilText.parse(npc, "<br/><b style='color:" + npc.getFemininity().getColour().toWebHexString() + ";'>[npc.Name]</b>(" + slots.size() + "): ", new ParserTag[0]));
                            int i = 0;
                            for (String string : slots) {
                                UtilText.nodeContentSB.append((i > 0 ? "\u3001" : "") + string);
                                ++i;
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                UtilText.nodeContentSB.append("</p>");
                return UtilText.nodeContentSB.toString();
            }

            @Override
            public String getResponseTabTitle(int index) {
                return InventoryDialogue.getGeneralResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                return INVENTORY_MENU.getResponse(responseTab, index);
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.INVENTORY;
            }
        };
        ITEM_INVENTORY = new DialogueNode("\u7269\u54c1", "", true){

            @Override
            public String getLabel() {
                if (Main.game.getDialogueFlags().values.contains(DialogueFlagValue.quickTrade) && !Main.game.isInSex() && !Main.game.isInCombat()) {
                    return "\u7269\u54c1\u680f(\u5feb\u901f\u7ba1\u7406\u5f53\u524d<b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u5f00\u542f</b>)";
                }
                return "\u7269\u54c1\u680f";
            }

            @Override
            public String getHeaderContent() {
                return InventoryDialogue.inventoryView();
            }

            @Override
            public String getContent() {
                return InventoryDialogue.getItemDisplayPanel(item, item.getSVGString(), item.getDisplayName(true), item.getDescription(owner) + item.getExtraDescription(owner, owner) + (String)(owner != null && owner.isPlayer() ? (inventoryNPC != null && interactionType == InventoryInteraction.TRADING ? "<p>" + (inventoryNPC.willBuy(item) && item.getItemType().isAbleToBeSold() ? inventoryNPC.getName("") + "\u4f1a\u4ee5" + UtilText.formatAsMoney(item.getPrice(inventoryNPC.getBuyModifier())) + "\u7684\u4ef7\u683c\u4e70\u5165\u3002" : inventoryNPC.getName("") + "\u4e0d\u60f3\u4e70\u8fd9\u4e2a\u3002") + "</p>" : "") : (inventoryNPC != null && interactionType == InventoryInteraction.TRADING ? "<p>" + inventoryNPC.getName("") + "\u4f1a\u4ee5" + UtilText.formatAsMoney(item.getPrice(inventoryNPC.getSellModifier(item))) + "\u7684\u4ef7\u683c\u51fa\u552e\u3002</p>" : "")));
            }

            @Override
            public String getResponseTabTitle(int index) {
                return InventoryDialogue.getGeneralResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 0) {
                    return InventoryDialogue.getCloseInventoryResponse();
                }
                if (Main.game.isBadEnd()) {
                    if (index == 1) {
                        return new Response("\u4e0d\u53ef\u7528", "\u5728\u574f\u7ed3\u5c40\u65f6\u65e0\u6cd5\u64cd\u4f5c\u7269\u54c1\u680f\u2026\u2026", null);
                    }
                    return null;
                }
                if (responseTab == 0) {
                    return INVENTORY_MENU.getResponse(responseTab, index);
                }
                if (owner != null && owner.isPlayer()) {
                    if (inventoryNPC == null) {
                        boolean areaFull = Main.game.isPlayerTileFull() && !Main.game.getPlayerCell().getInventory().hasItem(item);
                        switch (interactionType) {
                            case SEX: {
                                String dropTitle;
                                String string = dropTitle = owner.getLocationPlace().isItemsDisappear() ? "\u4e22\u5f03" : "\u5b58\u50a8";
                                if (index == 1) {
                                    return new Response(dropTitle + "(1)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u4e22\u5f03\u7269\u54c1\u3002", null);
                                }
                                if (index == 2) {
                                    return new Response(dropTitle + "(5)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u4e22\u5f03\u7269\u54c1\u3002", null);
                                }
                                if (index == 3) {
                                    return new Response(dropTitle + "(\u6240\u6709)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u4e22\u5f03\u7269\u54c1\u3002", null);
                                }
                                if (index == 5) {
                                    return new Response("\u9644\u9b54", "\u81ea\u6170\u65f6\u65e0\u6cd5\u9644\u9b54\u7269\u54c1\u3002", null);
                                }
                                if (index == 6) {
                                    if (Main.sex.isCharacterImmobilised(Main.game.getPlayer())) {
                                        return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", "\u4f60\u5f53\u524d\u5904\u4e8e[style.colourTerrible(\u65e0\u6cd5\u884c\u52a8)]\u72b6\u6001\uff0c\u65e0\u6cd5\u4f7f\u7528\u6b64\u7269\u54c1\uff01", null);
                                    }
                                    if (!Main.sex.isItemUseAvailable()) {
                                        return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", "\u8be5\u6027\u4ea4\u573a\u666f\u4e2d\u65e0\u6cd5\u4f7f\u7528\u7269\u54c1\uff01", null);
                                    }
                                    if (!item.isAbleToBeUsedInSex()) {
                                        return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u4f7f\u7528\u8fd9\u4e2a\uff01", null);
                                    }
                                    if (!item.isAbleToBeUsedFromInventory()) {
                                        return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getUnableToBeUsedFromInventoryDescription(), null);
                                    }
                                    if (!item.isAbleToBeUsed(Main.game.getPlayer(), Main.game.getPlayer())) {
                                        return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u81ea\u5df1)", item.getUnableToBeUsedDescription(Main.game.getPlayer(), Main.game.getPlayer()), null);
                                    }
                                    if (item.isBreakOutOfInventory()) {
                                        return new ResponseEffectsOnly(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(owner, owner)){

                                            @Override
                                            public void effects() {
                                                Main.game.getPlayer().useItem(item, Main.game.getPlayer(), false);
                                                InventoryDialogue.resetPostAction();
                                            }
                                        };
                                    }
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(owner, owner), Main.sex.SEX_DIALOGUE){

                                        @Override
                                        public void effects() {
                                            Main.sex.setUsingItemText(Main.game.getPlayer().useItem(item, Main.game.getPlayer(), false));
                                            InventoryDialogue.resetPostAction();
                                            Main.mainController.openInventory();
                                            Main.sex.endSexTurn(SexActionUtility.PLAYER_USE_ITEM);
                                            Main.sex.setSexStarted(true);
                                        }
                                    };
                                }
                                if (index == 7) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e00\u6b21\u53ea\u80fd\u4f7f\u7528\u4e00\u4efd\u7269\u54c1\uff01", null);
                                }
                                if (index == 10) {
                                    return InventoryDialogue.getQuickTradeResponse();
                                }
                                return null;
                            }
                        }
                        if (index == 1) {
                            if (owner.getLocationPlace().isItemsDisappear()) {
                                if (!item.getItemType().isAbleToBeDropped()) {
                                    return new Response("\u4e22\u5f03(1)", "\u4f60\u65e0\u6cd5\u4e22\u5f03" + item.getName() + "\uff01", null);
                                }
                                if (areaFull) {
                                    return new Response("\u4e22\u5f03(1)", "\u8be5\u533a\u57df\u5df2\u7ecf\u6ee1\u4e86\uff0c\u65e0\u6cd5\u5728\u6b64\u4e22\u5f03" + item.getName() + "\uff01", null);
                                }
                                return new Response("\u4e22\u5f03(1)", "\u4e22\u5f03" + item.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.dropItems(owner, item, 1);
                                    }
                                };
                            }
                            if (!item.getItemType().isAbleToBeDropped()) {
                                return new Response("\u5b58\u50a8(1)", "\u4f60\u65e0\u6cd5\u5b58\u50a8" + item.getName() + "\uff01", null);
                            }
                            if (areaFull) {
                                return new Response("\u5b58\u50a8(1)", "\u8be5\u533a\u57df\u5df2\u7ecf\u6ee1\u4e86\uff0c\u65e0\u6cd5\u5728\u6b64\u5b58\u50a8" + item.getName() + "\uff01", null);
                            }
                            return new Response("\u5b58\u50a8(1)", "\u5728\u8be5\u533a\u57df\u5b58\u50a8" + item.getName() + "\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    InventoryDialogue.dropItems(owner, item, 1);
                                }
                            };
                        }
                        if (index == 2) {
                            if (owner.getLocationPlace().isItemsDisappear()) {
                                if (owner.getItemCount(item) < 5) {
                                    return new Response("\u4e22\u5f03(5)", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u4e94\u4e2a" + item.getNamePlural() + "\uff01", null);
                                }
                                if (!item.getItemType().isAbleToBeDropped()) {
                                    return new Response("\u4e22\u5f03(5)", "\u4f60\u65e0\u6cd5\u4e22\u5f03" + item.getName() + "\uff01", null);
                                }
                                if (areaFull) {
                                    return new Response("\u4e22\u5f03(5)", "\u8be5\u533a\u57df\u5df2\u7ecf\u6ee1\u4e86\uff0c\u65e0\u6cd5\u5728\u6b64\u4e22\u5f03" + item.getName() + "\uff01", null);
                                }
                                return new Response("\u4e22\u5f03(5)", "\u4e22\u5f03\u4e94\u4e2a" + item.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.dropItems(owner, item, 5);
                                    }
                                };
                            }
                            if (owner.getItemCount(item) < 5) {
                                return new Response("\u5b58\u50a8(5)", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u4e94\u4e2a" + item.getNamePlural() + "\uff01", null);
                            }
                            if (!item.getItemType().isAbleToBeDropped()) {
                                return new Response("\u5b58\u50a8(5)", "\u4f60\u65e0\u6cd5\u5b58\u50a8" + item.getName() + "\uff01", null);
                            }
                            if (areaFull) {
                                return new Response("\u5b58\u50a8(5)", "\u8be5\u533a\u57df\u5df2\u7ecf\u6ee1\u4e86\uff0c\u65e0\u6cd5\u5728\u6b64\u5b58\u50a8" + item.getName() + "\uff01", null);
                            }
                            return new Response("\u5b58\u50a8(5)", "\u5728\u8be5\u533a\u57df\u5b58\u50a8\u4e94\u4e2a" + item.getName() + "\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    InventoryDialogue.dropItems(owner, item, 5);
                                }
                            };
                        }
                        if (index == 3) {
                            if (owner.getLocationPlace().isItemsDisappear()) {
                                if (!item.getItemType().isAbleToBeDropped()) {
                                    return new Response("\u4e22\u5f03(\u6240\u6709)", "\u4f60\u65e0\u6cd5\u4e22\u5f03" + item.getName() + "\uff01", null);
                                }
                                if (areaFull) {
                                    return new Response("\u4e22\u5f03(\u6240\u6709)", "\u8be5\u533a\u57df\u5df2\u7ecf\u6ee1\u4e86\uff0c\u65e0\u6cd5\u5728\u6b64\u4e22\u5f03" + item.getName() + "\uff01", null);
                                }
                                return new Response("\u4e22\u5f03(\u6240\u6709)", "\u4e22\u5f03\u6240\u6709\u7684" + item.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.dropItems(owner, item, owner.getItemCount(item));
                                    }
                                };
                            }
                            if (!item.getItemType().isAbleToBeDropped()) {
                                return new Response("\u5b58\u50a8(\u6240\u6709)", "\u4f60\u65e0\u6cd5\u5b58\u50a8" + item.getName() + "\uff01", null);
                            }
                            if (areaFull) {
                                return new Response("\u5b58\u50a8(\u6240\u6709)", "\u8be5\u533a\u57df\u5df2\u7ecf\u6ee1\u4e86\uff0c\u65e0\u6cd5\u5728\u6b64\u5b58\u50a8" + item.getName() + "\uff01", null);
                            }
                            return new Response("\u5b58\u50a8(\u6240\u6709)", "\u5728\u8be5\u533a\u57df\u5b58\u50a8\u6240\u6709\u7684" + item.getName() + "\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    InventoryDialogue.dropItems(owner, item, owner.getItemCount(item));
                                }
                            };
                        }
                        if (index == 5) {
                            if (item.getEnchantmentItemType(null) == null || item.getItemTags().contains((Object)ItemTag.UNENCHANTABLE)) {
                                return new Response("\u9644\u9b54", "\u8be5\u7269\u54c1\u65e0\u6cd5\u9644\u9b54\uff01", null);
                            }
                            if (Main.game.isDebugMode() || Main.game.getPlayer().hasQuest(QuestLine.SIDE_ENCHANTMENT_DISCOVERY) && Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ENCHANTMENT_DISCOVERY)) {
                                return new Response("\u9644\u9b54", "\u9644\u9b54\u8be5\u7269\u54c1\u3002", EnchantmentDialogue.ENCHANTMENT_MENU){

                                    @Override
                                    public DialogueNode getNextDialogue() {
                                        return EnchantmentDialogue.getEnchantmentMenu(item);
                                    }
                                };
                            }
                            return new Response("\u9644\u9b54", InventoryDialogue.getEnchantmentNotDiscoveredText("items"), null);
                        }
                        if (index == 6) {
                            if (!item.isAbleToBeUsedFromInventory()) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getUnableToBeUsedFromInventoryDescription(), null);
                            }
                            if (!item.isAbleToBeUsed(Main.game.getPlayer(), Main.game.getPlayer())) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u81ea\u5df1)", item.getUnableToBeUsedDescription(Main.game.getPlayer(), Main.game.getPlayer()), null);
                            }
                            if (item.isBreakOutOfInventory()) {
                                return new ResponseEffectsOnly(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(owner, owner)){

                                    @Override
                                    public void effects() {
                                        Main.game.getPlayer().useItem(item, Main.game.getPlayer(), false);
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(owner, owner), INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().useItem(item, Main.game.getPlayer(), false) + "</p>");
                                    InventoryDialogue.resetPostAction();
                                }
                            };
                        }
                        if (index == 7) {
                            if (!item.isAbleToBeUsedFromInventory()) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", item.getUnableToBeUsedFromInventoryDescription(), null);
                            }
                            if (!item.isAbleToBeUsed(Main.game.getPlayer(), Main.game.getPlayer())) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " \u6240\u6709(\u81ea\u5df1)", item.getUnableToBeUsedDescription(Main.game.getPlayer(), Main.game.getPlayer()), null);
                            }
                            if (item.isBreakOutOfInventory()) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", "\u7531\u4e8e\u8be5\u7269\u54c1\u62e5\u6709\u7279\u6b8a\u6548\u679c\uff0c\u4f60\u4e00\u6b21\u53ea\u80fd\u4f7f\u7528\u4e00\u4e2a\uff01", null);
                            }
                            return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(owner, owner) + "<br/>[style.italicsMinorGood(\u91cd\u590d\u8be5\u52a8\u4f5c\u76f4\u5230\u7528\u5149\u7269\u54c1\u680f\u4e2d\u7684\u6240\u6709" + item.getNamePlural() + "\u3002)]", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    int itemCount = Main.game.getPlayer().getItemCount(item);
                                    for (int i = 0; i < itemCount; ++i) {
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().useItem(item, Main.game.getPlayer(), false) + "</p>");
                                    }
                                    InventoryDialogue.resetPostAction();
                                }
                            };
                        }
                        if (index == 10) {
                            return InventoryDialogue.getQuickTradeResponse();
                        }
                        return null;
                    }
                    switch (interactionType) {
                        case COMBAT: {
                            if (index == 1) {
                                return new Response("\u7ed9\u4e88(1)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u7ed9\u4e88\u5176\u7269\u54c1\uff01", null);
                            }
                            if (index == 2) {
                                return new Response("\u7ed9\u4e88(5)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u7ed9\u4e88\u5bf9\u65b9\u7269\u54c1\uff01", null);
                            }
                            if (index == 3) {
                                return new Response("\u7ed9\u4e88(\u6240\u6709)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u7ed9\u4e88\u5176\u7269\u54c1\uff01", null);
                            }
                            if (index == 5) {
                                return new Response("\u9644\u9b54", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u9644\u9b54\u7269\u54c1\uff01", null);
                            }
                            if (index == 6) {
                                if (Main.game.getPlayer().isStunned()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", "\u7729\u6655\u65f6\u65e0\u6cd5\u4f7f\u7528\u4efb\u4f55\u7269\u54c1\uff01", null);
                                }
                                if (Main.combat.isCombatantDefeated(Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", "\u88ab\u51fb\u8d25\u65f6\u65e0\u6cd5\u4f7f\u7528\u4efb\u4f55\u7269\u54c1\uff01", null);
                                }
                                if (Main.game.getPlayer().getRemainingAP() < CombatMove.ITEM_USAGE.getAPcost(Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", "\u9700\u8981\u81f3\u5c11" + CombatMove.ITEM_USAGE.getAPcost(Main.game.getPlayer()) + "\u70b9AP\u6765\u4f7f\u7528\u8be5\u52a8\u4f5c\uff01", null);
                                }
                                if (!item.isAbleToBeUsedInCombatAllies()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", "\u65e0\u6cd5\u5728\u6218\u6597\u4e2d\u4f7f\u7528\u8fd9\u4e2a\uff01", null);
                                }
                                if (!item.isAbleToBeUsedFromInventory()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getUnableToBeUsedFromInventoryDescription(), null);
                                }
                                if (!item.isAbleToBeUsed(Main.game.getPlayer(), Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u81ea\u5df1)", item.getUnableToBeUsedDescription(Main.game.getPlayer(), Main.game.getPlayer()), null);
                                }
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(owner, owner), Main.combat.ENEMY_ATTACK){

                                    @Override
                                    public void effects() {
                                        Main.combat.addItemToBeUsed(owner, owner, item);
                                        InventoryDialogue.resetPostAction();
                                        Main.mainController.openInventory();
                                    }
                                };
                            }
                            if (index == 7) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", "\u6218\u6597\u65f6\u4e00\u6b21\u53ea\u80fd\u4f7f\u7528\u4e00\u4ef6\u7269\u54c1\uff01", null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index == 11) {
                                if (Main.game.getPlayer().isStunned()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u654c\u4eba)", "\u7729\u6655\u65f6\u65e0\u6cd5\u4f7f\u7528\u4efb\u4f55\u7269\u54c1\uff01", null);
                                }
                                if (Main.combat.isCombatantDefeated(Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u654c\u4eba)", "\u88ab\u51fb\u8d25\u65f6\u65e0\u6cd5\u4f7f\u7528\u4efb\u4f55\u7269\u54c1\uff01", null);
                                }
                                if (Main.game.getPlayer().getRemainingAP() < CombatMove.ITEM_USAGE.getAPcost(Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u654c\u4eba)", "\u81f3\u5c11\u9700\u8981" + CombatMove.ITEM_USAGE.getAPcost(Main.game.getPlayer()) + "\u70b9AP\u6765\u4f7f\u7528\u8be5\u52a8\u4f5c\uff01", null);
                                }
                                if (!item.isAbleToBeUsedInCombatEnemies()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u654c\u4eba)", "\u65e0\u6cd5\u5728\u6218\u6597\u4e2d\u4f7f\u7528\u8fd9\u4e2a\uff01", null);
                                }
                                if (!item.isAbleToBeUsedFromInventory()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u654c\u4eba)", item.getUnableToBeUsedFromInventoryDescription(), null);
                                }
                                if (!item.isAbleToBeUsed(Main.game.getPlayer(), inventoryNPC)) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u654c\u4eba)", item.getUnableToBeUsedDescription(Main.game.getPlayer(), inventoryNPC), null);
                                }
                                if (item.getItemType().isFetishGiving()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u654c\u4eba)", item.getItemType().getUseTooltipDescription(owner, inventoryNPC), Main.combat.ENEMY_ATTACK, Util.newArrayListOfValues(Fetish.FETISH_KINK_GIVING), Fetish.FETISH_KINK_GIVING.getAssociatedCorruptionLevel(), null, null, null){

                                        @Override
                                        public void effects() {
                                            Main.combat.addItemToBeUsed(owner, inventoryNPC, item);
                                            InventoryDialogue.resetPostAction();
                                            Main.mainController.openInventory();
                                        }
                                    };
                                }
                                if (item.getItemType().isTransformative()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u654c\u4eba)", item.getItemType().getUseTooltipDescription(owner, inventoryNPC), Main.combat.ENEMY_ATTACK, Util.newArrayListOfValues(Fetish.FETISH_TRANSFORMATION_GIVING), Fetish.FETISH_TRANSFORMATION_GIVING.getAssociatedCorruptionLevel(), null, null, null){

                                        @Override
                                        public void effects() {
                                            Main.combat.addItemToBeUsed(owner, inventoryNPC, item);
                                            InventoryDialogue.resetPostAction();
                                            Main.mainController.openInventory();
                                        }
                                    };
                                }
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u654c\u4eba)", item.getItemType().getUseTooltipDescription(owner, inventoryNPC), Main.combat.ENEMY_ATTACK){

                                    @Override
                                    public void effects() {
                                        Main.combat.addItemToBeUsed(owner, inventoryNPC, item);
                                        InventoryDialogue.resetPostAction();
                                        Main.mainController.openInventory();
                                    }
                                };
                            }
                            if (index == 12) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u654c\u4eba)", "\u6218\u6597\u65f6\u4e00\u6b21\u53ea\u80fd\u4f7f\u7528\u4e00\u4ef6\u7269\u54c1\uff01", null);
                            }
                            return null;
                        }
                        case FULL_MANAGEMENT: 
                        case CHARACTER_CREATION: {
                            boolean inventoryFull;
                            boolean bl = inventoryFull = inventoryNPC.isInventoryFull() && !inventoryNPC.hasItem(item);
                            if (index == 1) {
                                if (!item.getItemType().isAbleToBeDropped()) {
                                    return new Response("\u7ed9\u4e88(1)", "\u4f60\u65e0\u6cd5\u7ed9\u51fa" + item.getName() + "\uff01", null);
                                }
                                if (inventoryFull) {
                                    return new Response("\u7ed9\u4e88(1)", UtilText.parse((GameCharacter)inventoryNPC, "[npc.NamePos]\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", new ParserTag[0]), null);
                                }
                                return new Response("\u7ed9\u4e88(1)", UtilText.parse((GameCharacter)inventoryNPC, "\u7ed9\u4e88[npc.name]\u4e00\u4e2a" + item.getName() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.transferItems(Main.game.getPlayer(), inventoryNPC, item, 1);
                                    }
                                };
                            }
                            if (index == 2) {
                                if (!item.getItemType().isAbleToBeDropped()) {
                                    return new Response("\u7ed9\u4e88(5)", "\u4f60\u65e0\u6cd5\u7ed9\u51fa" + item.getName() + "\uff01", null);
                                }
                                if (inventoryFull) {
                                    return new Response("\u7ed9\u4e88(5)", UtilText.parse((GameCharacter)inventoryNPC, "[npc.NamePos]\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", new ParserTag[0]), null);
                                }
                                if (Main.game.getPlayer().getItemCount(item) >= 5) {
                                    return new Response("\u7ed9\u4e88(5)", UtilText.parse((GameCharacter)inventoryNPC, "\u7ed9\u4e88[npc.name]\u4e94\u4e2a" + item.getName() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.transferItems(Main.game.getPlayer(), inventoryNPC, item, 5);
                                        }
                                    };
                                }
                                return new Response("\u7ed9\u4e88(5)", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u4e94\u4e2a" + item.getNamePlural() + "\uff01", null);
                            }
                            if (index == 3) {
                                if (!item.getItemType().isAbleToBeDropped()) {
                                    return new Response("\u7ed9\u4e88(\u6240\u6709)", "\u4f60\u65e0\u6cd5\u7ed9\u51fa" + item.getName() + "\uff01", null);
                                }
                                if (inventoryFull) {
                                    return new Response("\u7ed9\u4e88(\u6240\u6709)", UtilText.parse((GameCharacter)inventoryNPC, "[npc.NamePos]\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", new ParserTag[0]), null);
                                }
                                return new Response("\u7ed9\u4e88(\u6240\u6709)", UtilText.parse((GameCharacter)inventoryNPC, "\u7ed9\u4e88[npc.name]\u4f60\u6240\u6709\u7684" + item.getName() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.transferItems(Main.game.getPlayer(), inventoryNPC, item, Main.game.getPlayer().getItemCount(item));
                                    }
                                };
                            }
                            if (index == 5) {
                                if (item.getEnchantmentItemType(null) == null || item.getItemTags().contains((Object)ItemTag.UNENCHANTABLE)) {
                                    return new Response("\u9644\u9b54", "\u8be5\u7269\u54c1\u65e0\u6cd5\u9644\u9b54\uff01", null);
                                }
                                if (Main.game.isDebugMode() || Main.game.getPlayer().hasQuest(QuestLine.SIDE_ENCHANTMENT_DISCOVERY) && Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ENCHANTMENT_DISCOVERY)) {
                                    return new Response("\u9644\u9b54", "\u9644\u9b54\u8be5\u7269\u54c1\u3002", EnchantmentDialogue.ENCHANTMENT_MENU){

                                        @Override
                                        public DialogueNode getNextDialogue() {
                                            return EnchantmentDialogue.getEnchantmentMenu(item);
                                        }
                                    };
                                }
                                return new Response("\u9644\u9b54", InventoryDialogue.getEnchantmentNotDiscoveredText("items"), null);
                            }
                            if (index == 6) {
                                if (!item.isAbleToBeUsedFromInventory()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getUnableToBeUsedFromInventoryDescription(), null);
                                }
                                if (!item.isAbleToBeUsed(Main.game.getPlayer(), Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u81ea\u5df1)", item.getUnableToBeUsedDescription(Main.game.getPlayer(), Main.game.getPlayer()), null);
                                }
                                if (item.isBreakOutOfInventory()) {
                                    return new ResponseEffectsOnly(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(owner, owner)){

                                        @Override
                                        public void effects() {
                                            Main.game.getPlayer().useItem(item, Main.game.getPlayer(), false);
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(owner, owner), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().useItem(item, Main.game.getPlayer(), false) + "</p>");
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            if (index == 7) {
                                if (!item.isAbleToBeUsedFromInventory()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", item.getUnableToBeUsedFromInventoryDescription(), null);
                                }
                                if (!item.isAbleToBeUsed(Main.game.getPlayer(), Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " \u6240\u6709(\u81ea\u5df1)", item.getUnableToBeUsedDescription(Main.game.getPlayer(), Main.game.getPlayer()), null);
                                }
                                if (item.isBreakOutOfInventory()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", "\u7531\u4e8e\u8be5\u7269\u54c1\u62e5\u6709\u7279\u6b8a\u6548\u679c\uff0c\u4f60\u4e00\u6b21\u53ea\u80fd\u4f7f\u7528\u4e00\u4e2a\uff01", null);
                                }
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(owner, owner) + "<br/>[style.italicsMinorGood(\u91cd\u590d\u8be5\u52a8\u4f5c\u76f4\u5230\u7528\u5149\u7269\u54c1\u680f\u4e2d\u7684\u6240\u6709" + item.getNamePlural() + "\u3002)]", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        int itemCount = Main.game.getPlayer().getItemCount(item);
                                        for (int i = 0; i < itemCount; ++i) {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().useItem(item, Main.game.getPlayer(), false) + "</p>");
                                        }
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index == 11) {
                                if (!item.isAbleToBeUsedFromInventory()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "([npc.HerHim])", new ParserTag[0]), item.getUnableToBeUsedFromInventoryDescription(), null);
                                }
                                if (!item.isAbleToBeUsed(Main.game.getPlayer(), inventoryNPC)) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, " ([npc.HerHim])", new ParserTag[0]), item.getUnableToBeUsedDescription(Main.game.getPlayer(), inventoryNPC), null);
                                }
                                if (item.isBreakOutOfInventory()) {
                                    return new ResponseEffectsOnly(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "([npc.HerHim])", new ParserTag[0]), item.getItemType().getUseTooltipDescription(owner, owner)){

                                        @Override
                                        public void effects() {
                                            Main.game.getPlayer().useItem(item, inventoryNPC, false);
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                if (item.getItemType().isFetishGiving()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "([npc.HerHim])", new ParserTag[0]), item.getItemType().getUseTooltipDescription(owner, inventoryNPC), INVENTORY_MENU, Util.newArrayListOfValues(Fetish.FETISH_KINK_GIVING), Fetish.FETISH_KINK_GIVING.getAssociatedCorruptionLevel(), null, null, null){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append(inventoryNPC.getItemUseEffects(item, owner, Main.game.getPlayer(), inventoryNPC).getValue());
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                if (item.getItemType().isTransformative()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "([npc.HerHim])", new ParserTag[0]), item.getItemType().getUseTooltipDescription(owner, inventoryNPC), INVENTORY_MENU, Util.newArrayListOfValues(Fetish.FETISH_TRANSFORMATION_GIVING), Fetish.FETISH_TRANSFORMATION_GIVING.getAssociatedCorruptionLevel(), null, null, null){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append(inventoryNPC.getItemUseEffects(item, owner, Main.game.getPlayer(), inventoryNPC).getValue());
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "([npc.HerHim])", new ParserTag[0]), item.getItemType().getUseTooltipDescription(owner, inventoryNPC), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        Main.game.getTextEndStringBuilder().append(inventoryNPC.getItemUseEffects(item, owner, Main.game.getPlayer(), inventoryNPC).getValue());
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            if (index == 12) {
                                if (!item.isAbleToBeUsedFromInventory()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "\u6240\u6709([npc.HerHim])", new ParserTag[0]), item.getUnableToBeUsedFromInventoryDescription(), null);
                                }
                                if (!item.isAbleToBeUsed(Main.game.getPlayer(), inventoryNPC)) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "\u6240\u6709([npc.HerHim])", new ParserTag[0]), item.getUnableToBeUsedDescription(Main.game.getPlayer(), inventoryNPC), null);
                                }
                                if (item.isBreakOutOfInventory()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "\u6240\u6709([npc.HerHim])", new ParserTag[0]), "\u7531\u4e8e\u8be5\u7269\u54c1\u5177\u6709\u7279\u6b8a\u6548\u679c\uff0c\u4f60\u4e00\u6b21\u53ea\u80fd\u4f7f\u7528\u4e00\u4e2a\uff01", null);
                                }
                                if (item.getItemType().isFetishGiving()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "\u6240\u6709([npc.HerHim])", new ParserTag[0]), item.getItemType().getUseTooltipDescription(owner, inventoryNPC) + "<br/>[style.italicsMinorGood(\u91cd\u590d\u8be5\u52a8\u4f5c\u76f4\u5230\u7528\u5149\u7269\u54c1\u680f\u4e2d\u7684\u6240\u6709" + item.getNamePlural() + "\u3002)]", INVENTORY_MENU, Util.newArrayListOfValues(Fetish.FETISH_KINK_GIVING), Fetish.FETISH_KINK_GIVING.getAssociatedCorruptionLevel(), null, null, null){

                                        @Override
                                        public void effects() {
                                            int itemCount = Main.game.getPlayer().getItemCount(item);
                                            for (int i = 0; i < itemCount; ++i) {
                                                Main.game.getTextEndStringBuilder().append(inventoryNPC.getItemUseEffects(item, owner, Main.game.getPlayer(), inventoryNPC).getValue());
                                            }
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                if (item.getItemType().isTransformative()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "\u6240\u6709([npc.HerHim])", new ParserTag[0]), item.getItemType().getUseTooltipDescription(owner, inventoryNPC) + "<br/>[style.italicsMinorGood(\u91cd\u590d\u8be5\u52a8\u4f5c\u76f4\u5230\u7528\u5149\u7269\u54c1\u680f\u4e2d\u7684\u6240\u6709" + item.getNamePlural() + "\u3002)]", INVENTORY_MENU, Util.newArrayListOfValues(Fetish.FETISH_TRANSFORMATION_GIVING), Fetish.FETISH_TRANSFORMATION_GIVING.getAssociatedCorruptionLevel(), null, null, null){

                                        @Override
                                        public void effects() {
                                            int itemCount = Main.game.getPlayer().getItemCount(item);
                                            for (int i = 0; i < itemCount; ++i) {
                                                Main.game.getTextEndStringBuilder().append(inventoryNPC.getItemUseEffects(item, owner, Main.game.getPlayer(), inventoryNPC).getValue());
                                            }
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "\u6240\u6709([npc.HerHim])", new ParserTag[0]), item.getItemType().getUseTooltipDescription(owner, inventoryNPC) + "<br/>[style.italicsMinorGood(\u91cd\u590d\u8be5\u52a8\u4f5c\u76f4\u5230\u7528\u5149\u7269\u54c1\u680f\u4e2d\u7684\u6240\u6709" + item.getNamePlural() + "\u3002)]", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        int itemCount = Main.game.getPlayer().getItemCount(item);
                                        for (int i = 0; i < itemCount; ++i) {
                                            Main.game.getTextEndStringBuilder().append(inventoryNPC.getItemUseEffects(item, owner, Main.game.getPlayer(), inventoryNPC).getValue());
                                        }
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            return null;
                        }
                        case SEX: {
                            if (index == 1) {
                                return new Response("\u7ed9\u4e88(1)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u7ed9\u4e88\u5bf9\u65b9\u7269\u54c1\uff01", null);
                            }
                            if (index == 2) {
                                return new Response("\u7ed9\u4e88(5)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u7ed9\u4e88\u5bf9\u65b9\u7269\u54c1\uff01", null);
                            }
                            if (index == 3) {
                                return new Response("\u7ed9\u4e88(\u6240\u6709)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u7ed9\u4e88\u5bf9\u65b9\u7269\u54c1\uff01", null);
                            }
                            if (index == 5) {
                                return new Response("\u9644\u9b54", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u9644\u9b54\u7269\u54c1\uff01", null);
                            }
                            if (index == 6) {
                                if (Main.sex.isCharacterImmobilised(Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", "\u4f60\u5f53\u524d\u5904\u4e8e[style.colourTerrible(\u65e0\u6cd5\u884c\u52a8)]\u72b6\u6001\uff0c\u65e0\u6cd5\u4f7f\u7528\u6b64\u7269\u54c1\uff01", null);
                                }
                                if (!Main.sex.isItemUseAvailable()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", "\u8be5\u6027\u4ea4\u573a\u666f\u4e2d\u65e0\u6cd5\u4f7f\u7528\u7269\u54c1\uff01", null);
                                }
                                if (!item.isAbleToBeUsedInSex()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u4f7f\u7528\u8fd9\u4e2a\uff01", null);
                                }
                                if (!item.isAbleToBeUsedFromInventory()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getUnableToBeUsedFromInventoryDescription(), null);
                                }
                                if (!item.isAbleToBeUsed(Main.game.getPlayer(), Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u81ea\u5df1)", item.getUnableToBeUsedDescription(Main.game.getPlayer(), Main.game.getPlayer()), null);
                                }
                                if (item.isBreakOutOfInventory()) {
                                    return new ResponseEffectsOnly(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(owner, owner)){

                                        @Override
                                        public void effects() {
                                            Main.game.getPlayer().useItem(item, Main.game.getPlayer(), false);
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(owner, owner), Main.sex.SEX_DIALOGUE){

                                    @Override
                                    public void effects() {
                                        Main.sex.setUsingItemText(((NPC)Main.sex.getTargetedPartner(Main.game.getPlayer())).getItemUseEffects(item, owner, Main.game.getPlayer(), Main.game.getPlayer()).getValue());
                                        InventoryDialogue.resetPostAction();
                                        Main.mainController.openInventory();
                                        Main.sex.endSexTurn(SexActionUtility.PLAYER_USE_ITEM);
                                        Main.sex.setSexStarted(true);
                                    }
                                };
                            }
                            if (index == 7) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e00\u6b21\u53ea\u80fd\u4f7f\u7528\u4e00\u4efd\u7269\u54c1\uff01", null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index == 11) {
                                if (Main.sex.isCharacterImmobilised(Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u5bf9\u8c61)", "\u4f60\u5f53\u524d\u5904\u4e8e[style.colourTerrible(\u65e0\u6cd5\u884c\u52a8)]\u72b6\u6001\uff0c\u65e0\u6cd5\u4f7f\u7528\u6b64\u7269\u54c1\uff01", null);
                                }
                                if (Main.sex.getInitialSexManager().isHidden(Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u5bf9\u8c61)", UtilText.parse((GameCharacter)inventoryNPC, "\u4f60\u65e0\u6cd5\u5728\u8eb2\u85cf\u65f6\u5bf9[npc.Name]\u4f7f\u7528\u7269\u54c1\uff01", new ParserTag[0]), null);
                                }
                                if (!Main.sex.isItemUseAvailable()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u5bf9\u8c61)", "\u8be5\u6027\u4ea4\u573a\u666f\u4e2d\u65e0\u6cd5\u4f7f\u7528\u7269\u54c1\uff01", null);
                                }
                                if (!item.isAbleToBeUsedInSex()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u5bf9\u8c61)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u4f7f\u7528\u8fd9\u4e2a\uff01", null);
                                }
                                if (!item.isAbleToBeUsedFromInventory()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u5bf9\u8c61)", item.getUnableToBeUsedFromInventoryDescription(), null);
                                }
                                if (!item.isAbleToBeUsed(Main.game.getPlayer(), inventoryNPC)) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u5bf9\u8c61)", item.getUnableToBeUsedDescription(Main.game.getPlayer(), inventoryNPC), null);
                                }
                                if (inventoryNPC.isAsleep()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u5bf9\u8c61)", UtilText.parse((GameCharacter)inventoryNPC, "\u5f53[npc.nameIsFull]\u7761\u7720\u65f6\u4f60\u4e0d\u80fd\u4f7f\u7528\u8be5\u7269\u54c1\uff01", new ParserTag[0]), null);
                                }
                                if (item.getItemType().isFetishGiving()) {
                                    if (item.isBreakOutOfInventory()) {
                                        return new ResponseEffectsOnly(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u5bf9\u8c61)", item.getItemType().getUseTooltipDescription(owner, inventoryNPC), Util.newArrayListOfValues(Fetish.FETISH_KINK_GIVING), Fetish.FETISH_KINK_GIVING.getAssociatedCorruptionLevel(), null, null, null){

                                            @Override
                                            public void effects() {
                                                Main.game.getPlayer().useItem(item, inventoryNPC, false);
                                                InventoryDialogue.resetPostAction();
                                            }
                                        };
                                    }
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u5bf9\u8c61)", item.getItemType().getUseTooltipDescription(owner, inventoryNPC), Main.sex.SEX_DIALOGUE, Util.newArrayListOfValues(Fetish.FETISH_KINK_GIVING), Fetish.FETISH_KINK_GIVING.getAssociatedCorruptionLevel(), null, null, null){

                                        @Override
                                        public void effects() {
                                            Main.sex.setUsingItemText(inventoryNPC.getItemUseEffects(item, owner, Main.game.getPlayer(), inventoryNPC).getValue());
                                            InventoryDialogue.resetPostAction();
                                            Main.mainController.openInventory();
                                            Main.sex.endSexTurn(SexActionUtility.PLAYER_USE_ITEM);
                                            Main.sex.setSexStarted(true);
                                        }
                                    };
                                }
                                if (item.getItemType().isTransformative()) {
                                    if (item.isBreakOutOfInventory()) {
                                        return new ResponseEffectsOnly(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u5bf9\u8c61)", item.getItemType().getUseTooltipDescription(owner, inventoryNPC), Util.newArrayListOfValues(Fetish.FETISH_TRANSFORMATION_GIVING), Fetish.FETISH_TRANSFORMATION_GIVING.getAssociatedCorruptionLevel(), null, null, null){

                                            @Override
                                            public void effects() {
                                                Main.game.getPlayer().useItem(item, inventoryNPC, false);
                                                InventoryDialogue.resetPostAction();
                                            }
                                        };
                                    }
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u5bf9\u8c61)", item.getItemType().getUseTooltipDescription(owner, inventoryNPC), Main.sex.SEX_DIALOGUE, Util.newArrayListOfValues(Fetish.FETISH_TRANSFORMATION_GIVING), Fetish.FETISH_TRANSFORMATION_GIVING.getAssociatedCorruptionLevel(), null, null, null){

                                        @Override
                                        public void effects() {
                                            Main.sex.setUsingItemText(inventoryNPC.getItemUseEffects(item, owner, Main.game.getPlayer(), inventoryNPC).getValue());
                                            InventoryDialogue.resetPostAction();
                                            Main.mainController.openInventory();
                                            Main.sex.endSexTurn(SexActionUtility.PLAYER_USE_ITEM);
                                            Main.sex.setSexStarted(true);
                                        }
                                    };
                                }
                                if (item.isBreakOutOfInventory()) {
                                    return new ResponseEffectsOnly(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u5bf9\u8c61)", item.getItemType().getUseTooltipDescription(owner, inventoryNPC)){

                                        @Override
                                        public void effects() {
                                            Main.game.getPlayer().useItem(item, inventoryNPC, false);
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u5bf9\u8c61)", item.getItemType().getUseTooltipDescription(owner, inventoryNPC), Main.sex.SEX_DIALOGUE){

                                    @Override
                                    public void effects() {
                                        Main.sex.setUsingItemText(inventoryNPC.getItemUseEffects(item, owner, Main.game.getPlayer(), inventoryNPC).getValue());
                                        InventoryDialogue.resetPostAction();
                                        Main.mainController.openInventory();
                                        Main.sex.endSexTurn(SexActionUtility.PLAYER_USE_ITEM);
                                        Main.sex.setSexStarted(true);
                                    }
                                };
                            }
                            if (index == 12) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " \u6240\u6709(\u5bf9\u8c61)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e00\u6b21\u53ea\u80fd\u4f7f\u7528\u4e00\u4efd\u7269\u54c1\uff01", null);
                            }
                            return null;
                        }
                        case TRADING: {
                            if (index == 1) {
                                if (!item.getItemType().isAbleToBeSold()) {
                                    return new Response("\u51fa\u552e(1)", "\u4f60\u65e0\u6cd5\u51fa\u552e" + item.getName() + "\uff01", null);
                                }
                                if (inventoryNPC.willBuy(item)) {
                                    final int sellPrice = item.getPrice(inventoryNPC.getBuyModifier());
                                    return new Response("\u51fa\u552e(1) (" + UtilText.formatAsMoney(sellPrice, "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice) + "\u7684\u4ef7\u683c\u51fa\u552e" + item.getName() + "\u3002", INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.sellItems(Main.game.getPlayer(), inventoryNPC, item, 1, sellPrice);
                                        }
                                    };
                                }
                                return new Response("\u51fa\u552e(1)", inventoryNPC.getName("") + "\u4e0d\u60f3\u4e70\u8fd9\u4e2a\u3002", null);
                            }
                            if (index == 2) {
                                if (Main.game.getPlayer().getItemCount(item) >= 5) {
                                    if (!item.getItemType().isAbleToBeSold()) {
                                        return new Response("\u51fa\u552e(5)", "\u4f60\u65e0\u6cd5\u51fa\u552e" + item.getName() + "\uff01", null);
                                    }
                                    if (inventoryNPC.willBuy(item)) {
                                        final int sellPrice = item.getPrice(inventoryNPC.getBuyModifier());
                                        return new Response("\u51fa\u552e(5) (" + UtilText.formatAsMoney(sellPrice * 5, "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice) + "\u7684\u4ef7\u683c\u51fa\u552e\u4e94\u4e2a" + item.getName() + "\u3002", INVENTORY_MENU){

                                            @Override
                                            public void effects() {
                                                InventoryDialogue.sellItems(Main.game.getPlayer(), inventoryNPC, item, 5, sellPrice);
                                            }
                                        };
                                    }
                                    return new Response("\u51fa\u552e(5)", inventoryNPC.getName("") + "\u4e0d\u60f3\u4e70\u8fd9\u4e9b\u3002", null);
                                }
                                return new Response("\u51fa\u552e(5)", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u4e94\u4e2a" + item.getNamePlural() + "\uff01", null);
                            }
                            if (index == 3) {
                                if (!item.getItemType().isAbleToBeSold()) {
                                    return new Response("\u51fa\u552e(\u6240\u6709)", "\u4f60\u65e0\u6cd5\u51fa\u552e" + item.getName() + "\uff01", null);
                                }
                                if (inventoryNPC.willBuy(item)) {
                                    final int sellPrice = item.getPrice(inventoryNPC.getBuyModifier());
                                    return new Response("\u51fa\u552e(\u6240\u6709) (" + UtilText.formatAsMoney(sellPrice * Main.game.getPlayer().getItemCount(item), "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice) + "\u7684\u4ef7\u683c\u51fa\u552e\u6240\u6709" + item.getName() + "\u3002", INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.sellItems(Main.game.getPlayer(), inventoryNPC, item, Main.game.getPlayer().getItemCount(item), sellPrice);
                                        }
                                    };
                                }
                                return new Response("\u51fa\u552e(\u6240\u6709)", inventoryNPC.getName("") + "\u4e0d\u60f3\u4e70\u8fd9\u4e9b\u3002", null);
                            }
                            if (index == 5) {
                                if (item.getEnchantmentItemType(null) == null || item.getItemTags().contains((Object)ItemTag.UNENCHANTABLE)) {
                                    return new Response("\u9644\u9b54", "\u8be5\u7269\u54c1\u65e0\u6cd5\u9644\u9b54\uff01", null);
                                }
                                if (Main.game.isDebugMode() || Main.game.getPlayer().hasQuest(QuestLine.SIDE_ENCHANTMENT_DISCOVERY) && Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ENCHANTMENT_DISCOVERY)) {
                                    return new Response("\u9644\u9b54", "\u9644\u9b54\u8be5\u7269\u54c1\u3002", EnchantmentDialogue.ENCHANTMENT_MENU){

                                        @Override
                                        public DialogueNode getNextDialogue() {
                                            return EnchantmentDialogue.getEnchantmentMenu(item);
                                        }
                                    };
                                }
                                return new Response("\u9644\u9b54", InventoryDialogue.getEnchantmentNotDiscoveredText("items"), null);
                            }
                            if (index == 6) {
                                if (!item.isAbleToBeUsedFromInventory()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getUnableToBeUsedFromInventoryDescription(), null);
                                }
                                if (!item.isAbleToBeUsedWhileTrading()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getUnableToBeUsedWhileTradingDescription(), null);
                                }
                                if (!item.isAbleToBeUsed(Main.game.getPlayer(), Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u81ea\u5df1)", item.getUnableToBeUsedDescription(Main.game.getPlayer(), Main.game.getPlayer()), null);
                                }
                                if (item.isBreakOutOfInventory()) {
                                    return new ResponseEffectsOnly(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(owner, owner)){

                                        @Override
                                        public void effects() {
                                            Main.game.getPlayer().useItem(item, Main.game.getPlayer(), false);
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(owner, owner), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().useItem(item, Main.game.getPlayer(), false) + "</p>");
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            if (index == 7) {
                                if (!item.isAbleToBeUsedFromInventory()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", item.getUnableToBeUsedFromInventoryDescription(), null);
                                }
                                if (!item.isAbleToBeUsedWhileTrading()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", item.getUnableToBeUsedWhileTradingDescription(), null);
                                }
                                if (!item.isAbleToBeUsed(Main.game.getPlayer(), Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " \u6240\u6709(\u81ea\u5df1)", item.getUnableToBeUsedDescription(Main.game.getPlayer(), Main.game.getPlayer()), null);
                                }
                                if (item.isBreakOutOfInventory()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", "\u7531\u4e8e\u8be5\u7269\u54c1\u5177\u6709\u7279\u6b8a\u6548\u679c\uff0c\u4f60\u4e00\u6b21\u53ea\u80fd\u4f7f\u7528\u4e00\u4e2a\uff01", null);
                                }
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(owner, owner) + "<br/>[style.italicsMinorGood(\u91cd\u590d\u8be5\u52a8\u4f5c\u76f4\u5230\u7528\u5149\u7269\u54c1\u680f\u4e2d\u7684\u6240\u6709" + item.getNamePlural() + "\u3002)]", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        int itemCount = Main.game.getPlayer().getItemCount(item);
                                        for (int i = 0; i < itemCount; ++i) {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().useItem(item, Main.game.getPlayer(), false) + "</p>");
                                        }
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            if (index == 9) {
                                return InventoryDialogue.getBuybackResponse();
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index == 11) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u4e0d\u60f3\u4f7f\u7528\u4f60\u7684\u7269\u54c1\u3002", new ParserTag[0]), null);
                            }
                            if (index == 12) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "\u6240\u6709([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u4e0d\u60f3\u4f7f\u7528\u4f60\u7684\u7269\u54c1\u3002", new ParserTag[0]), null);
                            }
                            return null;
                        }
                    }
                } else {
                    if (inventoryNPC == null) {
                        boolean inventoryFull = Main.game.getPlayer().isInventoryFull() && !Main.game.getPlayer().hasItem(item) && item.getRarity() != Rarity.QUEST;
                        switch (interactionType) {
                            case SEX: {
                                if (index == 1) {
                                    return new Response("\u62ff\u53d6(1)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u62ff\u8d77\u7269\u54c1\u3002", null);
                                }
                                if (index == 2) {
                                    return new Response("\u62ff\u53d6(5)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u62ff\u8d77\u7269\u54c1\u3002", null);
                                }
                                if (index == 3) {
                                    return new Response("\u62ff\u53d6(\u6240\u6709)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u62ff\u8d77\u7269\u54c1\u3002", null);
                                }
                                if (index == 5) {
                                    return new Response("\u9644\u9b54", "\u81ea\u6170\u65f6\u65e0\u6cd5\u9644\u9b54\u7269\u54c1\u3002", null);
                                }
                                if (index == 6) {
                                    if (Main.sex.isCharacterImmobilised(Main.game.getPlayer())) {
                                        return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", "\u4f60\u5f53\u524d\u5904\u4e8e[style.colourTerrible(\u65e0\u6cd5\u884c\u52a8)]\u72b6\u6001\uff0c\u65e0\u6cd5\u4f7f\u7528\u6b64\u7269\u54c1\uff01", null);
                                    }
                                    if (!Main.sex.isItemUseAvailable()) {
                                        return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", "\u8be5\u6027\u4ea4\u573a\u666f\u4e2d\u65e0\u6cd5\u4f7f\u7528\u7269\u54c1\uff01", null);
                                    }
                                    if (!item.isAbleToBeUsedInSex()) {
                                        return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", "\u505a\u7231\u7684\u65f6\u5019\u4e0d\u80fd\u7528\u8fd9\u4e2a\uff01", null);
                                    }
                                    if (!item.isAbleToBeUsedFromInventory()) {
                                        return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getUnableToBeUsedFromInventoryDescription(), null);
                                    }
                                    if (!item.isAbleToBeUsed(Main.game.getPlayer(), Main.game.getPlayer())) {
                                        return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u81ea\u5df1)", item.getUnableToBeUsedDescription(Main.game.getPlayer(), Main.game.getPlayer()), null);
                                    }
                                    if (item.isBreakOutOfInventory()) {
                                        return new ResponseEffectsOnly(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(Main.game.getPlayer(), Main.game.getPlayer())){

                                            @Override
                                            public void effects() {
                                                Main.game.getPlayer().useItem(item, Main.game.getPlayer(), true);
                                                InventoryDialogue.resetPostAction();
                                            }
                                        };
                                    }
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(Main.game.getPlayer(), Main.game.getPlayer()), Main.sex.SEX_DIALOGUE){

                                        @Override
                                        public void effects() {
                                            Main.sex.setUsingItemText(Main.game.getPlayer().useItem(item, Main.game.getPlayer(), true));
                                            InventoryDialogue.resetPostAction();
                                            Main.mainController.openInventory();
                                            Main.sex.endSexTurn(SexActionUtility.PLAYER_USE_ITEM);
                                            Main.sex.setSexStarted(true);
                                        }
                                    };
                                }
                                if (index == 7) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", "\u4f60\u5728\u505a\u7231\u8fc7\u7a0b\u4e2d\u53ea\u80fd\u7528\u4e00\u4e2a\uff01", null);
                                }
                                if (index == 10) {
                                    return InventoryDialogue.getQuickTradeResponse();
                                }
                                return null;
                            }
                        }
                        if (index == 1) {
                            if (inventoryFull) {
                                return new Response("\u62ff\u53d6(1)", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                            }
                            return new Response("\u62ff\u53d6(1)", "\u4ece\u5730\u4e0a\u62ff\u53d6\u4e00\u4e2a" + item.getName() + "\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    InventoryDialogue.pickUpItems(Main.game.getPlayer(), item, 1);
                                }
                            };
                        }
                        if (index == 2) {
                            if (inventoryFull) {
                                return new Response("\u62ff\u53d6(5)", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                            }
                            if (Main.game.getPlayerCell().getInventory().getItemCount(item) >= 5) {
                                return new Response("\u62ff\u53d6(5)", "\u4ece\u5730\u4e0a\u62ff\u53d6\u4e94\u4e2a" + item.getNamePlural() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.pickUpItems(Main.game.getPlayer(), item, 5);
                                    }
                                };
                            }
                            return new Response("\u62ff\u53d6(5)", "\u5730\u4e0a\u4e0d\u8db3\u4e94\u4e2a" + item.getNamePlural() + "\uff01", null);
                        }
                        if (index == 3) {
                            if (inventoryFull) {
                                return new Response("\u62ff\u53d6(\u6240\u6709)", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                            }
                            return new Response("\u62ff\u53d6(\u6240\u6709)", "\u4ece\u5730\u4e0a\u62ff\u53d6\u6240\u6709" + item.getNamePlural() + "\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    InventoryDialogue.pickUpItems(Main.game.getPlayer(), item, Main.game.getPlayerCell().getInventory().getItemCount(item));
                                }
                            };
                        }
                        if (index == 5) {
                            return new Response("\u9644\u9b54", "\u65e0\u6cd5\u9644\u9b54\u5728\u5730\u4e0a\u7684\u7269\u54c1\uff01", null);
                        }
                        if (index == 6) {
                            if (!item.isAbleToBeUsedFromInventory()) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getUnableToBeUsedFromInventoryDescription(), null);
                            }
                            if (!item.isAbleToBeUsed(Main.game.getPlayer(), Main.game.getPlayer())) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u81ea\u5df1)", item.getUnableToBeUsedDescription(Main.game.getPlayer(), Main.game.getPlayer()), null);
                            }
                            if (item.isBreakOutOfInventory()) {
                                return new ResponseEffectsOnly(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(Main.game.getPlayer(), Main.game.getPlayer())){

                                    @Override
                                    public void effects() {
                                        Main.game.getPlayer().useItem(item, Main.game.getPlayer(), true);
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(Main.game.getPlayer(), Main.game.getPlayer()), INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().useItem(item, Main.game.getPlayer(), true) + "</p>");
                                    InventoryDialogue.resetPostAction();
                                }
                            };
                        }
                        if (index == 7) {
                            if (!item.isAbleToBeUsedFromInventory()) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", item.getUnableToBeUsedFromInventoryDescription(), null);
                            }
                            if (!item.isAbleToBeUsed(Main.game.getPlayer(), Main.game.getPlayer())) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " \u6240\u6709(\u81ea\u5df1)", item.getUnableToBeUsedDescription(Main.game.getPlayer(), Main.game.getPlayer()), null);
                            }
                            if (item.isBreakOutOfInventory()) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", "\u7531\u4e8e\u8be5\u7269\u54c1\u5177\u6709\u7279\u6b8a\u6548\u679c\uff0c\u4f60\u4e00\u6b21\u53ea\u80fd\u4f7f\u7528\u4e00\u4e2a\uff01", null);
                            }
                            return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(Main.game.getPlayer(), Main.game.getPlayer()) + "<br/>[style.italicsMinorGood(\u91cd\u590d\u8be5\u52a8\u4f5c\u76f4\u5230\u7528\u5149\u8be5\u533a\u57df\u4e2d\u7684\u6240\u6709" + item.getNamePlural() + "\u3002)]", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    int itemCount = Main.game.getPlayerCell().getInventory().getItemCount(item);
                                    for (int i = 0; i < itemCount; ++i) {
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().useItem(item, Main.game.getPlayer(), true) + "</p>");
                                    }
                                    InventoryDialogue.resetPostAction();
                                }
                            };
                        }
                        if (index == 10) {
                            return InventoryDialogue.getQuickTradeResponse();
                        }
                        return null;
                    }
                    boolean inventoryFull = false;
                    switch (interactionType) {
                        case COMBAT: {
                            if (index == 1) {
                                return new Response("\u62ff\u53d6(1)", "\u4f60\u4e0d\u80fd\u5728\u548c\u4eba\u6218\u6597\u7684\u65f6\u5019\u62ff\u4ed6\u4eec\u7684\u4e1c\u897f\uff01", null);
                            }
                            if (index == 2) {
                                return new Response("\u62ff\u53d6(5)", "\u4f60\u4e0d\u80fd\u5728\u548c\u4eba\u6218\u6597\u7684\u65f6\u5019\u62ff\u4ed6\u4eec\u7684\u4e1c\u897f\uff01", null);
                            }
                            if (index == 3) {
                                return new Response("\u62ff\u53d6(\u6240\u6709)", "\u4f60\u4e0d\u80fd\u5728\u548c\u4eba\u6218\u6597\u7684\u65f6\u5019\u62ff\u4ed6\u4eec\u7684\u4e1c\u897f\uff01", null);
                            }
                            if (index == 5) {
                                return new Response("\u9644\u9b54", "\u65e0\u6cd5\u9644\u9b54\u5176\u4ed6\u4eba\u7684\u7269\u54c1\uff0c\u5c24\u5176\u662f\u5728\u6218\u6597\u8fc7\u7a0b\u4e2d\uff01", null);
                            }
                            if (index == 6) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", "\u4f60\u4e0d\u80fd\u5728\u548c\u4eba\u6253\u67b6\u7684\u540c\u65f6\u7528\u4ed6\u4eec\u7684\u4e1c\u897f\uff01", null);
                            }
                            if (index == 7) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", "\u4f60\u4e0d\u80fd\u5728\u548c\u4eba\u6253\u67b6\u7684\u540c\u65f6\u7528\u4ed6\u4eec\u7684\u4e1c\u897f\uff01", null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index == 11) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u654c\u4eba)", "\u4f60\u4e0d\u80fd\u5728\u548c\u4eba\u6253\u67b6\u7684\u540c\u65f6\u8ba9\u4ed6\u4eec\u4f7f\u7528\u4e1c\u897f\uff01", null);
                            }
                            if (index == 12) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u654c\u4eba)", "\u4f60\u4e0d\u80fd\u5728\u548c\u4eba\u6253\u67b6\u7684\u540c\u65f6\u8ba9\u4ed6\u4eec\u4f7f\u7528\u4e1c\u897f\uff01", null);
                            }
                            return null;
                        }
                        case FULL_MANAGEMENT: 
                        case CHARACTER_CREATION: {
                            boolean bl = inventoryFull = Main.game.getPlayer().isInventoryFull() && !Main.game.getPlayer().hasItem(item) && item.getRarity() != Rarity.QUEST;
                            if (index == 1) {
                                if (inventoryFull) {
                                    return new Response("\u62ff\u53d6(1)", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                                }
                                return new Response("\u62ff\u53d6(1)", UtilText.parse((GameCharacter)inventoryNPC, "\u4ece[npc.name]\u90a3\u91cc\u62ff\u53d6\u4e00\u4e2a" + item.getName() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.transferItems(inventoryNPC, Main.game.getPlayer(), item, 1);
                                    }
                                };
                            }
                            if (index == 2) {
                                if (inventoryFull) {
                                    return new Response("\u62ff\u53d6(5)", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                                }
                                if (inventoryNPC.getItemCount(item) >= 5) {
                                    return new Response("\u62ff\u53d6(5)", UtilText.parse((GameCharacter)inventoryNPC, "\u4ece[npc.namePos]\u90a3\u513f\u62ff\u8d70\u4e94\u4e2a" + item.getNamePlural() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.transferItems(inventoryNPC, Main.game.getPlayer(), item, 5);
                                        }
                                    };
                                }
                                return new Response("\u62ff\u53d6(5)", UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u6ca1\u67095\u4e2a" + item.getNamePlural() + "\uff01", new ParserTag[0]), null);
                            }
                            if (index == 3) {
                                if (inventoryFull) {
                                    return new Response("\u62ff\u53d6(\u6240\u6709)", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                                }
                                return new Response("\u62ff\u53d6(\u6240\u6709)", UtilText.parse((GameCharacter)inventoryNPC, "\u4ece[npc.namePos]\u90a3\u62ff\u8d70\u6240\u6709\u7684" + item.getNamePlural() + "(" + Util.intToString(inventoryNPC.getItemCount(item)) + "\u4e2a)\u3002", new ParserTag[0]), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.transferItems(inventoryNPC, Main.game.getPlayer(), item, inventoryNPC.getItemCount(item));
                                    }
                                };
                            }
                            if (index == 5) {
                                return new Response("\u9644\u9b54", "\u65e0\u6cd5\u9644\u9b54\u7531\u5176\u4ed6\u4eba\u62e5\u6709\u7684\u7269\u54c1\uff01", null);
                            }
                            if (index == 6) {
                                if (!item.isAbleToBeUsedFromInventory()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getUnableToBeUsedFromInventoryDescription(), null);
                                }
                                if (!item.isAbleToBeUsed(Main.game.getPlayer(), Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u81ea\u5df1)", item.getUnableToBeUsedDescription(Main.game.getPlayer(), Main.game.getPlayer()), null);
                                }
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(Main.game.getPlayer(), Main.game.getPlayer()), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().useItem(item, Main.game.getPlayer(), false, false, false) + "</p>");
                                        if (item.isConsumedOnUse()) {
                                            inventoryNPC.getInventory().removeItem(item);
                                        }
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            if (index == 7) {
                                if (!item.isAbleToBeUsedFromInventory()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", item.getUnableToBeUsedFromInventoryDescription(), null);
                                }
                                if (!item.isAbleToBeUsed(Main.game.getPlayer(), Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " \u6240\u6709(\u81ea\u5df1)", item.getUnableToBeUsedDescription(Main.game.getPlayer(), Main.game.getPlayer()), null);
                                }
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", item.getItemType().getUseTooltipDescription(Main.game.getPlayer(), Main.game.getPlayer()) + "<br/>[style.italicsMinorGood(\u91cd\u590d\u8be5\u52a8\u4f5c\u76f4\u5230\u7528\u5149[npc.namePos]\u7269\u54c1\u680f\u4e2d\u7684\u6240\u6709" + item.getNamePlural() + "\u3002)]", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        int itemCount = inventoryNPC.getItemCount(item);
                                        for (int i = 0; i < itemCount; ++i) {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().useItem(item, Main.game.getPlayer(), false, false, false) + "</p>");
                                        }
                                        if (item.isConsumedOnUse()) {
                                            inventoryNPC.getInventory().removeItem(item, itemCount);
                                        }
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index == 11) {
                                if (!item.isAbleToBeUsedFromInventory()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "([npc.HerHim])", new ParserTag[0]), item.getUnableToBeUsedFromInventoryDescription(), null);
                                }
                                if (!item.isAbleToBeUsed(Main.game.getPlayer(), inventoryNPC)) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, " ([npc.HerHim])", new ParserTag[0]), item.getUnableToBeUsedDescription(Main.game.getPlayer(), inventoryNPC), null);
                                }
                                if (item.isBreakOutOfInventory()) {
                                    return new ResponseEffectsOnly(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "([npc.HerHim])", new ParserTag[0]), item.getItemType().getUseTooltipDescription(owner, owner)){

                                        @Override
                                        public void effects() {
                                            Main.game.getPlayer().useItem(item, inventoryNPC, false);
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                if (item.getItemType().isFetishGiving()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "([npc.HerHim])", new ParserTag[0]), item.getItemType().getUseTooltipDescription(Main.game.getPlayer(), inventoryNPC), INVENTORY_MENU, Util.newArrayListOfValues(Fetish.FETISH_KINK_GIVING), Fetish.FETISH_KINK_GIVING.getAssociatedCorruptionLevel(), null, null, null){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append(inventoryNPC.getItemUseEffects(item, owner, Main.game.getPlayer(), inventoryNPC).getValue());
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                if (item.getItemType().isTransformative()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "([npc.HerHim])", new ParserTag[0]), item.getItemType().getUseTooltipDescription(Main.game.getPlayer(), inventoryNPC), INVENTORY_MENU, Util.newArrayListOfValues(Fetish.FETISH_TRANSFORMATION_GIVING), Fetish.FETISH_TRANSFORMATION_GIVING.getAssociatedCorruptionLevel(), null, null, null){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append(inventoryNPC.getItemUseEffects(item, owner, Main.game.getPlayer(), inventoryNPC).getValue());
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "([npc.HerHim])", new ParserTag[0]), item.getItemType().getUseTooltipDescription(Main.game.getPlayer(), inventoryNPC), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        Main.game.getTextEndStringBuilder().append(inventoryNPC.getItemUseEffects(item, owner, Main.game.getPlayer(), inventoryNPC).getValue());
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            if (index == 12) {
                                if (!item.isAbleToBeUsedFromInventory()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "\u6240\u6709([npc.HerHim])", new ParserTag[0]), item.getUnableToBeUsedFromInventoryDescription(), null);
                                }
                                if (!item.isAbleToBeUsed(Main.game.getPlayer(), inventoryNPC)) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "\u6240\u6709([npc.HerHim])", new ParserTag[0]), item.getUnableToBeUsedDescription(Main.game.getPlayer(), inventoryNPC), null);
                                }
                                if (item.isBreakOutOfInventory()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "\u6240\u6709([npc.HerHim])", new ParserTag[0]), "\u7531\u4e8e\u8be5\u7269\u54c1\u62e5\u6709\u7279\u6b8a\u6548\u679c\uff0c\u4f60\u4e00\u6b21\u53ea\u80fd\u4f7f\u7528\u4e00\u4e2a\uff01", null);
                                }
                                if (item.getItemType().isFetishGiving()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "\u6240\u6709([npc.HerHim])", new ParserTag[0]), item.getItemType().getUseTooltipDescription(Main.game.getPlayer(), inventoryNPC) + "<br/>[style.italicsMinorGood(\u91cd\u590d\u8be5\u52a8\u4f5c\u76f4\u5230\u7528\u5149[npc.namePos]\u7269\u54c1\u680f\u4e2d\u7684\u6240\u6709" + item.getNamePlural() + "\u3002)]", INVENTORY_MENU, Util.newArrayListOfValues(Fetish.FETISH_KINK_GIVING), Fetish.FETISH_KINK_GIVING.getAssociatedCorruptionLevel(), null, null, null){

                                        @Override
                                        public void effects() {
                                            int itemCount = inventoryNPC.getItemCount(item);
                                            for (int i = 0; i < itemCount; ++i) {
                                                Main.game.getTextEndStringBuilder().append(inventoryNPC.getItemUseEffects(item, owner, Main.game.getPlayer(), inventoryNPC).getValue());
                                            }
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                if (item.getItemType().isTransformative()) {
                                    return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "\u6240\u6709([npc.HerHim])", new ParserTag[0]), item.getItemType().getUseTooltipDescription(Main.game.getPlayer(), inventoryNPC) + "<br/>[style.italicsMinorGood(\u91cd\u590d\u8be5\u52a8\u4f5c\u76f4\u5230\u7528\u5149[npc.namePos]\u7269\u54c1\u680f\u4e2d\u7684\u6240\u6709" + item.getNamePlural() + "\u3002)]", INVENTORY_MENU, Util.newArrayListOfValues(Fetish.FETISH_TRANSFORMATION_GIVING), Fetish.FETISH_TRANSFORMATION_GIVING.getAssociatedCorruptionLevel(), null, null, null){

                                        @Override
                                        public void effects() {
                                            int itemCount = inventoryNPC.getItemCount(item);
                                            for (int i = 0; i < itemCount; ++i) {
                                                Main.game.getTextEndStringBuilder().append(inventoryNPC.getItemUseEffects(item, owner, Main.game.getPlayer(), inventoryNPC).getValue());
                                            }
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "\u6240\u6709([npc.HerHim])", new ParserTag[0]), item.getItemType().getUseTooltipDescription(Main.game.getPlayer(), inventoryNPC) + "<br/>[style.italicsMinorGood(\u91cd\u590d\u8be5\u52a8\u4f5c\u76f4\u5230\u7528\u5149[npc.namePos]\u7269\u54c1\u680f\u4e2d\u7684\u6240\u6709" + item.getNamePlural() + "\u3002)]", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        int itemCount = inventoryNPC.getItemCount(item);
                                        for (int i = 0; i < itemCount; ++i) {
                                            Main.game.getTextEndStringBuilder().append(inventoryNPC.getItemUseEffects(item, owner, Main.game.getPlayer(), inventoryNPC).getValue());
                                        }
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            return null;
                        }
                        case SEX: {
                            if (index == 1) {
                                return new Response("\u62ff\u53d6(1)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u62ff\u8d70\u4ed6\u4eba\u7269\u54c1\uff01", null);
                            }
                            if (index == 2) {
                                return new Response("\u62ff\u53d6(5)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u62ff\u8d70\u4ed6\u4eba\u7269\u54c1\uff01", null);
                            }
                            if (index == 3) {
                                return new Response("\u62ff\u53d6(\u6240\u6709)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u62ff\u8d70\u4ed6\u4eba\u7269\u54c1\uff01", null);
                            }
                            if (index == 5) {
                                return new Response("\u9644\u9b54", "\u65e0\u6cd5\u9644\u9b54\u5176\u4ed6\u4eba\u7684\u7269\u54c1\uff0c\u5c24\u5176\u662f\u5728\u6027\u4ea4\u8fc7\u7a0b\u4e2d\uff01", null);
                            }
                            if (index == 6) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u4f7f\u7528\u5bf9\u8c61\u7684\u7269\u54c1\uff01", null);
                            }
                            if (index == 7) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e00\u6b21\u53ea\u80fd\u4f7f\u7528\u4e00\u4efd\u7269\u54c1\uff01", null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index == 11) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " (\u5bf9\u8c61)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u4f7f\u7528\u5bf9\u8c61\u7684\u7269\u54c1\uff01", null);
                            }
                            if (index == 12) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + " \u6240\u6709(\u5bf9\u8c61)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e00\u6b21\u53ea\u80fd\u4f7f\u7528\u4e00\u4efd\u7269\u54c1\uff01", null);
                            }
                            return null;
                        }
                        case TRADING: {
                            boolean bl = inventoryFull = Main.game.getPlayer().isInventoryFull() && !Main.game.getPlayer().hasItem(item) && item.getRarity() != Rarity.QUEST;
                            if (index == 1) {
                                int sellPrice;
                                int n = sellPrice = buyback ? ((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).getPrice() : item.getPrice(inventoryNPC.getSellModifier(item));
                                if (inventoryFull) {
                                    return new Response("\u8d2d\u4e70(1) (" + UtilText.formatAsMoneyUncoloured(sellPrice, "span") + ")", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                                }
                                if (Main.game.getPlayer().getMoney() < (long)sellPrice) {
                                    return new Response("\u8d2d\u4e70(1) (" + UtilText.formatAsMoneyUncoloured(sellPrice, "span") + ")", "\u4f60\u4e70\u4e0d\u8d77\u8fd9\u4e2a\uff01", null);
                                }
                                return new Response("\u8d2d\u4e70(1) (" + UtilText.formatAsMoney(sellPrice, "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice) + "\u7684\u4ef7\u683c\u8d2d\u4e70" + item.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.sellItems(inventoryNPC, Main.game.getPlayer(), item, 1, sellPrice);
                                    }
                                };
                            }
                            if (index == 2) {
                                int sellPrice;
                                int n = sellPrice = buyback ? ((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).getPrice() : item.getPrice(inventoryNPC.getSellModifier(item));
                                if (buyback && ((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).getCount() < 5 || !buyback && inventoryNPC.getItemCount(item) < 5) {
                                    return new Response("\u8d2d\u4e70(5) (" + UtilText.formatAsMoneyUncoloured(sellPrice * 5, "span") + ")", UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u6ca1\u6709\u4e94\u4e2a" + item.getNamePlural() + "\u3002", new ParserTag[0]), null);
                                }
                                if (inventoryFull) {
                                    return new Response("\u8d2d\u4e70(5) (" + UtilText.formatAsMoneyUncoloured(sellPrice * 5, "span") + ")", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                                }
                                if (Main.game.getPlayer().getMoney() < (long)(sellPrice * 5)) {
                                    return new Response("\u8d2d\u4e70(5) (" + UtilText.formatAsMoneyUncoloured(sellPrice * 5, "span") + ")", "\u4f60\u4e70\u4e0d\u8d77\u8fd9\u4e2a\uff01", null);
                                }
                                return new Response("\u8d2d\u4e70(5) (" + UtilText.formatAsMoney(sellPrice * 5, "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice * 5) + "\u7684\u4ef7\u683c\u4e70\u4e0b" + item.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.sellItems(inventoryNPC, Main.game.getPlayer(), item, 5, sellPrice);
                                    }
                                };
                            }
                            if (index == 3) {
                                int count;
                                final int sellPrice = buyback ? ((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).getPrice() : item.getPrice(inventoryNPC.getSellModifier(item));
                                int n = count = buyback ? ((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).getCount() : inventoryNPC.getItemCount(item);
                                if (inventoryFull) {
                                    return new Response("\u8d2d\u4e70(\u6240\u6709) (" + UtilText.formatAsMoneyUncoloured(sellPrice * count, "span") + ")", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                                }
                                if (Main.game.getPlayer().getMoney() < (long)(sellPrice * count)) {
                                    final int affordableCount = (int)(Main.game.getPlayer().getMoney() / (long)sellPrice);
                                    if (affordableCount > 0) {
                                        return new Response("\u8d2d\u4e70(Max " + affordableCount + ") (" + UtilText.formatAsMoney(sellPrice * affordableCount, "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice * affordableCount) + "\u7684\u4ef7\u683c\u8d2d\u4e70" + item.getName() + "\u3002", INVENTORY_MENU){

                                            @Override
                                            public void effects() {
                                                InventoryDialogue.sellItems(inventoryNPC, Main.game.getPlayer(), item, affordableCount, sellPrice);
                                            }
                                        };
                                    }
                                    return new Response("\u8d2d\u4e70(\u6240\u6709) (" + UtilText.formatAsMoneyUncoloured(sellPrice * count, "span") + ")", "\u4f60\u4e70\u4e0d\u8d77\u8fd9\u4e2a\uff01", null);
                                }
                                return new Response("\u8d2d\u4e70(\u6240\u6709) (" + UtilText.formatAsMoney(sellPrice * count, "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice * count) + "\u7684\u4ef7\u683c\u8d2d\u4e70" + item.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.sellItems(inventoryNPC, Main.game.getPlayer(), item, count, sellPrice);
                                    }
                                };
                            }
                            if (index == 5) {
                                return new Response("\u9644\u9b54", "\u65e0\u6cd5\u9644\u9b54\u7531\u5176\u4ed6\u4eba\u62e5\u6709\u7684\u7269\u54c1\uff01", null);
                            }
                            if (index == 6) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "(\u81ea\u5df1)", UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u4e0d\u5141\u8bb8\u4f60\u4f7f\u7528[npc.her]\u7684\u7269\u54c1\uff0c\u9664\u975e\u4f60\u5148\u4e70\u4e0b\u3002", new ParserTag[0]), null);
                            }
                            if (index == 7) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + "\u6240\u6709(\u81ea\u5df1)", UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u4e0d\u5141\u8bb8\u4f60\u4f7f\u7528[npc.her]\u7684\u7269\u54c1\uff0c\u9664\u975e\u4f60\u5148\u4e70\u4e0b\u3002", new ParserTag[0]), null);
                            }
                            if (index == 9) {
                                return InventoryDialogue.getBuybackResponse();
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index == 11) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u4e0d\u5141\u8bb8\u4f60\u4f7f\u7528[npc.sheIs]\u51c6\u5907\u552e\u5356\u7684\u7269\u54c1\uff01", new ParserTag[0]), null);
                            }
                            if (index == 12) {
                                return new Response(Util.capitaliseSentence(item.getItemType().getUseName()) + UtilText.parse((GameCharacter)inventoryNPC, "\u6240\u6709([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u4e0d\u5141\u8bb8\u4f60\u4f7f\u7528[npc.sheIs]\u51c6\u5907\u552e\u5356\u7684\u7269\u54c1\uff01", new ParserTag[0]), null);
                            }
                            return null;
                        }
                    }
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.INVENTORY;
            }
        };
        WEAPON_INVENTORY = new DialogueNode("\u6b66\u5668", "", true){

            @Override
            public String getLabel() {
                if (Main.game.getDialogueFlags().values.contains(DialogueFlagValue.quickTrade) && !Main.game.isInSex() && !Main.game.isInCombat()) {
                    return "\u7269\u54c1\u680f(\u5feb\u901f\u7ba1\u7406\u5f53\u524d<b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u5f00\u542f</b>)";
                }
                return "\u7269\u54c1\u680f";
            }

            @Override
            public String getHeaderContent() {
                return InventoryDialogue.inventoryView();
            }

            @Override
            public String getContent() {
                StringBuilder sb = new StringBuilder();
                List<String> extraDescriptions = weapon.getExtraDescriptions(owner);
                if (!extraDescriptions.isEmpty()) {
                    sb.append("<p>");
                    for (int i = 0; i < extraDescriptions.size(); ++i) {
                        sb.append(extraDescriptions.get(i));
                        if (i >= extraDescriptions.size() - 1) continue;
                        sb.append("<br/>");
                    }
                    sb.append("</p>");
                }
                return InventoryDialogue.getItemDisplayPanel(weapon, weapon.getSVGString(), Util.capitaliseSentence(weapon.getDisplayName(true)), weapon.getDescription(owner) + sb.toString() + (String)(owner != null && owner.isPlayer() ? (inventoryNPC != null && interactionType == InventoryInteraction.TRADING ? "<p>" + (inventoryNPC.willBuy(weapon) ? inventoryNPC.getName("") + "\u4f1a\u4ee5" + UtilText.formatAsMoney(weapon.getPrice(inventoryNPC.getBuyModifier())) + "\u7684\u4ef7\u683c\u4e70\u5165\u3002" : inventoryNPC.getName("") + "\u5e76\u4e0d\u60f3\u4e70\u8fd9\u4e2a\u3002") + "</p>" : "") : (inventoryNPC != null && interactionType == InventoryInteraction.TRADING ? "<p>" + inventoryNPC.getName("") + "\u4f1a\u4ee5" + UtilText.formatAsMoney(weapon.getPrice(inventoryNPC.getSellModifier(weapon))) + "\u7684\u4ef7\u683c\u5356\u51fa\u3002</p>" : "")));
            }

            @Override
            public String getResponseTabTitle(int index) {
                return InventoryDialogue.getGeneralResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 0) {
                    return InventoryDialogue.getCloseInventoryResponse();
                }
                if (Main.game.isBadEnd()) {
                    if (index == 1) {
                        return new Response("\u4e0d\u53ef\u7528", "\u5728\u574f\u7ed3\u5c40\u65f6\u65e0\u6cd5\u64cd\u4f5c\u7269\u54c1\u680f\u2026\u2026", null);
                    }
                    return null;
                }
                if (responseTab == 0) {
                    return INVENTORY_MENU.getResponse(responseTab, index);
                }
                if (owner != null && owner.isPlayer()) {
                    if (inventoryNPC == null) {
                        boolean areaFull = Main.game.isPlayerTileFull() && !Main.game.getPlayerCell().getInventory().hasWeapon(weapon);
                        switch (interactionType) {
                            case SEX: {
                                String dropTitle;
                                String string = dropTitle = owner.getLocationPlace().isItemsDisappear() ? "\u4e22\u5f03" : "\u5b58\u50a8";
                                if (index == 1) {
                                    return new Response(dropTitle + "(1)", "\u4f60\u65e0\u6cd5\u5728\u81ea\u6170\u65f6\u4e22\u5f03\u4f60\u7684\u6b66\u5668\u3002", null);
                                }
                                if (index == 2) {
                                    return new Response(dropTitle + "(5)", "\u4f60\u65e0\u6cd5\u5728\u81ea\u6170\u65f6\u4e22\u5f03\u4f60\u7684\u6b66\u5668\u3002", null);
                                }
                                if (index == 3) {
                                    return new Response(dropTitle + "(\u6240\u6709)", "\u4f60\u65e0\u6cd5\u5728\u81ea\u6170\u65f6\u4e22\u5f03\u4f60\u7684\u6b66\u5668\u3002", null);
                                }
                                if (index == 4) {
                                    return new Response("\u67d3\u8272/\u91cd\u94f8", "\u4f60\u65e0\u6cd5\u5728\u81ea\u6170\u65f6\u67d3\u8272\u6216\u91cd\u94f8\u4f60\u7684\u6b66\u5668\u3002", null);
                                }
                                if (index == 5) {
                                    return new Response("\u9644\u9b54", "\u81ea\u6170\u65f6\u65e0\u6cd5\u9644\u9b54\u6b66\u5668\u3002", null);
                                }
                                if (index == 6) {
                                    return new Response("\u4e3b\u624b\u88c5\u5907(\u81ea\u5df1)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u88c5\u5907\u6b66\u5668\u3002", null);
                                }
                                if (index == 7) {
                                    return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u88c5\u5907\u6b66\u5668\u3002", null);
                                }
                                if (index == 10) {
                                    return InventoryDialogue.getQuickTradeResponse();
                                }
                                return null;
                            }
                        }
                        if (index == 1) {
                            if (owner.getLocationPlace().isItemsDisappear()) {
                                if (!weapon.getWeaponType().isAbleToBeDropped()) {
                                    return new Response("\u4e22\u5f03(1)", "\u65e0\u6cd5\u4e22\u5f03" + weapon.getName() + "\uff01", null);
                                }
                                if (areaFull) {
                                    return new Response("\u4e22\u5f03(1)", "\u8be5\u533a\u57df\u5df2\u7ecf\u6ee1\u4e86\uff0c\u6240\u4ee5\u65e0\u6cd5\u4e22\u5f03" + weapon.getName() + "\uff01", null);
                                }
                                return new Response("\u4e22\u5f03(1)", "\u4e22\u5f03" + weapon.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.dropWeapons(owner, weapon, 1);
                                    }
                                };
                            }
                            if (!weapon.getWeaponType().isAbleToBeDropped()) {
                                return new Response("\u5b58\u50a8(1)", "\u4f60\u65e0\u6cd5\u5b58\u50a8" + weapon.getName() + "\uff01", null);
                            }
                            if (areaFull) {
                                return new Response("\u5b58\u50a8(1)", "\u5b58\u50a8" + weapon.getName() + "\uff01", null);
                            }
                            return new Response("\u5b58\u50a8(1)", "\u5b58\u50a8" + weapon.getName() + "\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    InventoryDialogue.dropWeapons(owner, weapon, 1);
                                }
                            };
                        }
                        if (index == 2) {
                            if (owner.getLocationPlace().isItemsDisappear()) {
                                if (!weapon.getWeaponType().isAbleToBeDropped()) {
                                    return new Response("\u4e22\u5f03(5)", "\u65e0\u6cd5\u4e22\u5f03" + weapon.getName() + "\uff01", null);
                                }
                                if (owner.getWeaponCount(weapon) < 5) {
                                    return new Response("\u4e22\u5f03(5)", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u4e94\u4e2a" + weapon.getNamePlural() + "\uff01", null);
                                }
                                if (areaFull) {
                                    return new Response("\u4e22\u5f03(5)", "\u8be5\u533a\u57df\u5df2\u7ecf\u6ee1\u4e86\uff0c\u6240\u4ee5\u65e0\u6cd5\u4e22\u5f03" + weapon.getNamePlural() + "\uff01", null);
                                }
                                return new Response("\u4e22\u5f03(5)", "\u4e22\u5f03\u4e94\u4e2a" + weapon.getNamePlural() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.dropWeapons(owner, weapon, 5);
                                    }
                                };
                            }
                            if (!weapon.getWeaponType().isAbleToBeDropped()) {
                                return new Response("\u5b58\u50a8(5)", "\u4f60\u65e0\u6cd5\u5b58\u50a8" + weapon.getName() + "\uff01", null);
                            }
                            if (owner.getWeaponCount(weapon) < 5) {
                                return new Response("\u5b58\u50a8(5)", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u4e94\u4e2a" + weapon.getNamePlural() + "\uff01", null);
                            }
                            if (areaFull) {
                                return new Response("\u5b58\u50a8(5)", "\u5b58\u50a8" + weapon.getNamePlural() + "\uff01", null);
                            }
                            return new Response("\u5b58\u50a8(5)", "\u5b58\u50a8\u4e94\u4e2a" + weapon.getNamePlural() + "\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    InventoryDialogue.dropWeapons(owner, weapon, 5);
                                }
                            };
                        }
                        if (index == 3) {
                            if (!weapon.getWeaponType().isAbleToBeDropped()) {
                                return new Response("\u4e22\u5f03(\u6240\u6709)", "\u65e0\u6cd5\u4e22\u5f03" + weapon.getName() + "\uff01", null);
                            }
                            if (owner.getLocationPlace().isItemsDisappear()) {
                                if (areaFull) {
                                    return new Response("\u4e22\u5f03(\u6240\u6709)", "\u8be5\u533a\u57df\u5df2\u7ecf\u6ee1\u4e86\uff0c\u6240\u4ee5\u65e0\u6cd5\u4e22\u5f03" + weapon.getNamePlural() + "\uff01", null);
                                }
                                return new Response("\u4e22\u5f03(\u6240\u6709)", "\u4e22\u5f03\u6240\u6709\u7684" + weapon.getNamePlural() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.dropWeapons(owner, weapon, owner.getWeaponCount(weapon));
                                    }
                                };
                            }
                            if (!weapon.getWeaponType().isAbleToBeDropped()) {
                                return new Response("\u5b58\u50a8(\u6240\u6709)", "\u4f60\u65e0\u6cd5\u5b58\u50a8" + weapon.getName() + "\uff01", null);
                            }
                            if (areaFull) {
                                return new Response("\u5b58\u50a8(\u6240\u6709)", "\u5b58\u50a8" + weapon.getNamePlural() + "\uff01", null);
                            }
                            return new Response("\u5b58\u50a8(\u6240\u6709)", "\u5b58\u50a8\u6240\u6709\u7684" + weapon.getNamePlural() + "\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    InventoryDialogue.dropWeapons(owner, weapon, owner.getWeaponCount(weapon));
                                }
                            };
                        }
                        if (index == 4) {
                            if (InventoryDialogue.isWeaponDyeReforgeActionAvailable()) {
                                boolean canDye;
                                boolean hasFullInventory = Main.game.getPlayer().isInventoryFull() && weapon.getRarity() != Rarity.QUEST;
                                boolean isDyeingStackItem = Main.game.getPlayer().getAllWeaponsInInventory().get(weapon) > 1;
                                boolean bl = canDye = !isDyeingStackItem || !hasFullInventory;
                                if (canDye) {
                                    return new Response("\u67d3\u8272/\u91cd\u94f8", Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u4f7f\u7528\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\u4e3a\u7269\u54c1\u67d3\u8272\u6216\u91cd\u94f8\u3002" : "\u4f7f\u7528\u67d3\u8272\u5237\u6216\u91cd\u94f8\u9524\u6765\u4fee\u6539\u8fd9\u4ef6\u6b66\u5668\u7684\u5c5e\u6027\u3002", DYE_WEAPON){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.resetWeaponDyeColours();
                                        }
                                    };
                                }
                                return new Response("\u67d3\u8272/\u91cd\u94f8", "\u4f60\u7684\u7269\u54c1\u680f\u6ee1\u4e86\uff0c\u65e0\u6cd5\u4fee\u6539\u6b66\u5668\u7684\u5c5e\u6027\u3002", null);
                            }
                            return new Response("\u67d3\u8272/\u91cd\u94f8", "\u4f60\u9700\u8981\u627e\u5230\u67d3\u8272\u5237\u6216\u91cd\u94f8\u9524\u624d\u80fd\u4fee\u6539\u8fd9\u4ef6\u6b66\u5668\u7684\u5c5e\u6027\u3002", null);
                        }
                        if (index == 5) {
                            if (weapon.getEnchantmentItemType(null) == null || weapon.getItemTags().contains((Object)ItemTag.UNENCHANTABLE)) {
                                return new Response("\u9644\u9b54", "\u8be5\u6b66\u5668\u65e0\u6cd5\u9644\u9b54\uff01", null);
                            }
                            if (Main.game.isDebugMode() || Main.game.getPlayer().hasQuest(QuestLine.SIDE_ENCHANTMENT_DISCOVERY) && Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ENCHANTMENT_DISCOVERY)) {
                                return new Response("\u9644\u9b54", "\u9644\u9b54\u8be5\u6b66\u5668\u3002", EnchantmentDialogue.ENCHANTMENT_MENU){

                                    @Override
                                    public DialogueNode getNextDialogue() {
                                        return EnchantmentDialogue.getEnchantmentMenu(weapon);
                                    }
                                };
                            }
                            return new Response("\u9644\u9b54", InventoryDialogue.getEnchantmentNotDiscoveredText("weapons"), null);
                        }
                        if (index == 6) {
                            InventorySlot slot = InventorySlot.mainWeaponSlots[Main.game.getPlayer().getMainWeaponIndexToEquipTo(weapon)];
                            if (weapon.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                return new Response("\u4e3b\u624b\u88c5\u5907(\u81ea\u5df1)", "\u88c5\u5907" + weapon.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().equipMainWeaponFromInventory(weapon, Main.game.getPlayer()) + "</p>");
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            return new Response("\u4e3b\u624b\u88c5\u5907(\u81ea\u5df1)", weapon.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                        }
                        if (index == 7) {
                            if (weapon.getWeaponType().isTwoHanded()) {
                                return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", weapon.getWeaponType().isPlural() ? "\u7531\u4e8e" + weapon.getName() + "\u9700\u8981\u53cc\u624b\u63e1\u6301\uff0c\u6240\u4ee5\u53ea\u80fd\u88ab\u88c5\u5907\u5728\u4e3b\u624b\u680f\u4f4d\uff01" : "\u7531\u4e8e" + weapon.getName() + "\u662f\u53cc\u624b\u6b66\u5668\uff0c\u53ea\u80fd\u88ab\u88c5\u5907\u5728\u4e3b\u624b\u680f\u4f4d\uff01", null);
                            }
                            InventorySlot slot = InventorySlot.offhandWeaponSlots[Main.game.getPlayer().getOffhandWeaponIndexToEquipTo(weapon)];
                            if (weapon.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", "\u88c5\u5907" + weapon.getName() + "\u3002" + (String)(weapon.getWeaponType().isTwoHanded() ? "<br/>[style.italicsGood(\u5c3d\u7ba1" + (weapon.getWeaponType().isPlural() ? "" : "") + ")]" : ""), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().equipOffhandWeaponFromInventory(weapon, Main.game.getPlayer()) + "</p>");
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", weapon.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                        }
                        if (index == 10) {
                            return InventoryDialogue.getQuickTradeResponse();
                        }
                        return null;
                    }
                    switch (interactionType) {
                        case COMBAT: {
                            if (index == 1) {
                                return new Response("\u7ed9\u4e88(1)", "\u4f60\u4e0d\u80fd\u5728\u548c\u4eba\u6218\u6597\u7684\u65f6\u5019\u7ed9\u4ed6\u4eec\u6b66\u5668\uff01", null);
                            }
                            if (index == 2) {
                                return new Response("\u7ed9\u4e88(5)", "\u4f60\u4e0d\u80fd\u5728\u548c\u4eba\u6218\u6597\u7684\u65f6\u5019\u7ed9\u4ed6\u4eec\u6b66\u5668\uff01", null);
                            }
                            if (index == 3) {
                                return new Response("\u7ed9\u4e88(\u6240\u6709)", "\u4f60\u4e0d\u80fd\u5728\u548c\u4eba\u6218\u6597\u7684\u65f6\u5019\u7ed9\u4ed6\u4eec\u6b66\u5668\uff01", null);
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u67d3\u8272\u4f60\u7684\u6b66\u5668\uff01", null);
                            }
                            if (index == 5) {
                                return new Response("\u9644\u9b54", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u9644\u9b54\u6b66\u5668\uff01", null);
                            }
                            if (index == 6) {
                                return new Response("\u4e3b\u624b\u88c5\u5907(\u81ea\u5df1)", "\u4f60\u4e0d\u80fd\u5728\u548c\u4eba\u6218\u6597\u7684\u540c\u65f6\u66f4\u6362\u6b66\u5668\uff01", null);
                            }
                            if (index == 7) {
                                return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", "\u4f60\u4e0d\u80fd\u5728\u548c\u4eba\u6218\u6597\u7684\u540c\u65f6\u66f4\u6362\u6b66\u5668\uff01", null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index == 11) {
                                return new Response("\u88c5\u5907(\u654c\u4eba)", "\u4f60\u4e0d\u80fd\u7ed9\u5bf9\u624b\u88c5\u5907\u6b66\u5668\uff01", null);
                            }
                            return null;
                        }
                        case FULL_MANAGEMENT: 
                        case CHARACTER_CREATION: {
                            boolean inventoryFull;
                            boolean bl = inventoryFull = inventoryNPC.isInventoryFull() && !inventoryNPC.hasWeapon(weapon);
                            if (index == 1) {
                                if (!weapon.getWeaponType().isAbleToBeDropped()) {
                                    return new Response("\u7ed9\u4e88(1)", "\u4f60\u65e0\u6cd5\u7ed9\u51fa" + weapon.getName() + "\uff01", null);
                                }
                                if (inventoryFull) {
                                    return new Response("\u7ed9\u4e88(1)", UtilText.parse((GameCharacter)inventoryNPC, "[npc.NamePos]\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", new ParserTag[0]), null);
                                }
                                return new Response("\u7ed9\u4e88(1)", UtilText.parse((GameCharacter)inventoryNPC, "Give [npc.name] one " + weapon.getName() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.transferWeapons(Main.game.getPlayer(), inventoryNPC, weapon, 1);
                                    }
                                };
                            }
                            if (index == 2) {
                                if (!weapon.getWeaponType().isAbleToBeDropped()) {
                                    return new Response("\u7ed9\u4e88(5)", "\u4f60\u65e0\u6cd5\u7ed9\u51fa" + weapon.getName() + "\uff01", null);
                                }
                                if (inventoryFull) {
                                    return new Response("\u7ed9\u4e88(5)", UtilText.parse((GameCharacter)inventoryNPC, "[npc.NamePos]\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", new ParserTag[0]), null);
                                }
                                if (Main.game.getPlayer().getWeaponCount(weapon) >= 5) {
                                    return new Response("\u7ed9\u4e88(5)", UtilText.parse((GameCharacter)inventoryNPC, "\u7ed9[npc.name]\u4e94\u628a" + weapon.getNamePlural() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.transferWeapons(Main.game.getPlayer(), inventoryNPC, weapon, 5);
                                        }
                                    };
                                }
                                return new Response("\u7ed9\u4e88(5)", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u4e94\u4e2a" + weapon.getNamePlural() + "\uff01", null);
                            }
                            if (index == 3) {
                                if (!weapon.getWeaponType().isAbleToBeDropped()) {
                                    return new Response("\u7ed9\u4e88(\u6240\u6709)", "\u4f60\u65e0\u6cd5\u7ed9\u51fa" + weapon.getName() + "\uff01", null);
                                }
                                if (inventoryFull) {
                                    return new Response("\u7ed9\u4e88(\u6240\u6709)", UtilText.parse((GameCharacter)inventoryNPC, "[npc.NamePos]\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", new ParserTag[0]), null);
                                }
                                return new Response("\u7ed9\u4e88(\u6240\u6709)", UtilText.parse((GameCharacter)inventoryNPC, "\u628a\u4f60\u6240\u6709\u7684" + weapon.getNamePlural() + "\u7ed9[npc.name]\u3002", new ParserTag[0]), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.transferWeapons(Main.game.getPlayer(), inventoryNPC, weapon, Main.game.getPlayer().getWeaponCount(weapon));
                                    }
                                };
                            }
                            if (index == 4) {
                                if (InventoryDialogue.isWeaponDyeReforgeActionAvailable()) {
                                    boolean canDye;
                                    boolean hasFullInventory = Main.game.getPlayer().isInventoryFull() && weapon.getRarity() != Rarity.QUEST;
                                    boolean isDyeingStackItem = Main.game.getPlayer().getAllWeaponsInInventory().get(weapon) > 1;
                                    boolean bl2 = canDye = !isDyeingStackItem || !hasFullInventory;
                                    if (canDye) {
                                        return new Response("\u67d3\u8272/\u91cd\u94f8", Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u4f7f\u7528\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\u4e3a\u7269\u54c1\u67d3\u8272\u6216\u91cd\u94f8\u3002" : "\u4f7f\u7528\u67d3\u8272\u5237\u6216\u91cd\u94f8\u9524\u6765\u4fee\u6539\u8fd9\u4ef6\u6b66\u5668\u7684\u5c5e\u6027\u3002", DYE_WEAPON){

                                            @Override
                                            public void effects() {
                                                InventoryDialogue.resetWeaponDyeColours();
                                            }
                                        };
                                    }
                                    return new Response("\u67d3\u8272/\u91cd\u94f8", "\u4f60\u7684\u7269\u54c1\u680f\u6ee1\u4e86\uff0c\u65e0\u6cd5\u4fee\u6539\u6b66\u5668\u7684\u5c5e\u6027\u3002", null);
                                }
                                return new Response("\u67d3\u8272/\u91cd\u94f8", "\u4f60\u9700\u8981\u627e\u5230\u67d3\u8272\u5237\u6216\u91cd\u94f8\u9524\u624d\u80fd\u4fee\u6539\u8fd9\u4ef6\u6b66\u5668\u7684\u5c5e\u6027\u3002", null);
                            }
                            if (index == 5) {
                                if (weapon.getEnchantmentItemType(null) == null || weapon.getItemTags().contains((Object)ItemTag.UNENCHANTABLE)) {
                                    return new Response("\u9644\u9b54", "\u8be5\u6b66\u5668\u65e0\u6cd5\u9644\u9b54\uff01", null);
                                }
                                if (Main.game.isDebugMode() || Main.game.getPlayer().hasQuest(QuestLine.SIDE_ENCHANTMENT_DISCOVERY) && Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ENCHANTMENT_DISCOVERY)) {
                                    return new Response("\u9644\u9b54", "\u9644\u9b54\u8be5\u6b66\u5668\u3002", EnchantmentDialogue.ENCHANTMENT_MENU){

                                        @Override
                                        public DialogueNode getNextDialogue() {
                                            return EnchantmentDialogue.getEnchantmentMenu(weapon);
                                        }
                                    };
                                }
                                return new Response("\u9644\u9b54", InventoryDialogue.getEnchantmentNotDiscoveredText("weapons"), null);
                            }
                            if (index == 6) {
                                InventorySlot slot = InventorySlot.mainWeaponSlots[Main.game.getPlayer().getMainWeaponIndexToEquipTo(weapon)];
                                if (weapon.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                    return new Response("\u4e3b\u624b\u88c5\u5907(\u81ea\u5df1)", "\u88c5\u5907" + weapon.getName() + "\u4e3a\u4e3b\u624b\u6b66\u5668\u3002", INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().equipMainWeaponFromInventory(weapon, Main.game.getPlayer()) + "</p>");
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                return new Response("\u4e3b\u624b\u88c5\u5907(\u81ea\u5df1)", weapon.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                            }
                            if (index == 7) {
                                if (weapon.getWeaponType().isTwoHanded()) {
                                    return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", weapon.getWeaponType().isPlural() ? "\u7531\u4e8e" + weapon.getName() + "\u9700\u8981\u53cc\u624b\u63e1\u6301\uff0c\u6240\u4ee5\u53ea\u80fd\u88ab\u88c5\u5907\u5728\u4e3b\u624b\u680f\u4f4d\uff01" : "\u7531\u4e8e" + weapon.getName() + "\u662f\u53cc\u624b\u6b66\u5668\uff0c\u53ea\u80fd\u88ab\u88c5\u5907\u5728\u4e3b\u624b\u680f\u4f4d\uff01", null);
                                }
                                InventorySlot slot = InventorySlot.offhandWeaponSlots[Main.game.getPlayer().getOffhandWeaponIndexToEquipTo(weapon)];
                                if (weapon.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                    return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", "\u88c5\u5907" + weapon.getName() + "\u4e3a\u526f\u624b\u6b66\u5668\u3002", INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().equipOffhandWeaponFromInventory(weapon, Main.game.getPlayer()) + "</p>");
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", weapon.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index == 11) {
                                InventorySlot slot = InventorySlot.mainWeaponSlots[inventoryNPC.getMainWeaponIndexToEquipTo(weapon)];
                                if (weapon.isCanBeEquipped(inventoryNPC, slot)) {
                                    return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u4e3b\u624b\u88c5\u5907([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u8ba9[npc.name]\u88c5\u5907" + weapon.getName() + "\u4e3a\u4e3b\u624b\u6b66\u5668\u3002", new ParserTag[0]), INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + inventoryNPC.equipMainWeaponFromInventory(weapon, Main.game.getPlayer()) + "</p>");
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u4e3b\u624b\u88c5\u5907([npc.HerHim])", new ParserTag[0]), weapon.getCannotBeEquippedText(inventoryNPC, slot), null);
                            }
                            if (index == 12) {
                                if (weapon.getWeaponType().isTwoHanded()) {
                                    return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u526f\u624b\u88c5\u5907([npc.HerHim])", new ParserTag[0]), weapon.getWeaponType().isPlural() ? "\u7531\u4e8e" + weapon.getName() + "\u9700\u8981\u53cc\u624b\u63e1\u6301\uff0c\u6240\u4ee5\u53ea\u80fd\u88ab\u88c5\u5907\u5728\u4e3b\u624b\u680f\u4f4d\uff01" : "\u7531\u4e8e" + weapon.getName() + "\u662f\u53cc\u624b\u6b66\u5668\uff0c\u53ea\u80fd\u88ab\u88c5\u5907\u5728\u4e3b\u624b\u680f\u4f4d\uff01", null);
                                }
                                InventorySlot slot = InventorySlot.offhandWeaponSlots[inventoryNPC.getOffhandWeaponIndexToEquipTo(weapon)];
                                if (weapon.isCanBeEquipped(inventoryNPC, slot)) {
                                    return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u526f\u624b\u88c5\u5907([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u8ba9[npc.name]\u88c5\u5907" + weapon.getName() + "\u4e3a\u526f\u624b\u6b66\u5668\u3002", new ParserTag[0]), INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + inventoryNPC.equipOffhandWeaponFromInventory(weapon, Main.game.getPlayer()) + "</p>");
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u526f\u624b\u88c5\u5907([npc.HerHim])", new ParserTag[0]), weapon.getCannotBeEquippedText(inventoryNPC, slot), null);
                            }
                            return null;
                        }
                        case SEX: {
                            if (index == 1) {
                                return new Response("\u7ed9\u4e88(1)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u7ed9\u4e88\u5bf9\u65b9\u6b66\u5668\uff01", null);
                            }
                            if (index == 2) {
                                return new Response("\u7ed9\u4e88(5)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u7ed9\u4e88\u5bf9\u65b9\u6b66\u5668\uff01", null);
                            }
                            if (index == 3) {
                                return new Response("\u7ed9\u4e88(\u6240\u6709)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u7ed9\u4e88\u5bf9\u65b9\u6b66\u5668\uff01", null);
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272", "\u4f60\u548c\u4eba\u505a\u7231\u7684\u65f6\u5019\u4e0d\u80fd\u7ed9\u6b66\u5668\u67d3\u8272\uff01", null);
                            }
                            if (index == 5) {
                                return new Response("\u9644\u9b54", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u9644\u9b54\u6b66\u5668\uff01", null);
                            }
                            if (index == 6) {
                                return new Response("\u4e3b\u624b\u88c5\u5907(\u81ea\u5df1)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u88c5\u5907\u6b66\u5668\uff01", null);
                            }
                            if (index == 7) {
                                return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u88c5\u5907\u6b66\u5668\uff01", null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index == 11) {
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907([npc.HerHim])", new ParserTag[0]), "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u88c5\u5907\u6b66\u5668\uff01", null);
                            }
                            return null;
                        }
                        case TRADING: {
                            if (index == 1) {
                                if (!weapon.getWeaponType().isAbleToBeSold()) {
                                    return new Response("\u51fa\u552e(1)", "\u4f60\u4e0d\u80fd\u51fa\u552e" + weapon.getName() + "\uff01", null);
                                }
                                if (inventoryNPC.willBuy(weapon)) {
                                    final int sellPrice = weapon.getPrice(inventoryNPC.getBuyModifier());
                                    return new Response("\u51fa\u552e(1) (" + UtilText.formatAsMoney(sellPrice, "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice) + "\u7684\u4ef7\u683c\u51fa\u552e" + weapon.getName() + "\u3002", INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.sellWeapons(Main.game.getPlayer(), inventoryNPC, weapon, 1, sellPrice);
                                        }
                                    };
                                }
                                return new Response("\u51fa\u552e(1)", inventoryNPC.getName("") + "\u4e0d\u60f3\u4e70\u8fd9\u4e2a\u3002", null);
                            }
                            if (index == 2) {
                                if (Main.game.getPlayer().getWeaponCount(weapon) >= 5) {
                                    if (!weapon.getWeaponType().isAbleToBeSold()) {
                                        return new Response("\u51fa\u552e(5)", "\u4f60\u4e0d\u80fd\u51fa\u552e" + weapon.getName() + "\uff01", null);
                                    }
                                    if (inventoryNPC.willBuy(weapon)) {
                                        final int sellPrice = weapon.getPrice(inventoryNPC.getBuyModifier());
                                        return new Response("\u51fa\u552e(5) (" + UtilText.formatAsMoney(sellPrice * 5, "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice * 5) + "\u7684\u4ef7\u683c\u51fa\u552e\u4e94\u4ef6" + weapon.getNamePlural() + "\u3002", INVENTORY_MENU){

                                            @Override
                                            public void effects() {
                                                InventoryDialogue.sellWeapons(Main.game.getPlayer(), inventoryNPC, weapon, 5, sellPrice);
                                            }
                                        };
                                    }
                                    return new Response("\u51fa\u552e(5)", inventoryNPC.getName("") + "\u4e0d\u60f3\u4e70\u8fd9\u4e9b\u3002", null);
                                }
                                return new Response("\u51fa\u552e(5)", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u4e94\u4e2a" + weapon.getNamePlural() + "\uff01", null);
                            }
                            if (index == 3) {
                                if (!weapon.getWeaponType().isAbleToBeSold()) {
                                    return new Response("\u51fa\u552e(\u6240\u6709)", "\u4f60\u4e0d\u80fd\u51fa\u552e" + weapon.getName() + "\uff01", null);
                                }
                                if (inventoryNPC.willBuy(weapon)) {
                                    final int sellPrice = weapon.getPrice(inventoryNPC.getBuyModifier());
                                    return new Response("\u51fa\u552e(\u6240\u6709) (" + UtilText.formatAsMoney(sellPrice * Main.game.getPlayer().getWeaponCount(weapon), "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice * Main.game.getPlayer().getWeaponCount(weapon)) + "\u7684\u4ef7\u683c\u51fa\u552e" + weapon.getName() + "\u3002", INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.sellWeapons(Main.game.getPlayer(), inventoryNPC, weapon, Main.game.getPlayer().getWeaponCount(weapon), sellPrice);
                                        }
                                    };
                                }
                                return new Response("\u51fa\u552e(\u6240\u6709)", inventoryNPC.getName("") + "\u4e0d\u60f3\u4e70\u8fd9\u4e9b\u3002", null);
                            }
                            if (index == 4) {
                                if (InventoryDialogue.isWeaponDyeReforgeActionAvailable()) {
                                    boolean canDye;
                                    boolean hasFullInventory = Main.game.getPlayer().isInventoryFull() && weapon.getRarity() != Rarity.QUEST;
                                    boolean isDyeingStackItem = Main.game.getPlayer().getAllWeaponsInInventory().get(weapon) > 1;
                                    boolean bl = canDye = !isDyeingStackItem || !hasFullInventory;
                                    if (canDye) {
                                        return new Response("\u67d3\u8272/\u91cd\u94f8", Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u4f7f\u7528\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\u4e3a\u7269\u54c1\u67d3\u8272\u6216\u91cd\u94f8\u3002" : "\u4f7f\u7528\u67d3\u8272\u5237\u6216\u91cd\u94f8\u9524\u6765\u4fee\u6539\u8fd9\u4ef6\u6b66\u5668\u7684\u5c5e\u6027\u3002", DYE_WEAPON){

                                            @Override
                                            public void effects() {
                                                InventoryDialogue.resetWeaponDyeColours();
                                            }
                                        };
                                    }
                                    return new Response("\u67d3\u8272/\u91cd\u94f8", "\u4f60\u7684\u7269\u54c1\u680f\u6ee1\u4e86\uff0c\u65e0\u6cd5\u4fee\u6539\u6b66\u5668\u7684\u5c5e\u6027\u3002", null);
                                }
                                return new Response("\u67d3\u8272/\u91cd\u94f8", "\u4f60\u9700\u8981\u627e\u5230\u67d3\u8272\u5237\u6216\u91cd\u94f8\u9524\u624d\u80fd\u4fee\u6539\u8fd9\u4ef6\u6b66\u5668\u7684\u5c5e\u6027\u3002", null);
                            }
                            if (index == 5) {
                                if (weapon.getEnchantmentItemType(null) == null || weapon.getItemTags().contains((Object)ItemTag.UNENCHANTABLE)) {
                                    return new Response("\u9644\u9b54", "\u8be5\u6b66\u5668\u65e0\u6cd5\u9644\u9b54\uff01", null);
                                }
                                if (Main.game.isDebugMode() || Main.game.getPlayer().hasQuest(QuestLine.SIDE_ENCHANTMENT_DISCOVERY) && Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ENCHANTMENT_DISCOVERY)) {
                                    return new Response("\u9644\u9b54", "\u9644\u9b54\u8be5\u6b66\u5668\u3002", EnchantmentDialogue.ENCHANTMENT_MENU){

                                        @Override
                                        public DialogueNode getNextDialogue() {
                                            return EnchantmentDialogue.getEnchantmentMenu(weapon);
                                        }
                                    };
                                }
                                return new Response("\u9644\u9b54", InventoryDialogue.getEnchantmentNotDiscoveredText("weapons"), null);
                            }
                            if (index == 6) {
                                InventorySlot slot = InventorySlot.mainWeaponSlots[Main.game.getPlayer().getMainWeaponIndexToEquipTo(weapon)];
                                if (weapon.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                    return new Response("\u4e3b\u624b\u88c5\u5907(\u81ea\u5df1)", "\u88c5\u5907" + weapon.getName() + "\u4e3a\u4e3b\u624b\u6b66\u5668\u3002", INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().equipMainWeaponFromInventory(weapon, Main.game.getPlayer()) + "</p>");
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                return new Response("\u4e3b\u624b\u88c5\u5907(\u81ea\u5df1)", weapon.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                            }
                            if (index == 7) {
                                if (weapon.getWeaponType().isTwoHanded()) {
                                    return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", weapon.getWeaponType().isPlural() ? "\u7531\u4e8e" + weapon.getName() + "\u9700\u8981\u53cc\u624b\u63e1\u6301\uff0c\u6240\u4ee5\u53ea\u80fd\u88ab\u88c5\u5907\u5728\u4e3b\u624b\u680f\u4f4d\uff01" : "\u7531\u4e8e" + weapon.getName() + "\u662f\u53cc\u624b\u6b66\u5668\uff0c\u53ea\u80fd\u88ab\u88c5\u5907\u5728\u4e3b\u624b\u680f\u4f4d\uff01", null);
                                }
                                InventorySlot slot = InventorySlot.offhandWeaponSlots[Main.game.getPlayer().getOffhandWeaponIndexToEquipTo(weapon)];
                                if (weapon.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                    return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", "\u88c5\u5907" + weapon.getName() + "\u4e3a\u526f\u624b\u6b66\u5668\u3002", INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().equipOffhandWeaponFromInventory(weapon, Main.game.getPlayer()) + "</p>");
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", weapon.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                            }
                            if (index == 9) {
                                return InventoryDialogue.getBuybackResponse();
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index == 11) {
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u4e3b\u624b\u88c5\u5907([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u4e0d\u60f3\u4f7f\u7528\u4f60\u7684\u6b66\u5668\u3002", new ParserTag[0]), null);
                            }
                            if (index == 12) {
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u526f\u624b\u88c5\u5907([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u4e0d\u60f3\u4f7f\u7528\u4f60\u7684\u6b66\u5668\u3002", new ParserTag[0]), null);
                            }
                            return null;
                        }
                    }
                } else {
                    if (inventoryNPC == null) {
                        boolean inventoryFull = Main.game.getPlayer().isInventoryFull() && !Main.game.getPlayer().hasWeapon(weapon) && weapon.getRarity() != Rarity.QUEST;
                        switch (interactionType) {
                            case SEX: {
                                if (index == 1) {
                                    return new Response("\u62ff\u53d6(1)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u62ff\u8d77\u6b66\u5668\u3002", null);
                                }
                                if (index == 2) {
                                    return new Response("\u62ff\u53d6(5)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u62ff\u8d77\u6b66\u5668\u3002", null);
                                }
                                if (index == 3) {
                                    return new Response("\u62ff\u53d6(\u6240\u6709)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u62ff\u8d77\u6b66\u5668\u3002", null);
                                }
                                if (index == 4) {
                                    return new Response("\u67d3\u8272", "\u81ea\u6170\u65f6\u65e0\u6cd5\u67d3\u8272\u6b66\u5668\u3002", null);
                                }
                                if (index == 5) {
                                    return new Response("\u9644\u9b54", "\u81ea\u6170\u65f6\u65e0\u6cd5\u9644\u9b54\u6b66\u5668\u3002", null);
                                }
                                if (index == 6) {
                                    return new Response("\u4e3b\u624b\u88c5\u5907(\u81ea\u5df1)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u88c5\u5907\u6b66\u5668\u3002", null);
                                }
                                if (index == 7) {
                                    return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u88c5\u5907\u6b66\u5668\u3002", null);
                                }
                                if (index == 10) {
                                    return InventoryDialogue.getQuickTradeResponse();
                                }
                                return null;
                            }
                        }
                        if (index == 1) {
                            if (inventoryFull) {
                                return new Response("\u62ff\u53d6(1)", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                            }
                            return new Response("\u62ff\u53d6(1)", "\u4ece\u5730\u4e0a\u62ff\u53d6\u4e00\u4e2a" + weapon.getName() + "\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    InventoryDialogue.pickUpWeapons(Main.game.getPlayer(), weapon, 1);
                                }
                            };
                        }
                        if (index == 2) {
                            if (inventoryFull) {
                                return new Response("\u62ff\u53d6(5)", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                            }
                            if (Main.game.getPlayerCell().getInventory().getWeaponCount(weapon) >= 5) {
                                return new Response("\u62ff\u53d6(5)", "\u4ece\u5730\u4e0a\u62ff\u53d6\u4e94\u4e2a" + weapon.getNamePlural() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.pickUpWeapons(Main.game.getPlayer(), weapon, 5);
                                    }
                                };
                            }
                            return new Response("\u62ff\u53d6(5)", "\u5730\u4e0a\u4e0d\u8db3\u4e94\u4e2a" + weapon.getNamePlural() + "\uff01", null);
                        }
                        if (index == 3) {
                            if (inventoryFull) {
                                return new Response("\u62ff\u53d6(\u6240\u6709)", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                            }
                            return new Response("\u62ff\u53d6(\u6240\u6709)", "\u4ece\u5730\u4e0a\u62ff\u53d6\u6240\u6709" + weapon.getNamePlural() + "\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    InventoryDialogue.pickUpWeapons(Main.game.getPlayer(), weapon, Main.game.getPlayerCell().getInventory().getWeaponCount(weapon));
                                }
                            };
                        }
                        if (index == 4) {
                            if (InventoryDialogue.isWeaponDyeReforgeActionAvailable()) {
                                boolean canDye;
                                boolean hasFullInventory = Main.game.getPlayerCell().getInventory().isInventoryFull() && weapon.getRarity() != Rarity.QUEST;
                                boolean isDyeingStackItem = Main.game.getPlayerCell().getInventory().getAllWeaponsInInventory().get(weapon) > 1;
                                boolean bl = canDye = !isDyeingStackItem || !hasFullInventory;
                                if (canDye) {
                                    return new Response("\u67d3\u8272/\u91cd\u94f8", Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u4f7f\u7528\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\u4e3a\u7269\u54c1\u67d3\u8272\u6216\u91cd\u94f8\u3002" : "\u4f7f\u7528\u67d3\u8272\u5237\u6216\u91cd\u94f8\u9524\u6765\u4fee\u6539\u8fd9\u4ef6\u6b66\u5668\u7684\u5c5e\u6027\u3002", DYE_WEAPON){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.resetWeaponDyeColours();
                                        }
                                    };
                                }
                                return new Response("\u67d3\u8272/\u91cd\u94f8", "\u4f60\u7684\u7269\u54c1\u680f\u6ee1\u4e86\uff0c\u65e0\u6cd5\u4fee\u6539\u6b66\u5668\u7684\u5c5e\u6027\u3002", null);
                            }
                            return new Response("\u67d3\u8272/\u91cd\u94f8", "\u4f60\u9700\u8981\u627e\u5230\u67d3\u8272\u5237\u6216\u91cd\u94f8\u9524\u624d\u80fd\u4fee\u6539\u8fd9\u4ef6\u6b66\u5668\u7684\u5c5e\u6027\u3002", null);
                        }
                        if (index == 5) {
                            return new Response("\u9644\u9b54", "\u4f60\u65e0\u6cd5\u9644\u9b54\u5728\u5730\u4e0a\u7684\u6b66\u5668\uff01", null);
                        }
                        if (index == 6) {
                            InventorySlot slot = InventorySlot.mainWeaponSlots[Main.game.getPlayer().getMainWeaponIndexToEquipTo(weapon)];
                            if (weapon.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                return new Response("\u4e3b\u624b\u88c5\u5907(\u81ea\u5df1)", "\u88c5\u5907" + weapon.getName() + "\u4e3a\u4e3b\u624b\u6b66\u5668\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().equipMainWeaponFromFloor(weapon) + "</p>");
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            return new Response("\u4e3b\u624b\u88c5\u5907(\u81ea\u5df1)", weapon.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                        }
                        if (index == 7) {
                            InventorySlot slot = InventorySlot.mainWeaponSlots[Main.game.getPlayer().getMainWeaponIndexToEquipTo(weapon)];
                            if (!weapon.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", weapon.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                            }
                            if (weapon.getWeaponType().isTwoHanded()) {
                                return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", weapon.getWeaponType().isPlural() ? "\u7531\u4e8e" + weapon.getName() + "\u9700\u8981\u53cc\u624b\u63e1\u6301\uff0c\u6240\u4ee5\u53ea\u80fd\u88ab\u88c5\u5907\u5728\u4e3b\u624b\u680f\u4f4d\uff01" : "\u7531\u4e8e" + weapon.getName() + "\u662f\u53cc\u624b\u6b66\u5668\uff0c\u53ea\u80fd\u88ab\u88c5\u5907\u5728\u4e3b\u624b\u680f\u4f4d\uff01", null);
                            }
                            return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", "\u88c5\u5907" + weapon.getName() + "\u4e3a\u526f\u624b\u6b66\u5668\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().equipOffhandWeaponFromFloor(weapon) + "</p>");
                                    InventoryDialogue.resetPostAction();
                                }
                            };
                        }
                        if (index == 10) {
                            return InventoryDialogue.getQuickTradeResponse();
                        }
                        return null;
                    }
                    boolean inventoryFull = false;
                    switch (interactionType) {
                        case COMBAT: {
                            if (index == 1) {
                                return new Response("\u62ff\u53d6(1)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u62ff\u53d6\u4ed6\u4eba\u7684\u6b66\u5668\uff01", null);
                            }
                            if (index == 2) {
                                return new Response("\u62ff\u53d6(5)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u62ff\u53d6\u4ed6\u4eba\u7684\u6b66\u5668\uff01", null);
                            }
                            if (index == 3) {
                                return new Response("\u62ff\u53d6(\u6240\u6709)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u62ff\u53d6\u4ed6\u4eba\u7684\u6b66\u5668\uff01", null);
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u67d3\u8272\u4ed6\u4eba\u7684\u6b66\u5668\uff01", null);
                            }
                            if (index == 5) {
                                return new Response("\u9644\u9b54", "\u4f60\u65e0\u6cd5\u9644\u9b54\u5176\u4ed6\u4eba\u7684\u6b66\u5668\uff0c\u5c24\u5176\u662f\u5728\u6218\u6597\u8fc7\u7a0b\u4e2d\uff01", null);
                            }
                            if (index == 6) {
                                return new Response("\u4e3b\u624b\u88c5\u5907(\u81ea\u5df1)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u4f7f\u7528\u4ed6\u4eba\u7684\u6b66\u5668\uff01", null);
                            }
                            if (index == 7) {
                                return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u4f7f\u7528\u4ed6\u4eba\u7684\u6b66\u5668\uff01", null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index == 11) {
                                return new Response("\u4e3b\u624b\u88c5\u5907(\u654c\u4eba)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u4ee4\u4ed6\u4eba\u4f7f\u7528\u6b66\u5668\uff01", null);
                            }
                            if (index == 12) {
                                return new Response("\u526f\u624b\u88c5\u5907(\u654c\u4eba)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u4ee4\u4ed6\u4eba\u4f7f\u7528\u6b66\u5668\uff01", null);
                            }
                            return null;
                        }
                        case FULL_MANAGEMENT: 
                        case CHARACTER_CREATION: {
                            boolean bl = inventoryFull = Main.game.getPlayer().isInventoryFull() && !Main.game.getPlayer().hasWeapon(weapon) && weapon.getRarity() != Rarity.QUEST;
                            if (index == 1) {
                                if (inventoryFull) {
                                    return new Response("\u62ff\u53d6(1)", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                                }
                                return new Response("\u62ff\u53d6(1)", UtilText.parse((GameCharacter)inventoryNPC, "\u4ece[npc.Name]\u5904\u62ff\u53d6\u4e00\u4e2a" + weapon.getName() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.transferWeapons(inventoryNPC, Main.game.getPlayer(), weapon, 1);
                                    }
                                };
                            }
                            if (index == 2) {
                                if (inventoryFull) {
                                    return new Response("\u62ff\u53d6(5)", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                                }
                                if (inventoryNPC.getWeaponCount(weapon) >= 5) {
                                    return new Response("\u62ff\u53d6(5)", UtilText.parse((GameCharacter)inventoryNPC, "\u4ece[npc.namePos]\u90a3\u62ff\u8d70\u4e94\u4e2a" + weapon.getNamePlural() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.transferWeapons(inventoryNPC, Main.game.getPlayer(), weapon, 5);
                                        }
                                    };
                                }
                                return new Response("\u62ff\u53d6(5)", UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u6ca1\u67095\u4e2a" + weapon.getNamePlural() + "\uff01", new ParserTag[0]), null);
                            }
                            if (index == 3) {
                                if (inventoryFull) {
                                    return new Response("\u62ff\u53d6(\u6240\u6709)", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                                }
                                return new Response("\u62ff\u53d6(\u6240\u6709)", UtilText.parse((GameCharacter)inventoryNPC, "\u5c06[npc.namePos]\u7684" + weapon.getNamePlural() + Util.intToString(inventoryNPC.getWeaponCount(weapon)) + "\u5168\u90e8\u62ff\u8d70\u3002", new ParserTag[0]), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.transferWeapons(inventoryNPC, Main.game.getPlayer(), weapon, inventoryNPC.getWeaponCount(weapon));
                                    }
                                };
                            }
                            if (index == 4) {
                                if (InventoryDialogue.isWeaponDyeReforgeActionAvailable()) {
                                    boolean canDye;
                                    boolean hasFullInventory = inventoryNPC.isInventoryFull() && weapon.getRarity() != Rarity.QUEST;
                                    boolean isDyeingStackItem = inventoryNPC.getAllWeaponsInInventory().get(weapon) > 1;
                                    boolean bl3 = canDye = !isDyeingStackItem || !hasFullInventory;
                                    if (canDye) {
                                        return new Response("\u67d3\u8272/\u91cd\u94f8", Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u4f7f\u7528\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\u4e3a\u7269\u54c1\u67d3\u8272\u6216\u91cd\u94f8\u3002" : "\u4f7f\u7528\u67d3\u8272\u5237\u6216\u91cd\u94f8\u9524\u6765\u4fee\u6539\u8fd9\u4ef6\u6b66\u5668\u7684\u5c5e\u6027\u3002", DYE_WEAPON){

                                            @Override
                                            public void effects() {
                                                InventoryDialogue.resetWeaponDyeColours();
                                            }
                                        };
                                    }
                                    return new Response("\u67d3\u8272/\u91cd\u94f8", UtilText.parse((GameCharacter)inventoryNPC, "[npc.NamePos]\u7684\u7269\u54c1\u680f\u6ee1\u4e86\uff0c\u65e0\u6cd5\u4fee\u6539\u6b66\u5668\u7684\u5c5e\u6027\u3002", new ParserTag[0]), null);
                                }
                                return new Response("\u67d3\u8272/\u91cd\u94f8", UtilText.parse((GameCharacter)inventoryNPC, "\u4f60\u9700\u8981\u627e\u5230\u67d3\u8272\u5237\u6216\u91cd\u94f8\u9524\u624d\u80fd\u4fee\u6539[npc.namePos]\u7684\u6b66\u5668\u7684\u5c5e\u6027\u3002", new ParserTag[0]), null);
                            }
                            if (index == 5) {
                                return new Response("\u9644\u9b54", "\u65e0\u6cd5\u9644\u9b54\u7531\u5176\u4ed6\u4eba\u62e5\u6709\u7684\u6b66\u5668\uff01", null);
                            }
                            if (index == 6) {
                                InventorySlot slot = InventorySlot.mainWeaponSlots[Main.game.getPlayer().getMainWeaponIndexToEquipTo(weapon)];
                                if (weapon.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                    return new Response("\u4e3b\u624b\u88c5\u5907(\u81ea\u5df1)", "\u88c5\u5907" + weapon.getName() + "\u4e3a\u4e3b\u624b\u6b66\u5668\u3002", INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().equipMainWeaponFromInventory(weapon, inventoryNPC) + "</p>");
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                return new Response("\u4e3b\u624b\u88c5\u5907(\u81ea\u5df1)", weapon.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                            }
                            if (index == 7) {
                                if (weapon.getWeaponType().isTwoHanded()) {
                                    return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", weapon.getWeaponType().isPlural() ? "\u7531\u4e8e" + weapon.getName() + "\u9700\u8981\u53cc\u624b\u63e1\u6301\uff0c\u6240\u4ee5\u53ea\u80fd\u88ab\u88c5\u5907\u5728\u4e3b\u624b\u680f\u4f4d\uff01" : "\u7531\u4e8e" + weapon.getName() + "\u662f\u53cc\u624b\u6b66\u5668\uff0c\u53ea\u80fd\u88ab\u88c5\u5907\u5728\u4e3b\u624b\u680f\u4f4d\uff01", null);
                                }
                                InventorySlot slot = InventorySlot.offhandWeaponSlots[Main.game.getPlayer().getOffhandWeaponIndexToEquipTo(weapon)];
                                if (weapon.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                    return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", "\u88c5\u5907" + weapon.getName() + "\u4e3a\u526f\u624b\u6b66\u5668\u3002", INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().equipOffhandWeaponFromInventory(weapon, inventoryNPC) + "</p>");
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", weapon.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index == 11) {
                                InventorySlot slot = InventorySlot.mainWeaponSlots[inventoryNPC.getMainWeaponIndexToEquipTo(weapon)];
                                if (weapon.isCanBeEquipped(inventoryNPC, slot)) {
                                    return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u4e3b\u624b\u88c5\u5907([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u8ba9[npc.name]\u88c5\u5907" + weapon.getName() + "\u4e3a\u4e3b\u624b\u6b66\u5668\u3002", new ParserTag[0]), INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + inventoryNPC.equipMainWeaponFromInventory(weapon, inventoryNPC) + "</p>");
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u4e3b\u624b\u88c5\u5907([npc.HerHim])", new ParserTag[0]), weapon.getCannotBeEquippedText(inventoryNPC, slot), null);
                            }
                            if (index == 12) {
                                if (weapon.getWeaponType().isTwoHanded()) {
                                    return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u526f\u624b\u88c5\u5907([npc.HerHim])", new ParserTag[0]), weapon.getWeaponType().isPlural() ? "\u7531\u4e8e" + weapon.getName() + "\u9700\u8981\u53cc\u624b\u63e1\u6301\uff0c\u6240\u4ee5\u53ea\u80fd\u88ab\u88c5\u5907\u5728\u4e3b\u624b\u680f\u4f4d\uff01" : "\u7531\u4e8e" + weapon.getName() + "\u662f\u53cc\u624b\u6b66\u5668\uff0c\u53ea\u80fd\u88ab\u88c5\u5907\u5728\u4e3b\u624b\u680f\u4f4d\uff01", null);
                                }
                                InventorySlot slot = InventorySlot.offhandWeaponSlots[Main.game.getPlayer().getOffhandWeaponIndexToEquipTo(weapon)];
                                if (weapon.isCanBeEquipped(inventoryNPC, slot)) {
                                    return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u526f\u624b\u88c5\u5907([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u8ba9[npc.name]\u88c5\u5907" + weapon.getName() + "\u4e3a\u526f\u624b\u6b66\u5668\u3002", new ParserTag[0]), INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + inventoryNPC.equipOffhandWeaponFromInventory(weapon, inventoryNPC) + "</p>");
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u526f\u624b\u88c5\u5907([npc.HerHim])", new ParserTag[0]), weapon.getCannotBeEquippedText(inventoryNPC, slot), null);
                            }
                            return null;
                        }
                        case SEX: {
                            if (index == 1) {
                                return new Response("\u62ff\u53d6(1)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u62ff\u8d70\u4ed6\u4eba\u6b66\u5668\uff01", null);
                            }
                            if (index == 2) {
                                return new Response("\u62ff\u53d6(5)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u62ff\u8d70\u4ed6\u4eba\u6b66\u5668\uff01", null);
                            }
                            if (index == 3) {
                                return new Response("\u62ff\u53d6(\u6240\u6709)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u62ff\u8d70\u4ed6\u4eba\u6b66\u5668\uff01", null);
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u67d3\u8272\u4ed6\u4eba\u6b66\u5668\uff01", null);
                            }
                            if (index == 5) {
                                return new Response("\u9644\u9b54", "\u65e0\u6cd5\u9644\u9b54\u5176\u4ed6\u4eba\u7684\u6b66\u5668\uff0c\u5c24\u5176\u662f\u5728\u6027\u4ea4\u8fc7\u7a0b\u4e2d\uff01", null);
                            }
                            if (index == 6) {
                                return new Response("\u4e3b\u624b\u88c5\u5907(\u81ea\u5df1)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u4f7f\u7528\u4ed6\u4eba\u6b66\u5668\uff01", null);
                            }
                            if (index == 7) {
                                return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u4f7f\u7528\u4ed6\u4eba\u6b66\u5668\uff01", null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index == 11) {
                                return new Response("\u4e3b\u624b\u88c5\u5907(\u654c\u4eba)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u4ee4\u4ed6\u4eba\u4f7f\u7528\u6b66\u5668\uff01", null);
                            }
                            if (index == 12) {
                                return new Response("\u526f\u624b\u88c5\u5907(\u654c\u4eba)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u4ee4\u4ed6\u4eba\u4f7f\u7528\u6b66\u5668\uff01", null);
                            }
                            return null;
                        }
                        case TRADING: {
                            boolean bl = inventoryFull = Main.game.getPlayer().isInventoryFull() && !Main.game.getPlayer().hasWeapon(weapon) && weapon.getRarity() != Rarity.QUEST;
                            if (index == 1) {
                                int sellPrice;
                                int n = sellPrice = buyback ? ((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).getPrice() : weapon.getPrice(inventoryNPC.getSellModifier(weapon));
                                if (inventoryFull) {
                                    return new Response("\u8d2d\u4e70(1) (" + UtilText.formatAsMoneyUncoloured(sellPrice, "span") + ")", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                                }
                                if (Main.game.getPlayer().getMoney() < (long)sellPrice) {
                                    return new Response("\u8d2d\u4e70(1) (" + UtilText.formatAsMoneyUncoloured(sellPrice, "span") + ")", "\u4f60\u4e70\u4e0d\u8d77\u8fd9\u4e2a\uff01", null);
                                }
                                return new Response("\u8d2d\u4e70(1) (" + UtilText.formatAsMoney(sellPrice, "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice) + "\u7684\u4ef7\u683c\u8d2d\u4e70" + weapon.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.sellWeapons(inventoryNPC, Main.game.getPlayer(), weapon, 1, sellPrice);
                                    }
                                };
                            }
                            if (index == 2) {
                                int sellPrice;
                                int n = sellPrice = buyback ? ((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).getPrice() : weapon.getPrice(inventoryNPC.getSellModifier(weapon));
                                if (buyback && ((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).getCount() < 5 || !buyback && inventoryNPC.getWeaponCount(weapon) < 5) {
                                    return new Response("\u8d2d\u4e70(5) (" + UtilText.formatAsMoneyUncoloured(sellPrice * 5, "span") + ")", UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u5e76\u4e0d\u62e5\u6709\u4e94\u4ef6" + weapon.getNamePlural() + "\u3002", new ParserTag[0]), null);
                                }
                                if (inventoryFull) {
                                    return new Response("\u8d2d\u4e70(5) (" + UtilText.formatAsMoneyUncoloured(sellPrice * 5, "span") + ")", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                                }
                                if (Main.game.getPlayer().getMoney() < (long)(sellPrice * 5)) {
                                    return new Response("\u8d2d\u4e70(5) (" + UtilText.formatAsMoneyUncoloured(sellPrice * 5, "span") + ")", "\u4f60\u4e70\u4e0d\u8d77\u8fd9\u4e2a\uff01", null);
                                }
                                return new Response("\u8d2d\u4e70(5) (" + UtilText.formatAsMoney(sellPrice * 5, "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice * 5) + "\u7684\u4ef7\u683c\u8d2d\u4e70\u4e94\u4ef6" + weapon.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.sellWeapons(inventoryNPC, Main.game.getPlayer(), weapon, 5, sellPrice);
                                    }
                                };
                            }
                            if (index == 3) {
                                int count;
                                final int sellPrice = buyback ? ((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).getPrice() : weapon.getPrice(inventoryNPC.getSellModifier(weapon));
                                int n = count = buyback ? ((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).getCount() : inventoryNPC.getWeaponCount(weapon);
                                if (inventoryFull) {
                                    return new Response("\u8d2d\u4e70(\u6240\u6709) (" + UtilText.formatAsMoneyUncoloured(sellPrice * count, "span") + ")", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                                }
                                if (Main.game.getPlayer().getMoney() < (long)(sellPrice * count)) {
                                    final int affordableCount = (int)(Main.game.getPlayer().getMoney() / (long)sellPrice);
                                    if (affordableCount > 0) {
                                        return new Response("\u8d2d\u4e70(Max " + affordableCount + ") (" + UtilText.formatAsMoney(sellPrice * affordableCount, "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice * affordableCount) + "\u7684\u4ef7\u683c\u8d2d\u4e70" + weapon.getName() + "\u3002", INVENTORY_MENU){

                                            @Override
                                            public void effects() {
                                                InventoryDialogue.sellWeapons(inventoryNPC, Main.game.getPlayer(), weapon, affordableCount, sellPrice);
                                            }
                                        };
                                    }
                                    return new Response("\u8d2d\u4e70(\u6240\u6709) (" + UtilText.formatAsMoneyUncoloured(sellPrice * count, "span") + ")", "\u4f60\u4e70\u4e0d\u8d77\u8fd9\u4e2a\uff01", null);
                                }
                                return new Response("\u8d2d\u4e70(\u6240\u6709) (" + UtilText.formatAsMoney(sellPrice * count, "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice * count) + "\u7684\u4ef7\u683c\u8d2d\u4e70" + weapon.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.sellWeapons(inventoryNPC, Main.game.getPlayer(), weapon, count, sellPrice);
                                    }
                                };
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272", UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u4e0d\u5141\u8bb8\u4f60\u67d3\u8272[npc.sheIs]\u8981\u552e\u5356\u7684\u6b66\u5668\uff01", new ParserTag[0]), null);
                            }
                            if (index == 5) {
                                return new Response("\u9644\u9b54", "\u65e0\u6cd5\u9644\u9b54\u7531\u5176\u4ed6\u4eba\u62e5\u6709\u7684\u6b66\u5668\uff01", null);
                            }
                            if (index == 6) {
                                return new Response("\u4e3b\u624b\u88c5\u5907(\u81ea\u5df1)", UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u4e0d\u5141\u8bb8\u4f60\u88c5\u5907[npc.her]\u7684\u6b66\u5668\uff0c\u9664\u975e\u5148\u4e70\u4e0b\u3002", new ParserTag[0]), null);
                            }
                            if (index == 7) {
                                return new Response("\u526f\u624b\u88c5\u5907(\u81ea\u5df1)", UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u4e0d\u5141\u8bb8\u4f60\u88c5\u5907[npc.her]\u7684\u6b66\u5668\uff0c\u9664\u975e\u5148\u4e70\u4e0b\u3002", new ParserTag[0]), null);
                            }
                            if (index == 9) {
                                return InventoryDialogue.getBuybackResponse();
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index == 11) {
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u4e3b\u624b\u88c5\u5907([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u4e0d\u5141\u8bb8\u4f60\u88c5\u5907[npc.sheIs]\u8981\u552e\u5356\u7684\u6b66\u5668\uff01", new ParserTag[0]), null);
                            }
                            if (index == 12) {
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u526f\u624b\u88c5\u5907([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u4e0d\u5141\u8bb8\u4f60\u88c5\u5907[npc.sheIs]\u8981\u552e\u5356\u7684\u6b66\u5668\uff01", new ParserTag[0]), null);
                            }
                            return null;
                        }
                    }
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.INVENTORY;
            }
        };
        CLOTHING_INVENTORY = new DialogueNode("\u8863\u7269", "", true){

            @Override
            public String getLabel() {
                if (!Main.game.isInNewWorld()) {
                    return "\u665a\u4f1a\u7740\u88c5";
                }
                if (Main.game.getDialogueFlags().values.contains(DialogueFlagValue.quickTrade) && !Main.game.isInSex() && !Main.game.isInCombat()) {
                    return "\u7269\u54c1\u680f(\u5feb\u901f\u7ba1\u7406\u5f53\u524d<b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u5f00\u542f</b>)";
                }
                return "\u5e93\u5b58";
            }

            @Override
            public String getHeaderContent() {
                return InventoryDialogue.inventoryView();
            }

            @Override
            public String getContent() {
                StringBuilder sb = new StringBuilder();
                sb.append(clothing.getDescription(owner));
                sb.append("<p>");
                for (String s : clothing.getExtraDescriptions(null, null, true)) {
                    sb.append(s + "<br/>");
                }
                for (InventorySlot is : clothing.getClothingType().getEquipSlots()) {
                    List<String> descriptions = clothing.getExtraDescriptions(null, is, true);
                    if (descriptions.isEmpty()) continue;
                    sb.append("<i>\u5f53\u88c5\u5907\u5728\u201c" + is.getName() + "\u201d\u680f\u4f4d\u65f6:</i><br/>");
                    for (String s : clothing.getExtraDescriptions(null, is, true)) {
                        sb.append(s + "<br/>");
                    }
                }
                sb.append("</p>");
                sb.append((String)(owner != null && owner.isPlayer() ? (inventoryNPC != null && interactionType == InventoryInteraction.TRADING ? "<p>" + (inventoryNPC.willBuy(clothing) ? inventoryNPC.getName("") + "\u5c06\u4ee5" + UtilText.formatAsMoney(clothing.getPrice(inventoryNPC.getBuyModifier())) + "\u7684\u4ef7\u683c\u4e70\u4e0b\u3002" : inventoryNPC.getName("") + "\u4e0d\u60f3\u4e70\u8fd9\u4e2a\u3002") + "</p>" : "") : (inventoryNPC != null && interactionType == InventoryInteraction.TRADING ? "<p>" + inventoryNPC.getName("") + "\u5c06\u4ee5" + UtilText.formatAsMoney(clothing.getPrice(inventoryNPC.getSellModifier(clothing))) + "\u7684\u4ef7\u683c\u552e\u51fa\u3002</p>" : "")));
                return InventoryDialogue.getItemDisplayPanel(clothing, clothing.getSVGString(), clothing.getDisplayName(true), sb.toString()) + (interactionType == InventoryInteraction.CHARACTER_CREATION ? CharacterCreation.getCheckingClothingDescription() : "");
            }

            @Override
            public String getResponseTabTitle(int index) {
                return InventoryDialogue.getGeneralResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 0) {
                    return InventoryDialogue.getCloseInventoryResponse();
                }
                if (Main.game.isBadEnd()) {
                    if (index == 1) {
                        return new Response("\u4e0d\u53ef\u7528", "\u5728\u574f\u7ed3\u5c40\u65f6\u65e0\u6cd5\u64cd\u4f5c\u7269\u54c1\u680f\u2026\u2026", null);
                    }
                    return null;
                }
                if (responseTab == 0) {
                    return INVENTORY_MENU.getResponse(responseTab, index);
                }
                if (owner != null && owner.isPlayer()) {
                    if (inventoryNPC == null) {
                        boolean areaFull = Main.game.isPlayerTileFull() && !Main.game.getPlayerCell().getInventory().hasClothing(clothing);
                        switch (interactionType) {
                            case SEX: {
                                String dropTitle;
                                String string = dropTitle = owner.getLocationPlace().isItemsDisappear() ? "\u4e22\u5f03" : "\u5b58\u50a8";
                                if (index == 1) {
                                    return new Response(dropTitle + "(1)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u4e22\u5f03\u8863\u7269\u3002", null);
                                }
                                if (index == 2) {
                                    return new Response(dropTitle + "(5)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u4e22\u5f03\u8863\u7269\u3002", null);
                                }
                                if (index == 3) {
                                    return new Response(dropTitle + "(\u6240\u6709)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u4e22\u5f03\u8863\u7269\u3002", null);
                                }
                                if (index == 4) {
                                    return new Response("\u67d3\u8272", "\u81ea\u6170\u65f6\u65e0\u6cd5\u67d3\u8272\u8863\u7269\u3002", null);
                                }
                                if (index == 5) {
                                    if (clothing.isCondom()) {
                                        if (clothing.getCondomEffect().getPotency().isNegative()) {
                                            return new Response("\u4fee\u590d(<i>1\u7cbe\u534e</i>)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u4fee\u590d\u907f\u5b55\u5957\u3002", null);
                                        }
                                        return new Response("\u7834\u574f", "\u81ea\u6170\u65f6\u65e0\u6cd5\u7834\u574f\u907f\u5b55\u5957\u3002", null);
                                    }
                                    return new Response("\u9644\u9b54", "\u81ea\u6170\u65f6\u65e0\u6cd5\u9644\u9b54\u8863\u7269\u3002", null);
                                }
                                if (index >= 6 && index <= 9 && index - 6 < clothing.getClothingType().getEquipSlots().size()) {
                                    final InventorySlot slot = clothing.getClothingType().getEquipSlots().get(index - 6);
                                    if (Main.sex.isCharacterImmobilised(Main.game.getPlayer())) {
                                        return new Response("\u88c5\u5907\uff1a" + Util.capitaliseSentence(slot.getName()), "\u4f60\u5f53\u524d\u5904\u4e8e[style.colourTerrible(\u65e0\u6cd5\u884c\u52a8)]\u72b6\u6001\uff0c\u65e0\u6cd5\u88c5\u5907\u6b64\u7269\u54c1\uff01", null);
                                    }
                                    if (clothing.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                        if (clothing.isAbleToBeEquippedDuringSex(slot).getKey().booleanValue()) {
                                            if (!Main.sex.getInitialSexManager().isAbleToEquipSexClothing(Main.game.getPlayer(), Main.game.getPlayer(), clothing)) {
                                                return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), "\u7531\u4e8e\u5904\u4e8e\u7279\u6b8a\u6027\u4ea4\u573a\u666f\u4e2d\uff0c\u4f60\u65e0\u6cd5\u88c5\u5907\u8863\u7269\uff01", null);
                                            }
                                            if (!Main.sex.isClothingEquipAvailable(Main.game.getPlayer(), slot, clothing)) {
                                                return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), "\u8be5\u680f\u4f4d\u4e0e\u5f53\u524d\u8fdb\u884c\u7684\u6027\u52a8\u4f5c\u6709\u5173\uff0c\u6240\u4ee5\u65e0\u6cd5\u5728\u5176\u4e0a\u88c5\u5907\u8863\u7269\uff01", null);
                                            }
                                            if (Main.game.getPlayer().isAbleToEquip(clothing, slot, false, Main.game.getPlayer())) {
                                                return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), "\u88c5\u5907" + clothing.getName() + "\u3002", Main.sex.SEX_DIALOGUE){

                                                    @Override
                                                    public void effects() {
                                                        AbstractClothing c = clothing;
                                                        InventoryDialogue.equipClothingFromInventory(Main.game.getPlayer(), slot, Main.game.getPlayer(), clothing);
                                                        Main.sex.setEquipClothingText(c, Main.game.getPlayer().getUnequipDescription());
                                                        Main.mainController.openInventory();
                                                        Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                                        Main.sex.setSexStarted(true);
                                                    }
                                                };
                                            }
                                            return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), InventoryDialogue.getClothingBlockingRemovalText(Main.game.getPlayer(), "\u88c5\u5907"), null);
                                        }
                                        return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), clothing.isAbleToBeEquippedDuringSex(slot).getValue(), null);
                                    }
                                    return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), clothing.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                                }
                                if (index == 10) {
                                    return InventoryDialogue.getQuickTradeResponse();
                                }
                                return null;
                            }
                        }
                        if (index == 1) {
                            if (owner.getLocationPlace().isItemsDisappear()) {
                                if (!clothing.getClothingType().isAbleToBeDropped()) {
                                    return new Response("\u4e22\u5f03(1)", "\u65e0\u6cd5\u4e22\u5f03" + clothing.getName() + "\uff01", null);
                                }
                                if (areaFull) {
                                    return new Response("\u4e22\u5f03(1)", "\u8be5\u533a\u57df\u5df2\u7ecf\u6ee1\u4e86\uff0c\u6240\u4ee5\u65e0\u6cd5\u4e22\u5f03" + clothing.getName() + "\uff01", null);
                                }
                                return new Response("\u4e22\u5f03(1)", "\u4e22\u5f03" + clothing.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.dropClothing(owner, clothing, 1);
                                    }
                                };
                            }
                            if (!clothing.getClothingType().isAbleToBeDropped()) {
                                return new Response("\u5b58\u50a8(1)", "\u4f60\u65e0\u6cd5\u5b58\u50a8" + clothing.getName() + "\uff01", null);
                            }
                            if (areaFull) {
                                return new Response("\u5b58\u50a8(1)", "\u5b58\u50a8" + clothing.getName() + "\uff01", null);
                            }
                            return new Response("\u5b58\u50a8(1)", "\u5b58\u50a8" + clothing.getName() + "\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    InventoryDialogue.dropClothing(owner, clothing, 1);
                                }
                            };
                        }
                        if (index == 2) {
                            if (owner.getLocationPlace().isItemsDisappear()) {
                                if (!clothing.getClothingType().isAbleToBeDropped()) {
                                    return new Response("\u4e22\u5f03(5)", "\u65e0\u6cd5\u4e22\u5f03" + clothing.getName() + "\uff01", null);
                                }
                                if (owner.getClothingCount(clothing) < 5) {
                                    return new Response("\u4e22\u5f03(5)", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u4e94\u4e2a" + clothing.getNamePlural() + "\uff01", null);
                                }
                                if (areaFull) {
                                    return new Response("\u4e22\u5f03(5)", "\u8be5\u533a\u57df\u5df2\u7ecf\u6ee1\u4e86\uff0c\u6240\u4ee5\u65e0\u6cd5\u4e22\u5f03" + clothing.getNamePlural() + "\uff01", null);
                                }
                                return new Response("\u4e22\u5f03(5)", "\u4e22\u5f03\u4e94\u4e2a" + clothing.getNamePlural() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.dropClothing(owner, clothing, 5);
                                    }
                                };
                            }
                            if (!clothing.getClothingType().isAbleToBeDropped()) {
                                return new Response("\u5b58\u50a8(5)", "\u4f60\u65e0\u6cd5\u5b58\u50a8" + clothing.getName() + "\uff01", null);
                            }
                            if (owner.getClothingCount(clothing) < 5) {
                                return new Response("\u5b58\u50a8(5)", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u4e94\u4e2a" + clothing.getNamePlural() + "\uff01", null);
                            }
                            if (areaFull) {
                                return new Response("\u5b58\u50a8(5)", "\u5b58\u50a8" + clothing.getNamePlural() + "\uff01", null);
                            }
                            return new Response("\u5b58\u50a8(5)", "\u5b58\u50a8\u4e94\u4e2a" + clothing.getNamePlural() + "\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    InventoryDialogue.dropClothing(owner, clothing, 5);
                                }
                            };
                        }
                        if (index == 3) {
                            if (owner.getLocationPlace().isItemsDisappear()) {
                                if (!clothing.getClothingType().isAbleToBeDropped()) {
                                    return new Response("\u4e22\u5f03(\u6240\u6709)", "\u65e0\u6cd5\u4e22\u5f03" + clothing.getName() + "\uff01", null);
                                }
                                if (areaFull) {
                                    return new Response("\u4e22\u5f03(\u6240\u6709)", "\u8be5\u533a\u57df\u5df2\u7ecf\u6ee1\u4e86\uff0c\u6240\u4ee5\u65e0\u6cd5\u4e22\u5f03" + clothing.getNamePlural() + "\uff01", null);
                                }
                                return new Response("\u4e22\u5f03(\u6240\u6709)", "\u4e22\u5f03\u6240\u6709\u7684" + clothing.getNamePlural() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.dropClothing(owner, clothing, owner.getClothingCount(clothing));
                                    }
                                };
                            }
                            if (!clothing.getClothingType().isAbleToBeDropped()) {
                                return new Response("\u5b58\u50a8(\u6240\u6709)", "\u4f60\u65e0\u6cd5\u5b58\u50a8" + clothing.getName() + "\uff01", null);
                            }
                            if (areaFull) {
                                return new Response("\u5b58\u50a8(\u6240\u6709)", "\u5b58\u50a8" + clothing.getNamePlural() + "\uff01", null);
                            }
                            return new Response("\u5b58\u50a8(\u6240\u6709)", "\u5b58\u50a8\u6240\u6709\u7684" + clothing.getNamePlural() + "\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    InventoryDialogue.dropClothing(owner, clothing, owner.getClothingCount(clothing));
                                }
                            };
                        }
                        if (index == 4) {
                            if (InventoryDialogue.isClothingDyeActionAvailable()) {
                                boolean canDye;
                                boolean hasFullInventory = Main.game.getPlayer().isInventoryFull() && clothing.getRarity() != Rarity.QUEST;
                                boolean isDyeingStackItem = Main.game.getPlayer().getAllClothingInInventory().get(clothing) > 1;
                                boolean bl = canDye = !isDyeingStackItem || !hasFullInventory;
                                if (canDye) {
                                    return new Response("\u67d3\u8272", Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u4f7f\u7528\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\u4e3a\u8be5\u8863\u7269\u67d3\u8272\u3002" : "\u4f7f\u7528\u67d3\u8272\u5237\u6765\u67d3\u8272\u8863\u7269\u3002", DYE_CLOTHING){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.resetClothingDyeColours();
                                        }
                                    };
                                }
                                return new Response("\u67d3\u8272", "\u4f60\u7684\u7269\u54c1\u680f\u6ee1\u4e86\uff0c\u65e0\u6cd5\u67d3\u8272\u8fd9\u4ef6\u8863\u7269\u3002", null);
                            }
                            return new Response("\u67d3\u8272", "\u4f60\u9700\u8981\u627e\u5230\u67d3\u8272\u5237\u624d\u80fd\u67d3\u8272\u8863\u7269\u3002", null);
                        }
                        if (index == 5) {
                            if (clothing.isCondom()) {
                                return InventoryDialogue.getCondomSabotageResponse(clothing);
                            }
                            if (Main.game.isDebugMode() || Main.game.getPlayer().hasQuest(QuestLine.SIDE_ENCHANTMENT_DISCOVERY) && Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ENCHANTMENT_DISCOVERY)) {
                                if (clothing.getEnchantmentItemType(null) == null || clothing.getItemTags().contains((Object)ItemTag.UNENCHANTABLE)) {
                                    return new Response("\u9644\u9b54", "\u8be5\u8863\u7269\u65e0\u6cd5\u9644\u9b54\uff01", null);
                                }
                                if (!clothing.isEnchantmentKnown()) {
                                    if (Main.game.getPlayer().getEssenceCount() >= 15) {
                                        return new Response("\u9274\u5b9a([style.italicsArcane(15\u7cbe\u534e)])", "\u4e3a\u4e86\u9274\u5b9a" + clothing.getName() + "\uff0c\u4f60\u9700\u8981\u4ed8\u51fa15\u5965\u672f\u7cbe\u534e\u81ea\u5df1\u5b8c\u6210\uff0c\u6216\u524d\u5f80\u5546\u5e97\u4ed8\u51fa1000\u706b\u5e01\u8ba9\u522b\u4eba\u5e2e\u5fd9\u3002", CLOTHING_INVENTORY){

                                            @Override
                                            public void effects() {
                                                Main.game.getPlayer().incrementEssenceCount(-15, false);
                                                String enchantmentRemovedString = clothing.setEnchantmentKnown(owner, true);
                                                clothing = AbstractClothing.enchantmentRemovedClothing;
                                                Main.game.getTextEndStringBuilder().append("<p>\u4f60\u5f15\u5bfc" + Util.intToString(15L) + "\u5965\u672f\u7cbe\u534e\u7684\u80fd\u91cf\u8fdb\u5165\u4e86" + clothing.getName() + "\uff0c\u5b83\u53d1\u51fa\u4e00\u9635\u6de1\u7d2b\u8272\u5149\u8292\u540e\uff0c\u4f60\u53d1\u73b0\u81ea\u5df1\u5df2\u7ecf\u80fd\u591f\u68c0\u6d4b\u5230\u5176\u4e0a\u7684\u9644\u9b54\u79cd\u7c7b\u4e86\uff01</p>" + enchantmentRemovedString + "<p style='text-align:center;'>\u9274\u5b9a" + clothing.getName() + "\u6d88\u8017\u4e86\u4f60[style.boldBad(" + Util.intToString(15L) + ")][style.boldArcane(\u5965\u672f\u7cbe\u534e)]\uff01</p>");
                                                RenderingEngine.setPage(Main.game.getPlayer(), clothing);
                                            }
                                        };
                                    }
                                    return new Response("\u9274\u5b9a(<i>15\u7cbe\u534e</i>)", "\u4f60\u9700\u8981\u4ed8\u51fa15\u5965\u672f\u7cbe\u534e\u81ea\u5df1\u5b8c\u6210([style.italicsBad(\u4f46\u4f60\u7684\u7cbe\u534e\u4e0d\u8db3)])\uff0c\u6216\u524d\u5f80\u5546\u5e97\u4ed8\u51fa1000\u706b\u5e01\u8ba9\u522b\u4eba\u5e2e\u5fd9\u3002", null);
                                }
                                return new Response("\u9644\u9b54", "\u9644\u9b54\u8be5\u8863\u7269\u3002", EnchantmentDialogue.ENCHANTMENT_MENU){

                                    @Override
                                    public DialogueNode getNextDialogue() {
                                        return EnchantmentDialogue.getEnchantmentMenu(clothing);
                                    }
                                };
                            }
                            return new Response("\u9644\u9b54", InventoryDialogue.getEnchantmentNotDiscoveredText("clothing"), null);
                        }
                        if (index >= 6 && index <= 9 && index - 6 < clothing.getClothingType().getEquipSlots().size()) {
                            final InventorySlot slot = clothing.getClothingType().getEquipSlots().get(index - 6);
                            if (clothing.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), "\u88c5\u5907" + clothing.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.equipClothingFromInventory(Main.game.getPlayer(), slot, Main.game.getPlayer(), clothing) + "</p>");
                                    }
                                };
                            }
                            return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), clothing.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                        }
                        if (index == 10) {
                            return InventoryDialogue.getQuickTradeResponse();
                        }
                        return null;
                    }
                    switch (interactionType) {
                        case COMBAT: {
                            if (index == 1) {
                                return new Response("\u7ed9\u4e88(1)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u7ed9\u4e88\u5176\u8863\u7269\uff01", null);
                            }
                            if (index == 2) {
                                return new Response("\u7ed9\u4e88(5)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u7ed9\u4e88\u5176\u8863\u7269\uff01", null);
                            }
                            if (index == 3) {
                                return new Response("\u7ed9\u4e88(\u6240\u6709)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u7ed9\u4e88\u5176\u8863\u7269\uff01", null);
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u67d3\u8272\u4f60\u7684\u8863\u7269\uff01", null);
                            }
                            if (index == 5) {
                                if (clothing.isCondom()) {
                                    if (clothing.getCondomEffect().getPotency().isNegative()) {
                                        return new Response("\u4fee\u590d(<i>1\u7cbe\u534e</i>)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u4fee\u590d\u907f\u5b55\u5957\uff01", null);
                                    }
                                    return new Response("\u7834\u574f", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u7834\u574f\u907f\u5b55\u5957\uff01", null);
                                }
                                return new Response("\u9644\u9b54", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u9644\u9b54\u8863\u7269\uff01", null);
                            }
                            if (index >= 6 && index <= 9 && index - 6 < clothing.getClothingType().getEquipSlots().size()) {
                                InventorySlot slot = clothing.getClothingType().getEquipSlots().get(index - 6);
                                return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u66f4\u6362\u8863\u7269\uff01", null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index >= 11 && index <= 14 && index - 11 < clothing.getClothingType().getEquipSlots().size()) {
                                InventorySlot slot = clothing.getClothingType().getEquipSlots().get(index - 11);
                                return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "(\u654c\u4eba)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u4ee4\u654c\u4eba\u88c5\u5907\u8863\u7269\uff01", null);
                            }
                            return null;
                        }
                        case FULL_MANAGEMENT: 
                        case CHARACTER_CREATION: {
                            boolean inventoryFull;
                            boolean bl = inventoryFull = inventoryNPC.isInventoryFull() && !inventoryNPC.hasClothing(clothing);
                            if (index == 1) {
                                if (!clothing.getClothingType().isAbleToBeDropped()) {
                                    return new Response("\u7ed9\u4e88(1)", "\u4f60\u65e0\u6cd5\u7ed9\u51fa" + clothing.getName() + "\uff01", null);
                                }
                                if (inventoryFull) {
                                    return new Response("\u7ed9\u4e88(1)", UtilText.parse((GameCharacter)inventoryNPC, "[npc.NamePos]\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", new ParserTag[0]), null);
                                }
                                return new Response("\u7ed9\u4e88(1)", UtilText.parse((GameCharacter)inventoryNPC, "\u7ed9\u4e88[npc.name]" + clothing.getName() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.transferClothing(Main.game.getPlayer(), inventoryNPC, clothing, 1);
                                    }
                                };
                            }
                            if (index == 2) {
                                if (!clothing.getClothingType().isAbleToBeDropped()) {
                                    return new Response("\u7ed9\u4e88(5)", "\u4f60\u65e0\u6cd5\u7ed9\u51fa" + clothing.getName() + "\uff01", null);
                                }
                                if (inventoryFull) {
                                    return new Response("\u7ed9\u4e88(5)", UtilText.parse((GameCharacter)inventoryNPC, "[npc.NamePos]\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", new ParserTag[0]), null);
                                }
                                if (Main.game.getPlayer().getClothingCount(clothing) >= 5) {
                                    return new Response("\u7ed9\u4e88(5)", UtilText.parse((GameCharacter)inventoryNPC, "\u7ed9\u4e88[npc.name]\u4e94\u4e2a" + clothing.getNamePlural() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.transferClothing(Main.game.getPlayer(), inventoryNPC, clothing, 5);
                                        }
                                    };
                                }
                                return new Response("\u7ed9\u4e88(5)", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u4e94\u4e2a" + clothing.getNamePlural() + "\uff01", null);
                            }
                            if (index == 3) {
                                if (!clothing.getClothingType().isAbleToBeDropped()) {
                                    return new Response("\u7ed9\u4e88(\u6240\u6709)", "\u4f60\u65e0\u6cd5\u7ed9\u51fa" + clothing.getName() + "\uff01", null);
                                }
                                if (inventoryFull) {
                                    return new Response("\u7ed9\u4e88(\u6240\u6709)", UtilText.parse((GameCharacter)inventoryNPC, "[npc.NamePos]\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", new ParserTag[0]), null);
                                }
                                return new Response("\u7ed9\u4e88(\u6240\u6709)", UtilText.parse((GameCharacter)inventoryNPC, "\u7ed9\u4e88[npc.name]\u4f60\u6240\u6709\u7684" + clothing.getNamePlural() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.transferClothing(Main.game.getPlayer(), inventoryNPC, clothing, Main.game.getPlayer().getClothingCount(clothing));
                                    }
                                };
                            }
                            if (index == 4) {
                                if (InventoryDialogue.isClothingDyeActionAvailable()) {
                                    boolean canDye;
                                    boolean hasFullInventory = Main.game.getPlayer().isInventoryFull();
                                    boolean isDyeingStackItem = Main.game.getPlayer().getAllClothingInInventory().get(clothing) > 1;
                                    boolean bl2 = canDye = !isDyeingStackItem || !hasFullInventory;
                                    if (canDye) {
                                        return new Response("\u67d3\u8272", Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u4f7f\u7528\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\u4e3a\u8be5\u7269\u54c1\u67d3\u8272\u3002" : "\u4f7f\u7528\u67d3\u8272\u5237\u6765\u67d3\u8272\u8863\u7269\u3002", DYE_CLOTHING){

                                            @Override
                                            public void effects() {
                                                InventoryDialogue.resetClothingDyeColours();
                                            }
                                        };
                                    }
                                    return new Response("\u67d3\u8272", "\u4f60\u7684\u7269\u54c1\u680f\u6ee1\u4e86\uff0c\u65e0\u6cd5\u67d3\u8272\u8fd9\u4ef6\u8863\u7269\u3002", null);
                                }
                                return new Response("\u67d3\u8272", "\u4f60\u9700\u8981\u627e\u5230\u67d3\u8272\u5237\u624d\u80fd\u67d3\u8272\u8863\u7269\u3002", null);
                            }
                            if (index == 5) {
                                if (clothing.isCondom()) {
                                    return InventoryDialogue.getCondomSabotageResponse(clothing);
                                }
                                if (Main.game.isDebugMode() || Main.game.getPlayer().hasQuest(QuestLine.SIDE_ENCHANTMENT_DISCOVERY) && Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ENCHANTMENT_DISCOVERY)) {
                                    if (clothing.getEnchantmentItemType(null) == null || clothing.getItemTags().contains((Object)ItemTag.UNENCHANTABLE)) {
                                        return new Response("\u9644\u9b54", "\u8be5\u8863\u7269\u65e0\u6cd5\u9644\u9b54\uff01", null);
                                    }
                                    if (!clothing.isEnchantmentKnown()) {
                                        if (Main.game.getPlayer().getEssenceCount() >= 15) {
                                            return new Response("\u9274\u5b9a([style.italicsArcane(15\u7cbe\u534e)])", "\u4e3a\u4e86\u9274\u5b9a" + clothing.getName() + "\uff0c\u4f60\u9700\u8981\u4ed8\u51fa15\u5965\u672f\u7cbe\u534e\u81ea\u5df1\u5b8c\u6210\uff0c\u6216\u524d\u5f80\u5546\u5e97\u4ed8\u51fa1000\u706b\u5e01\u8ba9\u522b\u4eba\u5e2e\u5fd9\u3002", CLOTHING_INVENTORY){

                                                @Override
                                                public void effects() {
                                                    Main.game.getPlayer().incrementEssenceCount(-15, false);
                                                    String enchantmentRemovedString = clothing.setEnchantmentKnown(owner, true);
                                                    clothing = AbstractClothing.enchantmentRemovedClothing;
                                                    Main.game.getTextEndStringBuilder().append("<p>\u4f60\u5f15\u5bfc" + Util.intToString(15L) + "\u5965\u672f\u7cbe\u534e\u7684\u80fd\u91cf\u8fdb\u5165\u4e86" + clothing.getName() + "\uff0c\u5b83\u53d1\u51fa\u4e00\u9635\u6de1\u7d2b\u8272\u5149\u8292\u540e\uff0c\u4f60\u53d1\u73b0\u81ea\u5df1\u5df2\u7ecf\u80fd\u591f\u68c0\u6d4b\u5230\u5176\u4e0a\u7684\u9644\u9b54\u79cd\u7c7b\u4e86\uff01</p>" + enchantmentRemovedString + "<p style='text-align:center;'>\u9274\u5b9a" + clothing.getName() + "\u6d88\u8017\u4e86\u4f60[style.boldBad(" + Util.intToString(15L) + ")][style.boldArcane(\u5965\u672f\u7cbe\u534e)]\uff01</p>");
                                                    RenderingEngine.setPage(Main.game.getPlayer(), clothing);
                                                }
                                            };
                                        }
                                        return new Response("\u9274\u5b9a(<i>15\u7cbe\u534e</i>)", "\u4f60\u9700\u8981\u4ed8\u51fa15\u5965\u672f\u7cbe\u534e\u81ea\u5df1\u5b8c\u6210([style.italicsBad(\u4f46\u4f60\u7684\u7cbe\u534e\u4e0d\u8db3)])\uff0c\u6216\u524d\u5f80\u5546\u5e97\u4ed8\u51fa1000\u706b\u5e01\u8ba9\u522b\u4eba\u5e2e\u5fd9\u3002", null);
                                    }
                                    return new Response("\u9644\u9b54", "\u9644\u9b54\u8be5\u8863\u7269\u3002", EnchantmentDialogue.ENCHANTMENT_MENU){

                                        @Override
                                        public DialogueNode getNextDialogue() {
                                            return EnchantmentDialogue.getEnchantmentMenu(clothing);
                                        }
                                    };
                                }
                                return new Response("\u9644\u9b54", InventoryDialogue.getEnchantmentNotDiscoveredText("clothing"), null);
                            }
                            if (index >= 6 && index <= 9 && index - 6 < clothing.getClothingType().getEquipSlots().size()) {
                                final InventorySlot slot = clothing.getClothingType().getEquipSlots().get(index - 6);
                                if (clothing.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                    return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), "\u88c5\u5907" + clothing.getName() + "\u3002", INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.equipClothingFromInventory(Main.game.getPlayer(), slot, Main.game.getPlayer(), clothing) + "</p>");
                                        }
                                    };
                                }
                                return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), clothing.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index >= 11 && index <= 14 && index - 11 < clothing.getClothingType().getEquipSlots().size()) {
                                final InventorySlot slot = clothing.getClothingType().getEquipSlots().get(index - 11);
                                Util.Value<Boolean, String> equipAllowed = inventoryNPC.isInventoryEquipAllowed(clothing, slot);
                                if (!equipAllowed.getKey().booleanValue()) {
                                    return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, equipAllowed.getValue(), new ParserTag[0]), null);
                                }
                                if (clothing.isCanBeEquipped(inventoryNPC, slot)) {
                                    if (inventoryNPC.isAbleToEquip(clothing, slot, true, Main.game.getPlayer()) && clothing.isEnslavementClothing() && (!inventoryNPC.isSlave() || !inventoryNPC.getOwner().isPlayer())) {
                                        boolean willEnslave = !inventoryNPC.isSlave() && inventoryNPC.isAbleToBeEnslaved() && Main.game.getPlayer().isHasSlaverLicense();
                                        return new Response(UtilText.parse((GameCharacter)inventoryNPC, !willEnslave ? "[style.colourMinorBad(\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim]))]" : "[style.colourArcane(\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim]))]", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u8ba9[npc.name]\u88c5\u5907" + clothing.getName() + "\u3002" + (!willEnslave ? "<br/><i>\u5c3d\u7ba1" + clothing.getName() + (clothing.getClothingType().isPlural() != false ? "\u62e5\u6709\u5974\u5f79\u9644\u9b54\uff0c\u5b83" : "\u62e5\u6709\u5974\u5f79\u9644\u9b54\uff0c\u5b83") + "[style.colourMinorBad(\u65e0\u6cd5\u5974\u5f79[npc.name])]\uff0c\u539f\u56e0\u662f" + (Main.game.getPlayer().isHasSlaverLicense() ? "[npc.sheIsFull]\u5e76\u975e\u5408\u9002\u7684\u5974\u5f79\u5bf9\u8c61" : "\u4f60\u6ca1\u6709\u8d29\u5974\u8bb8\u53ef") + "\uff01</i>" : "<br/><i>\u591a\u4e8f\u4e86" + clothing.getName() + (clothing.getClothingType().isPlural() != false ? "\u62e5\u6709\u5974\u5f79\u9644\u9b54\uff0c\u5b83" : "\u62e5\u6709\u5974\u5f79\u9644\u9b54\uff0c\u5b83") + "[style.colourArcane(\u80fd\u591f\u5974\u5f79[npc.name])]\uff0c\u4ee4\u4f60\u6210\u4e3a[npc.her]\u7684\u65b0\u4e3b\u4eba\uff01</i>"), new ParserTag[0]), INVENTORY_MENU){

                                            @Override
                                            public DialogueNode getNextDialogue() {
                                                if (inventoryNPC.getEnslavementDialogue(clothing) != null) {
                                                    return inventoryNPC.getEnslavementDialogue(clothing);
                                                }
                                                return INVENTORY_MENU;
                                            }

                                            @Override
                                            public void effects() {
                                                ArrayList<NPC> enslavementTargets = new ArrayList<NPC>(Main.game.getNonCompanionCharactersPresent());
                                                enslavementTargets.removeIf(npc -> !Main.combat.getEnemies(Main.game.getPlayer()).contains(npc));
                                                if (enslavementTargets.size() <= 1) {
                                                    SlaveDialogue.setFollowupEnslavementDialogue(Main.game.getDefaultDialogue(false));
                                                } else {
                                                    SlaveDialogue.setFollowupEnslavementDialogue(Main.game.getSavedDialogueNode());
                                                }
                                                if (inventoryNPC.getEnslavementDialogue(clothing) == null) {
                                                    Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.equipClothingFromInventory(inventoryNPC, slot, Main.game.getPlayer(), clothing) + "</p>");
                                                } else {
                                                    InventoryDialogue.equipClothingFromInventory(inventoryNPC, slot, Main.game.getPlayer(), clothing);
                                                }
                                            }
                                        };
                                    }
                                    return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u4ee4[npc.name]\u88c5\u5907" + clothing.getName() + "\uff01", new ParserTag[0]), INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.equipClothingFromInventory(inventoryNPC, slot, Main.game.getPlayer(), clothing) + "</p>");
                                        }
                                    };
                                }
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), clothing.getCannotBeEquippedText(inventoryNPC, slot), null);
                            }
                            return null;
                        }
                        case SEX: {
                            if (index == 1) {
                                return new Response("\u7ed9\u4e88(1)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u7ed9\u4e88\u5bf9\u65b9\u8863\u7269\uff01", null);
                            }
                            if (index == 2) {
                                return new Response("\u7ed9\u4e88(5)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u7ed9\u4e88\u5bf9\u65b9\u8863\u7269\uff01", null);
                            }
                            if (index == 3) {
                                return new Response("\u7ed9\u4e88(\u6240\u6709)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u7ed9\u4e88\u5bf9\u65b9\u8863\u7269\uff01", null);
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u67d3\u8272\u4f60\u7684\u8863\u670d\uff01", null);
                            }
                            if (index == 5) {
                                if (clothing.isCondom()) {
                                    if (clothing.getCondomEffect().getPotency().isNegative()) {
                                        return new Response("\u4fee\u590d(<i>1\u7cbe\u534e</i>)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u4fee\u590d\u907f\u5b55\u5957\uff01", null);
                                    }
                                    return new Response("\u7834\u574f", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u7834\u574f\u907f\u5b55\u5957\uff01", null);
                                }
                                return new Response("\u9644\u9b54", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u9644\u9b54\u8863\u7269\uff01", null);
                            }
                            if (index >= 6 && index <= 9 && index - 6 < clothing.getClothingType().getEquipSlots().size()) {
                                final InventorySlot slot = clothing.getClothingType().getEquipSlots().get(index - 6);
                                if (Main.sex.isCharacterImmobilised(Main.game.getPlayer())) {
                                    return new Response("\u88c5\u5907\uff1a" + Util.capitaliseSentence(slot.getName()), "\u4f60\u5f53\u524d\u5904\u4e8e[style.colourTerrible(\u65e0\u6cd5\u884c\u52a8)]\u72b6\u6001\uff0c\u65e0\u6cd5\u88c5\u5907\u6b64\u7269\u54c1\uff01", null);
                                }
                                if (clothing.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                    if (clothing.isAbleToBeEquippedDuringSex(slot).getKey().booleanValue()) {
                                        if (!Main.sex.getInitialSexManager().isAbleToEquipSexClothing(Main.game.getPlayer(), Main.game.getPlayer(), clothing)) {
                                            return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), "\u7531\u4e8e\u5904\u4e8e\u7279\u6b8a\u6027\u4ea4\u573a\u666f\u4e2d\uff0c\u4f60\u65e0\u6cd5\u88c5\u5907\u8863\u7269\uff01", null);
                                        }
                                        if (!Main.sex.isClothingEquipAvailable(Main.game.getPlayer(), slot, clothing)) {
                                            return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), "\u8be5\u680f\u4f4d\u4e0e\u5f53\u524d\u8fdb\u884c\u7684\u6027\u52a8\u4f5c\u6709\u5173\uff0c\u6240\u4ee5\u65e0\u6cd5\u5728\u5176\u4e0a\u88c5\u5907\u8863\u7269\uff01", null);
                                        }
                                        if (Main.game.getPlayer().isAbleToEquip(clothing, slot, false, Main.game.getPlayer())) {
                                            return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), "\u88c5\u5907" + clothing.getName() + "\u3002", Main.sex.SEX_DIALOGUE){

                                                @Override
                                                public void effects() {
                                                    AbstractClothing c = clothing;
                                                    InventoryDialogue.equipClothingFromInventory(Main.game.getPlayer(), slot, Main.game.getPlayer(), clothing);
                                                    Main.sex.setEquipClothingText(c, Main.game.getPlayer().getUnequipDescription());
                                                    Main.mainController.openInventory();
                                                    Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                                    Main.sex.setSexStarted(true);
                                                }
                                            };
                                        }
                                        return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), InventoryDialogue.getClothingBlockingRemovalText(Main.game.getPlayer(), "\u88c5\u5907"), null);
                                    }
                                    return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), clothing.isAbleToBeEquippedDuringSex(slot).getValue(), null);
                                }
                                return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), clothing.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index >= 11 && index <= 14 && index - 11 < clothing.getClothingType().getEquipSlots().size()) {
                                final InventorySlot slot = clothing.getClothingType().getEquipSlots().get(index - 11);
                                if (Main.sex.isCharacterImmobilised(Main.game.getPlayer())) {
                                    return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u4f60\u5f53\u524d\u5904\u4e8e[style.colourTerrible(\u65e0\u6cd5\u884c\u52a8)]\u72b6\u6001\uff0c\u65e0\u6cd5\u8ba9[npc.name]\u88c5\u5907" + clothing.getName() + "\uff01", new ParserTag[0]), null);
                                }
                                Util.Value<Boolean, String> equipAllowed = inventoryNPC.isInventoryEquipAllowed(clothing, slot);
                                if (!equipAllowed.getKey().booleanValue()) {
                                    return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, equipAllowed.getValue(), new ParserTag[0]), null);
                                }
                                if (clothing.isCanBeEquipped(inventoryNPC, slot)) {
                                    if (clothing.isAbleToBeEquippedDuringSex(slot).getKey().booleanValue()) {
                                        if (!Main.sex.getInitialSexManager().isAbleToEquipSexClothing(Main.game.getPlayer(), inventoryNPC, clothing)) {
                                            return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), "\u7531\u4e8e\u5904\u4e8e\u7279\u6b8a\u6027\u4ea4\u573a\u666f\u4e2d\uff0c\u4f60\u65e0\u6cd5\u88c5\u5907\u8863\u7269\uff01", null);
                                        }
                                        if (!Main.sex.isClothingEquipAvailable(inventoryNPC, slot, clothing)) {
                                            return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), "\u8be5\u680f\u4f4d\u4e0e\u5f53\u524d\u8fdb\u884c\u7684\u6027\u52a8\u4f5c\u6709\u5173\uff0c\u6240\u4ee5\u65e0\u6cd5\u5728\u5176\u4e0a\u88c5\u5907\u8863\u7269\uff01", null);
                                        }
                                        if (inventoryNPC.isAbleToEquip(clothing, slot, false, Main.game.getPlayer())) {
                                            return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u4ee4[npc.name]\u88c5\u5907" + clothing.getName() + "\u3002", new ParserTag[0]), Main.sex.SEX_DIALOGUE){

                                                @Override
                                                public void effects() {
                                                    AbstractClothing c = clothing;
                                                    InventoryDialogue.equipClothingFromInventory(inventoryNPC, slot, Main.game.getPlayer(), clothing);
                                                    Main.sex.setEquipClothingText(c, inventoryNPC.getUnequipDescription());
                                                    Main.mainController.openInventory();
                                                    Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                                    Main.sex.setSexStarted(true);
                                                }
                                            };
                                        }
                                        return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u65e0\u6cd5\u88c5\u5907" + clothing.getName() + "\uff0c\u539f\u56e0\u662f\u5176\u4ed6\u88c5\u5907\u963b\u6b62\u4e86[npc.herHim]\u8fd9\u4e48\u505a\uff01", new ParserTag[0]), null);
                                    }
                                    return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), clothing.isAbleToBeEquippedDuringSex(slot).getValue(), null);
                                }
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), clothing.getCannotBeEquippedText(inventoryNPC, slot), null);
                            }
                            return null;
                        }
                        case TRADING: {
                            if (index == 1) {
                                if (!clothing.getClothingType().isAbleToBeSold()) {
                                    return new Response("\u51fa\u552e(1)", "\u4f60\u4e0d\u80fd\u51fa\u552e" + clothing.getName() + "\uff01", null);
                                }
                                if (inventoryNPC.willBuy(clothing)) {
                                    final int sellPrice = clothing.getPrice(inventoryNPC.getBuyModifier());
                                    return new Response("\u51fa\u552e(1) (" + UtilText.formatAsMoney(sellPrice, "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice) + "\u7684\u4ef7\u683c\u51fa\u552e" + clothing.getName() + "\u3002", INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.sellClothing(Main.game.getPlayer(), inventoryNPC, clothing, 1, sellPrice);
                                        }
                                    };
                                }
                                return new Response("\u51fa\u552e(1)", inventoryNPC.getName("") + "\u4e0d\u60f3\u4e70\u8fd9\u4e2a\u3002", null);
                            }
                            if (index == 2) {
                                if (!clothing.getClothingType().isAbleToBeSold()) {
                                    return new Response("\u51fa\u552e(5)", "\u4f60\u4e0d\u80fd\u51fa\u552e" + clothing.getName() + "\uff01", null);
                                }
                                if (Main.game.getPlayer().getClothingCount(clothing) >= 5) {
                                    if (inventoryNPC.willBuy(clothing)) {
                                        final int sellPrice = clothing.getPrice(inventoryNPC.getBuyModifier());
                                        return new Response("\u51fa\u552e(5) (" + UtilText.formatAsMoney(sellPrice * 5, "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice * 5) + "\u7684\u4ef7\u683c\u89e6\u624b\u4e94\u4e2a" + clothing.getNamePlural() + "\u3002", INVENTORY_MENU){

                                            @Override
                                            public void effects() {
                                                InventoryDialogue.sellClothing(Main.game.getPlayer(), inventoryNPC, clothing, 5, sellPrice);
                                            }
                                        };
                                    }
                                    return new Response("\u51fa\u552e(5)", inventoryNPC.getName("") + "\u4e0d\u60f3\u4e70\u8fd9\u4e9b\u3002", null);
                                }
                                return new Response("\u51fa\u552e(5)", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u4e94\u4e2a" + clothing.getNamePlural() + "\uff01", null);
                            }
                            if (index == 3) {
                                if (!clothing.getClothingType().isAbleToBeSold()) {
                                    return new Response("\u51fa\u552e(\u6240\u6709)", "\u4f60\u4e0d\u80fd\u51fa\u552e" + clothing.getName() + "\uff01", null);
                                }
                                if (inventoryNPC.willBuy(clothing)) {
                                    final int sellPrice = clothing.getPrice(inventoryNPC.getBuyModifier());
                                    return new Response("\u51fa\u552e(\u6240\u6709) (" + UtilText.formatAsMoney(sellPrice * Main.game.getPlayer().getClothingCount(clothing), "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice * Main.game.getPlayer().getClothingCount(clothing)) + "\u7684\u4ef7\u683c\u51fa\u552e" + clothing.getName() + "\u3002", INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.sellClothing(Main.game.getPlayer(), inventoryNPC, clothing, Main.game.getPlayer().getClothingCount(clothing), sellPrice);
                                        }
                                    };
                                }
                                return new Response("\u51fa\u552e(\u6240\u6709)", inventoryNPC.getName("") + "\u4e0d\u60f3\u4e70\u8fd9\u4e9b\u3002", null);
                            }
                            if (index == 4) {
                                if (InventoryDialogue.isClothingDyeActionAvailable()) {
                                    boolean canDye;
                                    boolean hasFullInventory = Main.game.getPlayer().isInventoryFull() && clothing.getRarity() != Rarity.QUEST;
                                    boolean isDyeingStackItem = Main.game.getPlayer().getAllClothingInInventory().get(clothing) > 1;
                                    boolean bl = canDye = !isDyeingStackItem || !hasFullInventory;
                                    if (canDye) {
                                        return new Response("\u67d3\u8272", Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u4f7f\u7528\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\u4e3a\u8be5\u7269\u54c1\u67d3\u8272\u3002" : "\u4f7f\u7528\u67d3\u8272\u5237\u6765\u67d3\u8272\u8863\u7269\u3002", DYE_CLOTHING){

                                            @Override
                                            public void effects() {
                                                InventoryDialogue.resetClothingDyeColours();
                                            }
                                        };
                                    }
                                    return new Response("\u67d3\u8272", "\u4f60\u7684\u7269\u54c1\u680f\u6ee1\u4e86\uff0c\u65e0\u6cd5\u67d3\u8272\u8fd9\u4ef6\u8863\u7269\u3002", null);
                                }
                                return new Response("\u67d3\u8272", "\u4f60\u9700\u8981\u627e\u5230\u67d3\u8272\u5237\u624d\u80fd\u67d3\u8272\u8863\u7269\u3002", null);
                            }
                            if (index == 5) {
                                if (clothing.isCondom()) {
                                    return InventoryDialogue.getCondomSabotageResponse(clothing);
                                }
                                if (Main.game.isDebugMode() || Main.game.getPlayer().hasQuest(QuestLine.SIDE_ENCHANTMENT_DISCOVERY) && Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ENCHANTMENT_DISCOVERY)) {
                                    if (clothing.getEnchantmentItemType(null) == null || clothing.getItemTags().contains((Object)ItemTag.UNENCHANTABLE)) {
                                        return new Response("\u9644\u9b54", "\u8be5\u8863\u7269\u65e0\u6cd5\u9644\u9b54\uff01", null);
                                    }
                                    if (!clothing.isEnchantmentKnown()) {
                                        if (Main.game.getPlayer().getEssenceCount() >= 15) {
                                            return new Response("\u9274\u5b9a([style.italicsArcane(15\u7cbe\u534e)])", "\u4e3a\u4e86\u9274\u5b9a" + clothing.getName() + "\uff0c\u4f60\u9700\u8981\u4ed8\u51fa15\u5965\u672f\u7cbe\u534e\u81ea\u5df1\u5b8c\u6210\uff0c\u6216\u524d\u5f80\u5546\u5e97\u4ed8\u51fa1000\u706b\u5e01\u8ba9\u522b\u4eba\u5e2e\u5fd9\u3002", CLOTHING_INVENTORY){

                                                @Override
                                                public void effects() {
                                                    Main.game.getPlayer().incrementEssenceCount(-15, false);
                                                    String enchantmentRemovedString = clothing.setEnchantmentKnown(owner, true);
                                                    clothing = AbstractClothing.enchantmentRemovedClothing;
                                                    Main.game.getTextEndStringBuilder().append("<p>\u4f60\u5f15\u5bfc" + Util.intToString(15L) + "\u5965\u672f\u7cbe\u534e\u7684\u80fd\u91cf\u8fdb\u5165\u4e86" + clothing.getName() + "\uff0c\u5b83\u53d1\u51fa\u4e00\u9635\u6de1\u7d2b\u8272\u5149\u8292\u540e\uff0c\u4f60\u53d1\u73b0\u81ea\u5df1\u5df2\u7ecf\u80fd\u591f\u68c0\u6d4b\u5230\u5176\u4e0a\u7684\u9644\u9b54\u79cd\u7c7b\u4e86\uff01</p>" + enchantmentRemovedString + "<p style='text-align:center;'>\u9274\u5b9a" + clothing.getName() + "\u6d88\u8017\u4e86\u4f60[style.boldBad(" + Util.intToString(15L) + ")][style.boldArcane(\u5965\u672f\u7cbe\u534e)]\uff01</p>");
                                                    RenderingEngine.setPage(Main.game.getPlayer(), clothing);
                                                }
                                            };
                                        }
                                        return new Response("\u9274\u5b9a(<i>15\u7cbe\u534e</i>)", "\u4f60\u9700\u8981\u4ed8\u51fa15\u5965\u672f\u7cbe\u534e\u81ea\u5df1\u5b8c\u6210([style.italicsBad(\u4f46\u4f60\u7684\u7cbe\u534e\u4e0d\u8db3)])\uff0c\u6216\u524d\u5f80\u5546\u5e97\u4ed8\u51fa1000\u706b\u5e01\u8ba9\u522b\u4eba\u5e2e\u5fd9\u3002", null);
                                    }
                                    return new Response("\u9644\u9b54", "\u9644\u9b54\u8be5\u8863\u7269\u3002", EnchantmentDialogue.ENCHANTMENT_MENU){

                                        @Override
                                        public DialogueNode getNextDialogue() {
                                            return EnchantmentDialogue.getEnchantmentMenu(clothing);
                                        }
                                    };
                                }
                                return new Response("\u9644\u9b54", InventoryDialogue.getEnchantmentNotDiscoveredText("clothing"), null);
                            }
                            if (index >= 6 && index <= 9 && index - 6 < clothing.getClothingType().getEquipSlots().size()) {
                                final InventorySlot slot = clothing.getClothingType().getEquipSlots().get(index - 6);
                                if (clothing.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                    return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), "\u88c5\u5907" + clothing.getName() + "\u3002", INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.equipClothingFromInventory(Main.game.getPlayer(), slot, Main.game.getPlayer(), clothing) + "</p>");
                                        }
                                    };
                                }
                                return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), clothing.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                            }
                            if (index == 9) {
                                return InventoryDialogue.getBuybackResponse();
                            }
                            if (index >= 11 && index <= 14 && index - 11 < clothing.getClothingType().getEquipSlots().size()) {
                                InventorySlot slot = clothing.getClothingType().getEquipSlots().get(index - 11);
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u4e0d\u60f3\u7a7f\u4f60\u7684\u8863\u7269\u3002", new ParserTag[0]), null);
                            }
                            if (index == 10 && !clothing.isEnchantmentKnown()) {
                                if (!inventoryNPC.willBuy(clothing)) {
                                    return new Response("\u9274\u5b9a", inventoryNPC.getName("") + "\u65e0\u6cd5\u9274\u5b9a\u8863\u7269\uff01", null);
                                }
                                if (Main.game.getPlayer().getMoney() < 1000L) {
                                    return new Response("\u9274\u5b9a(" + UtilText.formatAsMoneyUncoloured(1000L, "span") + ")", "\u4f60\u7684\u94b1\u4e0d\u591f\uff01", null);
                                }
                                return new Response("\u9274\u5b9a(" + UtilText.formatAsMoney(1000L, "span") + ")", "\u4ee5" + UtilText.formatAsMoney(1000L, "span") + "\u7684\u4ef7\u683c\u8ba9" + clothing.getName() + "\u9274\u5b9a\u3002", CLOTHING_INVENTORY){

                                    @Override
                                    public void effects() {
                                        Main.game.getPlayer().incrementMoney(-1000L);
                                        String enchantmentRemovedString = clothing.setEnchantmentKnown(owner, true);
                                        clothing = AbstractClothing.enchantmentRemovedClothing;
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + UtilText.parse((GameCharacter)inventoryNPC, "\u4f60\u5c06" + UtilText.formatAsMoney(1000L) + "\u9012\u7ed9\u4e86[npc.name]\uff0c\u5bf9\u65b9\u5148\u662f\u5728\u7279\u6b8a\u7684\u68c0\u5b9a\u88c5\u7f6e\u4e0a\u6492\u4e86\u51e0\u74f6\u5965\u672f\u7cbe\u534e\uff0c\u63a5\u7740\u4fbf\u7528\u8fd9\u4e2a\u88c5\u7f6e\u5c55\u793a\u51fa\u4e86" + clothing.getName() + "\u4e0a\u7684\u9644\u9b54\u3002", new ParserTag[0]) + "</p>" + enchantmentRemovedString);
                                        RenderingEngine.setPage(Main.game.getPlayer(), clothing);
                                    }
                                };
                            }
                            return null;
                        }
                    }
                } else {
                    if (inventoryNPC == null) {
                        boolean inventoryFull = Main.game.getPlayer().isInventoryFull() && !Main.game.getPlayer().hasClothing(clothing) && clothing.getRarity() != Rarity.QUEST;
                        switch (interactionType) {
                            case CHARACTER_CREATION: {
                                if (index == 1) {
                                    if (Main.game.getPlayer().isCoverableAreaVisible(CoverableArea.NIPPLES) || Main.game.getPlayer().isCoverableAreaVisible(CoverableArea.ANUS) || Main.game.getPlayer().isCoverableAreaVisible(CoverableArea.PENIS) || Main.game.getPlayer().isCoverableAreaVisible(CoverableArea.VAGINA) || Main.game.getPlayer().getClothingInSlot(InventorySlot.FOOT) == null && Main.game.getPlayer().getLegType().equals(LegType.HUMAN)) {
                                        return new Response("\u524d\u5f80\u821e\u53f0", "\u4f60\u9700\u8981\u5148\u7a7f\u597d\u80fd\u591f\u906e\u76d6\u8eab\u4f53\u7684\u8863\u7269\uff0c\u8fd8\u9700\u8981\u4e00\u53cc\u978b\u3002", null);
                                    }
                                    return new Response("\u524d\u5f80\u821e\u53f0", "\u4f60\u5df2\u7ecf\u51c6\u5907\u597d\u524d\u5f80\u821e\u53f0\u4e86\u3002", CharacterCreation.CHOOSE_BACKGROUND){

                                        @Override
                                        public void effects() {
                                            CharacterCreation.moveNPCIntoPlayerTile();
                                        }
                                    };
                                }
                                if (index == 4) {
                                    if (Main.game.getPlayer().getClothingCurrentlyEquipped().isEmpty()) {
                                        return new Response("\u8131\u4e0b\u6240\u6709\u8863\u7269", "\u4f60\u73b0\u5728\u5df2\u7ecf\u5149\u7740\u4e86\uff0c\u6ca1\u6709\u8863\u7269\u53ef\u4ee5\u8131\u3002", null);
                                    }
                                    return new Response("\u8131\u4e0b\u6240\u6709\u8863\u7269", "\u5c3d\u53ef\u80fd\u5730\u8131\u4e0b\u8863\u7269\u3002", INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append(InventoryDialogue.unequipAll(Main.game.getPlayer()));
                                        }
                                    };
                                }
                                if (index == 5) {
                                    return new Response("\u66f4\u6539\u989c\u8272", "\u66f4\u6539\u8fd9\u4ef6\u8863\u7269\u7684\u989c\u8272\u3002", DYE_CLOTHING_CHARACTER_CREATION){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.resetClothingDyeColours();
                                        }
                                    };
                                }
                                if (index >= 6 && index <= 9 && index - 6 < clothing.getClothingType().getEquipSlots().size()) {
                                    final InventorySlot slot = clothing.getClothingType().getEquipSlots().get(index - 6);
                                    if (clothing.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                        return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), "\u88c5\u5907" + clothing.getName() + "\u3002", INVENTORY_MENU){

                                            @Override
                                            public void effects() {
                                                InventoryDialogue.equipClothingFromGround(Main.game.getPlayer(), slot, Main.game.getPlayer(), clothing);
                                            }
                                        };
                                    }
                                    return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), clothing.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                                }
                                return null;
                            }
                            case SEX: {
                                if (index == 1) {
                                    return new Response("\u62ff\u53d6(1)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u62ff\u8d77\u8863\u7269\u3002", null);
                                }
                                if (index == 2) {
                                    return new Response("\u62ff\u53d6(5)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u62ff\u8d77\u8863\u7269\u3002", null);
                                }
                                if (index == 3) {
                                    return new Response("\u62ff\u53d6(\u6240\u6709)", "\u81ea\u6170\u65f6\u65e0\u6cd5\u62ff\u8d77\u8863\u7269\u3002", null);
                                }
                                if (index == 4) {
                                    return new Response("\u67d3\u8272", "\u81ea\u6170\u65f6\u65e0\u6cd5\u67d3\u8272\u8863\u7269\u3002", null);
                                }
                                if (index == 5) {
                                    if (clothing.isCondom()) {
                                        if (clothing.getCondomEffect().getPotency().isNegative()) {
                                            return new Response("\u4fee\u590d(<i>1\u7cbe\u534e</i>)", "\u65e0\u6cd5\u4fee\u590d\u5730\u4e0a\u7684\u907f\u5b55\u5957\uff01", null);
                                        }
                                        return new Response("\u7834\u574f", "\u65e0\u6cd5\u7834\u574f\u5730\u4e0a\u7684\u907f\u5b55\u5957\uff01", null);
                                    }
                                    if (!clothing.isEnchantmentKnown()) {
                                        return new Response("\u9274\u5b9a", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u9274\u5b9a\u8863\u7269\uff01", null);
                                    }
                                    return new Response("\u9644\u9b54", "\u4f60\u65e0\u6cd5\u9644\u9b54\u5728\u5730\u4e0a\u7684\u8863\u7269\uff01", null);
                                }
                                if (index >= 6 && index <= 9 && index - 6 < clothing.getClothingType().getEquipSlots().size()) {
                                    final InventorySlot slot = clothing.getClothingType().getEquipSlots().get(index - 6);
                                    if (Main.sex.isCharacterImmobilised(Main.game.getPlayer())) {
                                        return new Response("\u88c5\u5907\uff1a" + Util.capitaliseSentence(slot.getName()), "\u4f60\u5f53\u524d\u5904\u4e8e[style.colourTerrible(\u65e0\u6cd5\u884c\u52a8)]\u72b6\u6001\uff0c\u65e0\u6cd5\u88c5\u5907\u6b64\u7269\u54c1\uff01", null);
                                    }
                                    if (clothing.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                        if (clothing.isAbleToBeEquippedDuringSex(slot).getKey().booleanValue()) {
                                            if (!Main.sex.getInitialSexManager().isAbleToEquipSexClothing(Main.game.getPlayer(), Main.game.getPlayer(), clothing)) {
                                                return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), "\u7531\u4e8e\u5904\u4e8e\u7279\u6b8a\u6027\u4ea4\u573a\u666f\u4e2d\uff0c\u4f60\u65e0\u6cd5\u88c5\u5907\u8863\u7269\uff01", null);
                                            }
                                            if (!Main.sex.isClothingEquipAvailable(Main.game.getPlayer(), slot, clothing)) {
                                                return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), "\u8be5\u680f\u4f4d\u4e0e\u5f53\u524d\u8fdb\u884c\u7684\u6027\u52a8\u4f5c\u6709\u5173\uff0c\u6240\u4ee5\u65e0\u6cd5\u5728\u5176\u4e0a\u88c5\u5907\u8863\u7269\uff01", null);
                                            }
                                            if (Main.game.getPlayer().isAbleToEquip(clothing, slot, false, Main.game.getPlayer())) {
                                                return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), "\u88c5\u5907" + clothing.getName() + "\u3002", Main.sex.SEX_DIALOGUE){

                                                    @Override
                                                    public void effects() {
                                                        AbstractClothing c = clothing;
                                                        InventoryDialogue.equipClothingFromGround(Main.game.getPlayer(), slot, Main.game.getPlayer(), clothing);
                                                        Main.sex.setEquipClothingText(c, Main.game.getPlayer().getUnequipDescription());
                                                        Main.mainController.openInventory();
                                                        Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                                        Main.sex.setSexStarted(true);
                                                    }
                                                };
                                            }
                                            return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), InventoryDialogue.getClothingBlockingRemovalText(Main.game.getPlayer(), "\u88c5\u5907"), null);
                                        }
                                        return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), clothing.isAbleToBeEquippedDuringSex(slot).getValue(), null);
                                    }
                                    return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), clothing.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                                }
                                if (index == 10) {
                                    return InventoryDialogue.getQuickTradeResponse();
                                }
                                return null;
                            }
                        }
                        if (index == 1) {
                            if (inventoryFull) {
                                return new Response("\u62ff\u53d6(1)", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                            }
                            return new Response("\u62ff\u53d6(1)", "\u4ece\u5730\u4e0a\u62ff\u53d6\u4e00\u4e2a" + clothing.getName() + "\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    InventoryDialogue.pickUpClothing(Main.game.getPlayer(), clothing, 1);
                                }
                            };
                        }
                        if (index == 2) {
                            if (inventoryFull) {
                                return new Response("\u62ff\u53d6(5)", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                            }
                            if (Main.game.getPlayerCell().getInventory().getClothingCount(clothing) >= 5) {
                                return new Response("\u62ff\u53d6(5)", "\u4ece\u5730\u4e0a\u62ff\u53d6\u4e94\u4e2a" + clothing.getNamePlural() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.pickUpClothing(Main.game.getPlayer(), clothing, 5);
                                    }
                                };
                            }
                            return new Response("\u62ff\u53d6(5)", "\u5730\u4e0a\u4e0d\u8db3\u4e94\u4e2a" + clothing.getNamePlural() + "\uff01", null);
                        }
                        if (index == 3) {
                            if (inventoryFull) {
                                return new Response("\u62ff\u53d6(\u6240\u6709)", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                            }
                            return new Response("\u62ff\u53d6(\u6240\u6709)", "\u4ece\u5730\u4e0a\u62ff\u53d6\u6240\u6709" + clothing.getNamePlural() + "\u3002", INVENTORY_MENU){

                                @Override
                                public void effects() {
                                    InventoryDialogue.pickUpClothing(Main.game.getPlayer(), clothing, Main.game.getPlayerCell().getInventory().getClothingCount(clothing));
                                }
                            };
                        }
                        if (index == 4) {
                            if (InventoryDialogue.isClothingDyeActionAvailable()) {
                                boolean canDye;
                                boolean hasFullInventory = Main.game.getPlayerCell().getInventory().isInventoryFull();
                                boolean isDyeingStackItem = Main.game.getPlayerCell().getInventory().getAllClothingInInventory().get(clothing) > 1;
                                boolean bl = canDye = !isDyeingStackItem || !hasFullInventory;
                                if (canDye) {
                                    return new Response("\u67d3\u8272", Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u4f7f\u7528\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\u4e3a\u8be5\u7269\u54c1\u67d3\u8272\u3002" : "\u4f7f\u7528\u67d3\u8272\u5237\u6765\u67d3\u8272\u8863\u7269\u3002", DYE_CLOTHING){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.resetClothingDyeColours();
                                        }
                                    };
                                }
                                return new Response("\u67d3\u8272", "\u4f60\u7684\u7269\u54c1\u680f\u6ee1\u4e86\uff0c\u65e0\u6cd5\u67d3\u8272\u8fd9\u4ef6\u8863\u7269\u3002", null);
                            }
                            return new Response("\u67d3\u8272", "\u4f60\u9700\u8981\u627e\u5230\u67d3\u8272\u5237\u624d\u80fd\u67d3\u8272\u8863\u7269\u3002", null);
                        }
                        if (index == 5) {
                            if (clothing.isCondom()) {
                                if (clothing.getCondomEffect().getPotency().isNegative()) {
                                    return new Response("\u4fee\u590d(<i>1\u7cbe\u534e</i>)", "\u65e0\u6cd5\u4fee\u590d\u5730\u4e0a\u7684\u907f\u5b55\u5957\uff01", null);
                                }
                                return new Response("\u7834\u574f", "\u65e0\u6cd5\u7834\u574f\u5730\u4e0a\u7684\u907f\u5b55\u5957\uff01", null);
                            }
                            if (!clothing.isEnchantmentKnown()) {
                                if (Main.game.getPlayer().getEssenceCount() >= 15) {
                                    return new Response("\u9274\u5b9a([style.italicsArcane(15\u7cbe\u534e)])", "\u4e3a\u4e86\u9274\u5b9a" + clothing.getName() + "\uff0c\u4f60\u9700\u8981\u4ed8\u51fa15\u5965\u672f\u7cbe\u534e\u81ea\u5df1\u5b8c\u6210\uff0c\u6216\u524d\u5f80\u5546\u5e97\u4ed8\u51fa1000\u706b\u5e01\u8ba9\u522b\u4eba\u5e2e\u5fd9\u3002", CLOTHING_INVENTORY){

                                        @Override
                                        public void effects() {
                                            Main.game.getPlayer().incrementEssenceCount(-15, false);
                                            Main.game.getPlayerCell().getInventory().removeClothing(clothing);
                                            String enchantmentRemovedString = clothing.setEnchantmentKnown(owner, true);
                                            Main.game.getPlayerCell().getInventory().addClothing(clothing);
                                            Main.game.getTextEndStringBuilder().append("<p>\u4f60\u5f15\u5bfc" + Util.intToString(15L) + "\u5965\u672f\u7cbe\u534e\u7684\u80fd\u91cf\u8fdb\u5165\u4e86" + clothing.getName() + "\uff0c\u5b83\u53d1\u51fa\u4e00\u9635\u6de1\u7d2b\u8272\u5149\u8292\u540e\uff0c\u4f60\u53d1\u73b0\u81ea\u5df1\u5df2\u7ecf\u80fd\u591f\u68c0\u6d4b\u5230\u5176\u4e0a\u7684\u9644\u9b54\u79cd\u7c7b\u4e86\uff01</p>" + enchantmentRemovedString + "<p style='text-align:center;'>\u9274\u5b9a" + clothing.getName() + "\u6d88\u8017\u4e86\u4f60[style.boldBad(" + Util.intToString(15L) + ")][style.boldArcane(\u5965\u672f\u7cbe\u534e)]\uff01</p>");
                                            RenderingEngine.setPage(Main.game.getPlayer(), clothing);
                                        }
                                    };
                                }
                                return new Response("\u9274\u5b9a(<i>15\u7cbe\u534e</i>)", "\u4f60\u9700\u8981\u4ed8\u51fa15\u5965\u672f\u7cbe\u534e\u81ea\u5df1\u5b8c\u6210([style.italicsBad(\u4f46\u4f60\u7684\u7cbe\u534e\u4e0d\u8db3)])\uff0c\u6216\u524d\u5f80\u5546\u5e97\u4ed8\u51fa1000\u706b\u5e01\u8ba9\u522b\u4eba\u5e2e\u5fd9\u3002", null);
                            }
                            return new Response("\u9644\u9b54", "\u4f60\u65e0\u6cd5\u9644\u9b54\u5728\u5730\u4e0a\u7684\u8863\u7269\uff01", null);
                        }
                        if (index >= 6 && index <= 9 && index - 6 < clothing.getClothingType().getEquipSlots().size()) {
                            final InventorySlot slot = clothing.getClothingType().getEquipSlots().get(index - 6);
                            if (clothing.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), "\u88c5\u5907" + clothing.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.equipClothingFromGround(Main.game.getPlayer(), slot, Main.game.getPlayer(), clothing) + "</p>");
                                    }
                                };
                            }
                            return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), clothing.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                        }
                        if (index == 10) {
                            return InventoryDialogue.getQuickTradeResponse();
                        }
                        return null;
                    }
                    boolean inventoryFull = false;
                    switch (interactionType) {
                        case COMBAT: {
                            if (index == 1) {
                                return new Response("\u62ff\u53d6(1)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u62ff\u53d6\u4ed6\u4eba\u7684\u8863\u7269\uff01", null);
                            }
                            if (index == 2) {
                                return new Response("\u62ff\u53d6(5)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u62ff\u53d6\u4ed6\u4eba\u7684\u8863\u7269\uff01", null);
                            }
                            if (index == 3) {
                                return new Response("\u62ff\u53d6(\u6240\u6709)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u62ff\u53d6\u4ed6\u4eba\u7684\u8863\u7269\uff01", null);
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u67d3\u8272\u4ed6\u4eba\u7684\u8863\u7269\uff01", null);
                            }
                            if (index == 5) {
                                if (clothing.isCondom()) {
                                    if (clothing.getCondomEffect().getPotency().isNegative()) {
                                        return new Response("\u4fee\u590d(<i>1\u7cbe\u534e</i>)", "\u65e0\u6cd5\u4fee\u590d\u4ed6\u4eba\u7684\u907f\u5b55\u5957\uff0c\u5c24\u5176\u662f\u5728\u6218\u6597\u8fc7\u7a0b\u4e2d\uff01", null);
                                    }
                                    return new Response("\u7834\u574f", "\u65e0\u6cd5\u7834\u574f\u4ed6\u4eba\u7684\u907f\u5b55\u5957\uff0c\u5c24\u5176\u662f\u5728\u6218\u6597\u8fc7\u7a0b\u4e2d\uff01", null);
                                }
                                return new Response("\u9644\u9b54", "\u4f60\u6cd5\u9644\u9b54\u5176\u4ed6\u4eba\u7684\u8863\u7269\uff0c\u5c24\u5176\u662f\u5728\u6218\u6597\u8fc7\u7a0b\u4e2d\uff01", null);
                            }
                            if (index == 6) {
                                return new Response("\u88c5\u5907(\u81ea\u5df1)", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u4f7f\u7528\u4ed6\u4eba\u7684\u8863\u7269\uff01", null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index == 11) {
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:([npc.HerHim])", new ParserTag[0]), "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u4ee4\u4ed6\u4eba\u7a7f\u4e0a\u8863\u7269\uff01", null);
                            }
                            return null;
                        }
                        case FULL_MANAGEMENT: 
                        case CHARACTER_CREATION: {
                            boolean bl = inventoryFull = Main.game.getPlayer().isInventoryFull() && !Main.game.getPlayer().hasClothing(clothing) && clothing.getRarity() != Rarity.QUEST;
                            if (index == 1) {
                                if (inventoryFull) {
                                    return new Response("\u62ff\u53d6(1)", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                                }
                                return new Response("\u62ff\u53d6(1)", UtilText.parse((GameCharacter)inventoryNPC, "\u4ece[npc.Name]\u5904\u62ff\u53d6" + clothing.getName() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.transferClothing(inventoryNPC, Main.game.getPlayer(), clothing, 1);
                                    }
                                };
                            }
                            if (index == 2) {
                                if (inventoryFull) {
                                    return new Response("\u62ff\u53d6(5)", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                                }
                                if (inventoryNPC.getClothingCount(clothing) >= 5) {
                                    return new Response("\u62ff\u53d6(5)", UtilText.parse((GameCharacter)inventoryNPC, "\u4ece[npc.Name]\u5904\u62ff\u53d6\u4e94\u4e2a" + clothing.getNamePlural() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.transferClothing(inventoryNPC, Main.game.getPlayer(), clothing, 5);
                                        }
                                    };
                                }
                                return new Response("\u62ff\u53d6(5)", UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u6ca1\u6709\u4e94\u4e2a" + clothing.getNamePlural() + "\uff01", new ParserTag[0]), null);
                            }
                            if (index == 3) {
                                if (inventoryFull) {
                                    return new Response("\u62ff\u53d6(\u6240\u6709)", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                                }
                                return new Response("\u62ff\u53d6(\u6240\u6709)", UtilText.parse((GameCharacter)inventoryNPC, "\u4ece[npc.Name]\u5904\u62ff\u53d6\u6240\u6709" + Util.intToString(inventoryNPC.getClothingCount(clothing)) + "\u4e2a" + clothing.getNamePlural() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.transferClothing(inventoryNPC, Main.game.getPlayer(), clothing, inventoryNPC.getClothingCount(clothing));
                                    }
                                };
                            }
                            if (index == 4) {
                                if (InventoryDialogue.isClothingDyeActionAvailable()) {
                                    boolean canDye;
                                    boolean hasFullInventory = inventoryNPC.isInventoryFull();
                                    boolean isDyeingStackItem = clothing != null && inventoryNPC.getAllClothingInInventory().get(clothing) > 1;
                                    boolean bl3 = canDye = !isDyeingStackItem || !hasFullInventory;
                                    if (canDye) {
                                        return new Response("\u67d3\u8272", Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u4f7f\u7528\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\u4e3a\u8be5\u7269\u54c1\u67d3\u8272\u3002" : "\u4f7f\u7528\u67d3\u8272\u5237\u6765\u67d3\u8272\u8863\u7269\u3002", DYE_CLOTHING){

                                            @Override
                                            public void effects() {
                                                InventoryDialogue.resetClothingDyeColours();
                                            }
                                        };
                                    }
                                    return new Response("\u67d3\u8272", UtilText.parse((GameCharacter)inventoryNPC, "[npc.NamePos]\u7684\u7269\u54c1\u680f\u6ee1\u4e86\uff0c\u65e0\u6cd5\u67d3\u8272\u8fd9\u4ef6\u8863\u7269\u3002", new ParserTag[0]), null);
                                }
                                return new Response("\u67d3\u8272", UtilText.parse((GameCharacter)inventoryNPC, "\u4f60\u9700\u8981\u627e\u5230\u53e6\u4e00\u4e2a\u67d3\u8272\u5237\u624d\u80fd\u67d3\u8272[npc.namePos]\u7684\u8863\u7269\u3002", new ParserTag[0]), null);
                            }
                            if (index == 5) {
                                if (clothing.isCondom()) {
                                    if (clothing.getCondomEffect().getPotency().isNegative()) {
                                        return new Response("\u4fee\u590d(<i>1\u7cbe\u534e</i>)", "\u65e0\u6cd5\u4fee\u590d\u7531\u4ed6\u4eba\u62e5\u6709\u7684\u907f\u5b55\u5957\uff01", null);
                                    }
                                    return new Response("\u7834\u574f", "\u65e0\u6cd5\u7834\u574f\u7531\u4ed6\u4eba\u62e5\u6709\u7684\u907f\u5b55\u5957\uff01", null);
                                }
                                return new Response("\u9644\u9b54", "\u65e0\u6cd5\u9644\u9b54\u7531\u5176\u4ed6\u4eba\u62e5\u6709\u7684\u8863\u7269\uff01", null);
                            }
                            if (index >= 6 && index <= 9 && index - 6 < clothing.getClothingType().getEquipSlots().size()) {
                                final InventorySlot slot = clothing.getClothingType().getEquipSlots().get(index - 6);
                                if (clothing.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                    return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), "\u88c5\u5907" + clothing.getName() + "\u3002", INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.equipClothingFromInventory(Main.game.getPlayer(), slot, Main.game.getPlayer(), clothing) + "</p>");
                                        }
                                    };
                                }
                                return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), clothing.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index >= 11 && index <= 14 && index - 11 < clothing.getClothingType().getEquipSlots().size()) {
                                final InventorySlot slot = clothing.getClothingType().getEquipSlots().get(index - 11);
                                Util.Value<Boolean, String> equipAllowed = inventoryNPC.isInventoryEquipAllowed(clothing, slot);
                                if (!equipAllowed.getKey().booleanValue()) {
                                    return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, equipAllowed.getValue(), new ParserTag[0]), null);
                                }
                                if (clothing.isCanBeEquipped(inventoryNPC, slot)) {
                                    if (inventoryNPC.isAbleToEquip(clothing, slot, true, Main.game.getPlayer()) && clothing.isEnslavementClothing() && (!inventoryNPC.isSlave() || !inventoryNPC.getOwner().isPlayer())) {
                                        boolean willEnslave = !inventoryNPC.isSlave() && inventoryNPC.isAbleToBeEnslaved() && Main.game.getPlayer().isHasSlaverLicense();
                                        return new Response(UtilText.parse((GameCharacter)inventoryNPC, !willEnslave ? "[style.colourMinorBad(\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim]))]" : "[style.colourArcane(\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim]))]", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u4ee4[npc.name]\u88c5\u5907" + clothing.getName() + "\u3002" + (!willEnslave ? "<br/><i>\u5c3d\u7ba1" + clothing.getName() + (clothing.getClothingType().isPlural() != false ? "\u62e5\u6709\u5974\u5f79\u9644\u9b54\uff0c\u5b83" : "\u62e5\u6709\u5974\u5f79\u9644\u9b54\uff0c\u5b83") + "[style.colourMinorBad(\u65e0\u6cd5\u5974\u5f79[npc.name])]\uff0c\u539f\u56e0\u662f" + (Main.game.getPlayer().isHasSlaverLicense() ? "[npc.sheIsFull]\u5e76\u975e\u5408\u9002\u7684\u5974\u5f79\u5bf9\u8c61" : "\u4f60\u6ca1\u6709\u8d29\u5974\u8bb8\u53ef") + "\uff01</i>" : "<br/><i>\u591a\u4e8f\u4e86" + clothing.getName() + (clothing.getClothingType().isPlural() != false ? "\u62e5\u6709\u5974\u5f79\u9644\u9b54\uff0c\u5b83" : "\u62e5\u6709\u5974\u5f79\u9644\u9b54\uff0c\u5b83") + "[style.colourArcane(\u80fd\u591f\u5974\u5f79[npc.name])]\uff0c\u4ee4\u4f60\u6210\u4e3a[npc.her]\u7684\u65b0\u4e3b\u4eba\uff01</i>"), new ParserTag[0]), INVENTORY_MENU){

                                            @Override
                                            public DialogueNode getNextDialogue() {
                                                if (inventoryNPC.getEnslavementDialogue(clothing) != null) {
                                                    return inventoryNPC.getEnslavementDialogue(clothing);
                                                }
                                                return INVENTORY_MENU;
                                            }

                                            @Override
                                            public void effects() {
                                                ArrayList<NPC> enslavementTargets = new ArrayList<NPC>(Main.game.getNonCompanionCharactersPresent());
                                                enslavementTargets.removeIf(npc -> !Main.combat.getEnemies(Main.game.getPlayer()).contains(npc));
                                                if (enslavementTargets.size() <= 1) {
                                                    SlaveDialogue.setFollowupEnslavementDialogue(Main.game.getDefaultDialogue(false));
                                                } else {
                                                    SlaveDialogue.setFollowupEnslavementDialogue(Main.game.getSavedDialogueNode());
                                                }
                                                if (inventoryNPC.getEnslavementDialogue(clothing) == null) {
                                                    Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.equipClothingFromInventory(inventoryNPC, slot, Main.game.getPlayer(), clothing) + "</p>");
                                                } else {
                                                    InventoryDialogue.equipClothingFromInventory(inventoryNPC, slot, Main.game.getPlayer(), clothing);
                                                }
                                            }
                                        };
                                    }
                                    return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u4ee4[npc.name]\u88c5\u5907" + clothing.getName() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.equipClothingFromInventory(inventoryNPC, slot, Main.game.getPlayer(), clothing) + "</p>");
                                        }
                                    };
                                }
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), clothing.getCannotBeEquippedText(inventoryNPC, slot), null);
                            }
                            return null;
                        }
                        case SEX: {
                            if (index == 1) {
                                return new Response("\u62ff\u53d6(1)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u62ff\u8d70\u4ed6\u4eba\u8863\u7269\uff01", null);
                            }
                            if (index == 2) {
                                return new Response("\u62ff\u53d6(5)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u62ff\u8d70\u4ed6\u4eba\u8863\u7269\uff01", null);
                            }
                            if (index == 3) {
                                return new Response("\u62ff\u53d6(\u6240\u6709)", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u4e0d\u80fd\u62ff\u8d70\u4ed6\u4eba\u8863\u7269\uff01", null);
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u67d3\u8272\u4ed6\u4eba\u7684\u8863\u7269\uff01", null);
                            }
                            if (index == 5) {
                                if (clothing.isCondom()) {
                                    if (clothing.getCondomEffect().getPotency().isNegative()) {
                                        return new Response("\u4fee\u590d(<i>1\u7cbe\u534e</i>)", "\u65e0\u6cd5\u4fee\u590d\u4ed6\u4eba\u7684\u907f\u5b55\u5957\uff0c\u5c24\u5176\u662f\u5728\u6027\u4ea4\u8fc7\u7a0b\u4e2d\uff01", null);
                                    }
                                    return new Response("\u7834\u574f", "\u65e0\u6cd5\u7834\u574f\u4ed6\u4eba\u7684\u907f\u5b55\u5957\uff0c\u5c24\u5176\u662f\u5728\u6027\u4ea4\u8fc7\u7a0b\u4e2d\uff01", null);
                                }
                                return new Response("\u9644\u9b54", "\u65e0\u6cd5\u9644\u9b54\u5176\u4ed6\u4eba\u7684\u8863\u7269\uff0c\u5c24\u5176\u662f\u5728\u6027\u4ea4\u8fc7\u7a0b\u4e2d\uff01", null);
                            }
                            if (index >= 6 && index <= 9 && index - 6 < clothing.getClothingType().getEquipSlots().size()) {
                                final InventorySlot slot = clothing.getClothingType().getEquipSlots().get(index - 6);
                                if (Main.sex.isCharacterImmobilised(Main.game.getPlayer())) {
                                    return new Response("\u88c5\u5907\uff1a" + Util.capitaliseSentence(slot.getName()), "\u4f60\u5f53\u524d\u5904\u4e8e[style.colourTerrible(\u65e0\u6cd5\u884c\u52a8)]\u72b6\u6001\uff0c\u65e0\u6cd5\u88c5\u5907\u6b64\u7269\u54c1\uff01", null);
                                }
                                if (clothing.isCanBeEquipped(Main.game.getPlayer(), slot)) {
                                    if (clothing.isAbleToBeEquippedDuringSex(slot).getKey().booleanValue() && !inventoryNPC.isTrader()) {
                                        if (!Main.sex.getInitialSexManager().isAbleToEquipSexClothing(Main.game.getPlayer(), Main.game.getPlayer(), clothing)) {
                                            return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), "\u7531\u4e8e\u5904\u4e8e\u7279\u6b8a\u6027\u4ea4\u573a\u666f\u4e2d\uff0c\u4f60\u65e0\u6cd5\u88c5\u5907\u8863\u7269\uff01", null);
                                        }
                                        if (!Main.sex.isClothingEquipAvailable(Main.game.getPlayer(), slot, clothing)) {
                                            return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), "\u8be5\u680f\u4f4d\u4e0e\u5f53\u524d\u8fdb\u884c\u7684\u6027\u52a8\u4f5c\u6709\u5173\uff0c\u6240\u4ee5\u65e0\u6cd5\u5728\u5176\u4e0a\u88c5\u5907\u8863\u7269\uff01", null);
                                        }
                                        if (Main.game.getPlayer().isAbleToEquip(clothing, slot, false, Main.game.getPlayer())) {
                                            return new Response("\u88c5\u5907: " + Util.capitaliseSentence(slot.getName()), "\u88c5\u5907" + clothing.getName() + "\u3002", Main.sex.SEX_DIALOGUE){

                                                @Override
                                                public void effects() {
                                                    AbstractClothing c = clothing;
                                                    InventoryDialogue.equipClothingFromInventory(Main.game.getPlayer(), slot, Main.game.getPlayer(), clothing);
                                                    Main.sex.setEquipClothingText(c, Main.game.getPlayer().getUnequipDescription());
                                                    Main.mainController.openInventory();
                                                    Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                                    Main.sex.setSexStarted(true);
                                                }
                                            };
                                        }
                                        return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), InventoryDialogue.getClothingBlockingRemovalText(Main.game.getPlayer(), "\u88c5\u5907"), null);
                                    }
                                    return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), clothing.isAbleToBeEquippedDuringSex(slot).getValue(), null);
                                }
                                return new Response("\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()), clothing.getCannotBeEquippedText(Main.game.getPlayer(), slot), null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index >= 11 && index <= 14 && index - 11 < clothing.getClothingType().getEquipSlots().size()) {
                                final InventorySlot slot = clothing.getClothingType().getEquipSlots().get(index - 11);
                                if (Main.sex.isCharacterImmobilised(Main.game.getPlayer())) {
                                    return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u4f60\u5f53\u524d\u5904\u4e8e[style.colourTerrible(\u65e0\u6cd5\u884c\u52a8)]\u72b6\u6001\uff0c\u65e0\u6cd5\u8ba9[npc.name]\u88c5\u5907" + clothing.getName() + "\uff01", new ParserTag[0]), null);
                                }
                                Util.Value<Boolean, String> equipAllowed = inventoryNPC.isInventoryEquipAllowed(clothing, slot);
                                if (!equipAllowed.getKey().booleanValue()) {
                                    return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, equipAllowed.getValue(), new ParserTag[0]), null);
                                }
                                if (clothing.isCanBeEquipped(inventoryNPC, slot)) {
                                    if (clothing.isAbleToBeEquippedDuringSex(slot).getKey().booleanValue() && !inventoryNPC.isTrader()) {
                                        if (!Main.sex.getInitialSexManager().isAbleToEquipSexClothing(Main.game.getPlayer(), inventoryNPC, clothing)) {
                                            return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), "\u7531\u4e8e\u5904\u4e8e\u7279\u6b8a\u6027\u4ea4\u573a\u666f\u4e2d\uff0c\u4f60\u65e0\u6cd5\u88c5\u5907\u8863\u7269\uff01", null);
                                        }
                                        if (!Main.sex.isClothingEquipAvailable(inventoryNPC, slot, clothing)) {
                                            return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), "\u8be5\u680f\u4f4d\u4e0e\u5f53\u524d\u8fdb\u884c\u7684\u6027\u52a8\u4f5c\u6709\u5173\uff0c\u6240\u4ee5\u65e0\u6cd5\u5728\u5176\u4e0a\u88c5\u5907\u8863\u7269\uff01", null);
                                        }
                                        if (inventoryNPC.isAbleToEquip(clothing, slot, false, Main.game.getPlayer())) {
                                            return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "\u4ee4[npc.name]\u88c5\u5907" + clothing.getName() + "\u3002", new ParserTag[0]), Main.sex.SEX_DIALOGUE){

                                                @Override
                                                public void effects() {
                                                    AbstractClothing c = clothing;
                                                    InventoryDialogue.equipClothingFromInventory(inventoryNPC, slot, Main.game.getPlayer(), clothing);
                                                    Main.sex.setEquipClothingText(c, inventoryNPC.getUnequipDescription());
                                                    Main.mainController.openInventory();
                                                    Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                                    Main.sex.setSexStarted(true);
                                                }
                                            };
                                        }
                                        return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u65e0\u6cd5\u88c5\u5907" + clothing.getName() + "\uff0c\u539f\u56e0\u662f\u5176\u4ed6\u88c5\u5907\u963b\u6b62\u4e86[npc.herHim]\u8fd9\u4e48\u505a\uff01", new ParserTag[0]), null);
                                    }
                                    return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), clothing.isAbleToBeEquippedDuringSex(slot).getValue(), null);
                                }
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907:" + Util.capitaliseSentence(slot.getName()) + "([npc.HerHim])", new ParserTag[0]), clothing.getCannotBeEquippedText(inventoryNPC, slot), null);
                            }
                            return null;
                        }
                        case TRADING: {
                            boolean bl = inventoryFull = Main.game.getPlayer().isInventoryFull() && !Main.game.getPlayer().hasClothing(clothing) && clothing.getRarity() != Rarity.QUEST;
                            if (index == 1) {
                                int sellPrice;
                                int n = sellPrice = buyback ? ((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).getPrice() : clothing.getPrice(inventoryNPC.getSellModifier(clothing));
                                if (inventoryFull) {
                                    return new Response("\u8d2d\u4e70(1) (" + UtilText.formatAsMoneyUncoloured(sellPrice, "span") + ")", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                                }
                                if (Main.game.getPlayer().getMoney() < (long)sellPrice) {
                                    return new Response("\u8d2d\u4e70(1) (" + UtilText.formatAsMoneyUncoloured(sellPrice, "span") + ")", "\u4f60\u4e70\u4e0d\u8d77\u8fd9\u4e2a\uff01", null);
                                }
                                return new Response("\u8d2d\u4e70(1) (" + UtilText.formatAsMoney(sellPrice, "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice) + "\u7684\u4ef7\u683c\u8d2d\u4e70" + clothing.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.sellClothing(inventoryNPC, Main.game.getPlayer(), clothing, 1, sellPrice);
                                    }
                                };
                            }
                            if (index == 2) {
                                int sellPrice;
                                int n = sellPrice = buyback ? ((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).getPrice() : clothing.getPrice(inventoryNPC.getSellModifier(clothing));
                                if (buyback && ((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).getCount() < 5 || !buyback && inventoryNPC.getClothingCount(clothing) < 5) {
                                    return new Response("\u8d2d\u4e70(5) (" + UtilText.formatAsMoneyUncoloured(sellPrice * 5, "span") + ")", UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u6ca1\u6709\u4e94\u4e2a" + clothing.getNamePlural() + "\u3002", new ParserTag[0]), null);
                                }
                                if (inventoryFull) {
                                    return new Response("\u8d2d\u4e70(5) (" + UtilText.formatAsMoneyUncoloured(sellPrice * 5, "span") + ")", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                                }
                                if (Main.game.getPlayer().getMoney() < (long)(sellPrice * 5)) {
                                    return new Response("\u8d2d\u4e70(5) (" + UtilText.formatAsMoneyUncoloured(sellPrice * 5, "span") + ")", "\u4f60\u4e70\u4e0d\u8d77\u8fd9\u4e2a\uff01", null);
                                }
                                return new Response("\u8d2d\u4e70(5) (" + UtilText.formatAsMoney(sellPrice * 5, "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice * 5) + "\u7684\u4ef7\u683c\u8d2d\u4e70" + clothing.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.sellClothing(inventoryNPC, Main.game.getPlayer(), clothing, 5, sellPrice);
                                    }
                                };
                            }
                            if (index == 3) {
                                int count;
                                final int sellPrice = buyback ? ((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).getPrice() : clothing.getPrice(inventoryNPC.getSellModifier(clothing));
                                int n = count = buyback ? ((ShopTransaction)Main.game.getPlayer().getBuybackStack().get(buyBackIndex)).getCount() : inventoryNPC.getClothingCount(clothing);
                                if (inventoryFull) {
                                    return new Response("\u8d2d\u4e70(\u6240\u6709) (" + UtilText.formatAsMoneyUncoloured(sellPrice * count, "span") + ")", "\u4f60\u7684\u7269\u54c1\u680f\u5df2\u7ecf\u6ee1\u4e86\uff01", null);
                                }
                                if (Main.game.getPlayer().getMoney() < (long)(sellPrice * count)) {
                                    final int affordableCount = (int)(Main.game.getPlayer().getMoney() / (long)sellPrice);
                                    if (affordableCount > 0) {
                                        return new Response("\u8d2d\u4e70(\u6700\u5927" + affordableCount + ") (" + UtilText.formatAsMoney(sellPrice * affordableCount, "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice * affordableCount) + "\u7684\u4ef7\u683c\u8d2d\u4e70" + clothing.getName() + "\u3002", INVENTORY_MENU){

                                            @Override
                                            public void effects() {
                                                InventoryDialogue.sellClothing(inventoryNPC, Main.game.getPlayer(), clothing, affordableCount, sellPrice);
                                            }
                                        };
                                    }
                                    return new Response("\u8d2d\u4e70(\u6240\u6709) (" + UtilText.formatAsMoneyUncoloured(sellPrice * count, "span") + ")", "\u4f60\u4e70\u4e0d\u8d77\u8fd9\u4e2a\uff01", null);
                                }
                                return new Response("\u8d2d\u4e70(\u6240\u6709) (" + UtilText.formatAsMoney(sellPrice * count, "span") + ")", "\u4ee5" + UtilText.formatAsMoney(sellPrice * count) + "\u7684\u4ef7\u683c\u8d2d\u4e70" + clothing.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.sellClothing(inventoryNPC, Main.game.getPlayer(), clothing, count, sellPrice);
                                    }
                                };
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272", UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u4e0d\u5141\u8bb8\u4f60\u67d3\u8272[npc.sheIs]\u51c6\u5907\u51fa\u552e\u7684\u8863\u7269\uff01", new ParserTag[0]), null);
                            }
                            if (index == 5) {
                                if (clothing.isCondom()) {
                                    if (clothing.getCondomEffect().getPotency().isNegative()) {
                                        return new Response("\u4fee\u590d(<i>1\u7cbe\u534e</i>)", "\u65e0\u6cd5\u4fee\u590d\u4ed6\u4eba\u7684\u907f\u5b55\u5957\uff01", null);
                                    }
                                    return new Response("\u7834\u574f", "\u65e0\u6cd5\u7834\u574f\u4ed6\u4eba\u7684\u907f\u5b55\u5957\uff01", null);
                                }
                                return new Response("\u9644\u9b54", "\u65e0\u6cd5\u9644\u9b54\u7531\u5176\u4ed6\u4eba\u62e5\u6709\u7684\u8863\u7269\uff01", null);
                            }
                            if (index == 6) {
                                return new Response("\u88c5\u5907(\u81ea\u5df1)", UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u4e0d\u5141\u8bb8\u4f60\u4f7f\u7528[npc.her]\u7684\u8863\u7269\uff0c\u9664\u975e\u4f60\u5148\u4e70\u4e0b\u3002", new ParserTag[0]), null);
                            }
                            if (index == 9) {
                                return InventoryDialogue.getBuybackResponse();
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index == 11) {
                                return new Response(UtilText.parse((GameCharacter)inventoryNPC, "\u88c5\u5907([npc.HerHim])", new ParserTag[0]), UtilText.parse((GameCharacter)inventoryNPC, "[npc.Name]\u4e0d\u5141\u8bb8\u4f60\u4f7f\u7528[npc.sheIs]\u51c6\u5907\u51fa\u552e\u7684\u8863\u7269\uff01", new ParserTag[0]), null);
                            }
                            return null;
                        }
                    }
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.INVENTORY;
            }
        };
        WEAPON_EQUIPPED = new DialogueNode("\u6b66\u5668\u5df2\u88c5\u5907", "", true){

            @Override
            public String getLabel() {
                if (Main.game.getDialogueFlags().values.contains(DialogueFlagValue.quickTrade) && !Main.game.isInSex() && !Main.game.isInCombat()) {
                    return "\u7269\u54c1\u680f(\u5feb\u901f\u7ba1\u7406\u5f53\u524d<b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u5f00\u542f</b>)";
                }
                return "\u7269\u54c1\u680f";
            }

            @Override
            public String getHeaderContent() {
                return InventoryDialogue.inventoryView();
            }

            @Override
            public String getContent() {
                StringBuilder sb = new StringBuilder();
                List<String> extraDescriptions = weapon.getExtraDescriptions(owner);
                if (!extraDescriptions.isEmpty()) {
                    sb.append("<p>");
                    for (int i = 0; i < extraDescriptions.size(); ++i) {
                        sb.append(extraDescriptions.get(i));
                        if (i >= extraDescriptions.size() - 1) continue;
                        sb.append("<br/>");
                    }
                    sb.append("</p>");
                }
                return InventoryDialogue.getItemDisplayPanel(weapon, weapon.getSVGEquippedString(owner), Util.capitaliseSentence(weapon.getDisplayName(true)), weapon.getDescription(owner) + sb.toString());
            }

            @Override
            public String getResponseTabTitle(int index) {
                return InventoryDialogue.getGeneralResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 0) {
                    return InventoryDialogue.getCloseInventoryResponse();
                }
                if (Main.game.isBadEnd()) {
                    if (index == 1) {
                        return new Response("\u4e0d\u53ef\u7528", "\u5728\u574f\u7ed3\u5c40\u65f6\u65e0\u6cd5\u64cd\u4f5c\u7269\u54c1\u680f\u2026\u2026", null);
                    }
                    return null;
                }
                if (responseTab == 0) {
                    return INVENTORY_MENU.getResponse(responseTab, index);
                }
                if (owner != null && owner.isPlayer()) {
                    switch (interactionType) {
                        case COMBAT: {
                            if (index == 1) {
                                if (Main.game.getPlayer().getLocationPlace().isItemsDisappear()) {
                                    return new Response("\u4e22\u5f03", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u66f4\u6362\u6b66\u5668\uff01", null);
                                }
                                return new Response("\u5b58\u50a8", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u66f4\u6362\u6b66\u5668\uff01", null);
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272/\u91cd\u94f8", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u4fee\u6539" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684") + "\u6b66\u5668\u7684\u5c5e\u6027\uff01", null);
                            }
                            if (index == 5) {
                                return new Response("\u9644\u9b54", "\u4f60\u65e0\u6cd5\u9644\u9b54\u5df2\u7ecf\u88c5\u5907\u7684\u6b66\u5668\u3002", null);
                            }
                            if (index == 6) {
                                return new Response("\u5378\u4e0b", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u66f4\u6362\u6b66\u5668\uff01", null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            return null;
                        }
                        case FULL_MANAGEMENT: 
                        case CHARACTER_CREATION: 
                        case TRADING: {
                            if (index == 1) {
                                boolean areaFull;
                                boolean bl = areaFull = Main.game.isPlayerTileFull() && !Main.game.getPlayerCell().getInventory().hasWeapon(weapon);
                                if (Main.game.getPlayer().getLocationPlace().isItemsDisappear()) {
                                    if (!weapon.getWeaponType().isAbleToBeDropped()) {
                                        return new Response("\u4e22\u5f03", "\u65e0\u6cd5\u4e22\u5f03" + weapon.getName() + "\uff01", null);
                                    }
                                    if (areaFull) {
                                        return new Response("\u4e22\u5f03", "\u8be5\u533a\u57df\u5df2\u7ecf\u6ee1\u4e86\uff0c\u6240\u4ee5\u65e0\u6cd5\u4e22\u5f03" + weapon.getName() + "\uff01", null);
                                    }
                                    return new Response("\u4e22\u5f03", "\u4e22\u5f03" + weapon.getName() + "\u3002", INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().unequipWeapon(weaponSlot, weapon, true, true) + "</p>");
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                if (!weapon.getWeaponType().isAbleToBeDropped()) {
                                    return new Response("\u5b58\u50a8", "\u4f60\u65e0\u6cd5\u5b58\u50a8" + weapon.getName() + "\uff01", null);
                                }
                                if (areaFull) {
                                    return new Response("\u5b58\u50a8", "\u8be5\u533a\u57df\u5df2\u6ee1\uff0c\u65e0\u6cd5\u5b58\u50a8" + weapon.getName() + "\uff01", null);
                                }
                                return new Response("\u5b58\u50a8", "\u5728\u8be5\u533a\u57df\u5b58\u50a8" + weapon.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().unequipWeapon(weaponSlot, weapon, true, true) + "</p>");
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            if (index == 4) {
                                if (InventoryDialogue.isWeaponDyeReforgeActionAvailable()) {
                                    return new Response("\u67d3\u8272/\u91cd\u94f8", Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u4f7f\u7528\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\u4fee\u6539\u8be5\u6b66\u5668\u7684\u5c5e\u6027\u3002" : "\u4f7f\u7528\u67d3\u8272\u5237\u6216\u91cd\u94f8\u9524\u6765\u4fee\u6539\u8fd9\u4ef6\u6b66\u5668\u7684\u5c5e\u6027\u3002", DYE_EQUIPPED_WEAPON){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.resetWeaponDyeColours();
                                        }
                                    };
                                }
                                return new Response("\u67d3\u8272", "\u4f60\u9700\u8981\u627e\u5230\u67d3\u8272\u5237\u6216\u91cd\u94f8\u9524\u624d\u80fd\u4fee\u6539\u8fd9\u4ef6\u6b66\u5668\u7684\u5c5e\u6027\u3002", null);
                            }
                            if (index == 5) {
                                return new Response("\u9644\u9b54", "\u4f60\u65e0\u6cd5\u9644\u9b54\u5df2\u7ecf\u88c5\u5907\u7684\u6b66\u5668\u3002", null);
                            }
                            if (index == 6) {
                                return new Response("\u5378\u4e0b", "\u5378\u4e0b" + weapon.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().unequipWeapon(weaponSlot, weapon, false, true) + "</p>");
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            return null;
                        }
                        case SEX: {
                            if (index == 1) {
                                boolean areaFull;
                                boolean bl = areaFull = Main.game.isPlayerTileFull() && !Main.game.getPlayerCell().getInventory().hasWeapon(weapon);
                                if (Main.game.getPlayer().getLocationPlace().isItemsDisappear()) {
                                    if (!weapon.getWeaponType().isAbleToBeDropped()) {
                                        return new Response("\u4e22\u5f03", "\u65e0\u6cd5\u4e22\u5f03" + weapon.getName() + "\uff01", null);
                                    }
                                    if (areaFull) {
                                        return new Response("\u4e22\u5f03", "\u8be5\u533a\u57df\u5df2\u7ecf\u6ee1\u4e86\uff0c\u6240\u4ee5\u65e0\u6cd5\u4e22\u5f03" + weapon.getName() + "\uff01", null);
                                    }
                                    return new Response("\u4e22\u5f03", "\u4e22\u5f03" + weapon.getName() + "\u3002", Main.sex.SEX_DIALOGUE){

                                        @Override
                                        public void effects() {
                                            Main.sex.setUnequipWeaponText(weapon, "<p style='text-align:center;'>" + Main.game.getPlayer().unequipWeapon(weaponSlot, weapon, true, true) + "</p>");
                                            InventoryDialogue.resetPostAction();
                                            Main.mainController.openInventory();
                                            Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                            Main.sex.setSexStarted(true);
                                        }
                                    };
                                }
                                if (!weapon.getWeaponType().isAbleToBeDropped()) {
                                    return new Response("\u5b58\u50a8", "\u4f60\u65e0\u6cd5\u5b58\u50a8" + weapon.getName() + "\uff01", null);
                                }
                                if (areaFull) {
                                    return new Response("\u5b58\u50a8", "\u8be5\u533a\u57df\u5df2\u6ee1\uff0c\u65e0\u6cd5\u5b58\u50a8" + weapon.getName() + "\uff01", null);
                                }
                                return new Response("\u5b58\u50a8", "\u5728\u8be5\u533a\u57df\u5b58\u50a8" + weapon.getName() + "\u3002", Main.sex.SEX_DIALOGUE){

                                    @Override
                                    public void effects() {
                                        Main.sex.setUnequipWeaponText(weapon, "<p style='text-align:center;'>" + Main.game.getPlayer().unequipWeapon(weaponSlot, weapon, true, true) + "</p>");
                                        InventoryDialogue.resetPostAction();
                                        Main.mainController.openInventory();
                                        Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                        Main.sex.setSexStarted(true);
                                    }
                                };
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272/\u91cd\u94f8", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u4fee\u6539" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684") + "\u6b66\u5668\u7684\u5c5e\u6027\uff01", null);
                            }
                            if (index == 5) {
                                return new Response("\u9644\u9b54", "\u4f60\u65e0\u6cd5\u9644\u9b54\u5df2\u7ecf\u88c5\u5907\u7684\u6b66\u5668\u3002", null);
                            }
                            if (index == 6) {
                                return new Response("\u5378\u4e0b", "\u5378\u4e0b" + weapon.getName() + "\u3002", Main.sex.SEX_DIALOGUE){

                                    @Override
                                    public void effects() {
                                        Main.sex.setUnequipWeaponText(weapon, "<p style='text-align:center;'>" + Main.game.getPlayer().unequipWeapon(weaponSlot, weapon, false, true) + "</p>");
                                        InventoryDialogue.resetPostAction();
                                        Main.mainController.openInventory();
                                        Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                        Main.sex.setSexStarted(true);
                                    }
                                };
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            return null;
                        }
                    }
                } else {
                    switch (interactionType) {
                        case COMBAT: {
                            if (index == 1) {
                                return new Response("\u4e22\u5f03", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u4ee4\u4ed6\u4eba\u4e22\u5f03\u6b66\u5668\uff01", null);
                            }
                            if (index == 2) {
                                return new Response("\u62ff\u53d6", "\u6218\u6597\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u62ff\u53d6\u4ed6\u4eba\u7684\u6b66\u5668\uff01", null);
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272/\u91cd\u94f8", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u4fee\u6539\u7531\u4ed6\u4eba\u88c5\u5907\u7684\u6b66\u5668\u7684\u5c5e\u6027\uff01", null);
                            }
                            if (index == 5) {
                                return new Response("\u9644\u9b54", "\u65e0\u6cd5\u9644\u9b54\u5df2\u7ecf\u88c5\u5907\u7684\u6b66\u5668\uff0c\u5c24\u5176\u662f\u5728\u6218\u6597\u8fc7\u7a0b\u4e2d\uff01", null);
                            }
                            if (index == 6) {
                                return new Response("\u5378\u4e0b", "\u6218\u6597\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u89e3\u9664\u4ed6\u4eba\u7684\u6b66\u5668\uff01", null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            return null;
                        }
                        case FULL_MANAGEMENT: 
                        case CHARACTER_CREATION: {
                            boolean inventoryFull;
                            boolean bl = inventoryFull = Main.game.getPlayer().isInventoryFull() && !Main.game.getPlayer().hasWeapon(weapon) && weapon.getRarity() != Rarity.QUEST;
                            if (index == 1) {
                                boolean areaFull;
                                boolean bl2 = areaFull = Main.game.isPlayerTileFull() && !Main.game.getPlayerCell().getInventory().hasWeapon(weapon);
                                if (Main.game.getPlayer().getLocationPlace().isItemsDisappear()) {
                                    if (!weapon.getWeaponType().isAbleToBeDropped()) {
                                        return new Response("\u4e22\u5f03", UtilText.parse((GameCharacter)inventoryNPC, "[npc.name][npc.Name]\u65e0\u6cd5\u4e22\u5f03" + weapon.getName() + "\uff01", new ParserTag[0]), null);
                                    }
                                    if (areaFull) {
                                        return new Response("\u4e22\u5f03", UtilText.parse((GameCharacter)inventoryNPC, "\u8be5\u533a\u57df\u5df2\u7ecf\u6ee1\u4e86\uff0c[npc.name]\u65e0\u6cd5\u4e22\u5f03" + weapon.getName() + "\uff01", new ParserTag[0]), null);
                                    }
                                    return new Response("\u4e22\u5f03", UtilText.parse((GameCharacter)inventoryNPC, "\u8ba9[npc.name]\u4e22\u5f03" + weapon.getName() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + inventoryNPC.unequipWeapon(weaponSlot, weapon, true, false) + "</p>");
                                            InventoryDialogue.resetPostAction();
                                        }
                                    };
                                }
                                if (!weapon.getWeaponType().isAbleToBeDropped()) {
                                    return new Response("\u4e22\u5f03", UtilText.parse((GameCharacter)inventoryNPC, "[npc.name][npc.Name]\u65e0\u6cd5\u4e22\u5f03" + weapon.getName() + "\uff01", new ParserTag[0]), null);
                                }
                                if (areaFull) {
                                    return new Response("\u5b58\u50a8", UtilText.parse((GameCharacter)inventoryNPC, "\u8be5\u533a\u57df\u5df2\u6ee1\uff0c[npc.name]\u65e0\u6cd5\u5b58\u50a8" + weapon.getName() + "\uff01", new ParserTag[0]), null);
                                }
                                return new Response("\u5b58\u50a8", UtilText.parse((GameCharacter)inventoryNPC, "\u8ba9[npc.name]\u5728\u6b64\u5904\u5b58\u50a8" + weapon.getName() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + inventoryNPC.unequipWeapon(weaponSlot, weapon, true, false) + "</p>");
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            if (index == 2) {
                                if (inventoryFull) {
                                    return new Response("\u62ff\u53d6", "\u4f60\u7684\u7269\u54c1\u680f\u6ee1\u4e86\uff0c\u65e0\u6cd5\u62ff\u53d6\u8fd9\u4e2a\uff01", null);
                                }
                                return new Response("\u62ff\u53d6", UtilText.parse((GameCharacter)inventoryNPC, "\u62ff\u53d6[npc.namePos]\u7684" + weapon.getName() + "\u5e76\u52a0\u5165\u4f60\u7684\u7269\u54c1\u680f\u4e2d\u3002", new ParserTag[0]), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        inventoryNPC.unequipWeaponIntoVoid(weaponSlot, weapon, true);
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + Main.game.getPlayer().addWeapon(weapon, false) + "</p>");
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            if (index == 4) {
                                if (InventoryDialogue.isWeaponDyeReforgeActionAvailable()) {
                                    return new Response("\u67d3\u8272/\u91cd\u94f8", Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u4f7f\u7528\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\u4fee\u6539\u8be5\u6b66\u5668\u7684\u5c5e\u6027\u3002" : "\u4f7f\u7528\u67d3\u8272\u5237\u6216\u91cd\u94f8\u9524\u6765\u4fee\u6539\u8fd9\u4ef6\u6b66\u5668\u7684\u5c5e\u6027\u3002", DYE_EQUIPPED_WEAPON){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.resetWeaponDyeColours();
                                        }
                                    };
                                }
                                return new Response("\u67d3\u8272", UtilText.parse((GameCharacter)inventoryNPC, "\u4f60\u9700\u8981\u627e\u5230\u67d3\u8272\u5237\u6216\u91cd\u94f8\u9524\u624d\u80fd\u4fee\u6539[npc.namePos]\u7684\u6b66\u5668\u7684\u5c5e\u6027\u3002", new ParserTag[0]), null);
                            }
                            if (index == 5) {
                                return new Response("\u9644\u9b54", "\u4f60\u65e0\u6cd5\u9644\u9b54\u5df2\u7ecf\u88c5\u5907\u7684\u6b66\u5668\u3002", null);
                            }
                            if (index == 6) {
                                if (!weapon.getWeaponType().isAbleToBeDropped()) {
                                    return new Response("\u5378\u4e0b", UtilText.parse((GameCharacter)inventoryNPC, "\u7531\u4e8e\u8fd9\u662f\u4e00\u628a\u7279\u6b8a\u6b66\u5668\uff0c" + weapon.getName() + "\u65e0\u6cd5\u88ab\u5378\u4e0b\u81f3[npc.namePos]\u7684\u7269\u54c1\u680f\u4e2d\u3002", new ParserTag[0]), null);
                                }
                                return new Response("\u5378\u4e0b", UtilText.parse((GameCharacter)inventoryNPC, "\u4ee4[npc.name]\u5378\u4e0b[npc.her]\u7684" + weapon.getName() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + inventoryNPC.unequipWeapon(weaponSlot, weapon, false, false) + "</p>");
                                        InventoryDialogue.resetPostAction();
                                    }
                                };
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            return null;
                        }
                        case SEX: {
                            if (index == 1) {
                                return new Response("\u4e22\u5f03", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u4ee4\u4ed6\u4eba\u89e3\u9664\u6b66\u5668\uff01", null);
                            }
                            if (index == 2) {
                                return new Response("\u62ff\u53d6", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u62ff\u53d6\u4ed6\u4eba\u7684\u6b66\u5668\uff01", null);
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272/\u91cd\u94f8", UtilText.parse((GameCharacter)inventoryNPC, "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u4fee\u6539[npc.namePos]\u7684\u6b66\u5668\u7684\u5c5e\u6027\uff01", new ParserTag[0]), null);
                            }
                            if (index == 5) {
                                return new Response("\u9644\u9b54", "\u4f60\u65e0\u6cd5\u9644\u9b54\u5df2\u7ecf\u88c5\u5907\u7684\u6b66\u5668\u3002", null);
                            }
                            if (index == 6) {
                                return new Response("\u5378\u4e0b", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u89e3\u9664\u4ed6\u4eba\u7684\u6b66\u5668\uff01", null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            return null;
                        }
                        case TRADING: {
                            if (index == 1) {
                                return new Response("\u4e22\u5f03", "\u65e0\u6cd5\u4ee4\u4ed6\u4eba\u4e22\u5f03\u6b66\u5668\uff01", null);
                            }
                            if (index == 2) {
                                return new Response("\u62ff\u53d6", "\u65e0\u6cd5\u62ff\u53d6\u4ed6\u4eba\u7684\u6b66\u5668\uff01", null);
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272/\u91cd\u94f8", UtilText.parse((GameCharacter)inventoryNPC, "\u65e0\u6cd5\u4fee\u6539[npc.namePos]\u7684\u6b66\u5668\u7684\u5c5e\u6027\uff01", new ParserTag[0]), null);
                            }
                            if (index == 5) {
                                return new Response("\u9644\u9b54", "\u65e0\u6cd5\u9644\u9b54\u7531\u5176\u4ed6\u4eba\u88c5\u5907\u7684\u6b66\u5668\uff01", null);
                            }
                            if (index == 6) {
                                return new Response("\u5378\u4e0b", "\u65e0\u6cd5\u89e3\u9664\u4ed6\u4eba\u7684\u6b66\u5668\uff01", null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            return null;
                        }
                    }
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.INVENTORY;
            }
        };
        CLOTHING_EQUIPPED = new DialogueNode("\u8863\u7269\u5df2\u88c5\u5907", "", true){

            @Override
            public String getLabel() {
                if (!Main.game.isInNewWorld()) {
                    return "\u665a\u4f1a\u7740\u88c5";
                }
                if (Main.game.getDialogueFlags().values.contains(DialogueFlagValue.quickTrade) && !Main.game.isInSex() && !Main.game.isInCombat()) {
                    return "\u7269\u54c1\u680f(\u5feb\u901f\u7ba1\u7406\u5f53\u524d<b style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u5f00\u542f</b>)";
                }
                return "\u7269\u54c1\u680f";
            }

            @Override
            public String getHeaderContent() {
                return InventoryDialogue.inventoryView();
            }

            @Override
            public String getContent() {
                StringBuilder sb = new StringBuilder();
                sb.append(clothing.getDescription(owner));
                sb.append("<p>");
                GameCharacter descriptionTarget = owner;
                for (String s : clothing.getExtraDescriptions(descriptionTarget, null, true)) {
                    sb.append(s + "<br/>");
                }
                for (String s : clothing.getExtraDescriptions(descriptionTarget, clothing.getSlotEquippedTo(), true)) {
                    sb.append(s + "<br/>");
                }
                sb.append("</p>");
                sb.append(Main.game.isInSex() || Main.game.isInCombat() ? clothing.getDisplacementBlockingDescriptions(owner) : "");
                return InventoryDialogue.getItemDisplayPanel(clothing, clothing.getSVGEquippedString(owner), clothing.getDisplayName(true), sb.toString()) + (interactionType == InventoryInteraction.CHARACTER_CREATION ? CharacterCreation.getCheckingClothingDescription() : "");
            }

            @Override
            public String getResponseTabTitle(int index) {
                return InventoryDialogue.getGeneralResponseTabTitle(index);
            }

            @Override
            public Response getResponse(int responseTab, final int index) {
                if (index == 0) {
                    return InventoryDialogue.getCloseInventoryResponse();
                }
                if (Main.game.isBadEnd()) {
                    if (index == 1) {
                        return new Response("\u4e0d\u53ef\u7528", "\u5728\u574f\u7ed3\u5c40\u65f6\u65e0\u6cd5\u64cd\u4f5c\u7269\u54c1\u680f\u2026\u2026", null);
                    }
                    return null;
                }
                if (responseTab == 0) {
                    return INVENTORY_MENU.getResponse(responseTab, index);
                }
                if (owner != null && owner.isPlayer()) {
                    InventorySlot slotEquippedTo = clothing.getSlotEquippedTo();
                    switch (interactionType) {
                        case COMBAT: {
                            if (index == 1) {
                                if (Main.game.getPlayer().getLocationPlace().isItemsDisappear()) {
                                    return new Response("\u4e22\u5f03", "\u65e0\u6cd5\u5728\u6218\u6597\u4e2d\u4e22\u5f03" + clothing.getName() + "\uff01", null);
                                }
                                return new Response("\u5b58\u50a8", "\u4f60\u65e0\u6cd5\u5728\u6218\u6597\u4e2d\u5b58\u50a8" + clothing.getName() + "\uff01", null);
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272", "\u5728\u6218\u6597\u65f6\u4e0d\u80fd\u67d3\u8272" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684") + "\u8863\u7269\uff01", null);
                            }
                            if (index == 5) {
                                if (clothing.isSealed()) {
                                    return InventoryDialogue.getJinxRemovalResponse(true);
                                }
                                if (clothing.isCondom()) {
                                    if (clothing.getCondomEffect().getPotency().isNegative()) {
                                        return new Response("\u4fee\u590d(<i>1\u7cbe\u534e</i>)", "\u65e0\u6cd5\u4fee\u590d\u5df2\u7ecf\u88c5\u5907\u7684\u907f\u5b55\u5957\uff01", null);
                                    }
                                    return new Response("\u7834\u574f", "\u65e0\u6cd5\u7834\u574f\u5df2\u7ecf\u88c5\u5907\u7684\u907f\u5b55\u5957\uff01", null);
                                }
                                return new Response("\u9644\u9b54", "\u4f60\u65e0\u6cd5\u9644\u9b54\u5df2\u7ecf\u88c5\u5907\u7684\u8863\u7269\u3002", null);
                            }
                            if (index == 6 && !clothing.isDiscardedOnUnequip(slotEquippedTo)) {
                                return new Response("\u5378\u4e0b", "\u6218\u6597\u4e2d\u65e0\u6cd5\u89e3\u9664" + clothing.getName() + "\uff01", null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index > 10 && index - 11 < clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).size()) {
                                return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11).getDescription()), "\u65e0\u6cd5" + clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11).getDescription() + clothing.getName() + "\uff01", null);
                            }
                            return null;
                        }
                        case FULL_MANAGEMENT: 
                        case TRADING: {
                            if (index == 1) {
                                boolean areaFull;
                                boolean bl = areaFull = Main.game.isPlayerTileFull() && !Main.game.getPlayerCell().getInventory().hasClothing(clothing);
                                if (Main.game.getPlayer().getLocationPlace().isItemsDisappear()) {
                                    if (!clothing.getClothingType().isAbleToBeDropped()) {
                                        return new Response("\u4e22\u5f03", "\u65e0\u6cd5\u4e22\u5f03" + clothing.getName() + "\uff01", null);
                                    }
                                    if (areaFull && !clothing.isDiscardedOnUnequip(slotEquippedTo)) {
                                        return new Response("\u4e22\u5f03", "\u8be5\u533a\u57df\u5df2\u7ecf\u6ee1\u4e86\uff0c\u6240\u4ee5\u65e0\u6cd5\u4e22\u5f03" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684") + clothing.getName() + "\uff01", null);
                                    }
                                    return new Response(clothing.isDiscardedOnUnequip(slotEquippedTo) ? "\u79fb\u9664" : "\u4e22\u5f03", clothing.isDiscardedOnUnequip(slotEquippedTo) ? "\u62ff\u8d70" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684") + clothing.getName() + "\u5e76\u4e22\u5230\u4e00\u65c1\u3002" : "\u4e22\u5f03" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684") + clothing.getName() + "\u3002", INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.unequipClothingToFloor(Main.game.getPlayer(), clothing) + "</p>");
                                        }
                                    };
                                }
                                if (!clothing.getClothingType().isAbleToBeDropped()) {
                                    return new Response("\u5b58\u50a8", "\u4f60\u65e0\u6cd5\u5b58\u50a8" + clothing.getName() + "\uff01", null);
                                }
                                if (areaFull && !clothing.isDiscardedOnUnequip(slotEquippedTo)) {
                                    return new Response("\u5b58\u50a8", "\u8be5\u533a\u57df\u5df2\u6ee1\uff0c\u65e0\u6cd5\u5b58\u50a8" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("")) + clothing.getName() + "\uff01", null);
                                }
                                return new Response(clothing.isDiscardedOnUnequip(slotEquippedTo) ? "\u79fb\u9664" : "\u5b58\u50a8", clothing.isDiscardedOnUnequip(slotEquippedTo) ? "\u62ff\u8d70" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684") + clothing.getName() + "\u5e76\u4e22\u5230\u4e00\u65c1\u3002" : "\u5b58\u50a8" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("")) + clothing.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.unequipClothingToFloor(Main.game.getPlayer(), clothing) + "</p>");
                                    }
                                };
                            }
                            if (index == 4) {
                                if (InventoryDialogue.isClothingDyeActionAvailable()) {
                                    return new Response("\u67d3\u8272", Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u4f7f\u7528\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\u4e3a\u8be5\u7269\u54c1\u67d3\u8272\u3002" : "\u4f7f\u7528\u67d3\u8272\u5237\u6765\u67d3\u8272\u8863\u7269\u3002", DYE_EQUIPPED_CLOTHING){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.resetClothingDyeColours();
                                        }
                                    };
                                }
                                return new Response("\u67d3\u8272", "\u4f60\u9700\u8981\u627e\u5230\u67d3\u8272\u5237\u624d\u80fd\u67d3\u8272\u8863\u7269\u3002", null);
                            }
                            if (index == 5) {
                                if (clothing.isSealed()) {
                                    return InventoryDialogue.getJinxRemovalResponse(true);
                                }
                                if (clothing.isCondom()) {
                                    if (clothing.getCondomEffect().getPotency().isNegative()) {
                                        return new Response("\u4fee\u590d(<i>1\u7cbe\u534e</i>)", "\u65e0\u6cd5\u4fee\u590d\u5df2\u7ecf\u88c5\u5907\u7684\u907f\u5b55\u5957\uff01", null);
                                    }
                                    return new Response("\u7834\u574f", "\u65e0\u6cd5\u7834\u574f\u5df2\u7ecf\u88c5\u5907\u7684\u907f\u5b55\u5957\uff01", null);
                                }
                                return new Response("\u9644\u9b54", "\u4f60\u65e0\u6cd5\u9644\u9b54\u5df2\u7ecf\u88c5\u5907\u7684\u8863\u7269\u3002", null);
                            }
                            if (index == 6 && !clothing.isDiscardedOnUnequip(slotEquippedTo)) {
                                if (owner.isAbleToUnequip(clothing, true, Main.game.getPlayer())) {
                                    return new Response("\u5378\u4e0b", "\u5378\u4e0b" + clothing.getName() + "\u3002", INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.unequipClothingToInventory(Main.game.getPlayer(), clothing) + "</p>");
                                        }
                                    };
                                }
                                return new Response("\u5378\u4e0b", InventoryDialogue.getClothingBlockingRemovalText(owner, "\u5378\u4e0b"), null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index > 10 && index - 11 < clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).size()) {
                                if (clothing.getDisplacedList().contains((Object)clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11))) {
                                    return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11).getOppositeDescription()), Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11).getOppositeDescription()) + clothing.getName() + "\u3002" + clothing.getClothingBlockingDescription(clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11), Main.game.getPlayer(), clothing.getSlotEquippedTo(), "<span style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u8fd9\u5c06\u4f1a\u8986\u76d6" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684"), "\u3002</span>"), CLOTHING_EQUIPPED){

                                        @Override
                                        public void effects() {
                                            Main.game.getPlayer().isAbleToBeReplaced(clothing, clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11), true, true, Main.game.getPlayer());
                                        }
                                    };
                                }
                                return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11).getDescription()), Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11).getDescription()) + clothing.getName() + "\u3002" + clothing.getClothingBlockingDescription(clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11), Main.game.getPlayer(), clothing.getSlotEquippedTo(), "<span style='color:" + PresetColour.GENERIC_SEX.toWebHexString() + ";'>\u8fd9\u5c06\u4f1a\u66b4\u9732" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684"), "\u3002</span>"), CLOTHING_EQUIPPED){

                                    @Override
                                    public void effects() {
                                        Main.game.getPlayer().isAbleToBeDisplaced(clothing, clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11), true, true, Main.game.getPlayer());
                                    }
                                };
                            }
                            return null;
                        }
                        case CHARACTER_CREATION: {
                            if (index == 1) {
                                if (Main.game.getPlayer().isCoverableAreaVisible(CoverableArea.NIPPLES) || Main.game.getPlayer().isCoverableAreaVisible(CoverableArea.ANUS) || Main.game.getPlayer().isCoverableAreaVisible(CoverableArea.PENIS) || Main.game.getPlayer().isCoverableAreaVisible(CoverableArea.VAGINA) || Main.game.getPlayer().getClothingInSlot(InventorySlot.FOOT) == null && Main.game.getPlayer().getLegType().equals(LegType.HUMAN)) {
                                    return new Response("\u524d\u5f80\u821e\u53f0", "\u4f60\u9700\u8981\u5148\u7a7f\u597d\u80fd\u591f\u906e\u76d6\u8eab\u4f53\u7684\u8863\u7269\uff0c\u8fd8\u9700\u8981\u4e00\u53cc\u978b\u3002", null);
                                }
                                return new Response("\u524d\u5f80\u821e\u53f0", "\u4f60\u5df2\u7ecf\u51c6\u5907\u597d\u524d\u5f80\u821e\u53f0\u4e86\u3002", CharacterCreation.CHOOSE_BACKGROUND){

                                    @Override
                                    public void effects() {
                                        CharacterCreation.moveNPCIntoPlayerTile();
                                    }
                                };
                            }
                            if (index == 4) {
                                if (Main.game.getPlayer().getClothingCurrentlyEquipped().isEmpty()) {
                                    return new Response("\u8131\u4e0b\u6240\u6709\u8863\u7269", "\u4f60\u73b0\u5728\u5df2\u7ecf\u5149\u7740\u4e86\uff0c\u6ca1\u6709\u8863\u7269\u53ef\u4ee5\u8131\u3002", null);
                                }
                                return new Response("\u8131\u4e0b\u6240\u6709\u8863\u7269", "\u5c3d\u53ef\u80fd\u5730\u8131\u4e0b\u8863\u7269\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        Main.game.getTextEndStringBuilder().append(InventoryDialogue.unequipAll(Main.game.getPlayer()));
                                    }
                                };
                            }
                            if (index == 5) {
                                return new Response("\u66f4\u6539\u989c\u8272", "\u66f4\u6539\u8fd9\u4ef6\u8863\u7269\u7684\u989c\u8272\u3002", DYE_EQUIPPED_CLOTHING_CHARACTER_CREATION){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.resetClothingDyeColours();
                                    }
                                };
                            }
                            if (index == 6) {
                                return new Response("\u5378\u4e0b", "\u5378\u4e0b" + clothing.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        InventoryDialogue.unequipClothingToFloor(Main.game.getPlayer(), clothing);
                                    }
                                };
                            }
                            return null;
                        }
                        case SEX: {
                            if (index == 1) {
                                boolean areaFull;
                                String unequipTitle = "\u653e\u4e0b";
                                if (clothing.isDiscardedOnUnequip(slotEquippedTo)) {
                                    unequipTitle = "\u4e22\u5f03";
                                } else if (!Main.game.getPlayer().getLocationPlace().isItemsDisappear()) {
                                    unequipTitle = "\u5b58\u50a8";
                                }
                                if (Main.sex.isCharacterImmobilised(Main.game.getPlayer())) {
                                    return new Response(unequipTitle, "\u4f60\u5f53\u524d\u5904\u4e8e[style.colourTerrible(\u65e0\u6cd5\u884c\u52a8)]\u72b6\u6001\uff0c\u65e0\u6cd5\u89e3\u9664" + clothing.getName() + "\uff01", null);
                                }
                                if (!Main.sex.isCanRemoveSelfClothing(Main.game.getPlayer())) {
                                    return new Response(unequipTitle, "\u8be5\u6027\u4ea4\u573a\u666f\u4e2d\u65e0\u6cd5\u89e3\u9664" + clothing.getName() + "\uff01", null);
                                }
                                boolean bl = areaFull = Main.game.isPlayerTileFull() && !Main.game.getPlayerCell().getInventory().hasClothing(clothing);
                                if (Main.game.getPlayer().getLocationPlace().isItemsDisappear()) {
                                    if (!clothing.getClothingType().isAbleToBeDropped()) {
                                        return new Response("\u4e22\u5f03", "\u65e0\u6cd5\u4e22\u5f03" + clothing.getName() + "\uff01", null);
                                    }
                                    if (areaFull && !clothing.isDiscardedOnUnequip(slotEquippedTo)) {
                                        return new Response("\u4e22\u5f03", "\u8be5\u533a\u57df\u5df2\u7ecf\u6ee1\u4e86\uff0c\u6240\u4ee5\u65e0\u6cd5\u4e22\u5f03" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684") + clothing.getName() + "\uff01", null);
                                    }
                                    if (owner.isAbleToUnequip(clothing, false, Main.game.getPlayer())) {
                                        return new Response(clothing.isDiscardedOnUnequip(slotEquippedTo) ? "\u79fb\u9664" : "\u4e22\u5f03", clothing.isDiscardedOnUnequip(slotEquippedTo) ? "\u62ff\u8d70" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684") + clothing.getName() + "\u5e76\u4e22\u5230\u4e00\u65c1\u3002" : "\u4e22\u5f03" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684") + clothing.getName() + "\u3002", Main.sex.SEX_DIALOGUE){

                                            @Override
                                            public void effects() {
                                                GameCharacter unequipOwner = owner;
                                                AbstractClothing c = clothing;
                                                InventoryDialogue.unequipClothingToFloor(Main.game.getPlayer(), clothing);
                                                Main.sex.setUnequipClothingText(c, unequipOwner.getUnequipDescription());
                                                Main.mainController.openInventory();
                                                Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                                Main.sex.setSexStarted(true);
                                            }
                                        };
                                    }
                                    return new Response("\u4e22\u5f03", InventoryDialogue.getClothingBlockingRemovalText(owner, "unequip"), null);
                                }
                                if (!clothing.getClothingType().isAbleToBeDropped()) {
                                    return new Response("\u5b58\u50a8", "\u4f60\u65e0\u6cd5\u5b58\u50a8" + clothing.getName() + "\uff01", null);
                                }
                                if (areaFull && !clothing.isDiscardedOnUnequip(slotEquippedTo)) {
                                    return new Response("\u5b58\u50a8", "\u5b58\u50a8" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("")) + clothing.getName() + "\uff01", null);
                                }
                                if (owner.isAbleToUnequip(clothing, false, Main.game.getPlayer())) {
                                    return new Response(clothing.isDiscardedOnUnequip(slotEquippedTo) ? "\u79fb\u9664" : "\u5b58\u50a8", clothing.isDiscardedOnUnequip(slotEquippedTo) ? "\u62ff\u8d70" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684") + clothing.getName() + "\u5e76\u4e22\u5230\u4e00\u65c1\u3002" : "\u4e22\u5f03" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684") + clothing.getName() + "\u3002", Main.sex.SEX_DIALOGUE){

                                        @Override
                                        public void effects() {
                                            GameCharacter unequipOwner = owner;
                                            AbstractClothing c = clothing;
                                            InventoryDialogue.unequipClothingToFloor(Main.game.getPlayer(), clothing);
                                            Main.sex.setUnequipClothingText(c, unequipOwner.getUnequipDescription());
                                            Main.mainController.openInventory();
                                            Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                            Main.sex.setSexStarted(true);
                                        }
                                    };
                                }
                                return new Response("\u5b58\u50a8", InventoryDialogue.getClothingBlockingRemovalText(owner, "\u5378\u4e0b"), null);
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272", "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u67d3\u8272" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684") + "\u8863\u7269\uff01", null);
                            }
                            if (index == 5) {
                                if (clothing.isSealed()) {
                                    return InventoryDialogue.getJinxRemovalResponse(true);
                                }
                                if (clothing.isCondom()) {
                                    if (clothing.getCondomEffect().getPotency().isNegative()) {
                                        return new Response("\u4fee\u590d(<i>1\u7cbe\u534e</i>)", "\u65e0\u6cd5\u4fee\u590d\u5df2\u7ecf\u88c5\u5907\u7684\u907f\u5b55\u5957\uff01", null);
                                    }
                                    return new Response("\u7834\u574f", "\u65e0\u6cd5\u7834\u574f\u5df2\u7ecf\u88c5\u5907\u7684\u907f\u5b55\u5957\uff01", null);
                                }
                                return new Response("\u9644\u9b54", "\u4f60\u65e0\u6cd5\u9644\u9b54\u5df2\u7ecf\u88c5\u5907\u7684\u8863\u7269\u3002", null);
                            }
                            if (index == 6 && !clothing.isDiscardedOnUnequip(slotEquippedTo)) {
                                if (Main.sex.isCharacterImmobilised(Main.game.getPlayer())) {
                                    return new Response("\u5378\u4e0b", "\u4f60\u5f53\u524d\u5904\u4e8e[style.colourTerrible(\u65e0\u6cd5\u884c\u52a8)]\u72b6\u6001\uff0c\u65e0\u6cd5\u89e3\u9664" + clothing.getName() + "\uff01", null);
                                }
                                if (!Main.sex.isCanRemoveSelfClothing(Main.game.getPlayer())) {
                                    return new Response("\u5378\u4e0b", "\u8be5\u6027\u4ea4\u573a\u666f\u4e2d\u65e0\u6cd5\u89e3\u9664" + clothing.getName() + "\uff01", null);
                                }
                                if (owner.isAbleToUnequip(clothing, false, Main.game.getPlayer())) {
                                    return new Response("\u5378\u4e0b", "\u5378\u4e0b" + clothing.getName() + "\u3002", Main.sex.SEX_DIALOGUE){

                                        @Override
                                        public void effects() {
                                            AbstractClothing c = clothing;
                                            InventoryDialogue.unequipClothingToInventory(Main.game.getPlayer(), clothing);
                                            Main.sex.setUnequipClothingText(c, owner.getUnequipDescription());
                                            Main.mainController.openInventory();
                                            Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                            Main.sex.setSexStarted(true);
                                        }
                                    };
                                }
                                return new Response("\u5378\u4e0b", InventoryDialogue.getClothingBlockingRemovalText(owner, "\u5378\u4e0b"), null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index > 10 && index - 11 < clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).size()) {
                                if (clothing.getDisplacedList().contains((Object)clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11))) {
                                    return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11).getDescription()), clothing.getName() + (clothing.getClothingType().isPlural() != false ? "" : "") + "\u5df2\u7ecf\u88ab" + clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11).getDescriptionPast() + "\u4e86\uff01", null);
                                }
                                if (Main.sex.isCharacterImmobilised(Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11).getDescription()), "\u5728\u6218\u6597\u65f6\u65e0\u6cd5" + clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11).getDescription() + clothing.getName() + "\uff0c\u4f60\u5f53\u524d\u5904\u4e8e[style.colourTerrible(\u65e0\u6cd5\u884c\u52a8)]\u72b6\u6001\uff01", null);
                                }
                                if (!Main.sex.isCanRemoveSelfClothing(Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11).getDescription()), "\u65e0\u6cd5" + clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11).getDescription() + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684") + clothing.getName() + "\uff01", null);
                                }
                                if (owner.isAbleToBeDisplaced(clothing, clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11), false, false, Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11).getDescription()), Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11).getDescription()) + clothing.getName() + "\u3002" + clothing.getClothingBlockingDescription(clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11), Main.game.getPlayer(), clothing.getSlotEquippedTo(), "<span style='color:" + PresetColour.GENERIC_SEX.toWebHexString() + ";'>\u8fd9\u5c06\u4f1a\u66b4\u9732" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684"), ".</span>"), Main.sex.SEX_DIALOGUE){

                                        @Override
                                        public void effects() {
                                            Main.game.getPlayer().isAbleToBeDisplaced(clothing, clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11), true, true, Main.game.getPlayer());
                                            Main.sex.setDisplaceClothingText(clothing, owner.getDisplaceDescription());
                                            Main.mainController.openInventory();
                                            Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                            Main.sex.setSexStarted(true);
                                        }
                                    };
                                }
                                return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11).getDescription()), "\u65e0\u6cd5" + clothing.getBlockedPartsKeysAsListWithoutNONE(owner, clothing.getSlotEquippedTo()).get(index - 11).getDescription() + clothing.getName() + "\uff0c\u539f\u56e0\u662f" + UtilText.parse(owner, "[npc.namePos]\u7684", new ParserTag[0]) + owner.getBlockingClothing().getName() + (owner.getBlockingClothing().getClothingType().isPlural() != false ? "" : "") + "\u963b\u6321\u5728\u4e2d\u95f4\uff01", null);
                            }
                            return null;
                        }
                    }
                } else {
                    InventorySlot slotEquippedTo = clothing.getSlotEquippedTo();
                    switch (interactionType) {
                        case COMBAT: {
                            if (index == 1) {
                                return new Response("\u4e22\u5f03", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u4ee4\u4ed6\u4eba\u4e22\u5f03\u8863\u7269\uff01", null);
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u67d3\u8272\u7531\u4ed6\u4eba\u88c5\u5907\u7684\u6b66\u5668\uff01", null);
                            }
                            if (index == 5) {
                                if (clothing.isSealed()) {
                                    return InventoryDialogue.getJinxRemovalResponse(false);
                                }
                                if (clothing.isCondom()) {
                                    if (clothing.getCondomEffect().getPotency().isNegative()) {
                                        return new Response("\u4fee\u590d(<i>1\u7cbe\u534e</i>)", "\u65e0\u6cd5\u4fee\u590d\u5df2\u7ecf\u88c5\u5907\u7684\u907f\u5b55\u5957\uff01", null);
                                    }
                                    return new Response("\u7834\u574f", "\u65e0\u6cd5\u7834\u574f\u5df2\u7ecf\u88c5\u5907\u7684\u907f\u5b55\u5957\uff01", null);
                                }
                                return new Response("\u9644\u9b54", "\u4f60\u65e0\u6cd5\u9644\u9b54\u5df2\u7ecf\u88c5\u5907\u7684\u8863\u7269\u3002", null);
                            }
                            if (index == 6) {
                                return new Response("\u5378\u4e0b", "\u5728\u6218\u6597\u65f6\u65e0\u6cd5\u89e3\u9664\u4ed6\u4eba\u7684\u8863\u7269\uff01", null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index > 10 && index - 11 < clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).size()) {
                                if (clothing.getDisplacedList().contains((Object)clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11))) {
                                    return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescription()), clothing.getName() + (clothing.getClothingType().isPlural() != false ? "" : "") + "\u5df2\u7ecf\u88ab" + clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescriptionPast() + "\u4e86\uff01", null);
                                }
                                return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescription()), "\u5728\u6218\u6597\u65f6\u65e0\u6cd5" + clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescription() + clothing.getName() + "\uff01", null);
                            }
                            return null;
                        }
                        case FULL_MANAGEMENT: 
                        case CHARACTER_CREATION: {
                            boolean inventoryFull;
                            boolean bl = inventoryFull = Main.game.getPlayer().isInventoryFull() && !Main.game.getPlayer().hasClothing(clothing) && clothing.getRarity() != Rarity.QUEST;
                            if (index == 1) {
                                boolean areaFull;
                                boolean bl2 = areaFull = Main.game.isPlayerTileFull() && !Main.game.getPlayerCell().getInventory().hasClothing(clothing);
                                if (Main.game.getPlayer().getLocationPlace().isItemsDisappear()) {
                                    if (!clothing.getClothingType().isAbleToBeDropped()) {
                                        return new Response("\u4e22\u5f03", "\u65e0\u6cd5\u4e22\u5f03" + clothing.getName() + "\uff01", null);
                                    }
                                    if (areaFull && !clothing.isDiscardedOnUnequip(slotEquippedTo)) {
                                        return new Response("\u4e22\u5f03", UtilText.parse((GameCharacter)inventoryNPC, "\u8be5\u533a\u57df\u5df2\u7ecf\u6ee1\u4e86\uff0c\u6240\u4ee5\u65e0\u6cd5\u4e22\u5f03[npc.namePos] " + clothing.getName() + "\uff01", new ParserTag[0]), null);
                                    }
                                    return new Response(clothing.isDiscardedOnUnequip(slotEquippedTo) ? "\u79fb\u9664" : "\u4e22\u5f03", clothing.isDiscardedOnUnequip(slotEquippedTo) ? UtilText.parse((GameCharacter)inventoryNPC, "\u8131\u4e0b[npc.namePos]\u7684" + clothing.getName() + "\u5e76\u4e22\u5230\u4e00\u8fb9\u3002", new ParserTag[0]) : UtilText.parse((GameCharacter)inventoryNPC, "\u4e22\u5f03[npc.namePos]\u7684" + clothing.getName() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                        @Override
                                        public void effects() {
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.unequipClothingToFloor(Main.game.getPlayer(), clothing) + "</p>");
                                        }
                                    };
                                }
                                if (!clothing.getClothingType().isAbleToBeDropped()) {
                                    return new Response("\u5b58\u50a8", "\u4f60\u65e0\u6cd5\u5b58\u50a8" + clothing.getName() + "\uff01", null);
                                }
                                if (areaFull && !clothing.isDiscardedOnUnequip(slotEquippedTo)) {
                                    return new Response("\u5b58\u50a8", UtilText.parse((GameCharacter)inventoryNPC, "\u5b58\u50a8[npc.namePos]\u7684" + clothing.getName() + "\uff01", new ParserTag[0]), null);
                                }
                                return new Response(clothing.isDiscardedOnUnequip(slotEquippedTo) ? "\u79fb\u9664" : "\u5b58\u50a8", clothing.isDiscardedOnUnequip(slotEquippedTo) ? UtilText.parse((GameCharacter)inventoryNPC, "\u8131\u4e0b[npc.namePos]\u7684" + clothing.getName() + "\u5e76\u4e22\u5230\u4e00\u8fb9\u3002", new ParserTag[0]) : UtilText.parse((GameCharacter)inventoryNPC, "\u5b58\u50a8[npc.namePos]\u7684" + clothing.getName() + "\u3002", new ParserTag[0]), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.unequipClothingToFloor(Main.game.getPlayer(), clothing) + "</p>");
                                    }
                                };
                            }
                            if (index == 2) {
                                if (inventoryFull) {
                                    return new Response("\u62ff\u53d6", "\u4f60\u7684\u7269\u54c1\u680f\u6ee1\u4e86\uff0c\u65e0\u6cd5\u62ff\u53d6\u8fd9\u4e2a\uff01", null);
                                }
                                if (clothing.isDiscardedOnUnequip(slotEquippedTo)) {
                                    return new Response("\u62ff\u53d6", "\u8fd9\u4ef6\u8863\u7269\u5728\u5378\u4e0b\u65f6\u4f1a\u88ab\u81ea\u52a8\u79fb\u9664\uff0c\u6240\u4ee5\u65e0\u6cd5\u62ff\u53d6\uff01", null);
                                }
                                return new Response("\u62ff\u53d6", UtilText.parse((GameCharacter)inventoryNPC, "\u62ff\u53d6[npc.namePos]\u7684" + clothing.getName() + "\u5e76\u52a0\u5165\u4f60\u7684\u7269\u54c1\u680f\u4e2d\u3002", new ParserTag[0]), INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.unequipClothingToUnequippersInventory(Main.game.getPlayer(), clothing) + "</p>");
                                    }
                                };
                            }
                            if (index == 4) {
                                if (InventoryDialogue.isClothingDyeActionAvailable()) {
                                    return new Response("\u67d3\u8272", Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u4f7f\u7528\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\u4e3a\u8be5\u7269\u54c1\u67d3\u8272\u3002" : "\u4f7f\u7528\u67d3\u8272\u5237\u6765\u67d3\u8272\u8863\u7269\u3002", DYE_EQUIPPED_CLOTHING){

                                        @Override
                                        public void effects() {
                                            InventoryDialogue.resetClothingDyeColours();
                                        }
                                    };
                                }
                                return new Response("\u67d3\u8272", UtilText.parse((GameCharacter)inventoryNPC, "\u9700\u8981\u627e\u5230\u53e6\u4e00\u4e2a\u67d3\u8272\u5237\u624d\u80fd\u67d3\u8272[npc.namePos]\u7684\u8863\u7269\u3002", new ParserTag[0]), null);
                            }
                            if (index == 5) {
                                if (clothing.isSealed()) {
                                    return InventoryDialogue.getJinxRemovalResponse(false);
                                }
                                if (clothing.isCondom()) {
                                    if (clothing.getCondomEffect().getPotency().isNegative()) {
                                        return new Response("\u4fee\u590d(<i>1\u7cbe\u534e</i>)", "\u65e0\u6cd5\u4fee\u590d\u5df2\u7ecf\u88c5\u5907\u7684\u907f\u5b55\u5957\uff01", null);
                                    }
                                    return new Response("\u7834\u574f", "\u65e0\u6cd5\u7834\u574f\u5df2\u7ecf\u88c5\u5907\u7684\u907f\u5b55\u5957\uff01", null);
                                }
                                return new Response("\u9644\u9b54", "\u4f60\u65e0\u6cd5\u9644\u9b54\u5df2\u7ecf\u88c5\u5907\u7684\u8863\u7269\u3002", null);
                            }
                            if (index == 6 && !clothing.isDiscardedOnUnequip(slotEquippedTo)) {
                                if (!clothing.getClothingType().isAbleToBeDropped()) {
                                    return new Response("\u5378\u4e0b", UtilText.parse((GameCharacter)inventoryNPC, "\u7531\u4e8e\u8fd9\u662f\u4e00\u4ef6\u7279\u6b8a\u8863\u7269\uff0c" + clothing.getName() + "\u65e0\u6cd5\u88ab\u5378\u4e0b\u81f3[npc.namePos]\u7684\u7269\u54c1\u680f\u4e2d\u3002", new ParserTag[0]), null);
                                }
                                return new Response("\u5378\u4e0b", "\u5378\u4e0b" + clothing.getName() + "\u3002", INVENTORY_MENU){

                                    @Override
                                    public void effects() {
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.unequipClothingToInventory(Main.game.getPlayer(), clothing) + "</p>");
                                    }
                                };
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index > 10 && index - 11 < clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).size()) {
                                if (clothing.getDisplacedList().contains((Object)clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11))) {
                                    return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getOppositeDescription()), Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getOppositeDescription()) + clothing.getName() + "\u3002" + clothing.getClothingBlockingDescription(clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11), owner, clothing.getSlotEquippedTo(), "<span style='color:" + PresetColour.GENERIC_GOOD.toWebHexString() + ";'>\u8fd9\u5c06\u4f1a\u8986\u76d6" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684"), ".</span>"), CLOTHING_EQUIPPED){

                                        @Override
                                        public void effects() {
                                            owner.isAbleToBeReplaced(clothing, clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11), true, true, Main.game.getPlayer());
                                        }
                                    };
                                }
                                return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescription()), Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescription()) + clothing.getName() + "\u3002" + clothing.getClothingBlockingDescription(clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11), owner, clothing.getSlotEquippedTo(), "<span style='color:" + PresetColour.GENERIC_SEX.toWebHexString() + ";'>\u8fd9\u5c06\u4f1a\u66b4\u9732" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684"), ".</span>"), CLOTHING_EQUIPPED){

                                    @Override
                                    public void effects() {
                                        owner.isAbleToBeDisplaced(clothing, clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11), true, true, Main.game.getPlayer());
                                        Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + owner.getDisplaceDescription() + "</p>");
                                    }
                                };
                            }
                            return null;
                        }
                        case SEX: {
                            if (index == 1) {
                                boolean areaFull;
                                String unequipTitle = "\u653e\u4e0b";
                                if (clothing.isDiscardedOnUnequip(slotEquippedTo)) {
                                    unequipTitle = "\u4e22\u5f03";
                                } else if (!Main.game.getPlayer().getLocationPlace().isItemsDisappear()) {
                                    unequipTitle = "\u5b58\u50a8";
                                }
                                if (Main.sex.isCharacterImmobilised(Main.game.getPlayer())) {
                                    return new Response(unequipTitle, UtilText.parse((GameCharacter)inventoryNPC, "\u65e0\u6cd5\u8131\u4e0b[npc.namePos]\u7684\u8863\u7269\uff0c\u56e0\u4e3a\u4f60\u5f53\u524d[style.colourTerrible(\u65e0\u6cd5\u884c\u52a8)]\uff01", new ParserTag[0]), null);
                                }
                                if (Main.sex.getInitialSexManager().isHidden(Main.game.getPlayer())) {
                                    return new Response(unequipTitle, UtilText.parse((GameCharacter)inventoryNPC, "\u4f60\u65e0\u6cd5\u5728\u8eb2\u85cf\u65f6\u8131\u4e0b[npc.namePos]\u7684\u8863\u7269\uff01", new ParserTag[0]), null);
                                }
                                if (clothing.isDiscardedOnUnequip(slotEquippedTo) && !Main.sex.isCanRemoveOthersClothing(Main.game.getPlayer(), clothing)) {
                                    return new Response("\u79fb\u9664", "\u8be5\u6027\u4ea4\u573a\u666f\u4e2d\u65e0\u6cd5\u89e3\u9664" + clothing.getName() + "\uff01", null);
                                }
                                if (!Main.sex.isCanRemoveOthersClothing(Main.game.getPlayer(), clothing)) {
                                    return new Response(unequipTitle, "\u8be5\u6027\u4ea4\u573a\u666f\u4e2d\u65e0\u6cd5\u89e3\u9664" + clothing.getName() + "\uff01", null);
                                }
                                boolean bl = areaFull = Main.game.isPlayerTileFull() && !Main.game.getPlayerCell().getInventory().hasClothing(clothing);
                                if (Main.game.getPlayer().getLocationPlace().isItemsDisappear()) {
                                    if (!clothing.getClothingType().isAbleToBeDropped()) {
                                        return new Response("\u4e22\u5f03", "\u65e0\u6cd5\u4e22\u5f03" + clothing.getName() + "\uff01", null);
                                    }
                                    if (areaFull && !clothing.isDiscardedOnUnequip(slotEquippedTo)) {
                                        return new Response("\u4e22\u5f03", UtilText.parse((GameCharacter)inventoryNPC, "\u8be5\u533a\u57df\u5df2\u7ecf\u6ee1\u4e86\uff0c\u6240\u4ee5\u65e0\u6cd5\u4e22\u5f03[npc.namePos] " + clothing.getName() + "\uff01", new ParserTag[0]), null);
                                    }
                                    if (owner.isAbleToUnequip(clothing, false, Main.game.getPlayer())) {
                                        return new Response(clothing.isDiscardedOnUnequip(slotEquippedTo) ? "\u79fb\u9664" : "\u4e22\u5f03", clothing.isDiscardedOnUnequip(slotEquippedTo) ? UtilText.parse((GameCharacter)inventoryNPC, "\u8131\u4e0b[npc.namePos]\u7684" + clothing.getName() + "\u5e76\u4e22\u5230\u4e00\u8fb9\u3002", new ParserTag[0]) : UtilText.parse((GameCharacter)inventoryNPC, "\u4e22\u5f03[npc.namePos]\u7684" + clothing.getName() + "\u3002", new ParserTag[0]), Main.sex.SEX_DIALOGUE){

                                            @Override
                                            public void effects() {
                                                AbstractClothing c = clothing;
                                                Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.unequipClothingToFloor(Main.game.getPlayer(), clothing) + "</p>");
                                                Main.sex.setUnequipClothingText(c, inventoryNPC.getUnequipDescription());
                                                Main.mainController.openInventory();
                                                Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                                Main.sex.setSexStarted(true);
                                            }
                                        };
                                    }
                                    return new Response("\u4e22\u5f03", InventoryDialogue.getClothingBlockingRemovalText(owner, "unequip"), null);
                                }
                                if (!clothing.getClothingType().isAbleToBeDropped()) {
                                    return new Response("\u5b58\u50a8", "\u4f60\u65e0\u6cd5\u5b58\u50a8" + clothing.getName() + "\uff01", null);
                                }
                                if (areaFull && !clothing.isDiscardedOnUnequip(slotEquippedTo)) {
                                    return new Response("\u5b58\u50a8", UtilText.parse((GameCharacter)inventoryNPC, "\u5b58\u50a8[npc.namePos]\u7684" + clothing.getName() + "\uff01", new ParserTag[0]), null);
                                }
                                if (owner.isAbleToUnequip(clothing, false, Main.game.getPlayer())) {
                                    return new Response(clothing.isDiscardedOnUnequip(slotEquippedTo) ? "\u79fb\u9664" : "\u5b58\u50a8", clothing.isDiscardedOnUnequip(slotEquippedTo) ? UtilText.parse((GameCharacter)inventoryNPC, "\u8131\u4e0b[npc.namePos]\u7684" + clothing.getName() + "\u5e76\u4e22\u5230\u4e00\u8fb9\u3002", new ParserTag[0]) : UtilText.parse((GameCharacter)inventoryNPC, "\u5b58\u50a8[npc.namePos]\u7684" + clothing.getName() + "\u3002", new ParserTag[0]), Main.sex.SEX_DIALOGUE){

                                        @Override
                                        public void effects() {
                                            AbstractClothing c = clothing;
                                            Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.unequipClothingToFloor(Main.game.getPlayer(), clothing) + "</p>");
                                            Main.sex.setUnequipClothingText(c, inventoryNPC.getUnequipDescription());
                                            Main.mainController.openInventory();
                                            Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                            Main.sex.setSexStarted(true);
                                        }
                                    };
                                }
                                return new Response("\u5b58\u50a8", InventoryDialogue.getClothingBlockingRemovalText(owner, "\u5378\u4e0b"), null);
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272", UtilText.parse((GameCharacter)inventoryNPC, "\u6027\u4ea4\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u67d3\u8272[npc.namePos]\u7684\u8863\u7269\uff01", new ParserTag[0]), null);
                            }
                            if (index == 5) {
                                if (clothing.isSealed()) {
                                    return InventoryDialogue.getJinxRemovalResponse(false);
                                }
                                if (clothing.isCondom()) {
                                    if (clothing.getCondomEffect().getPotency().isNegative()) {
                                        return new Response("\u4fee\u590d(<i>1\u7cbe\u534e</i>)", "\u65e0\u6cd5\u4fee\u590d\u5df2\u7ecf\u88c5\u5907\u7684\u907f\u5b55\u5957\uff01", null);
                                    }
                                    return new Response("\u7834\u574f", "\u65e0\u6cd5\u7834\u574f\u5df2\u7ecf\u88c5\u5907\u7684\u907f\u5b55\u5957\uff01", null);
                                }
                                return new Response("\u9644\u9b54", "\u4f60\u65e0\u6cd5\u9644\u9b54\u5df2\u7ecf\u88c5\u5907\u7684\u8863\u7269\u3002", null);
                            }
                            if (index == 6 && !clothing.isDiscardedOnUnequip(slotEquippedTo)) {
                                if (Main.sex.isCharacterImmobilised(Main.game.getPlayer())) {
                                    return new Response("\u5378\u4e0b", UtilText.parse((GameCharacter)inventoryNPC, "\u65e0\u6cd5\u8131\u4e0b[npc.namePos]\u7684\u8863\u7269\uff0c\u56e0\u4e3a\u4f60\u5f53\u524d[style.colourTerrible(\u65e0\u6cd5\u884c\u52a8)]\uff01", new ParserTag[0]), null);
                                }
                                if (Main.sex.getInitialSexManager().isHidden(Main.game.getPlayer())) {
                                    return new Response("\u8131\u4e0b", UtilText.parse((GameCharacter)inventoryNPC, "\u4f60\u65e0\u6cd5\u5728\u8eb2\u85cf\u65f6\u8131\u4e0b[npc.namePos]\u7684\u8863\u670d\uff01", new ParserTag[0]), null);
                                }
                                if (!Main.sex.isCanRemoveOthersClothing(Main.game.getPlayer(), clothing)) {
                                    return new Response("\u5378\u4e0b", "\u8be5\u6027\u4ea4\u573a\u666f\u4e2d\u65e0\u6cd5\u89e3\u9664" + clothing.getName() + "\uff01", null);
                                }
                                if (owner.isAbleToUnequip(clothing, false, Main.game.getPlayer())) {
                                    return new Response("\u5378\u4e0b", "\u5378\u4e0b" + clothing.getName() + "\u3002", Main.sex.SEX_DIALOGUE){

                                        @Override
                                        public void effects() {
                                            AbstractClothing c = clothing;
                                            InventoryDialogue.unequipClothingToInventory(Main.game.getPlayer(), clothing);
                                            Main.sex.setUnequipClothingText(c, inventoryNPC.getUnequipDescription());
                                            Main.mainController.openInventory();
                                            Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                            Main.sex.setSexStarted(true);
                                        }
                                    };
                                }
                                return new Response("\u5378\u4e0b", InventoryDialogue.getClothingBlockingRemovalText(owner, "\u5378\u4e0b"), null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index > 10 && index - 11 < clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).size()) {
                                if (clothing.getDisplacedList().contains((Object)clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11))) {
                                    return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescription()), clothing.getName() + (clothing.getClothingType().isPlural() != false ? "" : "") + "\u5df2\u7ecf\u88ab" + clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescriptionPast() + "\u4e86\uff01", null);
                                }
                                if (Main.sex.isCharacterImmobilised(Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescription()), UtilText.parse((GameCharacter)inventoryNPC, "\u4f60\u65e0\u6cd5" + clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescription() + "[npc.namePos]\u7684\u8863\u7269\uff0c\u56e0\u4e3a\u4f60\u76ee\u524d[style.colourTerrible(\u65e0\u6cd5\u884c\u52a8)]\uff01", new ParserTag[0]), null);
                                }
                                if (Main.sex.getInitialSexManager().isHidden(Main.game.getPlayer())) {
                                    return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescription()), UtilText.parse((GameCharacter)inventoryNPC, "\u4f60\u65e0\u6cd5\u5728\u8eb2\u85cf\u65f6" + clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescription() + "[npc.namePos]\u7684" + clothing.getName() + "\uff01", new ParserTag[0]), null);
                                }
                                if (owner.isAbleToBeDisplaced(clothing, clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11), false, false, Main.game.getPlayer())) {
                                    if (!Main.sex.isCanRemoveOthersClothing(Main.game.getPlayer(), clothing)) {
                                        return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescription()), "\u8be5\u6027\u4ea4\u573a\u666f\u4e2d\u65e0\u6cd5" + clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescription() + clothing.getName() + "\uff01", null);
                                    }
                                    return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescription()), Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescription()) + clothing.getName() + "\u3002" + clothing.getClothingBlockingDescription(clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11), owner, clothing.getSlotEquippedTo(), "<span style='color:" + PresetColour.GENERIC_SEX.toWebHexString() + ";'>\u8fd9\u5c06\u4f1a\u66b4\u9732" + (String)(owner.isPlayer() ? "\u4f60\u7684" : owner.getName("") + "\u7684"), ".</span>"), Main.sex.SEX_DIALOGUE){

                                        @Override
                                        public void effects() {
                                            owner.isAbleToBeDisplaced(clothing, clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11), true, true, Main.game.getPlayer());
                                            Main.sex.setDisplaceClothingText(clothing, owner.getDisplaceDescription());
                                            Main.mainController.openInventory();
                                            Main.sex.endSexTurn(SexActionUtility.CLOTHING_REMOVAL);
                                            Main.sex.setSexStarted(true);
                                        }
                                    };
                                }
                                return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescription()), "\u65e0\u6cd5" + clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescription() + clothing.getName() + "\uff0c\u539f\u56e0\u662f" + UtilText.parse(owner, "[npc.namePos]\u7684", new ParserTag[0]) + owner.getBlockingClothing().getName() + (owner.getBlockingClothing().getClothingType().isPlural() != false ? "" : "") + "\u963b\u6321\u5728\u4e2d\u95f4\uff01", null);
                            }
                            return null;
                        }
                        case TRADING: {
                            if (index == 1) {
                                return new Response("\u4e22\u5f03", UtilText.parse((GameCharacter)inventoryNPC, "\u65e0\u6cd5\u4ee4[npc.name]\u4e22\u5f03[npc.her]\u7684\u8863\u7269\uff01", new ParserTag[0]), null);
                            }
                            if (index == 4) {
                                return new Response("\u67d3\u8272", UtilText.parse((GameCharacter)inventoryNPC, "\u65e0\u6cd5\u67d3\u8272[npc.namePos]\u7684\u8863\u7269\uff01", new ParserTag[0]), null);
                            }
                            if (index == 5) {
                                if (clothing.isCondom()) {
                                    if (clothing.getCondomEffect().getPotency().isNegative()) {
                                        return new Response("\u4fee\u590d(<i>1\u7cbe\u534e</i>)", "\u65e0\u6cd5\u4fee\u590d[npc.namePos]\u7684\u907f\u5b55\u5957\uff01", null);
                                    }
                                    return new Response("\u7834\u574f", "\u65e0\u6cd5\u7834\u574f[npc.namePos]\u7684\u907f\u5b55\u5957\uff01", null);
                                }
                                return new Response("\u9644\u9b54", UtilText.parse((GameCharacter)inventoryNPC, "\u4f60\u65e0\u6cd5\u9644\u9b54[npc.namePos]\u7684\u8863\u7269\uff01", new ParserTag[0]), null);
                            }
                            if (index == 6) {
                                return new Response("\u5378\u4e0b", UtilText.parse((GameCharacter)inventoryNPC, "\u65e0\u6cd5\u89e3\u9664[npc.namePos]\u7684\u8863\u7269\uff01", new ParserTag[0]), null);
                            }
                            if (index == 10) {
                                return InventoryDialogue.getQuickTradeResponse();
                            }
                            if (index > 10 && index - 11 < clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).size()) {
                                if (clothing.getDisplacedList().contains((Object)clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11))) {
                                    return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescription()), clothing.getName() + (clothing.getClothingType().isPlural() != false ? "" : "") + "\u5df2\u7ecf\u88ab" + clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescriptionPast() + "\u4e86\uff01", null);
                                }
                                return new Response(Util.capitaliseSentence(clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescription()), "\u65e0\u6cd5" + clothing.getBlockedPartsKeysAsListWithoutNONE(inventoryNPC, clothing.getSlotEquippedTo()).get(index - 11).getDescription() + clothing.getName() + "\uff01", null);
                            }
                            return null;
                        }
                    }
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.INVENTORY;
            }
        };
        DYE_CLOTHING = new DialogueNode("\u67d3\u8272\u8863\u7269", "", true){

            @Override
            public String getContent() {
                return InventoryDialogue.getClothingDyeUI();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u8fd4\u56de\u4e4b\u524d\u7684\u83dc\u5355\u3002", INVENTORY_MENU);
                }
                if (index == 1) {
                    if (dyePreviews.equals(clothing.getColours()) && dyePreviewPattern.equals(clothing.getPattern()) && dyePreviewPatternColours.equals(clothing.getPatternColours()) && dyePreviewStickers.equals(clothing.getStickersAsObjects())) {
                        return new Response("\u67d3\u8272", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u989c\u8272\u624d\u80fd\u67d3\u8272" + clothing.getName() + "\uff01", null);
                    }
                    return new Response("\u67d3\u8272", "\u4f7f\u7528\u9009\u4e2d\u7684\u989c\u8272\u67d3\u8272" + clothing.getName() + "\u3002" + (Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u4f46\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u968f\u65f6\u5c06\u5176\u67d3\u6210\u4e0d\u540c\u989c\u8272\u3002" : "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u5982\u679c\u60f3\u8981\u518d\u6b21\u66f4\u6539\u989c\u8272\u5219\u9700\u8981\u53e6\u4e00\u4e2a\u67d3\u8272\u5237\u3002"), INVENTORY_MENU){

                        @Override
                        public void effects() {
                            if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode()) {
                                Main.game.getPlayer().useItem(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH), owner, false);
                                Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.getDyeBrushEffects(clothing, dyePreviews.get(0)) + "</p><p><b>" + clothing.getName() + (clothing.getClothingType().isPlural() != false ? "\u5df2\u7ecf" : "\u5df2\u7ecf") + "\u67d3\u8272\u8fc7\u4e86</b>\uff01</p><p>" + (String)(InventoryDialogue.isClothingDyeActionAvailable() ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH))) + "</b>\u4e2a\u67d3\u8272\u5237" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u67d3\u8272\u5237\u4e86\uff01") + "</p>");
                            } else {
                                Main.game.getTextEndStringBuilder().append("<p>\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.boldEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u4e0d\u4f7f\u7528\u67d3\u8272\u5237\u5c31\u67d3\u8272" + clothing.getName() + "\uff01</p>");
                            }
                            if (owner != null) {
                                owner.removeClothing(clothing);
                                AbstractClothing dyedClothing = new AbstractClothing(clothing){};
                                dyedClothing.setColours(dyePreviews);
                                dyedClothing.setPattern(dyePreviewPattern);
                                dyedClothing.setPatternColours(dyePreviewPatternColours);
                                dyedClothing.setStickersAsObjects(dyePreviewStickers);
                                owner.addClothing(dyedClothing, false);
                                Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272", dyedClothing.getDisplayName(true)), false);
                            } else {
                                Main.game.getPlayerCell().getInventory().removeClothing(clothing);
                                AbstractClothing dyedClothing = new AbstractClothing(clothing){};
                                dyedClothing.setColours(dyePreviews);
                                dyedClothing.setPattern(dyePreviewPattern);
                                dyedClothing.setPatternColours(dyePreviewPatternColours);
                                dyedClothing.setStickersAsObjects(dyePreviewStickers);
                                Main.game.getPlayerCell().getInventory().addClothing(dyedClothing);
                                Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272", dyedClothing.getDisplayName(true)), false);
                            }
                        }
                    };
                }
                if (index == 6) {
                    int dyeBrushCount;
                    if (dyePreviews.equals(clothing.getColours()) && dyePreviewPattern.equals(clothing.getPattern()) && dyePreviewPatternColours.equals(clothing.getPatternColours()) && dyePreviewStickers.equals(clothing.getStickersAsObjects())) {
                        return new Response("\u67d3\u8272\u6240\u6709(\u5806\u53e0)", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u989c\u8272\u624d\u80fd\u67d3\u8272" + clothing.getName() + "\uff01", null);
                    }
                    int stackCount = 0;
                    stackCount = owner != null ? owner.getClothingCount(clothing) : Main.game.getPlayerCell().getInventory().getClothingCount(clothing);
                    final int finalCount = stackCount;
                    if (stackCount == 1) {
                        return new Response("\u67d3\u8272\u6240\u6709(\u5806\u53e0)", "\u4f60\u53ea\u6709\u4e00\u4ef6" + clothing.getName() + "\uff0c\u6240\u4ee5\u5e94\u8be5\u4f7f\u7528\u5355\u6b21\u52a8\u4f5c\u67d3\u8272\u2026\u2026", null);
                    }
                    if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode() && (dyeBrushCount = Main.game.getPlayer().getItemCount(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH))) < stackCount) {
                        return new Response("\u67d3\u8272\u6240\u6709(\u5806\u53e0)", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u67d3\u8272\u5237\u5c06\u6240\u6709" + clothing.getNamePlural() + "\u67d3\u8272\uff01\u4f60\u53ea\u6709\u4e2a" + dyeBrushCount + "\u67d3\u8272\u5237\uff0c\u4f46\u5806\u53e0\u4e2d\u6709" + stackCount + "\u4ef6" + clothing.getNamePlural() + "\u2026\u2026", null);
                    }
                    return new Response("\u67d3\u8272\u6240\u6709(\u5806\u53e0)", "\u5c06\u6240\u6709\u5728\u8be5\u8863\u7269\u5806\u53e0\u4e2d\u7684" + clothing.getNamePlural() + "\u67d3\u8272\u4e3a\u6240\u9009\u989c\u8272(\u5171\u8ba1" + stackCount + ")\u3002" + (Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u4f46\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u968f\u65f6\u5c06\u5176\u67d3\u6210\u4e0d\u540c\u989c\u8272\u3002" : "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u5982\u679c\u60f3\u8981\u518d\u6b21\u66f4\u6539\u989c\u8272\u5219\u9700\u8981\u53e6\u4e00\u4e2a\u67d3\u8272\u5237\u3002"), INVENTORY_MENU){

                        @Override
                        public void effects() {
                            if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode()) {
                                Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH), finalCount);
                                Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.getDyeBrushEffects(clothing, dyePreviews.get(0)) + "</p><p><b>" + clothing.getName() + (clothing.getClothingType().isPlural() != false ? "" : "") + "\u5df2\u7ecf\u88ab\u67d3\u8272\u8fc7\u4e86</b>\uff01</p>");
                                Main.game.getTextEndStringBuilder().append("<p>\u63a5\u7740\u4f60\u5bf9\u5269\u4f59" + Util.intToString(finalCount - 1) + "\u4ef6" + clothing.getNamePlural() + "\u91cd\u590d\u4e86\u6b64\u52a8\u4f5c\u2026\u2026</p>");
                                Main.game.getTextEndStringBuilder().append("<p>" + (String)(InventoryDialogue.isClothingDyeActionAvailable() ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH))) + "</b>\u4e2a\u67d3\u8272\u5237" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u67d3\u8272\u5237\u4e86\uff01") + "</p>");
                            } else {
                                Main.game.getTextEndStringBuilder().append("<p>\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.boldEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u4e0d\u4f7f\u7528\u67d3\u8272\u5237\u5c31\u67d3\u8272" + (String)(finalCount == 2 ? "\u4e24" : "\u6240\u6709" + Util.intToString(finalCount)) + "\u4ef6" + clothing.getNamePlural() + "\uff01</p>");
                            }
                            if (owner != null) {
                                owner.removeClothing(clothing, finalCount);
                                AbstractClothing dyedClothing = new AbstractClothing(clothing){};
                                dyedClothing.setColours(dyePreviews);
                                dyedClothing.setPattern(dyePreviewPattern);
                                dyedClothing.setPatternColours(dyePreviewPatternColours);
                                dyedClothing.setStickersAsObjects(dyePreviewStickers);
                                owner.addClothing(dyedClothing, finalCount, false, false);
                                Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272", dyedClothing.getDisplayName(true)), false);
                            } else {
                                Main.game.getPlayerCell().getInventory().removeClothing(clothing, finalCount);
                                AbstractClothing dyedClothing = new AbstractClothing(clothing){};
                                dyedClothing.setColours(dyePreviews);
                                dyedClothing.setPattern(dyePreviewPattern);
                                dyedClothing.setPatternColours(dyePreviewPatternColours);
                                dyedClothing.setStickersAsObjects(dyePreviewStickers);
                                Main.game.getPlayerCell().getInventory().addClothing(dyedClothing, finalCount);
                                Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272", dyedClothing.getDisplayName(true)), false);
                            }
                        }
                    };
                }
                if (index == 11) {
                    int dyeBrushCount;
                    if (dyePreviews.equals(clothing.getColours()) && dyePreviewPattern.equals(clothing.getPattern()) && dyePreviewPatternColours.equals(clothing.getPatternColours()) && dyePreviewStickers.equals(clothing.getStickersAsObjects())) {
                        return new Response("\u67d3\u8272\u6240\u6709", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u989c\u8272\u624d\u80fd\u67d3\u8272" + clothing.getName() + "\uff01", null);
                    }
                    final ArrayList<AbstractClothing> clothingMatches = new ArrayList<AbstractClothing>();
                    int stackCount = 0;
                    if (owner != null) {
                        for (Map.Entry<AbstractClothing, Integer> entry : owner.getAllClothingInInventory().entrySet()) {
                            if (!entry.getKey().getClothingType().equals(clothing.getClothingType())) continue;
                            clothingMatches.add(entry.getKey());
                            stackCount += entry.getValue().intValue();
                        }
                    } else {
                        for (Map.Entry<AbstractClothing, Integer> entry : Main.game.getPlayerCell().getInventory().getAllClothingInInventory().entrySet()) {
                            if (!entry.getKey().getClothingType().equals(clothing.getClothingType())) continue;
                            clothingMatches.add(entry.getKey());
                            stackCount += entry.getValue().intValue();
                        }
                    }
                    final int finalCount = stackCount;
                    if (stackCount == 1) {
                        return new Response("\u67d3\u8272\u6240\u6709", "\u4f60\u53ea\u6709\u4e00\u4ef6" + clothing.getName() + "\uff0c\u6240\u4ee5\u5e94\u8be5\u4f7f\u7528\u5355\u6b21\u52a8\u4f5c\u67d3\u8272\u2026\u2026", null);
                    }
                    if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode() && (dyeBrushCount = Main.game.getPlayer().getItemCount(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH))) < stackCount) {
                        return new Response("\u67d3\u8272\u6240\u6709", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u67d3\u8272\u5237\u5c06\u6240\u6709" + clothing.getNamePlural() + "\u67d3\u8272\uff01\u4f60\u53ea\u6709\u4e2a" + dyeBrushCount + "\u67d3\u8272\u5237\uff0c\u4f46\u603b\u5171\u6709" + stackCount + "\u4ef6" + clothing.getNamePlural() + "\u2026\u2026", null);
                    }
                    return new Response("\u67d3\u8272\u6240\u6709", "\u5c06\u6240\u6709\u5728\u8be5\u8863\u7269\u5806\u53e0\u4e2d\u7684" + clothing.getNamePlural() + "\u67d3\u8272\u4e3a\u6240\u9009\u989c\u8272(\u5171\u8ba1" + stackCount + ")\u3002" + (Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u4f46\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u968f\u65f6\u5c06\u5176\u67d3\u6210\u4e0d\u540c\u989c\u8272\u3002" : "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u5982\u679c\u60f3\u8981\u518d\u6b21\u66f4\u6539\u989c\u8272\u5219\u9700\u8981\u53e6\u4e00\u4e2a\u67d3\u8272\u5237\u3002"), INVENTORY_MENU){

                        @Override
                        public void effects() {
                            if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode()) {
                                Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH), finalCount);
                                Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.getDyeBrushEffects(clothing, dyePreviews.get(0)) + "</p><p><b>" + clothing.getName() + (clothing.getClothingType().isPlural() != false ? "" : "") + "\u5df2\u7ecf\u88ab\u67d3\u8272\u8fc7\u4e86</b>\uff01</p>");
                                Main.game.getTextEndStringBuilder().append("<p>\u63a5\u7740\u4f60\u5bf9\u5269\u4f59" + Util.intToString(finalCount - 1) + "\u4ef6" + clothing.getNamePlural() + "\u91cd\u590d\u4e86\u6b64\u52a8\u4f5c\u2026\u2026</p>");
                                Main.game.getTextEndStringBuilder().append("<p>" + (String)(InventoryDialogue.isClothingDyeActionAvailable() ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH))) + "</b>\u4e2a\u67d3\u8272\u5237" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u67d3\u8272\u5237\u4e86\uff01") + "</p>");
                            } else {
                                Main.game.getTextEndStringBuilder().append("<p>\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.boldEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u4e0d\u4f7f\u7528\u67d3\u8272\u5237\u5c31\u67d3\u8272" + (String)(finalCount == 2 ? "\u4e24" : "\u6240\u6709" + Util.intToString(finalCount)) + "\u4ef6" + clothing.getNamePlural() + "\uff01</p>");
                            }
                            if (owner != null) {
                                for (AbstractClothing c : clothingMatches) {
                                    int clothingCount = owner.getAllClothingInInventory().get(c);
                                    owner.removeClothing(c, clothingCount);
                                    AbstractClothing dyedClothing = new AbstractClothing(c){};
                                    dyedClothing.setColours(dyePreviews);
                                    dyedClothing.setPattern(dyePreviewPattern);
                                    dyedClothing.setPatternColours(dyePreviewPatternColours);
                                    dyedClothing.setStickersAsObjects(dyePreviewStickers);
                                    owner.addClothing(dyedClothing, clothingCount, false, false);
                                    Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272", dyedClothing.getDisplayName(true)), false);
                                }
                            } else {
                                for (AbstractClothing c : clothingMatches) {
                                    int clothingCount = Main.game.getPlayerCell().getInventory().getAllClothingInInventory().get(c);
                                    Main.game.getPlayerCell().getInventory().removeClothing(c, clothingCount);
                                    AbstractClothing dyedClothing = new AbstractClothing(c){};
                                    dyedClothing.setColours(dyePreviews);
                                    dyedClothing.setPattern(dyePreviewPattern);
                                    dyedClothing.setPatternColours(dyePreviewPatternColours);
                                    dyedClothing.setStickersAsObjects(dyePreviewStickers);
                                    Main.game.getPlayerCell().getInventory().addClothing(dyedClothing, clothingCount);
                                    Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272", dyedClothing.getDisplayName(true)), false);
                                }
                            }
                        }
                    };
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.INVENTORY;
            }
        };
        DYE_EQUIPPED_CLOTHING = new DialogueNode("\u67d3\u8272\u8863\u7269", "", true){

            @Override
            public String getContent() {
                return InventoryDialogue.getClothingDyeUI();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u8fd4\u56de\u4e4b\u524d\u7684\u83dc\u5355\u3002", INVENTORY_MENU);
                }
                if (index == 1) {
                    if (dyePreviews.equals(clothing.getColours()) && dyePreviewPattern.equals(clothing.getPattern()) && dyePreviewPatternColours.equals(clothing.getPatternColours()) && dyePreviewStickers.equals(clothing.getStickersAsObjects())) {
                        return new Response("\u67d3\u8272", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u989c\u8272\u624d\u80fd\u67d3\u8272" + clothing.getName() + "\uff01", null);
                    }
                    return new Response("\u67d3\u8272", "\u4f7f\u7528\u9009\u4e2d\u7684\u989c\u8272\u67d3\u8272" + clothing.getName() + "\u3002" + (Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u4f46\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u968f\u65f6\u5c06\u5176\u67d3\u6210\u4e0d\u540c\u989c\u8272\u3002" : "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u5982\u679c\u60f3\u8981\u518d\u6b21\u66f4\u6539\u989c\u8272\u5219\u9700\u8981\u53e6\u4e00\u4e2a\u67d3\u8272\u5237\u3002"), INVENTORY_MENU){

                        @Override
                        public void effects() {
                            if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode()) {
                                Main.game.getPlayer().useItem(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH), owner, false);
                                Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.getDyeBrushEffects(clothing, dyePreviews.get(0)) + "</p><p><b>" + clothing.getName() + (clothing.getClothingType().isPlural() != false ? "\u5df2\u7ecf" : "\u5df2\u7ecf") + "\u67d3\u8272\u8fc7\u4e86</b>\uff01</p><p>" + (String)(InventoryDialogue.isClothingDyeActionAvailable() ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH))) + "</b>\u4e2a\u67d3\u8272\u5237" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u67d3\u8272\u5237\u4e86\uff01") + "</p>");
                            } else {
                                Main.game.getTextEndStringBuilder().append("<p>\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.boldEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u4e0d\u4f7f\u7528\u67d3\u8272\u5237\u5c31\u67d3\u8272" + clothing.getName() + "\uff01</p>");
                            }
                            clothing.setColours(dyePreviews);
                            clothing.setPattern(dyePreviewPattern);
                            clothing.setPatternColours(dyePreviewPatternColours);
                            clothing.setStickersAsObjects(dyePreviewStickers);
                            Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272", clothing.getDisplayName(true)), false);
                        }
                    };
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.INVENTORY;
            }
        };
        DYE_CLOTHING_CHARACTER_CREATION = new DialogueNode("\u9009\u62e9\u989c\u8272", "", true){

            @Override
            public String getContent() {
                return InventoryDialogue.getClothingDyeUI();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u8fd4\u56de\u4e4b\u524d\u7684\u83dc\u5355\u3002", CLOTHING_INVENTORY);
                }
                if (index == 1) {
                    if (dyePreviews.equals(clothing.getColours()) && dyePreviewPattern.equals(clothing.getPattern()) && dyePreviewPatternColours.equals(clothing.getPatternColours()) && dyePreviewStickers.equals(clothing.getStickersAsObjects())) {
                        return new Response("\u67d3\u8272", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u989c\u8272\u624d\u80fd\u67d3\u8272" + clothing.getName() + "\uff01", null);
                    }
                    return new Response("\u67d3\u8272", "\u66f4\u6539" + clothing.getName() + "\u7684\u989c\u8272\u4e3a\u4f60\u9009\u62e9\u7684\u989c\u8272\u3002", INVENTORY_MENU){

                        @Override
                        public void effects() {
                            Main.game.getPlayerCell().getInventory().removeClothing(clothing);
                            AbstractClothing dyedClothing = new AbstractClothing(clothing){};
                            dyedClothing.setColours(dyePreviews);
                            dyedClothing.setPattern(dyePreviewPattern);
                            dyedClothing.setPatternColours(dyePreviewPatternColours);
                            dyedClothing.setStickersAsObjects(dyePreviewStickers);
                            clothing = dyedClothing;
                            Main.game.getPlayerCell().getInventory().addClothing(dyedClothing);
                        }
                    };
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.INVENTORY;
            }
        };
        DYE_EQUIPPED_CLOTHING_CHARACTER_CREATION = new DialogueNode("\u9009\u62e9\u989c\u8272", "", true){

            @Override
            public String getContent() {
                return InventoryDialogue.getClothingDyeUI();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u8fd4\u56de\u4e4b\u524d\u7684\u83dc\u5355\u3002", CLOTHING_EQUIPPED);
                }
                if (index == 1) {
                    if (dyePreviews.equals(clothing.getColours()) && dyePreviewPattern.equals(clothing.getPattern()) && dyePreviewPatternColours.equals(clothing.getPatternColours()) && dyePreviewStickers.equals(clothing.getStickersAsObjects())) {
                        return new Response("\u67d3\u8272", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u989c\u8272\u624d\u80fd\u67d3\u8272" + clothing.getName() + "\uff01", null);
                    }
                    return new Response("\u67d3\u8272", "\u66f4\u6539" + clothing.getName() + "\u7684\u989c\u8272\u4e3a\u4f60\u9009\u62e9\u7684\u989c\u8272\u3002", CLOTHING_EQUIPPED){

                        @Override
                        public void effects() {
                            clothing.setColours(dyePreviews);
                            clothing.setPattern(dyePreviewPattern);
                            clothing.setPatternColours(dyePreviewPatternColours);
                            clothing.setStickersAsObjects(dyePreviewStickers);
                        }
                    };
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.INVENTORY;
            }
        };
        DYE_WEAPON = new DialogueNode("\u67d3\u8272\u6b66\u5668", "", true){

            @Override
            public String getContent() {
                return InventoryDialogue.getWeaponDyeUI();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u8fd4\u56de\u4e4b\u524d\u7684\u83dc\u5355\u3002", INVENTORY_MENU);
                }
                if (index == 1) {
                    if (!(Main.game.getPlayer().hasItemType(ItemType.DYE_BRUSH) || Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) || Main.game.isDebugMode())) {
                        return new Response("\u67d3\u8272", "\u4f60\u6ca1\u6709\u67d3\u8272\u5237\uff0c\u6240\u4ee5\u65e0\u6cd5\u66f4\u6539" + weapon.getName() + "\u7684\u989c\u8272\u2026\u2026", null);
                    }
                    if (dyePreviews.equals(weapon.getColours())) {
                        return new Response("\u67d3\u8272", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u989c\u8272\u624d\u80fd\u67d3\u8272" + weapon.getName() + "\uff01", null);
                    }
                    return new Response("\u67d3\u8272", "\u4f7f\u7528\u9009\u4e2d\u7684\u989c\u8272\u67d3\u8272" + weapon.getName() + "\u3002" + (Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u4f46\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u968f\u65f6\u5c06\u5176\u67d3\u6210\u4e0d\u540c\u989c\u8272\u3002" : "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u5982\u679c\u60f3\u8981\u518d\u6b21\u66f4\u6539\u989c\u8272\u5219\u9700\u8981\u53e6\u4e00\u4e2a\u67d3\u8272\u5237\u3002"), INVENTORY_MENU){

                        @Override
                        public void effects() {
                            if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode()) {
                                Main.game.getPlayer().useItem(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH), owner, false);
                                Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.getDyeBrushEffects(weapon, dyePreviews.get(0)) + "</p><p><b>" + weapon.getName() + (weapon.getWeaponType().isPlural() ? "" : "") + "\u5df2\u7ecf\u67d3\u8272\u8fc7\u4e86</b>\uff01</p><p>" + (String)(InventoryDialogue.isClothingDyeActionAvailable() ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH))) + "</b>\u4e2a\u67d3\u8272\u5237" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u67d3\u8272\u5237\u4e86\uff01") + "</p>");
                            } else {
                                Main.game.getTextEndStringBuilder().append("<p>\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.boldEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u4e0d\u4f7f\u7528\u67d3\u8272\u5237\u5c31\u67d3\u8272" + weapon.getName() + "\uff01</p>");
                            }
                            if (owner != null) {
                                owner.removeWeapon(weapon);
                                AbstractWeapon dyedWeapon = Main.game.getItemGen().generateWeapon(weapon);
                                dyedWeapon.setColours(dyePreviews);
                                owner.addWeapon(dyedWeapon, false);
                                Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272", dyedWeapon.getDisplayName(true)), false);
                                weapon = dyedWeapon;
                            } else {
                                Main.game.getPlayerCell().getInventory().removeWeapon(weapon);
                                AbstractWeapon dyedWeapon = Main.game.getItemGen().generateWeapon(weapon);
                                dyedWeapon.setColours(dyePreviews);
                                Main.game.getPlayerCell().getInventory().addWeapon(dyedWeapon);
                                Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272", dyedWeapon.getDisplayName(true)), false);
                                weapon = dyedWeapon;
                            }
                        }
                    };
                }
                if (index == 2) {
                    if (!(Main.game.getPlayer().hasItemType(ItemType.REFORGE_HAMMER) || Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) || Main.game.isDebugMode())) {
                        return new Response("\u91cd\u94f8", "\u4f60\u6ca1\u6709\u91cd\u94f8\u9524\uff0c\u6240\u4ee5\u65e0\u6cd5\u66f4\u6539" + weapon.getName() + "\u7684\u4f24\u5bb3\u7c7b\u578b\u2026\u2026", null);
                    }
                    if (damageTypePreview == weapon.getDamageType()) {
                        return new Response("\u91cd\u94f8", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u6b66\u5668\u7c7b\u578b\u624d\u80fd\u91cd\u94f8" + weapon.getName() + "\uff01", null);
                    }
                    return new Response("\u91cd\u94f8", "\u5c06" + weapon.getName() + "\u91cd\u94f8\u4e3a\u9009\u4e2d\u7684\u4f24\u5bb3\u7c7b\u578b\u3002" + (Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u4f46\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u968f\u65f6\u5c06\u5176\u91cd\u94f8\u3002" : "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u5982\u679c\u60f3\u8981\u518d\u6b21\u66f4\u6539\u4f24\u5bb3\u7c7b\u578b\u5219\u9700\u8981\u53e6\u4e00\u4e2a\u91cd\u94f8\u9524\u3002"), INVENTORY_MENU){

                        @Override
                        public void effects() {
                            if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode()) {
                                Main.game.getPlayer().useItem(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER), owner, false);
                                Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.getReforgeHammerEffects(weapon, damageTypePreview) + "</p><p><b>" + weapon.getName() + (weapon.getWeaponType().isPlural() ? "" : "") + "\u5df2\u7ecf\u91cd\u94f8\u8fc7\u4e86</b>\uff01</p><p>" + (String)(Main.game.getPlayer().hasItemType(ItemType.REFORGE_HAMMER) || Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER))) + "</b>\u4e2a\u91cd\u94f8\u9524" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u91cd\u94f8\u9524\u4e86\uff01") + "</p>");
                            } else {
                                Main.game.getTextEndStringBuilder().append("<p>\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.boldEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u4e0d\u4f7f\u7528\u91cd\u94f8\u9524\u5c31\u91cd\u94f8" + weapon.getName() + "\uff01</p>");
                            }
                            if (owner != null) {
                                owner.removeWeapon(weapon);
                                AbstractWeapon modifiedWeapon = Main.game.getItemGen().generateWeapon(weapon);
                                modifiedWeapon.setDamageType(damageTypePreview);
                                owner.addWeapon(Main.game.getItemGen().generateWeapon(modifiedWeapon), false);
                                Main.game.addEvent(new EventLogEntry("\u5df2\u91cd\u94f8", modifiedWeapon.getDisplayName(true)), false);
                            } else {
                                Main.game.getPlayerCell().getInventory().removeWeapon(weapon);
                                AbstractWeapon modifiedWeapon = Main.game.getItemGen().generateWeapon(weapon);
                                modifiedWeapon.setDamageType(damageTypePreview);
                                Main.game.getPlayerCell().getInventory().addWeapon(Main.game.getItemGen().generateWeapon(modifiedWeapon));
                                Main.game.addEvent(new EventLogEntry("\u5df2\u91cd\u94f8", modifiedWeapon.getDisplayName(true)), false);
                            }
                        }
                    };
                }
                if (index == 3) {
                    if (!(Main.game.getPlayer().hasItemType(ItemType.REFORGE_HAMMER) && Main.game.getPlayer().hasItemType(ItemType.DYE_BRUSH) || Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) || Main.game.isDebugMode())) {
                        return new Response("\u67d3\u8272\u5e76\u91cd\u94f8", "\u4f60\u6ca1\u6709\u67d3\u8272\u5237\u548c\u91cd\u94f8\u9524\uff0c\u65e0\u6cd5\u67d3\u8272\u5e76\u91cd\u94f8" + weapon.getName() + "\u2026\u2026", null);
                    }
                    if (damageTypePreview == weapon.getDamageType()) {
                        return new Response("\u67d3\u8272\u5e76\u91cd\u94f8", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u6b66\u5668\u7c7b\u578b\u624d\u80fd\u91cd\u94f8" + weapon.getName() + "\uff01", null);
                    }
                    if (dyePreviews.equals(weapon.getColours())) {
                        return new Response("\u67d3\u8272\u5e76\u91cd\u94f8", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u989c\u8272\u624d\u80fd\u67d3\u8272" + weapon.getName() + "\uff01", null);
                    }
                    return new Response("\u67d3\u8272\u5e76\u91cd\u94f8", "\u5c06" + weapon.getName() + "\u67d3\u8272\u5e76\u91cd\u94f8\u4e3a\u4f60\u9009\u62e9\u7684\u989c\u8272\u548c\u4f24\u5bb3\u7c7b\u578b\u3002" + (Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u4f46\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u968f\u65f6\u5c06\u5176\u67d3\u8272\u4e0e\u91cd\u94f8\u3002" : "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u5982\u679c\u60f3\u8981\u518d\u6b21\u66f4\u6539\u989c\u8272\u548c\u4f24\u5bb3\u7c7b\u578b\u5219\u9700\u8981\u53e6\u4e00\u4e2a\u67d3\u8272\u5237\u548c\u91cd\u94f8\u9524\u3002"), INVENTORY_MENU){

                        @Override
                        public void effects() {
                            if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode()) {
                                Main.game.getPlayer().useItem(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH), owner, false);
                                Main.game.getPlayer().useItem(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER), owner, false);
                                Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.getDyeBrushEffects(weapon, dyePreviews.get(0)) + "</p><p style='text-align:center;'>" + InventoryDialogue.getReforgeHammerEffects(weapon, damageTypePreview) + "</p><p><b>" + weapon.getName() + (weapon.getWeaponType().isPlural() ? "" : "") + "\u5df2\u7ecf\u67d3\u8272\u548c\u91cd\u94f8\u8fc7\u4e86</b>\uff01</p><p>" + (String)(InventoryDialogue.isClothingDyeActionAvailable() ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH))) + "</b>\u4e2a\u67d3\u8272\u5237" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u67d3\u8272\u5237\u4e86\uff01") + "<br/>" + (String)(Main.game.getPlayer().hasItemType(ItemType.REFORGE_HAMMER) || Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER))) + "</b>\u4e2a\u91cd\u94f8\u9524" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u91cd\u94f8\u9524\u4e86\uff01") + "</p>");
                            } else {
                                Main.game.getTextEndStringBuilder().append("<p>\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.boldEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u4e0d\u4f7f\u7528\u67d3\u8272\u5237\u548c\u91cd\u94f8\u9524\u5c31\u67d3\u8272\u548c\u91cd\u94f8" + weapon.getName() + "\uff01</p>");
                            }
                            if (owner != null) {
                                owner.removeWeapon(weapon);
                                AbstractWeapon modifiedWeapon = Main.game.getItemGen().generateWeapon(weapon);
                                modifiedWeapon.setDamageType(damageTypePreview);
                                modifiedWeapon.setColours(dyePreviews);
                                owner.addWeapon(Main.game.getItemGen().generateWeapon(modifiedWeapon), false);
                                Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272\u5e76\u91cd\u94f8", modifiedWeapon.getDisplayName(true)), false);
                            } else {
                                Main.game.getPlayerCell().getInventory().removeWeapon(weapon);
                                AbstractWeapon modifiedWeapon = Main.game.getItemGen().generateWeapon(weapon);
                                modifiedWeapon.setDamageType(damageTypePreview);
                                modifiedWeapon.setColours(dyePreviews);
                                Main.game.getPlayerCell().getInventory().addWeapon(Main.game.getItemGen().generateWeapon(modifiedWeapon));
                                Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272\u5e76\u91cd\u94f8", modifiedWeapon.getDisplayName(true)), false);
                            }
                        }
                    };
                }
                if (index == 6) {
                    int dyeBrushCount;
                    if (dyePreviews.equals(weapon.getColours())) {
                        return new Response("\u67d3\u8272\u6240\u6709(\u5806\u53e0)", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u989c\u8272\u624d\u80fd\u67d3\u8272" + weapon.getName() + "\uff01", null);
                    }
                    int stackCount = 0;
                    stackCount = owner != null ? owner.getWeaponCount(weapon) : Main.game.getPlayerCell().getInventory().getWeaponCount(weapon);
                    final int finalCount = stackCount;
                    if (stackCount == 1) {
                        return new Response("\u67d3\u8272\u6240\u6709(\u5806\u53e0)", "\u4f60\u53ea\u6709\u4e00\u628a" + weapon.getName() + "\uff0c\u6240\u4ee5\u5e94\u8be5\u4f7f\u7528\u5355\u6b21\u52a8\u4f5c\u67d3\u8272\u2026\u2026", null);
                    }
                    if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode() && (dyeBrushCount = Main.game.getPlayer().getItemCount(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH))) < stackCount) {
                        return new Response("\u67d3\u8272\u6240\u6709(\u5806\u53e0)", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u67d3\u8272\u5237\u5c06\u6240\u6709" + weapon.getNamePlural() + "\u67d3\u8272\uff01\u4f60\u53ea\u6709\u4e2a" + dyeBrushCount + "\u67d3\u8272\u5237\uff0c\u4f46\u5806\u53e0\u4e2d\u6709" + stackCount + "\u628a" + weapon.getNamePlural() + "\u2026\u2026", null);
                    }
                    return new Response("\u67d3\u8272\u6240\u6709(\u5806\u53e0)", "\u5c06\u6240\u6709\u5728\u8be5\u6b66\u5668\u5806\u53e0\u4e2d\u7684" + weapon.getNamePlural() + "\u67d3\u8272\u4e3a\u6240\u9009\u989c\u8272(\u5171\u8ba1" + stackCount + ")\u3002" + (Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u4f46\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u968f\u65f6\u5c06\u5176\u67d3\u6210\u4e0d\u540c\u989c\u8272\u3002" : "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u5982\u679c\u60f3\u8981\u518d\u6b21\u66f4\u6539\u989c\u8272\u5219\u9700\u8981\u53e6\u4e00\u4e2a\u67d3\u8272\u5237\u3002"), INVENTORY_MENU){

                        @Override
                        public void effects() {
                            if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode()) {
                                Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH), finalCount);
                                Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.getDyeBrushEffects(weapon, dyePreviews.get(0)) + "</p><p><b>" + weapon.getName() + (weapon.getWeaponType().isPlural() ? "" : "") + "\u5df2\u7ecf\u67d3\u8272\u8fc7\u4e86</b>\uff01</p>");
                                Main.game.getTextEndStringBuilder().append("<p>\u63a5\u7740\u4f60\u5bf9\u5269\u4f59" + Util.intToString(finalCount - 1) + "\u628a" + weapon.getNamePlural() + "\u91cd\u590d\u4e86\u6b64\u52a8\u4f5c\u2026\u2026</p>");
                                Main.game.getTextEndStringBuilder().append("<p>" + (String)(InventoryDialogue.isClothingDyeActionAvailable() ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH))) + "</b>\u4e2a\u67d3\u8272\u5237" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u67d3\u8272\u5237\u4e86\uff01") + "</p>");
                            } else {
                                Main.game.getTextEndStringBuilder().append("<p>\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.boldEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u4e0d\u4f7f\u7528\u67d3\u8272\u5237\u5c31\u67d3\u8272" + (String)(finalCount == 2 ? "\u4e24" : "\u6240\u6709" + Util.intToString(finalCount)) + "\u628a" + weapon.getNamePlural() + "\uff01</p>");
                            }
                            if (owner != null) {
                                owner.removeWeapon(weapon, finalCount);
                                AbstractWeapon dyedWeapon = Main.game.getItemGen().generateWeapon(weapon);
                                dyedWeapon.setColours(dyePreviews);
                                owner.addWeapon(dyedWeapon, finalCount, false, false);
                                Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272", dyedWeapon.getDisplayName(true)), false);
                            } else {
                                Main.game.getPlayerCell().getInventory().removeWeapon(weapon, finalCount);
                                AbstractWeapon dyedWeapon = Main.game.getItemGen().generateWeapon(weapon);
                                dyedWeapon.setColours(dyePreviews);
                                Main.game.getPlayerCell().getInventory().addWeapon(dyedWeapon, finalCount);
                                Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272", dyedWeapon.getDisplayName(true)), false);
                            }
                        }
                    };
                }
                if (index == 7) {
                    int reforgeHammerCount;
                    if (damageTypePreview == weapon.getDamageType()) {
                        return new Response("\u91cd\u94f8\u6240\u6709(\u5806\u53e0)", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u6b66\u5668\u7c7b\u578b\u624d\u80fd\u91cd\u94f8" + weapon.getName() + "\uff01", null);
                    }
                    int stackCount = 0;
                    stackCount = owner != null ? owner.getWeaponCount(weapon) : Main.game.getPlayerCell().getInventory().getWeaponCount(weapon);
                    final int finalCount = stackCount;
                    if (stackCount == 1) {
                        return new Response("\u91cd\u94f8\u6240\u6709(\u5806\u53e0)", "\u4f60\u53ea\u6709\u4e00\u628a" + weapon.getName() + "\uff0c\u6240\u4ee5\u5e94\u8be5\u4f7f\u7528\u5355\u6b21\u52a8\u4f5c\u91cd\u94f8\u2026\u2026", null);
                    }
                    if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode() && (reforgeHammerCount = Main.game.getPlayer().getItemCount(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER))) < stackCount) {
                        return new Response("\u91cd\u94f8\u6240\u6709(\u5806\u53e0)", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u91cd\u94f8\u9524\u5c06\u6240\u6709" + weapon.getNamePlural() + "\u91cd\u94f8\uff01\u4f60\u53ea\u6709" + reforgeHammerCount + "\u4e2a\u91cd\u94f8\u9524\uff0c\u4f46\u5806\u53e0\u4e2d\u6709" + stackCount + "\u628a" + weapon.getNamePlural() + "\u2026\u2026", null);
                    }
                    return new Response("\u91cd\u94f8\u6240\u6709(\u5806\u53e0)", "\u5c06\u6240\u6709\u5728\u8be5\u6b66\u5668\u5806\u53e0\u4e2d\u7684" + weapon.getNamePlural() + "\u91cd\u94f8\u4e3a\u9009\u4e2d\u7684\u4f24\u5bb3\u7c7b\u578b(" + stackCount + " in total)\u3002" + (Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u4f46\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u968f\u65f6\u5c06\u5176\u91cd\u94f8\u3002" : "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u5982\u679c\u60f3\u8981\u518d\u6b21\u66f4\u6539\u4f24\u5bb3\u7c7b\u578b\u5219\u9700\u8981\u53e6\u4e00\u4e2a\u91cd\u94f8\u9524\u3002"), INVENTORY_MENU){

                        @Override
                        public void effects() {
                            if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode()) {
                                Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER), finalCount);
                                Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.getReforgeHammerEffects(weapon, damageTypePreview) + "</p><p><b>" + weapon.getName() + (weapon.getWeaponType().isPlural() ? "" : "") + "\u5df2\u7ecf\u91cd\u94f8\u8fc7\u4e86</b>\uff01</p>");
                                Main.game.getTextEndStringBuilder().append("<p>\u63a5\u7740\u4f60\u5bf9\u5269\u4f59" + Util.intToString(finalCount - 1) + "\u628a" + weapon.getNamePlural() + "\u91cd\u590d\u4e86\u6b64\u52a8\u4f5c\u2026\u2026</p>");
                                Main.game.getTextEndStringBuilder().append("<p>" + (String)(Main.game.getPlayer().hasItemType(ItemType.REFORGE_HAMMER) || Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER))) + "</b>\u4e2a\u91cd\u94f8\u9524" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u91cd\u94f8\u9524\u4e86\uff01") + "</p>");
                            } else {
                                Main.game.getTextEndStringBuilder().append("<p>\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.boldEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u4e0d\u4f7f\u7528\u91cd\u94f8\u9524\u5c31\u91cd\u94f8" + (String)(finalCount == 2 ? "\u4e24" : "\u6240\u6709" + Util.intToString(finalCount)) + "\u628a" + weapon.getNamePlural() + "\uff01</p>");
                            }
                            if (owner != null) {
                                owner.removeWeapon(weapon, finalCount);
                                AbstractWeapon modifiedWeapon = Main.game.getItemGen().generateWeapon(weapon);
                                modifiedWeapon.setDamageType(damageTypePreview);
                                owner.addWeapon(Main.game.getItemGen().generateWeapon(modifiedWeapon), finalCount, false, false);
                                Main.game.addEvent(new EventLogEntry("\u5df2\u91cd\u94f8", modifiedWeapon.getDisplayName(true)), false);
                            } else {
                                Main.game.getPlayerCell().getInventory().removeWeapon(weapon, finalCount);
                                AbstractWeapon modifiedWeapon = Main.game.getItemGen().generateWeapon(weapon);
                                modifiedWeapon.setDamageType(damageTypePreview);
                                Main.game.getPlayerCell().getInventory().addWeapon(Main.game.getItemGen().generateWeapon(modifiedWeapon), finalCount);
                                Main.game.addEvent(new EventLogEntry("\u5df2\u91cd\u94f8", modifiedWeapon.getDisplayName(true)), false);
                            }
                        }
                    };
                }
                if (index == 8) {
                    if (damageTypePreview == weapon.getDamageType()) {
                        return new Response("\u67d3\u8272\u5e76\u91cd\u94f8\u6240\u6709(\u5806\u53e0)", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u6b66\u5668\u7c7b\u578b\u624d\u80fd\u91cd\u94f8" + weapon.getName() + "\uff01", null);
                    }
                    if (dyePreviews.equals(weapon.getColours())) {
                        return new Response("\u67d3\u8272\u5e76\u91cd\u94f8\u6240\u6709(\u5806\u53e0)", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u989c\u8272\u624d\u80fd\u67d3\u8272" + weapon.getName() + "\uff01", null);
                    }
                    int stackCount = 0;
                    stackCount = owner != null ? owner.getWeaponCount(weapon) : Main.game.getPlayerCell().getInventory().getWeaponCount(weapon);
                    final int finalCount = stackCount;
                    if (stackCount == 1) {
                        return new Response("\u67d3\u8272\u5e76\u91cd\u94f8\u6240\u6709(\u5806\u53e0)", "\u4f60\u53ea\u6709\u4e00\u628a" + weapon.getName() + "\uff0c\u6240\u4ee5\u5e94\u8be5\u4f7f\u7528\u5355\u6b21\u52a8\u4f5c\u67d3\u8272\u548c\u91cd\u94f8\u2026\u2026", null);
                    }
                    if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode()) {
                        int dyeBrushCount = Main.game.getPlayer().getItemCount(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH));
                        int reforgeHammerCount = Main.game.getPlayer().getItemCount(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER));
                        if (dyeBrushCount < stackCount || reforgeHammerCount < stackCount) {
                            return new Response("\u67d3\u8272\u5e76\u91cd\u94f8\u6240\u6709(\u5806\u53e0)", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u67d3\u8272\u5237\u548c\u91cd\u94f8\u9524\u5c06\u6240\u6709\u5806\u53e0\u4e2d\u7684" + stackCount + "\u628a" + weapon.getNamePlural() + "\u67d3\u8272\u548c\u91cd\u94f8\u2026\u2026", null);
                        }
                    }
                    return new Response("\u67d3\u8272\u5e76\u91cd\u94f8\u6240\u6709(\u5806\u53e0)", "\u5c06\u6240\u6709\u5728\u8be5\u6b66\u5668\u5806\u53e0\u4e2d\u7684" + weapon.getNamePlural() + "\u67d3\u8272\u548c\u91cd\u94f8\u4e3a\u6240\u9009\u989c\u8272\u548c\u4f24\u5bb3\u7c7b\u578b(\u5171\u8ba1" + stackCount + ")\u3002" + (Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u4f46\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u968f\u65f6\u505a\u8fd9\u4e2a\u3002" : "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u5982\u679c\u60f3\u8981\u518d\u6b21\u505a\u8fd9\u4e2a\u5219\u9700\u8981\u53e6\u4e00\u4e2a\u67d3\u8272\u5237\u548c\u91cd\u94f8\u9524\u3002"), INVENTORY_MENU){

                        @Override
                        public void effects() {
                            if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode()) {
                                Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH), finalCount);
                                Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER), finalCount);
                                Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.getDyeBrushEffects(weapon, dyePreviews.get(0)) + "</p><p style='text-align:center;'>" + InventoryDialogue.getReforgeHammerEffects(weapon, damageTypePreview) + "</p><p><b>" + weapon.getName() + (weapon.getWeaponType().isPlural() ? "" : "") + "\u5df2\u7ecf\u67d3\u8272\u548c\u91cd\u94f8\u8fc7\u4e86</b>\uff01</p>");
                                Main.game.getTextEndStringBuilder().append("<p>\u63a5\u7740\u4f60\u5bf9\u5269\u4f59" + Util.intToString(finalCount - 1) + "\u628a" + weapon.getNamePlural() + "\u91cd\u590d\u4e86\u6b64\u52a8\u4f5c\u2026\u2026</p>");
                                Main.game.getTextEndStringBuilder().append("<p>" + (String)(Main.game.getPlayer().hasItemType(ItemType.DYE_BRUSH) ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH))) + "</b>\u4e2a\u67d3\u8272\u5237" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u67d3\u8272\u5237\u4e86\uff01") + "</p>");
                                Main.game.getTextEndStringBuilder().append("<p>" + (String)(Main.game.getPlayer().hasItemType(ItemType.REFORGE_HAMMER) ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER))) + "</b>\u4e2a\u91cd\u94f8\u9524" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u91cd\u94f8\u9524\u4e86\uff01") + "</p>");
                            } else {
                                Main.game.getTextEndStringBuilder().append("<p>\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.boldEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u4e0d\u4f7f\u7528\u67d3\u8272\u5237\u5c31\u67d3\u8272" + (String)(finalCount == 2 ? "\u4e24" : "\u6240\u6709" + Util.intToString(finalCount)) + "\u628a" + weapon.getNamePlural() + "\uff01</p>");
                            }
                            if (owner != null) {
                                owner.removeWeapon(weapon, finalCount);
                                AbstractWeapon modifiedWeapon = Main.game.getItemGen().generateWeapon(weapon);
                                modifiedWeapon.setDamageType(damageTypePreview);
                                modifiedWeapon.setColours(dyePreviews);
                                owner.addWeapon(Main.game.getItemGen().generateWeapon(modifiedWeapon), finalCount, false, false);
                                Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272\u5e76\u91cd\u94f8", modifiedWeapon.getDisplayName(true)), false);
                            } else {
                                Main.game.getPlayerCell().getInventory().removeWeapon(weapon, finalCount);
                                AbstractWeapon modifiedWeapon = Main.game.getItemGen().generateWeapon(weapon);
                                modifiedWeapon.setDamageType(damageTypePreview);
                                modifiedWeapon.setColours(dyePreviews);
                                Main.game.getPlayerCell().getInventory().addWeapon(Main.game.getItemGen().generateWeapon(modifiedWeapon), finalCount);
                                Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272\u5e76\u91cd\u94f8", modifiedWeapon.getDisplayName(true)), false);
                            }
                        }
                    };
                }
                if (index == 11) {
                    int dyeBrushCount;
                    if (dyePreviews.equals(weapon.getColours())) {
                        return new Response("\u67d3\u8272\u6240\u6709", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u989c\u8272\u624d\u80fd\u67d3\u8272" + weapon.getName() + "\uff01", null);
                    }
                    final ArrayList<AbstractWeapon> weaponMatches = new ArrayList<AbstractWeapon>();
                    int stackCount = 0;
                    if (owner != null) {
                        for (Map.Entry<AbstractWeapon, Integer> entry : owner.getAllWeaponsInInventory().entrySet()) {
                            if (!entry.getKey().getWeaponType().equals(weapon.getWeaponType())) continue;
                            weaponMatches.add(entry.getKey());
                            stackCount += entry.getValue().intValue();
                        }
                    } else {
                        for (Map.Entry<AbstractWeapon, Integer> entry : Main.game.getPlayerCell().getInventory().getAllWeaponsInInventory().entrySet()) {
                            if (!entry.getKey().getWeaponType().equals(weapon.getWeaponType())) continue;
                            weaponMatches.add(entry.getKey());
                            stackCount += entry.getValue().intValue();
                        }
                    }
                    final int finalCount = stackCount;
                    if (stackCount == 1) {
                        return new Response("\u67d3\u8272\u6240\u6709", "\u4f60\u53ea\u6709\u4e00\u628a" + weapon.getName() + "\uff0c\u6240\u4ee5\u5e94\u8be5\u4f7f\u7528\u5355\u6b21\u52a8\u4f5c\u67d3\u8272\u2026\u2026", null);
                    }
                    if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode() && (dyeBrushCount = Main.game.getPlayer().getItemCount(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH))) < stackCount) {
                        return new Response("\u67d3\u8272\u6240\u6709", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u67d3\u8272\u5237\u5c06\u6240\u6709" + weapon.getNamePlural() + "\u67d3\u8272\uff01\u4f60\u53ea\u6709\u4e2a" + dyeBrushCount + "\u67d3\u8272\u5237\uff0c\u4f46\u603b\u5171\u6709" + stackCount + "\u628a" + weapon.getNamePlural() + "\u2026\u2026", null);
                    }
                    return new Response("\u67d3\u8272\u6240\u6709", "\u5c06\u6240\u6709\u5728\u8be5\u6b66\u5668\u5806\u53e0\u4e2d\u7684" + weapon.getNamePlural() + "\u67d3\u8272\u4e3a\u6240\u9009\u989c\u8272(\u5171\u8ba1" + stackCount + ")\u3002" + (Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u4f46\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u968f\u65f6\u5c06\u5176\u67d3\u6210\u4e0d\u540c\u989c\u8272\u3002" : "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u5982\u679c\u60f3\u8981\u518d\u6b21\u66f4\u6539\u989c\u8272\u5219\u9700\u8981\u53e6\u4e00\u4e2a\u67d3\u8272\u5237\u3002"), INVENTORY_MENU){

                        @Override
                        public void effects() {
                            if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode()) {
                                Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH), finalCount);
                                Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.getDyeBrushEffects(weapon, dyePreviews.get(0)) + "</p><p><b>" + weapon.getName() + (weapon.getWeaponType().isPlural() ? "" : "") + "\u5df2\u7ecf\u67d3\u8272\u8fc7\u4e86</b>\uff01</p>");
                                Main.game.getTextEndStringBuilder().append("<p>\u63a5\u7740\u4f60\u5bf9\u5269\u4f59" + Util.intToString(finalCount - 1) + "\u628a" + weapon.getNamePlural() + "\u91cd\u590d\u4e86\u6b64\u52a8\u4f5c\u2026\u2026</p>");
                                Main.game.getTextEndStringBuilder().append("<p>" + (String)(InventoryDialogue.isClothingDyeActionAvailable() ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH))) + "</b>\u4e2a\u67d3\u8272\u5237" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u67d3\u8272\u5237\u4e86\uff01") + "</p>");
                            } else {
                                Main.game.getTextEndStringBuilder().append("<p>\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.boldEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u4e0d\u4f7f\u7528\u67d3\u8272\u5237\u5c31\u67d3\u8272" + (String)(finalCount == 2 ? "\u4e24" : "\u6240\u6709" + Util.intToString(finalCount)) + "\u628a" + weapon.getNamePlural() + "\uff01</p>");
                            }
                            if (owner != null) {
                                for (AbstractWeapon w : weaponMatches) {
                                    int weaponCount = owner.getAllWeaponsInInventory().get(w);
                                    owner.removeWeapon(w, weaponCount);
                                    AbstractWeapon dyedWeapon = Main.game.getItemGen().generateWeapon(w);
                                    dyedWeapon.setColours(dyePreviews);
                                    owner.addWeapon(dyedWeapon, weaponCount, false, false);
                                    Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272", dyedWeapon.getDisplayName(true)), false);
                                }
                            } else {
                                for (AbstractWeapon w : weaponMatches) {
                                    int weaponCount = Main.game.getPlayerCell().getInventory().getAllWeaponsInInventory().get(w);
                                    Main.game.getPlayerCell().getInventory().removeWeapon(w, weaponCount);
                                    AbstractWeapon dyedWeapon = Main.game.getItemGen().generateWeapon(w);
                                    dyedWeapon.setColours(dyePreviews);
                                    Main.game.getPlayerCell().getInventory().addWeapon(dyedWeapon, weaponCount);
                                    Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272", dyedWeapon.getDisplayName(true)), false);
                                }
                            }
                        }
                    };
                }
                if (index == 12) {
                    int reforgeHammerCount;
                    if (damageTypePreview == weapon.getDamageType()) {
                        return new Response("\u91cd\u94f8\u6240\u6709", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u6b66\u5668\u7c7b\u578b\u624d\u80fd\u91cd\u94f8" + weapon.getName() + "\uff01", null);
                    }
                    final ArrayList<AbstractWeapon> weaponMatches = new ArrayList<AbstractWeapon>();
                    int stackCount = 0;
                    if (owner != null) {
                        for (Map.Entry<AbstractWeapon, Integer> entry : owner.getAllWeaponsInInventory().entrySet()) {
                            if (!entry.getKey().getWeaponType().equals(weapon.getWeaponType())) continue;
                            weaponMatches.add(entry.getKey());
                            stackCount += entry.getValue().intValue();
                        }
                    } else {
                        for (Map.Entry<AbstractWeapon, Integer> entry : Main.game.getPlayerCell().getInventory().getAllWeaponsInInventory().entrySet()) {
                            if (!entry.getKey().getWeaponType().equals(weapon.getWeaponType())) continue;
                            weaponMatches.add(entry.getKey());
                            stackCount += entry.getValue().intValue();
                        }
                    }
                    final int finalCount = stackCount;
                    if (stackCount == 1) {
                        return new Response("\u91cd\u94f8\u6240\u6709", "\u4f60\u53ea\u6709\u4e00\u628a" + weapon.getName() + "\uff0c\u6240\u4ee5\u5e94\u8be5\u4f7f\u7528\u5355\u6b21\u52a8\u4f5c\u91cd\u94f8\u2026\u2026", null);
                    }
                    if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode() && (reforgeHammerCount = Main.game.getPlayer().getItemCount(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER))) < stackCount) {
                        return new Response("\u91cd\u94f8\u6240\u6709", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u91cd\u94f8\u9524\u5c06\u6240\u6709" + weapon.getNamePlural() + "\u91cd\u94f8\uff01\u4f60\u53ea\u6709" + reforgeHammerCount + "\u4e2a\u91cd\u94f8\u9524\uff0c\u4f46\u603b\u5171\u6709" + stackCount + "\u628a" + weapon.getNamePlural() + "\u2026\u2026", null);
                    }
                    return new Response("\u91cd\u94f8\u6240\u6709", "\u5c06\u6240\u6709\u5728\u8be5\u6b66\u5668\u5806\u53e0\u4e2d\u7684" + weapon.getNamePlural() + "\u91cd\u94f8\u4e3a\u9009\u4e2d\u7684\u4f24\u5bb3\u7c7b\u578b(" + stackCount + " in total)\u3002" + (Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u4f46\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u968f\u65f6\u5c06\u5176\u91cd\u94f8\u3002" : "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u5982\u679c\u60f3\u8981\u518d\u6b21\u66f4\u6539\u4f24\u5bb3\u7c7b\u578b\u5219\u9700\u8981\u53e6\u4e00\u4e2a\u91cd\u94f8\u9524\u3002"), INVENTORY_MENU){

                        @Override
                        public void effects() {
                            if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode()) {
                                Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER), finalCount);
                                Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.getReforgeHammerEffects(weapon, damageTypePreview) + "</p><p><b>" + weapon.getName() + (weapon.getWeaponType().isPlural() ? "" : "") + "\u5df2\u7ecf\u91cd\u94f8\u8fc7\u4e86</b>\uff01</p>");
                                Main.game.getTextEndStringBuilder().append("<p>\u63a5\u7740\u4f60\u5bf9\u5269\u4f59" + Util.intToString(finalCount - 1) + "\u628a" + weapon.getNamePlural() + "\u91cd\u590d\u4e86\u6b64\u52a8\u4f5c\u2026\u2026</p>");
                                Main.game.getTextEndStringBuilder().append("<p>" + (String)(Main.game.getPlayer().hasItemType(ItemType.REFORGE_HAMMER) || Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER))) + "</b>\u4e2a\u91cd\u94f8\u9524" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u91cd\u94f8\u9524\u4e86\uff01") + "</p>");
                            } else {
                                Main.game.getTextEndStringBuilder().append("<p>\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.boldEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u4e0d\u4f7f\u7528\u91cd\u94f8\u9524\u5c31\u91cd\u94f8" + (String)(finalCount == 2 ? "\u4e24" : "\u6240\u6709" + Util.intToString(finalCount)) + "\u628a" + weapon.getNamePlural() + "\uff01</p>");
                            }
                            if (owner != null) {
                                for (AbstractWeapon w : weaponMatches) {
                                    int weaponCount = owner.getAllWeaponsInInventory().get(w);
                                    owner.removeWeapon(w, weaponCount);
                                    AbstractWeapon modifiedWeapon = Main.game.getItemGen().generateWeapon(w);
                                    modifiedWeapon.setDamageType(damageTypePreview);
                                    owner.addWeapon(Main.game.getItemGen().generateWeapon(modifiedWeapon), weaponCount, false, false);
                                    Main.game.addEvent(new EventLogEntry("\u5df2\u91cd\u94f8", modifiedWeapon.getDisplayName(true)), false);
                                }
                            } else {
                                for (AbstractWeapon w : weaponMatches) {
                                    int weaponCount = Main.game.getPlayerCell().getInventory().getAllWeaponsInInventory().get(w);
                                    Main.game.getPlayerCell().getInventory().removeWeapon(w, weaponCount);
                                    AbstractWeapon modifiedWeapon = Main.game.getItemGen().generateWeapon(w);
                                    modifiedWeapon.setDamageType(damageTypePreview);
                                    Main.game.getPlayerCell().getInventory().addWeapon(Main.game.getItemGen().generateWeapon(modifiedWeapon), weaponCount);
                                    Main.game.addEvent(new EventLogEntry("\u5df2\u91cd\u94f8", modifiedWeapon.getDisplayName(true)), false);
                                }
                            }
                        }
                    };
                }
                if (index == 13) {
                    if (damageTypePreview == weapon.getDamageType()) {
                        return new Response("\u67d3\u8272\u5e76\u91cd\u94f8\u6240\u6709", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u6b66\u5668\u7c7b\u578b\u624d\u80fd\u91cd\u94f8" + weapon.getName() + "\uff01", null);
                    }
                    if (dyePreviews.equals(weapon.getColours())) {
                        return new Response("\u67d3\u8272\u5e76\u91cd\u94f8\u6240\u6709", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u989c\u8272\u624d\u80fd\u67d3\u8272" + weapon.getName() + "\uff01", null);
                    }
                    final ArrayList<AbstractWeapon> weaponMatches = new ArrayList<AbstractWeapon>();
                    int stackCount = 0;
                    if (owner != null) {
                        for (Map.Entry<AbstractWeapon, Integer> entry : owner.getAllWeaponsInInventory().entrySet()) {
                            if (!entry.getKey().getWeaponType().equals(weapon.getWeaponType())) continue;
                            weaponMatches.add(entry.getKey());
                            stackCount += entry.getValue().intValue();
                        }
                    } else {
                        for (Map.Entry<AbstractWeapon, Integer> entry : Main.game.getPlayerCell().getInventory().getAllWeaponsInInventory().entrySet()) {
                            if (!entry.getKey().getWeaponType().equals(weapon.getWeaponType())) continue;
                            weaponMatches.add(entry.getKey());
                            stackCount += entry.getValue().intValue();
                        }
                    }
                    final int finalCount = stackCount;
                    if (stackCount == 1) {
                        return new Response("\u67d3\u8272\u5e76\u91cd\u94f8\u6240\u6709", "\u4f60\u53ea\u6709\u4e00\u628a" + weapon.getName() + "\uff0c\u6240\u4ee5\u5e94\u8be5\u4f7f\u7528\u5355\u6b21\u52a8\u4f5c\u67d3\u8272\u548c\u91cd\u94f8\u2026\u2026", null);
                    }
                    if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode()) {
                        int dyeBrushCount = Main.game.getPlayer().getItemCount(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH));
                        int reforgeHammerCount = Main.game.getPlayer().getItemCount(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER));
                        if (dyeBrushCount < stackCount || reforgeHammerCount < stackCount) {
                            return new Response("\u67d3\u8272\u5e76\u91cd\u94f8\u6240\u6709", "\u4f60\u6ca1\u6709\u8db3\u591f\u7684\u67d3\u8272\u5237\u548c\u91cd\u94f8\u9524\u5c06\u6240\u6709\u5806\u53e0\u4e2d\u7684" + stackCount + "\u628a" + weapon.getNamePlural() + "\u67d3\u8272\u548c\u91cd\u94f8\u2026\u2026", null);
                        }
                    }
                    return new Response("\u67d3\u8272\u5e76\u91cd\u94f8\u6240\u6709", "\u5c06\u6240\u6709\u5728\u8be5\u6b66\u5668\u5806\u53e0\u4e2d\u7684" + weapon.getNamePlural() + "\u67d3\u8272\u548c\u91cd\u94f8\u4e3a\u6240\u9009\u989c\u8272\u548c\u4f24\u5bb3\u7c7b\u578b(\u5171\u8ba1" + stackCount + ")\u3002" + (Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u4f46\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u968f\u65f6\u505a\u8fd9\u4e2a\u3002" : "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u5982\u679c\u60f3\u8981\u518d\u6b21\u505a\u8fd9\u4e2a\u5219\u9700\u8981\u53e6\u4e00\u4e2a\u67d3\u8272\u5237\u548c\u91cd\u94f8\u9524\u3002"), INVENTORY_MENU){

                        @Override
                        public void effects() {
                            if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode()) {
                                Main.game.getPlayer().removeItem(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH), finalCount);
                                Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.getDyeBrushEffects(weapon, dyePreviews.get(0)) + "</p><p style='text-align:center;'>" + InventoryDialogue.getReforgeHammerEffects(weapon, damageTypePreview) + "</p><p><b>" + weapon.getName() + (weapon.getWeaponType().isPlural() ? "" : "") + "\u5df2\u7ecf\u67d3\u8272\u548c\u91cd\u94f8\u8fc7\u4e86</b>\uff01</p>");
                                Main.game.getTextEndStringBuilder().append("<p>\u63a5\u7740\u4f60\u5bf9\u5269\u4f59" + Util.intToString(finalCount - 1) + "\u628a" + weapon.getNamePlural() + "\u91cd\u590d\u4e86\u6b64\u52a8\u4f5c\u2026\u2026</p>");
                                Main.game.getTextEndStringBuilder().append("<p>" + (String)(Main.game.getPlayer().hasItemType(ItemType.DYE_BRUSH) ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH))) + "</b>\u4e2a\u67d3\u8272\u5237" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u67d3\u8272\u5237\u4e86\uff01") + "</p>");
                                Main.game.getTextEndStringBuilder().append("<p>" + (String)(Main.game.getPlayer().hasItemType(ItemType.REFORGE_HAMMER) ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER))) + "</b>\u4e2a\u91cd\u94f8\u9524" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u91cd\u94f8\u9524\u4e86\uff01") + "</p>");
                            } else {
                                Main.game.getTextEndStringBuilder().append("<p>\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.boldEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u4e0d\u4f7f\u7528\u67d3\u8272\u5237\u548c\u91cd\u94f8\u9524\u5c31\u67d3\u8272\u548c\u91cd\u94f8" + (String)(finalCount == 2 ? "\u4e24" : "\u6240\u6709" + Util.intToString(finalCount)) + "\u628a" + weapon.getNamePlural() + "\uff01</p>");
                            }
                            if (owner != null) {
                                for (AbstractWeapon w : weaponMatches) {
                                    int weaponCount = owner.getAllWeaponsInInventory().get(w);
                                    owner.removeWeapon(w, weaponCount);
                                    AbstractWeapon modifiedWeapon = Main.game.getItemGen().generateWeapon(w);
                                    modifiedWeapon.setDamageType(damageTypePreview);
                                    modifiedWeapon.setColours(dyePreviews);
                                    owner.addWeapon(Main.game.getItemGen().generateWeapon(modifiedWeapon), weaponCount, false, false);
                                    Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272\u5e76\u91cd\u94f8", modifiedWeapon.getDisplayName(true)), false);
                                }
                            } else {
                                for (AbstractWeapon w : weaponMatches) {
                                    int weaponCount = Main.game.getPlayerCell().getInventory().getAllWeaponsInInventory().get(w);
                                    Main.game.getPlayerCell().getInventory().removeWeapon(w, weaponCount);
                                    AbstractWeapon modifiedWeapon = Main.game.getItemGen().generateWeapon(w);
                                    modifiedWeapon.setDamageType(damageTypePreview);
                                    modifiedWeapon.setColours(dyePreviews);
                                    Main.game.getPlayerCell().getInventory().addWeapon(Main.game.getItemGen().generateWeapon(modifiedWeapon), weaponCount);
                                    Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272\u5e76\u91cd\u94f8", modifiedWeapon.getDisplayName(true)), false);
                                }
                            }
                        }
                    };
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.INVENTORY;
            }
        };
        DYE_EQUIPPED_WEAPON = new DialogueNode("\u67d3\u8272\u6b66\u5668", "", true){

            @Override
            public String getContent() {
                return InventoryDialogue.getWeaponDyeUI();
            }

            @Override
            public Response getResponse(int responseTab, int index) {
                if (index == 0) {
                    return new Response("\u8fd4\u56de", "\u8fd4\u56de\u4e4b\u524d\u7684\u83dc\u5355\u3002", INVENTORY_MENU);
                }
                if (index == 1) {
                    if (!(Main.game.getPlayer().hasItemType(ItemType.DYE_BRUSH) || Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) || Main.game.isDebugMode())) {
                        return new Response("\u67d3\u8272", "\u4f60\u6ca1\u6709\u67d3\u8272\u5237\uff0c\u6240\u4ee5\u65e0\u6cd5\u66f4\u6539" + weapon.getName() + "\u7684\u989c\u8272\u2026\u2026", null);
                    }
                    if (dyePreviews.equals(weapon.getColours())) {
                        return new Response("\u67d3\u8272", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u989c\u8272\u624d\u80fd\u67d3\u8272" + weapon.getName() + "\uff01", null);
                    }
                    return new Response("\u67d3\u8272", "\u4f7f\u7528\u9009\u4e2d\u7684\u989c\u8272\u67d3\u8272" + weapon.getName() + "\u3002" + (Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u4f46\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u968f\u65f6\u5c06\u5176\u67d3\u6210\u4e0d\u540c\u989c\u8272\u3002" : "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u5982\u679c\u60f3\u8981\u518d\u6b21\u66f4\u6539\u989c\u8272\u5219\u9700\u8981\u53e6\u4e00\u4e2a\u67d3\u8272\u5237\u3002"), INVENTORY_MENU){

                        @Override
                        public void effects() {
                            if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode()) {
                                Main.game.getPlayer().useItem(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH), owner, false);
                                Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.getDyeBrushEffects(weapon, dyePreviews.get(0)) + "</p><p><b>" + weapon.getName() + (weapon.getWeaponType().isPlural() ? "" : "") + "\u5df2\u7ecf\u67d3\u8272\u8fc7\u4e86</b>\uff01</p><p>" + (String)(InventoryDialogue.isClothingDyeActionAvailable() ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH))) + "</b>\u4e2a\u67d3\u8272\u5237" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u67d3\u8272\u5237\u4e86\uff01") + "</p>");
                            } else {
                                Main.game.getTextEndStringBuilder().append("<p>\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.boldEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u4e0d\u4f7f\u7528\u67d3\u8272\u5237\u5c31\u67d3\u8272" + weapon.getName() + "\uff01</p>");
                            }
                            owner.unequipWeaponIntoVoid(weaponSlot, weapon, true);
                            AbstractWeapon modifiedWeapon = Main.game.getItemGen().generateWeapon(weapon);
                            modifiedWeapon.setColours(dyePreviews);
                            if (weaponSlot == InventorySlot.WEAPON_MAIN_1 || weaponSlot == InventorySlot.WEAPON_MAIN_2 || weaponSlot == InventorySlot.WEAPON_MAIN_3) {
                                owner.equipMainWeaponFromNowhere(Main.game.getItemGen().generateWeapon(modifiedWeapon));
                            } else {
                                owner.equipOffhandWeaponFromNowhere(Main.game.getItemGen().generateWeapon(modifiedWeapon));
                            }
                            Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272", weapon.getDisplayName(true)), false);
                        }
                    };
                }
                if (index == 2) {
                    if (!(Main.game.getPlayer().hasItemType(ItemType.REFORGE_HAMMER) || Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) || Main.game.isDebugMode())) {
                        return new Response("\u91cd\u94f8", "\u4f60\u6ca1\u6709\u91cd\u94f8\u9524\uff0c\u6240\u4ee5\u65e0\u6cd5\u66f4\u6539" + weapon.getName() + "\u7684\u4f24\u5bb3\u7c7b\u578b\u2026\u2026", null);
                    }
                    if (damageTypePreview == weapon.getDamageType()) {
                        return new Response("\u91cd\u94f8", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u6b66\u5668\u7c7b\u578b\u624d\u80fd\u91cd\u94f8" + weapon.getName() + "\uff01", null);
                    }
                    return new Response("\u91cd\u94f8", "\u5c06" + weapon.getName() + "\u91cd\u94f8\u4e3a\u9009\u4e2d\u7684\u4f24\u5bb3\u7c7b\u578b\u3002" + (Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u4f46\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u968f\u65f6\u5c06\u5176\u91cd\u94f8\u3002" : "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u5982\u679c\u60f3\u8981\u518d\u6b21\u66f4\u6539\u4f24\u5bb3\u7c7b\u578b\u5219\u9700\u8981\u53e6\u4e00\u4e2a\u91cd\u94f8\u9524\u3002"), INVENTORY_MENU){

                        @Override
                        public void effects() {
                            if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode()) {
                                Main.game.getPlayer().useItem(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER), owner, false);
                                Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.getReforgeHammerEffects(weapon, damageTypePreview) + "</p><p><b>" + weapon.getName() + (weapon.getWeaponType().isPlural() ? "" : "") + "\u5df2\u7ecf\u91cd\u94f8\u8fc7\u4e86</b>\uff01</p><p>" + (String)(Main.game.getPlayer().hasItemType(ItemType.REFORGE_HAMMER) || Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER))) + "</b>\u4e2a\u91cd\u94f8\u9524" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u91cd\u94f8\u9524\u4e86\uff01") + "</p>");
                            } else {
                                Main.game.getTextEndStringBuilder().append("<p>\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.boldEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u4e0d\u4f7f\u7528\u91cd\u94f8\u9524\u5c31\u91cd\u94f8" + weapon.getName() + "\uff01</p>");
                            }
                            owner.unequipWeaponIntoVoid(weaponSlot, weapon, true);
                            AbstractWeapon modifiedWeapon = Main.game.getItemGen().generateWeapon(weapon);
                            modifiedWeapon.setDamageType(damageTypePreview);
                            if (weaponSlot == InventorySlot.WEAPON_MAIN_1 || weaponSlot == InventorySlot.WEAPON_MAIN_2 || weaponSlot == InventorySlot.WEAPON_MAIN_3) {
                                owner.equipMainWeaponFromNowhere(Main.game.getItemGen().generateWeapon(modifiedWeapon));
                            } else {
                                owner.equipOffhandWeaponFromNowhere(Main.game.getItemGen().generateWeapon(modifiedWeapon));
                            }
                            Main.game.addEvent(new EventLogEntry("\u5df2\u91cd\u94f8", weapon.getDisplayName(true)), false);
                        }
                    };
                }
                if (index == 3) {
                    if (!(Main.game.getPlayer().hasItemType(ItemType.REFORGE_HAMMER) && Main.game.getPlayer().hasItemType(ItemType.DYE_BRUSH) || Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) || Main.game.isDebugMode())) {
                        return new Response("\u67d3\u8272\u5e76\u91cd\u94f8", "\u4f60\u6ca1\u6709\u67d3\u8272\u5237\u548c\u91cd\u94f8\u9524\uff0c\u65e0\u6cd5\u67d3\u8272\u5e76\u91cd\u94f8" + weapon.getName() + "\u2026\u2026", null);
                    }
                    if (damageTypePreview == weapon.getDamageType()) {
                        return new Response("\u67d3\u8272\u5e76\u91cd\u94f8", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u6b66\u5668\u7c7b\u578b\u624d\u80fd\u91cd\u94f8" + weapon.getName() + "\uff01", null);
                    }
                    if (dyePreviews.equals(weapon.getColours())) {
                        return new Response("\u67d3\u8272\u5e76\u91cd\u94f8", "\u9700\u8981\u9009\u62e9\u4e0e\u4e4b\u524d\u4e0d\u540c\u7684\u989c\u8272\u624d\u80fd\u67d3\u8272" + weapon.getName() + "\uff01", null);
                    }
                    return new Response("\u67d3\u8272\u5e76\u91cd\u94f8", "\u5c06" + weapon.getName() + "\u67d3\u8272\u5e76\u91cd\u94f8\u4e3a\u4f60\u9009\u62e9\u7684\u989c\u8272\u548c\u4f24\u5bb3\u7c7b\u578b\u3002" + (Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u4f46\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.colourEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u968f\u65f6\u5c06\u5176\u67d3\u8272\u4e0e\u91cd\u94f8\u3002" : "\u8be5\u884c\u4e3a\u662f\u6c38\u4e45\u7684\uff0c\u5982\u679c\u60f3\u8981\u518d\u6b21\u66f4\u6539\u989c\u8272\u548c\u4f24\u5bb3\u7c7b\u578b\u5219\u9700\u8981\u53e6\u4e00\u4e2a\u67d3\u8272\u5237\u548c\u91cd\u94f8\u9524\u3002"), INVENTORY_MENU){

                        @Override
                        public void effects() {
                            if (!Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) && !Main.game.isDebugMode()) {
                                Main.game.getPlayer().useItem(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH), owner, false);
                                Main.game.getPlayer().useItem(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER), owner, false);
                                Main.game.getTextEndStringBuilder().append("<p style='text-align:center;'>" + InventoryDialogue.getDyeBrushEffects(weapon, dyePreviews.get(0)) + "</p><p style='text-align:center;'>" + InventoryDialogue.getReforgeHammerEffects(weapon, damageTypePreview) + "</p><p><b>" + weapon.getName() + (weapon.getWeaponType().isPlural() ? "" : "") + "\u5df2\u7ecf\u91cd\u94f8\u8fc7\u4e86</b>\uff01</p><p>" + (String)(InventoryDialogue.isClothingDyeActionAvailable() ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH))) + "</b>\u4e2a\u67d3\u8272\u5237" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.DYE_BRUSH)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u67d3\u8272\u5237\u4e86\uff01") + "<br/>" + (String)(Main.game.getPlayer().hasItemType(ItemType.REFORGE_HAMMER) || Main.game.getPlayer().isSpellSchoolSpecialAbilityUnlocked(SpellSchool.EARTH) ? "\u4f60\u8fd8\u5269\u4e0b<b>" + String.valueOf(Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER))) + "</b>\u4e2a\u91cd\u94f8\u9524" + (Main.game.getPlayer().getAllItemsInInventory().get(Main.game.getItemGen().generateItem(ItemType.REFORGE_HAMMER)) == 1 ? "" : "") + "\uff01" : "\u4f60<b>\u6ca1\u6709</b>\u91cd\u94f8\u9524\u4e86\uff01") + "</p>");
                            } else {
                                Main.game.getTextEndStringBuilder().append("<p>\u7531\u4e8e\u4f60\u7cbe\u901a\u7684[style.boldEarth(\u571f\u7cfb\u6cd5\u672f)]\uff0c\u4f60\u53ef\u4ee5\u4e0d\u4f7f\u7528\u67d3\u8272\u5237\u548c\u91cd\u94f8\u9524\u5c31\u67d3\u8272\u548c\u91cd\u94f8" + weapon.getName() + "\uff01</p>");
                            }
                            owner.unequipWeaponIntoVoid(weaponSlot, weapon, true);
                            AbstractWeapon modifiedWeapon = Main.game.getItemGen().generateWeapon(weapon);
                            modifiedWeapon.setColours(dyePreviews);
                            modifiedWeapon.setDamageType(damageTypePreview);
                            if (weaponSlot == InventorySlot.WEAPON_MAIN_1 || weaponSlot == InventorySlot.WEAPON_MAIN_2 || weaponSlot == InventorySlot.WEAPON_MAIN_3) {
                                owner.equipMainWeaponFromNowhere(Main.game.getItemGen().generateWeapon(modifiedWeapon));
                            } else {
                                owner.equipOffhandWeaponFromNowhere(Main.game.getItemGen().generateWeapon(modifiedWeapon));
                            }
                            Main.game.addEvent(new EventLogEntry("\u5df2\u67d3\u8272\u5e76\u91cd\u94f8", weapon.getDisplayName(true)), false);
                        }
                    };
                }
                return null;
            }

            @Override
            public DialogueNodeType getDialogueNodeType() {
                return DialogueNodeType.INVENTORY;
            }
        };
    }
}

