/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.dialogue.utils;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.types.BodyPartType;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.List;

public abstract class ParserCommand {
    private boolean allowsCapitalisation;
    private boolean allowPronoun;
    private String description;
    private String arguments;
    private List<String> tags;
    private BodyPartType relatedBodyPart;

    public ParserCommand(List<String> tags, boolean allowsCapitalisation, boolean allowPronoun, String arguments, String description) {
        this(tags, allowsCapitalisation, allowPronoun, arguments, description, BodyPartType.GENERIC);
    }

    public ParserCommand(List<String> tags, boolean allowsCapitalisation, boolean allowPronoun, String arguments, String description, BodyPartType relatedBodyPart) {
        this.tags = tags;
        this.allowsCapitalisation = allowsCapitalisation;
        this.allowPronoun = allowPronoun;
        this.description = description;
        this.arguments = arguments;
        this.relatedBodyPart = relatedBodyPart;
    }

    public boolean isAllowsCapitalisation() {
        return this.allowsCapitalisation;
    }

    public boolean isAllowsPronoun() {
        return this.allowPronoun;
    }

    public String getDescription() {
        return this.description;
    }

    public String getArguments() {
        return this.arguments;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public BodyPartType getRelatedBodyPart() {
        return this.relatedBodyPart;
    }

    public String getArgumentExample() {
        return "\u793a\u4f8b\u53c2\u6570";
    }

    public String getExampleBeforeParse(String target, String arguments) {
        return "[<i style='color:" + PresetColour.CLOTHING_BLUE_LIGHT.toWebHexString() + ";'>" + target + "</i>.<i style='color:" + PresetColour.CLOTHING_PINK_LIGHT.toWebHexString() + ";'>" + this.tags.get(0) + "</i>" + (String)(arguments == "" ? "" : "<i style='color:" + PresetColour.CLOTHING_YELLOW.toWebHexString() + ";'>(" + arguments + ")</i>") + "]";
    }

    public abstract String parse(List<GameCharacter> var1, String var2, String var3, String var4, GameCharacter var5);

    protected static String applyDescriptor(String descriptor, String name) {
        if (descriptor == null) {
            return name;
        }
        return (String)(descriptor.length() > 0 ? descriptor + "\u7684" : UtilText.returnStringAtRandom("\u5e73\u5e73\u65e0\u5947\u7684", "\u666e\u901a\u7684", "\u5e73\u5e38\u7684")) + name;
    }

    protected String applyDeterminer(String descriptor, String input) {
        if (descriptor == null) {
            return input;
        }
        return (descriptor.length() > 0 ? descriptor : "") + input;
    }
}

