/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AbstractAttribute;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreType;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.Rarity;
import com.lilithsthrone.game.inventory.enchanting.AbstractItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.XMLSaving;
import com.lilithsthrone.utils.colours.Colour;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractCoreItem
implements XMLSaving {
    protected String name;
    protected String namePlural;
    protected String SVGString;
    protected Rarity rarity;
    protected List<Colour> colours;
    protected Map<AbstractAttribute, Integer> attributeModifiers;
    protected Set<ItemTag> itemTags;

    public AbstractCoreItem(String name, String namePlural, String SVGString, Colour colour, Rarity rarity, Map<AbstractAttribute, Integer> attributeModifiers) {
        this(name, namePlural, SVGString, colour, rarity, attributeModifiers, new HashSet<ItemTag>());
    }

    public AbstractCoreItem(String name, String namePlural, String SVGString, Colour colour, Rarity rarity, Map<AbstractAttribute, Integer> attributeModifiers, Set<ItemTag> itemTags) {
        this.name = name;
        this.namePlural = namePlural;
        this.colours = Util.newArrayListOfValues(colour);
        this.rarity = rarity;
        this.SVGString = SVGString;
        this.attributeModifiers = new TreeMap<AbstractAttribute, Integer>();
        this.itemTags = new HashSet<ItemTag>();
        if (attributeModifiers != null) {
            for (Map.Entry<AbstractAttribute, Integer> e : attributeModifiers.entrySet()) {
                this.attributeModifiers.put(e.getKey(), e.getValue());
            }
        }
        if (itemTags != null) {
            this.itemTags.addAll(itemTags);
        }
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        System.err.print("Error: Tried to export an abstract item!");
        return null;
    }

    public static AbstractCoreItem loadFromXML(Element parentElement, Document doc) {
        System.err.print("Error: Tried to import an abstract item!");
        return null;
    }

    public boolean isAbleToBeEnchanted() {
        return this.getEnchantmentEffect() != null && this.getEnchantmentItemType(null) != null;
    }

    public int getEnchantmentLimit() {
        return 100;
    }

    public AbstractItemEffectType getEnchantmentEffect() {
        return null;
    }

    public AbstractCoreType getEnchantmentItemType(List<ItemEffect> effects) {
        return null;
    }

    public AbstractCoreItem enchant(TFModifier primaryModifier, TFModifier secondaryModifier) {
        return this;
    }

    public boolean equals(Object o) {
        return o instanceof AbstractCoreItem && ((AbstractCoreItem)o).getName().equals(this.getName()) && ((AbstractCoreItem)o).getColours().equals(this.getColours()) && ((AbstractCoreItem)o).getRarity() == this.getRarity() && ((AbstractCoreItem)o).getAttributeModifiers().equals(this.getAttributeModifiers()) && ((AbstractCoreItem)o).getEnchantmentEffect() == this.getEnchantmentEffect() && ((AbstractCoreItem)o).getEnchantmentItemType(null) == this.getEnchantmentItemType(null) && ((AbstractCoreItem)o).getItemTags().equals(this.getItemTags());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + this.getColours().hashCode();
        result = 31 * result + this.getRarity().hashCode();
        result = 31 * result + this.getAttributeModifiers().hashCode();
        if (this.getEnchantmentEffect() != null) {
            result = 31 * result + this.getEnchantmentEffect().hashCode();
        }
        if (this.getEnchantmentItemType(null) != null) {
            result = 31 * result + this.getEnchantmentItemType(null).hashCode();
        }
        if (this.getItemTags() != null) {
            result = 31 * result + this.getItemTags().hashCode();
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamePlural() {
        return this.namePlural;
    }

    public String getDisplayName(boolean withRarityColour) {
        return Util.capitaliseSentence(UtilText.generateSingularDeterminer(this.name)) + (String)(withRarityColour ? "<span style='color: " + this.rarity.getColour().toWebHexString() + ";'>" + this.name + "</span>" : this.name);
    }

    public String getDisplayNamePlural(boolean withRarityColour) {
        return Util.capitaliseSentence((String)(withRarityColour ? "<span style='color: " + this.rarity.getColour().toWebHexString() + ";'>" + this.namePlural + "</span>" : this.namePlural));
    }

    public String getSVGString() {
        return this.SVGString;
    }

    public void setSVGString(String SVGString) {
        this.SVGString = SVGString;
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public abstract String getDescription(GameCharacter var1);

    public abstract int getValue();

    public int getPrice(float modifier) {
        return (int)((float)this.getValue() * modifier);
    }

    public void setRarity(Rarity rarity) {
        this.rarity = rarity;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public Colour getColour(int index) {
        try {
            return this.colours.get(index);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public List<Colour> getColours() {
        return this.colours;
    }

    public void setColours(List<Colour> colours) {
        this.colours = new ArrayList<Colour>(colours);
    }

    public void setColour(int index, Colour colour) {
        if (this.colours.size() > index) {
            this.colours.remove(index);
        }
        this.colours.add(index, colour);
    }

    public Map<AbstractAttribute, Integer> getAttributeModifiers() {
        return this.attributeModifiers;
    }

    public void setAttributeModifiers(Map<AbstractAttribute, Integer> attributeModifiers) {
        this.attributeModifiers = new TreeMap<AbstractAttribute, Integer>(attributeModifiers);
    }

    public List<ItemEffect> getEffects() {
        return new ArrayList<ItemEffect>();
    }

    public Set<ItemTag> getItemTags() {
        return this.itemTags;
    }
}

