/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory;

import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.ColourListPresets;
import com.lilithsthrone.utils.colours.PresetColour;
import java.util.ArrayList;
import java.util.List;

public class ColourReplacement {
    public static final Colour DEFAULT_COLOUR_VALUE = PresetColour.CLOTHING_BLACK;
    public static final List<String> DEFAULT_PRIMARY_REPLACEMENTS = Util.newArrayListOfValues("#ff2a2a", "#ff5555", "#ff8080", "#ffaaaa", "#ffd5d5");
    public static final List<String> DEFAULT_SECONDARY_REPLACEMENTS = Util.newArrayListOfValues("#ff7f2a", "#ff9955", "#ffb380", "#ffccaa", "#ffe6d5");
    public static final List<String> DEFAULT_TERTIARY_REPLACEMENTS = Util.newArrayListOfValues("#ffd42a", "#ffdd55", "#ffe680", "#ffeeaa", "#fff6d5");
    public static final List<String> DEFAULT_QUATERNARY_REPLACEMENTS = Util.newArrayListOfValues("#abc837", "#bcd35f", "#cdde87", "#dde9af", "#eef4d7");
    public static final List<String> DEFAULT_PATTERN_PRIMARY_REPLACEMENTS = Util.newArrayListOfValues("#c83737", "#d35f5f", "#de8787", "#e9afaf", "#f4d7d7");
    public static final List<String> DEFAULT_PATTERN_SECONDARY_REPLACEMENTS = Util.newArrayListOfValues("#c87137", "#d38d5f", "#deaa87", "#e9c6af", "#f4e3d7");
    public static final List<String> DEFAULT_PATTERN_TERTIARY_REPLACEMENTS = Util.newArrayListOfValues("#c8ab37", "#d3bc5f", "#decd87", "#e9ddaf", "#f4eed7");
    private boolean recolouringAllowed;
    private List<String> colourReplacements;
    private List<Colour> defaultColours;
    private List<Colour> extraColours;
    private List<Colour> allColours;

    public ColourReplacement(boolean recolouringAllowed, List<String> colourReplacements, List<Colour> defaultColours, List<Colour> extraColours) {
        this.recolouringAllowed = recolouringAllowed;
        this.colourReplacements = new ArrayList<String>(colourReplacements);
        this.defaultColours = new ArrayList<Colour>();
        if (defaultColours == null) {
            this.defaultColours.add(DEFAULT_COLOUR_VALUE);
        } else {
            this.defaultColours.addAll(defaultColours);
        }
        this.extraColours = new ArrayList<Colour>();
        if (extraColours != null) {
            this.extraColours.addAll(extraColours);
        }
        ArrayList<Colour> colourSet = new ArrayList<Colour>();
        this.allColours = new ArrayList<Colour>(ColourListPresets.DEBUG_ALL);
        if (defaultColours != null) {
            colourSet.addAll(defaultColours);
        }
        if (extraColours != null) {
            colourSet.addAll(extraColours);
        }
        this.allColours.removeIf(c -> !colourSet.contains(c));
        for (Colour c2 : colourSet) {
            if (this.allColours.contains(c2)) continue;
            this.allColours.add(c2);
        }
        if (this.allColours.stream().filter(c -> c == PresetColour.CLOTHING_GREEN_LIME).count() > 1L) {
            this.allColours.remove(PresetColour.CLOTHING_GREEN_LIME);
        }
    }

    public boolean isRecolouringAllowed() {
        return this.recolouringAllowed;
    }

    public List<String> getColourReplacements() {
        return this.colourReplacements;
    }

    public List<Colour> getDefaultColours() {
        return this.defaultColours;
    }

    public Colour getFirstOfDefaultColours() {
        if (this.getDefaultColours() == null || this.getDefaultColours().isEmpty()) {
            return DEFAULT_COLOUR_VALUE;
        }
        return this.getDefaultColours().get(0);
    }

    public Colour getRandomOfDefaultColours() {
        if (this.getDefaultColours() == null || this.getDefaultColours().isEmpty()) {
            return DEFAULT_COLOUR_VALUE;
        }
        return Util.randomItemFrom(this.getDefaultColours());
    }

    public List<Colour> getExtraColours() {
        return this.extraColours;
    }

    public Colour getFirstOfExtraColours() {
        if (this.getExtraColours() == null || this.getExtraColours().isEmpty()) {
            return DEFAULT_COLOUR_VALUE;
        }
        return this.getExtraColours().get(0);
    }

    public Colour getRandomOfExtraColours() {
        if (this.getExtraColours() == null || this.getExtraColours().isEmpty()) {
            return DEFAULT_COLOUR_VALUE;
        }
        return Util.randomItemFrom(this.getExtraColours());
    }

    public List<Colour> getAllColours() {
        return this.allColours;
    }

    public Colour getFirstOfAllColours() {
        if (this.getAllColours() == null || this.getAllColours().isEmpty()) {
            return DEFAULT_COLOUR_VALUE;
        }
        return this.getAllColours().get(0);
    }

    public Colour getRandomOfAllColours() {
        if (this.getAllColours() == null || this.getAllColours().isEmpty()) {
            return DEFAULT_COLOUR_VALUE;
        }
        return Util.randomItemFrom(this.getAllColours());
    }
}

