/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory.clothing;

import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.clothing.ClothingAccess;
import com.lilithsthrone.game.inventory.clothing.DisplacementType;
import com.lilithsthrone.game.inventory.clothing.PresetConcealmentLists;
import com.lilithsthrone.utils.XMLSaving;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BlockedParts
implements XMLSaving {
    public DisplacementType displacementType;
    public List<ClothingAccess> clothingAccessRequired;
    public List<CoverableArea> blockedBodyParts;
    public List<ClothingAccess> clothingAccessBlocked;
    public List<InventorySlot> concealedSlots;

    public BlockedParts(DisplacementType displacementType, List<ClothingAccess> clothingAccessRequired, List<CoverableArea> blockedBodyParts, List<ClothingAccess> clothingAccessBlocked, List<InventorySlot> concealedSlots) {
        this.displacementType = displacementType;
        this.clothingAccessRequired = clothingAccessRequired != null ? new ArrayList<ClothingAccess>(clothingAccessRequired) : new ArrayList<ClothingAccess>();
        this.blockedBodyParts = blockedBodyParts != null ? new ArrayList<CoverableArea>(blockedBodyParts) : new ArrayList<CoverableArea>();
        this.clothingAccessBlocked = clothingAccessBlocked != null ? new ArrayList<ClothingAccess>(clothingAccessBlocked) : new ArrayList<ClothingAccess>();
        this.concealedSlots = concealedSlots != null ? new ArrayList<InventorySlot>(concealedSlots) : new ArrayList<InventorySlot>();
    }

    public BlockedParts(BlockedParts blockedParts) {
        this(blockedParts.displacementType, blockedParts.clothingAccessRequired, blockedParts.blockedBodyParts, blockedParts.clothingAccessBlocked, blockedParts.concealedSlots);
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element blockedParts = doc.createElement("blockedParts");
        parentElement.appendChild(blockedParts);
        Element displacementTypeElement = doc.createElement("displacementType");
        blockedParts.appendChild(displacementTypeElement);
        displacementTypeElement.setTextContent(this.displacementType.toString());
        Element clothingAccessRequiredElement = doc.createElement("clothingAccessRequired");
        blockedParts.appendChild(clothingAccessRequiredElement);
        for (ClothingAccess clothingAccess : this.clothingAccessRequired) {
            Element element = doc.createElement("clothingAccess");
            clothingAccessRequiredElement.appendChild(element);
            element.setTextContent(clothingAccess.toString());
        }
        Element blockedBodyPartsElement = doc.createElement("blockedBodyParts");
        blockedParts.appendChild(blockedBodyPartsElement);
        for (CoverableArea coverableArea : this.blockedBodyParts) {
            Element coverableAreaElement = doc.createElement("bodyPart");
            blockedBodyPartsElement.appendChild(coverableAreaElement);
            coverableAreaElement.setTextContent(coverableArea.toString());
        }
        Element element = doc.createElement("clothingAccessBlocked");
        blockedParts.appendChild(element);
        for (ClothingAccess clothingAccess : this.clothingAccessBlocked) {
            Element clothingAccessElement = doc.createElement("clothingAccess");
            element.appendChild(clothingAccessElement);
            clothingAccessElement.setTextContent(clothingAccess.toString());
        }
        Element element2 = doc.createElement("concealedSlots");
        blockedParts.appendChild(element2);
        for (InventorySlot inventorySlot : this.concealedSlots) {
            Element inventorySlotElement = doc.createElement("slot");
            element2.appendChild(inventorySlotElement);
            inventorySlotElement.setTextContent(inventorySlot.toString());
        }
        return blockedParts;
    }

    public static BlockedParts loadFromXML(Element parentElement, Document doc, String contextForErrors) {
        DisplacementType displacementType = DisplacementType.valueOf(parentElement.getElementsByTagName("displacementType").item(0).getTextContent());
        String errorCode = "Unknown Clothing";
        Element clothingElement = (Element)doc.getElementsByTagName("clothing").item(0);
        try {
            errorCode = clothingElement.getElementsByTagName("coreAtributes").getLength() > 0 ? ((Element)clothingElement.getElementsByTagName("coreAtributes").item(0)).getElementsByTagName("name").item(0).getTextContent() : ((Element)clothingElement.getElementsByTagName("coreAttributes").item(0)).getElementsByTagName("name").item(0).getTextContent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<ClothingAccess> loadedClothingAccessRequired = new ArrayList<ClothingAccess>();
        Element clothingAccessRequiredElement = (Element)parentElement.getElementsByTagName("clothingAccessRequired").item(0);
        try {
            for (int i = 0; i < clothingAccessRequiredElement.getElementsByTagName("clothingAccess").getLength(); ++i) {
                Element e = (Element)clothingAccessRequiredElement.getElementsByTagName("clothingAccess").item(i);
                loadedClothingAccessRequired.add(ClothingAccess.valueOf(e.getTextContent()));
            }
        }
        catch (Exception ex) {
            System.err.println("BlockedParts loading failed for " + errorCode + ". Code 1 (clothingAccessRequired -> clothingAccess); Context: " + contextForErrors);
            System.err.println(ex);
            BlockedParts.printHelpfulErrorForEnumValueMismatches(ex, BlockedParts.getPossibleEnumValues());
        }
        ArrayList<CoverableArea> loadedBlockedBodyParts = new ArrayList<CoverableArea>();
        Element blockedBodyPartsElement = (Element)parentElement.getElementsByTagName("blockedBodyParts").item(0);
        try {
            for (int i = 0; i < blockedBodyPartsElement.getElementsByTagName("bodyPart").getLength(); ++i) {
                Element e = (Element)blockedBodyPartsElement.getElementsByTagName("bodyPart").item(i);
                loadedBlockedBodyParts.add(CoverableArea.valueOf(e.getTextContent()));
            }
        }
        catch (Exception ex) {
            System.err.println("BlockedParts loading failed for " + errorCode + ". Code 2 (blockedBodyParts -> bodyPart); Context: " + contextForErrors);
            System.err.println(ex);
            BlockedParts.printHelpfulErrorForEnumValueMismatches(ex, BlockedParts.getPossibleEnumValues());
        }
        ArrayList<ClothingAccess> loadedClothingAccessBlocked = new ArrayList<ClothingAccess>();
        Element clothingAccessBlockedElement = (Element)parentElement.getElementsByTagName("clothingAccessBlocked").item(0);
        try {
            for (int i = 0; i < clothingAccessBlockedElement.getElementsByTagName("clothingAccess").getLength(); ++i) {
                Element e = (Element)clothingAccessBlockedElement.getElementsByTagName("clothingAccess").item(i);
                loadedClothingAccessBlocked.add(ClothingAccess.valueOf(e.getTextContent()));
            }
        }
        catch (Exception ex) {
            System.err.println("BlockedParts loading failed for " + errorCode + ". Code 3 (clothingAccessBlocked -> clothingAccess); Context: " + contextForErrors);
            System.err.println(ex);
            BlockedParts.printHelpfulErrorForEnumValueMismatches(ex, BlockedParts.getPossibleEnumValues());
        }
        ArrayList<InventorySlot> loadedConcealedSlots = new ArrayList();
        Element concealedSlotsElement = (Element)parentElement.getElementsByTagName("concealedSlots").item(0);
        if (!concealedSlotsElement.getAttribute("values").isEmpty()) {
            try {
                loadedConcealedSlots = PresetConcealmentLists.valueOf(concealedSlotsElement.getAttribute("values")).getPresetInventorySlotList();
            }
            catch (Exception ex) {
                System.err.println("BlockedParts loading failed for " + errorCode + ". Code 4a (concealedSlots.values); Context: " + contextForErrors);
                System.err.println(ex);
                BlockedParts.printHelpfulErrorForEnumValueMismatches(ex, BlockedParts.getPossibleEnumValues());
            }
        } else {
            try {
                for (int i = 0; i < concealedSlotsElement.getElementsByTagName("slot").getLength(); ++i) {
                    Element e = (Element)concealedSlotsElement.getElementsByTagName("slot").item(i);
                    loadedConcealedSlots.add(InventorySlot.valueOf(e.getTextContent()));
                }
            }
            catch (Exception ex) {
                System.err.println("BlockedParts loading failed for " + errorCode + ". Code 4b (concealedSlots -> slot); Context: " + contextForErrors);
                System.err.println(ex);
                BlockedParts.printHelpfulErrorForEnumValueMismatches(ex, BlockedParts.getPossibleEnumValues());
            }
        }
        return new BlockedParts(displacementType, loadedClothingAccessRequired, loadedBlockedBodyParts, loadedClothingAccessBlocked, loadedConcealedSlots);
    }

    private static Map<Class, Object[]> getPossibleEnumValues() {
        HashMap<Class, Object[]> possibleEnumValues = new HashMap<Class, Object[]>();
        possibleEnumValues.put(ClothingAccess.class, (Object[])ClothingAccess.values());
        possibleEnumValues.put(InventorySlot.class, (Object[])InventorySlot.values());
        possibleEnumValues.put(CoverableArea.class, (Object[])CoverableArea.values());
        possibleEnumValues.put(PresetConcealmentLists.class, (Object[])PresetConcealmentLists.values());
        return possibleEnumValues;
    }

    private static void printHelpfulErrorForEnumValueMismatches(Exception ex, Map<Class, Object[]> possibleEnumValues) {
        String exMessage = ex.getMessage();
        if (exMessage.startsWith("No enum constant")) {
            for (Map.Entry<Class, Object[]> possibleMatch : possibleEnumValues.entrySet()) {
                if (!exMessage.contains(possibleMatch.getKey().getCanonicalName())) continue;
                StringJoiner valueLister = new StringJoiner(",");
                Arrays.asList(possibleMatch.getValue()).forEach(enumValue -> valueLister.add(enumValue.toString()));
                System.err.println("Possible values for " + possibleMatch.getKey().getSimpleName() + " are " + valueLister.toString());
            }
        }
    }
}

