/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory.clothing;

import com.lilithsthrone.controller.xmlParsing.XMLLoadException;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.body.valueEnums.Femininity;
import com.lilithsthrone.game.character.persona.Occupation;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractSetBonus;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.Rarity;
import com.lilithsthrone.game.inventory.SetBonus;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.AbstractClothingType;
import com.lilithsthrone.game.inventory.clothing.BlockedParts;
import com.lilithsthrone.game.inventory.clothing.ClothingAccess;
import com.lilithsthrone.game.inventory.clothing.DisplacementType;
import com.lilithsthrone.game.inventory.clothing.PresetConcealmentLists;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.game.inventory.enchanting.TFPotency;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.ColourListPresets;
import com.lilithsthrone.utils.colours.PresetColour;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ClothingType {
    public static AbstractClothingType WRIST_WOMENS_WATCH;
    public static AbstractClothingType WRIST_MENS_WATCH;
    public static AbstractClothingType WRIST_SUIT_CUFFS;
    public static AbstractClothingType WRIST_WRISTBANDS;
    public static AbstractClothingType HIPS_CONDOMS;
    public static AbstractClothingType HIPS_SUSPENDER_BELT;
    public static AbstractClothingType ENFORCER_SHIRT;
    public static AbstractClothingType ENFORCER_SHORTS;
    public static AbstractClothingType ENFORCER_MINI_SKIRT;
    public static AbstractClothingType MILK_MAID_TORSO_DRESS;
    public static AbstractClothingType MILK_MAID_HEADBAND;
    public static AbstractClothingType MILK_MAID_KERCHIEF;
    public static AbstractClothingType JOLNIR_HAT;
    public static AbstractClothingType JOLNIR_COAT;
    public static AbstractClothingType JOLNIR_DRESS;
    public static AbstractClothingType JOLNIR_BOOTS;
    public static AbstractClothingType JOLNIR_BOOTS_FEMININE;
    public static AbstractClothingType FINGER_LYSSIETHS_RING;
    private static List<AbstractClothingType> allClothing;
    private static List<AbstractClothingType> moddedClothingList;
    private static Map<AbstractSetBonus, List<AbstractClothingType>> setClothing;
    private static List<InventorySlot> coreClothingSlots;
    private static List<InventorySlot> lingerieSlots;
    private static Map<InventorySlot, List<AbstractClothingType>> commonClothingMap;
    private static Map<InventorySlot, List<AbstractClothingType>> commonClothingMapFemale;
    private static Map<InventorySlot, List<AbstractClothingType>> commonClothingMapMale;
    private static Map<InventorySlot, List<AbstractClothingType>> commonClothingMapAndrogynous;
    private static Map<InventorySlot, List<AbstractClothingType>> commonClothingMapFemaleIncludingAndrogynous;
    private static Map<InventorySlot, List<AbstractClothingType>> commonClothingMapMaleIncludingAndrogynous;
    private static Map<Occupation, ArrayList<AbstractClothingType>> suitableFeminineClothing;
    private static Map<AbstractClothingType, String> clothingToIdMap;
    private static Map<String, AbstractClothingType> idToClothingMap;
    private static Map<String, String> oldIdConversionMap;

    public static AbstractClothingType getClothingTypeFromId(String id) {
        return ClothingType.getClothingTypeFromId(id, null);
    }

    public static AbstractClothingType getClothingTypeFromId(String id, String slotHint) {
        if (oldIdConversionMap.containsKey(id)) {
            id = oldIdConversionMap.get(id);
        }
        Map<String, AbstractClothingType> choiceMap = idToClothingMap;
        if (slotHint != null && !slotHint.isEmpty()) {
            try {
                InventorySlot slot = InventorySlot.valueOf(slotHint);
                choiceMap = idToClothingMap.entrySet().parallelStream().filter(e -> ((AbstractClothingType)e.getValue()).getEquipSlots().contains((Object)slot)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            catch (Exception ex) {
                String validSlots = InventorySlot.getClothingSlots().stream().map(Enum::toString).collect(Collectors.joining(", "));
                System.err.println("Warning: getClothingTypeFromId() invalid slot hint: " + slotHint + ". Valid slots are: " + validSlots);
            }
        }
        id = Util.getClosestStringMatch(id, choiceMap.keySet());
        return idToClothingMap.get(id);
    }

    public static String getIdFromClothingType(AbstractClothingType clothingType) {
        return clothingToIdMap.get(clothingType);
    }

    public static Map<Occupation, ArrayList<AbstractClothingType>> getSuitableFeminineClothing() {
        return suitableFeminineClothing;
    }

    public static List<AbstractClothingType> getAllClothing() {
        return allClothing;
    }

    public static List<AbstractClothingType> getAllClothingInSet(AbstractSetBonus setBonus) {
        return setClothing.get(setBonus);
    }

    public static List<AbstractClothingType> getModdedClothingList() {
        return moddedClothingList;
    }

    public static List<InventorySlot> getCoreClothingSlots() {
        return coreClothingSlots;
    }

    public static List<InventorySlot> getLingerieSlots() {
        return lingerieSlots;
    }

    public static Map<InventorySlot, List<AbstractClothingType>> getCommonClothingMap() {
        return commonClothingMap;
    }

    public static Map<InventorySlot, List<AbstractClothingType>> getCommonClothingMapFemale() {
        return commonClothingMapFemale;
    }

    public static Map<InventorySlot, List<AbstractClothingType>> getCommonClothingMapMale() {
        return commonClothingMapMale;
    }

    public static Map<InventorySlot, List<AbstractClothingType>> getCommonClothingMapAndrogynous() {
        return commonClothingMapAndrogynous;
    }

    public static Map<InventorySlot, List<AbstractClothingType>> getCommonClothingMapFemaleIncludingAndrogynous() {
        return commonClothingMapFemaleIncludingAndrogynous;
    }

    public static Map<InventorySlot, List<AbstractClothingType>> getCommonClothingMapMaleIncludingAndrogynous() {
        return commonClothingMapMaleIncludingAndrogynous;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var5_18;
        AbstractClothingType ct;
        WRIST_WOMENS_WATCH = new AbstractClothingType(1000, "\u4e00\u6761", false, "\u5973\u58eb\u624b\u8868", "\u5973\u58eb\u624b\u8868", "\u4e00\u5757\u5973\u6027\u5316\u5916\u89c2\u7684\u624b\u8868\uff0c\u5c31\u50cf\u5176\u4ed6\u540c\u7c7b\u4ea7\u54c1\u4e00\u6837\uff0c\u5176\u4e3b\u8981\u529f\u80fd\u662f\u8bb0\u5f55\u65f6\u95f4\u3002", 0.0f, Femininity.FEMININE, InventorySlot.WRIST, Rarity.COMMON, null, "clothing/wrist_womens_watch", null, Util.newArrayListOfValues(new BlockedParts(DisplacementType.REMOVE_OR_EQUIP, Util.newArrayListOfValues(ClothingAccess.WRISTS), null, Util.newArrayListOfValues(ClothingAccess.WRISTS), null)), null, ColourListPresets.ALL, null, ColourListPresets.JUST_STEEL, ColourListPresets.ALL_WITH_METALS, ColourListPresets.JUST_STEEL, ColourListPresets.ALL_WITH_METALS, Util.newArrayListOfValues(ItemTag.SOLD_BY_NYAN)){

            @Override
            public String equipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                if (clothingOwner.isPlayer() && clothingRemover.isPlayer()) {
                    return "\u4f60\u628a\u624b\u8868\u6234\u5728\u624b\u8155\u4e0a\uff0c\u7cfb\u7d27\u8868\u5e26\u3002";
                }
                return UtilText.parse(clothingOwner, "[npc.Name]\u628a" + clothing.getName(true) + "\u6234\u5728[npc.her]\u7684\u624b\u8155\u4e0a\uff0c\u7cfb\u7d27\u8868\u5e26\u3002", new ParserTag[0]);
            }

            @Override
            public String unequipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                if (clothingOwner.isPlayer() && clothingRemover.isPlayer()) {
                    return "\u4f60\u89e3\u5f00\u8868\u5e26\uff0c\u6458\u4e0b\u624b\u8868\u3002";
                }
                if (!clothingOwner.isPlayer() && !clothingRemover.isPlayer()) {
                    return UtilText.parse(clothingOwner, "[npc.Name]\u89e3\u5f00[npc.her]\u7684\u8868\u5e26\uff0c\u6458\u4e0b\u624b\u8868\u3002", new ParserTag[0]);
                }
                if (clothingOwner.isPlayer()) {
                    return "[npc.Name]\u89e3\u5f00\u4f60\u7684\u8868\u5e26\uff0c\u6458\u4e0b\u624b\u8868\u3002";
                }
                return UtilText.parse(clothingOwner, "\u4f60\u89e3\u5f00[npc.namePos]\u7684\u8868\u5e26\uff0c\u6458\u4e0b\u624b\u8868\u3002", new ParserTag[0]);
            }
        };
        WRIST_MENS_WATCH = new AbstractClothingType(1200, "\u4e00\u4ef6", false, "\u7537\u58eb\u624b\u8868", "\u5973\u58eb\u624b\u8868", "\u4e00\u5757\u7537\u6027\u5316\u5916\u89c2\u7684\u624b\u8868\uff0c\u5c31\u50cf\u5176\u4ed6\u540c\u7c7b\u4ea7\u54c1\u4e00\u6837\uff0c\u5176\u4e3b\u8981\u529f\u80fd\u662f\u8bb0\u5f55\u65f6\u95f4\u3002", 0.0f, Femininity.MASCULINE, InventorySlot.WRIST, Rarity.COMMON, null, "clothing/wrist_mens_watch", null, Util.newArrayListOfValues(new BlockedParts(DisplacementType.REMOVE_OR_EQUIP, Util.newArrayListOfValues(ClothingAccess.WRISTS), null, Util.newArrayListOfValues(ClothingAccess.WRISTS), null)), null, ColourListPresets.ALL_METAL, ColourListPresets.ALL, ColourListPresets.JUST_STEEL, ColourListPresets.ALL_WITH_METALS, ColourListPresets.JUST_STEEL, ColourListPresets.ALL_WITH_METALS, Util.newArrayListOfValues(ItemTag.SOLD_BY_NYAN)){

            @Override
            public String equipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                if (clothingOwner.isPlayer() && clothingRemover.isPlayer()) {
                    return "\u4f60\u628a\u624b\u8868\u6234\u5728\u624b\u8155\u4e0a\uff0c\u7cfb\u7d27\u8868\u5e26\u3002";
                }
                return UtilText.parse(clothingOwner, "[npc.Name]\u628a" + clothing.getName(true) + "\u6234\u5728[npc.her]\u7684\u624b\u8155\u4e0a\uff0c\u7cfb\u7d27\u8868\u5e26\u3002", new ParserTag[0]);
            }

            @Override
            public String unequipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                if (clothingOwner.isPlayer() && clothingRemover.isPlayer()) {
                    return "\u4f60\u89e3\u5f00\u8868\u5e26\uff0c\u6458\u4e0b\u624b\u8868\u3002";
                }
                if (!clothingOwner.isPlayer() && !clothingRemover.isPlayer()) {
                    return UtilText.parse(clothingOwner, "[npc.Name]\u89e3\u5f00[npc.her]\u7684\u8868\u5e26\uff0c\u6458\u4e0b\u624b\u8868\u3002", new ParserTag[0]);
                }
                if (clothingOwner.isPlayer()) {
                    return "[npc.Name]\u89e3\u5f00\u4f60\u7684\u8868\u5e26\uff0c\u6458\u4e0b\u624b\u8868\u3002";
                }
                return UtilText.parse(clothingOwner, "\u4f60\u89e3\u5f00[npc.namePos]\u7684\u8868\u5e26\uff0c\u6458\u4e0b\u624b\u8868\u3002", new ParserTag[0]);
            }
        };
        WRIST_SUIT_CUFFS = new AbstractClothingType(100, "\u4e00\u5bf9", true, "\u897f\u88c5\u8896\u53e3", "\u897f\u88c5\u8896\u53e3", "\u4e00\u5bf9\u897f\u88c5\u8896\u53e3\uff0c\u7cfb\u5728\u624b\u8155\u4e0a\u3002", 0.0f, null, InventorySlot.WRIST, Rarity.COMMON, null, "clothing/wrist_suit_cuffs", null, Util.newArrayListOfValues(new BlockedParts(DisplacementType.REMOVE_OR_EQUIP, Util.newArrayListOfValues(ClothingAccess.WRISTS), null, Util.newArrayListOfValues(ClothingAccess.WRISTS), null)), null, ColourListPresets.JUST_WHITE, ColourListPresets.ALL, ColourListPresets.JUST_BLACK, ColourListPresets.ALL, null, null, Util.newArrayListOfValues(ItemTag.SOLD_BY_NYAN)){

            @Override
            public String equipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 3.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u628a\u897f\u88c5\u8896\u53e3\u7cfb\u5728\u624b\u8155\u4e0a\u3002", "\u4f60\u628a\u897f\u88c5\u8896\u53e3\u7cfb\u5728[npc.namePos]\u7684\u624b\u8155\u4e0a\u3002", null, "[npc.Name]\u628a\u897f\u88c5\u8896\u53e3\u7cfb\u5728[npc.her]\u7684\u624b\u8155\u4e0a\u3002", "[npc.Name]\u628a\u897f\u88c5\u8896\u53e3\u7cfb\u5728\u4f60\u7684\u624b\u8155\u4e0a\u3002", null, null, null);
            }

            @Override
            public String unequipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 3.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u89e3\u5f00\u624b\u8155\u4e0a\u7684\u897f\u88c5\u8896\u53e3\uff0c\u53d6\u4e0b\u5b83\u4eec\u3002", "\u4f60\u89e3\u5f00[npc.namePos]\u624b\u8155\u4e0a\u7684\u897f\u88c5\u8896\u53e3\uff0c\u53d6\u4e0b\u5b83\u4eec\u3002", null, "[npc.Name]\u89e3\u5f00[npc.her]\u624b\u8155\u4e0a\u7684\u897f\u88c5\u8896\u53e3\uff0c\u53d6\u4e0b\u5b83\u4eec\u3002", "[npc.Name]\u89e3\u5f00\u4f60\u624b\u8155\u4e0a\u7684\u897f\u88c5\u8896\u53e3\uff0c\u53d6\u4e0b\u5b83\u4eec\u3002", null, null, null);
            }
        };
        WRIST_WRISTBANDS = new AbstractClothingType(100, "\u4e00\u5bf9", true, "\u8155\u5957", "\u8155\u5957", "\u4e00\u5bf9\u8155\u5957\uff0c\u6234\u5728\u624b\u8155\u4e0a\uff0c\u5438\u6c57\u6027\u5f88\u5f3a\u3002", 0.0f, null, InventorySlot.WRIST, Rarity.COMMON, null, "clothing/wrist_sweatbands", null, Util.newArrayListOfValues(new BlockedParts(DisplacementType.REMOVE_OR_EQUIP, Util.newArrayListOfValues(ClothingAccess.WRISTS), null, Util.newArrayListOfValues(ClothingAccess.WRISTS), null)), null, ColourListPresets.ALL, null, null, null, null, null, Util.newArrayListOfValues(ItemTag.SOLD_BY_NYAN)){

            @Override
            public String equipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 4.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u628a\u8155\u5957\u6234\u5728\u624b\u8155\u4e0a\u3002", "\u4f60\u628a\u8155\u5957\u6234\u5728[npc.namePos]\u624b\u8155\u4e0a\u3002", null, "[npc.Name]\u628a\u8155\u5957\u6234\u5728[npc.her]\u624b\u8155\u4e0a\u3002", "[npc.Name]\u628a\u8155\u5957\u6234\u5728\u4f60\u624b\u8155\u4e0a\u3002", null, null, null);
            }

            @Override
            public String unequipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 4.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u892a\u4e0b\u624b\u8155\u4e0a\u7684\u8155\u5957\u3002", "\u4f60\u892a\u4e0b[npc.namePos]\u624b\u8155\u4e0a\u7684\u8155\u5957\u3002", null, "[npc.Name]\u892a\u4e0b[npc.her]\u624b\u8155\u4e0a\u7684\u8155\u5957\u3002", "[npc.Name]\u892a\u4e0b\u4f60\u624b\u8155\u4e0a\u7684\u8155\u5957\u3002", null, null, null);
            }
        };
        HIPS_CONDOMS = new AbstractClothingType(20, "\u4e00\u4ef6", false, "\u907f\u5b55\u5957\u8170\u5e26", "\u907f\u5b55\u5957\u8170\u5e26", "\u4e00\u6761\u7d27\u8d34\u7a7f\u6234\u8005\u81c0\u90e8\u7684\u575a\u97e7\u5c3c\u9f99\u5e26\u3002\u5b83\u6ca1\u4ec0\u4e48\u5b9e\u9645\u7528\u9014\uff0c\u4f46\u4f60\u53ef\u4ee5\u628a\u7528\u8fc7\u7684\u907f\u5b55\u5957\u7cfb\u5728\u4e0a\u9762\u2026\u2026", 0.0f, null, InventorySlot.HIPS, Rarity.COMMON, null, "clothing/belt_used_condoms", null, Util.newArrayListOfValues(new BlockedParts(DisplacementType.REMOVE_OR_EQUIP, null, null, null, null)), null, ColourListPresets.ALL, null, null, null, null, null, Util.newArrayListOfValues(ItemTag.SOLD_BY_NYAN)){

            @Override
            public String equipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                if (clothingOwner.isPlayer() && clothingRemover.isPlayer()) {
                    return "\u4f60\u7a7f\u8fdb\u8170\u5e26\uff0c\u7136\u540e\u628a\u5b83\u62c9\u5230\u8170\u90e8\u3002";
                }
                return UtilText.parse(clothingOwner, "[npc.Name]\u7a7f\u8fdb\u8170\u5e26\uff0c\u7136\u540e\u628a\u5b83\u62c9\u5230\u8170\u90e8\u3002", new ParserTag[0]);
            }

            @Override
            public String unequipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                if (clothingOwner.isPlayer() && clothingRemover.isPlayer()) {
                    return "\u4f60\u89e3\u4e0b\u8170\u5e26\uff0c\u7136\u540e\u4e00[pc.feet]\u8e22\u5f00\u3002";
                }
                if (!clothingOwner.isPlayer() && !clothingRemover.isPlayer()) {
                    return UtilText.parse(clothingOwner, "[npc.Name]\u89e3\u4e0b\u8170\u5e26\uff0c\u7136\u540e\u4e00[npc.feet]\u8e22\u5f00\u3002", new ParserTag[0]);
                }
                if (clothingOwner.isPlayer()) {
                    return UtilText.parse(clothingRemover, "[npc.Name]\u89e3\u4e0b\u4f60\u7684\u8170\u5e26\uff0c\u628a\u5b83\u6ed1\u5230\u4f60[pc.feet]\u8fb9\u3002", new ParserTag[0]);
                }
                return UtilText.parse(clothingOwner, "\u4f60\u89e3\u5f00[npc.namePos]\u7684\u8170\u5e26\uff0c\u628a\u5b83\u6ed1\u5230[npc.her][npc.feet]\u8fb9\u3002", new ParserTag[0]);
            }
        };
        HIPS_SUSPENDER_BELT = new AbstractClothingType(150, "\u4e00\u6761", false, "\u540a\u889c\u8170\u5e26", "\u540a\u889c\u8170\u5e26", "\u7531\u67d4\u8f6f\u7684\u5f39\u6027\u5c3c\u9f99\u5236\u6210\u7684\u73af\u5f62\u5e26\u5b50\uff0c\u4e0a\u9762\u6709\u516d\u6761\u5e26\u5b50\uff0c\u6bcf\u6761\u5e26\u5b50\u90fd\u53ef\u4ee5\u94a9\u4f4f\u4e00\u53cc\u957f\u889c\uff0c\u4f7f\u5176\u5411\u4e0a\u7fd8\u8d77\u3002", 0.0f, Femininity.FEMININE, InventorySlot.HIPS, Rarity.COMMON, null, "clothing/hips_suspender_belt", null, Util.newArrayListOfValues(new BlockedParts(DisplacementType.REMOVE_OR_EQUIP, null, null, null, null)), null, ColourListPresets.LINGERIE, ColourListPresets.ALL, ColourListPresets.JUST_STEEL, ColourListPresets.ALL_METAL, null, null, Util.newArrayListOfValues(ItemTag.SOLD_BY_NYAN)){

            @Override
            public String equipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 6.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u7a7f\u8fdb\u540a\u889c\u8170\u5e26\uff0c\u7136\u540e\u628a\u5b83\u62c9\u5230\u8170\u90e8\u3002", "\u4f60\u8ba9[npc.Name]\u7a7f\u8fdb\u540a\u889c\u8170\u5e26\uff0c\u7136\u540e\u628a\u5b83\u62c9\u5230[npc.her]\u7684\u8170\u90e8\u3002", null, "[npc.Name]\u7a7f\u8fdb\u540a\u889c\u8170\u5e26\uff0c\u7136\u540e\u628a\u5b83\u62c9\u5230[npc.her]\u7684\u8170\u90e8\u3002", "[npc.Name]\u8ba9\u4f60\u7a7f\u8fdb\u540a\u889c\u8170\u5e26\uff0c\u7136\u540e\u628a\u5b83\u62c9\u5230\u4f60\u7684\u8170\u90e8\u3002", null, null, null);
            }

            @Override
            public String unequipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 6.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u89e3\u4e0b\u540a\u889c\u8170\u5e26\uff0c\u8131\u4e0b\u5b83\u3002", "\u4f60\u89e3\u4e0b[npc.namePos]\u7684\u540a\u889c\u8170\u5e26\uff0c\u8131\u4e0b\u5b83\u3002", null, "[npc.Name]\u89e3\u4e0b[npc.her]\u7684\u540a\u889c\u8170\u5e26\uff0c\u8131\u4e0b\u5b83\u3002", "[npc.Name]\u89e3\u4e0b\u4f60\u7684\u540a\u889c\u8170\u5e26\uff0c\u8131\u4e0b\u5b83\u3002", null, null, null);
            }
        };
        ENFORCER_SHIRT = new AbstractClothingType(1500, "\u4e00\u4ef6", false, "\u5316\u88c5\u6267\u6cd5\u8005\u5236\u670d", "\u5316\u88c5\u6267\u6cd5\u8005\u5236\u670d", "\u4e00\u4ef6\u5316\u88c5\u7528\u7684\u6267\u6cd5\u8005\u5236\u670d\uff0c\u914d\u6709\u4eff\u5236\u7684\u9632\u523a\u80cc\u5fc3\u3002", 1.0f, null, InventorySlot.TORSO_UNDER, Rarity.EPIC, SetBonus.getSetBonusFromId("innoxia_slutty_enforcer"), "clothing/enforcerShirt", Util.newArrayListOfValues(new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.DAMAGE_LUST, TFPotency.MAJOR_BOOST, 0), new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.DAMAGE_LUST, TFPotency.MAJOR_BOOST, 0)), Util.newArrayListOfValues(new BlockedParts(DisplacementType.REMOVE_OR_EQUIP, Util.newArrayListOfValues(ClothingAccess.ARMS_UP_TO_SHOULDER), Util.newArrayListOfValues(CoverableArea.BACK, CoverableArea.ARMPITS), null, null), new BlockedParts(DisplacementType.UNBUTTONS, null, Util.newArrayListOfValues(CoverableArea.BREASTS, CoverableArea.NIPPLES, CoverableArea.STOMACH), Util.newArrayListOfValues(ClothingAccess.CHEST, ClothingAccess.WAIST), PresetConcealmentLists.CONCEALED_PARTIAL_TORSO.getPresetInventorySlotList())), null, Util.newArrayListOfValues(PresetColour.CLOTHING_BLUE, PresetColour.CLOTHING_BLACK, PresetColour.CLOTHING_PINK), ColourListPresets.ALL, ColourListPresets.JUST_BLACK, ColourListPresets.ALL, ColourListPresets.JUST_STEEL, ColourListPresets.ALL_METAL, Util.newArrayListOfValues(ItemTag.SOLD_BY_NYAN, ItemTag.FITS_ARM_WINGS)){

            @Override
            public String equipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 7.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u7a7f\u4e0a\u5236\u670d\uff0c\u7cfb\u597d\u6263\u5b50\u3002", "\u4f60\u7ed9[npc.Name]\u7a7f\u4e0a\u5236\u670d\uff0c\u7cfb\u597d\u6263\u5b50\u3002", null, "[npc.Name]\u7a7f\u4e0a\u5236\u670d\uff0c\u7cfb\u597d\u6263\u5b50\u3002", "[npc.Name]\u7ed9\u4f60\u7a7f\u4e0a\u5236\u670d\uff0c\u7cfb\u597d\u6263\u5b50\u3002", null, null, null);
            }

            @Override
            public String unequipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 7.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u89e3\u5f00\u6263\u5b50\uff0c\u8131\u4e0b\u5236\u670d\u3002", "\u4f60\u89e3\u5f00\u6263\u5b50\uff0c\u8131\u4e0b[npc.namePos]\u7684\u5236\u670d\u3002", null, "[npc.Name]\u89e3\u5f00\u6263\u5b50\uff0c\u8131\u4e0b[npc.her]\u7684\u5236\u670d\u3002", "[npc.Name]\u89e3\u5f00\u6263\u5b50\uff0c\u8131\u4e0b\u4f60\u7684\u5236\u670d\u3002", null, null, null);
            }
        };
        ENFORCER_SHORTS = new AbstractClothingType(600, "\u4e00\u6761", true, "\u5316\u88c5\u6267\u6cd5\u8005\u77ed\u88e4", "\u5316\u88c5\u6267\u6cd5\u8005\u77ed\u88e4", "\u4e00\u6761\u5316\u88c5\u6267\u6cd5\u8005\u77ed\u88e4\uff0c\u914d\u5907\u7740\u591a\u529f\u80fd\u8170\u5e26\u3002", 0.0f, null, InventorySlot.LEG, Rarity.EPIC, SetBonus.getSetBonusFromId("innoxia_slutty_enforcer"), "clothing/enforcerShorts", Util.newArrayListOfValues(new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.DAMAGE_LUST, TFPotency.MAJOR_BOOST, 0)), Util.newArrayListOfValues(new BlockedParts(DisplacementType.REMOVE_OR_EQUIP, Util.newArrayListOfValues(ClothingAccess.LEGS_UP_TO_GROIN), null, Util.newArrayListOfValues(ClothingAccess.LEGS_UP_TO_GROIN), null), new BlockedParts(DisplacementType.PULLS_DOWN, null, Util.newArrayListOfValues(CoverableArea.ANUS, CoverableArea.PENIS, CoverableArea.VAGINA), Util.newArrayListOfValues(ClothingAccess.GROIN, ClothingAccess.ANUS), PresetConcealmentLists.CONCEALED_GROIN.getPresetInventorySlotList()), new BlockedParts(DisplacementType.UNZIPS, null, Util.newArrayListOfValues(CoverableArea.PENIS), Util.newArrayListOfValues(ClothingAccess.GROIN), PresetConcealmentLists.CONCEALED_UNZIPS_GROIN.getPresetInventorySlotList())), null, Util.newArrayListOfValues(PresetColour.CLOTHING_BLUE, PresetColour.CLOTHING_BLACK, PresetColour.CLOTHING_PINK), ColourListPresets.ALL, ColourListPresets.JUST_BLACK, ColourListPresets.ALL, ColourListPresets.JUST_STEEL, ColourListPresets.ALL_METAL, Util.newArrayListOfValues(ItemTag.SOLD_BY_NYAN)){

            @Override
            public String equipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 8.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u7a7f\u8fdb\u77ed\u88e4\uff0c\u7136\u540e\u628a\u5b83\u63d0\u5230\u8170\u4e0a\u3002", "\u4f60\u628a\u77ed\u88e4\u62c9\u5230[npc.namePos]\u7684[npc.legs]\u6839\uff0c\u7136\u540e\u63d0\u5230\u8170\u4e0a\u3002", null, "[npc.Name]\u7a7f\u8fdb\u77ed\u88e4\uff0c\u7136\u540e\u628a\u5b83\u63d0\u5230\u8170\u4e0a\u3002", "[npc.Name]\u628a\u77ed\u88e4\u62c9\u5230\u4f60\u7684[pc.legs]\u6839\uff0c\u7136\u540e\u63d0\u5230\u8170\u4e0a\u3002", null, null, null);
            }

            @Override
            public String unequipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 8.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u8131\u4e0b\u77ed\u88e4\uff0c\u4e00[pc.feet]\u8e22\u5f00\u3002", "\u4f60\u62c9\u4e0b[npc.namePos]\u7684\u77ed\u88e4\uff0c\u628a\u5b83\u6ed1\u5230[npc.her]\u7684[npc.feet]\u8fb9\u3002", null, "[npc.Name]\u8131\u4e0b[npc.her]\u7684\u77ed\u88e4\uff0c\u7136\u540e\u4e00[npc.feet]\u8e22\u5f00\u3002", "[npc.Name]\u8131\u4e0b\u4f60\u7684\u77ed\u88e4\uff0c\u628a\u5b83\u6ed1\u5230\u4f60[pc.feet]\u8fb9\u3002", null, null, null);
            }
        };
        ENFORCER_MINI_SKIRT = new AbstractClothingType(600, "\u4e00\u4ef6", false, "\u5316\u88c5\u6267\u6cd5\u8005\u8ff7\u4f60\u77ed\u88d9", "\u5316\u88c5\u6267\u6cd5\u8005\u8ff7\u4f60\u77ed\u88d9", "\u4e00\u6761\u5316\u88c5\u6267\u6cd5\u8005\u8ff7\u4f60\u77ed\u88d9\uff0c\u914d\u5907\u7740\u591a\u529f\u80fd\u8170\u5e26\u3002\u5b83\u592a\u77ed\u4e86\u751a\u81f3\u90fd\u6ca1\u5230\u5927\u817f\u4e2d\u90e8\u3002", 0.0f, Femininity.FEMININE, InventorySlot.LEG, Rarity.EPIC, SetBonus.getSetBonusFromId("innoxia_slutty_enforcer"), "clothing/enforcer_miniskirt", Util.newArrayListOfValues(new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.DAMAGE_LUST, TFPotency.MAJOR_BOOST, 0)), Util.newArrayListOfValues(new BlockedParts(DisplacementType.PULLS_UP, null, Util.newArrayListOfValues(CoverableArea.ANUS, CoverableArea.PENIS, CoverableArea.VAGINA), Util.newArrayListOfValues(ClothingAccess.GROIN, ClothingAccess.ANUS), PresetConcealmentLists.CONCEALED_GROIN.getPresetInventorySlotList())), null, Util.newArrayListOfValues(PresetColour.CLOTHING_BLUE, PresetColour.CLOTHING_BLACK, PresetColour.CLOTHING_PINK), ColourListPresets.ALL, ColourListPresets.JUST_BLACK, ColourListPresets.ALL, ColourListPresets.JUST_STEEL, ColourListPresets.ALL_METAL, Util.newArrayListOfValues(ItemTag.SOLD_BY_NYAN)){

            @Override
            public String equipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 9.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u7a7f\u8fdb\u8ff7\u4f60\u77ed\u88d9\uff0c\u7136\u540e\u628a\u5b83\u62c9\u5230\u8170\u90e8\u3002", "\u4f60\u628a\u8ff7\u4f60\u77ed\u88d9\u62c9\u5230[npc.namePos]\u7684[npc.legs]\u6839\uff0c\u7136\u540e\u63d0\u5230\u8170\u4e0a\u3002", null, "[npc.Name]\u7a7f\u8fdb\u8ff7\u4f60\u77ed\u88d9\uff0c\u7136\u540e\u628a\u5b83\u62c9\u5230[npc.her]\u7684\u8170\u90e8\u3002", "[npc.Name]\u628a\u8ff7\u4f60\u77ed\u88d9\u62c9\u5230\u4f60\u7684[pc.legs]\u6839\uff0c\u7136\u540e\u63d0\u5230\u8170\u4e0a\u3002", null, null, null);
            }

            @Override
            public String unequipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 9.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u8131\u4e0b\u8ff7\u4f60\u77ed\u88d9\uff0c\u4e00[pc.feet]\u8e22\u5f00\u3002", "\u4f60\u62c9\u4e0b[npc.namePos]\u7684\u8ff7\u4f60\u77ed\u88d9\uff0c\u628a\u5b83\u6ed1\u5230[npc.her]\u7684[npc.feet]\u8fb9\u3002", null, "[npc.Name]\u8131\u4e0b[npc.her]\u7684\u8ff7\u4f60\u77ed\u88d9\uff0c\u4e00[npc.feet]\u8e22\u5f00\u3002", "[npc.Name]\u8131\u4e0b\u4f60\u7684\u8ff7\u4f60\u77ed\u88d9\uff0c\u4ece\u4f60\u7684[pc.feet]\u4e0b\u6ed1\u843d\u3002", null, null, null);
            }
        };
        MILK_MAID_TORSO_DRESS = new AbstractClothingType(1500, "\u4e00\u6761", false, "\u6324\u5976\u5973\u4ec6\u88d9", "\u6324\u5976\u5973\u4ec6\u88d9", "\u6324\u5976\u5973\u4ec6\u7684\u8fde\u8863\u88d9\uff0c\u7531\u886c\u886b\u3001\u88d9\u5b50\u548c\u7d27\u8eab\u80f8\u8863\u7ec4\u6210\u3002\u886c\u886b\u662f\u7531\u8f7b\u4fbf\u8212\u9002\u7684\u6750\u6599\u5236\u6210\u7684\uff0c\u88ab\u6253\u6e7f\u65f6\u4f1a\u53d8\u5f97\u975e\u5e38\u900f\u660e\u3002\u7d27\u8eab\u80f8\u8863\u548c\u88d9\u5b50\u4e00\u6837\uff0c\u90fd\u662f\u7531\u67d4\u8f6f\u7684\u7ec7\u7269\u5236\u6210\u7684\u3002\u80f8\u8863\u4e0a\u7684\u7ec6\u7ef3\u53ef\u4ee5\u62c9\u7d27\uff0c\u4ee5\u4fee\u9970\u7a7f\u7740\u8005\u7684\u8eab\u6750\uff0c\u5e76\u4f7f\u80f8\u90e8\u66f4\u52a0\u805a\u62e2\u3002", 0.0f, Femininity.FEMININE, InventorySlot.TORSO_UNDER, Rarity.EPIC, SetBonus.getSetBonusFromId("innoxia_milk_maid"), "clothing/milk_maid_dress", Util.newArrayListOfValues(new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_MAJOR_ATTRIBUTE, TFModifier.STRENGTH, TFPotency.MAJOR_BOOST, 0)), Util.newArrayListOfValues(new BlockedParts(DisplacementType.REMOVE_OR_EQUIP, Util.newArrayListOfValues(ClothingAccess.ARMS_UP_TO_SHOULDER, ClothingAccess.HEAD), Util.newArrayListOfValues(CoverableArea.STOMACH, CoverableArea.BACK), Util.newArrayListOfValues(ClothingAccess.WAIST), PresetConcealmentLists.CONCEALED_PARTIAL_TORSO.getPresetInventorySlotList()), new BlockedParts(DisplacementType.PULLS_UP, null, Util.newArrayListOfValues(CoverableArea.ANUS, CoverableArea.PENIS, CoverableArea.VAGINA), Util.newArrayListOfValues(ClothingAccess.GROIN, ClothingAccess.ANUS), PresetConcealmentLists.CONCEALED_GROIN.getPresetInventorySlotList()), new BlockedParts(DisplacementType.PULLS_DOWN, null, Util.newArrayListOfValues(CoverableArea.BREASTS, CoverableArea.NIPPLES), Util.newArrayListOfValues(ClothingAccess.CHEST), Util.newArrayListOfValues(InventorySlot.CHEST, InventorySlot.NIPPLE, InventorySlot.PIERCING_NIPPLE))), null, ColourListPresets.MILK_MAID, ColourListPresets.ALL, ColourListPresets.JUST_WHITE, ColourListPresets.ALL, null, null, Util.newArrayListOfValues(ItemTag.SOLD_BY_NYAN, ItemTag.DRESS, ItemTag.FITS_ARM_WINGS)){

            @Override
            public String getAuthorDescription() {
                return "\u88d9\u5b50\u91cc\u7f1d\u7740\u7684\u6807\u7b7e\u544a\u8bc9\u4f60\u8fd9\u662f\u7531\u201cBlue999\u201d\u5236\u4f5c\u7684\u3002";
            }
        };
        MILK_MAID_HEADBAND = new AbstractClothingType(400, "\u4e00\u4ef6", false, "\u6324\u5976\u5973\u4ec6\u5934\u9970", "\u6324\u5976\u5973\u4ec6\u5934\u9970", "\u4e00\u6761\u591a\u8936\u7684\u5973\u4ec6\u5934\u9970\uff0c\u9876\u90e8\u6709\u8bb8\u591a\u88c5\u9970\u857e\u4e1d\u82b1\u8fb9\u3002", 0.0f, Femininity.FEMININE, InventorySlot.HEAD, Rarity.EPIC, SetBonus.getSetBonusFromId("innoxia_milk_maid"), "clothing/milk_maid_headband", Util.newArrayListOfValues(new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_MAJOR_ATTRIBUTE, TFModifier.STRENGTH, TFPotency.BOOST, 0)), Util.newArrayListOfValues(new BlockedParts(DisplacementType.REMOVE_OR_EQUIP, Util.newArrayListOfValues(ClothingAccess.HEAD), null, null, null)), null, ColourListPresets.MILK_MAID, ColourListPresets.ALL, ColourListPresets.JUST_WHITE, ColourListPresets.ALL, null, null, Util.newArrayListOfValues(ItemTag.SOLD_BY_NYAN)){

            @Override
            public String getAuthorDescription() {
                return "\u53d1\u5e26\u91cc\u7f1d\u7740\u7684\u6807\u7b7e\u544a\u8bc9\u4f60\u8fd9\u662f\u7531\u201cBlue999\u201d\u5236\u4f5c\u7684\u3002";
            }

            @Override
            public String equipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 11.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u6234\u4e0a\u5934\u9970\u3002", "\u4f60\u628a\u5934\u9970\u6234\u5728[npc.namePos]\u7684\u5934\u4e0a\u3002", null, "[npc.Name]\u628a\u5934\u9970\u6234\u5728[npc.her]\u7684\u5934\u4e0a\u3002", "[npc.Name]\u628a\u5934\u9970\u6234\u5728\u4f60\u7684\u5934\u4e0a\u3002", null, null, null);
            }

            @Override
            public String unequipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 11.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u6458\u4e0b\u4f60\u7684\u5934\u9970\u3002", "\u4f60\u6458\u4e0b[npc.namePos]\u7684\u5934\u9970\u3002", null, "[npc.Name]\u6458\u4e0b[npc.her]\u7684\u5934\u9970\u3002", "[npc.Name]\u6458\u4e0b\u4f60\u7684\u5934\u9970\u3002", null, null, null);
            }
        };
        MILK_MAID_KERCHIEF = new AbstractClothingType(300, "\u4e00\u6761", false, "\u65b9\u5dfe", "\u65b9\u5dfe", "\u4e00\u5757\u4e09\u89d2\u5f62\u7684\u5e03\uff0c\u7528\u4e8e\u906e\u76d6\u7a7f\u6234\u8005\u7684\u5934\u90e8\u3002", 0.0f, null, InventorySlot.HEAD, Rarity.EPIC, SetBonus.getSetBonusFromId("innoxia_milk_maid"), "clothing/milk_maid_kerchief", Util.newArrayListOfValues(new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_MAJOR_ATTRIBUTE, TFModifier.STRENGTH, TFPotency.BOOST, 0)), Util.newArrayListOfValues(new BlockedParts(DisplacementType.REMOVE_OR_EQUIP, Util.newArrayListOfValues(ClothingAccess.HEAD), null, null, null)), null, ColourListPresets.JUST_WHITE, ColourListPresets.ALL, null, null, null, null, Util.newArrayListOfValues(ItemTag.SOLD_BY_NYAN)){

            @Override
            public String equipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 12.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u5c06\u65b9\u5dfe\u6234\u5728\u5934\u4e0a\uff0c\u7136\u540e\u5728\u4e0b\u5df4\u90a3\u91cc\u6253\u4e86\u4e2a\u7ed3\u3002", "\u4f60\u5c06\u65b9\u5dfe\u6234\u5728[npc.namePos]\u7684\u5934\u4e0a\uff0c\u7136\u540e\u5728[npc.her]\u7684\u4e0b\u5df4\u90a3\u91cc\u6253\u4e86\u4e2a\u7ed3\u3002", null, "[npc.Name]\u5c06\u65b9\u5dfe\u6234\u5728[npc.her]\u7684\u5934\u4e0a\uff0c\u7136\u540e\u5728\u4e0b\u5df4\u90a3\u91cc\u6253\u4e86\u4e2a\u7ed3\u3002", "[npc.Name]\u5c06\u65b9\u5dfe\u6234\u5728\u4f60\u7684\u5934\u4e0a\uff0c\u7136\u540e\u5728\u4e0b\u5df4\u90a3\u91cc\u6253\u4e86\u4e2a\u7ed3\u3002", null, null, null);
            }

            @Override
            public String unequipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 12.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u6458\u4e0b\u4f60\u7684\u65b9\u5dfe\u3002", "\u4f60\u6458\u4e0b[npc.namePos]\u7684\u65b9\u5dfe\u3002", null, "[npc.Name]\u6458\u4e0b[npc.her]\u7684\u65b9\u5dfe\u3002", "[npc.Name]\u6458\u4e0b\u4f60\u7684\u65b9\u5dfe\u3002", null, null, null);
            }
        };
        JOLNIR_HAT = new AbstractClothingType(400, "\u4e00\u6761", false, "\u5723\u8bde\u5e3d", "\u5723\u8bde\u5e3d", "\u4e00\u9876\u5e3d\u5b50\uff0c\u662f\u8fc7\u5723\u8bde\u8282\u7684\u4eba\u4eec\u6234\u7684\u6b3e\u5f0f\u3002", 0.0f, null, InventorySlot.HEAD, Rarity.EPIC, SetBonus.getSetBonusFromId("innoxia_jolnir"), "clothing/jolnir_head_hat", Util.newArrayListOfValues(new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.RESISTANCE_ICE, TFPotency.MAJOR_BOOST, 0)), Util.newArrayListOfValues(new BlockedParts(DisplacementType.REMOVE_OR_EQUIP, Util.newArrayListOfValues(ClothingAccess.HEAD), null, null, null)), null, ColourListPresets.JUST_RED, ColourListPresets.ALL, ColourListPresets.JUST_WHITE, ColourListPresets.ALL, null, null, Util.newArrayListOfValues(ItemTag.REINDEER_GIFT)){

            @Override
            public String equipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 13.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u6234\u4e0a\u5723\u8bde\u5e3d\u3002", "\u4f60\u628a\u5723\u8bde\u5e3d\u6234\u5728[npc.namePos]\u7684\u5934\u4e0a\u3002", null, "[npc.Name]\u6234\u4e0a\u5723\u8bde\u5e3d\u3002", "[npc.Name]\u628a\u5723\u8bde\u5e3d\u6234\u5728\u4f60\u7684\u5934\u4e0a\u3002", null, null, null);
            }

            @Override
            public String unequipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 13.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u8131\u4e0b\u5723\u8bde\u5e3d\u3002", "\u4f60\u8131\u4e0b[npc.namePos]\u7684\u5723\u8bde\u5e3d\u3002", null, "[npc.Name]\u8131\u4e0b\u5723\u8bde\u5e3d\u3002", "[npc.Name]\u8131\u4e0b\u4f60\u7684\u5723\u8bde\u5e3d\u3002", null, null, null);
            }
        };
        JOLNIR_COAT = new AbstractClothingType(750, "\u4e00\u6761", false, "\u5723\u8bde\u5916\u5957", "\u5723\u8bde\u5916\u5957", "\u4e00\u4ef6\u5916\u5957\uff0c\u662f\u8fc7\u5723\u8bde\u8282\u7684\u4eba\u4eec\u7a7f\u7684\u6b3e\u5f0f\u3002", 0.0f, null, InventorySlot.TORSO_OVER, Rarity.EPIC, SetBonus.getSetBonusFromId("innoxia_jolnir"), "clothing/jolnir_torso_over_coat", Util.newArrayListOfValues(new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.SPELL_COST_MODIFIER, TFPotency.MAJOR_BOOST, 0), new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.DAMAGE_SPELLS, TFPotency.MAJOR_BOOST, 0)), Util.newArrayListOfValues(new BlockedParts(DisplacementType.REMOVE_OR_EQUIP, Util.newArrayListOfValues(ClothingAccess.ARMS_UP_TO_SHOULDER), Util.newArrayListOfValues(CoverableArea.BREASTS, CoverableArea.NIPPLES, CoverableArea.STOMACH, CoverableArea.BACK, CoverableArea.ARMPITS), Util.newArrayListOfValues(ClothingAccess.ARMS_UP_TO_SHOULDER), PresetConcealmentLists.CONCEALED_FULL_TORSO.getPresetInventorySlotList())), null, ColourListPresets.JUST_RED, ColourListPresets.ALL, ColourListPresets.JUST_WHITE, ColourListPresets.ALL, ColourListPresets.JUST_BLACK, ColourListPresets.ALL, Util.newArrayListOfValues(ItemTag.REINDEER_GIFT)){

            @Override
            public String equipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 14.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u7a7f\u4e0a\u5916\u5957\u3002", "\u4f60\u5f15\u5bfc[npc.namePos][npc.arms]\u7a7f\u8fc7\u5916\u5957\u7684\u8896\u5b50\uff0c\u7136\u540e\u628a\u5b83\u4ece[npc.herHim]\u7684\u5934\u4e0a\u62c9\u4e0b\u6765\u3002", null, "[npc.Name]\u7a7f\u4e0a\u5916\u5957\u3002", "[npc.Name]\u5f15\u5bfc\u4f60\u7684[pc.arms]\u7a7f\u8fc7\u5916\u5957\u7684\u8896\u5b50\uff0c[npc.she]\u628a\u5b83\u4ece\u4f60\u5934\u4e0a\u62c9\u4e0b\u6765\u3002", null, null, null);
            }

            @Override
            public String unequipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 14.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u8131\u4e0b\u4f60\u7684\u5916\u5957\u3002", "\u4f60\u8131\u4e0b[npc.namePos]\u7684\u5916\u5957\u3002", null, "[npc.Name]\u8131\u4e0b[npc.her]\u7684\u5916\u5957\u3002", "[npc.Name]\u8131\u4e0b\u4f60\u7684\u5916\u5957\u3002", null, null, null);
            }
        };
        JOLNIR_DRESS = new AbstractClothingType(900, "\u4e00\u6761", false, "\u5723\u8bde\u8fde\u8863\u88d9", "\u5723\u8bde\u8fde\u8863\u88d9", "\u4e00\u4ef6\u8fde\u8863\u88d9\uff0c\u662f\u8fc7\u5723\u8bde\u8282\u7684\u4eba\u4eec\u7a7f\u7684\u6b3e\u5f0f\u3002", 0.0f, Femininity.FEMININE, InventorySlot.TORSO_UNDER, Rarity.EPIC, SetBonus.getSetBonusFromId("innoxia_jolnir"), "clothing/jolnir_torso_dress", Util.newArrayListOfValues(new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.SPELL_COST_MODIFIER, TFPotency.MAJOR_BOOST, 0), new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.DAMAGE_SPELLS, TFPotency.MAJOR_BOOST, 0)), Util.newArrayListOfValues(new BlockedParts(DisplacementType.REMOVE_OR_EQUIP, Util.newArrayListOfValues(ClothingAccess.ARMS_UP_TO_SHOULDER, ClothingAccess.HEAD), Util.newArrayListOfValues(CoverableArea.BREASTS, CoverableArea.NIPPLES, CoverableArea.STOMACH, CoverableArea.BACK, CoverableArea.ARMPITS), Util.newArrayListOfValues(ClothingAccess.CHEST, ClothingAccess.WAIST), PresetConcealmentLists.CONCEALED_PARTIAL_TORSO.getPresetInventorySlotList()), new BlockedParts(DisplacementType.PULLS_UP, null, Util.newArrayListOfValues(CoverableArea.ANUS, CoverableArea.PENIS, CoverableArea.VAGINA), Util.newArrayListOfValues(ClothingAccess.GROIN, ClothingAccess.ANUS), PresetConcealmentLists.CONCEALED_GROIN.getPresetInventorySlotList())), null, ColourListPresets.JUST_RED, ColourListPresets.ALL, ColourListPresets.JUST_WHITE, ColourListPresets.ALL, ColourListPresets.JUST_BLACK, ColourListPresets.ALL, Util.newArrayListOfValues(ItemTag.REINDEER_GIFT, ItemTag.DRESS, ItemTag.FITS_ARM_WINGS)){

            @Override
            public String equipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 15.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u7a7f\u4e0a\u5723\u8bde\u8fde\u8863\u88d9\uff0c\u6574\u7406\u597d\u88d9\u5b50\u540e\uff0c\u5c06\u5e26\u5b50\u79fb\u5230\u80a9\u8180\u4e0a\u7684\u8212\u9002\u4f4d\u7f6e\u3002", "\u4f60\u628a\u5723\u8bde\u8fde\u8863\u88d9\u62c9\u8fc7[npc.namePos]\u7684\u5934\uff0c\u5957\u5728[npc.her]\u8eab\u4e0a\uff0c\u6574\u7406\u597d\u88d9\u5b50\u540e\uff0c\u5c06\u5e26\u5b50\u5728[npc.her]\u80a9\u8180\u4e0a\u52a8\u4e86\u52a8\uff0c\u4ee5\u786e\u4fdd\u7a7f\u7740\u8212\u9002\u3002", null, "[npc.Name]\u7a7f\u4e0a\u5723\u8bde\u8fde\u8863\u88d9\uff0c\u6574\u7406\u597d\u88d9\u5b50\u540e\uff0c\u5c06\u5e26\u5b50\u79fb\u5230[npc.her]\u80a9\u8180\u4e0a\u7684\u8212\u9002\u4f4d\u7f6e\u3002", "[npc.Name]\u5c06\u5723\u8bde\u8fde\u8863\u88d9\u62c9\u8fc7\u4f60\u7684\u5934\uff0c\u5957\u5728\u4f60\u8eab\u4e0a\uff0c\u6574\u7406\u597d\u88d9\u5b50\u540e\uff0c\u5c06\u5e26\u5b50\u5728\u4f60\u80a9\u8180\u4e0a\u79fb\u4e86\u79fb\uff0c\u786e\u4fdd\u7a7f\u7740\u8212\u9002\u3002", null, null, null);
            }

            @Override
            public String unequipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 15.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u62c9\u8d77\u4f60\u7684\u5723\u8bde\u8fde\u8863\u88d9\u4ece\u5934\u9876\u8131\u4e0b\u3002", "\u4f60\u5c06[npc.namePos]\u7684\u5723\u8bde\u8fde\u8863\u88d9\u4ece[npc.her]\u7684\u5934\u9876\u62c9\u8d77\uff0c\u7136\u540e\u8131\u6389\u3002", null, "[npc.Name]\u5c06[npc.her]\u7684\u5723\u8bde\u8fde\u8863\u88d9\u4ece\u5934\u9876\u62c9\u8d77\uff0c\u7136\u540e\u8131\u6389\u3002", "[npc.Name]\u5c06\u4f60\u7684\u5723\u8bde\u8fde\u8863\u88d9\u4ece\u5934\u9876\u62c9\u8d77\uff0c\u7136\u540e\u8131\u6389\u3002", null, null, null);
            }

            @Override
            public String displaceText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, DisplacementType dt, boolean rough) {
                return 15.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u62c9\u8d77\u4f60\u5723\u8bde\u8fde\u8863\u88d9\u7684\u4e0b\u6446\u3002", "\u4f60\u62c9\u8d77[npc.namePos]\u5723\u8bde\u8fde\u8863\u88d9\u7684\u4e0b\u6446\u3002", null, "[npc.Name]\u62c9\u8d77[npc.her]\u5723\u8bde\u8fde\u8863\u88d9\u7684\u4e0b\u6446\u3002", "[npc.Name]\u62c9\u8d77\u4f60\u5723\u8bde\u8fde\u8863\u88d9\u7684\u4e0b\u6446\u3002", null, null, null);
            }

            @Override
            public String replaceText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, DisplacementType dt, boolean rough) {
                return 15.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u628a\u5723\u8bde\u8fde\u8863\u88d9\u62c9\u56de\u6b63\u786e\u4f4d\u7f6e\u3002", "\u4f60\u628a[npc.namePos]\u7684\u5723\u8bde\u8fde\u8863\u88d9\u62c9\u56de\u6b63\u786e\u4f4d\u7f6e\u3002", null, "[npc.Name]\u628a[npc.her]\u7684\u5723\u8bde\u8fde\u8863\u88d9\u62c9\u56de\u6b63\u786e\u4f4d\u7f6e\u3002", "[npc.Name]\u628a\u4f60\u7684\u5723\u8bde\u8fde\u8863\u88d9\u62c9\u56de\u6b63\u786e\u4f4d\u7f6e\u3002", null, null, null);
            }
        };
        JOLNIR_BOOTS = new AbstractClothingType(500, "\u4e00\u53cc", true, "\u5723\u8bde\u9774", "\u5723\u8bde\u9774", "\u4e00\u53cc\u9774\u5b50\uff0c\u662f\u8fc7\u5723\u8bde\u8282\u7684\u4eba\u4eec\u7a7f\u7684\u6b3e\u5f0f\u3002", 0.0f, Femininity.MASCULINE, InventorySlot.FOOT, Rarity.EPIC, SetBonus.getSetBonusFromId("innoxia_jolnir"), "clothing/jolnir_foot_boots", Util.newArrayListOfValues(new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.RESISTANCE_ICE, TFPotency.MAJOR_BOOST, 0)), Util.newArrayListOfValues(new BlockedParts(DisplacementType.REMOVE_OR_EQUIP, Util.newArrayListOfValues(ClothingAccess.FEET), Util.newArrayListOfValues(CoverableArea.FEET), Util.newArrayListOfValues(ClothingAccess.FEET), null)), null, ColourListPresets.JUST_RED, ColourListPresets.ALL, ColourListPresets.JUST_BLACK, ColourListPresets.ALL, ColourListPresets.JUST_WHITE, ColourListPresets.ALL, Util.newArrayListOfValues(ItemTag.REINDEER_GIFT)){

            @Override
            public String equipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 16.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u5c06\u4f60\u7684[pc.feet]\u7a7f\u8fdb\u9774\u5b50\u4e2d\u3002", "\u4f60\u5c06[npc.namePos]\u7684[npc.feet]\u7a7f\u8fdb\u9774\u5b50\u4e2d\u3002", "\u4f60\u5f3a\u884c\u5c06[npc.namePos]\u7684[npc.feet]\u7a7f\u8fdb\u9774\u5b50\u4e2d\u3002", "[npc.Name]\u5c06[npc.her]\u7684[npc.feet]\u7a7f\u8fdb\u9774\u5b50\u4e2d\u3002", "[npc.Name]\u5c06\u4f60\u7684[pc.feet]\u7a7f\u8fdb\u9774\u5b50\u4e2d\u3002", "[npc.Name]\u5f3a\u884c\u6293\u4f4f\u4f60\u7684[pc.feet]\u8ba9\u4f60\u7a7f\u4e0a\u9774\u5b50\u3002", null, null);
            }

            @Override
            public String unequipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 16.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u8131\u4e0b\u4f60\u7684\u9774\u5b50\u3002", "\u4f60\u8131\u4e0b[npc.namePos]\u7684\u9774\u5b50\u3002", "\u4f60\u6293\u4f4f[npc.namePos]\u7684[npc.feet]\u7136\u540e\u8131\u4e0b[npc.her]\u7684\u9774\u5b50\u3002", "[npc.Name]\u8131\u4e0b[npc.her]\u7684\u9774\u5b50\u3002", "[npc.Name]\u8131\u4e0b\u4f60\u7684\u9774\u5b50\u3002", "[npc.Name]\u6293\u4f4f\u4f60\u7684[pc.feet]\u7136\u540e\u628a\u4f60\u7684\u9774\u5b50\u8131\u4e0b\u3002", null, null);
            }
        };
        JOLNIR_BOOTS_FEMININE = new AbstractClothingType(750, "\u4e00\u53cc", true, "\u5723\u8bde\u9ad8\u8ddf\u9774", "\u5723\u8bde\u9ad8\u8ddf\u9774", "\u4e00\u53cc\u9774\u5b50\uff0c\u662f\u8fc7\u5723\u8bde\u8282\u7684\u4eba\u4eec\u7a7f\u7684\u6b3e\u5f0f\u3002", 0.0f, Femininity.FEMININE, InventorySlot.FOOT, Rarity.EPIC, SetBonus.getSetBonusFromId("innoxia_jolnir"), "clothing/jolnir_foot_boots_feminine", Util.newArrayListOfValues(new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.RESISTANCE_ICE, TFPotency.MAJOR_BOOST, 0)), Util.newArrayListOfValues(new BlockedParts(DisplacementType.REMOVE_OR_EQUIP, Util.newArrayListOfValues(ClothingAccess.FEET), Util.newArrayListOfValues(CoverableArea.FEET), Util.newArrayListOfValues(ClothingAccess.FEET), null)), null, ColourListPresets.JUST_RED, ColourListPresets.ALL, ColourListPresets.JUST_BLACK, ColourListPresets.ALL, ColourListPresets.JUST_WHITE, ColourListPresets.ALL, Util.newArrayListOfValues(ItemTag.REINDEER_GIFT)){

            @Override
            public String equipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 17.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u5c06\u4f60\u7684[pc.feet]\u7a7f\u8fdb\u9774\u5b50\u4e2d\u3002", "\u4f60\u5c06[npc.namePos]\u7684[npc.feet]\u7a7f\u8fdb\u9774\u5b50\u4e2d\u3002", "\u4f60\u5f3a\u884c\u5c06[npc.namePos]\u7684[npc.feet]\u7a7f\u8fdb\u9774\u5b50\u4e2d\u3002", "[npc.Name]\u5c06[npc.her]\u7684[npc.feet]\u7a7f\u8fdb\u9774\u5b50\u4e2d\u3002", "[npc.Name]\u5c06\u4f60\u7684[pc.feet]\u7a7f\u8fdb\u9774\u5b50\u4e2d\u3002", "[npc.Name]\u5f3a\u884c\u6293\u4f4f\u4f60\u7684[pc.feet]\u8ba9\u4f60\u7a7f\u4e0a\u9774\u5b50\u3002", null, null);
            }

            @Override
            public String unequipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                return 17.getEquipDescriptions(clothingOwner, clothingRemover, rough, "\u4f60\u8131\u4e0b\u4f60\u7684\u9774\u5b50\u3002", "\u4f60\u8131\u4e0b[npc.namePos]\u7684\u9774\u5b50\u3002", "\u4f60\u6293\u4f4f[npc.namePos]\u7684[npc.feet]\u7136\u540e\u8131\u4e0b[npc.her]\u7684\u9774\u5b50\u3002", "[npc.Name]\u8131\u4e0b[npc.her]\u7684\u9774\u5b50\u3002", "[npc.Name]\u8131\u4e0b\u4f60\u7684\u9774\u5b50\u3002", "[npc.Name]\u6293\u4f4f\u4f60\u7684[pc.feet]\u7136\u540e\u628a\u4f60\u7684\u9774\u5b50\u8131\u4e0b\u3002", null, null);
            }
        };
        FINGER_LYSSIETHS_RING = new AbstractClothingType(50000, "", false, "\u8389\u897f\u4e1d\u7684\u5370\u7ae0\u6307\u73af", "\u8389\u897f\u4e1d\u7684\u5370\u7ae0\u6307\u73af", "\u8389\u897f\u4e1d\u7684\u5370\u7ae0\u6307\u73af\u5236\u4f5c\u7cbe\u7f8e\uff0c\u9576\u5d4c\u7740\u73cd\u8d35\u7684\u5b9d\u77f3\uff0c\u7528\u4ee5\u638c\u63a7\u7740\u5bb6\u65cf\u7684\u5c0a\u91cd\u548c\u5fe0\u8bda\u3002\u4f5c\u4e3a\u8389\u7433\u7684\u6743\u529b\u8c61\u5f81\u4e4b\u4e00\uff0c\u8fd9\u4ef6\u7269\u54c1\u62e5\u6709\u7740\u5de8\u5927\u5374\u8150\u8d25\u7684\u6743\u529b\u3002", 0.0f, Femininity.ANDROGYNOUS, InventorySlot.FINGER, Rarity.QUEST, null, "items/lyssiethsRing", Util.newArrayListOfValues(new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.DAMAGE_LUST, TFPotency.MAJOR_BOOST, 0), new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.DAMAGE_LUST, TFPotency.MAJOR_BOOST, 0), new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.DAMAGE_LUST, TFPotency.MAJOR_BOOST, 0), new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.DAMAGE_LUST, TFPotency.MAJOR_BOOST, 0), new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.DAMAGE_SPELLS, TFPotency.MAJOR_BOOST, 0), new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.DAMAGE_SPELLS, TFPotency.MAJOR_BOOST, 0), new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.DAMAGE_SPELLS, TFPotency.MAJOR_BOOST, 0), new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.SPELL_COST_MODIFIER, TFPotency.MAJOR_BOOST, 0), new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.SPELL_COST_MODIFIER, TFPotency.MAJOR_BOOST, 0), new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_ATTRIBUTE, TFModifier.SPELL_COST_MODIFIER, TFPotency.MAJOR_BOOST, 0), new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_MAJOR_ATTRIBUTE, TFModifier.CORRUPTION, TFPotency.MAJOR_BOOST, 0), new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_MAJOR_ATTRIBUTE, TFModifier.CORRUPTION, TFPotency.MAJOR_BOOST, 0), new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_MAJOR_ATTRIBUTE, TFModifier.CORRUPTION, TFPotency.MAJOR_BOOST, 0), new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_MAJOR_ATTRIBUTE, TFModifier.CORRUPTION, TFPotency.MAJOR_BOOST, 0), new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_MAJOR_ATTRIBUTE, TFModifier.CORRUPTION, TFPotency.MAJOR_BOOST, 0)), Util.newArrayListOfValues(new BlockedParts(DisplacementType.REMOVE_OR_EQUIP, Util.newArrayListOfValues(ClothingAccess.FINGERS), null, null, null)), null, ColourListPresets.JUST_ROSE_GOLD, ColourListPresets.ALL_METAL, ColourListPresets.JUST_RED_DARK, ColourListPresets.ALL, ColourListPresets.JUST_ROSE_GOLD, ColourListPresets.ALL_METAL, null){

            @Override
            public String equipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                if (rough) {
                    return UtilText.parse(clothingOwner, clothingRemover, "[npc.Name]\u7c97\u66b4\u5730\u5f3a\u884c\u628a\u5370\u7ae0\u6307\u73af\u5957\u8fdb[npc2.namePos]\u7684\u624b\u6307\u3002", new ParserTag[0]);
                }
                if (clothingOwner.equals(clothingRemover)) {
                    return UtilText.parse(clothingOwner, clothingRemover, "[npc.Name]\u628a\u5370\u7ae0\u6307\u73af\u6234\u5728[npc.her]\u7684\u624b\u6307\u4e0a\u3002", new ParserTag[0]);
                }
                return UtilText.parse(clothingOwner, clothingRemover, "[npc.Name]\u628a\u5370\u7ae0\u6307\u73af\u6234\u5728[npc2.namePos]\u7684\u624b\u6307\u4e0a\u3002", new ParserTag[0]);
            }

            @Override
            public String unequipText(GameCharacter clothingOwner, GameCharacter clothingRemover, InventorySlot slotToEquipInto, boolean rough, AbstractClothing clothing, boolean applyEffects) {
                if (rough) {
                    return UtilText.parse(clothingRemover, clothingOwner, "[npc.Name]\u7c97\u66b4\u5730\u5c06\u5370\u7ae0\u6212\u6307\u4ece[npc2.namePos]\u624b\u6307\u4e0a\u62fd\u4e0b\u6765\u3002", new ParserTag[0]);
                }
                if (clothingOwner.equals(clothingRemover)) {
                    return UtilText.parse(clothingRemover, clothingOwner, "[npc.Name]\u4ece[npc.her]\u624b\u6307\u4e0a\u6458\u4e0b\u5370\u7ae0\u6307\u73af\u3002", new ParserTag[0]);
                }
                return UtilText.parse(clothingRemover, clothingOwner, "[npc.Name]\u4ece[npc2.namePos]\u624b\u6307\u4e0a\u6458\u4e0b\u5370\u7ae0\u6307\u73af\u3002", new ParserTag[0]);
            }
        };
        suitableFeminineClothing = new HashMap<Occupation, ArrayList<AbstractClothingType>>();
        clothingToIdMap = new HashMap<AbstractClothingType, String>();
        idToClothingMap = new HashMap<String, AbstractClothingType>();
        oldIdConversionMap = new HashMap<String, String>();
        oldIdConversionMap.put("NECK_SNOWFLAKE_NECKLACE", "innoxia_elemental_snowflake_necklace");
        oldIdConversionMap.put("PIERCING_EAR_SNOW_FLAKES", "innoxia_elemental_piercing_ear_snowflakes");
        oldIdConversionMap.put("PIERCING_NOSE_SNOWFLAKE_STUD", "innoxia_elemental_piercing_nose_snowflake");
        oldIdConversionMap.put("NECK_SUN_NECKLACE", "innoxia_elemental_sun_necklace");
        oldIdConversionMap.put("PIERCING_EAR_SUN", "innoxia_elemental_piercing_ear_sun");
        oldIdConversionMap.put("PIERCING_NOSE_SUN_STUD", "innoxia_elemental_piercing_nose_sun");
        oldIdConversionMap.put("CATTLE_NECK_COWBELL_COLLAR", "innoxia_cattle_cowbell_collar");
        oldIdConversionMap.put("CATTLE_PIERCING_EAR_TAGS", "innoxia_cattle_piercing_ear_tag");
        oldIdConversionMap.put("CATTLE_PIERCING_NOSE_BOVINE_RING", "innoxia_cattle_piercing_nose_ring");
        oldIdConversionMap.put("SOCK_RAINBOW_STOCKINGS", "innoxia_rainbow_stockings");
        oldIdConversionMap.put("HAND_RAINBOW_FINGERLESS_GLOVES", "innoxia_rainbow_gloves");
        oldIdConversionMap.put("BDSM_CHASTITY_CAGE", "innoxia_bdsm_chastity_cage");
        oldIdConversionMap.put("BDSM_PENIS_STRAPON", "innoxia_bdsm_penis_strapon");
        oldIdConversionMap.put("innoxia_bdsmBracelets_wrist_bracelets", "innoxia_bdsm_wrist_bracelets");
        oldIdConversionMap.put("BDSM_BALLGAG", "innoxia_bdsm_ballgag");
        oldIdConversionMap.put("BDSM_RINGGAG", "innoxia_bdsm_ringgag");
        oldIdConversionMap.put("BDSM_SPREADER_BAR", "innoxia_bdsm_spreaderbar");
        oldIdConversionMap.put("BDSM_CHOKER", "innoxia_bdsm_choker");
        oldIdConversionMap.put("BDSM_WRIST_RESTRAINTS", "innoxia_bdsm_wrist_restraints");
        oldIdConversionMap.put("BDSM_CHASTITY_BELT", "innoxia_bdsm_chastity_belt");
        oldIdConversionMap.put("BDSM_CHASTITY_BELT_FULL", "innoxia_bdsm_chastity_belt_full");
        oldIdConversionMap.put("BDSM_KARADA", "innoxia_bdsm_karada");
        oldIdConversionMap.put("WITCH_HAT", "innoxia_witch_witch_hat");
        oldIdConversionMap.put("WITCH_DRESS", "innoxia_witch_witch_dress");
        oldIdConversionMap.put("WITCH_BOOTS", "innoxia_witch_witch_boots");
        oldIdConversionMap.put("WITCH_BOOTS_THIGH_HIGH", "innoxia_witch_witch_boots_thigh_high");
        oldIdConversionMap.put("EYES_SAFETY_GOGGLES", "innoxia_scientist_safety_goggles");
        oldIdConversionMap.put("SCIENTIST_EYES_SAFETY_GOGGLES", "innoxia_scientist_safety_goggles");
        oldIdConversionMap.put("SCIENTIST_TORSO_OVER_LAB_COAT", "innoxia_scientist_lab_coat");
        oldIdConversionMap.put("AMBERS_BITCH_CHOKER", "innoxia_neck_ambers_bitch_collar");
        oldIdConversionMap.put("KIMONO_HAIR_KANZASHI", "innoxia_japanese_kanzashi");
        oldIdConversionMap.put("KIMONO_DRESS", "innoxia_japanese_kimono");
        oldIdConversionMap.put("KIMONO_GETA", "innoxia_japanese_geta");
        oldIdConversionMap.put("KIMONO_MENS_KIMONO", "innoxia_japanese_mens_kimono");
        oldIdConversionMap.put("KIMONO_HAORI", "innoxia_japanese_haori");
        oldIdConversionMap.put("KIMONO_MENS_GETA", "innoxia_japanese_mens_geta");
        oldIdConversionMap.put("MAID_HEADPIECE", "innoxia_maid_headpiece");
        oldIdConversionMap.put("MAID_DRESS", "innoxia_maid_dress");
        oldIdConversionMap.put("MAID_STOCKINGS", "innoxia_maid_stockings");
        oldIdConversionMap.put("MAID_HEELS", "innoxia_maid_heels");
        oldIdConversionMap.put("MAID_SLEEVES", "innoxia_maid_sleeves");
        oldIdConversionMap.put("kobolds_belt_leather_belt", "innoxia_hips_leather_belt");
        oldIdConversionMap.put("PENIS_CONDOM", "innoxia_penis_condom");
        oldIdConversionMap.put("ANKLE_BRACELET", "innoxia_ankle_anklet");
        oldIdConversionMap.put("ANKLE_SHIN_GUARDS", "innoxia_ankle_shin_guards");
        oldIdConversionMap.put("PIERCING_EAR_RING", "innoxia_piercing_ear_ring");
        oldIdConversionMap.put("PIERCING_EAR_BASIC_RING", "innoxia_piercing_ear_ring");
        oldIdConversionMap.put("PIERCING_EAR_HOOPS", "innoxia_piercing_ear_hoops");
        oldIdConversionMap.put("PIERCING_NOSE_BASIC_RING", "innoxia_piercing_nose_ring");
        oldIdConversionMap.put("PIERCING_LIP_RINGS", "innoxia_piercing_lip_double_ring");
        oldIdConversionMap.put("PIERCING_TONGUE_BAR", "innoxia_piercing_basic_barbell");
        oldIdConversionMap.put("PIERCING_NIPPLE_BARS", "innoxia_piercing_basic_barbell_pair");
        oldIdConversionMap.put("PIERCING_NAVEL_GEM", "innoxia_piercing_gemstone_barbell");
        oldIdConversionMap.put("PIERCING_VAGINA_BARBELL_RING", "innoxia_piercing_ringed_barbell");
        oldIdConversionMap.put("PIERCING_PENIS_RING", "innoxia_piercing_penis_ring");
        oldIdConversionMap.put("EYES_GLASSES", "innoxia_eye_glasses");
        oldIdConversionMap.put("EYES_AVIATORS", "innoxia_eye_aviators");
        oldIdConversionMap.put("EYES_PATCH", "innoxia_eye_patch");
        oldIdConversionMap.put("MOUTH_BANDANA", "innoxia_mouth_bandana");
        oldIdConversionMap.put("HEAD_CHEATERS_CIRCLET", "innoxia_head_circlet");
        oldIdConversionMap.put("HEAD_CIRCLET", "innoxia_head_circlet");
        oldIdConversionMap.put("HEAD_TIARA", "innoxia_head_tiara");
        oldIdConversionMap.put("HEAD_CAP", "innoxia_head_cap");
        oldIdConversionMap.put("HEAD_HEADBAND", "innoxia_head_headband");
        oldIdConversionMap.put("HEAD_HEADBAND_BOW", "innoxia_head_headband_bow");
        oldIdConversionMap.put("HEAD_SWEATBAND", "innoxia_head_sweatband");
        oldIdConversionMap.put("HEAD_COWBOY_HAT", "innoxia_head_cowboy_hat");
        oldIdConversionMap.put("HEAD_ANTLER_HEADBAND", "innoxia_head_antler_headband");
        oldIdConversionMap.put("HEAD_SLIME_QUEENS_TIARA", "innoxia_head_slime_queens_tiara");
        oldIdConversionMap.put("HAND_ELBOWLENGTH_GLOVES", "innoxia_hand_elbow_length_gloves");
        oldIdConversionMap.put("HAND_GLOVES", "innoxia_hand_gloves");
        oldIdConversionMap.put("HAND_FINGERLESS_GLOVES", "innoxia_hand_fingerless_gloves");
        oldIdConversionMap.put("HAND_WRAPS", "innoxia_hand_wraps");
        oldIdConversionMap.put("HAND_FISHNET_GLOVES", "innoxia_hand_fishnet_gloves");
        oldIdConversionMap.put("FINGER_RING", "innoxia_finger_ring");
        oldIdConversionMap.put("NECK_ANKH_NECKLACE", "innoxia_neck_ankh_necklace");
        oldIdConversionMap.put("NECK_BELL_COLLAR", "innoxia_neck_bell_collar");
        oldIdConversionMap.put("NECK_COLLAR_BOWTIE", "innoxia_neck_collar_bowtie");
        oldIdConversionMap.put("NECK_HEART_NECKLACE", "innoxia_neck_heart_necklace");
        oldIdConversionMap.put("NECK_SCARF", "innoxia_neck_scarf");
        oldIdConversionMap.put("NECK_TIE", "innoxia_neck_tie");
        oldIdConversionMap.put("NECK_BREEDER_COLLAR", "innoxia_neck_breeder_collar");
        oldIdConversionMap.put("NECK_SLAVE_COLLAR", "innoxia_bdsm_metal_collar");
        oldIdConversionMap.put("CHEST_LACY_PLUNGE_BRA", "innoxia_chest_lacy_plunge_bra");
        oldIdConversionMap.put("CHEST_BIKINI", "innoxia_chest_bikini");
        oldIdConversionMap.put("CHEST_CHEMISE", "innoxia_chest_chemise");
        oldIdConversionMap.put("CHEST_CROPTOP_BRA", "innoxia_chest_croptop_bra");
        oldIdConversionMap.put("CHEST_FULLCUP_BRA", "innoxia_chest_fullcup_bra");
        oldIdConversionMap.put("CHEST_PLUNGE_BRA", "innoxia_chest_plunge_bra");
        oldIdConversionMap.put("CHEST_NURSING_BRA", "innoxia_chest_nursing_bra");
        oldIdConversionMap.put("CHEST_OPEN_CUP_BRA", "innoxia_chest_open_cup_bra");
        oldIdConversionMap.put("CHEST_SARASHI", "innoxia_chest_sarashi");
        oldIdConversionMap.put("CHEST_SPORTS_BRA", "innoxia_chest_sports_bra");
        oldIdConversionMap.put("CHEST_STRIPED_BRA", "innoxia_chest_striped_bra");
        oldIdConversionMap.put("CHEST_SWIMSUIT", "innoxia_chest_swimsuit");
        oldIdConversionMap.put("CHEST_TUBE_TOP", "innoxia_chest_tube_top");
        oldIdConversionMap.put("NIPPLE_TAPE_CROSSES", "innoxia_tape_roll");
        oldIdConversionMap.put("innoxia_nipple_tape_crosses", "innoxia_tape_roll");
        oldIdConversionMap.put("LEG_SKIRT", "innoxia_leg_skirt");
        oldIdConversionMap.put("LEG_PENCIL_SKIRT", "innoxia_leg_pencil_skirt");
        oldIdConversionMap.put("LEG_MINI_SKIRT", "innoxia_leg_mini_skirt");
        oldIdConversionMap.put("LEG_MICRO_SKIRT_PLEATED", "innoxia_leg_micro_skirt_pleated");
        oldIdConversionMap.put("LEG_MICRO_SKIRT_BELTED", "innoxia_leg_micro_skirt_belted");
        oldIdConversionMap.put("LEG_SHORTS", "innoxia_leg_shorts");
        oldIdConversionMap.put("LEG_BIKE_SHORTS", "innoxia_leg_bike_shorts");
        oldIdConversionMap.put("LEG_SPORT_SHORTS", "innoxia_leg_sport_shorts");
        oldIdConversionMap.put("LEG_HOTPANTS", "innoxia_leg_hotpants");
        oldIdConversionMap.put("LEG_TIGHT_TROUSERS", "innoxia_leg_tight_jeans");
        oldIdConversionMap.put("LEG_JEANS", "innoxia_leg_jeans");
        oldIdConversionMap.put("LEG_TROUSERS", "innoxia_leg_trousers");
        oldIdConversionMap.put("LEG_CARGO_TROUSERS", "innoxia_leg_cargo_trousers");
        oldIdConversionMap.put("LEG_YOGA_PANTS", "innoxia_leg_yoga_pants");
        oldIdConversionMap.put("LEG_ASSLESS_CHAPS", "innoxia_leg_assless_chaps");
        oldIdConversionMap.put("LEG_CROTCHLESS_CHAPS", "innoxia_leg_crotchless_chaps");
        oldIdConversionMap.put("GROIN_LACY_PANTIES", "innoxia_groin_lacy_panties");
        oldIdConversionMap.put("GROIN_PANTIES", "innoxia_groin_panties");
        oldIdConversionMap.put("GROIN_SHIMAPAN", "innoxia_groin_shimapan");
        oldIdConversionMap.put("GROIN_VSTRING", "innoxia_groin_vstring");
        oldIdConversionMap.put("GROIN_THONG", "innoxia_groin_thong");
        oldIdConversionMap.put("GROIN_BIKINI", "innoxia_groin_bikini");
        oldIdConversionMap.put("GROIN_BOYSHORTS", "innoxia_groin_boyshorts");
        oldIdConversionMap.put("GROIN_BRIEFS", "innoxia_groin_briefs");
        oldIdConversionMap.put("GROIN_BOXERS", "innoxia_groin_boxers");
        oldIdConversionMap.put("GROIN_JOCKSTRAP", "innoxia_groin_jockstrap");
        oldIdConversionMap.put("GROIN_BACKLESS_PANTIES", "innoxia_groin_backless_panties");
        oldIdConversionMap.put("GROIN_CROTCHLESS_PANTIES", "innoxia_groin_crotchless_panties");
        oldIdConversionMap.put("GROIN_CROTCHLESS_THONG", "innoxia_groin_crotchless_thong");
        oldIdConversionMap.put("GROIN_CROTCHLESS_BRIEFS", "innoxia_groin_crotchless_briefs");
        oldIdConversionMap.put("FOOT_ANKLE_BOOTS", "innoxia_foot_ankle_boots");
        oldIdConversionMap.put("FOOT_CHELSEA_BOOTS", "innoxia_foot_chelsea_boots");
        oldIdConversionMap.put("FOOT_HEELS", "innoxia_foot_heels");
        oldIdConversionMap.put("FOOT_LOW_TOP_SKATER_SHOES", "innoxia_foot_low_top_skater_shoes");
        oldIdConversionMap.put("FOOT_MENS_SMART_SHOES", "innoxia_foot_mens_smart_shoes");
        oldIdConversionMap.put("FOOT_PLATFORM_BOOTS", "innoxia_foot_platform_boots");
        oldIdConversionMap.put("FOOT_STILETTO_HEELS", "innoxia_foot_stiletto_heels");
        oldIdConversionMap.put("FOOT_THIGH_HIGH_BOOTS", "innoxia_foot_thigh_high_boots");
        oldIdConversionMap.put("FOOT_TRAINERS", "innoxia_foot_trainers");
        oldIdConversionMap.put("FOOT_WORK_BOOTS", "innoxia_foot_work_boots");
        oldIdConversionMap.put("TORSO_TSHIRT", "innoxia_torso_tshirt");
        oldIdConversionMap.put("TORSO_OXFORD_SHIRT", "innoxia_torso_long_sleeved_shirt");
        oldIdConversionMap.put("TORSO_SHORT_SLEEVE_SHIRT", "innoxia_torso_short_sleeved_shirt");
        oldIdConversionMap.put("TORSO_BLOUSE", "innoxia_torso_blouse");
        oldIdConversionMap.put("TORSO_SLEEVELESS_TURTLENECK", "innoxia_torso_sleeveless_turtleneck");
        oldIdConversionMap.put("TORSO_KEYHOLE_CROPTOP", "innoxia_torso_keyhole_croptop");
        oldIdConversionMap.put("TORSO_SHORT_CROPTOP", "innoxia_torso_short_croptop");
        oldIdConversionMap.put("TORSO_FISHNET_TOP", "innoxia_torso_fishnet_top");
        oldIdConversionMap.put("TORSO_CAMITOP_STRAPS", "innoxia_torso_cami_straps");
        oldIdConversionMap.put("TORSO_SKATER_DRESS", "innoxia_torso_skater_dress");
        oldIdConversionMap.put("TORSO_CORSET_DRESS", "innoxia_torso_corset_dress");
        oldIdConversionMap.put("TORSO_VIRGIN_KILLER_SWEATER", "innoxia_torso_virgin_killer_sweater");
        oldIdConversionMap.put("TORSO_SLIP_DRESS", "innoxia_torso_slip_dress");
        oldIdConversionMap.put("TORSO_PLUNGE_DRESS", "innoxia_torso_plunge_dress");
        oldIdConversionMap.put("TORSO_LONG_SLEEVE_DRESS", "innoxia_torso_long_sleeve_dress");
        oldIdConversionMap.put("TORSO_BODYCONZIP_DRESS", "innoxia_torso_bodyconzip_dress");
        oldIdConversionMap.put("MEGA_MILK", "innoxia_torso_tshirt_megamilk");
        oldIdConversionMap.put("STOMACH_LOWBACK_BODY", "innoxia_stomach_lowback_body");
        oldIdConversionMap.put("STOMACH_UNDERBUST_CORSET", "innoxia_stomach_underbust_corset");
        oldIdConversionMap.put("STOMACH_OVERBUST_CORSET", "innoxia_stomach_overbust_corset");
        oldIdConversionMap.put("STOMACH_SARASHI", "innoxia_stomach_sarashi");
        oldIdConversionMap.put("TORSO_OVER_HOODIE", "innoxia_torsoOver_hoodie");
        oldIdConversionMap.put("TORSO_OVER_OPEN_CARDIGAN", "innoxia_torsoOver_open_front_cardigan");
        oldIdConversionMap.put("TORSO_OVER_BLAZER", "innoxia_torsoOver_blazer");
        oldIdConversionMap.put("TORSO_OVER_COAT_DRESS", "innoxia_torsoOver_dress_coat");
        oldIdConversionMap.put("TORSO_OVER_CLOAK", "innoxia_torsoOver_hooded_cloak");
        oldIdConversionMap.put("TORSO_RIBBED_SWEATER", "innoxia_torsoOver_ribbed_jumper");
        oldIdConversionMap.put("TORSO_OVER_CHRISTMAS_SWEATER", "innoxia_torsoOver_christmas_jumper");
        oldIdConversionMap.put("TORSO_KEYHOLE_SWEATER", "innoxia_torsoOver_keyhole_jumper");
        oldIdConversionMap.put("TORSO_OVER_SUIT_JACKET", "innoxia_torsoOver_suit_jacket");
        oldIdConversionMap.put("TORSO_OVER_WOMENS_LEATHER_JACKET", "innoxia_torsoOver_womens_leather_jacket");
        oldIdConversionMap.put("SOCK_SOCKS", "innoxia_sock_socks");
        oldIdConversionMap.put("SOCK_TRAINER_SOCKS", "innoxia_sock_trainer_socks");
        oldIdConversionMap.put("SOCK_KNEEHIGH_SOCKS", "innoxia_sock_kneehigh_socks");
        oldIdConversionMap.put("SOCK_STOCKINGS", "innoxia_sock_stockings");
        oldIdConversionMap.put("SOCK_THIGHHIGH_SOCKS", "innoxia_sock_thighhigh_socks");
        oldIdConversionMap.put("SOCK_THIGHHIGH_SOCKS_STRIPED", "innoxia_sock_thighhigh_socks_striped");
        oldIdConversionMap.put("SOCK_TIGHTS", "innoxia_sock_pantyhose");
        oldIdConversionMap.put("SOCK_FISHNET_STOCKINGS", "innoxia_sock_fishnets");
        oldIdConversionMap.put("SOCK_TOELESS_STRIPED_STOCKINGS", "innoxia_sock_toeless_striped_stockings");
        oldIdConversionMap.put("WRIST_BANGLE", "innoxia_wrist_bangle");
        oldIdConversionMap.put("innoxia_insertableVibrator_insertable_vibrator", "innoxia_vagina_insertable_dildo");
        oldIdConversionMap.put("dsg_eep_servequipset_enfdjacket_pc", "dsg_eep_servequipset_enfdjacket");
        commonClothingMap = new EnumMap<InventorySlot, List<AbstractClothingType>>(InventorySlot.class);
        commonClothingMapFemale = new EnumMap<InventorySlot, List<AbstractClothingType>>(InventorySlot.class);
        commonClothingMapMale = new EnumMap<InventorySlot, List<AbstractClothingType>>(InventorySlot.class);
        commonClothingMapAndrogynous = new EnumMap<InventorySlot, List<AbstractClothingType>>(InventorySlot.class);
        commonClothingMapFemaleIncludingAndrogynous = new EnumMap<InventorySlot, List<AbstractClothingType>>(InventorySlot.class);
        commonClothingMapMaleIncludingAndrogynous = new EnumMap<InventorySlot, List<AbstractClothingType>>(InventorySlot.class);
        for (InventorySlot slot : InventorySlot.values()) {
            commonClothingMap.put(slot, new ArrayList());
            commonClothingMapFemale.put(slot, new ArrayList());
            commonClothingMapMale.put(slot, new ArrayList());
            commonClothingMapAndrogynous.put(slot, new ArrayList());
            commonClothingMapFemaleIncludingAndrogynous.put(slot, new ArrayList());
            commonClothingMapMaleIncludingAndrogynous.put(slot, new ArrayList());
        }
        coreClothingSlots = Util.newArrayListOfValues(InventorySlot.TORSO_UNDER, InventorySlot.LEG);
        lingerieSlots = Util.newArrayListOfValues(InventorySlot.CHEST, InventorySlot.GROIN, InventorySlot.STOMACH, InventorySlot.SOCK);
        allClothing = new ArrayList<AbstractClothingType>();
        moddedClothingList = new ArrayList<AbstractClothingType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/items/clothing");
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry entry2 : entry.getValue().entrySet()) {
                try {
                    String string = (String)entry2.getKey();
                    AbstractClothingType ct2 = new AbstractClothingType((File)entry2.getValue(), entry.getKey()){};
                    moddedClothingList.add(ct2);
                    clothingToIdMap.put(ct2, string);
                    idToClothingMap.put(string, ct2);
                    if (ct2.getRarity() != Rarity.COMMON || ct2.getDefaultItemTags().contains((Object)ItemTag.NO_RANDOM_SPAWN)) continue;
                    commonClothingMap.get((Object)ct2.getEquipSlots().get(0)).add(ct2);
                    if (ct2.getFemininityRestriction() == Femininity.FEMININE) {
                        commonClothingMapFemale.get((Object)ct2.getEquipSlots().get(0)).add(ct2);
                        commonClothingMapFemaleIncludingAndrogynous.get((Object)ct2.getEquipSlots().get(0)).add(ct2);
                        continue;
                    }
                    if (ct2.getFemininityRestriction() == Femininity.ANDROGYNOUS || ct2.getFemininityRestriction() == null) {
                        commonClothingMapAndrogynous.get((Object)ct2.getEquipSlots().get(0)).add(ct2);
                        commonClothingMapFemaleIncludingAndrogynous.get((Object)ct2.getEquipSlots().get(0)).add(ct2);
                        commonClothingMapMaleIncludingAndrogynous.get((Object)ct2.getEquipSlots().get(0)).add(ct2);
                        continue;
                    }
                    if (ct2.getFemininityRestriction() != Femininity.MASCULINE) continue;
                    commonClothingMapMale.get((Object)ct2.getEquipSlots().get(0)).add(ct2);
                    commonClothingMapMaleIncludingAndrogynous.get((Object)ct2.getEquipSlots().get(0)).add(ct2);
                }
                catch (XMLLoadException xMLLoadException) {
                    System.err.println("Loading modded clothing failed at 'ClothingType'. File path: " + ((File)entry2.getValue()).getAbsolutePath());
                    System.err.println("Actual exception: ");
                    System.err.println(xMLLoadException);
                }
            }
        }
        allClothing.addAll(moddedClothingList);
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/clothing");
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> entry3 : entry.getValue().entrySet()) {
                try {
                    String id = entry3.getKey();
                    ct = new AbstractClothingType(entry3.getValue(), entry.getKey()){};
                    allClothing.add(ct);
                    clothingToIdMap.put(ct, id);
                    idToClothingMap.put(id, ct);
                    if (ct.getRarity() != Rarity.COMMON || ct.getDefaultItemTags().contains((Object)ItemTag.NO_RANDOM_SPAWN)) continue;
                    commonClothingMap.get((Object)ct.getEquipSlots().get(0)).add(ct);
                    if (ct.getFemininityRestriction() == Femininity.FEMININE) {
                        commonClothingMapFemale.get((Object)ct.getEquipSlots().get(0)).add(ct);
                        commonClothingMapFemaleIncludingAndrogynous.get((Object)ct.getEquipSlots().get(0)).add(ct);
                        continue;
                    }
                    if (ct.getFemininityRestriction() == Femininity.ANDROGYNOUS || ct.getFemininityRestriction() == null) {
                        commonClothingMapAndrogynous.get((Object)ct.getEquipSlots().get(0)).add(ct);
                        commonClothingMapFemaleIncludingAndrogynous.get((Object)ct.getEquipSlots().get(0)).add(ct);
                        commonClothingMapMaleIncludingAndrogynous.get((Object)ct.getEquipSlots().get(0)).add(ct);
                        continue;
                    }
                    if (ct.getFemininityRestriction() != Femininity.MASCULINE) continue;
                    commonClothingMapMale.get((Object)ct.getEquipSlots().get(0)).add(ct);
                    commonClothingMapMaleIncludingAndrogynous.get((Object)ct.getEquipSlots().get(0)).add(ct);
                }
                catch (Exception ex) {
                    System.err.println("Loading clothing failed at 'ClothingType'. File path: " + entry3.getValue().getAbsolutePath());
                    System.err.println("Actual exception: ");
                    ex.printStackTrace(System.err);
                }
            }
        }
        Field[] fields = ClothingType.class.getFields();
        Field[] fieldArray = fields;
        int n = fieldArray.length;
        boolean bl = false;
        while (var5_18 < n) {
            Field f = fieldArray[var5_18];
            if (AbstractClothingType.class.isAssignableFrom(f.getType())) {
                try {
                    ct = (AbstractClothingType)f.get(null);
                    clothingToIdMap.put(ct, f.getName());
                    idToClothingMap.put(f.getName(), ct);
                    allClothing.add(ct);
                    if (!ct.isDefaultSlotCondom() && ct.getRarity() == Rarity.COMMON && !ct.getDefaultItemTags().contains((Object)ItemTag.NO_RANDOM_SPAWN)) {
                        commonClothingMap.get((Object)ct.getEquipSlots().get(0)).add(ct);
                        if (ct.getFemininityRestriction() == Femininity.FEMININE) {
                            commonClothingMapFemale.get((Object)ct.getEquipSlots().get(0)).add(ct);
                            commonClothingMapFemaleIncludingAndrogynous.get((Object)ct.getEquipSlots().get(0)).add(ct);
                        } else if (ct.getFemininityRestriction() == Femininity.ANDROGYNOUS || ct.getFemininityRestriction() == null) {
                            commonClothingMapAndrogynous.get((Object)ct.getEquipSlots().get(0)).add(ct);
                            commonClothingMapFemaleIncludingAndrogynous.get((Object)ct.getEquipSlots().get(0)).add(ct);
                            commonClothingMapMaleIncludingAndrogynous.get((Object)ct.getEquipSlots().get(0)).add(ct);
                        } else if (ct.getFemininityRestriction() == Femininity.MASCULINE) {
                            commonClothingMapMale.get((Object)ct.getEquipSlots().get(0)).add(ct);
                            commonClothingMapMaleIncludingAndrogynous.get((Object)ct.getEquipSlots().get(0)).add(ct);
                        }
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            ++var5_18;
        }
        setClothing = new HashMap<AbstractSetBonus, List<AbstractClothingType>>();
        for (AbstractClothingType abstractClothingType : allClothing) {
            if (abstractClothingType.getClothingSet() == null) continue;
            setClothing.putIfAbsent(abstractClothingType.getClothingSet(), new ArrayList());
            setClothing.get(abstractClothingType.getClothingSet()).add(abstractClothingType);
        }
        suitableFeminineClothing.put(Occupation.NPC_PROSTITUTE, Util.newArrayListOfValues(ClothingType.getClothingTypeFromId("innoxia_ankle_anklet"), ClothingType.getClothingTypeFromId("innoxia_chest_lacy_plunge_bra"), ClothingType.getClothingTypeFromId("innoxia_chest_open_cup_bra"), ClothingType.getClothingTypeFromId("innoxia_chest_plunge_bra"), ClothingType.getClothingTypeFromId("innoxia_eye_aviators"), ClothingType.getClothingTypeFromId("innoxia_finger_ring"), ClothingType.getClothingTypeFromId("innoxia_foot_chelsea_boots"), ClothingType.getClothingTypeFromId("innoxia_foot_ankle_boots"), ClothingType.getClothingTypeFromId("innoxia_foot_heels"), ClothingType.getClothingTypeFromId("innoxia_foot_thigh_high_boots"), ClothingType.getClothingTypeFromId("innoxia_foot_stiletto_heels"), ClothingType.getClothingTypeFromId("innoxia_groin_backless_panties"), ClothingType.getClothingTypeFromId("innoxia_groin_crotchless_panties"), ClothingType.getClothingTypeFromId("innoxia_groin_crotchless_thong"), ClothingType.getClothingTypeFromId("innoxia_groin_lacy_panties"), ClothingType.getClothingTypeFromId("innoxia_groin_thong"), ClothingType.getClothingTypeFromId("innoxia_groin_vstring"), ClothingType.getClothingTypeFromId("innoxia_hand_elbow_length_gloves"), ClothingType.getClothingTypeFromId("innoxia_head_headband"), ClothingType.getClothingTypeFromId("innoxia_head_headband_bow"), ClothingType.getClothingTypeFromId("innoxia_leg_crotchless_chaps"), ClothingType.getClothingTypeFromId("innoxia_leg_micro_skirt_belted"), ClothingType.getClothingTypeFromId("innoxia_leg_micro_skirt_pleated"), ClothingType.getClothingTypeFromId("innoxia_leg_mini_skirt"), ClothingType.getClothingTypeFromId("innoxia_leg_skirt"), ClothingType.getClothingTypeFromId("innoxia_neck_heart_necklace"), ClothingType.getClothingTypeFromId("innoxia_neck_ankh_necklace"), ClothingType.getClothingTypeFromId("innoxia_tape_roll"), ClothingType.getClothingTypeFromId("innoxia_hand_fishnet_gloves"), ClothingType.getClothingTypeFromId("innoxia_sock_fishnets"), ClothingType.getClothingTypeFromId("innoxia_sock_pantyhose"), ClothingType.getClothingTypeFromId("innoxia_stomach_overbust_corset"), ClothingType.getClothingTypeFromId("innoxia_stomach_underbust_corset"), ClothingType.getClothingTypeFromId("innoxia_torso_fishnet_top"), ClothingType.getClothingTypeFromId("innoxia_torso_keyhole_croptop"), ClothingType.getClothingTypeFromId("innoxia_torso_short_croptop"), ClothingType.getClothingTypeFromId("innoxia_wrist_bangle"), WRIST_WOMENS_WATCH, ClothingType.getClothingTypeFromId("innoxia_piercing_ear_ring"), ClothingType.getClothingTypeFromId("innoxia_piercing_lip_double_ring"), ClothingType.getClothingTypeFromId("innoxia_piercing_gemstone_barbell"), ClothingType.getClothingTypeFromId("innoxia_piercing_basic_barbell_pair"), ClothingType.getClothingTypeFromId("innoxia_piercing_nose_ring"), ClothingType.getClothingTypeFromId("innoxia_piercing_penis_ring"), ClothingType.getClothingTypeFromId("innoxia_piercing_basic_barbell"), ClothingType.getClothingTypeFromId("innoxia_piercing_ringed_barbell")));
    }
}

