/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory.enchanting;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.Game;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractTailType;
import com.lilithsthrone.game.character.body.types.TailType;
import com.lilithsthrone.game.character.body.valueEnums.LegConfiguration;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.character.race.RacialBody;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.enchanting.AbstractItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectTimer;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.game.inventory.enchanting.TFPotency;
import com.lilithsthrone.game.settings.DifficultyLevel;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.XMLSaving;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ItemEffect
implements XMLSaving {
    public static final int SEALED_COST_MINOR_BOOST = 5;
    public static final int SEALED_COST_MINOR_DRAIN = 25;
    public static final int SEALED_COST_DRAIN = 100;
    public static final int SEALED_COST_MAJOR_DRAIN = 500;
    public static final int SEALED_COST_SPECIAL = 1000000;
    private AbstractItemEffectType itemEffectType;
    private TFModifier primaryModifier;
    private TFModifier secondaryModifier;
    private TFPotency potency;
    private int limit;
    private ItemEffectTimer timer;

    public ItemEffect(AbstractItemEffectType itemEffectType) {
        this.itemEffectType = itemEffectType;
        this.primaryModifier = null;
        this.secondaryModifier = null;
        this.potency = null;
        this.limit = 0;
        this.timer = new ItemEffectTimer();
    }

    public ItemEffect(AbstractItemEffectType itemEffectType, TFModifier primaryModifier, TFModifier secondaryModifier, TFPotency potency, int limit) {
        this.itemEffectType = itemEffectType;
        this.primaryModifier = primaryModifier;
        this.secondaryModifier = secondaryModifier;
        this.potency = potency;
        this.limit = limit;
        this.timer = new ItemEffectTimer();
    }

    public String getId() {
        return (this.itemEffectType == null ? "n" : this.itemEffectType.toString()) + (this.primaryModifier == null ? "n" : this.primaryModifier.toString()) + (this.secondaryModifier == null ? "n" : this.secondaryModifier.toString()) + (this.potency == null ? "n" : this.potency.toString()) + this.limit;
    }

    public boolean equals(Object o) {
        return o instanceof ItemEffect && (((ItemEffect)o).getItemEffectType() == null && this.itemEffectType == null || ((ItemEffect)o).getItemEffectType() != null && ((ItemEffect)o).getItemEffectType().equals(this.itemEffectType)) && ((ItemEffect)o).getPrimaryModifier() == this.primaryModifier && ((ItemEffect)o).getSecondaryModifier() == this.secondaryModifier && ((ItemEffect)o).getPotency() == this.potency && ((ItemEffect)o).getLimit() == this.limit;
    }

    public int hashCode() {
        int result = 17;
        if (this.itemEffectType != null) {
            result = 31 * result + this.itemEffectType.hashCode();
        }
        if (this.primaryModifier != null) {
            result = 31 * result + this.primaryModifier.hashCode();
        }
        if (this.secondaryModifier != null) {
            result = 31 * result + this.secondaryModifier.hashCode();
        }
        if (this.potency != null) {
            result = 31 * result + this.potency.hashCode();
        }
        result = 31 * result + this.limit;
        return result;
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element effect = doc.createElement("effect");
        parentElement.appendChild(effect);
        XMLUtil.addAttribute(doc, effect, "type", ItemEffectType.getIdFromItemEffectType(this.getItemEffectType()));
        XMLUtil.addAttribute(doc, effect, "mod1", this.getPrimaryModifier() == null ? "null" : this.getPrimaryModifier().toString());
        XMLUtil.addAttribute(doc, effect, "mod2", this.getSecondaryModifier() == null ? "null" : this.getSecondaryModifier().toString());
        XMLUtil.addAttribute(doc, effect, "potency", this.getPotency() == null ? "null" : this.getPotency().toString());
        XMLUtil.addAttribute(doc, effect, "limit", String.valueOf(this.getLimit()));
        XMLUtil.addAttribute(doc, effect, "timer", String.valueOf(this.getTimer().getSecondsPassed()));
        return effect;
    }

    public static ItemEffect loadFromXML(Element parentElement, Document doc) {
        ItemEffect ie;
        String secondaryMod;
        String primaryMod;
        String itemEffectType = parentElement.getAttribute("type");
        if (itemEffectType.isEmpty()) {
            itemEffectType = parentElement.getAttribute("itemEffectType");
        }
        if ((primaryMod = parentElement.getAttribute("mod1")).isEmpty()) {
            primaryMod = parentElement.getAttribute("primaryModifier");
        }
        if ((secondaryMod = parentElement.getAttribute("mod2")).isEmpty()) {
            secondaryMod = parentElement.getAttribute("secondaryModifier");
        }
        TFPotency loadedPotency = parentElement.getAttribute("potency").equals("null") ? null : TFPotency.valueOf(parentElement.getAttribute("potency"));
        switch (itemEffectType) {
            case "ATTRIBUTE_STRENGTH": 
            case "ATTRIBUTE_FITNESS": {
                itemEffectType = "ATTRIBUTE_PHYSIQUE";
                break;
            }
            case "ATTRIBUTE_INTELLIGENCE": {
                itemEffectType = "ATTRIBUTE_ARCANE";
            }
        }
        switch (primaryMod) {
            case "DAMAGE_ATTACK": 
            case "RESISTANCE_ATTACK": {
                return null;
            }
            case "CLOTHING_SEALING": {
                primaryMod = "CLOTHING_SPECIAL";
                secondaryMod = "CLOTHING_SEALING";
                break;
            }
            case "CLOTHING_ENSLAVEMENT": {
                primaryMod = "CLOTHING_SPECIAL";
                secondaryMod = "CLOTHING_ENSLAVEMENT";
                break;
            }
            case "TF_PENIS": {
                if (!Main.isVersionOlderThan(Game.loadingVersion, "0.3.5.1") || secondaryMod != "TF_MOD_SIZE_SECONDARY") break;
                secondaryMod = "TF_MOD_SIZE_TERTIARY";
                break;
            }
            case "CLOTHING_SPECIAL": {
                if (!Main.isVersionOlderThan(Game.loadingVersion, "0.4.10.10") || !secondaryMod.equalsIgnoreCase("CLOTHING_VIBRATION") && !secondaryMod.equalsIgnoreCase("CLOTHING_ORGASM_PREVENTION")) break;
                primaryMod = "CLOTHING_SEXUAL";
            }
        }
        switch (secondaryMod) {
            case "TF_MOD_FETISH_SEEDER": {
                secondaryMod = "TF_MOD_FETISH_IMPREGNATION";
                break;
            }
            case "TF_MOD_FETISH_BROODMOTHER": {
                secondaryMod = "TF_MOD_FETISH_PREGNANCY";
                break;
            }
            case "CRITICAL_CHANCE": {
                secondaryMod = "CRITICAL_DAMAGE";
                break;
            }
            case "CLOTHING_ANTI_SELF_TRANSFORMATION": {
                secondaryMod = "CLOTHING_SERVITUDE";
                break;
            }
            case "TF_MOD_ORIFICE_DEEP": {
                secondaryMod = "TF_MOD_DEPTH";
                break;
            }
            case "TF_MOD_ORIFICE_DEEP_2": {
                secondaryMod = "TF_MOD_DEPTH_2";
                break;
            }
            case "CLOTHING_SEALING": {
                if (loadedPotency != TFPotency.MAJOR_BOOST && loadedPotency != TFPotency.BOOST) break;
                loadedPotency = TFPotency.MINOR_BOOST;
            }
        }
        if (Main.isVersionOlderThan(Game.loadingVersion, "0.4.1") && itemEffectType == "TF_TAIL" && primaryMod == "TF_MOD_SIZE") {
            primaryMod = "TF_MOD_SIZE_SECONDARY";
        }
        try {
            TFModifier secondary;
            TFModifier primary = primaryMod.equals("null") || primaryMod.isEmpty() ? null : TFModifier.valueOf(primaryMod);
            TFModifier tFModifier = secondary = secondaryMod.equals("null") || secondaryMod.isEmpty() ? null : TFModifier.valueOf(secondaryMod);
            if (secondary != null && TFModifier.getWeaponMajorAttributeList().contains((Object)secondary)) {
                primary = TFModifier.CLOTHING_MAJOR_ATTRIBUTE;
            }
            if (!ItemEffectType.idToItemEffectTypeMap.containsKey(itemEffectType)) {
                return null;
            }
            ie = new ItemEffect(ItemEffectType.getItemEffectTypeFromId(itemEffectType), primary, secondary, loadedPotency, Integer.valueOf(parentElement.getAttribute("limit")));
        }
        catch (Exception ex) {
            System.err.println("(Minor error, can ignore.) Unable to import ItemEffect (" + primaryMod + ", " + secondaryMod + ") from" + doc.getDocumentURI());
            System.err.println(ex);
            return null;
        }
        try {
            String timerString = parentElement.getAttribute("timer");
            int time = 0;
            if (!timerString.isEmpty()) {
                time = Integer.valueOf(timerString);
            }
            if (Main.isVersionOlderThan(Game.loadingVersion, "0.2.6.5")) {
                int timer = time / 60;
                ie.getTimer().setSecondsPassed(timer * 60 + (int)(Main.game.getMinutesPassed() % 60L));
            } else if (Main.isVersionOlderThan(Game.loadingVersion, "0.3.0.6")) {
                ie.getTimer().setSecondsPassed(time * 60);
            } else {
                ie.getTimer().setSecondsPassed(time);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ie;
    }

    public String applyEffect(GameCharacter user, GameCharacter target, int secondsPassed) {
        this.timer.incrementSecondsPassed(secondsPassed);
        if (target != null && this.getItemEffectType() != ItemEffectType.CLOTHING && this.getItemEffectType() != ItemEffectType.TATTOO && this.getItemEffectType().getAssociatedRace() != Race.DEMON) {
            if (target.isDoll() && this.itemEffectType.getAssociatedRace() != null) {
                return UtilText.parse(target, "<p style='text-align:center;'>[style.colourDisabled(\u7531\u4e8e[npc.name]\u662f\u6027\u7231\u73a9\u5076\uff0c\u666e\u901a\u7684\u8f6c\u5316\u5bf9[npc.her]\u4e0d\u751f\u6548\u2026\u2026)]</p>", new ParserTag[0]);
            }
            if (!(target.getSubspeciesOverrideRace() != Race.DEMON && (target.isAbleToHaveRaceTransformed() || target.getRace() == Race.SLIME) || this.getSecondaryModifier() != TFModifier.TF_TYPE_1 && this.getSecondaryModifier() != TFModifier.TF_TYPE_2 && this.getSecondaryModifier() != TFModifier.TF_TYPE_3 && this.getSecondaryModifier() != TFModifier.TF_TYPE_4 && this.getSecondaryModifier() != TFModifier.TF_TYPE_5 && this.getSecondaryModifier() != TFModifier.TF_TYPE_6 && this.getSecondaryModifier() != TFModifier.TF_TYPE_7 && this.getSecondaryModifier() != TFModifier.TF_TYPE_8 && this.getSecondaryModifier() != TFModifier.TF_TYPE_9 && this.getSecondaryModifier() != TFModifier.TF_TYPE_10 && this.getSecondaryModifier() != TFModifier.TF_MOD_LEG_CONFIG_ARACHNID && this.getSecondaryModifier() != TFModifier.TF_MOD_LEG_CONFIG_BIPEDAL && this.getSecondaryModifier() != TFModifier.TF_MOD_LEG_CONFIG_CEPHALOPOD && this.getSecondaryModifier() != TFModifier.TF_MOD_LEG_CONFIG_AVIAN && this.getSecondaryModifier() != TFModifier.TF_MOD_LEG_CONFIG_TAIL && this.getSecondaryModifier() != TFModifier.TF_MOD_LEG_CONFIG_TAIL_LONG && this.getSecondaryModifier() != TFModifier.TF_MOD_LEG_CONFIG_TAUR && this.getSecondaryModifier() != TFModifier.REMOVAL)) {
                if (this.getSecondaryModifier() == TFModifier.TF_MOD_LEG_CONFIG_ARACHNID && (target.getLegType().isLegConfigurationAvailable(LegConfiguration.ARACHNID) || target.getLegType().getRace() == Race.DEMON)) {
                    return AbstractItemEffectType.getRacialEffect(target.getLegType().getRace(), this.getPrimaryModifier(), this.getSecondaryModifier(), this.getPotency(), user, target).applyEffect();
                }
                if (this.getSecondaryModifier() == TFModifier.TF_MOD_LEG_CONFIG_BIPEDAL && (target.getLegType().isLegConfigurationAvailable(LegConfiguration.BIPEDAL) || target.getLegType().getRace() == Race.DEMON)) {
                    return AbstractItemEffectType.getRacialEffect(target.getLegType().getRace(), this.getPrimaryModifier(), this.getSecondaryModifier(), this.getPotency(), user, target).applyEffect();
                }
                if (this.getSecondaryModifier() == TFModifier.TF_MOD_LEG_CONFIG_CEPHALOPOD && (target.getLegType().isLegConfigurationAvailable(LegConfiguration.CEPHALOPOD) || target.getLegType().getRace() == Race.DEMON)) {
                    return AbstractItemEffectType.getRacialEffect(target.getLegType().getRace(), this.getPrimaryModifier(), this.getSecondaryModifier(), this.getPotency(), user, target).applyEffect();
                }
                if (this.getSecondaryModifier() == TFModifier.TF_MOD_LEG_CONFIG_AVIAN && (target.getLegType().isLegConfigurationAvailable(LegConfiguration.AVIAN) || target.getLegType().getRace() == Race.DEMON)) {
                    return AbstractItemEffectType.getRacialEffect(target.getLegType().getRace(), this.getPrimaryModifier(), this.getSecondaryModifier(), this.getPotency(), user, target).applyEffect();
                }
                if (this.getSecondaryModifier() == TFModifier.TF_MOD_LEG_CONFIG_TAIL && (target.getLegType().isLegConfigurationAvailable(LegConfiguration.TAIL) || target.getLegType().getRace() == Race.DEMON)) {
                    return AbstractItemEffectType.getRacialEffect(target.getLegType().getRace(), this.getPrimaryModifier(), this.getSecondaryModifier(), this.getPotency(), user, target).applyEffect();
                }
                if (this.getSecondaryModifier() == TFModifier.TF_MOD_LEG_CONFIG_TAIL_LONG && (target.getLegType().isLegConfigurationAvailable(LegConfiguration.TAIL_LONG) || target.getLegType().getRace() == Race.DEMON)) {
                    return AbstractItemEffectType.getRacialEffect(target.getLegType().getRace(), this.getPrimaryModifier(), this.getSecondaryModifier(), this.getPotency(), user, target).applyEffect();
                }
                if (this.getSecondaryModifier() == TFModifier.TF_MOD_LEG_CONFIG_TAUR && (target.getLegType().isLegConfigurationAvailable(LegConfiguration.QUADRUPEDAL) || target.getLegType().getRace() == Race.DEMON)) {
                    return AbstractItemEffectType.getRacialEffect(target.getLegType().getRace(), this.getPrimaryModifier(), this.getSecondaryModifier(), this.getPotency(), user, target).applyEffect();
                }
                TFModifier secondaryMod = this.getSecondaryModifier();
                if (secondaryMod == TFModifier.TF_TYPE_2 || secondaryMod == TFModifier.TF_TYPE_3 || secondaryMod == TFModifier.TF_TYPE_4 || secondaryMod == TFModifier.TF_TYPE_5 || secondaryMod == TFModifier.TF_TYPE_6 || secondaryMod == TFModifier.TF_TYPE_7 || secondaryMod == TFModifier.TF_TYPE_8 || secondaryMod == TFModifier.TF_TYPE_9 || secondaryMod == TFModifier.TF_TYPE_10) {
                    secondaryMod = TFModifier.TF_TYPE_1;
                }
                if (target.getSubspeciesOverride() == Subspecies.HALF_DEMON) {
                    AbstractSubspecies halfSubspecies = target.getHalfDemonSubspecies();
                    switch (this.getPrimaryModifier()) {
                        case TF_EARS: 
                        case TF_HAIR: {
                            if (halfSubspecies == Subspecies.HUMAN) {
                                return AbstractItemEffectType.getRacialEffect(Race.DEMON, this.getPrimaryModifier(), secondaryMod, this.getPotency(), user, target).applyEffect();
                            }
                            return AbstractItemEffectType.getRacialEffect(halfSubspecies.getRace(), this.getPrimaryModifier(), secondaryMod, this.getPotency(), user, target).applyEffect();
                        }
                        case TF_EYES: {
                            return AbstractItemEffectType.getRacialEffect(Race.DEMON, this.getPrimaryModifier(), secondaryMod, this.getPotency(), user, target).applyEffect();
                        }
                        case TF_ANTENNA: 
                        case TF_ARMS: 
                        case TF_CORE: 
                        case TF_FACE: 
                        case TF_LEGS: 
                        case TF_SKIN: {
                            return AbstractItemEffectType.getRacialEffect(halfSubspecies.getRace(), this.getPrimaryModifier(), secondaryMod, this.getPotency(), user, target).applyEffect();
                        }
                        case TF_TAIL: {
                            List<AbstractTailType> tailTypes = RacialBody.valueOfRace(halfSubspecies.getRace()).getTailType();
                            if (tailTypes.size() == 1 && tailTypes.get(0) == TailType.NONE) {
                                return AbstractItemEffectType.getRacialEffect(Race.DEMON, this.getPrimaryModifier(), secondaryMod, this.getPotency(), user, target).applyEffect();
                            }
                            return AbstractItemEffectType.getRacialEffect(halfSubspecies.getRace(), this.getPrimaryModifier(), secondaryMod, this.getPotency(), user, target).applyEffect();
                        }
                        case TF_ASS: 
                        case TF_BREASTS: 
                        case TF_BREASTS_CROTCH: 
                        case TF_HORNS: 
                        case TF_PENIS: 
                        case TF_VAGINA: 
                        case TF_WINGS: 
                        case TF_TENTACLE: {
                            return AbstractItemEffectType.getRacialEffect(Race.DEMON, this.getPrimaryModifier(), secondaryMod, this.getPotency(), user, target).applyEffect();
                        }
                    }
                }
                return AbstractItemEffectType.getRacialEffect(target.getRace() == Race.SLIME ? target.getFleshSubspecies().getRace() : target.getRace(), this.getPrimaryModifier(), secondaryMod, this.getPotency(), user, target).applyEffect();
            }
        }
        return this.getItemEffectType().applyEffect(this.getPrimaryModifier(), this.getSecondaryModifier(), this.getPotency(), this.getLimit(), user, target, this.timer);
    }

    public List<String> getEffectsDescription(GameCharacter user, GameCharacter target) {
        return this.getItemEffectType().getEffectsDescription(this.getPrimaryModifier(), this.getSecondaryModifier(), this.getPotency(), this.getLimit(), user, target);
    }

    public int getCost() {
        int cost = 1;
        if (this.getPrimaryModifier() != null && this.getPrimaryModifier() != TFModifier.NONE) {
            cost += this.getPrimaryModifier().getValue();
        }
        if (this.getSecondaryModifier() != null && this.getSecondaryModifier() != TFModifier.NONE) {
            cost += this.getSecondaryModifier().getValue();
        }
        if (this.potency != null) {
            cost += this.potency.getValue();
        }
        if (this.getLimit() != -1) {
            ++cost;
        }
        return cost;
    }

    public AbstractItemEffectType getItemEffectType() {
        return this.itemEffectType;
    }

    public void setItemEffectType(AbstractItemEffectType itemEffectType) {
        this.itemEffectType = itemEffectType;
    }

    public TFModifier getPrimaryModifier() {
        return this.primaryModifier;
    }

    public void setPrimaryModifier(TFModifier primaryModifier) {
        this.primaryModifier = primaryModifier;
    }

    public TFModifier getSecondaryModifier() {
        return this.secondaryModifier;
    }

    public void setSecondaryModifier(TFModifier secondaryModifier) {
        this.secondaryModifier = secondaryModifier;
    }

    public TFPotency getPotency() {
        return this.potency;
    }

    public void setPotency(TFPotency potency) {
        this.potency = potency;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public ItemEffectTimer getTimer() {
        return this.timer;
    }

    public void setTimer(ItemEffectTimer timer) {
        this.timer = timer;
    }

    public static ItemEffect getDefaultSealEffect() {
        int scalingFactor;
        TFPotency potency = TFPotency.MINOR_BOOST;
        int level = Main.game.getPlayer().getLevel();
        if (Main.getProperties().difficultyLevel != DifficultyLevel.NORMAL && (scalingFactor = level - (Util.random.nextInt(20) + 1)) > 0) {
            potency = scalingFactor > 25 ? TFPotency.MAJOR_DRAIN : (scalingFactor > 10 ? TFPotency.DRAIN : TFPotency.MINOR_DRAIN);
        }
        if (potency == TFPotency.MINOR_BOOST && level >= 5) {
            double random = Math.random();
            if (random < 0.01) {
                potency = TFPotency.MAJOR_DRAIN;
            } else if (random < 0.05) {
                potency = TFPotency.DRAIN;
            } else if (random < 0.25) {
                potency = TFPotency.MINOR_DRAIN;
            }
        }
        return new ItemEffect(ItemEffectType.CLOTHING, TFModifier.CLOTHING_SPECIAL, TFModifier.CLOTHING_SEALING, potency, 0);
    }
}

