/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory.enchanting;

import com.lilithsthrone.game.character.markings.AbstractTattooType;
import com.lilithsthrone.game.character.markings.Tattoo;
import com.lilithsthrone.game.dialogue.utils.EnchantmentDialogue;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.AbstractClothingType;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.item.AbstractItemType;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.game.inventory.weapon.AbstractWeaponType;
import com.lilithsthrone.main.Main;
import java.util.ArrayList;
import java.util.List;

public class LoadedEnchantment {
    private String name;
    private AbstractItemType itemType;
    private AbstractClothingType clothingType;
    private AbstractWeaponType weaponType;
    private AbstractTattooType tattooType;
    private List<ItemEffect> effects;

    public LoadedEnchantment(String name, AbstractItemType itemType, List<ItemEffect> effects) {
        this.name = name;
        this.itemType = itemType;
        this.clothingType = null;
        this.weaponType = null;
        this.tattooType = null;
        this.effects = effects;
    }

    public LoadedEnchantment(String name, AbstractClothingType clothingType, List<ItemEffect> effects) {
        this.name = name;
        this.itemType = null;
        this.clothingType = clothingType;
        this.weaponType = null;
        this.tattooType = null;
        this.effects = effects;
    }

    public LoadedEnchantment(String name, AbstractWeaponType weaponType, List<ItemEffect> effects) {
        this.name = name;
        this.itemType = null;
        this.clothingType = null;
        this.weaponType = weaponType;
        this.tattooType = null;
        this.effects = effects;
    }

    public LoadedEnchantment(String name, AbstractTattooType tattooType, List<ItemEffect> effects) {
        this.name = name;
        this.itemType = null;
        this.clothingType = null;
        this.weaponType = null;
        this.tattooType = tattooType;
        this.effects = effects;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSuitableItemAvailable() {
        return this.getSuitableItem() != null;
    }

    public AbstractCoreItem getSuitableItem() {
        if (this.itemType != null) {
            for (AbstractItem item : Main.game.getPlayer().getAllItemsInInventory().keySet()) {
                if (!item.getItemType().equals(this.itemType)) continue;
                return item;
            }
        } else if (this.clothingType != null) {
            ArrayList<AbstractClothing> clothingList = new ArrayList<AbstractClothing>();
            for (AbstractClothing c : Main.game.getPlayer().getAllClothingInInventory().keySet()) {
                if (!c.getClothingType().equals(this.clothingType) || !c.isEnchantmentKnown()) continue;
                if (c.getEffects().isEmpty()) {
                    return c;
                }
                clothingList.add(c);
            }
            if (!clothingList.isEmpty()) {
                return (AbstractCoreItem)clothingList.get(0);
            }
        } else if (this.weaponType != null) {
            ArrayList<AbstractWeapon> weaponList = new ArrayList<AbstractWeapon>();
            for (AbstractWeapon w : Main.game.getPlayer().getAllWeaponsInInventory().keySet()) {
                if (!w.getWeaponType().equals(this.weaponType)) continue;
                if (w.getEffects().isEmpty()) {
                    return w;
                }
                weaponList.add(w);
            }
            if (!weaponList.isEmpty()) {
                return (AbstractCoreItem)weaponList.get(0);
            }
        } else if (this.tattooType != null) {
            return EnchantmentDialogue.getIngredient();
        }
        return null;
    }

    public String getSVGString() {
        AbstractCoreItem item = this.getSuitableItem();
        if (this.itemType != null) {
            if (item != null) {
                return ((AbstractItem)item).getSVGString();
            }
            return this.itemType.getSVGString();
        }
        if (this.clothingType != null) {
            if (item != null) {
                return ((AbstractClothing)item).getSVGString();
            }
            return this.clothingType.getSVGImage();
        }
        if (this.weaponType != null) {
            if (item != null) {
                return ((AbstractWeapon)item).getSVGString();
            }
            return this.weaponType.getSVGImage();
        }
        if (this.tattooType != null) {
            return ((Tattoo)item).getSVGString();
        }
        return "";
    }

    public AbstractItemType getItemType() {
        return this.itemType;
    }

    public AbstractClothingType getClothingType() {
        return this.clothingType;
    }

    public AbstractWeaponType getWeaponType() {
        return this.weaponType;
    }

    public AbstractTattooType getTattooType() {
        return this.tattooType;
    }

    public List<ItemEffect> getEffects() {
        return this.effects;
    }
}

