/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory.enchanting;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.AbstractClothingType;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.game.inventory.enchanting.TFPotency;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.Document;

public class RandomEnchantment {
    private boolean positiveEnchantment;
    private boolean applyDefaultSeal;
    private String spawnWeighting;
    private String namePrefix;
    private String namePostfix;
    private String nameOverride;
    private String conditionalPreParsing;
    private List<Util.Value<String, List<ItemEffect>>> effects;
    private static List<RandomEnchantment> allPositiveClothingEnchantments = new ArrayList<RandomEnchantment>();
    private static List<RandomEnchantment> allNegativeClothingEnchantments = new ArrayList<RandomEnchantment>();

    public RandomEnchantment(boolean positiveEnchantment, boolean applyDefaultSeal, String spawnWeighting, String namePrefix, String namePostfix, String nameOverride, List<TFPotency> sealPotency, String conditionalPreParsing, List<Util.Value<String, List<ItemEffect>>> effects) {
        this.positiveEnchantment = positiveEnchantment;
        this.applyDefaultSeal = applyDefaultSeal;
        this.spawnWeighting = spawnWeighting;
        this.namePrefix = namePrefix;
        this.namePostfix = namePostfix;
        this.nameOverride = nameOverride;
        this.conditionalPreParsing = conditionalPreParsing;
        this.effects = effects;
    }

    public RandomEnchantment(File file) {
        if (file.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(file);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(file);
                this.positiveEnchantment = false;
                if (coreElement.getOptionalFirstOf("positiveEnchantment").isPresent()) {
                    try {
                        this.positiveEnchantment = Boolean.valueOf(coreElement.getMandatoryFirstOf("positiveEnchantment").getTextContent());
                    }
                    catch (Exception ex) {
                        System.err.println("RandomEnchantment loading error in '" + file.getName() + "': positiveEnchantment");
                    }
                }
                this.applyDefaultSeal = true;
                if (coreElement.getOptionalFirstOf("applyDefaultSeal").isPresent()) {
                    try {
                        this.applyDefaultSeal = Boolean.valueOf(coreElement.getMandatoryFirstOf("applyDefaultSeal").getTextContent());
                    }
                    catch (Exception ex) {
                        System.err.println("RandomEnchantment loading error in '" + file.getName() + "': applyDefaultSeal");
                    }
                }
                this.spawnWeighting = "";
                if (coreElement.getOptionalFirstOf("spawnWeighting").isPresent()) {
                    try {
                        this.spawnWeighting = coreElement.getMandatoryFirstOf("spawnWeighting").getTextContent();
                    }
                    catch (Exception ex) {
                        System.err.println("RandomEnchantment loading error in '" + file.getName() + "': spawnWeighting");
                    }
                }
                this.namePrefix = null;
                this.namePostfix = null;
                this.nameOverride = null;
                if (coreElement.getOptionalFirstOf("namePrefix").isPresent()) {
                    this.namePrefix = coreElement.getMandatoryFirstOf("namePrefix").getTextContent().trim();
                }
                if (coreElement.getOptionalFirstOf("namePostfix").isPresent()) {
                    this.namePostfix = coreElement.getMandatoryFirstOf("namePostfix").getTextContent().trim();
                }
                if (coreElement.getOptionalFirstOf("nameOverride").isPresent()) {
                    this.nameOverride = coreElement.getMandatoryFirstOf("nameOverride").getTextContent().trim();
                }
                this.conditionalPreParsing = "";
                if (coreElement.getOptionalFirstOf("conditionalPreParsing").isPresent()) {
                    this.conditionalPreParsing = coreElement.getMandatoryFirstOf("conditionalPreParsing").getTextContent().trim();
                }
                this.effects = new ArrayList<Util.Value<String, List<ItemEffect>>>();
                for (Element e : coreElement.getAllOf("itemEffects")) {
                    try {
                        String conditional = "true";
                        if (e.getOptionalFirstOf("conditional").isPresent()) {
                            conditional = e.getMandatoryFirstOf("conditional").getTextContent();
                        }
                        ArrayList<ItemEffect> effectsList = new ArrayList<ItemEffect>();
                        for (Element effectElement : e.getAllOf("effect")) {
                            ItemEffect effect = ItemEffect.loadFromXML(effectElement.getInnerElement(), doc);
                            effect.getTimer().setSecondsPassed(0);
                            effectsList.add(effect);
                        }
                        this.effects.add(new Util.Value(conditional, effectsList));
                    }
                    catch (Exception ex) {
                        System.err.println("RandomEnchantment loading error in '" + file.getName() + "': effects");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean equals(Object o) {
        return o instanceof RandomEnchantment && ((RandomEnchantment)o).positiveEnchantment == this.positiveEnchantment && ((RandomEnchantment)o).applyDefaultSeal == this.applyDefaultSeal && Objects.equals(((RandomEnchantment)o).spawnWeighting, this.spawnWeighting) && Objects.equals(((RandomEnchantment)o).namePrefix, this.namePrefix) && Objects.equals(((RandomEnchantment)o).namePostfix, this.namePostfix) && Objects.equals(((RandomEnchantment)o).nameOverride, this.nameOverride) && Objects.equals(((RandomEnchantment)o).conditionalPreParsing, this.conditionalPreParsing) && Objects.equals(((RandomEnchantment)o).effects, this.effects);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.positiveEnchantment ? 1 : 0);
        result = 31 * result + (this.applyDefaultSeal ? 1 : 0);
        result = 31 * result + this.spawnWeighting.hashCode();
        if (this.namePrefix != null) {
            result = 31 * result + this.namePrefix.hashCode();
        }
        if (this.namePostfix != null) {
            result = 31 * result + this.namePostfix.hashCode();
        }
        if (this.nameOverride != null) {
            result = 31 * result + this.nameOverride.hashCode();
        }
        if (this.conditionalPreParsing != null) {
            result = 31 * result + this.conditionalPreParsing.hashCode();
        }
        result = 31 * result + this.effects.hashCode();
        return result;
    }

    public boolean isPositiveEnchantment() {
        return this.positiveEnchantment;
    }

    public boolean isAvailable(AbstractClothingType clothingType) {
        return this.getWeighting(clothingType) > 0;
    }

    public int getWeighting(AbstractClothingType clothingType) {
        UtilText.setClothingTypeForParsing(clothingType);
        return Integer.valueOf(UtilText.parse(this.spawnWeighting, new ParserTag[0]).trim());
    }

    public String getName(AbstractClothingType clothingType) {
        if (this.nameOverride != null && !this.nameOverride.isEmpty()) {
            return this.nameOverride;
        }
        StringBuilder sb = new StringBuilder();
        if (this.namePrefix != null && !this.namePrefix.isEmpty()) {
            sb.append(this.namePrefix + this.namePostfix);
        }
        sb.append(clothingType.getName());
        if (this.namePostfix != null && !this.namePostfix.isEmpty()) {
            sb.append("");
        }
        return sb.toString();
    }

    public void executeConditionalPreParsing(AbstractClothing clothing) {
        UtilText.setClothingTypeForParsing(clothing.getClothingType());
        UtilText.parse(this.conditionalPreParsing, new ParserTag[0]);
    }

    public void applyEffects(AbstractClothing clothing) {
        AbstractClothingType type = clothing.getClothingType();
        clothing.clearEffects();
        UtilText.setClothingTypeForParsing(type);
        this.executeConditionalPreParsing(clothing);
        clothing.setHiddenName(UtilText.parse(this.getName(type), new ParserTag[0]));
        boolean increaseTFStrength = false;
        for (Util.Value<String, List<ItemEffect>> entry : this.effects) {
            if (!Boolean.valueOf(UtilText.parse(entry.getKey(), new ParserTag[0]).trim()).booleanValue()) continue;
            for (ItemEffect effect : entry.getValue()) {
                if (increaseTFStrength && TFModifier.getTFRacialBodyPartsList().contains((Object)effect.getPrimaryModifier())) {
                    effect.setPotency(TFPotency.MAJOR_BOOST);
                }
                clothing.addEffect(effect);
            }
        }
        if (!(this.positiveEnchantment || !this.applyDefaultSeal && clothing.isSealed())) {
            clothing.addEffect(ItemEffect.getDefaultSealEffect());
        }
    }

    public static List<RandomEnchantment> getAllPositiveClothingEnchantments() {
        return new ArrayList<RandomEnchantment>(allPositiveClothingEnchantments);
    }

    public static List<RandomEnchantment> getAllNegativeClothingEnchantments() {
        return new ArrayList<RandomEnchantment>(allNegativeClothingEnchantments);
    }

    public static void initAllRandomEnchantments() {
        allPositiveClothingEnchantments = new ArrayList<RandomEnchantment>();
        allNegativeClothingEnchantments = new ArrayList<RandomEnchantment>();
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/randomEnchantments");
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                try {
                    RandomEnchantment enchantment = new RandomEnchantment(innerEntry.getValue()){};
                    if (enchantment.isPositiveEnchantment()) {
                        allPositiveClothingEnchantments.add(enchantment);
                        continue;
                    }
                    allNegativeClothingEnchantments.add(enchantment);
                }
                catch (Exception ex) {
                    System.err.println("Loading RandomEnchantment failed at 'getAllRandomEnchantments' (RES). File path: " + innerEntry.getValue().getAbsolutePath());
                    System.err.println("Actual exception: ");
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/randomEnchantments");
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                try {
                    RandomEnchantment enchantment = new RandomEnchantment(innerEntry.getValue()){};
                    if (enchantment.isPositiveEnchantment()) {
                        allPositiveClothingEnchantments.add(enchantment);
                        continue;
                    }
                    allNegativeClothingEnchantments.add(enchantment);
                }
                catch (Exception ex) {
                    System.err.println("Loading RandomEnchantment failed at 'getAllRandomEnchantments' (MODS). File path: " + innerEntry.getValue().getAbsolutePath());
                    System.err.println("Actual exception: ");
                    ex.printStackTrace(System.err);
                }
            }
        }
    }

    static {
        RandomEnchantment.initAllRandomEnchantments();
    }
}

