/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory.item;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.controller.xmlParsing.XMLLoadException;
import com.lilithsthrone.controller.xmlParsing.XMLMissingTagException;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AbstractAttribute;
import com.lilithsthrone.game.character.effects.AbstractStatusEffect;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.character.race.AbstractRace;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreType;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.Rarity;
import com.lilithsthrone.game.inventory.enchanting.AbstractItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectType;
import com.lilithsthrone.game.inventory.item.ItemType;
import com.lilithsthrone.game.inventory.item.SvgInformation;
import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractItemType
extends AbstractCoreType {
    private String determiner;
    private String name;
    private String namePlural;
    private String description;
    private String useDescriptor;
    private String authorDescription;
    private boolean sexUse;
    private boolean combatUseAllies;
    private boolean combatUseEnemies;
    private boolean consumedOnUse;
    private boolean breakOutOfInventory;
    private Rarity rarity;
    private int value;
    private boolean plural;
    private boolean mod;
    private boolean fromExternalFile;
    private List<SvgInformation> svgPathInformation;
    private List<Colour> colourShades;
    protected String SVGString;
    protected List<String> effectTooltipLines;
    protected String specialEffect;
    protected List<String> useDescriptionsSelf;
    protected List<String> useDescriptionsOther;
    protected List<ItemEffect> effects;
    protected Map<AbstractStatusEffect, Util.Value<String, Integer>> appliedStatusEffects;
    protected String potionDescriptor;
    protected AbstractRace associatedRace;
    protected String enchantmentEffectId;
    protected String enchantmentItemTypeId;
    protected Set<ItemTag> itemTags;

    public AbstractItemType(int value, String determiner, boolean plural, String name, String namePlural, String description, String pathName, Colour colourPrimary, Colour colourSecondary, Colour colourTertiary, Rarity rarity, List<ItemEffect> effects, List<ItemTag> itemTags) {
        this(value, determiner, plural, name, namePlural, description, pathName, AbstractItemType.initNewColourShades(colourPrimary, colourSecondary, colourTertiary), rarity, effects, itemTags);
    }

    public AbstractItemType(int value, String determiner, boolean plural, String name, String namePlural, String description, String pathName, List<Colour> colourShades, Rarity rarity, List<ItemEffect> effects, List<ItemTag> itemTags) {
        this.determiner = determiner;
        this.plural = plural;
        this.mod = false;
        this.fromExternalFile = false;
        this.name = name;
        this.namePlural = namePlural;
        this.description = description;
        this.useDescriptor = "\u4f7f\u7528";
        this.svgPathInformation = Util.newArrayListOfValues(new SvgInformation(1, pathName == null ? "" : pathName, 100, 0, new HashMap<String, String>()));
        this.authorDescription = "";
        this.sexUse = true;
        this.combatUseAllies = true;
        this.combatUseEnemies = false;
        this.consumedOnUse = true;
        this.breakOutOfInventory = false;
        this.value = value;
        this.rarity = rarity;
        this.itemTags = new HashSet<ItemTag>();
        if (itemTags != null) {
            this.itemTags.addAll(itemTags);
        }
        this.effectTooltipLines = new ArrayList<String>();
        this.useDescriptionsSelf = Util.newArrayListOfValues("[npc.Name]\u4f7f\u7528\u4e86\u8be5\u7269\u54c1\u3002");
        this.useDescriptionsOther = Util.newArrayListOfValues("[npc.Name]\u5bf9[npc2.name]\u4f7f\u7528\u4e86\u8be5\u7269\u54c1\u3002");
        this.specialEffect = "";
        this.effects = effects == null ? new ArrayList<ItemEffect>() : effects;
        this.potionDescriptor = "";
        this.associatedRace = Race.NONE;
        this.enchantmentEffectId = null;
        this.enchantmentItemTypeId = null;
        this.colourShades = colourShades;
        this.SVGString = null;
    }

    private static List<Colour> initNewColourShades(Colour colourPrimary, Colour colourSecondary, Colour colourTertiary) {
        ArrayList<Colour> newColourShades = new ArrayList<Colour>();
        if (colourPrimary == null) {
            newColourShades.add(PresetColour.CLOTHING_BLACK);
        } else {
            newColourShades.add(colourPrimary);
        }
        if (colourSecondary == null) {
            newColourShades.add(PresetColour.CLOTHING_BLACK);
        } else {
            newColourShades.add(colourSecondary);
        }
        if (colourTertiary == null) {
            newColourShades.add(PresetColour.CLOTHING_BLACK);
        } else {
            newColourShades.add(colourTertiary);
        }
        return newColourShades;
    }

    public AbstractItemType(File itemXMLFile, String author, boolean mod) throws XMLLoadException {
        boolean debug = false;
        try {
            Element itemElement = Element.getDocumentRootElement(itemXMLFile);
            Element coreAttributes = null;
            try {
                coreAttributes = itemElement.getMandatoryFirstOf("coreAtributes");
            }
            catch (XMLMissingTagException ex) {
                coreAttributes = itemElement.getMandatoryFirstOf("coreAttributes");
            }
            if (debug) {
                System.out.println("1");
            }
            this.mod = mod;
            this.fromExternalFile = true;
            this.name = coreAttributes.getMandatoryFirstOf("name").getTextContent();
            this.namePlural = coreAttributes.getMandatoryFirstOf("namePlural").getTextContent();
            this.description = coreAttributes.getMandatoryFirstOf("description").getTextContent();
            this.useDescriptor = coreAttributes.getMandatoryFirstOf("useDescriptor").getTextContent();
            this.plural = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("namePlural").getAttribute("pluralByDefault"));
            this.value = Integer.valueOf(coreAttributes.getMandatoryFirstOf("value").getTextContent());
            this.rarity = Rarity.valueOf(coreAttributes.getMandatoryFirstOf("rarity").getTextContent());
            this.authorDescription = coreAttributes.getOptionalFirstOf("authorTag").isPresent() ? coreAttributes.getMandatoryFirstOf("authorTag").getTextContent() : (!author.equalsIgnoreCase("innoxia") ? "\u5c0f\u5fc3\u5730\u8d34\u5728" + (this.plural ? this.namePlural : this.name) + "\u4e0a\u9762\u7684\u6807\u7b7e\u544a\u8bc9\u4f60\u8fd9\u662f\u7531\u201c" + Util.capitaliseSentence(author) + "\u201d\u6240\u5236\u4f5c\u3002" : "");
            this.sexUse = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("sexUse").getTextContent());
            this.combatUseAllies = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("combatUseAllies").getTextContent());
            this.combatUseEnemies = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("combatUseEnemies").getTextContent());
            this.consumedOnUse = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("consumedOnUse").getTextContent());
            this.breakOutOfInventory = false;
            if (coreAttributes.getOptionalFirstOf("breakOutOfInventory").isPresent()) {
                this.breakOutOfInventory = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("breakOutOfInventory").getTextContent());
            }
            this.svgPathInformation = new ArrayList<SvgInformation>();
            for (Element imagePathElement : coreAttributes.getAllOf("imageName")) {
                String rawPath = imagePathElement.getTextContent();
                Object pathName = rawPath.contains("res/") ? rawPath : itemXMLFile.getParentFile().getAbsolutePath() + "/" + imagePathElement.getTextContent();
                int zLayer = 1;
                int imageSize = 100;
                int imageRotation = 0;
                HashMap<String, String> replacements = new HashMap<String, String>();
                if (!imagePathElement.getAttribute("zLayer").isEmpty()) {
                    try {
                        zLayer = Integer.valueOf(imagePathElement.getAttribute("zLayer"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!imagePathElement.getAttribute("imageSize").isEmpty()) {
                    try {
                        imageSize = Math.min(100, Math.max(1, Integer.valueOf(imagePathElement.getAttribute("imageSize"))));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!imagePathElement.getAttribute("imageRotation").isEmpty()) {
                    try {
                        imageRotation = Math.min(360, Math.max(-360, Integer.valueOf(imagePathElement.getAttribute("imageRotation"))));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                int i = 1;
                while (!imagePathElement.getAttribute("target" + i).isEmpty()) {
                    replacements.put(imagePathElement.getAttribute("target" + i), imagePathElement.getAttribute("replacement" + i));
                    ++i;
                }
                this.svgPathInformation.add(new SvgInformation(zLayer, (String)pathName, imageSize, imageRotation, replacements));
            }
            this.SVGString = null;
            Colour colourShade = PresetColour.getColourFromId(coreAttributes.getMandatoryFirstOf("colourPrimary").getTextContent());
            Colour colourShadeSecondary = null;
            if (coreAttributes.getOptionalFirstOf("colourSecondary").isPresent() && !coreAttributes.getMandatoryFirstOf("colourSecondary").getTextContent().isEmpty()) {
                colourShadeSecondary = PresetColour.getColourFromId(coreAttributes.getMandatoryFirstOf("colourSecondary").getTextContent());
            }
            Colour colourShadeTertiary = null;
            if (coreAttributes.getOptionalFirstOf("colourTertiary").isPresent() && !coreAttributes.getMandatoryFirstOf("colourTertiary").getTextContent().isEmpty()) {
                colourShadeTertiary = PresetColour.getColourFromId(coreAttributes.getMandatoryFirstOf("colourTertiary").getTextContent());
            }
            this.colourShades = Util.newArrayListOfValues(colourShade, colourShadeSecondary, colourShadeTertiary);
            if (debug) {
                System.out.println("2");
            }
            this.effects = new ArrayList<ItemEffect>();
            this.itemTags = new HashSet<ItemTag>(Util.toEnumList(coreAttributes.getMandatoryFirstOf("itemTags").getAllOf("tag"), ItemTag.class));
            this.appliedStatusEffects = new HashMap<AbstractStatusEffect, Util.Value<String, Integer>>();
            if (this.getItemTags().contains((Object)ItemTag.FOOD)) {
                this.appliedStatusEffects.put(StatusEffect.RECENTLY_EATEN, new Util.Value<String, Integer>("true", 21600));
            }
            if (this.getItemTags().contains((Object)ItemTag.FOOD_POOR)) {
                this.appliedStatusEffects.put(StatusEffect.RECENTLY_EATEN_POOR, new Util.Value<String, Integer>("true", 21600));
            }
            if (this.getItemTags().contains((Object)ItemTag.FOOD_QUALITY)) {
                this.appliedStatusEffects.put(StatusEffect.RECENTLY_EATEN_QUALITY, new Util.Value<String, Integer>("true", 21600));
            }
            if (this.getItemTags().contains((Object)ItemTag.DRINK)) {
                this.appliedStatusEffects.put(StatusEffect.THIRST_QUENCHED, new Util.Value<String, Integer>("true", 21600));
            }
            if (this.getItemTags().contains((Object)ItemTag.DRINK_POOR)) {
                this.appliedStatusEffects.put(StatusEffect.THIRST_QUENCHED_POOR, new Util.Value<String, Integer>("true", 21600));
            }
            if (this.getItemTags().contains((Object)ItemTag.DRINK_QUALITY)) {
                this.appliedStatusEffects.put(StatusEffect.THIRST_QUENCHED_QUALITY, new Util.Value<String, Integer>("true", 21600));
            }
            if (coreAttributes.getOptionalFirstOf("statusEffects").isPresent()) {
                for (Element e : coreAttributes.getMandatoryFirstOf("statusEffects").getAllOf("effect")) {
                    int seconds = Integer.valueOf(e.getAttribute("seconds"));
                    AbstractStatusEffect se = StatusEffect.getStatusEffectFromId(e.getTextContent());
                    String conditional = e.getAttribute("conditional");
                    this.appliedStatusEffects.put(se, new Util.Value<String, Integer>(conditional.isEmpty() ? "true" : conditional, seconds));
                }
            }
            this.specialEffect = coreAttributes.getMandatoryFirstOf("applyEffects").getTextContent();
            this.potionDescriptor = coreAttributes.getOptionalFirstOf("potionDescriptor").isPresent() ? coreAttributes.getMandatoryFirstOf("potionDescriptor").getTextContent() : "";
            this.associatedRace = coreAttributes.getOptionalFirstOf("associatedRace").isPresent() && !coreAttributes.getMandatoryFirstOf("associatedRace").getTextContent().isEmpty() ? Race.getRaceFromId(coreAttributes.getMandatoryFirstOf("associatedRace").getTextContent()) : Race.NONE;
            this.enchantmentEffectId = coreAttributes.getOptionalFirstOf("enchantmentEffectId").isPresent() && !coreAttributes.getMandatoryFirstOf("enchantmentEffectId").getTextContent().isEmpty() ? coreAttributes.getMandatoryFirstOf("enchantmentEffectId").getTextContent() : null;
            this.enchantmentItemTypeId = coreAttributes.getOptionalFirstOf("enchantmentItemTypeId").isPresent() && !coreAttributes.getMandatoryFirstOf("enchantmentItemTypeId").getTextContent().isEmpty() ? coreAttributes.getMandatoryFirstOf("enchantmentItemTypeId").getTextContent() : null;
            this.effectTooltipLines = new ArrayList<String>();
            if (coreAttributes.getOptionalFirstOf("effectTooltipLines").isPresent()) {
                for (Element e : coreAttributes.getMandatoryFirstOf("effectTooltipLines").getAllOf("line")) {
                    this.effectTooltipLines.add(e.getTextContent());
                }
            }
            if (debug) {
                System.out.println("3");
            }
            if (itemElement.getOptionalFirstOf("useDescriptions").isPresent()) {
                this.useDescriptionsSelf = itemElement.getMandatoryFirstOf("useDescriptions").getAllOf("selfUse").stream().map(o -> o.getTextContent()).collect(Collectors.toList());
                if (this.useDescriptionsSelf.isEmpty()) {
                    this.useDescriptionsSelf = Util.newArrayListOfValues("[npc.Name]\u4f7f\u7528\u4e86\u8be5\u7269\u54c1\u3002");
                }
                this.useDescriptionsOther = itemElement.getMandatoryFirstOf("useDescriptions").getAllOf("otherUse").stream().map(o -> o.getTextContent()).collect(Collectors.toList());
                if (this.useDescriptionsOther.isEmpty()) {
                    this.useDescriptionsOther = Util.newArrayListOfValues("[npc.Name]\u5bf9[npc2.name]\u4f7f\u7528\u4e86\u8be5\u7269\u54c1\u3002");
                }
            } else {
                this.useDescriptionsSelf = Util.newArrayListOfValues("[npc.Name]\u4f7f\u7528\u4e86\u8be5\u7269\u54c1\u3002");
                this.useDescriptionsOther = Util.newArrayListOfValues("[npc.Name]\u5bf9[npc2.name]\u4f7f\u7528\u4e86\u8be5\u7269\u54c1\u3002");
            }
        }
        catch (XMLMissingTagException ex) {
            throw new XMLLoadException(ex, itemXMLFile);
        }
        catch (Exception e) {
            System.out.println(e);
            throw new XMLLoadException(e, itemXMLFile);
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && o instanceof AbstractItemType && ((AbstractItemType)o).getName(false).equals(this.getName(false)) && ((AbstractItemType)o).getPathNameInformation().equals(this.getPathNameInformation()) && ((AbstractItemType)o).getRarity() == this.getRarity() && ((AbstractItemType)o).getEffects().equals(this.getEffects());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getName(false).hashCode();
        result = 31 * result + this.getPathNameInformation().hashCode();
        result = 31 * result + this.getRarity().hashCode();
        result = 31 * result + this.getEffects().hashCode();
        return result;
    }

    public String getId() {
        return ItemType.getItemToIdMap().get(this);
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public String getAuthorDescription() {
        return this.authorDescription;
    }

    public List<ItemEffect> getEffects() {
        return this.effects;
    }

    public String getSpecialEffect() {
        return this.specialEffect;
    }

    public String getPotionDescriptor() {
        return this.potionDescriptor;
    }

    public boolean isAbleToBeSold() {
        return this.getRarity() != Rarity.QUEST;
    }

    public boolean isAbleToBeDropped() {
        return this.getRarity() != Rarity.QUEST;
    }

    public int getEnchantmentLimit() {
        return 100;
    }

    public AbstractItemEffectType getEnchantmentEffect() {
        if (this.enchantmentEffectId == null || this.enchantmentEffectId.isEmpty()) {
            return null;
        }
        if (this.enchantmentEffectId.equalsIgnoreCase("RACE")) {
            return ItemEffectType.getRacialEffectType(this.associatedRace);
        }
        return ItemEffectType.getItemEffectTypeFromId(this.enchantmentEffectId);
    }

    public AbstractItemType getEnchantmentItemType(List<ItemEffect> effects) {
        if (this.enchantmentItemTypeId == null || this.enchantmentItemTypeId.isEmpty()) {
            return null;
        }
        return ItemType.getItemTypeFromId(this.enchantmentItemTypeId);
    }

    public String getDeterminer() {
        return this.determiner != null ? this.determiner : "";
    }

    public boolean isPlural() {
        return this.plural;
    }

    public String getName(boolean displayName) {
        return this.getName(displayName, displayName);
    }

    public String getName(boolean displayName, boolean capitalise) {
        Object out;
        if (displayName) {
            out = (this.determiner != null ? this.determiner : "") + " <span style='color: " + this.rarity.getColour().toWebHexString() + ";'>" + (this.isPlural() ? this.namePlural : this.name) + "</span>";
        } else {
            Object object = out = this.isPlural() ? this.namePlural : this.name;
        }
        if (capitalise) {
            return Util.capitaliseSentence((String)out);
        }
        return out;
    }

    public String getNamePlural(boolean displayName) {
        return this.getNamePlural(displayName, displayName);
    }

    public String getNamePlural(boolean displayName, boolean capitalise) {
        Object out = displayName ? (this.determiner != null ? this.determiner : "") + " <span style='color: " + this.rarity.getColour().toWebHexString() + ";'>" + this.namePlural + "</span>" : this.namePlural;
        if (capitalise) {
            return Util.capitaliseSentence((String)out);
        }
        return out;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAppendItemEffectLinesToTooltip() {
        return true;
    }

    public List<String> getEffectTooltipLines() {
        ArrayList<String> parsed = new ArrayList<String>();
        for (String string : this.effectTooltipLines) {
            parsed.add(UtilText.parse(string, new ParserTag[0]));
        }
        if (this.appliedStatusEffects != null) {
            for (Map.Entry entry : this.appliedStatusEffects.entrySet()) {
                AbstractStatusEffect se = (AbstractStatusEffect)entry.getKey();
                int seconds = (Integer)((Util.Value)entry.getValue()).getValue();
                int timeDisplay = seconds / 60;
                String timeDesc = "\u5206\u949f";
                if (timeDisplay > 120) {
                    timeDisplay /= 60;
                    timeDesc = "\u5c0f\u65f6";
                }
                if (timeDisplay > 48) {
                    timeDisplay /= 24;
                    timeDesc = "\u5929";
                }
                for (Map.Entry<AbstractAttribute, Float> attEntry : se.getAttributeModifiers(null).entrySet()) {
                    parsed.add("<i>" + attEntry.getKey().getFormattedValue(attEntry.getValue().floatValue()) + "</i>\u6301\u7eed[style.italicsOrange(" + timeDisplay + timeDesc + ")]");
                }
            }
        } else {
            for (ItemEffect itemEffect : this.getEffects()) {
                for (Map.Entry<AbstractStatusEffect, Integer> entry : itemEffect.getItemEffectType().getAppliedStatusEffects().entrySet()) {
                    AbstractStatusEffect se = entry.getKey();
                    int seconds = entry.getValue();
                    int timeDisplay = seconds / 60;
                    String timeDesc = "\u5206\u949f";
                    if (timeDisplay > 120) {
                        timeDisplay /= 60;
                        timeDesc = "\u5c0f\u65f6";
                    }
                    if (timeDisplay > 48) {
                        timeDisplay /= 24;
                        timeDesc = "\u5929";
                    }
                    for (Map.Entry<AbstractAttribute, Float> attEntry : se.getAttributeModifiers(null).entrySet()) {
                        parsed.add("<i>" + attEntry.getKey().getFormattedValue(attEntry.getValue().floatValue()) + "</i>\u6301\u7eed[style.italicsOrange(" + timeDisplay + timeDesc + ")]");
                    }
                }
            }
        }
        return parsed;
    }

    public String getDisplayName(boolean withRarityColour) {
        return Util.capitaliseSentence((this.determiner != null ? this.determiner : "") + (String)(withRarityColour ? "<span style='color: " + this.rarity.getColour().toWebHexString() + ";'>" + (this.isPlural() ? this.getNamePlural(false) : this.getName(false)) + "</span>" : (this.isPlural() ? this.getNamePlural(false) : this.getName(false))));
    }

    public List<SvgInformation> getPathNameInformation() {
        return this.svgPathInformation;
    }

    public Colour getColour() {
        return this.colourShades.get(0);
    }

    public List<Colour> getColourShades() {
        return this.colourShades;
    }

    public int getValue() {
        return this.value;
    }

    public String getSVGString() {
        block10: {
            if (this.SVGString == null) {
                if (this.getPathNameInformation() != null && !this.getPathNameInformation().isEmpty()) {
                    try {
                        if (this.isFromExternalFile()) {
                            Collections.sort(this.svgPathInformation, (i1, i2) -> i1.getZLayer() - i2.getZLayer());
                            StringBuilder svgBuilder = new StringBuilder();
                            for (SvgInformation info : this.getPathNameInformation()) {
                                List<String> lines = Files.readAllLines(Paths.get(info.getPathName(), new String[0]));
                                StringBuilder sb = new StringBuilder();
                                for (String line : lines) {
                                    sb.append(line);
                                }
                                int sizeOffset = (100 - info.getImageSize()) / 2;
                                svgBuilder.append("<div style='width:" + info.getImageSize() + "%;height:" + info.getImageSize() + "%;transform:rotate(" + info.getImageRotation() + "deg);position:absolute;left:" + sizeOffset + "%;bottom:" + sizeOffset + "%;padding:0;margin:0;'>");
                                String finalSvg = sb.toString();
                                for (Map.Entry<String, String> entry : info.getReplacements().entrySet()) {
                                    finalSvg = finalSvg.replaceAll(entry.getKey(), entry.getValue());
                                }
                                svgBuilder.append(finalSvg);
                                svgBuilder.append("</div>");
                            }
                            this.SVGString = svgBuilder.toString();
                            this.SVGString = SvgUtil.colourReplacement(this.getId(), this.getColourShades(), null, this.SVGString);
                            break block10;
                        }
                        InputStream is = this.getClass().getResourceAsStream("/com/lilithsthrone/res/items/" + this.svgPathInformation.get(0).getPathName() + ".svg");
                        if (is == null) {
                            System.err.println("Error! AbstractItemType icon file does not exist (Trying to read from '" + this.svgPathInformation.get(0).getPathName() + "')!");
                        }
                        String s = Util.inputStreamToString(is);
                        this.SVGString = SvgUtil.colourReplacement(this.getId(), this.getColourShades(), null, s);
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.SVGString = "";
                }
            }
        }
        return this.SVGString;
    }

    @Override
    public Rarity getRarity() {
        return this.rarity;
    }

    public String getUseName() {
        return this.useDescriptor;
    }

    public String getUseTooltipDescription(GameCharacter user, GameCharacter target) {
        if (user == null || target == null || user.equals(target)) {
            return Util.capitaliseSentence(this.getUseName()) + this.getName(false) + "\u3002";
        }
        return UtilText.parse(target, "\u8ba9[npc.name]" + this.getUseName() + this.getName(false) + "\u3002", new ParserTag[0]);
    }

    public String getUseDescription(GameCharacter user, GameCharacter target) {
        if (user.equals(target)) {
            return "<p>" + UtilText.parse(user, target, Util.randomItemFrom(this.useDescriptionsSelf), new ParserTag[0]) + "</p>";
        }
        return "<p>" + UtilText.parse(user, target, Util.randomItemFrom(this.useDescriptionsOther), new ParserTag[0]) + "</p>";
    }

    public boolean isAbleToBeUsedFromInventory() {
        return true;
    }

    public String getUnableToBeUsedFromInventoryDescription() {
        return "\u8be5\u7269\u54c1\u65e0\u6cd5\u8fd9\u6837\u4f7f\u7528\uff01";
    }

    public boolean isAbleToBeUsedWhileTrading() {
        return true;
    }

    public String getUnableToBeUsedWhileTradingDescription() {
        return "\u8be5\u7269\u54c1\u65e0\u6cd5\u5728\u4ea4\u6613\u65f6\u4f7f\u7528\uff01";
    }

    public boolean isAbleToBeUsed(GameCharacter user, GameCharacter target) {
        return true;
    }

    public String getUnableToBeUsedDescription(GameCharacter user, GameCharacter target) {
        return "\u8be5\u7269\u54c1\u65e0\u6cd5\u8fd9\u6837\u4f7f\u7528\uff01";
    }

    public boolean isAbleToBeUsedInSex() {
        return this.sexUse;
    }

    public boolean isAbleToBeUsedInCombatAllies() {
        return this.combatUseAllies;
    }

    public boolean isAbleToBeUsedInCombatEnemies() {
        return this.combatUseEnemies;
    }

    public boolean isConsumedOnUse() {
        return this.consumedOnUse;
    }

    public boolean isBreakOutOfInventory() {
        return this.breakOutOfInventory;
    }

    public boolean isTransformative() {
        return this.getItemTags().contains((Object)ItemTag.RACIAL_TF_ITEM);
    }

    public boolean isGift() {
        return false;
    }

    public boolean isFetishGiving() {
        return false;
    }

    public Set<ItemTag> getItemTags() {
        return this.itemTags;
    }

    public Map<AbstractStatusEffect, Util.Value<String, Integer>> getAppliedStatusEffects() {
        return this.appliedStatusEffects;
    }
}

