/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory.item;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import java.util.List;

public abstract class AbstractItemUseEffect {
    protected List<ItemEffect> effects;

    public AbstractItemUseEffect(List<ItemEffect> effects) {
        this.effects = effects;
    }

    public abstract String getUseName(GameCharacter var1);

    public abstract String getUseDescription(GameCharacter var1);

    public List<ItemEffect> getEffects() {
        return this.effects;
    }

    public boolean isAbleToBeUsed(GameCharacter target) {
        return this.getCannotUseDescription(target) == null || this.getCannotUseDescription(target).isEmpty();
    }

    public String getCannotUseDescription(GameCharacter target) {
        return null;
    }

    public boolean isAbleToBeUsedInSex() {
        return true;
    }

    public boolean isAbleToBeUsedInCombat() {
        return true;
    }

    public boolean isConsumedOnUse() {
        return true;
    }

    public boolean isTransformative() {
        return false;
    }

    public boolean isGift() {
        return false;
    }

    public boolean isFetishGiving() {
        return false;
    }
}

