/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory.item;

import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AbstractAttribute;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.attributes.CorruptionLevel;
import com.lilithsthrone.game.character.attributes.IntelligenceLevel;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.effects.AbstractStatusEffect;
import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.character.race.AbstractSubspecies;
import com.lilithsthrone.game.character.race.Race;
import com.lilithsthrone.game.character.race.Subspecies;
import com.lilithsthrone.game.combat.spells.Spell;
import com.lilithsthrone.game.combat.spells.SpellSchool;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.encounters.Encounter;
import com.lilithsthrone.game.dialogue.utils.BodyChanging;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreType;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.Rarity;
import com.lilithsthrone.game.inventory.enchanting.AbstractItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectTimer;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.TFModifier;
import com.lilithsthrone.game.inventory.enchanting.TFPotency;
import com.lilithsthrone.game.inventory.item.AbstractItemType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Units;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.places.PlaceType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ItemType {
    public static AbstractItemType FETISH_UNREFINED;
    public static AbstractItemType FETISH_REFINED;
    public static AbstractItemType ADDICTION_REMOVAL;
    public static AbstractItemType ADDICTION_REMOVAL_REFINED;
    public static AbstractItemType MUSHROOM;
    public static AbstractItemType BOTTLED_ESSENCE_ARCANE;
    public static AbstractItemType HARPY_MATRIARCH_BIMBO_LOLLIPOP;
    public static AbstractItemType HARPY_MATRIARCH_NYMPHO_LOLLIPOP;
    public static AbstractItemType HARPY_MATRIARCH_DOMINANT_PERFUME;
    public static AbstractItemType POTION;
    public static AbstractItemType ELIXIR;
    public static AbstractItemType DYE_BRUSH;
    public static AbstractItemType REFORGE_HAMMER;
    public static AbstractItemType CONDOM_USED_WEBBING;
    public static AbstractItemType CONDOM_USED;
    public static AbstractItemType ORIENTATION_HYPNO_WATCH;
    public static AbstractItemType MOO_MILKER_EMPTY;
    public static AbstractItemType MOO_MILKER_FULL;
    public static AbstractItemType PREGNANCY_TEST;
    public static AbstractItemType MOTHERS_MILK;
    public static AbstractItemType REJUVENATION_POTION;
    public static AbstractItemType CIGARETTE_PACK;
    public static AbstractItemType CIGARETTE;
    public static AbstractItemType MAKEUP_SET;
    public static AbstractItemType DOLL_CONSOLE;
    public static AbstractItemType PRESENT;
    public static AbstractItemType GIFT_ROSE_BOUQUET;
    public static AbstractItemType GIFT_CHOCOLATES;
    public static AbstractItemType GIFT_PERFUME;
    public static AbstractItemType GIFT_TEDDY_BEAR;
    public static AbstractItemType EGGPLANT;
    public static AbstractItemType EGGPLANT_POTION;
    public static AbstractItemType ARTHURS_PACKAGE;
    public static AbstractItemType IMP_FORTRESS_ARCANE_KEY;
    public static AbstractItemType IMP_FORTRESS_ARCANE_KEY_2;
    public static AbstractItemType IMP_FORTRESS_ARCANE_KEY_3;
    public static AbstractItemType LYSSIETHS_RING;
    public static AbstractItemType OFFSPRING_MAP;
    public static AbstractItemType CANDI_PERFUMES;
    public static AbstractItemType CANDI_CONTRABAND;
    public static AbstractItemType CANDI_HUNDRED_KISSES;
    public static AbstractItemType RESONANCE_STONE;
    public static AbstractItemType PAINT_CAN_PREMIUM;
    public static AbstractItemType PAINT_CAN;
    public static AbstractItemType ROLLED_UP_POSTERS;
    public static AbstractItemType NATALYA_BUSINESS_CARD;
    public static AbstractItemType NATALYA_BUSINESS_CARD_STAMPED;
    public static AbstractItemType SLAVER_LICENSE;
    private static List<AbstractItemType> dominionAlleywayItems;
    private static List<AbstractItemType> submissionTunnelItems;
    private static List<AbstractItemType> batCavernItems;
    private static List<AbstractItemType> elisAlleywayItems;
    private static List<AbstractItemType> essences;
    private static List<AbstractItemType> allItems;
    private static List<AbstractItemType> moddedItems;
    private static Map<AbstractSubspecies, String> subspeciesBookId;
    private static Map<AbstractItemType, String> itemToIdMap;
    private static Map<String, AbstractItemType> idToItemMap;
    private static Map<AbstractSubspecies, String> essenceMap;

    private static String getGenericUseDescription(GameCharacter user, GameCharacter target, String playerUseSelf, String playerUsePartner, String partnerUseSelf, String partnerUsePlayer) {
        if (user != null && user.isPlayer()) {
            if (target != null) {
                if (target.isPlayer()) {
                    return "<p>" + playerUseSelf + "</p>";
                }
                return UtilText.parse(target, "<p>" + playerUsePartner + "</p>", new ParserTag[0]);
            }
            return "";
        }
        if (target != null) {
            if (target.isPlayer()) {
                return UtilText.parse(user, "<p>" + partnerUsePlayer + "</p>", new ParserTag[0]);
            }
            return UtilText.parse(user, "<p>" + partnerUseSelf + "</p>", new ParserTag[0]);
        }
        return "";
    }

    private static String getEssenceAbsorptionText(Colour essenceColour, GameCharacter user, GameCharacter target) {
        if (user != null && user.isPlayer()) {
            if (target != null) {
                if (target.isPlayer()) {
                    if (!Main.game.getDialogueFlags().values.contains(DialogueFlagValue.essenceBottledDiscovered)) {
                        Main.game.getDialogueFlags().values.add(DialogueFlagValue.essenceBottledDiscovered);
                        if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ENCHANTMENT_DISCOVERY)) {
                            return "<p>\u4f60\u628a\u74f6\u53e3\u7684\u8f6f\u6728\u585e\u62d4\u4e86\u51fa\u6765\uff0c\u53ea\u89c1\u4e00\u9053\u65cb\u8f6c\u7684\u5149\u5f69\u987f\u65f6\u4ece\u73bb\u7483\u7262\u7b3c\u4e2d\u51b2\u51fa\uff0c\u8ba9\u4f60\u4e0d\u7981\u5012\u5438\u4e00\u53e3\u6c14\u3002\u4f60\u8fd8\u6ca1\u6765\u5f97\u53ca\u53cd\u5e94\uff0c\u7cbe\u534e\u4fbf\u76f4\u76f4\u5411\u4f60\u51b2\u8fc7\u6765\uff0c\u968f\u7740\u4e00\u9635" + essenceColour.getName() + "\u7684\u95ea\u5149\uff0c\u5b83\u4fbf\u51fb\u4e2d\u4e86\u4f60\u7684\u80f8\u819b\uff0c\u4ece\u89c6\u7ebf\u4e2d\u6d88\u5931\u4e86\u3002\u4f60\u89c9\u5f97\u6700\u597d\u53bb\u95ee\u95ee\u8389\u83b1\u96c5\u521a\u624d\u53d1\u751f\u7684\u4e8b\u2026\u2026</p>" + (!Main.game.getPlayer().hasQuest(QuestLine.SIDE_ENCHANTMENT_DISCOVERY) ? Main.game.getPlayer().startQuest(QuestLine.SIDE_ENCHANTMENT_DISCOVERY) : "");
                        }
                        return "<p>\u4f60\u628a\u74f6\u53e3\u7684\u8f6f\u6728\u585e\u62d4\u4e86\u51fa\u6765\uff0c\u53ea\u89c1\u4e00\u9053\u65cb\u8f6c\u7684\u5149\u5f69\u987f\u65f6\u4ece\u73bb\u7483\u7262\u7b3c\u4e2d\u51b2\u51fa\uff0c\u8ba9\u4f60\u4e0d\u7981\u5012\u5438\u4e00\u53e3\u6c14\u3002\u4f60\u8fd8\u6ca1\u6765\u5f97\u53ca\u53cd\u5e94\uff0c\u7cbe\u534e\u4fbf\u76f4\u76f4\u5411\u4f60\u51b2\u8fc7\u6765\uff0c\u968f\u7740\u4e00\u9635" + essenceColour.getName() + "\u7684\u95ea\u5149\uff0c\u5b83\u4fbf\u51fb\u4e2d\u4e86\u4f60\u7684\u80f8\u819b\uff0c\u4ece\u89c6\u7ebf\u4e2d\u6d88\u5931\u4e86\u3002\u4f60\u5ffd\u7136\u8bb0\u8d77\u8389\u83b1\u96c5\u544a\u8bc9\u4f60\u6709\u5173\u5438\u6536\u7cbe\u534e\u7684\u4e8b\u60c5\uff0c\u8fd9\u624d\u957f\u957f\u7684\u5401\u4e86\u4e00\u53e3\u6c14\u2026\u2026</p>";
                    }
                    if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ENCHANTMENT_DISCOVERY)) {
                        return "<p>\u4f60\u628a\u74f6\u53e3\u7684\u8f6f\u6728\u585e\u62d4\u4e86\u51fa\u6765\uff0c\u5c06\u5965\u672f\u7cbe\u534e\u4ece\u73bb\u7483\u7262\u7b3c\u4e2d\u91ca\u653e\u4e86\u51fa\u6765\u3002\u90a3\u7cbe\u534e\u5411\u7740\u4f60\u5f3a\u5927\u7684\u5965\u672f\u7075\u6c14\uff0c\u76f4\u76f4\u5730\u51b2\u4e86\u8fc7\u6765\uff0c\u968f\u7740\u4e00\u9635" + essenceColour.getName() + "\u7684\u95ea\u5149\uff0c\u5b83\u4fbf\u4ece\u89c6\u7ebf\u4e2d\u6d88\u5931\u4e86\u3002\u4f60\u89c9\u5f97\u6700\u597d\u53bb\u95ee\u95ee\u8389\u83b1\u96c5\u521a\u624d\u53d1\u751f\u7684\u4e8b\u2026\u2026</p>";
                    }
                    return "<p>\u4f60\u628a\u74f6\u53e3\u7684\u8f6f\u6728\u585e\u62d4\u4e86\u51fa\u6765\uff0c\u5c06\u5965\u672f\u7cbe\u534e\u4ece\u73bb\u7483\u7262\u7b3c\u4e2d\u91ca\u653e\u4e86\u51fa\u6765\u3002\u90a3\u7cbe\u534e\u5411\u7740\u4f60\u5f3a\u5927\u7684\u5965\u672f\u7075\u6c14\uff0c\u76f4\u76f4\u5730\u51b2\u4e86\u8fc7\u6765\uff0c\u968f\u7740\u4e00\u9635" + essenceColour.getName() + "\u7684\u95ea\u5149\uff0c\u5b83\u4fbf\u4ece\u89c6\u7ebf\u4e2d\u6d88\u5931\u4e86\u3002\u4f60\u611f\u89c9\u5230\u7075\u6c14\u53d1\u751f\u4e86\u4e00\u4e9b\u5fae\u5c0f\u7684\u53d8\u5316\uff0c\u4e5f\u5c31\u8bf4\u660e\u4f60\u6210\u529f\u5c06\u7cbe\u534e\u5438\u6536\u4e86\u3002</p>";
                }
                return UtilText.parse(target, "<p>\u4f60\u628a\u74f6\u53e3\u7684\u8f6f\u6728\u585e\u62d4\u4e86\u51fa\u6765\uff0c\u5c06\u5965\u672f\u7cbe\u534e\u4ece\u73bb\u7483\u7262\u7b3c\u4e2d\u91ca\u653e\u4e86\u51fa\u6765\u3002\u90a3\u7cbe\u534e\u5411\u7740[npc.namePos]\u5f3a\u5927\u7684\u5965\u672f\u7075\u6c14\uff0c\u76f4\u76f4\u5730\u51b2\u4e86\u8fc7\u53bb\uff0c\u968f\u7740\u4e00\u9635" + essenceColour.getName() + "\u7684\u95ea\u5149\uff0c\u5b83\u4fbf\u4ece\u89c6\u7ebf\u4e2d\u6d88\u5931\uff0c\u88ab\u5438\u6536\u8fdb\u5165[npc.her]\u7684\u7075\u6c14\u4e86\u3002</p>", new ParserTag[0]);
            }
            return "";
        }
        if (target != null) {
            if (target.isPlayer()) {
                if (!Main.game.getDialogueFlags().values.contains(DialogueFlagValue.essenceBottledDiscovered)) {
                    Main.game.getDialogueFlags().values.add(DialogueFlagValue.essenceBottledDiscovered);
                    if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ENCHANTMENT_DISCOVERY)) {
                        return UtilText.parse(user, "<p>[npc.Name]\u628a\u74f6\u53e3\u7684\u8f6f\u6728\u585e\u62d4\u4e86\u51fa\u6765\uff0c\u5c06\u5965\u672f\u7cbe\u534e\u4ece\u73bb\u7483\u7262\u7b3c\u4e2d\u91ca\u653e\u4e86\u51fa\u6765\u3002\u4f60\u8fd8\u6ca1\u6765\u5f97\u53ca\u53cd\u5e94\uff0c\u7cbe\u534e\u4fbf\u76f4\u76f4\u5411\u4f60\u51b2\u8fc7\u6765\uff0c\u968f\u7740\u4e00\u9635" + essenceColour.getName() + "\u7684\u95ea\u5149\uff0c\u5b83\u4fbf\u51fb\u4e2d\u4e86\u4f60\u7684\u80f8\u819b\uff0c\u4ece\u89c6\u7ebf\u4e2d\u6d88\u5931\u4e86\u3002\u4f60\u89c9\u5f97\u6700\u597d\u53bb\u95ee\u95ee\u8389\u83b1\u96c5\u521a\u624d\u53d1\u751f\u7684\u4e8b\u2026\u2026</p>" + (!Main.game.getPlayer().hasQuest(QuestLine.SIDE_ENCHANTMENT_DISCOVERY) ? Main.game.getPlayer().startQuest(QuestLine.SIDE_ENCHANTMENT_DISCOVERY) : ""), new ParserTag[0]);
                    }
                    return UtilText.parse(user, "<p>[npc.Name]\u628a\u74f6\u53e3\u7684\u8f6f\u6728\u585e\u62d4\u4e86\u51fa\u6765\uff0c\u5c06\u5965\u672f\u7cbe\u534e\u4ece\u73bb\u7483\u7262\u7b3c\u4e2d\u91ca\u653e\u4e86\u51fa\u6765\u3002\u4f60\u8fd8\u6ca1\u6765\u5f97\u53ca\u53cd\u5e94\uff0c\u7cbe\u534e\u4fbf\u76f4\u76f4\u5411\u4f60\u51b2\u8fc7\u6765\uff0c\u968f\u7740\u4e00\u9635" + essenceColour.getName() + "\u7684\u95ea\u5149\uff0c\u5b83\u4fbf\u51fb\u4e2d\u4e86\u4f60\u7684\u80f8\u819b\uff0c\u4ece\u89c6\u7ebf\u4e2d\u6d88\u5931\u4e86\u3002\u4f60\u5ffd\u7136\u8bb0\u8d77\u8389\u83b1\u96c5\u544a\u8bc9\u4f60\u6709\u5173\u5438\u6536\u7cbe\u534e\u7684\u4e8b\u60c5\uff0c\u8fd9\u624d\u957f\u957f\u7684\u5401\u4e86\u4e00\u53e3\u6c14\u2026\u2026</p>", new ParserTag[0]);
                }
                if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ENCHANTMENT_DISCOVERY)) {
                    return UtilText.parse(user, "<p>[npc.Name]\u628a\u74f6\u53e3\u7684\u8f6f\u6728\u585e\u62d4\u4e86\u51fa\u6765\uff0c\u5c06\u5965\u672f\u7cbe\u534e\u4ece\u73bb\u7483\u7262\u7b3c\u4e2d\u91ca\u653e\u4e86\u51fa\u6765\u3002\u90a3\u7cbe\u534e\u5411\u7740\u4f60\u5f3a\u5927\u7684\u5965\u672f\u7075\u6c14\uff0c\u76f4\u76f4\u5730\u51b2\u4e86\u8fc7\u6765\uff0c\u968f\u7740\u4e00\u9635" + essenceColour.getName() + "\u7684\u95ea\u5149\uff0c\u5b83\u4fbf\u4ece\u89c6\u7ebf\u4e2d\u6d88\u5931\u4e86\u3002\u4f60\u89c9\u5f97\u6700\u597d\u53bb\u95ee\u95ee\u8389\u83b1\u96c5\u521a\u624d\u53d1\u751f\u7684\u4e8b\u2026\u2026</p>", new ParserTag[0]);
                }
                return UtilText.parse(user, "<p>[npc.Name]\u628a\u74f6\u53e3\u7684\u8f6f\u6728\u585e\u62d4\u4e86\u51fa\u6765\uff0c\u5c06\u5965\u672f\u7cbe\u534e\u4ece\u73bb\u7483\u7262\u7b3c\u4e2d\u91ca\u653e\u4e86\u51fa\u6765\u3002\u90a3\u7cbe\u534e\u5411\u7740\u4f60\u5f3a\u5927\u7684\u5965\u672f\u7075\u6c14\uff0c\u76f4\u76f4\u5730\u51b2\u4e86\u8fc7\u6765\uff0c\u968f\u7740\u4e00\u9635" + essenceColour.getName() + "\u7684\u95ea\u5149\uff0c\u5b83\u4fbf\u4ece\u89c6\u7ebf\u4e2d\u6d88\u5931\u4e86\u3002\u4f60\u611f\u89c9\u5230\u7075\u6c14\u53d1\u751f\u4e86\u4e00\u4e9b\u5fae\u5c0f\u7684\u53d8\u5316\uff0c\u4e5f\u5c31\u8bf4\u660e\u4f60\u6210\u529f\u5c06\u7cbe\u534e\u5438\u6536\u4e86\u3002</p>", new ParserTag[0]);
            }
            return UtilText.parse(user, "<p>[npc.Name]\u628a\u74f6\u53e3\u7684\u8f6f\u6728\u585e\u62d4\u4e86\u51fa\u6765\uff0c\u5c06\u5965\u672f\u7cbe\u534e\u4ece\u73bb\u7483\u7262\u7b3c\u4e2d\u91ca\u653e\u4e86\u51fa\u6765\u3002\u90a3\u7cbe\u534e\u5411\u7740[npc.her]\u5f3a\u5927\u7684\u5965\u672f\u7075\u6c14\uff0c\u76f4\u76f4\u5730\u51b2\u4e86\u8fc7\u53bb\uff0c\u968f\u7740\u4e00\u9635" + essenceColour.getName() + "\u7684\u95ea\u5149\uff0c\u5b83\u4fbf\u4ece\u89c6\u7ebf\u4e2d\u6d88\u5931\uff0c\u88ab\u5438\u6536\u8fdb\u5165[npc.her]\u7684\u7075\u6c14\u4e86\u3002</p>", new ParserTag[0]);
        }
        return "";
    }

    public static int getMooMilkerMaxMilk() {
        return 1000;
    }

    public static AbstractItemType getItemTypeFromId(String id) {
        if (id.equalsIgnoreCase("PROMISCUITY_PILL")) {
            id = "innoxia_pills_sterility";
        } else if (id.equalsIgnoreCase("VIXENS_VIRILITY")) {
            id = "innoxia_pills_fertility";
        }
        if (id.equalsIgnoreCase("STR_INGREDIENT_EQUINE_CIDER")) {
            id = "innoxia_race_horse_equine_cider";
        } else if (id.equalsIgnoreCase("STR_INGREDIENT_BUBBLE_MILK")) {
            id = "innoxia_race_cow_bubble_milk";
        } else if (id.equalsIgnoreCase("STR_INGREDIENT_WOLF_WHISKEY")) {
            id = "innoxia_race_wolf_wolf_whiskey";
        } else if (id.equalsIgnoreCase("STR_INGREDIENT_SWAMP_WATER")) {
            id = "innoxia_race_alligator_swamp_water";
        } else if (id.equalsIgnoreCase("STR_INGREDIENT_BLACK_RATS_RUM")) {
            id = "innoxia_race_rat_black_rats_rum";
        } else if (id.equalsIgnoreCase("INT_INGREDIENT_FELINE_FANCY")) {
            id = "innoxia_race_cat_felines_fancy";
        } else if (id.equalsIgnoreCase("INT_INGREDIENT_GRAPE_JUICE")) {
            id = "innoxia_race_fox_vulpines_vineyard";
        } else if (id.equalsIgnoreCase("INT_INGREDIENT_VANILLA_WATER")) {
            id = "innoxia_race_human_vanilla_water";
        } else if (id.equalsIgnoreCase("INT_INGREDIENT_FRUIT_BAT_SQUASH")) {
            id = "innoxia_race_bat_fruit_bats_juice_box";
        } else if (id.equalsIgnoreCase("FIT_INGREDIENT_CANINE_CRUSH")) {
            id = "innoxia_race_dog_canine_crush";
        } else if (id.equalsIgnoreCase("FIT_INGREDIENT_SQUIRREL_JAVA")) {
            id = "innoxia_race_squirrel_squirrel_java";
        } else if (id.equalsIgnoreCase("FIT_INGREDIENT_EGG_NOG")) {
            id = "innoxia_race_reindeer_rudolphs_egg_nog";
        } else if (id.equalsIgnoreCase("SEX_INGREDIENT_HARPY_PERFUME")) {
            id = "innoxia_race_harpy_harpy_perfume";
        } else if (id.equalsIgnoreCase("SEX_INGREDIENT_SLIME_QUENCHER")) {
            id = "innoxia_race_slime_slime_quencher";
        } else if (id.equalsIgnoreCase("SEX_INGREDIENT_BUNNY_JUICE")) {
            id = "innoxia_race_rabbit_bunny_juice";
        } else if (id.equalsIgnoreCase("SEX_INGREDIENT_MINCE_PIE")) {
            id = "innoxia_race_none_mince_pie";
        } else if (id.equalsIgnoreCase("COR_INGREDIENT_ANGELS_TEARS")) {
            id = "innoxia_race_angel_angels_tears";
        } else if (id.equalsIgnoreCase("COR_INGREDIENT_LILITHS_GIFT")) {
            id = "innoxia_race_demon_liliths_gift";
        } else if (id.equalsIgnoreCase("COR_INGREDIENT_IMPISH_BREW")) {
            id = "innoxia_race_imp_impish_brew";
        } else if (id.equalsIgnoreCase("DEBUG_YOUKO_POTION")) {
            id = "innoxia_cheat_inno_chans_gift";
        } else if (id.equalsIgnoreCase("FEMININE_BURGER")) {
            id = "innoxia_cheat_unlikely_whammer";
        }
        if (id.equalsIgnoreCase("DEBUG_DEMON_POTION")) {
            id = "innoxia_race_demon_innoxias_gift";
        } else if (id.equalsIgnoreCase("RACE_ANGELS_TEARS") || id.equalsIgnoreCase("RACE_INGREDIENT_HUMAN")) {
            id = "innoxia_race_human_bread_roll";
        } else if (id.equalsIgnoreCase("RACE_INGREDIENT_CAT_MORPH")) {
            id = "innoxia_race_cat_kittys_reward";
        } else if (id.equalsIgnoreCase("RACE_INGREDIENT_DOG_MORPH")) {
            id = "innoxia_race_dog_canine_crunch";
        } else if (id.equalsIgnoreCase("RACE_INGREDIENT_COW_MORPH")) {
            id = "innoxia_race_cow_bubble_cream";
        } else if (id.equalsIgnoreCase("RACE_INGREDIENT_SQUIRREL_MORPH")) {
            id = "innoxia_race_squirrel_round_nuts";
        } else if (id.equalsIgnoreCase("RACE_INGREDIENT_BAT_MORPH")) {
            id = "innoxia_race_bat_fruit_bats_salad";
        } else if (id.equalsIgnoreCase("RACE_INGREDIENT_RAT_MORPH")) {
            id = "innoxia_race_rat_brown_rats_burger";
        } else if (id.equalsIgnoreCase("RACE_INGREDIENT_RABBIT_MORPH")) {
            id = "innoxia_race_rabbit_bunny_carrot_cake";
        } else if (id.equalsIgnoreCase("RACE_INGREDIENT_FOX_MORPH")) {
            id = "innoxia_race_fox_chicken_pot_pie";
        } else if (id.equalsIgnoreCase("RACE_INGREDIENT_HORSE_MORPH")) {
            id = "innoxia_race_horse_sugar_carrot_cube";
        } else if (id.equalsIgnoreCase("RACE_INGREDIENT_REINDEER_MORPH")) {
            id = "innoxia_race_reindeer_sugar_cookie";
        } else if (id.equalsIgnoreCase("RACE_INGREDIENT_ALLIGATOR_MORPH")) {
            id = "innoxia_race_alligator_gators_gumbo";
        } else if (id.equalsIgnoreCase("RACE_INGREDIENT_WOLF_MORPH")) {
            id = "innoxia_race_wolf_meat_and_marrow";
        } else if (id.equalsIgnoreCase("RACE_INGREDIENT_HARPY")) {
            id = "innoxia_race_harpy_bubblegum_lollipop";
        } else if (id.equalsIgnoreCase("RACE_INGREDIENT_SLIME")) {
            id = "innoxia_race_slime_biojuice_canister";
        }
        id = Util.getClosestStringMatch(id, idToItemMap.keySet());
        return idToItemMap.get(id);
    }

    public static String getIdFromItemType(AbstractItemType itemType) {
        return itemToIdMap.get(itemType);
    }

    public static AbstractItemType getSpellBookType(Spell s) {
        return idToItemMap.get("SPELL_BOOK_" + String.valueOf((Object)s));
    }

    public static AbstractItemType getSpellScrollType(SpellSchool school) {
        return idToItemMap.get("SPELL_SCROLL_" + String.valueOf((Object)school));
    }

    public static AbstractItemType getLoreBook(AbstractSubspecies subspecies) {
        return idToItemMap.get(subspeciesBookId.get(subspecies));
    }

    private static AbstractItemEffectType generateBookEffect(final AbstractSubspecies mainSubspecies, final List<AbstractSubspecies> additionalUnlockSubspecies) {
        return new AbstractItemEffectType(Util.newArrayListOfValues("\u6dfb\u52a0" + mainSubspecies.getName(null) + "\u767e\u79d1\u6761\u76ee", "\u63ed\u793a\u8be5\u79cd\u65cf\u7684\u79cd\u65cf\u72b6\u6001\u6548\u679c\u5177\u4f53\u5c5e\u6027", "[style.colourExcellent(\u83b7\u5f97\u72ec\u7279\u5929\u8d4b\uff1a)]", Perk.getSubspeciesRelatedPerk(mainSubspecies).getName(null)), mainSubspecies.getColour(null)){

            @Override
            public String itemEffectOverride(TFModifier primaryModifier, TFModifier secondaryModifier, TFPotency potency, int limit, GameCharacter user, GameCharacter target, ItemEffectTimer timer) {
                return 59.getBookEffect(target, mainSubspecies, additionalUnlockSubspecies, true);
            }
        };
    }

    private static String getEssenceSvg(AbstractSubspecies subspecies) {
        if (essenceMap.containsKey(subspecies)) {
            return essenceMap.get(subspecies);
        }
        String background = "";
        String bottle = "";
        Colour colour = subspecies.getColour(null);
        try {
            InputStream is = ItemType.class.getResourceAsStream("/com/lilithsthrone/res/items/essenceBackground.svg");
            String s = Util.inputStreamToString(is);
            background = SvgUtil.colourReplacement(subspecies.getName(null), colour, s);
            is.close();
            is = ItemType.class.getResourceAsStream("/com/lilithsthrone/res/items/essenceBottle.svg");
            s = Util.inputStreamToString(is);
            bottle = SvgUtil.colourReplacement(subspecies.getName(null), colour, s);
            is.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String subspeciesIcon = subspecies.getSVGStringNoBackground();
        subspeciesIcon = subspeciesIcon.replaceAll("fill=\"#(.*?)\"", "fill=\"" + colour.getShades()[1] + "\"");
        subspeciesIcon = subspeciesIcon.replaceAll("stroke=\"#(.*?)\"", "stroke=\"" + colour.getShades()[1] + "\"");
        String finalImage = "<div style='width:80%;height:80%;position:absolute;left:10%;top:10%;'>" + background + "</div><div style='width:70%;height:70%;position:absolute;left:15%;top:20%;'>" + subspeciesIcon + "</div><div style='width:60%;height:60%;position:absolute;left:20%;top:25%;'>" + bottle + "</div>";
        essenceMap.put(subspecies, finalImage);
        return finalImage;
    }

    private static String getEssenceEffectSvg(AbstractSubspecies subspecies) {
        String background = "";
        Colour colour = subspecies.getColour(null);
        try {
            InputStream is = ItemType.class.getResourceAsStream("/com/lilithsthrone/res/items/essenceBackground.svg");
            String s = Util.inputStreamToString(is);
            background = SvgUtil.colourReplacement(subspecies.getName(null), colour, s);
            is.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String subspeciesIcon = subspecies.getSVGStringNoBackground();
        subspeciesIcon = subspeciesIcon.replaceAll("fill=\"#(.*?)\"", "fill=\"" + colour.getShades()[1] + "\"");
        subspeciesIcon = subspeciesIcon.replaceAll("stroke=\"#(.*?)\"", "stroke=\"" + colour.getShades()[1] + "\"");
        String finalImage = "<div style='width:80%;height:80%;position:absolute;left:10%;top:10%;'>" + background + "</div><div style='width:70%;height:70%;position:absolute;left:15%;top:20%;'>" + subspeciesIcon + "</div>";
        return finalImage;
    }

    public static List<AbstractItemType> getDominionAlleywayItems() {
        return dominionAlleywayItems;
    }

    public static List<AbstractItemType> getSubmissionTunnelItems() {
        return submissionTunnelItems;
    }

    public static List<AbstractItemType> getBatCavernItems() {
        return batCavernItems;
    }

    public static List<AbstractItemType> getElisAlleywayItems() {
        return elisAlleywayItems;
    }

    public static List<AbstractItemType> getEssences() {
        return essences;
    }

    public static List<AbstractItemType> getAllItems() {
        return allItems;
    }

    public static Map<AbstractItemType, String> getItemToIdMap() {
        return itemToIdMap;
    }

    public static Map<String, AbstractItemType> getIdToItemMap() {
        return idToItemMap;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var5_28;
        void var5_26;
        void var5_24;
        Field[] fieldArray;
        FETISH_UNREFINED = new AbstractItemType(500, "\u4e00\u74f6", false, "\u9b45\u9b54\u4e4b\u543b", "\u9b45\u9b54\u4e4b\u543b", "\u4e00\u4e2a\u5fc3\u5f62\u7684\u73bb\u7483\u74f6\uff0c\u88c5\u6ee1\u4e86\u6d8c\u52a8\u7684\uff0c\u8367\u5149\u7c89\u8272\u7684\u6db2\u4f53\u74f6\u8eab\u4e0a\u7528\u534e\u4e3d\u7684\u5b57\u4f53\u523b\u7740\u201c\u9b45\u9b54\u4e4b\u543b\u201c\u7684\u5b57\u6837\uff0c\u800c\u4e0b\u9762\u7684\u201c\u50bb\u74dc\u5f0f\u7231\u60c5\u836f\u6c34\u201d\u5b57\u6837\u5219\u6e05\u695a\u5730\u8868\u660e\u4e86\u8fd9\u79cd\u6db2\u4f53\u7684\u4f5c\u7528\u3002", "fetishDrink", Util.newArrayListOfValues(PresetColour.CLOTHING_PINK, PresetColour.CLOTHING_PINK_LIGHT, PresetColour.CLOTHING_WHITE, PresetColour.CLOTHING_PINK_DARK), Rarity.EPIC, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.MYSTERY_KINK)), Util.newArrayListOfValues(ItemTag.DOMINION_ALLEYWAY_SPAWN, ItemTag.SUBMISSION_TUNNEL_SPAWN, ItemTag.BAT_CAVERNS_SPAWN, ItemTag.MISC_TF_ITEM, ItemTag.SOLD_BY_RALPH, ItemTag.DRINK)){

            @Override
            public AbstractItemEffectType getEnchantmentEffect() {
                return ItemEffectType.FETISH_ENHANCEMENT;
            }

            @Override
            public AbstractItemType getEnchantmentItemType(List<ItemEffect> effects) {
                return FETISH_REFINED;
            }

            @Override
            public String getUseName() {
                return "\u559d";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u628a\u74f6\u585e\u4ece\u201c\u9b45\u9b54\u4e4b\u543b\u201d\u7684\u74f6\u9888\u4e0a\u62d4\u6389\uff0c\u7136\u540e\u9001\u5230\u5634\u5507\u8fb9\uff0c\u541e\u4e0b\u91cc\u9762\u7518\u751c\u7684\u7c89\u7ea2\u8272\u6db2\u4f53\u3002", "\u4f60\u628a\u74f6\u585e\u4ece\u201c\u9b45\u9b54\u4e4b\u543b\u201d\u7684\u74f6\u9888\u4e0a\u62d4\u6389\uff0c\u7136\u540e\u628a\u5b83\u9001\u5230[npc.namePos]\u5507\u8fb9\uff0c\u7ed9[npc.herHim]\u704c\u4e0b\u4e86\u91cc\u9762\u7518\u751c\u7684\u7c89\u7ea2\u8272\u6db2\u4f53\u3002", "[npc.Name]\u62ff\u51fa\u4e00\u74f6\u201c\u9b45\u9b54\u4e4b\u543b\u201d\uff0c\u8fc5\u901f\u62d4\u6389\u4e86\u74f6\u585e\uff0c\u5c06\u6574\u74f6\u4e00\u996e\u800c\u5c3d\u3002", "[npc.Name]\u62ff\u51fa\u4e00\u74f6\u201c\u9b45\u9b54\u4e4b\u543b\u201d\uff0c\u8fc5\u901f\u62d4\u6389\u4e86\u74f6\u585e\uff0c[npc.she]\u628a\u74f6\u53e3\u9001\u5230\u4f60[pc.lips]\u8fb9\uff0c\u7a0d\u5fae\u4ef0\u8d77\u4f60\u7684\u8111\u888b\uff0c\u5f3a\u884c\u7ed9\u4f60\u704c\u4e0b\u4e86\u91cc\u9762\u7518\u751c\u7684\u7c89\u7ea2\u8272\u6db2\u4f53\u3002");
            }
        };
        FETISH_REFINED = new AbstractItemType(750, "\u4e00\u5c0f\u74f6", false, "\u5929\u8d50\u4e4b\u7656", "\u5929\u8d50\u4e4b\u7656", "\u4e00\u5c0f\u74f6\u8d77\u6ce1\u7684\u7c89\u8272\u6db2\u4f53\uff0c\u7531\u201c\u9b45\u9b54\u4e4b\u543b\u201d\u7cbe\u70bc\u800c\u6210\u3002\u5176\u9644\u9b54\u548c\u4e4b\u84b8\u998f\u524d\u7684\u6db2\u4f53\u6709\u6240\u4e0d\u540c\uff0c\u80fd\u591f\u6dfb\u52a0\u6216\u79fb\u9664\u7279\u5b9a\u6027\u7656\u3002", "fetishDrinkRefined", PresetColour.FETISH, null, null, Rarity.EPIC, null, Util.newArrayListOfValues(ItemTag.DRINK)){

            @Override
            public boolean isFetishGiving() {
                return true;
            }

            @Override
            public String getUseName() {
                return "\u559d";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u628a\u74f6\u585e\u4ece\u201c\u5929\u8d50\u4e4b\u7656\u201d\u7684\u74f6\u9888\u4e0a\u62d4\u6389\uff0c\u7136\u540e\u9001\u5230\u5507\u8fb9\uff0c\u5c06\u91cc\u9762\u751c\u817b\u7684\u6db2\u4f53\u4e00\u996e\u800c\u5c3d\u3002", "\u4f60\u628a\u74f6\u585e\u4ece\u201c\u5929\u8d50\u4e4b\u7656\u201d\u7684\u74f6\u9888\u4e0a\u62d4\u6389\uff0c\u7136\u540e\u9001\u5230[npc.namePos]\u5507\u8fb9\uff0c\u5c06\u91cc\u9762\u751c\u817b\u7684\u6db2\u4f53\u704c\u5165[npc.herHim]\u7684\u53e3\u4e2d\u3002", "[npc.Name]\u62ff\u51fa\u4e00\u74f6\u201c\u5929\u8d50\u4e4b\u7656\u201d\uff0c\u8fc5\u901f\u62d4\u6389\u4e86\u74f6\u585e\uff0c\u5c06\u6574\u74f6\u4e00\u996e\u800c\u5c3d\u3002", "[npc.Name]\u62ff\u51fa\u4e00\u74f6\u201c\u5929\u8d50\u4e4b\u7656\u201d\uff0c\u8fc5\u901f\u62d4\u6389\u4e86\u74f6\u585e\uff0c[npc.she]\u628a\u74f6\u53e3\u9001\u5230\u4f60[pc.lips]\u8fb9\uff0c\u7a0d\u5fae\u4ef0\u8d77\u4f60\u7684\u8111\u888b\uff0c\u5f3a\u884c\u8ba9\u4f60\u541e\u4e0b\u4e86\u91cc\u9762\u751c\u817b\u7684\u6db2\u4f53\u3002");
            }
        };
        ADDICTION_REMOVAL = new AbstractItemType(750, "\u4e00\u74f6", false, "\u5929\u4f7f\u7389\u6db2", "\u5929\u4f7f\u7389\u6db2", "\u4e00\u4e2a\u7cbe\u81f4\u7684\u73bb\u7483\u74f6\uff0c\u91cc\u9762\u88c5\u6709\u6e05\u51c9\u7684\u84dd\u8272\u6db2\u4f53\u3002\u74f6\u8eab\u4e00\u4fa7\u9633\u523b\u7740\u51e0\u4e2a\u5b57\u201c\u5929\u4f7f\u7389\u6db2\u201d\uff0c\u4f46\u4f60\u4e0d\u6e05\u695a\u8fd9\u8ddf\u91cc\u9762\u7684\u6db2\u4f53\u5230\u5e95\u6709\u6ca1\u6709\u5173\u7cfb\u2026\u2026", "addictionRemoval", PresetColour.RACE_HUMAN, null, null, Rarity.LEGENDARY, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.ADDICTION_REMOVAL)), Util.newArrayListOfValues(ItemTag.DOMINION_ALLEYWAY_SPAWN, ItemTag.SUBMISSION_TUNNEL_SPAWN, ItemTag.BAT_CAVERNS_SPAWN, ItemTag.SOLD_BY_RALPH, ItemTag.DRINK_QUALITY)){

            @Override
            public String getUseName() {
                return "\u559d";
            }

            @Override
            public AbstractItemEffectType getEnchantmentEffect() {
                return ItemEffectType.ADDICTION_REMOVAL_REFINEMENT;
            }

            @Override
            public AbstractItemType getEnchantmentItemType(List<ItemEffect> effects) {
                return ADDICTION_REMOVAL_REFINED;
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u628a\u6c34\u6676\u74f6\u585e\u4ece\u201c\u5929\u4f7f\u7389\u6db2\u201d\u7684\u74f6\u9888\u4e0a\u62d4\u6389\uff0c\u7136\u540e\u9001\u5230\u5507\u8fb9\uff0c\u5c06\u91cc\u9762\u6ca1\u4ec0\u4e48\u5473\u9053\u7684\u6db2\u4f53\u4e00\u996e\u800c\u5c3d\u3002", "\u4f60\u628a\u6c34\u6676\u74f6\u585e\u4ece\u201c\u5929\u4f7f\u7389\u6db2\u201d\u7684\u74f6\u9888\u4e0a\u62d4\u6389\uff0c\u7136\u540e\u9001\u5230[npc.namePos]\u7684\u5507\u8fb9\uff0c\u5c06\u91cc\u9762\u7684\u6db2\u4f53\u704c\u5165[npc.herHim]\u7684\u53e3\u4e2d\u3002", "[npc.Name]\u62ff\u51fa\u4e00\u74f6\u201c\u5929\u4f7f\u7389\u6db2\u201d\uff0c\u8fc5\u901f\u62d4\u6389\u4e86\u6c34\u6676\u74f6\u585e\uff0c\u5c06\u6574\u74f6\u4e00\u996e\u800c\u5c3d\u3002", "[npc.Name]\u62ff\u51fa\u4e00\u74f6\u201c\u5929\u4f7f\u7389\u6db2\u201d\uff0c\u8fc5\u901f\u62d4\u6389\u4e86\u6c34\u6676\u74f6\u585e\uff0c[npc.she]\u628a\u74f6\u53e3\u9001\u5230\u4f60[pc.lips]\u8fb9\uff0c\u7a0d\u5fae\u4ef0\u8d77\u4f60\u7684\u8111\u888b\uff0c\u5f3a\u884c\u8ba9\u4f60\u541e\u4e0b\u4e86\u91cc\u9762\u6ca1\u4ec0\u4e48\u5473\u9053\u7684\u6db2\u4f53\u3002");
            }
        };
        ADDICTION_REMOVAL_REFINED = new AbstractItemType(1500, "\u4e00\u5c0f\u74f6", false, "\u5929\u4f7f\u4e4b\u7eaf\u6d01", "\u5929\u4f7f\u4e4b\u7eaf\u6d01", "\u88c5\u6709\u6de1\u84dd\u8272\u6e05\u51c9\u6db2\u4f53\u7684\u73bb\u7483\u74f6\uff0c\u6563\u53d1\u7740\u5fae\u5f31\u4f46\u6301\u4e45\u7684\u5149\u8292\u3002\u662f\u7cbe\u70bc\u540e\u7684\u201c\u5929\u4f7f\u7389\u6db2\u201d\uff0c\u8fd9\u79cd\u6db2\u4f53\u5df2\u7ecf\u65e0\u6cd5\u518d\u79fb\u9664\u6210\u763e\u6548\u679c\uff0c\u4f46\u65e0\u8bba\u8c01\u559d\u4e0b\uff0c\u90fd\u80fd\u591f\u6c38\u4e45\u964d\u4f4e\u5815\u843d\u2026\u2026", "addictionRemovalRefined", PresetColour.RACE_HUMAN, null, null, Rarity.LEGENDARY, null, Util.newArrayListOfValues(ItemTag.DRINK_QUALITY)){

            @Override
            public String getUseName() {
                return "\u559d";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u628a\u74f6\u585e\u4ece\u201c\u5929\u4f7f\u4e4b\u7eaf\u6d01\u201d\u7684\u74f6\u9888\u4e0a\u62d4\u6389\uff0c\u7136\u540e\u9001\u5230\u5507\u8fb9\uff0c\u5c06\u91cc\u9762\u6e05\u51c9\u723d\u53e3\u7684\u6db2\u4f53\u4e00\u996e\u800c\u5c3d\u3002", "\u4f60\u628a\u74f6\u585e\u4ece\u201c\u5929\u4f7f\u4e4b\u7eaf\u6d01\u201d\u7684\u74f6\u9888\u4e0a\u62d4\u6389\uff0c\u7136\u540e\u9001\u5230[npc.namePos]\u7684\u5507\u8fb9\uff0c\u5c06\u91cc\u9762\u7684\u6db2\u4f53\u704c\u5165[npc.herHim]\u7684\u53e3\u4e2d\u3002", "[npc.Name]\u62ff\u51fa\u4e00\u74f6\u201c\u5929\u4f7f\u4e4b\u7eaf\u6d01\u201d\uff0c\u8fc5\u901f\u62d4\u6389\u4e86\u74f6\u585e\uff0c\u5c06\u6574\u74f6\u4e00\u996e\u800c\u5c3d\u3002", "[npc.Name]\u62ff\u51fa\u4e00\u74f6\u201c\u5929\u4f7f\u4e4b\u7eaf\u6d01\u201d\uff0c\u8fc5\u901f\u62d4\u6389\u4e86\u74f6\u585e\uff0c[npc.she]\u628a\u74f6\u53e3\u9001\u5230\u4f60[pc.lips]\u8fb9\uff0c\u7a0d\u5fae\u4ef0\u8d77\u4f60\u7684\u8111\u888b\uff0c\u5f3a\u884c\u8ba9\u4f60\u541e\u4e0b\u4e86\u91cc\u9762\u6e05\u51c9\u723d\u53e3\u7684\u6db2\u4f53\u3002");
            }
        };
        MUSHROOM = new AbstractItemType(500, "\u4e00\u628a", true, "\u53d1\u5149\u8611\u83c7", "\u53d1\u5149\u8611\u83c7", "\u50cf\u8fd9\u6837\u7684\u53d1\u5149\u8611\u83c7\u901a\u5e38\u751f\u957f\u5728\u8759\u8760\u6d1e\u7a9f\u4e2d\u3002\u90a3\u4e9b\u4ee5\u8759\u8760\u6d1e\u7a74\u4e3a\u5bb6\u7684\u53f2\u83b1\u59c6\u901a\u5e38\u4ee5\u8fd9\u4e9b\u8611\u83c7\u4e3a\u98df\uff0c\u8fd9\u4e5f\u662f\u5b83\u4eec\u7684\u8eab\u4f53\u4f1a\u53d1\u5149\u7684\u539f\u56e0\u3002", "mushrooms", PresetColour.BASE_BLUE_LIGHT, null, null, Rarity.EPIC, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.MUSHROOMS)), Util.newArrayListOfValues(ItemTag.BAT_CAVERNS_SPAWN, ItemTag.CONTRABAND_LIGHT)){

            @Override
            public boolean isTransformative() {
                return true;
            }

            @Override
            public String getUseName() {
                return "\u5403";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u62ff\u51fa\u4e00\u5c0f\u628a\u53d1\u5149\u8611\u83c7\u653e\u8fdb\u5634\u91cc\uff0c\u5480\u56bc\u51e0\u4e0b\u4fbf\u54bd\u4e86\u4e0b\u53bb\uff0c\u5ffd\u7136\u53d1\u73b0\u6709\u4e00\u79cd\u6e05\u65b0\u7684\u8584\u8377\u5473\u3002", "\u4f60\u62ff\u51fa\u4e00\u5c0f\u628a\u53d1\u5149\u8611\u83c7\u653e\u8fdb[npc.namePos]\u5634\u91cc\uff0c\u7b49\u5230[npc.she]\u5480\u56bc\u51e0\u4e0b\u54bd\u5230\u809a\u5b50\u91cc\u624d\u7b97\u5b8c\u3002", "[npc.Name]\u62ff\u51fa\u4e00\u5c0f\u628a\u53d1\u5149\u8611\u83c7\u653e\u8fdb\u5634\u91cc\uff0c\u5480\u56bc\u51e0\u4e0b\u4fbf\u54bd\u4e86\u4e0b\u53bb\u3002", "[npc.Name]\u62ff\u51fa\u4e00\u5c0f\u628a\u53d1\u5149\u8611\u83c7\u653e\u8fdb\u4f60\u7684\u5634\u91cc\uff0c\u7b49\u5230\u4f60\u5480\u56bc\u51e0\u4e0b\u54bd\u5230\u809a\u5b50\u91cc\u624d\u7b97\u5b8c\uff0c\u4f60\u5ffd\u7136\u53d1\u73b0\u6709\u4e00\u79cd\u6e05\u65b0\u7684\u8584\u8377\u5473\u3002");
            }
        };
        BOTTLED_ESSENCE_ARCANE = new AbstractItemType(40, null, false, "\u74f6\u88c5\u5965\u672f\u7cbe\u534e", "\u74f6\u88c5\u5965\u672f\u7cbe\u534e", "\u4e00\u4e2a\u5c0f\u73bb\u7483\u74f6\uff0c\u74f6\u53e3\u7d27\u7d27\u7684\u585e\u7740\u4e00\u4e2a\u5c0f\u8f6f\u6728\u585e\u3002\u91cc\u9762" + PresetColour.GENERIC_ARCANE.getName() + "\u5149\u8292\u7684\u5965\u672f\u7cbe\u534e\u821e\u52a8\u95ea\u70c1\u7740\uff0c\u4e0d\u65ad\u98de\u65cb\uff0c\u4ee4\u4eba\u7740\u8ff7\u3002", null, PresetColour.GENERIC_ARCANE, null, null, Rarity.EPIC, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.BOTTLED_ESSENCE_ARCANE)), Util.newArrayListOfValues(ItemTag.ESSENCE)){

            @Override
            public String getUseName() {
                return "\u5438\u6536";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getEssenceAbsorptionText(PresetColour.GENERIC_ARCANE, user, target);
            }

            @Override
            public String getSVGString() {
                return ItemType.getEssenceSvg(Subspecies.LILIN);
            }
        };
        HARPY_MATRIARCH_BIMBO_LOLLIPOP = new AbstractItemType(1250, null, false, "[bimboHarpy.namePos]\u7684\u68d2\u68d2\u7cd6", "[bimboHarpy.namePos]\u7684\u68d2\u68d2\u7cd6", "\u4ece\u54c8\u6bd4\u65cf\u957f[bimboHarpy.name]\u90a3\u91cc\u62ff\u5230\u7684\u98ce\u8f66\u578b\u68d2\u68d2\u7cd6\u3002\u5c3d\u7ba1\u770b\u4e0a\u53bb\u5e73\u5e73\u65e0\u5947\uff0c\u4f46\u4f60\u786e\u4fe1\u4e00\u65e6\u5403\u4e0b\u53bb\u80af\u5b9a\u4f1a\u53d1\u751f\u8f6c\u5316\u2026\u2026", "bimboLollipop", PresetColour.RARITY_LEGENDARY, null, null, Rarity.LEGENDARY, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.BIMBO_LOLLIPOP)), Util.newArrayListOfValues(ItemTag.RACIAL_TF_ITEM, ItemTag.NOT_FOR_SALE, ItemTag.FOOD)){

            @Override
            public boolean isTransformative() {
                return true;
            }

            @Override
            public String getUseName() {
                return "\u8214";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u628a\u68d2\u68d2\u7cd6\u653e\u5230[pc.lips+]\u8fb9\uff0c\u4f38\u51fa[pc.tongue]\u5728\u4e0a\u9762\u7559\u4e0b\u4e86\u4e00\u9053\u7ef5\u957f\u7684\u53e3\u6c34\u75d5\u3002\u4e00\u80a1\u5f3a\u70c8\u7684\u751c\u5473\u5145\u65a5\u4e86\u4f60\u7684\u53e3\u8154\uff0c\u8ddf\u4f60\u4e4b\u524d\u5c1d\u8fc7\u7684\u5473\u9053\u5b8c\u5168\u4e0d\u540c\u3002\u5728\u4f60\u8fd8\u6ca1\u6709\u53cd\u5e94\u8fc7\u6765\u7684\u65f6\u5019\uff0c\u4f60\u5c31\u628a[pc.lips]\u5438\u5728\u4e86\u8fd9\u7f8e\u5473\u7684\u7cd6\u679c\u4e0a\uff0c\u53d1\u51fa\u7740\u5c0f\u58f0\u7684\u545c\u54bd\uff0c\u4f60\u4f3c\u4e4e\u963b\u6b62\u4e0d\u4e86\u81ea\u5df1\u8214\u8fd9\u6839\u68d2\u68d2\u7cd6\u4e86\u2026\u2026", "[npc.name]\u628a\u68d2\u68d2\u7cd6\u653e\u5230[npc.lips+]\u8fb9\uff0c\u4f38\u51fa[npc.tongue]\u5728\u4e0a\u9762\u7559\u4e0b\u4e86\u4e00\u9053\u7ef5\u957f\u7684\u53e3\u6c34\u75d5\u3002\u90a3\u4ee4\u4eba\u4e0a\u763e\u7684\u5473\u9053\u8fc5\u901f\u51b2\u57ae\u4e86[npc.her]\u7684\u611f\u5b98\uff0c[npc.she]\u6025\u5207\u5730\u5c06[npc.lips]\u5438\u5728\u8fd9\u7f8e\u5473\u7684\u7cd6\u679c\u4e0a\uff0c\u53d1\u51fa\u7740\u5c0f\u58f0\u7684\u545c\u54bd\uff0c[npc.she]\u4f3c\u4e4e\u963b\u6b62\u4e0d\u4e86\u81ea\u5df1\u8214\u8fd9\u6839\u68d2\u68d2\u7cd6\u4e86\u2026\u2026", "[npc.Name]\u62ff\u51fa\u4e86\u4e00\u6839\u98ce\u8f66\u578b\u7684\u68d2\u68d2\u7cd6\uff0c\u9ebb\u5229\u5730\u6253\u5f00\u5305\u88c5\uff0c\u5f00\u59cb\u8214\u8d77\u6765\u2026\u2026", "[npc.Name]\u62ff\u51fa\u4e86\u4e00\u6839\u98ce\u8f66\u578b\u7684\u68d2\u68d2\u7cd6\uff0c\u9ebb\u5229\u5730\u6253\u5f00\u5305\u88c5\uff0c\u786c\u585e\u8fdb\u4e86\u4f60\u7684\u5634\u91cc\u3002\u4e00\u80a1\u5f3a\u70c8\u7684\u751c\u5473\u51b2\u51fb\u7740\u4f60\u7684\u820c\u5934\uff0c\u8ddf\u4f60\u4e4b\u524d\u5c1d\u8fc7\u7684\u5473\u9053\u5b8c\u5168\u4e0d\u540c\u3002\u5728\u4f60\u8fd8\u6ca1\u6709\u53cd\u5e94\u8fc7\u6765\u7684\u65f6\u5019\uff0c\u4f60\u5c31\u628a[pc.lips]\u5438\u5728\u4e86\u8fd9\u7f8e\u5473\u7684\u7cd6\u679c\u4e0a\uff0c\u53d1\u51fa\u7740\u5c0f\u58f0\u7684\u545c\u54bd\uff0c\u4f60\u4f3c\u4e4e\u963b\u6b62\u4e0d\u4e86\u81ea\u5df1\u8214\u8fd9\u6839\u68d2\u68d2\u7cd6\u4e86\u2026\u2026");
            }
        };
        HARPY_MATRIARCH_NYMPHO_LOLLIPOP = new AbstractItemType(1250, null, false, "[nymphoHarpy.namePos]\u7684\u68d2\u68d2\u7cd6", "[nymphoHarpy.namePos]\u7684\u68d2\u68d2\u7cd6", "\u4ece\u54c8\u6bd4\u65cf\u957f[nymphoHarpy.name]\u90a3\u91cc\u62ff\u5230\u7684\u5c4c\u72b6\u68d2\u68d2\u7cd6\u3002\u5c3d\u7ba1\u770b\u4e0a\u53bb\u5c31\u662f\u666e\u901a\u7684\u7cd6\u679c\u5236\u6210\uff0c\u4f46\u4f60\u786e\u4fe1\u4e00\u65e6\u5403\u4e0b\u53bb\u80af\u5b9a\u4f1a\u53d1\u751f\u8f6c\u5316\u2026\u2026", "nymphoLollipop", PresetColour.RARITY_LEGENDARY, null, null, Rarity.LEGENDARY, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.NYMPHO_LOLLIPOP)), Util.newArrayListOfValues(ItemTag.RACIAL_TF_ITEM, ItemTag.NOT_FOR_SALE, ItemTag.FOOD)){

            @Override
            public boolean isTransformative() {
                return true;
            }

            @Override
            public String getUseName() {
                return "\u8214";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u628a\u68d2\u68d2\u7cd6\u653e\u5230[pc.lips+]\u8fb9\uff0c\u4f38\u51fa[pc.tongue]\u5728\u4e0a\u9762\u7559\u4e0b\u4e86\u4e00\u9053\u7ef5\u957f\u7684\u53e3\u6c34\u75d5\u3002\u4e00\u80a1\u5f3a\u70c8\u7684\u751c\u5473\u5145\u65a5\u4e86\u4f60\u7684\u53e3\u8154\uff0c\u8ddf\u4f60\u4e4b\u524d\u5c1d\u8fc7\u7684\u5473\u9053\u5b8c\u5168\u4e0d\u540c\u3002\u5728\u4f60\u8fd8\u6ca1\u6709\u53cd\u5e94\u8fc7\u6765\u7684\u65f6\u5019\uff0c\u4f60\u5c31\u5f00\u59cb\u628a\u8fd9\u7f8e\u5473\u7684\u5c4c\u72b6\u7cd6\u679c\u5728\u5634\u91cc\u8fdb\u8fdb\u51fa\u51fa\uff0c\u53d1\u51fa\u7740\u6deb\u8361\u7684\u547b\u541f\uff0c\u4f60\u4f3c\u4e4e\u963b\u6b62\u4e0d\u4e86\u81ea\u5df1\u8214\u8fd9\u6839\u68d2\u68d2\u7cd6\u4e86\u2026\u2026", "[npc.name]\u628a\u68d2\u68d2\u7cd6\u653e\u5230[npc.lips+]\u8fb9\uff0c\u4f38\u51fa[npc.tongue]\u5728\u4e0a\u9762\u7559\u4e0b\u4e86\u4e00\u9053\u7ef5\u957f\u7684\u53e3\u6c34\u75d5\u3002\u90a3\u4ee4\u4eba\u4e0a\u763e\u7684\u5473\u9053\u8fc5\u901f\u51b2\u57ae\u4e86[npc.her]\u7684\u611f\u5b98\uff0c[npc.she]\u6025\u5207\u5730\u7528[npc.lips]\u5305\u88f9\u4f4f\u4e86\u8fd9\u7f8e\u5473\u7684\u5c4c\u72b6\u7cd6\u679c\uff0c\u53d1\u51fa\u7740\u6deb\u8361\u7684\u547b\u541f\uff0c[npc.she]\u4f3c\u4e4e\u963b\u6b62\u4e0d\u4e86\u81ea\u5df1\u8214\u8fd9\u6839\u68d2\u68d2\u7cd6\u4e86\u2026\u2026", "[npc.Name]\u62ff\u51fa\u4e86\u4e00\u6839\u5c4c\u72b6\u7684\u68d2\u68d2\u7cd6\uff0c\u9ebb\u5229\u5730\u6253\u5f00\u5305\u88c5\uff0c\u5f00\u59cb\u8214\u8d77\u6765\u2026\u2026", "[npc.Name]\u62ff\u51fa\u4e86\u4e00\u6839\u5c4c\u72b6\u7684\u68d2\u68d2\u7cd6\uff0c\u9ebb\u5229\u5730\u6253\u5f00\u5305\u88c5\uff0c\u786c\u585e\u8fdb\u4e86\u4f60\u7684\u5634\u91cc\u3002\u4e00\u80a1\u5f3a\u70c8\u7684\u751c\u5473\u5145\u65a5\u4e86\u4f60\u7684\u53e3\u8154\uff0c\u8ddf\u4f60\u4e4b\u524d\u5c1d\u8fc7\u7684\u5473\u9053\u5b8c\u5168\u4e0d\u540c\u3002\u5728\u4f60\u8fd8\u6ca1\u6709\u53cd\u5e94\u8fc7\u6765\u7684\u65f6\u5019\uff0c\u4f60\u5c31\u5f00\u59cb\u628a\u8fd9\u7f8e\u5473\u7684\u5c4c\u72b6\u7cd6\u679c\u5728\u5634\u91cc\u8fdb\u8fdb\u51fa\u51fa\uff0c\u53d1\u51fa\u7740\u6deb\u8361\u7684\u547b\u541f\uff0c\u4f60\u4f3c\u4e4e\u963b\u6b62\u4e0d\u4e86\u81ea\u5df1\u8214\u8fd9\u6839\u68d2\u68d2\u7cd6\u4e86\u2026\u2026");
            }
        };
        HARPY_MATRIARCH_DOMINANT_PERFUME = new AbstractItemType(1250, null, false, "[dominantHarpy.namePos]\u7684\u9999\u6c34", "[dominantHarpy.namePos]\u7684\u9999\u6c34", "\u4ece\u54c8\u6bd4\u65cf\u957f[dominantHarpy.name]\u90a3\u91cc\u62ff\u5230\u7684\u4e00\u74f6\u9999\u6c34\u3002\u5c3d\u7ba1\u770b\u4e0a\u53bb\u5c31\u662f\u666e\u901a\u7684\u9999\u6c34\uff0c\u4f46\u4f60\u786e\u4fe1\u4e00\u65e6\u55b7\u5728\u8eab\u4e0a\u80af\u5b9a\u4f1a\u53d1\u751f\u8f6c\u5316\u2026\u2026", "dominantPerfume", PresetColour.RARITY_LEGENDARY, null, null, Rarity.LEGENDARY, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.DOMINANT_PERFUME)), Util.newArrayListOfValues(ItemTag.RACIAL_TF_ITEM, ItemTag.NOT_FOR_SALE)){

            @Override
            public boolean isTransformative() {
                return true;
            }

            @Override
            public String getUseName() {
                return "\u55b7";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u628a\u9999\u6c34\u74f6\u653e\u5728\u8116\u5b50\u65c1\uff0c\u8f7b\u8f7b\u4e00\u55b7\u3002\u5c3d\u7ba1\u53ea\u91ca\u653e\u51fa\u6781\u5c11\u91cf\u7684\u6db2\u4f53\uff0c\u4f46\u5374\u77ac\u95f4\u7528\u5149\u4e86\u4e00\u6574\u74f6\uff0c\u53ea\u5269\u4e0b\u4e00\u4e2a\u7a7a\u58f3\u5b50\u3002\u4f60\u60ca\u8bb6\u5730\u4f4e\u5934\u4e00\u770b\uff0c\u4e00\u9635\u6d53\u70c8\u7684\u5973\u6027\u9999\u6c14\u5374\u76f4\u63a5\u51b2\u7834\u4e86\u4f60\u7684\u611f\u5b98\uff0c\u9999\u6c34\u4e2d\u5f3a\u529b\u7684\u9644\u9b54\u4f3c\u4e4e\u5f00\u59cb\u53d1\u6325\u4f5c\u7528\uff0c\u4f60\u610f\u8bc6\u5230\u81ea\u5df1\u4e0b\u610f\u8bc6\u6e34\u671b\u5730\u547b\u541f\u8d77\u6765\u2026\u2026", "\u4f60\u628a\u9999\u6c34\u74f6\u653e\u5728[npc.namePos]\u8116\u5b50\u65c1\uff0c\u8f7b\u8f7b\u4e00\u55b7\u3002\u5c3d\u7ba1\u53ea\u91ca\u653e\u51fa\u6781\u5c11\u91cf\u7684\u6db2\u4f53\uff0c\u4f46\u5374\u77ac\u95f4\u7528\u5149\u4e86\u4e00\u6574\u74f6\uff0c\u53ea\u5269\u4e0b\u4e00\u4e2a\u7a7a\u58f3\u5b50\u3002\u4f60\u60ca\u8bb6\u5730\u4f4e\u5934\u4e00\u770b\uff0c\u4e00\u9635\u6d53\u70c8\u7684\u5973\u6027\u9999\u6c14\u5374\u76f4\u63a5\u51b2\u7834\u4e86[npc.namePos]\u7684\u611f\u5b98\uff0c\u9999\u6c34\u4e2d\u5f3a\u529b\u7684\u9644\u9b54\u4f3c\u4e4e\u5f00\u59cb\u53d1\u6325\u4f5c\u7528\uff0c[npc.she]\u610f\u8bc6\u5230\u81ea\u5df1\u4e0b\u610f\u8bc6\u6e34\u671b\u5730\u547b\u541f\u8d77\u6765\u2026\u2026", "[npc.Name]\u62ff\u51fa\u4e86\u4e00\u74f6\u9999\u6c34\uff0c\u9ebb\u5229\u5730\u6380\u5f00\u76d6\u5b50\uff0c\u55b7\u5728\u4e86[npc.her]\u7684\u8116\u5b50\u4e0a\u2026\u2026", "[npc.Name]\u62ff\u51fa\u4e86\u4e00\u74f6\u9999\u6c34\uff0c\u9ebb\u5229\u5730\u6380\u5f00\u76d6\u5b50\uff0c\u55b7\u5728\u4e86\u4f60\u7684\u8116\u5b50\u4e0a\u2026\u2026\u5c3d\u7ba1\u53ea\u91ca\u653e\u51fa\u6781\u5c11\u91cf\u7684\u6db2\u4f53\uff0c\u4f46\u5374\u77ac\u95f4\u7528\u5149\u4e86\u4e00\u6574\u74f6\uff0c\u53ea\u5269\u4e0b\u4e00\u4e2a\u7a7a\u58f3\u5b50\u3002\u4f60\u60ca\u8bb6\u5730\u4f4e\u5934\u4e00\u770b\uff0c\u4e00\u9635\u6d53\u70c8\u7684\u5973\u6027\u9999\u6c14\u5374\u76f4\u63a5\u51b2\u7834\u4e86\u4f60\u7684\u611f\u5b98\uff0c\u9999\u6c34\u4e2d\u5f3a\u529b\u7684\u9644\u9b54\u4f3c\u4e4e\u5f00\u59cb\u53d1\u6325\u4f5c\u7528\uff0c\u4f60\u610f\u8bc6\u5230\u81ea\u5df1\u4e0b\u610f\u8bc6\u6e34\u671b\u5730\u547b\u541f\u8d77\u6765\u2026\u2026");
            }
        };
        POTION = new AbstractItemType(500, "", false, "\u836f\u6c34", "\u836f\u6c34", "\u901a\u8fc7\u5411\u6d88\u8017\u54c1\u4e2d\u6ce8\u5165\u5965\u672f\u7cbe\u534e\u800c\u521b\u9020\u51fa\u7684\u836f\u6c34\u80fd\u591f\u62e5\u6709\u5f3a\u5927\u7684\u6062\u590d\u6548\u679c\u6216\u5c5e\u6027\u63d0\u5347\u3002\u7531\u4e8e\u836f\u6c34\u7684\u5236\u4f5c\u4ec5\u9650\u4e8e\u90a3\u4e9b\u7cbe\u901a\u5965\u672f\u7684\u4eba\uff0c\u6bd4\u5982\u6076\u9b54\u3002\u6240\u4ee5\u5b83\u4eec\u76f8\u5f53\u7f55\u89c1\uff0c\u4ef7\u683c\u4e5f\u5f88\u9ad8\u3002", "refined_potion_container", PresetColour.CLOTHING_PINK, null, null, Rarity.RARE, null, null){

            @Override
            public boolean isTransformative() {
                return false;
            }

            @Override
            public String getUseName() {
                return "\u559d";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u5148\u62d4\u51fa\u4e86\u74f6\u585e\uff0c\u7136\u540e\u8feb\u4e0d\u53ca\u5f85\u5730\u9001\u5230\u4e86\u5634\u8fb9\u3002\u4e00\u80a1\u9999\u751c\u5473\u4ece\u74f6\u53e3\u6d8c\u51fa\uff0c\u4f60\u8fde\u5fd9\u541e\u4e0b\u4e86\u8fd9\u7f8e\u5473\u7684\u6db2\u4f53\uff0c\u968f\u540e\u4fbf\u611f\u5230\u4e00\u9635\u523a\u75db\u4f20\u904d\u4e86\u4f60\u7684\u8eab\u4f53\uff0c\u836f\u6c34\u4f3c\u4e4e\u5f00\u59cb\u8d77\u6548\u4e86\u2026\u2026", "\u4f60\u5148\u62d4\u51fa\u4e86\u74f6\u585e\uff0c\u7136\u540e\u9001\u5230\u4e86[npc.namePos]\u7684\u5634\u8fb9\uff0c\u7ed9[npc.herHim]\u5168\u90e8\u704c\u4e86\u4e0b\u53bb\u3002", "[npc.Name]\u62ff\u51fa\u4e86\u4e00\u74f6\u67d0\u79cd\u6db2\u4f53\uff0c\u8fc5\u901f\u62d4\u6389\u4e86\u74f6\u585e\uff0c\u5c06\u6574\u74f6\u4e00\u996e\u800c\u5c3d\u3002", "[npc.Name]\u5c06\u836f\u6c34\u9001\u5230\u4f60\u7684\u5634\u8fb9\uff0c\u7a0d\u5fae\u4ef0\u8d77\u4f60\u7684\u8111\u888b\uff0c\u5f3a\u884c\u8ba9\u4f60\u541e\u4e0b\u4e86\u91cc\u9762\u7684\u6db2\u4f53\u3002\u4f60\u611f\u5230\u4e00\u80a1\u5947\u7279\u7684\u523a\u75db\u611f\u4f20\u904d\u4e86\u5168\u8eab\uff0c\u836f\u6c34\u4f3c\u4e4e\u5f00\u59cb\u8d77\u6548\u4e86\u2026\u2026");
            }
        };
        ELIXIR = new AbstractItemType(750, "", false, "\u7075\u836f", "\u7075\u836f", "\u901a\u8fc7\u5c06\u5965\u672f\u7cbe\u534e\u6ce8\u5165\u6d88\u8017\u54c1\u540e\u83b7\u5f97\uff0c\u8fd9\u6837\u7684\u7075\u836f\u53ef\u4ee5\u62e5\u6709\u5927\u91cf\u7684\u8f6c\u5316\u6548\u679c\u3002\u53ea\u6709\u5965\u672f\u9020\u8be3\u6781\u9ad8\u7684\u4eba\u2014\u2014\u4f8b\u5982\u6076\u9b54\u2014\u2014\u624d\u80fd\u917f\u9020\u7075\u836f\uff0c\u7075\u836f\u5341\u5206\u7a00\u6709\uff0c\u4ef7\u683c\u4e5f\u4e0d\u4fd7\u3002", "refined_elixir_container", PresetColour.CLOTHING_PINK, null, null, Rarity.EPIC, null, null){

            @Override
            public boolean isTransformative() {
                return true;
            }

            @Override
            public String getUseName() {
                return "\u559d";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u5148\u62d4\u51fa\u4e86\u74f6\u585e\uff0c\u7136\u540e\u8feb\u4e0d\u53ca\u5f85\u5730\u5c06\u7075\u836f\u9001\u5230\u4e86\u5634\u8fb9\u3002\u4e00\u80a1\u9999\u751c\u5473\u4ece\u74f6\u53e3\u6d8c\u51fa\uff0c\u4f60\u8fde\u5fd9\u541e\u4e0b\u4e86\u8fd9\u7f8e\u5473\u7684\u6db2\u4f53\uff0c\u968f\u540e\u4fbf\u611f\u5230\u4e00\u9635\u523a\u75db\u4f20\u904d\u4e86\u4f60\u7684\u8eab\u4f53\uff0c\u7075\u836f\u4f3c\u4e4e\u5f00\u59cb\u8d77\u6548\u4e86\u2026\u2026", "\u4f60\u5148\u62d4\u51fa\u4e86\u74f6\u585e\uff0c\u7136\u540e\u5c06\u7075\u836f\u9001\u5230\u4e86[npc.namePos]\u7684\u5634\u8fb9\uff0c\u7ed9[npc.herHim]\u5168\u90e8\u704c\u4e86\u4e0b\u53bb\u3002", "[npc.Name]\u62ff\u51fa\u4e86\u4e00\u74f6\u67d0\u79cd\u7075\u836f\uff0c\u8fc5\u901f\u62d4\u6389\u4e86\u74f6\u585e\uff0c\u5c06\u6574\u74f6\u4e00\u996e\u800c\u5c3d\u3002", "[npc.Name]\u5c06\u7075\u836f\u9001\u5230\u4f60\u7684\u5634\u8fb9\uff0c\u7a0d\u5fae\u4ef0\u8d77\u4f60\u7684\u8111\u888b\uff0c\u5f3a\u884c\u8ba9\u4f60\u541e\u4e0b\u4e86\u91cc\u9762\u7684\u6db2\u4f53\u3002\u4f60\u611f\u5230\u4e00\u80a1\u5947\u7279\u7684\u523a\u75db\u611f\u4f20\u904d\u4e86\u5168\u8eab\uff0c\u7075\u836f\u4f3c\u4e4e\u5f00\u59cb\u8d77\u6548\u4e86\u2026\u2026");
            }
        };
        DYE_BRUSH = new AbstractItemType(150, "\u4e00\u628a", false, "\u67d3\u8272\u5237", "\u67d3\u8272\u5237", "\u4e00\u628a\u770b\u4e0a\u53bb\u6781\u5176\u4e0d\u540c\u7684\u5c0f\u5237\u5b50\uff0c\u770b\u6837\u5b50\u5c31\u662f\u5728\u753b\u5e03\u6216\u96d5\u5851\u4e0a\u63cf\u753b\u7ec6\u8282\u7684\u3002\u51d1\u8fd1\u4ed4\u7ec6\u89c2\u5bdf\u540e\uff0c\u4f60\u6ce8\u610f\u5230\u5237\u5b50\u7684\u9876\u7aef\u6563\u53d1\u51fa\u6781\u5176\u5fae\u5f31\u7684\u7d2b\u8272\u5149\u8292\uff0c\u8868\u660e\u5176\u786e\u5b9e\u662f\u4e00\u628a\u5965\u672f\u9644\u9b54\u7684\u67d3\u8272\u5237\u3002", "dyeBrush", PresetColour.CLOTHING_WHITE, null, null, Rarity.EPIC, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.DYE_BRUSH)), Util.newArrayListOfValues(ItemTag.DOMINION_ALLEYWAY_SPAWN, ItemTag.SUBMISSION_TUNNEL_SPAWN)){

            @Override
            public String getUseName() {
                return "\u4f7f\u7528";
            }

            @Override
            public boolean isAbleToBeUsedInSex() {
                return false;
            }

            @Override
            public boolean isAbleToBeUsedInCombatAllies() {
                return false;
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return "<p>\u5f53\u4f60\u63e1\u4f4f\u67d3\u8272\u5237\u65f6\uff0c\u4f60\u770b\u5230\u5237\u5934\u53d1\u51fa\u4e00\u9635\u7d2b\u8272\u7684\u5f3a\u5149\u3002\u5f53\u5176\u8d8a\u9760\u8fd1\u90a3\u4ef6\u8863\u7269\uff0c\u5149\u8292\u5c31\u8d8a\u660e\u4eae\uff0c\u6700\u540e\u4e00\u77ac\u95f4\uff0c\u4e94\u989c\u516d\u8272\u7684\u753b\u9762\u5f00\u59cb\u5728\u4f60\u7684\u8111\u4e2d\u95ea\u70c1\u3002\u7528\u6bdb\u5237\u89e6\u78b0\u5230\u8863\u7269\u8868\u9762\u65f6\uff0c\u67d3\u8272\u5237\u77ac\u95f4\u6c7d\u5316\u4e86\uff01\u4f60\u770b\u5f97\u51fa\u5965\u672f\u9644\u9b54\u5df2\u7ecf\u5c06\u8863\u7269\u67d3\u6210\u4f60\u60f3\u8981\u7684\u989c\u8272\u4e86\u3002</p>";
            }

            @Override
            public boolean isAbleToBeUsedFromInventory() {
                return false;
            }
        };
        REFORGE_HAMMER = new AbstractItemType(150, "\u4e00\u628a", false, "\u91cd\u94f8\u9524", "\u91cd\u94f8\u9524", "\u4e00\u628a\u5c0f\u9524\u5b50\uff0c\u6709\u575a\u56fa\u7684\u91d1\u5c5e\u5934\u548c\u6728\u5236\u7684\u9524\u67c4\u3002\u5b83\u88ab\u6ce8\u5165\u4e86\u4e00\u79cd\u72ec\u7279\u7684\u5965\u672f\u9b54\u6cd5\uff0c\u4e0d\u4ec5\u8f7b\u5982\u9e3f\u6bdb\uff0c\u8fd8\u80fd\u77ac\u95f4\u91cd\u94f8\u4efb\u4f55\u6b66\u5668\u3002", "reforge_hammer", PresetColour.CLOTHING_WHITE, null, null, Rarity.EPIC, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.REFORGE_HAMMER)), Util.newArrayListOfValues(ItemTag.DOMINION_ALLEYWAY_SPAWN, ItemTag.SUBMISSION_TUNNEL_SPAWN)){

            @Override
            public String getUseName() {
                return "\u4f7f\u7528";
            }

            @Override
            public boolean isAbleToBeUsedInSex() {
                return false;
            }

            @Override
            public boolean isAbleToBeUsedInCombatAllies() {
                return false;
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return "<p>\u5f53\u4f60\u63e1\u4f4f\u91cd\u94f8\u9524\u65f6\uff0c\u4f60\u770b\u5230\u91d1\u5c5e\u5934\u53d1\u51fa\u4e00\u9635\u6697\u7d2b\u8272\u7684\u5149\u8292\u3002\u5f53\u5176\u8d8a\u9760\u8fd1\u4f60\u7684\u6b66\u5668\uff0c\u5149\u8292\u5c31\u8d8a\u660e\u4eae\uff0c\u6700\u540e\u4e00\u77ac\u95f4\uff0c\u5404\u7c7b\u4f24\u5bb3\u7c7b\u578b\u7684\u753b\u9762\u5f00\u59cb\u5728\u4f60\u7684\u8111\u4e2d\u95ea\u70c1\u3002\u7528\u91d1\u5c5e\u5934\u89e6\u78b0\u5230\u6b66\u5668\u8868\u9762\u65f6\uff0c\u91cd\u94f8\u9524\u77ac\u95f4\u6c7d\u5316\u4e86\uff01\u4f60\u6ce8\u610f\u5230\u5965\u672f\u9644\u9b54\u5df2\u7ecf\u91cd\u94f8\u4e86\u8fd9\u628a\u6b66\u5668\uff0c\u6210\u4e3a\u4e86\u4f60\u60f3\u8981\u4f24\u5bb3\u7c7b\u578b\u3002</p>";
            }

            @Override
            public boolean isAbleToBeUsedFromInventory() {
                return false;
            }
        };
        CONDOM_USED_WEBBING = new AbstractItemType(1, "\u4e00\u4e2a", false, "\u7528\u8fc7\u7684\u907f\u5b55\u7f51", "\u7528\u8fc7\u7684\u907f\u5b55\u7f51", "\u4e00\u4e2a\u7531\u86db\u7f51\u5236\u6210\u7684\u907f\u5b55\u5957\u6837\u7684\u7269\u4f53\uff0c\u5df2\u7ecf\u4f7f\u7528\u8fc7\uff0c\u91cc\u9762\u88c5\u6ee1\u4e86\u67d0\u4eba\u7684\u7cbe\u6db2\uff0c\u53e3\u90e8\u7cfb\u4e86\u8d77\u6765\u3002\u867d\u7136\u7edd\u5927\u591a\u6570\u4eba\u90fd\u53ea\u4f1a\u5355\u7eaf\u5c06\u5176\u4e22\u6389\uff0c\u4f46\u90a3\u4e9b\u5fc3\u7075\u80ae\u810f\u7684\u5bb6\u4f19\u603b\u4f1a\u53e6\u6709\u4ed6\u7528\u2026\u2026", "condomUsedWebbing", PresetColour.CLOTHING_WHITE, null, null, Rarity.COMMON, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.USED_CONDOM_DRINK)), Util.newArrayListOfValues(ItemTag.REMOVE_FROM_DEBUG_SPAWNER)){

            @Override
            public String getUseName() {
                return CONDOM_USED.getUseName();
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return CONDOM_USED.getUseDescription(user, target);
            }

            @Override
            public String getUnableToBeUsedDescription(GameCharacter user, GameCharacter target) {
                return CONDOM_USED.getUnableToBeUsedDescription(user, target);
            }

            @Override
            public boolean isAbleToBeUsedInCombatAllies() {
                return false;
            }

            @Override
            public boolean isAbleToBeUsedInSex() {
                return true;
            }
        };
        CONDOM_USED = new AbstractItemType(1, "\u4e00\u4e2a", false, "\u7528\u8fc7\u7684\u907f\u5b55\u5957", "\u7528\u8fc7\u7684\u907f\u5b55\u5957", "\u4e00\u4e2a\u4f7f\u7528\u8fc7\u7684\u907f\u5b55\u5957\u6837\u7684\u7269\u4f53\uff0c\u91cc\u9762\u88c5\u6ee1\u4e86\u67d0\u4eba\u7684\u7cbe\u6db2\uff0c\u53e3\u90e8\u7cfb\u4e86\u8d77\u6765\u3002\u867d\u7136\u7edd\u5927\u591a\u6570\u4eba\u90fd\u53ea\u4f1a\u5355\u7eaf\u5c06\u5176\u4e22\u6389\uff0c\u4f46\u90a3\u4e9b\u5fc3\u7075\u80ae\u810f\u7684\u5bb6\u4f19\u603b\u4f1a\u53e6\u6709\u4ed6\u7528\u2026\u2026", "condomUsed", PresetColour.CLOTHING_WHITE, null, null, Rarity.COMMON, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.USED_CONDOM_DRINK)), Util.newArrayListOfValues(ItemTag.REMOVE_FROM_DEBUG_SPAWNER)){

            @Override
            public String getUseName() {
                return "\u6253\u5f00";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                if (user == target) {
                    return UtilText.parse(user, target, "\u89e3\u5f00\u7528\u8fc7\u7684\u907f\u5b55\u5957\uff0c[npc.name]\u60f3\u77e5\u9053\u5982\u4f55\u6700\u597d\u5730\u4f7f\u7528\u91cc\u9762\u7684\u4e1c\u897f\u3002", new ParserTag[0]);
                }
                return UtilText.parse(user, target, "\u89e3\u5f00\u7528\u8fc7\u7684\u907f\u5b55\u5957\uff0c[npc.name]\u60f3\u77e5\u9053\u5982\u4f55\u5728[npc2.name]\u8eab\u4e0a\u6700\u597d\u5730\u4f7f\u7528\u91cc\u9762\u7684\u4e1c\u897f\u3002", new ParserTag[0]);
            }

            @Override
            public String getUnableToBeUsedDescription(GameCharacter user, GameCharacter target) {
                return "\u4f60\u60f3\u4e0d\u5230\u8fd9\u4e1c\u897f\u8fd8\u6709\u4ec0\u4e48\u7528\u6cd5\u3002\u6216\u8bb8\u8fd8\u662f\u8d76\u7d27\u6254\u4e86\u5427\u2026\u2026<br/>(\u4f60\u7684\u5815\u843d\u5ea6\u81f3\u5c11\u9700\u8981\u8fbe\u5230<b style='color:" + CorruptionLevel.THREE_DIRTY.getColour().toWebHexString() + ";'>" + CorruptionLevel.THREE_DIRTY.getName() + "</b>\u624d\u80fd\u5f97\u77e5\u8be5\u7269\u54c1\u7684\u7528\u6cd5\uff01)";
            }

            @Override
            public boolean isAbleToBeUsedInCombatAllies() {
                return false;
            }

            @Override
            public boolean isAbleToBeUsedInSex() {
                return true;
            }
        };
        ORIENTATION_HYPNO_WATCH = new AbstractItemType(50000, "\u4e00\u4e2a", false, "\u50ac\u7720\u6000\u8868", "\u50ac\u7720\u6000\u8868", "\u4e00\u4e2a\u5341\u5206\u7279\u6b8a\u53c8\u6781\u5176\u5f3a\u5927\u7684\u5965\u672f\u88c5\u7f6e\u3002\u9644\u9b54\u4e4b\u540e\uff0c\u8fd9\u5757\u50ac\u7720\u6000\u8868\u5c31\u80fd\u591f\u4fee\u6539\u4ed6\u4eba\u7684\u6027\u53d6\u5411\uff0c\u53ea\u9700\u63d0\u5347\u4e00\u70b9\u5bf9\u8c61\u7684\u5815\u843d\u5ea6\u2026\u2026", "hypnoClockBase", PresetColour.ANDROGYNOUS, null, null, Rarity.QUEST, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.ORIENTATION_CHANGE)), null){

            @Override
            public boolean isFetishGiving() {
                return true;
            }

            @Override
            public String getDeterminer() {
                return UtilText.generateSingularDeterminer(this.getName(false));
            }

            @Override
            public int getEnchantmentLimit() {
                return 1;
            }

            @Override
            public AbstractItemEffectType getEnchantmentEffect() {
                return ItemEffectType.ORIENTATION_CHANGE;
            }

            @Override
            public AbstractItemType getEnchantmentItemType(List<ItemEffect> effects) {
                return ORIENTATION_HYPNO_WATCH;
            }

            @Override
            public String getUseName() {
                return "\u50ac\u7720";
            }

            @Override
            public String getUseTooltipDescription(GameCharacter user, GameCharacter target) {
                if (user.equals(target)) {
                    return "\u4f7f\u7528" + this.getName(false) + "\u50ac\u7720\u81ea\u5df1\u3002";
                }
                return UtilText.parse(target, "\u4f7f\u7528" + this.getName(false) + "\u50ac\u7720[npc.name]\u3002", new ParserTag[0]);
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u634f\u4f4f\u7cbe\u81f4\u7684\u8868\u94fe\uff0c\u8f7b\u8f7b\u5730\u5c06\u50ac\u7720\u6000\u8868\u5de6\u53f3\u6643\u52a8\u8d77\u6765\uff0c\u540c\u65f6\u5c06\u81ea\u5df1\u7684\u76ee\u5149\u96c6\u4e2d\u5728\u8f6c\u52a8\u7684\u8868\u76d8\u4e0a\uff0c\u4ece\u800c\u8ba9\u7269\u54c1\u4e2d\u7684\u5965\u672f\u4e4b\u529b\u6e17\u5165\u601d\u60f3\u4e2d\u2026\u2026", "\u4f60\u634f\u4f4f\u7cbe\u81f4\u7684\u8868\u94fe\uff0c\u8f7b\u8f7b\u5730\u5c06\u50ac\u7720\u6000\u8868\u5728[npc.namePos]\u7684\u9762\u524d\u5de6\u53f3\u6643\u52a8\u8d77\u6765\uff0c\u5982\u4f60\u6240\u6599\uff0c[npc.she]\u5c06\u76ee\u5149\u96c6\u4e2d\u5728\u4e86\u8f6c\u52a8\u7684\u8868\u76d8\u4e0a\uff0c\u7269\u54c1\u4e2d\u7684\u5965\u672f\u4e4b\u529b\u4ece\u800c\u5f97\u4ee5\u6e17\u5165[npc.her]\u7684\u601d\u60f3\u4e2d\u2026\u2026 ", "[npc.Name]\u634f\u4f4f\u7cbe\u81f4\u7684\u8868\u94fe\uff0c\u8f7b\u8f7b\u5730\u5c06\u50ac\u7720\u6000\u8868\u5de6\u53f3\u6643\u52a8\u8d77\u6765\uff0c\u540c\u65f6\u5c06\u81ea\u5df1\u7684\u76ee\u5149\u96c6\u4e2d\u5728\u8f6c\u52a8\u7684\u8868\u76d8\u4e0a\uff0c\u4ece\u800c\u8ba9\u7269\u54c1\u4e2d\u7684\u5965\u672f\u4e4b\u529b\u6e17\u5165\u601d\u60f3\u4e2d\u2026\u2026", "[npc.Name]\u634f\u4f4f\u7cbe\u81f4\u7684\u8868\u94fe\uff0c\u8f7b\u8f7b\u5730\u5c06\u50ac\u7720\u6000\u8868\u5728\u4f60\u7684\u9762\u524d\u5de6\u53f3\u6643\u52a8\u8d77\u6765\uff0c\u4f60\u610f\u8bc6\u5230\u81ea\u5df1\u96be\u4ee5\u81ea\u63a7\uff0c\u5c06\u76ee\u5149\u96c6\u4e2d\u5728\u4e86\u65cb\u6da1\u72b6\u7684\u8868\u76d8\u4e0a\uff0c\u7269\u54c1\u4e2d\u7684\u5965\u672f\u4e4b\u529b\u4ece\u800c\u5f97\u4ee5\u6e17\u5165\u4f60\u7684\u601d\u60f3\u4e2d\u2026\u2026 ");
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }
        };
        MOO_MILKER_EMPTY = new AbstractItemType(50, "\u4e00\u4e2a", false, "\u54de\u54de\u6324\u5976\u5668", "\u54de\u54de\u6324\u5976\u5668", "\u4e00\u4e2a\u624b\u52a8\u7684\u6324\u5976\u5668\uff0c\u6709\u5976\u725b\u98ce\u683c\u7684\u88c5\u9970\uff0c\u6700\u591a\u80fd\u591f\u5728\u76f8\u8fde\u63a5\u7684\u5851\u6599\u74f6\u4e2d\u50a8\u5b58" + Units.fluid(1000.0) + "\u7684\u6db2\u4f53\u3002", "breastPump", PresetColour.BASE_PURPLE_LIGHT, null, null, Rarity.COMMON, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.MOO_MILKER)), Util.newArrayListOfValues(ItemTag.DOMINION_ALLEYWAY_SPAWN, ItemTag.SUBMISSION_TUNNEL_SPAWN, ItemTag.BAT_CAVERNS_SPAWN, ItemTag.SOLD_BY_RALPH)){

            @Override
            public String getUseName() {
                return "\u6324\u5976";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u5c06\u54de\u54de\u6324\u5976\u5668\u62ff\u5230\u81ea\u5df1\u7684\u80f8\u65c1\uff0c\u628a\u5438\u529b\u7f69\u5b89\u88c5\u5728[pc.nipple(true)]\u4e0a\uff0c\u7136\u540e\u5f00\u59cb\u6309\u52a8\u4e0a\u9762\u7684\u628a\u624b\u3002\u4f60[pc.milk+]\u6e10\u6e10\u5730\u88ab\u6cf5\u5165\u8fde\u63a5\u7684\u74f6\u4e2d\uff0c\u7ed9\u81ea\u5df1\u6324\u5976\u7684\u611f\u89c9\u4ee4\u4f60\u6309\u637a\u4e0d\u4f4f\uff0c\u53d1\u51fa\u4e00\u58f0\u6ee1\u8db3\u7684\u957f\u53f9\u3002", "\u4f60\u5c06\u54de\u54de\u6324\u5976\u5668\u62ff\u5230[npc.namePos]\u7684\u80f8\u65c1\uff0c\u628a\u5438\u529b\u7f69\u5b89\u88c5\u5728[pc.nipple(true)]\u4e0a\uff0c\u7136\u540e\u5f00\u59cb\u6309\u52a8\u4e0a\u9762\u7684\u628a\u624b\u3002[npc.her][npc.milk+]\u6e10\u6e10\u5730\u88ab\u6cf5\u5165\u8fde\u63a5\u7684\u74f6\u4e2d\uff0c\u88ab\u6324\u5976\u7684\u611f\u89c9\u4ee4[npc.she]\u6309\u637a\u4e0d\u4f4f\uff0c\u53d1\u51fa\u4e00\u58f0\u6ee1\u8db3\u7684\u957f\u53f9\u3002", "[npc.Name]\u5c06\u54de\u54de\u6324\u5976\u5668\u62ff\u5230\u81ea\u5df1\u7684\u80f8\u65c1\uff0c\u628a\u5438\u529b\u7f69\u5b89\u88c5\u5728[npc.nipple(true)]\u4e0a\uff0c\u7136\u540e\u5f00\u59cb\u6309\u52a8\u4e0a\u9762\u7684\u628a\u624b\u3002[npc.her][npc.milk+]\u6e10\u6e10\u5730\u88ab\u6cf5\u5165\u8fde\u63a5\u7684\u74f6\u4e2d\uff0c\u7ed9\u81ea\u5df1\u6324\u5976\u7684\u611f\u89c9\u4ee4[npc.she]\u6309\u637a\u4e0d\u4f4f\uff0c\u53d1\u51fa\u4e00\u58f0\u6ee1\u8db3\u7684\u957f\u53f9\u3002", "[npc.Name]\u5c06\u54de\u54de\u6324\u5976\u5668\u62ff\u5230\u4f60\u7684\u80f8\u65c1\uff0c\u628a\u5438\u529b\u7f69\u5b89\u88c5\u5728[pc.nipple(true)]\u4e0a\uff0c\u7136\u540e\u5f00\u59cb\u6309\u52a8\u4e0a\u9762\u7684\u628a\u624b\u3002\u4f60[pc.milk+]\u6e10\u6e10\u5730\u88ab\u6cf5\u5165\u8fde\u63a5\u7684\u74f6\u4e2d\uff0c\u88ab\u6324\u5976\u7684\u611f\u89c9\u4ee4\u4f60\u6309\u637a\u4e0d\u4f4f\uff0c\u53d1\u51fa\u4e00\u58f0\u6ee1\u8db3\u7684\u957f\u53f9\u3002");
            }

            @Override
            public boolean isAbleToBeUsed(GameCharacter user, GameCharacter target) {
                return target.isAbleToAccessCoverableArea(CoverableArea.NIPPLES, true) && target.getBreastRawMilkStorageValue() >= 5;
            }

            @Override
            public String getUnableToBeUsedDescription(GameCharacter user, GameCharacter target) {
                if (target.isPlayer()) {
                    if (!target.isAbleToAccessCoverableArea(CoverableArea.NIPPLES, true)) {
                        return "\u8981\u4f7f\u7528\u8be5\u7269\u54c1\u5fc5\u987b\u5148\u80fd\u591f\u63a5\u89e6\u5230\u4f60\u7684\u4e73\u5934\uff01";
                    }
                    return "\u8981\u4f7f\u7528\u8be5\u7269\u54c1\uff0c\u4f60\u7684\u4e73\u623f\u4e2d\u81f3\u5c11\u9700\u8981\u50a8\u5b58\u7740" + Units.fluid(5.0) + "\u4e73\u6c41\uff01";
                }
                if (!target.isAbleToAccessCoverableArea(CoverableArea.NIPPLES, true)) {
                    return UtilText.parse(target, "\u8981\u4f7f\u7528\u8be5\u7269\u54c1\u5fc5\u987b\u5148\u80fd\u591f\u63a5\u89e6\u5230[npc.namePos]\u5934\uff01", new ParserTag[0]);
                }
                return UtilText.parse(target, "\u8981\u4f7f\u7528\u8be5\u7269\u54c1\uff0c[npc.her]\u7684\u4e73\u623f\u4e2d\u81f3\u5c11\u9700\u8981\u50a8\u5b58\u7740" + Units.fluid(5.0) + "\u4e73\u6c41\uff01", new ParserTag[0]);
            }
        };
        MOO_MILKER_FULL = new AbstractItemType(150, "\u4e00\u5757", false, "\u88c5\u6ee1\u7684\u6324\u5976\u5668", "\u88c5\u6ee1\u7684\u6324\u5976\u5668", "\u4e00\u4e2a\u624b\u52a8\u7684\u6324\u5976\u5668\uff0c\u6709\u5976\u725b\u98ce\u683c\u7684\u88c5\u9970\u3002\u8fde\u63a5\u5728\u5176\u4e0a\u7684\u5851\u6599\u74f6\u5df2\u7ecf\u88c5\u6ee1\u4e86\u4e73\u6c41\uff0c\u53ea\u8981\u62e7\u5f00\u9876\u7aef\u7684\u62bd\u53d6\u88c5\u7f6e\uff0c\u5c31\u80fd\u591f\u968f\u65f6\u4eab\u7528\u5230\u5176\u4e2d\u7684\u6db2\u4f53\u3002", "breastPumpFilled", PresetColour.BASE_PURPLE_LIGHT, null, null, Rarity.COMMON, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.FILLED_MOO_MILKER_DRINK)), Util.newArrayListOfValues(ItemTag.REMOVE_FROM_DEBUG_SPAWNER)){

            @Override
            public String getUseName() {
                return "\u559d";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u62e7\u5f00\u4e86\u62bd\u53d6\u5934\uff0c\u5c06\u74f6\u53e3\u9001\u5230\u5507\u8fb9\uff0c\u559d\u4e0b\u4e86\u5176\u4e2d\u7684\u6db2\u4f53\u3002", "\u4f60\u62e7\u5f00\u4e86\u62bd\u53d6\u5934\uff0c\u5c06\u74f6\u53e3\u9001\u5230[npc.namePos][npc.lips]\u8fb9\uff0c\u5f3a\u884c\u8ba9[npc.herHim]\u559d\u4e0b\u4e86\u5176\u4e2d\u7684\u6db2\u4f53\u3002", "[npc.Name]\u62e7\u5f00\u4e86\u62bd\u53d6\u5934\uff0c\u5c06\u74f6\u53e3\u9001\u5230[npc.lips]\u8fb9\uff0c\u559d\u4e0b\u4e86\u5176\u4e2d\u7684\u6db2\u4f53\u3002", "[npc.Name]\u62e7\u5f00\u4e86\u62bd\u53d6\u5934\uff0c\u5c06\u74f6\u53e3\u9001\u5230\u4f60[pc.lips]\u8fb9\uff0c\u5f3a\u884c\u8ba9\u4f60\u559d\u4e0b\u4e86\u5176\u4e2d\u7684\u6db2\u4f53\u3002");
            }
        };
        PREGNANCY_TEST = new AbstractItemType(100, "\u4e00\u6839", false, "\u5965\u672f\u9a8c\u5b55\u68d2", "\u5965\u672f\u9a8c\u5b55\u68d2", "\u4e00\u6839\u5c0f\u5851\u6599\u68d2\uff0c\u957f\u4e0d\u8fc7" + Units.size(15.0) + "\uff0c\u4e2d\u95f4\u5d4c\u5165\u7740\u4e00\u5757\u6570\u5b57\u663e\u793a\u5c4f\u3002\u9644\u5e26\u7684\u5c0f\u8bf4\u660e\u4e66\u4e0a\u5199\u5230\uff1a\u201c\u5c06\u68c0\u9a8c\u68d2\u5728\u5bf9\u8c61\u8179\u90e8\u626b\u8fc7\uff0c\u5c31\u80fd\u5224\u5b9a\u7236\u4eb2\u7684\u8eab\u4efd\uff01\u201d", "pregnancy_test", PresetColour.CLOTHING_WHITE, PresetColour.GENERIC_ARCANE, null, Rarity.COMMON, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.PREGNANCY_TEST)), Util.newArrayListOfValues(ItemTag.DOMINION_ALLEYWAY_SPAWN, ItemTag.SUBMISSION_TUNNEL_SPAWN, ItemTag.SOLD_BY_RALPH)){

            @Override
            public String getUseName() {
                return "\u4f7f\u7528";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u5c06\u9a8c\u5b55\u68d2\u4ece\u809a\u5b50\u524d\u626b\u8fc7\uff0c\u542c\u89c1\u6ef4\u7684\u4e00\u58f0\u540e\u4fbf\u62ff\u4e86\u8d77\u6765\u68c0\u67e5\u8bfb\u6570\u3002", "\u4f60\u5c06\u9a8c\u5b55\u68d2\u4ece[npc.namePos]\u7684\u809a\u5b50\u524d\u626b\u8fc7\uff0c\u542c\u89c1\u6ef4\u7684\u4e00\u58f0\u540e\u4fbf\u62ff\u4e86\u8d77\u6765\u68c0\u67e5\u8bfb\u6570\u3002", "[npc.Name]\u5c06\u9a8c\u5b55\u68d2\u4ece[npc.her]\u7684\u809a\u5b50\u524d\u626b\u8fc7\uff0c\u542c\u89c1\u6ef4\u7684\u4e00\u58f0\u540e\u4fbf\u62ff\u4e86\u8d77\u6765\u68c0\u67e5\u8bfb\u6570\u3002", "[npc.Name]\u9a8c\u5b55\u68d2\u4ece\u4f60\u7684\u809a\u5b50\u524d\u626b\u8fc7\uff0c\u542c\u89c1\u6ef4\u7684\u4e00\u58f0\u540e\u4fbf\u62ff\u4e86\u8d77\u6765\u68c0\u67e5\u8bfb\u6570\u3002");
            }
        };
        MOTHERS_MILK = new AbstractItemType(100, "\u4e00\u74f6", false, "\u6bcd\u4eb2\u7684\u5976\u6c34", "\u6bcd\u4eb2\u7684\u5976\u6c34", "\u88c5\u6709\u9187\u539a\u6db2\u4f53\u7684\u5a74\u513f\u5976\u74f6\u3002\u5728\u74f6\u8eab\u4e00\u8fb9\u8d34\u7740\u4e00\u4e2a\u6807\u7b7e\uff0c\u79f0\u8be5\u996e\u54c1\u80fd\u591f\u5feb\u901f\u7f29\u77ed\u5b55\u671f\u548c\u5b75\u5375\u671f\u3002", "mothers_milk", PresetColour.CLOTHING_WHITE, null, null, Rarity.COMMON, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.MOTHERS_MILK)), Util.newArrayListOfValues(ItemTag.DOMINION_ALLEYWAY_SPAWN, ItemTag.SUBMISSION_TUNNEL_SPAWN, ItemTag.SOLD_BY_RALPH, ItemTag.DRINK)){

            @Override
            public String getUseName() {
                return "\u559d";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u5c06\u74f6\u5b50\u9001\u5230[pc.lips]\u8fb9\uff0c\u542b\u4f4f\u5976\u5934\u5f62\u72b6\u7684\u5f00\u53e3\uff0c\u8d2a\u5a6a\u5730\u542e\u5438\u8d77\u5176\u4e2d\u6d53\u90c1\u7684\u6db2\u4f53\u3002", "\u4f60\u5c06\u74f6\u5b50\u9001\u5230[npc.namePos][npc.lips]\u8fb9\uff0c\u628a\u5976\u5934\u5f62\u72b6\u7684\u5f00\u53e3\u585e\u8fdb\u4e86[npc.her]\u7684\u5634\u91cc\uff0c\u5f3a\u884c\u8ba9[npc.herHim]\u542e\u5438\u8d77\u5176\u4e2d\u6d53\u90c1\u7684\u6db2\u4f53\u3002", "[npc.Name]\u5c06\u74f6\u5b50\u9001\u5230[npc.lips]\u8fb9\uff0c\u542b\u4f4f\u5976\u5934\u5f62\u72b6\u7684\u5f00\u53e3\uff0c\u8d2a\u5a6a\u5730\u542e\u5438\u8d77\u5176\u4e2d\u6d53\u90c1\u7684\u6db2\u4f53\u3002", "[npc.Name]\u5c06\u74f6\u5b50\u9001\u5230\u4f60[pc.lips]\u8fb9\uff0c\u628a\u5976\u5934\u5f62\u72b6\u7684\u5f00\u53e3\u585e\u8fdb\u4e86\u5634\u91cc\uff0c\u5f3a\u884c\u8ba9\u4f60\u542e\u5438\u8d77\u5176\u4e2d\u6d53\u90c1\u7684\u6db2\u4f53\u3002");
            }
        };
        REJUVENATION_POTION = new AbstractItemType(1000, "\u4e00\u74f6", false, "\u6d3b\u529b\u836f\u5242", "\u6d3b\u529b\u836f\u5242", "\u4e00\u4e2a\u82b1\u7eb9\u7e41\u590d\u7684\u73bb\u7483\u74f6\uff0c\u74f6\u585e\u4e5f\u662f\u9752\u94dc\u9576\u5d4c\u7684\u73bb\u7483\u585e\u3002\u5728\u74f6\u5e95\u8d34\u6709\u6709\u4e00\u5f20\u63d0\u793a\u7528\u7684\u5c0f\u6807\u7b7e\uff0c\u4e0a\u9762\u5199\u7740\uff1a'<i>\u6d3b\u529b\u836f\u5242\uff0c\u80fd\u591f\u91cd\u5851\u4f7f\u7528\u8fc7\u5ea6\u7684\u8154\u7a74\u4ee5\u53ca\u6062\u590d\u4f60\u6240\u6709\u7684\u4f53\u6db2\uff01</i>'", "rejuvenation_potion", PresetColour.CLOTHING_BLUE_LIGHT, PresetColour.CLOTHING_GOLD, PresetColour.CLOTHING_BLUE_GREY, Rarity.COMMON, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.REJUVENATION_POTION)), Util.newArrayListOfValues(ItemTag.DOMINION_ALLEYWAY_SPAWN, ItemTag.SUBMISSION_TUNNEL_SPAWN, ItemTag.SOLD_BY_RALPH, ItemTag.DRINK)){

            @Override
            public String getUseName() {
                return "\u559d";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u5c06\u74f6\u5b50\u9001\u5230[pc.lips]\u8fb9\uff0c\u542b\u4f4f\u5976\u5934\u5f62\u72b6\u7684\u5f00\u53e3\uff0c\u8d2a\u5a6a\u5730\u542e\u5438\u8d77\u5176\u4e2d\u6d53\u90c1\u7684\u6db2\u4f53\u3002", "\u4f60\u5c06\u74f6\u5b50\u9001\u5230[npc.namePos][npc.lips]\u8fb9\uff0c\u628a\u5976\u5934\u5f62\u72b6\u7684\u5f00\u53e3\u585e\u8fdb\u4e86[npc.her]\u7684\u5634\u91cc\uff0c\u5f3a\u884c\u8ba9[npc.herHim]\u542e\u5438\u8d77\u5176\u4e2d\u6d53\u90c1\u7684\u6db2\u4f53\u3002", "[npc.Name]\u5c06\u74f6\u5b50\u9001\u5230[npc.lips]\u8fb9\uff0c\u542b\u4f4f\u5976\u5934\u5f62\u72b6\u7684\u5f00\u53e3\uff0c\u8d2a\u5a6a\u5730\u542e\u5438\u8d77\u5176\u4e2d\u6d53\u90c1\u7684\u6db2\u4f53\u3002", "[npc.Name]\u5c06\u74f6\u5b50\u9001\u5230\u4f60[pc.lips]\u8fb9\uff0c\u628a\u5976\u5934\u5f62\u72b6\u7684\u5f00\u53e3\u585e\u8fdb\u4e86\u5634\u91cc\uff0c\u5f3a\u884c\u8ba9\u4f60\u542e\u5438\u8d77\u5176\u4e2d\u6d53\u90c1\u7684\u6db2\u4f53\u3002");
            }
        };
        CIGARETTE_PACK = new AbstractItemType(350, "\u4e00\u5305", true, "\u65af\u5854\u9999\u70df", "\u65af\u5854\u9999\u70df", "\u4e00\u5305\u8fd8\u6ca1\u5f00\u8fc7\u7684\u7eb8\u58f3\u5305\u88c5\u7684\u70df\u76d2\uff0c\u7d2b\u767d\u914d\u8272\uff0c\u5185\u6db5\u4e8c\u5341\u6839\u201c\u65af\u5854\u9999\u70df\u201d\u3002\u6839\u636e\u76d2\u5b50\u80cc\u9762\u6253\u5370\u7684\u4fe1\u606f\uff0c\u8fd9\u4e9b\u9999\u70df\u4e0d\u4ec5\u201c\u6dfb\u52a0\u4e86\u91cd\u632f\u7075\u6c14\u7684\u8865\u5242\u201d\u8fd8\u201c\u4fdd\u8bc1\u4f60\u56de\u5934\u7387\u62c9\u6ee1\u201d\u3002", "cigaretteBox", PresetColour.CLOTHING_PURPLE_DARK, PresetColour.CLOTHING_GOLD, null, Rarity.COMMON, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.CIGARETTE_PACK)), Util.newArrayListOfValues(ItemTag.DOMINION_ALLEYWAY_SPAWN, ItemTag.SUBMISSION_TUNNEL_SPAWN, ItemTag.SOLD_BY_RALPH)){

            @Override
            public String getUseName() {
                return "\u6253\u5f00";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u6253\u5f00\u4e0a\u65b9\u7684\u5305\u88c5\u540e\uff0c\u4f60\u4fbf\u80fd\u591f\u53d6\u51fa\u5176\u4e2d\u7684\u4e8c\u5341\u6839\u9999\u70df\u4e86\u3002", "\u6253\u5f00\u4e0a\u65b9\u7684\u5305\u88c5\u540e\uff0c\u4f60\u4fbf\u80fd\u591f\u53d6\u51fa\u5176\u4e2d\u7684\u4e8c\u5341\u6839\u9999\u70df\u7ed9[npc.Name]\u4e86\u3002", "\u6253\u5f00\u4e0a\u65b9\u7684\u5305\u88c5\u540e\uff0c[npc.Name]\u4fbf\u80fd\u591f\u53d6\u51fa\u5176\u4e2d\u7684\u4e8c\u5341\u6839\u9999\u70df\u4e86\u3002", "\u6253\u5f00\u4e0a\u65b9\u7684\u5305\u88c5\u540e\uff0c[npc.Name]\u4fbf\u80fd\u591f\u53d6\u51fa\u5176\u4e2d\u7684\u4e8c\u5341\u6839\u9999\u70df\u7ed9\u4f60\u4e86\u3002");
            }
        };
        CIGARETTE = new AbstractItemType(20, "\u4e00\u4e2a", false, "\u65af\u5854\u9999\u70df", "\u65af\u5854\u9999\u70df", "\u4e00\u6839\u5377\u8d77\u7684\u7eb8\u7b52\uff0c\u585e\u7740\u6d77\u7ef5\u6837\u7684\u6ee4\u5634\uff0c\u5185\u542b\u7269\u7531\u70d8\u5e72\u7684\u70df\u8349\u548c\u5965\u672f\u589e\u5e45\u8865\u5242\u6df7\u5408\u800c\u6210\u3002\u5176\u4e0a\u9644\u9b54\u6709\u975e\u5e38\u5fae\u5f31\u7684\u706b\u7cfb\u6cd5\u672f\uff0c\u653e\u5230\u5634\u8fb9\u65f6\u5c31\u80fd\u81ea\u52a8\u5f15\u706b\u3002", "cigarette", PresetColour.CLOTHING_ORANGE, PresetColour.CLOTHING_BRASS, PresetColour.CLOTHING_WHITE, Rarity.COMMON, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.CIGARETTE)), Util.newArrayListOfValues(ItemTag.DOMINION_ALLEYWAY_SPAWN, ItemTag.SUBMISSION_TUNNEL_SPAWN, ItemTag.SOLD_BY_RALPH)){

            @Override
            public String getUseName() {
                return "\u62bd";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u628a\u9999\u70df\u4e3e\u5230[pc.lips]\u8fb9\uff0c\u5c06\u70df\u5634\u585e\u5230\u4e86\u5634\u91cc\uff0c\u8fd9\u65f6\u5176\u4e0a\u7684\u706b\u7130\u9644\u9b54\u4fbf\u81ea\u52a8\u70b9\u71c3\u4e86\u53e6\u4e00\u7aef\u3002\u4f60\u6df1\u5438\u4e00\u53e3\uff0c\u5438\u5165\u4e86\u70b9\u71c3\u70df\u8349\u4ea7\u751f\u7684\u70df\u96fe\uff0c\u5410\u51fa\u540e\u5728\u9762\u524d\u5f62\u6210\u4e86\u4e00\u5c0f\u56e2\u767d\u8272\u70df\u6c14\u3002", "\u4f60\u628a\u9999\u70df\u4e3e\u5230[npc.namePos][npc.lips]\u8fb9\uff0c\u5c06\u70df\u5634\u585e\u5230\u4e86\u5634\u91cc\uff0c\u8fd9\u65f6\u5176\u4e0a\u7684\u706b\u7130\u9644\u9b54\u4fbf\u81ea\u52a8\u70b9\u71c3\u4e86\u53e6\u4e00\u7aef\u3002[npc.she]\u6df1\u5438\u4e00\u53e3\uff0c\u5438\u5165\u4e86\u70b9\u71c3\u70df\u8349\u4ea7\u751f\u7684\u70df\u96fe\uff0c\u5410\u51fa\u540e\u5728\u9762\u524d\u5f62\u6210\u4e86\u4e00\u5c0f\u56e2\u767d\u8272\u70df\u6c14\u3002", "[npc.namePos]\u628a\u9999\u70df\u4e3e\u5230[npc.lips]\u8fb9\uff0c\u5c06\u70df\u5634\u585e\u5230\u4e86\u5634\u91cc\uff0c\u8fd9\u65f6\u5176\u4e0a\u7684\u706b\u7130\u9644\u9b54\u4fbf\u81ea\u52a8\u70b9\u71c3\u4e86\u53e6\u4e00\u7aef\u3002[npc.she]\u6df1\u5438\u4e00\u53e3\uff0c\u5438\u5165\u4e86\u70b9\u71c3\u70df\u8349\u4ea7\u751f\u7684\u70df\u96fe\uff0c\u5410\u51fa\u540e\u5728\u9762\u524d\u5f62\u6210\u4e86\u4e00\u5c0f\u56e2\u767d\u8272\u70df\u6c14\u3002", "[npc.namePos]\u628a\u9999\u70df\u4e3e\u5230\u4f60[pc.lips]\u8fb9\uff0c\u5c06\u70df\u5634\u585e\u5230\u4e86\u5634\u91cc\uff0c\u8fd9\u65f6\u5176\u4e0a\u7684\u706b\u7130\u9644\u9b54\u4fbf\u81ea\u52a8\u70b9\u71c3\u4e86\u53e6\u4e00\u7aef\u3002\u4f60\u6df1\u5438\u4e00\u53e3\uff0c\u5438\u5165\u4e86\u70b9\u71c3\u70df\u8349\u4ea7\u751f\u7684\u70df\u96fe\uff0c\u5410\u51fa\u540e\u5728\u9762\u524d\u5f62\u6210\u4e86\u4e00\u5c0f\u56e2\u767d\u8272\u70df\u6c14\u3002");
            }
        };
        MAKEUP_SET = new AbstractItemType(5000, "\u4e00\u5957", false, "\u5965\u672f\u5316\u5986\u5957\u88c5", "\u5965\u672f\u5316\u5986\u5957\u88c5", "\u4e00\u5957\u5e7f\u53d7\u597d\u8bc4\u7684\u4fbf\u643a\u5316\u5986\u5957\u88c5\u3002\u5176\u4e2d\u7684\u5316\u5986\u54c1\u90fd\u62e5\u6709\u9644\u9b54\uff0c\u80fd\u591f\u8ba9\u4f7f\u7528\u8005\u968f\u610f\u8c03\u6574\u989c\u8272\u3002\u66f4\u795e\u5947\u7684\u662f\uff0c\u65e0\u8bba\u5982\u4f55\u4f7f\u7528\uff0c\u91cc\u9762\u7684\u5316\u5986\u54c1\u90fd\u4e0d\u4f1a\u8017\u5c3d\u3002", "makeupSet", PresetColour.CLOTHING_BLACK, PresetColour.CLOTHING_BLACK, PresetColour.CLOTHING_BLACK, Rarity.EPIC, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.MAKEUP_SET)), Util.newArrayListOfValues(ItemTag.SOLD_BY_RALPH, ItemTag.SOLD_BY_KATE)){

            @Override
            public boolean isAbleToBeUsedInSex() {
                return true;
            }

            @Override
            public boolean isAbleToBeUsedInCombatAllies() {
                return false;
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }

            @Override
            public String getUseName() {
                return "\u4f7f\u7528";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return "";
            }

            @Override
            public boolean isAbleToBeUsed(GameCharacter user, GameCharacter target) {
                return super.isAbleToBeUsed(user, target) && target.isAbleToWearMakeup();
            }

            @Override
            public String getUnableToBeUsedDescription(GameCharacter user, GameCharacter target) {
                if (!target.isAbleToWearMakeup()) {
                    return UtilText.parse(target, "<i>\u7531\u4e8e[npc.namePos]\u7684\u8eab\u4f53\u7531" + BodyChanging.getTarget().getBodyMaterial().getName() + "\u6784\u6210\uff0c[npc.sheIsFull][style.colourBad(\u65e0\u6cd5\u8fdb\u884c\u4efb\u4f55\u5316\u5986)]\uff01</i>", new ParserTag[0]);
                }
                return "\u8be5\u7269\u54c1\u65e0\u6cd5\u8fd9\u6837\u4f7f\u7528\uff01";
            }
        };
        DOLL_CONSOLE = new AbstractItemType(120000, "\u4e00\u4e2a", false, "D.E.C.K.", "D.E.C.K.", "<i>\u201c\u73a9\u5076\u4e13\u7528\u5ba2\u5236\u5316\u5de5\u5177(Doll's Expedient Customisation Kit)\u201d</i>\u662f\u552f\u4e00\u80fd\u591f\u8f6c\u5316\u81ea\u52a8\u6027\u7231\u73a9\u5076\u7684\u65b9\u5f0f\u3002\u5c06\u6570\u636e\u7ebf\u63d2\u5165\u73a9\u5076\u540e\u9888\u90e8\u7684\u63a5\u53e3\uff0c\u4f7f\u7528\u8005\u4fbf\u80fd\u591f\u8c03\u6574\u73a9\u5076\u5927\u91cf\u7684\u8eab\u4f53\u7279\u6027\u3002", "dollConsole", PresetColour.CLOTHING_BLUE_LIGHT, PresetColour.CLOTHING_PINK_LIGHT, PresetColour.CLOTHING_PURPLE, Rarity.QUEST, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.DOLL_CONSOLE)), Util.newArrayListOfValues(new ItemTag[0])){

            @Override
            public boolean isAbleToBeSold() {
                return true;
            }

            @Override
            public boolean isAbleToBeUsedInSex() {
                return false;
            }

            @Override
            public boolean isAbleToBeUsedInCombatAllies() {
                return false;
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }

            @Override
            public String getUseName() {
                return "\u4f7f\u7528";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return "";
            }

            @Override
            public boolean isAbleToBeUsed(GameCharacter user, GameCharacter target) {
                return super.isAbleToBeUsed(user, target) && target.isDoll();
            }

            @Override
            public String getUnableToBeUsedDescription(GameCharacter user, GameCharacter target) {
                if (!target.isDoll()) {
                    return UtilText.parse(target, "<i>[npc.nameIsFull]\u5e76\u975e\u73a9\u5076\uff0cD.E.C.K.\u6ca1\u6709\u6548\u679c\uff01</i>", new ParserTag[0]);
                }
                return "\u8be5\u7269\u54c1\u65e0\u6cd5\u8fd9\u6837\u4f7f\u7528\uff01";
            }
        };
        PRESENT = new AbstractItemType(250, "\u4e00\u6839", false, "\u5723\u8bde\u8282\u793c\u7269", "\u5723\u8bde\u8282\u793c\u7269", "\u4e00\u4efd\u5305\u88f9\u597d\u7684\u793c\u7269\uff0c\u7531\u5fa1\u57ce\u533a\u7684\u67d0\u4e2a\u9a6f\u9e7f\u5316\u5f62\u5de5\u5934\u552e\u5356\u3002\u91cc\u9762\u5305\u542b\u4e86\u4ed6\u5546\u5e97\u4e2d\u7684\u4e00\u4ef6\u968f\u673a\u7269\u54c1\uff0c\u540c\u6837\u4e5f\u53ef\u4ee5\u5f53\u4f5c\u793c\u7269\u9001\u7ed9\u540e\u4ee3\u3001\u5974\u96b6\u6216\u8005\u8389\u83b1\u96c5\u3002", "present", PresetColour.GENERIC_ARCANE, null, null, Rarity.RARE, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.PRESENT)), null){

            @Override
            public boolean isAbleToBeUsed(GameCharacter user, GameCharacter target) {
                return !target.isInventoryFull() || !Main.game.getPlayerCell().getInventory().isInventoryFull();
            }

            @Override
            public String getUnableToBeUsedDescription(GameCharacter user, GameCharacter target) {
                return "\u4f60\u7684\u7269\u54c1\u680f\u548c\u5730\u9762\u90fd\u6ca1\u6709\u7a7a\u95f4\u6765\u5bb9\u7eb3\u7269\u54c1\u4e86\uff01";
            }

            @Override
            public String getUseName() {
                return "\u6253\u5f00";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u89e3\u4e0b\u4e1d\u5e26\uff0c\u6495\u5f00\u4e86\u5305\u88c5\u7eb8\uff0c\u6253\u5f00\u76d2\u5b50\u540e\u53d1\u73b0\u91cc\u9762\u662f\u2026\u2026", "\u4f60\u8ba9[npc.name]\u89e3\u4e0b\u4e1d\u5e26\uff0c\u6495\u5f00\u4e86\u5305\u88c5\u7eb8\uff0c\u6253\u5f00\u76d2\u5b50\u540e\u53d1\u73b0\u91cc\u9762\u662f\u2026\u2026", "[npc.Name]\u62ff\u51fa\u4e00\u4efd\u793c\u7269\uff0c\u968f\u540e\u89e3\u4e0b\u4e1d\u5e26\uff0c\u6495\u5f00\u4e86\u5305\u88c5\u7eb8\uff0c\u6253\u5f00\u76d2\u5b50\u540e\u53d1\u73b0\u91cc\u9762\u662f\u2026\u2026", "[npc.Name]\u62ff\u51fa\u4e00\u4efd\u793c\u7269\uff0c\u968f\u540e\u8ba9\u4f60\u89e3\u4e0b\u4e1d\u5e26\uff0c\u6495\u5f00\u4e86\u5305\u88c5\u7eb8\uff0c\u6253\u5f00\u76d2\u5b50\u540e\u53d1\u73b0\u91cc\u9762\u662f\u2026\u2026");
            }
        };
        GIFT_ROSE_BOUQUET = new AbstractItemType(500, null, false, "\u73ab\u7470\u82b1\u675f", "\u73ab\u7470\u82b1\u675f", "\u4e00\u675f\u5404\u8272\u73ab\u7470\u7ec4\u6210\u7684\u82b1\u675f\uff0c\u5373\u4f7f\u76f8\u9694\u5f88\u8fdc\u4e5f\u80fd\u95fb\u5230\u6021\u4eba\u7684\u9999\u5473\u3002[Ashley.speech(\u514d\u5f97\u4f60\u90fd\u4e0d\u77e5\u9053\u5fc3\u4e0a\u4eba\u6700\u559c\u6b22\u7684\u989c\u8272\u662f\u4ec0\u4e48\uff0c\u6240\u4ee5\u91cc\u9762\u6bcf\u79cd\u989c\u8272\u90fd\u6709\u3002)]", "giftRoseBouquet", PresetColour.BASE_RED, PresetColour.BASE_ORANGE, PresetColour.BASE_YELLOW, Rarity.UNCOMMON, null, Util.newArrayListOfValues(ItemTag.GIFT)){

            @Override
            public String getDescription() {
                if (Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SHOPPING_ARCADE_ASHLEYS_SHOP)) {
                    return "\u4e00\u675f\u5404\u8272\u73ab\u7470\u7ec4\u6210\u7684\u82b1\u675f\uff0c\u5373\u4f7f\u76f8\u9694\u5f88\u8fdc\u4e5f\u80fd\u95fb\u5230\u6021\u4eba\u7684\u9999\u5473\u3002[Ashley.speech(\u514d\u5f97\u4f60\u90fd\u4e0d\u77e5\u9053\u5fc3\u4e0a\u4eba\u6700\u559c\u6b22\u7684\u989c\u8272\u662f\u4ec0\u4e48\uff0c\u6240\u4ee5\u91cc\u9762\u6bcf\u79cd\u989c\u8272\u90fd\u6709\u3002)]";
                }
                return "\u4e00\u675f\u5404\u8272\u73ab\u7470\u7ec4\u6210\u7684\u82b1\u675f\uff0c\u5373\u4f7f\u76f8\u9694\u5f88\u8fdc\u4e5f\u80fd\u95fb\u5230\u6021\u4eba\u7684\u9999\u5473\u3002";
            }

            @Override
            public String getUseName() {
                return "\u95fb";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u95fb\u4e86\u95fb\u73ab\u7470\u82b1\u675f\u6563\u53d1\u51fa\u7684\u6de1\u96c5\u7684\u9999\u6c14\u3002", "\u4f60\u8ba9[npc.Name]\u95fb\u4e86\u95fb\u73ab\u7470\u82b1\u675f\u6563\u53d1\u51fa\u7684\u6de1\u96c5\u7684\u9999\u6c14\u3002", "[npc.Name]\u95fb\u4e86\u95fb\u73ab\u7470\u82b1\u675f\u6563\u53d1\u51fa\u7684\u6de1\u96c5\u7684\u9999\u6c14\u3002", "[npc.Name]\u8ba9\u4f60\u95fb\u4e86\u95fb\u73ab\u7470\u82b1\u675f\u6563\u53d1\u51fa\u7684\u6de1\u96c5\u7684\u9999\u6c14\u3002");
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }
        };
        GIFT_CHOCOLATES = new AbstractItemType(300, "\u4e00\u76d2", true, "\u5de7\u514b\u529b", "\u5de7\u514b\u529b", "\u4e00\u76d2\u5404\u79cd\u53e3\u5473\u7684\u5de7\u514b\u529b\u3002[Ashley.speech(\u5f88\u666e\u901a\u4f46\u662f\u5f88\u597d\u5403\u3002\u55ef\uff0c\u4e70\u5427\uff0c\u5047\u88c5\u662f\u7ed9\u522b\u4eba\u4e70\u7684\u5c31\u597d\u3002)]", "giftChocolates", PresetColour.BASE_TAN, PresetColour.BASE_BROWN_DARK, PresetColour.BASE_YELLOW, Rarity.UNCOMMON, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.GIFT_CHOCOLATES)), Util.newArrayListOfValues(ItemTag.GIFT, ItemTag.FOOD_QUALITY)){

            @Override
            public String getDescription() {
                if (Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SHOPPING_ARCADE_ASHLEYS_SHOP)) {
                    return "\u4e00\u76d2\u5404\u79cd\u53e3\u5473\u7684\u5de7\u514b\u529b\u3002[Ashley.speech(\u5f88\u666e\u901a\u4f46\u662f\u5f88\u597d\u5403\u3002\u55ef\uff0c\u4e70\u5427\uff0c\u5047\u88c5\u662f\u7ed9\u522b\u4eba\u4e70\u7684\u5c31\u597d\u3002)]";
                }
                return "\u4e00\u76d2\u5404\u79cd\u53e3\u5473\u7684\u5de7\u514b\u529b\u3002";
            }

            @Override
            public String getUseName() {
                return "\u5403";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u62ff\u5f00\u76d2\u76d6\uff0c\u81ea\u5df1\u5403\u4e86\u8d77\u6765\u3002", "\u4f60\u62ff\u5f00\u76d2\u76d6\uff0c\u5582\u7ed9[npc.Name]\u5403\u4e86\u8d77\u6765\u3002", "[npc.Name]\u62ff\u5f00\u76d2\u76d6\uff0c\u81ea\u5df1\u5403\u4e86\u8d77\u6765\u3002", "[npc.Name]\u62ff\u5f00\u76d2\u76d6\uff0c\u5582\u7ed9\u4f60\u5403\u4e86\u8d77\u6765\u3002");
            }
        };
        GIFT_PERFUME = new AbstractItemType(300, "\u4e00\u74f6", false, "\u73ab\u7470\u9999\u6c34", "\u73ab\u7470\u9999\u6c34", "\u4e00\u5c0f\u74f6\u9999\u6c34\u3002[Ashley.speech(\u5927\u591a\u4eba\u90fd\u5f88\u6b23\u8d4f\u7684\u5e73\u5e38\u5473\u9053\u3002\u80fd\u8ba9\u4f60\u5438\u5f15\u5230\u66f4\u591a\u4eba\uff0c\u8c01\u559c\u6b22\u6d51\u8eab\u81ed\u6c14\u5462\uff01)]", "giftPerfume", PresetColour.BASE_ROSE, PresetColour.BASE_PURPLE_LIGHT, null, Rarity.UNCOMMON, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.GIFT_PERFUME)), Util.newArrayListOfValues(ItemTag.GIFT)){

            @Override
            public String getDescription() {
                if (Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SHOPPING_ARCADE_ASHLEYS_SHOP)) {
                    return "\u4e00\u5c0f\u74f6\u9999\u6c34\u3002[Ashley.speech(\u5927\u591a\u4eba\u90fd\u5f88\u6b23\u8d4f\u7684\u5e73\u5e38\u5473\u9053\u3002\u80fd\u8ba9\u4f60\u5438\u5f15\u5230\u66f4\u591a\u4eba\uff0c\u8c01\u559c\u6b22\u6d51\u8eab\u81ed\u6c14\u5462\uff01)]";
                }
                return "\u4e00\u5c0f\u74f6\u9999\u6c34\u3002";
            }

            @Override
            public String getUseName() {
                return "\u55b7";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u6df1\u5438\u4e86\u4e00\u53e3\u73ab\u7470\u7684\u82b3\u9999\uff0c\u4fbf\u5c06\u201c\u73ab\u7470\u9999\u6c34\u201d\u55b7\u5728\u4e86\u4f60\u7684\u8116\u5b50\u4e0a\u3002", "\u4f60\u5c06\u201c\u73ab\u7470\u9999\u6c34\u201d\u55b7\u5728\u4e86[npc.namePos]\u7684\u8116\u5b50\u4e0a\u3002", "[npc.Name]\u62ff\u51fa\u4e00\u74f6\u201c\u73ab\u7470\u9999\u6c34\u201d\uff0c\u4e3e\u5230\u8116\u5b50\u8fb9\uff0c\u7acb\u523b\u55b7\u5728\u4e86[npc.skin]\u4e0a\u3002", "[npc.Name]\u62ff\u51fa\u4e00\u74f6\u201c\u73ab\u7470\u9999\u6c34\u201d\uff0c\u4e3e\u5230\u4f60\u7684\u8116\u5b50\u8fb9\uff0c\u7acb\u523b\u55b7\u5728\u4e86[pc.skin]\u4e0a\u3002");
            }
        };
        GIFT_TEDDY_BEAR = new AbstractItemType(600, null, false, "\u6cf0\u8fea\u718a", "\u6cf0\u8fea\u718a", "\u4e00\u53ea\u53ef\u7231\u7684\u68d5\u8272\u6cf0\u8fea\u718a\uff0c\u62b1\u7740\u4e00\u4e2a\u7c89\u8272\u7684\u5fc3\uff0c\u4e0a\u9762\u7ee3\u7740\u201c\u62b1\u62b1\u6211\uff01\u201d\u3002[Ashley.speech(\u6ce8\u610f\uff0c\u8fd9\u4e0d\u662f\u4e2a\u6d3b\u7269\uff1b\u5b83\u5176\u5b9e\u5e76\u4e0d\u6e34\u671b\u4f60\u7684\u7231\uff0c\u4e5f\u4e0d\u80fd\u8ba9\u4f60\u514d\u53d7\u85cf\u5728\u5e8a\u5e95\u4e0b\u7684\u602a\u7269\u7684\u4f24\u5bb3\uff01)]", "giftTeddyBear", PresetColour.BASE_TAN, null, null, Rarity.UNCOMMON, null, Util.newArrayListOfValues(ItemTag.GIFT)){

            @Override
            public String getDescription() {
                if (Main.game.getPlayer().getLocationPlace().getPlaceType().equals(PlaceType.SHOPPING_ARCADE_ASHLEYS_SHOP)) {
                    return "\u4e00\u53ea\u53ef\u7231\u7684\u68d5\u8272\u6cf0\u8fea\u718a\uff0c\u62b1\u7740\u4e00\u4e2a\u7c89\u8272\u7684\u5fc3\uff0c\u4e0a\u9762\u7ee3\u7740\u201c\u62b1\u62b1\u6211\uff01\u201d\u3002[Ashley.speech(\u6ce8\u610f\uff0c\u8fd9\u4e0d\u662f\u4e2a\u6d3b\u7269\uff1b\u5b83\u5176\u5b9e\u5e76\u4e0d\u6e34\u671b\u4f60\u7684\u7231\uff0c\u4e5f\u4e0d\u80fd\u8ba9\u4f60\u514d\u53d7\u85cf\u5728\u5e8a\u5e95\u4e0b\u7684\u602a\u7269\u7684\u4f24\u5bb3\uff01)]";
                }
                return "\u4e00\u53ea\u53ef\u7231\u7684\u68d5\u8272\u6cf0\u8fea\u718a\uff0c\u62b1\u7740\u4e00\u4e2a\u7c89\u8272\u7684\u5fc3\uff0c\u4e0a\u9762\u7ee3\u7740\u201c\u62b1\u62b1\u6211\uff01\u201d\u3002";
            }

            @Override
            public String getUseName() {
                return "\u62e5\u62b1";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u62b1\u4e86\u62b1\u6cf0\u8fea\u718a\uff0c\u53c8\u677e\u53c8\u8f6f\u2026\u2026", "\u4f60\u8ba9[npc.name]\u62b1\u4e86\u62b1\u6cf0\u8fea\u718a\uff0c[npc.She]\u5f88\u60ca\u8bb6\u7adf\u7136\u80fd\u8fd9\u4e48\u677e\u8f6f\u2026\u2026", "[npc.Name]\u62b1\u4e86\u62b1\u6cf0\u8fea\u718a\uff0c[npc.She]\u60ca\u8bb6\u7adf\u7136\u80fd\u8fd9\u4e48\u677e\u8f6f\u2026\u2026", "[npc.Name]\u8ba9\u4f60\u62b1\u4e86\u62b1\u6cf0\u8fea\u718a\uff0c\u53c8\u677e\u53c8\u8f6f\u2026\u2026");
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }
        };
        EGGPLANT = new AbstractItemType(25, null, false, "\u8304\u5b50", "\u8304\u5b50", "\u4e00\u79cd\u6f02\u4eae\u7684\u70ed\u5e26\u591a\u5e74\u751f\u690d\u7269\uff0c\u901a\u5e38\u5728\u6e29\u5e26\u6c14\u5019\u4e0b\u4f5c\u4e3a\u4e0d\u8010\u5bd2\u6216\u534a\u8010\u5bd2\u7684\u4e00\u5e74\u751f\u690d\u7269\u683d\u57f9\u3002\u772f\u7740\u773c\u775b\u770b\u6709\u70b9\u50cf\u4e2a\u5c4c\u3002", "eggplant", PresetColour.GENERIC_ARCANE, null, null, Rarity.LEGENDARY, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.EGGPLANT)), Util.newArrayListOfValues(ItemTag.FOOD)){

            @Override
            public AbstractItemEffectType getEnchantmentEffect() {
                return ItemEffectType.EGGPLANT_POTION;
            }

            @Override
            public AbstractItemType getEnchantmentItemType(List<ItemEffect> effects) {
                return EGGPLANT_POTION;
            }

            @Override
            public String getUseName() {
                return "\u5403";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u5403\u4e86\u8304\u5b50\u3002\u82e6\u6da9\u7684\u53e3\u611f\u8ba9\u4f60\u5f88\u5931\u671b\u3002", "\u4f60\u8ba9[npc.Name]\u5403\u4e0b\u4e86\u8304\u5b50\u3002\u82e6\u6da9\u7684\u53e3\u611f\u8ba9\u4f60\u4eec\u5f88\u5931\u671b\u3002", "[npc.Name]\u62ff\u51fa\u4e00\u6839\u8304\u5b50\uff0c\u5403\u4e86\u4e0b\u53bb\u3002\u82e6\u6da9\u7684\u53e3\u611f\u8ba9\u4f60\u4eec\u5f88\u5931\u671b\u3002", "[npc.Name]\u62ff\u51fa\u4e00\u6839\u8304\u5b50\uff0c\u8ba9\u4f60\u5403\u4e86\u4e0b\u53bb\u3002\u82e6\u6da9\u7684\u53e3\u611f\u8ba9\u4f60\u4eec\u5f88\u5931\u671b\u3002");
            }
        };
        EGGPLANT_POTION = new AbstractItemType(250, null, false, "\u8304\u5b50\u836f\u5242", "\u8304\u5b50\u836f\u5242", "\u4e00\u74f6\u7531\u82e6\u6da9\u7684\u8304\u5b50\u679c\u8089\u5236\u6210\u7684\u836f\u5242\u3002\u5c31\u8ddf\u4f5c\u4e3a\u5176\u539f\u6599\u7684\u679c\u5b9e\u4e00\u6837\uff0c\u88c5\u6709\u836f\u6c34\u7684\u74f6\u5b50\u772f\u7740\u773c\u770b\u4e5f\u50cf\u4e2a\u5c4c\u3002", "eggplant_potion", PresetColour.GENERIC_ARCANE, null, null, Rarity.LEGENDARY, null, Util.newArrayListOfValues(ItemTag.DRINK)){

            @Override
            public boolean isTransformative() {
                return true;
            }

            @Override
            public String getUseName() {
                return "\u559d";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u4f60\u559d\u4e0b\u4e86\u8304\u5b50\u836f\u5242\uff0c\u6ca1\u60f3\u5230\u4e30\u5bcc\u800c\u590d\u6742\u7684\u5473\u9053\u8fd8\u633a\u597d\u559d\u3002", "\u4f60\u8ba9[npc.name]\u559d\u4e0b\u4e86\u8304\u5b50\u836f\u5242\uff0c\u6ca1\u60f3\u5230\u4e30\u5bcc\u800c\u590d\u6742\u7684\u5473\u9053\u8fd8\u633a\u597d\u559d\u3002", "[npc.Name]\u62ff\u51fa\u4e00\u74f6\u8304\u5b50\u836f\u5242\u559d\u4e86\u4e0b\u53bb\uff0c\u6ca1\u60f3\u5230\u4e30\u5bcc\u800c\u590d\u6742\u7684\u5473\u9053\u8fd8\u633a\u597d\u559d\u3002", "[npc.Name]\u62ff\u51fa\u4e00\u74f6\u8304\u5b50\u836f\u5242\u8ba9\u4f60\u559d\u4e86\u4e0b\u53bb\uff0c\u6ca1\u60f3\u5230\u4e30\u5bcc\u800c\u590d\u6742\u7684\u5473\u9053\u8fd8\u633a\u597d\u559d\u3002");
            }
        };
        ARTHURS_PACKAGE = new AbstractItemType(0, "", false, "\u4e9a\u745f\u7684\u5305\u88f9", "\u4e9a\u745f\u7684\u5305\u88f9", "\u4ece\u201c\u5965\u672f\u827a\u672f\u201d\u62ff\u56de\u6765\u7684\u5305\u88f9\uff0c\u9700\u8981\u4ea4\u7ed9\u4e9a\u745f\u3002", "arthursPackage", PresetColour.ANDROGYNOUS, null, null, Rarity.QUEST, null, null){

            @Override
            public String getUseName() {
                return "\u68c0\u67e5";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return ItemType.getGenericUseDescription(user, target, "\u5305\u88f9\u5f88\u5c0f\uff0c\u6bcf\u8fb9\u957f\u5927\u6982" + Units.size(20.0) + "\u3002\u5916\u9762\u5305\u88f9\u7740\u68d5\u8272\u7684\u7eb8\u677f\uff0c\u7528\u5305\u88c5\u80f6\u5e26\u5bc6\u5c01\u7740\u3002", "\u5305\u88f9\u5f88\u5c0f\uff0c\u6bcf\u8fb9\u957f\u5927\u6982" + Units.size(20.0) + "\u3002\u5916\u9762\u5305\u88f9\u7740\u68d5\u8272\u7684\u7eb8\u677f\uff0c\u7528\u5305\u88c5\u80f6\u5e26\u5bc6\u5c01\u7740\u3002", "\u5305\u88f9\u5f88\u5c0f\uff0c\u6bcf\u8fb9\u957f\u5927\u6982" + Units.size(20.0) + "\u3002\u5916\u9762\u5305\u88f9\u7740\u68d5\u8272\u7684\u7eb8\u677f\uff0c\u7528\u5305\u88c5\u80f6\u5e26\u5bc6\u5c01\u7740\u3002", "\u5305\u88f9\u5f88\u5c0f\uff0c\u6bcf\u8fb9\u957f\u5927\u6982" + Units.size(20.0) + "\u3002\u5916\u9762\u5305\u88f9\u7740\u68d5\u8272\u7684\u7eb8\u677f\uff0c\u7528\u5305\u88c5\u80f6\u5e26\u5bc6\u5c01\u7740\u3002");
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }
        };
        IMP_FORTRESS_ARCANE_KEY = new AbstractItemType(0, "", false, "\u83f2\u5c14\u897f\u4e9a\u7684\u94a5\u5319", "\u83f2\u5c14\u897f\u4e9a\u7684\u94a5\u5319", "\u4e00\u628a\u5965\u672f\u94a5\u5319\uff0c\u4ece\u5c48\u57ce\u533a\u5c0f\u6076\u9b54\u8981\u585e\u7684\u9996\u9886\u83f2\u5c14\u897f\u4e9a\u90a3\u91cc\u53d6\u5f97\u3002\u4e0e\u53e6\u4e24\u5ea7\u8981\u585e\u5904\u83b7\u5f97\u7684\u94a5\u5319\u7ec4\u5408\u4f7f\u7528\uff0c\u5c31\u80fd\u8fdb\u5165\u4e2d\u592e\u57ce\u5821\u3002", "impArcaneKey", PresetColour.CLOTHING_SILVER, PresetColour.GENERIC_ARCANE, null, Rarity.QUEST, null, null){

            @Override
            public String getUseName() {
                return "\u68c0\u67e5";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return UtilText.parse(user, "\u4f60\u5c06\u94a5\u5319\u5728[npc.hands]\u4e2d\u628a\u73a9\uff0c\u611f\u53d7\u5230\u4e86\u5176\u6563\u53d1\u51fa\u5fae\u5f31\u7684\u5965\u672f\u6d8c\u52a8\u3002", new ParserTag[0]);
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }
        };
        IMP_FORTRESS_ARCANE_KEY_2 = new AbstractItemType(0, "", false, "\u5353\u7279\u62c9\u514b\u65af\u7684\u94a5\u5319", "\u5353\u7279\u62c9\u514b\u65af\u7684\u94a5\u5319", "\u4e00\u628a\u5965\u672f\u94a5\u5319\uff0c\u4ece\u5c48\u57ce\u533a\u5c0f\u6076\u9b54\u8981\u585e\u7684\u9996\u9886\u5353\u7279\u62c9\u514b\u65af\u90a3\u91cc\u53d6\u5f97\u3002\u4e0e\u53e6\u4e24\u5ea7\u8981\u585e\u5904\u83b7\u5f97\u7684\u94a5\u5319\u7ec4\u5408\u4f7f\u7528\uff0c\u5c31\u80fd\u8fdb\u5165\u4e2d\u592e\u57ce\u5821\u3002", "impArcaneKey2", PresetColour.CLOTHING_STEEL, PresetColour.GENERIC_ARCANE, null, Rarity.QUEST, null, null){

            @Override
            public String getUseName() {
                return "\u68c0\u67e5";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return UtilText.parse(user, "\u4f60\u5c06\u94a5\u5319\u5728[npc.hands]\u4e2d\u628a\u73a9\uff0c\u611f\u53d7\u5230\u4e86\u5176\u6563\u53d1\u51fa\u5fae\u5f31\u7684\u5965\u672f\u6d8c\u52a8\u3002", new ParserTag[0]);
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }
        };
        IMP_FORTRESS_ARCANE_KEY_3 = new AbstractItemType(0, "", false, "\u5e0c\u5c14\u8389\u4e1d\u7684\u94a5\u5319", "\u5e0c\u5c14\u8389\u4e1d\u7684\u94a5\u5319", "\u4e00\u628a\u5965\u672f\u94a5\u5319\uff0c\u4ece\u5c48\u57ce\u533a\u5c0f\u6076\u9b54\u8981\u585e\u7684\u9996\u9886\u5e0c\u5c14\u8389\u4e1d\u90a3\u91cc\u53d6\u5f97\u3002\u4e0e\u53e6\u4e24\u5ea7\u8981\u585e\u5904\u83b7\u5f97\u7684\u94a5\u5319\u7ec4\u5408\u4f7f\u7528\uff0c\u5c31\u80fd\u8fdb\u5165\u4e2d\u592e\u57ce\u5821\u3002", "impArcaneKey3", PresetColour.CLOTHING_GOLD, PresetColour.GENERIC_ARCANE, null, Rarity.QUEST, null, null){

            @Override
            public String getUseName() {
                return "\u68c0\u67e5";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return UtilText.parse(user, "\u4f60\u5c06\u94a5\u5319\u5728[npc.hands]\u4e2d\u628a\u73a9\uff0c\u611f\u53d7\u5230\u4e86\u5176\u6563\u53d1\u51fa\u5fae\u5f31\u7684\u5965\u672f\u6d8c\u52a8\u3002", new ParserTag[0]);
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }
        };
        LYSSIETHS_RING = new AbstractItemType(0, "", false, "\u8389\u897f\u4e1d\u7684\u9677\u9631\u56fe\u7ae0\u6212\u6307", "\u8389\u897f\u4e1d\u7684\u9677\u9631\u56fe\u7ae0\u6212\u6307", "\u6212\u6307\u7531\u73ab\u7470\u91d1\u7cbe\u94f8\u800c\u6210\uff0c\u9576\u5d4c\u7740\u73cd\u8d35\u7684\u73e0\u5b9d\uff0c\u4e14\u5176\u4e0a\u6709\u9644\u9b54\uff0c\u53ea\u8981\u6234\u4e0a\u5c31\u4f1a\u88ab\u5974\u5f79\u3002\u5982\u679c\u4f60\u80fd\u9a97\u201c\u6697\u591c\u585e\u58ec\u201d\u6234\u4e0a\uff0c\u5175\u4e0d\u8840\u5203\u4fbf\u8d62\u5f97\u8389\u897f\u4e1d\u7684\u8d4f\u8bc6\u3002", "lyssiethsRing", PresetColour.CLOTHING_ROSE_GOLD, PresetColour.CLOTHING_RED_DARK, PresetColour.CLOTHING_ROSE_GOLD, Rarity.QUEST, null, null){

            @Override
            public String getUseName() {
                return "\u68c0\u67e5";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return UtilText.parse(user, "\u8fd9\u679a\u6212\u6307\u6478\u4e0a\u53bb\u6709\u4e00\u80a1\u6696\u6d41\uff0c\u610f\u5473\u7740\u5176\u5e26\u6709\u5f3a\u5927\u7684\u9644\u9b54\u3002\u6216\u8bb8\u4e00\u5207\u7ed3\u675f\u540e\uff0c\u8389\u897f\u4e1d\u4f1a\u8ba9\u4f60\u7559\u4e0b\u5b83\u4f5c\u4e3a\u5956\u52b1\u2026\u2026", new ParserTag[0]);
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }
        };
        OFFSPRING_MAP = new AbstractItemType(50000, "\u4e00\u5f20", false, "\u5965\u672f\u540e\u4ee3\u5730\u56fe", "\u5965\u672f\u540e\u4ee3\u5730\u56fe", "\u4e00\u5f20\u4ece\u5fa1\u57ce\u533a\u5e02\u653f\u5385\u83b7\u5f97\u7684\u5965\u672f\u9644\u9b54\u5730\u56fe\uff0c\u53ef\u4ee5\u8ffd\u8e2a\u5230\u4f60\u9644\u8fd1\u4efb\u4f55\u4e00\u4e2a\u5b69\u5b50\u7684\u5927\u81f4\u4f4d\u7f6e\u3002", "offspring_map", PresetColour.BASE_BROWN, null, null, Rarity.QUEST, Util.newArrayListOfValues(new ItemEffect(ItemEffectType.OFFSPRING_MAP)), null){

            @Override
            public String getUseName() {
                return "\u67e5\u9605";
            }

            @Override
            public boolean isAbleToBeUsedInSex() {
                return false;
            }

            @Override
            public boolean isAbleToBeUsedInCombatAllies() {
                return false;
            }

            @Override
            public boolean isAbleToBeUsed(GameCharacter user, GameCharacter target) {
                return target.isPlayer() && Main.game.getCharactersTreatingCellAsHome(Main.game.getPlayerCell()).size() == 0 && (Util.newArrayListOfValues(Encounter.DOMINION_ALLEY, Encounter.DOMINION_CANAL, Encounter.HARPY_NEST_WALKWAYS, Encounter.SUBMISSION_TUNNELS, Encounter.BAT_CAVERN, Encounter.getEncounterFromId("innoxia_elis_alleyway")).contains(target.getLocationPlace().getPlaceType().getCoreEncounterType()) || Main.game.getPlayer().getLocationPlaceType() == PlaceType.getPlaceTypeFromId("innoxia_fields_elis_town_alley"));
            }

            @Override
            public String getUnableToBeUsedDescription(GameCharacter user, GameCharacter target) {
                return "\u8981\u4f7f\u7528\u8fd9\u5f20\u5730\u56fe\uff0c\u4f60\u9700\u8981\u5728\u4ee5\u4e0b\u51e0\u79cd\u7c7b\u578b\u7684\u7a7a\u5730\u5757\u4e0a\uff1a\u5fa1\u57ce\u533a\u5c0f\u5df7\u3001\u5fa1\u57ce\u533a\u8fd0\u6cb3\u3001\u54c8\u6bd4\u5de2\u7a74\u901a\u9053\u3001\u5c48\u57ce\u533a\u96a7\u9053\u3001\u4f0a\u5229\u65af\u5c0f\u5df7\u3002";
            }

            @Override
            public String getUseTooltipDescription(GameCharacter user, GameCharacter target) {
                return "\u67e5\u9605\u5730\u56fe\u4ee5\u5bfb\u627e\u8be5\u533a\u57df\u662f\u5426\u6709\u4f60\u7684\u540e\u4ee3\u3002";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return "\u4f60\u67e5\u9605\u4e86\u5730\u56fe\u2026\u2026";
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }
        };
        CANDI_PERFUMES = new AbstractItemType(500, "", true, "\u574e\u8fea\u7684\u9999\u6c34", "\u574e\u8fea\u7684\u9999\u6c34", "\u4ece\u201c\u9b45\u9b54\u7684\u79d8\u5bc6\u201d\u7684\u51ef\u7279\u90a3\u91cc\u62ff\u6765\u7684\u51e0\u74f6\u9999\u6c34\u3002\u4f60\u9700\u8981\u4ea4\u7ed9\u6267\u6cd5\u8005\u603b\u90e8\u7684\u574e\u8fea\u3002", "candiPerfumes", PresetColour.BASE_ROSE, PresetColour.BASE_PURPLE_LIGHT, null, Rarity.QUEST, null, null){

            @Override
            public String getUseName() {
                return "\u68c0\u67e5";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return "\u8fd9\u51e0\u74f6\u9999\u6c34\u6ca1\u4ec0\u4e48\u7279\u522b\u7684\u3002\u8fd8\u662f\u8d76\u7d27\u4ea4\u7ed9\u574e\u8fea\u5427\u3002";
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }
        };
        CANDI_CONTRABAND = new AbstractItemType(1000, "", false, "\u8fdd\u7981\u54c1\u68d2\u68d2\u7cd6", "\u8fdd\u7981\u54c1\u68d2\u68d2\u7cd6", "\u88c5\u6ee1\u4e86\u8fdd\u7981\u54c1\u68d2\u68d2\u7cd6\u7684\u7bb1\u5b50\uff0c\u4ece\u54c8\u6bd4\u4e4b\u5de2\u7684\u6267\u6cd5\u8005\u90a3\u91cc\u53d6\u6765\uff0c\u574e\u8fea\u5bf9\u6b64\u5782\u6d8e\u6b32\u6ef4\u3002", "contrabandBox", PresetColour.BASE_PINK_DEEP, null, null, Rarity.QUEST, null, null){

            @Override
            public String getUseName() {
                return "\u68c0\u67e5";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return "\u7bb1\u5b50\u4e0a\u6807\u8bb0\u4e86\u51e0\u9053\u7ea2\u53c9\uff0c\u91cc\u9762\u7684\u4e1c\u897f\u663e\u7136\u67d0\u79cd\u7a0b\u5ea6\u4e0a\u6bd4\u8f83\u5371\u9669\u3002\u5c06\u7bb1\u5b50\u4ea4\u7ed9\u4f60\u7684\u6267\u6cd5\u8005\u66fe\u8bf4\u91cc\u9762\u7684\u68d2\u68d2\u7cd6\u662f\u4e00\u79cd\u6c38\u4e45\u6625\u836f\uff0c\u5e94\u5f53\u7acb\u5373\u88ab\u5c01\u9501\u5728\u5b89\u5168\u5b58\u50a8\u4e2d\u3002";
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }
        };
        CANDI_HUNDRED_KISSES = new AbstractItemType(50000, "", false, "\u201c\u767e\u4e07\u4e4b\u543b\u201d", "\u201c\u767e\u4e07\u4e4b\u543b\u201d", "\u4e00\u76d2\u9650\u5b9a\u6b3e\u7684\u53e3\u7ea2\uff0c\u5305\u542b\u7740\u4e0a\u767e\u79cd\u4e0d\u540c\u7684\u989c\u8272\uff0c\u7531\u6574\u4e2a\u5fa1\u57ce\u533a\u6700\u72ec\u7279\u3001\u6700\u9ad8\u6863\u7684\u5316\u5986\u54c1\u516c\u53f8\u751f\u4ea7\u3002", "candiHundredKisses", PresetColour.BASE_PINK_DEEP, null, null, Rarity.QUEST, null, null){

            @Override
            public String getUseName() {
                return "\u68c0\u67e5";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return "\u968f\u4fbf\u770b\u4e00\u773c\u5c31\u8fd9\u534e\u4e3d\u7684\u76d2\u5b50\uff0c\u5c31\u80fd\u77e5\u9053\u91cc\u9762\u88c5\u7740\u7684\u7edd\u5bf9\u662f\u7528\u94b1\u80fd\u4e70\u5230\u6700\u4e0a\u7b49\u7684\u53e3\u7ea2\u3002";
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }
        };
        RESONANCE_STONE = new AbstractItemType(0, "", false, "\u514b\u83b1\u5c14\u7684\u56de\u58f0\u77f3", "\u514b\u83b1\u5c14\u7684\u56de\u58f0\u77f3", "\u4e00\u5757\u5149\u6ed1\u7684\u5c0f\u578b\u7403\u4f53\uff0c\u5706\u5468\u4e0a\u6709\u4e00\u9053\u6d45\u6d45\u7684\u51f9\u69fd\u3002\u901a\u5e38\u7981\u6b62\u5e73\u6c11\u6240\u6709\uff0c\u4f46\u514b\u83b1\u5c14\u7ed9\u4e86\u4f60\u4e00\u5757\uff0c\u65b9\u4fbf\u4f60\u5411\u9f20\u7a9f\u65c1\u8fb9\u7684SWORD\u6267\u6cd5\u8005\u53d1\u9001\u4fe1\u53f7\u3002", "resonanceStone", PresetColour.CLOTHING_PURPLE_VERY_DARK, null, null, Rarity.QUEST, null, null){

            @Override
            public String getUseName() {
                return "\u68c0\u67e5";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return "\u8fd9\u5757\u56de\u58f0\u77f3\u7531\u67d0\u79cd\u7cbe\u5fc3\u629b\u5149\u8fc7\u7684\u5ca9\u77f3\u5236\u6210\uff0c\u53ea\u8981\u5c06\u4e0a\u4e0b\u4e24\u4e2a\u534a\u7403\u671d\u4e0d\u540c\u65b9\u5411\u626d\u52a8\uff0c\u5c31\u80fd\u5c06\u5176\u542f\u52a8\uff0c\u5411\u8fde\u63a5\u7684\u5176\u4ed6\u56de\u58f0\u77f3\u53d1\u9001\u4fe1\u53f7\u3002\u514b\u83b1\u5c14\u544a\u8bc9\u8fc7\u4f60\uff0c\u8fd9\u4e00\u5757\u4f1a\u5411SWORD\u6267\u6cd5\u8005\u53d1\u51fa\u901a\u77e5\uff0c\u8ba9\u4ed6\u4eec\u5bf9\u9f20\u7a9f\u53d1\u52a8\u7a81\u88ad\uff0c\u4f60\u5e94\u5f53\u5728\u786e\u8ba4\u6587\u52a0\u5728\u573a\u65f6\u518d\u4f7f\u7528\u3002";
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }
        };
        PAINT_CAN_PREMIUM = new AbstractItemType(1500, "\u4e00\u7f50", false, "\u201c\u7d2b\u661f\u201d\u91d1\u8272\u6cb9\u6f06", "\u201c\u7d2b\u661f\u201d\u91d1\u8272\u6cb9\u6f06", "\u4e00\u7f50\u91d1\u8272\u6cb9\u6f06\uff0c\u5e26\u6709\u9ad8\u7ea7\u7684\u201c\u7d2b\u661f\u201d\u6807\u7b7e\uff0c\u4ece\u201c\u963f\u683c\u65af\u7684DIY\u4ed3\u5e93\u201d\u4e70\u6765\u7684\u3002\u5e0c\u671b\u6d77\u4f26\u5a1c\u660e\u767d\u8fd9\u53ef\u4e0d\u662f\u5c0f\u4ef7\u94b1\u2026\u2026", "paint_can", PresetColour.CLOTHING_GOLD, PresetColour.CLOTHING_PURPLE_DARK, null, Rarity.QUEST, null, null){

            @Override
            public String getUseName() {
                return "\u68c0\u67e5";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return "\u9664\u975e\u662f\u771f\u6b63\u7684\u4e13\u4e1a\u6f06\u5320\uff0c\u4e0d\u7136\u6ca1\u6709\u4eba\u4f1a\u76f8\u4fe1\u4f60\u4e3a\u4e86\u4e70\u8fd9\u7f50\u201c\u7d2b\u661f\u201d\u6cb9\u6f06\u82b1\u4e86\u591a\u5c11\u94b1\u2026\u2026";
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }

            @Override
            public List<AbstractCoreType> getAdditionalDiscoveryTypes() {
                return Util.newArrayListOfValues(PAINT_CAN);
            }
        };
        PAINT_CAN = new AbstractItemType(250, "\u4e00\u7f50", false, "\u201c\u94dc\u661f\u201d\u91d1\u8272\u6cb9\u6f06", "\u201c\u94dc\u661f\u201d\u91d1\u8272\u6cb9\u6f06", "\u4e00\u7f50\u91d1\u8272\u6cb9\u6f06\uff0c\u5e26\u6709\u666e\u901a\u7684\u201c\u94dc\u661f\u201d\u6807\u7b7e\uff0c\u4ece\u201c\u963f\u683c\u65af\u7684DIY\u4ed3\u5e93\u201d\u4e70\u6765\u7684\u3002\u5e0c\u671b\u6d77\u4f26\u5a1c\u4e0d\u4f1a\u592a\u5931\u671b\u2026\u2026", "paint_can", PresetColour.CLOTHING_GOLD, PresetColour.CLOTHING_BRONZE, null, Rarity.QUEST, null, null){

            @Override
            public String getUseName() {
                return "\u68c0\u67e5";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return "\u5c3d\u7ba1\u4e0d\u662f\u6d77\u4f26\u5a1c\u6307\u5b9a\u7684\u9ad8\u7ea7\u201c\u7d2b\u661f\u201d\u6cb9\u6f06\uff0c\u4f46\u4f60\u80af\u5b9a\u8fd9\u4e2a\u5df2\u7ecf\u8db3\u591f\u5e94\u4ed8\u4e86\u2026\u2026";
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }

            @Override
            public List<AbstractCoreType> getAdditionalDiscoveryTypes() {
                return Util.newArrayListOfValues(PAINT_CAN_PREMIUM);
            }
        };
        ROLLED_UP_POSTERS = new AbstractItemType(0, "\u534a\u6253", true, "\u5377\u8d77\u6765\u7684\u9644\u9b54\u6d77\u62a5", "\u5377\u8d77\u6765\u7684\u9644\u9b54\u6d77\u62a5", "\u534a\u6253\u5377\u8d77\u6765\u7684\u9644\u9b54\u6d77\u62a5\uff0c\u6d77\u4f26\u5a1c\u8ba9\u4f60\u5f20\u8d34\u5728\u5974\u96b6\u5df7\u5165\u53e3\u8fb9\u7684\u5899\u4e0a\u3002\u6bcf\u4e00\u5f20\u4e0a\u90fd\u5c55\u793a\u7740\u9644\u9b54\u8fc7\u7684\u52a8\u6001\u56fe\u50cf\uff0c\u4e00\u53ea\u98ce\u59ff\u7ef0\u7ea6\u7684\u54c8\u6bd4\u8eab\u7740\u66b4\u9732\u7684\u6bd4\u57fa\u5c3c\uff0c\u6446\u51fa\u8bf1\u60d1\u7684\u59ff\u52bf\u3002", "rolled_up_posters", PresetColour.CLOTHING_DESATURATED_BROWN, null, null, Rarity.QUEST, null, null){

            @Override
            public String getUseName() {
                return "\u68c0\u67e5";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return "\u5c3d\u7ba1\u662f\u7528\u6765\u7ed9\u201c\u6d77\u4f26\u5a1c\u7cbe\u54c1\u5e97\u201d\u6253\u5e7f\u544a\u7528\u7684\uff0c\u4f46\u5728\u6d77\u62a5\u4e0a\u5374\u4e1d\u6beb\u6ca1\u6709\u63d0\u53ca\u90a3\u4f4d\u54c8\u6bd4\u7684\u5e97\u94fa\u3002\u53cd\u800c\u6bcf\u4e00\u5f20\u4e0a\u90fd\u5c55\u793a\u7740\u9644\u9b54\u8fc7\u7684\u52a8\u6001\u56fe\u50cf\uff0c\u4e00\u53ea\u98ce\u59ff\u7ef0\u7ea6\u7684\u54c8\u6bd4\u8eab\u7740\u66b4\u9732\u7684\u6bd4\u57fa\u5c3c\uff0c\u6446\u51fa\u8bf1\u60d1\u7684\u59ff\u52bf\u3002\u552f\u4e00\u53ef\u89c1\u7684\u6587\u5b57\u5728\u6d77\u62a5\u5e95\u90e8\uff0c\u53ea\u662f\u5355\u7eaf\u5730\u7528\u4f18\u7f8e\u7684\u8fde\u7b14\u5199\u7740\u201c\u6d77\u4f26\u5a1c\u201d\u51e0\u4e2a\u5b57\u3002";
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }
        };
        NATALYA_BUSINESS_CARD = new AbstractItemType(0, "", false, "\u5a1c\u5854\u8389\u4e9a\u7684\u540d\u7247", "\u5a1c\u5854\u8389\u4e9a\u7684\u540d\u7247", "\u4e00\u5f20\u5a1c\u5854\u8389\u4e9a\u7ed9\u4f60\u7684\u540d\u7247\uff0c\u5979\u662f\u4e2a\u5f81\u670d\u6b32\u5f88\u5f3a\u7684\u6076\u9b54\u534a\u4eba\u9a6c\uff0c\u62c5\u4efb\u7740\u5feb\u9012\u516c\u53f8\u201c\u5fa1\u57ce\u901f\u9012\u201d\u7684\u201c\u9a6c\u573a\u4e3b\u201d\u3002\u540d\u7247\u4e0a\u5370\u7740\u7684\u5730\u5740\u6307\u5f15\u4f60\u524d\u5f80\u5fa1\u57ce\u533a\u7684\u4ed3\u5e93\u533a\u3002", "natalya_business_card", PresetColour.CLOTHING_WHITE, null, null, Rarity.QUEST, null, null){

            @Override
            public String getUseName() {
                return "\u68c0\u67e5";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return "\u5a1c\u5854\u8389\u4e9a\u7684\u540d\u7247\u4e0a\u5199\u7740\u5979\u7684\u540d\u5b57\u548c\u804c\u4f4d\u201c\u9a6c\u573a\u4e3b\u201d\u3002\u5979\u4ece\u4e8b\u7684\u516c\u53f8\u201c\u5fa1\u57ce\u901f\u9012\u201d\u7684\u5730\u5740\u4e5f\u5199\u5f97\u6e05\u6e05\u695a\u695a\uff0c\u6b63\u5728\u5fa1\u57ce\u533a\u7684\u4ed3\u5e93\u533a\u3002";
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }
        };
        NATALYA_BUSINESS_CARD_STAMPED = new AbstractItemType(0, "", false, "\u5a1c\u5854\u8389\u4e9a\u7684\u540d\u7247(\u76d6\u7ae0)", "\u5a1c\u5854\u8389\u4e9a\u7684\u540d\u7247(\u76d6\u7ae0)", "\u4e00\u5f20\u5a1c\u5854\u8389\u4e9a\u7ed9\u4f60\u7684\u540d\u7247\uff0c\u5979\u662f\u4e2a\u5f81\u670d\u6b32\u5f88\u5f3a\u7684\u6076\u9b54\u534a\u4eba\u9a6c\uff0c\u62c5\u4efb\u7740\u5feb\u9012\u516c\u53f8\u201c\u5fa1\u57ce\u901f\u9012\u201d\u7684\u201c\u9a6c\u573a\u4e3b\u201d\u3002\u540d\u7247\u4e0a\u5370\u7740\u7684\u5730\u5740\u6307\u5f15\u4f60\u524d\u5f80\u5fa1\u57ce\u533a\u7684\u4ed3\u5e93\u533a\u3002", "natalya_business_card_stamped", PresetColour.CLOTHING_WHITE, null, null, Rarity.QUEST, null, null){

            @Override
            public String getUseName() {
                return "\u68c0\u67e5";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return "\u5a1c\u5854\u8389\u4e9a\u7684\u540d\u7247\u4e0a\u5199\u7740\u5979\u7684\u540d\u5b57\u548c\u804c\u4f4d\u201c\u9a6c\u573a\u4e3b\u201d\u3002\u5979\u4ece\u4e8b\u7684\u516c\u53f8\u201c\u5fa1\u57ce\u901f\u9012\u201d\u7684\u5730\u5740\u4e5f\u5199\u5f97\u6e05\u6e05\u695a\u695a\uff0c\u6b63\u5728\u5fa1\u57ce\u533a\u7684\u4ed3\u5e93\u533a\u3002\u8fd9\u5f20\u540d\u7247\u4e0a\u5df2\u7ecf\u7531\u5a1c\u5854\u8389\u4e9a\u4eb2\u81ea\u76d6\u7ae0\uff0c\u51c6\u8bb8\u4f60\u5728\u5fa1\u57ce\u901f\u9012\u7684\u4ed3\u5e93\u4e2d\u7545\u901a\u65e0\u963b\u3002";
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }
        };
        SLAVER_LICENSE = new AbstractItemType(5000, "", false, "\u8d29\u5974\u8bb8\u53ef", "\u8d29\u5974\u8bb8\u53ef", "\u4e00\u4efd\u5b98\u65b9\u6587\u4ef6\uff0c\u58f0\u660e\u4f60\u5728\u6cd5\u5f8b\u4e0a\u6709\u6743\u62e5\u6709\u3001\u8d2d\u4e70\u3001\u51fa\u552e\u751a\u81f3\u6355\u83b7\u5974\u96b6\u3002\u867d\u7136\u8d29\u5974\u8bb8\u53ef\u6781\u96be\u83b7\u5f97\uff0c\u4f46\u53ea\u6709\u5bf9\u5176\u5408\u6cd5\u62e5\u6709\u8005\u6765\u8bf4\u624d\u771f\u6b63\u6709\u4ef7\u503c\u2026\u2026", "slaver_license", PresetColour.CLOTHING_WHITE, null, null, Rarity.QUEST, null, null){

            @Override
            public String getUseName() {
                return "\u68c0\u67e5";
            }

            @Override
            public String getUseDescription(GameCharacter user, GameCharacter target) {
                return "\u8fd9\u5f20\u8d29\u5974\u8bb8\u53ef\u7531\u4e00\u5f20\u9ad8\u8d28\u91cf\u7684\u539a\u7eb8\u5370\u5237\u3002\u4e0a\u9762\u5f88\u6e05\u695a\u5730\u5370\u7740\u4f60\u7684\u540d\u5b57\uff0c\u8fd8\u6709\u82ac\u5947\u7684\u7b7e\u540d\u3002";
            }

            @Override
            public boolean isConsumedOnUse() {
                return false;
            }
        };
        dominionAlleywayItems = new ArrayList<AbstractItemType>();
        submissionTunnelItems = new ArrayList<AbstractItemType>();
        batCavernItems = new ArrayList<AbstractItemType>();
        elisAlleywayItems = new ArrayList<AbstractItemType>();
        essences = new ArrayList<AbstractItemType>();
        allItems = new ArrayList<AbstractItemType>();
        moddedItems = new ArrayList<AbstractItemType>();
        subspeciesBookId = new HashMap<AbstractSubspecies, String>();
        itemToIdMap = new HashMap<AbstractItemType, String>();
        idToItemMap = new HashMap<String, AbstractItemType>();
        moddedItems = new ArrayList<AbstractItemType>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/items/items");
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                try {
                    String string = innerEntry.getKey();
                    AbstractItemType abstractItemType = new AbstractItemType(innerEntry.getValue(), entry.getKey(), true){};
                    moddedItems.add(abstractItemType);
                    itemToIdMap.put(abstractItemType, string);
                    idToItemMap.put(string, abstractItemType);
                }
                catch (Exception exception) {
                    System.err.println("Loading modded item failed at 'ItemType'. File path: " + innerEntry.getValue().getAbsolutePath());
                    System.err.println("Actual exception: ");
                    exception.printStackTrace(System.err);
                }
            }
        }
        allItems.addAll(moddedItems);
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/items");
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> entry2 : entry.getValue().entrySet()) {
                try {
                    String string = entry2.getKey();
                    AbstractItemType ct = new AbstractItemType(entry2.getValue(), entry.getKey(), false){};
                    allItems.add(ct);
                    itemToIdMap.put(ct, string);
                    idToItemMap.put(string, ct);
                }
                catch (Exception exception) {
                    System.err.println("Loading item failed at 'ItemType'. File path: " + entry2.getValue().getAbsolutePath());
                    System.err.println("Actual exception: ");
                    exception.printStackTrace(System.err);
                }
            }
        }
        for (AbstractItemType abstractItemType : allItems) {
            abstractItemType.getSVGString();
        }
        Field[] fieldArray2 = fieldArray = ItemType.class.getFields();
        int n = fieldArray2.length;
        boolean bl = false;
        while (var5_24 < n) {
            Field field = fieldArray2[var5_24];
            if (AbstractItemType.class.isAssignableFrom(field.getType())) {
                try {
                    AbstractItemType item = (AbstractItemType)field.get(null);
                    itemToIdMap.put(item, field.getName());
                    idToItemMap.put(field.getName(), item);
                    allItems.add(item);
                    if (item.getItemTags().contains((Object)ItemTag.ESSENCE)) {
                        essences.add(item);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            ++var5_24;
        }
        Spell[] spellArray = Spell.values();
        n = spellArray.length;
        boolean bl2 = false;
        while (var5_26 < n) {
            final Spell spell = spellArray[var5_26];
            if (spell.isSpellBook()) {
                ArrayList<String> effectsString = Util.newArrayListOfValues("[style.boldExcellent(\u6c38\u4e45)]\u4e60\u5f97\u6cd5\u672f\u201c<b style='color:" + spell.getSpellSchool().getColour().toWebHexString() + ";'>" + spell.getName() + "</b>\u201d\u3002");
                if (spell == Spell.ELEMENTAL_EARTH) {
                    effectsString.add("Adds " + Subspecies.ELEMENTAL_EARTH.getName(null) + " encyclopedia entry.");
                } else if (spell == Spell.ELEMENTAL_WATER) {
                    effectsString.add("Adds " + Subspecies.ELEMENTAL_WATER.getName(null) + " encyclopedia entry.");
                } else if (spell == Spell.ELEMENTAL_AIR) {
                    effectsString.add("Adds " + Subspecies.ELEMENTAL_AIR.getName(null) + " encyclopedia entry.");
                } else if (spell == Spell.ELEMENTAL_FIRE) {
                    effectsString.add("Adds " + Subspecies.ELEMENTAL_FIRE.getName(null) + " encyclopedia entry.");
                } else if (spell == Spell.ELEMENTAL_ARCANE) {
                    effectsString.add("Adds " + Subspecies.ELEMENTAL_ARCANE.getName(null) + " encyclopedia entry.");
                }
                AbstractItemEffectType effectType = new AbstractItemEffectType(effectsString, spell.getSpellSchool().getColour()){

                    @Override
                    public String itemEffectOverride(TFModifier primaryModifier, TFModifier secondaryModifier, TFPotency potency, int limit, GameCharacter user, GameCharacter target, ItemEffectTimer timer) {
                        boolean hasSpell = target.hasSpell(spell);
                        target.addSpell(spell);
                        String raceKnowledgeGained = "";
                        if (target.isPlayer()) {
                            if (spell == Spell.ELEMENTAL_EARTH) {
                                raceKnowledgeGained = 51.getBookEffect(target, Subspecies.ELEMENTAL_EARTH, null, true);
                            } else if (spell == Spell.ELEMENTAL_WATER) {
                                raceKnowledgeGained = 51.getBookEffect(target, Subspecies.ELEMENTAL_WATER, null, true);
                            } else if (spell == Spell.ELEMENTAL_AIR) {
                                raceKnowledgeGained = 51.getBookEffect(target, Subspecies.ELEMENTAL_AIR, null, true);
                            } else if (spell == Spell.ELEMENTAL_FIRE) {
                                raceKnowledgeGained = 51.getBookEffect(target, Subspecies.ELEMENTAL_FIRE, null, true);
                            } else if (spell == Spell.ELEMENTAL_ARCANE) {
                                raceKnowledgeGained = 51.getBookEffect(target, Subspecies.ELEMENTAL_ARCANE, null, true);
                            }
                        }
                        if (hasSpell) {
                            if (target.isPlayer()) {
                                return "<p style='text-align:center'><i><b style='color:" + spell.getSpellSchool().getColour().toWebHexString() + ";'>" + spell.getName() + ":</b>" + spell.getDescription(target) + "</i></p><p>\u518d\u6b21\u901a\u8bfb\u4e86\u8fd9\u672c\u6cd5\u672f\u4e66\uff0c\u4f60\u5f88\u5feb\u5c31\u610f\u8bc6\u5230\u81ea\u5df1\u5df2\u7ecf\u5b8c\u5168\u638c\u63e1\u4e86\u6cd5\u672f\u201c" + spell.getName() + "\u201d\u76f8\u5173\u7684\u77e5\u8bc6\u3002\u9664\u4e86\u51e0\u5f20\u6076\u9b54\u91ca\u653e\u8be5\u6cd5\u672f\u65f6\u7684\u751f\u52a8\u56fe\u50cf\uff0c\u8fd9\u672c\u4e66\u4e2d\u5df2\u7ecf\u6ca1\u51e0\u9875\u80fd\u5f15\u8d77\u4f60\u7684\u6ce8\u610f\u4e86\uff0c\u6ca1\u8fc7\u51e0\u5206\u949f\u4f60\u5c31\u5408\u4e0a\u4e86\u4e66\uff0c\u5e76\u6ca1\u6709\u5b66\u5230\u4ec0\u4e48\u65b0\u4e1c\u897f\u2026\u2026</p>" + raceKnowledgeGained;
                            }
                            return "<p style='text-align:center'><i><b style='color:" + spell.getSpellSchool().getColour().toWebHexString() + ";'>" + spell.getName() + ":</b>" + spell.getDescription(target) + "</i></p><p>" + UtilText.parse(target, "\u518d\u6b21\u901a\u8bfb\u4e86\u8fd9\u672c\u6cd5\u672f\u4e66\uff0c[npc.Name]\u5f88\u5feb\u5c31\u610f\u8bc6\u5230\u81ea\u5df1\u5df2\u7ecf\u5b8c\u5168\u638c\u63e1\u4e86\u6cd5\u672f\u201c" + spell.getName() + "\u201d\u76f8\u5173\u7684\u77e5\u8bc6\u3002\u9664\u4e86\u51e0\u5f20\u6076\u9b54\u91ca\u653e\u8be5\u6cd5\u672f\u65f6\u7684\u751f\u52a8\u56fe\u50cf\uff0c\u8fd9\u672c\u4e66\u4e2d\u5df2\u7ecf\u6ca1\u51e0\u9875\u80fd\u5f15\u8d77[npc.her]\u7684\u6ce8\u610f\u4e86\uff0c\u6ca1\u8fc7\u51e0\u5206\u949f[npc.she]\u5c31\u5408\u4e0a\u4e86\u4e66\uff0c\u5e76\u6ca1\u6709\u5b66\u5230\u4ec0\u4e48\u65b0\u4e1c\u897f\u2026\u2026", new ParserTag[0]) + "</p>";
                        }
                        if (target.isPlayer()) {
                            return "<p style='text-align:center'><i><b style='color:" + spell.getSpellSchool().getColour().toWebHexString() + ";'>" + spell.getName() + ":</b>" + spell.getDescription(target) + "</i></p><p>\u4f60\u901a\u8bfb\u4e86\u4e00\u4e0b\u8fd9\u672c\u4e66\uff0c\u53d1\u73b0\u5927\u90e8\u5206\u5185\u5bb9\u90fd\u5728\u6559\u8bfb\u8005\u8bad\u7ec3\u5965\u672f\u7075\u6c14\uff0c\u4ee5\u8fbe\u5230\u91ca\u653e\u8be5\u6cd5\u672f\u7684\u6700\u4f4e\u95e8\u69db\u3002\u9274\u4e8e\u4f60\u7684\u7075\u6c14\u5df2\u7ecf\u975e\u5e38\u5f3a\u5927\uff0c\u8fd9\u4e9b\u6bb5\u843d\u5bf9\u4f60\u6765\u8bf4\u6beb\u65e0\u7528\u5904\u3002\u4f60\u8fc5\u901f\u5730\u7ffb\u5230\u6700\u540e\u51e0\u7ae0\uff0c\u8fd9\u4e9b\u7ae0\u8282\u8be6\u7ec6\u4ecb\u7ecd\u4e86\u5982\u4f55\u96c6\u4e2d\u4f60\u7684\u5965\u672f\u7075\u6c14\u6765\u65bd\u653e\u6cd5\u672f\u201c<i>" + spell.getName() + "</i>\u201d\u3002\u4f60\u6ca1\u82b1\u591a\u957f\u65f6\u95f4\u5c31\u5927\u81f4\u4e86\u89e3\u4e86\u5e94\u8be5\u600e\u4e48\u505a\uff0c\u5728\u5b8c\u6210\u4e86\u4e66\u4e2d\u7684\u7ec3\u4e60\u4e4b\u540e\uff0c\u4f60\u81ea\u4fe1\u5730\u8ba4\u4e3a\u81ea\u5df1\u53ef\u4ee5\u968f\u65f6\u65bd\u5c55\u8fd9\u4e2a\u6cd5\u672f\u3002</p><p style='text-align:center;'>\u4f60\u5b66\u4e60\u4e86<b style='color:" + spell.getSpellSchool().getColour().toWebHexString() + ";'>" + spell.getName() + "</b>\u6cd5\u672f\uff01<br/><i>\u6cd5\u672f\u4e66\u5b8c\u6210\u4e86\u5b83\u7684\u4f7f\u547d\uff0c\u5728\u4e00\u9053\u7d2b\u5149\u4e2d\u6d88\u5931\u4e86\uff01</i><br/>[style.italicsExcellent(\u6cd5\u672f\u4e66\u5df2\u88ab\u6dfb\u52a0\u5230\u8389\u83b1\u96c5\u7684\u56fe\u4e66\u9986\u4e2d\uff01)]</p>" + raceKnowledgeGained;
                        }
                        return "<p style='text-align:center'><i><b style='color:" + spell.getSpellSchool().getColour().toWebHexString() + ";'>" + spell.getName() + ":</b>" + spell.getDescription(target) + "</i></p><p>" + UtilText.parse(target, "[npc.Name]\u901a\u8bfb\u4e86\u4e00\u4e0b\u8fd9\u672c\u4e66\uff0c\u53d1\u73b0\u5927\u90e8\u5206\u5185\u5bb9\u90fd\u5728\u6559\u8bfb\u8005\u8bad\u7ec3\u5965\u672f\u7075\u6c14\uff0c\u4ee5\u8fbe\u5230\u91ca\u653e\u8be5\u6cd5\u672f\u7684\u6700\u4f4e\u95e8\u69db\u3002\u9274\u4e8e[npc.her]\u7684\u7075\u6c14\u5df2\u7ecf\u8db3\u591f\u5f3a\u5927\uff0c\u8fd9\u4e9b\u6bb5\u843d\u5bf9\u4e8e[npc.herHim]\u6beb\u65e0\u7528\u5904\uff0c[npc.she]\u8fc5\u901f\u5730\u7ffb\u5230\u6700\u540e\u51e0\u7ae0\u3002\u8fd9\u4e9b\u7ae0\u8282\u8be6\u7ec6\u4ecb\u7ecd\u4e86\u5982\u4f55\u96c6\u4e2d[npc.her]\u7684\u5965\u672f\u7075\u6c14\u6765\u65bd\u653e\u6cd5\u672f\u201c<i>" + spell.getName() + "</i>\u201d\u3002[npc.herHim]\u6ca1\u82b1\u591a\u957f\u65f6\u95f4\u5c31\u5927\u81f4\u4e86\u89e3\u4e86\u5e94\u8be5\u600e\u4e48\u505a\uff0c\u5728\u5b8c\u6210\u4e86\u4e66\u4e2d\u7684\u7ec3\u4e60\u4e4b\u540e\uff0c[npc.herHim]\u81ea\u4fe1\u5730\u8ba4\u4e3a\u81ea\u5df1\u53ef\u4ee5\u968f\u65f6\u65bd\u5c55\u8fd9\u4e2a\u6cd5\u672f\u3002", new ParserTag[0]) + "</p><p style='text-align:center;'>" + UtilText.parse(target, "[npc.Name]\u4e60\u5f97\u4e86\u6cd5\u672f<b style='color:" + spell.getSpellSchool().getColour().toWebHexString() + ";'>" + spell.getName() + "</b>\uff01", new ParserTag[0]) + "<br/><i>\u6cd5\u672f\u4e66\u5b8c\u6210\u4e86\u5b83\u7684\u4f7f\u547d\uff0c\u5728\u4e00\u9053\u7d2b\u5149\u4e2d\u6d88\u5931\u4e86\uff01</i></p>";
                    }
                };
                ItemEffectType.addAbstractItemEffectToIds("EFFECT_SPELL_" + String.valueOf((Object)spell), effectType);
                int value = 2500;
                switch (spell) {
                    case ARCANE_AROUSAL: 
                    case ICE_SHARD: 
                    case POISON_VAPOURS: 
                    case FIREBALL: 
                    case SLAM: {
                        break;
                    }
                    case ARCANE_CLOUD: 
                    case FLASH: 
                    case RAIN_CLOUD: 
                    case TELEKENETIC_SHOWER: 
                    case TELEPATHIC_COMMUNICATION: 
                    case VACUUM: {
                        value = 5000;
                        break;
                    }
                    case STONE_SHELL: 
                    case SOOTHING_WATERS: 
                    case PROTECTIVE_GUSTS: 
                    case CLOAK_OF_FLAMES: 
                    case CLEANSE: 
                    case STEAL: {
                        value = 10000;
                        break;
                    }
                    case ELEMENTAL_AIR: 
                    case ELEMENTAL_ARCANE: 
                    case ELEMENTAL_EARTH: 
                    case ELEMENTAL_FIRE: 
                    case ELEMENTAL_WATER: {
                        value = 25000;
                        break;
                    }
                    case LILITHS_COMMAND: 
                    case TELEPORT: {
                        value = 1000000;
                        break;
                    }
                }
                AbstractItemType spellBook = new AbstractItemType(value, null, false, "\u6cd5\u672f\u4e66\uff1a" + spell.getName(), "\u6cd5\u672f\u4e66\uff1a" + spell.getName(), "\u4e00\u672c\u8d85\u539a\u7684\u5965\u672f\u5b9d\u5178\uff0c\u5185\u542b\u624b\u628a\u624b\u7684\u201c" + spell.getName() + "\u201d\u4ece\u5165\u95e8\u5230\u7cbe\u901a\u3002\u9605\u8bfb\u6b64\u4e66\u540e\uff0c\u4fbf\u80fd\u4e60\u5f97\u8be5\u6cd5\u672f\u3002", "spell_book", spell.getSpellSchool().getColour(), null, null, Rarity.LEGENDARY, Util.newArrayListOfValues(new ItemEffect(effectType)), Util.newArrayListOfValues(ItemTag.SPELL_BOOK)){

                    @Override
                    public String getSVGString() {
                        return super.getSVGString() + "<div style='width:60%;height:60%;position:absolute;left:0;top:0;'>" + spell.getSVGString() + "</div>";
                    }

                    @Override
                    public boolean isAbleToBeUsed(GameCharacter user, GameCharacter target) {
                        return (target.isPlayer() || target.getAttributeValue(Attribute.MAJOR_ARCANE) >= (float)IntelligenceLevel.ONE_AVERAGE.getMinimumValue()) && !target.isElemental();
                    }

                    @Override
                    public String getUnableToBeUsedDescription(GameCharacter user, GameCharacter target) {
                        if (target.isPlayer()) {
                            return "\u4f60\u5df2\u7ecf\u77e5\u9053\u600e\u4e48\u4f7f\u7528\u8fd9\u4e2a\u6cd5\u672f\u4e86\uff01";
                        }
                        if (target.isElemental()) {
                            return UtilText.parse(target, "\u5c31\u50cf\u5176\u4ed6\u5143\u7d20\u4f53\u4e00\u6837\uff0c[npc.Name]\u4e0d\u80fd\u4ece\u4e66\u4e2d\u5b66\u4e60\u6cd5\u672f\u3002\u76f8\u53cd[npc.she]\u9700\u8981\u4e13\u6ce8\u4e8e\u63d0\u9ad8\u5bf9\u4e8e\u5965\u672f\u7684\u7406\u89e3\uff0c\u4ece\u800c\u624d\u80fd\u5b66\u4e60\u65b0\u6cd5\u672f\u3002(\u5143\u7d20\u4f53\u901a\u8fc7\u5929\u8d4b\u6811\u83b7\u5f97\u65b0\u6cd5\u672f\u3002)", new ParserTag[0]);
                        }
                        return UtilText.parse(target, "[npc.Name]\u6ca1\u6709\u8db3\u591f\u7684\u5965\u672f\u6280\u5de7\u6765\u5b66\u4e60\u8fd9\u4e2a\u6cd5\u672f\uff01(\u9700\u8981\u5965\u672f\u6280\u5de7\u81f3\u5c11\u4e3a" + IntelligenceLevel.ONE_AVERAGE.getMinimumValue() + ")", new ParserTag[0]);
                    }

                    @Override
                    public String getUseName() {
                        return "\u9605\u8bfb";
                    }

                    @Override
                    public String getUseDescription(GameCharacter user, GameCharacter target) {
                        return ItemType.getGenericUseDescription(user, target, "\u4f60\u6253\u5f00\u6cd5\u672f\u4e66\uff0c\u9605\u8bfb\u4e86\u4e66\u4e2d\u7684\u5185\u5bb9\u2026\u2026", "\u4f60\u6253\u5f00\u6cd5\u672f\u4e66\uff0c\u8ba9[npc.Name]\u9605\u8bfb\u4e66\u4e2d\u7684\u5185\u5bb9\u2026\u2026", "[npc.Name]\u62ff\u51fa\u4e00\u672c\u6cd5\u672f\u4e66\uff0c\u9605\u8bfb\u8d77\u4e66\u4e2d\u7684\u5185\u5bb9\u2026\u2026", "[npc.Name]\u62ff\u51fa\u4e00\u672c\u6cd5\u672f\u4e66\uff0c\u8ba9\u4f60\u9605\u8bfb\u4e66\u4e2d\u7684\u5185\u5bb9\u2026\u2026");
                    }

                    @Override
                    public boolean isAbleToBeUsedInSex() {
                        return false;
                    }

                    @Override
                    public boolean isAbleToBeUsedInCombatAllies() {
                        return false;
                    }
                };
                itemToIdMap.put(spellBook, "SPELL_BOOK_" + String.valueOf((Object)spell));
                idToItemMap.put("SPELL_BOOK_" + String.valueOf((Object)spell), spellBook);
                allItems.add(spellBook);
            }
            ++var5_26;
        }
        SpellSchool[] spellSchoolArray = SpellSchool.values();
        n = spellSchoolArray.length;
        boolean bl3 = false;
        while (var5_28 < n) {
            final SpellSchool spellSchool = spellSchoolArray[var5_28];
            AbstractItemEffectType effectType = new AbstractItemEffectType(Util.newArrayListOfValues("<span style='color:" + spellSchool.getColour().toWebHexString() + ";'>" + spellSchool.getName() + "</span>\u5347\u7ea7\u70b9\u6570[style.boldExcellent(+1)]\u3002"), spellSchool.getColour()){

                @Override
                public String itemEffectOverride(TFModifier primaryModifier, TFModifier secondaryModifier, TFPotency potency, int limit, GameCharacter user, GameCharacter target, ItemEffectTimer timer) {
                    target.incrementSpellUpgradePoints(spellSchool, 1);
                    return "<p style='text-align:center;'>" + (target.isPlayer() ? "\u4f60\u83b7\u5f97\u4e86" : UtilText.parse(target, "[npc.Name]\u83b7\u5f97\u4e86", new ParserTag[0])) + "\u4e00\u70b9<b style='color:" + spellSchool.getColour().toWebHexString() + ";'>" + spellSchool.getName() + "</b>\u5b66\u6d3e\u7684\u5347\u7ea7\u70b9\u6570\uff01<br/><i>\u5377\u8f74\u5b8c\u6210\u4e86\u5b83\u7684\u4f7f\u547d\uff0c\u5728\u4e00\u9053\u7d2b\u5149\u4e2d\u6d88\u5931\u4e86\uff01</i></p>";
                }
            };
            ItemEffectType.addAbstractItemEffectToIds("EFFECT_SCROLL_SCHOOL_" + String.valueOf((Object)spellSchool), effectType);
            AbstractItemType scroll = new AbstractItemType(1000, null, false, Util.capitaliseSentence(spellSchool.getName()) + "\u5377\u8f74", Util.capitaliseSentence(spellSchool.getName()) + "\u5377\u8f74", "\u4e00\u5f20\u5965\u672f\u5377\u8f74\uff0c\u9605\u8bfb\u540e\u4f1a\u5c06" + Util.capitaliseSentence(spellSchool.getName()) + "\u5b66\u6d3e\u7684\u529b\u91cf\u6ce8\u5165\u5230\u9605\u8bfb\u8005\u4f53\u5185\u3002", "spell_scroll", spellSchool.getColour(), null, null, Rarity.EPIC, Util.newArrayListOfValues(new ItemEffect(effectType)), Util.newArrayListOfValues(ItemTag.SPELL_SCROLL)){

                @Override
                public boolean isAbleToBeUsed(GameCharacter user, GameCharacter target) {
                    return (target.isPlayer() || target.getAttributeValue(Attribute.MAJOR_ARCANE) >= (float)IntelligenceLevel.ONE_AVERAGE.getMinimumValue()) && !target.isElemental();
                }

                @Override
                public String getUnableToBeUsedDescription(GameCharacter user, GameCharacter target) {
                    if (target.isElemental()) {
                        return "\u5143\u7d20\u4f53\u65e0\u6cd5\u4f7f\u7528\u5377\u8f74\uff0c\u76f8\u53cd\u662f\u901a\u8fc7\u5929\u8d4b\u7cbe\u8fdb\u6cd5\u672f\uff01";
                    }
                    return UtilText.parse(target, "[npc.Name]\u6ca1\u6709\u8db3\u591f\u7684\u5965\u672f\u6280\u5de7\u6765\u5f97\u77e5\u5438\u6536\u5377\u8f74\u529b\u91cf\u7684\u65b9\u6cd5\uff01(\u9700\u8981\u5965\u672f\u6280\u5de7\u81f3\u5c11\u4e3a" + IntelligenceLevel.ONE_AVERAGE.getMinimumValue() + "\u3002)", new ParserTag[0]);
                }

                @Override
                public String getUseName() {
                    return "\u9605\u8bfb";
                }

                @Override
                public String getUseDescription(GameCharacter user, GameCharacter target) {
                    return ItemType.getGenericUseDescription(user, target, "\u4f60\u5c55\u5f00\u5377\u8f74\uff0c\u9605\u8bfb\u4e86\u5176\u4e2d\u7684\u5185\u5bb9\u2026\u2026", "\u4f60\u5c55\u5f00\u5377\u8f74\uff0c\u8ba9[npc.Name]\u9605\u8bfb\u4e86\u5176\u4e2d\u7684\u5185\u5bb9\u2026\u2026", "[npc.Name]\u62ff\u51fa\u4e00\u5f20\u5377\u8f74\uff0c\u5c55\u5f00\u540e\u9605\u8bfb\u4e86\u5176\u4e2d\u7684\u5185\u5bb9\u2026\u2026", "[npc.Name]\u62ff\u51fa\u4e00\u5f20\u5377\u8f74\uff0c\u5c55\u5f00\u540e\u8ba9\u4f60\u9605\u8bfb\u4e86\u5176\u4e2d\u7684\u5185\u5bb9\u2026\u2026");
                }

                @Override
                public boolean isAbleToBeUsedInSex() {
                    return false;
                }

                @Override
                public boolean isAbleToBeUsedInCombatAllies() {
                    return false;
                }
            };
            itemToIdMap.put(scroll, "SPELL_SCROLL_" + String.valueOf((Object)spellSchool));
            idToItemMap.put("SPELL_SCROLL_" + String.valueOf((Object)spellSchool), scroll);
            allItems.add(scroll);
            ++var5_28;
        }
        HashMap hashMap = new HashMap();
        for (AbstractSubspecies abstractSubspecies : Subspecies.getAllSubspecies()) {
            hashMap.putIfAbsent(abstractSubspecies.getAdvancedDescriptionId(), new ArrayList());
            ((List)hashMap.get(abstractSubspecies.getAdvancedDescriptionId())).add(abstractSubspecies);
        }
        for (AbstractSubspecies abstractSubspecies : Subspecies.getAllSubspecies()) {
            hashMap.putIfAbsent(abstractSubspecies.getAdvancedDescriptionId(), new ArrayList());
            ((List)hashMap.get(abstractSubspecies.getAdvancedDescriptionId())).add(abstractSubspecies);
        }
        for (final Map.Entry entry : hashMap.entrySet()) {
            String raceNamePlural;
            final AbstractSubspecies abstractSubspecies = ((List)entry.getValue()).contains(AbstractSubspecies.getMainSubspeciesOfRace(((AbstractSubspecies)((List)entry.getValue()).get(0)).getRace())) ? AbstractSubspecies.getMainSubspeciesOfRace(((AbstractSubspecies)((List)entry.getValue()).get(0)).getRace()) : (AbstractSubspecies)((List)entry.getValue()).get(0);
            AbstractItemType loreBook = new AbstractItemType(250, null, false, abstractSubspecies.getBookName(), abstractSubspecies.getBookNamePlural(), "\u5305\u542b\u7740\u6709\u5173" + abstractSubspecies.getNamePlural(null) + "\u66f4\u8be6\u7ec6\u7684\u77e5\u8bc6\u3002", "race_book", abstractSubspecies.getColour(null), PresetColour.CLOTHING_GOLD, abstractSubspecies.getColour(null), Rarity.RARE, null, Util.newArrayListOfValues(ItemTag.BOOK)){

                @Override
                public String getDescription() {
                    return super.getDescription() + (String)(abstractSubspecies.getBookAuthor().isEmpty() ? "" : "\u8fd9\u672c\u4e66\u7684\u4f5c\u8005\u4e3a\u201c" + abstractSubspecies.getBookAuthor() + "\u201d\u3002");
                }

                @Override
                public List<ItemEffect> getEffects() {
                    AbstractSubspecies mainSubspecies = ((List)entry.getValue()).contains(AbstractSubspecies.getMainSubspeciesOfRace(((AbstractSubspecies)((List)entry.getValue()).get(0)).getRace())) ? AbstractSubspecies.getMainSubspeciesOfRace(((AbstractSubspecies)((List)entry.getValue()).get(0)).getRace()) : (AbstractSubspecies)((List)entry.getValue()).get(0);
                    String id = "BOOK_READ_" + Subspecies.getIdFromSubspecies(mainSubspecies);
                    if (!ItemEffectType.idToItemEffectTypeMap.containsKey(id)) {
                        AbstractItemEffectType bookType = ItemType.generateBookEffect(mainSubspecies, (List)entry.getValue());
                        ItemEffectType.allEffectTypes.add(bookType);
                        ItemEffectType.itemEffectTypeToIdMap.put(bookType, id);
                        ItemEffectType.idToItemEffectTypeMap.put(id, bookType);
                    }
                    return Util.newArrayListOfValues(new ItemEffect(ItemEffectType.getBookEffectFromSubspecies(mainSubspecies)));
                }

                @Override
                public String getSVGString() {
                    int offset = 6;
                    float left = (float)(30.0 + (double)offset * Math.cos(Math.toRadians(60.0)));
                    left = Math.round(left * 100.0f);
                    return super.getSVGString() + "<div style='width:40%;height:40%;position:absolute;left:" + (left /= 100.0f) + "%;top:" + (30 - offset) + "%; opacity:0.75; -webkit-transform: rotate(30deg);'>" + abstractSubspecies.getBookSVGString() + "</div>";
                }

                @Override
                public boolean isConsumedOnUse() {
                    return false;
                }

                @Override
                public String getUseName() {
                    return "\u9605\u8bfb";
                }

                @Override
                public String getUseDescription(GameCharacter user, GameCharacter target) {
                    return ItemType.getGenericUseDescription(user, target, "\u4f60\u7ffb\u5f00\u4e66\uff0c\u9605\u8bfb\u4e86\u5176\u4e2d\u7684\u5185\u5bb9\u2026\u2026", "\u4f60\u7ffb\u5f00\u4e66\uff0c\u8ba9[npc.name]\u9605\u8bfb\u4e86\u5176\u4e2d\u7684\u5185\u5bb9\u2026\u2026", "[npc.Name]\u62ff\u51fa\u4e00\u672c\u540d\u4e3a\u201c" + this.getName(false) + "\u201d\u7684\u4e66\uff0c\u9605\u8bfb\u8d77\u5176\u4e2d\u7684\u5185\u5bb9\u2026\u2026", "[npc.Name]\u62ff\u51fa\u4e00\u672c\u540d\u4e3a\u201c" + this.getName(false) + "\u201d\u7684\u4e66\uff0c\u8ba9\u4f60\u9605\u8bfb\u4e86\u5176\u4e2d\u7684\u5185\u5bb9\u2026\u2026");
                }
            };
            String id = "BOOK_" + Subspecies.getIdFromSubspecies(abstractSubspecies);
            itemToIdMap.put(loreBook, id);
            idToItemMap.put(id, loreBook);
            for (AbstractSubspecies subspecies : (List)entry.getValue()) {
                subspeciesBookId.put(subspecies, id);
            }
            allItems.add(loreBook);
            if (abstractSubspecies == Subspecies.CENTAUR) continue;
            int override = abstractSubspecies.getSubspeciesOverridePriority();
            String raceName = override > 0 ? abstractSubspecies.getFeralName(null) : abstractSubspecies.getRace().getName(true);
            String string = raceNamePlural = override > 0 ? abstractSubspecies.getFeralNamePlural(null) : abstractSubspecies.getRace().getNamePlural(true);
            final AbstractStatusEffect statusEffect = new AbstractStatusEffect(80, (abstractSubspecies.getRace() == Race.ANGEL ? "\u5929\u4f7f" : (abstractSubspecies.getRace() == Race.DEMON && override <= 2 ? "\u5c0f\u6076\u9b54" : (abstractSubspecies.getRace() == Race.DEMON && override >= 5 && override <= 20 ? "\u6076\u9b54" : (abstractSubspecies == Subspecies.LILIN ? "\u8389\u7433" : (abstractSubspecies == Subspecies.ELDER_LILIN ? "\u8389\u7433\u957f\u8001" : raceName.toLowerCase()))))) + "\u76f4\u89c9", null, abstractSubspecies.getColour(null), true, Util.newHashMapOfValues(new Util.Value<AbstractAttribute, Float>(Attribute.MAJOR_PHYSIQUE, Float.valueOf(2.0f)), new Util.Value<AbstractAttribute, Float>(abstractSubspecies.getRace() == Race.DEMON && override <= 2 ? Attribute.DAMAGE_IMP : (abstractSubspecies == Subspecies.LILIN ? Attribute.DAMAGE_LILIN : (abstractSubspecies == Subspecies.ELDER_LILIN ? Attribute.DAMAGE_ELDER_LILIN : Attribute.getRacialDamageAttribute(abstractSubspecies.getRace()))), Float.valueOf(25.0f))), null){

                @Override
                public String getDescription(GameCharacter target) {
                    if (target == null) {
                        return "";
                    }
                    return UtilText.parse(target, "[npc.nameIsFull]\u5728\u5438\u6536\u4e86\u7279\u5b9a\u9644\u9b54\u7684\u5965\u672f\u7cbe\u534e\u540e\uff0c\u80fd\u591f\u7cbe\u51c6\u5730\u9884\u6d4b" + raceNamePlural.toLowerCase() + "\u7684\u884c\u52a8\u65b9\u5f0f\u4e86\u3002", new ParserTag[0]);
                }

                @Override
                public String getSVGString(GameCharacter owner) {
                    return ItemType.getEssenceEffectSvg(abstractSubspecies);
                }
            };
            String effect_id = "COMBAT_BONUS_" + Subspecies.getIdFromSubspecies(abstractSubspecies).toUpperCase();
            StatusEffect.statusEffectToIdMap.put(statusEffect, effect_id);
            StatusEffect.idToStatusEffectMap.put(effect_id, statusEffect);
            StatusEffect.allStatusEffects.add(statusEffect);
            AbstractItemEffectType effectType = new AbstractItemEffectType(Util.newArrayListOfValues("[style.boldGood(+1)][style.boldArcane(\u5965\u672f\u7cbe\u534e)]"), abstractSubspecies.getColour(null)){

                @Override
                public Map<AbstractStatusEffect, Integer> getAppliedStatusEffects() {
                    return Util.newHashMapOfValues(new Util.Value<AbstractStatusEffect, Integer>(statusEffect, 14400));
                }

                @Override
                public String itemEffectOverride(TFModifier primaryModifier, TFModifier secondaryModifier, TFPotency potency, int limit, GameCharacter user, GameCharacter target, ItemEffectTimer timer) {
                    if (target.isDoll()) {
                        return UtilText.parse(target, "<p style='text-align:center;'>[style.colourDisabled(\u7531\u4e8e[npc.sheIsFull]\u662f\u4e2a\u6027\u7231\u73a9\u5076\uff0c\u65e0\u6cd5\u5438\u6536\u7cbe\u534e\u2026\u2026)]</p>", new ParserTag[0]);
                    }
                    return target.incrementEssenceCount(1, false) + UtilText.parse(target, "<p style='text-align:center;'>[npc.She]\u6682\u65f6\u80fd\u591f\u66f4\u6709\u6548\u5730\u5bf9<b style='color:" + abstractSubspecies.getColour(null).toWebHexString() + ";'>" + raceNamePlural + "</b>\u53d1\u8d77\u653b\u51fb\uff01</p>", new ParserTag[0]);
                }
            };
            ItemEffectType.addAbstractItemEffectToIds("BOTTLED_ESSENCE_" + Subspecies.getIdFromSubspecies(abstractSubspecies).toUpperCase(), effectType);
            AbstractItemType essence = new AbstractItemType(Math.min(Math.max(abstractSubspecies.getBaseSlaveValue(null) / 250, 40), 10000), null, false, "\u74f6\u88c5" + Util.capitaliseSentence(raceName) + "\u7cbe\u534e", "\u74f6\u88c5" + Util.capitaliseSentence(raceName) + "\u7cbe\u534e", "\u4e00\u4e2a\u5c0f\u73bb\u7483\u74f6\uff0c\u9876\u90e8\u7d27\u7d27\u5730\u585e\u7740\u4e00\u9897\u5c0f\u5de7\u7684\u8f6f\u6728\u585e\u3002\u91cc\u9762" + PresetColour.GENERIC_ARCANE.getName() + "\u5149\u8292\u7684\u5965\u672f\u7cbe\u534e\u821e\u52a8\u95ea\u70c1\u7740\uff0c\u4e0d\u65ad\u98de\u65cb\uff0c\u4ee4\u4eba\u7740\u8ff7\uff0c\u5e76\u4e14\u6ce8\u5165\u4e86" + UtilText.generateSingularDeterminer(raceName) + raceName + "\u7684\u80fd\u91cf\u3002", null, abstractSubspecies.getColour(null), null, null, Rarity.EPIC, Util.newArrayListOfValues(new ItemEffect(effectType)), abstractSubspecies.getRace() == Race.DEMON && abstractSubspecies.getSubspeciesOverridePriority() > 5 || abstractSubspecies.getRace() == Race.ANGEL ? Util.newArrayListOfValues(ItemTag.ESSENCE, ItemTag.CONTRABAND_HEAVY) : Util.newArrayListOfValues(ItemTag.ESSENCE)){

                @Override
                public String getUseName() {
                    return "\u5438\u6536";
                }

                @Override
                public String getUseDescription(GameCharacter user, GameCharacter target) {
                    return ItemType.getEssenceAbsorptionText(abstractSubspecies.getColour(null), user, target);
                }

                @Override
                public String getSVGString() {
                    return ItemType.getEssenceSvg(abstractSubspecies);
                }
            };
            String essence_id = "BOTTLED_ESSENCE_" + Subspecies.getIdFromSubspecies(abstractSubspecies).toUpperCase();
            itemToIdMap.put(essence, essence_id);
            idToItemMap.put(essence_id, essence);
            allItems.add(essence);
            essences.add(essence);
        }
        for (AbstractItemType abstractItemType : allItems) {
            if (abstractItemType.getItemTags().contains((Object)ItemTag.DOMINION_ALLEYWAY_SPAWN) || abstractItemType.getItemTags().contains((Object)ItemTag.ALL_AREAS_SPAWN)) {
                dominionAlleywayItems.add(abstractItemType);
            }
            if (abstractItemType.getItemTags().contains((Object)ItemTag.SUBMISSION_TUNNEL_SPAWN) || abstractItemType.getItemTags().contains((Object)ItemTag.ALL_AREAS_SPAWN)) {
                submissionTunnelItems.add(abstractItemType);
            }
            if (abstractItemType.getItemTags().contains((Object)ItemTag.BAT_CAVERNS_SPAWN) || abstractItemType.getItemTags().contains((Object)ItemTag.ALL_AREAS_SPAWN)) {
                batCavernItems.add(abstractItemType);
            }
            if (!abstractItemType.getItemTags().contains((Object)ItemTag.ELIS_ALLEYWAY_SPAWN) && !abstractItemType.getItemTags().contains((Object)ItemTag.ALL_AREAS_SPAWN)) continue;
            elisAlleywayItems.add(abstractItemType);
        }
        essenceMap = new HashMap<AbstractSubspecies, String>();
    }
}

