/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory.outfit;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.controller.xmlParsing.XMLLoadException;
import com.lilithsthrone.controller.xmlParsing.XMLMissingTagException;
import com.lilithsthrone.game.character.EquipClothingSetting;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.body.valueEnums.Femininity;
import com.lilithsthrone.game.character.body.valueEnums.LegConfiguration;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.combat.DamageType;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.ColourReplacement;
import com.lilithsthrone.game.inventory.InventorySlot;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.Rarity;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.clothing.AbstractClothingType;
import com.lilithsthrone.game.inventory.clothing.ClothingType;
import com.lilithsthrone.game.inventory.outfit.OutfitPotential;
import com.lilithsthrone.game.inventory.outfit.OutfitType;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.game.inventory.weapon.AbstractWeaponType;
import com.lilithsthrone.game.inventory.weapon.WeaponType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.ColourListPresets;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.WorldRegion;
import com.lilithsthrone.world.WorldType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class AbstractOutfit {
    private String filePath;
    private String name;
    private String description;
    private List<WorldRegion> worldRegions;
    private List<AbstractWorldType> worldTypes;
    private Femininity femininity;
    private List<OutfitType> outfitTypes;
    private List<LegConfiguration> acceptableLegConfigurations;
    private String conditional;
    private int weight;
    private Map<String, String> innerConditionals;
    private List<List<Colour>> presetColourGroups;

    public AbstractOutfit(File outfitXMLFile) throws XMLLoadException {
        try {
            this.filePath = outfitXMLFile.getAbsolutePath();
            Element outfitElement = Element.getDocumentRootElement(outfitXMLFile);
            Element coreAttributes = outfitElement.getMandatoryFirstOf("coreAttributes");
            this.name = coreAttributes.getMandatoryFirstOf("name").getTextContent();
            this.description = coreAttributes.getMandatoryFirstOf("description").getTextContent();
            this.femininity = Femininity.valueOf(coreAttributes.getMandatoryFirstOf("femininity").getTextContent());
            this.conditional = coreAttributes.getMandatoryFirstOf("conditional").getTextContent();
            this.weight = Integer.valueOf(coreAttributes.getMandatoryFirstOf("weight").getTextContent());
            this.worldRegions = new ArrayList<WorldRegion>();
            if (coreAttributes.getOptionalFirstOf("worldRegions").isPresent()) {
                this.worldRegions = coreAttributes.getMandatoryFirstOf("worldRegions").getAllOf("region").stream().map(e -> WorldRegion.valueOf(e.getTextContent())).collect(Collectors.toList());
            }
            this.worldTypes = new ArrayList<AbstractWorldType>();
            if (coreAttributes.getOptionalFirstOf("worldTypes").isPresent()) {
                this.worldTypes = coreAttributes.getMandatoryFirstOf("worldTypes").getAllOf("world").stream().map(e -> WorldType.getWorldTypeFromId(e.getTextContent())).filter(Objects::nonNull).collect(Collectors.toList());
            }
            this.outfitTypes = coreAttributes.getMandatoryFirstOf("outfitTypes").getAllOf("type").stream().map(e -> OutfitType.valueOf(e.getTextContent())).filter(Objects::nonNull).collect(Collectors.toList());
            try {
                this.acceptableLegConfigurations = coreAttributes.getMandatoryFirstOf("acceptableLegConfigurations").getAllOf("legConfiguration").stream().map(e -> LegConfiguration.getValueFromString(e.getTextContent())).filter(Objects::nonNull).collect(Collectors.toList());
            }
            catch (Exception ex) {
                this.acceptableLegConfigurations = null;
            }
        }
        catch (XMLMissingTagException ex) {
            throw new XMLLoadException(ex, outfitXMLFile);
        }
        catch (Exception e2) {
            System.out.println(e2);
            throw new XMLLoadException(e2, outfitXMLFile);
        }
    }

    public boolean isAvailableForCharacter(OutfitType type, GameCharacter character) {
        boolean hasWorldTypes;
        if (!this.getOutfitTypes().contains((Object)type)) {
            return false;
        }
        switch (this.getFemininity()) {
            case FEMININE: 
            case FEMININE_STRONG: {
                if (character.isFeminine() || character.hasFetish(Fetish.FETISH_CROSS_DRESSER)) break;
                return false;
            }
            case ANDROGYNOUS: {
                break;
            }
            case MASCULINE: 
            case MASCULINE_STRONG: {
                if (!character.isFeminine() || character.hasFetish(Fetish.FETISH_CROSS_DRESSER)) break;
                return false;
            }
        }
        boolean hasWorldRegions = this.getWorldRegions() != null && !this.getWorldRegions().isEmpty();
        boolean bl = hasWorldTypes = this.getWorldTypes() != null && !this.getWorldTypes().isEmpty();
        if (hasWorldRegions && hasWorldTypes && !this.getWorldRegions().contains((Object)character.getWorldLocation().getWorldRegion()) && !this.getWorldTypes().contains(character.getWorldLocation())) {
            return false;
        }
        if (hasWorldRegions && !hasWorldTypes && !this.getWorldRegions().contains((Object)character.getWorldLocation().getWorldRegion())) {
            return false;
        }
        if (hasWorldTypes && !hasWorldRegions && !this.getWorldTypes().contains(character.getWorldLocation())) {
            return false;
        }
        if (this.getAcceptableLegConfigurations() != null && !this.getAcceptableLegConfigurations().isEmpty() && !this.getAcceptableLegConfigurations().contains((Object)character.getLegConfiguration())) {
            return false;
        }
        return this.conditional.isEmpty() || this.evalConditional(character, this.conditional);
    }

    public String applyOutfit(GameCharacter character, List<EquipClothingSetting> settings) throws XMLLoadException {
        StringBuilder sb = new StringBuilder();
        boolean debug = false;
        File outfitXMLFile = new File(this.filePath);
        if (outfitXMLFile.exists()) {
            try {
                if (settings.contains((Object)EquipClothingSetting.REPLACE_CLOTHING)) {
                    character.unequipAllClothingIntoVoid(settings.contains((Object)EquipClothingSetting.REMOVE_SEALS), false);
                }
                Element outfitElement = Element.getDocumentRootElement(outfitXMLFile);
                Element generationAttributes = outfitElement.getMandatoryFirstOf("generationAttributes");
                this.innerConditionals = new HashMap<String, String>();
                try {
                    for (Element el : generationAttributes.getAll()) {
                        String string = el.getTagName();
                        if (!string.startsWith("clothingConditional") && !string.startsWith("cond")) continue;
                        if (Boolean.valueOf(el.getAttribute("constant")).booleanValue()) {
                            this.innerConditionals.put(string, String.valueOf(this.evalConditional(character, el.getTextContent())));
                            continue;
                        }
                        this.innerConditionals.put(string, el.getTextContent());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (debug) {
                    System.out.println("1");
                }
                this.presetColourGroups = new ArrayList<List<Colour>>();
                try {
                    for (int i = 1; i < 20; ++i) {
                        Element presetColourGroup = generationAttributes.getMandatoryFirstOf("presetColourGroup" + i);
                        ArrayList<Colour> arrayList = new ArrayList<Colour>();
                        if (!presetColourGroup.getAttribute("values").isEmpty()) {
                            arrayList.addAll(ColourListPresets.getColourListFromId(presetColourGroup.getAttribute("values")));
                        } else {
                            for (Element e2 : presetColourGroup.getAllOf("randomColour")) {
                                try {
                                    String text = e2.getTextContent();
                                    if (text.startsWith("presetColourGroup")) {
                                        arrayList.addAll((Collection)this.presetColourGroups.get(Integer.valueOf(text.substring(text.length() - 1)) - 1));
                                        continue;
                                    }
                                    arrayList.add(PresetColour.getColourFromId(text));
                                }
                                catch (Exception text) {}
                            }
                        }
                        if (Boolean.valueOf(presetColourGroup.getAttribute("singleColour")).booleanValue()) {
                            Collections.shuffle(arrayList);
                            arrayList.subList(1, arrayList.size()).clear();
                        }
                        this.presetColourGroups.add(arrayList);
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
                if (debug) {
                    System.out.println("2a");
                }
                if (settings.contains((Object)EquipClothingSetting.ADD_WEAPONS)) {
                    Object wep;
                    ArrayList<AbstractWeapon> weapons;
                    try {
                        weapons = new ArrayList<AbstractWeapon>();
                        for (Element element : generationAttributes.getMandatoryFirstOf("mainWeapons").getAllOf("weapon")) {
                            try {
                                String weaponConditional2 = element.getMandatoryFirstOf("conditional").getTextContent();
                                if (!weaponConditional2.isEmpty() && !this.evalConditional(character, weaponConditional2)) {
                                    continue;
                                }
                            }
                            catch (Exception weaponConditional2) {
                                // empty catch block
                            }
                            weapons.add(this.getWeapon(element));
                        }
                        if (!weapons.isEmpty()) {
                            wep = (AbstractWeapon)Util.randomItemFrom(weapons);
                            character.equipMainWeaponFromNowhere((AbstractWeapon)wep);
                            if (((AbstractWeapon)wep).getWeaponType().getArcaneCost() > 0) {
                                character.incrementEssenceCount(((AbstractWeapon)wep).getWeaponType().getArcaneCost() * (10 + Util.random.nextInt(21)), false);
                            }
                        }
                    }
                    catch (Exception e4) {
                        e4.printStackTrace();
                    }
                    try {
                        weapons = new ArrayList();
                        for (Element element : generationAttributes.getMandatoryFirstOf("offhandWeapons").getAllOf("weapon")) {
                            try {
                                String weaponConditional3 = element.getMandatoryFirstOf("conditional").getTextContent();
                                if (!weaponConditional3.isEmpty() && !this.evalConditional(character, weaponConditional3)) {
                                    continue;
                                }
                            }
                            catch (Exception weaponConditional3) {
                                // empty catch block
                            }
                            weapons.add(this.getWeapon(element));
                        }
                        if (!weapons.isEmpty()) {
                            wep = (AbstractWeapon)Util.randomItemFrom(weapons);
                            character.equipOffhandWeaponFromNowhere((AbstractWeapon)wep);
                            if (((AbstractWeapon)wep).getWeaponType().getArcaneCost() > 0) {
                                character.incrementEssenceCount(((AbstractWeapon)wep).getWeaponType().getArcaneCost() * (10 + Util.random.nextInt(21)), false);
                            }
                        }
                    }
                    catch (Exception e5) {
                        e5.printStackTrace();
                    }
                }
                if (debug) {
                    System.out.println("2b");
                }
                if (generationAttributes.getOptionalFirstOf("guaranteedClothingEquips").isPresent()) {
                    List<Object> guaranteedClothingEquips = new ArrayList();
                    guaranteedClothingEquips = generationAttributes.getMandatoryFirstOf("guaranteedClothingEquips").getAllOf("uniqueClothing").stream().map(e -> {
                        try {
                            ArrayList<Colour> colours;
                            int index;
                            AbstractClothing ac = AbstractClothing.loadFromXML(e.getMandatoryFirstOf("clothing").getInnerElement(), e.getDocument());
                            try {
                                UtilText.setClothingTypeForParsing(ac.getClothingType());
                                String conditional = e.getMandatoryFirstOf("conditional").getTextContent();
                                if (!this.evalConditional(character, conditional)) {
                                    return null;
                                }
                            }
                            catch (XMLMissingTagException conditional) {
                                // empty catch block
                            }
                            String colourText = e.getAttribute("colour");
                            if (colourText.startsWith("presetColourGroup")) {
                                index = Integer.valueOf(colourText.substring(colourText.length() - 1)) - 1;
                                colours = new ArrayList<Colour>((Collection)this.presetColourGroups.get(index));
                                colours.removeIf(c -> !ac.getClothingType().getColourReplacement(0).getAllColours().contains(c));
                                if (!colours.isEmpty()) {
                                    ac.setColour(0, (Colour)Util.randomItemFrom(colours));
                                }
                            }
                            if ((colourText = e.getAttribute("colourSecondary")).startsWith("presetColourGroup")) {
                                index = Integer.valueOf(colourText.substring(colourText.length() - 1)) - 1;
                                colours = new ArrayList(this.presetColourGroups.get(index));
                                colours.removeIf(c -> !ac.getClothingType().getColourReplacement(1).getAllColours().contains(c));
                                if (!colours.isEmpty()) {
                                    ac.setColour(1, (Colour)Util.randomItemFrom(colours));
                                }
                            }
                            if ((colourText = e.getAttribute("colourTertiary")).startsWith("presetColourGroup")) {
                                index = Integer.valueOf(colourText.substring(colourText.length() - 1)) - 1;
                                colours = new ArrayList(this.presetColourGroups.get(index));
                                colours.removeIf(c -> !ac.getClothingType().getColourReplacement(2).getAllColours().contains(c));
                                if (!colours.isEmpty()) {
                                    ac.setColour(2, (Colour)Util.randomItemFrom(colours));
                                }
                            }
                            return ac;
                        }
                        catch (XMLMissingTagException e1) {
                            e1.printStackTrace();
                            System.err.println("Error in guaranteedClothingEquips()");
                            return null;
                        }
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                    if (debug) {
                        System.out.println("3");
                    }
                    Collections.shuffle(guaranteedClothingEquips);
                    for (AbstractClothing abstractClothing : guaranteedClothingEquips) {
                        if (!abstractClothing.getClothingType().getEquipSlots().get(0).isCoreClothing() && !settings.contains((Object)EquipClothingSetting.ADD_ACCESSORIES)) continue;
                        abstractClothing.setName(UtilText.parse(character, abstractClothing.getBaseName(), new ParserTag[0]));
                        if (character.isSlotIncompatible(abstractClothing.getClothingType().getEquipSlots().get(0))) continue;
                        character.equipClothingOverride(abstractClothing, abstractClothing.getClothingType().getEquipSlots().get(0), false, false);
                    }
                }
                if (debug) {
                    System.out.println("4");
                }
                ArrayList<OutfitPotential> outfitPotentials = new ArrayList<OutfitPotential>();
                for (Element element : generationAttributes.getAllOf("genericClothingType")) {
                    ArrayList<AbstractClothingType> ctList = new ArrayList<AbstractClothingType>();
                    boolean anyConditionalsFound = false;
                    ArrayList<AbstractClothingType> clothingList = new ArrayList<AbstractClothingType>(ClothingType.getAllClothing());
                    clothingList.removeIf(c -> c.getDefaultItemTags().contains((Object)ItemTag.NO_RANDOM_SPAWN));
                    block40: for (AbstractClothingType ct : clothingList) {
                        AbstractClothing defaultClothingExample = Main.game.getItemGen().generateClothing(ct, false);
                        try {
                            if (element.getOptionalFirstOf("itemTags").isPresent()) {
                                anyConditionalsFound = true;
                                List tags = element.getMandatoryFirstOf("itemTags").getAllOf("tag").stream().map(e -> ItemTag.valueOf(e.getTextContent())).filter(Objects::nonNull).collect(Collectors.toList());
                                if (!ct.getDefaultItemTags().containsAll(tags)) {
                                    continue;
                                }
                            }
                        }
                        catch (Exception ex) {
                            System.err.println("genericClothingType error: itemTags");
                        }
                        try {
                            if (element.getOptionalFirstOf("acceptableFemininities").isPresent() && element.getMandatoryFirstOf("acceptableFemininities").getOptionalFirstOf("femininity").isPresent()) {
                                anyConditionalsFound = true;
                                List femininities = element.getMandatoryFirstOf("acceptableFemininities").getAllOf("femininity").stream().map(e -> Femininity.valueOf(e.getTextContent())).filter(Objects::nonNull).collect(Collectors.toList());
                                if (ct.getFemininityRestriction() != null) {
                                    switch (ct.getFemininityRestriction()) {
                                        case FEMININE: 
                                        case FEMININE_STRONG: {
                                            if (femininities.contains((Object)Femininity.FEMININE) || femininities.contains((Object)Femininity.FEMININE_STRONG)) break;
                                            continue block40;
                                        }
                                        case ANDROGYNOUS: {
                                            if (femininities.contains((Object)Femininity.ANDROGYNOUS)) break;
                                            continue block40;
                                        }
                                        case MASCULINE: 
                                        case MASCULINE_STRONG: {
                                            if (femininities.contains((Object)Femininity.MASCULINE) || femininities.contains((Object)Femininity.MASCULINE_STRONG)) break;
                                            continue block40;
                                        }
                                    }
                                } else if (!femininities.contains((Object)Femininity.ANDROGYNOUS)) {
                                    continue;
                                }
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            System.err.println("genericClothingType error: femininity");
                        }
                        try {
                            if (element.getOptionalFirstOf("slot").isPresent() && !element.getMandatoryFirstOf("slot").getTextContent().isEmpty()) {
                                anyConditionalsFound = true;
                                InventorySlot slot = InventorySlot.valueOf(element.getMandatoryFirstOf("slot").getTextContent());
                                if (ct.getEquipSlots().get(0) != slot) {
                                    continue;
                                }
                            }
                        }
                        catch (Exception ex) {
                            System.err.println("genericClothingType error: slot");
                        }
                        try {
                            if (element.getOptionalFirstOf("rarity").isPresent()) {
                                anyConditionalsFound = true;
                                Rarity rarity = Rarity.valueOf(element.getMandatoryFirstOf("rarity").getTextContent());
                                if (ct.getRarity() != rarity) {
                                    continue;
                                }
                            }
                        }
                        catch (Exception ex) {
                            System.err.println("genericClothingType error: rarity");
                        }
                        try {
                            UtilText.setClothingTypeForParsing(ct);
                            if (element.getOptionalFirstOf("conditional").isPresent()) {
                                anyConditionalsFound = true;
                                String genericClothingConditional = element.getMandatoryFirstOf("conditional").getTextContent();
                                if (!genericClothingConditional.isEmpty() && !this.evalConditional(character, genericClothingConditional)) {
                                    continue;
                                }
                            }
                        }
                        catch (Exception ex) {
                            System.err.println("genericClothingType error: conditional");
                        }
                        if (!anyConditionalsFound) break;
                        if (!defaultClothingExample.isAbleToBeEquipped(character, ct.getEquipSlots().get(0)).getKey().booleanValue()) continue;
                        ctList.add(ct);
                    }
                    outfitPotentials.add(this.getOutfitPotential(ctList, element));
                }
                if (debug) {
                    System.out.println("5");
                }
                for (Element element : generationAttributes.getAllOf("clothingType")) {
                    List<AbstractClothingType> clothingTypeList = element.getMandatoryFirstOf("types").getAllOf("type").stream().map(e -> {
                        AbstractClothingType ct = ClothingType.getClothingTypeFromId(e.getTextContent());
                        AbstractClothing defaultClothingExample = Main.game.getItemGen().generateClothing(ct, false);
                        if (!defaultClothingExample.isAbleToBeEquipped(character, ct.getEquipSlots().get(0)).getKey().booleanValue()) {
                            return null;
                        }
                        return ct;
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                    for (AbstractClothingType ct : new ArrayList(clothingTypeList)) {
                        try {
                            UtilText.setClothingTypeForParsing(ct);
                            String clothingConditional = element.getMandatoryFirstOf("conditional").getTextContent();
                            if (clothingConditional.isEmpty() || this.evalConditional(character, clothingConditional)) continue;
                            clothingTypeList.remove(ct);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (clothingTypeList.isEmpty()) continue;
                    outfitPotentials.add(this.getOutfitPotential(clothingTypeList, element));
                }
                if (debug) {
                    System.out.println("6");
                }
                Collections.shuffle(outfitPotentials);
                for (OutfitPotential outfitPotential : outfitPotentials) {
                    Collections.shuffle(outfitPotential.getTypes());
                    for (AbstractClothingType ct : outfitPotential.getTypes()) {
                        if (character.getClothingInSlot(ct.getEquipSlots().get(0)) != null || !ct.getEquipSlots().get(0).isCoreClothing() && !settings.contains((Object)EquipClothingSetting.ADD_ACCESSORIES) || character.isSlotIncompatible(ct.getEquipSlots().get(0))) continue;
                        ArrayList<Colour> coloursForGeneration = new ArrayList<Colour>(outfitPotential.getColoursForClothingGeneration());
                        for (int i = 0; i < coloursForGeneration.size(); ++i) {
                            ColourReplacement colRep = ct.getColourReplacement(i);
                            if (colRep == null || colRep.getAllColours().contains(coloursForGeneration.get(i))) continue;
                            coloursForGeneration.add(i, ct.getColourReplacement(i).getRandomOfDefaultColours());
                        }
                        AbstractClothing clothing = Main.game.getItemGen().generateClothing(ct, coloursForGeneration, null);
                        character.equipClothingOverride(clothing, ct.getEquipSlots().get(0), true, false);
                    }
                }
            }
            catch (Exception e6) {
                System.out.println(e6);
                throw new XMLLoadException(e6, outfitXMLFile);
            }
        }
        return sb.toString();
    }

    private boolean evalConditional(GameCharacter character, String conditional) {
        if (this.innerConditionals != null) {
            for (Map.Entry<String, String> entry : this.innerConditionals.entrySet()) {
                conditional = conditional.replaceAll(entry.getKey(), entry.getValue());
            }
        }
        try {
            return Boolean.valueOf(UtilText.parse(character, ("[#" + conditional + "]").replaceAll("\u200b", ""), new ParserTag[0]));
        }
        catch (Exception ex) {
            System.err.println("error in AbstractOutfit evalConditional(): cannot parse to Boolean");
            return false;
        }
    }

    private OutfitPotential getOutfitPotential(List<AbstractClothingType> ctList, Element baseElement) {
        ArrayList<List<Colour>> coloursList = new ArrayList<List<Colour>>();
        ArrayList<Colour> primaryColours = new ArrayList<Colour>();
        try {
            if (baseElement.getOptionalFirstOf("primaryColours").isPresent()) {
                if (!baseElement.getMandatoryFirstOf("primaryColours").getAttribute("values").isEmpty()) {
                    primaryColours.addAll(ColourListPresets.getColourListFromId(baseElement.getMandatoryFirstOf("primaryColours").getAttribute("values")));
                } else {
                    for (Element element : baseElement.getMandatoryFirstOf("primaryColours").getAllOf("colour")) {
                        String string = element.getTextContent();
                        if (string.startsWith("presetColourGroup")) {
                            primaryColours.addAll((Collection)this.presetColourGroups.get(Integer.valueOf(string.substring(string.length() - 1)) - 1));
                            continue;
                        }
                        primaryColours.add(PresetColour.getColourFromId(string));
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("AbstractOutfit error: primary fail 1");
        }
        if (!primaryColours.isEmpty()) {
            coloursList.add(primaryColours);
        }
        ArrayList<Colour> secondaryColours = new ArrayList<Colour>();
        try {
            if (baseElement.getOptionalFirstOf("secondaryColours").isPresent()) {
                if (!baseElement.getMandatoryFirstOf("secondaryColours").getAttribute("values").isEmpty()) {
                    secondaryColours.addAll(ColourListPresets.getColourListFromId(baseElement.getMandatoryFirstOf("secondaryColours").getAttribute("values")));
                } else {
                    for (Element element : baseElement.getMandatoryFirstOf("secondaryColours").getAllOf("colour")) {
                        String text = element.getTextContent();
                        if (text.startsWith("presetColourGroup")) {
                            secondaryColours.addAll((Collection)this.presetColourGroups.get(Integer.valueOf(text.substring(text.length() - 1)) - 1));
                            continue;
                        }
                        secondaryColours.add(PresetColour.getColourFromId(text));
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("AbstractOutfit error: secondary fail 1");
        }
        if (!secondaryColours.isEmpty()) {
            coloursList.add(secondaryColours);
        }
        ArrayList<Colour> arrayList = new ArrayList<Colour>();
        try {
            if (baseElement.getOptionalFirstOf("tertiaryColours").isPresent()) {
                if (!baseElement.getMandatoryFirstOf("tertiaryColours").getAttribute("values").isEmpty()) {
                    arrayList.addAll(ColourListPresets.getColourListFromId(baseElement.getMandatoryFirstOf("tertiaryColours").getAttribute("values")));
                } else {
                    for (Element colour : baseElement.getMandatoryFirstOf("tertiaryColours").getAllOf("colour")) {
                        String text = colour.getTextContent();
                        if (text.startsWith("presetColourGroup")) {
                            arrayList.addAll((Collection)this.presetColourGroups.get(Integer.valueOf(text.substring(text.length() - 1)) - 1));
                            continue;
                        }
                        arrayList.add(PresetColour.getColourFromId(text));
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("AbstractOutfit error: tertiary fail 1");
        }
        if (!arrayList.isEmpty()) {
            coloursList.add(arrayList);
        }
        try {
            if (baseElement.getOptionalFirstOf("colours").isPresent()) {
                for (Element e : baseElement.getAllOf("colours")) {
                    ArrayList<Colour> colourList = new ArrayList<Colour>();
                    if (!e.getAttribute("values").isEmpty()) {
                        colourList.addAll(ColourListPresets.getColourListFromId(e.getAttribute("values")));
                    } else {
                        for (Element colour : e.getAllOf("colour")) {
                            String text = colour.getTextContent();
                            if (text.startsWith("presetColourGroup")) {
                                colourList.addAll((Collection)this.presetColourGroups.get(Integer.valueOf(text.substring(text.length() - 1)) - 1));
                                continue;
                            }
                            colourList.add(PresetColour.getColourFromId(text));
                        }
                    }
                    if (colourList.isEmpty()) continue;
                    coloursList.add(colourList);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("AbstractOutfit error: colours fail 1");
        }
        return new OutfitPotential(ctList, coloursList);
    }

    /*
     * WARNING - void declaration
     */
    private AbstractWeapon getWeapon(Element baseElement) {
        try {
            void var9_27;
            DamageType dt = null;
            AbstractWeaponType wt = baseElement.getOptionalFirstOf("types").isPresent() ? (AbstractWeaponType)Util.randomItemFrom(baseElement.getMandatoryFirstOf("types").getAllOf("type").stream().map(el -> WeaponType.getWeaponTypeFromId(el.getTextContent())).filter(Objects::nonNull).collect(Collectors.toList())) : WeaponType.getWeaponTypeFromId(baseElement.getMandatoryFirstOf("type").getTextContent());
            List dtList = baseElement.getMandatoryFirstOf("damageTypes").getAllOf("damage").stream().map(element -> DamageType.valueOf(element.getTextContent())).filter(Objects::nonNull).collect(Collectors.toList());
            if (!dtList.isEmpty()) {
                dt = (DamageType)((Object)Util.randomItemFrom(dtList));
            }
            ArrayList coloursList = new ArrayList();
            ArrayList<Colour> primaryColours = new ArrayList<Colour>();
            try {
                for (Element element2 : baseElement.getMandatoryFirstOf("primaryColours").getAllOf("colour")) {
                    String string = element2.getTextContent();
                    if (string.startsWith("presetColourGroup")) {
                        primaryColours.addAll((Collection)this.presetColourGroups.get(Integer.valueOf(string.substring(string.length() - 1)) - 1));
                        continue;
                    }
                    primaryColours.add(PresetColour.getColourFromId(string));
                }
            }
            catch (Exception ex) {
                System.err.println("AbstractOutfit error: main weapon primary fail 1");
            }
            if (!primaryColours.isEmpty()) {
                coloursList.add(primaryColours);
            }
            ArrayList<Colour> secondaryColours = new ArrayList<Colour>();
            try {
                for (Element element3 : baseElement.getMandatoryFirstOf("secondaryColours").getAllOf("colour")) {
                    String string = element3.getTextContent();
                    if (string.startsWith("presetColourGroup")) {
                        secondaryColours.addAll((Collection)this.presetColourGroups.get(Integer.valueOf(string.substring(string.length() - 1)) - 1));
                        continue;
                    }
                    secondaryColours.add(PresetColour.getColourFromId(string));
                }
            }
            catch (Exception exception) {
                System.err.println("AbstractOutfit error: main weapon secondary fail 1");
            }
            if (!secondaryColours.isEmpty()) {
                coloursList.add(secondaryColours);
            }
            try {
                if (baseElement.getOptionalFirstOf("colours").isPresent()) {
                    for (Element element4 : baseElement.getAllOf("colours")) {
                        ArrayList<Colour> arrayList = new ArrayList<Colour>();
                        if (!element4.getAttribute("values").isEmpty()) {
                            arrayList.addAll(ColourListPresets.getColourListFromId(element4.getAttribute("values")));
                        } else {
                            for (Element colour : element4.getAllOf("colour")) {
                                String text = colour.getTextContent();
                                if (text.startsWith("presetColourGroup")) {
                                    arrayList.addAll((Collection)this.presetColourGroups.get(Integer.valueOf(text.substring(text.length() - 1)) - 1));
                                    continue;
                                }
                                arrayList.add(PresetColour.getColourFromId(text));
                            }
                        }
                        if (arrayList.isEmpty()) continue;
                        coloursList.add(arrayList);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("AbstractOutfit error: colours fail 1");
            }
            ArrayList<Colour> arrayList = new ArrayList<Colour>();
            for (List list : coloursList) {
                arrayList.add((Colour)Util.randomItemFrom(list));
            }
            if (dt != null) {
                AbstractWeapon abstractWeapon = Main.game.getItemGen().generateWeapon(wt, dt, arrayList);
            } else {
                AbstractWeapon abstractWeapon = Main.game.getItemGen().generateWeapon(wt, Util.randomItemFrom(wt.getAvailableDamageTypes()), arrayList);
            }
            return var9_27;
        }
        catch (XMLMissingTagException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Femininity getFemininity() {
        return this.femininity;
    }

    public List<WorldRegion> getWorldRegions() {
        return this.worldRegions;
    }

    public List<AbstractWorldType> getWorldTypes() {
        return this.worldTypes;
    }

    public List<OutfitType> getOutfitTypes() {
        return this.outfitTypes;
    }

    public List<LegConfiguration> getAcceptableLegConfigurations() {
        return this.acceptableLegConfigurations;
    }

    public String getConditional() {
        return this.conditional;
    }

    public int getWeight() {
        return this.weight;
    }
}

