/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory.outfit;

import com.lilithsthrone.game.inventory.clothing.AbstractClothingType;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import java.util.ArrayList;
import java.util.List;

public class OutfitPotential {
    private List<AbstractClothingType> types;
    private List<List<Colour>> colours;

    public OutfitPotential(List<AbstractClothingType> types, List<List<Colour>> colours) {
        if (types != null) {
            this.types = types;
        } else {
            types = new ArrayList<AbstractClothingType>();
        }
        this.colours = colours;
    }

    public List<AbstractClothingType> getTypes() {
        return this.types;
    }

    public List<Colour> getColoursForClothingGeneration() {
        ArrayList<Colour> coloursForGeneration = new ArrayList<Colour>();
        for (List<Colour> c : this.getColourLists()) {
            coloursForGeneration.add(Util.randomItemFrom(c));
        }
        return coloursForGeneration;
    }

    public List<List<Colour>> getColourLists() {
        return this.colours;
    }

    public List<Colour> getColours(int index) {
        try {
            return this.getColourLists().get(index);
        }
        catch (Exception ex) {
            return new ArrayList<Colour>();
        }
    }
}

