/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory.outfit;

import com.lilithsthrone.game.inventory.outfit.AbstractOutfit;
import com.lilithsthrone.utils.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum OutfitType {
    MUGGER,
    PROSTITUTE,
    CASUAL,
    JOB_SMART,
    JOB_LABOUR,
    CLUBBING,
    CASUAL_DATE,
    FORMAL_DATE,
    ATHLETIC,
    NIGHTWEAR,
    NIGHTWEAR_SEXY;

    private static List<AbstractOutfit> allOutfits;
    private static List<AbstractOutfit> moddedOutfits;
    private static Map<AbstractOutfit, String> outfitsToIdMap;
    private static Map<String, AbstractOutfit> idToOutfitMap;

    public static AbstractOutfit getOutfitTypeFromId(String id) {
        id = Util.getClosestStringMatchUnordered(id, idToOutfitMap.keySet());
        return idToOutfitMap.get(id);
    }

    public static String getIdFromOutfitType(AbstractOutfit outfitsType) {
        return outfitsToIdMap.get(outfitsType);
    }

    public static List<AbstractOutfit> getOutfitsFromIdStart(String idStart) {
        ArrayList<AbstractOutfit> returnList = new ArrayList<AbstractOutfit>();
        for (Map.Entry<String, AbstractOutfit> entry : idToOutfitMap.entrySet()) {
            if (!entry.getKey().startsWith(idStart)) continue;
            returnList.add(entry.getValue());
        }
        return returnList;
    }

    public static List<AbstractOutfit> getAllOutfits() {
        return allOutfits;
    }

    public static List<AbstractOutfit> getModdedOutfits() {
        return moddedOutfits;
    }

    static {
        outfitsToIdMap = new HashMap<AbstractOutfit, String>();
        idToOutfitMap = new HashMap<String, AbstractOutfit>();
        allOutfits = new ArrayList<AbstractOutfit>();
        moddedOutfits = new ArrayList<AbstractOutfit>();
        Map<String, Map<String, File>> moddedFilesMap = Util.getExternalModFilesById("/outfits");
        for (Map.Entry<String, Map<String, File>> entry : moddedFilesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                try {
                    AbstractOutfit ct = new AbstractOutfit(innerEntry.getValue()){};
                    moddedOutfits.add(ct);
                    String id = innerEntry.getKey();
                    outfitsToIdMap.put(ct, id);
                    idToOutfitMap.put(id, ct);
                }
                catch (Exception ex) {
                    System.err.println("Loading modded outfit failed at 'OutfitType'. File path: " + innerEntry.getValue().getAbsolutePath());
                    System.err.println("Actual exception: ");
                    ex.printStackTrace(System.err);
                }
            }
        }
        allOutfits.addAll(moddedOutfits);
        Map<String, Map<String, File>> filesMap = Util.getExternalFilesById("res/outfits");
        for (Map.Entry<String, Map<String, File>> entry : filesMap.entrySet()) {
            for (Map.Entry<String, File> innerEntry : entry.getValue().entrySet()) {
                try {
                    AbstractOutfit ct = new AbstractOutfit(innerEntry.getValue()){};
                    allOutfits.add(ct);
                    String id = innerEntry.getKey();
                    outfitsToIdMap.put(ct, id);
                    idToOutfitMap.put(id, ct);
                }
                catch (Exception ex) {
                    System.err.println("Loading outfit failed at 'OutfitType'. File path: " + innerEntry.getValue().getAbsolutePath());
                    System.err.println("Actual exception: ");
                    ex.printStackTrace(System.err);
                }
            }
        }
    }
}

