/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.inventory.weapon;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.controller.xmlParsing.XMLMissingTagException;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.combat.DamageType;
import com.lilithsthrone.game.combat.DamageVariance;
import com.lilithsthrone.game.combat.moves.AbstractCombatMove;
import com.lilithsthrone.game.combat.moves.CombatMove;
import com.lilithsthrone.game.combat.spells.Spell;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.AbstractCoreItem;
import com.lilithsthrone.game.inventory.AbstractCoreType;
import com.lilithsthrone.game.inventory.AbstractSetBonus;
import com.lilithsthrone.game.inventory.ColourReplacement;
import com.lilithsthrone.game.inventory.ItemTag;
import com.lilithsthrone.game.inventory.Rarity;
import com.lilithsthrone.game.inventory.SetBonus;
import com.lilithsthrone.game.inventory.enchanting.AbstractItemEffectType;
import com.lilithsthrone.game.inventory.enchanting.ItemEffect;
import com.lilithsthrone.game.inventory.enchanting.ItemEffectType;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.game.inventory.weapon.WeaponType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.ColourListPresets;
import com.lilithsthrone.utils.colours.PresetColour;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.w3c.dom.Document;

public abstract class AbstractWeaponType
extends AbstractCoreType {
    private int baseValue;
    private boolean mod;
    private boolean melee;
    private boolean twoHanded;
    private boolean oneShot;
    private float oneShotChanceToRecoverAfterTurn;
    private float oneShotChanceToRecoverAfterCombat;
    private boolean appendDamageName;
    private String determiner;
    boolean plural;
    private String name;
    private String namePlural;
    private String attackDescriptor;
    private String attackDescriptionPrefix;
    private String attackTooltipDescription;
    private String description;
    private AbstractSetBonus clothingSet;
    private Rarity rarity;
    private float physicalResistance;
    private String equipText;
    private String unequipText;
    private List<String> hitDescriptions;
    private List<String> hitCriticalDescriptions;
    private List<String> missDescriptions;
    private List<String> oneShotEndTurnRecoveryDescriptions;
    protected String hitEffect;
    protected String criticalHitEffect;
    private String pathNamePrefix;
    private String pathName;
    private String pathNameEquipped;
    private String authorDescription;
    protected int damage;
    protected List<Util.Value<Integer, Integer>> aoeDamage;
    protected int arcaneCost;
    protected DamageVariance damageVariance;
    private List<DamageType> availableDamageTypes;
    private boolean spellRegenOnDamageTypeChange;
    private Map<DamageType, List<Spell>> spells;
    private boolean combatMovesRegenOnDamageTypeChange;
    private Map<DamageType, List<AbstractCombatMove>> combatMoves;
    protected List<ItemEffect> effects;
    protected List<String> extraEffects;
    private Map<String, String> SVGStringMap;
    private Map<String, String> SVGStringEquippedMap;
    private String SVGStringDesaturated;
    private String SVGStringEquippedDesaturated;
    private List<ColourReplacement> colourReplacements;
    public Map<Integer, Integer> copyGenerationColours;
    private List<ItemTag> itemTags = new ArrayList<ItemTag>();

    public AbstractWeaponType(File weaponXMLFile, String author, boolean mod) {
        if (weaponXMLFile.exists()) {
            try {
                Document doc = Main.getDocBuilder().parse(weaponXMLFile);
                doc.getDocumentElement().normalize();
                Element weaponElement = Element.getDocumentRootElement(weaponXMLFile);
                Element coreAttributes = null;
                try {
                    coreAttributes = weaponElement.getMandatoryFirstOf("coreAtributes");
                }
                catch (XMLMissingTagException ex) {
                    coreAttributes = weaponElement.getMandatoryFirstOf("coreAttributes");
                }
                this.itemTags = Util.toEnumList(coreAttributes.getMandatoryFirstOf("itemTags").getAllOf("tag"), ItemTag.class);
                this.mod = mod;
                this.baseValue = Integer.valueOf(coreAttributes.getMandatoryFirstOf("value").getTextContent());
                this.melee = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("melee").getTextContent());
                this.twoHanded = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("twoHanded").getTextContent());
                this.oneShot = coreAttributes.getOptionalFirstOf("oneShotWeapon").isPresent() ? Boolean.valueOf(coreAttributes.getMandatoryFirstOf("oneShotWeapon").getTextContent()) : false;
                this.oneShotChanceToRecoverAfterTurn = coreAttributes.getOptionalFirstOf("oneShotWeaponChanceToRecoverAfterTurn").isPresent() ? Float.valueOf(coreAttributes.getMandatoryFirstOf("oneShotWeaponChanceToRecoverAfterTurn").getTextContent()).floatValue() : 0.0f;
                this.oneShotChanceToRecoverAfterCombat = coreAttributes.getOptionalFirstOf("oneShotWeaponChanceToRecoverAfterCombat").isPresent() ? Float.valueOf(coreAttributes.getMandatoryFirstOf("oneShotWeaponChanceToRecoverAfterCombat").getTextContent()).floatValue() : 0.0f;
                this.determiner = coreAttributes.getMandatoryFirstOf("determiner").getTextContent();
                this.plural = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("namePlural").getAttribute("pluralByDefault"));
                this.name = coreAttributes.getMandatoryFirstOf("name").getTextContent();
                this.namePlural = coreAttributes.getMandatoryFirstOf("namePlural").getTextContent();
                this.description = coreAttributes.getMandatoryFirstOf("description").getTextContent();
                this.attackDescriptor = coreAttributes.getMandatoryFirstOf("attackDescriptor").getTextContent();
                this.attackDescriptionPrefix = coreAttributes.getOptionalFirstOf("attackDescriptionPrefix").isPresent() ? coreAttributes.getMandatoryFirstOf("attackDescriptionPrefix").getTextContent() : this.attackDescriptor;
                this.attackTooltipDescription = coreAttributes.getMandatoryFirstOf("attackTooltipDescription").getTextContent();
                this.appendDamageName = !coreAttributes.getMandatoryFirstOf("name").getAttribute("appendDamageName").isEmpty() ? Boolean.valueOf(coreAttributes.getMandatoryFirstOf("name").getAttribute("appendDamageName")) : true;
                this.authorDescription = coreAttributes.getOptionalFirstOf("weaponAuthorTag").isPresent() ? coreAttributes.getMandatoryFirstOf("weaponAuthorTag").getTextContent() : (coreAttributes.getOptionalFirstOf("authorTag").isPresent() ? coreAttributes.getMandatoryFirstOf("authorTag").getTextContent() : (!author.equalsIgnoreCase("innoxia") ? (this.plural ? this.namePlural : this.name) + "\u8868\u9762\u4e0a\u96c5\u81f4\u7684\u94ed\u523b\u63d0\u9192\u4f60\uff1a\u6b66\u5668\u662f\u7531\u90a3\u4f4d'" + Util.capitaliseSentence(author) + "'\u5236\u9020\u7684\u3002" : ""));
                this.equipText = coreAttributes.getMandatoryFirstOf("equipText").getTextContent();
                this.unequipText = coreAttributes.getMandatoryFirstOf("unequipText").getTextContent();
                this.pathNamePrefix = weaponXMLFile.getParentFile().getAbsolutePath() + "/";
                this.pathName = this.pathNamePrefix + coreAttributes.getMandatoryFirstOf("imageName").getTextContent();
                Predicate<Element> filterEmptyElements = element -> !element.getTextContent().isEmpty();
                this.pathNameEquipped = coreAttributes.getOptionalFirstOf("imageEquippedName").filter(filterEmptyElements).map(o -> o.getTextContent()).orElse(this.pathName);
                this.damage = Integer.valueOf(coreAttributes.getMandatoryFirstOf("damage").getTextContent());
                this.arcaneCost = Integer.valueOf(coreAttributes.getMandatoryFirstOf("arcaneCost").getTextContent());
                this.damageVariance = DamageVariance.valueOf(coreAttributes.getMandatoryFirstOf("damageVariance").getTextContent());
                this.aoeDamage = new ArrayList<Util.Value<Integer, Integer>>();
                if (coreAttributes.getOptionalFirstOf("aoe").isPresent()) {
                    for (Element e2 : coreAttributes.getAllOf("aoe")) {
                        this.aoeDamage.add(new Util.Value<Integer, Integer>(Integer.valueOf(e2.getAttribute("chance")), Integer.valueOf(e2.getTextContent())));
                    }
                }
                this.availableDamageTypes = coreAttributes.getOptionalFirstOf("availableDamageTypes").isPresent() ? coreAttributes.getMandatoryFirstOf("availableDamageTypes").getAllOf("damageType").stream().map(Element::getTextContent).map(DamageType::valueOf).collect(Collectors.toList()) : new ArrayList<DamageType>();
                this.spells = new HashMap<DamageType, List<Spell>>();
                if (coreAttributes.getOptionalFirstOf("spells").isPresent()) {
                    this.spellRegenOnDamageTypeChange = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("spells").getAttribute("changeOnReforge"));
                    for (Element e2 : coreAttributes.getMandatoryFirstOf("spells").getAllOf("spell")) {
                        String spellId = e2.getTextContent();
                        spellId = spellId.replaceAll("DARK_SIREN_BANEFUL_FISSURE", "DARK_SIREN_SIRENS_CALL");
                        Spell s = Spell.valueOf(spellId);
                        DamageType dt = null;
                        if (!e2.getAttribute("damageType").isEmpty()) {
                            dt = DamageType.valueOf(e2.getAttribute("damageType"));
                        }
                        this.spells.putIfAbsent(dt, new ArrayList());
                        this.spells.get((Object)dt).add(s);
                    }
                }
                this.combatMoves = new HashMap<DamageType, List<AbstractCombatMove>>();
                if (coreAttributes.getOptionalFirstOf("combatMoves").isPresent()) {
                    this.combatMovesRegenOnDamageTypeChange = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("combatMoves").getAttribute("changeOnReforge"));
                    for (Element e2 : coreAttributes.getMandatoryFirstOf("combatMoves").getAllOf("move")) {
                        AbstractCombatMove cm = CombatMove.getCombatMoveFromId(e2.getTextContent());
                        DamageType dt = null;
                        if (!e2.getAttribute("damageType").isEmpty()) {
                            dt = DamageType.valueOf(e2.getAttribute("damageType"));
                        }
                        this.combatMoves.putIfAbsent(dt, new ArrayList());
                        this.combatMoves.get((Object)dt).add(cm);
                    }
                }
                this.clothingSet = coreAttributes.getOptionalFirstOf("weaponSet").filter(filterEmptyElements).map(Element::getTextContent).map(SetBonus::getSetBonusFromId).orElse(null);
                this.effects = coreAttributes.getMandatoryFirstOf("effects").getAllOf("effect").stream().map(e -> ItemEffect.loadFromXML(e.getInnerElement(), e.getDocument())).filter(Objects::nonNull).collect(Collectors.toList());
                this.extraEffects = new ArrayList<String>();
                if (coreAttributes.getOptionalFirstOf("extraEffects").isPresent()) {
                    for (Element e2 : coreAttributes.getMandatoryFirstOf("extraEffects").getAllOf("effect")) {
                        this.extraEffects.add(e2.getTextContent());
                    }
                }
                this.hitEffect = "";
                if (coreAttributes.getOptionalFirstOf("onHitEffect").isPresent()) {
                    this.hitEffect = coreAttributes.getMandatoryFirstOf("onHitEffect").getTextContent();
                }
                this.criticalHitEffect = "";
                if (coreAttributes.getOptionalFirstOf("onCriticalHitEffect").isPresent()) {
                    this.criticalHitEffect = coreAttributes.getMandatoryFirstOf("onCriticalHitEffect").getTextContent();
                }
                this.rarity = Rarity.valueOf(coreAttributes.getMandatoryFirstOf("rarity").getTextContent());
                if (coreAttributes.getOptionalFirstOf("physicalResistance").isPresent()) {
                    this.physicalResistance = Float.valueOf(coreAttributes.getMandatoryFirstOf("physicalResistance").getTextContent()).floatValue();
                }
                if (weaponElement.getOptionalFirstOf("hitDescriptions").isPresent()) {
                    this.hitDescriptions = weaponElement.getMandatoryFirstOf("hitDescriptions").getAllOf("hitText").stream().map(o -> o.getTextContent()).collect(Collectors.toList());
                    this.hitCriticalDescriptions = weaponElement.getMandatoryFirstOf("hitDescriptions").getAllOf("criticalHitText").stream().map(o -> o.getTextContent()).collect(Collectors.toList());
                } else {
                    this.hitDescriptions = new ArrayList<String>();
                    this.hitCriticalDescriptions = new ArrayList<String>();
                }
                this.missDescriptions = weaponElement.getOptionalFirstOf("missDescriptions").isPresent() ? weaponElement.getMandatoryFirstOf("missDescriptions").getAllOf("missText").stream().map(o -> o.getTextContent()).collect(Collectors.toList()) : Util.newArrayListOfValues("[npc.Name]\u6062\u590d\u4e86[npc.her]\u7684" + this.name + "\uff01");
                this.oneShotEndTurnRecoveryDescriptions = weaponElement.getOptionalFirstOf("oneShotEndTurnRecoveryDescriptions").isPresent() ? weaponElement.getMandatoryFirstOf("oneShotEndTurnRecoveryDescriptions").getAllOf("recoveryText").stream().map(o -> o.getTextContent()).collect(Collectors.toList()) : new ArrayList<String>();
                Function<Element, List> getColoursFromElement = colorsElement -> {
                    String values = colorsElement.getAttribute("values");
                    try {
                        if (values.isEmpty()) {
                            return colorsElement.getAllOf("colour").stream().map(Element::getTextContent).map(PresetColour::getColourFromId).collect(Collectors.toList());
                        }
                        return ColourListPresets.getColourListFromId(values);
                    }
                    catch (Exception e) {
                        AbstractWeaponType.printHelpfulErrorForEnumValueMismatches(e);
                        throw new IllegalStateException("Colour tag reading failure: " + colorsElement.getTagName() + " " + e.getMessage(), e);
                    }
                };
                this.copyGenerationColours = new HashMap<Integer, Integer>();
                boolean primaryRecolourAllowed = true;
                if (coreAttributes.getOptionalFirstOf("primaryColours").isPresent() && !coreAttributes.getMandatoryFirstOf("primaryColours").getAttribute("recolouringAllowed").isEmpty()) {
                    primaryRecolourAllowed = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("primaryColours").getAttribute("recolouringAllowed"));
                }
                if (coreAttributes.getOptionalFirstOf("primaryColours").isPresent() && !coreAttributes.getMandatoryFirstOf("primaryColours").getAttribute("copyColourIndex").isEmpty()) {
                    this.copyGenerationColours.put(0, Integer.valueOf(coreAttributes.getMandatoryFirstOf("primaryColours").getAttribute("copyColourIndex")));
                }
                List importedPrimaryColours = coreAttributes.getOptionalFirstOf("primaryColours").map(getColoursFromElement::apply).orElseGet(ArrayList::new);
                List importedPrimaryColoursDye = coreAttributes.getOptionalFirstOf("primaryColoursDye").map(getColoursFromElement::apply).orElseGet(ArrayList::new);
                boolean secondaryRecolourAllowed = true;
                if (coreAttributes.getOptionalFirstOf("secondaryColours").isPresent() && !coreAttributes.getMandatoryFirstOf("secondaryColours").getAttribute("recolouringAllowed").isEmpty()) {
                    secondaryRecolourAllowed = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("secondaryColours").getAttribute("recolouringAllowed"));
                }
                if (coreAttributes.getOptionalFirstOf("secondaryColours").isPresent() && !coreAttributes.getMandatoryFirstOf("secondaryColours").getAttribute("copyColourIndex").isEmpty()) {
                    this.copyGenerationColours.put(1, Integer.valueOf(coreAttributes.getMandatoryFirstOf("secondaryColours").getAttribute("copyColourIndex")));
                }
                List importedSecondaryColours = coreAttributes.getOptionalFirstOf("secondaryColours").map(getColoursFromElement::apply).orElseGet(ArrayList::new);
                List importedSecondaryColoursDye = coreAttributes.getOptionalFirstOf("secondaryColoursDye").map(getColoursFromElement::apply).orElseGet(ArrayList::new);
                boolean tertiaryRecolourAllowed = true;
                if (coreAttributes.getOptionalFirstOf("tertiaryColours").isPresent() && !coreAttributes.getMandatoryFirstOf("tertiaryColours").getAttribute("recolouringAllowed").isEmpty()) {
                    tertiaryRecolourAllowed = Boolean.valueOf(coreAttributes.getMandatoryFirstOf("tertiaryColours").getAttribute("recolouringAllowed"));
                }
                if (coreAttributes.getOptionalFirstOf("tertiaryColours").isPresent() && !coreAttributes.getMandatoryFirstOf("tertiaryColours").getAttribute("copyColourIndex").isEmpty()) {
                    this.copyGenerationColours.put(2, Integer.valueOf(coreAttributes.getMandatoryFirstOf("tertiaryColours").getAttribute("copyColourIndex")));
                }
                List importedTertiaryColours = coreAttributes.getOptionalFirstOf("tertiaryColours").map(getColoursFromElement::apply).orElseGet(ArrayList::new);
                List importedTertiaryColoursDye = coreAttributes.getOptionalFirstOf("tertiaryColoursDye").map(getColoursFromElement::apply).orElseGet(ArrayList::new);
                this.setUpColours(primaryRecolourAllowed, importedPrimaryColours, importedPrimaryColoursDye, secondaryRecolourAllowed, importedSecondaryColours, importedSecondaryColoursDye, tertiaryRecolourAllowed, importedTertiaryColours, importedTertiaryColoursDye);
                if (weaponElement.getOptionalFirstOf("customColours").isPresent()) {
                    Element customColoursElement = weaponElement.getMandatoryFirstOf("customColours");
                    for (Element e3 : customColoursElement.getAllOf("customColour")) {
                        try {
                            ArrayList<String> replacementStrings = new ArrayList<String>();
                            int i = 0;
                            while (!e3.getAttribute("c" + i).isEmpty()) {
                                replacementStrings.add(e3.getAttribute("c" + i));
                                ++i;
                            }
                            boolean recolourAllowed = true;
                            if (!e3.getAttribute("recolouringAllowed").isEmpty()) {
                                recolourAllowed = Boolean.valueOf(e3.getAttribute("recolouringAllowed"));
                            }
                            if (!e3.getAttribute("copyColourIndex").isEmpty()) {
                                this.copyGenerationColours.put(this.colourReplacements.size() - 1, Integer.valueOf(e3.getAttribute("copyColourIndex")));
                            }
                            List defaultColours = getColoursFromElement.apply(e3.getMandatoryFirstOf("defaultColours"));
                            List extraColours = getColoursFromElement.apply(e3.getMandatoryFirstOf("extraColours"));
                            this.colourReplacements.add(new ColourReplacement(recolourAllowed, replacementStrings, defaultColours, extraColours));
                        }
                        catch (Exception ex) {
                            System.err.println("Error in loading customColours from weapon: " + this.getName());
                        }
                    }
                }
                if (this.colourReplacements.isEmpty()) {
                    throw new Exception("AbstractWeaponType (" + weaponXMLFile.getName() + "): colourReplacements is empty!");
                }
                this.SVGStringMap = new HashMap<String, String>();
                this.SVGStringEquippedMap = new HashMap<String, String>();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("WeaponType was unable to be loaded from file! (" + weaponXMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && o instanceof AbstractWeaponType && ((AbstractWeaponType)o).getName().equals(this.getName()) && ((AbstractWeaponType)o).isMelee() == this.isMelee() && ((AbstractWeaponType)o).isTwoHanded() == this.isTwoHanded() && ((AbstractWeaponType)o).getPathName().equals(this.getPathName()) && ((AbstractWeaponType)o).getPhysicalResistance() == this.getPhysicalResistance() && ((AbstractWeaponType)o).getDamage() == this.getDamage() && ((AbstractWeaponType)o).getDamageVariance() == this.getDamageVariance() && ((AbstractWeaponType)o).getRarity() == this.getRarity() && ((AbstractWeaponType)o).getAvailableDamageTypes().equals(this.getAvailableDamageTypes()) && ((AbstractWeaponType)o).getSpells().equals(this.getSpells()) && ((AbstractWeaponType)o).getEffects().equals(this.getEffects()) && ((AbstractWeaponType)o).getClothingSet() == this.getClothingSet();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + this.getPathName().hashCode();
        result = 31 * result + Float.floatToIntBits(this.getPhysicalResistance());
        result = 31 * result + this.getDamage();
        result = 31 * result + this.getDamageVariance().hashCode();
        result = 31 * result + (this.melee ? 1 : 0);
        result = 31 * result + (this.twoHanded ? 1 : 0);
        result = 31 * result + (this.oneShot ? 1 : 0);
        result = 31 * result + this.getRarity().hashCode();
        result = 31 * result + this.getAvailableDamageTypes().hashCode();
        result = 31 * result + this.getSpells().hashCode();
        result = 31 * result + this.getEffects().hashCode();
        if (this.getClothingSet() != null) {
            result = 31 * result + this.getClothingSet().hashCode();
        }
        return result;
    }

    private void setUpColours(boolean primaryRecolouringAllowed, List<Colour> availablePrimaryColours, List<Colour> availablePrimaryDyeColours, boolean secondaryRecolouringAllowed, List<Colour> availableSecondaryColours, List<Colour> availableSecondaryDyeColours, boolean tertiaryRecolouringAllowed, List<Colour> availableTertiaryColours, List<Colour> availableTertiaryDyeColours) {
        this.colourReplacements = new ArrayList<ColourReplacement>();
        this.colourReplacements.add(new ColourReplacement(true, ColourReplacement.DEFAULT_PRIMARY_REPLACEMENTS, PresetColour.getAllPresetColours(), null));
        if (availablePrimaryColours != null && !availablePrimaryColours.isEmpty() || availablePrimaryDyeColours != null && !availablePrimaryDyeColours.isEmpty()) {
            this.colourReplacements.add(new ColourReplacement(primaryRecolouringAllowed, ColourReplacement.DEFAULT_SECONDARY_REPLACEMENTS, availablePrimaryColours, availablePrimaryDyeColours));
        }
        if (availableSecondaryColours != null && !availableSecondaryColours.isEmpty() || availableSecondaryDyeColours != null && !availableSecondaryDyeColours.isEmpty()) {
            this.colourReplacements.add(new ColourReplacement(secondaryRecolouringAllowed, ColourReplacement.DEFAULT_TERTIARY_REPLACEMENTS, availableSecondaryColours, availableSecondaryDyeColours));
        }
        if (availableTertiaryColours != null && !availableTertiaryColours.isEmpty() || availableTertiaryDyeColours != null && !availableTertiaryDyeColours.isEmpty()) {
            this.colourReplacements.add(new ColourReplacement(tertiaryRecolouringAllowed, ColourReplacement.DEFAULT_QUATERNARY_REPLACEMENTS, availableTertiaryColours, availableTertiaryDyeColours));
        }
    }

    private static void printHelpfulErrorForEnumValueMismatches(Exception ex) {
        HashMap<Class<ColourListPresets>, Set<String>> possibleEnumValues = new HashMap<Class<ColourListPresets>, Set<String>>();
        possibleEnumValues.put(ColourListPresets.class, ColourListPresets.getIdToColourListMap().keySet());
        String exMessage = ex.getMessage();
        if (exMessage.startsWith("No ColourListPreset constant")) {
            for (Map.Entry possibleMatch : possibleEnumValues.entrySet()) {
                if (!exMessage.contains(((Class)possibleMatch.getKey()).getCanonicalName())) continue;
                StringJoiner valueLister = new StringJoiner(",");
                Arrays.asList((Set)possibleMatch.getValue()).forEach(enumValue -> valueLister.add(enumValue.toString()));
                System.err.println("Possible values for " + ((Class)possibleMatch.getKey()).getSimpleName() + " are " + valueLister.toString());
            }
        }
    }

    public boolean isMod() {
        return this.mod;
    }

    public String getId() {
        return WeaponType.weaponToIdMap.get(this);
    }

    public String equipText(GameCharacter character) {
        return UtilText.parse(character, this.equipText, new ParserTag[0]);
    }

    public String unequipText(GameCharacter character) {
        return UtilText.parse(character, this.unequipText, new ParserTag[0]);
    }

    public String getAttackDescription(GameCharacter character, GameCharacter target, AbstractWeapon weapon, boolean isHit, boolean critical) {
        if (isHit) {
            return UtilText.parse(character, target, this.getHitText(character, target, weapon, critical), new ParserTag[0]);
        }
        return UtilText.parse(character, target, this.getMissText(character, target, weapon), new ParserTag[0]);
    }

    public String getHitText(GameCharacter character, GameCharacter target, AbstractWeapon weapon, boolean critical) {
        if (critical && !this.hitCriticalDescriptions.isEmpty()) {
            return UtilText.parse(Util.newArrayListOfValues(character, target), (AbstractCoreItem)weapon, Util.randomItemFrom(this.hitCriticalDescriptions), new ParserTag[0]);
        }
        return UtilText.parse(Util.newArrayListOfValues(character, target), (AbstractCoreItem)weapon, Util.randomItemFrom(this.hitDescriptions), new ParserTag[0]);
    }

    public String getMissText(GameCharacter character, GameCharacter target, AbstractWeapon weapon) {
        return UtilText.parse(Util.newArrayListOfValues(character, target), (AbstractCoreItem)weapon, Util.randomItemFrom(this.missDescriptions), new ParserTag[0]);
    }

    public String getOneShotEndTurnRecoveryDescription(GameCharacter character) {
        return UtilText.parse(character, Util.randomItemFrom(this.oneShotEndTurnRecoveryDescriptions), new ParserTag[0]);
    }

    protected static String getDescriptions(GameCharacter character, GameCharacter target, boolean isHit, String playerStrikingNPC, String NPCStrikingPlayer, String NPCStrikingNPC, String playerMissingNPC, String NPCMissingPlayer, String NPCMissingNPC) {
        if (isHit) {
            if (character.isPlayer()) {
                return UtilText.parse(target, playerStrikingNPC, new ParserTag[0]);
            }
            if (target.isPlayer()) {
                return UtilText.parse(character, NPCStrikingPlayer, new ParserTag[0]);
            }
            return UtilText.parse(character, target, NPCStrikingNPC, new ParserTag[0]);
        }
        if (character.isPlayer()) {
            return UtilText.parse(target, playerMissingNPC, new ParserTag[0]);
        }
        if (target.isPlayer()) {
            return UtilText.parse(character, NPCMissingPlayer, new ParserTag[0]);
        }
        return UtilText.parse(character, target, NPCMissingNPC, new ParserTag[0]);
    }

    public static String genericMeleeAttackDescription(GameCharacter character, GameCharacter target, boolean isHit) {
        if (isHit) {
            if (character.isFeral()) {
                return UtilText.parse(character, target, UtilText.returnStringAtRandom("[npc.Name]\u7acb\u9a6c\u51b2\u4e0a\u524d\u53bb\uff0c\u62ac\u811a\u7ed3\u7ed3\u5b9e\u5b9e\u5730\u8e39\u5728[npc2.namePos]\u7684\u8eab\u4e0a\u3002", "[npc.Name]\u8e22\u51fa\u4e00\u811a\uff0c\u7ed3\u7ed3\u5b9e\u5b9e\u5730\u8e22\u5728\u4e86[npc2.name]\u7684\u817f\u4e0a\uff01", "[npc.Name]\u5f92\u624b\u5411[npc2.name]\u88ad\u53bb\uff0c\u5bf9\u7740[npc2.her]\u7684\u8eab\u5b50\u72e0\u72e0\u5730\u6765\u4e86\u4e00\u811a\u3002"), new ParserTag[0]);
            }
            return UtilText.parse(character, target, UtilText.returnStringAtRandom("[npc.Name]\u7acb\u9a6c\u51b2\u4e0a\u524d\u53bb\uff0c\u4e3e\u62f3\u7ed3\u7ed3\u5b9e\u5b9e\u5730\u6253\u5728[npc2.namePos]\u7684[npc2.arm]\u4e0a\u3002", "[npc.Name]\u6325\u51fa\u4e00\u62f3\uff0c\u7ed3\u7ed3\u5b9e\u5b9e\u5730\u6253\u5728\u4e86[npc2.name]\u7684[npc2.arm]\u4e0a\uff01", "[npc.Name]\u5f92\u624b\u5411[npc2.name]\u88ad\u53bb\uff0c\u5bf9\u7740[npc2.her]\u7684\u8eab\u5b50\u72e0\u72e0\u5730\u6765\u4e86\u4e00\u62f3\u3002"), new ParserTag[0]);
        }
        return UtilText.parse(character, target, UtilText.returnStringAtRandom("[npc.Name]\u7acb\u9a6c\u51b2\u4e0a\u524d\u53bb\uff0c\u5411\u7740[npc2.namePos]\u7684[npc2.arm]\u6325\u51fa\u4e00\u62f3\uff0c\u4f46\u88ab\u53ca\u65f6\u8eb2\u5f00\u4e86\u3002", "[npc.Name]\u5411[npc2.name]\u6325\u51fa\u4e00\u62f3\uff0c\u4f46\u5374\u6ca1\u80fd\u51fb\u4e2d[npc2.her]\u8eab\u4f53\u7684\u4efb\u4f55\u4e00\u5904\u3002", "[npc.Name]\u5f92\u624b\u5411[npc2.name]\u88ad\u53bb\uff0c\u5374\u6ca1\u80fd\u51fb\u4e2d\u3002"), new ParserTag[0]);
    }

    public boolean isAbleToBeUsed(GameCharacter user, GameCharacter target) {
        if (this.getArcaneCost() > 0) {
            return user.getEssenceCount() > 0;
        }
        return true;
    }

    public String getUnableToBeUsedDescription() {
        if (this.getArcaneCost() > 0) {
            return "\u4f60\u9700\u8981\u81f3\u5c11[style.boldBad(\u4e00)][style.boldArcane(\u5965\u672f\u7cbe\u534e)]\u624d\u80fd\u4f7f\u7528\u8be5\u6b66\u5668\uff01";
        }
        return "";
    }

    public String applyExtraEffects(GameCharacter user, GameCharacter target, boolean isHit, boolean isCritical) {
        StringBuilder sb = new StringBuilder();
        if (this.getArcaneCost() > 0) {
            user.incrementEssenceCount(-this.getArcaneCost(), false);
            sb.append(UtilText.parse(user, "\u4f7f\u7528" + this.getName() + "\u4ece[npc.namePos]\u7075\u6c14\u4e2d\u6d88\u8017\u4e86[style.boldBad(" + Util.intToString(this.getArcaneCost()) + ")][style.boldArcane(\u5965\u672f\u7cbe\u534e)]\uff01", new ParserTag[0]));
        }
        if (isHit) {
            String hitText;
            String string = hitText = isCritical ? this.criticalHitEffect : this.hitEffect;
            if (!hitText.isEmpty()) {
                if (sb.length() > 0) {
                    sb.append("<br/>");
                }
                sb.append(UtilText.parse(user, target, hitText, new ParserTag[0]));
            }
        }
        return sb.toString();
    }

    public int getBaseValue() {
        return this.baseValue;
    }

    public boolean isUsingUnarmedCalculation() {
        return this.getItemTags().contains((Object)ItemTag.WEAPON_UNARMED);
    }

    public boolean isMelee() {
        return this.melee;
    }

    public boolean isTwoHanded() {
        return this.twoHanded;
    }

    public boolean isOneShot() {
        return this.oneShot;
    }

    public float getOneShotChanceToRecoverAfterTurn() {
        return this.oneShotChanceToRecoverAfterTurn;
    }

    public float getOneShotChanceToRecoverAfterCombat() {
        return this.oneShotChanceToRecoverAfterCombat;
    }

    public boolean isAppendDamageName() {
        return this.appendDamageName;
    }

    public String getDeterminer() {
        return this.determiner;
    }

    public boolean isPlural() {
        return this.plural;
    }

    public String getName() {
        if (this.isPlural()) {
            return this.namePlural;
        }
        return this.name;
    }

    public String getNamePlural() {
        return this.namePlural;
    }

    public String getAttackDescriptor() {
        return this.attackDescriptor;
    }

    public String getAttackDescriptionPrefix(GameCharacter user, GameCharacter target) {
        return this.attackDescriptionPrefix;
    }

    public String getAttackDescription(GameCharacter user, GameCharacter target) {
        return UtilText.parse(user, target, this.attackTooltipDescription, new ParserTag[0]);
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getExtraEffects() {
        return this.extraEffects;
    }

    public String getAuthorDescription() {
        return this.authorDescription;
    }

    @Override
    public Rarity getRarity() {
        return this.rarity;
    }

    public float getPhysicalResistance() {
        return this.physicalResistance;
    }

    public AbstractSetBonus getClothingSet() {
        return this.clothingSet;
    }

    public String getPathName() {
        return this.pathName;
    }

    public String getEquippedPathName(GameCharacter characterEquippedTo) {
        String parsedPath = UtilText.parse(characterEquippedTo, this.pathNameEquipped, new ParserTag[0]).trim();
        if (parsedPath.isEmpty()) {
            return null;
        }
        return this.pathNamePrefix + parsedPath;
    }

    public boolean isEquippedSVGImageDifferent() {
        return !this.getPathName().equals(this.pathNameEquipped);
    }

    public int getDamage() {
        return this.damage;
    }

    public DamageVariance getDamageVariance() {
        return this.damageVariance;
    }

    public int getArcaneCost() {
        return this.arcaneCost;
    }

    public List<Util.Value<Integer, Integer>> getAoeDamage() {
        return this.aoeDamage;
    }

    public List<DamageType> getAvailableDamageTypes() {
        return this.availableDamageTypes;
    }

    public boolean isSpellRegenOnDamageTypeChange() {
        return this.spellRegenOnDamageTypeChange;
    }

    public Map<DamageType, List<Spell>> getSpells() {
        return this.spells;
    }

    public List<Spell> getSpells(DamageType damageType) {
        ArrayList<Spell> damageTypeSpells = new ArrayList<Spell>();
        if (this.spells.containsKey(null)) {
            damageTypeSpells.addAll((Collection)this.spells.get(null));
        }
        if (this.spells.containsKey((Object)damageType)) {
            damageTypeSpells.addAll((Collection<Spell>)this.spells.get((Object)damageType));
        }
        return damageTypeSpells;
    }

    public boolean isCombatMoveRegenOnDamageTypeChange() {
        return this.combatMovesRegenOnDamageTypeChange;
    }

    public Map<DamageType, List<AbstractCombatMove>> getCombatMoves() {
        return this.combatMoves;
    }

    public List<AbstractCombatMove> getCombatMoves(DamageType damageType) {
        ArrayList<AbstractCombatMove> damageTypeCombatMoves = new ArrayList<AbstractCombatMove>();
        if (this.combatMoves.containsKey(null)) {
            damageTypeCombatMoves.addAll((Collection)this.combatMoves.get(null));
        }
        if (this.combatMoves.containsKey((Object)damageType)) {
            damageTypeCombatMoves.addAll((Collection<AbstractCombatMove>)this.combatMoves.get((Object)damageType));
        }
        return damageTypeCombatMoves;
    }

    public ColourReplacement getColourReplacement(boolean includeDamageTypeReplacement, int index) {
        List<ColourReplacement> list = this.getColourReplacements(includeDamageTypeReplacement);
        if (index > list.size() - 1) {
            return null;
        }
        return list.get(index);
    }

    public List<ColourReplacement> getColourReplacements(boolean includeDamageTypeReplacement) {
        if (includeDamageTypeReplacement) {
            return this.colourReplacements;
        }
        ArrayList<ColourReplacement> removeZeroList = new ArrayList<ColourReplacement>(this.colourReplacements);
        removeZeroList.remove(0);
        return removeZeroList;
    }

    private static String generateIdentifier(DamageType dt, List<Colour> colours) {
        return AbstractWeaponType.generateIdentifier(null, dt, colours);
    }

    private static String generateIdentifier(GameCharacter character, DamageType dt, List<Colour> colours) {
        StringBuilder sb = new StringBuilder(dt.toString());
        if (character != null) {
            sb.append(character.getId());
        }
        for (Colour c : colours) {
            sb.append(c.getId());
        }
        return sb.toString();
    }

    private void addSVGStringMapping(DamageType dt, List<Colour> colours, String s) {
        this.SVGStringMap.put(AbstractWeaponType.generateIdentifier(dt, colours), s);
    }

    private String getSVGStringFromMap(DamageType dt, List<Colour> colours) {
        return this.SVGStringMap.get(AbstractWeaponType.generateIdentifier(dt, colours));
    }

    public String getSVGImage() {
        DamageType dt = DamageType.PHYSICAL;
        if (this.getAvailableDamageTypes() != null && !this.getAvailableDamageTypes().contains((Object)dt)) {
            dt = this.getAvailableDamageTypes().get(0);
        }
        ArrayList<Colour> colours = new ArrayList<Colour>();
        for (ColourReplacement cr : this.getColourReplacements(false)) {
            colours.add(cr.getFirstOfDefaultColours());
        }
        return this.getSVGImage(dt, colours);
    }

    public String getSVGImage(DamageType dt, List<Colour> colours) {
        if (!this.getAvailableDamageTypes().contains((Object)dt)) {
            return "";
        }
        String stringFromMap = this.getSVGStringFromMap(dt, colours);
        if (stringFromMap != null) {
            return stringFromMap;
        }
        try {
            List<String> lines = Files.readAllLines(Paths.get(this.pathName, new String[0]));
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append(line);
            }
            String s = sb.toString();
            ArrayList<Colour> coloursPlusDT = Util.newArrayListOfValues(dt.getColour());
            coloursPlusDT.addAll(colours);
            s = SvgUtil.colourReplacement(this.getId(), coloursPlusDT, this.getColourReplacements(true), s);
            this.addSVGStringMapping(dt, colours, s);
            return s;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getSVGImageDesaturated() {
        if (this.SVGStringDesaturated != null) {
            return this.SVGStringDesaturated;
        }
        try {
            List<String> lines = Files.readAllLines(Paths.get(this.pathName, new String[0]));
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append(line);
            }
            String s = sb.toString();
            this.SVGStringDesaturated = s = SvgUtil.colourReplacement(this.getId() + "DS", Util.newArrayListOfValues(PresetColour.BASE_GREY, PresetColour.BASE_GREY, PresetColour.BASE_GREY), this.getColourReplacements(true), s);
            return s;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    private String getSVGStringEquippedFromMap(GameCharacter character, DamageType dt, List<Colour> colours) {
        return this.SVGStringEquippedMap.get(AbstractWeaponType.generateIdentifier(character, dt, colours));
    }

    public String getSVGEquippedImage(GameCharacter characterEquipped) {
        DamageType dt = DamageType.PHYSICAL;
        if (this.getAvailableDamageTypes() != null && !this.getAvailableDamageTypes().contains((Object)dt)) {
            dt = this.getAvailableDamageTypes().get(0);
        }
        ArrayList<Colour> colours = new ArrayList<Colour>();
        for (ColourReplacement cr : this.getColourReplacements(false)) {
            colours.add(cr.getFirstOfDefaultColours());
        }
        return this.getSVGEquippedImage(characterEquipped, dt, colours);
    }

    public String getSVGEquippedImage(GameCharacter characterEquipped, DamageType dt, List<Colour> colours) {
        if (!this.isEquippedSVGImageDifferent()) {
            return this.getSVGImage(dt, colours);
        }
        if (!this.getAvailableDamageTypes().contains((Object)dt)) {
            return "";
        }
        String stringFromMap = this.getSVGStringEquippedFromMap(characterEquipped, dt, colours);
        if (stringFromMap != null) {
            return stringFromMap;
        }
        try {
            List<String> lines = Files.readAllLines(Paths.get(this.getEquippedPathName(characterEquipped), new String[0]));
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append(line);
            }
            String s = sb.toString();
            ArrayList<Colour> coloursPlusDT = Util.newArrayListOfValues(dt.getColour());
            coloursPlusDT.addAll(colours);
            s = SvgUtil.colourReplacement(this.getId() + "Equipped", coloursPlusDT, this.getColourReplacements(true), s);
            return s;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getSVGEquippedImageDesaturated(GameCharacter characterEquipped) {
        if (this.SVGStringEquippedDesaturated != null) {
            return this.SVGStringEquippedDesaturated;
        }
        try {
            List<String> lines = Files.readAllLines(Paths.get(this.getEquippedPathName(characterEquipped), new String[0]));
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append(line);
            }
            String s = sb.toString();
            this.SVGStringEquippedDesaturated = s = SvgUtil.colourReplacement(this.getId() + "EquippedDS", Util.newArrayListOfValues(PresetColour.BASE_GREY, PresetColour.BASE_GREY, PresetColour.BASE_GREY), this.getColourReplacements(true), s);
            return s;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public List<ItemEffect> getEffects() {
        return this.effects;
    }

    public boolean isAbleToBeSold() {
        return this.getRarity() != Rarity.QUEST;
    }

    public boolean isAbleToBeDropped() {
        return this.getRarity() != Rarity.QUEST;
    }

    public int getEnchantmentLimit() {
        return 100;
    }

    public AbstractItemEffectType getEnchantmentEffect() {
        return ItemEffectType.WEAPON;
    }

    public AbstractWeaponType getEnchantmentItemType(List<ItemEffect> effects) {
        return this;
    }

    public List<ItemTag> getItemTags() {
        return this.itemTags;
    }
}

