/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.game.occupantManagement;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.character.FluidStored;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.character.attributes.AffectionLevel;
import com.lilithsthrone.game.character.attributes.Attribute;
import com.lilithsthrone.game.character.body.CoverableArea;
import com.lilithsthrone.game.character.body.FluidCum;
import com.lilithsthrone.game.character.body.FluidGirlCum;
import com.lilithsthrone.game.character.body.FluidMilk;
import com.lilithsthrone.game.character.body.abstractTypes.AbstractFluidType;
import com.lilithsthrone.game.character.body.valueEnums.FluidFlavour;
import com.lilithsthrone.game.character.body.valueEnums.FluidModifier;
import com.lilithsthrone.game.character.body.valueEnums.FluidTypeBase;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJob;
import com.lilithsthrone.game.occupantManagement.slave.SlaveJobSetting;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.rendering.SVGImages;
import com.lilithsthrone.utils.Units;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.Vector2i;
import com.lilithsthrone.utils.XMLSaving;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.PlaceUpgrade;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MilkingRoom
implements XMLSaving {
    private AbstractWorldType worldType;
    private Vector2i location;
    private List<FluidStored> fluidsStored;
    private Map<String, List<AbstractClothing>> clothingRemovedForMilking = new HashMap<String, List<AbstractClothing>>();
    private static GameCharacter targetedCharacter = Main.game.getPlayer();
    public static final int INGESTION_AMOUNT = 100;
    public static final int ARTISAN_MILKING_AMOUNT = 2000;
    public static final int BASE_MILKING_AMOUNT = 2500;
    public static final int INDUSTRIAL_MILKING_AMOUNT = 5000;
    public static final int ARTISAN_CUM_MILKING_AMOUNT = 200;
    public static final int BASE_CUM_MILKING_AMOUNT = 250;
    public static final int INDUSTRIAL_CUM_MILKING_AMOUNT = 500;
    public static final int ARTISAN_GIRLCUM_MILKING_AMOUNT = 40;
    public static final int BASE_GIRLCUM_MILKING_AMOUNT = 50;
    public static final int INDUSTRIAL_GIRLCUM_MILKING_AMOUNT = 100;

    public MilkingRoom(AbstractWorldType worldType, Vector2i location) {
        this.worldType = worldType;
        this.location = new Vector2i(location.getX(), location.getY());
        this.fluidsStored = new ArrayList<FluidStored>();
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element element = doc.createElement("milkingRoom");
        parentElement.appendChild(element);
        XMLUtil.addAttribute(doc, element, "worldType", WorldType.getIdFromWorldType(this.getWorldType()));
        XMLUtil.addAttribute(doc, element, "x", String.valueOf(this.getLocation().getX()));
        XMLUtil.addAttribute(doc, element, "y", String.valueOf(this.getLocation().getY()));
        for (FluidStored fluid : this.fluidsStored) {
            fluid.saveAsXML(element, doc);
        }
        if (!this.clothingRemovedForMilking.isEmpty()) {
            Element clothingSaved = doc.createElement("clothingRemovedForMilking");
            element.appendChild(clothingSaved);
            for (Map.Entry<String, List<AbstractClothing>> entry : this.clothingRemovedForMilking.entrySet()) {
                Element clothingCharacter = doc.createElement("clothingCharacter");
                clothingSaved.appendChild(clothingCharacter);
                XMLUtil.addAttribute(doc, clothingCharacter, "id", entry.getKey());
                for (AbstractClothing clothing : entry.getValue()) {
                    Element e = clothing.saveAsXML(clothingSaved, doc);
                    clothingCharacter.appendChild(e);
                }
            }
        }
        return element;
    }

    public static MilkingRoom loadFromXML(Element parentElement, Document doc) {
        try {
            MilkingRoom room = new MilkingRoom(WorldType.getWorldTypeFromId(parentElement.getAttribute("worldType")), new Vector2i(Integer.valueOf(parentElement.getAttribute("x")), Integer.valueOf(parentElement.getAttribute("y"))));
            try {
                NodeList fluidStoredElements = parentElement.getElementsByTagName("fluidStored");
                for (int i = 0; i < fluidStoredElements.getLength(); ++i) {
                    Element element = (Element)fluidStoredElements.item(i);
                    room.getFluidsStored().add(FluidStored.loadFromXML(null, element, doc));
                }
            }
            catch (Exception fluidStoredElements) {
                // empty catch block
            }
            HashMap<FluidStored, Float> uniqueFluids = new HashMap<FluidStored, Float>();
            for (FluidStored fluidStored : room.getFluidsStored()) {
                if (uniqueFluids.containsKey(fluidStored)) {
                    uniqueFluids.put(fluidStored, Float.valueOf(fluidStored.getMillilitres() + ((Float)uniqueFluids.get(fluidStored)).floatValue()));
                    continue;
                }
                uniqueFluids.put(fluidStored, Float.valueOf(fluidStored.getMillilitres()));
            }
            room.fluidsStored = new ArrayList<FluidStored>();
            for (Map.Entry entry : uniqueFluids.entrySet()) {
                ((FluidStored)entry.getKey()).setMillilitres(((Float)entry.getValue()).floatValue());
                room.fluidsStored.add((FluidStored)entry.getKey());
            }
            room.clothingRemovedForMilking = new HashMap<String, List<AbstractClothing>>();
            NodeList clothingStoredElements = parentElement.getElementsByTagName("clothingRemovedForMilking");
            if (clothingStoredElements.item(0) != null) {
                Element element = (Element)clothingStoredElements.item(0);
                NodeList savedCharacters = element.getElementsByTagName("clothingCharacter");
                for (int i = 0; i < savedCharacters.getLength(); ++i) {
                    Element characterElement = (Element)savedCharacters.item(i);
                    String id = characterElement.getAttribute("id");
                    ArrayList<AbstractClothing> clothingLoaded = new ArrayList<AbstractClothing>();
                    NodeList clothingElement = characterElement.getElementsByTagName("clothing");
                    for (int j = 0; j < clothingElement.getLength(); ++j) {
                        clothingLoaded.add(AbstractClothing.loadFromXML((Element)clothingElement.item(j), doc));
                    }
                    room.clothingRemovedForMilking.put(id, clothingLoaded);
                }
            }
            return room;
        }
        catch (Exception ex) {
            System.err.println("Warning: MilkingRoom failed to import!");
            return null;
        }
    }

    public static Cell getMilkingCell(GameCharacter character, boolean needFreeCell) {
        ArrayList<MilkingRoom> freeRooms = new ArrayList<MilkingRoom>();
        ArrayList<MilkingRoom> fullRooms = new ArrayList<MilkingRoom>();
        ArrayList<Cell> milkingCells = new ArrayList<Cell>();
        for (MilkingRoom room : Main.game.getOccupancyUtil().getMilkingRooms()) {
            Cell c = Main.game.getWorlds().get(room.getWorldType()).getCell(room.getLocation());
            int charactersPresent = 0;
            for (GameCharacter gameCharacter : Main.game.getCharactersPresent(c)) {
                if (!gameCharacter.isSlave() || gameCharacter.getSlaveJob(Main.game.getHourOfDay()) != SlaveJob.MILKING || gameCharacter == character) continue;
                ++charactersPresent;
            }
            if (charactersPresent < 8) {
                freeRooms.add(room);
                continue;
            }
            fullRooms.add(room);
        }
        if (freeRooms.isEmpty() && needFreeCell) {
            return null;
        }
        ArrayList<Cell> suitableCells = new ArrayList<Cell>();
        for (MilkingRoom room : freeRooms) {
            Cell c = Main.game.getWorlds().get(room.getWorldType()).getCell(room.getLocation());
            if (character.hasSlaveJobSetting(SlaveJob.MILKING, SlaveJobSetting.MILKING_INDUSTRIAL) && c.getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM_INDUSTRIAL_MILKERS)) {
                suitableCells.add(c);
                continue;
            }
            if (character.hasSlaveJobSetting(SlaveJob.MILKING, SlaveJobSetting.MILKING_ARTISAN) && c.getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM_ARTISAN_MILKERS)) {
                suitableCells.add(c);
                continue;
            }
            if (character.hasSlaveJobSetting(SlaveJob.MILKING, SlaveJobSetting.MILKING_REGULAR) && !c.getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM_ARTISAN_MILKERS) && !c.getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM_INDUSTRIAL_MILKERS)) {
                suitableCells.add(c);
                continue;
            }
            milkingCells.add(c);
        }
        if (!suitableCells.isEmpty()) {
            if (suitableCells.contains(character.getCell())) {
                return character.getCell();
            }
            return (Cell)suitableCells.get(0);
        }
        for (MilkingRoom room : fullRooms) {
            Cell c = Main.game.getWorlds().get(room.getWorldType()).getCell(room.getLocation());
            milkingCells.add(c);
        }
        if (milkingCells.isEmpty()) {
            return null;
        }
        for (Cell c : milkingCells) {
            int charactersPresent = Main.game.getCharactersPresent(c).size();
            if (charactersPresent < 8) {
                return c;
            }
            if (!(character.hasSlaveJobSetting(SlaveJob.MILKING, SlaveJobSetting.MILKING_INDUSTRIAL) && c.getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM_INDUSTRIAL_MILKERS) ? !needFreeCell && charactersPresent == 8 : (character.hasSlaveJobSetting(SlaveJob.MILKING, SlaveJobSetting.MILKING_ARTISAN) && c.getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM_ARTISAN_MILKERS) ? !needFreeCell && charactersPresent == 8 : character.hasSlaveJobSetting(SlaveJob.MILKING, SlaveJobSetting.MILKING_REGULAR) && !c.getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM_ARTISAN_MILKERS) && !c.getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM_INDUSTRIAL_MILKERS) && !needFreeCell && charactersPresent == 8))) continue;
            return c;
        }
        return (Cell)milkingCells.get(0);
    }

    public static int getMaximumMilkPerHour(GameCharacter character) {
        Cell c = character.getCell();
        int milked = 2500;
        if (c == null) {
            return milked;
        }
        if (c.getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM_ARTISAN_MILKERS)) {
            milked = 2000;
        } else if (c.getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM_INDUSTRIAL_MILKERS)) {
            milked = 5000;
        }
        if (c.getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM_MILK_EFFICIENCY)) {
            milked *= 2;
        }
        return milked;
    }

    public static int getActualMilkPerHour(GameCharacter character) {
        if (character.getBreastRawMilkStorageValue() == 0) {
            return 0;
        }
        return (int)Math.min((float)MilkingRoom.getMaximumMilkPerHour(character), character.getLactationRegenerationPerSecond(true) * 60.0f * 60.0f);
    }

    public static int getActualCrotchMilkPerHour(GameCharacter character) {
        if (!character.hasBreastsCrotch() || character.getBreastCrotchRawMilkStorageValue() == 0) {
            return 0;
        }
        return (int)Math.min((float)MilkingRoom.getMaximumMilkPerHour(character), character.getCrotchLactationRegenerationPerSecond(true) * 60.0f * 60.0f);
    }

    public static int getMaximumCumPerHour(GameCharacter character) {
        Cell c = MilkingRoom.getMilkingCell(character, false);
        int milked = 250;
        if (c == null) {
            return milked;
        }
        if (c.getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM_ARTISAN_MILKERS)) {
            milked = 200;
        } else if (c.getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM_INDUSTRIAL_MILKERS)) {
            milked = 500;
        }
        if (c.getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM_CUM_EFFICIENCY)) {
            milked *= 2;
        }
        return milked;
    }

    public static int getActualCumPerHour(GameCharacter character) {
        if (!character.hasPenisIgnoreDildo()) {
            return 0;
        }
        return (int)Math.min((float)MilkingRoom.getMaximumCumPerHour(character), character.getCumRegenerationPerSecond() * 60.0f * 60.0f);
    }

    public static int getMaximumGirlcumPerHour(GameCharacter character) {
        Cell c = MilkingRoom.getMilkingCell(character, false);
        int milked = 50;
        if (c == null) {
            return milked;
        }
        if (c.getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM_ARTISAN_MILKERS)) {
            milked = 40;
        } else if (c.getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM_INDUSTRIAL_MILKERS)) {
            milked = 100;
        }
        if (c.getPlace().getPlaceUpgrades().contains(PlaceUpgrade.LILAYA_MILKING_ROOM_GIRLCUM_EFFICIENCY)) {
            milked *= 2;
        }
        return milked;
    }

    public static int getActualGirlcumPerHour(GameCharacter character) {
        if (!character.hasVagina()) {
            return 0;
        }
        int orgasmsPerHour = 10;
        return Math.min(MilkingRoom.getMaximumGirlcumPerHour(character), orgasmsPerHour * character.getVaginaWetness().getValue() * (character.isVaginaSquirter() ? 5 : 1));
    }

    public AbstractWorldType getWorldType() {
        return this.worldType;
    }

    public Vector2i getLocation() {
        return this.location;
    }

    public List<FluidStored> getFluidsStored() {
        return this.fluidsStored;
    }

    public List<FluidStored> getMilkFluidsStored() {
        ArrayList<FluidStored> milkFluids = new ArrayList<FluidStored>(this.fluidsStored);
        milkFluids.removeIf(fluid -> !fluid.isMilk());
        return milkFluids;
    }

    public List<FluidStored> getCumFluidsStored() {
        ArrayList<FluidStored> cumFluids = new ArrayList<FluidStored>(this.fluidsStored);
        cumFluids.removeIf(fluid -> !fluid.isCum());
        return cumFluids;
    }

    public List<FluidStored> getGirlcumFluidsStored() {
        ArrayList<FluidStored> girlcumFluids = new ArrayList<FluidStored>(this.fluidsStored);
        girlcumFluids.removeIf(fluid -> !fluid.isGirlCum());
        return girlcumFluids;
    }

    public void incrementFluidStored(FluidStored fluid, float millilitres) {
        boolean fluidIncremented = false;
        for (FluidStored f : this.getFluidsStored()) {
            if (!fluid.equals(f)) continue;
            f.incrementMillilitres(millilitres);
            fluidIncremented = true;
            break;
        }
        if (!fluidIncremented) {
            this.getFluidsStored().add(fluid);
        }
        this.getFluidsStored().removeIf(fs -> fs.getMillilitres() <= 0.0f);
    }

    public Map<String, List<AbstractClothing>> getClothingRemovedForMilking() {
        return this.clothingRemovedForMilking;
    }

    public void addClothingRemovedForMilking(GameCharacter character, AbstractClothing clothing) {
        this.clothingRemovedForMilking.putIfAbsent(character.getId(), new ArrayList());
        this.clothingRemovedForMilking.get(character.getId()).add(clothing);
    }

    public void clearClothingRemovedForMilking(GameCharacter character) {
        this.clothingRemovedForMilking.remove(character.getId());
    }

    public String getRoomDescription() {
        StringBuilder milkyMilknessSB = new StringBuilder();
        milkyMilknessSB.append(this.getFluidEntries(this.getMilkFluidsStored(), PresetColour.MILK, "\u4e73\u6c41\u5df2\u50a8\u5b58"));
        milkyMilknessSB.append(this.getFluidEntries(this.getCumFluidsStored(), PresetColour.CUM, "\u7cbe\u6db2\u5df2\u50a8\u5b58"));
        milkyMilknessSB.append(this.getFluidEntries(this.getGirlcumFluidsStored(), PresetColour.GIRLCUM, "\u59b9\u6c41\u5df2\u50a8\u5b58"));
        return milkyMilknessSB.toString();
    }

    private String getFluidEntries(List<FluidStored> fluids, Colour colour, String title) {
        StringBuilder milkyMilknessSB = new StringBuilder();
        boolean fluidsFound = false;
        milkyMilknessSB.append("<div class='container-full-width' style='margin-bottom:2px; text-align:center;'><b style='color:" + colour.toWebHexString() + ";'>" + title + "</b>");
        for (FluidStored fluid : fluids) {
            String idModifier = "";
            AbstractFluidType type = null;
            if (fluid.isMilk()) {
                idModifier = "MILK";
                type = ((FluidMilk)fluid.getFluid()).getType();
            } else if (fluid.isCum()) {
                idModifier = "CUM";
                type = ((FluidCum)fluid.getFluid()).getType();
            } else if (fluid.isGirlCum()) {
                idModifier = "GIRLCUM";
                type = ((FluidGirlCum)fluid.getFluid()).getType();
            }
            fluidsFound = true;
            milkyMilknessSB.append("<div class='container-full-width' style='margin-top:2px; background:" + PresetColour.BACKGROUND_ALT.toWebHexString() + ";'>");
            milkyMilknessSB.append("<div class='container-half-width' style='margin:0; padding:2px; width:15%; background:transparent;'>[style.colourExcellent(" + Units.fluid(fluid.getMillilitres()) + ")]");
            if (fluid.isCum()) {
                milkyMilknessSB.append("<br/><span style='color:" + Attribute.VIRILITY.getColour().toWebHexString() + ";'>\u751f\u6b96\u529b:</span> " + Units.adaptiveRound(fluid.getVirility()));
            }
            milkyMilknessSB.append("</div>");
            milkyMilknessSB.append("<div class='container-half-width' style='margin:0; padding:2px; width:25%; background:transparent;'>");
            GameCharacter fluidOwner = null;
            try {
                fluidOwner = fluid.getFluidCharacter();
                milkyMilknessSB.append(UtilText.parse(fluidOwner, "<span style='color:" + fluidOwner.getFemininity().getColour().toWebHexString() + ";'>[npc.NamePos]\u7684</span>", new ParserTag[0]));
            }
            catch (Exception ex) {
                milkyMilknessSB.append("[style.colourDisabled(\u67d0\u4eba\u7684)]");
            }
            milkyMilknessSB.append("<br/><span style='color:" + type.getRace().getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(type.getRace().getName(fluid.isFeral())) + type.getBaseType().getNames().get(0) + "</span></div>");
            milkyMilknessSB.append("<div class='container-half-width' style='margin:0; padding:2px; width:35%; background:transparent;'>");
            FluidFlavour flavour = fluid.getFluid().getFlavour();
            milkyMilknessSB.append("<span style='color:" + flavour.getColour().toWebHexString() + ";'>" + Util.capitaliseSentence(flavour.getName()) + (flavour == FluidFlavour.FLAVOURLESS ? "" : "\u53e3\u5473") + "</span>\u3002<br/>");
            if (!fluid.getFluid().getFluidModifiers().isEmpty()) {
                int i = 0;
                for (FluidModifier mod : fluid.getFluid().getFluidModifiers()) {
                    if (i > 0) {
                        milkyMilknessSB.append("\uff0c");
                    }
                    milkyMilknessSB.append(Util.capitaliseSentence(mod.getName()));
                    ++i;
                }
                milkyMilknessSB.append("\u3002");
            } else {
                milkyMilknessSB.append("[style.colourDisabled(\u65e0\u4fee\u9970)]");
            }
            milkyMilknessSB.append("</div>");
            milkyMilknessSB.append("<div class='container-half-width' style='margin:0; padding:2px; width:10%; background:transparent;'>" + UtilText.formatAsMoney((int)(fluid.getMillilitres() * fluid.getFluid().getValuePerMl()), "span") + "</div>");
            milkyMilknessSB.append("<div style='float:left; width:15%; margin:0 auto; padding:0; display:inline-block; text-align:center; background:transparent;'><div id='" + idModifier + "_" + String.valueOf((Object)CoverableArea.MOUTH) + "_" + fluid.hashCode() + "' " + (this.isAbleToIngestThroughArea(fluid.getFluid().getType().getBaseType(), MilkingRoom.getTargetedCharacter(), CoverableArea.MOUTH, fluid.getMillilitres()) ? "class='square-button big'" : "class='square-button big disabled'") + "><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaMouth() + "</div></div>");
            milkyMilknessSB.append("<div id='" + idModifier + "_" + String.valueOf((Object)CoverableArea.VAGINA) + "_" + fluid.hashCode() + "' " + (this.isAbleToIngestThroughArea(fluid.getFluid().getType().getBaseType(), MilkingRoom.getTargetedCharacter(), CoverableArea.VAGINA, fluid.getMillilitres()) ? "class='square-button big'" : "class='square-button big disabled'") + "><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaVagina() + "</div></div>");
            milkyMilknessSB.append("<div id='" + idModifier + "_" + String.valueOf((Object)CoverableArea.ANUS) + "_" + fluid.hashCode() + "' " + (this.isAbleToIngestThroughArea(fluid.getFluid().getType().getBaseType(), MilkingRoom.getTargetedCharacter(), CoverableArea.ANUS, fluid.getMillilitres()) ? "class='square-button big'" : "class='square-button big disabled'") + "><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getCoverableAreaAnus() + "</div></div>");
            milkyMilknessSB.append("<div id='" + idModifier + "_SELL_" + fluid.hashCode() + "' class='square-button big'><div class='square-button-content'>" + SVGImages.SVG_IMAGE_PROVIDER.getTransactionSell() + "</div></div>");
            milkyMilknessSB.append("</div>");
            milkyMilknessSB.append("</div>");
        }
        if (!fluidsFound) {
            milkyMilknessSB.append("<div class='container-full-width' style='margin-bottom:2px; text-align:center; background:" + PresetColour.BACKGROUND_ALT.toWebHexString() + ";'>[style.colourDisabled(\u65e0\u2026\u2026)]</div>");
        }
        milkyMilknessSB.append("</div>");
        return milkyMilknessSB.toString();
    }

    public boolean isAbleToIngestThroughArea(FluidTypeBase fluidType, GameCharacter ingestingCharacter, CoverableArea area, float millilitres) {
        return this.getAreaIngestionBlockedDescription(fluidType, ingestingCharacter, area, millilitres).isEmpty();
    }

    public String getAreaIngestionBlockedDescription(FluidTypeBase fluidType, GameCharacter ingestingCharacter, CoverableArea area, float millilitres) {
        StringBuilder sb = new StringBuilder();
        if (millilitres < 5.0f) {
            sb.append("\u81f3\u5c11\u9700\u8981" + Units.fluid(5.0) + "\u6db2\u4f53\u624d\u80fd\u8ba9[npc.name]\u6444\u5165\uff01<br/>");
        }
        switch (area) {
            case ANUS: {
                if (ingestingCharacter.isAbleToAccessCoverableArea(CoverableArea.ANUS, true)) break;
                sb.append("[npc.NameIsFull]\u65e0\u6cd5\u4f7f\u7528[npc.her]\u7684\u540e\u7a74\uff01");
                break;
            }
            case MOUTH: {
                if (ingestingCharacter.isAbleToAccessCoverableArea(CoverableArea.MOUTH, true)) break;
                sb.append("[npc.NameIsFull]\u65e0\u6cd5\u4f7f\u7528[npc.her]\u7684\u5634\u5df4\uff01");
                break;
            }
            case VAGINA: {
                if (!ingestingCharacter.hasVagina()) {
                    sb.append("[npc.Name]\u6ca1\u6709\u9634\u9053\uff01");
                    break;
                }
                if (ingestingCharacter.isAbleToAccessCoverableArea(CoverableArea.VAGINA, true)) break;
                sb.append("[npc.NameIsFull]\u65e0\u6cd5\u4f7f\u7528[npc.her]\u7684\u5c0f\u7a74\uff01");
                break;
            }
        }
        if (sb.length() > 0) {
            return UtilText.parse(ingestingCharacter, sb.toString(), new ParserTag[0]);
        }
        if (!ingestingCharacter.isPlayer() && !ingestingCharacter.isSlave()) {
            if (ingestingCharacter.getAffection(Main.game.getPlayer()) < (float)AffectionLevel.POSITIVE_FOUR_LOVE.getMinimumValue()) {
                sb.append(UtilText.parse(ingestingCharacter, "[npc.name]\u4e0d\u662f\u4f60\u7684\u5974\u96b6\uff0c [npc.sheIs]\u53ea\u6709\u5728<span style='color:" + AffectionLevel.POSITIVE_FOUR_LOVE.getColour().toWebHexString() + ";'>" + AffectionLevel.POSITIVE_FOUR_LOVE.getDescriptor() + "</span>\u4f60\u65f6\u624d\u4f1a\u540c\u610f\u3002<br/>", new ParserTag[0]));
            } else if (fluidType == FluidTypeBase.CUM && (area == CoverableArea.VAGINA ? !ingestingCharacter.getFetishDesire(Fetish.FETISH_PREGNANCY).isPositive() : !ingestingCharacter.getFetishDesire(Fetish.FETISH_CUM_ADDICT).isPositive())) {
                sb.append(UtilText.parse(ingestingCharacter, area == CoverableArea.VAGINA ? "[npc.Name]\u9700\u8981\u5bf9" + Fetish.FETISH_PREGNANCY.getName(ingestingCharacter) + "\u6027\u7656\u6709\u6b63\u5411\u6e34\u671b\u503c\u3002<br/>" : "[npc.Name]\u9700\u8981\u5bf9" + Fetish.FETISH_CUM_ADDICT.getName(ingestingCharacter) + "\u6027\u7656\u6709\u6b63\u5411\u6e34\u671b\u503c\u3002<br/>", new ParserTag[0]));
            } else if (fluidType == FluidTypeBase.MILK && !ingestingCharacter.getFetishDesire(Fetish.FETISH_LACTATION_OTHERS).isPositive()) {
                sb.append(UtilText.parse(ingestingCharacter, "[npc.Name]\u9700\u8981\u5bf9" + Fetish.FETISH_LACTATION_OTHERS.getName(ingestingCharacter) + "\u6027\u7656\u6709\u6b63\u5411\u6e34\u671b\u503c\u3002<br/>", new ParserTag[0]));
            } else if (fluidType == FluidTypeBase.GIRLCUM && !ingestingCharacter.getFetishDesire(Fetish.FETISH_VAGINAL_GIVING).isPositive()) {
                sb.append(UtilText.parse(ingestingCharacter, "[npc.Name]\u9700\u8981\u5bf9" + Fetish.FETISH_VAGINAL_GIVING.getName(ingestingCharacter) + "\u6027\u7656\u6709\u6b63\u5411\u6e34\u671b\u503c\u3002<br/>", new ParserTag[0]));
            }
            switch (area) {
                case ANUS: {
                    if (ingestingCharacter.getFetishDesire(Fetish.FETISH_ANAL_RECEIVING).isPositive()) break;
                    sb.append(UtilText.parse(ingestingCharacter, "[npc.Name]\u9700\u8981\u5bf9" + Fetish.FETISH_ANAL_RECEIVING.getName(ingestingCharacter) + "\u6027\u7656\u6709\u6b63\u5411\u6e34\u671b\u503c\u3002", new ParserTag[0]));
                    break;
                }
                case VAGINA: {
                    if (ingestingCharacter.getFetishDesire(Fetish.FETISH_VAGINAL_RECEIVING).isPositive()) break;
                    sb.append(UtilText.parse(ingestingCharacter, "[npc.Name]\u9700\u8981\u5bf9" + Fetish.FETISH_VAGINAL_RECEIVING.getName(ingestingCharacter) + "\u6027\u7656\u6709\u975e\u8d1f\u6e34\u671b\u503c\u3002", new ParserTag[0]));
                    break;
                }
            }
        }
        return sb.toString();
    }

    public static GameCharacter getTargetedCharacter() {
        if (targetedCharacter == null || !targetedCharacter.isPlayer() && !Main.game.getCharactersPresent().contains(targetedCharacter)) {
            targetedCharacter = Main.game.getPlayer();
        }
        return targetedCharacter;
    }

    public static void setTargetedCharacter(GameCharacter targetedCharacter) {
        MilkingRoom.targetedCharacter = targetedCharacter;
    }
}

