/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.rendering;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;

public class CachedImage {
    protected String imageString = "";
    protected int width = 200;
    protected int height = 200;
    protected int percentageWidth = 35;

    public boolean load(File f) {
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            BufferedImage image = ImageIO.read(f);
            this.updatePercentageWidth(image);
            int[] targetSize = this.getAdjustedSize(600, 600);
            image = CachedImage.scaleDown(image, targetSize[0], targetSize[1]);
            this.width = image.getWidth();
            this.height = image.getHeight();
            ImageIO.setUseCache(false);
            ImageIO.write((RenderedImage)image, "PNG", byteStream);
            this.imageString = "data:image/png;base64," + Base64.getEncoder().encodeToString(byteStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    void updatePercentageWidth(BufferedImage image) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        if (this.height == this.width) {
            this.percentageWidth = 45;
        } else if (this.height < this.width) {
            this.percentageWidth = 65;
        }
    }

    public String getImageString() {
        return this.imageString;
    }

    public String getThumbnailString() {
        return this.imageString;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPercentageWidth() {
        return this.percentageWidth;
    }

    public int[] getAdjustedSize(int maxWidth, int maxHeight) {
        float widthRatio = (float)maxWidth / (float)this.width;
        float heightRatio = (float)maxHeight / (float)this.height;
        float scale = Math.min(widthRatio, heightRatio);
        return new int[]{(int)((float)this.width * scale), (int)((float)this.height * scale)};
    }

    static BufferedImage scaleDown(BufferedImage original, int targetWidth, int targetHeight) {
        int width = original.getWidth();
        int height = original.getHeight();
        BufferedImage rv = original;
        while (width > targetWidth || height > targetHeight) {
            if (width > targetWidth) {
                width = Math.max(width / 2, targetWidth);
            }
            if (height > targetHeight) {
                height = Math.max(height / 2, targetHeight);
            }
            BufferedImage step = new BufferedImage(width, height, 2);
            Graphics2D canvas = step.createGraphics();
            canvas.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            canvas.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            canvas.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            canvas.drawImage(original, 0, 0, width, height, null);
            canvas.dispose();
            rv = step;
        }
        return rv;
    }
}

