/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.rendering;

import com.lilithsthrone.rendering.CachedGif;
import com.lilithsthrone.rendering.CachedImage;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

public enum ImageCache {
    INSTANCE;

    protected Map<File, CachedImage> cache = Collections.synchronizedMap(new LinkedHashMap<File, CachedImage>(16, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<File, CachedImage> eldest) {
            if (this.size() <= 8) {
                return false;
            }
            long byteSize = this.size() * 500 * 1024;
            if (byteSize > Runtime.getRuntime().maxMemory() / 10L) {
                return true;
            }
            long adjustSize = (byteSize - Runtime.getRuntime().freeMemory()) / 512000L;
            if (adjustSize > 0L) {
                int i = 0;
                while ((long)i < adjustSize) {
                    this.remove(this.keySet().iterator().next());
                    ++i;
                }
            }
            return false;
        }
    });
    protected LinkedBlockingQueue<File> queue = new LinkedBlockingQueue();
    protected Thread loaderThread = new Thread(() -> {
        while (!Thread.currentThread().isInterrupted()) {
            File f;
            try {
                f = this.queue.take();
            }
            catch (InterruptedException e) {
                break;
            }
            this.getImage(f);
        }
    });

    private ImageCache() {
        this.loaderThread.setDaemon(true);
        this.loaderThread.start();
    }

    public void requestCache(File f) {
        if (this.cache.get(f) == null && !this.queue.contains(f)) {
            this.queue.offer(f);
        }
    }

    public CachedImage requestImage(File f) {
        if (f == null) {
            return null;
        }
        CachedImage image = this.cache.get(f);
        if (image == null) {
            this.requestCache(f);
        }
        return image;
    }

    public CachedImage getImage(File f) {
        if (f == null) {
            return null;
        }
        CachedImage image = this.cache.get(f);
        if (image == null) {
            CachedImage cachedImage = image = f.getName().endsWith(".gif") ? new CachedGif() : new CachedImage();
            if (image.load(f)) {
                this.cache.put(f, image);
            } else {
                return null;
            }
        }
        return image;
    }
}

