/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.utils;

import java.util.ArrayList;
import java.util.List;

public class TreeNode<T> {
    private T data;
    private TreeNode<T> parent;
    private List<TreeNode<T>> children;

    public TreeNode(T data) {
        this.data = data;
        this.children = new ArrayList<TreeNode<T>>();
    }

    public T getData() {
        return this.data;
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public List<TreeNode<T>> getChildren() {
        return this.children;
    }

    public void addChild(TreeNode<T> child) {
        this.children.add(child);
        child.parent = this;
    }

    public boolean childrenContainsData(T data) {
        for (TreeNode<T> node : this.children) {
            if (!node.childrenContainsData(data)) continue;
            return true;
        }
        return this.data.equals(data);
    }

    public TreeNode<T> getFirstNodeWithData(T data) {
        if (this.getData().equals(data)) {
            return this;
        }
        for (TreeNode<T> node : this.children) {
            TreeNode<T> returnedNode = node.getFirstNodeWithData(data);
            if (returnedNode == null) continue;
            return returnedNode;
        }
        return null;
    }
}

