/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.utils;

import com.lilithsthrone.game.PropertyValue;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public enum Units {
    FORMATTER;

    public final int MIN_PRECISION = 0;
    public final int MAX_PRECISION = 2;
    public final List<String> imperialCountries = Arrays.asList("US", "LR", "MM");
    public final List<String> twelveHourCountries = Arrays.asList("US", "UK", "PH", "CA", "AU", "NZ", "IN", "EG", "SA", "CO", "PK", "MY", "SG", "ZA");
    DateTimeFormatter shortDate;
    DateTimeFormatter longDate;
    DateTimeFormatter time;
    NumberFormat number;
    Locale defaultLocale = Locale.getDefault();
    public static final String INCH_SYMBOL = "&quot;";
    public static final String FOOT_SYMBOL = "&#39;";
    private static final String[] suffixes;

    private Units() {
        if (Main.getProperties() == null) {
            new NullPointerException("Unit formatters initialized before properties. Assuming auto locale.").printStackTrace();
            this.updateFormats(true);
        } else {
            this.updateSettings();
            this.updateFormats(Main.getProperties().hasValue(PropertyValue.autoLocale));
        }
    }

    public void updateSettings() {
        if (Main.getProperties().hasValue(PropertyValue.autoLocale)) {
            String countryCode = this.defaultLocale.getCountry().toUpperCase();
            boolean isMetric = !this.imperialCountries.contains(countryCode);
            Main.getProperties().setValue(PropertyValue.metricSizes, isMetric);
            Main.getProperties().setValue(PropertyValue.metricFluids, isMetric);
            Main.getProperties().setValue(PropertyValue.metricWeights, isMetric);
            Main.getProperties().setValue(PropertyValue.twentyFourHourTime, !this.twelveHourCountries.contains(countryCode));
            Main.getProperties().setValue(PropertyValue.internationalDate, isMetric);
        }
    }

    public void updateDateFormat(boolean autoLocale) {
        Locale.setDefault(autoLocale ? this.defaultLocale : Locale.CHINESE);
        this.shortDate = (autoLocale ? DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT) : DateTimeFormatter.ofPattern(Main.getProperties().hasValue(PropertyValue.internationalDate) ? "yy.MM.dd" : "yy.MM.dd")).withZone(ZoneId.systemDefault());
        this.longDate = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5").withZone(ZoneId.systemDefault());
    }

    public void updateTimeFormat(boolean autoLocale) {
        this.time = (autoLocale ? DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT) : DateTimeFormatter.ofPattern(Main.getProperties().hasValue(PropertyValue.twentyFourHourTime) ? "HH:mm" : "hh:mm a").withLocale(Locale.ENGLISH)).withZone(ZoneId.systemDefault());
    }

    public void updateNumberFormat(boolean autoLocale) {
        this.number = NumberFormat.getNumberInstance(autoLocale ? Locale.getDefault() : Locale.CHINESE);
        this.number.setRoundingMode(RoundingMode.HALF_UP);
        this.number.setMinimumFractionDigits(0);
        this.number.setMaximumFractionDigits(2);
    }

    public void updateFormats(boolean autoLocale) {
        this.updateDateFormat(autoLocale);
        this.updateTimeFormat(autoLocale);
        this.updateNumberFormat(autoLocale);
    }

    public static String number(double amount) {
        return Units.FORMATTER.number.format(amount);
    }

    public static String number(long amount) {
        return Units.FORMATTER.number.format(amount);
    }

    public static String number(double amount, int minPrecision, int maxPrecision) {
        NumberFormat formatter = Units.FORMATTER.number;
        formatter.setMinimumFractionDigits(minPrecision);
        formatter.setMaximumFractionDigits(maxPrecision);
        String output = formatter.format(amount);
        formatter.setMinimumFractionDigits(Units.FORMATTER.MIN_PRECISION);
        formatter.setMaximumFractionDigits(Units.FORMATTER.MAX_PRECISION);
        return output;
    }

    public static String dateTime(TemporalAccessor timePoint) {
        return Units.dateTime(timePoint, DateType.SHORT);
    }

    public static String dateTime(TemporalAccessor timePoint, DateType type) {
        return Units.date(timePoint, type) + ", " + Units.time(timePoint);
    }

    public static String date(TemporalAccessor timePoint) {
        return Units.date(timePoint, DateType.SHORT);
    }

    public static String date(TemporalAccessor timePoint, DateType type) {
        if (type == DateType.SHORT) {
            return Units.FORMATTER.shortDate.format(timePoint);
        }
        return Units.FORMATTER.longDate.format(timePoint).replaceFirst("%o", Units.getOrdinal(timePoint.get(ChronoField.DAY_OF_MONTH))).replaceFirst("%m", Units.getMonthName(timePoint.get(ChronoField.MONTH_OF_YEAR)));
    }

    public static String time(TemporalAccessor timePoint) {
        return Units.FORMATTER.time.format(timePoint);
    }

    public static String size(double cm) {
        return Units.size(cm, ValueType.NUMERIC, UnitType.SHORT);
    }

    public static String size(double cm, UnitType uType) {
        return Units.size(cm, ValueType.NUMERIC, uType);
    }

    public static String size(double cm, ValueType vType, UnitType uType) {
        if (Main.getProperties().hasValue(PropertyValue.metricSizes)) {
            return Units.sizeAsMetric(cm, vType, uType);
        }
        return Units.sizeAsImperial(cm, vType, uType);
    }

    public static String sizeAsImperial(double cm, ValueType vType, UnitType uType) {
        double inches = cm / 2.54;
        double roundingFactor = vType == ValueType.PRECISE || Math.abs(inches) < 1.0 ? 0.25 : 1.0;
        long feet = (long)(Units.roundTo(inches, roundingFactor) / 12.0f);
        double remainingInches = Units.roundTo(inches, roundingFactor) % 12.0f;
        StringBuilder output = new StringBuilder();
        boolean both = uType != UnitType.NONE && vType != ValueType.TEXT && feet != 0L && remainingInches != 0.0;
        boolean wrap = vType == ValueType.TEXT && Math.abs(inches) >= 11.5 || both || feet != 0L && remainingInches == 0.0;
        double usedValue = wrap ? (double)feet : inches;
        output.append(Units.value(usedValue, vType, true));
        switch (uType) {
            case NONE: {
                break;
            }
            case SHORT: {
                output.append(wrap ? FOOT_SYMBOL : INCH_SYMBOL);
                break;
            }
            case LONG: {
                if (Math.floor(inches) == 0.0 && vType != ValueType.PRECISE) {
                    output.setLength(0);
                    return output.append("\u4e0d\u8db3").append(vType == ValueType.TEXT ? "\u4e00" : "1").append("\u82f1\u5bf8").toString();
                }
                if (Math.abs(usedValue) >= 1.0 + roundingFactor / 2.0 || usedValue == 0.0) {
                    output.append(wrap ? "\u82f1\u5c3a" : "\u82f1\u5bf8");
                    break;
                }
                output.append(wrap ? "\u82f1\u5c3a" : "\u82f1\u5bf8");
                break;
            }
            case LONG_SINGULAR: {
                output.append(wrap ? "\u82f1\u5c3a" : "\u82f1\u5bf8");
            }
        }
        if (both) {
            if (uType == UnitType.LONG) {
                output.append("");
            }
            if (uType == UnitType.LONG_SINGULAR) {
                output.append("-");
            }
            remainingInches = Math.abs(Units.roundTo(remainingInches, roundingFactor));
            output.append(Units.value(remainingInches, vType, true));
            switch (uType) {
                case SHORT: {
                    output.append(INCH_SYMBOL);
                    break;
                }
                case LONG: {
                    output.append(remainingInches >= 1.0 + roundingFactor / 2.0 ? "\u82f1\u5bf8" : "\u82f1\u5bf8");
                    break;
                }
            }
        }
        return output.toString();
    }

    public static String sizeAsMetric(double cm, ValueType vType, UnitType uType) {
        double m = cm / 100.0;
        return Units.valueWithUnit(cm, "cm", "\u5398\u7c73", m, "m", "\u7c73", vType, uType, false);
    }

    public static String fluid(double ml) {
        return Units.fluid(ml, ValueType.NUMERIC, UnitType.SHORT);
    }

    public static String fluid(double ml, UnitType uType) {
        return Units.fluid(ml, ValueType.NUMERIC, uType);
    }

    public static String fluid(double ml, ValueType vType) {
        return Units.fluid(ml, vType, UnitType.SHORT);
    }

    public static String fluid(double ml, ValueType vType, UnitType uType) {
        if (Main.getProperties().hasValue(PropertyValue.metricFluids)) {
            return Units.fluidAsMetric(ml, vType, uType);
        }
        return Units.fluidAsImperial(ml, vType, uType);
    }

    public static float mlToOz(float ml) {
        return (float)((double)ml / 28.4131);
    }

    public static String fluidAsImperial(double ml, ValueType vType, UnitType uType) {
        double oz = ml / 28.4131;
        double gal = oz / 160.0;
        return Units.valueWithUnit(oz, "oz", "\u76ce\u53f8", gal, "gal", "\u52a0\u4ed1", vType, uType, true);
    }

    public static String fluidAsMetric(double ml, ValueType vType, UnitType uType) {
        double l = ml / 1000.0;
        return Units.valueWithUnit(ml, "mL", "\u6beb\u5347", l, "L", "\u5347", vType, uType, false);
    }

    public static String weight(double grams) {
        return Units.weight(grams, ValueType.NUMERIC, UnitType.SHORT);
    }

    public static String weight(double grams, UnitType uType) {
        return Units.weight(grams, ValueType.NUMERIC, uType);
    }

    public static String weight(double grams, ValueType vType, UnitType uType) {
        if (Main.getProperties().hasValue(PropertyValue.metricWeights)) {
            return Units.weightAsMetric(grams, vType, uType);
        }
        return Units.weightAsImperial(grams, vType, uType);
    }

    public static String weightAsImperial(double grams, ValueType vType, UnitType uType) {
        double oz = grams / 28.34952;
        double lb = oz / 16.0;
        return Units.valueWithUnit(oz, "oz", "\u76ce\u53f8", lb, "lb", "\u78c5", vType, uType, true);
    }

    public static String weightAsMetric(double grams, ValueType vType, UnitType uType) {
        double kg = grams / 1000.0;
        return Units.valueWithUnit(grams, "g", "\u514b", kg, "kg", "\u5343\u514b", vType, uType, false);
    }

    private static String value(double value, ValueType vType, boolean useQuarters) {
        switch (vType) {
            case PRECISE: {
                if (useQuarters) {
                    return Units.withQuarters(value);
                }
                return Units.number(value);
            }
            case TEXT: {
                return Util.intToString((int)Units.aggressiveRound(value));
            }
        }
        if (useQuarters) {
            return Math.abs(value) < 0.875 ? Units.withQuarters(value) : Units.number(Math.round(value));
        }
        return Units.number(Units.adaptiveRound(value));
    }

    private static String valueWithUnit(double value, String shortUnit, String unit, double wrappedValue, String shortWrappedUnit, String wrappedUnit, ValueType vType, UnitType uType, boolean useQuarters) {
        double usedValue;
        StringBuilder output = new StringBuilder();
        boolean wrap = Math.abs(wrappedValue) >= 1.0 && vType != ValueType.PRECISE;
        double d = usedValue = wrap ? wrappedValue : value;
        if (useQuarters) {
            usedValue = Units.roundTo(usedValue, 0.25);
        }
        if (value > 0.0 && usedValue == 0.0) {
            output.append("&lt;");
            usedValue = 0.25;
        }
        output.append(Units.value(usedValue, wrap && vType == ValueType.NUMERIC ? ValueType.PRECISE : vType, useQuarters));
        switch (uType) {
            case NONE: {
                break;
            }
            case SHORT: {
                output.append(wrap ? shortWrappedUnit : shortUnit);
                break;
            }
            case LONG: {
                if (Math.floor(value) == 0.0 && vType != ValueType.PRECISE) {
                    output.setLength(0);
                    return output.append("\u4e0d\u8db3").append(vType == ValueType.TEXT ? "\u4e00" : "1").append(unit).toString();
                }
                output.append(wrap ? wrappedUnit : unit);
                break;
            }
            case LONG_SINGULAR: {
                output.append(wrap ? wrappedUnit : unit);
            }
        }
        return output.toString();
    }

    public static String withQuarters(double value) {
        double floor;
        boolean negative = value < 0.0;
        if ((value = (double)Units.roundTo(Math.abs(value), 0.25)) == (floor = Math.floor(value))) {
            return String.valueOf(negative ? Character.valueOf('-') : "") + Units.number(floor);
        }
        int quarters = (int)Math.round((value - floor) / 0.25);
        return String.valueOf(negative ? Character.valueOf('-') : "") + (floor == 0.0 ? "" : Units.number(floor)) + Units.getQuarterSymbol(quarters);
    }

    private static String getQuarterSymbol(int quarters) {
        switch (quarters) {
            case 1: {
                return "&frac14;";
            }
            case 2: {
                return "&frac12;";
            }
            case 3: {
                return "&frac34;";
            }
        }
        return "";
    }

    public static String getOrdinal(int value) {
        switch (value % 100) {
            case 11: 
            case 12: 
            case 13: {
                return "th";
            }
        }
        return suffixes[value % 10];
    }

    public static String getMonthName(int month) {
        switch (month) {
            case 1: {
                return "1\u6708";
            }
            case 2: {
                return "2\u6708";
            }
            case 3: {
                return "3\u6708";
            }
            case 4: {
                return "4\u6708";
            }
            case 5: {
                return "5\u6708";
            }
            case 6: {
                return "6\u6708";
            }
            case 7: {
                return "7\u6708";
            }
            case 8: {
                return "8\u6708";
            }
            case 9: {
                return "9\u6708";
            }
            case 10: {
                return "10\u6708";
            }
            case 11: {
                return "11\u6708";
            }
            case 12: {
                return "12\u6708";
            }
        }
        return "";
    }

    public static float round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException("Amount of fractional places cannot be less than 0.");
        }
        return BigDecimal.valueOf(value).setScale(places, RoundingMode.HALF_UP).floatValue();
    }

    public static float roundTo(double value, double nearest) {
        return (float)((double)Math.round(value / nearest) * nearest);
    }

    public static long roundTo(double value, long nearest) {
        return Math.round(value / (double)nearest) * nearest;
    }

    public static double adaptiveRound(double value) {
        double absoluteValue = Math.abs(value);
        if (absoluteValue <= 2.0) {
            return Units.round(value, 1);
        }
        if (absoluteValue <= 10.0) {
            return Units.roundTo(value, 0.5);
        }
        return Math.round(value);
    }

    public static long aggressiveRound(double value) {
        double absoluteValue = Math.abs(value);
        if (absoluteValue <= 10.0) {
            return Math.round(value);
        }
        if (absoluteValue <= 50.0) {
            return Units.roundTo(value, 5L);
        }
        return Units.roundTo(value, 10L);
    }

    static {
        suffixes = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
    }

    public static enum DateType {
        SHORT,
        LONG;

    }

    public static enum ValueType {
        NUMERIC,
        PRECISE,
        TEXT;

    }

    public static enum UnitType {
        NONE,
        SHORT,
        LONG,
        LONG_SINGULAR;

    }
}

