/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.world;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.Game;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.game.inventory.Rarity;
import com.lilithsthrone.game.inventory.clothing.AbstractClothing;
import com.lilithsthrone.game.inventory.item.AbstractItem;
import com.lilithsthrone.game.inventory.weapon.AbstractWeapon;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Vector2i;
import com.lilithsthrone.utils.XMLSaving;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.AbstractPlaceUpgrade;
import com.lilithsthrone.world.places.Aquatic;
import com.lilithsthrone.world.places.Darkness;
import com.lilithsthrone.world.places.GenericPlace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Cell
implements XMLSaving {
    public static final int CELL_MAXIMUM_INVENTORY_SPACE = 48;
    public static int refundMoney = 0;
    private AbstractWorldType type;
    private Vector2i location;
    private boolean discovered;
    private boolean travelledTo;
    private GenericPlace place;
    private CharacterInventory inventory;
    private Set<String> charactersPresentIds;
    private Set<String> charactersHomeIds;
    private Set<String> charactersGlobalIds;

    public Cell(AbstractWorldType type, Vector2i location) {
        this.type = type;
        this.location = location;
        this.discovered = false;
        this.travelledTo = false;
        this.place = new GenericPlace(type.getStandardPlace());
        this.inventory = new CharacterInventory(true, 0, 48);
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element element = doc.createElement("cell");
        parentElement.appendChild(element);
        Element location = doc.createElement("location");
        element.appendChild(location);
        XMLUtil.addAttribute(doc, location, "x", String.valueOf(this.getLocation().getX()));
        XMLUtil.addAttribute(doc, location, "y", String.valueOf(this.getLocation().getY()));
        XMLUtil.addAttribute(doc, element, "discovered", String.valueOf(this.discovered));
        XMLUtil.addAttribute(doc, element, "travelledTo", String.valueOf(this.travelledTo));
        this.place.saveAsXML(element, doc);
        if (!this.inventory.isEmpty()) {
            this.inventory.saveAsXML(element, doc);
        }
        return element;
    }

    public static Cell loadFromXML(Element parentElement, Document doc, AbstractWorldType type) {
        Element locationElement = (Element)parentElement.getElementsByTagName("location").item(0);
        Cell cell = new Cell(type, new Vector2i(Integer.valueOf(locationElement.getAttribute("x")), Integer.valueOf(locationElement.getAttribute("y"))));
        cell.setDiscovered(Boolean.valueOf(parentElement.getAttribute("discovered")));
        if (Main.isVersionOlderThan(Game.loadingVersion, "0.2.11.5")) {
            cell.setTravelledTo(Boolean.valueOf(parentElement.getAttribute("discovered")));
        } else {
            try {
                if (type.isRevealedOnStart()) {
                    cell.setTravelledTo(true);
                } else {
                    cell.setTravelledTo(Boolean.valueOf(parentElement.getAttribute("travelledTo")));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        cell.setPlace(GenericPlace.loadFromXML((Element)parentElement.getElementsByTagName("place").item(0), doc, cell), false);
        try {
            Node invNode = parentElement.getElementsByTagName("characterInventory").item(0);
            if (invNode != null) {
                CharacterInventory.loadingFromFloorBackupCheck = true;
                cell.setInventory(CharacterInventory.loadFromXML((Element)invNode, doc));
            }
            if (refundMoney > 0) {
                cell.getInventory().incrementMoney(refundMoney);
                refundMoney = 0;
            }
        }
        catch (Exception ex) {
            System.err.println("Cell import error 1");
        }
        return cell;
    }

    public String toString() {
        return "Cell (" + this.getLocation().toString() + "): Place: " + this.getPlace().getPlaceType().getName();
    }

    public String getId() {
        return WorldType.getIdFromWorldType(this.type) + "-X:" + this.location.getX() + "-Y:" + this.location.getY();
    }

    public AbstractWorldType getType() {
        return this.type;
    }

    public void setType(AbstractWorldType type) {
        this.type = type;
    }

    public String getPlaceName() {
        return this.place.getName();
    }

    public boolean isDiscovered() {
        return this.discovered;
    }

    public void setDiscovered(boolean discovered) {
        this.discovered = discovered;
    }

    public boolean isTravelledTo() {
        return this.travelledTo;
    }

    public void setTravelledTo(boolean travelledTo) {
        this.travelledTo = travelledTo;
    }

    public GenericPlace getPlace() {
        return this.place;
    }

    public void setPlace(GenericPlace place, boolean applyInventoryInit) {
        this.place = place;
        if (applyInventoryInit) {
            place.getPlaceType().applyInventoryInit(this.getInventory());
        }
    }

    public AbstractPlaceType getPlaceType() {
        return this.getPlace().getPlaceType();
    }

    public boolean isLight() {
        return !this.isDark();
    }

    public boolean isDark() {
        return this.getPlace().getPlaceType().getDarkness() == Darkness.ALWAYS_DARK || this.getPlace().getPlaceType().getDarkness() == Darkness.DAYLIGHT && !Main.game.isDayTime();
    }

    public Aquatic getAquatic() {
        return this.getPlace().getPlaceType().getAquatic();
    }

    public boolean isFurniturePresent() {
        return this.getPlace().getPlaceType().isFurniturePresentOverride() ? this.getPlace().getPlaceType().isFurniturePresent() : this.getType().isFurniturePresent();
    }

    public String getDeskName() {
        if (Main.game.isInSex() && Main.sex.getInitialSexManager().getDeskName() != null && !Main.sex.getInitialSexManager().getDeskName().isEmpty()) {
            return Main.sex.getInitialSexManager().getDeskName();
        }
        return this.getPlace().getPlaceType().isDeskNameOverride() ? this.getPlace().getPlaceType().getDeskName() : this.getType().getDeskName();
    }

    public boolean isWallsPresent() {
        return this.getPlace().getPlaceType().isWallsPresentOverride() ? this.getPlace().getPlaceType().isWallsPresent() : this.getType().isWallsPresent();
    }

    public String getWallName() {
        if (Main.game.isInSex() && Main.sex.getInitialSexManager().getWallName() != null && !Main.sex.getInitialSexManager().getWallName().isEmpty()) {
            return Main.sex.getInitialSexManager().getWallName();
        }
        return this.getPlace().getPlaceType().isWallNameOverride() ? this.getPlace().getPlaceType().getWallName() : this.getType().getWallName();
    }

    public DialogueNode getDialogue(boolean withRandomEncounter) {
        return this.getPlace().getDialogue(this, withRandomEncounter, false);
    }

    public DialogueNode getDialogue(boolean withRandomEncounter, boolean forceEncounter) {
        return this.getPlace().getDialogue(this, withRandomEncounter, forceEncounter);
    }

    public boolean addPlaceUpgrade(AbstractPlaceUpgrade upgrade) {
        return this.getPlace().addPlaceUpgrade(this, upgrade);
    }

    public boolean removePlaceUpgrade(AbstractPlaceUpgrade upgrade) {
        return this.getPlace().removePlaceUpgrade(this, upgrade);
    }

    public Vector2i getLocation() {
        return new Vector2i(this.location);
    }

    public void setLocation(Vector2i location) {
        this.location = location;
    }

    public void resetInventory() {
        this.resetInventory(null);
    }

    public void resetInventory(List<Rarity> rarityOfItemsToSave) {
        if (rarityOfItemsToSave != null && !rarityOfItemsToSave.isEmpty()) {
            ArrayList<AbstractItem> itemsToSave = new ArrayList<AbstractItem>();
            for (AbstractItem abstractItem : this.inventory.getAllItemsInInventory().keySet()) {
                if (!rarityOfItemsToSave.contains((Object)abstractItem.getRarity())) continue;
                itemsToSave.add(abstractItem);
            }
            ArrayList<AbstractWeapon> weaponsToSave = new ArrayList<AbstractWeapon>();
            for (AbstractWeapon weapon : this.inventory.getAllWeaponsInInventory().keySet()) {
                if (!rarityOfItemsToSave.contains((Object)weapon.getRarity())) continue;
                weaponsToSave.add(weapon);
            }
            ArrayList<AbstractClothing> arrayList = new ArrayList<AbstractClothing>();
            for (AbstractClothing abstractClothing : this.inventory.getAllClothingInInventory().keySet()) {
                if (!rarityOfItemsToSave.contains((Object)abstractClothing.getRarity())) continue;
                arrayList.add(abstractClothing);
            }
            this.inventory = new CharacterInventory(true, 0, 48);
            for (AbstractItem abstractItem : itemsToSave) {
                this.inventory.addItem(abstractItem);
            }
            for (AbstractWeapon abstractWeapon : weaponsToSave) {
                this.inventory.addWeapon(abstractWeapon);
            }
            for (AbstractClothing abstractClothing : arrayList) {
                this.inventory.addClothing(abstractClothing);
            }
        } else {
            this.inventory = new CharacterInventory(true, 0, 48);
        }
    }

    public CharacterInventory getInventory() {
        return this.inventory;
    }

    public void setInventory(CharacterInventory inventory) {
        this.inventory = inventory;
    }

    public Set<String> getCharactersPresentIds() {
        if (this.charactersPresentIds == null) {
            this.charactersPresentIds = Collections.synchronizedSet(new HashSet());
        }
        return this.charactersPresentIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCharacterPresentId(String id) {
        if (id.equals("NOT_SET")) {
            return;
        }
        if (this.charactersPresentIds == null) {
            this.charactersPresentIds = Collections.synchronizedSet(new HashSet());
        }
        Set<String> set = this.charactersPresentIds;
        synchronized (set) {
            this.charactersPresentIds.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCharacterPresentId(String id) {
        if (this.charactersPresentIds == null) {
            return;
        }
        Set<String> set = this.charactersPresentIds;
        synchronized (set) {
            this.charactersPresentIds.remove(id);
        }
    }

    public Set<String> getCharactersHomeIds() {
        if (this.charactersHomeIds == null) {
            this.charactersHomeIds = Collections.synchronizedSet(new HashSet());
        }
        return this.charactersHomeIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCharacterHomeId(String id) {
        if (id.equals("NOT_SET")) {
            return;
        }
        if (this.charactersHomeIds == null) {
            this.charactersHomeIds = Collections.synchronizedSet(new HashSet());
        }
        Set<String> set = this.charactersHomeIds;
        synchronized (set) {
            this.charactersHomeIds.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCharacterHomeId(String id) {
        if (this.charactersHomeIds == null) {
            return;
        }
        Set<String> set = this.charactersHomeIds;
        synchronized (set) {
            this.charactersHomeIds.remove(id);
        }
    }

    public Set<String> getCharactersGlobalIds() {
        if (this.charactersGlobalIds == null) {
            this.charactersGlobalIds = Collections.synchronizedSet(new HashSet());
        }
        return this.charactersGlobalIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCharacterGlobalId(String id) {
        if (id.equals("NOT_SET")) {
            return;
        }
        if (this.charactersGlobalIds == null) {
            this.charactersGlobalIds = Collections.synchronizedSet(new HashSet());
        }
        Set<String> set = this.charactersGlobalIds;
        synchronized (set) {
            this.charactersGlobalIds.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCharacterGlobalId(String id) {
        if (this.charactersGlobalIds == null) {
            return;
        }
        Set<String> set = this.charactersGlobalIds;
        synchronized (set) {
            this.charactersGlobalIds.remove(id);
        }
    }
}

