/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.world;

import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Vector2i;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.World;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.GenericPlace;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.concurrent.Task;
import javax.imageio.ImageIO;

public class Generation
extends Task<Boolean> {
    private boolean debug = false;

    @Override
    public Boolean call() {
        int maxSize = WorldType.getAllWorldTypes().size();
        AtomicInteger count = new AtomicInteger();
        WorldType.getAllWorldTypes().parallelStream().forEach(wt -> {
            if (this.debug) {
                System.out.println(wt);
            }
            try {
                Main.game.getWorlds().put((AbstractWorldType)wt, this.worldGeneration((AbstractWorldType)wt));
            }
            catch (Exception e) {
                System.err.println("Exception while generating world type! " + wt.getId());
                e.printStackTrace(System.err);
            }
            this.updateProgress(count.incrementAndGet(), maxSize);
        });
        return true;
    }

    public World worldGeneration(AbstractWorldType worldType) {
        if (worldType.isUsesFile()) {
            try {
                BufferedImage img = worldType.isFromExternalFile() ? ImageIO.read(new File(worldType.getFileLocation())) : ImageIO.read(this.getClass().getResource(worldType.getFileLocation()));
                World world = new World(img.getWidth(), img.getHeight(), null, worldType);
                if (this.debug) {
                    System.out.println(worldType.getName() + " Start-File 1");
                }
                Cell[][] grid = new Cell[img.getWidth()][img.getHeight()];
                for (int i = 0; i < img.getWidth(); ++i) {
                    for (int j = 0; j < img.getHeight(); ++j) {
                        grid[i][j] = new Cell(worldType, new Vector2i(i, j));
                        if (worldType.isRevealedOnStart()) {
                            grid[i][j].setDiscovered(true);
                            grid[i][j].setTravelledTo(true);
                            continue;
                        }
                        if (!worldType.isDiscoveredOnStart()) continue;
                        grid[i][j].setDiscovered(true);
                    }
                }
                if (this.debug) {
                    System.out.println(worldType.getName() + " Start-File 2");
                }
                for (int w = 0; w < img.getWidth(); ++w) {
                    for (int h = 0; h < img.getHeight(); ++h) {
                        grid[w][img.getHeight() - 1 - h].setPlace(new GenericPlace(worldType.getPlacesMap().get(new Color(img.getRGB(w, h)))), true);
                    }
                }
                if (this.debug) {
                    System.out.println(worldType.getName() + " Start-File 3");
                }
                world.setGrid(grid);
                return world;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

