/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.world.places;

import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.encounters.AbstractEncounter;
import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.AbstractWorldType;
import com.lilithsthrone.world.WorldRegion;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.Aquatic;
import com.lilithsthrone.world.places.Darkness;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractGlobalPlaceType
extends AbstractPlaceType {
    public AbstractGlobalPlaceType(WorldRegion worldRegion, String name, String SVGPath2, String tooltipDescription, Colour colour, DialogueNode dialogue, AbstractEncounter encounterType, String virginityLossDescription) {
        this(worldRegion, name, tooltipDescription, SVGPath2, colour, colour, dialogue, encounterType, virginityLossDescription);
    }

    public AbstractGlobalPlaceType(WorldRegion worldRegion, String name, String tooltipDescription, String SVGPath2, Colour colour, Colour backgroundColour, DialogueNode dialogue, AbstractEncounter encounterType, String virginityLossDescription) {
        super(worldRegion, name, tooltipDescription, null, null, dialogue, Darkness.DAYLIGHT, encounterType, virginityLossDescription);
        this.name = name;
        this.colour = colour;
        this.backgroundColour = backgroundColour == null ? PresetColour.MAP_BACKGROUND : backgroundColour;
        this.encounterType = encounterType;
        this.virginityLossDescription = virginityLossDescription;
        this.dialogue = dialogue;
        this.globalMapTile = true;
        if (SVGPath2 != null) {
            try {
                InputStream is = this.getClass().getResourceAsStream("/com/lilithsthrone/res/map/" + SVGPath2 + ".svg");
                if (is == null) {
                    System.err.println("Error! PlaceType icon file does not exist (Trying to read from '" + SVGPath2 + "')! (Code 1)");
                }
                String s = Util.inputStreamToString(is);
                try {
                    s = SvgUtil.colourReplacement("placeColour" + colourReplacementId, colour, s);
                    ++colourReplacementId;
                }
                catch (Exception ex) {
                    System.err.println(SVGPath2 + " error!");
                }
                this.SVGString = s;
                is.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else {
            this.SVGString = null;
        }
    }

    @Override
    public AbstractGlobalPlaceType initDangerous() {
        this.dangerous = true;
        return this;
    }

    @Override
    public AbstractGlobalPlaceType initAquatic(Aquatic aquatic) {
        this.aquatic = aquatic;
        return this;
    }

    @Override
    public AbstractGlobalPlaceType initItemsPersistInTile() {
        this.itemsDisappear = false;
        return this;
    }

    public abstract AbstractWorldType getGlobalLinkedWorldType();
}

