/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.world.places;

import com.lilithsthrone.controller.xmlParsing.Element;
import com.lilithsthrone.game.character.GameCharacter;
import com.lilithsthrone.game.dialogue.DialogueManager;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.encounters.AbstractEncounter;
import com.lilithsthrone.game.dialogue.encounters.Encounter;
import com.lilithsthrone.game.dialogue.utils.ParserTag;
import com.lilithsthrone.game.dialogue.utils.UtilText;
import com.lilithsthrone.game.inventory.CharacterInventory;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.SvgUtil;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.Bearing;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.EntranceType;
import com.lilithsthrone.world.TeleportPermissions;
import com.lilithsthrone.world.Weather;
import com.lilithsthrone.world.WorldRegion;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceUpgrade;
import com.lilithsthrone.world.places.Aquatic;
import com.lilithsthrone.world.places.Darkness;
import com.lilithsthrone.world.places.PlaceType;
import com.lilithsthrone.world.population.AbstractPopulationType;
import com.lilithsthrone.world.population.Population;
import com.lilithsthrone.world.population.PopulationDensity;
import com.lilithsthrone.world.population.PopulationType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;

public class AbstractPlaceType {
    private boolean mod;
    private boolean fromExternalFile;
    private String author;
    protected WorldRegion worldRegion;
    protected String name;
    protected String tooltipDescription;
    protected String SVGString;
    protected Colour colour;
    protected Colour backgroundColour;
    protected DialogueNode dialogue;
    protected AbstractEncounter encounterType;
    protected boolean globalMapTile;
    protected boolean dangerous;
    protected boolean itemsDisappear;
    private boolean furniturePresentOverride;
    private boolean furniturePresent;
    private boolean deskNameOverride;
    private String deskName;
    private boolean loiteringEnabledOverride;
    private boolean loiteringEnabled;
    private boolean wallsPresentOverride;
    private boolean wallsPresent;
    private boolean wallNameOverride;
    private String wallName;
    private String sexBlockedReason;
    private boolean sexBlockedFromCharacterPresent;
    protected Aquatic aquatic;
    protected Darkness darkness;
    protected TeleportPermissions teleportPermissions;
    protected List<Weather> weatherImmunities;
    protected static List<Weather> allWeatherImmunities = new ArrayList<Weather>(Arrays.asList(Weather.values()));
    protected String virginityLossDescription;
    protected static Map<String, String> SVGOverrides = new HashMap<String, String>();
    protected static int colourReplacementId = 0;
    protected String dangerousString;
    protected String itemsDisappearString;
    protected String aquaticString;
    protected String darknessString;
    protected String inventoryInitString;
    protected List<Population> populations = new ArrayList<Population>();
    protected String copyPlaceTypePopulationId;

    public AbstractPlaceType(WorldRegion worldRegion, String name, String tooltipDescription, String SVGPath2, Colour colour, DialogueNode dialogue, Darkness darkness, AbstractEncounter encounterType, String virginityLossDescription) {
        this.worldRegion = worldRegion;
        this.name = name;
        this.tooltipDescription = tooltipDescription;
        this.colour = colour;
        this.backgroundColour = PresetColour.MAP_BACKGROUND;
        this.dialogue = dialogue;
        this.encounterType = encounterType;
        this.weatherImmunities = new ArrayList<Weather>();
        this.virginityLossDescription = virginityLossDescription;
        this.dangerous = false;
        this.itemsDisappear = true;
        this.globalMapTile = false;
        this.furniturePresentOverride = false;
        this.furniturePresent = false;
        this.loiteringEnabledOverride = false;
        this.loiteringEnabled = false;
        this.wallsPresentOverride = false;
        this.wallsPresent = false;
        this.wallName = "\u5899\u58c1";
        this.sexBlockedReason = "";
        this.sexBlockedFromCharacterPresent = true;
        this.aquatic = Aquatic.LAND;
        this.darkness = darkness;
        this.teleportPermissions = TeleportPermissions.BOTH;
        if (SVGPath2 != null) {
            try {
                InputStream is = this.getClass().getResourceAsStream("/com/lilithsthrone/res/map/" + SVGPath2 + ".svg");
                if (is == null) {
                    System.err.println("Error! PlaceType icon file does not exist (Trying to read from '" + SVGPath2 + "')! (Code 1)");
                }
                String s = Util.inputStreamToString(is);
                try {
                    s = SvgUtil.colourReplacement("placeColour" + colourReplacementId, colour, s);
                    ++colourReplacementId;
                }
                catch (Exception ex) {
                    System.err.println(SVGPath2 + " error!");
                }
                this.SVGString = s;
                is.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else {
            this.SVGString = null;
        }
    }

    public AbstractPlaceType(File XMLFile, String author, String id, boolean mod) {
        if (XMLFile.exists()) {
            try {
                Iterator<Element> encounterId;
                Document doc = Main.getDocBuilder().parse(XMLFile);
                doc.getDocumentElement().normalize();
                Element coreElement = Element.getDocumentRootElement(XMLFile);
                this.mod = mod;
                this.fromExternalFile = true;
                this.author = author;
                this.worldRegion = WorldRegion.valueOf(coreElement.getMandatoryFirstOf("worldRegion").getTextContent());
                this.name = coreElement.getMandatoryFirstOf("name").getTextContent();
                if (!Boolean.valueOf(coreElement.getMandatoryFirstOf("name").getAttribute("noCapitalisation")).booleanValue()) {
                    String[] nameSplit = this.name.split(" ");
                    StringBuilder sb = new StringBuilder();
                    for (String s : nameSplit) {
                        sb.append(Util.capitaliseSentence(s));
                        sb.append("");
                    }
                    this.name = sb.toString();
                }
                this.tooltipDescription = coreElement.getMandatoryFirstOf("tooltipDescription").getTextContent();
                this.virginityLossDescription = coreElement.getMandatoryFirstOf("virginityLossDescription").getTextContent();
                this.sexBlockedReason = coreElement.getOptionalFirstOf("sexBlockedReason").isPresent() ? coreElement.getMandatoryFirstOf("sexBlockedReason").getTextContent() : null;
                this.sexBlockedFromCharacterPresent = Boolean.valueOf(coreElement.getMandatoryFirstOf("sexBlockedFromCharacterPresent").getTextContent().trim());
                String colourId = coreElement.getMandatoryFirstOf("colour").getTextContent();
                this.colour = colourId.startsWith("#") ? new Colour(false, Util.newColour(colourId), Util.newColour(colourId), "") : PresetColour.getColourFromId(colourId);
                colourId = coreElement.getMandatoryFirstOf("backgroundColour").getTextContent();
                this.backgroundColour = colourId.startsWith("#") ? new Colour(false, Util.newColour(colourId), Util.newColour(colourId), "") : PresetColour.getColourFromId(colourId);
                this.encounterType = null;
                if (coreElement.getOptionalFirstOf("encounterType").isPresent() && !((String)((Object)(encounterId = coreElement.getMandatoryFirstOf("encounterType").getTextContent().trim()))).equals("null") && !((String)((Object)encounterId)).isEmpty()) {
                    this.encounterType = Encounter.getEncounterFromId(coreElement.getMandatoryFirstOf("encounterType").getTextContent().trim());
                }
                this.dialogue = DialogueManager.getDialogueFromId(coreElement.getMandatoryFirstOf("dialogue").getTextContent());
                this.populations = new ArrayList<Population>();
                if (coreElement.getOptionalFirstOf("populationPresent").isPresent()) {
                    if (!coreElement.getMandatoryFirstOf("populationPresent").getAttribute("copyPlaceType").isEmpty()) {
                        this.copyPlaceTypePopulationId = coreElement.getMandatoryFirstOf("populationPresent").getAttribute("copyPlaceType");
                    } else {
                        for (Element population : coreElement.getMandatoryFirstOf("populationPresent").getAllOf("population")) {
                            int startMinutes = -1;
                            int endMinutes = -1;
                            boolean usingDaylightHours = false;
                            boolean inclusiveRange = true;
                            if (Boolean.valueOf(population.getAttribute("night")).booleanValue()) {
                                usingDaylightHours = true;
                                inclusiveRange = false;
                            } else if (Boolean.valueOf(population.getAttribute("day")).booleanValue()) {
                                usingDaylightHours = true;
                            } else {
                                if (!population.getAttribute("startMinutes").isEmpty()) {
                                    startMinutes = Integer.valueOf(population.getAttribute("startMinutes"));
                                }
                                if (!population.getAttribute("endMinutes").isEmpty()) {
                                    endMinutes = Integer.valueOf(population.getAttribute("endMinutes"));
                                }
                                if (!population.getAttribute("inclusiveRange").isEmpty()) {
                                    inclusiveRange = Boolean.valueOf(population.getAttribute("inclusiveRange"));
                                }
                            }
                            String conditional = "";
                            if (population.getOptionalFirstOf("conditional").isPresent()) {
                                conditional = population.getMandatoryFirstOf("conditional").getTextContent();
                            }
                            String populationTypeString = population.getMandatoryFirstOf("populationType").getTextContent();
                            boolean plural = Boolean.valueOf(population.getMandatoryFirstOf("populationType").getAttribute("plural"));
                            PopulationDensity density = PopulationDensity.valueOf(population.getMandatoryFirstOf("populationType").getAttribute("density"));
                            AbstractPopulationType popType = PopulationType.hasId(populationTypeString) ? PopulationType.getPopulationTypeFromId(populationTypeString) : new AbstractPopulationType(populationTypeString, populationTypeString){};
                            if (population.getMandatoryFirstOf("subspeciesPresent").getAttribute("worldType").isEmpty()) {
                                ArrayList<String> subspeciesIds = new ArrayList<String>();
                                for (Element element : population.getMandatoryFirstOf("subspeciesPresent").getAllOf("subspecies")) {
                                    String subId = element.getTextContent();
                                    subspeciesIds.add(subId);
                                }
                                Population pop = new Population(plural, popType, density, null);
                                pop.setConditional(conditional);
                                pop.setSubspeciesIdToAdd(subspeciesIds);
                                pop.setDayStartOverride(startMinutes);
                                pop.setDayEndOverride(endMinutes);
                                pop.setUsingDaylightHours(usingDaylightHours);
                                pop.setInclusiveTimeRange(inclusiveRange);
                                this.populations.add(pop);
                                continue;
                            }
                            String popDaySubspeciesWorldTypeId = population.getMandatoryFirstOf("subspeciesPresent").getAttribute("worldType");
                            ArrayList<String> subspeciesIds = new ArrayList<String>();
                            for (Element subspecies3 : population.getMandatoryFirstOf("subspeciesPresent").getAllOf("subspeciesToRemove")) {
                                subspeciesIds.add(subspecies3.getTextContent());
                            }
                            Population population2 = new Population(plural, popType, density, null);
                            population2.setConditional(conditional);
                            population2.setSubspeciesPlaceTypeId(id);
                            population2.setSubspeciesWorldTypeId(popDaySubspeciesWorldTypeId);
                            population2.setSubspeciesIdToRemove(subspeciesIds);
                            population2.setDayStartOverride(startMinutes);
                            population2.setDayEndOverride(endMinutes);
                            population2.setUsingDaylightHours(usingDaylightHours);
                            population2.setInclusiveTimeRange(inclusiveRange);
                            this.populations.add(population2);
                        }
                    }
                }
                if (coreElement.getOptionalFirstOf("furniturePresent").isPresent()) {
                    this.furniturePresentOverride = true;
                    this.furniturePresent = Boolean.valueOf(coreElement.getMandatoryFirstOf("furniturePresent").getTextContent().trim());
                    if (!coreElement.getMandatoryFirstOf("furniturePresent").getAttribute("deskName").isEmpty()) {
                        this.deskNameOverride = true;
                        this.deskName = coreElement.getMandatoryFirstOf("furniturePresent").getAttribute("deskName");
                    }
                } else {
                    this.furniturePresentOverride = false;
                    this.furniturePresent = false;
                    this.deskNameOverride = false;
                    this.deskName = "\u684c\u5b50";
                }
                if (coreElement.getOptionalFirstOf("loiteringEnabled").isPresent()) {
                    this.loiteringEnabledOverride = true;
                    this.loiteringEnabled = Boolean.valueOf(coreElement.getMandatoryFirstOf("loiteringEnabled").getTextContent().trim());
                } else {
                    this.loiteringEnabledOverride = false;
                    this.loiteringEnabled = false;
                }
                if (coreElement.getOptionalFirstOf("wallsPresent").isPresent()) {
                    this.wallsPresentOverride = true;
                    this.wallsPresent = Boolean.valueOf(coreElement.getMandatoryFirstOf("wallsPresent").getTextContent().trim());
                    if (!coreElement.getMandatoryFirstOf("wallsPresent").getAttribute("wallName").isEmpty()) {
                        this.wallNameOverride = true;
                        this.wallName = coreElement.getMandatoryFirstOf("wallsPresent").getAttribute("wallName");
                    }
                } else {
                    this.wallsPresentOverride = false;
                    this.wallsPresent = false;
                    this.wallNameOverride = false;
                    this.wallName = "\u5899\u58c1";
                }
                this.globalMapTile = Boolean.valueOf(coreElement.getMandatoryFirstOf("globalMapTile").getTextContent().trim());
                this.dangerousString = coreElement.getMandatoryFirstOf("dangerous").getTextContent().trim();
                this.itemsDisappearString = coreElement.getMandatoryFirstOf("itemsDisappear").getTextContent().trim();
                this.aquaticString = coreElement.getMandatoryFirstOf("aquatic").getTextContent().trim();
                this.darknessString = coreElement.getMandatoryFirstOf("darkness").getTextContent().trim();
                this.teleportPermissions = coreElement.getOptionalFirstOf("teleportPermissions").isPresent() && !coreElement.getMandatoryFirstOf("teleportPermissions").getTextContent().isEmpty() ? TeleportPermissions.valueOf(coreElement.getMandatoryFirstOf("teleportPermissions").getTextContent()) : TeleportPermissions.BOTH;
                this.weatherImmunities = new ArrayList<Weather>();
                if (coreElement.getOptionalFirstOf("weatherImmunities").isPresent()) {
                    if (Boolean.valueOf(coreElement.getMandatoryFirstOf("weatherImmunities").getAttribute("immuneToAll").trim()).booleanValue()) {
                        this.initWeatherImmune();
                    } else {
                        for (Element e : coreElement.getMandatoryFirstOf("weatherImmunities").getAllOf("weather")) {
                            try {
                                this.weatherImmunities.add(Weather.valueOf(e.getTextContent().trim()));
                            }
                            catch (Exception ex) {
                                System.err.println("PlaceType loading error in '" + XMLFile.getName() + "': Weather '" + e.getTextContent() + "' not recognised! (Not added)");
                            }
                        }
                    }
                }
                this.inventoryInitString = coreElement.getOptionalFirstOf("applyInventoryInit").isPresent() ? coreElement.getMandatoryFirstOf("applyInventoryInit").getTextContent() : "";
                String svgPath = XMLFile.getAbsolutePath().replace(".xml", ".svg");
                if (coreElement.getOptionalFirstOf("svgName").isPresent() && !coreElement.getMandatoryFirstOf("svgName").getTextContent().isEmpty()) {
                    svgPath = XMLFile.getAbsolutePath().replace(XMLFile.getName(), coreElement.getMandatoryFirstOf("svgName").getTextContent() + ".svg");
                }
                if (new File(svgPath).exists()) {
                    try {
                        InputStream is = this.getClass().getResourceAsStream("/com/lilithsthrone/res/map/iconBackground.svg");
                        this.SVGString = Util.inputStreamToString(is);
                        is.close();
                        List<String> lines = Files.readAllLines(Paths.get(svgPath, new String[0]));
                        StringBuilder sb = new StringBuilder();
                        sb.append("<div style='width:100%;height:100%;position:absolute;left:0;top:0;margin:0;padding:0;'>");
                        sb.append(this.SVGString);
                        sb.append("</div>");
                        sb.append("<div style='width:70%;height:70%;position:absolute;left:15%;top:15%;margin:0;padding:0;'>");
                        for (String line : lines) {
                            sb.append(line);
                        }
                        sb.append("</div>");
                        this.SVGString = sb.toString();
                        this.SVGString = SvgUtil.colourReplacement(XMLFile.getName().replace("\\.svg", ""), this.colour, PresetColour.BASE_WHITE, null, this.SVGString);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    this.SVGString = null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("PlaceType was unable to be loaded from file! (" + XMLFile.getName() + ")\n" + String.valueOf(ex));
            }
        }
    }

    public AbstractPlaceType initDangerous() {
        this.dangerous = true;
        return this;
    }

    public AbstractPlaceType initItemsPersistInTile() {
        this.itemsDisappear = false;
        return this;
    }

    public AbstractPlaceType initMapBackgroundColour(Colour backgroundColour) {
        this.backgroundColour = backgroundColour;
        return this;
    }

    public AbstractPlaceType initWeatherImmune() {
        this.weatherImmunities = allWeatherImmunities;
        return this;
    }

    public AbstractPlaceType initWeatherImmune(Weather ... weatherImmunities) {
        this.weatherImmunities = new ArrayList<Weather>(Arrays.asList(weatherImmunities));
        return this;
    }

    public AbstractPlaceType initAquatic(Aquatic aquatic) {
        this.aquatic = aquatic;
        return this;
    }

    public AbstractPlaceType initTeleportPermissions(TeleportPermissions teleportPermissions) {
        this.teleportPermissions = teleportPermissions;
        return this;
    }

    public AbstractPlaceType initSexNotBlockedFromCharacterPresent() {
        this.sexBlockedFromCharacterPresent = false;
        return this;
    }

    public boolean isMod() {
        return this.mod;
    }

    public boolean isFromExternalFile() {
        return this.fromExternalFile;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getId() {
        return PlaceType.getIdFromPlaceType(this);
    }

    public WorldRegion getWorldRegion() {
        return this.worldRegion;
    }

    public String getName() {
        return this.name;
    }

    public String getTooltipDescription() {
        return UtilText.parse(this.tooltipDescription, new ParserTag[0]);
    }

    public Colour getColour() {
        return this.colour;
    }

    public Colour getBackgroundColour() {
        if (this.backgroundColour == PresetColour.MAP_BACKGROUND && this.isDangerous()) {
            return PresetColour.MAP_BACKGROUND_DANGEROUS;
        }
        return this.backgroundColour;
    }

    public AbstractEncounter getCoreEncounterType() {
        return this.encounterType;
    }

    public AbstractEncounter getEncounterType() {
        HashMap<AbstractEncounter, Float> possibleEncountersMap = new HashMap<AbstractEncounter, Float>();
        if (this.encounterType != null && this.encounterType.getTotalChanceValue() > 0.0f) {
            possibleEncountersMap.put(this.encounterType, Float.valueOf(this.encounterType.getTotalChanceValue()));
        }
        for (AbstractEncounter enc : Encounter.getAddedEncounters(this.getId())) {
            if (!(enc.getTotalChanceValue() > 0.0f)) continue;
            possibleEncountersMap.put(enc, Float.valueOf(enc.getTotalChanceValue()));
        }
        if (possibleEncountersMap.isEmpty()) {
            return null;
        }
        if (possibleEncountersMap.keySet().stream().anyMatch(en -> en.isAnyBaseTriggerChanceOverOneHundred())) {
            possibleEncountersMap.keySet().removeIf(en -> !en.isAnyBaseTriggerChanceOverOneHundred());
        }
        AbstractEncounter ae = (AbstractEncounter)Util.getRandomObjectFromWeightedFloatMap(possibleEncountersMap);
        return ae;
    }

    protected DialogueNode getBaseDialogue(Cell cell) {
        return this.dialogue;
    }

    public DialogueNode getDialogue(boolean withRandomEncounter) {
        return this.getDialogue(null, withRandomEncounter, false);
    }

    public DialogueNode getDialogue(Cell cell, boolean withRandomEncounter) {
        return this.getDialogue(cell, withRandomEncounter, false);
    }

    public DialogueNode getDialogue(Cell cell, boolean withRandomEncounter, boolean forceEncounter) {
        DialogueNode dn;
        AbstractEncounter encounterType;
        if (withRandomEncounter && Main.game.isStarted() && (encounterType = this.getEncounterType()) != null && (dn = encounterType.getRandomEncounter(forceEncounter)) != null) {
            return dn;
        }
        return this.getBaseDialogue(cell);
    }

    public List<Population> getPopulation() {
        ArrayList<Population> returnPopulation = new ArrayList<Population>();
        if (this.fromExternalFile) {
            if (this.copyPlaceTypePopulationId != null && !this.copyPlaceTypePopulationId.isEmpty()) {
                return PlaceType.getPlaceTypeFromId(this.copyPlaceTypePopulationId).getPopulation();
            }
            for (Population pop : this.populations) {
                if (!pop.isAvailableFromConditional() || !pop.isAvailableFromCurrentTime()) continue;
                returnPopulation.add(pop);
            }
        }
        return returnPopulation;
    }

    public boolean isPopulated() {
        if (this.getPopulation() != null) {
            for (Population pop : this.getPopulation()) {
                if (pop.getSpecies().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isStormImmune() {
        return this.weatherImmunities.contains((Object)Weather.MAGIC_STORM);
    }

    public boolean isLand() {
        return this.getAquatic().isLand();
    }

    public boolean isWater() {
        return this.getAquatic().isWater();
    }

    public boolean isDangerous() {
        if (this.isFromExternalFile()) {
            return Boolean.valueOf(UtilText.parse(this.dangerousString, new ParserTag[0]));
        }
        return this.dangerous;
    }

    public boolean isItemsDisappear() {
        if (this.isFromExternalFile()) {
            return Boolean.valueOf(UtilText.parse(this.itemsDisappearString, new ParserTag[0]));
        }
        return this.itemsDisappear;
    }

    public Aquatic getAquatic() {
        if (this.isFromExternalFile()) {
            return Aquatic.valueOf(UtilText.parse(this.aquaticString, new ParserTag[0]));
        }
        return this.aquatic;
    }

    public Darkness getDarkness() {
        if (this.isFromExternalFile()) {
            String parsedDarkness = UtilText.parse(this.darknessString, new ParserTag[0]);
            if (parsedDarkness.isEmpty()) {
                return Darkness.DAYLIGHT;
            }
            return Darkness.valueOf(parsedDarkness);
        }
        return this.darkness;
    }

    public static String getSVGOverride(String pathName, Colour colour) {
        return AbstractPlaceType.getSVGOverride(pathName, colour, colour, colour);
    }

    public static String getSVGOverride(String pathName, Colour colourPrimary, Colour colourSecondary, Colour colourTertiary) {
        if (!SVGOverrides.keySet().contains(pathName + colourPrimary.getId())) {
            try {
                InputStream is = colourPrimary.getClass().getResourceAsStream("/com/lilithsthrone/res/map/" + pathName + ".svg");
                if (is == null) {
                    System.err.println("Error! PlaceType icon file does not exist (Trying to read from '" + pathName + "')! (Code 2)");
                }
                String s = Util.inputStreamToString(is);
                try {
                    s = SvgUtil.colourReplacement("placeColour" + colourReplacementId, colourPrimary, colourSecondary, colourTertiary, s);
                    ++colourReplacementId;
                }
                catch (Exception ex) {
                    System.err.println(pathName + " error!");
                }
                SVGOverrides.put(pathName + colourPrimary.getId(), s);
                is.close();
            }
            catch (Exception e1) {
                System.err.println("Error! AbstractPlaceType: PlaceType.getSVGOverride()");
                e1.printStackTrace();
                return "";
            }
        }
        return SVGOverrides.get(pathName + colourPrimary.getId());
    }

    public String getSVGString(Set<AbstractPlaceUpgrade> upgrades) {
        for (AbstractPlaceUpgrade upgrade : upgrades) {
            String s = upgrade.getSVGOverride();
            if (s == null) continue;
            return s;
        }
        return this.SVGString;
    }

    public void applyInventoryInit(CharacterInventory inventory) {
        if (this.isFromExternalFile() && !this.inventoryInitString.isEmpty()) {
            UtilText.setInventoryForParsing("inventory", inventory);
            UtilText.parse(this.inventoryInitString, new ParserTag[0]);
        }
    }

    public Bearing getBearing() {
        return null;
    }

    public WorldType getParentWorldType() {
        return null;
    }

    public AbstractPlaceType getParentPlaceType() {
        return null;
    }

    public EntranceType getParentAlignment() {
        return null;
    }

    public String getPlaceNameAppendFormat(int count) {
        return "";
    }

    public boolean isAbleToBeUpgraded() {
        return false;
    }

    public ArrayList<AbstractPlaceUpgrade> getStartingPlaceUpgrades() {
        return new ArrayList<AbstractPlaceUpgrade>();
    }

    public ArrayList<AbstractPlaceUpgrade> getAvailablePlaceUpgrades(Set<AbstractPlaceUpgrade> upgrades) {
        return new ArrayList<AbstractPlaceUpgrade>();
    }

    public boolean isSexBlockedOverride(GameCharacter character) {
        return this.getSexBlockedReason(character) != null;
    }

    public boolean isSexBlocked(GameCharacter character) {
        return this.getSexBlockedReason(character) != null && !this.getSexBlockedReason(character).isEmpty();
    }

    public String getSexBlockedReason(GameCharacter character) {
        if (this.isFromExternalFile() && this.sexBlockedReason != null) {
            return UtilText.parse(character, this.sexBlockedReason, new ParserTag[0]);
        }
        return this.sexBlockedReason;
    }

    public String getVirginityLossDescription() {
        return this.virginityLossDescription;
    }

    public boolean isGlobalMapTile() {
        return this.globalMapTile;
    }

    public TeleportPermissions getTeleportPermissions() {
        return this.teleportPermissions;
    }

    public boolean isFurniturePresentOverride() {
        return this.furniturePresentOverride;
    }

    public boolean isFurniturePresent() {
        return this.furniturePresent;
    }

    public boolean isDeskNameOverride() {
        return this.deskNameOverride;
    }

    public String getDeskName() {
        return this.deskName;
    }

    public boolean isLoiteringEnabledOverride() {
        return this.loiteringEnabledOverride;
    }

    public boolean isLoiteringEnabled() {
        return this.loiteringEnabled;
    }

    public boolean isSexBlockedFromCharacterPresent() {
        return this.sexBlockedFromCharacterPresent;
    }

    public boolean isWallsPresentOverride() {
        return this.wallsPresentOverride;
    }

    public boolean isWallsPresent() {
        return this.wallsPresent;
    }

    public boolean isWallNameOverride() {
        return this.wallNameOverride;
    }

    public String getWallName() {
        return this.wallName;
    }
}

