/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.world.places;

import com.lilithsthrone.game.character.effects.Perk;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.sex.ImmobilisationType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.places.GenericPlace;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPlaceUpgrade {
    private boolean isCoreRoomUpgrade;
    protected String name;
    protected String descriptionForPurchase;
    protected String descriptionAfterPurchase;
    protected String roomDescription;
    private int installCost;
    private int removalCost;
    private int upkeep;
    private int capacity;
    private Colour colour;
    private float affectionGain;
    private float obedienceGain;
    private List<AbstractPlaceUpgrade> prerequisites;

    public AbstractPlaceUpgrade(boolean isCoreRoomUpgrade, Colour colour, String name, String descriptionForPurchase, String descriptionAfterPurchase, String roomDescription, int installCost, int removalCost, int upkeep, int capacity, float affectionGain, float obedienceGain, List<AbstractPlaceUpgrade> prerequisites) {
        this.isCoreRoomUpgrade = isCoreRoomUpgrade;
        this.colour = colour;
        this.name = name;
        this.descriptionForPurchase = descriptionForPurchase;
        this.descriptionAfterPurchase = descriptionAfterPurchase;
        this.roomDescription = roomDescription;
        this.installCost = installCost;
        this.removalCost = removalCost;
        this.upkeep = upkeep;
        this.capacity = capacity;
        this.affectionGain = affectionGain;
        this.obedienceGain = obedienceGain;
        this.prerequisites = prerequisites == null ? new ArrayList<AbstractPlaceUpgrade>() : prerequisites;
    }

    protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
        return new Util.Value<Boolean, String>(true, "");
    }

    public Util.Value<Boolean, String> getAvailability(Cell cell) {
        if (!Main.game.getPlayer().isHasSlaverLicense() && this.isSlaverUpgrade()) {
            return new Util.Value<Boolean, String>(false, "\u4f60\u5728\u6ca1\u6709\u8d29\u5974\u8bb8\u53ef\u7684\u60c5\u51b5\u4e0b\u65e0\u6cd5\u8d2d\u4e70\u6b64\u9879\u5347\u7ea7\uff01");
        }
        return this.getExtraConditionalAvailability(cell);
    }

    public Util.Value<Boolean, String> getRemovalAvailability(Cell cell) {
        if (this.isCoreRoomUpgrade()) {
            return new Util.Value<Boolean, String>(false, "\u4f60\u65e0\u6cd5\u76f4\u63a5\u79fb\u9664\u6838\u5fc3\u5347\u7ea7\u3002\u4f5c\u4e3a\u66ff\u4ee3\uff0c\u4f60\u53ef\u4ee5\u8d2d\u4e70\u5176\u4ed6\u7684\u6838\u5fc3\u6a21\u5757\u4ee5\u66ff\u6362\u73b0\u6709\u7684\u6838\u5fc3\u3002");
        }
        return new Util.Value<Boolean, String>(true, "");
    }

    public boolean isSlaverUpgrade() {
        return true;
    }

    public boolean isCoreRoomUpgrade() {
        return this.isCoreRoomUpgrade;
    }

    public ImmobilisationType getImmobilisationType() {
        return null;
    }

    public Colour getColour() {
        return this.colour;
    }

    public String getName() {
        return this.name;
    }

    public String getRoomDescription(Cell c) {
        return this.roomDescription;
    }

    public String getDescriptionForPurchase() {
        return this.descriptionForPurchase;
    }

    public String getDescriptionAfterPurchase() {
        return this.descriptionAfterPurchase;
    }

    public String getSVGOverride() {
        return null;
    }

    public int getInstallCost() {
        if (Main.game.getPlayer().hasTrait(Perk.JOB_PLAYER_CONSTRUCTION_WORKER, true)) {
            return this.installCost / 2;
        }
        return this.installCost;
    }

    public int getRemovalCost() {
        if (Main.game.getPlayer().hasTrait(Perk.JOB_PLAYER_CONSTRUCTION_WORKER, true)) {
            if (this.removalCost > 0) {
                return this.removalCost;
            }
            return Math.max(-(this.installCost / 2), this.removalCost);
        }
        return this.removalCost;
    }

    public int getUpkeep() {
        return this.upkeep;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public float getHourlyAffectionGain() {
        return this.affectionGain;
    }

    public float getHourlyObedienceGain() {
        return this.obedienceGain;
    }

    public List<AbstractPlaceUpgrade> getPrerequisites() {
        return this.prerequisites;
    }

    public boolean isPrerequisitesMet(GenericPlace place) {
        return place.getPlaceUpgrades().containsAll(this.prerequisites);
    }

    public void applyInstallationEffects(Cell c) {
    }

    public void applyRemovalEffects(Cell c) {
    }

    public DialogueNode getInstallationDialogue(Cell c) {
        return null;
    }

    public DialogueNode getRoomDialogue(Cell c) {
        return null;
    }
}

