/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.world.places;

import com.lilithsthrone.controller.xmlParsing.XMLUtil;
import com.lilithsthrone.game.Game;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.XMLSaving;
import com.lilithsthrone.utils.colours.Colour;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.EntranceType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.AbstractPlaceUpgrade;
import com.lilithsthrone.world.places.PlaceType;
import com.lilithsthrone.world.places.PlaceUpgrade;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenericPlace
implements XMLSaving {
    private String name;
    private AbstractPlaceType placeType;
    private Set<AbstractPlaceUpgrade> placeUpgrades;
    public static Map<AbstractPlaceType, Integer> placeCountMap = new ConcurrentHashMap<AbstractPlaceType, Integer>();

    public GenericPlace(AbstractPlaceType placeType) {
        this.placeType = placeType;
        this.placeUpgrades = new HashSet<AbstractPlaceUpgrade>();
        if (placeType != null) {
            placeCountMap.put(placeType, placeCountMap.getOrDefault(placeType, 0) + 1);
            String placeNameExtra = placeType.getPlaceNameAppendFormat(placeCountMap.get(placeType));
            if (placeNameExtra != null && !placeNameExtra.isEmpty()) {
                this.name = placeType.getName() + placeNameExtra;
            }
            this.placeUpgrades.addAll(placeType.getStartingPlaceUpgrades());
        } else {
            this.name = "";
        }
    }

    @Override
    public Element saveAsXML(Element parentElement, Document doc) {
        Element element = doc.createElement("place");
        parentElement.appendChild(element);
        if (!this.getName().equals(this.getPlaceType().getName())) {
            XMLUtil.addAttribute(doc, element, "name", this.getName());
        }
        XMLUtil.addAttribute(doc, element, "type", PlaceType.getIdFromPlaceType(this.getPlaceType()));
        if (!this.getPlaceUpgrades().isEmpty()) {
            Element innerElement = doc.createElement("placeUpgrades");
            element.appendChild(innerElement);
            for (AbstractPlaceUpgrade upgrade : this.getPlaceUpgrades()) {
                Element e = doc.createElement("upgrade");
                innerElement.appendChild(e);
                XMLUtil.addAttribute(doc, e, "type", PlaceUpgrade.getIdFromPlaceUpgrade(upgrade));
            }
        }
        return element;
    }

    public static GenericPlace loadFromXML(Element parentElement, Document doc, Cell c) {
        String placeType = parentElement.getAttribute("type");
        AbstractPlaceType pt = PlaceType.getPlaceTypeFromId(placeType);
        GenericPlace place = new GenericPlace(pt);
        if (!(parentElement.getAttribute("name").isEmpty() || Main.isVersionOlderThan(Game.loadingVersion, "0.3") && (place.getPlaceType().equals(PlaceType.DOMINION_EXIT_NORTH) || place.getPlaceType().equals(PlaceType.DOMINION_EXIT_SOUTH) || place.getPlaceType().equals(PlaceType.DOMINION_EXIT_EAST) || place.getPlaceType().equals(PlaceType.DOMINION_EXIT_WEST)))) {
            String name = parentElement.getAttribute("name");
            if (!pt.getName().equals(name)) {
                place.setName(name);
            }
        }
        try {
            if (parentElement.getElementsByTagName("placeUpgrades").getLength() > 0 && ((Element)parentElement.getElementsByTagName("placeUpgrades").item(0)).getElementsByTagName("upgrade").getLength() > 0) {
                ArrayList<AbstractPlaceUpgrade> coreUpgrades = new ArrayList<AbstractPlaceUpgrade>();
                ArrayList<AbstractPlaceUpgrade> upgrades = new ArrayList<AbstractPlaceUpgrade>();
                for (int i = 0; i < ((Element)parentElement.getElementsByTagName("placeUpgrades").item(0)).getElementsByTagName("upgrade").getLength(); ++i) {
                    Element e = (Element)((Element)parentElement.getElementsByTagName("placeUpgrades").item(0)).getElementsByTagName("upgrade").item(i);
                    String placeUpgradeId = e.getAttribute("type");
                    if (placeUpgradeId.equals("LILAYA_PLAYER_ROOM_BATH")) {
                        Cell.refundMoney += 300000;
                        continue;
                    }
                    AbstractPlaceUpgrade upgrade = PlaceUpgrade.getPlaceUpgradeFromId(placeUpgradeId);
                    if (upgrade.isCoreRoomUpgrade()) {
                        coreUpgrades.add(upgrade);
                        continue;
                    }
                    upgrades.add(upgrade);
                }
                place.getPlaceUpgrades().clear();
                for (AbstractPlaceUpgrade coreUpgrade : coreUpgrades) {
                    if (coreUpgrade == PlaceUpgrade.LILAYA_EMPTY_ROOM && coreUpgrades.size() > 1 || place.getPlaceUpgrades().contains(coreUpgrade)) continue;
                    if (place.addPlaceUpgrade(c, coreUpgrade)) break;
                    System.err.println("WARNING: Import of GenericPlace (" + String.valueOf(place.getPlaceType()) + ") was unable to add core upgrade: " + coreUpgrade.getName());
                }
                for (AbstractPlaceUpgrade upgrade : upgrades) {
                    if (place.getPlaceUpgrades().contains(upgrade) || place.addPlaceUpgrade(c, upgrade)) continue;
                    System.err.println("WARNING: Import of GenericPlace (" + String.valueOf(place.getPlaceType()) + ") was unable to add upgrade: " + upgrade.getName());
                }
            }
        }
        catch (Exception ex) {
            System.err.println("GenericPlace import error 1");
        }
        return place;
    }

    public boolean equals(Object o) {
        return o instanceof GenericPlace && ((GenericPlace)o).getPlaceType() == this.placeType && ((GenericPlace)o).getPlaceUpgrades().equals(this.placeUpgrades);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.placeType.hashCode();
        result = 31 * result + this.placeUpgrades.hashCode();
        return result;
    }

    public String getName() {
        if ((this.name == null || this.name.isEmpty()) && this.getPlaceType() != null) {
            return this.getPlaceType().getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Colour getColour() {
        if (this.getPlaceUpgrades().stream().anyMatch(up -> up.isCoreRoomUpgrade())) {
            return ((AbstractPlaceUpgrade)this.getPlaceUpgrades().stream().filter(up -> up.isCoreRoomUpgrade()).collect(Collectors.toList()).get(0)).getColour();
        }
        return this.placeType.getColour();
    }

    public DialogueNode getDialogue(Cell c, boolean withRandomEncounter) {
        return this.getDialogue(c, withRandomEncounter, false);
    }

    public DialogueNode getDialogue(Cell c, boolean withRandomEncounter, boolean forceEncounter) {
        return this.placeType.getDialogue(c, withRandomEncounter, forceEncounter);
    }

    public boolean isPopulated() {
        return this.placeType.isPopulated();
    }

    public boolean isDangerous() {
        return this.placeType.isDangerous();
    }

    public boolean isStormImmune() {
        return this.placeType.isStormImmune();
    }

    public boolean isItemsDisappear() {
        return this.placeType.isItemsDisappear();
    }

    public String getSVGString() {
        return this.placeType.getSVGString(this.placeUpgrades);
    }

    public AbstractPlaceType getParentPlaceType() {
        return this.placeType.getParentPlaceType();
    }

    public EntranceType getParentAlignment() {
        return this.placeType.getParentAlignment();
    }

    public boolean addPlaceUpgrade(Cell c, AbstractPlaceUpgrade upgrade) {
        if (this.placeUpgrades.add(upgrade)) {
            upgrade.applyInstallationEffects(c);
            return true;
        }
        return false;
    }

    public boolean removePlaceUpgrade(Cell c, AbstractPlaceUpgrade upgrade) {
        if (this.placeUpgrades.remove(upgrade)) {
            upgrade.applyRemovalEffects(c);
            return true;
        }
        return false;
    }

    public boolean isAbleToBeUpgraded() {
        return this.placeType.isAbleToBeUpgraded();
    }

    public Set<AbstractPlaceUpgrade> getPlaceUpgrades() {
        return this.placeUpgrades;
    }

    public boolean isSlaveCell() {
        for (AbstractPlaceUpgrade upgrade : this.placeUpgrades) {
            if (!upgrade.isCoreRoomUpgrade() || !upgrade.isSlaverUpgrade()) continue;
            return true;
        }
        return false;
    }

    public int getCapacity() {
        int c = 0;
        for (AbstractPlaceUpgrade pu : this.placeUpgrades) {
            c += pu.getCapacity();
        }
        return c;
    }

    public int getUpkeep() {
        int upkeep = 0;
        for (AbstractPlaceUpgrade pu : this.placeUpgrades) {
            upkeep += pu.getUpkeep();
        }
        if (upkeep < 0) {
            return 0;
        }
        return upkeep;
    }

    public float getHourlyAffectionChange() {
        float affectionChange = 0.0f;
        for (AbstractPlaceUpgrade pu : this.placeUpgrades) {
            affectionChange += pu.getHourlyAffectionGain();
        }
        return affectionChange;
    }

    public float getHourlyObedienceChange() {
        float obedienceChange = 0.0f;
        for (AbstractPlaceUpgrade pu : this.placeUpgrades) {
            obedienceChange += pu.getHourlyObedienceGain();
        }
        return obedienceChange;
    }

    public AbstractPlaceType getPlaceType() {
        return this.placeType;
    }

    public void setPlaceType(AbstractPlaceType placeType) {
        this.placeType = placeType;
    }
}

