/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.world.places;

import com.lilithsthrone.game.character.effects.StatusEffect;
import com.lilithsthrone.game.character.fetishes.Fetish;
import com.lilithsthrone.game.character.npc.dominion.Arthur;
import com.lilithsthrone.game.character.npc.dominion.Lilaya;
import com.lilithsthrone.game.character.quests.Quest;
import com.lilithsthrone.game.character.quests.QuestLine;
import com.lilithsthrone.game.dialogue.DialogueFlagValue;
import com.lilithsthrone.game.dialogue.DialogueNode;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.Lab;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.LilayaDiningHallDialogue;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.LilayaDressingRoomDialogue;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.LilayaMilkingRoomDialogue;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.LilayaOfficeDialogue;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.LilayaSlaveLoungeDialogue;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.LilayaSpa;
import com.lilithsthrone.game.dialogue.places.dominion.lilayashome.RoomArthur;
import com.lilithsthrone.game.occupantManagement.MilkingRoom;
import com.lilithsthrone.game.occupantManagement.slave.SlavePermissionSetting;
import com.lilithsthrone.game.sex.ImmobilisationType;
import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Units;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.utils.colours.PresetColour;
import com.lilithsthrone.world.Cell;
import com.lilithsthrone.world.WorldType;
import com.lilithsthrone.world.places.AbstractPlaceType;
import com.lilithsthrone.world.places.AbstractPlaceUpgrade;
import com.lilithsthrone.world.places.GenericPlace;
import com.lilithsthrone.world.places.PlaceType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlaceUpgrade {
    public static final AbstractPlaceUpgrade SLAVERY_ADMINISTRATION_CELLS;
    public static final AbstractPlaceUpgrade LILAYA_EMPTY_ROOM;
    public static final AbstractPlaceUpgrade LILAYA_ARTHUR_ROOM;
    public static final AbstractPlaceUpgrade LILAYA_PLAYER_ROOM_BED;
    public static final AbstractPlaceUpgrade LILAYA_DOLL_CLOSET;
    public static final AbstractPlaceUpgrade LILAYA_GUEST_ROOM;
    public static final AbstractPlaceUpgrade LILAYA_SLAVE_ROOM;
    public static final AbstractPlaceUpgrade LILAYA_SLAVE_ROOM_DOUBLE;
    public static final AbstractPlaceUpgrade LILAYA_SLAVE_ROOM_QUADRUPLE;
    public static final AbstractPlaceUpgrade LILAYA_SLAVE_ROOM_DOWNGRADE_BED;
    public static final AbstractPlaceUpgrade LILAYA_SLAVE_ROOM_UPGRADE_BED;
    public static final AbstractPlaceUpgrade LILAYA_SLAVE_ROOM_OBEDIENCE_TRAINER;
    public static final AbstractPlaceUpgrade LILAYA_SLAVE_ROOM_DOG_BOWLS;
    public static final AbstractPlaceUpgrade LILAYA_SLAVE_ROOM_ROOM_SERVICE;
    public static final AbstractPlaceUpgrade LILAYA_SLAVE_ROOM_ARCANE_INSTRUMENTS;
    public static final AbstractPlaceUpgrade LILAYA_DUNGEON_CELL;
    public static final AbstractPlaceUpgrade LILAYA_DUNGEON_CELL_DOWNGRADE_BED;
    public static final AbstractPlaceUpgrade LILAYA_DUNGEON_CELL_UPGRADE_BED;
    public static final AbstractPlaceUpgrade LILAYA_DUNGEON_CELL_DOG_BOWLS;
    public static final AbstractPlaceUpgrade LILAYA_DUNGEON_CELL_DECENT_FOOD;
    public static final AbstractPlaceUpgrade LILAYA_DUNGEON_CELL_ROPES;
    public static final AbstractPlaceUpgrade LILAYA_DUNGEON_CELL_CHAINS;
    public static final AbstractPlaceUpgrade LILAYA_MILKING_ROOM;
    public static final AbstractPlaceUpgrade LILAYA_MILKING_ROOM_ARTISAN_MILKERS;
    public static final AbstractPlaceUpgrade LILAYA_MILKING_ROOM_INDUSTRIAL_MILKERS;
    public static final AbstractPlaceUpgrade LILAYA_MILKING_ROOM_MILK_EFFICIENCY;
    public static final AbstractPlaceUpgrade LILAYA_MILKING_ROOM_CUM_EFFICIENCY;
    public static final AbstractPlaceUpgrade LILAYA_MILKING_ROOM_GIRLCUM_EFFICIENCY;
    public static final AbstractPlaceUpgrade LILAYA_OFFICE;
    public static final AbstractPlaceUpgrade LILAYA_OFFICE_EXECUTIVE_UPGRADE;
    public static final AbstractPlaceUpgrade LILAYA_OFFICE_COFFEE_MACHINE;
    public static final AbstractPlaceUpgrade LILAYA_OFFICE_PARTITIONING_WALLS;
    public static final AbstractPlaceUpgrade LILAYA_DRESSING_ROOM;
    public static final AbstractPlaceUpgrade LILAYA_DRESSING_ROOM_LYSSIETH_WARDROBE;
    public static final AbstractPlaceUpgrade LILAYA_SPA;
    public static final AbstractPlaceUpgrade LILAYA_SPA_SAUNA;
    public static final AbstractPlaceUpgrade LILAYA_SPA_POOL;
    public static final AbstractPlaceUpgrade LILAYA_SPA_BAR;
    public static final AbstractPlaceUpgrade LILAYA_DINING_HALL;
    public static final AbstractPlaceUpgrade LILAYA_SLAVE_LOUNGE;
    private static ArrayList<AbstractPlaceUpgrade> coreRoomUpgrades;
    private static ArrayList<AbstractPlaceUpgrade> guestRoomUpgrades;
    private static ArrayList<AbstractPlaceUpgrade> dungeonCellUpgrades;
    private static ArrayList<AbstractPlaceUpgrade> slaveQuartersUpgradesSingle;
    private static ArrayList<AbstractPlaceUpgrade> slaveQuartersUpgradesDouble;
    private static ArrayList<AbstractPlaceUpgrade> slaveQuartersUpgradesQuadruple;
    private static ArrayList<AbstractPlaceUpgrade> milkingRoomUpgrades;
    private static ArrayList<AbstractPlaceUpgrade> officeUpgrades;
    private static ArrayList<AbstractPlaceUpgrade> spaUpgrades;
    private static ArrayList<AbstractPlaceUpgrade> diningHallUpgrades;
    private static ArrayList<AbstractPlaceUpgrade> slaveLoungeUpgrades;
    private static ArrayList<AbstractPlaceUpgrade> dressingRoomUpgrades;
    private static List<AbstractPlaceUpgrade> allPlaceUpgrades;
    private static Map<AbstractPlaceUpgrade, String> placeUpgradeToIdMap;
    private static Map<String, AbstractPlaceUpgrade> idToPlaceUpgradeMap;

    public static ArrayList<AbstractPlaceUpgrade> getCoreRoomUpgrades() {
        return coreRoomUpgrades;
    }

    public static ArrayList<AbstractPlaceUpgrade> getGuestRoomUpgrades() {
        return guestRoomUpgrades;
    }

    public static ArrayList<AbstractPlaceUpgrade> getDungeonCellUpgrades() {
        return dungeonCellUpgrades;
    }

    public static ArrayList<AbstractPlaceUpgrade> getSlaveQuartersUpgradesSingle() {
        return slaveQuartersUpgradesSingle;
    }

    public static ArrayList<AbstractPlaceUpgrade> getSlaveQuartersUpgradesDouble() {
        return slaveQuartersUpgradesDouble;
    }

    public static ArrayList<AbstractPlaceUpgrade> getSlaveQuartersUpgradesQuadruple() {
        return slaveQuartersUpgradesQuadruple;
    }

    public static ArrayList<AbstractPlaceUpgrade> getMilkingUpgrades() {
        return milkingRoomUpgrades;
    }

    public static ArrayList<AbstractPlaceUpgrade> getOfficeUpgrades() {
        return officeUpgrades;
    }

    public static ArrayList<AbstractPlaceUpgrade> getSpaUpgrades() {
        return spaUpgrades;
    }

    public static ArrayList<AbstractPlaceUpgrade> getDiningHallUpgrades() {
        return diningHallUpgrades;
    }

    public static ArrayList<AbstractPlaceUpgrade> getSlaveLoungeUpgrades() {
        return slaveLoungeUpgrades;
    }

    public static ArrayList<AbstractPlaceUpgrade> getDressingRoomUpgrades() {
        return dressingRoomUpgrades;
    }

    public static List<AbstractPlaceUpgrade> getAllPlaceUpgrades() {
        return allPlaceUpgrades;
    }

    public static AbstractPlaceUpgrade getPlaceUpgradeFromId(String id) {
        id = Util.getClosestStringMatch(id, idToPlaceUpgradeMap.keySet());
        return idToPlaceUpgradeMap.get(id);
    }

    public static String getIdFromPlaceUpgrade(AbstractPlaceUpgrade placeType) {
        return placeUpgradeToIdMap.get(placeType);
    }

    static {
        Field[] fields;
        SLAVERY_ADMINISTRATION_CELLS = new AbstractPlaceUpgrade(true, PresetColour.GENERIC_ARCANE, "\u53ee\u5f53\u4f5c\u54cd\u7684\u9694\u95f4", "-", "", "\u82ac\u5947\u6ca1\u6709\u82b1\u4efb\u4f55\u7cbe\u529b\u6765\u7ef4\u62a4\u5974\u96b6\u7ba1\u7406\u5c40\u4e0b\u9762\u7684\u7262\u623f\uff0c\u56e0\u6b64\uff0c\u4efb\u4f55\u88ab\u5173\u5728\u8fd9\u91cc\u7684\u5974\u96b6\u90fd\u4f1a\u5f88\u5feb\u5931\u53bb\u4ed6\u4eec\u7684\u597d\u611f\u548c\u670d\u4ece\u3002", 200, 0, 0, 1000, -0.5f, -0.5f, null){};
        LILAYA_EMPTY_ROOM = new AbstractPlaceUpgrade(true, PresetColour.BASE_GREY, "\u7a7a\u623f\u95f4", "\u841d\u4e1d\u4f1a\u628a\u8fd9\u4e2a\u623f\u95f4\u6062\u590d\u539f\u72b6\uff0c\u8fd9\u6837\u5c31\u4e0d\u9002\u5408\u4f60\u7684\u5974\u96b6\u5c45\u4f4f\u4e86\u3002", "\u8fd9\u4e2a\u623f\u95f4\u662f\u7a7a\u7684\uff0c\u5982\u679c\u4f60\u60f3\u628a\u4f60\u7684\u5974\u96b6\u5b89\u7f6e\u5728\u8fd9\u91cc\uff0c\u5c31\u9700\u8981\u8fdb\u884c\u6539\u9020\u3002", "\u8fd9\u95f4\u623f\u6ca1\u4eba\u5165\u4f4f\u3002\u5c3d\u7ba1\u88ab\u841d\u4e1d\u6253\u626b\u5f97\u5e72\u51c0\u6574\u6d01\uff0c\u4e00\u5c18\u4e0d\u67d3\uff0c\u4f46\u9057\u61be\u7684\u662f\uff0c\u8fd9\u95f4\u623f\u4f3c\u4e4e\u5e76\u6ca1\u6709\u53d1\u6325\u51fa\u5b83\u5e94\u6709\u7684\u6f5c\u529b\u2026\u2026", 2000, 0, 0, 0, 0.0f, 0.0f, null){

            @Override
            public boolean isSlaverUpgrade() {
                return false;
            }

            @Override
            public void applyInstallationEffects(Cell c) {
                GenericPlace place = c.getPlace();
                if (place.getPlaceUpgrades().contains(LILAYA_MILKING_ROOM)) {
                    Main.game.getOccupancyUtil().removeMilkingRoom(Main.game.getOccupancyUtil().getMilkingRoom(c.getType(), c.getLocation()));
                }
                for (AbstractPlaceUpgrade upgrade : PlaceUpgrade.getAllPlaceUpgrades()) {
                    if (upgrade == LILAYA_EMPTY_ROOM) continue;
                    place.removePlaceUpgrade(c, upgrade);
                }
            }

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_ARTHUR_ROOM)) {
                    return new Util.Value<Boolean, String>(false, "");
                }
                boolean nonCompanionCharactersPresent = false;
                if (cell.getCharactersPresentIds() != null) {
                    for (String id : cell.getCharactersPresentIds()) {
                        if (id.equals(Main.game.getPlayer().getId()) || Main.game.getPlayer().getCompanionsId().contains(id)) continue;
                        nonCompanionCharactersPresent = true;
                    }
                }
                if (!Main.game.getCharactersTreatingCellAsHome(cell).isEmpty() || nonCompanionCharactersPresent) {
                    return new Util.Value<Boolean, String>(false, "\u6539\u9020\u6216\u51fa\u552e\u5f00\u59cb\u524d\uff0c\u8fd9\u4e2a\u623f\u95f4\u9700\u8981\u88ab\u6e05\u7a7a\u5e76\u4e14\u95f2\u7f6e\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }
        };
        LILAYA_ARTHUR_ROOM = new AbstractPlaceUpgrade(true, PresetColour.RACE_HUMAN, "\u4e9a\u745f\u7684\u623f\u95f4", "\u5e2e\u841d\u4e1d\u628a\u5965\u672f\u4f7f\u7528\u4eea\u5668\u79fb\u52a8\u5230\u8be5\u623f\u95f4\u4ee5\u4fbf\u4e8e\u8ba9\u623f\u95f4\u66f4\u9002\u5408\u4e9a\u745f\u5c45\u4f4f\u3002<b>\u8fd9\u662f\u4e2a\u6c38\u4e45\u7684\u4fee\u6539\uff0c\u5e76\u4e14\u65e0\u6cd5\u64a4\u9500\uff01</b>", "\u8fd9\u4e2a\u623f\u95f4\u73b0\u5728\u5c5e\u4e8e\u4e9a\u745f\uff0c\u4ed6\u628a\u5b83\u5f53\u4f5c\u81ea\u5df1\u7684\u4e2a\u4eba\u5b9e\u9a8c\u5ba4\u517c\u5367\u5ba4\u3002", "\u8fd9\u95f4\u623f\u6ca1\u4eba\u5165\u4f4f\u3002\u5c3d\u7ba1\u88ab\u841d\u4e1d\u6253\u626b\u5f97\u5e72\u51c0\u6574\u6d01\uff0c\u4e00\u5c18\u4e0d\u67d3\uff0c\u4f46\u9057\u61be\u7684\u662f\uff0c\u8fd9\u95f4\u623f\u4f3c\u4e4e\u5e76\u6ca1\u6709\u53d1\u6325\u51fa\u5b83\u5e94\u6709\u7684\u6f5c\u529b\u2026\u2026", 0, 0, 0, 0, 0.0f, 0.0f, null){

            @Override
            public DialogueNode getInstallationDialogue(Cell c) {
                return RoomArthur.ROOM_ARTHUR_INSTALLATION;
            }

            @Override
            public void applyInstallationEffects(Cell c) {
                GenericPlace place = c.getPlace();
                place.setPlaceType(PlaceType.LILAYA_HOME_ARTHUR_ROOM);
                for (AbstractPlaceUpgrade upgrade : PlaceUpgrade.getAllPlaceUpgrades()) {
                    if (upgrade == LILAYA_ARTHUR_ROOM) continue;
                    place.removePlaceUpgrade(c, upgrade);
                }
                c.getPlace().setName("\u4e9a\u745f\u7684\u623f\u95f4");
                if (Main.game.isStarted()) {
                    Main.game.getNpc(Arthur.class).setLocation(c.getType(), c.getLocation(), true);
                }
            }

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (Main.game.getPlayer().isQuestProgressLessThan(QuestLine.MAIN, Quest.MAIN_2_A_INTO_THE_DEPTHS) || !Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCells(LILAYA_ARTHUR_ROOM).isEmpty() || !Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_FIRST_FLOOR).getCells(LILAYA_ARTHUR_ROOM).isEmpty()) {
                    return new Util.Value<Boolean, String>(false, "");
                }
                if (!Main.game.getCharactersTreatingCellAsHome(cell).isEmpty()) {
                    return new Util.Value<Boolean, String>(false, "\u6539\u9020\u5f00\u59cb\u524d\uff0c\u8fd9\u4e2a\u623f\u95f4\u9700\u8981\u88ab\u6e05\u7a7a\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }
        };
        LILAYA_PLAYER_ROOM_BED = new AbstractPlaceUpgrade(false, PresetColour.BASE_GOLD, "\u5e1d\u7687\u5c3a\u5bf8\u7684\u5e8a", "\u5c06\u4f60\u73b0\u5728\u7684\u7279\u5927\u53f7\u5e8a\u6362\u6210\u4e00\u5f20\u5de8\u5927\u7684\u201c\u5e1d\u7687\u5c3a\u5bf8\u5e8a\u201d\u3002[style.italicsGood(\u8fd9\u5c06\u63d0\u9ad8\u5728\u623f\u95f4\u91cc\u4f11\u606f\u6240\u83b7\u5f97\u7684\u201c\u5145\u5206\u4f11\u606f\u201d\u52a0\u6210\u3002)]", "\u539f\u6765\u7684\u7279\u5927\u53f7\u5e8a\u88ab\u5de8\u5927\u7684\u201c\u5e1d\u7687\u5c3a\u5bf8\u5e8a\u201d\u6240\u53d6\u4ee3\u3002[style.italicsGood(\u5728\u8be5\u623f\u95f4\u4f11\u606f\u4f1a\u83b7\u5f97\u589e\u5f3a\u7684\u201c\u5145\u5206\u4f11\u606f\u201d\u72b6\u6001\uff01)]", "\u539f\u6765\u7684\u7279\u5927\u53f7\u5e8a\u88ab\u5de8\u5927\u7684\u201c\u5e1d\u7687\u5c3a\u5bf8\u5e8a\u201d\u6240\u53d6\u4ee3\uff0c\u9760\u7740\u5899\u4e5f\u975e\u5e38\u62a2\u773c\u3002\u8212\u9002\u7684\u5e8a\u57ab\u3001\u677e\u8f6f\u7684\u6795\u5934\u548c\u6e29\u6696\u7684\u7fbd\u7ed2\u88ab\u786e\u4fdd\u4f60\u5728\u7761\u8fc7\u4e4b\u540e\u603b\u662f\u611f\u89c9\u5145\u5206\u4f11\u606f\u4e86\u3002", 10000, -5000, 0, 0, 0.2f, -0.1f, null){

            @Override
            public Util.Value<Boolean, String> getAvailability(Cell cell) {
                return new Util.Value<Boolean, String>(true, "");
            }
        };
        LILAYA_DOLL_CLOSET = new AbstractPlaceUpgrade(true, PresetColour.GENERIC_ARCANE, "\u73a9\u5076\u8d2e\u85cf\u5ba4", "\u841d\u4e1d\u4f1a\u6e05\u7a7a\u8fd9\u4e2a\u623f\u95f4\u7684\u5bb6\u5177\uff0c\u7528\u4e8e\u50a8\u5b58\u4f60\u62e5\u6709\u7684\u6240\u6709\u6027\u7231\u73a9\u5076\u3002", "\u8fd9\u4e2a\u623f\u95f4\u5df2\u7ecf\u88ab\u6539\u88c5\u6210\u9002\u5408\u653e\u7f6e\u6027\u7231\u73a9\u5076\u7684\u5730\u65b9\u3002", "\u4f60\u5df2\u7ecf\u6e05\u7a7a\u4e86\u8fd9\u4e2a\u623f\u95f4\uff0c\u5982\u6b64\u4e00\u6765\u5c31\u80fd\u591f\u50a8\u5b58\u4f60\u62e5\u6709\u7684\u6240\u6709\u6027\u7231\u73a9\u5076\u3002", 250, 0, 0, 12, 0.0f, 0.0f, null){

            @Override
            public boolean isSlaverUpgrade() {
                return false;
            }

            @Override
            public String getSVGOverride() {
                return AbstractPlaceType.getSVGOverride("dominion/lilayasHome/roomDoll", PresetColour.RACE_DOLL, PresetColour.BASE_WHITE, PresetColour.BASE_WHITE);
            }

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_ARTHUR_ROOM)) {
                    return new Util.Value<Boolean, String>(false, "");
                }
                if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_DOLL_STORAGE)) {
                    return new Util.Value<Boolean, String>(false, "\u8981\u5b89\u88c5\u4e00\u95f4\u73a9\u5076\u8d2e\u85cf\u5ba4\uff0c\u4f60\u9700\u8981\u5148\u5f81\u5f97\u8389\u83b1\u96c5\u7684\u540c\u610f\u624d\u80fd\u8fdb\u884c\u5347\u7ea7\u3002");
                }
                if (!Main.game.getCharactersTreatingCellAsHome(cell).isEmpty()) {
                    return new Util.Value<Boolean, String>(false, "\u6539\u9020\u5f00\u59cb\u524d\uff0c\u8fd9\u4e2a\u623f\u95f4\u9700\u8981\u88ab\u6e05\u7a7a\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }

            @Override
            public void applyInstallationEffects(Cell c) {
                GenericPlace place = c.getPlace();
                for (AbstractPlaceUpgrade upgrade : PlaceUpgrade.getAllPlaceUpgrades()) {
                    if (upgrade == LILAYA_DOLL_CLOSET) continue;
                    place.removePlaceUpgrade(c, upgrade);
                }
            }
        };
        LILAYA_GUEST_ROOM = new AbstractPlaceUpgrade(true, PresetColour.GENERIC_ARCANE, "\u5ba2\u623f", "\u841d\u4e1d\u5c06\u4e3a\u4f60\u7684\u4e00\u4f4d\u5ba2\u4eba\u51c6\u5907\u8fd9\u4e2a\u623f\u95f4\uff0c\u4f7f\u5176\u9002\u5408\u4e00\u4e2a\u4eba\u5c45\u4f4f\u3002\u867d\u7136\u8fd9\u4e0d\u662f\u6700\u7ecf\u6d4e\u7684\u9009\u62e9\uff0c\u4f46\u8fd9\u4e2a\u623f\u95f4\u7684\u4f4f\u5ba2\u65e0\u7591\u4f1a\u559c\u6b22\u62e5\u6709\u81ea\u5df1\u7684\u79c1\u4eba\u7a7a\u95f4\u3002", "\u8fd9\u4e2a\u623f\u95f4\u5df2\u88ab\u6539\u88c5\u6210\u9002\u5408\u4f60\u7684\u5ba2\u4eba\u5c45\u4f4f\u7684\u5730\u65b9\u3002", "\u4f60\u5df2\u4ed8\u8d39\u5c06\u8fd9\u95f4\u5ba2\u623f\u6539\u5efa\u4e3a\u57fa\u672c\u5ba2\u623f\u3002\u4e00\u5f20\u94fa\u7740\u7d20\u767d\u7fbd\u7ed2\u88ab\u7684\u5355\u4eba\u5e8a\u9760\u5728\u4e00\u9762\u5899\u8fb9\u3002\u5e8a\u8fb9\u6709\u4e00\u4e2a\u7b80\u5355\u7684\u5e8a\u5934\u67dc\uff0c\u4e0a\u9762\u6709\u4e00\u76cf\u5965\u672f\u53f0\u706f\u3002\u9664\u6b64\u4e4b\u5916\uff0c\u5176\u4ed6\u5bb6\u5177\u5c31\u53ea\u6709\u4e00\u4e2a\u6728\u5236\u8863\u67dc\u548c\u62bd\u5c49\u67dc\u3002", 2000, 0, 100, 1, 0.0f, 0.0f, null){

            @Override
            public String getSVGOverride() {
                return AbstractPlaceType.getSVGOverride("dominion/lilayasHome/roomGuest", PresetColour.BASE_GREEN_LIGHT);
            }

            @Override
            public boolean isSlaverUpgrade() {
                return false;
            }

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_ARTHUR_ROOM)) {
                    return new Util.Value<Boolean, String>(false, "");
                }
                if (!Main.game.getPlayer().isQuestCompleted(QuestLine.SIDE_ACCOMMODATION)) {
                    return new Util.Value<Boolean, String>(false, "\u8981\u5b89\u88c5\u4e00\u95f4\u5ba2\u5367\uff0c\u4f60\u9700\u8981\u5148\u627e\u4e00\u4e2a\u4eba\u9080\u8bf7\u4ed6\u548c\u4f60\u4e00\u8d77\u4f4f\uff0c\u7136\u540e\u5f81\u5f97\u8389\u83b1\u96c5\u7684\u540c\u610f\u624d\u80fd\u8fdb\u884c\u5347\u7ea7\u3002");
                }
                if (!Main.game.getCharactersTreatingCellAsHome(cell).isEmpty()) {
                    return new Util.Value<Boolean, String>(false, "\u6539\u9020\u6216\u51fa\u552e\u5f00\u59cb\u524d\uff0c\u8fd9\u4e2a\u623f\u95f4\u9700\u8981\u88ab\u6e05\u7a7a\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }

            @Override
            public void applyInstallationEffects(Cell c) {
                GenericPlace place = c.getPlace();
                for (AbstractPlaceUpgrade upgrade : PlaceUpgrade.getAllPlaceUpgrades()) {
                    if (upgrade == LILAYA_GUEST_ROOM) continue;
                    place.removePlaceUpgrade(c, upgrade);
                }
            }
        };
        LILAYA_SLAVE_ROOM = new AbstractPlaceUpgrade(true, PresetColour.GENERIC_ARCANE, "\u5974\u96b6\u623f", "\u841d\u4e1d\u4f1a\u50cf\u5979\u5bf9\u5f85\u4efb\u4f55\u5176\u4ed6\u5ba2\u4eba\u90a3\u6837\u51c6\u5907\u8fd9\u4e2a\u623f\u95f4\uff0c\u4f7f\u5176\u9002\u5408\u4e3a\u4e00\u4f4d\u4f60\u7684\u5974\u96b6\u5c45\u4f4f\u3002\u5982\u679c\u4f60\u6253\u7b97\u62e5\u6709\u5927\u91cf\u5974\u96b6\uff0c\u8fd9\u867d\u7136\u4e0d\u662f\u6700\u7ecf\u6d4e\u7684\u9009\u62e9\uff0c\u4f46\u8fd9\u4e2a\u623f\u95f4\u7684\u4f4f\u5ba2\u65e0\u7591\u4f1a\u559c\u6b22\u62e5\u6709\u81ea\u5df1\u7684\u79c1\u4eba\u7a7a\u95f4\u3002", "\u8fd9\u4e2a\u623f\u95f4\u5df2\u88ab\u6539\u5efa\u6210\u9002\u5408\u5b89\u7f6e\u4f60\u7684\u4e00\u540d\u5974\u96b6\u7684\u5730\u65b9\u3002", "\u4f60\u4ed8\u94b1\u5c06\u8fd9\u4e2a\u623f\u95f4\u6539\u88c5\u6210\u4e86\u57fa\u672c\u5974\u96b6\u5bbf\u820d\u3002\u4e00\u5f20\u94fa\u7740\u7d20\u767d\u7fbd\u7ed2\u88ab\u7684\u5355\u4eba\u5e8a\u9760\u5728\u4e00\u9762\u5899\u8fb9\u3002\u5e8a\u8fb9\u6709\u4e00\u4e2a\u7b80\u5355\u7684\u5e8a\u5934\u67dc\uff0c\u4e0a\u9762\u6709\u4e00\u76cf\u5965\u672f\u53f0\u706f\u3002\u9664\u6b64\u4e4b\u5916\uff0c\u5176\u4ed6\u5bb6\u5177\u5c31\u53ea\u6709\u4e00\u4e2a\u6728\u5236\u8863\u67dc\u548c\u62bd\u5c49\u67dc\u3002", 2000, 0, 100, 1, 0.0f, 0.0f, null){

            @Override
            public String getSVGOverride() {
                return AbstractPlaceType.getSVGOverride("dominion/lilayasHome/roomSlave", PresetColour.BASE_CRIMSON);
            }

            @Override
            public String getRoomDescription(Cell c) {
                GenericPlace place = c.getPlace();
                if (place.getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM_UPGRADE_BED)) {
                    return "\u4f60\u4ed8\u94b1\u5c06\u8fd9\u4e2a\u623f\u95f4\u6539\u88c5\u6210\u4e86\u57fa\u672c\u5974\u96b6\u5bbf\u820d\u3002\u4e00\u5f20\u8212\u9002\u7684\uff0c\u94fa\u7740\u6e29\u6696\u677e\u8f6f\u7684\u7fbd\u7ed2\u88ab\u7684\u53cc\u4eba\u5e8a\u9760\u5728\u4e00\u9762\u5899\u8fb9\u3002\u5e8a\u8fb9\u6709\u4e00\u4e2a\u7b80\u5355\u7684\u5e8a\u5934\u67dc\uff0c\u4e0a\u9762\u6709\u4e00\u76cf\u5965\u672f\u53f0\u706f\u3002\u9664\u6b64\u4e4b\u5916\uff0c\u8fd9\u91cc\u53ea\u6709\u4e00\u4e2a\u6728\u5236\u8863\u67dc\u548c\u62bd\u5c49\u67dc\u3002";
                }
                if (place.getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM_DOWNGRADE_BED)) {
                    return "\u4f60\u4ed8\u94b1\u5c06\u8fd9\u4e2a\u623f\u95f4\u6539\u88c5\u6210\u4e86\u57fa\u672c\u5974\u96b6\u5bbf\u820d\u3002\u4e00\u5f20\u94fa\u7740\u4e00\u5f20\u8584\u6bef\u5b50\u7684\u4e0d\u8212\u9002\u7684\u5355\u4eba\u5e8a\u9760\u5728\u4e00\u9762\u5899\u8fb9\u3002\u5e8a\u8fb9\u6709\u4e00\u4e2a\u7b80\u5355\u7684\u5e8a\u5934\u67dc\uff0c\u4e0a\u9762\u6709\u4e00\u76cf\u5965\u672f\u53f0\u706f\u3002\u9664\u6b64\u4e4b\u5916\uff0c\u8fd9\u91cc\u53ea\u6709\u4e00\u4e2a\u6728\u5236\u8863\u67dc\u548c\u62bd\u5c49\u67dc\u3002";
                }
                return "\u4f60\u4ed8\u94b1\u5c06\u8fd9\u4e2a\u623f\u95f4\u6539\u88c5\u6210\u4e86\u57fa\u672c\u5974\u96b6\u5bbf\u820d\u3002\u4e00\u5f20\u94fa\u7740\u7d20\u767d\u7fbd\u7ed2\u88ab\u7684\u5355\u4eba\u5e8a\u9760\u5728\u4e00\u9762\u5899\u8fb9\u3002\u5e8a\u8fb9\u6709\u4e00\u4e2a\u7b80\u5355\u7684\u5e8a\u5934\u67dc\uff0c\u4e0a\u9762\u6709\u4e00\u76cf\u5965\u672f\u53f0\u706f\u3002\u9664\u6b64\u4e4b\u5916\uff0c\u8fd9\u91cc\u53ea\u6709\u4e00\u4e2a\u6728\u5236\u8863\u67dc\u548c\u62bd\u5c49\u67dc\u3002";
            }

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_ARTHUR_ROOM)) {
                    return new Util.Value<Boolean, String>(false, "");
                }
                if (!Main.game.getCharactersTreatingCellAsHome(cell).isEmpty()) {
                    return new Util.Value<Boolean, String>(false, "\u6539\u9020\u5f00\u59cb\u524d\uff0c\u8fd9\u4e2a\u623f\u95f4\u9700\u8981\u88ab\u6e05\u7a7a\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }

            @Override
            public void applyInstallationEffects(Cell c) {
                GenericPlace place = c.getPlace();
                for (AbstractPlaceUpgrade upgrade : PlaceUpgrade.getAllPlaceUpgrades()) {
                    if (upgrade == LILAYA_SLAVE_ROOM) continue;
                    place.removePlaceUpgrade(c, upgrade);
                }
            }
        };
        LILAYA_SLAVE_ROOM_DOUBLE = new AbstractPlaceUpgrade(true, PresetColour.BASE_MAGENTA, "\u53cc\u4eba\u5974\u96b6\u623f", "\u841d\u4e1d\u4f1a\u50cf\u5979\u5bf9\u5f85\u4efb\u4f55\u5176\u4ed6\u5ba2\u4eba\u90a3\u6837\u51c6\u5907\u8fd9\u4e2a\u623f\u95f4\uff0c\u4f7f\u5176\u9002\u5408\u4e3a\u4e24\u4f4d\u4f60\u7684\u5974\u96b6\u5c45\u4f4f\u3002\u8fd9\u6837\u505a\u66f4\u7701\u94b1\uff0c\u4f46\u4f4f\u5ba2\u4eec\u65e0\u7591\u4f1a\u56e0\u4e3a\u9700\u8981\u4e0e\u5176\u5b83\u5974\u96b6\u5206\u4eab\u79c1\u4eba\u7a7a\u95f4\u800c\u6cae\u4e27\uff0c\u540c\u65f6\u4e5f\u7ed9\u4ed6\u4eec\u7559\u4e0b\u4e86\u5bc6\u8c0b\u53cd\u6297\u4f60\u7684\u673a\u4f1a\u3002", "\u8fd9\u4e2a\u623f\u95f4\u5df2\u88ab\u6539\u88c5\u6210\u9002\u5408\u4e24\u4e2a\u4f60\u7684\u5974\u96b6\u5c45\u4f4f\u7684\u5730\u65b9\u3002", "\u4f60\u51fa\u8d44\u5c06\u623f\u95f4\u6539\u88c5\u6210\u4e86\u53cc\u4eba\u95f4\u3002\u4e00\u5bf9\u5355\u4eba\u5e8a\uff0c\u94fa\u7740\u7d20\u767d\u7684\u7fbd\u7ed2\u88ab\uff0c\u5206\u522b\u9760\u5728\u76f8\u5bf9\u7684\u4e24\u9762\u5899\u8fb9\u3002\u6bcf\u5f20\u5e8a\u8fb9\u90fd\u6709\u4e00\u4e2a\u7b80\u5355\u7684\u5e8a\u5934\u67dc\uff0c\u4e0a\u9762\u6709\u4e00\u76cf\u5965\u672f\u53f0\u706f\u3002\u9664\u6b64\u4e4b\u5916\uff0c\u8fd9\u91cc\u53ea\u6709\u4e00\u4e2a\u6728\u8d28\u8863\u67dc\u548c\u62bd\u5c49\u67dc\u3002", 3500, 0, 100, 2, -0.05f, -0.05f, null){

            @Override
            public String getSVGOverride() {
                return AbstractPlaceType.getSVGOverride("dominion/lilayasHome/roomSlaveDouble", PresetColour.BASE_MAGENTA);
            }

            @Override
            public String getRoomDescription(Cell c) {
                GenericPlace place = c.getPlace();
                if (place.getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM_UPGRADE_BED)) {
                    return "\u4f60\u51fa\u8d44\u5c06\u623f\u95f4\u6539\u88c5\u6210\u4e86\u53cc\u4eba\u95f4\u3002\u4e24\u5f20\u53cc\u4eba\u5e8a\uff0c\u94fa\u7740\u6e29\u6696\u677e\u8f6f\u7684\u7fbd\u7ed2\u88ab\uff0c\u5206\u522b\u9760\u5728\u76f8\u5bf9\u7684\u4e24\u9762\u5899\u8fb9\u3002\u6bcf\u5f20\u5e8a\u8fb9\u90fd\u6709\u4e00\u4e2a\u7b80\u5355\u7684\u5e8a\u5934\u67dc\uff0c\u4e0a\u9762\u6709\u4e00\u76cf\u5965\u672f\u53f0\u706f\u3002\u9664\u6b64\u4e4b\u5916\uff0c\u5176\u4ed6\u5bb6\u5177\u5c31\u53ea\u6709\u4e00\u5bf9\u6728\u5236\u8863\u67dc\u548c\u4e24\u4e2a\u62bd\u5c49\u67dc\u3002";
                }
                if (place.getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM_DOWNGRADE_BED)) {
                    return "\u4f60\u51fa\u8d44\u5c06\u623f\u95f4\u6539\u88c5\u6210\u4e86\u53cc\u4eba\u95f4\u3002\u4e24\u5f20\u4e0d\u592a\u8212\u670d\u7684\u5355\u4eba\u5e8a\uff0c\u53ea\u94fa\u4e0a\u4e86\u8584\u8584\u7684\u6bef\u5b50\uff0c\u9760\u7740\u5899\u8fb9\u3002\u6bcf\u5f20\u5e8a\u8fb9\u90fd\u6709\u4e00\u4e2a\u7b80\u5355\u7684\u5e8a\u5934\u67dc\uff0c\u4e0a\u9762\u6709\u4e00\u76cf\u5965\u672f\u53f0\u706f\u3002\u9664\u6b64\u4e4b\u5916\uff0c\u8fd9\u91cc\u53ea\u6709\u4e00\u4e2a\u6728\u8d28\u8863\u67dc\u548c\u62bd\u5c49\u67dc\u3002";
                }
                return "\u4f60\u51fa\u8d44\u5c06\u623f\u95f4\u6539\u88c5\u6210\u4e86\u53cc\u4eba\u95f4\u3002\u4e00\u5bf9\u5355\u4eba\u5e8a\uff0c\u94fa\u7740\u7d20\u767d\u7684\u7fbd\u7ed2\u88ab\uff0c\u5206\u522b\u9760\u5728\u76f8\u5bf9\u7684\u4e24\u9762\u5899\u8fb9\u3002\u6bcf\u5f20\u5e8a\u8fb9\u90fd\u6709\u4e00\u4e2a\u7b80\u5355\u7684\u5e8a\u5934\u67dc\uff0c\u4e0a\u9762\u6709\u4e00\u76cf\u5965\u672f\u53f0\u706f\u3002\u9664\u6b64\u4e4b\u5916\uff0c\u8fd9\u91cc\u53ea\u6709\u4e00\u4e2a\u6728\u8d28\u8863\u67dc\u548c\u62bd\u5c49\u67dc\u3002";
            }

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_ARTHUR_ROOM)) {
                    return new Util.Value<Boolean, String>(false, "");
                }
                if (!Main.game.getCharactersTreatingCellAsHome(cell).isEmpty() && !cell.getPlace().getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM)) {
                    return new Util.Value<Boolean, String>(false, "\u6539\u9020\u6216\u51fa\u552e\u5f00\u59cb\u524d\uff0c\u8fd9\u4e2a\u623f\u95f4\u9700\u8981\u88ab\u6e05\u7a7a\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }

            @Override
            public void applyInstallationEffects(Cell c) {
                GenericPlace place = c.getPlace();
                if (place.getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM)) {
                    place.removePlaceUpgrade(c, LILAYA_SLAVE_ROOM);
                } else {
                    for (AbstractPlaceUpgrade upgrade : PlaceUpgrade.getAllPlaceUpgrades()) {
                        if (upgrade == LILAYA_SLAVE_ROOM_DOUBLE) continue;
                        place.removePlaceUpgrade(c, upgrade);
                    }
                }
            }
        };
        LILAYA_SLAVE_ROOM_QUADRUPLE = new AbstractPlaceUpgrade(true, PresetColour.BASE_MAGENTA, "\u56db\u4eba\u5974\u96b6\u623f", "\u841d\u4e1d\u4f1a\u50cf\u5979\u5bf9\u5f85\u4efb\u4f55\u5176\u4ed6\u5ba2\u4eba\u90a3\u6837\u51c6\u5907\u8fd9\u4e2a\u623f\u95f4\uff0c\u4f7f\u5176\u9002\u5408\u4e3a\u56db\u4f4d\u4f60\u7684\u5974\u96b6\u5c45\u4f4f\u3002\u867d\u7136\u6bd4\u8d77\u6bcf\u4e2a\u5974\u96b6\u4e00\u4e2a\u5355\u72ec\u7684\u623f\u95f4\u66f4\u52a0\u7ecf\u6d4e\uff0c\u4f46\u4f4f\u5728\u5176\u4e2d\u7684\u4eba\u80af\u5b9a\u4e0d\u592a\u4e50\u610f\uff0c\u56e0\u4e3a\u5fc5\u987b\u8981\u8ddf\u5176\u4ed6\u5974\u96b6\u5206\u4eab\u4e2a\u4eba\u7a7a\u95f4\uff0c\u540c\u65f6\u4e5f\u7ed9\u4ed6\u4eec\u7559\u4e0b\u4e86\u5f88\u591a\u5bc6\u8c0b\u53cd\u6297\u4f60\u7684\u673a\u4f1a\u3002", "\u8fd9\u4e2a\u623f\u95f4\u5df2\u88ab\u6539\u5efa\u6210\u9002\u5408\u5b89\u7f6e\u56db\u540d\u5974\u96b6\u7684\u5730\u65b9\u3002", "\u4f60\u51fa\u8d44\u5c06\u623f\u95f4\u6539\u88c5\u6210\u4e86\u56db\u4eba\u95f4\u3002\u56db\u5f20\u5355\u4eba\u5e8a\uff0c\u94fa\u7740\u7d20\u767d\u8272\u7684\u7fbd\u7ed2\u88ab\uff0c\u9760\u5728\u5899\u8fb9\u3002\u6bcf\u5f20\u5e8a\u8fb9\u90fd\u6709\u4e00\u4e2a\u7b80\u5355\u7684\u5e8a\u5934\u67dc\uff0c\u4e0a\u9762\u6709\u4e00\u76cf\u5965\u672f\u53f0\u706f\u3002\u9664\u6b64\u4e4b\u5916\uff0c\u5176\u4ed6\u5bb6\u5177\u5c31\u53ea\u6709\u4e00\u5bf9\u6728\u5236\u8863\u67dc\u548c\u4e24\u4e2a\u62bd\u5c49\u67dc\u3002", 6000, 0, 100, 4, -0.1f, -0.2f, null){

            @Override
            public String getSVGOverride() {
                return AbstractPlaceType.getSVGOverride("dominion/lilayasHome/roomSlaveQuadruple", PresetColour.BASE_MAGENTA);
            }

            @Override
            public String getRoomDescription(Cell c) {
                GenericPlace place = c.getPlace();
                if (place.getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM_UPGRADE_BED)) {
                    return "\u4f60\u51fa\u8d44\u5c06\u623f\u95f4\u6539\u88c5\u6210\u4e86\u56db\u4eba\u95f4\u3002\u56db\u5f20\u53cc\u4eba\u5e8a\uff0c\u94fa\u7740\u6e29\u6696\u677e\u8f6f\u7684\u7fbd\u7ed2\u88ab\uff0c\u9760\u5728\u5899\u8fb9\u3002\u6bcf\u5f20\u5e8a\u8fb9\u90fd\u6709\u4e00\u4e2a\u7b80\u5355\u7684\u5e8a\u5934\u67dc\uff0c\u4e0a\u9762\u6709\u4e00\u76cf\u5965\u672f\u53f0\u706f\u3002\u9664\u6b64\u4e4b\u5916\uff0c\u5176\u4ed6\u5bb6\u5177\u5c31\u53ea\u6709\u56db\u4e2a\u6728\u5236\u8863\u67dc\u548c\u62bd\u5c49\u67dc\u3002";
                }
                if (place.getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM_DOWNGRADE_BED)) {
                    return "\u4f60\u51fa\u8d44\u5c06\u623f\u95f4\u6539\u88c5\u6210\u4e86\u56db\u4eba\u95f4\u3002\u56db\u5f20\u4e0d\u592a\u8212\u670d\u7684\u5c0f\u5e8a\uff0c\u53ea\u94fa\u4e0a\u4e86\u8584\u8584\u7684\u6bef\u5b50\uff0c\u9760\u7740\u5899\u8fb9\u3002\u6bcf\u5f20\u5e8a\u8fb9\u90fd\u6709\u4e00\u4e2a\u7b80\u5355\u7684\u5e8a\u5934\u67dc\uff0c\u4e0a\u9762\u6709\u4e00\u76cf\u5965\u672f\u53f0\u706f\u3002\u9664\u6b64\u4e4b\u5916\uff0c\u5176\u4ed6\u5bb6\u5177\u5c31\u53ea\u6709\u4e00\u5bf9\u6728\u5236\u8863\u67dc\u548c\u4e24\u4e2a\u62bd\u5c49\u67dc\u3002";
                }
                return "\u4f60\u51fa\u8d44\u5c06\u623f\u95f4\u6539\u88c5\u6210\u4e86\u56db\u4eba\u95f4\u3002\u56db\u5f20\u5355\u4eba\u5e8a\uff0c\u94fa\u7740\u7d20\u767d\u8272\u7684\u7fbd\u7ed2\u88ab\uff0c\u9760\u5728\u5899\u8fb9\u3002\u6bcf\u5f20\u5e8a\u8fb9\u90fd\u6709\u4e00\u4e2a\u7b80\u5355\u7684\u5e8a\u5934\u67dc\uff0c\u4e0a\u9762\u6709\u4e00\u76cf\u5965\u672f\u53f0\u706f\u3002\u9664\u6b64\u4e4b\u5916\uff0c\u8fd9\u91cc\u53ea\u6709\u4e00\u4e2a\u6728\u8d28\u8863\u67dc\u548c\u62bd\u5c49\u67dc\u3002";
            }

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_ARTHUR_ROOM)) {
                    return new Util.Value<Boolean, String>(false, "");
                }
                if (!(Main.game.getCharactersTreatingCellAsHome(cell).isEmpty() || cell.getPlace().getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM) || cell.getPlace().getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM_DOUBLE))) {
                    return new Util.Value<Boolean, String>(false, "\u6539\u9020\u5f00\u59cb\u524d\uff0c\u8fd9\u4e2a\u623f\u95f4\u9700\u8981\u88ab\u6e05\u7a7a\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }

            @Override
            public void applyInstallationEffects(Cell c) {
                GenericPlace place = c.getPlace();
                if (place.getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM)) {
                    place.removePlaceUpgrade(c, LILAYA_SLAVE_ROOM);
                } else if (place.getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM_DOUBLE)) {
                    place.removePlaceUpgrade(c, LILAYA_SLAVE_ROOM_DOUBLE);
                } else {
                    for (AbstractPlaceUpgrade upgrade : PlaceUpgrade.getAllPlaceUpgrades()) {
                        if (upgrade == LILAYA_SLAVE_ROOM_QUADRUPLE) continue;
                        place.removePlaceUpgrade(c, upgrade);
                    }
                }
            }
        };
        LILAYA_SLAVE_ROOM_DOWNGRADE_BED = new AbstractPlaceUpgrade(false, PresetColour.GENERIC_BAD, "\u5c0f\u94c1\u5e8a", "\u5c06\u8be5\u623f\u95f4\u7684\u5e8a\u66ff\u6362\u4e3a\u94a2\u6846\u67b6\u7684\u5e8a\uff0c\u4e0a\u9762\u94fa\u4e00\u5f20\u4e0d\u8212\u670d\u7684\u5e8a\u57ab\uff0c\u4e00\u4e2a\u786c\u6795\u5934\u548c\u4e00\u6761\u8584\u6bef\u3002\u8fd9\u4e9b\u6539\u52a8\u65e0\u7591\u4f1a\u8ba9\u4f4f\u5728\u5176\u4e2d\u7684\u4eba\u610f\u8bc6\u5230\u4ed6\u4eec\u786e\u786e\u5b9e\u5b9e\u6210\u4e3a\u4e86\u5974\u96b6\u3002", "\u623f\u95f4\u5185\u5b89\u653e\u7740\u4e00\u5f20\u5355\u4eba\u5c0f\u5e8a\uff0c\u5e8a\u4e0a\u6709\u4e00\u5f20\u4e0d\u8212\u670d\u7684\u5e8a\u57ab\u3001\u4e00\u4e2a\u786c\u6795\u5934\u548c\u4e00\u6761\u8584\u6bef\u3002", "\u623f\u95f4\u7684\u4e00\u4fa7\u653e\u7740\u4e00\u5f20\u5355\u4eba\u5c0f\u5e8a\uff0c\u5e8a\u4e0a\u6709\u4e00\u5f20\u4e0d\u8212\u670d\u7684\u5e8a\u57ab\u3001\u4e00\u4e2a\u786c\u6795\u5934\u548c\u4e00\u6761\u8584\u6bef\u3002\u7ed9\u623f\u95f4\u91cc\u7684\u4f4f\u6237\u63d0\u4f9b\u5982\u6b64\u4e0d\u9002\u7684\u4f11\u606f\u573a\u6240\uff0c\u80af\u5b9a\u4f1a\u5f3a\u5316\u4ed6\u4eec\u662f\u4f60\u7684\u5974\u96b6\u7684\u60f3\u6cd5\uff0c\u4f46\u540c\u65f6\u4ed6\u4eec\u5fc5\u7136\u4e5f\u4f1a\u66f4\u8ba8\u538c\u4f60\u2026\u2026", 250, 100, -10, 0, -0.1f, 0.2f, null){

            @Override
            public String getRoomDescription(Cell c) {
                GenericPlace place = c.getPlace();
                if (place.getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM_QUADRUPLE)) {
                    return "\u623f\u95f4\u4e2d\u7684\u56db\u5f20\u5355\u4eba\u5e8a\u5df2\u7ecf\u88ab\u66ff\u6362\u4e3a\u94a2\u6846\u67b6\u7684\u5e8a\uff0c\u53ea\u5269\u4e0b\u4e0d\u8212\u670d\u7684\u5e8a\u57ab\u3001\u50f5\u786c\u7684\u6795\u5934\u548c\u5355\u8584\u7684\u6bef\u5b50\u3002\u7ed9\u623f\u95f4\u91cc\u7684\u4f4f\u6237\u63d0\u4f9b\u5982\u6b64\u4e0d\u9002\u7684\u4f11\u606f\u573a\u6240\uff0c\u80af\u5b9a\u4f1a\u8fdb\u4e00\u6b65\u8ba9\u4ed6\u4eec\u63a5\u53d7\u81ea\u5df1\u4e0d\u8fc7\u662f\u4f60\u7684\u5974\u96b6\uff0c\u4f46\u540c\u65f6\u4ed6\u4eec\u5fc5\u7136\u4e5f\u4f1a\u66f4\u8ba8\u538c\u4f60\u2026\u2026";
                }
                if (place.getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM_DOUBLE)) {
                    return "\u623f\u95f4\u4e2d\u7684\u4e24\u5f20\u5355\u4eba\u5e8a\u5df2\u7ecf\u88ab\u66ff\u6362\u4e3a\u94a2\u6846\u67b6\u7684\u5e8a\uff0c\u53ea\u5269\u4e0b\u4e0d\u8212\u670d\u7684\u5e8a\u57ab\u3001\u50f5\u786c\u7684\u6795\u5934\u548c\u5355\u8584\u7684\u6bef\u5b50\u3002\u7ed9\u623f\u95f4\u91cc\u7684\u4f4f\u6237\u63d0\u4f9b\u5982\u6b64\u4e0d\u9002\u7684\u4f11\u606f\u573a\u6240\uff0c\u80af\u5b9a\u4f1a\u8fdb\u4e00\u6b65\u8ba9\u4ed6\u4eec\u63a5\u53d7\u81ea\u5df1\u4e0d\u8fc7\u662f\u4f60\u7684\u5974\u96b6\uff0c\u4f46\u540c\u65f6\u4ed6\u4eec\u5fc5\u7136\u4e5f\u4f1a\u66f4\u8ba8\u538c\u4f60\u2026\u2026";
                }
                return "\u623f\u95f4\u4e2d\u7684\u5c0f\u578b\u5355\u4eba\u5e8a\u5df2\u7ecf\u88ab\u66ff\u6362\u4e3a\u94a2\u6846\u67b6\u7684\u5e8a\uff0c\u53ea\u5269\u4e0b\u4e0d\u8212\u670d\u7684\u5e8a\u57ab\u3001\u786c\u6795\u5934\u548c\u8584\u6bef\u3002\u7ed9\u623f\u95f4\u91cc\u7684\u4f4f\u6237\u63d0\u4f9b\u5982\u6b64\u4e0d\u9002\u7684\u4f11\u606f\u573a\u6240\uff0c\u80af\u5b9a\u4f1a\u8fdb\u4e00\u6b65\u8ba9\u4ed6\u4eec\u63a5\u53d7\u81ea\u5df1\u4e0d\u8fc7\u662f\u4f60\u7684\u5974\u96b6\uff0c\u4f46\u540c\u65f6\u4ed6\u4eec\u5fc5\u7136\u4e5f\u4f1a\u66f4\u8ba8\u538c\u4f60\u2026\u2026";
            }

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM_UPGRADE_BED)) {
                    return new Util.Value<Boolean, String>(false, "\u5728\u5b89\u88c5\u201c\u5c0f\u94c1\u5e8a\u201d\u4e4b\u524d\uff0c\u5fc5\u987b\u5148\u5378\u4e0b\u201c\u53cc\u4eba\u5e8a\u201d\u5347\u7ea7\u4ef6\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }
        };
        LILAYA_SLAVE_ROOM_UPGRADE_BED = new AbstractPlaceUpgrade(false, PresetColour.GENERIC_GOOD, "\u53cc\u4eba\u5e8a", "\u5728\u8be5\u623f\u95f4\u4e2d\u5b89\u7f6e\u53cc\u4eba\u5e8a\uff0c\u914d\u5907\u6709\u66f4\u8212\u670d\u7684\u5e8a\u57ab\u3001\u84ec\u677e\u7684\u6795\u5934\u548c\u6e29\u6696\u7684\u7fbd\u7ed2\u88ab\u3002\u623f\u95f4\u91cc\u7684\u4f4f\u6237\u80af\u5b9a\u4f1a\u611f\u6fc0\u8fd9\u9879\u6539\u9020\u3002", "\u623f\u95f4\u5185\u5b89\u653e\u7740\u4e00\u5f20\u53cc\u4eba\u5e8a\uff0c\u914d\u5907\u6709\u8212\u9002\u7684\u5e8a\u57ab\u3001\u84ec\u677e\u7684\u6795\u5934\u548c\u6e29\u6696\u7684\u7fbd\u7ed2\u88ab\u3002", "\u623f\u95f4\u7684\u4e00\u4fa7\u653e\u7740\u4e00\u5f20\u53cc\u4eba\u5e8a\uff0c\u5e8a\u4e0a\u6709\u4e00\u5f20\u8212\u670d\u7684\u5e8a\u57ab\u3001\u4e00\u4e2a\u84ec\u677e\u7684\u6795\u5934\u548c\u4e00\u5f20\u6e29\u6696\u7684\u7fbd\u7ed2\u88ab\u3002\u7ed9\u623f\u95f4\u91cc\u7684\u4f4f\u6237\u63d0\u4f9b\u5982\u6b64\u8212\u9002\u7684\u4f11\u606f\u573a\u6240\uff0c\u80af\u5b9a\u4f1a\u8ba9\u4ed6\u4eec\u66f4\u559c\u6b22\u4f60\uff0c\u4f46\u8fd9\u79cd\u5962\u534e\u53ef\u80fd\u4f1a\u4ee4\u5176\u5fd8\u8bb0\u81ea\u5df1\u7684\u5730\u4f4d\u2026\u2026", 500, 200, 25, 0, 0.2f, -0.1f, null){

            @Override
            public String getRoomDescription(Cell c) {
                GenericPlace place = c.getPlace();
                if (place.getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM_QUADRUPLE)) {
                    return "\u623f\u95f4\u4e2d\u7684\u56db\u5f20\u5355\u4eba\u5e8a\u5df2\u7ecf\u88ab\u66ff\u6362\u4e3a\u53cc\u4eba\u5e8a\uff0c\u914d\u5907\u4e86\u8212\u9002\u7684\u5e8a\u57ab\u3001\u84ec\u677e\u7684\u6795\u5934\u548c\u6e29\u6696\u7684\u7fbd\u7ed2\u88ab\u3002\u7ed9\u623f\u95f4\u91cc\u7684\u4f4f\u6237\u63d0\u4f9b\u5982\u6b64\u8212\u9002\u7684\u4f11\u606f\u573a\u6240\uff0c\u80af\u5b9a\u4f1a\u8ba9\u4ed6\u4eec\u66f4\u559c\u6b22\u4f60\uff0c\u4f46\u8fd9\u79cd\u5962\u534e\u53ef\u80fd\u4f1a\u4ee4\u5176\u5fd8\u8bb0\u81ea\u5df1\u7684\u5730\u4f4d\u2026\u2026";
                }
                if (place.getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM_DOUBLE)) {
                    return "\u623f\u95f4\u4e2d\u7684\u4e24\u5f20\u5355\u4eba\u5e8a\u5df2\u7ecf\u88ab\u66ff\u6362\u4e3a\u53cc\u4eba\u5e8a\uff0c\u914d\u5907\u4e86\u8212\u9002\u7684\u5e8a\u57ab\u3001\u84ec\u677e\u7684\u6795\u5934\u548c\u6e29\u6696\u7684\u7fbd\u7ed2\u88ab\u3002\u7ed9\u623f\u95f4\u91cc\u7684\u4f4f\u6237\u63d0\u4f9b\u5982\u6b64\u8212\u9002\u7684\u4f11\u606f\u573a\u6240\uff0c\u80af\u5b9a\u4f1a\u8ba9\u4ed6\u4eec\u66f4\u559c\u6b22\u4f60\uff0c\u4f46\u8fd9\u79cd\u5962\u534e\u53ef\u80fd\u4f1a\u4ee4\u5176\u5fd8\u8bb0\u81ea\u5df1\u7684\u5730\u4f4d\u2026\u2026";
                }
                return "\u623f\u95f4\u7684\u4e00\u4fa7\u653e\u7740\u4e00\u5f20\u53cc\u4eba\u5e8a\uff0c\u914d\u5907\u4e86\u8212\u9002\u7684\u5e8a\u57ab\u3001\u84ec\u677e\u7684\u6795\u5934\u548c\u6e29\u6696\u7684\u7fbd\u7ed2\u88ab\u3002\u7ed9\u623f\u95f4\u91cc\u7684\u4f4f\u6237\u63d0\u4f9b\u5982\u6b64\u8212\u9002\u7684\u4f11\u606f\u573a\u6240\uff0c\u80af\u5b9a\u4f1a\u8ba9\u4ed6\u4eec\u66f4\u559c\u6b22\u4f60\uff0c\u4f46\u8fd9\u79cd\u5962\u534e\u53ef\u80fd\u4f1a\u4ee4\u5176\u5fd8\u8bb0\u81ea\u5df1\u7684\u5730\u4f4d\u2026\u2026";
            }

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM_DOWNGRADE_BED)) {
                    return new Util.Value<Boolean, String>(false, "\u5728\u5b89\u88c5\u201c\u53cc\u4eba\u5e8a\u201d\u4e4b\u524d\uff0c\u5fc5\u987b\u5148\u5378\u4e0b\u201c\u5c0f\u94c1\u5e8a\u201d\u5347\u7ea7\u4ef6\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }
        };
        LILAYA_SLAVE_ROOM_OBEDIENCE_TRAINER = new AbstractPlaceUpgrade(false, PresetColour.GENERIC_ARCANE, "\u670d\u4ece\u8bad\u7ec3\u5668", "\u8389\u83b1\u96c5\u95ee\u4f60\u662f\u5426\u613f\u610f\u8003\u8651\u5728\u8fd9\u4e2a\u623f\u95f4\u91cc\u5b89\u88c5\u5979\u7684\u4e00\u4e2a\u5b9e\u9a8c\u88c5\u7f6e\uff0c\u5373\u6240\u8c13\u7684\u670d\u4ece\u8bad\u7ec3\u5668\u3002\u8fd9\u4e2a\u7279\u522b\u7684\u9644\u52a0\u88c5\u7f6e\u662f\u4e00\u5757\u53d1\u5149\u7684\u5927\u6c34\u6676\uff0c\u9700\u8981\u653e\u7f6e\u5728\u623f\u95f4\u7684\u4e2d\u592e\u3002\u6bcf\u5f53\u623f\u95f4\u91cc\u7684\u4eba\u6709\u4e0d\u542c\u8bdd\u7684\u5ff5\u5934\u65f6\uff0c\u6c34\u6676\u5c31\u4f1a\u53d1\u5c04\u51fa\u4ee4\u4eba\u9707\u60ca\u7684\u5965\u672f\u80fd\u91cf\uff0c\u4ece\u800c\u4ee5\u53ef\u4ee5\u60f3\u8c61\u5230\u7684\u6700\u5177\u4fb5\u72af\u6027\u7684\u65b9\u5f0f\u8bad\u7ec3\u5974\u96b6\u7684\u670d\u4ece\u6027\u3002", "\u4f60\u5728\u8fd9\u4e2a\u623f\u95f4\u91cc\u5b89\u88c5\u4e86\u8389\u83b1\u96c5\u7684\u4e00\u4e2a\u5b9e\u9a8c\u88c5\u7f6e\uff0c\u5373\u6240\u8c13\u7684\u670d\u4ece\u8bad\u7ec3\u5668\u3002\u623f\u95f4\u4e2d\u592e\u653e\u7f6e\u4e86\u4e00\u5757\u5de8\u5927\u7684\u53d1\u5149\u6c34\u6676\u3002\u6bcf\u5f53\u623f\u95f4\u91cc\u7684\u4eba\u6709\u4e0d\u542c\u8bdd\u7684\u5ff5\u5934\u65f6\uff0c\u6c34\u6676\u5c31\u4f1a\u53d1\u5c04\u51fa\u4ee4\u4eba\u9707\u60ca\u7684\u5965\u672f\u80fd\u91cf\uff0c\u4ece\u800c\u4ee5\u53ef\u4ee5\u60f3\u8c61\u5230\u7684\u6700\u5177\u4fb5\u72af\u6027\u7684\u65b9\u5f0f\u8bad\u7ec3\u5974\u96b6\u7684\u670d\u4ece\u6027\u3002", "\u8389\u83b1\u96c5\u7684\u4e00\u4e2a\u5b9e\u9a8c\u88c5\u7f6e\uff0c\u5373\u6240\u8c13\u7684\u201c\u670d\u4ece\u8bad\u7ec3\u5668\u201d\uff0c\u5c31\u5b89\u88c5\u5728\u8fd9\u4e2a\u623f\u95f4\u7684\u4e2d\u592e\u3002\u670d\u4ece\u8bad\u7ec3\u5668\u7684\u5916\u5f62\u662f\u4e00\u5757\u53d1\u5149\u7684\u5927\u6c34\u6676\uff0c\u5b83\u4f1a\u5411\u9644\u8fd1\u4efb\u4f55\u80c6\u6562\u6709\u4e0d\u670d\u4ece\u60f3\u6cd5\u7684\u5974\u96b6\u53d1\u5c04\u4e00\u9053\u9707\u64bc\u4eba\u5fc3\u7684\u5965\u672f\u80fd\u91cf\u5f39\u3002\u867d\u7136\u8fd9\u79cd\u8bad\u7ec3\u65b9\u6cd5\u5728\u8bad\u7ec3\u670d\u4ece\u6027\u65b9\u9762\u975e\u5e38\u6709\u6548\uff0c\u4f46\u4efb\u4f55\u63a5\u53d7\u8fc7\u8fd9\u79cd\u4fb5\u5165\u5f0f\u8bad\u7ec3\u7684\u5974\u96b6\u90fd\u80af\u5b9a\u4f1a\u5728\u4e0d\u4e45\u540e\u538c\u6076\u4f60\u2026\u2026", 10000, 500, 250, 0, -0.2f, 0.4f, null){};
        LILAYA_SLAVE_ROOM_DOG_BOWLS = new AbstractPlaceUpgrade(false, PresetColour.GENERIC_BAD, "\u72d7\u7897", "\u7528\u653e\u5728\u5730\u4e0a\u7684\u72d7\u7897\u7ed9\u623f\u95f4\u91cc\u7684\u4eba\u9001\u996d\u3002\u88ab\u8feb\u4ee5\u8fd9\u79cd\u5c48\u8fb1\u7684\u65b9\u5f0f\u8fdb\u98df\u80af\u5b9a\u4f1a\u8ba9\u4f60\u7684\u5974\u96b6\u4eec\u8ba8\u538c\u4f60\uff0c\u4f46\u8fd9\u4e5f\u4f1a\u5f3a\u8c03\u4e00\u4e2a\u4e8b\u5b9e\uff0c\u90a3\u5c31\u662f\u4ed6\u4eec\u53ea\u4e0d\u8fc7\u662f\u4f60\u7684\u8d22\u4ea7\u800c\u5df2\u3002", "\u8fd9\u4e2a\u623f\u95f4\u7684\u5730\u4e0a\u653e\u7740\u91d1\u5c5e\u72d7\u7897\uff0c\u623f\u95f4\u91cc\u7684\u4eba\u5c31\u662f\u7528\u8fd9\u4e9b\u72d7\u7897\u5403\u996d\u7684\u3002\u88ab\u8feb\u4ee5\u5982\u6b64\u5c48\u8fb1\u7684\u65b9\u5f0f\u8fdb\u98df\u4f1a\u8ba9\u4f60\u7684\u5974\u96b6\u4eec\u8ba8\u538c\u4f60\uff0c\u4f46\u540c\u65f6\u4e5f\u662f\u5728\u5f3a\u8c03\u4ed6\u4eec\u4e0d\u8fc7\u662f\u4f60\u7684\u8d22\u4ea7\u8fd9\u4e00\u4e8b\u5b9e\u3002", "\u623f\u95f4\u7684\u4e00\u89d2\u6446\u653e\u7740\u4e00\u7cfb\u5217\u91d1\u5c5e\u72d7\u7897\uff0c\u623f\u95f4\u91cc\u7684\u4eba\u5c31\u662f\u4ece\u8fd9\u4e9b\u72d7\u7897\u91cc\u8fdb\u98df\u548c\u559d\u6c34\u7684\u3002\u88ab\u8feb\u56db\u811a\u7740\u5730\uff0c\u50cf\u72d7\u4e00\u6837\u8fdb\u98df\uff0c\u8fd9\u8ba9\u4f60\u7684\u5974\u96b6\u4eec\u4e0d\u559c\u6b22\u4f60\uff0c\u4f46\u540c\u65f6\uff0c\u8fd9\u4e5f\u8ba9\u4ed6\u4eec\u660e\u767d\uff0c\u4ed6\u4eec\u4e0d\u8fc7\u662f\u4f60\u7684\u8d22\u4ea7\u2026\u2026", 100, 0, 10, 0, -0.2f, 0.25f, null){

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM_ROOM_SERVICE)) {
                    return new Util.Value<Boolean, String>(false, "\u5728\u4f7f\u7528\u201c\u72d7\u7897\u201d\u4e4b\u524d\uff0c\u5fc5\u987b\u5148\u53d6\u6d88\u201c\u5ba2\u623f\u670d\u52a1\u201d\u5347\u7ea7\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }
        };
        LILAYA_SLAVE_ROOM_ROOM_SERVICE = new AbstractPlaceUpgrade(false, PresetColour.GENERIC_ARCANE, "\u5ba2\u623f\u670d\u52a1", "\u4f60\u53ef\u4ee5\u4e3a\u8fd9\u95f4\u5ba2\u623f\u7684\u4f4f\u5ba2\u63d0\u4f9b\u65e0\u9650\u91cf\u7684\u5ba2\u623f\u670d\u52a1\u3002\u8fd9\u5e76\u4e0d\u662f\u5927\u591a\u6570\u4e3b\u4eba\u5bf9\u5f85\u5974\u96b6\u7684\u65b9\u5f0f\uff0c\u867d\u7136\u8fd9\u6837\u505a\u80af\u5b9a\u4f1a\u8ba9\u4f4f\u5ba2\u66f4\u559c\u6b22\u4f60\uff0c\u4f46\u4e5f\u4f1a\u82b1\u8d39\u5927\u91cf\u7684\u7ef4\u62a4\u8d39\u7528\uff0c\u8fd8\u4f1a\u5bf9\u4ed6\u4eec\u7684\u670d\u4ece\u6027\u4ea7\u751f\u4e00\u4e9b\u8d1f\u9762\u5f71\u54cd\u2026\u2026", "\u4f60\u4e3a\u8fd9\u95f4\u5ba2\u623f\u7684\u4f4f\u5ba2\u63d0\u4f9b\u4e86\u65e0\u9650\u91cf\u7684\u5ba2\u623f\u670d\u52a1\u3002\u8fd9\u80af\u5b9a\u4f1a\u8ba9\u4ed6\u4eec\u66f4\u559c\u6b22\u4f60\uff0c\u4f46\u4e5f\u8981\u82b1\u8d39\u76f8\u5f53\u591a\u7684\u7ef4\u62a4\u8d39\u7528\uff0c\u5bf9\u4f60\u7684\u5974\u96b6\u7684\u670d\u4ece\u6027\u4e5f\u6709\u8d1f\u9762\u5f71\u54cd\u2026\u2026", "\u4e00\u8f86\u5c0f\u63a8\u8f66\u4e0a\u5806\u653e\u7740\u51e0\u4e2a\u7a7a\u94f6\u76d8\u548c\u73bb\u7483\u676f\uff0c\u8fd9\u8bc1\u660e\u4f4f\u5728\u8fd9\u91cc\u7684\u5974\u96b6\u4eec\u6b63\u5728\u5145\u5206\u5229\u7528\u4f60\u4e3a\u4ed6\u4eec\u63d0\u4f9b\u7684\u65e0\u9650\u91cf\u5ba2\u623f\u670d\u52a1\u3002\u8fd9\u80af\u5b9a\u4f1a\u8ba9\u4ed6\u4eec\u66f4\u559c\u6b22\u4f60\uff0c\u4f46\u8ba9\u4ed6\u4eec\u62e5\u6709\u8fd9\u6837\u7684\u5962\u4f88\u54c1\u4e5f\u4f1a\u5bf9\u4ed6\u4eec\u7684\u670d\u4ece\u6027\u4ea7\u751f\u8d1f\u9762\u5f71\u54cd\uff0c\u66f4\u4e0d\u7528\u8bf4\u8fd9\u5bf9\u4f60\u7684\u7ecf\u6d4e\u9020\u6210\u7684\u635f\u5bb3\u4e86\u2026\u2026", 500, 0, 250, 0, 0.4f, -0.2f, null){

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_SLAVE_ROOM_DOG_BOWLS)) {
                    return new Util.Value<Boolean, String>(false, "\u5728\u4f7f\u7528\u201c\u5ba2\u623f\u670d\u52a1\u201d\u4e4b\u524d\uff0c\u5fc5\u987b\u5148\u79fb\u9664\u201c\u72d7\u7897\u201d\u5347\u7ea7\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }
        };
        LILAYA_SLAVE_ROOM_ARCANE_INSTRUMENTS = new AbstractPlaceUpgrade(false, PresetColour.GENERIC_ARCANE, "\u5965\u672f\u4eea\u5668", "\u5141\u8bb8\u8389\u83b1\u96c5\u5728\u8fd9\u4e2a\u623f\u95f4\u91cc\u5b89\u88c5\u5965\u672f\u611f\u5e94\u5668\uff0c\u8fd9\u6837\u5979\u5c31\u80fd\u6536\u96c6\u5230\u5173\u4e8e\u4f60\u7684\u5974\u96b6\u7684\u7075\u6c14\u7684\u6709\u7528\u6570\u636e\u3002\u4f60\u7684\u5974\u96b6\u4eec\u4f1a\u89c9\u5f97\u8fd9\u662f\u5bf9\u4ed6\u4eec\u4ec5\u6709\u7684\u4e2a\u4eba\u7a7a\u95f4\u7684\u4fb5\u72af\uff0c\u4ed6\u4eec\u5bf9\u4f60\u7684\u611f\u60c5\u4e5f\u4f1a\u56e0\u6b64\u53d7\u5230\u5f71\u54cd\u3002", "\u8fd9\u4e2a\u623f\u95f4\u5468\u56f4\u5b89\u88c5\u4e86\u4e00\u7cfb\u5217\u5965\u672f\u4f20\u611f\u5668\uff0c\u8ba9\u8389\u83b1\u96c5\u80fd\u591f\u6536\u96c6\u5230\u5173\u4e8e\u4f60\u7684\u5974\u96b6\u7684\u7075\u6c14\u7684\u6709\u7528\u6570\u636e\u3002\u4f60\u7684\u5974\u96b6\u4f1a\u89c9\u5f97\u8fd9\u662f\u5bf9\u4ed6\u4eec\u4ec5\u6709\u7684\u4e2a\u4eba\u7a7a\u95f4\u7684\u4fb5\u72af\uff0c\u4ed6\u4eec\u5bf9\u4f60\u7684\u611f\u60c5\u4e5f\u4f1a\u56e0\u6b64\u53d7\u5230\u5f71\u54cd\u3002", "\u4f5c\u4e3a\u964d\u4f4e\u623f\u95f4\u7ef4\u62a4\u6210\u672c\u7684\u4ea4\u6362\u6761\u4ef6\uff0c\u8389\u83b1\u96c5\u5728\u623f\u95f4\u5468\u56f4\u5b89\u88c5\u4e86\u51e0\u53f0\u5965\u672f\u4eea\u5668\uff0c\u901a\u8fc7\u8fd9\u4e9b\u4eea\u5668\uff0c\u5979\u53ef\u4ee5\u6536\u96c6\u4efb\u4f55\u88ab\u5b89\u7f6e\u5728\u8fd9\u91cc\u7684\u5974\u96b6\u7684\u6570\u636e\u3002\u5176\u4e2d\u6709\u51e0\u4e2a\u4f1a\u53d1\u51fa\u975e\u5e38\u5b89\u9759\u7684\u55e1\u55e1\u58f0\uff0c\u518d\u52a0\u4e0a\u5b83\u4eec\u5fae\u5f31\u7684\u7d2b\u8272\u5149\u8292\uff0c\u4f7f\u5b83\u4eec\u53d8\u5f97\u76f8\u5f53\u5177\u6709\u4fb5\u6270\u6027\uff0c\u5e76\u4f1a\u4f7f\u5c45\u4f4f\u8005\u5bf9\u4f60\u7684\u597d\u611f\u4ea7\u751f\u8d1f\u9762\u5f71\u54cd\u3002", 500, 100, -25, 0, -0.1f, 0.0f, null){};
        LILAYA_DUNGEON_CELL = new AbstractPlaceUpgrade(true, PresetColour.BASE_MAGENTA, "\u5730\u7262\u9694\u95f4", "-", "\u8fd9\u9694\u95f4\u6070\u597d\u80fd\u5bb9\u7eb3\u56db\u4e2a\u5012\u9709\u7684\u5974\u96b6\u3002", "-", 0, 0, 0, 4, -0.15f, 0.2f, null){

            @Override
            public String getSVGOverride() {
                return AbstractPlaceType.getSVGOverride("dominion/lilayasHome/roomSlaveQuadruple", PresetColour.BASE_MAGENTA);
            }

            @Override
            public String getRoomDescription(Cell c) {
                GenericPlace place = c.getPlace();
                StringBuilder sb = new StringBuilder();
                sb.append("\u9694\u95f4\u7684\u5899\u58c1\u3001\u5730\u9762\u548c\u5929\u82b1\u677f\u90fd\u662f\u7528\u7070\u8272\u7684\u5927\u77f3\u5934\u780c\u6210\u7684\uff0c\u7ed9\u4eba\u4e00\u79cd\u9634\u6c89\u3001\u538b\u6291\u7684\u611f\u89c9\u3002\u9694\u95f4\u7684\u4e24\u4fa7\u5899\u58c1\u4e0a\u56fa\u5b9a\u7740\u51e0\u4e2a\u91d1\u5c5e\u70db\u53f0\uff0c\u6bcf\u4e2a\u70db\u53f0\u4e0a\u90fd\u6709\u4e00\u4e2a\u5965\u672f\u706b\u628a\u3002\u6c38\u4e0d\u7184\u706d\u7684\u70db\u706b\u4e0d\u65f6\u660e\u706d\u8df3\u8dc3\uff0c\u5728\u623f\u95f4\u5185\u6295\u4e0b\u821e\u52a8\u7684\u5f71\u5b50\u3002\u539a\u91cd\u7684\u6728\u95e8\u4e0a\u6709\u4e00\u6247\u5e26\u94c1\u6805\u680f\u7684\u5c0f\u7a97\uff0c\u8fd9\u6837\u5c31\u53ef\u4ee5\u5728\u5b89\u5168\u7684\u8d70\u5eca\u4e0a\u76d1\u89c6\u88ab\u5173\u5728\u91cc\u9762\u7684\u5974\u96b6\u3002");
                if (!place.getPlaceUpgrades().contains(LILAYA_DUNGEON_CELL_UPGRADE_BED) && !place.getPlaceUpgrades().contains(LILAYA_DUNGEON_CELL_DOWNGRADE_BED)) {
                    sb.append("<br/><br/>\u9694\u95f4\u91cc\u6709\u56db\u5f20\u94a2\u67b6\u5c0f\u5e8a\uff0c\u6bcf\u5f20\u5e8a\u4e0a\u90fd\u94fa\u7740\u8584\u5e8a\u57ab\uff0c\u653e\u7740\u5e72\u762a\u7684\u6795\u5934\u548c\u7834\u65e7\u7684\u6bef\u5b50\u3002\u5e8a\u8fb9\u7684\u8001\u65e7\u6728\u7bb1\u5145\u4f5c\u7b80\u6613\u5e8a\u5934\u67dc\u4f7f\u7528\u3002\u9664\u4e86\u5e8a\u548c\u677f\u6761\u7bb1\uff0c\u53ea\u4f59\u56db\u58c1\u3002");
                }
                return sb.toString();
            }
        };
        LILAYA_DUNGEON_CELL_DOWNGRADE_BED = new AbstractPlaceUpgrade(false, PresetColour.GENERIC_BAD, "\u7a3b\u8349\u88ab\u8925", "\u62c6\u9664\u8be5\u56da\u5ba4\u7684\u94a2\u67b6\u5e8a\u5e76\u4ee5\u7a3b\u8349\u5806\u4ee3\u4e4b\u3002\u7ed9\u7262\u623f\u91cc\u7684\u5974\u96b6\u4eec\u63d0\u4f9b\u5982\u6b64\u4e0d\u8212\u9002\u7684\u7761\u89c9\u573a\u6240\uff0c\u80af\u5b9a\u4f1a\u8ba9\u4ed6\u4eec\u66f4\u52a0\u610f\u8bc6\u5230\u4ed6\u4eec\u4e0d\u8fc7\u662f\u4f60\u7684\u8d22\u4ea7\uff0c\u4f46\u4e0e\u6b64\u540c\u65f6\uff0c\u4ed6\u4eec\u80af\u5b9a\u4f1a\u66f4\u52a0\u8ba8\u538c\u4f60\u2026\u2026", "\u8fd9\u4e2a\u623f\u95f4\u91cc\u7684\u5e8a\u5df2\u88ab\u79fb\u8d70\uff0c\u53d6\u800c\u4ee3\u4e4b\u7684\u662f\u4e00\u5806\u7a3b\u8349\u3002", "\u623f\u95f4\u7684\u4e00\u4fa7\u653e\u7740\u4e00\u5f20\u5355\u4eba\u5c0f\u5e8a\uff0c\u5e8a\u4e0a\u6709\u4e00\u5f20\u4e0d\u8212\u670d\u7684\u5e8a\u57ab\u3001\u4e00\u4e2a\u786c\u6795\u5934\u548c\u4e00\u6761\u8584\u6bef\u3002\u7ed9\u8fd9\u4e2a\u7262\u623f\u7684\u5974\u96b6\u4eec\u63d0\u4f9b\u8fd9\u4e48\u4e0d\u8212\u670d\u7684\u5730\u65b9\u7761\u89c9\uff0c\u65e0\u7591\u662f\u5728\u5f3a\u5316\u4ed6\u4eec\u53ea\u662f\u4f60\u7684\u8d22\u4ea7\u8fd9\u4e00\u4e8b\u5b9e\uff0c\u4f46\u4e0e\u6b64\u540c\u65f6\uff0c\u4ed6\u4eec\u4e5f\u5f00\u59cb\u66f4\u52a0\u8ba8\u538c\u4f60\u4e86\u2026\u2026", 100, 25, 0, 0, -0.1f, 0.2f, null){

            @Override
            public String getRoomDescription(Cell c) {
                return "\u8fd9\u4e2a\u623f\u95f4\u91cc\u7684\u56db\u5f20\u94a2\u67b6\u5e8a\u5df2\u5168\u90e8\u62c6\u9664\uff0c\u53d6\u800c\u4ee3\u4e4b\u7684\u662f\u4e00\u5806\u7a3b\u8349\u3002\u7528\u6765\u4ee3\u66ff\u5e8a\u5934\u67dc\u7684\u65e7\u6728\u7bb1\u4e5f\u88ab\u5305\u88c5\u7a3b\u8349\u7684\u7b80\u6613\u6728\u6846\u6240\u53d6\u4ee3\u3002\u7ed9\u7262\u623f\u91cc\u7684\u5974\u96b6\u4eec\u63d0\u4f9b\u5982\u6b64\u4e0d\u8212\u9002\u7684\u7761\u89c9\u573a\u6240\uff0c\u80af\u5b9a\u4f1a\u8ba9\u4ed6\u4eec\u66f4\u52a0\u610f\u8bc6\u5230\u4ed6\u4eec\u4e0d\u8fc7\u662f\u4f60\u7684\u8d22\u4ea7\uff0c\u4f46\u4e0e\u6b64\u540c\u65f6\uff0c\u4ed6\u4eec\u80af\u5b9a\u4f1a\u66f4\u52a0\u8ba8\u538c\u4f60\u2026\u2026";
            }

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_DUNGEON_CELL_UPGRADE_BED)) {
                    return new Util.Value<Boolean, String>(false, "\u5728\u5b89\u88c5\u201c\u7a3b\u8349\u88ab\u8925\u201d\u4e4b\u524d\uff0c\u5fc5\u987b\u5148\u79fb\u9664\u201c\u6539\u826f\u7684\u5e8a\u4e0a\u7528\u54c1\u201d\u5347\u7ea7\u7248\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }
        };
        LILAYA_DUNGEON_CELL_UPGRADE_BED = new AbstractPlaceUpgrade(false, PresetColour.GENERIC_GOOD, "\u6539\u826f\u7684\u5e8a\u4e0a\u7528\u54c1", "\u62c6\u6389\u5e8a\u4e0a\u7684\u8584\u5e8a\u57ab\u3001\u762a\u6795\u5934\u548c\u7834\u6bef\u5b50\uff0c\u6362\u4e0a\u66f4\u8212\u9002\u7684\u66ff\u4ee3\u54c1\u3002\u4e3a\u8fd9\u4e2a\u7262\u623f\u7684\u5974\u96b6\u63d0\u4f9b\u66f4\u9ad8\u7684\u8212\u9002\u5ea6\u80af\u5b9a\u4f1a\u8ba9\u4ed6\u4eec\u66f4\u559c\u6b22\u4f60\uff0c\u5c3d\u7ba1\u8fd9\u79cd\u76f8\u5bf9\u7684\u5962\u534e\u53ef\u80fd\u4f1a\u8ba9\u4ed6\u4eec\u5fd8\u8bb0\u81ea\u5df1\u7684\u5730\u4f4d\u2026\u2026", "\u7262\u623f\u91cc\u7684\u56db\u5f20\u5e8a\u7684\u5e8a\u57ab\u3001\u6795\u5934\u548c\u6bef\u5b50\u90fd\u6362\u6210\u4e86\u66f4\u8212\u9002\u7684\u66ff\u4ee3\u54c1\u3002", "\u7262\u623f\u91cc\u7684\u56db\u5f20\u5e8a\u7684\u5e8a\u57ab\u3001\u6795\u5934\u548c\u6bef\u5b50\u90fd\u6362\u6210\u4e86\u66f4\u8212\u9002\u7684\u66ff\u4ee3\u54c1\u3002\u4e3a\u8fd9\u4e2a\u7262\u623f\u7684\u5974\u96b6\u63d0\u4f9b\u66f4\u9ad8\u7684\u8212\u9002\u5ea6\u80af\u5b9a\u4f1a\u8ba9\u4ed6\u4eec\u66f4\u559c\u6b22\u4f60\uff0c\u5c3d\u7ba1\u8fd9\u79cd\u76f8\u5bf9\u7684\u5962\u534e\u8ba9\u4ed6\u4eec\u5fd8\u8bb0\u4e86\u81ea\u5df1\u7684\u5730\u4f4d\u2026\u2026", 250, 50, 5, 0, 0.05f, -0.05f, null){

            @Override
            public String getRoomDescription(Cell c) {
                return "\u7262\u623f\u91cc\u7684\u56db\u5f20\u5e8a\u7684\u5e8a\u57ab\u3001\u6795\u5934\u548c\u6bef\u5b50\u90fd\u6362\u6210\u4e86\u66f4\u8212\u9002\u7684\u66ff\u4ee3\u54c1\u3002\u4e3a\u8fd9\u4e2a\u7262\u623f\u7684\u5974\u96b6\u63d0\u4f9b\u66f4\u9ad8\u7684\u8212\u9002\u5ea6\u80af\u5b9a\u4f1a\u8ba9\u4ed6\u4eec\u66f4\u559c\u6b22\u4f60\uff0c\u5c3d\u7ba1\u8fd9\u79cd\u76f8\u5bf9\u7684\u5962\u534e\u53ef\u80fd\u4f1a\u8ba9\u4ed6\u4eec\u5fd8\u8bb0\u81ea\u5df1\u7684\u5730\u4f4d\u2026\u2026";
            }

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_DUNGEON_CELL_DOWNGRADE_BED)) {
                    return new Util.Value<Boolean, String>(false, "\u5728\u5b89\u88c5\u201c\u6539\u826f\u7684\u5e8a\u4e0a\u7528\u54c1\u201d\u4e4b\u524d\uff0c\u5fc5\u987b\u5148\u79fb\u9664\u201c\u7a3b\u8349\u88ab\u8925\u201d\u5347\u7ea7\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }
        };
        LILAYA_DUNGEON_CELL_DOG_BOWLS = new AbstractPlaceUpgrade(false, PresetColour.GENERIC_BAD, "\u72d7\u7897", "\u7528\u653e\u5728\u5730\u4e0a\u7684\u72d7\u7897\u7ed9\u7262\u623f\u91cc\u7684\u5974\u96b6\u9001\u996d\u3002\u88ab\u8feb\u4ee5\u8fd9\u79cd\u5c48\u8fb1\u7684\u65b9\u5f0f\u8fdb\u98df\u80af\u5b9a\u4f1a\u8ba9\u4f60\u7684\u5974\u96b6\u4eec\u8ba8\u538c\u4f60\uff0c\u4f46\u8fd9\u4e5f\u4f1a\u5f3a\u8c03\u4e00\u4e2a\u4e8b\u5b9e\uff0c\u90a3\u5c31\u662f\u4ed6\u4eec\u53ea\u4e0d\u8fc7\u662f\u4f60\u7684\u8d22\u4ea7\u800c\u5df2\u3002", "\u5730\u4e0a\u653e\u7740\u91d1\u5c5e\u72d7\u7897\uff0c\u7262\u623f\u91cc\u7684\u5974\u96b6\u5c31\u662f\u7528\u8fd9\u4e9b\u72d7\u7897\u5403\u996d\u7684\u3002", "\u5730\u4e0a\u653e\u7740\u56db\u5bf9\u91d1\u5c5e\u72d7\u7897\uff0c\u7262\u623f\u91cc\u7684\u5974\u96b6\u4eec\u8981\u7528\u8fd9\u4e9b\u72d7\u7897\u5403\u996d\u559d\u6c34\u3002\u88ab\u8feb\u56db\u811a\u7740\u5730\uff0c\u50cf\u72d7\u4e00\u6837\u8fdb\u98df\uff0c\u8fd9\u8ba9\u4f60\u7684\u5974\u96b6\u4eec\u4e0d\u559c\u6b22\u4f60\uff0c\u4f46\u540c\u65f6\uff0c\u8fd9\u4e5f\u8ba9\u4ed6\u4eec\u660e\u767d\uff0c\u4ed6\u4eec\u4e0d\u8fc7\u662f\u4f60\u7684\u8d22\u4ea7\u2026\u2026", 100, 0, 10, 0, -0.2f, 0.25f, null){

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_DUNGEON_CELL_DECENT_FOOD)) {
                    return new Util.Value<Boolean, String>(false, "\u5728\u4f7f\u7528\u201c\u72d7\u7897\u201d\u4e4b\u524d\uff0c\u5fc5\u987b\u5148\u79fb\u9664\u201c\u4f53\u9762\u98df\u7269\u201d\u5347\u7ea7\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }
        };
        LILAYA_DUNGEON_CELL_DECENT_FOOD = new AbstractPlaceUpgrade(false, PresetColour.GENERIC_GOOD, "\u4f53\u9762\u7684\u98df\u7269", "\u7528\u50cf\u6837\u7684\u70ed\u98df\u53d6\u4ee3\u4e3a\u7262\u623f\u5974\u96b6\u63d0\u4f9b\u7684\u51b0\u51b7\u65e0\u5473\u7684\u996d\u83dc\u3002\u4e3a\u8fd9\u4e2a\u7262\u623f\u7684\u5974\u96b6\u4eec\u63d0\u4f9b\u66f4\u7f8e\u5473\u7684\u98df\u7269\u80af\u5b9a\u4f1a\u8ba9\u4ed6\u4eec\u66f4\u559c\u6b22\u4f60\uff0c\u5c3d\u7ba1\u8fd9\u79cd\u76f8\u5bf9\u7684\u5962\u4f88\u53ef\u80fd\u4f1a\u8ba9\u4ed6\u4eec\u5fd8\u8bb0\u81ea\u5df1\u7684\u5730\u4f4d\u2026\u2026", "\u4f60\u4eec\u4e3a\u7262\u623f\u7684\u5974\u96b6\u4eec\u6362\u4e0a\u4e86\u70ed\u6c14\u817e\u817e\u7684\u996d\u83dc\u3002", "\u4f60\u4eec\u4e3a\u7262\u623f\u7684\u5974\u96b6\u4eec\u6362\u4e0a\u4e86\u70ed\u6c14\u817e\u817e\u7684\u996d\u83dc\u3002\u7ed9\u8fd9\u4e2a\u7262\u623f\u7684\u5974\u96b6\u4eec\u63d0\u4f9b\u66f4\u7f8e\u5473\u7684\u98df\u7269\u80af\u5b9a\u4f1a\u8ba9\u4ed6\u4eec\u66f4\u559c\u6b22\u4f60\uff0c\u5c3d\u7ba1\u8fd9\u79cd\u76f8\u5bf9\u7684\u5962\u4f88\u8ba9\u4ed6\u4eec\u5fd8\u8bb0\u4e86\u81ea\u5df1\u7684\u5730\u4f4d\u2026\u2026", 250, 0, 100, 0, 0.1f, -0.1f, null){

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_DUNGEON_CELL_DOG_BOWLS)) {
                    return new Util.Value<Boolean, String>(false, "\u5728\u4f7f\u7528\u201c\u4f53\u9762\u98df\u7269\u201d\u4e4b\u524d\uff0c\u5fc5\u987b\u5148\u79fb\u9664\u201c\u72d7\u7897\u201d\u5347\u7ea7\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }
        };
        LILAYA_DUNGEON_CELL_ROPES = new AbstractPlaceUpgrade(false, PresetColour.GENERIC_TERRIBLE, "\u7ef3\u7f1a\u88c5\u7f6e", "\u5728\u7262\u623f\u7684\u5899\u58c1\u4e0a\u62f4\u4e0a\u7ed3\u5b9e\u7684\u7ef3\u7d22\uff0c\u7528\u5b83\u4eec\u5c06\u5974\u96b6\u4eec\u6346\u7ed1\u5230\u4f4d\u3002\u8fd9\u5c06\u963b\u6b62\u4f60\u7684\u5974\u96b6\u76f8\u4e92\u4ea4\u6d41\uff0c\u5982\u679c\u5904\u4e8e\u987a\u4ece\u72b6\u6001\uff0c\u4ed6\u4eec\u5728\u5f00\u59cb\u6027\u7231\u573a\u666f\u65f6\u5c06\u4f1a\u56fa\u5b9a\u83b7\u5f97\u201c\u7ef3\u7f1a\u201d\u7684\u6548\u679c\u3002", "\u7262\u623f\u7684\u5899\u58c1\u4e0a\u62f4\u7740\u7ed3\u5b9e\u7684\u7ef3\u5b50\uff0c\u7528\u6765\u6346\u7ed1\u7262\u623f\u91cc\u7684\u5974\u96b6\u3002", "\u7262\u623f\u7684\u5899\u58c1\u4e0a\u62f4\u7740\u7ed3\u5b9e\u7684\u7ef3\u5b50\uff0c\u7528\u6765\u6346\u7ed1\u7262\u623f\u91cc\u7684\u5974\u96b6\u3002\u8fd9\u59a8\u788d\u4e86\u4f60\u7684\u5974\u96b6\u4eec\u76f8\u4e92\u4ea4\u6d41\uff0c\u4f7f\u4ed6\u4eec\u66f4\u52a0\u542c\u8bdd\uff0c\u4f46\u4ee3\u4ef7\u662f\u66f4\u52a0\u4e0d\u559c\u6b22\u4f60\u2026\u2026", 250, 100, 10, 0, -0.2f, 0.15f, null){

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_DUNGEON_CELL_CHAINS)) {
                    return new Util.Value<Boolean, String>(false, "\u5728\u4f7f\u7528\u201c\u7ef3\u7f1a\u88c5\u7f6e\u201d\u4e4b\u524d\uff0c\u5fc5\u987b\u5148\u79fb\u9664\u201c\u94fe\u7f1a\u88c5\u7f6e\u201d\u5347\u7ea7\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }

            @Override
            public ImmobilisationType getImmobilisationType() {
                return ImmobilisationType.ROPE;
            }
        };
        LILAYA_DUNGEON_CELL_CHAINS = new AbstractPlaceUpgrade(false, PresetColour.GENERIC_TERRIBLE, "\u94fe\u7f1a\u88c5\u7f6e", "\u5728\u7262\u623f\u7684\u5899\u58c1\u4e0a\u5b89\u88c5\u91d1\u5c5e\u94fe\uff0c\u7528\u5b83\u4eec\u5c06\u5974\u96b6\u4eec\u6346\u7ed1\u5230\u4f4d\u3002\u8fd9\u5c06\u963b\u6b62\u4f60\u7684\u5974\u96b6\u76f8\u4e92\u4ea4\u6d41\uff0c\u5982\u679c\u5904\u4e8e\u987a\u4ece\u72b6\u6001\uff0c\u4ed6\u4eec\u5728\u5f00\u59cb\u6027\u7231\u573a\u666f\u65f6\u5c06\u4f1a\u56fa\u5b9a\u83b7\u5f97\u201c\u94fe\u7f1a\u201d\u7684\u6548\u679c\u3002", "\u7262\u623f\u7684\u5899\u58c1\u4e0a\u5df2\u7ecf\u7ed1\u4e0a\u4e86\u91d1\u5c5e\u94fe\u6761\uff0c\u7528\u6765\u6346\u7ed1\u7262\u623f\u91cc\u7684\u5974\u96b6\u3002", "\u7262\u623f\u7684\u5899\u58c1\u4e0a\u5df2\u7ecf\u7ed1\u4e0a\u4e86\u91d1\u5c5e\u94fe\u6761\uff0c\u7528\u6765\u6346\u7ed1\u7262\u623f\u91cc\u7684\u5974\u96b6\u3002\u8fd9\u59a8\u788d\u4e86\u4f60\u7684\u5974\u96b6\u4eec\u76f8\u4e92\u4ea4\u6d41\uff0c\u4f7f\u4ed6\u4eec\u66f4\u52a0\u542c\u8bdd\uff0c\u4f46\u4ee3\u4ef7\u662f\u66f4\u52a0\u4e0d\u559c\u6b22\u4f60\u2026\u2026", 500, 250, 25, 0, -0.25f, 0.3f, null){

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_DUNGEON_CELL_ROPES)) {
                    return new Util.Value<Boolean, String>(false, "\u5728\u4f7f\u7528\u201c\u94fe\u7f1a\u88c5\u7f6e\u201d\u4e4b\u524d\uff0c\u5fc5\u987b\u5148\u5378\u4e0b\u201c\u7ef3\u7f1a\u88c5\u7f6e\u201d\u5347\u7ea7\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }

            @Override
            public ImmobilisationType getImmobilisationType() {
                return ImmobilisationType.CHAINS;
            }
        };
        LILAYA_MILKING_ROOM = new AbstractPlaceUpgrade(true, PresetColour.BASE_ORANGE, "\u6324\u5976\u5ba4", "\u5728\u8be5\u623f\u95f4\u5b89\u88c5\u6324\u5976\u673a\u5668\uff0c\u5141\u8bb8\u4f60\u7684[style.colourGood(\u516b\u4e2a)]\u5974\u96b6\u88ab\u5b89\u6392\u5728\u6b64\u5de5\u4f5c\uff0c\u6bcf\u4eba\u90fd\u4f1a\u88ab\u6324\u51fa\u4e73\u6c41\u6216\u8005\u7cbe\u6db2\u3002<br/><i>\u4e73\u6c41\uff1a" + Units.fluid(2500.0) + "\u6bcf\u5c0f\u65f6<br/>\u7cbe\u6db2\uff1a" + Units.fluid(250.0) + "\u6bcf\u5c0f\u65f6<br/>\u7231\u6db2" + Units.fluid(50.0) + "\u6bcf\u5c0f\u65f6</i>", "\u8fd9\u4e2a\u623f\u95f4\u5df2\u88ab\u6539\u5efa\u6210\u9002\u5408\u69a8\u53d6[style.colourGood(\u516b\u540d)]\u5974\u96b6\u7684\u4e73\u6c41\u548c\u7cbe\u6db2\u7684\u5730\u65b9\u3002", "\u8fd9\u4e2a\u623f\u95f4\u5df2\u88ab\u6539\u5efa\u6210\u4e00\u5904\u7279\u6b8a\u4ea7\u5976\u95f4\uff0c\u53ef\u4ee5\u69a8\u53d6\u516b\u540d\u5974\u96b6\u7684\u5404\u79cd\u4f53\u6db2\u3002\u5de6\u624b\u8fb9\u7684\u5899\u4e0a\u6392\u5217\u7740\u56db\u53f0\u673a\u5668\uff0c\u800c\u53e6\u4e00\u8fb9\u5219\u662f\u53e6\u5916\u56db\u53f0\u3002", 10000, 0, 500, 0, 0.0f, 0.0f, null){

            @Override
            public DialogueNode getRoomDialogue(Cell c) {
                return LilayaMilkingRoomDialogue.MILKING_ROOM;
            }

            @Override
            public String getSVGOverride() {
                return AbstractPlaceType.getSVGOverride("dominion/lilayasHome/roomMilking", PresetColour.BASE_YELLOW_LIGHT);
            }

            @Override
            public String getRoomDescription(Cell c) {
                MilkingRoom room = Main.game.getOccupancyUtil().getMilkingRoom(c.getType(), c.getLocation());
                return room.getRoomDescription();
            }

            @Override
            public void applyInstallationEffects(Cell c) {
                GenericPlace place = c.getPlace();
                for (AbstractPlaceUpgrade upgrade : PlaceUpgrade.getAllPlaceUpgrades()) {
                    if (upgrade == LILAYA_MILKING_ROOM) continue;
                    place.removePlaceUpgrade(c, upgrade);
                }
                if (Main.game.getOccupancyUtil().getMilkingRoom(c.getType(), c.getLocation()) == null) {
                    Main.game.getOccupancyUtil().addMilkingRoom(new MilkingRoom(c.getType(), c.getLocation()));
                }
            }

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_ARTHUR_ROOM)) {
                    return new Util.Value<Boolean, String>(false, "");
                }
                if (!Main.game.getCharactersTreatingCellAsHome(cell).isEmpty()) {
                    return new Util.Value<Boolean, String>(false, "\u6539\u9020\u6216\u51fa\u552e\u5f00\u59cb\u524d\uff0c\u8fd9\u4e2a\u623f\u95f4\u9700\u8981\u88ab\u6e05\u7a7a\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }
        };
        LILAYA_MILKING_ROOM_ARTISAN_MILKERS = new AbstractPlaceUpgrade(false, PresetColour.GENERIC_ARCANE, "\u624b\u5de5\u6324\u5976\u673a", "\u4f60\u53ef\u4ee5\u5c06\u8be5\u623f\u95f4\u4e2d\u7684\u6807\u51c6\u6324\u5976\u88c5\u7f6e\u66ff\u6362\u4e3a\u6781\u5176\u6602\u8d35\u7684\u624b\u5de5\u6324\u5976\u673a\u3002\u867d\u7136\u5974\u96b6\u4f7f\u7528\u8d77\u6765\u4f1a\u66f4\u8212\u670d\uff0c\u4f46\u8fd9\u79cd\u6324\u5976\u673a\u5668\u6700\u521d\u662f\u8bbe\u8ba1\u7528\u6765\u5c55\u793a\u7684\uff0c\u5b9e\u7528\u6027\u4e0d\u4f73\uff0c\u5bfc\u81f4\u6324\u5976\u91cf\u76f8\u6bd4\u5e38\u89c4\u673a\u5668\u7565\u5fae\u964d\u4f4e\u3002<br/><i>\u4ea7\u4e73" + Units.fluid(2000.0) + "\u6bcf\u5c0f\u65f6<br/>\u7cbe\u6db2\uff1a" + Units.fluid(200.0) + " \u6bcf\u5c0f\u65f6<br/>\u7231\u6db2\uff1a" + Units.fluid(40.0) + "\u6bcf\u5c0f\u65f6</i>", "\u4f60\u5df2\u7ecf\u5728\u8be5\u623f\u95f4\u5b89\u88c5\u4e86\u624b\u5de5\u6324\u5976\u673a\u3002\u6709\u5e78\u88ab\u9501\u5728\u8fd9\u4e9b\u673a\u5668\u91cc\u7684\u5974\u96b6\u4eec\u80af\u5b9a\u4f1a\u611f\u6fc0\u4f60\u3002<br/><i>\u4ea7\u4e73" + Units.fluid(2000.0) + "\u6bcf\u5c0f\u65f6<br/>\u7cbe\u6db2\uff1a" + Units.fluid(200.0) + " \u6bcf\u5c0f\u65f6<br/>\u7231\u6db2\uff1a" + Units.fluid(40.0) + "\u6bcf\u5c0f\u65f6</i>", "\u5965\u672f\u9a71\u52a8\u7684\u624b\u5de5\u6324\u5976\u673a\u5668\u5df2\u7ecf\u5b89\u653e\u5728\u8be5\u623f\u95f4\uff0c\u5468\u56f4\u7684\u7a7a\u6c14\u4e2d\u5145\u6ee1\u4e86\u67d4\u548c\u3001\u60a6\u8033\u7684\u8f70\u9e23\u58f0\u3002\u5c3d\u7ba1\u7528\u8d77\u6765\u76f8\u6bd4\u5e38\u89c4\u6324\u5976\u673a\u5668\u66f4\u52a0\u8212\u9002\uff0c\u4f46\u4f3c\u4e4e\u6700\u521d\u662f\u8bbe\u8ba1\u7528\u6765\u5c55\u793a\u7684\uff0c\u5b9e\u7528\u6027\u4e0d\u4f73\uff0c\u4f60\u7684\u5974\u96b6\u80af\u5b9a\u4f1a\u89c9\u5f97\u5f00\u5fc3\uff0c\u4f46\u6324\u5976\u91cf\u76f8\u6bd4\u5e73\u5e38\u7565\u4f4e\u3002", 2500, 500, 500, 0, 1.0f, 0.5f, null){

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_MILKING_ROOM_INDUSTRIAL_MILKERS)) {
                    return new Util.Value<Boolean, String>(false, "\u5728\u5b89\u88c5\u201c\u624b\u5de5\u6324\u5976\u673a\u201d\u4e4b\u524d\uff0c\u5fc5\u987b\u5148\u79fb\u9664\u201c\u5de5\u4e1a\u6324\u5976\u673a\u201d\u5347\u7ea7\u7a0b\u5e8f\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }
        };
        LILAYA_MILKING_ROOM_INDUSTRIAL_MILKERS = new AbstractPlaceUpgrade(false, PresetColour.GENERIC_ARCANE, "\u5de5\u4e1a\u6324\u5976\u673a", "\u4f60\u53ef\u4ee5\u5c06\u8be5\u623f\u95f4\u4e2d\u7684\u6807\u51c6\u6324\u5976\u88c5\u7f6e\u66ff\u6362\u4e3a\u5de5\u4e1a\u7ea7\u7684\u673a\u5668\u3002\u867d\u7136\u8fd9\u4e9b\u6324\u5976\u673a\u5bf9\u4e8e\u88ab\u6324\u5976\u7684\u5974\u96b6\u6765\u8bf4\u4e0d\u90a3\u4e48\u8212\u9002\uff0c\u4f46\u5374\u80fd\u6700\u5927\u9650\u5ea6\u5730\u63d0\u9ad8\u4ea7\u5976\u91cf\u548c\u5229\u6da6\u3002<br/><i>\u4ea7\u4e73\uff1a" + Units.fluid(5000.0) + "\u6bcf\u5c0f\u65f6<br/>\u7cbe\u6db2\uff1a" + Units.fluid(500.0) + " \u6bcf\u5c0f\u65f6<br/>\u7231\u6db2\uff1a" + Units.fluid(100.0) + " \u6bcf\u5c0f\u65f6</i>", "\u4f60\u5df2\u7ecf\u5728\u8be5\u623f\u95f4\u5b89\u88c5\u4e86\u5de5\u4e1a\u6324\u5976\u673a\u5668\u3002\u4e0d\u5e78\u88ab\u9501\u5728\u8fd9\u4e9b\u673a\u5668\u91cc\u7684\u5974\u96b6\u4eec\u80af\u5b9a\u4f1a\u618e\u6068\u4f60\u3002<br/><i>\u4ea7\u4e73\uff1a" + Units.fluid(5000.0) + "\u6bcf\u5c0f\u65f6<br/>\u7cbe\u6db2\uff1a" + Units.fluid(500.0) + " \u6bcf\u5c0f\u65f6<br/>\u7231\u6db2\uff1a" + Units.fluid(100.0) + " \u6bcf\u5c0f\u65f6</i>", "\u5965\u672f\u9a71\u52a8\u7684\u5de5\u4e1a\u6324\u5976\u673a\u5668\u5df2\u7ecf\u5b89\u653e\u5728\u8be5\u623f\u95f4\uff0c\u5468\u56f4\u7684\u7a7a\u6c14\u4e2d\u5145\u6ee1\u4e86\u8fde\u7eed\u4e0d\u65ad\u7684\u8f70\u9e23\u58f0\u3002\u5c3d\u7ba1\u8fd9\u4e9b\u673a\u5668\u80fd\u591f\u6700\u5927\u5316\u4ea7\u5976\u91cf\uff0c\u4f46\u88ab\u7ed1\u5728\u8fd9\u4e9b\u88c5\u7f6e\u4e0a\u80af\u5b9a\u4e0d\u7b97\u8212\u670d\uff0c\u65e0\u8bba\u54ea\u4e2a\u5974\u96b6\u5728\u8fd9\u91cc\u88ab\u6324\u5976\u80af\u5b9a\u90fd\u4f1a\u5bf9\u4f60\u5fc3\u751f\u6028\u5ff5\u2026\u2026", 1500, 500, 1000, 0, -1.0f, 0.5f, null){

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_MILKING_ROOM_ARTISAN_MILKERS)) {
                    return new Util.Value<Boolean, String>(false, "\u5728\u5b89\u88c5\u201c\u5de5\u4e1a\u6324\u5976\u673a\u201d\u4e4b\u524d\uff0c\u5fc5\u987b\u5148\u79fb\u9664\u201c\u624b\u5de5\u6324\u5976\u673a\u201d\u5347\u7ea7\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }
        };
        LILAYA_MILKING_ROOM_MILK_EFFICIENCY = new AbstractPlaceUpgrade(false, PresetColour.MILK, "\u69a8\u4e73\u4e50", "\u751f\u4ea7\u6324\u5976\u673a\u7684\u516c\u53f8\u8fd8\u63d0\u4f9b\u4e00\u7cfb\u5217\u552e\u540e\u5e02\u573a\u5347\u7ea7\u4ea7\u54c1\u3002\u5176\u4e2d\u4e4b\u4e00\u662f\u201c\u69a8\u4e73\u4e50\u201d\uff0c\u5b83\u53ef\u5c06\u6324\u5976\u673a\u7684\u6700\u9ad8\u6bcf\u5c0f\u65f6\u6324\u5976\u6548\u7387\u63d0\u9ad8\u4e00\u500d\u3002", "\u4f60\u4e3a\u8fd9\u4e2a\u6324\u5976\u5ba4\u7684\u6324\u5976\u673a\u52a0\u88c5\u4e86\u53ef\u9009\u7684\u201c\u69a8\u4e73\u4e50\u201d\uff0c\u4f7f\u5b83\u4eec\u6bcf\u5c0f\u65f6\u7684\u6700\u9ad8\u6324\u5976\u6548\u7387\u63d0\u9ad8\u4e86\u4e00\u500d\u3002", "\u6bcf\u53f0\u673a\u5668\u4e0a\u7684\u6807\u51c6\u5438\u76d8\u5df2\u88ab\u9009\u914d\u7684\u201c\u69a8\u4e73\u4e50\u201d\u53d6\u4ee3\uff0c\u8fd9\u79cd\u5438\u76d8\u53ef\u5c06\u6bcf\u5c0f\u65f6\u7684\u6700\u5927\u6324\u5976\u91cf\u63d0\u9ad8\u4e00\u500d\u3002", 500, 100, 200, 0, 0.0f, 0.0f, null){};
        LILAYA_MILKING_ROOM_CUM_EFFICIENCY = new AbstractPlaceUpgrade(false, PresetColour.CUM, "\u9b45\u9b54\u7ba1", "\u751f\u4ea7\u6324\u5976\u673a\u7684\u516c\u53f8\u8fd8\u63d0\u4f9b\u4e00\u7cfb\u5217\u552e\u540e\u5e02\u573a\u5347\u7ea7\u4ea7\u54c1\u3002\u5176\u4e2d\u4e4b\u4e00\u662f\u201c\u9b45\u9b54\u7ba1\u201d\uff0c\u5b83\u80fd\u5c06\u6324\u5976\u673a\u7684\u6700\u9ad8\u6bcf\u5c0f\u65f6\u69a8\u7cbe\u6548\u7387\u63d0\u9ad8\u4e00\u500d\u3002", "\u4f60\u4e3a\u8fd9\u4e2a\u623f\u95f4\u7684\u6324\u5976\u673a\u52a0\u88c5\u4e86\u53ef\u9009\u7684\u201c\u9b45\u9b54\u7ba1\u201d\uff0c\u4f7f\u5b83\u4eec\u6bcf\u5c0f\u65f6\u7684\u6700\u9ad8\u69a8\u7cbe\u6548\u7387\u63d0\u9ad8\u4e86\u4e00\u500d\u3002", "\u6bcf\u53f0\u6324\u5976\u673a\u4e0a\u7684\u6807\u51c6\u6324\u5976\u7ba1\u5df2\u88ab\u9009\u914d\u7684\u201c\u9b45\u9b54\u7ba1\u201d\u6240\u53d6\u4ee3\uff0c\u8fd9\u4f7f\u5f97\u6bcf\u5c0f\u65f6\u7684\u6700\u5927\u69a8\u7cbe\u91cf\u7ffb\u4e86\u4e00\u756a\u3002", 500, 100, 200, 0, 0.0f, 0.0f, null){};
        LILAYA_MILKING_ROOM_GIRLCUM_EFFICIENCY = new AbstractPlaceUpgrade(false, PresetColour.GIRLCUM, "\u4ed9\u5973\u6cf5", "\u751f\u4ea7\u6324\u5976\u673a\u7684\u516c\u53f8\u8fd8\u63d0\u4f9b\u4e00\u7cfb\u5217\u552e\u540e\u5e02\u573a\u5347\u7ea7\u4ea7\u54c1\u3002\u5176\u4e2d\u4e4b\u4e00\u662f\u201c\u4ed9\u5973\u6cf5\u201d\uff0c\u5b83\u80fd\u5c06\u6324\u5976\u673a\u6bcf\u5c0f\u65f6\u7684\u6700\u5927\u6324\u7231\u6db2\u6548\u7387\u63d0\u9ad8\u4e00\u500d\u3002", "\u4f60\u4e3a\u8fd9\u4e2a\u623f\u95f4\u7684\u6324\u5976\u673a\u52a0\u88c5\u4e86\u53ef\u9009\u7684\u201c\u4ed9\u5973\u6cf5\u201d\uff0c\u4f7f\u5b83\u4eec\u6bcf\u5c0f\u65f6\u7684\u6700\u5927\u6324\u7231\u6db2\u6548\u7387\u63d0\u9ad8\u4e86\u4e00\u500d\u3002", "\u6bcf\u53f0\u673a\u5668\u4e0a\u7684\u6807\u51c6\u9634\u9053\u6cf5\u5df2\u88ab\u9009\u914d\u7684\u201c\u4ed9\u5973\u6cf5\u201d\u53d6\u4ee3\uff0c\u8fd9\u79cd\u6cf5\u53ef\u5c06\u6bcf\u5c0f\u65f6\u63d0\u53d6\u7684\u7231\u6db2\u91cf\u589e\u52a0\u4e00\u500d\u3002", 500, 100, 200, 0, 0.0f, 0.0f, null){};
        LILAYA_OFFICE = new AbstractPlaceUpgrade(true, PresetColour.BASE_TEAL, "\u529e\u516c\u5ba4", "\u7531\u4e8e\u8389\u83b1\u96c5\u7684\u5b9e\u9a8c\u5ba4\u7ecf\u5e38\u9700\u8981\u8ba2\u8d2d\u53d7\u5230\u4e25\u683c\u7ba1\u5236\u7684\u5916\u6765\u6750\u6599\uff0c\u56e0\u6b64\u5979\u6bcf\u4e2a\u6708\u90fd\u9700\u8981\u5b8c\u6210\u5927\u91cf\u7684\u6587\u4e66\u5de5\u4f5c\u3002\u8ba9\u841d\u4e1d\u628a\u8fd9\u4e2a\u623f\u95f4\u7684\u5bb6\u5177\u6362\u6210\u529e\u516c\u684c\u3001\u6905\u5b50\u548c\u6587\u4ef6\u67dc\uff0c\u4f60\u5c31\u53ef\u4ee5\u628a\u5b83\u53d8\u6210\u4e00\u4e2a\u529e\u516c\u573a\u6240\uff0c\u4f60\u7684[style.colorGood(\u56db)]\u4e2a\u5974\u96b6\u5c31\u53ef\u4ee5\u62ff\u94b1\u4e3a\u5979\u5b8c\u6210\u8fd9\u4e9b\u5de5\u4f5c\u3002[style.italicsGood(\u4f60\u8fd8\u53ef\u4ee5\u5728\u529e\u516c\u5ba4\u67e5\u9605\u201c\u4f4f\u6237\u540d\u5355\u201d\uff01)]", "\u8fd9\u4e2a\u623f\u95f4\u5df2\u88ab\u6539\u5efa\u6210\u529e\u516c\u5ba4\uff0c\u6709\u8db3\u591f\u7684\u529e\u516c\u684c\u548c\u7a7a\u95f4\u6765\u8212\u9002\u5730\u5bb9\u7eb3[style.colorGood(\u56db)]\u540d\u5de5\u4f5c\u4eba\u5458\u3002[style.italicsGood(\u5728\u529e\u516c\u5ba4\u65f6\uff0c\u4f60\u8fd8\u53ef\u4ee5\u8bbf\u95ee\u201c\u4f4f\u6237\u540d\u5355\u201d\uff01)]", "\u4e3a\u4e86\u5e2e\u52a9\u8389\u83b1\u96c5\u5904\u7406\u5927\u91cf\u4e0e\u5916\u6765\u6750\u6599\u6536\u8d2d\u6709\u5173\u7684\u6587\u4e66\u5de5\u4f5c\uff0c\u4f60\u628a\u8fd9\u4e2a\u623f\u95f4\u6539\u5efa\u6210\u4e86\u4e00\u4e2a\u53ef\u5bb9\u7eb3\u56db\u4eba\u7684\u529e\u516c\u5ba4\u3002\u9664\u4e86\u4e0e\u8389\u83b1\u96c5\u4e25\u683c\u76d1\u7ba1\u7684\u91c7\u8d2d\u76f8\u5173\u7684\u8868\u683c\u5916\uff0c\u5206\u914d\u5230\u8fd9\u91cc\u7684\u5de5\u4f5c\u4eba\u5458\u8fd8\u8d1f\u8d23\u5728\u201c\u4f4f\u6237\u540d\u5355\u201d\u4e2d\u4fdd\u5b58\u8bb0\u5f55\uff0c\u4f60\u53ef\u4ee5\u968f\u65f6\u5728\u8fd9\u91cc\u67e5\u9605\u3002", 8000, 500, 250, 0, 0.0f, 0.0f, null){

            @Override
            public DialogueNode getRoomDialogue(Cell c) {
                return LilayaOfficeDialogue.ROOM_OFFICE;
            }

            @Override
            public String getSVGOverride() {
                return AbstractPlaceType.getSVGOverride("dominion/lilayasHome/roomOffice", PresetColour.BASE_LILAC);
            }

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_ARTHUR_ROOM)) {
                    return new Util.Value<Boolean, String>(false, "");
                }
                if (!Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCells(LILAYA_OFFICE).isEmpty() || !Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_FIRST_FLOOR).getCells(LILAYA_OFFICE).isEmpty()) {
                    return new Util.Value<Boolean, String>(false, "\u6ca1\u6709\u8db3\u591f\u7684\u8bc1\u660e\u6750\u6599\uff0c\u4e0d\u80fd\u8bc1\u660e\u6709\u7406\u7531\u8bbe\u7acb\u4e00\u4e2a\u4ee5\u4e0a\u7684\u529e\u516c\u5ba4\u3002");
                }
                if (!Main.game.getCharactersTreatingCellAsHome(cell).isEmpty()) {
                    return new Util.Value<Boolean, String>(false, "\u6539\u9020\u6216\u51fa\u552e\u5f00\u59cb\u524d\uff0c\u8fd9\u4e2a\u623f\u95f4\u9700\u8981\u88ab\u6e05\u7a7a\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }

            @Override
            public void applyInstallationEffects(Cell c) {
                GenericPlace place = c.getPlace();
                for (AbstractPlaceUpgrade upgrade : PlaceUpgrade.getAllPlaceUpgrades()) {
                    if (upgrade == LILAYA_OFFICE) continue;
                    place.removePlaceUpgrade(c, upgrade);
                }
            }
        };
        LILAYA_OFFICE_EXECUTIVE_UPGRADE = new AbstractPlaceUpgrade(false, PresetColour.BASE_GOLD, "\u884c\u653f\u529e\u516c\u5ba4", "\u8ba9\u841d\u4e1d\u4e3a\u8fd9\u95f4\u529e\u516c\u5ba4\u914d\u5907\u5979\u80fd\u5f04\u5230\u7684\u6700\u8c6a\u534e\u3001\u6700\u5962\u4f88\u7684\u5bb6\u5177\u3002\u867d\u7136\u8fd9\u95f4\u529e\u516c\u5ba4\u4e00\u5b9a\u4f1a\u8ba9\u4efb\u4f55\u88ab\u5206\u914d\u5230\u8fd9\u91cc\u7684\u5458\u5de5\u611f\u5230\u8083\u7136\u8d77\u656c\uff0c\u4f46\u5fa1\u57ce\u533a\u6700\u597d\u7684\u5bb6\u5177\u5e76\u4e0d\u4fbf\u5b9c\u2026\u2026", "\u4f60\u4e3a\u8fd9\u95f4\u529e\u516c\u5ba4\u914d\u5907\u4e86\u6700\u9ad8\u6863\u7684\u5bb6\u5177\uff0c\u8fd9\u4e00\u5b9a\u4f1a\u8ba9\u88ab\u6d3e\u5230\u8fd9\u91cc\u5de5\u4f5c\u7684\u4eba\u5bf9\u4f60\u8083\u7136\u8d77\u656c\u3002", "\u4f60\u5df2\u7ecf\u4e3a\u8fd9\u95f4\u529e\u516c\u5ba4\u914d\u5907\u4e86\u91d1\u94b1\u6240\u80fd\u4e70\u5230\u7684\u6700\u8c6a\u534e\u3001\u6700\u5962\u4f88\u7684\u5bb6\u5177\u3002\u56db\u4e2a\u5de5\u4f4d\u90fd\u6709\u81ea\u5df1\u7684\u96d5\u523b\u7cbe\u7f8e\u7684\u7ea2\u6728\u529e\u516c\u684c\uff0c\u529e\u516c\u684c\u540e\u9762\u7684\u5899\u58c1\u4e0a\u56fa\u5b9a\u7740\u4e66\u67b6\uff0c\u4e0a\u9762\u6446\u6ee1\u4e86\u624b\u5de5\u5236\u4f5c\u7684\u76ae\u9769\u88c5\u8ba2\u7684\u5531\u7247\u4e66\u7c4d\u3002", 500000, -200000, 50, 0, 0.25f, 1.0f, null){};
        LILAYA_OFFICE_COFFEE_MACHINE = new AbstractPlaceUpgrade(false, PresetColour.BASE_BROWN_DARK, "\u5496\u5561\u673a", "\u841d\u4e1d\u544a\u8bc9\u4f60\uff0c\u5979\u77e5\u9053\u6709\u4e00\u79cd\u6781\u597d\u7684\u5965\u672f\u5496\u5561\u673a\u53ef\u4ee5\u8d2d\u4e70\u3002\u8fd9\u53f0\u673a\u5668\u53ef\u4ee5\u63d0\u4f9b\u5404\u79cd\u51b7\u70ed\u5496\u5561\u996e\u54c1\uff0c\u8fd9\u6837\u7684\u673a\u5668\u4e00\u5b9a\u4f1a\u53d7\u5230\u529e\u516c\u5ba4\u5de5\u4f5c\u4eba\u5458\u7684\u9752\u7750\u3002", "\u4f60\u4e3a\u8fd9\u95f4\u529e\u516c\u5ba4\u8d2d\u4e70\u4e86\u4e00\u53f0\u5965\u672f\u5496\u5561\u673a\uff0c\u5206\u914d\u5230\u8fd9\u91cc\u5de5\u4f5c\u7684\u5974\u96b6\u4eec\u5bf9\u6b64\u975e\u5e38\u611f\u6fc0\u3002", "\u623f\u95f4\u7684\u4e00\u89d2\u6446\u653e\u7740\u4e00\u53f0\u5f27\u5f62\u5496\u5561\u673a\uff0c\u80fd\u591f\u63d0\u4f9b\u5404\u79cd\u51b7\u70ed\u5496\u5561\u996e\u54c1\u3002", 5000, 100, 250, 0, 0.1f, 0.05f, null){};
        LILAYA_OFFICE_PARTITIONING_WALLS = new AbstractPlaceUpgrade(false, PresetColour.BASE_TAN, "\u9694\u65ad\u5899", "\u4f60\u53ef\u4ee5\u5728\u8fd9\u95f4\u529e\u516c\u5ba4\u91cc\u8bbe\u7f6e\u4e00\u4e9b\u9694\u65ad\u5899\uff0c\u8fd9\u6837\u5c31\u53ef\u4ee5\u7ed9\u5206\u914d\u5230\u8fd9\u91cc\u7684\u56db\u540d\u5458\u5de5\u6bcf\u4eba\u63d0\u4f9b\u81ea\u5df1\u7684\u79c1\u4eba\u7a7a\u95f4\uff0c\u8ba9\u4ed6\u4eec\u53ef\u4ee5\u7ee7\u7eed\u5de5\u4f5c\u3002", "\u4f60\u5728\u8fd9\u95f4\u529e\u516c\u5ba4\u91cc\u8bbe\u7f6e\u4e86\u51e0\u9762\u9694\u65ad\u5899\uff0c\u4e3a\u6bcf\u4f4d\u5458\u5de5\u63d0\u4f9b\u4e86\u66f4\u591a\u7684\u79c1\u4eba\u7a7a\u95f4\uff0c\u8ba9\u4ed6\u4eec\u53ef\u4ee5\u5b89\u9759\u5730\u5904\u7406\u5206\u914d\u7ed9\u4ed6\u4eec\u7684\u5de5\u4f5c\u3002", "\u8fd9\u95f4\u529e\u516c\u5ba4\u7684\u56db\u4e2a\u5de5\u4f4d\u90fd\u7528\u9694\u5899\u5206\u9694\u5f00\u6765\uff0c\u7ed9\u5458\u5de5\u4eec\u63d0\u4f9b\u4e86\u4e00\u4e9b\u79c1\u4eba\u7a7a\u95f4\uff0c\u8ba9\u4ed6\u4eec\u53ef\u4ee5\u5b89\u9759\u5730\u5b8c\u6210\u5206\u914d\u7ed9\u4ed6\u4eec\u7684\u4efb\u52a1\u3002", 2500, 500, 0, 0, 0.05f, 0.0f, null){};
        LILAYA_DRESSING_ROOM = new AbstractPlaceUpgrade(true, PresetColour.BASE_GOLD, "\u66f4\u8863\u5ba4", "\u867d\u7136\u6bcf\u95f4\u5367\u5ba4\u90fd\u8db3\u591f\u5bb9\u7eb3\u4e00\u4e24\u4e2a\u8863\u67dc\uff0c\u4f46\u80fd\u6709\u4e00\u6574\u4e2a\u623f\u95f4\u4e13\u95e8\u5b58\u653e\u8863\u670d\u4e5f\u4e0d\u9519\u3002", "\u8fd9\u4e2a\u7279\u6b8a\u7684\u623f\u95f4\u88ab\u6539\u9020\u6210\u4e86\u66f4\u8863\u5ba4\uff0c\u62e5\u6709\u8db3\u591f\u7684\u8863\u67dc\u7a7a\u95f4\u6765\u5b58\u653e\u6570\u767e\u4ef6\u8863\u7269\u3002", "\u4f60\u5c06\u8fd9\u4e2a\u7279\u5b9a\u623f\u95f4\u6539\u9020\u6210\u4e86\u4e13\u7528\u66f4\u8863\u5ba4\u3002\u51e0\u5341\u4e2a\u8863\u67dc\u4e3a\u6570\u767e\u4ef6\u8863\u7269\u63d0\u4f9b\u4e86\u50a8\u5b58\u7a7a\u95f4\u3002", 5000, 250, 50, 0, 0.0f, 0.0f, null){

            @Override
            public String getRoomDescription(Cell c) {
                GenericPlace place = c.getPlace();
                StringBuilder sb = new StringBuilder();
                sb.append(super.getRoomDescription(c));
                if (!place.getPlaceUpgrades().contains(LILAYA_DRESSING_ROOM_LYSSIETH_WARDROBE)) {
                    sb.append("\u8389\u897f\u4e1d\u7684\u8863\u67dc\uff0c\u7531\u8c61\u7259\u96d5\u523b\u800c\u6210\uff0c\u5e76\u7528\u9ec4\u91d1\u88c5\u9970\uff0c\u5728\u8fd9\u95f4\u623f\u95f4\u91cc\u5360\u636e\u7740\u663e\u773c\u7684\u4f4d\u7f6e\u3002\u5176\u72ec\u7279\u7684\u9644\u9b54\u80fd\u8ba9\u4f60\u4ec5\u51ed\u60f3\u8c61\u5c31\u80fd\u51ed\u7a7a\u521b\u9020\u7269\u54c1\uff0c\u4f46\u76ee\u524d\u65e0\u6cd5\u4f7f\u7528\uff0c\u800c\u4e14\u8ba9\u8389\u83b1\u96c5\u6765\u4fee\u7406\u4f1a\u975e\u5e38\u6602\u8d35\u3002");
                }
                return sb.toString();
            }

            @Override
            public DialogueNode getInstallationDialogue(Cell c) {
                if (!Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.dressingRoomLyssiethsWardrobeActivated)) {
                    return LilayaDressingRoomDialogue.INSTALLATION;
                }
                return super.getInstallationDialogue(c);
            }

            @Override
            public DialogueNode getRoomDialogue(Cell c) {
                return LilayaDressingRoomDialogue.ROOM_DRESSING_ROOM;
            }

            @Override
            public String getSVGOverride() {
                return AbstractPlaceType.getSVGOverride("dominion/lilayasHome/roomDressingRoom", PresetColour.BASE_GOLD);
            }

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_ARTHUR_ROOM)) {
                    return new Util.Value<Boolean, String>(false, "");
                }
                if (!Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCells(LILAYA_DRESSING_ROOM).isEmpty() || !Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_FIRST_FLOOR).getCells(LILAYA_DRESSING_ROOM).isEmpty()) {
                    return new Util.Value<Boolean, String>(false, "\u4f60\u53ea\u80fd\u62e5\u6709\u4e00\u4e2a\u66f4\u8863\u5ba4\u3002");
                }
                if (!Main.game.getCharactersTreatingCellAsHome(cell).isEmpty()) {
                    return new Util.Value<Boolean, String>(false, "\u6539\u9020\u6216\u51fa\u552e\u5f00\u59cb\u524d\uff0c\u8fd9\u4e2a\u623f\u95f4\u9700\u8981\u88ab\u6e05\u7a7a\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }

            @Override
            public void applyInstallationEffects(Cell c) {
                GenericPlace place = c.getPlace();
                for (AbstractPlaceUpgrade upgrade : PlaceUpgrade.getAllPlaceUpgrades()) {
                    if (upgrade == LILAYA_DRESSING_ROOM) continue;
                    place.removePlaceUpgrade(c, upgrade);
                }
                if (Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.dressingRoomLyssiethsWardrobeActivated)) {
                    place.addPlaceUpgrade(c, LILAYA_DRESSING_ROOM_LYSSIETH_WARDROBE);
                }
            }
        };
        LILAYA_DRESSING_ROOM_LYSSIETH_WARDROBE = new AbstractPlaceUpgrade(false, PresetColour.GENERIC_ARCANE, "\u8389\u897f\u4e1d\u7684\u8863\u67dc", "\u8ba9\u8389\u83b1\u96c5\u91cd\u65b0\u4e3a\u8389\u897f\u4e1d\u90a3\u7279\u6b8a\u7684\u8863\u67dc\u9644\u9b54\u540e\uff0c\u5c06\u62e5\u6709\u4e0d\u53ef\u601d\u8bae\u7684\u529b\u91cf\u2014\u2014\u80fd\u521b\u9020\u51fa\u51e0\u4e4e\u4efb\u4f55\u4f60\u80fd\u60f3\u8c61\u5230\u7684\u6b66\u5668\u6216\u8863\u7269\u3002<br/>[style.italicsGood(\u8fd9\u5c06\u4e3a\u4f60\u548c\u4f60\u7684\u5974\u96b6\u89e3\u9501\u201c\u670d\u88c5\u201d\u529f\u80fd\u3002)]", "\u4e00\u5c0a\u7531\u8c61\u7259\u96d5\u7422\u3001\u9ec4\u91d1\u88c5\u9970\u7684\u975e\u51e1\u8863\u67dc\uff0c\u5728\u66f4\u8863\u5ba4\u91cc\u5360\u636e\u7740\u6700\u663e\u773c\u7684\u4f4d\u7f6e\u3002\u8fd9\u4ef6\u72ec\u7279\u7684\u5bb6\u5177\u7531\u8389\u7433\u957f\u8001\u8389\u897f\u4e1d\u59d4\u6258\u6253\u9020\uff0c\u62e5\u6709\u4e0d\u53ef\u601d\u8bae\u7684\u529b\u91cf\uff0c\u51e0\u4e4e\u80fd\u521b\u9020\u51fa\u4f60\u6240\u80fd\u60f3\u8c61\u7684\u4efb\u4f55\u6b66\u5668\u6216\u8863\u7269\u3002<br/>[style.italicsGood(\u8389\u897f\u4e1d\u7684\u8863\u67dc\u5c06\u4e3a\u4f60\u548c\u4f60\u7684\u5974\u96b6\u89e3\u9501\u201c\u670d\u88c5\u201d\u529f\u80fd\u3002)]", "\u4e00\u5c0a\u7531\u8c61\u7259\u96d5\u7422\u3001\u9ec4\u91d1\u88c5\u9970\u7684\u975e\u51e1\u8863\u67dc\uff0c\u5728\u66f4\u8863\u5ba4\u91cc\u5360\u636e\u7740\u6700\u663e\u773c\u7684\u4f4d\u7f6e\u3002\u8fd9\u4ef6\u72ec\u7279\u7684\u5bb6\u5177\u7531\u8389\u7433\u957f\u8001\u8389\u897f\u4e1d\u59d4\u6258\u6253\u9020\uff0c\u62e5\u6709\u4e0d\u53ef\u601d\u8bae\u7684\u529b\u91cf\uff0c\u51e0\u4e4e\u80fd\u521b\u9020\u51fa\u4f60\u6240\u80fd\u60f3\u8c61\u7684\u4efb\u4f55\u6b66\u5668\u6216\u8863\u7269\u3002", 250000, 0, 0, 0, 0.0f, 0.0f, null){

            @Override
            public DialogueNode getInstallationDialogue(Cell c) {
                return LilayaDressingRoomDialogue.WARDROBE_ACTIVATION;
            }

            @Override
            public Util.Value<Boolean, String> getRemovalAvailability(Cell cell) {
                return new Util.Value<Boolean, String>(false, "\u4f60\u4e0d\u80fd\u79fb\u9664\u8389\u897f\u4e1d\u7684\u8863\u67dc\u3002");
            }
        };
        LILAYA_SPA = new AbstractPlaceUpgrade(true, PresetColour.BASE_AQUA, "\u6c34\u7597\u4e2d\u5fc3", "\u901a\u8fc7\u5f7b\u5e95\u62c6\u9664\u548c\u91cd\u65b0\u88c5\u4fee\u8fd9\u4e2a\u623f\u95f4\uff0c\u53ef\u4ee5\u5c06\u5176\u6539\u9020\u6210\u4e00\u4e2a\u79c1\u4eba\u6c34\u7597\u4e2d\u5fc3\u3002\u6beb\u65e0\u7591\u95ee\uff0c\u8fd9\u5c06\u662f\u8fd9\u5ea7\u8c6a\u5b85\u7684\u4e00\u5927\u4eae\u70b9\uff0c\u4f46\u91cd\u65b0\u94fa\u8bbe\u5730\u70ed\u6cc9\u6c34\u7ba1\u9053\u4ee5\u5efa\u9020\u5ba4\u5185\u6cf3\u6c60\u7684\u8d39\u7528\u5c06\u6781\u5176\u6602\u8d35\u2026\u2026<br/>[style.italicsbad(\u53ea\u80fd\u5b89\u88c5\u4e00\u4e2a\u6c34\u7597\u4e2d\u5fc3\uff0c\u800c\u4e14\u4e0d\u80fd\u62c6\u9664\uff0c\u56e0\u6b64\u5728\u5b89\u88c5\u4e4b\u524d\uff0c\u8bf7\u786e\u4fdd\u4f60\u5e0c\u671b\u5728\u8be5\u5730\u5757\u4e0a\u5b89\u88c5\u6c34\u7597\u4e2d\u5fc3\uff01)]", "\u8fd9\u4e2a\u623f\u95f4\u88ab\u5f7b\u5e95\u7ffb\u65b0\uff0c\u6539\u5efa\u6210\u4e86\u4e00\u95f4\u8c6a\u534e\u7684\u79c1\u4eba\u6c34\u7597\u4e2d\u5fc3\u3002\u5728\u5927\u7406\u77f3\u5730\u9762\u4e2d\u592e\uff0c\u6709\u4e00\u8fde\u4e32\u5927\u6c34\u6c60\uff0c\u6bcf\u4e2a\u6c60\u5b50\u91cc\u90fd\u88c5\u6ee1\u4e86\u4ece\u5730\u70ed\u6cc9\u4e2d\u6c72\u53d6\u7684\u6e29\u6c34\u3002", "\u8fd9\u4e2a\u623f\u95f4\u88ab\u5f7b\u5e95\u7684\u7ffb\u65b0\uff0c\u6539\u5efa\u6210\u4e86\u4e00\u95f4\u8c6a\u534e\u7684\u79c1\u4eba\u6c34\u7597\u4e2d\u5fc3\uff0c\u5185\u6709\u79c1\u4eba\u6dcb\u6d74\u95f4\u548c\u66f4\u8863\u95f4\u3002\u5728\u5927\u7406\u77f3\u5730\u9762\u4e2d\u592e\uff0c\u6709\u4e00\u8fde\u4e32\u5927\u6c34\u6c60\uff0c\u6bcf\u4e2a\u6c60\u5b50\u91cc\u90fd\u88c5\u6ee1\u4e86\u4ece\u5730\u70ed\u6cc9\u4e2d\u6c72\u53d6\u7684\u6e29\u6c34\u3002\u623f\u95f4\u91cc\u7f57\u5217\u7740\u8bb8\u591a\u8212\u9002\u7684\u8eba\u6905\uff0c\u5982\u679c\u4f60\u4e0d\u60f3\u6ce1\u5728\u6cf3\u6c60\u91cc\uff0c\u8fd9\u4e9b\u8eba\u6905\u4e5f\u662f\u4f60\u653e\u677e\u548c\u4f11\u61a9\u7684\u597d\u53bb\u5904\u3002", 1500000, 250000, 500, 0, 0.0f, 0.0f, null){

            @Override
            public DialogueNode getInstallationDialogue(Cell c) {
                LilayaSpa.setCellInstallation(c);
                return LilayaSpa.SPA_INSTALLATION;
            }

            @Override
            public DialogueNode getRoomDialogue(Cell c) {
                return LilayaSpa.SPA_RECEPTION;
            }

            @Override
            public String getSVGOverride() {
                return AbstractPlaceType.getSVGOverride("dominion/lilayasHome/roomSpaReception", PresetColour.BASE_BLUE_STEEL);
            }

            @Override
            public boolean isSlaverUpgrade() {
                return false;
            }

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (!Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCells(LILAYA_SPA).isEmpty() || !Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_FIRST_FLOOR).getCells(LILAYA_SPA).isEmpty()) {
                    return new Util.Value<Boolean, String>(false, "\u4f60\u53ea\u80fd\u5efa\u9020\u4e00\u4e2a\u6c34\u7597\u4e2d\u5fc3\uff01");
                }
                int size = Main.game.getWorlds().get((Object)WorldType.LILAYAS_HOUSE_GROUND_FLOOR).WORLD_WIDTH;
                if (cell.getType() != WorldType.LILAYAS_HOUSE_GROUND_FLOOR || cell.getLocation().getY() < 2 || Math.abs(cell.getLocation().getY() - size) > 2 && Math.min(cell.getLocation().getX(), Math.abs(size - cell.getLocation().getX())) > 2) {
                    return new Util.Value<Boolean, String>(false, "\u6c34\u7597\u4e2d\u5fc3\u53ea\u80fd\u5efa\u5728\u4e00\u697c\u7684\u5317\u4fa7\u3001\u4e1c\u4fa7\u6216\u897f\u4fa7\uff01");
                }
                if (Main.game.getNpc(Lilaya.class).getBaseFetishDesire(Fetish.FETISH_PREGNANCY).isNegative() && (Main.game.getNpc(Lilaya.class).hasStatusEffect(StatusEffect.PREGNANT_0) || Main.game.getNpc(Lilaya.class).isPregnant())) {
                    return new Util.Value<Boolean, String>(false, "\u8389\u83b1\u96c5\u9700\u8981\u5148\u89e3\u51b3\u6000\u5b55\u7684\u95ee\u9898\uff01");
                }
                if (Lab.isLilayaAngryAtPlayerDemonTF() && !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.lilayaReactedToPlayerAsDemon)) {
                    return new Util.Value<Boolean, String>(false, "\u4f60\u5f97\u5148\u548c\u8389\u83b1\u96c5\u8c08\u8c08\u4f60\u7684\u6076\u9b54\u5f62\u6001\uff01");
                }
                if (!Main.game.isExtendedWorkTime()) {
                    return new Util.Value<Boolean, String>(false, "\u4f60\u53ea\u80fd\u5728\u8389\u83b1\u96c5\u9192\u7740\u7684\u65f6\u5019\u6269\u5efa\u6c34\u7597\u4e2d\u5fc3\uff01");
                }
                if (!Main.game.getCharactersTreatingCellAsHome(cell).isEmpty()) {
                    return new Util.Value<Boolean, String>(false, "\u6539\u9020\u5f00\u59cb\u524d\uff0c\u8fd9\u4e2a\u623f\u95f4\u9700\u8981\u88ab\u6e05\u7a7a\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }

            @Override
            public void applyInstallationEffects(Cell cell) {
                GenericPlace place = cell.getPlace();
                for (AbstractPlaceUpgrade upgrade : PlaceUpgrade.getAllPlaceUpgrades()) {
                    if (upgrade == LILAYA_SPA) continue;
                    place.removePlaceUpgrade(cell, upgrade);
                }
            }
        };
        LILAYA_SPA_SAUNA = new AbstractPlaceUpgrade(false, PresetColour.BASE_ROSE, "\u6851\u62ff\u623f(\u62d3\u5c55)", "\u6c34\u7597\u4e2d\u5fc3\u8fd8\u6709\u76f8\u5f53\u5927\u7684\u6269\u5efa\u7a7a\u95f4\u2026\u2026<br/>\u5982\u679c\u4f60\u613f\u610f\uff0c\u4f60\u53ef\u4ee5\u5411\u8389\u83b1\u96c5\u5efa\u8bae\uff0c\u6851\u62ff\u623f\u5c06\u662f\u6c34\u7597\u4e2d\u5fc3\u7684\u4e00\u4e2a\u91cd\u8981\u8865\u5145\u3002", "", "", 150000, 25000, 100, 0, 0.25f, 0.0f, null){

            @Override
            public DialogueNode getInstallationDialogue(Cell c) {
                return LilayaSpa.SPA_SAUNA_INSTALLATION;
            }

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCell(PlaceType.LILAYA_HOME_SPA) == null) {
                    return new Util.Value<Boolean, String>(false, "\u4f60\u9700\u8981\u7b49\u5f85\u6c34\u7597\u4e2d\u5fc3\u6269\u5efa\u5de5\u7a0b\u5b8c\u5de5\u540e\u624d\u80fd\u6269\u5efa\u5b83\uff01");
                }
                if (Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCell(PlaceType.LILAYA_HOME_UNDER_CONSTRUCTION) != null) {
                    return new Util.Value<Boolean, String>(false, "\u4f60\u9700\u8981\u7b49\u5f85\u6e38\u6cf3\u6c60\u6269\u5efa\u5de5\u7a0b\u5b8c\u5de5\u540e\u518d\u5f00\u59cb\u8fd9\u4e2a\u5de5\u7a0b\uff01");
                }
                if (Main.game.getNpc(Lilaya.class).getBaseFetishDesire(Fetish.FETISH_PREGNANCY).isNegative() && (Main.game.getNpc(Lilaya.class).hasStatusEffect(StatusEffect.PREGNANT_0) || Main.game.getNpc(Lilaya.class).isPregnant())) {
                    return new Util.Value<Boolean, String>(false, "\u8389\u83b1\u96c5\u9700\u8981\u5148\u89e3\u51b3\u6000\u5b55\u7684\u95ee\u9898\uff01");
                }
                if (Lab.isLilayaAngryAtPlayerDemonTF() && !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.lilayaReactedToPlayerAsDemon)) {
                    return new Util.Value<Boolean, String>(false, "\u4f60\u5f97\u5148\u548c\u8389\u83b1\u96c5\u8c08\u8c08\u4f60\u7684\u6076\u9b54\u5f62\u6001\uff01");
                }
                if (!Main.game.isExtendedWorkTime()) {
                    return new Util.Value<Boolean, String>(false, "\u4f60\u53ea\u80fd\u5728\u8389\u83b1\u96c5\u9192\u7740\u7684\u65f6\u5019\u6269\u5efa\u6851\u62ff\u623f\uff01");
                }
                return super.getExtraConditionalAvailability(cell);
            }

            @Override
            public Util.Value<Boolean, String> getRemovalAvailability(Cell cell) {
                return new Util.Value<Boolean, String>(false, "\u8fd9\u9879\u5347\u7ea7\u4e0d\u80fd\u88ab\u53d6\u6d88\uff01");
            }
        };
        LILAYA_SPA_POOL = new AbstractPlaceUpgrade(false, PresetColour.BASE_BLUE_LIGHT, "\u6e38\u6cf3\u6c60(\u62d3\u5c55)", "\u6c34\u7597\u4e2d\u5fc3\u8fd8\u6709\u76f8\u5f53\u5927\u7684\u6269\u5efa\u7a7a\u95f4\u2026\u2026<br/>\u5982\u679c\u4f60\u613f\u610f\uff0c\u53ef\u4ee5\u5411\u8389\u83b1\u96c5\u5efa\u8bae\uff0c\u5ba4\u5185\u6e38\u6cf3\u6c60\u5c06\u662f\u6c34\u7597\u4e2d\u5fc3\u7684\u91cd\u8981\u8865\u5145\u3002", "", "", 300000, 50000, 100, 0, 0.25f, 0.0f, null){

            @Override
            public DialogueNode getInstallationDialogue(Cell c) {
                return LilayaSpa.SPA_POOL_INSTALLATION;
            }

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCell(PlaceType.LILAYA_HOME_SPA) == null) {
                    return new Util.Value<Boolean, String>(false, "\u4f60\u9700\u8981\u7b49\u5f85\u6c34\u7597\u4e2d\u5fc3\u6269\u5efa\u5de5\u7a0b\u5b8c\u5de5\u540e\u624d\u80fd\u6269\u5efa\u5b83\uff01");
                }
                if (Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCell(PlaceType.LILAYA_HOME_UNDER_CONSTRUCTION) != null) {
                    return new Util.Value<Boolean, String>(false, "\u4f60\u9700\u8981\u7b49\u5f85\u6851\u62ff\u623f\u6269\u5efa\u5de5\u7a0b\u5b8c\u5de5\u540e\u518d\u5f00\u59cb\u8fd9\u4e2a\u5de5\u7a0b\uff01");
                }
                if (Main.game.getNpc(Lilaya.class).getBaseFetishDesire(Fetish.FETISH_PREGNANCY).isNegative() && (Main.game.getNpc(Lilaya.class).hasStatusEffect(StatusEffect.PREGNANT_0) || Main.game.getNpc(Lilaya.class).isPregnant())) {
                    return new Util.Value<Boolean, String>(false, "\u8389\u83b1\u96c5\u9700\u8981\u5148\u89e3\u51b3\u6000\u5b55\u7684\u95ee\u9898\uff01");
                }
                if (Lab.isLilayaAngryAtPlayerDemonTF() && !Main.game.getDialogueFlags().hasFlag(DialogueFlagValue.lilayaReactedToPlayerAsDemon)) {
                    return new Util.Value<Boolean, String>(false, "\u4f60\u5f97\u5148\u548c\u8389\u83b1\u96c5\u8c08\u8c08\u4f60\u7684\u6076\u9b54\u5f62\u6001\uff01");
                }
                if (!Main.game.isExtendedWorkTime()) {
                    return new Util.Value<Boolean, String>(false, "\u4f60\u53ea\u80fd\u5728\u8389\u83b1\u96c5\u9192\u7740\u7684\u65f6\u5019\u6269\u5efa\u6851\u62ff\u623f\uff01");
                }
                return super.getExtraConditionalAvailability(cell);
            }

            @Override
            public Util.Value<Boolean, String> getRemovalAvailability(Cell cell) {
                return new Util.Value<Boolean, String>(false, "\u8fd9\u9879\u5347\u7ea7\u4e0d\u80fd\u88ab\u53d6\u6d88\uff01");
            }
        };
        LILAYA_SPA_BAR = new AbstractPlaceUpgrade(false, PresetColour.BASE_ORANGE, "\u9152\u5427", "\u5728\u6c34\u7597\u4e2d\u5fc3\u7684\u6cf3\u6c60\u533a\u5efa\u9020\u4e00\u4e2a\u9152\u5427\uff0c\u786e\u4fdd\u5907\u9f50\u5404\u7c7b\u70c8\u9152\u548c\u8f6f\u996e\u3002\u51b7\u85cf\u548c\u8865\u8d27\u6210\u672c\u610f\u5473\u7740\u7ef4\u6301\u8fd0\u8f6c\u53ef\u4e0d\u4fbf\u5b9c\uff0c\u4e0d\u8fc7\u2026\u2026", "\u4f60\u5df2\u7ecf\u5728\u6c34\u7597\u4e2d\u5fc3\u7684\u6cf3\u6c60\u533a\u5efa\u9020\u4e00\u4e2a\u4e86\u9152\u5427\uff0c\u786e\u4fdd\u5907\u9f50\u5404\u7c7b\u70c8\u9152\u548c\u8f6f\u996e\u3002\u4e0d\u8fc7\u51b7\u85cf\u548c\u8865\u8d27\u7684\u6210\u672c\u610f\u5473\u7740\u7ef4\u6301\u5b83\u5e76\u4e0d\u4fbf\u5b9c\u2026\u2026", "", 15000, 5000, 500, 0, 0.1f, -0.2f, null){

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (Main.game.getWorlds().get(WorldType.LILAYAS_HOUSE_GROUND_FLOOR).getCell(PlaceType.LILAYA_HOME_SPA) == null) {
                    return new Util.Value<Boolean, String>(false, "\u4f60\u9700\u8981\u7b49\u5f85\u6c34\u7597\u4e2d\u5fc3\u6269\u5efa\u5de5\u7a0b\u5b8c\u5de5\u540e\u624d\u80fd\u5347\u7ea7\u5b83\uff01");
                }
                return super.getExtraConditionalAvailability(cell);
            }
        };
        LILAYA_DINING_HALL = new AbstractPlaceUpgrade(true, PresetColour.BASE_ORANGE_LIGHT, "\u9910\u5385", "\u8389\u83b1\u96c5\u548c\u841d\u4e1d\u5728\u5b9e\u9a8c\u5ba4\u91cc\u7528\u9910\uff0c\u56e0\u6b64\u5927\u5b85\u91cc\u6ca1\u6709\u4e13\u95e8\u7684\u9910\u5385\u3002\u4e00\u5f20\u5408\u9002\u7684\u5927\u684c\u5b50\u548c\u5341\u4e8c\u628a\u6905\u5b50\u5c31\u80fd\u89e3\u51b3\u8fd9\u4e2a\u95ee\u9898\u2026\u2026", "\u8fd9\u4e2a\u623f\u95f4\u88ab\u6539\u5efa\u6210\u4e86\u9910\u5385\uff0c\u914d\u6709\u4e00\u5f20\u957f\u6728\u684c\u548c\u5341\u4e8c\u628a\u6905\u5b50\u3002", "\u8fd9\u4e2a\u623f\u95f4\u88ab\u6539\u5efa\u6210\u4e86\u9910\u5385\uff0c\u914d\u6709\u4e00\u5f20\u957f\u6728\u684c\u548c\u5341\u4e8c\u628a\u6905\u5b50\u3002\u867d\u7136\u8389\u83b1\u96c5\u548c\u841d\u4e1d\u5f88\u53ef\u80fd\u4f1a\u7ee7\u7eed\u4fdd\u6301\u5728\u5b9e\u9a8c\u5ba4\u7528\u9910\u7684\u4e60\u60ef\uff0c\u4f46\u6ca1\u6709\u4ec0\u4e48\u80fd\u963b\u6b62\u4f60\u4eec\u5229\u7528\u8fd9\u4e2a\u623f\u95f4\u3002", 6000, 250, 50, 0, 0.0f, 0.0f, null){

            @Override
            public DialogueNode getRoomDialogue(Cell c) {
                return LilayaDiningHallDialogue.ROOM_DINING_HALL;
            }

            @Override
            public String getSVGOverride() {
                return AbstractPlaceType.getSVGOverride("dominion/lilayasHome/roomDining", PresetColour.BASE_ORANGE_LIGHT);
            }

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_ARTHUR_ROOM)) {
                    return new Util.Value<Boolean, String>(false, "");
                }
                if (!Main.game.getCharactersTreatingCellAsHome(cell).isEmpty()) {
                    return new Util.Value<Boolean, String>(false, "\u6539\u9020\u5f00\u59cb\u524d\uff0c\u8fd9\u4e2a\u623f\u95f4\u9700\u8981\u88ab\u6e05\u7a7a\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }

            @Override
            public void applyInstallationEffects(Cell c) {
                GenericPlace place = c.getPlace();
                for (AbstractPlaceUpgrade upgrade : PlaceUpgrade.getAllPlaceUpgrades()) {
                    if (upgrade == LILAYA_DINING_HALL) continue;
                    place.removePlaceUpgrade(c, upgrade);
                }
            }
        };
        LILAYA_SLAVE_LOUNGE = new AbstractPlaceUpgrade(true, PresetColour.BASE_GREEN_LIME, "\u5974\u96b6\u4f11\u606f\u5ba4", "\u9664\u4e86\u4f7f\u7528\u5404\u81ea\u7684\u623f\u95f4\uff0c\u4f60\u7684\u5974\u96b6\u6709\u65f6\u4e5f\u4f1a\u9009\u62e9\u53bb\u5974\u96b6\u4f11\u606f\u5ba4\u653e\u677e\u3002\u628a\u8fd9\u4e2a\u623f\u95f4\u6539\u5efa\u6210\u5974\u96b6\u4f11\u606f\u5ba4\uff0c\u53ef\u4ee5\u8ba9\u4f60\u7684\u5974\u96b6\u4eec\u5728\u4f11\u606f\u65f6\u95f4\u6765\u8fd9\u91cc\u4f11\u606f\u3002", "\u8fd9\u4e2a\u623f\u95f4\u5df2\u88ab\u6539\u88c5\u6210\u4f9b\u5974\u96b6\u4eec\u4f7f\u7528\u7684\u4f11\u606f\u5ba4\u3002\u5728\u4e0d\u7761\u89c9\u6216\u5de5\u4f5c\u7684\u65f6\u5019\uff0c\u53ea\u8981\u4ed6\u4eec\u62e5\u6709\u201c" + SlavePermissionSetting.GENERAL_HOUSE_FREEDOM.getName() + "\u201d\u6743\u9650\uff0c\u4ed6\u4eec\u53ef\u80fd\u4f1a\u9009\u62e9\u6765\u8fd9\u91cc\u653e\u677e\u4e00\u4e2a\u5c0f\u65f6\u5de6\u53f3\u3002", "\u8fd9\u4e2a\u623f\u95f4\u5df2\u88ab\u6539\u88c5\u6210\u4f9b\u5974\u96b6\u4eec\u4f7f\u7528\u7684\u4f11\u606f\u5ba4\u3002\u5728\u4e0d\u7761\u89c9\u6216\u5de5\u4f5c\u7684\u65f6\u5019\uff0c\u53ea\u8981\u4ed6\u4eec\u62e5\u6709\u201c" + SlavePermissionSetting.GENERAL_HOUSE_FREEDOM.getName() + "\u201d\u6743\u9650\uff0c\u4ed6\u4eec\u53ef\u80fd\u4f1a\u9009\u62e9\u6765\u8fd9\u91cc\u653e\u677e\u4e00\u4e2a\u5c0f\u65f6\u5de6\u53f3\u3002", 5000, 250, 50, 0, 0.5f, 0.0f, null){

            @Override
            public DialogueNode getRoomDialogue(Cell c) {
                return LilayaSlaveLoungeDialogue.ROOM_SLAVE_LOUNGE;
            }

            @Override
            public String getSVGOverride() {
                return AbstractPlaceType.getSVGOverride("dominion/lilayasHome/roomSlaveLounge", PresetColour.BASE_GREEN_LIME);
            }

            @Override
            protected Util.Value<Boolean, String> getExtraConditionalAvailability(Cell cell) {
                if (cell.getPlace().getPlaceUpgrades().contains(LILAYA_ARTHUR_ROOM)) {
                    return new Util.Value<Boolean, String>(false, "");
                }
                if (!Main.game.getCharactersTreatingCellAsHome(cell).isEmpty()) {
                    return new Util.Value<Boolean, String>(false, "\u6539\u9020\u5f00\u59cb\u524d\uff0c\u8fd9\u4e2a\u623f\u95f4\u9700\u8981\u88ab\u6e05\u7a7a\u3002");
                }
                return super.getExtraConditionalAvailability(cell);
            }

            @Override
            public void applyInstallationEffects(Cell c) {
                GenericPlace place = c.getPlace();
                for (AbstractPlaceUpgrade upgrade : PlaceUpgrade.getAllPlaceUpgrades()) {
                    if (upgrade == LILAYA_SLAVE_LOUNGE) continue;
                    place.removePlaceUpgrade(c, upgrade);
                }
            }
        };
        coreRoomUpgrades = Util.newArrayListOfValues(LILAYA_DOLL_CLOSET, LILAYA_GUEST_ROOM, LILAYA_SLAVE_ROOM, LILAYA_SLAVE_ROOM_DOUBLE, LILAYA_SLAVE_ROOM_QUADRUPLE, LILAYA_SLAVE_LOUNGE, LILAYA_SPA, LILAYA_OFFICE, LILAYA_DRESSING_ROOM, LILAYA_MILKING_ROOM, LILAYA_DINING_HALL, LILAYA_ARTHUR_ROOM);
        guestRoomUpgrades = Util.newArrayListOfValues(LILAYA_EMPTY_ROOM);
        dungeonCellUpgrades = Util.newArrayListOfValues(LILAYA_DUNGEON_CELL_DECENT_FOOD, LILAYA_DUNGEON_CELL_DOG_BOWLS, LILAYA_DUNGEON_CELL_UPGRADE_BED, LILAYA_DUNGEON_CELL_DOWNGRADE_BED, LILAYA_DUNGEON_CELL_ROPES, LILAYA_DUNGEON_CELL_CHAINS, LILAYA_SLAVE_ROOM_ARCANE_INSTRUMENTS, LILAYA_SLAVE_ROOM_OBEDIENCE_TRAINER);
        slaveQuartersUpgradesSingle = Util.newArrayListOfValues(LILAYA_SLAVE_ROOM_ROOM_SERVICE, LILAYA_SLAVE_ROOM_DOG_BOWLS, LILAYA_SLAVE_ROOM_UPGRADE_BED, LILAYA_SLAVE_ROOM_DOWNGRADE_BED, LILAYA_SLAVE_ROOM_ARCANE_INSTRUMENTS, LILAYA_SLAVE_ROOM_OBEDIENCE_TRAINER, LILAYA_SLAVE_ROOM_DOUBLE, LILAYA_SLAVE_ROOM_QUADRUPLE, LILAYA_EMPTY_ROOM, LILAYA_ARTHUR_ROOM);
        slaveQuartersUpgradesDouble = Util.newArrayListOfValues(LILAYA_SLAVE_ROOM_ROOM_SERVICE, LILAYA_SLAVE_ROOM_DOG_BOWLS, LILAYA_SLAVE_ROOM_UPGRADE_BED, LILAYA_SLAVE_ROOM_DOWNGRADE_BED, LILAYA_SLAVE_ROOM_ARCANE_INSTRUMENTS, LILAYA_SLAVE_ROOM_OBEDIENCE_TRAINER, LILAYA_SLAVE_ROOM_QUADRUPLE, LILAYA_EMPTY_ROOM, LILAYA_ARTHUR_ROOM);
        slaveQuartersUpgradesQuadruple = Util.newArrayListOfValues(LILAYA_SLAVE_ROOM_ROOM_SERVICE, LILAYA_SLAVE_ROOM_DOG_BOWLS, LILAYA_SLAVE_ROOM_UPGRADE_BED, LILAYA_SLAVE_ROOM_DOWNGRADE_BED, LILAYA_SLAVE_ROOM_ARCANE_INSTRUMENTS, LILAYA_SLAVE_ROOM_OBEDIENCE_TRAINER, LILAYA_EMPTY_ROOM, LILAYA_ARTHUR_ROOM);
        milkingRoomUpgrades = Util.newArrayListOfValues(LILAYA_MILKING_ROOM_ARTISAN_MILKERS, LILAYA_MILKING_ROOM_INDUSTRIAL_MILKERS, LILAYA_MILKING_ROOM_MILK_EFFICIENCY, LILAYA_MILKING_ROOM_CUM_EFFICIENCY, LILAYA_MILKING_ROOM_GIRLCUM_EFFICIENCY, LILAYA_EMPTY_ROOM);
        officeUpgrades = Util.newArrayListOfValues(LILAYA_OFFICE_EXECUTIVE_UPGRADE, LILAYA_OFFICE_COFFEE_MACHINE, LILAYA_OFFICE_PARTITIONING_WALLS, LILAYA_EMPTY_ROOM);
        spaUpgrades = Util.newArrayListOfValues(LILAYA_SPA_BAR);
        diningHallUpgrades = Util.newArrayListOfValues(LILAYA_EMPTY_ROOM);
        slaveLoungeUpgrades = Util.newArrayListOfValues(LILAYA_EMPTY_ROOM);
        dressingRoomUpgrades = Util.newArrayListOfValues(LILAYA_DRESSING_ROOM_LYSSIETH_WARDROBE, LILAYA_EMPTY_ROOM);
        allPlaceUpgrades = new ArrayList<AbstractPlaceUpgrade>();
        placeUpgradeToIdMap = new HashMap<AbstractPlaceUpgrade, String>();
        idToPlaceUpgradeMap = new HashMap<String, AbstractPlaceUpgrade>();
        for (Field f : fields = PlaceUpgrade.class.getFields()) {
            if (!AbstractPlaceUpgrade.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractPlaceUpgrade placeType = (AbstractPlaceUpgrade)f.get(null);
                placeUpgradeToIdMap.put(placeType, f.getName());
                idToPlaceUpgradeMap.put(f.getName(), placeType);
                allPlaceUpgrades.add(placeType);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }
}

