/*
 * Decompiled with CFR 0.152.
 */
package com.lilithsthrone.world.population;

import com.lilithsthrone.main.Main;
import com.lilithsthrone.utils.Util;
import com.lilithsthrone.world.population.AbstractPopulationType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PopulationType {
    public static AbstractPopulationType PERSON;
    public static AbstractPopulationType FAN;
    public static AbstractPopulationType HARPY;
    public static AbstractPopulationType CROWD;
    public static AbstractPopulationType PRIVATE_SECURITY_GUARD;
    public static AbstractPopulationType ENFORCER;
    public static AbstractPopulationType SWORD;
    public static AbstractPopulationType CENTAUR_CARTS;
    public static AbstractPopulationType SHOPPER;
    public static AbstractPopulationType DINER;
    public static AbstractPopulationType VIP;
    public static AbstractPopulationType GUARD;
    public static AbstractPopulationType SECURITY_GUARD;
    public static AbstractPopulationType MAID;
    public static AbstractPopulationType CHEF;
    public static AbstractPopulationType SLAVE;
    public static AbstractPopulationType OFFICE_WORKER;
    public static AbstractPopulationType TEXTILE_WORKER;
    public static AbstractPopulationType CONSTRUCTION_WORKER;
    public static AbstractPopulationType RECEPTIONIST;
    public static AbstractPopulationType GANG_MEMBER;
    public static AbstractPopulationType STALL_HOLDER;
    public static AbstractPopulationType MILKER;
    public static AbstractPopulationType CASHIER;
    public static AbstractPopulationType CLERK;
    public static AbstractPopulationType MASSEUSE;
    public static AbstractPopulationType AMAZON;
    public static AbstractPopulationType AMAZON_GUARD;
    public static AbstractPopulationType LUNETTE_DAUGTHER;
    public static AbstractPopulationType COCK_SLEEVE;
    public static AbstractPopulationType DOLL;
    public static AbstractPopulationType OVERSEER;
    private static List<AbstractPopulationType> allPopulationTypes;
    private static Map<AbstractPopulationType, String> populationToIdMap;
    private static Map<String, AbstractPopulationType> idToPlaceMap;

    public static List<AbstractPopulationType> getAllPopulationTypes() {
        return allPopulationTypes;
    }

    public static boolean hasId(String id) {
        return idToPlaceMap.keySet().contains(id);
    }

    public static AbstractPopulationType getPopulationTypeFromId(String id) {
        id = Util.getClosestStringMatch(id, idToPlaceMap.keySet());
        return idToPlaceMap.get(id);
    }

    public static String getIdFromPopulationType(AbstractPopulationType populationType) {
        return populationToIdMap.get(populationType);
    }

    static {
        Field[] fields;
        PERSON = new AbstractPopulationType("\u4eba", "\u4eba"){};
        FAN = new AbstractPopulationType("\u7c89\u4e1d", "\u7c89\u4e1d"){};
        HARPY = new AbstractPopulationType("\u54c8\u6bd4", "\u54c8\u6bd4"){

            @Override
            public String getName() {
                if (Main.game.isSillyModeEnabled()) {
                    return "\u557e";
                }
                return "\u54c8\u6bd4";
            }

            @Override
            public String getNamePlural() {
                if (Main.game.isSillyModeEnabled()) {
                    return "\u557e";
                }
                return "\u54c8\u6bd4";
            }
        };
        CROWD = new AbstractPopulationType("\u4eba\u7fa4", "\u4eba\u7fa4"){};
        PRIVATE_SECURITY_GUARD = new AbstractPopulationType("\u79c1\u4eba\u62a4\u536b", "\u79c1\u4eba\u62a4\u536b"){};
        ENFORCER = new AbstractPopulationType("\u6267\u6cd5\u8005", "\u6267\u6cd5\u8005"){};
        SWORD = new AbstractPopulationType("SWORD\u6267\u6cd5\u8005", "SWORD\u6267\u6cd5\u8005"){};
        CENTAUR_CARTS = new AbstractPopulationType("\u534a\u4eba\u9a6c\u62c9\u8f66", "\u534a\u4eba\u9a6c\u62c9\u8f66"){};
        SHOPPER = new AbstractPopulationType("\u987e\u5ba2", "\u987e\u5ba2"){};
        DINER = new AbstractPopulationType("\u7528\u9910\u8005", "\u7528\u9910\u8005"){};
        VIP = new AbstractPopulationType("VIP", "VIP"){};
        GUARD = new AbstractPopulationType("\u4fdd\u5b89", "\u4fdd\u5b89"){};
        SECURITY_GUARD = new AbstractPopulationType("\u62a4\u536b", "\u62a4\u536b"){};
        MAID = new AbstractPopulationType("\u5973\u4ec6", "\u5973\u4ec6"){};
        CHEF = new AbstractPopulationType("\u53a8\u5e08", "\u53a8\u5e08"){};
        SLAVE = new AbstractPopulationType("\u5974\u96b6", "\u5974\u96b6"){};
        OFFICE_WORKER = new AbstractPopulationType("\u529e\u516c\u5ba4\u804c\u5458", "\u529e\u516c\u5ba4\u804c\u5458"){};
        TEXTILE_WORKER = new AbstractPopulationType("\u7eba\u7ec7\u5382\u5de5\u4eba", "\u7eba\u7ec7\u5382\u5de5\u4eba"){};
        CONSTRUCTION_WORKER = new AbstractPopulationType("\u5efa\u7b51\u5de5\u4eba", "\u5efa\u7b51\u5de5\u4eba"){};
        RECEPTIONIST = new AbstractPopulationType("\u63a5\u5f85\u5458", "\u63a5\u5f85\u5458"){};
        GANG_MEMBER = new AbstractPopulationType("\u5e2e\u6d3e\u6210\u5458", "\u5e2e\u6d3e\u6210\u5458"){};
        STALL_HOLDER = new AbstractPopulationType("\u644a\u4e3b", "\u644a\u4e3b"){};
        MILKER = new AbstractPopulationType("\u6324\u5976\u4eba", "\u6324\u5976\u4eba"){};
        CASHIER = new AbstractPopulationType("\u6536\u94f6\u5458", "\u6536\u94f6\u5458"){};
        CLERK = new AbstractPopulationType("\u6587\u5458", "\u6587\u5458"){};
        MASSEUSE = new AbstractPopulationType("\u6309\u6469\u5e08", "\u6309\u6469\u5e08"){};
        AMAZON = new AbstractPopulationType("\u4e9a\u9a6c\u900a\u4eba", "\u4e9a\u9a6c\u900a\u4eba"){};
        AMAZON_GUARD = new AbstractPopulationType("\u4e9a\u9a6c\u900a\u62a4\u536b", "\u4e9a\u9a6c\u900a\u62a4\u536b"){};
        LUNETTE_DAUGTHER = new AbstractPopulationType("\u9732\u5185\u7279\u7684\u5973\u513f", "\u9732\u5185\u7279\u7684\u5973\u513f"){};
        COCK_SLEEVE = new AbstractPopulationType("\u9634\u830e\u5957", "\u9634\u830e\u5957"){};
        DOLL = new AbstractPopulationType("\u73a9\u5076", "\u73a9\u5076"){};
        OVERSEER = new AbstractPopulationType("\u76d1\u7763\u5458", "\u76d1\u7763\u5458"){};
        allPopulationTypes = new ArrayList<AbstractPopulationType>();
        populationToIdMap = new HashMap<AbstractPopulationType, String>();
        idToPlaceMap = new HashMap<String, AbstractPopulationType>();
        for (Field f : fields = PopulationType.class.getFields()) {
            if (!AbstractPopulationType.class.isAssignableFrom(f.getType())) continue;
            try {
                AbstractPopulationType populationType = (AbstractPopulationType)f.get(null);
                populationToIdMap.put(populationType, f.getName());
                idToPlaceMap.put(f.getName(), populationType);
                allPopulationTypes.add(populationType);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }
}

