"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cancellable = void 0;
const native_1 = require("./native");
const signals_1 = require("./signals");
const util_1 = require("util");
class Cancellable {
    constructor() {
        this.impl = new native_1.binding.Cancellable();
        const { signals } = this.impl;
        this.cancelled = new signals_1.Signal(signals, "cancelled");
    }
    get isCancelled() {
        return this.impl.isCancelled;
    }
    throwIfCancelled() {
        this.impl.throwIfCancelled();
    }
    cancel() {
        return this.impl.cancel();
    }
    [util_1.inspect.custom]() {
        return "Cancellable {}";
    }
}
exports.Cancellable = Cancellable;
