"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeviceManager = void 0;
const device_1 = require("./device");
const native_1 = require("./native");
const signals_1 = require("./signals");
const util_1 = require("util");
class DeviceManager {
    constructor() {
        this.impl = new native_1.binding.DeviceManager();
        const signals = new DeviceManagerSignals(this.impl.signals);
        this.added = new signals_1.Signal(signals, "added");
        this.removed = new signals_1.Signal(signals, "removed");
        this.changed = new signals_1.Signal(signals, "changed");
    }
    async enumerateDevices(cancellable) {
        const devices = await this.impl.enumerateDevices(cancellable);
        return devices.map(impl => new device_1.Device(impl));
    }
    async addRemoteDevice(address, options = {}, cancellable) {
        const { certificate = null, origin = null, token = null, keepaliveInterval = null, } = options;
        return new device_1.Device(await this.impl.addRemoteDevice(address, certificate, origin, token, keepaliveInterval, cancellable));
    }
    removeRemoteDevice(address, cancellable) {
        return this.impl.removeRemoteDevice(address, cancellable);
    }
    [util_1.inspect.custom]() {
        return "DeviceManager {}";
    }
}
exports.DeviceManager = DeviceManager;
class DeviceManagerSignals extends signals_1.SignalAdapter {
    constructor(signals) {
        super(signals);
    }
    getProxy(name, userHandler) {
        if (name === "added" || name === "removed") {
            return impl => userHandler(new device_1.Device(impl));
        }
        return null;
    }
}
