/// <reference types="node" />
import { AuthenticatedSessionInfo } from "./authentication";
import { inspect } from "util";
export declare class EndpointParameters {
    private impl;
    constructor({ address, port, certificate, origin, authentication, assetRoot, }?: EndpointParametersSubset);
    [inspect.custom](): string;
}
export interface EndpointParametersSubset {
    address?: string;
    port?: number;
    certificate?: string;
    origin?: string;
    authentication?: AuthenticationScheme;
    assetRoot?: string;
}
export declare type AuthenticationScheme = TokenAuthenticationScheme | CallbackAuthenticationScheme;
export interface TokenAuthenticationScheme {
    scheme: "token";
    token: string;
}
export interface CallbackAuthenticationScheme {
    scheme: "callback";
    callback: AuthenticationCallback;
}
export declare type AuthenticationCallback = (token: string) => Promise<AuthenticatedSessionInfo>;
