"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndpointParameters = void 0;
const native_1 = require("./native");
const util_1 = require("util");
class EndpointParameters {
    constructor({ address = null, port = null, certificate = null, origin = null, authentication = null, assetRoot = null, } = {}) {
        let authToken = null;
        let authCallback = null;
        if (authentication !== null) {
            if (authentication.scheme === "token") {
                authToken = authentication.token;
            }
            else {
                authCallback = authentication.callback;
            }
        }
        this.impl = new native_1.binding.EndpointParameters(address, port, certificate, origin, authToken, authCallback, assetRoot);
    }
    [util_1.inspect.custom]() {
        return "EndpointParameters {}";
    }
}
exports.EndpointParameters = EndpointParameters;
