/// <reference types="node" />
/// <reference types="node" />
import { Application } from "./application";
import { AuthenticatedSessionInfo } from "./authentication";
import { Cancellable } from "./cancellable";
import { Device } from "./device";
import { EndpointParameters } from "./endpoint_parameters";
import { Signal } from "./signals";
import { SocketAddress } from "./socket_address";
import { inspect } from "util";
export declare class PortalService {
    nodeConnected: Signal<PortalNodeConnectedHandler>;
    nodeJoined: Signal<PortalNodeJoinedHandler>;
    nodeLeft: Signal<PortalNodeLeftHandler>;
    nodeDisconnected: Signal<PortalNodeDisconnectedHandler>;
    controllerConnected: Signal<PortalControllerConnectedHandler>;
    controllerDisconnected: Signal<PortalControllerDisconnectedHandler>;
    authenticated: Signal<PortalAuthenticatedHandler>;
    subscribe: Signal<PortalSubscribeHandler>;
    message: Signal<PortalMessageHandler>;
    device: Device;
    private impl;
    constructor({ clusterParams, controlParams }?: PortalServiceOptions);
    start(cancellable?: Cancellable): Promise<void>;
    stop(cancellable?: Cancellable): Promise<void>;
    post(connectionId: PortalConnectionId, message: any, data?: Buffer | null): void;
    narrowcast(tag: PortalConnectionTag, message: any, data?: Buffer | null): void;
    broadcast(message: any, data?: Buffer | null): void;
    enumerateTags(connectionId: PortalConnectionId): Promise<PortalConnectionTag[]>;
    tag(connectionId: PortalConnectionId, tag: PortalConnectionTag): void;
    untag(connectionId: PortalConnectionId, tag: PortalConnectionTag): void;
    [inspect.custom](): string;
}
export interface PortalServiceOptions {
    clusterParams?: EndpointParameters;
    controlParams?: EndpointParameters;
}
export declare type PortalConnectionId = number;
export declare type PortalConnectionTag = string;
export declare type PortalNodeConnectedHandler = (connectionId: PortalConnectionId, remoteAddress: SocketAddress) => void;
export declare type PortalNodeJoinedHandler = (connectionId: PortalConnectionId, application: Application) => void;
export declare type PortalNodeLeftHandler = (connectionId: PortalConnectionId, application: Application) => void;
export declare type PortalNodeDisconnectedHandler = (connectionId: PortalConnectionId, remoteAddress: SocketAddress) => void;
export declare type PortalControllerConnectedHandler = (connectionId: PortalConnectionId, remoteAddress: SocketAddress) => void;
export declare type PortalControllerDisconnectedHandler = (connectionId: PortalConnectionId, remoteAddress: SocketAddress) => void;
export declare type PortalAuthenticatedHandler = (connectionId: PortalConnectionId, sessionInfo: AuthenticatedSessionInfo) => void;
export declare type PortalSubscribeHandler = (connectionId: PortalConnectionId) => void;
export declare type PortalMessageHandler = (connectionId: PortalConnectionId, message: any, data: Buffer | null) => void;
